/*
$Id: extprog_toolkit.h,v 2.3 2003/08/24 05:45:41 ericprev Exp $
*/

#ifndef __EXTPROG_TOOLKIT_H__
#define __EXTPROG_TOOLKIT_H__

void  str_to_llunsigned(char  *str, long long unsigned *lu);
char  *llunsigned_to_str(long long unsigned a);

/**************************/
/* setup your info on hub */
/****************************************************************************/
/* input: sck: socket to send the DC string                                 */
/*        nick: your nickname (you cannot change this after the connection, */
/*              it is a protocol limitation                                 */
/*        description: your description on the hub (can be NULL)            */
/*        cnx: your connection type (should be in the following list:       */
/*             "56Kbps", "33.6Kbps", "28.8Kbps", "Satellite", "ISDN", "DSL",*/
/*             "Cable", "LAN(T1)", "LAN(T3)")                               */
/*        cnx_opt: this value is a bit field                                */
/*                 bit 0 always set.                                        */
/*                 bit 1   ==0, user here, ==1, user away                   */
/*                 bit 2   ==0, normal, ==1, is server                      */
/*                         according to DC, a server is a client online     */
/*                         for more than 2 hours.                           */
/*                 bit 3   ==0, normal, ==1, fast upload                    */
/*                         according to DC, a fast upload is a client       */
/*                         having an upload speed greater than 100KB/s.     */
/*        mail: your e-mail on the hub (can be NULL)                        */
/*        amount: size of the share size in bytes.                          */
/****************************************************************************/
void set_user_info(int sck,const char *nick, char *description, char *cnx,char cnx_opt,char *mail,unsigned long long amount);

/***************************************************************************/
/* send a specified textfile called by a command as a private chat message */
/***************************************************************************/
/* The file has to be in DOS format                             */
/* otherwise you'll get problems with new lines ;)              */
/* You'll have to set a basic path where your files are located */
/****************************************************************/
void send_commandfile(int sck, const char *filename, const char *source_nick, const char *dest_nick);

/*****************************************/
/* send a message on the hub public chat */
/*******************************************************************************************/
/* input: sck: socket to send the DC string                                                */
/*        nick: your nickname                                                              */
/*        message: the message to send. Remember you cannot use the characters '$' and '|' */
/*                 Also remember that newline is in DOS format ("\r\n") and not Unix ("\n")*/
/*******************************************************************************************/
void send_public_chat_message(int sck, char *nick, char *message);

/************************************/
/* send a message on a private chat */ 
/*******************************************************************************************/
/* input: sck: socket to send the DC string                                                */
/*        nick: your nickname                                                              */
/*        destnick: destination nickname                                                   */
/*        message: the message to send. Remember you cannot use the characters '$' and '|' */
/*                 Also remember that newline is in DOS format ("\r\n") and not Unix ("\n")*/
/*                 for a normal private chat, the message should start with "<yournick> "  */
/*        auto_prefix: if set, the function will automatically prefix the "<yournick> "    */
/*                     to your message. If not set, your message is used as is.            */
/*******************************************************************************************/
void send_private_chat_message(int sck, char *nick, char *destnick, char *message, int autoprefix);
void send_private_gchat_message(int sck, char *dest_nick, char *source_nick, char *message);
/**************************************/
/* kick the given user out of the hub */
/****************************************************/
/* input: sck: socket to send the DC string         */
/*        nick: your nickname                       */
/*        kicknick: nickname of the user to kick    */
/*        reason: a short message giving the reason */
/*                NOTE: the message cannot contains */
/*                " characters                      */
/****************************************************/
void kick_user(int sck, const char *nick, const char *kicknick, const char *reason);

/**************************************/
/* ban the given user out of the hub  */
/****************************************************/
/* input: sck: socket to send the DC string         */
/*        nick: your nickname                       */
/*        kicknick: nickname of the user to ban     */
/*        reason: a short message giving the reason */
/*                NOTE: the message cannot contains */
/*                " characters                      */
/****************************************************/
void ban_user(int sck, const char *nick, const char *kicknick, const char *duration, const char *reason);

/******************************************************************************/
/* perform a search on the hub. The function builds and sends a string having */
/* the following format:                                                      */
/* "$Search Hub:nick a?b?c?d?eeeee| where                                     */
/* a is F if size doesn't matter, else T                                      */
/* b is F if size is "at least", else T (at most)                             */
/* c is the size in byte                                                      */
/* d is data type: 1=any,2=audio,3=compressed,4=document,5=exe,6=picture,     */
/*                 7=videos,8=folder                                          */
/* and eeee is the pattern to find                                            */
/* Hub:nick is replaced by hostip:hostport if the search is performed in      */
/* active mode (this requires the client to create a socket to receive result)*/
/*******************************************************************************************/
/* input: sck: socket to send the DC string                                                */
/*        mode: 0=ACTIVE, !=0=PASSIVE                                                      */
/*        dest: if mode is active, it is a string "hostip:hostport" (==address to reply)   */
/*              if mode is passive, it is your nickname                                    */
/*        size_matter: 0= size has no meaning. !=0, size must be taken into account        */
/*        size_at_most: (only if size_matter is set). 0= size is at least the given one    */
/*                      !=0, size is at most the given one                                 */
/*        wanted_size: (only if size_matter is set). size (in byte) used with size_at_most */
/*        wanted_type: see 'd' value in the beginning of the description.                  */
/*        pattern: pattern to search.                                                      */
/*******************************************************************************************/
void do_search(int sck, int mode, char *dest, int size_matter, int size_at_most, unsigned long long wanted_size, unsigned int wanted_type, char *pattern);
void do_uni_search(int sck, int mode, const char *dest, int size_matter, int size_at_most, unsigned long long wanted_size, unsigned int wanted_type, const char *pattern, const char* dest_sr);

/******************************************/
/* redirect the given user to another hub */
/******************************************************/
/* input: sck: socket to send the DC string           */
/*        nick: your nickname                         */
/*        redirnick: nickname of the user to redirect */
/*        address: hub address where the user must be */
/*                 redirected.                        */
/******************************************************/
void redir_user(int sck, char *nick, char *redirnick, char *address);

/*******************************************************************************************/
/* this structure is used by the generic decoder and contains the list of function to call */
/*******************************************************************************************/
typedef struct
{
	int (*myinfo_fnc)(void *xtra_param,const char *nick, const char *description, const char *cnx,
						   unsigned char cnx_opt, const char *mail, unsigned long long amount);	/* $MyINFO */
	int (*publicmsg_fnc)(void *xtra_param,const char *nick, const char *message);				/* public chat message */
	int (*privmsg_fnc)(void *xtra_param,const char *fromnick, const char *tonick, const char *message);	/* $To */
	int (*search_fnc)(void *xtra_param,const char *nick, int mode, int size_matter,
						   int size_at_most, unsigned long wanted_size,
							unsigned int wanted_type, const char *pattern);										/* $Search */
	int (*sr_fnc)(void *xtra_param, const char *nick, const char *filename, unsigned long long filesize,
						   unsigned int free_slot, unsigned int ttl_slot);	/* $SR */
	int (*version_fnc)(void *xtra_param,const char *version);	/* $Version */
	int (*other_fnc)(void *xtra_param, GString *input);
	int (*hello_fnc)(void *xtra_param, const char *nick);		/* $Hello */
	int (*quit_fnc)(void *xtra_param, const char *nick);		/* $Quit */
	int (*nicklist_fnc)(void *xtra_param, const char *nicklist);	/* $NickList */
	int (*oplist_fnc)(void *xtra_param, const char *oplist);        /* $Oplist */
}TBLDECODE;

/*********************************************************************************/
/* the following function provides a generic message decoder. Known messages are */
/* predecoded into an easiest format to use.                                     */
/*********************************************************************************/
/* output: -1: parameters are not valid      */
/*         -2: invalid input string          */
/*         -3: unable to decode input string */
/*         0=ok                              */
/*********************************************/
int generic_decoder(GString *input, TBLDECODE *fncs, void *xtra_parm);

#endif
