/* DChub - a Direct Connect hub clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * dummy_prog.c: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: dummy_prog.c,v 2.1 2003/03/14 13:59:28 ericprev Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#include "dc_com.h"			/* we use the same function as the hub one to communicate */
#include "extprog_toolkit.h"

int hub_com;		/* socket fd to use to communicate with hub */
char *my_name;

/*********************************************************************************************************/
/* the program receives 2 parameters: its name (has it appears on the hub) and the hub com socket number */
/* NOTE: the dc_com.c is the same as the src one but you must provide the DC_INPUT_NO_TIMEOUT else after */
/* 30 seconds idle, you will received a NULL string.                                                     */
/*********************************************************************************************************/
int main(int argc,char **argv)
{
	GString *str;

	if(argc!=4)
	{
		fprintf(stderr,"Usage: %s name fdnumber localhostIP\n",argv[0]);
		exit(1);
	}

	my_name=argv[1];
	sscanf(argv[2],"%u",&hub_com);

	while(1)
	{
		str=get_a_dc_line(hub_com);

		if(str==NULL)
			break;

		printf("%s received: '%s'\n",my_name,str->str);
		
		/* a sample of all calls */
		if(strstr(str->str,"pubchat")!=NULL)
		{
			send_public_chat_message(hub_com,my_name,"This is a public chat message");
		}
		else if(strstr(str->str,"privchat")!=NULL)
		{
			send_private_chat_message(hub_com,my_name,"MASTER","Hello master\r\nHow are you ?",1);
		}
		else if(strstr(str->str,"kick_it")!=NULL)
		{
			kick_user(hub_com,my_name,"tutu","You're kicked and never come back...");
		}
		else if(strstr(str->str,"search")!=NULL)
		{
			do_search(hub_com,1,my_name,0,0,0,1,"tmp");		/* passive search */
		}
		else if(strstr(str->str,"redir_it")!=NULL)
		{
			redir_user(hub_com,my_name,"tutu","out.of.here.dummy.org");
		}

		g_string_free(str,TRUE);

	}
	printf("%s has lost hub connection and leaves\n",my_name);
	return 0;
}

