#! /usr/bin/perl

# $Id: DcHub.pm,v 1.7 2003/09/13 14:02:59 blusseau Exp $

package DcHub;
use 5.008;             # 5.8 required for stable threadinguse strict;
use warnings;
use Carp;
use threads;           # pull in threading routines
use threads::shared;   # and variable sharing routines
use IO::Socket;
use IO::Select;
#use Socket;
use LWP::Simple;

use Fcntl;
use vars qw(@ISA @EXPORT @EXPORT_OK %EXPORT_TAGS $VERSION);

use Exporter;
$VERSION = 1.00;
@ISA = ('Exporter');       # Inherit from Exporter
# @EXPORT      = qw();       # Symbols to autoexport (:DEFAULT tag)
@EXPORT_OK   = qw();       # Symbols to export on request

my %DL_FROM_NICK : shared;

sub new {
    my $classname  = shift;         # What class are we constructing?
    my $self = {};         		# Allocate new memory
    bless($self, $classname);       # Mark it of the right type
    $self->_init(@_);               # Call _init with remaining args
    return $self;
}

my $get_peer_dcline = sub {
	my $peer_connexion=shift;
	my ($nread,$buffer,$char);
	do {
		$nread=sysread($peer_connexion,$char,1);
		# print "Nread:$nread char:$char\n";
		$buffer.=$char unless ($char eq '|');
	} while ($char ne '|' && $nread > 0);
	return $buffer;
};

my $send_peer_dcline = sub {
	my $self=shift;
	my $peer_connexion=shift;
	my $dc_line=join(' ',@_).'|';
	# print "Send Peer:[$dc_line]\n";
	syswrite($peer_connexion,$dc_line);
};

my $append_spec_char = sub {
	my $char=shift;
	if ($char == 0 || $char == 5 || $char == 36 || $char == 96) {
		# /%DCN0
		my @char=(47,37,68,67,78,48);
		if ($char == 0) {
			push @char,(48,48);
		} elsif ($char == 5) {
			push @char,(48,53);
		} elsif ($char == 36) {
			push @char,(51,54);
		} else {
			push @char,(57,54);
		}
		# %/
		push @char,(37,47);
		return @char;
	} else {
		return $char;
	}
};

my $compute_access_key=sub {
	my $remote_lock=shift;
	my @key;
	# print "RemoteLock=$remote_lock\n";
	my @lock=unpack("C*",$remote_lock);
	my $u=$lock[0];
	my $l=$lock[$#lock];
	my $o=$lock[$#lock-1];
	$u=$u^$l^$o^5;
	my $v=((($u<<8)|$u)>>4)&255;
	push @key,&$append_spec_char($v);
	for (my $i=1;$i<=$#lock;$i++) {
		$u=$lock[$i];
		$l=$lock[$i-1];
		$u=$u^$l;
		$v=((($u<<8)|$u)>>4)&255;
		push @key,&$append_spec_char($v);
	}
	return pack("C*",@key);
};

my $add_to_dl_queue = sub {
	my $self=shift;
	my $nick=shift;
	my $remotefile=shift;
	my $localfile=shift;
	if ($nick ne $self->{_MYNAME}) {
		# print "*** ADD TO DL QUEUE $remotefile => $localfile\n";
		lock(%DL_FROM_NICK);
		if (not defined $DL_FROM_NICK{$nick}) {
			my %hash : shared = ($remotefile,$localfile);
			$DL_FROM_NICK{$nick}=\%hash;
		} else {
			# Is the DL already in queue ?
			my $trouve=0;
			foreach my $rf (keys(%{$DL_FROM_NICK{$nick}})) {
				# print "Check $remotefile <=> $rf\n";
				if ($remotefile eq $rf) {
					$trouve=1;
					last;
				}
			}
			unless ($trouve) {
				# print "Adding...\n";
				my $ref=$DL_FROM_NICK{$nick};
				%{$ref}=(%{$ref},$remotefile,$localfile);
			}
		}
		return 1;
	}
	return 0;
};

sub get_dl_queue {
	my $self = shift;
	my %hash;
	lock(%DL_FROM_NICK);
	foreach my $nick (keys(%DL_FROM_NICK)) {
		my $ref_array=[];
		foreach my $rf (keys(%{$DL_FROM_NICK{$nick}})) {
			push @{$ref_array},$rf;
		}
		$hash{$nick}=$ref_array;
	}
	return %hash;
}

my $manage_download = sub {
	my $self=shift;
	my $peer_connexion=shift;
	# print "Manage Download\n";
	my $buffer=&$get_peer_dcline($peer_connexion);
	return -1 unless ($buffer=~s/^\$MyNick\s//);
	my $remote_nick=$buffer;
	my $remote_filename;
	my $local_filename;
	{
		lock(%DL_FROM_NICK);
		my @others;
		($remote_filename,$local_filename,@others)=%{$DL_FROM_NICK{$remote_nick}};
		return -1 unless ($remote_filename);
		my $ref=$DL_FROM_NICK{$remote_nick};
		%{$ref}=(@others);
	}
	&$send_peer_dcline($self,$peer_connexion,"\$MyNick $self->{_MYNAME}");
	# Create my $lock
	my $lock="ABCABCABCABCABCABCABCABCABCABCABC Pk=PerlBot-1.0ABCDE";
	&$send_peer_dcline($self,$peer_connexion,"\$Lock $lock");
	# print "TO DOWNLOAD $remote_nick:$remote_filename => $local_filename\n";
	$buffer=&$get_peer_dcline($peer_connexion);
	# print "Buffer:[$buffer]\n";
	return -1 unless ($buffer=~s/^\$Lock\s(.+)\s(Pk=.+)?$/$1/);
	my $remote_lock=$buffer;
	$buffer=&$get_peer_dcline($peer_connexion);
	return -1 unless ($buffer=~/^\$Direction\sUpload\s/);
	&$send_peer_dcline($self,$peer_connexion,"\$Direction Download 99999");
	$buffer=&$get_peer_dcline($peer_connexion);
	# print "Buffer:[$buffer]\n";
	$buffer=&$get_peer_dcline($peer_connexion) if ($buffer=~/^\$Capabilities\s.+/);
	# print "Buffer:[$buffer]\n";
	return -1 unless ($buffer=~/^\$Key\s.+/);
	my $key=&$compute_access_key($remote_lock);
	# print "KEY:[$key]\n";
	&$send_peer_dcline($self,$peer_connexion,"\$Key ".$key);
	my $filelength;
	my $do_download=1;
	if ($remote_filename eq "MyList.DcLst") {
		&$send_peer_dcline($self,$peer_connexion,"\$GetListLen");
		$buffer=&$get_peer_dcline($peer_connexion);
		# print "Buffer(GetListLen):[$buffer]\n";
		if ($buffer=~/^\$MaxedOut/) {
			&$add_to_dl_queue($self,$remote_nick,$remote_filename,$local_filename);	
			return 0;
		}
		return -1 unless ($buffer=~s/^\$ListLen\s//);
		$filelength=$buffer;
		my ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,
			$atime,$mtime,$ctime,$blksize,$blocks) = stat($local_filename);
		# print "Size:$size FileLength:$filelength $local_filename\n";
		$do_download=0 if (defined $size && $filelength == $size);
	}
	# print "DO_DOWNLOAD:$do_download\n";
	if ($do_download) {
		&$send_peer_dcline($self,$peer_connexion,"\$Get $remote_filename\$1");
		$buffer=&$get_peer_dcline($peer_connexion);
		# print "Buffer:[$buffer]\n";
		if ($buffer=~/^\$MaxedOut/) {
			&$add_to_dl_queue($self,$remote_nick,$remote_filename,$local_filename);	
			return 0;
		}
		return -1 unless ($buffer=~s/^\$FileLength\s//);
		$filelength=$buffer;
		# print "Filelength:[$filelength]\n";
		&$send_peer_dcline($self,$peer_connexion,"\$Send");
		my $remain=$filelength;
		open(HANDLE,">$local_filename") or do {
			print "Can't create $local_filename ! open: $!\n";
			return -1;
		};
		do {
			$nread=sysread($peer_connexion,$buffer,32768);
			if ($nread) {
				syswrite(HANDLE,$buffer,$nread);
				$remain -= $nread;
			}
		} while ($remain > 0 && $nread > 0);
		if ($remain != 0) {
			&$add_to_dl_queue($self,$remote_nick,$remote_filename,$local_filename);	
			return -1;
		}
	}
	my $user_fnc=$self->{_TBL_FNC}->{filedownloaded};
	$user_fnc->($remote_nick,$remote_filename,$local_filename,$filelength,$do_download) if ($user_fnc);
};

my $peer_connected=sub {
	my $self=shift;
	my $peer_connexion=shift;
	&$manage_download($self,$peer_connexion);
	$peer_connexion->shutdown(2);
};

my $wait_connections=sub {
	my $self=shift;
	my $client;
	while ($client = $self->{_TCP_SERVER}->accept()) {
		my $new_thread=threads->create($peer_connected,$self,$client);
		# print "New Thread: ".$new_thread->tid()." Created\n";
		$new_thread->detach();
	}
};

my $queue_download_thread = sub {
	my $self=shift;
	while (1 != 0) {
	 	{
	 		lock(%DL_FROM_NICK);
	 		foreach my $nick (keys(%DL_FROM_NICK)) {
	 			my ($remote_filename,$local_filename,@others)=%{$DL_FROM_NICK{$nick}};
	 			if ($remote_filename) {
	 				print "Start download from queue for $nick:$remote_filename\n";
					$self->send_dc_line("\$ConnectToMe $nick $self->{_HOSTIP}:$self->{_TCP_PORT}");
	 			}
	 		}
		}
		sleep(900);
	}
};

# "private" method to initialize fields.
# If called with arguments, _init interprets them as key+value pairs
# to initialize the object with.
sub _init {
    my $self = shift;
	croak ("Invalid Argument for new.\nWaiting: name fd hostip ! ") if ($#_ < 2 or $#_ > 4);
	$self->{_MYNAME}=shift;
	my $fd=shift;
	open(FH, "<&=$fd") || croak "open: $!";
	$self->{_FH}= *FH; # save the filehandle in variable;
	$self->{_HOSTIP}=shift;
	$self->{_READABLES_HDL}=new IO::Select;
	$self->{_READABLES_HDL}->add($self->{_FH});
	$self->{_USERLIST}={};
	$self->{_OPLIST}=[];
	$self->{_TBL_FNC}={
					   "hello" 			=> undef,
					   "oplist" 			=> undef,
					   "quit"			=> undef,
					   "myinfo" 		=> undef,
					   "global_chat" 	=> undef,
					   "priv_chat" 		=> undef,
					   "search" 		=> undef,
					   "sr"		 		=> undef,
					   "connecttome"	=> undef,
					   "filedownloaded" => undef,
					  };
	my $response=get('http://whatismyip.com');
	$self->{_HOSTIP}=$1 if ($response =~ /((\d{1,3}\.){3}\d{1,3})/);
	print "Name: $self->{_MYNAME}, FD: $fd IP: $self->{_HOSTIP}\n";
	my $port_tcp=shift;
	if ($port_tcp) {
		$self->{_TCP_PORT}=$port_tcp;
		my $tcp_server = IO::Socket::INET->new(LocalPort => $self->{_TCP_PORT},
											   Type      => SOCK_STREAM,
											   Reuse     => 1,
											   Listen    => 10 )   # or SOMAXCONN
		  or die "Couldn't be a tcp server on port $self->{_TCP_PORT}: $@\n";
		$self->{_TCP_SERVER}=$tcp_server;
	}
	my $port_udp=shift;
	if ($port_udp) {
		$self->{_UDP_PORT}=$port_udp;
  		my $udp_server = IO::Socket::INET->new(LocalPort => $self->{_UDP_PORT},
											   Proto     => "udp")
		  or die "Couldn't be a udp server on port $self->{_UDP_PORT}: $@\n";
		$self->{_UDP_SERVER}=$udp_server;
		$self->{_READABLES_HDL}->add($udp_server);
	}
}

sub start_server {
	my $self = shift;
	my $tcp_thread_waiting=threads->create($wait_connections,$self);
	$tcp_thread_waiting->detach();
	my $queue_thread=threads->create($queue_download_thread,$self);
	$queue_thread->detach();
}

sub define_callback($\&) {
	my $self=shift;
	my $fnc=shift;
	my $routine=shift;
	if (!exists($self->{_TBL_FNC}->{$fnc})) {
		print "Callback for $fnc command can't be defined !\n";
		print "This is the only commands that you can use in define_callback:\n";
		my $tbl_fnc=$self->{_TBL_FNC};
		foreach (keys(%$tbl_fnc)) {
		 	print "$_\n";
		}
		croak("Exiting....");
	} else {
		$self->{_TBL_FNC}->{$fnc}=$routine;
	}
}

sub get_a_dc_line {
	my $self = shift;
    my $new_readable;
	my $buffer=undef;
	my $char='|';
	my $nread=0;
	# select() blocks until a socket is ready to be read or written
	($new_readable) = IO::Select->select($self->{_READABLES_HDL},undef, undef, undef);
	foreach my $sock (@$new_readable) {
		if ($sock eq $self->{_FH}) {
			do {
				$nread=sysread($sock,$char,1);
				$buffer.=$char;
			} while ($char ne '|' && $nread > 0);
		}
		if (exists($self->{_UDP_SERVER}) && $sock eq $self->{_UDP_SERVER}) {
			$self->{_UDP_SERVER}->recv($buffer, 1024);
		}
	}
	return $buffer;
}

sub send_dc_line {
	my $self = shift;
	my $dc_line=join(' ',@_).'|';
	# print "Send:[$dc_line]\n";
	syswrite($self->{_FH},$dc_line);
}

sub send_public_chat_message($) {
	my $self=shift;
	my $msg=escape(shift);
	$self->send_dc_line("<$self->{_MYNAME}>",$msg);
}

sub send_private_gchat_message($$) {
	my $self=shift;
	my $dest_nick=shift;
	my $msg=escape(shift);
	$self->send_dc_line("\$ForceSendTo",$dest_nick,"<$self->{_MYNAME}>",$msg);
}

sub send_private_chat_message($$) {
	my $self=shift;
	my $dest_nick=shift;
	my $msg=escape(shift);
	$self->send_dc_line("\$To:",$dest_nick,"From:",$self->{_MYNAME},"\$<$self->{_MYNAME}>",$msg);
}	

sub escape($) {
	my $msg=shift;
	$msg=~s/\|/&#124;/g; # Convert the | char
	return $msg;
}

my $hello_decoder = sub($$$) {
	my $self=shift;
	my $user_fnc=$self->{_TBL_FNC}->{"hello"};
	return unless $user_fnc;
	my $cmd=shift;
	my $nick=shift;
	$nick=~s/\|$//;	# Remove the trailing |
	# add the user to _USERLIST
	$self->{_USERLIST}->{$nick}={};
	# launch the user function
	$user_fnc->($nick);
};

my $quit_decoder = sub($$$) {
	my $self=shift;
	my $user_fnc=$self->{_TBL_FNC}->{"quit"};
	return unless $user_fnc;
	my $cmd=shift;
	my $nick=shift;
	$nick=~s/\|$//;	# Remove the trailing |
	# Remove the user from oplist (if it's in it)
	$self->{_OPLIST}=[grep { $_ ne $nick } @{$self->{_OPLIST}}];
	# Remove the user from de _USERLIST
	delete $self->{_USERLIST}->{$nick};
	# launch the user function
	$user_fnc->($nick);
};

my $myinfo_decoder = sub($$$) {
	my $self=shift;
	my $user_fnc=$self->{_TBL_FNC}->{"myinfo"};
	return unless $user_fnc;
	my $cmd=shift;
	my $line=shift;
	$line=~s/\|$//;	# Remove the trailing |	
	#*********************************************************************
	#* string format:  $MyINFO $ALL nickname aaa$ $xxxf$bbb$yyy$         *
	#*       aaa is user description                                     *
	#*       xxx is connection type (ex: Cable)                          *
	#*       f is a 1 byte flag. Default value: \x01                     *
	#*             if not behind firewall, bit 1 must be set, else clear *
	#*       bbb is e-mail (empty string)                                *
	#*       yyy is size of shared data in bytes                         *
	#*********************************************************************
	return -1 unless $line=~/^\$ALL ([^ ]+) (.*)\$ \$(.*)(.)\$(.*)\$(\d+)\$/;
	# $1: Nick
	# $2: Description
	# $3: Connection Type
	# $4: Flag
	# $5: Email
	# $6: Share Size
	my ($nick,$desc,$cnx_type,$flag,$email,$share_size)=($1,$2,$3,$4,$5,$6);
	$self->{_USERLIST}->{$nick}->{"description"}=$desc;
	$self->{_USERLIST}->{$nick}->{"cnx_type"}=$cnx_type;
	$self->{_USERLIST}->{$nick}->{"flag"}=$flag;
	$self->{_USERLIST}->{$nick}->{"email"}=$email;
	$self->{_USERLIST}->{$nick}->{"share_size"}=$share_size;
	# launch the user function
	$user_fnc->($1,$2,$3,$4,$5,$6);
	return 0;
};

my %data_type=(
			   1	=> 'any',
			   2	=> 'audio',
			   3	=> 'compressed',
			   4	=> 'document',
			   5	=> 'exe',
			   6	=> 'picture',
			   7	=> 'videos',
			   8	=> 'folder'
			  );

my $search_decoder = sub($$$) {
	my $self=shift;
	my $user_fnc=$self->{_TBL_FNC}->{"search"};
	return unless $user_fnc;
	my $cmd=shift;
	my $line=shift;
	$line=~s/\|$//;	# Remove the trailing |	
	# string format: "$Search Hub:nick a?b?c?d?eeeee" (passive search)
	#     or format: "$Search ip:port a?b?c?d?eeeee" (active search)
	#
	#	a = F if size doesn't care, T if size is important
	#	b = F size is "at least", T if size is "at most"
	#	c = size in bytes (or 0)
	#	d = data type 1=any,2=audio,3=compressed,4=document,5=exe,6=picture,7=videos,8=folder
	#	eeeee = search pattern
	return -1 unless $line=~/^(.+:.+?) (F|T)\?(F|T)\?(\d+)\?(\d)\?(.+)/;
	# $1: Hub:Nick or ip:port
	# $2: F or T
	# $3: F or T
	# $4: size
	# $5: type
	# $6: pattern
	my ($user,$size_matter,$size_at_most,$size,$type,$pattern)=($1,$2,$3,$4,$5,$6);
	my $passive_mode=0;
	$passive_mode=1 if ($user=~s/Hub://);
	$size_matter=($size_matter eq 'F') ? 0 : 1;
	$size_at_most=($size_at_most eq 'F') ? 0 : 1;
	$type=$data_type{$type};
	$user_fnc->($user,$passive_mode,$size_matter,$size_at_most,$type,$pattern);
	return 0;
};

my $sr_decoder = sub($$$) {
	my $self=shift;
	my $user_fnc=$self->{_TBL_FNC}->{"sr"};
	return unless $user_fnc;
	my $cmd=shift;
	my $line=shift;
	$line=~s/\|$//;	# Remove the trailing |	
	# string format:  $SR nickname filename\005filesize slot/ratio\005hubname (hub addr)
	#  or if folder:  $SR nickname filename slot/ratio\005hubname (hub addr)
	return -1 unless $line=~/(.+?) (.+?)(\x05.+?)? (\d+)\/(\d+)\x05(.+)/;
	# $1: Nickname
	# $2: Filename or Dirname
	# $3: empty (for directory) or filesize
	# $4: free_slot
	# $5: max_slot
	# $6: hub
	$user_fnc->($1,$2,$3,$4,$5,$6);
	return 0;
};

my $nicklist_decoder = sub($$$) {
	my $self=shift;
	my $cmd=shift;
	my $line=shift;
	$line=~s/\|$//;	# Remove the trailing |
	foreach my $nick (split(/\$\$/,$line)) {
		if (!exists($self->{_USERLIST}->{$nick})) {
			$self->{_USERLIST}->{$nick}={};
		}
	}
	return 0;
};

my $oplist_decoder = sub($$$) {
	my $self=shift;
	my $cmd=shift;
	my $line=shift;
	$line=~s/\|$//;	# Remove the trailing |
	my @oplist=split(/\$\$/,$line);
	$self->{_OPLIST}=[@oplist];
	my $user_fnc=$self->{_TBL_FNC}->{"oplist"};
        return unless $user_fnc;
	$user_fnc->($self->{_OPLIST});
	return 0;
};

my $connecttome_decoder = sub($$$) {
	my $self=shift;
	my $cmd=shift;
	my $line=shift;
	my $user_fnc=$self->{_TBL_FNC}->{"connecttome"};
	return unless $user_fnc;
	$line=~s/\|$//;	# Remove the trailing |
	return -1 unless $line=~/(.+)\s+(.+):(\d+)$/;
	# $1 dest_nick (our nick normaly :-) )
	# $2 remote IP
	# $3 remote PORT
	$user_fnc->($1,$2,$3);
	return 0;
};
							  
my $privchat_decoder = sub($$$) {
	my $self=shift;
	my $user_fnc=$self->{_TBL_FNC}->{"priv_chat"};
	return unless $user_fnc;
	my $cmd=shift;
	my $line=shift;
	$line=~s/\|$//; # Remove the trailing |
	return -1 unless $line=~/^([^ ]+) From: ([^ ]+) \$(.*)/;
	# $1 dest_nick (our nick normaly :-) )
	# $2 source_nick
	# $3 message
	return 0 if ($1 ne $self->{_MYNAME}); # Test if the message is for us
	my $source_nick=$2;
	my $msg=$3;
	$msg=~s/^<.+?> //;
	$user_fnc->($source_nick,$msg);
	return 0;	
};

my $globalchat_decoder = sub($$) {
	my $self=shift;
	my $user_fnc=$self->{_TBL_FNC}->{"global_chat"};
	return unless $user_fnc;
	my $line=shift;
	$line=~s/\|$//; # Remove the trailing |
	return -1 unless $line=~/^<(.+?)> (.+)/;
	# $1 source_nick
	# $2 message
	$user_fnc->($1,$2);
	return 0;	
};
						
my %HoF = ( # Compose a hash of functions
		   "\$Hello"		=> $hello_decoder,
		   "\$Quit"			=> $quit_decoder,
		   "\$MyINFO"		=> $myinfo_decoder,
		   "\$To:"			=> $privchat_decoder,
		   "\$Search"		=> $search_decoder,
		   "\$SR"			=> $sr_decoder,
		   "\$OpList"		=> $oplist_decoder,
		   "\$NickList"		=> $nicklist_decoder,
		   "\$ConnectToMe" 	=> $connecttome_decoder,
		  );

sub generic_decoder($) {
	my $self=shift;
	my $line=shift;
	my $result;
	if ($line) {
		(my $cmd, my $reste)=split(/\s+/,$line,2);
		# print "CMD:[$cmd]\n";
		if ($HoF{$cmd}) {
			$result=$HoF{$cmd}->($self,$cmd,$reste);
		} elsif ($cmd=~/^</) {
			$result=$globalchat_decoder->($self,$line);
		} elsif ($cmd eq '|') {
			$result=1;
		} else {
			print "Unknown command:[$line]\n";
			$result=-1;
		}
	}
	return $result;
}

sub get_user_info($) {
	my $self=shift;
	my $nick=shift;
	return exists($self->{_USERLIST}->{$nick}) ? %{$self->{_USERLIST}->{$nick}} : ();
}

#	a = F if size doesn't care, T if size is important
#	b = F size is "at least", T if size is "at most"
#	c = size in bytes (or 0)
#	d = data type 1=any,2=audio,3=compressed,4=document,5=exe,6=picture,7=videos,8=folder
my $create_search_string= sub($;$$) {
	my $self=shift;
	my ($pattern, $size, $at_most)=(@_);
	$pattern=~s/\s/\$/g;
	$size = 0 unless ($size);
	my $search=(defined $self->{_UDP_PORT} ?
				"$self->{_HOSTIP}:$self->{_UDP_PORT}" :
				"Hub:$self->{_MYNAME}")." ";
    $search .= ($size > 0 ? "T":"F").'?';
	$search .= ((defined $at_most && $at_most) ? "T":"F")."?$size?1?$pattern";
	return $search;
};

sub search($;$$) {
	my $self=shift;
	my $search="\$Search ".&$create_search_string($self,@_);
	print "Search:[$search]\n";
	$self->send_dc_line($search);
}

sub unisearch($$;$$) {
	my $self=shift;
	my $nick=shift;
	my $search="\$UniSearch $nick ".&$create_search_string($self,@_);
	print "UniSearch:[$search]\n";
	$self->send_dc_line($search);
}

sub get_file($$$$) {
	my $self=shift;
	my $nick=shift;
	my $remotefile=shift;
	my $localfile=shift;
	my $added=&$add_to_dl_queue($self,$nick,$remotefile,$localfile);
	if ($added) {
		# print "*** Remote $nick:".$DL_FROM_NICK{$nick}->{$remotefile}."\n";
		$self->send_dc_line("\$ConnectToMe $nick $self->{_HOSTIP}:$self->{_TCP_PORT}");
		# $self->send_dc_line("\$ConnectToMe $nick 81.48.253.42:110");
	}
}

1;
__END__
# Below is stub documentation for your module. You'd better edit it!

=head1 NAME

DcHub - Perl extension for blah blah blah

=head1 SYNOPSIS

  use DcHub;
  blah blah blah

=head1 ABSTRACT

  This should be the abstract for DcHub.
  The abstract is used when making PPD (Perl Package Description) files.
  If you don't want an ABSTRACT you should also edit Makefile.PL to
  remove the ABSTRACT_FROM option.

=head1 DESCRIPTION

Stub documentation for DcHub, created by h2xs. It looks like the
author of the extension was negligent enough to leave the stub
unedited.

Blah blah blah.

=head2 EXPORT

None by default.



=head1 SEE ALSO

Mention other useful documentation such as the documentation of
related modules or operating system documentation (such as man pages
in UNIX), or any relevant external documentation such as RFCs or
standards.

If you have a mailing list set up for your module, mention it here.

If you have a web site set up for your module, mention it here.

=head1 AUTHOR

root, E<lt>root@localdomainE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2003 by root

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself. 

=cut
