/* DChub - a Direct Connect hub clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * ClientBot.c: Copyright (C) Dirk Rieger
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the temps of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the mpplied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this progrmp; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: ClientBot.c,v 2.13 2003/10/31 13:23:02 ericprev Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <glib.h>
#include <pthread.h>
#include <math.h>
/* includes for incoming_tcp */

#include <errno.h>

/* end includes for incoming_tcp */

#include "dc_com.h"				/* we use the same function as the hub one to communicate */
#include "extprog_toolkit.h"
#include "network.h"
#include "ulist.h"
#include "slist.h"
#include "mlist.h"

#ifndef MSG_NOSIGNAL
#define HAVE_NO_MSG_NOSIGNAL 1
#define MSG_NOSIGNAL 0
#endif

int hub_com;						/* socket fd to use to communicate with hub */
G_LOCK_DEFINE(hub_com);			/* to avoid conflict between the main function and threads */

GPtrArray *hub_user_list=NULL;
GPtrArray *hub_op_list=NULL;
GPtrArray *hub_user_xtra_info=NULL;
GPtrArray *hub_user_uinfo=NULL;
G_LOCK_DEFINE(hub_user_list);

/* some global vars here */
unsigned long long my_minshare=5368709120;	/* define your minshare in Bytes here default 10GB=10737418240 */
unsigned long long my_maxshare=536870912000; /* define your maxshare in Bytes here default 500GB=536870912000 */
/* dc limits */
int my_minslots=2;
int my_maxslots=20;
int my_maxhubs=4;
int my_uplimit=6;

/* definitions for incoming_tcp */

/**************************************************************************************/
/* due to the fact all the following data are used by threads, they must be protected */
/**************************************************************************************/

/* this is the lists of all running connections */
G_LOCK_DEFINE(waiting_action);				/* this mutex protects waiting_action array */
GPtrArray *waiting_action=NULL;           /* array of pointers on WAIT_ACT structure */

typedef enum
{
	CNX_ON_CONNECT,                 			/* created after a connect (in reply to a $ConnectToMe) */
	CNX_ON_ACCEPT,                         /* created after accepting an incoming connection */
} CNX_TYPE;

typedef struct
{
	int running;                           /* 0=not running, 1=waiting remote connection, 2=running, 3=killed */
	CNX_TYPE cnx_type;                     /* thread created on accept or connect ? */
	time_t last_touch;                     /* date of the last change of this task */
	pthread_t thread_id;                   /* !=0, this is the thread id */
	int sock_fd;                           /* socket descriptor used by the thread */
	GString *remote_nick;           			/* nick of the user on the remote side */
	GString *remote_addr;           			/* addr:port of the remote side */
	struct wait_revcon *run_task;   			/* task associated to this thread */
	GString *disp_info;                    /* info displayed when the xfer list is requested */
	GStringChunk *cap_str;          			/* used to store remote client capabilities */
	GPtrArray *cap_ptr;                    /* array of pointers on remote client capabilities */
} WAIT_ACT;

typedef struct
{
	int kick;
	int warnmsg_send;
	GString *warnmsg;
} USER_DAT;

int in_sck=-1;
G_LOCK_DEFINE(in_sck);
char my_incom[8192];

#define max(a,b)     (((a)>(b))?(a):(b))

char *lockstart[]={     "EXTENDEDPROTOCOL",			/* Default dc++ loststart */
                        "AAAAAAAAAAAAAAAA",			/* dc++k hiding with disabled extended protocol */
								"NEOMODUS",						/* unknown hiding Client with static lock & PK */
                        NULL};

char *pkstart[]={       "DCPLUSPLUS",              /* Default dc++ pkstart */
                        "BBBBBBBBBB",              /* dc++k hiding with disabled extended protocol */
                        "mldonkey",                /* edonkey-client searching in dc-hubs as well as faker with 93.1GB share */
								"DIRECTCONNECT10091",      /* unknown hiding Client with static lock & PK */
								"KoalaDC",						/* KoalaDC (just checked vers. 4.0) */
								"LUDCPLUSPLUS",				/* an sverige dc++ clone */
								"EXTENDEDPROTOCOLDCGUI",	/* dcgui 0.2.5 */
								"DCGUI",							/* dcgui > 0.2.5 */
								"mldc",							/* new mldonkey client */
								"QuickDC",						/* QuickDC */
								"JAVADC2BBB",					/* JavaDC2 */
                        NULL};

char *pkend[]={         "ABCABC",                  /* Default dc++ pkend */
                        NULL};

/* end definitions for incoming_tcp */

char *known_mod_dc[]={	" DC@fe++",						/* modifying descr. only - OP-Client */
								" Horror++",					/* modifying descr. only - OP-Client */
								" [DFP]",						/* modifying descr. only - OP-Client */
								" PePeK Edition",				/*  information needed  */
								"R^3",							/* modifying descr. only - CZDC version 0.181 */
								"A",								/* modifying descr. & Lock/Pk - CZDC version 0.211 */
								"B",								/* modifying descr. only CZDC version 0.233 */
																	/* attention CZDC vers. 0.241 has lock vers. 0.24 */
								"P",
								NULL};

char *my_name;
gchar *my_hostip=NULL;		/* it is the address to use to perform search or download */

time_t gl_cur_time;
/**************************************************/
/* this is a list of search to periodically start */
/**************************************************/
typedef struct
{
	time_t last_global_scan;
	gchar *search_result_return_address;	/* it is my_hostip my_port */
	GString *search_query;						/* it is the constant part of the search (file type, search type, search pattern) */
	unsigned int on_start:1;					/* (not yet supported) ==1, when this entry is added, a search is immediatly started */
	unsigned int on_incoming:1;				/* ==1, when a new user enters, a "one user" search is started */
	unsigned int global_periodic:1;			/* ==1, the scan is periodically started */
} AUTOSEARCH;

typedef struct
{
	GString *user;
	GString *message;
} USR_MSG;

static GArray *user_messages=NULL;
G_LOCK_DEFINE_STATIC(user_messages);

GArray *search_to_start=NULL;
G_LOCK_DEFINE(search_to_start);

/*********************************/
/* sending a message to all ops  */
/*********************************/
static inline void delete_incoming_message(int num)
{
	USR_MSG *dim;
#if 0
	printf("start deleting incoming message\n");
#endif
	dim=&(g_array_index(user_messages,USR_MSG,num));
	if(dim->user)
		g_string_free(dim->user,TRUE);
	if(dim->message)
		g_string_free(dim->message,TRUE);

	user_messages=g_array_remove_index_fast(user_messages,num);
#if 0
	printf("finished deleting incoming message\n");
#endif
}

void find_incoming_message_by_nickname(const char *suchnickname)
{
   int zahl;
#if 0
	printf("start find incoming message\n");
#endif
   if(user_messages!=NULL)
   {
#if 0
		printf("msg-count: %i\n",user_messages->len);
#endif
      for(zahl=0;zahl<user_messages->len;zahl++)
      {
         USR_MSG *imbn;
#if 0
			printf("getting entry %i\n",zahl);
#endif
         imbn=&(g_array_index(user_messages,USR_MSG,zahl));
#if 0
			printf("comparing %s %s\n",imbn->user->str,suchnickname);
#endif
         if(!strcmp(imbn->user->str,suchnickname))
         {
            delete_incoming_message(zahl);
            break;
         }
      }
   }
#if 0
	printf("finished find incoming message\n");
#endif
}

void add_incoming_message(const char *nickadd, const char *in_msgadd, int update_file)
{
	USR_MSG aim;
#if 0
	printf("locking user messages\n");
#endif
	G_LOCK(user_messages);
#if 0
	printf("user messages locked\n");
#endif

	if(user_messages!=NULL)
		find_incoming_message_by_nickname(nickadd);

#if 0
	printf("setting var's: '%s %s'\n",nickadd,in_msgadd);
#endif
	aim.user=g_string_new(nickadd);
	aim.message=g_string_new(in_msgadd);
#if 0
	printf("var's set\n");
#endif

	if(user_messages==NULL)
      user_messages=g_array_new(FALSE,FALSE,sizeof(USR_MSG));

#if 0
	printf("append new array\n");
#endif
	user_messages=g_array_append_val(user_messages,aim);

	if(update_file==1)
	{
		FILE *msg_file;
#if 0
		printf("updating usercomments\n");
#endif
		msg_file = fopen ("/usr/local/etc/dchub/usercomment","wt");
		if(msg_file==NULL)
		{
			printf("error opening file for writing\n");
		}
		else
		{
			int i;
#if 0
			printf("file opened\n");
#endif
			for(i=0;i<user_messages->len;i++)
			{
				USR_MSG *setmsg;
				GString *out_line;
				setmsg=&(g_array_index(user_messages,USR_MSG,i));
				out_line=g_string_new(setmsg->user->str);
				out_line=g_string_append_c(out_line,'$');
				out_line=g_string_append(out_line,setmsg->user->str);
				out_line=g_string_append(out_line,"\n");
				setmsg=&(g_array_index(user_messages,USR_MSG,i));
				fputs (out_line->str,msg_file);
				g_string_free(out_line,TRUE);
			}
			fclose(msg_file);
#if 0
			printf("file closed\n");
#endif
		}
	}
#if 0
	printf("unlocking user messages\n");
#endif
	G_UNLOCK(user_messages);
#if 0
	printf("user messages unlocked\n");
#endif
}

void get_incoming_messages()
{
   FILE * msg_file;

   msg_file = fopen ("/usr/local/etc/dchub/usercomment","rt");
   if (msg_file==NULL)
   {
      printf("no file found\n");
      msg_file = fopen ("/usr/local/etc/dchub/usercomment","wt");
      if(msg_file==NULL)
         printf("error creating file\n");
      else
      {
         fclose (msg_file);
         printf("file created & closed\n");
      }
   }
   else
   {
      int count;
      int msgcount;
      char in_line[256];
      char user[32];
      char message[224];

      while((fgets(in_line,256,msg_file))!=NULL)
      {
         count = 0;
         do
         {
            user[count]=in_line[count];
            count++;
         } while (in_line[count]!='$');
         user[count]='\0';
         count++;
         msgcount=0;
         do
         {
            message[msgcount]=in_line[count];
            msgcount++;
            count++;
         } while (in_line[count]!=10);
         message[msgcount]='\0';

         /* puts (in_line);
         puts (user);
         puts (message); */

         add_incoming_message(user,message,0);

         memset (in_line,0x00,256);
         memset (user,0x00,32);
         memset (message,0x00,224);
      }
      fclose (msg_file);
   }
}

void send_op_message(char *message, char *source_nick)
{
	int i;
#if 0
	printf("send op message trying to lock hubuserlist\n");
#endif
	G_LOCK(hub_user_list);
#if 0
	printf("send op message locked hubuserlist\n");
#endif
	for(i=0;i<hub_op_list->len;i++)
	{
		if((strcmp(source_nick,g_ptr_array_index(hub_op_list,i))!=0) && (strcmp(my_name,g_ptr_array_index(hub_op_list,i))!=0) && (strcmp("Hub-Security",g_ptr_array_index(hub_op_list,i))!=0))
		{
			G_LOCK(hub_com);
			send_private_chat_message(hub_com,my_name,g_ptr_array_index(hub_op_list,i),message,0);
			G_UNLOCK(hub_com);
		}
	}
#if 0
	printf("send op message trying to unlock hubuserlist\n");
#endif
	G_UNLOCK(hub_user_list);
#if 0
	printf("send op message unlocked hubuserlist\n");
#endif
}

static void add_pattern_to_search(unsigned short receive_port, char *pattern, unsigned int on_start, unsigned int on_incoming, unsigned int global_periodic)
{
	AUTOSEARCH nw;
	char myaddr[8192];

	sprintf(myaddr,"%s:%hu",my_hostip,receive_port);

	nw.last_global_scan=0;
	nw.search_result_return_address=g_strdup(myaddr);
	nw.search_query=g_string_new(pattern);
	nw.on_start=on_start;
	nw.on_incoming=on_incoming;
	nw.global_periodic=global_periodic;

	G_LOCK(search_to_start);
	search_to_start=g_array_append_val(search_to_start,nw);
	G_UNLOCK(search_to_start);
}

void welcome_op(const char *nick)
{
	if(strcmp(nick,"Hub-Security") && strcmp(nick,my_name))
	{
		USR_MSG *umsg=NULL;
		GString *welcome;
		GString *oplist;
		int i;
		int opcount=0;
		int has_welcome=FALSE;
		char tmp_date_buf[512];
		time_t income=time(NULL);
		struct tm *in_time;

		in_time=localtime(&income);

		welcome=g_string_new("");
		oplist=g_string_new("");
		strftime(tmp_date_buf,sizeof(tmp_date_buf)-1,"%T",in_time);
   	G_LOCK(hub_user_list);
   	for(i=0;i<hub_op_list->len;i++)
   	{
      	char *p;
      	p=g_ptr_array_index(hub_op_list,i);
      	if(strcmp(p,"Hub-Security") && strcmp(p,my_name))
      	{
				if(opcount==0)
					g_string_sprintf(oplist,"<%s> ",p);
				else
         		g_string_sprintfa(oplist,"<%s> ",p);
         	opcount++;
      	}
   	}
   	G_UNLOCK(hub_user_list);

		g_string_sprintf(welcome,"<%s> %s Uhr: %s hat den Hub betreten! Zur Zeit sind %i Ops im Hub: \r\n \r\n %s \r\n",my_name,tmp_date_buf,nick,opcount,oplist->str);
		send_op_message(welcome->str,my_name);

		/**** searching for a variable welcome message ************/
		G_LOCK(user_messages);
		if(user_messages!=NULL)
		{
			for(i=0;i<user_messages->len;i++)
			{
				umsg=&(g_array_index(user_messages,USR_MSG,i));
				if(!strcmp(umsg->user->str,nick))
				{
					has_welcome=TRUE;
#if 0
					printf("gotcha: %s,%s\n",umsg->user->str,nick);
#endif
					break;
				}
			}
		}
		if(has_welcome==TRUE)
		{
			if(strstr(umsg->message->str,"%USER")!=NULL)
			{
				char *t;
				char *premsg;
				char *appmsg;
				premsg=strdup(umsg->message->str);
				t=strstr(premsg,"%USER");
				*t++='\0';
				appmsg=strdup(t+4);
				g_string_sprintf(umsg->message,"%s%s%s",premsg,nick,appmsg);
			}
			if(strstr(umsg->message->str,"%OPS")!=NULL)
			{
				char *t;
				char *premsg;
				char *appmsg;
				premsg=strdup(umsg->message->str);
				t=strstr(premsg,"%OPS");
				*t++='\0';
				appmsg=strdup(t+3);
				g_string_sprintf(welcome,"%s%i%s",premsg,opcount,appmsg);
			}
			else
				g_string_sprintf(welcome,"%s",umsg->message->str);
		}
		else
         g_string_sprintf(welcome,"The operator %s has entered the hub... at this moment %i Ops are available!",(char*)nick,opcount);
		G_UNLOCK(user_messages);

		G_LOCK(hub_com);
		send_public_chat_message(hub_com,my_name,welcome->str);
		G_UNLOCK(hub_com);
		g_string_free(welcome,TRUE);
		g_string_free(oplist,TRUE);
	}
}

void welcome_reg(const char *nick)
{
	USR_MSG *umsg=NULL;
	GString *welcome;
	int has_welcome=FALSE;
	welcome=g_string_new("");

	/**** searching for a variable welcome message ************/
	G_LOCK(user_messages);
	if(user_messages!=NULL)
	{
		int i;
		for(i=0;i<user_messages->len;i++)
		{
			umsg=&(g_array_index(user_messages,USR_MSG,i));
			if(!strcmp(umsg->user->str,nick))
			{
				has_welcome=TRUE;
				break;
			}
		}
	}
	if(has_welcome==TRUE)
	{
		if(strstr(umsg->message->str,"%USER")!=NULL)
		{
			char *t;
			char *premsg;
			char *appmsg;
			premsg=strdup(umsg->message->str);
			t=strstr(premsg,"%USER");
			*t++='\0';
			appmsg=strdup(t+4);
			g_string_sprintf(umsg->message,"%s%s%s",premsg,nick,appmsg);
		}
		g_string_sprintf(welcome,"%s",umsg->message->str);
	}
	else
		g_string_sprintf(welcome,"%s has entered the hub...",nick);
	G_UNLOCK(user_messages);
	G_LOCK(hub_com);
	send_public_chat_message(hub_com,my_name,welcome->str);
	G_UNLOCK(hub_com);
	g_string_free(welcome,TRUE);
}

/********************************************/
/* testing if the sharesize is valid or not */
/********************************************/
USER_DAT *check_valid_sharesize(const char *nickname, unsigned long long amount)
{
	USER_DAT *ud;
	ud=malloc(sizeof(USER_DAT));
	
	if(ud!=NULL)
	{
		ud->kick=0;
		ud->warnmsg_send=FALSE;
		ud->warnmsg=NULL;
	   if(amount==10000000000 || amount==1000000000)
   	{
#if 0
			printf("got mldonkey\n");
#endif
	      ud->warnmsg=g_string_new("");
			/* first create and send the kicking reason to the user */
      	g_string_sprintf(ud->warnmsg,"Your Client is not allowed here !!!");
			G_LOCK(hub_com);
			send_private_chat_message(hub_com,my_name,(char*)nickname,ud->warnmsg->str,1);
			G_UNLOCK(hub_com);
			/* create the op-message, but don't send it here, because the userlist is locked by set_xtra_cnx_info */
			g_string_sprintf(ud->warnmsg,"<%s> %s kicked because: mldonkey (sharecheck)",my_name,nickname);
      	ud->kick=3;
   	}
   	else if(amount>my_maxshare)
   	{
#if 0
			printf("sharesize above maxshare\n");
#endif
	      ud->warnmsg=g_string_new("");
   	   g_string_sprintf(ud->warnmsg,"Your sharesize exceeds the %u GB max-share limit of this hub !!!",(unsigned int)(my_maxshare/(1024*1024*1024)));
      	G_LOCK(hub_com);
			send_private_chat_message(hub_com,my_name,(char*)nickname,ud->warnmsg->str,1);
   	   G_UNLOCK(hub_com);
			/* no opchat-message for exceeding maximum sharesize*/
	      g_string_free(ud->warnmsg,TRUE);
			ud->warnmsg=NULL;
			ud->kick=4;
	   }
		else if(amount<my_minshare)
		{
#if 0
			printf("sharesize below minshare\n");
#endif
			ud->warnmsg=g_string_new("");
			g_string_sprintf(ud->warnmsg,"Your sharesize is below the %u GB min-share limit of this hub !!!",(unsigned int)(my_minshare/(1024*1024*1024)));
			G_LOCK(hub_com);
			send_private_chat_message(hub_com,my_name,(char*)nickname,ud->warnmsg->str,1);
			G_UNLOCK(hub_com);
#if 0
			printf("private kick-message send\n");
#endif
			/* no opchat-message for sharesize below minshare */
			g_string_free(ud->warnmsg,TRUE);
			ud->kick=4;
			ud->warnmsg=NULL;
		}
   	else if(amount>my_minshare)
	   {	/* the sharesize is inside the limits so lets check some more ;) */
			char *sharesize;
   	  	double dummy;
      	double gb=(double)amount/(1024*1024*1024);
	      double mb=(double)amount/(1024*1024);
   	   double kb=(double)amount/1024;
      	long long rest=amount;
	      double kpart=modf(kb,&dummy);
   	   double spart=modf(((double)amount/100000000),&dummy);
      	double gpart=modf(gb,&dummy);
			sharesize=llunsigned_to_str(amount);
	      if(spart==0 || gpart==0)
   	   {
      	   ud->warnmsg=g_string_new("");
				g_string_sprintf(ud->warnmsg,"ShareFaker !!!");
				G_LOCK(hub_com);
				send_private_chat_message(hub_com,my_name,(char*)nickname,ud->warnmsg->str,1);
				G_UNLOCK(hub_com);
         	g_string_sprintf(ud->warnmsg,"<%s> User %s banned: %lli B = %f KB = %f MB = %f GB\r\n",my_name,nickname,rest,kb,mb,gb);
	         ud->kick=3;
   	   }
	      else if(kpart==0)
   	   {
      	   ud->warnmsg=g_string_new("");
				/* possible sharefaker - just create an op-message */
	         g_string_sprintf(ud->warnmsg,"<%s> User %s to be checked - possible ShareFaker\r\n",my_name,nickname);
   	      g_string_sprintfa(ud->warnmsg,"%lli B = %f KB = %f MB = %f GB",rest,kb,mb,gb);
				ud->kick=1;
	      }
         else if(strstr(sharesize,"11111111")!=NULL ||
                  strstr(sharesize,"22222222")!=NULL ||
                  strstr(sharesize,"33333333")!=NULL ||
                  strstr(sharesize,"44444444")!=NULL ||
                  strstr(sharesize,"55555555")!=NULL ||
                  strstr(sharesize,"66666666")!=NULL ||
                  strstr(sharesize,"77777777")!=NULL ||
                  strstr(sharesize,"88888888")!=NULL ||
                  strstr(sharesize,"99999999")!=NULL )
         {
            ud->warnmsg=g_string_new("");
            /* possible sharefaker - just create an op-message */
            g_string_sprintf(ud->warnmsg,"<%s> User %s to be checked - possible ShareFaker\r\n",my_name,nickname);
            g_string_sprintfa(ud->warnmsg,"%lli B = %f KB = %f MB = %f GB",rest,kb,mb,gb);
            ud->kick=1;
         }
   	}
	}
#if 0
	printf("returning result\n");
#endif
	return ud;
}

/*****************************************/
/* start the scan for new incoming users */
/*****************************************/
void start_incoming_scan(const char *nickname)
{
	int i;
#if 0
	printf(" incoming scan started for %s\n",nickname);
#endif
	G_LOCK(search_to_start);

	for(i=0;i<search_to_start->len;i++)
	{
		GString *out;
		AUTOSEARCH *as;
		out=g_string_new("");
		as=&(g_array_index(search_to_start,AUTOSEARCH,i));
		if(as->on_incoming)
		{
			g_string_sprintf(out,"$UniSearch %s %s %s",nickname,as->search_result_return_address,as->search_query->str);
#if 0
			printf("%s incoming scan sends: '%s'\n",my_name,out->str);
#endif
			G_LOCK(hub_com);
			send_dc_line(hub_com,out->str,NULL);
			G_UNLOCK(hub_com);
		}
		g_string_free(out,TRUE);
	}

	G_UNLOCK(search_to_start);

	if((in_sck!=-1) && (strcmp(nickname,my_name)) && (strcmp(nickname,"Hub-Security")))
	{
		GString *out;
		out=g_string_new("");
		g_string_sprintf(out,"$ConnectToMe %s %s",(char *)nickname,my_incom);
		G_LOCK(hub_com);
		send_dc_line(hub_com,out->str,NULL);
		G_UNLOCK(hub_com);
#if 0
		printf("%s incoming scan sends: %s\n",my_name,out->str);
#endif
		g_string_free(out,TRUE);
	}
}

/***********************************************/
/* let's decide if we allow this client or not */
/***********************************************/
USER_DAT *check_client_accept(XTRA_INFO *xi,char *nickname, int i)
{
	USER_DAT *ud=NULL;
	ud=malloc(sizeof(USER_DAT));

	if(ud!=NULL)
	{
		ud->kick=0;
		ud->warnmsg_send=FALSE;
		ud->warnmsg=NULL;

		/* first check the Clients using an description-tag because all other Clients are marked as nmdc-client first */
		if(!strcmp(xi->d_client->str,"DC++"))
		{
#if 0
			printf("check dc++-client\n");
#endif
			if(xi->version==xi->d_version)
			{
				if(!strcmp(xi->client->str,"DC++") && xi->version==xi->d_version)
				{	/* client and version in description & lock match */
					xi->need_scan=0;
					g_ptr_array_index(hub_user_xtra_info,i)=xi;
				}
				else if(!strcmp(xi->client->str,"DC++ k") && xi->version>=0.2501)
				{
					xi->need_scan=0;
					g_ptr_array_index(hub_user_xtra_info,i)=xi;
				}
				else if(!strcmp(xi->client->str,"DC++ OP") && xi->version==xi->d_version)
				{
					xi->need_scan=0;
					g_ptr_array_index(hub_user_xtra_info,i)=xi;
				}
				else if(!strcmp(xi->client->str,"BCDC") && xi->version==xi->d_version)
				{  /* client and version in description & lock match */
					xi->need_scan=0;
					g_ptr_array_index(hub_user_xtra_info,i)=xi;
				}
				else
				{
					ud->warnmsg=g_string_new("");
					g_string_sprintf(ud->warnmsg,"<%s> check %s using unknown Client with DC++Description",my_name, nickname);
					ud->kick=1;
				}
			}
			else if((xi->version==0.2501 || xi->version==0.2505) && xi->d_version==0.25 && !strcmp(xi->client->str,"DC++ k"))
			{
				xi->need_scan=0;
				g_ptr_array_index(hub_user_xtra_info,i)=xi;
			}
			else 
			{	/* clientversions doesn't match - let's Kick */
				ud->warnmsg=g_string_new("");
				g_string_sprintf(ud->warnmsg,"You've been kicked because: Faker");
				G_LOCK(hub_com);
				send_private_chat_message(hub_com,my_name,nickname,ud->warnmsg->str,1);
				G_UNLOCK(hub_com);
				g_string_sprintf(ud->warnmsg,"<%s> %s kicked because Client-Versions doesn't match:\r\nLock:	%f\r\nDesc:	%f",my_name, nickname, xi->version,xi->d_version);
				ud->kick=3;
			}
		}
		else if(!strcmp(xi->d_client->str,"LuDC"))
		{
			if(xi->version==xi->d_version)
			{
				if(!strcmp(xi->client->str,"LuDC"))
				{
					xi->need_scan=0;
					g_ptr_array_index(hub_user_xtra_info,i)=xi;
				}
				else
				{
					ud->warnmsg=g_string_new("");
					g_string_sprintf(ud->warnmsg,"<%s> check %s using unknown Client with LuDC Description",my_name, nickname);
					ud->kick=1;
				}
			}
			else
			{	/* clientversions doesn't match - let's Kick */
				ud->warnmsg=g_string_new("");
				g_string_sprintfa(ud->warnmsg,"You've been kicked because: Faker");
				G_LOCK(hub_com);
				send_private_chat_message(hub_com,my_name,nickname,ud->warnmsg->str,1);
				G_UNLOCK(hub_com);
				g_string_sprintf(ud->warnmsg,"<%s> %s kicked because Client-Versions doesn't match:\r\nLock:  %f\r\nDesc: %f",my_name, nickname, xi->version,xi->d_version);
				ud->kick=3;
			}
		}
		else if(!strcmp(xi->d_client->str,"DC++ mod"))
		{	/* unknown dc++-clones modifying the dc++-description */
			/* send op-message to check the description manually */
			if(xi->need_scan>0)
			{
				xi->need_scan--;
				g_ptr_array_index(hub_user_xtra_info,i)=xi;
			}
			ud->warnmsg=g_string_new("");
			g_string_sprintfa(ud->warnmsg,"<%s> check %s for modified DC++ description-tag",my_name,nickname);
			ud->kick=1;
		}
		else if(!strcmp(xi->d_client->str,"DC++ mod OK"))
		{
#if 0
			printf("check DC++ mod OK Client\n");
#endif
			if(xi->version==xi->d_version)
			{
#if 0
				printf("version io\n");
#endif
				if(!strcmp(xi->client->str,"DC++"))
				{	/* known dc++-clones modifying the dc++-description */
#if 0
					printf("Lock check Client is DC++\n");
#endif
					if((!strcmp(xi->d_versionadd->str," DC@fe++") || !strcmp(xi->d_versionadd->str," Horror++") || !strcmp(xi->d_versionadd->str,"[DFP]") || !strcmp(xi->d_versionadd->str,"B")) && !strcmp(xi->versionadd->str,"")) 
					{
						xi->need_scan=0;
#if 0
						printf("updating xi\n");
#endif
						g_ptr_array_index(hub_user_xtra_info,i)=xi;
					}
					else if(!strcmp(xi->d_versionadd->str,"R^3") && !strcmp(xi->versionadd->str,"") && xi->version==0.181 && xi->d_version==0.181)
					{
						xi->need_scan=0;
						g_ptr_array_index(hub_user_xtra_info,i)=xi;
					}
				}
				else if(!strcmp(xi->client->str,"CZDC") && !strcmp(xi->d_versionadd->str,"A") && !strcmp(xi->versionadd->str,"/*0.211A*/") && xi->version==0.211)
				{
					xi->need_scan=0;
					g_ptr_array_index(hub_user_xtra_info,i)=xi;
				}
				else
				{
					ud->warnmsg=g_string_new("");
					g_string_sprintfa(ud->warnmsg,"<%s> check %s for modifying known DC++ Clone",my_name,nickname);
					xi->need_scan--;
					g_ptr_array_index(hub_user_xtra_info,i)=xi;
					ud->kick=1;
				}
#if 0
				printf("finished DC++ mod OK Client\n");
#endif
			}
			else if(xi->version==0.24 && xi->d_version==0.241 && !strcmp(xi->d_versionadd->str,"A") && !strcmp(xi->client->str,"DC++"))
			{	/* CZDC 0.241 has different versions in Lock & Description :( */
				xi->need_scan=0;
				g_ptr_array_index(hub_user_xtra_info,i)=xi;
			}
			else
			{	/* but check for CZDC 0.24/0.241 before */
				ud->warnmsg=g_string_new("");
				g_string_sprintfa(ud->warnmsg,"You've been kicked because: Faker");
				G_LOCK(hub_com);
				send_private_chat_message(hub_com,my_name,nickname,ud->warnmsg->str,1);
				G_UNLOCK(hub_com);
				g_string_sprintf(ud->warnmsg,"<%s> %s kicked because known DC++ Clone Versions doesn't match:\r\nLock:  %f\r\nDesc: %f",my_name,nickname,xi->version,xi->d_version);
				ud->kick=3;
			}
		}
		else if(!strcmp(xi->d_client->str,"DCGUI"))
		{
			if(!strcmp(xi->client->str,"DCGUI"))
			{
				xi->need_scan=0;
				g_ptr_array_index(hub_user_xtra_info,i)=xi;
			}
		}
		else if(!strcmp(xi->d_client->str,"KoalaDC"))
		{
			if(!strcmp(xi->client->str,"KoalaDC"))
			{
				xi->need_scan=0;
				g_ptr_array_index(hub_user_xtra_info,i)=xi;
			}
		}
		else if(!strcmp(xi->d_client->str,"NMDC2") && !strcmp(xi->client->str,"NM-DC OS-X"))
		{
			if(xi->need_scan>0)
			{
				xi->need_scan--;
				g_ptr_array_index(hub_user_xtra_info,i)=xi;
			}
		}
		else if(!strcmp(xi->d_client->str,"NM-DC"))
		{	/* all Clients not displaying an description-tag */
			if(!strcmp(xi->client->str,"DCTC"))
			{
				if(xi->need_scan>0)
				{
					xi->need_scan--;
					g_ptr_array_index(hub_user_xtra_info,i)=xi;
				}
			}
			else if(!strcmp(xi->client->str,"QuickDC"))
			{
				if(xi->need_scan>0)
				{
					xi->need_scan--;
					g_ptr_array_index(hub_user_xtra_info,i)=xi;
				}
			}
			else if(!strcmp(xi->client->str,"JavaDC2"))
			{
				if(xi->need_scan>0)
				{
					xi->need_scan--;
					g_ptr_array_index(hub_user_xtra_info,i)=xi;
					g_string_sprintf(ud->warnmsg,"<%s> %s detected as using JavaDC2",my_name,nickname);
					ud->kick=1;
				}
			}
			else if(!strcmp(xi->client->str,"PK17 statisch"))
			{
				ud->warnmsg=g_string_new("");
				g_string_sprintf(ud->warnmsg,"You've been kicked because: Faker");
				G_LOCK(hub_com);
				send_private_chat_message(hub_com,my_name,nickname,ud->warnmsg->str,1);
				G_UNLOCK(hub_com);
				g_string_sprintf(ud->warnmsg,"<%s> %s kicked because %s hiding",my_name,nickname,xi->client->str);
				ud->kick=3;
			}
			else if(!strcmp(xi->client->str,"DC++"))
			{
				ud->warnmsg=g_string_new("");
				g_string_sprintf(ud->warnmsg,"You've been kicked because: No hiding dc++ clients");
				G_LOCK(hub_com);
				send_private_chat_message(hub_com,my_name,nickname,ud->warnmsg->str,1);
				G_UNLOCK(hub_com);
				g_string_sprintf(ud->warnmsg,"<%s> %s kicked because DC++ %f hiding",my_name,nickname,xi->version);
				ud->kick=3;
			}
			else if(!strcmp(xi->client->str,"DC++ hiding version too old"))
			{
				ud->warnmsg=g_string_new("");
				g_string_sprintf(ud->warnmsg,"Please update to an actual Client !!!");
				G_LOCK(hub_com);
				send_private_chat_message(hub_com,my_name,nickname,ud->warnmsg->str,1);
				G_UNLOCK(hub_com);
				g_string_sprintf(ud->warnmsg,"<%s> %s kicked because DC++ outdated version %f",my_name,nickname,xi->version);
				ud->kick=3;
			}
			else if(!strcmp(xi->client->str,"DC++ hiding"))
			{
				ud->warnmsg=g_string_new("");
				g_string_sprintf(ud->warnmsg,"Please update to an actual non-descriptiontag-hiding Client !!!");
				G_LOCK(hub_com);
				send_private_chat_message(hub_com,my_name,nickname,ud->warnmsg->str,1);
				G_UNLOCK(hub_com);
				g_string_sprintf(ud->warnmsg,"<%s> %s kicked because DC++ hiding %f",my_name,nickname,xi->version);
				ud->kick=3;
			}
			else if(!strcmp(xi->client->str,"DC++k hiding"))
			{
				ud->warnmsg=g_string_new("");
				g_string_sprintf(ud->warnmsg,"You've been kicked because: No hiding dc++ clients");
				G_LOCK(hub_com);
				send_private_chat_message(hub_com,my_name,nickname,ud->warnmsg->str,1);
				G_UNLOCK(hub_com);
				g_string_sprintf(ud->warnmsg,"<%s> %s kicked because DC++ k hiding",my_name,nickname);
				ud->kick=3;
			}
			else if(!strcmp(xi->client->str,"BCDC hiding"))
			{
				ud->warnmsg=g_string_new("");
				g_string_sprintf(ud->warnmsg,"You've been kicked because: No hiding dc++ clients");
				G_LOCK(hub_com);
				send_private_chat_message(hub_com,my_name,nickname,ud->warnmsg->str,1);
				G_UNLOCK(hub_com);
				g_string_sprintf(ud->warnmsg,"<%s> %s kicked because BCDC hiding",my_name,nickname);
				ud->kick=3;
			}
			else if(!strcmp(xi->client->str,"DC++ mod"))
			{
				ud->warnmsg=g_string_new("");
				g_string_sprintf(ud->warnmsg,"You've been kicked because: No hiding dc++ clients");
				G_LOCK(hub_com);
				send_private_chat_message(hub_com,my_name,nickname,ud->warnmsg->str,1);
				G_UNLOCK(hub_com);
				g_string_sprintf(ud->warnmsg,"<%s> %s kicked because DC++ mod %f - %s hiding",my_name,nickname,xi->version,xi->versionadd->str);
				ud->kick=3;
			}
			else if(!strcmp(xi->client->str,"DCGUI"))
			{
				ud->warnmsg=g_string_new("");
				g_string_sprintf(ud->warnmsg,"Please activate the DCGUI-Description Tag - otherwise you'll be banned");
				G_LOCK(hub_com);
				send_private_chat_message(hub_com,my_name,nickname,ud->warnmsg->str,1);
				G_UNLOCK(hub_com);
				g_string_sprintf(ud->warnmsg,"<%s> detected hiding dcgui %s - user disconnected",my_name,nickname);
				g_ptr_array_index(hub_user_xtra_info,i)=xi;
				ud->kick=5;
			}
			else if(!strcmp(xi->client->str,"CZDC"))
			{
				ud->warnmsg=g_string_new("");
				g_string_sprintf(ud->warnmsg,"You've been kicked because: No hiding dc++ clients");
				G_LOCK(hub_com);
				send_private_chat_message(hub_com,my_name,nickname,ud->warnmsg->str,1);
				G_UNLOCK(hub_com);
				g_string_sprintf(ud->warnmsg,"<%s> %s kicked because CZDC hiding",my_name,nickname);
				ud->kick=3;
			}
			else if(!strcmp(xi->client->str,"BCDC"))
			{
				ud->warnmsg=g_string_new("");
				g_string_sprintf(ud->warnmsg,"You've been kicked because: No hiding dc++ clients");
				G_LOCK(hub_com);
				send_private_chat_message(hub_com,my_name,nickname,ud->warnmsg->str,1);
				G_UNLOCK(hub_com);
				g_string_sprintf(ud->warnmsg,"<%s> %s kicked because BCDC hiding",my_name,nickname);
				ud->kick=3;
			}
			else if(!strcmp(xi->client->str,"LuDC"))
			{
				ud->warnmsg=g_string_new("");
				g_string_sprintf(ud->warnmsg,"You've been kicked because: No hiding dc++ clients");
				G_LOCK(hub_com);
				send_private_chat_message(hub_com,my_name,nickname,ud->warnmsg->str,1);
				G_UNLOCK(hub_com);
				g_string_sprintf(ud->warnmsg,"<%s> %s kicked because LuDC hiding",my_name,nickname);
				ud->kick=3;
			}
			else if(!strcmp(xi->client->str,"DC++ Blue"))
			{
				ud->warnmsg=g_string_new("");
				g_string_sprintf(ud->warnmsg,"You've been kicked because: Your client is not allowed in here");
				G_LOCK(hub_com);
				send_private_chat_message(hub_com,my_name,nickname,ud->warnmsg->str,1);
				G_UNLOCK(hub_com);
				g_string_sprintf(ud->warnmsg,"<%s> %s kicked because DC++ Blue",my_name,nickname);
				ud->kick=3;
			}
			else if(!strcmp(xi->client->str,"mldonkey"))
			{
				ud->warnmsg=g_string_new("");
				g_string_sprintf(ud->warnmsg,"You've been kicked because: Your client is not allowed in here");
				G_LOCK(hub_com);
				send_private_chat_message(hub_com,my_name,nickname,ud->warnmsg->str,1);
				G_UNLOCK(hub_com);
				g_string_sprintf(ud->warnmsg,"<%s> %s kicked because mldonkey",my_name,nickname);
				ud->kick=3;
			}
			else if((xi->got_lock>2) && (strcmp(xi->locka->str,xi->lockb->str)==0) && (strcmp(xi->locka->str,xi->lockc->str)==0) && (strcmp(xi->pka->str,xi->pkb->str)==0) && (strcmp(xi->pka->str,xi->pkc->str)==0))
			{
				ud->warnmsg=g_string_new("");
				g_string_sprintf(ud->warnmsg,"You've been kicked because: Your client is not allowed in here");
				G_LOCK(hub_com);
				send_private_chat_message(hub_com,my_name,nickname,ud->warnmsg->str,1);
				G_UNLOCK(hub_com);
				g_string_sprintf(ud->warnmsg,"<%s> %s kicked because static Lock & Pk\r\nLock: %s\r\n%s",my_name,nickname,xi->locka->str,xi->pka->str);
				ud->kick=3;
			}
			else if((xi->got_lock>2) && (strlen(xi->locka->str)==strlen(xi->lockb->str)) && (strlen(xi->locka->str)==strlen(xi->lockc->str)))
			{
				ud->warnmsg=g_string_new("");
				if(xi->has_bzlist>0)
				{
					g_string_sprintf(ud->warnmsg,"You've been kicked because: Your client is not allowed in here");
					G_LOCK(hub_com);
					send_private_chat_message(hub_com,my_name,nickname,ud->warnmsg->str,1);
					G_UNLOCK(hub_com);
					g_string_sprintf(ud->warnmsg,"<%s> %s kicked because Client with static Locklenght using bzlist",my_name,nickname);
					ud->kick=3;
				}
				else
				{
					g_string_sprintf(ud->warnmsg,"<%s> found %s using client with static locklength:\r\n",my_name,nickname);
					g_string_sprintfa(ud->warnmsg,"Connect client: %s   version: %f %s\r\n",xi->client->str,xi->version,xi->versionadd->str);
					g_string_sprintfa(ud->warnmsg,"myinfo  client: %s   version: %f %s\r\n",xi->d_client->str,xi->d_version,xi->d_versionadd->str);
					g_string_sprintfa(ud->warnmsg,"bzlist: %i\r\n",xi->has_bzlist);
					g_string_sprintfa(ud->warnmsg,"lock1: (%i) %s\r\n",strlen(xi->locka->str),xi->locka->str);
					g_string_sprintfa(ud->warnmsg,"pk1: (%i) %s\r\n",strlen(xi->pka->str),xi->pka->str);
					g_string_sprintfa(ud->warnmsg,"lock2: (%i) %s\r\n",strlen(xi->lockb->str),xi->lockb->str);
					g_string_sprintfa(ud->warnmsg,"pk2: (%i) %s\r\n",strlen(xi->pkb->str),xi->pkb->str);
					g_string_sprintfa(ud->warnmsg,"lock3: (%i) %s\r\n",strlen(xi->lockc->str),xi->lockc->str);
					g_string_sprintfa(ud->warnmsg,"pk3: (%i) %s\r\n",strlen(xi->pkc->str),xi->pkc->str);
					g_string_sprintfa(ud->warnmsg,"PLEASE RESCAN MANUALLY");
					ud->kick=1;
				}
			}
			else if(xi->has_bzlist>0 && xi->got_lock>2)
			{
				ud->warnmsg=g_string_new("");
      	   g_string_sprintf(ud->warnmsg,"<%s> check %s using unknown client with the dc++ 'supports bzlist' !!!\r\n",my_name,nickname);
				g_string_sprintfa(ud->warnmsg,"Connect client: %s   version: %f %s\r\n",xi->client->str,xi->version,xi->versionadd->str);
				g_string_sprintfa(ud->warnmsg,"myinfo  client: %s   version: %f %s\r\n",xi->d_client->str,xi->d_version,xi->d_versionadd->str);
				g_string_sprintfa(ud->warnmsg,"bzlist: supported\r\n");
				g_string_sprintfa(ud->warnmsg,"lock1: (%i) %s\r\n",strlen(xi->locka->str),xi->locka->str);
				g_string_sprintfa(ud->warnmsg,"pk1: (%i) %s\r\n",strlen(xi->pka->str),xi->pka->str);
				g_string_sprintfa(ud->warnmsg,"lock2: (%i) %s\r\n",strlen(xi->lockb->str),xi->lockb->str);
				g_string_sprintfa(ud->warnmsg,"pk2: (%i) %s\r\n",strlen(xi->pkb->str),xi->pkb->str);
				g_string_sprintfa(ud->warnmsg,"lock3: (%i) %s\r\n",strlen(xi->lockc->str),xi->lockc->str);
				g_string_sprintfa(ud->warnmsg,"pk3: (%i) %s\r\n",strlen(xi->pkc->str),xi->pkc->str);
				if(xi->need_scan>0)
				{
					xi->need_scan--;
					g_ptr_array_index(hub_user_xtra_info,i)=xi;
				}
				ud->kick=1;
      	}
	      else if(!strcmp(xi->client->str,"NM-DC"))
   	   {
      	   if(xi->need_scan>0)
         	{
            	xi->need_scan--;
	            g_ptr_array_index(hub_user_xtra_info,i)=xi;
   	      }
      	}
	      else if(!strcmp(xi->client->str,"NM-DC OS-X"))
   	   {
      	   if(xi->need_scan>0)
         	{
            	xi->need_scan--;
	            g_ptr_array_index(hub_user_xtra_info,i)=xi;
   	      }
      	}
			else
			{
				ud->warnmsg=g_string_new("");
				g_string_sprintf(ud->warnmsg,"<%s> check %s using unknown Client:\r\n",my_name,nickname);
				g_string_sprintfa(ud->warnmsg,"Connect client: %s   version: %f %s\r\n",xi->client->str,xi->version,xi->versionadd->str);
				g_string_sprintfa(ud->warnmsg,"myinfo  client: %s   version: %f %s\r\n",xi->d_client->str,xi->d_version,xi->d_versionadd->str);
				g_string_sprintfa(ud->warnmsg,"bzlist: unsupported\r\n");
				g_string_sprintfa(ud->warnmsg,"lock1: (%i) %s\r\n",strlen(xi->locka->str),xi->locka->str);
				g_string_sprintfa(ud->warnmsg,"pk1: (%i) %s\r\n",strlen(xi->pka->str),xi->pka->str);
				if (xi->got_lock==1)
				{
					g_string_sprintfa(ud->warnmsg,"second scan will be started...\r\n");
				}
				if (xi->got_lock>1)
				{
					g_string_sprintfa(ud->warnmsg,"lock2: (%i) %s\r\n",strlen(xi->lockb->str),xi->lockb->str);
					g_string_sprintfa(ud->warnmsg,"pk2: (%i) %s\r\n",strlen(xi->pkb->str),xi->pkb->str);
				}
				if (xi->got_lock>2)
				{
					g_string_sprintfa(ud->warnmsg,"lock3: (%i) %s\r\n",strlen(xi->lockc->str),xi->lockc->str);
					g_string_sprintfa(ud->warnmsg,"pk3: (%i) %s\r\n",strlen(xi->pkc->str),xi->pkc->str);
				}
				if(xi->need_scan>0)
				{
					xi->need_scan--;
					g_ptr_array_index(hub_user_xtra_info,i)=xi;
				}
				ud->kick=1;
			}
		}
		else
		{
			ud->warnmsg=g_string_new("");
			g_string_sprintf(ud->warnmsg,"<%s> unknown client - possible detectionerror - check %s",my_name,nickname);
			ud->kick=1;
		}
	}
	/****************************************************/
	/* What do I use...                                 */
	/* ...the messages to chat/user are send before     */
	/****************************************************/
	/* kick=0 -> everything should be ok                */
	/* kick=1 -> just an op/user info message           */
	/* kick=2 -> unused now - mainly used by ops to     */
	/*           kick users not taking care of hubrules */
	/* kick=3 -> used for faking or hiding clients      */
	/* kick=4 -> lowkick for exceeding dc++ limits      */
	/*           or share-limit                         */
	/* kick=5 -> disconnect only - one minute ban to    */
	/*           prevent fast reconnects                */
	/****************************************************/
	return ud;
}

/******************************/
/* set user extra information */
/******************************/
void set_xtra_information_cnx( const char *nick, int type, const char *addr, const char *client, double version, const char *versionadd, const char *lock, const char *pk, int has_bzlist, int got_lock, int got_myinfo, const char *d_client,double  d_version, const char *d_versionadd, time_t lock_time, char *utype, unsigned long long sharesize, int exceed_limit)
{
	int i;
	int kick=0;
	int warnmsg_send=FALSE;
	char *usr_addr=NULL;
	GString *warnmsg=NULL;
	XTRA_INFO *xi=NULL;

#if 0
	printf("%s set_xtra_info start\n",my_name);
#endif
	G_LOCK(hub_user_list);
	
	/* first we must find the index of the given user */
	for(i=0;i<hub_user_list->len;i++)
	{
		char *p;

		p=g_ptr_array_index(hub_user_list,i);
#if 0
		printf("xtra-info comparing: %s %s %s\n",(char *)nick,p,(char *)g_ptr_array_index(hub_user_list,i));
#endif
		if(strcmp(nick,p)==0)
		{
			/* gotcha */
#if 0
			printf("xtra-info found: %s\n",(char *)g_ptr_array_index(hub_user_list,i));
#endif
			xi=g_ptr_array_index(hub_user_xtra_info,i);
			if(xi==NULL)
			{
				/* not yet set */
#if 0
				printf("%s xtra info no info yet - getting memory for entry\n",my_name);
#endif
				xi=create_user_cnx_info(type, addr, client, version, versionadd, lock, pk, has_bzlist, got_lock, got_myinfo, d_client, d_version, d_versionadd, lock_time, utype, exceed_limit, sharesize);
				g_ptr_array_index(hub_user_xtra_info,i)=xi;
			}
			else
			{
				int z;
#if 0
				printf("xi != NULL\n");
#endif 
				/* lets first check if 'client' has changed between locks */
				/* this may happen with some (faking) clients assumed to be nmdc, dctc or unknown */
				/* the assumed client is stored only once inside the cnx-info, so check before updating */
				if(got_lock==1 && xi->got_lock>0 && strcmp(client,xi->client->str))
				{
					warnmsg=g_string_new("");
					g_string_sprintf(warnmsg,"<%s> check %s for changing decoded client: %s %s",my_name,(char*)nick,client,xi->client->str);
					kick=1;
				}
#if 0
				printf("updating user info\n");
#endif
				z=update_user_cnx_info(i, type, addr, client, version, versionadd, lock, pk, has_bzlist, got_lock, got_myinfo, d_client, d_version, d_versionadd, lock_time, utype, xi, exceed_limit, sharesize);
#if 0
				printf("userinfo updated - getting updated data\n");
#endif
				xi=NULL;
				xi=g_ptr_array_index(hub_user_xtra_info,i);

#if 0
				printf("array entry updated -> %s %i\n",xi->utype,xi->got_myinfo);
#endif

				/* user data is updated - checking if we allow this client or not */
				/* first lets check the sharesize if we've got myinfo and usertype */
#if 0
				printf("sharecheck: %s %i\n",xi->utype, xi->got_myinfo);
#endif
				if(xi->utype!=NULL && xi->got_myinfo>0)
				{
#if 0
					printf("got utype & myinfo -> sharecheck\n");
#endif
					/* first prevent some usertypes not beeing checked for valid share */
					if(strcspn(xi->utype,"VOMbB")!=0)
					{
						if(xi->exceed_limit==TRUE)
						{	/* users outside dc++, dcgui or Koala hub or slotlimits */
							G_LOCK(hub_com);
							send_private_chat_message(hub_com,my_name,(char*)nick,"You are being kicked because: DC++,Koala or DCGUI User: 4 HUBS and 2 Slots is Limit - max 20 SLOTS - min UPSTREAM 6 ...",1);
							G_UNLOCK(hub_com);
							kick=4;
						}
						else
						{
							USER_DAT *ud=NULL;
#if 0
							printf("users inside limit - start sharesize-scan: \n");
#endif
							ud=check_valid_sharesize((char*)nick,xi->amount);
#if 0
							printf("received share-scan result\n");
#endif
							if(ud!=NULL)
							{
								kick=ud->kick;

								if(ud->warnmsg!=NULL)
								{
#if 0
									printf("scare-scan result: %i %s\n",ud->kick,ud->warnmsg->str);
#endif
									if(warnmsg!=NULL)
									{
										g_string_free(warnmsg,TRUE);
									}
									warnmsg=g_string_new("");
									g_string_sprintf(warnmsg,"%s",ud->warnmsg->str);
								}
								else
								{
#if 0
									printf("scare-scan result: %i - no warnmsg\n",ud->kick);
#endif
								}
							}
							else
							{
#if 0
								printf("scare-scan result: ud=NULL\n");
#endif
							}
						}
					}
#if 0
					printf("sharesize io - start incoming scan\n");
#endif
					/* if the user will not be kicked lets start the incoming user-scan */
					if((kick==0 || kick==1) && xi->got_myinfo>0 && got_myinfo==1)
						start_incoming_scan((char*)nick);
				}
#if 0
				printf("sharecheck finished\n");
#endif
				/* if we've got myinfo,lock & the user is not marked to be kicked let's check if this client is valid or not */
				if((kick==0 || kick==1) && (xi->got_lock > 0) && (xi->got_myinfo > 0) && (xi->utype!=NULL))
				{
					USER_DAT *ud=NULL;
#if 0
					printf("starting client-check\n");
#endif
					/* now lets check which client we allow or which not */
					ud=check_client_accept(xi,(char*)nick,i);
					if(ud!=NULL)
					{
						if(ud->kick>kick)
							kick=ud->kick;

						warnmsg_send=ud->warnmsg_send;
						usr_addr=strdup(xi->addr->str);
						if(ud->warnmsg!=NULL)
						{
#if 0
							printf("client accept result: %i %s\n",ud->kick,ud->warnmsg->str);
#endif
							if(warnmsg!=NULL)
							{
								g_string_free(warnmsg,TRUE);
							}
							warnmsg=g_string_new("");
							g_string_sprintf(warnmsg,"%s",ud->warnmsg->str);
						}
						else
						{
#if 0
							printf("client accept result: %i - no warnmsg\n",ud->kick);
#endif
						}
					}
#if 0
					printf("Client check finished\n");
#endif
				}
			}
			break;
		}
	}
	G_UNLOCK(hub_user_list);
	if (warnmsg!=NULL && (kick==1 || kick==3 || kick==5))
	{
		if (warnmsg_send==FALSE)
		{
			send_op_message(warnmsg->str, my_name);
		}
		g_string_free(warnmsg,TRUE);
	}

	if(kick==2 || kick==3 || kick==4 || kick==5)
	{
		/****************************************************/
		/* What do I use...                                 */
		/* ...the messages to chat/user are send before     */
		/****************************************************/
		/* kick=0 -> everything should be ok                */
		/* kick=1 -> just an op/user info message           */
		/* kick=2 -> unused now - mainly used by ops to     */
		/*           kick users not taking care of hubrules */
		/* kick=3 -> used for faking or hiding clients      */
		/* kick=4 -> lowkick for exceeding dc++ limits      */
		/*           or share-limit                         */
		/* kick=5 -> disconnect only - one minute ban to    */
		/*           prevent fast reconnects                */
		/****************************************************/
		if(remove_user_to_user_list(nick))
		{
			GString *bancmd;
			int duration=0;

			bancmd=g_string_new("");

			if (kick==2)
				duration=120;	/* -ban time is specified in minutes 120==2h */
			else if (kick==3)
				duration=43200;	/* -ban time is specified in minutes 43200==30d */
			else if (kick==4)
				duration=10;	/* -ban time is specified in minutes */
			else if (kick==5)
				duration=1;		/* -ban time is specified in minutes */

			g_string_sprintf(bancmd,"-ban %i %s",duration,nick);
			G_LOCK(hub_com);
			send_private_chat_message(hub_com,my_name,"Hub-Security",bancmd->str,1);
			G_UNLOCK(hub_com);

			g_string_free(bancmd,TRUE);

			G_LOCK(hub_com);
			kick_user(hub_com,my_name,nick,"...");
			G_UNLOCK(hub_com);
		}
	}
#if 0
	printf("set xtra info finished\n");
#endif
}

/************************************************************************/
/* check if the given pattern exists inside filename (case insensitive) */
/************************************************************************/
/* output: address of the pattern or NULL */
/******************************************/
const char *my_strcasestr(const GString *pattern, const char *filename)
{
   int max_pos;
   int i;

#if 0
   printf("start strcasestr\n");
#endif

   max_pos=strlen(filename)-pattern->len;

   if(max_pos<0)              /* filename length < pattern length ? */
      return NULL;            /* no match */

   for(i=0;i<=max_pos;i++)
   {
      if(!strncasecmp(pattern->str,filename+i,pattern->len))
		{
#if 0
			printf("finish strcasestr\n");
#endif
			return filename+i;
		}
   }
#if 0
	printf("finish strcasestr\n");
#endif
   return NULL;               /* no match */
}
/**********************************************************/
/* backwardscheck for dc++ users - against doubling-Fakes */
/**********************************************************/
const char *my_strbackstr(const GString *pattern, const char *filename)
{
   int max_pos;
   int i;

#if 0
   printf("start strbackstr\n");
#endif

   max_pos=strlen(filename)-pattern->len;

   if(max_pos<0)
      return NULL;

   i=max_pos;
   while(i>0)
   {
		i=i-1;
		if(!strncasecmp(pattern->str,filename+i,pattern->len))
		{
#if 0
         printf("finish strbackstr\n");
#endif
			return filename+i;
		}
   }
#if 0
   printf("finish strbackstr\n");
#endif

   return NULL;
}
/* ----------------------------------------------------------------------------------------- */
/* ----------------------------------------------------------------------------------------- */
/* ----------------------------------------------------------------------------------------- */
/* ---- find users having no enough slots opened ------------------------------------------- */
/* ----------------------------------------------------------------------------------------- */
/* ----------------------------------------------------------------------------------------- */
/* ----------------------------------------------------------------------------------------- */

/***************************************************************************************************/
/* this function analyzes the result of the "F?F?0?1?mp" search query to identify buggy clones */
/***************************************************************************************************/
static int slot_autosearch_sr(void *xtra_param, const char *nick, const char *filename, unsigned long long filesize, unsigned int free_slot, unsigned int ttl_slot)
{
	const GString explorer={"explorer.exe",strlen("explorer.exe")};
	const GString about={"AboutDC.exe",strlen("AboutDC.exe")};
	const GString kazaa={"download10",strlen("download10")};
	const GString emule={".part.met",strlen(".part.met")};
	const GString incompl={"__INCOMPLETE___",strlen("__INCOMPLETE___")};
	GString *resexplorer;
	GString *resabout;
	GString *reskazaa;
	GString *resemule;
	GString *resincompl;
	int i;
	int protect=FALSE;
#if 0
	printf("%s slot_autosearch_sr: '%s'\n",my_name,filename);
#endif
	resexplorer=g_string_new(my_strcasestr(&explorer,filename));
	resabout=g_string_new(my_strcasestr(&about,filename));
	reskazaa=g_string_new(my_strcasestr(&kazaa,filename));
	resemule=g_string_new(my_strcasestr(&emule,filename));
	resincompl=g_string_new(my_strcasestr(&incompl,filename));
#if 0
	printf("slot_autosearch_sr trying to lock hub user list\n");
#endif
	G_LOCK(hub_user_list);
#if 0
	printf("slot_autosearch_sr locked hub user list\n");
#endif
	for(i=0;i<hub_user_list->len;i++)
	{
		if(!strcmp(nick,g_ptr_array_index(hub_user_list,i)))
		{ /* user found */
			XTRA_INFO *xi;
			xi=g_ptr_array_index(hub_user_xtra_info,i);
			if(xi!=NULL)
			{
				if(xi->utype!=NULL)
				{
					if(!strcspn(xi->utype,"VbBMO"))
					{
						protect=TRUE;
					}
				}
				else
					protect=TRUE;    /* protecting users when no usertype is available */
			}
			else
				protect=TRUE;		/* protecting users when no usertype is available */
			break;
		}
	}
#if 0
	printf("slot_autosearch_sr trying to unlock hub user list\n");
#endif
	G_UNLOCK(hub_user_list);
#if 0
	printf("slot_autosearch_sr unlocked hub user list\n");
#endif
	if (protect==FALSE)
	{
		if	(
			(ttl_slot<2) /* 2 Slot is the Limit */
			)
		{
			G_LOCK(hub_com);
			send_private_chat_message(hub_com,my_name,(char *)nick,"This HUB has a Slot-Limit of 2 - change it and you can come back...",1);
			G_UNLOCK(hub_com);
			if(remove_user_to_user_list((char *)nick))
			{
				G_LOCK(hub_com);
				kick_user(hub_com,my_name,(char *)nick,"...");
				G_UNLOCK(hub_com);
			}
		}
		else if (strncmp(filename,"/mnt/data/pub",13)==0)
		{
			if(remove_user_to_user_list((char *)nick))
			{
				GString *msg;
				msg=g_string_new("");
				G_LOCK(hub_com);
				send_private_chat_message(hub_com,my_name,(char *)nick,"FAKER",1);
				G_UNLOCK(hub_com);
				g_string_sprintf(msg,"-ban 30d %s",(char *)nick); // 30D Ban
				G_LOCK(hub_com);
				send_private_chat_message(hub_com,my_name,"Hub-Security",msg->str,1);
				G_UNLOCK(hub_com);
				G_LOCK(hub_com);
				kick_user(hub_com,my_name,(char *)nick,"...");
				G_UNLOCK(hub_com);
				g_string_free(msg,TRUE);
			}
		}
		else if	(
			((strcmp(resexplorer->str,"explorer.exe")==0)||
			(strcmp(resabout->str,"AboutDC.exe")==0))
			)
		{
			G_LOCK(hub_com);
			send_private_chat_message(hub_com,my_name,(char *)nick,"You are Sharing Windows-System-Files or installed Program-Files - change it and you can come back...",1);
			G_UNLOCK(hub_com);
			if(remove_user_to_user_list((char *)nick))
			{
				GString *msg;
				msg=g_string_new("");
				g_string_sprintf(msg,"-ban 10 %s",(char *)nick); // 10min Ban
				G_LOCK(hub_com);
				send_private_chat_message(hub_com,my_name,"Hub-Security",msg->str,1);
				G_UNLOCK(hub_com);
				G_LOCK(hub_com);
				kick_user(hub_com,my_name,nick,"...");
				G_UNLOCK(hub_com);
				g_string_free(msg,TRUE);
			}
		}
		else if (strncmp(reskazaa->str,"download10",strlen("download10"))==0)
		{
			char *dp;
			dp=strstr(reskazaa->str,".dat");
			if(dp!=NULL)
			{
				if(strcmp(dp,".dat")==0)
				{
					if(remove_user_to_user_list((char *)nick))
					{
						GString *msg;
						msg=g_string_new("");
						g_string_sprintf(msg,"don't share eDonkey/eMule/Overnet/WinMX/KaZaa or any other incomplete/temp-downloads !!!\r\nPath: %s",filename);
						G_LOCK(hub_com);
						send_private_chat_message(hub_com,my_name,(char *)nick,msg->str,1);
						G_UNLOCK(hub_com);
						g_string_sprintf(msg,"-ban 10 %s",(char *)nick); // 10min Ban
						G_LOCK(hub_com);
						send_private_chat_message(hub_com,my_name,"Hub-Security",msg->str,1);
						G_UNLOCK(hub_com);
						G_LOCK(hub_com);
						kick_user(hub_com,my_name,(char *)nick,"...");
						G_UNLOCK(hub_com);
						g_string_free(msg,TRUE);
					}
				}
			}
		}
		else if (strstr(resemule->str,".part.met")!=NULL)
		{
			char *dp;
			dp=strstr(resemule->str,".part.met");
			if(strcmp(dp,".part.met")==0)
			{
				if(remove_user_to_user_list((char *)nick))
				{
					GString *msg;
					msg=g_string_new("");
					g_string_sprintf(msg,"don't share eDonkey/eMule/Overnet/WinMX/KaZaa or any other incomplete/temp-downloads !!!\r\nPath: %s",filename);
					G_LOCK(hub_com);
					send_private_chat_message(hub_com,my_name,(char *)nick,msg->str,1);
					G_UNLOCK(hub_com);
					g_string_sprintf(msg,"-ban 10 %s",nick); // 10min Ban
					G_LOCK(hub_com);
					send_private_chat_message(hub_com,my_name,"Hub-Security",msg->str,1);
					G_UNLOCK(hub_com);
					G_LOCK(hub_com);
					kick_user(hub_com,my_name,(char *)nick,"...");
					G_UNLOCK(hub_com);
					g_string_free(msg,TRUE);
				}
			}
		}
		else if (strncmp(resincompl->str,"__INCOMPLETE___",strlen("__INCOMPLETE___"))==0 && strlen(resincompl->str)>70)
		{
			if(remove_user_to_user_list((char *)nick))
			{
				GString *msg;
				msg=g_string_new("");
				g_string_sprintf(msg,"don't share eDonkey/eMule/Overnet/WinMX/KaZaa or any other incomplete/temp-downloads !!!\r\nPath: %s",filename);

				G_LOCK(hub_com);
				send_private_chat_message(hub_com,my_name,(char *)nick,"don't share eDonkey/eMule/Overnet/WinMX/KaZaa or any other incomplete/temp-downloads !!!",1);
				G_UNLOCK(hub_com);
				g_string_sprintf(msg,"-ban 10 %s",(char *)nick); // 10min Ban
				G_LOCK(hub_com);
				send_private_chat_message(hub_com,my_name,"Hub-Security",msg->str,1);
				G_UNLOCK(hub_com);
				G_LOCK(hub_com);
				kick_user(hub_com,my_name,(char *)nick,"...");
				G_UNLOCK(hub_com);
				g_string_free(msg,TRUE);
			}
		}
	}
	g_string_free(resexplorer,TRUE);
	g_string_free(resabout,TRUE);
	g_string_free(reskazaa,TRUE);
	g_string_free(resemule,TRUE);
	g_string_free(resincompl,TRUE);
	return 0;
}

/**********************************************************************************************************************/
/* slot autosearch searchs for buggy DC clone returning everything but what it is expected when a research is started */
/**********************************************************************************************************************/
/* This function receives the search results of the query "$Search myhost mpyip F?F?0?1?mp|" sent to each   */
/* incoming user.                                                                                           */
/* theoritically, this should returns the list of max 5 files including the String "*mp*". I think nearly   */
/* everyone have an mp3 or an mpeg-file ;-). From this answer we extract the number of Slots, the user has. */
/* If the min-slot is not offered the user is kicked and banned and its IP is banned.                       */
/************************************************************************************************************/
/* NOTE: to reduce bandwidth usage, when added, a search is immediatly started and a "one user" search is   */
/*       performed each time a user enters the hub                                                          */
/************************************************************************************************************/
static void *slot_autosearch_fnc(void *dummy)
{
	int incoming_result_fd;
	static TBLDECODE gen_dec={NULL,NULL,NULL,NULL,slot_autosearch_sr,NULL,NULL,NULL,NULL,NULL,NULL};

	incoming_result_fd=_x_udp(0);			/* create an UDP socket and found an unused port */
	if(incoming_result_fd==-1)
	{
		fprintf(stderr,"slot_autosearch_fnc: fail to create UDP socket.\n");
	}
	else
	{
		struct sockaddr_in lcl;
		int len_lcl=sizeof(lcl);

		if(getsockname(incoming_result_fd,(void*)&lcl,&len_lcl)!=0)
		{
			perror("getsockname fail");
			shutdown(incoming_result_fd,2);
			close(incoming_result_fd);
		}
		else
		{
			GString *str;

			add_pattern_to_search(ntohs(lcl.sin_port),"F?T?0?1?mp",TRUE,TRUE,FALSE);
			add_pattern_to_search(ntohs(lcl.sin_port),"F?T?0?5?explorer.exe",TRUE,FALSE,TRUE);
			add_pattern_to_search(ntohs(lcl.sin_port),"F?T?0?5?AboutDC.exe",TRUE,FALSE,TRUE);
			add_pattern_to_search(ntohs(lcl.sin_port),"F?T?0?1?.part.met",TRUE,FALSE,TRUE);
			add_pattern_to_search(ntohs(lcl.sin_port),"F?T?0?1?download10",TRUE,FALSE,TRUE);
			add_pattern_to_search(ntohs(lcl.sin_port),"F?T?0?1?__INCOMPLETE___",TRUE,FALSE,TRUE);
			add_pattern_to_search(ntohs(lcl.sin_port),"F?T?0?1?mnt data pub",TRUE,TRUE,FALSE);
			str=g_string_new("");

			/* loop for ever and process received result */
			while(1)
			{
				int ret;
				char buf[8192];

				ret=recv(incoming_result_fd,buf,sizeof(buf)-1,MSG_NOSIGNAL);
				if(ret!=-1)
				{
					buf[ret]='\0';
					
					str=g_string_assign(str,buf);
					str=g_string_append(str,"|");
#if 0
					printf("%s Slot AutoSearch funktion got: %s\n",my_name,str->str);
#endif
					generic_decoder(str,&gen_dec,NULL);
#if 0
					printf("generic decoder finished\n");
#endif
				}
			}
		}
	}
	pthread_exit(NULL);
}

static void start_auto_search()
{
	pthread_t tid;
	pthread_attr_t thread_attr;
	pthread_attr_init (&thread_attr);
	pthread_attr_setdetachstate(&thread_attr, PTHREAD_CREATE_DETACHED);
	if(pthread_create(&tid,&thread_attr,(void*)slot_autosearch_fnc,NULL)!=0)
	{
		fprintf(stderr,"Fail to create auto search thread.\n");
		exit(1);
	}
}

/********************************************************/
/* when someone connects on com port, send our nickname */
/********************************************************/
static int send_nick(int sck)
{
	GString *str;
	int a;
#if 0
	printf("%s send nick start\n",my_name);
#endif
	str=g_string_new(NULL);
	g_string_sprintf(str,"$MyNick %s|",my_name);
#if 0
	printf("send nick sent: '%s'\n",str->str);
#endif

#if 0
	a=write(sck,str->str,str->len);                 /* @@@ replaced by send */
	a=(a!=str->len);
#else
	a=( (send(sck,str->str,str->len,MSG_NOSIGNAL)) != str->len );
#endif

	g_string_free(str,TRUE);
	return a;                               /* 1=fail, 0=ok */
}

/***********************************************/
/* destruction of the given WAIT_ACT structure */
/***********************************************/
void free_wait_act(WAIT_ACT *act)
{
#if 0
	printf("free wait act start\n");
#endif
	if(act==NULL)
		return;
	if(act->sock_fd)
	{
		shutdown(act->sock_fd,2);
		close(act->sock_fd);
		act->sock_fd=0;
	}
	if(act->remote_nick!=NULL)
	{
		g_string_free(act->remote_nick,TRUE);
		act->remote_nick=NULL;
	}
	if(act->remote_addr!=NULL)
	{
		g_string_free(act->remote_addr,TRUE);
		act->remote_addr=NULL;
	}
	if(act->run_task!=NULL)
	{
		fprintf(stderr,"WARNING, in free_wait_act, run_task still is here.\n");
		act->run_task=NULL;
	}
	if(act->disp_info!=NULL)
	{
		g_string_free(act->disp_info,TRUE);
		act->disp_info=NULL;
	}
	if(act->cap_str!=NULL)
	{
		g_string_chunk_free(act->cap_str);
		act->cap_str=NULL;
	}
	if(act->cap_ptr!=NULL)
	{
		g_ptr_array_free(act->cap_ptr,TRUE);
		act->cap_ptr=NULL;
	}
	free(act);
#if 0
	printf("free wait act finished\n");
#endif
}

/***************************************************/
/* decode the received Lock to get the client Type */
/***************************************************/
void decode_lock(const char *nick, const char *remote_addr, const char *received_lock, int has_bzlist, int bcdc)
{
	unsigned int u;
	int i;
	int dec_lock=-1;
	int dec_pk=-1;
	char *client=NULL;
	double version=0;
	char *addr=NULL;
	char *versionadd=NULL;
	char *lock=NULL;
	char *pk=NULL;
	char *dp=NULL;
	GString *lock_test;
	GString *new_lock;

#if 0
	printf("decode lock start\n");
#endif
	lock_test=g_string_new(received_lock);
#if 0
	printf("%s decode lock: %s %s\n",my_name,nick,received_lock);
#endif
	/* get the ip from the remote-address */
	addr=strdup(remote_addr);
	dp=strchr(addr,':');
	*dp++='\0';
	/* forget the clientport ;) */

	/* split and redo lock...  - maybe this will keep from errors */
	new_lock=g_string_new("");
#if 0
 	printf("Lock change: ");
#endif
   for(i=0;i<lock_test->len;i++)
   {
      u=(((unsigned int)(lock_test->str[i]))&255);
#if 0
		printf("%i ",u);
#endif
      switch(u)
      {
         default:
                  new_lock=g_string_append_c(new_lock,u);
                  break;
      }
   }
#if 0
	printf("\n");
#endif
	dp=new_lock->str;
	lock=dp;
	
	/* trying to split the String into lock & pk part */

	dp=strstr(lock," Pk=");	
	if(dp!=NULL)
	{
		*dp++='\0';
		dp+=3;
		pk=dp;
	}

#if 0
	printf("extracted lock: '%s'\n",lock);
	printf("extracted pk  : '%s'\n",pk);
#endif
	i=0;
	while(lockstart[i]!=NULL)
	{
		if(!strncmp(lock,lockstart[i],strlen(lockstart[i])))
		{
			dec_lock=i;
			break;
		}
		i++;
	}
#if 0
	printf("client lock: %i\n",dec_lock);
#endif
	if(pk!=NULL)
	{
#if 0
		printf("pk is not NULL\n");
#endif
		i=0;
		while(pkstart[i]!=NULL)
		{
#if 0
			printf("pkstart: '%s'\n",pkstart[i]);
#endif
			if(!strncmp(pk,pkstart[i],strlen(pkstart[i])))
			{
				dec_pk=i;
				if(dec_lock==0 && dec_pk==6)
					client="DCGUI";
				else if(dec_lock==0 && dec_pk==7 && strlen(pk)==16)
					client="DCGUI";
				else if(dec_lock==0 && dec_pk==9)
				{
					client="QuickDC";
				}
				else if(dec_lock==0 && dec_pk==10)
				{
					client="JavaDC2";
				}
				else if((dec_pk==0 || dec_pk==5) && dec_lock==0)
				{
					char *t=NULL;
					char *pkdup=strdup(pk);
#if 0
					printf("decoded pk: %i\n",dec_pk);
#endif
					version=g_strtod(pkdup+strlen(pkstart[i]),&t);
					if(strcmp(t,"ABCABC")!=0)
					{ /* somethig different than the usual dc++ */
						if (strcmp(t,"ABCABCABC")==0)
						{
							if (version<=0.153 && version>=0.1)
								client="DC++ hiding version too old";
							else
								client="DC++ hiding";
						}
						else if (strlen(t)>6)
						{
#if 0
							printf("versionadd: %i\n",strlen(t));
#endif
							versionadd=t;
							if(strstr(versionadd,"ABCABC")!=NULL)
							{
								t=strstr(versionadd,"ABCABC");
								*t++='\0';
#if 0
								printf("decode versionadd: %s\n",versionadd);
#endif
								if(!strcmp(versionadd,"k") && (version==0.2501) && strcmp(t,"BCABC")==0)
									client="DC++ k";
								if(!strcmp(versionadd,".19") && version==0.22 && strcmp(t,"BCABC")==0)
									client="DC++ OP";
								else if(!strcmp(versionadd,"/*0.211A*/") && version==0.211 && strcmp(t,"BCABC")==0)
									client="CZDC";
								else if(strcmp(versionadd," PePeK Edition")==0 && strcmp(t,"BCABC")==0)
									client="DC++ PePeK Edition";
								else
								{
#if 0
									printf("decoded Client: DC++ mod\n");
#endif
									client="DC++ mod";
								}
							}
							else
							{
#if 0
								printf("decoded Client: DC++ mod\n");
#endif
								client="DC++ mod";
							}
						}
						else
							client="DC++ mod";
					}
					else if(dec_pk==5)
						client="LuDC";
					else if(bcdc==TRUE)
						client="BCDC";
					else if(version==0.2505)
						client="dc++ k";
					else
						client="DC++";
				}
				else if(dec_pk==1 && dec_lock==1)
				{
					client="DC++k hiding";
				}
				else if(dec_pk==2 || dec_pk==8)
				{
					client="mldonkey";
				}
				else if(dec_pk==3 && dec_lock==2)
            {
	            client="unknown hiding client with static Lock & PK";
            }
            else if(dec_pk==4 && dec_lock==-1)
            {
               client="KoalaDC";
            }
				else if(dec_lock==0)
				{
					client="unknown client using extended protocol";
				}
				break;
			}
			i++;
		}
		if ((strlen(pk)==16) && (dec_lock==0) && (dec_pk==-1) && (strstr(pk,"RDR1VJIQA=!")!=NULL))
			client="DCGUI";
		if(dec_pk==-1 && dec_lock==-1)
		{
			if (strlen(pk)==16)
			{
				if (strncmp(lock,pk,16)==0 || strncmp(lock,pk+1,15)==0)
					client="Unknown hiding client with constantly having Pk in Lock";
				else if ((strstr(lock,"RDR1VJ")!=NULL) && (strstr(pk,"RDR1VJ")!=NULL))
					client="DCGUI";
				else if (bcdc==TRUE)
					client="BCDC hiding";
				else if (strlen(lock)>44 && strlen(lock)<116)
					client="NM-DC";
				else
					client="unknown Client";
			}
			else if (strlen(pk)==17 && strlen(lock)==81 && !strcmp(pk,"I2HM=QfFp\'\']JPwg<") && !strcmp(lock,"EC,VuUxW/Z?CircNK*1mh)L<XPZRy<mLZ>4PSZ:Fqi:(4G:mYp(c_1M@MAQUjG@FuJ42o8@Pb:kS:zj4e"))
				client="PK17 statisch";
			else if ((strlen(pk)==15) && (strspn(pk,"abcdefghijklmnopqrstuvwxyz")==15) && (strspn(lock,"abcdefghijklmnopqrstuvwxyz")==strlen(lock)))
					client="NM-DC OS-X";
			else if ((strlen(pk)>50) && (strstr(pk,"DCN096")) && (strstr(pk,"DCN036")) && (strstr(pk,"DCN000")))
				client="DC++ Blue";
#if 0
			printf("lnge lock: %i\n",strlen(lock));
			printf("lnge pk: %i\n",strlen(pk));
#endif
		}
	}
	else if(pk==NULL && strlen(lock)>50)
	{
		client="DCTC";
	}
	else
	{
		client="unknown Client";
	}
	if (client==NULL)
		client="unknown";

#if 0
	printf("decode lock: %s, %s, %f, %s, %s, %i\n", nick, client, version, lock, pk, has_bzlist);
#endif
	set_xtra_information_cnx(nick,0,addr,client,version,versionadd,lock,pk,has_bzlist,1,0,NULL,0,NULL,time(NULL),NULL,0,FALSE);
	g_string_free(lock_test,TRUE);
	g_string_free(new_lock,TRUE);
#if 0
	printf("decode lock finished\n");
#endif
}

/***************************************************************************/
/* create a lock inside the 'created_lock' array and send it on the socket */
/***************************************************************************/
static int send_a_lock(int sck, char *created_lock)
{
	gchar *v;
	int ret;
#if 0
	printf("send lock start\n");
#endif
	created_lock="EXTENDEDPROTOCOLABCABCABCABCABCABC Pk=DCPLUSPLUS0.22ABCABC|";
	v=g_strconcat("$Lock ",created_lock,NULL);

	ret=(send(sck,v,strlen(v),MSG_NOSIGNAL)!=strlen(v));
	g_free(v);
	if(ret)
		return 1;       /* fails */
#if 0
	printf("send_lock finished\n");
#endif
	return 0;               /* ok */
}

/******************************/
/* thread managing connect_me */
/******************************/
static void *connect_me_thread(WAIT_ACT *act)
{
	GString *input=NULL;
	char c_lock[256];
	GString *rec_lock=NULL;
	int has_bzlist=0;
	int bcdc=FALSE;
#if 0
	printf("connect me thread started: '%lu'\n",(unsigned long)act);
#endif

	while(act->thread_id==0)
		usleep(1000);           /* wait until the main process has set the thread_id in act */
#if 0
	printf("connect_me_thread: '%lu' continued\n",(unsigned long)act);
#endif
	act->running=1;
	act->last_touch=time(NULL);
#if 0
	printf("connect_me_thread: '%i'\n",act->sock_fd);
#endif
	/* add act to the waiting task array */
	G_LOCK(waiting_action);
	g_ptr_array_add(waiting_action,act);
	G_UNLOCK(waiting_action);
#if 0
	printf("connect_me_thread: '%lu' act added\n",(unsigned long)act->thread_id);
#endif
	/* send our name */
	if(send_nick(act->sock_fd))
	{
#if 0
		printf("connect_me_thread: %lu fail to send nick\n",(unsigned long)act->thread_id);
#endif
		goto thread_over;
	}
#if 0
	printf("connect_me_thread: %lu nick sent\n",(unsigned long)act->thread_id);
#endif
	if(send_a_lock(act->sock_fd,c_lock))
	{       /* send a lock to the remote side */
#if 0
		printf("connect_me_thread: %lu fail to send lock\n",(unsigned long)act->thread_id);
#endif
		goto thread_over;
	}
#if 0
	printf("connect_me_thread: %lu lock sent\n",(unsigned long)act->thread_id);
#endif
	input=get_a_dc_line(act->sock_fd);                              /* get the "$MyNick line */
	if(input==NULL)
	{
#if 0
		printf("connect_me_thread: %lu no incoming data\n",(unsigned long)act->thread_id);
#endif
		input=get_a_dc_line(act->sock_fd);
		if(input==NULL)
		{
			printf("connect_me_thread: %s no incoming data2\n",act->remote_addr->str);
			goto thread_over;
		}
		printf("connect_me_thread: lets see whats in the next line...: %s\n",input->str);
	}
#if 0
	printf("connect_me_thread got: %s from %s\n",input->str,act->remote_addr->str);
#endif
	/* we should have received "$MyNick xxxx" */
	if(strncmp(input->str,"$MyNick ",8))
	{
		GString *fehler;
		fehler=g_string_new("");
		if(input!=NULL)
			input=g_string_truncate(input,input->len-1);
		g_string_sprintf(fehler,"Connect me Thread got invalid $MyNick from %s. Thats what I got: %s\r\n",act->remote_addr->str,input->str);
#if 0
		printf("connect_me_thread: %lu $Nick not found\n",(unsigned long)act->thread_id);
#endif
		if(input==NULL)
		{
			g_string_free(fehler,TRUE);
			goto thread_over;
		}
		if(input!=NULL)
		{
			g_string_free(input,TRUE);
			input=NULL;
		}
		/* BCDC is sending an incalid line before sending the $MyNick !!! */
		/* so lets check the next line */
		input=get_a_dc_line(act->sock_fd);
		if(strncmp("$MyNick ",input->str,8))
		{
			if(input==NULL)
				g_string_sprintfa(fehler,"no following line");
			else
			{
				input=g_string_truncate(input,input->len-1);
				g_string_sprintfa(fehler,"invalid following line: %s",input->str);
			}
			send_op_message(fehler->str,my_name);
			g_string_free(fehler,TRUE);
			goto thread_over;
		}
		g_string_sprintfa(fehler,"correct next line recieved: %s",input->str);
		fehler=g_string_truncate(fehler,fehler->len-1);
		bcdc=TRUE;
		g_string_free(fehler,TRUE);
	}

	/* My nick is here */
	input=g_string_erase(input,0,8);                	/* remove the "$MyNick " at the beginning */
	input=g_string_truncate(input,input->len-1);            /* remove the trailing | */

	G_LOCK(waiting_action);
	act->remote_nick=input;                                 /* set the remote nick */
	G_UNLOCK(waiting_action);
	
	input=get_a_dc_line(act->sock_fd);              	/* get the $Lock line */
	if(input==NULL)
	{
#if 0
		printf("connect_me_thread: %lu $Lock not found\n",(unsigned long)act->thread_id);
#endif
		goto thread_over;
	}
	if(strncmp("$Lock ",input->str,6))
	{
#if 0
		printf("connect_me_thread: something else than $Lock received...\n");
#endif
		goto thread_over;
	}
#if 0
	printf("connect_me_thread: %lu %s\n",(unsigned long)act->thread_id,input->str);
#endif
	input=g_string_erase(input,0,6);			/* remove the "$Lock " at the beginning */
	input=g_string_truncate(input,input->len-1);            /* remove the trailing | */
	rec_lock=input;

	/* Koala-DC doesn't give more answers so break here */
	if(strstr(rec_lock->str,"Pk=KoalaDC"))
	{
		goto decode;
	}	
	/* query if bzlist is supported */
	redo:
	input=get_a_dc_line(act->sock_fd);              	/* get the $Supports result*/
	if(input!=NULL)
	{
#if 0
		printf("connect_me_thread: %lu %s\n",(unsigned long)act->thread_id,input->str);
#endif
		if(!strncmp(input->str,"$Supports",9))
			has_bzlist=1;
		else if(strncmp(input->str,"$Direction",10))
		{
			printf("connect_me_thread Lock-addon ? : %s %s\n",act->remote_nick->str,input->str);
			rec_lock=g_string_append_c(rec_lock,'_');
			input=g_string_truncate(input,input->len-1);            /* remove the trailing | */
			rec_lock=g_string_append(rec_lock,input->str);
			g_string_free(input,TRUE);
			bcdc=TRUE;
			input=NULL;
			goto redo;
		}
		g_string_free(input,TRUE);
		input=NULL;
	}
	decode:
#if 0
	printf("try to decode lock\n");
#endif
	decode_lock(act->remote_nick->str,act->remote_addr->str,rec_lock->str,has_bzlist,bcdc);
	/* thread is over */
	thread_over:
#if 0
	printf("thread over\n");
#endif
	G_LOCK(waiting_action);
	g_ptr_array_remove_fast(waiting_action,act);
	G_UNLOCK(waiting_action);
	free_wait_act(act);
#if 0
	printf("connect_me_thread: '%s' finished\n",c_lock);
#endif
	pthread_exit(NULL);
}

/********************************************/
/* someone tries to connect to the com port */
/********************************************/
void manage_com_port(void *dummy)
{
	int sock_fd;
	WAIT_ACT *nw_act;
	pthread_attr_t thread_attr;
	struct sockaddr_in remote;
	int x=sizeof(remote);

#if 0
	printf("manage com port started\n");
#endif
	sock_fd=accept(in_sck,(struct sockaddr*)&remote,&x);
	if(sock_fd==-1)
	{
		printf("manage_com_port - someone fails to connect to com port\n");
		return;
	}
	/* ok, remote host connect to the newly created socket */
	nw_act=malloc(sizeof(WAIT_ACT));
	if(nw_act==NULL)
	{
#if 0
		printf("manage_com_port - malloc failed\n");
#endif
		shutdown(sock_fd,2);
		close(sock_fd);
		return;
	}

#if 0
	printf("manage_com_port - creating thread info %lu\n",(unsigned long)nw_act);
#endif
	nw_act->running=3;                      /* thread init */
	nw_act->cnx_type=CNX_ON_ACCEPT;
	nw_act->last_touch=time(NULL);
	nw_act->thread_id=0;
	nw_act->sock_fd=sock_fd;
	nw_act->remote_nick=NULL;

	/* remote address */
	nw_act->remote_addr=g_string_new("");
	g_string_sprintf(nw_act->remote_addr,"%s:%hu", inet_ntoa(remote.sin_addr),ntohs(remote.sin_port));

	nw_act->run_task=NULL;
	nw_act->disp_info=NULL;

	/* remote client capabilities */
	nw_act->cap_str=NULL;
	nw_act->cap_ptr=NULL;

	/* create the new thread */
	pthread_attr_init (&thread_attr);
	pthread_attr_setdetachstate(&thread_attr, PTHREAD_CREATE_DETACHED);
	if(pthread_create(&(nw_act->thread_id),&thread_attr, (void*)connect_me_thread,nw_act)!=0)
	{
		if(errno==EINTR)
		{
#if 0
			printf("manage_com_port - mcp:pthread_create failed - MEMORY NOT FREED TO AVOID CRASH\n");
#endif
		}
		else
		{
#if 0
			printf("manage_com_port - mcp:pthread_create failed\n");
#endif
			free(nw_act);
			shutdown(sock_fd,2);
			close(sock_fd);
			return;
		}
	}
#if 0
	printf("manage com port finished\n");
#endif
	/* nw_act will be freed by the thread */
}

static void *in_com_fnc(void *dummy)
{
	int ln;
	int n;
	/* int asearch; */
	int lsearch=0;
	fd_set rd,wd;
	struct timeval tv;
   time_t gl_cur_time;
   time_t last_lock_check;
	time_t last_heartbeat=time(NULL);
	time_t last_autosearch=time(NULL);
	time_t next_autosearch=time(NULL);

	in_sck=_x_tcp(0);
	
	if(in_sck==-1)
	{
		fprintf(stderr,"slot_autosearch_fnc: fail to create TCP socket.\n");
	}
	else
	{
		struct sockaddr_in my_tcp;
		int len_my_tcp=sizeof(my_tcp);
		last_lock_check=time(NULL);

		if(getsockname(in_sck,(void*)&my_tcp,&len_my_tcp)!=0)
		{
			perror("getsockname fail");
			shutdown(in_sck,2);
			close(in_sck);
		}
		else
		{
			sprintf(my_incom,"%s:%hu",my_hostip,ntohs(my_tcp.sin_port));
			listen(in_sck,64);
		}
        
		while(1)
		{
			n=-1;
			gl_cur_time=time(NULL);
			FD_ZERO(&rd);
			FD_ZERO(&wd);

			if(in_sck!=-1)                  /* com port exists ? */
			{
				FD_SET(in_sck,&rd);
				n=max(n,in_sck);
			}
			tv.tv_sec=1;
			tv.tv_usec=0;
			ln=select(n+1,&rd,&wd,NULL,&tv);
			if(ln>0)
			{
				if((in_sck!=-1)&&(FD_ISSET(in_sck,&rd)))
				{       /* someone wants to connect to this client ? */
					manage_com_port(NULL);
				}
			}
			else if(ln==-1)
			{
				if(errno!=EINTR)
					break;
			}
			if ((gl_cur_time - last_lock_check) > 10)
			{
				int i;
				XTRA_INFO *xi;
				last_lock_check=time(NULL);
#if 0
				printf("last lock check started\n");
#endif
				again:
#if 0
				printf("last lock check trying to lock hub user list\n");
#endif
				G_LOCK(hub_user_list);
#if 0
				printf("last lock check locked hub user list\n");
#endif
				for (i=0;i<hub_user_list->len;i++)
				{
					xi=g_ptr_array_index(hub_user_xtra_info,i);
					if(xi!=NULL)
					{
						if((xi->need_scan!=0) && (xi->got_lock<3) && ((gl_cur_time - xi->last_call) > 90))
						{
							char *nickname;
							nickname=g_ptr_array_index(hub_user_list,i);
							if ((strcmp(nickname,my_name)!=0) && (strcmp(nickname,"Hub-Security")!=0))
							{
								GString *out;
						      out=g_string_new("");
					     		g_string_sprintf(out,"$ConnectToMe %s %s",nickname,my_incom);
					      	G_LOCK(hub_com);
					      	send_dc_line(hub_com,out->str,NULL);
					      	G_UNLOCK(hub_com);
#if 0
					      	printf("%s in_com_function: %s\n",my_name,out->str);
#endif
      						g_string_free(out,TRUE);
								xi->last_call=time(NULL);
								g_ptr_array_index(hub_user_xtra_info,i)=xi;
							}
							if(((gl_cur_time - xi->lock_time) > 1800) && (strcmp(nickname,my_name)!=0) && (strcmp(nickname,"Hub-Security")!=0))
							{
								GString *out;
								out=g_string_new("");
								g_string_sprintf(out,"<%s> WARNUNG kein Lock von %s nach 30min !!!",my_name,nickname);
								xi->lock_time=gl_cur_time;
								g_ptr_array_index(hub_user_xtra_info,i)=xi;
#if 0
								printf("last lock check trying to unlock hub user list for 30min again\n");
#endif
								G_UNLOCK(hub_user_list);
#if 0
								printf("last lock check unlocked hub user list for again\n");
#endif
								send_op_message(out->str,my_name);
								g_string_free(out,TRUE);
								goto again;
							}
							if(((gl_cur_time - xi->lock_time) > 1200)	&& (xi->warnmsg_send==TRUE))
							{
#if 0
								printf("last lock check trying to unlock hub user list for warnmsg send again\n");
#endif
								G_UNLOCK(hub_user_list);
#if 0
								printf("last lock check unlocked hub user list for warnmsg send again\n");
#endif
								if(remove_user_to_user_list(nickname))
								{
									G_LOCK(hub_com);
									kick_user(hub_com,my_name,nickname,"Du wurdest gewarnt - DC-GUI hiding...");
									G_UNLOCK(hub_com);
								}
								goto again;
							}	
						}
					}
				}
#if 0
				printf("last lock check trying to unlock hub user list\n");
#endif
				G_UNLOCK(hub_user_list);
#if 0
				printf("last lock check unlocked hubuser list - finished\n");
#endif
			}
			if ((gl_cur_time - last_autosearch) > (900+(lsearch*10)))
			{
#if 0
				printf("last autosearch start\n");
#endif
				if(lsearch<search_to_start->len)
				{
					AUTOSEARCH *as;
					if(lsearch==0)
						next_autosearch=time(NULL);
         				as=&(g_array_index(search_to_start,AUTOSEARCH,lsearch));
					if(as->global_periodic)
					{
						GString *output;
						output=g_string_new("");
         			g_string_sprintf(output,"$Search %s %s",as->search_result_return_address,as->search_query->str);
#if 0
         			printf("%s global myinfo handler sends: '%s'\n",my_name,output->str);
#endif
         			G_LOCK(hub_com);
         			send_dc_line(hub_com,output->str,NULL);
         			G_UNLOCK(hub_com);
						g_string_free(output,TRUE);
					}
					lsearch++;
				}
				else
				{
					lsearch=0;
					last_autosearch=next_autosearch;
				}
#if 0
				printf("last autosearch finished\n");
#endif
      	}
			if ((gl_cur_time - last_heartbeat) > 30)
			{
#if 0
				printf("heartbeat start\n");
#endif
            last_heartbeat = gl_cur_time;
            G_LOCK(hub_com);
            send_dc_line(hub_com,"|",NULL);
            G_UNLOCK(hub_com);
#if 0
				printf("heartbeat finished\n");
#endif
			}
		}
	}
	pthread_exit(NULL);
}

static void start_in_com()
{
	pthread_t tid; 
	pthread_attr_t thread_attr;
	pthread_attr_init (&thread_attr);
	pthread_attr_setdetachstate(&thread_attr, PTHREAD_CREATE_DETACHED);
	if(pthread_create(&tid,&thread_attr,(void*)in_com_fnc,NULL)!=0)
	{
		fprintf(stderr,"Fail to create in_com thread.\n");
		exit(1);
	}
}


/***************************************************************/
/* this message is received each time a user changes his share */
/*****************************************************************************************/
/* when a user enters the hub, we send him all the query having the on_incoming flag set */
/*****************************************************************************************/
static int global_myinfo_fnc(void *xtra_param, const char *nickname, const char *description, const char *cnxtype, unsigned char flag, const char *email, unsigned long long amount)
{
	int i;
	char *t=NULL;
	double d_version=0;
	char *m_version=NULL;
	char *d_client=NULL;
	char *reason=NULL;
	char *cmode=NULL;
	char *hubs=NULL;
	char *slots=NULL;
	char *nslots=NULL;
	char *line=NULL;
	char *down=NULL;
	/* char *dcplusrest=NULL; */
	int is_op=FALSE;
	int low_err=FALSE;
	int dc_mod_ok=FALSE;
	int hubnum=0;
	int slotnum=0;
	int nslotsnum=0;
	int linenum=0;
	int downnum=0;
	int dcfake=FALSE;
	int userkicked=FALSE;
	int clientmode=FALSE;
	int hubcount=FALSE;
	int slotcount=FALSE;
	int xtraslot=FALSE;
	int uplimit=FALSE;
	int downlimit=FALSE;
	int exceed_limit=FALSE;
	GString *dcplusfnd=NULL;
	GString *dcguifnd=NULL;
	GString *koalafnd=NULL;
	GString *nmdctwofnd=NULL;

	const GString dcplusplus={"<++",strlen("<++")};
	const GString dcgui={"<DCGUI V:",strlen("<DCGUI V:")};
	const GString koala={"[KDC V:",strlen("[KDC V:")};
	const GString nmdctwo={"<DC V:",strlen("<DC V:")};
#if 0
	printf("%s global myinfo fnc start for %s\n",my_name,nickname);
#endif
	dcplusfnd=g_string_new(my_strbackstr(&dcplusplus,description));
	dcguifnd=g_string_new(my_strbackstr(&dcgui,description));
	koalafnd=g_string_new(my_strbackstr(&koala,description));
	nmdctwofnd=g_string_new(my_strbackstr(&nmdctwo,description));
#if 0
	printf("myinfo funktion trying to lock hub user list\n");
#endif
	G_LOCK(hub_user_list);
#if 0
	printf("myinfo funktion locked hub user list\n");
#endif
	if(hub_op_list!=NULL)
	{
   	for(i=0;i<hub_op_list->len;i++)
   	{
			if(!strcmp(nickname,g_ptr_array_index(hub_op_list,i)))
			{
				is_op=TRUE;                 /* we have found it */
				break;
			}
		}
	}
#if 0
	printf("myinfo funktion trying to unlock hub user list\n");
#endif
	G_UNLOCK(hub_user_list);
#if 0
	printf("myinfo funktion unlocked hub user list\n");
#endif


	if((my_strbackstr(&dcplusplus,description)!=NULL) || (my_strbackstr(&dcgui,description)!=NULL) || (my_strbackstr(&koala,description)!=NULL) || (my_strbackstr(&nmdctwo,description)!=NULL))
	{
		int leave_decode=FALSE;
#if 0
		printf("%s global myinfo fnc got dc++, dcgui or KoalaDC: %s\n",my_name,dcplusfnd->str);
#endif
		/*****************************************************/
		/* dc++ info decode                                  */
		/*****************************************************/
		/* the dc++ string hast following structure          */
		/* <++ V:a.aaa,M:x,H:yyyy,S:zzzz>                    */
		/* additionally there can be an						     */
		/* ',L:bbbb' or ',B:bbbb' or ',U:bbbb' (Uploadspeed) */
		/* or																  */
		/* ',O:cccc' (OpenAdditional Slots)						  */
		/* behind the 'S:'-tag										  */
		/*****************************************************/
		/* a.aaa is the Version                              */
		/* x     is the Connect Mode (A - Active)            */
		/*                           (P - Passive)           */
		/*                           (5 - Socks5)				  */
		/* yyyy  is the number of Hubs connected to          */
		/* zzzz  is the number of slots offered              */
		/* bbbb  is a line-value			     					  */
		/*****************************************************/
		if(my_strbackstr(&dcplusplus,description)!=NULL)
		{
			char *version;
			t=dcplusfnd->str+strlen("<++");
			version=t;
			if(t!=NULL)
			{
				char *dp;
				if(!strncmp(version,"LuDC",4))
				{
					d_client="LuDC";
				}
				if(strncmp(version," V:",3))
				{
					if(strstr(version,"V:")==NULL)
					{
						d_client="NM-DC";
						leave_decode=TRUE;
					}
					else
						d_client="DC++ mod";
				}

				if(leave_decode==FALSE)
				{
					dp=strstr(version,"V:");
					if(dp!=NULL)
					{
						dp++;
						*dp++='\0';
						d_version=g_strtod(dp,&t);
						if(d_client==NULL)
							d_client="DC++";
					}
					else
					{
						dcfake=TRUE;
						d_client="NM-DC";
						reason="check description";
					}
				}
			}
		}
		else if(my_strbackstr(&dcgui,description)!=NULL)
		{
			d_version=g_strtod(dcguifnd->str+strlen("<DCGUI V:"),&t);
			d_client="DCGUI";
		}
		else if(my_strbackstr(&koala,description)!=NULL)
		{
			d_version=g_strtod(koalafnd->str+strlen("[KDC V:"),&t);
			d_client="KoalaDC";
		}
		else if(my_strbackstr(&nmdctwo,description)!=NULL)
		{
			d_version=g_strtod(nmdctwofnd->str+strlen("<DC V:"),&t);
			d_client="NMDC2";
		}
		if(leave_decode==FALSE)
		{
			if(t!=NULL && dcfake==FALSE)
			{
				m_version=t;
				t=strchr(m_version,',');
				if(t!=NULL)
					*t++='\0';
				else
				{
					dcfake=TRUE;
				}
				if((d_version==0 || d_version>1) && strcmp(d_client,"NMDC2")!=0)
				{
#if 0
					printf("descriptiondecoding version=%f - fake\n",d_version);
#endif
					dcfake=TRUE;
					reason="version=0";
				}
#if 0
				printf("%s global myinfo fnc got dc++Version: %f\n",my_name,d_version);
#endif
				if(strlen(m_version)!=0 && !strcmp(d_client,"DC++") && dcfake==FALSE)
				{
					/* something in m_version */
					i=0;
					d_client="DC++ mod";
					while(known_mod_dc[i]!=NULL)
					{
						if(!strcmp(known_mod_dc[i],m_version))
						{
							d_client="DC++ mod OK";
							dc_mod_ok=TRUE;
							break;
						}
						i++;
					}
				}
				else if(strlen(m_version)!=0 && !strcmp(d_client,"DCGUI") && dcfake==FALSE)
				{
	         	char *dcgui_va;
					char *s;
      	   	int y;

         		char keysetb[]="1234567890";

					dcgui_va=strdup(m_version);
	         	s=strpbrk(dcgui_va,keysetb);
   	      	y=atoi(s);
      	   	*s++='\0';
					if ((d_version < 0.2) || (d_version==0.2 && strcmp(dcgui_va,"beta")==0) || (d_version==0.2 && strcmp(dcgui_va,"rc")==0 && y<4))
         		{
						G_LOCK(hub_com);
						send_private_chat_message(hub_com,my_name,(char *)nickname,"You are using a buggy DCGUI-Version - please update to an actual version...",1);
						G_UNLOCK(hub_com);
						if(remove_user_to_user_list((char *)nickname))
						{
            			G_LOCK(hub_com);
	            		/* kick_user(hub_com,my_name,(char *)nickname,"You are using a buggy DCGUI-Version - please update to an actual version..."); */
   	         		G_UNLOCK(hub_com);
						}
						remove_user_to_user_list((char *)nickname);
					}
				}
				if(userkicked==FALSE && dcfake==FALSE)
				{
					if(strstr(t,"M:")!=NULL)
						clientmode=TRUE;
					if(strstr(t,"H:")!=NULL)
						hubcount=TRUE;
					if(strstr(t,"S:")!=NULL)
						slotcount=TRUE;
					if(strstr(t,"O:")!=NULL || strstr(t,"N9")!=NULL)
						xtraslot=TRUE;
					if(strstr(t,"L:")!=NULL || strstr(t,"B:")!=NULL || strstr(t,"U:")!=NULL)
						uplimit=TRUE;
					if(strstr(t,"D:")!=NULL)
						downlimit=TRUE;
					if(t!=NULL && clientmode==TRUE && dcfake==FALSE)
					{
						cmode=t;
						if(strncmp(cmode,"M:",2))
						{
/* #if 0 */
							printf("descriptiondecoding mode 'M:' not found - fake\n");
/* #endif */
							dcfake=TRUE;
							reason="mode wrong place";
						}
						else
						{
							cmode=t+2;
							if(strchr(cmode,',')==NULL)
							{
/* #if 0 */
								printf("descriptiondecoding mode description-over");
/* #endif */
								dcfake=TRUE;
								reason="mode description over";
							}
							else
							{
								t=strchr(cmode,',');
								*t++='\0';
								/* cmode should be just one character 'A' for active or 'P' for passive or '5' for Socks5 */
								if(((strlen(cmode)!=1) || (strcspn(cmode,"AP5")!=0)) && dcfake==FALSE)
								{
/* #if 0 */
									printf("descriptiondecoding mode got fake\n");
/* #endif */
									dcfake=TRUE;
									reason="mode wrong character";
								}
								else
								{
#if 0
									printf("%s global myinfo fnc got dc++Connection: %s\n",my_name,cmode);
#endif
								}
							}
						}
					}
					else if(clientmode==FALSE && dcfake==FALSE)
					{
/* #if 0 */
						printf("descriptiondecoding mode got fake\n");
/* #endif */
						dcfake=TRUE;
						reason="no mode found";
					}
					if(t!=NULL && hubcount==TRUE && dcfake==FALSE)
					{
						hubs=t;
						if(strncmp(hubs,"H:",2))
						{
/* #if 0 */
							printf("descriptiondecoding hubs 'H:' not found - fake\n");
/* #endif */
							dcfake=TRUE;
							reason="hub wrong place";
						}
						else
						{
							hubs=t+2;
							if(strchr(hubs,',')==NULL)
							{
/* #if 0 */
								printf("descriptiondecoding hubs description-over");
/* #endif */
								dcfake=TRUE;
							reason="hubs description over";
							}
							else
							{
								if(d_version>=0.24 && strchr(hubs,'/')!=NULL && (d_client=="DC++ mod OK" || d_client=="DC++" || d_client=="NMDC2"))
								{
									char *reghubs=NULL;
									char *ophubs=NULL;
									t=strchr(hubs,'/');
									if (t==NULL)
										dcfake=TRUE;
									else
									{
										*t++='\0';
										reghubs=t;
										t=strchr(reghubs,'/');
										if (t==NULL)
											dcfake=TRUE;
										else
										{
											*t++='\0';
											ophubs=t;
											t=strchr(ophubs,',');
											if (t==NULL)
												dcfake=TRUE;
											else
												*t++='\0';
										}
									}
									if((strlen(hubs)==0 || strspn(hubs,"0123456789")!=strlen(hubs)) && dcfake==FALSE)
									{
/* #if 0 */
										printf("descriptiondecoding hubs got fake\n");
/* #endif */
										dcfake=TRUE;
										reason="wrong hub number";
									}
									else if(dcfake==FALSE)
									{
										hubnum = atoi (hubs);
#if 0
										printf("%s global myinfo fnc got dc++ Hubs: %u\n",my_name,hubnum);
#endif
									}
									if((strlen(reghubs)==0 || strspn(reghubs,"0123456789")!=strlen(reghubs)) && dcfake==FALSE)
									{
/* #if 0 */
										printf("descriptiondecoding reghubs got fake\n");
/* #endif */
										dcfake=TRUE;
										reason="wrong reghub number";
									}
									else if(dcfake==FALSE)
									{
										hubnum = hubnum+atoi(reghubs);
#if 0
										printf("%s global myinfo fnc got dc++ RegHubs: %u\n",my_name,hubnum);
#endif
									}
									if((strlen(ophubs)==0 || strspn(ophubs,"0123456789")!=strlen(ophubs)) && dcfake==FALSE)
									{
/* #if 0 */
										printf("descriptiondecoding ophubs got fake\n");
/* #endif */
										dcfake=TRUE;
										reason="wrong reghub number";
									}
									else if(dcfake==FALSE)
									{
										hubnum = hubnum+atoi(ophubs);
#if 0
										printf("%s global myinfo fnc got dc++ OpHubs: %u\n",my_name,hubnum);
#endif
									}
								}
								else
								{
									t=strchr(hubs,',');
									*t++='\0';
									if((strlen(hubs)==0 || strspn(hubs,"0123456789")!=strlen(hubs)) && dcfake==FALSE)
									{
/* #if 0 */
										printf("descriptiondecoding hubs got fake\n");
/* #endif */
										dcfake=TRUE;
										reason="wrong hub number";
									}
									else
									{
										hubnum = atoi (hubs);
#if 0
					      			printf("%s global myinfo fnc got dc++ Hubs: %u\n",my_name,hubnum);
#endif
									}
								}
							}
						}
					}
					else if(hubcount==FALSE && dcfake==FALSE)
					{
						if(strcmp(d_client,"KoalaDC")!=0)
						{
/* #if 0 */
							printf("descriptiondecoding hubs got fake\n");
/* #endif */
							dcfake=TRUE;
							reason="no hub found";
						}
					}
					if(t!=NULL && slotcount==TRUE  && dcfake==FALSE)
					{
						slots=t;
						if(strncmp(slots,"S:",2))
						{
/* #if 0 */
							printf("descriptiondecoding slots 'S:' not found - fake\n");
/* #endif */
							dcfake=TRUE;
							reason="wrong slot place";
						}
						else
						{
							slots=t+2;
#if 0
							printf("slots: %s\n",slots);
#endif
							if (strchr(slots,'+')!=NULL)
							{
								t=strchr(slots,'+');
								*t++='\0';
							}
							else if (strchr(slots,',')!=NULL)
							{
								t=strchr(slots,',');
								*t++='\0';
							}
							else if (strchr(slots,'>')!=NULL)
							{
								t=strchr(slots,'>');
								*t++='\0';
							}
							else if (strchr(slots,']')!=NULL)
							{
								t=strchr(slots,']');
								*t++='\0';
							}
							else if (strlen(t)==strlen(slots)+2)
							{
								/* nothing behind slot */
								t=NULL;
							}
							if(strlen(slots)==0 || strspn(slots,"0123456789")!=strlen(slots))
							{
								if((strcmp(slots,"X")!=0) && (strcmp(d_client,"DCGUI")!=0))
								{
/* #if 0 */
									printf("descriptiondecoding slot got fake\n");
/* #endif */
	   	         			dcfake=TRUE;
   	   	      			reason="wrong slot number";
	      	   			}
							}
   	   				else if(strcmp(slots,"X")!=0 && dcfake==FALSE)
							{
         					slotnum = atoi (slots);
#if 0
	      					printf("%s global myinfo fnc got dc++ Slots: %u\n",my_name,slotnum);
#endif
							}
						}
					}
					else if (slotcount==FALSE  && dcfake==FALSE)
					{
/* #if 0 */
						printf("descriptiondecoding slots got fake\n");
/* #endif */
						dcfake=TRUE;
						reason="no slot found";
					}
					if(t!=NULL && xtraslot==TRUE && dcfake==FALSE)
					{
						nslots=t;
#if 0
						printf("nslots: %s\n",nslots);
#endif
						if(strncmp(nslots,"O:",2) && strncmp(nslots,"N9",2))
						{
/* #if 0 */
							printf("descriptiondecoding xtraslot 'O:' or 'N9' not found - fake\n");
/* #endif */
							low_err=TRUE;
							reason="wrong xtraslot place";
      	   		}
						else
						{
							nslots=t+2;
#if 0
							printf("nslots: %s\n",nslots);
#endif
							if(strchr(nslots,',')!=NULL)
							{
								t=strchr(nslots,',');
								*t++='\0';
							}
							else if(strchr(nslots,'>')!=NULL)
							{
								t=strchr(nslots,'>');
								*t++='\0';
							}
							else if (strlen(t)==strlen(nslots)+2)
							{
								/* nothing behind nslot */
								t=NULL;
							}
							if(strlen(nslots)==0 || strspn(nslots,"0123456789")!=strlen(nslots))
							{
/* #if 0 */
   	              	   printf("descriptiondecoding nslot got fake\n");
/* #endif */
                     	low_err=TRUE;
	                     reason="wrong slot number";
							}
							else
							{
								nslotsnum = atoi (nslots);
#if 0
								printf("%s global myinfo fnc got dc++ Slots: %u\n",my_name,slotnum);
#endif
							}
						}
					}
					if(t!=NULL && uplimit==TRUE && dcfake==FALSE && low_err==FALSE)
					{
						line=t;
						if((strncmp(line,"L:",2)!=0) && (strncmp(line,"B:",2)!=0) && (strncmp(line,"U:",2)!=0))
						{
/* #if 0 */
							printf("descriptiondecoding line 'L:, B: or U:' not found - fake\n");
/* #endif */
							low_err=TRUE;
							reason="none or invalid line-tag found";
						}
						else
						{
							line=t+2;
							if(strchr(line,',')!=NULL)
							{
								t=strchr(line,',');
								*t++='\0';
							}
							else if(strchr(line,'>')!=NULL)
							{
								t=strchr(line,'>');
								*t++='\0';
							}
							else if (strlen(t)==strlen(line)+2)
							{
								/* nothing behind line */
								t=NULL;
							}
							if(strlen(line)==0 || strspn(line,".0123456789")!=strlen(line))
							{
								if(strcmp(line,"*")!=0 && strcmp(line,"X")!=0)
								{
/* #if 0 */	
									printf("descriptiondecoding line got fake\n");
/* #endif */
									low_err=TRUE;
									reason="wrong line number";
								}
							}
							else
							{
								linenum = atoi (line);
								if(linenum<my_uplimit)
									exceed_limit=TRUE;
							}
					
						}
					}
					if(t!=NULL && downlimit==TRUE && dcfake==FALSE && low_err==FALSE)
      	   	{
         	   	down=t;
	         	   if(strncmp(down,"D:",2)!=0)
   	         	{
/* #if 0 */
	               	printf("descriptiondecoding line 'D:' not found - fake\n");
/* #endif */
	   	            low_err=TRUE;
   	   	         reason="none or invalid line-tag found";
      	   	   }
         	   	else
            		{
               		down=t+2;
               		if(strchr(down,'>')!=NULL)
	               	{
   	               	t=strchr(down,'>');
      	            	*t++='\0';
         	      	}
							else if (strlen(t)==strlen(down)+2)
							{
								/* nothing behind down */
								t=NULL;
							}
            	   	if(strlen(down)==0 || strspn(down,"0123456789")!=strlen(down))
               		{
/* #if 0 */
                  	   printf("descriptiondecoding down got fake\n");
/* #endif */
                     	low_err=TRUE;
	                     reason="wrong down number";
   	            	}
	   	            else
   	   	            downnum = atoi (down);
      	   	   }
	         	}
				}
				if(t!=NULL)
				{
					char *dcplusrest=NULL;
					dcplusrest=t;
					/* where should be nothing behind the dc++-description */
					if(strlen(dcplusrest)!=0)
					{ 
/* #if 0 */
						printf("descriptiondecoding rest got fake '%s'\n",dcplusrest);
/* #endif */
						dcfake=TRUE;
						reason="something behind dc++/dcgui tag";
					}
				}
		
				if (dcfake==TRUE || low_err==TRUE)
				{
					/* int i;
					char *op_name; */
					GString *out;
					out=g_string_new("");
					g_string_sprintf(out,"<%s> myinfo: Check %s for modified %s tag: %s",my_name,nickname,d_client,reason);
/* #if 0 */
					printf("%s - No Faking DC++ clients...\n", nickname);
/* #endif */
					send_op_message(out->str,my_name);
					g_string_free(out,TRUE);
				}
				if((hubnum>my_maxhubs || slotnum>my_maxslots || slotnum<my_minslots ) && dcfake==FALSE)
				{
#if 0
					printf("%s - DC++/DCGUI Rules-break\n", nickname);
#endif
					exceed_limit=TRUE;
				}
			}
		}
	}
	else
		d_client="NM-DC";

#if 0
	printf("myinfo setting xtra information\n");
#endif
	set_xtra_information_cnx((char *)nickname,0,NULL,NULL,0,NULL,NULL,NULL,0,0,1,d_client,d_version,m_version,time(NULL),NULL,amount,exceed_limit);

#if 0
	printf("global myinfo handler finished\n");
#endif
	return 0;
}


/***************************************************************************************************************/
/* static nicklist funktion  - this Message should be received from hub after sending the $GetNickList command */
/***************************************************************************************************************/
static int global_nicklist_fnc(void *xtra_parm, const char *nicklist)
{
	char *u;
	char *t;
	GString *output;
#if 0
	printf("%s global nicklist handler got: %s\n",my_name,nicklist);
#endif
	t=strdup(nicklist);
	u=strstr(t," ");
	output=g_string_new("");
	while(u!=NULL)
	{
		*u='\0';
		if(strcmp(t,my_name) && strcmp(t,"Hub-Security"))
		{
			add_user_to_user_list(t);
			add_seen_entry(1,t);
			g_string_sprintf(output,"-showtype %s",t);
			G_LOCK(hub_com);
			send_private_chat_message(hub_com,my_name,"Hub-Security",output->str,1);
			G_UNLOCK(hub_com);
			g_string_sprintf(output,"$GetINFO %s %s",t,my_name);
			G_LOCK(hub_com);
			send_dc_line(hub_com,output->str,NULL);
			G_UNLOCK(hub_com);
		}
		t=u+1;
		u=strstr(t," ");
	}
	if(strcmp(t,my_name) && strcmp(t,"Hub-Security"))
	{
		add_user_to_user_list(t);
		add_seen_entry(1,t);
		g_string_sprintf(output,"-getip %s",t);
		G_LOCK(hub_com);
		send_private_chat_message(hub_com,my_name,"Hub-Security",output->str,1);
		G_UNLOCK(hub_com);
		g_string_sprintf(output,"-showtype %s",t);
		G_LOCK(hub_com);
		send_private_chat_message(hub_com,my_name,"Hub-Security",output->str,1);
		G_UNLOCK(hub_com);
	}
	g_string_free(output,TRUE);
#if 0
	printf("%s global nicklist handler finished\n",my_name);
#endif
	return 0;
}

/*************************************************************************************/
/* static oplist funktion  - this Message is received each time an Operator connects */
/*************************************************************************************/
static int global_oplist_fnc(void *xtra_parm, const char *oplist)
{
	char *u;
	char *t;
#if 0
	printf("%s global oplist handler got: %s\n",my_name,oplist);
#endif
	t=strdup(oplist);
	u=strstr(t," ");
	while(u!=NULL)
	{
		*u='\0';
		if(strcmp(t,my_name) && strcmp(t,"Hub-Security"))
		{
			if(add_user_to_op_list(t))
			{
			}
		}
		t=u+1;
		u=strstr(t," ");
	}
	if(strcmp(t,my_name) && strcmp(t,"Hub-Security"))
	{
		if(add_user_to_op_list(t))
		{
		}
	}
#if 0
	printf("%s global oplist handler finished\n",my_name);
#endif
	return 0;
}

/***********************************************************************************************/
/* static Private-Chat funktion  - this message is received each time an Message is send to me */
/***********************************************************************************************/
static int global_privmsg_fnc(void *xtra_parm, const char *source_nick, const char *dest_nick, const char *message)
{
#if 0
	printf("%s global privmsg fnc start\n",my_name);
#endif
	if ((strcmp(source_nick,my_name)!=0) && (strcmp(dest_nick,my_name)==0) && (strcmp(source_nick,"Hub-Security")!=0))
	{
		int i;
		int is_op=FALSE;
#if 0
		printf("privmsg funktion trying to lock hub user list\n");
#endif
		G_LOCK(hub_user_list);
#if 0
		printf("privmsg funktion locked hub user list\n");
#endif
		for(i=0;i<hub_op_list->len;i++)
		{
			if(!strcmp(source_nick,g_ptr_array_index(hub_op_list,i)))
			{
				is_op=TRUE;
				break;
			}
		}
#if 0
		printf("privmsg funktion trying to unlock hub user list\n");
#endif
		G_UNLOCK(hub_user_list);
#if 0
		printf("privmsg funktion unlocked hub user list\n");
#endif
		{
			char *dp;
			char *cut;
         dp=strdup(message);
			printf("%s privmsg-command1 got: %s\n",my_name,dp);
         cut=strtok(dp," ");
         if(cut!=NULL)
         {
            cut=strtok(NULL," ");
            if(cut!=NULL)
            {
               /* OP-CHAT */
               if((!strcmp(cut,"#say") || strncmp(cut,"#",1)) && is_op==TRUE)
               {
                  send_op_message((char *)message,(char *)source_nick);
               }
/***************** op-commands ***********************/
					if ((!strcmp(cut,"#close") || !strcmp(cut,"#kick") || !strcmp(cut,"#ban") || !strcmp(cut,"#flood")) && is_op==TRUE)
					{
						char *kicking_op=NULL;
						char *cmd=NULL;
#if 0
						printf("%s privmsg-command2 got: %s\n",my_name,dp);
#endif
						kicking_op=strdup(source_nick);
						if(cut!=NULL)
						{
							cmd = strdup(cut);
							printf("cmd set: %s\n",cmd);
							cut=strtok(NULL," ");
						}
						if(cut!=NULL)
						{
							int kicknick_found=FALSE;
							char *kicknick=strdup(cut);
							char *kicknick_ip=NULL;
							G_LOCK(hub_user_list);
							for(i=0;i<hub_user_list->len;i++)
							{
								if(!strcmp(kicknick,g_ptr_array_index(hub_user_list,i)))
								{
									XTRA_INFO *xi;
									xi=g_ptr_array_index(hub_user_xtra_info,i);
									kicknick_ip=strdup(xi->addr->str);
									kicknick_found=TRUE;
									break;
								}
							}
							G_UNLOCK(hub_user_list);
							if (kicknick_found==TRUE)
							{
#if 0
								printf("nick found - continue\n");
#endif
								cut=strtok(NULL," ");
								if(cut!=NULL)
								{
									GString *reason;
									reason=g_string_new(cut);
#if 0
									printf("reason: %s\n",cut);
#endif
									cut=strtok(NULL," ");
									if (cut!=NULL)
									{
										while(cut!=NULL)
										{
#if 0
											printf("reason: %s\n",cut);
#endif
											g_string_sprintfa(reason," %s",cut);
											cut=strtok(NULL," ");
										}
									}
#if 0
									printf("kickcmd: %s, %s, %s\n",cmd,kicknick,reason->str);
#endif
									if(!strcmp(cmd,"#close"))
									{
										GString *msg;
										msg=g_string_new("You've been disconnected by ");
										g_string_sprintfa(msg,"%s because: %s",(char*)source_nick,reason->str);
										G_LOCK(hub_com);
										send_private_chat_message(hub_com,my_name,kicknick,msg->str,1);
										G_UNLOCK(hub_com);
										g_string_sprintf(msg,"%s is disconnecting %s because: %s",kicking_op,kicknick,reason->str);
										G_LOCK(hub_com);
										send_public_chat_message(hub_com,my_name,msg->str);
										G_UNLOCK(hub_com);
										g_string_sprintf(msg,"-kick %s ...",kicknick);
										G_LOCK(hub_com);
										send_private_chat_message(hub_com,my_name,"Hub-Security",msg->str,1);
										G_UNLOCK(hub_com);
										g_string_free(msg,TRUE);
									}
									else if(!strcmp(cmd,"#kick"))
									{
										GString *msg;
										msg=g_string_new("You've been kicked by ");
										g_string_sprintfa(msg,"%s because: %s",kicking_op,reason->str);
										G_LOCK(hub_com);
										send_private_chat_message(hub_com,my_name,kicknick,msg->str,1);
										G_UNLOCK(hub_com);
										g_string_sprintf(msg,"%s is kicking %s because: %s",kicking_op,kicknick,reason->str);
										G_LOCK(hub_com);
										send_public_chat_message(hub_com,my_name,msg->str);
										G_UNLOCK(hub_com);
										g_string_sprintf(msg,"-ban 24h %s",kicknick); // 24h Ban
										G_LOCK(hub_com);
										send_private_chat_message(hub_com,my_name,"Hub-Security",msg->str,1);
										G_UNLOCK(hub_com);
										g_string_sprintf(msg,"-kick %s ...",kicknick);
										G_LOCK(hub_com);
										send_private_chat_message(hub_com,my_name,"Hub-Security",msg->str,1);
										G_UNLOCK(hub_com);
										g_string_free(msg,TRUE);
									}
									else if(!strcmp(cmd,"#ban"))
									{
										GString *msg;
										msg=g_string_new("You've been banned by ");
										g_string_sprintfa(msg,"%s because: %s",kicking_op,reason->str);
										G_LOCK(hub_com);
										send_private_chat_message(hub_com,my_name,kicknick,msg->str,1);
										G_UNLOCK(hub_com);
										g_string_sprintf(msg,"%s is banning %s because: %s",kicking_op,kicknick,reason->str);
										G_LOCK(hub_com);
										send_public_chat_message(hub_com,my_name,msg->str);
										G_UNLOCK(hub_com);
										g_string_sprintf(msg,"-ban 30d %s",kicknick);	// 30D Ban
										G_LOCK(hub_com);
										send_private_chat_message(hub_com,my_name,"Hub-Security",msg->str,1);
										G_UNLOCK(hub_com);
										g_string_sprintf(msg,"-kick %s ...",kicknick);
										G_LOCK(hub_com);
										send_private_chat_message(hub_com,my_name,"Hub-Security",msg->str,1);
										G_UNLOCK(hub_com);
										g_string_free(msg,TRUE);
									}
									else if(!strcmp(cmd,"#flood"))
									{
										GString *msg;
										msg=g_string_new("You've been banned by ");
										g_string_sprintfa(msg,"%s because: %s",kicking_op,reason->str);
										G_LOCK(hub_com);
										send_private_chat_message(hub_com,my_name,kicknick,msg->str,1);
										G_UNLOCK(hub_com);
										g_string_sprintf(msg,"%s is banning %s because: %s",kicking_op,kicknick,reason->str);
										G_LOCK(hub_com);
										send_public_chat_message(hub_com,my_name,msg->str);
										G_UNLOCK(hub_com);
										g_string_sprintf(msg,"-ban 30d %s",kicknick); // 30D Ban
										G_LOCK(hub_com);
										send_private_chat_message(hub_com,my_name,"Hub-Security",msg->str,1);
										G_UNLOCK(hub_com);
										g_string_sprintf(msg,"-flood %s ...",kicknick);
										G_LOCK(hub_com);
										send_private_chat_message(hub_com,my_name,"Hub-Security",msg->str,1);
										G_UNLOCK(hub_com);
										g_string_free(msg,TRUE);
									}
									g_string_free(reason,TRUE);
								}
							}
							else
							{
								G_LOCK(hub_com);
								send_private_chat_message(hub_com,my_name,kicking_op,"Sorry - unknown user",1);
								G_UNLOCK(hub_com);
							}
						}	
					}
              	else if (!strcmp(cut,"#scan") && is_op==TRUE)
					{
						cut=strtok(NULL," ");
						if(cut!=NULL)
						{
							GString *output;
							char *test_nick;
							int nick_found=FALSE;
							test_nick=strdup(cut);
#if 0
							printf("privmsg funktion #scan trying to lock hub user list\n");
#endif
							G_LOCK(hub_user_list);
#if 0
							printf("privmsg funktion #scan locked hub user list\n");
#endif
							for(i=0;i<hub_user_list->len;i++)
							{
								if(!strcmp(test_nick,g_ptr_array_index(hub_user_list,i)))
								{
									nick_found=TRUE;
									break;
								}
							}
							if (nick_found==TRUE)
							{
								XTRA_INFO *xi;
								GString *needinfo;
					         xi=g_ptr_array_index(hub_user_xtra_info,i);
					         if(xi==NULL)
								{
									/* no information at all -> try to get myinfo-string */
									needinfo=g_string_new("");
  									g_string_sprintf(needinfo,"$GetINFO %s %s",test_nick,my_name);
   								G_LOCK(hub_com);
   								send_dc_line(hub_com,needinfo->str,NULL);
   								G_UNLOCK(hub_com);
   								g_string_free(needinfo,TRUE);
									output=g_string_new("");
									g_string_sprintf(output,"Sorry, No information for %s available - I'll try to get some",test_nick);
								}
								else
								{
									/* lets see what we have */
									output=g_string_new("");
									g_string_sprintf(output,"Information for %s:\r\n",test_nick);
									g_string_sprintfa(output,"IP: %s\r\n",xi->addr->str);
									if(xi->got_myinfo>0)
									{
										if((strcmp(xi->d_client->str,"DC++")==0) || (strcmp(xi->d_client->str,"DCGUI")==0) || (strcmp(xi->d_client->str,"DC++ mod")==0) || (strcmp(xi->d_client->str,"DC++ mod OK")==0) || (strcmp(xi->d_client->str,"LuDC")==0) || (strcmp(xi->d_client->str,"NMDC2")==0) || (strcmp(xi->d_client->str,"BCDC")==0))
											g_string_sprintfa(output,"myinfo: %s, %f %s\r\n",xi->d_client->str,xi->d_version,xi->d_versionadd->str);
										else
											g_string_sprintfa(output,"myinfo: probably NM-DC\r\n");
									}
									if(xi->got_lock>0)
									{
										g_string_sprintfa(output,"connect: %s %f %s\r\n",xi->client->str,xi->version,xi->versionadd->str);
										g_string_sprintfa(output,"lock1: (%i)   %s\r\npk1: (%i)   %s\r\n",
																						strlen(xi->locka->str),xi->locka->str,
																						strlen(xi->pka->str),xi->pka->str);
										if(xi->got_lock>1)
											g_string_sprintfa(output,"lock2: (%i)   %s\r\npk2: (%i)   %s\r\n",
																						strlen(xi->lockb->str),xi->lockb->str,
																						strlen(xi->pkb->str),xi->pkb->str);
										if(xi->got_lock>2)
											g_string_sprintfa(output,"lock3: (%i)   %s\r\npk3: (%i)   %s\r\n",
																						strlen(xi->lockc->str),xi->lockc->str,
																						strlen(xi->pkc->str),xi->pkc->str);
										if(xi->has_bzlist>0)
											g_string_sprintfa(output,"bzlist: supported\r\n");
										else
											g_string_sprintfa(output,"bzlist: unsupported\r\n");
										if(xi->need_scan!=0)
											g_string_sprintfa(output,"another scan will be requested\r\n");
									}
									else
									{
										g_string_sprintfa(output,"No Lock & PK available - I'll try to get them");
									}
									if(xi->need_scan!=0)
									{
										needinfo=g_string_new("");
#if 0
										printf("$ConnectToMe %s %s\n",test_nick,my_incom);
#endif
   	                       	g_string_sprintf(needinfo,"$ConnectToMe %s %s",test_nick,my_incom);
  	   	                    	G_LOCK(hub_com);
     	   	                 	send_dc_line(hub_com,needinfo->str,NULL);
        	   	              	G_UNLOCK(hub_com);
           	   	           	g_string_free(needinfo,TRUE);
									}
								}
							}
							else
							{
								/* nick not found */
								output=g_string_new("");
								g_string_sprintf(output,"Sorry, '%s' unknown...",test_nick);
							}
#if 0
							printf("privmsg funktion #scan trying to unlock hub user list\n");
#endif
							G_UNLOCK(hub_user_list);
#if 0
							printf("privmsg funktion #scan unlocked hub user list\n");
#endif
							G_LOCK(hub_com);
							send_private_gchat_message(hub_com,(char*) source_nick, my_name, output->str);
							G_UNLOCK(hub_com);
							g_string_free(output,TRUE);
						}
					}
					else if (!strcmp(cut,"#clear") && is_op==TRUE)
					{
						GString *output;
						output=g_string_new("");
						g_string_sprintf(output,"...cleaning main chat...\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n...cleared!");
						G_LOCK(hub_com);
						send_public_chat_message(hub_com,my_name,output->str);
						G_UNLOCK(hub_com);
						g_string_free(output,TRUE);
					}
					else if (!strcmp(cut,"#clearscan") && is_op==TRUE)
					{
                 	cut=strtok(NULL," ");
                 	if(cut!=NULL)
                 	{
							int gotcha=FALSE;
                     char *test_nick;
  	                  test_nick=strdup(cut);
#if 0
							printf("privmsg funktion #clearscan trying to lock hub user list\n");
#endif
							G_LOCK(hub_user_list);
#if 0
							printf("privmsg funktion #clearscan locked hub user list\n");
#endif
        	            for(i=0;i<hub_user_list->len;i++)
           	         {
              	         if(!strcmp(test_nick,g_ptr_array_index(hub_user_list,i)))
                 	      {
									gotcha=TRUE;
									break;
								}
							}
#if 0
							printf("privmsg funktion #clearscan trying to unlock hub user list\n");
#endif
							G_UNLOCK(hub_user_list);
#if 0
							printf("privmsg funktion #clearscan unlocked hub user list\n");
#endif
							if(gotcha==TRUE)
							{
								GString *needinfo;
								int clearop=FALSE;
								needinfo=g_string_new("");
#if 0
								printf("privmsg funktion #clearscan 2 trying to lock hub user list\n");
#endif
								G_LOCK(hub_user_list);
#if 0
								printf("privmsg funktion #clearscan 2 locked hub user list\n");
#endif
								for(i=0;i<hub_op_list->len;i++)
								{
									if(!strcmp(test_nick,g_ptr_array_index(hub_op_list,i)))
									{
										clearop=TRUE;
										break;
									}
								}
#if 0
								printf("privmsg funktion #clearscan 2 trying to unlock hub user list\n");
#endif
								G_UNLOCK(hub_user_list);
#if 0
								printf("privmsg funktion #clearscan 2 unlocked hub user list\n");
#endif
								if(remove_user_to_user_list(test_nick))
								{
									add_user_to_user_list(test_nick);
									if (clearop==TRUE)
										add_user_to_op_list(test_nick);
									g_string_sprintf(needinfo,"-getip %s",test_nick);
									send_private_chat_message(hub_com,my_name,"Hub-Security",needinfo->str,1);
									G_UNLOCK(hub_com);
									g_string_sprintf(needinfo,"-showtype %s",test_nick);
									G_LOCK(hub_com);
									send_private_chat_message(hub_com,my_name,"Hub-Security",needinfo->str,1);
									G_UNLOCK(hub_com);
                        	g_string_sprintf(needinfo,"$GetINFO %s %s",test_nick,my_name);
                        	G_LOCK(hub_com);
                        	send_dc_line(hub_com,needinfo->str,NULL);
                        	G_UNLOCK(hub_com);
								}
                        g_string_free(needinfo,TRUE);
                 	   }
						}
					}
					else if(!strcmp(cut,"#test") && is_op==TRUE)
					{
						char *filename="test.txt";
						G_LOCK(hub_com);
                  send_commandfile(hub_com, filename, my_name, (char *)source_nick);
                  G_UNLOCK(hub_com);
					}
					else if (!strcmp(cut,"#say") && is_op==TRUE)
					{
						cut=strtok(NULL," ");
						if (cut!=NULL)
						{
							GString *output;
							output=g_string_new("");
							g_string_sprintf(output,"<%s> ",cut);
							cut=strtok(NULL," ");
							if (cut!=NULL)
							{
								g_string_sprintfa(output,"%s ",cut);
								cut=strtok(NULL," ");
								while(cut!=NULL)
								{
									g_string_sprintfa(output,"%s ",cut);
									cut=strtok(NULL," ");
								}
								G_LOCK(hub_com);
								send_dc_line(hub_com,output->str,NULL);
								G_UNLOCK(hub_com);
							}
							g_string_free(output,TRUE);
						}
					}
					else if (!strcmp(cut,"#mass") && is_op==TRUE)
					{
						cut=strtok(NULL," ");
						if (cut!=NULL)
						{
							GString *output;
							output=g_string_new("");
							g_string_sprintf(output,"-bcast \"");
							while (cut!=NULL)
							{
								g_string_sprintfa(output," %s",cut);
								cut=strtok(NULL," ");
							}
							g_string_sprintfa(output,"\"");
							G_LOCK(hub_com);
							send_private_chat_message(hub_com,(char*)source_nick,"Hub-Security",output->str,1);
							G_UNLOCK(hub_com);
							g_string_free(output,TRUE);
						}
					}
               else if (!strcmp(cut,"#users"))
               {
                  GString *output;
                  int i=0;
                  i=do_users();
                  output=g_string_new("");
                  g_string_sprintf(output,"%i users since last bot-start",i);
                  G_LOCK(hub_com);
                  send_private_chat_message(hub_com,my_name,(char*)source_nick,output->str,1);
                  G_UNLOCK(hub_com);
                  g_string_free(output,TRUE);
               }

/***************** user-commands ***********************/
					else if(!strcmp(cut,"#connect"))
					{
						cut=strtok(NULL," ");
						if (cut!=NULL)
						{
							GString *output;
							output=g_string_new(cut);
							cut=strtok(NULL," ");
							if (cut!=NULL)
							{
								while (cut!=NULL)
								{
									g_string_sprintfa(output," %s",cut);
									cut=strtok(NULL," ");
								}
							}
							/* if(strlen(in_msg)>220) */
							if(strlen(output->str)>200)
							{
								/* incoming message to long */
							}
							else
							{
								printf("adding incoming message: %s, %s\n",source_nick,output->str);
								add_incoming_message((char*)source_nick,output->str,0);
							}
							g_string_free(output,TRUE);
						}
					}
					else if(!strcmp(cut,"#seen"))
					{
						cut=strtok(NULL," ");
						if (cut!=NULL)
						{
							char *output=NULL;
							output=find_seen_by_nickname(cut);
							G_LOCK(hub_com);
							send_private_chat_message(hub_com,my_name,(char*)source_nick,output,1);
							G_UNLOCK(hub_com);
						}
					}
					else if(!strcmp(cut,"#msg"))
					{
						cut=strtok(NULL," ");
						if (cut!=NULL)
						{
							char *reciepient=strdup(cut);
							cut=strtok(NULL," ");
							if(cut!=NULL)
							{
								GString *message;
								int i=0;
								message=g_string_new(cut);
								cut=strtok(NULL," ");
								if (cut!=NULL)
								{
									while(cut!=NULL)
									{
										g_string_sprintfa(message," %s",cut);
										cut=strtok(NULL," ");
									}
								}
								i=add_message(source_nick,reciepient,message);
								if (i==1)
								{
									G_LOCK(hub_com);
									send_private_chat_message(hub_com,my_name,(char*)source_nick,"sorry - something went wrong",1);
									G_UNLOCK(hub_com);
								}
								else
								{
									GString *output;
									output=g_string_new("");
									g_string_sprintf(output,"Your message for %s was succesfully stored!",reciepient);
									G_LOCK(hub_com);
									send_private_chat_message(hub_com,my_name,(char*)source_nick,output->str,1);
									G_UNLOCK(hub_com);
									g_string_free(output,TRUE);
								}
								g_string_free(message,TRUE);
							}
						}
					}
					else if(!strcmp(cut,"#clearmsg"))
					{
						int i=0;
						i=delete_messages(source_nick);
						if(i==0)
						{
							G_LOCK(hub_com);
							send_private_chat_message(hub_com,my_name,(char*)source_nick,"found no message to delete!",1);
							G_UNLOCK(hub_com);
						}
						else
						{
							GString *output;
							output=g_string_new("");
							g_string_sprintf(output,"%i message(s) deleted!",i);
							G_LOCK(hub_com);
							send_private_chat_message(hub_com,my_name,(char*)source_nick,output->str,1);
							G_UNLOCK(hub_com);
							g_string_free(output,TRUE);
						}
					}
					else if(!strncmp(cut,"#",1))
            	{
               	char filename[30];
	               strcpy(filename," ");
#if 0
               	printf("trying usercommand: %s\n",cut);
#endif
   	            if (!strcmp(cut,"#befehle"))
      	         {
         	         if(is_op==TRUE)
            	         strcpy(filename,"opbefehle.txt");
               	   else
                  	   strcpy(filename,"befehle.txt");
	               }
   	            else if (!strcmp(cut,"#help"))
      	         {
         	         cut=strtok(NULL," ");
            	      if (cut!=NULL)
               	   {
                  	   if (!strcmp(cut,"me"))
                     	{
	                        strcpy(filename,"helpme.txt");
   	                  }
      	               else if(!strcmp(cut,"op"))
         	            {
            	            char msg[100];
               	         strcpy(msg,"<");
									strcat(msg,my_name);
									strcat(msg,"> The user");
                  	      strcat (msg,source_nick);
                     	   strcat (msg," needs some help...");
                        	send_op_message(msg,(char *)source_nick);
	                        strcpy(msg,"...an OP will contact you");
   	                     G_LOCK(hub_com);
      	                  send_private_chat_message(hub_com,my_name,(char *)source_nick,msg,1);
         	               G_UNLOCK(hub_com);
            	         }
               	   }
	               }
	               else if (!strcmp(cut,"#hubregeln"))
   	               strcpy(filename,"hubregeln.txt");
      	         else if (!strcmp(cut,"#hubrules"))
         	         strcpy(filename,"hubrules.txt");
            	   else if (!strcmp(cut,"##help"))
               	{
                  	cut=strtok(NULL," ");
	                  if (cut!=NULL)
   	               {
      	               if(strspn(cut,"0123456789")==strlen(cut) && atoi(cut)>0 && atoi(cut)<14)
         	            {
            	            strcpy(filename,"help");
               	         strcat(filename,cut);
                  	      strcat(filename,".txt");
                     	}
	                     else
   	                  {
      	                  char msg[100]="Hmm - da stimmte wohl die Nummer nicht...";
         	               G_LOCK(hub_com);
            	            send_private_chat_message(hub_com,my_name,(char*)source_nick,msg,1);
               	         G_UNLOCK(hub_com);
                  	   }
                  	}
               	}
	               else if (!strcmp(cut,"#cafe"))
   	            {	/* THIS IS A SAMPLE HOW TO LET USERS REDIRECT THEMSELVES INSIDE AN HUB-COMMUNITY */
      	            cut=strtok(NULL," ");
         	         if (cut!=NULL)
            	      {
								GString *output;
               	      char *cafe=NULL;
                  	   output=g_string_new("");
                     	if (!strcmp(cut,"1"))
	                     {
   	                     cafe="deutschlandcafe1.nerdcamp.net:411";
      	               }
         	            else if (!strcmp(cut,"2"))
            	         {
               	         cafe="deutschlandcafe2.nerdcamp.net:411";
                  	   }
                     	else if (!strcmp(cut,"3"))
	                     {
   	                     cafe="deutschlandcafe3.nerdcamp.net:411";
      	               }
         	            else if (!strcmp(cut,"4"))
            	         {
               	         cafe="deutschlandcafe4.nerdcamp.net:411";
                  	   }
                     	else
	                     {
   	                     g_string_sprintf(output,"$To: %s From: %s $<%s> wrong hub-number ?",source_nick,my_name,my_name);
      	               }
         	            if (cafe!=NULL)
            	         {
               	         g_string_sprintf(output,"$OpForceMove $Who:%s$Where:%s$Msg:You'll be re-directed to Deutschland C@fe %s  because: Your own wish !!",source_nick,cafe,cut);
                  	   }
                     	G_LOCK(hub_com);
	                     send_dc_line(hub_com,output->str,NULL);
   	                  G_UNLOCK(hub_com);
      	               g_string_free(output,TRUE);
         	         }
            	   }
               	if (strcmp(filename," "))
	               {
   	               G_LOCK(hub_com);
      	            send_commandfile(hub_com, filename, my_name, (char *)source_nick);
         	         G_UNLOCK(hub_com);
            	   }
					}
				}
			}
			if(dp)
				free(dp);
		}
	}
	else if(!strcmp(source_nick,"Hub-Security"))
	{ /* try to decode Hub-Security-messages inside here */
		if (!strncmp(message,"ip:",3))
		{
			GString *str;
			char *de;
			char *fnd_nick;
#if 0
			printf("Userip-message received from hub\n");
#endif
			str=g_string_new(message+3);
			str=g_string_truncate(str,str->len-2); /* remove the /r/n after the nicktype-Character */
			de=str->str;
			fnd_nick=de;
			de=strchr(fnd_nick,' ');
			if(de!=NULL)
			{
				*de++='\0';
				if(strcmp(fnd_nick,my_name) && strcmp(fnd_nick,"Hub-Security"))
				{
					set_xtra_information_cnx(fnd_nick,0,de,NULL,0,NULL,NULL,NULL,0,0,0,NULL,0,NULL,time(NULL),NULL,0,FALSE);
				}
			}
			g_string_free(str,TRUE);
		}
		else if (!strncmp(message,"type:",5))
		{ /* this is the reply to the -showtype message send when a user is entering the hub */
			GString *str;
			char *de;
			char *fnd_nick;
#if 0
			printf("Usertype-message received from hub\n");
#endif
			str=g_string_new(message+5);
			str=g_string_truncate(str,str->len-2); /* remove the /r/n after the nicktype-Character */
			de=str->str;
         /* extract the nickname */
         fnd_nick=de;
         de=strchr(fnd_nick,' ');
         if(de!=NULL)
			{
				char *welcome_nick;
				char *nick_type;
         	*de++='\0';
				/* de should now be the one-character usertype */
#if 0
				printf("received usertype for %s: %s %i\n",fnd_nick,de,strlen(de));
#endif
				welcome_nick=strdup(fnd_nick);
				nick_type=strdup(de);
				if (strlen(de)==1 && strcmp(fnd_nick,my_name) && strcmp(fnd_nick,"Hub-Security"))
				{
					set_xtra_information_cnx(fnd_nick,0,NULL,NULL,0,NULL,NULL,NULL,0,0,0,NULL,0,NULL,time(NULL),de,0,FALSE);
					/* g_string_sprintf(str,"$GetINFO %s %s",fnd_nick,my_name); */
					/* G_LOCK(hub_com); */
					/* send_dc_line(hub_com,str->str,NULL); */
					/* G_UNLOCK(hub_com); */
					if(strstr(nick_type,"M")!=NULL || strstr(nick_type,"O")!=NULL)
					{
						welcome_op(welcome_nick);
					}
					else if (strstr(nick_type,"N")!=NULL || strstr(nick_type,"V")!=NULL)
					{
						welcome_reg(welcome_nick);
					}
				}
			}
			g_string_free(str,TRUE);
#if 0
			printf("finished Hub-Security usertype\n");
#endif
		}
	}
#if 0
	printf("%s global privmsg fnc finished: %s\n",my_name,source_nick);
#endif
	return 0;
}

static int global_hello_fnc(void *xtra_param,const char *nickname)
{
	
#if 0
	printf("global hello function start\n");
#endif
	if(strcmp(nickname,my_name) && strcmp(nickname,"Hub-Security"))
	{
		GString *msg;
		GString *message;
		add_user_to_user_list((char *)nickname);
		msg=g_string_new("");
		g_string_sprintf(msg,"-getip %s",(char *)nickname);
		send_private_chat_message(hub_com,my_name,"Hub-Security",msg->str,1);
		G_UNLOCK(hub_com);
		g_string_sprintf(msg,"-showtype %s",(char *)nickname);
		G_LOCK(hub_com);
		send_private_chat_message(hub_com,my_name,"Hub-Security",msg->str,1);
		G_UNLOCK(hub_com);
		g_string_free(msg,TRUE);
		message=find_left_messages(nickname);
		if(strlen(message->str)>2)
		{
			G_LOCK(hub_com);
			send_private_chat_message(hub_com,my_name,(char*)nickname,message->str,1);
			G_UNLOCK(hub_com);
		}
		g_string_free(message,TRUE);
	}
	else if(!strcmp(my_name,nickname))
	{
		GString *output;
		char *my_desc="der bse bot";
		char *my_cnxtype="Bot";
		unsigned char my_flag=1;
		char *my_mail="";
		unsigned long long my_share=0;
		output=g_string_new("");
		g_string_sprintf(output,"$MyINFO $ALL %s %s$ $%s%c$%s$%llu$",
					my_name,my_desc,my_cnxtype,(char)my_flag,my_mail,my_share);
		G_LOCK(hub_com);
		send_dc_line(hub_com,output->str,NULL);
		G_UNLOCK(hub_com);
		g_string_free(output,TRUE);
	}
	add_seen_entry(1,nickname);

#if 0
	printf("global hello function finished\n");
#endif
	return 0;
}

static int global_quit_fnc(void *xtra_param, const char *nickname)
{
	int i;
	i=remove_user_to_user_list((char *)nickname);
	add_seen_entry(0,nickname);
	return 0;
}

/*********************************************************************************************************/
/* the program receives 3 parameters: its name (as it appears on the hub), the hub com socket number and */
/* the localhost IP (not 127.0.0.1, the IP used by users to connect to the hub).                         */
/* NOTE: the dc_com.c is the same as the src one but you must provide the DC_INPUT_NO_TIMEOUT else after */
/* 30 seconds idle, you will received a NULL string.                                                     */
/*********************************************************************************************************/
int main(int argc, char **argv)
{
	GString *str;

	if(argc!=4)
	{
		fprintf(stderr,"Usage: %s name fdnumber localhostIP\n",argv[0]);
		exit(1);
	}

	reset_hub_user_list();

	my_name=argv[1];
	sscanf(argv[2],"%u",&hub_com);

	my_hostip=g_strdup(argv[3]);
	G_LOCK(hub_com);
	send_dc_line(hub_com,"$GetNickList",NULL);
	G_UNLOCK(hub_com);

	search_to_start=g_array_new(FALSE,FALSE,sizeof(AUTOSEARCH));
	start_auto_search();
	start_in_com();
	get_incoming_messages();
	/* allocated running task array and queued task array */
	waiting_action=g_ptr_array_new();

	while(1)
	{
		timeout_message();
		static TBLDECODE global_gen_dec={global_myinfo_fnc,NULL,global_privmsg_fnc,NULL,NULL,NULL,NULL,global_hello_fnc,global_quit_fnc,global_nicklist_fnc,global_oplist_fnc};
		str=get_a_dc_line(hub_com);

		if(str==NULL)
			break;

#if 0
		printf("%s received: '%s'\n",my_name,str->str);
#endif
	
		generic_decoder(str,&global_gen_dec,NULL);

		g_string_free(str,TRUE);

	}
	printf("%s has lost hub connection and leaves\n",my_name);
	return 0;
}

