/* Generated By:JavaCC: Do not edit this line. AxionSqlParser.java */
package org.axiondb.parser;

import org.axiondb.*;
import org.axiondb.constraints.*;
import org.axiondb.types.*;
import org.axiondb.functions.*;
import org.axiondb.expression.*;
import org.axiondb.engine.commands.*;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.InputStream;
import java.io.ByteArrayInputStream;

import java.util.*;

/** 
 * JavaCC generated SQL parser. 
 * Generated from AxionSqlParser.jj ($Header: /cvs/axion/grammars/AxionSqlParser.jj,v 1.44 2003/07/08 21:45:48 rwald Exp $).
 * Do not edit this (.java) file directly, it is programmaticly generated.
 * 
 * @author kevinh (at) empower.com.au
 * @author Doug Sale
 * @author Chuck Burdick
 * @author Rodney Waldhoff
 * @author James Strachan
 * @author Rob Oxspring
 * @author Amrish Lal
 * @author Rahul Dwivedi
 */
public class AxionSqlParser implements Parser, AxionSqlParserConstants {

    public AxionSqlParser() {
        this(new ByteArrayInputStream(new byte[0]));
        _log.debug("created new parser");
    }

    public AxionCommand parse(String sql) throws AxionException {
        this.ReInit(new ByteArrayInputStream(sql.getBytes()));
        try {
            return this.SqlCommand();
        } catch(TokenMgrError e) {
            throw new AxionException(e);
        } catch(ParseException ex) {
            throw new AxionException(ex);
        }
    }

  /**
   * Replaces all occurances of <i>old</i> in <i>src</i> with <i>nu</i>.
   *
   * @param src the source String
   * @param old the character to replace
   * @param nu  the String to replace <i>old</i> with
   * @return a copy of <i>src</i> with all instances of <i>old</i>
   *         replaced by <i>nu</i>
   * @throws java.lang.NullPointerException if any argument is null.
   */
  private final static String replace(String src, String old, String nu) {
    int srclen = src.length();
    int cur = 0;
    int loc = 0;
    int oldlen = old.length();
    StringBuffer buf = new StringBuffer(srclen+nu.length());
    do {
      loc = src.indexOf(old,cur);
      if(loc != -1) {
        buf.append(src.substring(cur,loc));
        buf.append(nu);
        cur = loc + oldlen;
      }
    } while(loc != -1);
    if(cur < srclen) {
      buf.append(src.substring(cur));
    }
    return buf.toString();
  }

  private static Log _log = LogFactory.getLog(AxionSqlParser.class);

// ----------------------------------------------------------------------------
// SQL GRAMMAR
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// COMMANDS
// ----------------------------------------------------------------------------
  final public AxionCommand SqlCommand() throws ParseException {
    AxionCommand result = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELECT:
      result = SqlSelect();
      break;
    case INSERT:
      result = SqlInsert();
      break;
    case UPDATE:
      result = SqlUpdate();
      break;
    case DELETE:
      result = SqlDelete();
      break;
    case CREATE:
      result = SqlCreate();
      break;
    case DROP:
      result = SqlDrop();
      break;
    case ALTER:
      result = SqlAlterTable();
      break;
    case ID:
      result = SqlAxionCustom();
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMICOLON:
      jj_consume_token(SEMICOLON);
      break;
    default:
      ;
    }
    jj_consume_token(0);
    if(_log.isDebugEnabled()) { _log.debug("SqlCommand: created \"" + result + "\""); }
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

// ----------------------------------------------------------------------------
// COMMANDS: AXION CUSTOM
// ----------------------------------------------------------------------------
  final public AxionCommand SqlAxionCustom() throws ParseException {
    jj_consume_token(ID);
    if("CHECKPOINT".equalsIgnoreCase(token.image)) {
      {if (true) return new CheckpointCommand();}
    } else if("REMOUNT".equalsIgnoreCase(token.image)) {
      {if (true) return SqlRemount();}
    } else if("SHUTDOWN".equalsIgnoreCase(token.image)) {
      {if (true) return new ShutdownCommand();}
    } else if("CHECKFILESTATE".equalsIgnoreCase(token.image)) {
      {if (true) return new CheckFileStateCommand();}
    } else {
      {if (true) throw new ParseException("Expected CHECKPOINT, REMOUNT, SHUTDOWN, or CHECKFILESTATE found \"" + token.image + "\".");}
    }
    throw new Error("Missing return statement in function");
  }

  final public AxionCommand SqlRemount() throws ParseException {
    RemountCommand remount = new RemountCommand();
    Object dir;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
      jj_consume_token(ID);
        remount.setTable(new TableIdentifier(token.image));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ID:
        jj_consume_token(ID);
        if("data".equalsIgnoreCase(token.image)) {
          remount.setDataFilesOnly(true);
        } else {
          {if (true) throw new ParseException("Expected \"DATA\", found \"" + token.image + "\"");}
        }
        break;
      default:
        ;
      }
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING_LITERAL:
      jj_consume_token(STRING_LITERAL);
      if(_log.isDebugEnabled()) { _log.debug("SqlRemount: consumed \"" + token + "\""); }
      // trim off the open and close quotes
      String trimmed = token.image.substring(1, token.image.length() - 1);
      // replace all '' with '
      String result = replace(trimmed,"''","'");
      if(_log.isDebugEnabled()) { _log.debug("SqlRemount: path \"" + result + "\""); }
      dir = result;
      remount.setDirectory(result);
      break;
    case QUESTIONMARK:
      dir = SqlBindVar();
       remount.setDirectory((Literal)dir);
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
     {if (true) return remount;}
    throw new Error("Missing return statement in function");
  }

// ----------------------------------------------------------------------------
// COMMANDS: CREATE
// ----------------------------------------------------------------------------
  final public AxionCommand SqlCreate() throws ParseException {
    AxionCommand result = null;
    String type = null;
    boolean unique = false;
    jj_consume_token(CREATE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNIQUE:
      jj_consume_token(UNIQUE);
        unique = true;
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
      type = SqlIdentifier();
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TABLE:
      result = SqlCreateTable(type);
      break;
    case INDEX:
      result = SqlCreateIndex(unique,type);
      break;
    case SEQUENCE:
      result = SqlCreateSequence();
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public AxionCommand SqlCreateTable(String type) throws ParseException {
    CreateTableCommand result = new CreateTableCommand();
    result.setType(type);
    String str = null;
    jj_consume_token(TABLE);
    str = SqlIdentifier();
     result.setName(str);
    jj_consume_token(OPENPAREN);
    SqlColumnExpression(result);
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        break label_1;
      }
      jj_consume_token(COMMA);
      SqlColumnExpression(result);
    }
    jj_consume_token(CLOSEPAREN);
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public void SqlColumnExpression(CreateTableCommand result) throws ParseException {
    String[] pair = null;
    Constraint constraint = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHECK:
    case CONSTRAINT:
    case NOT:
    case NULL:
    case PRIMARY:
    case UNIQUE:
      constraint = SqlTableConstraint();
        if(null != constraint) {
            result.addChildCommand(new AddConstraintCommand(result.getName(),constraint));
            constraint = null;
        }
      break;
    case ID:
      pair = SqlColumnDef();
      result.addColumn(pair[0],pair[1]);
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case CHECK:
        case CONSTRAINT:
        case NOT:
        case NULL:
        case PRIMARY:
        case UNIQUE:
          ;
          break;
        default:
          break label_2;
        }
        constraint = SqlColumnConstraint(result.getName(),pair[0]);
        if(null != constraint) {
            result.addChildCommand(new AddConstraintCommand(result.getName(),constraint));
            constraint = null;
        }
      }
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public AxionCommand SqlCreateIndex(boolean unique, String type) throws ParseException {
    CreateIndexCommand result = new CreateIndexCommand();
    result.setUnique(unique);
    result.setType(type);
    String str = null;
    jj_consume_token(INDEX);
     if(_log.isDebugEnabled()) { _log.debug("SqlCreateIndex: consumed \"" + token + "\""); }
    str = SqlIdentifier();
     if(_log.isDebugEnabled()) { _log.debug("SqlCreateIndex: consumed \"" + str + "\""); }
     result.setName(str);
     str = null;
    jj_consume_token(ON);
     if(_log.isDebugEnabled()) { _log.debug("SqlCreateIndex: consumed \"" + token + "\""); }
    str = SqlLValueTerm();
     if(_log.isDebugEnabled()) { _log.debug("SqlCreateIndex: consumed \"" + str + "\""); }
     result.setTable(str);
     str = null;
    jj_consume_token(OPENPAREN);
     if(_log.isDebugEnabled()) { _log.debug("SqlCreateIndex: consumed \"" + token + "\""); }
    str = SqlIdentifier();
     if(_log.isDebugEnabled()) { _log.debug("SqlCreateIndex: consumed \"" + str + "\""); }
     result.addColumn(str);
     str = null;
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        break label_3;
      }
      jj_consume_token(COMMA);
      str = SqlIdentifier();
       if(_log.isDebugEnabled()) { _log.debug("SqlCreateIndex: consumed \"" + str + "\""); }
       result.addColumn(str);
       str = null;
    }
    jj_consume_token(CLOSEPAREN);
     if(_log.isDebugEnabled()) { _log.debug("SqlCreateIndex: consumed \"" + token + "\""); }
     {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public AxionCommand SqlCreateSequence() throws ParseException {
    CreateSequenceCommand result = new CreateSequenceCommand();
    String name = null;
    Token t = null;
    jj_consume_token(SEQUENCE);
     if(_log.isDebugEnabled()) { _log.debug("SqlCreateSequence: consumed \"" + token + "\""); }
    name = SqlIdentifier();
    if(_log.isDebugEnabled()) { _log.debug("SqlCreateSequence: found sequence name  \"" + name + "\""); }
    result.setName(name);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STARTS:
      jj_consume_token(STARTS);
      jj_consume_token(WITH);
      t = jj_consume_token(INTEGER_LITERAL);
          result.setStartValue(t.image);
      break;
    default:
      ;
    }
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

// ----------------------------------------------------------------------------
// COMMANDS: DELETE
// ----------------------------------------------------------------------------
  final public AxionCommand SqlDelete() throws ParseException {
    TableIdentifier table = null;
    Selectable where = null;
    jj_consume_token(DELETE);
    if(_log.isDebugEnabled()) { _log.debug("SqlDelete: consumed \"" + token + "\""); }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FROM:
      jj_consume_token(FROM);
      if(_log.isDebugEnabled()) { _log.debug("SqlDelete: consumed \"" + token + "\""); }
      break;
    default:
      ;
    }
    table = SqlTableRef();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHERE:
      where = SqlWhere();
      break;
    default:
      ;
    }
     {if (true) return new DeleteCommand(table,(WhereNode)where);}
    throw new Error("Missing return statement in function");
  }

// ----------------------------------------------------------------------------
// COMMANDS: ALTER TABLE
// ----------------------------------------------------------------------------
  final public AxionCommand SqlAlterTable() throws ParseException {
    AxionCommand result = null;
    String tablename = null;
    jj_consume_token(ALTER);
    jj_consume_token(TABLE);
    tablename = SqlIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ADD:
      result = SqlAddConstraint(tablename);
      break;
    case DROP:
      result = SqlDropConstraint(tablename);
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public AxionCommand SqlDropConstraint(String tablename) throws ParseException {
    String constraintname = null;
    jj_consume_token(DROP);
    jj_consume_token(CONSTRAINT);
    constraintname = SqlIdentifier();
        {if (true) return new DropConstraintCommand(tablename,constraintname);}
    throw new Error("Missing return statement in function");
  }

  final public AxionCommand SqlAddConstraint(String tablename) throws ParseException {
    Constraint constraint = null;
    jj_consume_token(ADD);
    constraint = SqlTableConstraint();
        if(null == constraint) {
            {if (true) return null;}
        } else {
            {if (true) return new AddConstraintCommand(tablename,constraint);}
        }
    throw new Error("Missing return statement in function");
  }

// ----------------------------------------------------------------------------
// COMMANDS: DROP
// ----------------------------------------------------------------------------
  final public AxionCommand SqlDrop() throws ParseException {
    AxionCommand result = null;
    jj_consume_token(DROP);
     if(_log.isDebugEnabled()) { _log.debug("SqlDrop: consumed \"" + token + "\""); }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TABLE:
      result = SqlDropTable();
      break;
    case SEQUENCE:
      result = SqlDropSequence();
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public AxionCommand SqlDropTable() throws ParseException {
    DropTableCommand result = null;
    String tableName = null;
    boolean exists = false;
    jj_consume_token(TABLE);
       if(_log.isDebugEnabled()) {  _log.debug("SqlDropTable: consumed \"" + token + "\""); }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IF:
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
            exists = true;
      break;
    default:
      ;
    }
    tableName = SqlIdentifier();
       if(_log.isDebugEnabled()) { _log.debug("SqlDropTable: found table name  \"" + tableName + "\""); }
       result = new DropTableCommand(tableName, exists);
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public AxionCommand SqlDropSequence() throws ParseException {
    DropSequenceCommand result = null;
    String sequenceName = null;
    jj_consume_token(SEQUENCE);
       if(_log.isDebugEnabled()) {  _log.debug("SqlDropSequence: consumed \"" + token + "\""); }
    sequenceName = SqlIdentifier();
       if(_log.isDebugEnabled()) { _log.debug("SqlDropSequence: found sequence name  \"" + sequenceName + "\""); }
       result = new DropSequenceCommand(sequenceName);
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

// ----------------------------------------------------------------------------
// COMMANDS: INSERT
// ----------------------------------------------------------------------------
  final public AxionCommand SqlInsert() throws ParseException {
    TableIdentifier table = null;
    List columns = null;
    List values = null;
    jj_consume_token(INSERT);
    jj_consume_token(INTO);
    table = SqlTableRef();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPENPAREN:
      jj_consume_token(OPENPAREN);
      columns = SqlSelectCols();
      jj_consume_token(CLOSEPAREN);
      break;
    default:
      ;
    }
    jj_consume_token(VALUES);
    jj_consume_token(OPENPAREN);
    values = SqlSelectList();
    jj_consume_token(CLOSEPAREN);
    {if (true) return new InsertCommand(table, columns, values);}
    throw new Error("Missing return statement in function");
  }

// ----------------------------------------------------------------------------
// COMMANDS: SELECT
// ----------------------------------------------------------------------------
  final public AxionCommand SqlSelect() throws ParseException {
   SelectCommand result = new SelectCommand();
   List temp = null;
   Selectable where = null;
   List order = null;
   Literal limit = null;
   Literal offset = null;
   FromNode from = null;
    jj_consume_token(SELECT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ALL:
    case DISTINCT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
        jj_consume_token(ALL);
        result.setDistinct(false);
        break;
      case DISTINCT:
        jj_consume_token(DISTINCT);
        result.setDistinct(true);
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      ;
    }
    // can gather all cols here and add to builder as list
      // or one at a time farther down the parse tree
      // problem is, farther down the parse tree, might not
      // know we're getting column identifiers, might need to
      // pass column identifiers back to production where
      // context is obvious
      temp = SqlSelectCols();
    result.setSelect(temp);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FROM:
      jj_consume_token(FROM);
      from = SqlFrom();
         result.setFrom(from);
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHERE:
      where = SqlWhere();
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      order = SqlOrderBy();
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LIMIT:
      limit = SqlSelectLimit();
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OFFSET:
      offset = SqlSelectOffset();
      break;
    default:
      ;
    }
    result.setWhere((WhereNode)where);
    result.setOrderBy(order);
    result.setLimit(limit);
    result.setOffset(offset);
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public List SqlSelectCols() throws ParseException {
  List list = new ArrayList();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CASE:
    case FALSE:
    case NOT:
    case NULL:
    case SYSDATE:
    case TRUE:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case ID:
    case OPENPAREN:
    case ASTERISK:
    case PLUS:
    case MINUS:
    case QUESTIONMARK:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASTERISK:
        jj_consume_token(ASTERISK);
        list.add(new ColumnIdentifier("*"));
        break;
      case CASE:
      case FALSE:
      case NOT:
      case NULL:
      case SYSDATE:
      case TRUE:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case ID:
      case OPENPAREN:
      case PLUS:
      case MINUS:
      case QUESTIONMARK:
        list = SqlSelectList();
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      ;
    }
    {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public Literal SqlSelectLimit() throws ParseException {
  Literal limit = null;
    jj_consume_token(LIMIT);
    limit = SqlNumericLiteralOrBindVar();
    {if (true) return limit;}
    throw new Error("Missing return statement in function");
  }

  final public Literal SqlSelectOffset() throws ParseException {
  Literal offset = null;
    jj_consume_token(OFFSET);
    offset = SqlNumericLiteralOrBindVar();
    {if (true) return offset;}
    throw new Error("Missing return statement in function");
  }

  final public Literal SqlNumericLiteralOrBindVar() throws ParseException {
  Literal value = null;
    value = SqlLiteralOrBindVar();
     try {
        if(!(value instanceof BindVariable || value.evaluate(null) instanceof Number)) {
           {if (true) throw new ParseException("Expected numeric literal or bind variable.");}
        }
     } catch(AxionException e) {
        {if (true) throw new ParseException("AxionException " + e.toString() + " while parsing OFFSET. Shouldn't happen.");}
     }
    {if (true) return value;}
    throw new Error("Missing return statement in function");
  }

  final public Literal SqlLiteralOrBindVar() throws ParseException {
  Literal value = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FALSE:
    case NULL:
    case TRUE:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case ASTERISK:
      value = SqlLiteral();
      break;
    case QUESTIONMARK:
      value = SqlBindVar();
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return value;}
    throw new Error("Missing return statement in function");
  }

// ----------------------------------------------------------------------------
// COMMANDS: UPDATE
// ----------------------------------------------------------------------------
  final public AxionCommand SqlUpdate() throws ParseException {
    TableIdentifier table = null;
    List colvalpairs = new ArrayList();
    Selectable where = null;
    Selectable[] curpair = null;
    jj_consume_token(UPDATE);
    table = SqlTableRef();
    jj_consume_token(SET);
    label_4:
    while (true) {
      curpair = SqlUpdateAssignment();
      colvalpairs.add(curpair);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        jj_consume_token(COMMA);
        break;
      default:
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ID:
        ;
        break;
      default:
        break label_4;
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHERE:
      where = SqlWhere();
      break;
    default:
      ;
    }
        UpdateCommand cmd = new UpdateCommand();
        cmd.setTable(table);
        Iterator iter = colvalpairs.iterator();
        while(iter.hasNext()) {
            Selectable[] pair = (Selectable[])(iter.next());
            cmd.addColumn((ColumnIdentifier)pair[0]);
            cmd.addValue(pair[1]);
        }
        cmd.setWhere((WhereNode)where);
        {if (true) return cmd;}
    throw new Error("Missing return statement in function");
  }

  final public Selectable[] SqlUpdateAssignment() throws ParseException {
    Selectable[] pair = new Selectable[2];
    pair[0] = SqlColumnRef();
    jj_consume_token(EQUAL);
    // akl: Be careful, we may run into "Halloween problem" here. Statements
      // such as "update table t set a = a + 1" tend to go into a infinite
      // recursive loop doing a = a + 1.
      //pair[1] = SqlSelectableElements() // no expressions in update statement.
      pair[1] = SqlSumExprSelectable();
    {if (true) return pair;}
    throw new Error("Missing return statement in function");
  }

// ----------------------------------------------------------------------------
// CONSTRAINTS
// ----------------------------------------------------------------------------
  final public Constraint SqlTableConstraint() throws ParseException {
    Constraint constraint = null;
    String name = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CONSTRAINT:
      jj_consume_token(CONSTRAINT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ID:
        name = SqlIdentifier();
        break;
      default:
        ;
      }
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
    case NULL:
    case PRIMARY:
    case UNIQUE:
      constraint = SqlSelectableBasedConstraintType(name);
      SqlSelectableBasedConstraintArgs((SelectableBasedConstraint)constraint);
      break;
    case CHECK:
      constraint = SqlCheckConstraintType(name);
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (jj_2_1(2)) {
      SqlDeferrable(constraint);
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INITIALLY:
      SqlInitiallyDeferredOrImmediate(constraint);
      break;
    default:
      ;
    }
        {if (true) return constraint;}
    throw new Error("Missing return statement in function");
  }

  final public Constraint SqlColumnConstraint(String tablename, String columnname) throws ParseException {
    Constraint constraint = null;
    String name = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CONSTRAINT:
      jj_consume_token(CONSTRAINT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ID:
        name = SqlIdentifier();
        break;
      default:
        ;
      }
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
    case NULL:
    case PRIMARY:
    case UNIQUE:
      constraint = SqlSelectableBasedConstraintType(name);
                ((SelectableBasedConstraint)constraint).addSelectable(new ColumnIdentifier(new TableIdentifier(tablename),columnname));
      break;
    case CHECK:
      constraint = SqlCheckConstraintType(name);
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (jj_2_2(2)) {
      SqlDeferrable(constraint);
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INITIALLY:
      SqlInitiallyDeferredOrImmediate(constraint);
      break;
    default:
      ;
    }
        {if (true) return constraint;}
    throw new Error("Missing return statement in function");
  }

  final public SelectableBasedConstraint SqlSelectableBasedConstraintType(String constraintname) throws ParseException {
    SelectableBasedConstraint constraint = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PRIMARY:
      jj_consume_token(PRIMARY);
      jj_consume_token(KEY);
                constraint = new PrimaryKeyConstraint(constraintname);
      break;
    case NULL:
      jj_consume_token(NULL);
                constraint = new NullConstraint(constraintname);
      break;
    case NOT:
      jj_consume_token(NOT);
      jj_consume_token(NULL);
                constraint = new NotNullConstraint(constraintname);
      break;
    case UNIQUE:
      jj_consume_token(UNIQUE);
                constraint = new UniqueConstraint(constraintname);
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return constraint;}
    throw new Error("Missing return statement in function");
  }

  final public CheckConstraint SqlCheckConstraintType(String constraintname) throws ParseException {
    CheckConstraint constraint = null;
    Selectable where = null;
    jj_consume_token(CHECK);
            constraint = new CheckConstraint(constraintname);
    jj_consume_token(OPENPAREN);
    where = SqlWhereOr();
    jj_consume_token(CLOSEPAREN);
            constraint.setCondition((WhereNode)where);
        {if (true) return constraint;}
    throw new Error("Missing return statement in function");
  }

  final public void SqlSelectableBasedConstraintArgs(SelectableBasedConstraint constraint) throws ParseException {
    Selectable selectable = null;
    jj_consume_token(OPENPAREN);
    selectable = SqlSelectableElements();
      constraint.addSelectable(selectable);
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        break label_5;
      }
      jj_consume_token(COMMA);
      selectable = SqlSelectableElements();
        constraint.addSelectable(selectable);
    }
    jj_consume_token(CLOSEPAREN);
  }

  final public void SqlDeferrable(Constraint constraint) throws ParseException {
    boolean deferrable = true;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
            deferrable = false;
      break;
    default:
      ;
    }
    jj_consume_token(DEFERRABLE);
        constraint.setDeferrable(deferrable);
  }

  final public void SqlInitiallyDeferredOrImmediate(Constraint constraint) throws ParseException {
    jj_consume_token(INITIALLY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DEFERRED:
      jj_consume_token(DEFERRED);
                try {
                    constraint.setDeferred(true);
                } catch(AxionException e) {
                    {if (true) throw new ParseException("Constraint not deferrable (use DEFERRABLE before INITIALLY DEFERRED)");}
                }
      break;
    case IMMEDIATE:
      jj_consume_token(IMMEDIATE);
                try {
                    constraint.setDeferred(false);
                } catch(AxionException e) {
                    {if (true) throw new ParseException("Constraint not deferrable (use DEFERRABLE)");}
                }
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

// ----------------------------------------------------------------------------
// GENERIC STUFF (IDENTIFIERS, LITERALS, ETC.)
// ----------------------------------------------------------------------------
  final public String SqlIdentifier() throws ParseException {
   Token t = null;
    t = jj_consume_token(ID);
      {if (true) return t.image;}
    throw new Error("Missing return statement in function");
  }

  final public List SqlIdentifierList() throws ParseException {
   List result = new ArrayList();
   String curIdent = null;
    curIdent = SqlIdentifier();
      result.add(curIdent);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      curIdent = SqlIdentifier();
         result.add(curIdent);
      break;
    default:
      ;
    }
      {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public BindVariable SqlBindVar() throws ParseException {
    jj_consume_token(QUESTIONMARK);
      {if (true) return new BindVariable();}
    throw new Error("Missing return statement in function");
  }

  final public String[] SqlColumnDef() throws ParseException {
    String[] pair = new String[2];
    pair[0] = SqlLValueTerm();
    pair[1] = SqlLValueTerm();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPENPAREN:
      jj_consume_token(OPENPAREN);
      jj_consume_token(INTEGER_LITERAL);
      label_6:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          break label_6;
        }
        jj_consume_token(COMMA);
        jj_consume_token(INTEGER_LITERAL);
      }
      jj_consume_token(CLOSEPAREN);
      break;
    default:
      ;
    }
        {if (true) return pair;}
    throw new Error("Missing return statement in function");
  }

  final public ColumnIdentifier SqlColumnRef() throws ParseException {
   String column = null;
    column = SqlLValueTerm();
      {if (true) return new ColumnIdentifier(column);}
    throw new Error("Missing return statement in function");
  }

  final public Selectable SqlCase() throws ParseException {
    List   caseargs = new ArrayList();
    List   whenargs = null;
    //
    Selectable condition = null;
    Selectable thenArg = null;
    Selectable elseArg = null;
    //
    FunctionIdentifier whenFn = null;
    FunctionIdentifier caseFn = null;
    jj_consume_token(CASE);
    label_7:
    while (true) {
      jj_consume_token(WHEN);
      condition = SqlWhereOr();
                whenargs = new ArrayList();
                whenargs.add((WhereNode)condition);
      jj_consume_token(THEN);
      thenArg = SqlSelectable();
                whenargs.add(thenArg);
                whenFn = new FunctionIdentifier("IFTHEN", whenargs);
                caseargs.add(whenFn);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHEN:
        ;
        break;
      default:
        break label_7;
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ELSE:
      jj_consume_token(ELSE);
      elseArg = SqlSelectable();
            caseargs.add(elseArg);
      break;
    default:
      ;
    }
    jj_consume_token(END);
        caseFn = new FunctionIdentifier("COALESCE", caseargs);
        {if (true) return (caseFn);}
    throw new Error("Missing return statement in function");
  }

  final public Selectable SqlPseudoColumn() throws ParseException {
    Selectable sel = null;
    jj_consume_token(SYSDATE);
        if(_log.isDebugEnabled()) { _log.debug("SqlPseudoColumn: consumed \"" + token + "\""); }
        sel = new FunctionIdentifier("now",Collections.EMPTY_LIST);
    {if (true) return sel;}
    throw new Error("Missing return statement in function");
  }

  final public Selectable SqlFunction() throws ParseException {
  String name = null;
  List fnargs = null;
    jj_consume_token(ID);
        if(_log.isDebugEnabled()) { _log.debug("SqlFunction: consumed \"" + token + "\""); }
        name = token.image;
    fnargs = SqlFunctionArgs();
    {if (true) return new FunctionIdentifier(name,fnargs);}
    throw new Error("Missing return statement in function");
  }

  final public List SqlFunctionArgs() throws ParseException {
    List args = new ArrayList();
    jj_consume_token(OPENPAREN);
    args = SqlSelectCols();
    jj_consume_token(CLOSEPAREN);
    {if (true) return args;}
    throw new Error("Missing return statement in function");
  }

  final public Selectable SqlSumExprSelectable() throws ParseException {
        Selectable sel = null;
        Selectable temp = null;
        short operation = -1;
        Selectable prv = null;
    sel = SqlProductExprSelectable();
    label_8:
    while (true) {
      if (jj_2_3(2)) {
        ;
      } else {
        break label_8;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        jj_consume_token(PLUS);
                                  operation = ExpressionIdentifier.PLUS_OPERATION;
        break;
      case MINUS:
        jj_consume_token(MINUS);
                                    operation = ExpressionIdentifier.MINUS_OPERATION;
        break;
      case CONCAT:
        jj_consume_token(CONCAT);
                                     operation = ExpressionIdentifier.CONCAT_OPERATION;
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      temp = SqlProductExprSelectable();
                           ExpressionIdentifier expr = new ExpressionIdentifier("Sum");
                           if(prv == null){
                                prv = sel;
                           }
                           expr.setLeftSelectable(prv);
                           expr.setRightSelectable(temp);
                           expr.setOperationType(operation);
                           prv = expr;
    }
        if(null==prv){
                 {if (true) return sel;}
        }
        else{
                {if (true) return  prv;}
        }
    throw new Error("Missing return statement in function");
  }

  final public Selectable SqlProductExprSelectable() throws ParseException {
        Selectable sel = null;
        Selectable temp = null;
        short operation = -1;
    Selectable prv = null;
    sel = SqlParenthExprSelectable();
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASTERISK:
      case SLASH:
        ;
        break;
      default:
        break label_9;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASTERISK:
        jj_consume_token(ASTERISK);
                    operation = ExpressionIdentifier.MULT_OPERATION;
        break;
      case SLASH:
        jj_consume_token(SLASH);
                     operation = ExpressionIdentifier.DIV_OPERATION;
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      temp = SqlParenthExprSelectable();
            ExpressionIdentifier expr = new ExpressionIdentifier("Product");
            if(prv == null){
                prv = sel;
            }
            expr.setLeftSelectable(prv);
            expr.setRightSelectable(temp);
            expr.setOperationType(operation);
            prv = expr;
    }
         if(null==prv){
                 {if (true) return sel;}
        }
        else{
                {if (true) return  prv;}
        }
    throw new Error("Missing return statement in function");
  }

  final public Selectable SqlParenthExprSelectable() throws ParseException {
        Selectable sel = null;
    if (jj_2_4(3)) {
      jj_consume_token(OPENPAREN);
      sel = SqlSumExprSelectable();
      jj_consume_token(CLOSEPAREN);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CASE:
      case FALSE:
      case NULL:
      case SYSDATE:
      case TRUE:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case ID:
      case ASTERISK:
      case PLUS:
      case MINUS:
      case QUESTIONMARK:
        sel = SqlUnaryExprSelectable();
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    }

  {if (true) return sel;}
    throw new Error("Missing return statement in function");
  }

  final public Selectable SqlUnaryExprSelectable() throws ParseException {
        //UnaryExpression unary = null;
        Selectable sel = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
    case MINUS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        jj_consume_token(PLUS);

        break;
      case MINUS:
        jj_consume_token(MINUS);

        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      ;
    }
    sel = SqlSelectableElements();

  {if (true) return sel;}
    throw new Error("Missing return statement in function");
  }

  final public List SqlLiteralList() throws ParseException {
   List result = new ArrayList();
   Object cur = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FALSE:
    case NULL:
    case TRUE:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case ASTERISK:
      cur = SqlLiteral();
      break;
    case QUESTIONMARK:
      cur = SqlBindVar();
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
      result.add(cur);
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        break label_10;
      }
      jj_consume_token(COMMA);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FALSE:
      case NULL:
      case TRUE:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case ASTERISK:
        cur = SqlLiteral();
        break;
      case QUESTIONMARK:
        cur = SqlBindVar();
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
         result.add(cur);
    }
      {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public String SqlLValue() throws ParseException {
  String s = null;
    s = SqlLValueTerm();
    {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public Literal SqlLiteral() throws ParseException {
   Literal literal = null;
   Token t = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING_LITERAL:
      t = jj_consume_token(STRING_LITERAL);
      if(_log.isDebugEnabled()) { _log.debug("SqlLiteral: consumed \"" + token + "\""); }
      // trim off the open and close quotes
      String trimmed = t.image.substring(1, t.image.length() - 1);
      // replace all '' with '
      String result = replace(trimmed,"''","'");
      literal = new Literal(result,new StringType());
      if(_log.isDebugEnabled()) { _log.debug("SqlLiteral: result \"" + result + "\""); }
      break;
    case INTEGER_LITERAL:
      t = jj_consume_token(INTEGER_LITERAL);
      if(_log.isDebugEnabled()) { _log.debug("SqlLiteral: consumed \"" + token + "\""); }
      literal = new Literal(new Long(t.image), new LongType());
      break;
    case FLOATING_POINT_LITERAL:
      t = jj_consume_token(FLOATING_POINT_LITERAL);
      if(_log.isDebugEnabled()) { _log.debug("SqlLiteral: consumed \"" + token + "\""); }
      literal = new Literal(new Float(t.image),new FloatType());
      break;
    case NULL:
      jj_consume_token(NULL);
      if(_log.isDebugEnabled()) { _log.debug("SqlLiteral: consumed \"" + token + "\""); }
      literal = new Literal(null);
      break;
    case TRUE:
      jj_consume_token(TRUE);
      if(_log.isDebugEnabled()) { _log.debug("SqlLiteral: consumed \"" + token + "\""); }
      literal = new Literal(Boolean.TRUE,new BooleanType());
      break;
    case FALSE:
      jj_consume_token(FALSE);
      if(_log.isDebugEnabled()) { _log.debug("SqlLiteral: consumed \"" + token + "\""); }
      literal = new Literal(Boolean.FALSE,new BooleanType());
      break;
    case ASTERISK:
      jj_consume_token(ASTERISK);
      if(_log.isDebugEnabled()) { _log.debug("SqlLiteral: consumed \"" + token + "\""); }
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return literal;}
    throw new Error("Missing return statement in function");
  }

  final public String SqlLValueTerm() throws ParseException {
  StringBuffer buffer = new StringBuffer();
  Token t = null;
    t = jj_consume_token(ID);
    buffer.append(t.image);
    if(_log.isDebugEnabled()) { _log.debug("SqlLValueTerm: consumed \"" + token + "\""); }
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
        ;
        break;
      default:
        break label_11;
      }
      t = jj_consume_token(DOT);
      buffer.append(t.image);
      if(_log.isDebugEnabled()) { _log.debug("SqlLValueTerm: consumed \"" + token + "\""); }
      t = jj_consume_token(ID);
      buffer.append(t.image);
      if(_log.isDebugEnabled()) { _log.debug("SqlLValueTerm: consumed \"" + token + "\""); }
    }
    {if (true) return buffer.toString();}
    throw new Error("Missing return statement in function");
  }

  final public Selectable SqlSelectable() throws ParseException {
        Selectable sel = null;
    sel = SqlWhereOr();
                {if (true) return sel;}
    throw new Error("Missing return statement in function");
  }

  final public Selectable SqlSelectableElements() throws ParseException {
   Selectable sel = null;
    if (jj_2_5(2)) {
      sel = SqlFunction();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ID:
        sel = SqlColumnRef();
        break;
      case FALSE:
      case NULL:
      case TRUE:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case ASTERISK:
        sel = SqlLiteral();
        break;
      case QUESTIONMARK:
        sel = SqlBindVar();
        break;
      case CASE:
        sel = SqlCase();
        break;
      case SYSDATE:
        sel = SqlPseudoColumn();
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
      {if (true) return sel;}
    throw new Error("Missing return statement in function");
  }

  final public List SqlSelectList() throws ParseException {
  List list = new ArrayList();
  Selectable curCol = null;
    curCol = SqlSelectable();
      list.add(curCol);
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        break label_12;
      }
      jj_consume_token(COMMA);
      if(_log.isDebugEnabled()) { _log.debug("SqlSelectList: consumed \"" + token + "\""); }
      curCol = SqlSelectable();
      list.add(curCol);
    }
    {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public TableIdentifier SqlTableRef() throws ParseException {
  Token t = null;
  String name = null;
  String alias = null;
    t = jj_consume_token(ID);
    name = t.image;
    if(_log.isDebugEnabled()) { _log.debug("SqlTableRef: consumed \"" + token + "\""); }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
      t = jj_consume_token(ID);
      alias = t.image;
      if(_log.isDebugEnabled()) { _log.debug("SqlTableRef: consumed \"" + token + "\""); }
      break;
    default:
      ;
    }
    {if (true) return new TableIdentifier(name, alias);}
    throw new Error("Missing return statement in function");
  }

  final public void SqlLValueList() throws ParseException {
    SqlLValueElement();
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        break label_13;
      }
      jj_consume_token(COMMA);
     if(_log.isDebugEnabled()) { _log.debug("SqlValueList: consumed \"" + token + "\""); }
      SqlLValueElement();
    }
  }

  final public void SqlLValueElement() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NULL:
      jj_consume_token(NULL);
    if(_log.isDebugEnabled()) { _log.debug("SqlValueElement: consumed \"" + token + "\""); }
      break;
    case SELECT:
      SqlSelect();
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

// ----------------------------------------------------------------------------
// ORDER BY CLAUSE
// ----------------------------------------------------------------------------
  final public List SqlOrderBy() throws ParseException {
   List result = null;
    jj_consume_token(ORDER);
     if(_log.isDebugEnabled()) { _log.debug("SqlOrderBy: consumed \"" + token + "\""); }
    jj_consume_token(BY);
     if(_log.isDebugEnabled()) { _log.debug("SqlOrderBy: consumed \"" + token + "\""); }
    result = SqlOrderByList();
      {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public OrderNode SqlOrderByElem() throws ParseException {
   Selectable sel = null;
   boolean ascending = true;
    sel = SqlSelectableElements();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASC:
    case DESC:
      ascending = SqlOrderDirection();
      break;
    default:
      ;
    }
      {if (true) return new OrderNode(sel, !ascending);}
    throw new Error("Missing return statement in function");
  }

  final public List SqlOrderByList() throws ParseException {
   List result = new ArrayList();
   OrderNode cur = null;
    cur = SqlOrderByElem();
      result.add(cur);
    label_14:
    while (true) {
      if (jj_2_6(2)) {
        ;
      } else {
        break label_14;
      }
      jj_consume_token(COMMA);
        if(_log.isDebugEnabled()) { _log.debug("SqlOrderByList: consumed \"" + token + "\""); }
      cur = SqlOrderByElem();
         result.add(cur);
    }
      {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public boolean SqlOrderDirection() throws ParseException {
   boolean ascending = true;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASC:
      jj_consume_token(ASC);
      if(_log.isDebugEnabled()) { _log.debug("SqlOrderDirection: consumed \"" + token + "\""); }
      break;
    case DESC:
      jj_consume_token(DESC);
      if(_log.isDebugEnabled()) { _log.debug("SqlOrderDirection: consumed \"" + token + "\""); }
      ascending = false;
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
   {if (true) return ascending;}
    throw new Error("Missing return statement in function");
  }

// ----------------------------------------------------------------------------
// FROM CLAUSE
// ----------------------------------------------------------------------------
  final public FromNode SqlFrom() throws ParseException {
    FromNode node = new FromNode();
    TableIdentifier curTable = null;
    curTable = SqlTableRef();
        node.setLeft(curTable);
        node.setType(FromNode.TYPE_SINGLE);
        node.setCondition(null);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INNER:
    case JOIN:
    case LEFT:
    case RIGHT:
    case COMMA:
      if (jj_2_7(2)) {
        node = SqlTableList(node);
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INNER:
        case JOIN:
        case LEFT:
        case RIGHT:
          node = SqlJoin(node);
          break;
        default:
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
    default:
      ;
    }
        {if (true) return (node);}
    throw new Error("Missing return statement in function");
  }

  final public FromNode SqlTableList(FromNode node) throws ParseException {
    FromNode temp = null;
    TableIdentifier curTable = null;
    label_15:
    while (true) {
      jj_consume_token(COMMA);
     if (temp != null) {
       temp.setLeft(node);
       node = temp;
       temp = null;
     }

     node.setCondition(null);
     node.setType(FromNode.TYPE_INNER);
      curTable = SqlTableRef();
     node.setRight(curTable);
     temp = new FromNode();
      if (jj_2_8(2)) {
        ;
      } else {
        break label_15;
      }
    }
    {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

  final public FromNode SqlJoin(FromNode node) throws ParseException {
    FromNode temp = null;
    Selectable condition = null;
    TableIdentifier curTable = null;
    int curType = -1;
    label_16:
    while (true) {
      curType = SqlJoinType();
          if (temp != null) {
            temp.setLeft(node);
            node = temp;
            temp = null;
          }
          node.setType(curType);
      curTable = SqlTableRef();
          node.setRight(curTable);
      jj_consume_token(ON);
      jj_consume_token(OPENPAREN);
      condition = SqlWhereOr();
          node.setCondition((WhereNode)condition);
      jj_consume_token(CLOSEPAREN);
          temp = new FromNode();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INNER:
      case JOIN:
      case LEFT:
      case RIGHT:
        ;
        break;
      default:
        break label_16;
      }
    }
      {if (true) return (node);}
    throw new Error("Missing return statement in function");
  }

  final public int SqlJoinType() throws ParseException {
    int type = FromNode.TYPE_UNDEFINED;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LEFT:
      jj_consume_token(LEFT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OUTER:
        jj_consume_token(OUTER);
        break;
      default:
        ;
      }
      jj_consume_token(JOIN);
         type = FromNode.TYPE_LEFT;
      break;
    case RIGHT:
      jj_consume_token(RIGHT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OUTER:
        jj_consume_token(OUTER);
        break;
      default:
        ;
      }
      jj_consume_token(JOIN);
         type = FromNode.TYPE_RIGHT;
      break;
    case INNER:
    case JOIN:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INNER:
        jj_consume_token(INNER);
        break;
      default:
        ;
      }
      jj_consume_token(JOIN);
         type = FromNode.TYPE_INNER;
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return (type);}
    throw new Error("Missing return statement in function");
  }

// ----------------------------------------------------------------------------
// GROUP BY CLAUSE
// ----------------------------------------------------------------------------
  final public void SqlGroupBy() throws ParseException {
    jj_consume_token(GROUP);
    if(_log.isDebugEnabled()) { _log.debug("SqlGroupBy: consumed \"" + token + "\""); }
    jj_consume_token(BY);
    if(_log.isDebugEnabled()) { _log.debug("SqlGroupBy: consumed \"" + token + "\""); }
    SqlOrderByList();
  }

// ----------------------------------------------------------------------------
// WHERE CLAUSE
// ----------------------------------------------------------------------------
  final public Selectable SqlWhere() throws ParseException {
   Selectable result = null;
    jj_consume_token(WHERE);
     if(_log.isDebugEnabled()) { _log.debug("SqlWhere: consumed \"" + token + "\""); }
    result = SqlWhereOr();
      {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public Selectable SqlWhereOr() throws ParseException {
   BinaryBranchWhereNode parent = null;
   Selectable left = null;
   Selectable right = null;
   Selectable result = null;
    left = SqlWhereAnd();
      result = left;
    label_17:
    while (true) {
      if (jj_2_9(2)) {
        ;
      } else {
        break label_17;
      }
      jj_consume_token(OR);
       if(_log.isDebugEnabled()) { _log.debug("SqlWhereOr: consumed \"" + token + "\""); }
      right = SqlWhereAnd();
         parent = new BinaryBranchWhereNode();
         parent.setLeft((WhereNode)left);
         parent.setRight((WhereNode)right);
         parent.setIsOr(true);
         left = (Selectable) parent;
         result = (Selectable) parent;
    }
      {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public Selectable SqlWhereAnd() throws ParseException {
   BinaryBranchWhereNode parent = null;
   Selectable left = null;
   Selectable right = null;
   Selectable result = null;
    left = SqlWhereNot();
      result = left;
    label_18:
    while (true) {
      if (jj_2_10(2)) {
        ;
      } else {
        break label_18;
      }
      jj_consume_token(AND);
       if(_log.isDebugEnabled()) { _log.debug("SqlWhereAnd: consumed \"" + token + "\""); }
      right = SqlWhereNot();
         parent = new BinaryBranchWhereNode();
         parent.setLeft((WhereNode)left);
         parent.setRight((WhereNode)right);
         parent.setIsAnd(true);
         left = (Selectable) parent;
         result = (Selectable) parent;
    }
      {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public Selectable SqlWhereNot() throws ParseException {
   Selectable child = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
         if(_log.isDebugEnabled()) { _log.debug("SqlWhereNot: consumed \"" + token + "\""); }
      child = SqlWhereElt();
         {if (true) return ((Selectable)new NotWhereNode((WhereNode)child));}
      break;
    case CASE:
    case FALSE:
    case NULL:
    case SYSDATE:
    case TRUE:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case ID:
    case OPENPAREN:
    case ASTERISK:
    case PLUS:
    case MINUS:
    case QUESTIONMARK:
      child = SqlWhereElt();
     {if (true) return child;}
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Selectable SqlWhereElt() throws ParseException {
   Selectable result = null;
    if (jj_2_11(6)) {
      result = SqlCompareExpr();
         {if (true) return result;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OPENPAREN:
        jj_consume_token(OPENPAREN);
        result = SqlWhereOr();
        jj_consume_token(CLOSEPAREN);
         {if (true) return result;}
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public Selectable SqlCompareExpr() throws ParseException {
   Selectable left = null;
   Selectable right = null;
   ComparisonOperator op = null;
   Selectable[] endpts = null;
   List elements = null;
   Selectable result = null;
    left = SqlSumExprSelectable();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BETWEEN:
    case IN:
    case IS:
    case LIKE:
    case LESS:
    case LESSEQUAL:
    case GREATER:
    case GREATEREQUAL:
    case EQUAL:
    case NOTEQUAL:
    case NOTEQUAL2:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IS:
        op = SqlIsClause();
        result = new LeafWhereNode(left, op, null);
        break;
      case BETWEEN:
        endpts = SqlBetweenClause();
        BinaryBranchWhereNode between = new BinaryBranchWhereNode();
        between.setIsAnd(true);
        between.setLeft(new LeafWhereNode(left, ComparisonOperator.GREATER_THAN_OR_EQUAL, endpts[0]));
        between.setRight(new LeafWhereNode(left, ComparisonOperator.LESS_THAN_OR_EQUAL, endpts[1]));
        result = between;
        break;
      case LESS:
      case LESSEQUAL:
      case GREATER:
      case GREATEREQUAL:
      case EQUAL:
      case NOTEQUAL:
      case NOTEQUAL2:
        op = SqlCompareOp();
        right = SqlSumExprSelectable();
        result = new LeafWhereNode(left, op, right);
        break;
      case IN:
        jj_consume_token(IN);
        jj_consume_token(OPENPAREN);
        elements = SqlLiteralList();
        jj_consume_token(CLOSEPAREN);
         result = new InWhereNode(left, elements);
        break;
      case LIKE:
        jj_consume_token(LIKE);
        right = SqlSumExprSelectable();
         List likeArgs = new ArrayList();
         likeArgs.add(right);
         FunctionIdentifier like = new FunctionIdentifier("like2regexp", likeArgs);

         List matchArgs = new ArrayList();
         matchArgs.add(left);
         matchArgs.add(like);
         FunctionIdentifier matches = new FunctionIdentifier("matches", matchArgs);

         Literal troo = new Literal(Boolean.TRUE, new BooleanType());
         result = new LeafWhereNode(matches, ComparisonOperator.EQUAL, troo);
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      ;
    }
        if (result == null) {
            result = left;
        }
        {if (true) return (result);}
    throw new Error("Missing return statement in function");
  }

  final public ComparisonOperator SqlCompareOp() throws ParseException {
   ComparisonOperator result = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EQUAL:
      jj_consume_token(EQUAL);
         if(_log.isDebugEnabled()) { _log.debug("SqlCompareOp: consumed \"" + token + "\""); }
         result = ComparisonOperator.EQUAL;
      break;
    case NOTEQUAL:
      jj_consume_token(NOTEQUAL);
         if(_log.isDebugEnabled()) { _log.debug("SqlCompareOp: consumed \"" + token + "\""); }
         result = ComparisonOperator.NOT_EQUAL;
      break;
    case NOTEQUAL2:
      jj_consume_token(NOTEQUAL2);
         if(_log.isDebugEnabled()) { _log.debug("SqlCompareOp: consumed \"" + token + "\""); }
         result = ComparisonOperator.NOT_EQUAL;
      break;
    case GREATER:
      jj_consume_token(GREATER);
         if(_log.isDebugEnabled()) { _log.debug("SqlCompareOp: consumed \"" + token + "\""); }
         result = ComparisonOperator.GREATER_THAN;
      break;
    case GREATEREQUAL:
      jj_consume_token(GREATEREQUAL);
         if(_log.isDebugEnabled()) { _log.debug("SqlCompareOp: consumed \"" + token + "\""); }
         result = ComparisonOperator.GREATER_THAN_OR_EQUAL;
      break;
    case LESS:
      jj_consume_token(LESS);
         if(_log.isDebugEnabled()) { _log.debug("SqlCompareOp: consumed \"" + token + "\""); }
         result = ComparisonOperator.LESS_THAN;
      break;
    case LESSEQUAL:
      jj_consume_token(LESSEQUAL);
         if(_log.isDebugEnabled()) { _log.debug("SqlCompareOp: consumed \"" + token + "\""); }
         result = ComparisonOperator.LESS_THAN_OR_EQUAL;
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public ComparisonOperator SqlIsClause() throws ParseException {
   boolean foundnot = false;
    jj_consume_token(IS);
    if(_log.isDebugEnabled()) { _log.debug("SqlIsClause: consumed \"" + token + "\""); }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
     if(_log.isDebugEnabled()) { _log.debug("SqlIsClause: consumed \"" + token + "\""); }
     foundnot = true;
      break;
    default:
      ;
    }
    jj_consume_token(NULL);
     if(_log.isDebugEnabled()) { _log.debug("SqlIsClause: consumed \"" + token + "\""); }
     {if (true) return (foundnot ? ComparisonOperator.IS_NOT_NULL : ComparisonOperator.IS_NULL);}
    throw new Error("Missing return statement in function");
  }

  final public Selectable[] SqlBetweenClause() throws ParseException {
   Selectable[] pair = new Selectable[2];
    jj_consume_token(BETWEEN);
    if(_log.isDebugEnabled()) { _log.debug("SqlBetweenClause: consumed \"" + token + "\""); }
    pair[0] = SqlSumExprSelectable();
    jj_consume_token(AND);
    if(_log.isDebugEnabled()) { _log.debug("SqlBetweenClause: consumed \"" + token + "\""); }
    pair[1] = SqlSumExprSelectable();
    {if (true) return pair;}
    throw new Error("Missing return statement in function");
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    return !jj_3_1();
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    return !jj_3_2();
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    return !jj_3_3();
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    return !jj_3_4();
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    return !jj_3_5();
  }

  final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    return !jj_3_6();
  }

  final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    return !jj_3_7();
  }

  final private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    return !jj_3_8();
  }

  final private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    return !jj_3_9();
  }

  final private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    return !jj_3_10();
  }

  final private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    return !jj_3_11();
  }

  final private boolean jj_3R_35() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_5()) {
    jj_scanpos = xsp;
    if (jj_3R_41()) {
    jj_scanpos = xsp;
    if (jj_3R_42()) {
    jj_scanpos = xsp;
    if (jj_3R_43()) {
    jj_scanpos = xsp;
    if (jj_3R_44()) {
    jj_scanpos = xsp;
    if (jj_3R_45()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_3R_19()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_8() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_28()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_27() {
    Token xsp;
    if (jj_3_8()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_8()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_62() {
    if (jj_scan_token(BETWEEN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_24()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(AND)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_24()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_22() {
    if (jj_scan_token(CONCAT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_21() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_94() {
    if (jj_3R_93()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_20() {
    if (jj_scan_token(PLUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_10() {
    if (jj_scan_token(AND)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_30()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_29() {
    if (jj_3R_30()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_10()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3_7() {
    if (jj_3R_27()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_74() {
    if (jj_scan_token(NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_3() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_20()) {
    jj_scanpos = xsp;
    if (jj_3R_21()) {
    jj_scanpos = xsp;
    if (jj_3R_22()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_23()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_24() {
    if (jj_3R_23()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_3()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_61() {
    if (jj_scan_token(IS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_74()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(NULL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_90() {
    if (jj_scan_token(DOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_81() {
    if (jj_scan_token(LESSEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_66() {
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_90()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3_9() {
    if (jj_scan_token(OR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_29()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_80() {
    if (jj_scan_token(LESS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_93() {
    if (jj_3R_29()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_9()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_79() {
    if (jj_scan_token(GREATEREQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_34() {
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_92()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(CLOSEPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_73() {
    if (jj_scan_token(ASTERISK)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_78() {
    if (jj_scan_token(GREATER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_32() {
    if (jj_scan_token(NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_72() {
    if (jj_scan_token(FALSE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_77() {
    if (jj_scan_token(NOTEQUAL2)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_19() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_32()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(DEFERRABLE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_71() {
    if (jj_scan_token(TRUE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_76() {
    if (jj_scan_token(NOTEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_25() {
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_34()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_70() {
    if (jj_scan_token(NULL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_6() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_26()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_75() {
    if (jj_scan_token(EQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_45() {
    if (jj_3R_59()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_69() {
    if (jj_scan_token(FLOATING_POINT_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_39() {
    if (jj_3R_52()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_63() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_75()) {
    jj_scanpos = xsp;
    if (jj_3R_76()) {
    jj_scanpos = xsp;
    if (jj_3R_77()) {
    jj_scanpos = xsp;
    if (jj_3R_78()) {
    jj_scanpos = xsp;
    if (jj_3R_79()) {
    jj_scanpos = xsp;
    if (jj_3R_80()) {
    jj_scanpos = xsp;
    if (jj_3R_81()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_68() {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_59() {
    if (jj_scan_token(SYSDATE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_67() {
    if (jj_scan_token(STRING_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_26() {
    if (jj_3R_35()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_44() {
    if (jj_3R_58()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_56() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_67()) {
    jj_scanpos = xsp;
    if (jj_3R_68()) {
    jj_scanpos = xsp;
    if (jj_3R_69()) {
    jj_scanpos = xsp;
    if (jj_3R_70()) {
    jj_scanpos = xsp;
    if (jj_3R_71()) {
    jj_scanpos = xsp;
    if (jj_3R_72()) {
    jj_scanpos = xsp;
    if (jj_3R_73()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_88() {
    if (jj_3R_57()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_91() {
    if (jj_scan_token(ELSE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_83() {
    if (jj_3R_57()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_51() {
    if (jj_scan_token(LIKE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_24()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_50() {
    if (jj_scan_token(IN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_64()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(CLOSEPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_43() {
    if (jj_3R_57()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_87() {
    if (jj_3R_56()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_49() {
    if (jj_3R_63()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_24()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_84() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_87()) {
    jj_scanpos = xsp;
    if (jj_3R_88()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_89() {
    if (jj_scan_token(WHEN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_93()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(THEN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_94()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_48() {
    if (jj_3R_62()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_82() {
    if (jj_3R_56()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_64() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_82()) {
    jj_scanpos = xsp;
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_84()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_58() {
    if (jj_scan_token(CASE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    if (jj_3R_89()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_89()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    xsp = jj_scanpos;
    if (jj_3R_91()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(END)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_38() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_47()) {
    jj_scanpos = xsp;
    if (jj_3R_48()) {
    jj_scanpos = xsp;
    if (jj_3R_49()) {
    jj_scanpos = xsp;
    if (jj_3R_50()) {
    jj_scanpos = xsp;
    if (jj_3R_51()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_47() {
    if (jj_3R_61()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_86() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_85() {
    if (jj_scan_token(PLUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_31() {
    if (jj_3R_24()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_38()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_65() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_85()) {
    jj_scanpos = xsp;
    if (jj_3R_86()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_42() {
    if (jj_3R_56()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_52() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_65()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_35()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_55() {
    if (jj_3R_66()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_24()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(CLOSEPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_60() {
    if (jj_scan_token(OPENPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_93()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(CLOSEPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_33() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_4()) {
    jj_scanpos = xsp;
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_97() {
    if (jj_3R_98()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_28() {
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_41() {
    if (jj_3R_55()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_96() {
    if (jj_scan_token(ASTERISK)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_95() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_96()) {
    jj_scanpos = xsp;
    if (jj_3R_97()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_3R_19()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_11() {
    if (jj_3R_31()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_46() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_11()) {
    jj_scanpos = xsp;
    if (jj_3R_60()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_92() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_95()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_37() {
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_57() {
    if (jj_scan_token(QUESTIONMARK)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_99() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_94()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_54() {
    if (jj_scan_token(SLASH)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_53() {
    if (jj_scan_token(ASTERISK)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_40() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_53()) {
    jj_scanpos = xsp;
    if (jj_3R_54()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_33()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_98() {
    if (jj_3R_94()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_99()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_36() {
    if (jj_scan_token(NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_30() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_36()) {
    jj_scanpos = xsp;
    if (jj_3R_37()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_23() {
    if (jj_3R_33()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_40()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3_5() {
    if (jj_3R_25()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  public AxionSqlParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;

  public AxionSqlParser(java.io.InputStream stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new AxionSqlParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
  }

  public AxionSqlParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new AxionSqlParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
  }

  public AxionSqlParser(AxionSqlParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
  }

  public void ReInit(AxionSqlParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      return token;
    }
    token = oldToken;
    throw generateParseException();
  }

  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    return (jj_scanpos.kind != kind);
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  final public ParseException generateParseException() {
    Token errortok = token.next;
    int line = errortok.beginLine, column = errortok.beginColumn;
    String mess = (errortok.kind == 0) ? tokenImage[0] : errortok.image;
    return new ParseException("Parse error at line " + line + ", column " + column + ".  Encountered: " + mess);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

}
