/*
 * $Id: Transaction.java,v 1.8 2002/12/16 22:18:29 rwald Exp $
 * =======================================================================
 * Copyright (c) 2002 Axion Development Team.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The names "Tigris", "Axion", nor the names of its contributors may
 *    not be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * 4. Products derived from this software may not be called "Axion", nor
 *    may "Tigris" or "Axion" appear in their names without specific prior
 *    written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * =======================================================================
 */

package org.axiondb;

import java.util.Set;

/**
 * A database transaction.
 * 
 * @version $Revision: 1.8 $ $Date: 2002/12/16 22:18:29 $
 * @author Rodney Waldhoff
 */
public interface Transaction extends Database, Transactable {
    /**
     * Get the {@link Database} upon which I 
     * am open (i.e., the state to which we will 
     * return to if I am rolled back.
     * Note that this may be another <code>Transaction</code>.
     */
    Database getOpenOnTransaction();
    
    /**
     * Return my current transaction state.
     * Returns one of {@link #STATE_OPEN}, {@link #STATE_COMMITTED}, 
     * {@link #STATE_ABORTED}, {@link #STATE_APPLIED}.
     */
    int getState();
    
    /** 
     * Return a {@link Set} of {@link Table}s that
     * have been modified thus far in this transaction.
     */
    Set getModifiedTables();

    /** 
     * Return a {@link Set} of {@link Table}s that
     * have been read thus far in this transaction.
     */
    Set getReadTables();

    /** Open (neither committed nor aborted yet). */
    public static final int STATE_OPEN = 0;

    /** Committed, but not yet applied. */
    public static final int STATE_COMMITTED = 1;

    /** Aborted. */
    public static final int STATE_ABORTED = 2;

    /** Applied. */
    public static final int STATE_APPLIED = 3;
}
