/*
 * $Id: AxionCommand.java,v 1.10 2003/07/10 22:20:37 rwald Exp $
 * =======================================================================
 * Copyright (c) 2002 Axion Development Team.  All rights reserved.
 *  
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 * 
 * 1. Redistributions of source code must retain the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer. 
 *   
 * 2. Redistributions in binary form must reproduce the above copyright 
 *    notice, this list of conditions and the following disclaimer in 
 *    the documentation and/or other materials provided with the 
 *    distribution. 
 *   
 * 3. The names "Tigris", "Axion", nor the names of its contributors may 
 *    not be used to endorse or promote products derived from this 
 *    software without specific prior written permission. 
 *  
 * 4. Products derived from this software may not be called "Axion", nor 
 *    may "Tigris" or "Axion" appear in their names without specific prior
 *    written permission.
 *   
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * =======================================================================
 */

package org.axiondb;

import java.sql.ResultSet;

import org.axiondb.jdbc.AxionResultSet;

/**
 * A command to be executed against a {@link Database}.
 * 
 * @version $Revision: 1.10 $ $Date: 2003/07/10 22:20:37 $
 * @author Chuck Burdick 
 */
public interface AxionCommand {
    /**
     * Executes an SQL statement that may return multiple results.
     * @return <tt>true</tt> if one or more {@link java.sql.ResultSet}s 
     * were generated, <tt>false</tt> otherwise 
     * @see java.sql.Statement#execute(java.lang.String)
     * @see java.sql.PreparedStatement#execute
     */
    boolean execute(Database db) throws AxionException;

    /**
     * Executes an SQL that may add, delete or modify zero or more 
     * rows within the database, such as an INSERT, UPDATE or DELETE statement. 
     * In addition, SQL statements that return nothing, such as SQL 
     * DDL statements, can be executed via this method.
     * @return the number of rows modified
     * @see java.sql.Statement#executeUpdate(java.lang.String)
     * @see java.sql.PreparedStatement#executeUpdate
     */
    int executeUpdate(Database db) throws AxionException;

    /**  
     * Executes an SQL statement that returns a single 
     * {@link java.sql.ResultSet} object such as 
     * a SELECT statement.
     * @return the generated {@link java.sql.ResultSet} 
     * @see java.sql.Statement#executeQuery(java.lang.String)
     * @see java.sql.PreparedStatement#executeQuery
     */
    AxionResultSet executeQuery(Database db) throws AxionException;

    /**
     * Returns the last {@link java.sql.ResultSet} generated by 
     * {@link #execute} or {@link #executeQuery}.
     */
    ResultSet getResultSet();
    
    /**
     * Returns the last row count generated by 
     * {@link #execute} or {@link #executeUpdate}.
     */
    int getEffectedRowCount();
    
    /**
     * Sets the <i>value</i> of the <i>i</i><sup>th</sup> 
     * bind variable within this command.
     * @param index the one-based index of the variable
     * @param value the value to bind the variable to
     */
    void bind(int index, Object value) throws AxionException;

    /**
     * Clears all bind variables within this command. 
     */
    void clearBindings() throws AxionException;
}
