#include <sys/ioctl.h>
#include <linux/soundcard.h>
#include <syslog.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "error.h"

int set_soundcard_sample_format(int fd)
{
	int format = AFMT_S16_NE;	/* machine-endian 16 bit signed */

	if (ioctl(fd, SNDCTL_DSP_SETFMT, &format) == -1)
		error_exit("set_soundcard_sample_format::ioctl: failed\n");

	if (format != AFMT_S16_NE)
		error_exit("set_soundcard_sample_format: sampleformat unexpected: %d\n", format);

	return 0;
}

int set_soundcard_number_of_channels(int fd, int n_channels)
{
	int dummy = n_channels;

	if (ioctl(fd, SNDCTL_DSP_CHANNELS, &dummy) == -1)
		error_exit("set_soundcard_number_of_channels::ioctl: failed");

	if (dummy != n_channels)
		error_exit("set_soundcard_number_of_channels::ioctl: number of channels unexpected: %d", dummy);

	return 0;
}

int set_soundcard_sample_rate(int fd, int hz)
{
	int dummy = hz;

	if (ioctl(fd, SNDCTL_DSP_SPEED, &dummy) == -1)
		error_exit("set_soundcard_sample_rate::ioctl: failed: %d");

	if (dummy != hz)
		error_exit("set_soundcard_sample_rate::ioctl: samplerate unexpected: %d", dummy);

	return 0;
}
