/* $Id: tstIEMAImplDataFpuBinary1-Intel.cpp $ */
/** @file
 * IEM Assembly Instruction Helper Testcase Data Intel - r150967 on Intel(R) Core(TM) i9-10980XE CPU @ 3.00GHz.
 */

/*
 * Copyright (C) 2022 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#include "tstIEMAImpl.h"

FPU_BINARY_R80_TEST_T const g_aTests_fpatan_r80_by_r80_intel[] =
{
    { 0x007f, 0x8b1f, 0x3b20, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #0/0/0/m = #0 */
    { 0x0000, 0x8b1f, 0xbba0, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #0/0/0/u = #1 */
    { 0x0020, 0x8b1f, 0x3b20, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #0/0/0/0x20 = #2 */
    { 0x017f, 0x8b1f, 0x3b20, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #0/0/1/m = #3 */
    { 0x0100, 0x8b1f, 0xbba0, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #0/0/1/u = #4 */
    { 0x0120, 0x8b1f, 0x3b20, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #0/0/1/0x20 = #5 */
    { 0x027f, 0x8b1f, 0x3b20, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #0/0/2/m = #6 */
    { 0x0200, 0x8b1f, 0xbba0, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #0/0/2/u = #7 */
    { 0x0220, 0x8b1f, 0x3b20, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #0/0/2/0x20 = #8 */
    { 0x037f, 0x8b1f, 0x3b20, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #0/0/3/m = #9 */
    { 0x0300, 0x8b1f, 0xbba0, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #0/0/3/u = #10 */
    { 0x0320, 0x8b1f, 0x3b20, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #0/0/3/0x20 = #11 */
    { 0x047f, 0x8b1f, 0x3920, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #0/1/0/m = #12 */
    { 0x0400, 0x8b1f, 0xb9a0, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #0/1/0/u = #13 */
    { 0x0420, 0x8b1f, 0x3920, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #0/1/0/0x20 = #14 */
    { 0x057f, 0x8b1f, 0x3920, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #0/1/1/m = #15 */
    { 0x0500, 0x8b1f, 0xb9a0, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #0/1/1/u = #16 */
    { 0x0520, 0x8b1f, 0x3920, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #0/1/1/0x20 = #17 */
    { 0x067f, 0x8b1f, 0x3920, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #0/1/2/m = #18 */
    { 0x0600, 0x8b1f, 0xb9a0, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #0/1/2/u = #19 */
    { 0x0620, 0x8b1f, 0x3920, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #0/1/2/0x20 = #20 */
    { 0x077f, 0x8b1f, 0x3920, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #0/1/3/m = #21 */
    { 0x0700, 0x8b1f, 0xb9a0, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #0/1/3/u = #22 */
    { 0x0720, 0x8b1f, 0x3920, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #0/1/3/0x20 = #23 */
    { 0x087f, 0x8b1f, 0x3b20, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #0/2/0/m = #24 */
    { 0x0800, 0x8b1f, 0xbba0, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #0/2/0/u = #25 */
    { 0x0820, 0x8b1f, 0x3b20, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #0/2/0/0x20 = #26 */
    { 0x097f, 0x8b1f, 0x3b20, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #0/2/1/m = #27 */
    { 0x0900, 0x8b1f, 0xbba0, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #0/2/1/u = #28 */
    { 0x0920, 0x8b1f, 0x3b20, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #0/2/1/0x20 = #29 */
    { 0x0a7f, 0x8b1f, 0x3b20, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #0/2/2/m = #30 */
    { 0x0a00, 0x8b1f, 0xbba0, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #0/2/2/u = #31 */
    { 0x0a20, 0x8b1f, 0x3b20, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #0/2/2/0x20 = #32 */
    { 0x0b7f, 0x8b1f, 0x3b20, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #0/2/3/m = #33 */
    { 0x0b00, 0x8b1f, 0xbba0, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #0/2/3/u = #34 */
    { 0x0b20, 0x8b1f, 0x3b20, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #0/2/3/0x20 = #35 */
    { 0x0c7f, 0x8b1f, 0x3920, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #0/3/0/m = #36 */
    { 0x0c00, 0x8b1f, 0xb9a0, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #0/3/0/u = #37 */
    { 0x0c20, 0x8b1f, 0x3920, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #0/3/0/0x20 = #38 */
    { 0x0d7f, 0x8b1f, 0x3920, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #0/3/1/m = #39 */
    { 0x0d00, 0x8b1f, 0xb9a0, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #0/3/1/u = #40 */
    { 0x0d20, 0x8b1f, 0x3920, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #0/3/1/0x20 = #41 */
    { 0x0e7f, 0x8b1f, 0x3920, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #0/3/2/m = #42 */
    { 0x0e00, 0x8b1f, 0xb9a0, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #0/3/2/u = #43 */
    { 0x0e20, 0x8b1f, 0x3920, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #0/3/2/0x20 = #44 */
    { 0x0f7f, 0x8b1f, 0x3920, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #0/3/3/m = #45 */
    { 0x0f00, 0x8b1f, 0xb9a0, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #0/3/3/u = #46 */
    { 0x0f20, 0x8b1f, 0x3920, RTFLOAT80U_INIT_C(0,0xbf68627837cd730e,16694), RTFLOAT80U_INIT_C(1,0xb337db63e9fb8ec0,25728), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #0/3/3/0x20 = #47 */
    { 0x007f, 0xf125, 0x7b20, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #1/0/0/m = #48 */
    { 0x0000, 0xf125, 0xfba0, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #1/0/0/u = #49 */
    { 0x0020, 0xf125, 0x7b20, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #1/0/0/0x20 = #50 */
    { 0x017f, 0xf125, 0x7b20, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #1/0/1/m = #51 */
    { 0x0100, 0xf125, 0xfba0, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #1/0/1/u = #52 */
    { 0x0120, 0xf125, 0x7b20, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #1/0/1/0x20 = #53 */
    { 0x027f, 0xf125, 0x7b20, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #1/0/2/m = #54 */
    { 0x0200, 0xf125, 0xfba0, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #1/0/2/u = #55 */
    { 0x0220, 0xf125, 0x7b20, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #1/0/2/0x20 = #56 */
    { 0x037f, 0xf125, 0x7b20, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #1/0/3/m = #57 */
    { 0x0300, 0xf125, 0xfba0, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #1/0/3/u = #58 */
    { 0x0320, 0xf125, 0x7b20, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #1/0/3/0x20 = #59 */
    { 0x047f, 0xf125, 0x7b20, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #1/1/0/m = #60 */
    { 0x0400, 0xf125, 0xfba0, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #1/1/0/u = #61 */
    { 0x0420, 0xf125, 0x7b20, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #1/1/0/0x20 = #62 */
    { 0x057f, 0xf125, 0x7b20, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #1/1/1/m = #63 */
    { 0x0500, 0xf125, 0xfba0, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #1/1/1/u = #64 */
    { 0x0520, 0xf125, 0x7b20, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #1/1/1/0x20 = #65 */
    { 0x067f, 0xf125, 0x7b20, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #1/1/2/m = #66 */
    { 0x0600, 0xf125, 0xfba0, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #1/1/2/u = #67 */
    { 0x0620, 0xf125, 0x7b20, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #1/1/2/0x20 = #68 */
    { 0x077f, 0xf125, 0x7b20, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #1/1/3/m = #69 */
    { 0x0700, 0xf125, 0xfba0, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #1/1/3/u = #70 */
    { 0x0720, 0xf125, 0x7b20, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #1/1/3/0x20 = #71 */
    { 0x087f, 0xf125, 0x7920, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #1/2/0/m = #72 */
    { 0x0800, 0xf125, 0xf9a0, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #1/2/0/u = #73 */
    { 0x0820, 0xf125, 0x7920, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #1/2/0/0x20 = #74 */
    { 0x097f, 0xf125, 0x7920, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #1/2/1/m = #75 */
    { 0x0900, 0xf125, 0xf9a0, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #1/2/1/u = #76 */
    { 0x0920, 0xf125, 0x7920, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #1/2/1/0x20 = #77 */
    { 0x0a7f, 0xf125, 0x7920, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #1/2/2/m = #78 */
    { 0x0a00, 0xf125, 0xf9a0, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #1/2/2/u = #79 */
    { 0x0a20, 0xf125, 0x7920, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #1/2/2/0x20 = #80 */
    { 0x0b7f, 0xf125, 0x7920, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #1/2/3/m = #81 */
    { 0x0b00, 0xf125, 0xf9a0, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #1/2/3/u = #82 */
    { 0x0b20, 0xf125, 0x7920, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #1/2/3/0x20 = #83 */
    { 0x0c7f, 0xf125, 0x7920, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #1/3/0/m = #84 */
    { 0x0c00, 0xf125, 0xf9a0, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #1/3/0/u = #85 */
    { 0x0c20, 0xf125, 0x7920, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #1/3/0/0x20 = #86 */
    { 0x0d7f, 0xf125, 0x7920, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #1/3/1/m = #87 */
    { 0x0d00, 0xf125, 0xf9a0, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #1/3/1/u = #88 */
    { 0x0d20, 0xf125, 0x7920, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #1/3/1/0x20 = #89 */
    { 0x0e7f, 0xf125, 0x7920, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #1/3/2/m = #90 */
    { 0x0e00, 0xf125, 0xf9a0, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #1/3/2/u = #91 */
    { 0x0e20, 0xf125, 0x7920, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #1/3/2/0x20 = #92 */
    { 0x0f7f, 0xf125, 0x7920, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #1/3/3/m = #93 */
    { 0x0f00, 0xf125, 0xf9a0, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #1/3/3/u = #94 */
    { 0x0f20, 0xf125, 0x7920, RTFLOAT80U_INIT_C(1,0xa6fdc2a17356c0ba,4803), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #1/3/3/0x20 = #95 */
    { 0x007f, 0x9d01, 0x3d01, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_IND(1) }, /* #2/0/0/m = #96 */
    { 0x0000, 0x9d01, 0xb581, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521) }, /* #2/0/0/u = #97 */
    { 0x0001, 0x9d01, 0x3d01, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_IND(1) }, /* #2/0/0/0x1 = #98 */
    { 0x017f, 0x9d01, 0x3d01, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_IND(1) }, /* #2/0/1/m = #99 */
    { 0x0100, 0x9d01, 0xb581, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521) }, /* #2/0/1/u = #100 */
    { 0x0101, 0x9d01, 0x3d01, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_IND(1) }, /* #2/0/1/0x1 = #101 */
    { 0x027f, 0x9d01, 0x3d01, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_IND(1) }, /* #2/0/2/m = #102 */
    { 0x0200, 0x9d01, 0xb581, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521) }, /* #2/0/2/u = #103 */
    { 0x0201, 0x9d01, 0x3d01, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_IND(1) }, /* #2/0/2/0x1 = #104 */
    { 0x037f, 0x9d01, 0x3d01, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_IND(1) }, /* #2/0/3/m = #105 */
    { 0x0300, 0x9d01, 0xb581, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521) }, /* #2/0/3/u = #106 */
    { 0x0301, 0x9d01, 0x3d01, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_IND(1) }, /* #2/0/3/0x1 = #107 */
    { 0x047f, 0x9d01, 0x3d01, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_IND(1) }, /* #2/1/0/m = #108 */
    { 0x0400, 0x9d01, 0xb581, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521) }, /* #2/1/0/u = #109 */
    { 0x0401, 0x9d01, 0x3d01, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_IND(1) }, /* #2/1/0/0x1 = #110 */
    { 0x057f, 0x9d01, 0x3d01, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_IND(1) }, /* #2/1/1/m = #111 */
    { 0x0500, 0x9d01, 0xb581, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521) }, /* #2/1/1/u = #112 */
    { 0x0501, 0x9d01, 0x3d01, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_IND(1) }, /* #2/1/1/0x1 = #113 */
    { 0x067f, 0x9d01, 0x3d01, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_IND(1) }, /* #2/1/2/m = #114 */
    { 0x0600, 0x9d01, 0xb581, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521) }, /* #2/1/2/u = #115 */
    { 0x0601, 0x9d01, 0x3d01, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_IND(1) }, /* #2/1/2/0x1 = #116 */
    { 0x077f, 0x9d01, 0x3d01, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_IND(1) }, /* #2/1/3/m = #117 */
    { 0x0700, 0x9d01, 0xb581, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521) }, /* #2/1/3/u = #118 */
    { 0x0701, 0x9d01, 0x3d01, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_IND(1) }, /* #2/1/3/0x1 = #119 */
    { 0x087f, 0x9d01, 0x3d01, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_IND(1) }, /* #2/2/0/m = #120 */
    { 0x0800, 0x9d01, 0xb581, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521) }, /* #2/2/0/u = #121 */
    { 0x0801, 0x9d01, 0x3d01, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_IND(1) }, /* #2/2/0/0x1 = #122 */
    { 0x097f, 0x9d01, 0x3d01, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_IND(1) }, /* #2/2/1/m = #123 */
    { 0x0900, 0x9d01, 0xb581, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521) }, /* #2/2/1/u = #124 */
    { 0x0901, 0x9d01, 0x3d01, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_IND(1) }, /* #2/2/1/0x1 = #125 */
    { 0x0a7f, 0x9d01, 0x3d01, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_IND(1) }, /* #2/2/2/m = #126 */
    { 0x0a00, 0x9d01, 0xb581, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521) }, /* #2/2/2/u = #127 */
    { 0x0a01, 0x9d01, 0x3d01, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_IND(1) }, /* #2/2/2/0x1 = #128 */
    { 0x0b7f, 0x9d01, 0x3d01, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_IND(1) }, /* #2/2/3/m = #129 */
    { 0x0b00, 0x9d01, 0xb581, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521) }, /* #2/2/3/u = #130 */
    { 0x0b01, 0x9d01, 0x3d01, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_IND(1) }, /* #2/2/3/0x1 = #131 */
    { 0x0c7f, 0x9d01, 0x3d01, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_IND(1) }, /* #2/3/0/m = #132 */
    { 0x0c00, 0x9d01, 0xb581, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521) }, /* #2/3/0/u = #133 */
    { 0x0c01, 0x9d01, 0x3d01, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_IND(1) }, /* #2/3/0/0x1 = #134 */
    { 0x0d7f, 0x9d01, 0x3d01, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_IND(1) }, /* #2/3/1/m = #135 */
    { 0x0d00, 0x9d01, 0xb581, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521) }, /* #2/3/1/u = #136 */
    { 0x0d01, 0x9d01, 0x3d01, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_IND(1) }, /* #2/3/1/0x1 = #137 */
    { 0x0e7f, 0x9d01, 0x3d01, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_IND(1) }, /* #2/3/2/m = #138 */
    { 0x0e00, 0x9d01, 0xb581, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521) }, /* #2/3/2/u = #139 */
    { 0x0e01, 0x9d01, 0x3d01, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_IND(1) }, /* #2/3/2/0x1 = #140 */
    { 0x0f7f, 0x9d01, 0x3d01, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_IND(1) }, /* #2/3/3/m = #141 */
    { 0x0f00, 0x9d01, 0xb581, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521) }, /* #2/3/3/u = #142 */
    { 0x0f01, 0x9d01, 0x3d01, RTFLOAT80U_INIT_C(0,0x81d96a461274d0d8,17467), RTFLOAT80U_INIT_C(0,0x25bb561c91fe4e75,10521), RTFLOAT80U_INIT_IND(1) }, /* #2/3/3/0x1 = #143 */
    { 0x007f, 0x06d7, 0x3c01, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0xda4794d119227934,32767) }, /* #3/0/0/m = #144 */
    { 0x0000, 0x06d7, 0xb481, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767) }, /* #3/0/0/u = #145 */
    { 0x0001, 0x06d7, 0x3c01, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0xda4794d119227934,32767) }, /* #3/0/0/0x1 = #146 */
    { 0x017f, 0x06d7, 0x3c01, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0xda4794d119227934,32767) }, /* #3/0/1/m = #147 */
    { 0x0100, 0x06d7, 0xb481, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767) }, /* #3/0/1/u = #148 */
    { 0x0101, 0x06d7, 0x3c01, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0xda4794d119227934,32767) }, /* #3/0/1/0x1 = #149 */
    { 0x027f, 0x06d7, 0x3c01, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0xda4794d119227934,32767) }, /* #3/0/2/m = #150 */
    { 0x0200, 0x06d7, 0xb481, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767) }, /* #3/0/2/u = #151 */
    { 0x0201, 0x06d7, 0x3c01, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0xda4794d119227934,32767) }, /* #3/0/2/0x1 = #152 */
    { 0x037f, 0x06d7, 0x3c01, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0xda4794d119227934,32767) }, /* #3/0/3/m = #153 */
    { 0x0300, 0x06d7, 0xb481, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767) }, /* #3/0/3/u = #154 */
    { 0x0301, 0x06d7, 0x3c01, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0xda4794d119227934,32767) }, /* #3/0/3/0x1 = #155 */
    { 0x047f, 0x06d7, 0x3c01, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0xda4794d119227934,32767) }, /* #3/1/0/m = #156 */
    { 0x0400, 0x06d7, 0xb481, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767) }, /* #3/1/0/u = #157 */
    { 0x0401, 0x06d7, 0x3c01, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0xda4794d119227934,32767) }, /* #3/1/0/0x1 = #158 */
    { 0x057f, 0x06d7, 0x3c01, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0xda4794d119227934,32767) }, /* #3/1/1/m = #159 */
    { 0x0500, 0x06d7, 0xb481, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767) }, /* #3/1/1/u = #160 */
    { 0x0501, 0x06d7, 0x3c01, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0xda4794d119227934,32767) }, /* #3/1/1/0x1 = #161 */
    { 0x067f, 0x06d7, 0x3c01, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0xda4794d119227934,32767) }, /* #3/1/2/m = #162 */
    { 0x0600, 0x06d7, 0xb481, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767) }, /* #3/1/2/u = #163 */
    { 0x0601, 0x06d7, 0x3c01, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0xda4794d119227934,32767) }, /* #3/1/2/0x1 = #164 */
    { 0x077f, 0x06d7, 0x3c01, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0xda4794d119227934,32767) }, /* #3/1/3/m = #165 */
    { 0x0700, 0x06d7, 0xb481, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767) }, /* #3/1/3/u = #166 */
    { 0x0701, 0x06d7, 0x3c01, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0xda4794d119227934,32767) }, /* #3/1/3/0x1 = #167 */
    { 0x087f, 0x06d7, 0x3c01, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0xda4794d119227934,32767) }, /* #3/2/0/m = #168 */
    { 0x0800, 0x06d7, 0xb481, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767) }, /* #3/2/0/u = #169 */
    { 0x0801, 0x06d7, 0x3c01, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0xda4794d119227934,32767) }, /* #3/2/0/0x1 = #170 */
    { 0x097f, 0x06d7, 0x3c01, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0xda4794d119227934,32767) }, /* #3/2/1/m = #171 */
    { 0x0900, 0x06d7, 0xb481, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767) }, /* #3/2/1/u = #172 */
    { 0x0901, 0x06d7, 0x3c01, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0xda4794d119227934,32767) }, /* #3/2/1/0x1 = #173 */
    { 0x0a7f, 0x06d7, 0x3c01, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0xda4794d119227934,32767) }, /* #3/2/2/m = #174 */
    { 0x0a00, 0x06d7, 0xb481, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767) }, /* #3/2/2/u = #175 */
    { 0x0a01, 0x06d7, 0x3c01, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0xda4794d119227934,32767) }, /* #3/2/2/0x1 = #176 */
    { 0x0b7f, 0x06d7, 0x3c01, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0xda4794d119227934,32767) }, /* #3/2/3/m = #177 */
    { 0x0b00, 0x06d7, 0xb481, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767) }, /* #3/2/3/u = #178 */
    { 0x0b01, 0x06d7, 0x3c01, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0xda4794d119227934,32767) }, /* #3/2/3/0x1 = #179 */
    { 0x0c7f, 0x06d7, 0x3c01, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0xda4794d119227934,32767) }, /* #3/3/0/m = #180 */
    { 0x0c00, 0x06d7, 0xb481, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767) }, /* #3/3/0/u = #181 */
    { 0x0c01, 0x06d7, 0x3c01, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0xda4794d119227934,32767) }, /* #3/3/0/0x1 = #182 */
    { 0x0d7f, 0x06d7, 0x3c01, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0xda4794d119227934,32767) }, /* #3/3/1/m = #183 */
    { 0x0d00, 0x06d7, 0xb481, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767) }, /* #3/3/1/u = #184 */
    { 0x0d01, 0x06d7, 0x3c01, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0xda4794d119227934,32767) }, /* #3/3/1/0x1 = #185 */
    { 0x0e7f, 0x06d7, 0x3c01, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0xda4794d119227934,32767) }, /* #3/3/2/m = #186 */
    { 0x0e00, 0x06d7, 0xb481, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767) }, /* #3/3/2/u = #187 */
    { 0x0e01, 0x06d7, 0x3c01, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0xda4794d119227934,32767) }, /* #3/3/2/0x1 = #188 */
    { 0x0f7f, 0x06d7, 0x3c01, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0xda4794d119227934,32767) }, /* #3/3/3/m = #189 */
    { 0x0f00, 0x06d7, 0xb481, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767) }, /* #3/3/3/u = #190 */
    { 0x0f01, 0x06d7, 0x3c01, RTFLOAT80U_INIT_C(0,0xc8faa9c2528a7c7d,19817), RTFLOAT80U_INIT_C(0,0x9a4794d119227934,32767), RTFLOAT80U_INIT_C(0,0xda4794d119227934,32767) }, /* #3/3/3/0x1 = #191 */
    { 0x007f, 0x6047, 0x7800, RTFLOAT80U_INIT_C(1,0xe025f2991240cf02,10579), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767) }, /* #4/0/0/m = #192 */
    { 0x0000, 0x6047, 0x7800, RTFLOAT80U_INIT_C(1,0xe025f2991240cf02,10579), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767) }, /* #4/0/0/u = #193 */
    { 0x017f, 0x6047, 0x7800, RTFLOAT80U_INIT_C(1,0xe025f2991240cf02,10579), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767) }, /* #4/0/1/m = #194 */
    { 0x0100, 0x6047, 0x7800, RTFLOAT80U_INIT_C(1,0xe025f2991240cf02,10579), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767) }, /* #4/0/1/u = #195 */
    { 0x027f, 0x6047, 0x7800, RTFLOAT80U_INIT_C(1,0xe025f2991240cf02,10579), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767) }, /* #4/0/2/m = #196 */
    { 0x0200, 0x6047, 0x7800, RTFLOAT80U_INIT_C(1,0xe025f2991240cf02,10579), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767) }, /* #4/0/2/u = #197 */
    { 0x037f, 0x6047, 0x7800, RTFLOAT80U_INIT_C(1,0xe025f2991240cf02,10579), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767) }, /* #4/0/3/m = #198 */
    { 0x0300, 0x6047, 0x7800, RTFLOAT80U_INIT_C(1,0xe025f2991240cf02,10579), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767) }, /* #4/0/3/u = #199 */
    { 0x047f, 0x6047, 0x7800, RTFLOAT80U_INIT_C(1,0xe025f2991240cf02,10579), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767) }, /* #4/1/0/m = #200 */
    { 0x0400, 0x6047, 0x7800, RTFLOAT80U_INIT_C(1,0xe025f2991240cf02,10579), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767) }, /* #4/1/0/u = #201 */
    { 0x057f, 0x6047, 0x7800, RTFLOAT80U_INIT_C(1,0xe025f2991240cf02,10579), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767) }, /* #4/1/1/m = #202 */
    { 0x0500, 0x6047, 0x7800, RTFLOAT80U_INIT_C(1,0xe025f2991240cf02,10579), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767) }, /* #4/1/1/u = #203 */
    { 0x067f, 0x6047, 0x7800, RTFLOAT80U_INIT_C(1,0xe025f2991240cf02,10579), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767) }, /* #4/1/2/m = #204 */
    { 0x0600, 0x6047, 0x7800, RTFLOAT80U_INIT_C(1,0xe025f2991240cf02,10579), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767) }, /* #4/1/2/u = #205 */
    { 0x077f, 0x6047, 0x7800, RTFLOAT80U_INIT_C(1,0xe025f2991240cf02,10579), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767) }, /* #4/1/3/m = #206 */
    { 0x0700, 0x6047, 0x7800, RTFLOAT80U_INIT_C(1,0xe025f2991240cf02,10579), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767) }, /* #4/1/3/u = #207 */
    { 0x087f, 0x6047, 0x7800, RTFLOAT80U_INIT_C(1,0xe025f2991240cf02,10579), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767) }, /* #4/2/0/m = #208 */
    { 0x0800, 0x6047, 0x7800, RTFLOAT80U_INIT_C(1,0xe025f2991240cf02,10579), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767) }, /* #4/2/0/u = #209 */
    { 0x097f, 0x6047, 0x7800, RTFLOAT80U_INIT_C(1,0xe025f2991240cf02,10579), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767) }, /* #4/2/1/m = #210 */
    { 0x0900, 0x6047, 0x7800, RTFLOAT80U_INIT_C(1,0xe025f2991240cf02,10579), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767) }, /* #4/2/1/u = #211 */
    { 0x0a7f, 0x6047, 0x7800, RTFLOAT80U_INIT_C(1,0xe025f2991240cf02,10579), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767) }, /* #4/2/2/m = #212 */
    { 0x0a00, 0x6047, 0x7800, RTFLOAT80U_INIT_C(1,0xe025f2991240cf02,10579), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767) }, /* #4/2/2/u = #213 */
    { 0x0b7f, 0x6047, 0x7800, RTFLOAT80U_INIT_C(1,0xe025f2991240cf02,10579), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767) }, /* #4/2/3/m = #214 */
    { 0x0b00, 0x6047, 0x7800, RTFLOAT80U_INIT_C(1,0xe025f2991240cf02,10579), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767) }, /* #4/2/3/u = #215 */
    { 0x0c7f, 0x6047, 0x7800, RTFLOAT80U_INIT_C(1,0xe025f2991240cf02,10579), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767) }, /* #4/3/0/m = #216 */
    { 0x0c00, 0x6047, 0x7800, RTFLOAT80U_INIT_C(1,0xe025f2991240cf02,10579), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767) }, /* #4/3/0/u = #217 */
    { 0x0d7f, 0x6047, 0x7800, RTFLOAT80U_INIT_C(1,0xe025f2991240cf02,10579), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767) }, /* #4/3/1/m = #218 */
    { 0x0d00, 0x6047, 0x7800, RTFLOAT80U_INIT_C(1,0xe025f2991240cf02,10579), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767) }, /* #4/3/1/u = #219 */
    { 0x0e7f, 0x6047, 0x7800, RTFLOAT80U_INIT_C(1,0xe025f2991240cf02,10579), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767) }, /* #4/3/2/m = #220 */
    { 0x0e00, 0x6047, 0x7800, RTFLOAT80U_INIT_C(1,0xe025f2991240cf02,10579), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767) }, /* #4/3/2/u = #221 */
    { 0x0f7f, 0x6047, 0x7800, RTFLOAT80U_INIT_C(1,0xe025f2991240cf02,10579), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767) }, /* #4/3/3/m = #222 */
    { 0x0f00, 0x6047, 0x7800, RTFLOAT80U_INIT_C(1,0xe025f2991240cf02,10579), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767), RTFLOAT80U_INIT_C(0,0xe0f3fa87d88789ad,32767) }, /* #4/3/3/u = #223 */
    { 0x007f, 0x3f46, 0x3d01, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/0/0/m = #224 */
    { 0x0000, 0x3f46, 0xb581, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767) }, /* #5/0/0/u = #225 */
    { 0x0001, 0x3f46, 0x3d01, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/0/0/0x1 = #226 */
    { 0x017f, 0x3f46, 0x3d01, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/0/1/m = #227 */
    { 0x0100, 0x3f46, 0xb581, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767) }, /* #5/0/1/u = #228 */
    { 0x0101, 0x3f46, 0x3d01, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/0/1/0x1 = #229 */
    { 0x027f, 0x3f46, 0x3d01, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/0/2/m = #230 */
    { 0x0200, 0x3f46, 0xb581, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767) }, /* #5/0/2/u = #231 */
    { 0x0201, 0x3f46, 0x3d01, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/0/2/0x1 = #232 */
    { 0x037f, 0x3f46, 0x3d01, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/0/3/m = #233 */
    { 0x0300, 0x3f46, 0xb581, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767) }, /* #5/0/3/u = #234 */
    { 0x0301, 0x3f46, 0x3d01, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/0/3/0x1 = #235 */
    { 0x047f, 0x3f46, 0x3d01, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/1/0/m = #236 */
    { 0x0400, 0x3f46, 0xb581, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767) }, /* #5/1/0/u = #237 */
    { 0x0401, 0x3f46, 0x3d01, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/1/0/0x1 = #238 */
    { 0x057f, 0x3f46, 0x3d01, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/1/1/m = #239 */
    { 0x0500, 0x3f46, 0xb581, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767) }, /* #5/1/1/u = #240 */
    { 0x0501, 0x3f46, 0x3d01, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/1/1/0x1 = #241 */
    { 0x067f, 0x3f46, 0x3d01, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/1/2/m = #242 */
    { 0x0600, 0x3f46, 0xb581, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767) }, /* #5/1/2/u = #243 */
    { 0x0601, 0x3f46, 0x3d01, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/1/2/0x1 = #244 */
    { 0x077f, 0x3f46, 0x3d01, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/1/3/m = #245 */
    { 0x0700, 0x3f46, 0xb581, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767) }, /* #5/1/3/u = #246 */
    { 0x0701, 0x3f46, 0x3d01, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/1/3/0x1 = #247 */
    { 0x087f, 0x3f46, 0x3d01, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/2/0/m = #248 */
    { 0x0800, 0x3f46, 0xb581, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767) }, /* #5/2/0/u = #249 */
    { 0x0801, 0x3f46, 0x3d01, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/2/0/0x1 = #250 */
    { 0x097f, 0x3f46, 0x3d01, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/2/1/m = #251 */
    { 0x0900, 0x3f46, 0xb581, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767) }, /* #5/2/1/u = #252 */
    { 0x0901, 0x3f46, 0x3d01, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/2/1/0x1 = #253 */
    { 0x0a7f, 0x3f46, 0x3d01, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/2/2/m = #254 */
    { 0x0a00, 0x3f46, 0xb581, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767) }, /* #5/2/2/u = #255 */
    { 0x0a01, 0x3f46, 0x3d01, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/2/2/0x1 = #256 */
    { 0x0b7f, 0x3f46, 0x3d01, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/2/3/m = #257 */
    { 0x0b00, 0x3f46, 0xb581, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767) }, /* #5/2/3/u = #258 */
    { 0x0b01, 0x3f46, 0x3d01, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/2/3/0x1 = #259 */
    { 0x0c7f, 0x3f46, 0x3d01, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/3/0/m = #260 */
    { 0x0c00, 0x3f46, 0xb581, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767) }, /* #5/3/0/u = #261 */
    { 0x0c01, 0x3f46, 0x3d01, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/3/0/0x1 = #262 */
    { 0x0d7f, 0x3f46, 0x3d01, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/3/1/m = #263 */
    { 0x0d00, 0x3f46, 0xb581, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767) }, /* #5/3/1/u = #264 */
    { 0x0d01, 0x3f46, 0x3d01, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/3/1/0x1 = #265 */
    { 0x0e7f, 0x3f46, 0x3d01, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/3/2/m = #266 */
    { 0x0e00, 0x3f46, 0xb581, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767) }, /* #5/3/2/u = #267 */
    { 0x0e01, 0x3f46, 0x3d01, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/3/2/0x1 = #268 */
    { 0x0f7f, 0x3f46, 0x3d01, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/3/3/m = #269 */
    { 0x0f00, 0x3f46, 0xb581, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767) }, /* #5/3/3/u = #270 */
    { 0x0f01, 0x3f46, 0x3d01, RTFLOAT80U_INIT_C(1,0xfc63ac3e39a3ce91,15926), RTFLOAT80U_INIT_C(1,0xe08cbe23804b134,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/3/3/0x1 = #271 */
    { 0x007f, 0x059f, 0x3f22, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #6/0/0/m = #272 */
    { 0x0000, 0x059f, 0xb582, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0) }, /* #6/0/0/u = #273 */
    { 0x0022, 0x059f, 0x3f22, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #6/0/0/0x22 = #274 */
    { 0x0020, 0x059f, 0xb582, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0) }, /* #6/0/0/u0x2 = #275 */
    { 0x0002, 0x059f, 0xbfa2, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #6/0/0/u0x20 = #276 */
    { 0x017f, 0x059f, 0x3f22, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #6/0/1/m = #277 */
    { 0x0100, 0x059f, 0xb582, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0) }, /* #6/0/1/u = #278 */
    { 0x0122, 0x059f, 0x3f22, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #6/0/1/0x22 = #279 */
    { 0x0120, 0x059f, 0xb582, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0) }, /* #6/0/1/u0x2 = #280 */
    { 0x0102, 0x059f, 0xbfa2, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #6/0/1/u0x20 = #281 */
    { 0x027f, 0x059f, 0x3f22, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #6/0/2/m = #282 */
    { 0x0200, 0x059f, 0xb582, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0) }, /* #6/0/2/u = #283 */
    { 0x0222, 0x059f, 0x3f22, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #6/0/2/0x22 = #284 */
    { 0x0220, 0x059f, 0xb582, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0) }, /* #6/0/2/u0x2 = #285 */
    { 0x0202, 0x059f, 0xbfa2, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #6/0/2/u0x20 = #286 */
    { 0x037f, 0x059f, 0x3f22, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #6/0/3/m = #287 */
    { 0x0300, 0x059f, 0xb582, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0) }, /* #6/0/3/u = #288 */
    { 0x0322, 0x059f, 0x3f22, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #6/0/3/0x22 = #289 */
    { 0x0320, 0x059f, 0xb582, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0) }, /* #6/0/3/u0x2 = #290 */
    { 0x0302, 0x059f, 0xbfa2, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #6/0/3/u0x20 = #291 */
    { 0x047f, 0x059f, 0x3f22, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #6/1/0/m = #292 */
    { 0x0400, 0x059f, 0xb582, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0) }, /* #6/1/0/u = #293 */
    { 0x0422, 0x059f, 0x3f22, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #6/1/0/0x22 = #294 */
    { 0x0420, 0x059f, 0xb582, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0) }, /* #6/1/0/u0x2 = #295 */
    { 0x0402, 0x059f, 0xbfa2, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #6/1/0/u0x20 = #296 */
    { 0x057f, 0x059f, 0x3f22, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #6/1/1/m = #297 */
    { 0x0500, 0x059f, 0xb582, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0) }, /* #6/1/1/u = #298 */
    { 0x0522, 0x059f, 0x3f22, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #6/1/1/0x22 = #299 */
    { 0x0520, 0x059f, 0xb582, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0) }, /* #6/1/1/u0x2 = #300 */
    { 0x0502, 0x059f, 0xbfa2, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #6/1/1/u0x20 = #301 */
    { 0x067f, 0x059f, 0x3f22, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #6/1/2/m = #302 */
    { 0x0600, 0x059f, 0xb582, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0) }, /* #6/1/2/u = #303 */
    { 0x0622, 0x059f, 0x3f22, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #6/1/2/0x22 = #304 */
    { 0x0620, 0x059f, 0xb582, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0) }, /* #6/1/2/u0x2 = #305 */
    { 0x0602, 0x059f, 0xbfa2, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #6/1/2/u0x20 = #306 */
    { 0x077f, 0x059f, 0x3f22, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #6/1/3/m = #307 */
    { 0x0700, 0x059f, 0xb582, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0) }, /* #6/1/3/u = #308 */
    { 0x0722, 0x059f, 0x3f22, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #6/1/3/0x22 = #309 */
    { 0x0720, 0x059f, 0xb582, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0) }, /* #6/1/3/u0x2 = #310 */
    { 0x0702, 0x059f, 0xbfa2, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #6/1/3/u0x20 = #311 */
    { 0x087f, 0x059f, 0x3d22, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #6/2/0/m = #312 */
    { 0x0800, 0x059f, 0xb582, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0) }, /* #6/2/0/u = #313 */
    { 0x0822, 0x059f, 0x3d22, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #6/2/0/0x22 = #314 */
    { 0x0820, 0x059f, 0xb582, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0) }, /* #6/2/0/u0x2 = #315 */
    { 0x0802, 0x059f, 0xbda2, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #6/2/0/u0x20 = #316 */
    { 0x097f, 0x059f, 0x3d22, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #6/2/1/m = #317 */
    { 0x0900, 0x059f, 0xb582, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0) }, /* #6/2/1/u = #318 */
    { 0x0922, 0x059f, 0x3d22, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #6/2/1/0x22 = #319 */
    { 0x0920, 0x059f, 0xb582, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0) }, /* #6/2/1/u0x2 = #320 */
    { 0x0902, 0x059f, 0xbda2, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #6/2/1/u0x20 = #321 */
    { 0x0a7f, 0x059f, 0x3d22, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #6/2/2/m = #322 */
    { 0x0a00, 0x059f, 0xb582, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0) }, /* #6/2/2/u = #323 */
    { 0x0a22, 0x059f, 0x3d22, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #6/2/2/0x22 = #324 */
    { 0x0a20, 0x059f, 0xb582, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0) }, /* #6/2/2/u0x2 = #325 */
    { 0x0a02, 0x059f, 0xbda2, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #6/2/2/u0x20 = #326 */
    { 0x0b7f, 0x059f, 0x3d22, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #6/2/3/m = #327 */
    { 0x0b00, 0x059f, 0xb582, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0) }, /* #6/2/3/u = #328 */
    { 0x0b22, 0x059f, 0x3d22, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #6/2/3/0x22 = #329 */
    { 0x0b20, 0x059f, 0xb582, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0) }, /* #6/2/3/u0x2 = #330 */
    { 0x0b02, 0x059f, 0xbda2, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #6/2/3/u0x20 = #331 */
    { 0x0c7f, 0x059f, 0x3d22, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #6/3/0/m = #332 */
    { 0x0c00, 0x059f, 0xb582, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0) }, /* #6/3/0/u = #333 */
    { 0x0c22, 0x059f, 0x3d22, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #6/3/0/0x22 = #334 */
    { 0x0c20, 0x059f, 0xb582, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0) }, /* #6/3/0/u0x2 = #335 */
    { 0x0c02, 0x059f, 0xbda2, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #6/3/0/u0x20 = #336 */
    { 0x0d7f, 0x059f, 0x3d22, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #6/3/1/m = #337 */
    { 0x0d00, 0x059f, 0xb582, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0) }, /* #6/3/1/u = #338 */
    { 0x0d22, 0x059f, 0x3d22, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #6/3/1/0x22 = #339 */
    { 0x0d20, 0x059f, 0xb582, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0) }, /* #6/3/1/u0x2 = #340 */
    { 0x0d02, 0x059f, 0xbda2, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #6/3/1/u0x20 = #341 */
    { 0x0e7f, 0x059f, 0x3d22, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #6/3/2/m = #342 */
    { 0x0e00, 0x059f, 0xb582, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0) }, /* #6/3/2/u = #343 */
    { 0x0e22, 0x059f, 0x3d22, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #6/3/2/0x22 = #344 */
    { 0x0e20, 0x059f, 0xb582, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0) }, /* #6/3/2/u0x2 = #345 */
    { 0x0e02, 0x059f, 0xbda2, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #6/3/2/u0x20 = #346 */
    { 0x0f7f, 0x059f, 0x3d22, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #6/3/3/m = #347 */
    { 0x0f00, 0x059f, 0xb582, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0) }, /* #6/3/3/u = #348 */
    { 0x0f22, 0x059f, 0x3d22, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #6/3/3/0x22 = #349 */
    { 0x0f20, 0x059f, 0xb582, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0) }, /* #6/3/3/u0x2 = #350 */
    { 0x0f02, 0x059f, 0xbda2, RTFLOAT80U_INIT_C(1,0x8ba678576d320a0b,6163), RTFLOAT80U_INIT_C(0,0x853be2478fa26eb1,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #6/3/3/u0x20 = #351 */
    { 0x007f, 0xa90c, 0x3b22, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #7/0/0/m = #352 */
    { 0x0000, 0xa90c, 0xb182, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0) }, /* #7/0/0/u = #353 */
    { 0x0022, 0xa90c, 0x3b22, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #7/0/0/0x22 = #354 */
    { 0x0020, 0xa90c, 0xb182, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0) }, /* #7/0/0/u0x2 = #355 */
    { 0x0002, 0xa90c, 0xbba2, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #7/0/0/u0x20 = #356 */
    { 0x017f, 0xa90c, 0x3b22, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #7/0/1/m = #357 */
    { 0x0100, 0xa90c, 0xb182, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0) }, /* #7/0/1/u = #358 */
    { 0x0122, 0xa90c, 0x3b22, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #7/0/1/0x22 = #359 */
    { 0x0120, 0xa90c, 0xb182, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0) }, /* #7/0/1/u0x2 = #360 */
    { 0x0102, 0xa90c, 0xbba2, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #7/0/1/u0x20 = #361 */
    { 0x027f, 0xa90c, 0x3b22, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #7/0/2/m = #362 */
    { 0x0200, 0xa90c, 0xb182, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0) }, /* #7/0/2/u = #363 */
    { 0x0222, 0xa90c, 0x3b22, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #7/0/2/0x22 = #364 */
    { 0x0220, 0xa90c, 0xb182, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0) }, /* #7/0/2/u0x2 = #365 */
    { 0x0202, 0xa90c, 0xbba2, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #7/0/2/u0x20 = #366 */
    { 0x037f, 0xa90c, 0x3b22, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #7/0/3/m = #367 */
    { 0x0300, 0xa90c, 0xb182, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0) }, /* #7/0/3/u = #368 */
    { 0x0322, 0xa90c, 0x3b22, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #7/0/3/0x22 = #369 */
    { 0x0320, 0xa90c, 0xb182, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0) }, /* #7/0/3/u0x2 = #370 */
    { 0x0302, 0xa90c, 0xbba2, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #7/0/3/u0x20 = #371 */
    { 0x047f, 0xa90c, 0x3b22, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #7/1/0/m = #372 */
    { 0x0400, 0xa90c, 0xb182, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0) }, /* #7/1/0/u = #373 */
    { 0x0422, 0xa90c, 0x3b22, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #7/1/0/0x22 = #374 */
    { 0x0420, 0xa90c, 0xb182, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0) }, /* #7/1/0/u0x2 = #375 */
    { 0x0402, 0xa90c, 0xbba2, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #7/1/0/u0x20 = #376 */
    { 0x057f, 0xa90c, 0x3b22, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #7/1/1/m = #377 */
    { 0x0500, 0xa90c, 0xb182, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0) }, /* #7/1/1/u = #378 */
    { 0x0522, 0xa90c, 0x3b22, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #7/1/1/0x22 = #379 */
    { 0x0520, 0xa90c, 0xb182, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0) }, /* #7/1/1/u0x2 = #380 */
    { 0x0502, 0xa90c, 0xbba2, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #7/1/1/u0x20 = #381 */
    { 0x067f, 0xa90c, 0x3b22, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #7/1/2/m = #382 */
    { 0x0600, 0xa90c, 0xb182, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0) }, /* #7/1/2/u = #383 */
    { 0x0622, 0xa90c, 0x3b22, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #7/1/2/0x22 = #384 */
    { 0x0620, 0xa90c, 0xb182, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0) }, /* #7/1/2/u0x2 = #385 */
    { 0x0602, 0xa90c, 0xbba2, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #7/1/2/u0x20 = #386 */
    { 0x077f, 0xa90c, 0x3b22, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #7/1/3/m = #387 */
    { 0x0700, 0xa90c, 0xb182, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0) }, /* #7/1/3/u = #388 */
    { 0x0722, 0xa90c, 0x3b22, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #7/1/3/0x22 = #389 */
    { 0x0720, 0xa90c, 0xb182, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0) }, /* #7/1/3/u0x2 = #390 */
    { 0x0702, 0xa90c, 0xbba2, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #7/1/3/u0x20 = #391 */
    { 0x087f, 0xa90c, 0x3922, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #7/2/0/m = #392 */
    { 0x0800, 0xa90c, 0xb182, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0) }, /* #7/2/0/u = #393 */
    { 0x0822, 0xa90c, 0x3922, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #7/2/0/0x22 = #394 */
    { 0x0820, 0xa90c, 0xb182, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0) }, /* #7/2/0/u0x2 = #395 */
    { 0x0802, 0xa90c, 0xb9a2, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #7/2/0/u0x20 = #396 */
    { 0x097f, 0xa90c, 0x3922, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #7/2/1/m = #397 */
    { 0x0900, 0xa90c, 0xb182, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0) }, /* #7/2/1/u = #398 */
    { 0x0922, 0xa90c, 0x3922, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #7/2/1/0x22 = #399 */
    { 0x0920, 0xa90c, 0xb182, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0) }, /* #7/2/1/u0x2 = #400 */
    { 0x0902, 0xa90c, 0xb9a2, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #7/2/1/u0x20 = #401 */
    { 0x0a7f, 0xa90c, 0x3922, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #7/2/2/m = #402 */
    { 0x0a00, 0xa90c, 0xb182, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0) }, /* #7/2/2/u = #403 */
    { 0x0a22, 0xa90c, 0x3922, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #7/2/2/0x22 = #404 */
    { 0x0a20, 0xa90c, 0xb182, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0) }, /* #7/2/2/u0x2 = #405 */
    { 0x0a02, 0xa90c, 0xb9a2, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #7/2/2/u0x20 = #406 */
    { 0x0b7f, 0xa90c, 0x3922, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #7/2/3/m = #407 */
    { 0x0b00, 0xa90c, 0xb182, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0) }, /* #7/2/3/u = #408 */
    { 0x0b22, 0xa90c, 0x3922, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #7/2/3/0x22 = #409 */
    { 0x0b20, 0xa90c, 0xb182, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0) }, /* #7/2/3/u0x2 = #410 */
    { 0x0b02, 0xa90c, 0xb9a2, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #7/2/3/u0x20 = #411 */
    { 0x0c7f, 0xa90c, 0x3922, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #7/3/0/m = #412 */
    { 0x0c00, 0xa90c, 0xb182, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0) }, /* #7/3/0/u = #413 */
    { 0x0c22, 0xa90c, 0x3922, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #7/3/0/0x22 = #414 */
    { 0x0c20, 0xa90c, 0xb182, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0) }, /* #7/3/0/u0x2 = #415 */
    { 0x0c02, 0xa90c, 0xb9a2, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #7/3/0/u0x20 = #416 */
    { 0x0d7f, 0xa90c, 0x3922, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #7/3/1/m = #417 */
    { 0x0d00, 0xa90c, 0xb182, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0) }, /* #7/3/1/u = #418 */
    { 0x0d22, 0xa90c, 0x3922, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #7/3/1/0x22 = #419 */
    { 0x0d20, 0xa90c, 0xb182, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0) }, /* #7/3/1/u0x2 = #420 */
    { 0x0d02, 0xa90c, 0xb9a2, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #7/3/1/u0x20 = #421 */
    { 0x0e7f, 0xa90c, 0x3922, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #7/3/2/m = #422 */
    { 0x0e00, 0xa90c, 0xb182, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0) }, /* #7/3/2/u = #423 */
    { 0x0e22, 0xa90c, 0x3922, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #7/3/2/0x22 = #424 */
    { 0x0e20, 0xa90c, 0xb182, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0) }, /* #7/3/2/u0x2 = #425 */
    { 0x0e02, 0xa90c, 0xb9a2, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #7/3/2/u0x20 = #426 */
    { 0x0f7f, 0xa90c, 0x3922, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #7/3/3/m = #427 */
    { 0x0f00, 0xa90c, 0xb182, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0) }, /* #7/3/3/u = #428 */
    { 0x0f22, 0xa90c, 0x3922, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #7/3/3/0x22 = #429 */
    { 0x0f20, 0xa90c, 0xb182, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0) }, /* #7/3/3/u0x2 = #430 */
    { 0x0f02, 0xa90c, 0xb9a2, RTFLOAT80U_INIT_C(1,0xbfc7ee24cac0e342,7501), RTFLOAT80U_INIT_C(0,0x587c8ed7d20affa4,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #7/3/3/u0x20 = #431 */
    { 0x007f, 0x6537, 0x7d00, RTFLOAT80U_INIT_C(1,0xff96b2ee00ec4446,12200), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #8/0/0/m = #432 */
    { 0x0000, 0x6537, 0x7d00, RTFLOAT80U_INIT_C(1,0xff96b2ee00ec4446,12200), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #8/0/0/u = #433 */
    { 0x017f, 0x6537, 0x7d00, RTFLOAT80U_INIT_C(1,0xff96b2ee00ec4446,12200), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #8/0/1/m = #434 */
    { 0x0100, 0x6537, 0x7d00, RTFLOAT80U_INIT_C(1,0xff96b2ee00ec4446,12200), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #8/0/1/u = #435 */
    { 0x027f, 0x6537, 0x7d00, RTFLOAT80U_INIT_C(1,0xff96b2ee00ec4446,12200), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #8/0/2/m = #436 */
    { 0x0200, 0x6537, 0x7d00, RTFLOAT80U_INIT_C(1,0xff96b2ee00ec4446,12200), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #8/0/2/u = #437 */
    { 0x037f, 0x6537, 0x7d00, RTFLOAT80U_INIT_C(1,0xff96b2ee00ec4446,12200), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #8/0/3/m = #438 */
    { 0x0300, 0x6537, 0x7d00, RTFLOAT80U_INIT_C(1,0xff96b2ee00ec4446,12200), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #8/0/3/u = #439 */
    { 0x047f, 0x6537, 0x7d00, RTFLOAT80U_INIT_C(1,0xff96b2ee00ec4446,12200), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #8/1/0/m = #440 */
    { 0x0400, 0x6537, 0x7d00, RTFLOAT80U_INIT_C(1,0xff96b2ee00ec4446,12200), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #8/1/0/u = #441 */
    { 0x057f, 0x6537, 0x7d00, RTFLOAT80U_INIT_C(1,0xff96b2ee00ec4446,12200), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #8/1/1/m = #442 */
    { 0x0500, 0x6537, 0x7d00, RTFLOAT80U_INIT_C(1,0xff96b2ee00ec4446,12200), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #8/1/1/u = #443 */
    { 0x067f, 0x6537, 0x7d00, RTFLOAT80U_INIT_C(1,0xff96b2ee00ec4446,12200), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #8/1/2/m = #444 */
    { 0x0600, 0x6537, 0x7d00, RTFLOAT80U_INIT_C(1,0xff96b2ee00ec4446,12200), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #8/1/2/u = #445 */
    { 0x077f, 0x6537, 0x7d00, RTFLOAT80U_INIT_C(1,0xff96b2ee00ec4446,12200), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #8/1/3/m = #446 */
    { 0x0700, 0x6537, 0x7d00, RTFLOAT80U_INIT_C(1,0xff96b2ee00ec4446,12200), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #8/1/3/u = #447 */
    { 0x087f, 0x6537, 0x7d00, RTFLOAT80U_INIT_C(1,0xff96b2ee00ec4446,12200), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #8/2/0/m = #448 */
    { 0x0800, 0x6537, 0x7d00, RTFLOAT80U_INIT_C(1,0xff96b2ee00ec4446,12200), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #8/2/0/u = #449 */
    { 0x097f, 0x6537, 0x7d00, RTFLOAT80U_INIT_C(1,0xff96b2ee00ec4446,12200), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #8/2/1/m = #450 */
    { 0x0900, 0x6537, 0x7d00, RTFLOAT80U_INIT_C(1,0xff96b2ee00ec4446,12200), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #8/2/1/u = #451 */
    { 0x0a7f, 0x6537, 0x7d00, RTFLOAT80U_INIT_C(1,0xff96b2ee00ec4446,12200), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #8/2/2/m = #452 */
    { 0x0a00, 0x6537, 0x7d00, RTFLOAT80U_INIT_C(1,0xff96b2ee00ec4446,12200), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #8/2/2/u = #453 */
    { 0x0b7f, 0x6537, 0x7d00, RTFLOAT80U_INIT_C(1,0xff96b2ee00ec4446,12200), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #8/2/3/m = #454 */
    { 0x0b00, 0x6537, 0x7d00, RTFLOAT80U_INIT_C(1,0xff96b2ee00ec4446,12200), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #8/2/3/u = #455 */
    { 0x0c7f, 0x6537, 0x7d00, RTFLOAT80U_INIT_C(1,0xff96b2ee00ec4446,12200), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #8/3/0/m = #456 */
    { 0x0c00, 0x6537, 0x7d00, RTFLOAT80U_INIT_C(1,0xff96b2ee00ec4446,12200), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #8/3/0/u = #457 */
    { 0x0d7f, 0x6537, 0x7d00, RTFLOAT80U_INIT_C(1,0xff96b2ee00ec4446,12200), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #8/3/1/m = #458 */
    { 0x0d00, 0x6537, 0x7d00, RTFLOAT80U_INIT_C(1,0xff96b2ee00ec4446,12200), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #8/3/1/u = #459 */
    { 0x0e7f, 0x6537, 0x7d00, RTFLOAT80U_INIT_C(1,0xff96b2ee00ec4446,12200), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #8/3/2/m = #460 */
    { 0x0e00, 0x6537, 0x7d00, RTFLOAT80U_INIT_C(1,0xff96b2ee00ec4446,12200), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #8/3/2/u = #461 */
    { 0x0f7f, 0x6537, 0x7d00, RTFLOAT80U_INIT_C(1,0xff96b2ee00ec4446,12200), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #8/3/3/m = #462 */
    { 0x0f00, 0x6537, 0x7d00, RTFLOAT80U_INIT_C(1,0xff96b2ee00ec4446,12200), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #8/3/3/u = #463 */
    { 0x007f, 0xe4ed, 0x7e20, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #9/0/0/m = #464 */
    { 0x0000, 0xe4ed, 0xfea0, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #9/0/0/u = #465 */
    { 0x0020, 0xe4ed, 0x7e20, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #9/0/0/0x20 = #466 */
    { 0x017f, 0xe4ed, 0x7e20, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #9/0/1/m = #467 */
    { 0x0100, 0xe4ed, 0xfea0, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #9/0/1/u = #468 */
    { 0x0120, 0xe4ed, 0x7e20, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #9/0/1/0x20 = #469 */
    { 0x027f, 0xe4ed, 0x7e20, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #9/0/2/m = #470 */
    { 0x0200, 0xe4ed, 0xfea0, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #9/0/2/u = #471 */
    { 0x0220, 0xe4ed, 0x7e20, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #9/0/2/0x20 = #472 */
    { 0x037f, 0xe4ed, 0x7e20, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #9/0/3/m = #473 */
    { 0x0300, 0xe4ed, 0xfea0, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #9/0/3/u = #474 */
    { 0x0320, 0xe4ed, 0x7e20, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #9/0/3/0x20 = #475 */
    { 0x047f, 0xe4ed, 0x7e20, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #9/1/0/m = #476 */
    { 0x0400, 0xe4ed, 0xfea0, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #9/1/0/u = #477 */
    { 0x0420, 0xe4ed, 0x7e20, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #9/1/0/0x20 = #478 */
    { 0x057f, 0xe4ed, 0x7e20, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #9/1/1/m = #479 */
    { 0x0500, 0xe4ed, 0xfea0, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #9/1/1/u = #480 */
    { 0x0520, 0xe4ed, 0x7e20, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #9/1/1/0x20 = #481 */
    { 0x067f, 0xe4ed, 0x7e20, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #9/1/2/m = #482 */
    { 0x0600, 0xe4ed, 0xfea0, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #9/1/2/u = #483 */
    { 0x0620, 0xe4ed, 0x7e20, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #9/1/2/0x20 = #484 */
    { 0x077f, 0xe4ed, 0x7e20, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #9/1/3/m = #485 */
    { 0x0700, 0xe4ed, 0xfea0, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #9/1/3/u = #486 */
    { 0x0720, 0xe4ed, 0x7e20, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #9/1/3/0x20 = #487 */
    { 0x087f, 0xe4ed, 0x7c20, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #9/2/0/m = #488 */
    { 0x0800, 0xe4ed, 0xfca0, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #9/2/0/u = #489 */
    { 0x0820, 0xe4ed, 0x7c20, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #9/2/0/0x20 = #490 */
    { 0x097f, 0xe4ed, 0x7c20, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #9/2/1/m = #491 */
    { 0x0900, 0xe4ed, 0xfca0, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #9/2/1/u = #492 */
    { 0x0920, 0xe4ed, 0x7c20, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #9/2/1/0x20 = #493 */
    { 0x0a7f, 0xe4ed, 0x7c20, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #9/2/2/m = #494 */
    { 0x0a00, 0xe4ed, 0xfca0, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #9/2/2/u = #495 */
    { 0x0a20, 0xe4ed, 0x7c20, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #9/2/2/0x20 = #496 */
    { 0x0b7f, 0xe4ed, 0x7c20, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #9/2/3/m = #497 */
    { 0x0b00, 0xe4ed, 0xfca0, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #9/2/3/u = #498 */
    { 0x0b20, 0xe4ed, 0x7c20, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #9/2/3/0x20 = #499 */
    { 0x0c7f, 0xe4ed, 0x7c20, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #9/3/0/m = #500 */
    { 0x0c00, 0xe4ed, 0xfca0, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #9/3/0/u = #501 */
    { 0x0c20, 0xe4ed, 0x7c20, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #9/3/0/0x20 = #502 */
    { 0x0d7f, 0xe4ed, 0x7c20, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #9/3/1/m = #503 */
    { 0x0d00, 0xe4ed, 0xfca0, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #9/3/1/u = #504 */
    { 0x0d20, 0xe4ed, 0x7c20, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #9/3/1/0x20 = #505 */
    { 0x0e7f, 0xe4ed, 0x7c20, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #9/3/2/m = #506 */
    { 0x0e00, 0xe4ed, 0xfca0, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #9/3/2/u = #507 */
    { 0x0e20, 0xe4ed, 0x7c20, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #9/3/2/0x20 = #508 */
    { 0x0f7f, 0xe4ed, 0x7c20, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #9/3/3/m = #509 */
    { 0x0f00, 0xe4ed, 0xfca0, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #9/3/3/u = #510 */
    { 0x0f20, 0xe4ed, 0x7c20, RTFLOAT80U_INIT_C(1,0xb846940c750fdd6b,22135), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #9/3/3/0x20 = #511 */
    { 0x007f, 0xd92b, 0x7901, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/0/0/m = #512 */
    { 0x0000, 0xd92b, 0xf181, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #10/0/0/u = #513 */
    { 0x0001, 0xd92b, 0x7901, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/0/0/0x1 = #514 */
    { 0x017f, 0xd92b, 0x7901, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/0/1/m = #515 */
    { 0x0100, 0xd92b, 0xf181, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #10/0/1/u = #516 */
    { 0x0101, 0xd92b, 0x7901, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/0/1/0x1 = #517 */
    { 0x027f, 0xd92b, 0x7901, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/0/2/m = #518 */
    { 0x0200, 0xd92b, 0xf181, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #10/0/2/u = #519 */
    { 0x0201, 0xd92b, 0x7901, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/0/2/0x1 = #520 */
    { 0x037f, 0xd92b, 0x7901, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/0/3/m = #521 */
    { 0x0300, 0xd92b, 0xf181, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #10/0/3/u = #522 */
    { 0x0301, 0xd92b, 0x7901, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/0/3/0x1 = #523 */
    { 0x047f, 0xd92b, 0x7901, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/1/0/m = #524 */
    { 0x0400, 0xd92b, 0xf181, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #10/1/0/u = #525 */
    { 0x0401, 0xd92b, 0x7901, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/1/0/0x1 = #526 */
    { 0x057f, 0xd92b, 0x7901, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/1/1/m = #527 */
    { 0x0500, 0xd92b, 0xf181, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #10/1/1/u = #528 */
    { 0x0501, 0xd92b, 0x7901, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/1/1/0x1 = #529 */
    { 0x067f, 0xd92b, 0x7901, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/1/2/m = #530 */
    { 0x0600, 0xd92b, 0xf181, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #10/1/2/u = #531 */
    { 0x0601, 0xd92b, 0x7901, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/1/2/0x1 = #532 */
    { 0x077f, 0xd92b, 0x7901, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/1/3/m = #533 */
    { 0x0700, 0xd92b, 0xf181, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #10/1/3/u = #534 */
    { 0x0701, 0xd92b, 0x7901, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/1/3/0x1 = #535 */
    { 0x087f, 0xd92b, 0x7901, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/2/0/m = #536 */
    { 0x0800, 0xd92b, 0xf181, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #10/2/0/u = #537 */
    { 0x0801, 0xd92b, 0x7901, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/2/0/0x1 = #538 */
    { 0x097f, 0xd92b, 0x7901, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/2/1/m = #539 */
    { 0x0900, 0xd92b, 0xf181, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #10/2/1/u = #540 */
    { 0x0901, 0xd92b, 0x7901, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/2/1/0x1 = #541 */
    { 0x0a7f, 0xd92b, 0x7901, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/2/2/m = #542 */
    { 0x0a00, 0xd92b, 0xf181, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #10/2/2/u = #543 */
    { 0x0a01, 0xd92b, 0x7901, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/2/2/0x1 = #544 */
    { 0x0b7f, 0xd92b, 0x7901, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/2/3/m = #545 */
    { 0x0b00, 0xd92b, 0xf181, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #10/2/3/u = #546 */
    { 0x0b01, 0xd92b, 0x7901, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/2/3/0x1 = #547 */
    { 0x0c7f, 0xd92b, 0x7901, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/3/0/m = #548 */
    { 0x0c00, 0xd92b, 0xf181, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #10/3/0/u = #549 */
    { 0x0c01, 0xd92b, 0x7901, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/3/0/0x1 = #550 */
    { 0x0d7f, 0xd92b, 0x7901, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/3/1/m = #551 */
    { 0x0d00, 0xd92b, 0xf181, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #10/3/1/u = #552 */
    { 0x0d01, 0xd92b, 0x7901, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/3/1/0x1 = #553 */
    { 0x0e7f, 0xd92b, 0x7901, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/3/2/m = #554 */
    { 0x0e00, 0xd92b, 0xf181, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #10/3/2/u = #555 */
    { 0x0e01, 0xd92b, 0x7901, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/3/2/0x1 = #556 */
    { 0x0f7f, 0xd92b, 0x7901, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/3/3/m = #557 */
    { 0x0f00, 0xd92b, 0xf181, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #10/3/3/u = #558 */
    { 0x0f01, 0xd92b, 0x7901, RTFLOAT80U_INIT_C(0,0x8d42410891b1a4db,20204), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/3/3/0x1 = #559 */
    { 0x007f, 0x3f60, 0x3f20, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #11/0/0/m = #560 */
    { 0x0000, 0x3f60, 0xbfa0, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #11/0/0/u = #561 */
    { 0x0020, 0x3f60, 0x3f20, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #11/0/0/0x20 = #562 */
    { 0x017f, 0x3f60, 0x3f20, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #11/0/1/m = #563 */
    { 0x0100, 0x3f60, 0xbfa0, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #11/0/1/u = #564 */
    { 0x0120, 0x3f60, 0x3f20, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #11/0/1/0x20 = #565 */
    { 0x027f, 0x3f60, 0x3f20, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #11/0/2/m = #566 */
    { 0x0200, 0x3f60, 0xbfa0, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #11/0/2/u = #567 */
    { 0x0220, 0x3f60, 0x3f20, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #11/0/2/0x20 = #568 */
    { 0x037f, 0x3f60, 0x3f20, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #11/0/3/m = #569 */
    { 0x0300, 0x3f60, 0xbfa0, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #11/0/3/u = #570 */
    { 0x0320, 0x3f60, 0x3f20, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #11/0/3/0x20 = #571 */
    { 0x047f, 0x3f60, 0x3d20, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #11/1/0/m = #572 */
    { 0x0400, 0x3f60, 0xbda0, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #11/1/0/u = #573 */
    { 0x0420, 0x3f60, 0x3d20, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #11/1/0/0x20 = #574 */
    { 0x057f, 0x3f60, 0x3d20, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #11/1/1/m = #575 */
    { 0x0500, 0x3f60, 0xbda0, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #11/1/1/u = #576 */
    { 0x0520, 0x3f60, 0x3d20, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #11/1/1/0x20 = #577 */
    { 0x067f, 0x3f60, 0x3d20, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #11/1/2/m = #578 */
    { 0x0600, 0x3f60, 0xbda0, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #11/1/2/u = #579 */
    { 0x0620, 0x3f60, 0x3d20, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #11/1/2/0x20 = #580 */
    { 0x077f, 0x3f60, 0x3d20, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #11/1/3/m = #581 */
    { 0x0700, 0x3f60, 0xbda0, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #11/1/3/u = #582 */
    { 0x0720, 0x3f60, 0x3d20, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #11/1/3/0x20 = #583 */
    { 0x087f, 0x3f60, 0x3f20, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #11/2/0/m = #584 */
    { 0x0800, 0x3f60, 0xbfa0, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #11/2/0/u = #585 */
    { 0x0820, 0x3f60, 0x3f20, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #11/2/0/0x20 = #586 */
    { 0x097f, 0x3f60, 0x3f20, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #11/2/1/m = #587 */
    { 0x0900, 0x3f60, 0xbfa0, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #11/2/1/u = #588 */
    { 0x0920, 0x3f60, 0x3f20, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #11/2/1/0x20 = #589 */
    { 0x0a7f, 0x3f60, 0x3f20, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #11/2/2/m = #590 */
    { 0x0a00, 0x3f60, 0xbfa0, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #11/2/2/u = #591 */
    { 0x0a20, 0x3f60, 0x3f20, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #11/2/2/0x20 = #592 */
    { 0x0b7f, 0x3f60, 0x3f20, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #11/2/3/m = #593 */
    { 0x0b00, 0x3f60, 0xbfa0, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #11/2/3/u = #594 */
    { 0x0b20, 0x3f60, 0x3f20, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #11/2/3/0x20 = #595 */
    { 0x0c7f, 0x3f60, 0x3d20, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #11/3/0/m = #596 */
    { 0x0c00, 0x3f60, 0xbda0, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #11/3/0/u = #597 */
    { 0x0c20, 0x3f60, 0x3d20, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #11/3/0/0x20 = #598 */
    { 0x0d7f, 0x3f60, 0x3d20, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #11/3/1/m = #599 */
    { 0x0d00, 0x3f60, 0xbda0, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #11/3/1/u = #600 */
    { 0x0d20, 0x3f60, 0x3d20, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #11/3/1/0x20 = #601 */
    { 0x0e7f, 0x3f60, 0x3d20, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #11/3/2/m = #602 */
    { 0x0e00, 0x3f60, 0xbda0, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #11/3/2/u = #603 */
    { 0x0e20, 0x3f60, 0x3d20, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #11/3/2/0x20 = #604 */
    { 0x0f7f, 0x3f60, 0x3d20, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #11/3/3/m = #605 */
    { 0x0f00, 0x3f60, 0xbda0, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #11/3/3/u = #606 */
    { 0x0f20, 0x3f60, 0x3d20, RTFLOAT80U_INIT_C(0,0x8be9313f84eeb4e8,5251), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #11/3/3/0x20 = #607 */
    { 0x007f, 0x2d95, 0x3f20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #12/0/0/m = #608 */
    { 0x0000, 0x2d95, 0xbfa0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #12/0/0/u = #609 */
    { 0x0020, 0x2d95, 0x3f20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #12/0/0/0x20 = #610 */
    { 0x017f, 0x2d95, 0x3f20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #12/0/1/m = #611 */
    { 0x0100, 0x2d95, 0xbfa0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #12/0/1/u = #612 */
    { 0x0120, 0x2d95, 0x3f20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #12/0/1/0x20 = #613 */
    { 0x027f, 0x2d95, 0x3f20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #12/0/2/m = #614 */
    { 0x0200, 0x2d95, 0xbfa0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #12/0/2/u = #615 */
    { 0x0220, 0x2d95, 0x3f20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #12/0/2/0x20 = #616 */
    { 0x037f, 0x2d95, 0x3f20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #12/0/3/m = #617 */
    { 0x0300, 0x2d95, 0xbfa0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #12/0/3/u = #618 */
    { 0x0320, 0x2d95, 0x3f20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #12/0/3/0x20 = #619 */
    { 0x047f, 0x2d95, 0x3d20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #12/1/0/m = #620 */
    { 0x0400, 0x2d95, 0xbda0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #12/1/0/u = #621 */
    { 0x0420, 0x2d95, 0x3d20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #12/1/0/0x20 = #622 */
    { 0x057f, 0x2d95, 0x3d20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #12/1/1/m = #623 */
    { 0x0500, 0x2d95, 0xbda0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #12/1/1/u = #624 */
    { 0x0520, 0x2d95, 0x3d20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #12/1/1/0x20 = #625 */
    { 0x067f, 0x2d95, 0x3d20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #12/1/2/m = #626 */
    { 0x0600, 0x2d95, 0xbda0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #12/1/2/u = #627 */
    { 0x0620, 0x2d95, 0x3d20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #12/1/2/0x20 = #628 */
    { 0x077f, 0x2d95, 0x3d20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #12/1/3/m = #629 */
    { 0x0700, 0x2d95, 0xbda0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #12/1/3/u = #630 */
    { 0x0720, 0x2d95, 0x3d20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #12/1/3/0x20 = #631 */
    { 0x087f, 0x2d95, 0x3f20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #12/2/0/m = #632 */
    { 0x0800, 0x2d95, 0xbfa0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #12/2/0/u = #633 */
    { 0x0820, 0x2d95, 0x3f20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #12/2/0/0x20 = #634 */
    { 0x097f, 0x2d95, 0x3f20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #12/2/1/m = #635 */
    { 0x0900, 0x2d95, 0xbfa0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #12/2/1/u = #636 */
    { 0x0920, 0x2d95, 0x3f20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #12/2/1/0x20 = #637 */
    { 0x0a7f, 0x2d95, 0x3f20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #12/2/2/m = #638 */
    { 0x0a00, 0x2d95, 0xbfa0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #12/2/2/u = #639 */
    { 0x0a20, 0x2d95, 0x3f20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #12/2/2/0x20 = #640 */
    { 0x0b7f, 0x2d95, 0x3f20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #12/2/3/m = #641 */
    { 0x0b00, 0x2d95, 0xbfa0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #12/2/3/u = #642 */
    { 0x0b20, 0x2d95, 0x3f20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #12/2/3/0x20 = #643 */
    { 0x0c7f, 0x2d95, 0x3d20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #12/3/0/m = #644 */
    { 0x0c00, 0x2d95, 0xbda0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #12/3/0/u = #645 */
    { 0x0c20, 0x2d95, 0x3d20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #12/3/0/0x20 = #646 */
    { 0x0d7f, 0x2d95, 0x3d20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #12/3/1/m = #647 */
    { 0x0d00, 0x2d95, 0xbda0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #12/3/1/u = #648 */
    { 0x0d20, 0x2d95, 0x3d20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #12/3/1/0x20 = #649 */
    { 0x0e7f, 0x2d95, 0x3d20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #12/3/2/m = #650 */
    { 0x0e00, 0x2d95, 0xbda0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #12/3/2/u = #651 */
    { 0x0e20, 0x2d95, 0x3d20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #12/3/2/0x20 = #652 */
    { 0x0f7f, 0x2d95, 0x3d20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #12/3/3/m = #653 */
    { 0x0f00, 0x2d95, 0xbda0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #12/3/3/u = #654 */
    { 0x0f20, 0x2d95, 0x3d20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0x94023ae8de602b5a,31457), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #12/3/3/0x20 = #655 */
    { 0x007f, 0x99ea, 0x3b20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaaddde,16370) }, /* #13/0/0/m = #656 */
    { 0x0000, 0x99ea, 0xbba0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaaddde,16370) }, /* #13/0/0/u = #657 */
    { 0x0020, 0x99ea, 0x3b20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaaddde,16370) }, /* #13/0/0/0x20 = #658 */
    { 0x017f, 0x99ea, 0x3b20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaaddde,16370) }, /* #13/0/1/m = #659 */
    { 0x0100, 0x99ea, 0xbba0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaaddde,16370) }, /* #13/0/1/u = #660 */
    { 0x0120, 0x99ea, 0x3b20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaaddde,16370) }, /* #13/0/1/0x20 = #661 */
    { 0x027f, 0x99ea, 0x3b20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaaddde,16370) }, /* #13/0/2/m = #662 */
    { 0x0200, 0x99ea, 0xbba0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaaddde,16370) }, /* #13/0/2/u = #663 */
    { 0x0220, 0x99ea, 0x3b20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaaddde,16370) }, /* #13/0/2/0x20 = #664 */
    { 0x037f, 0x99ea, 0x3b20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaaddde,16370) }, /* #13/0/3/m = #665 */
    { 0x0300, 0x99ea, 0xbba0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaaddde,16370) }, /* #13/0/3/u = #666 */
    { 0x0320, 0x99ea, 0x3b20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaaddde,16370) }, /* #13/0/3/0x20 = #667 */
    { 0x047f, 0x99ea, 0x3b20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaaddde,16370) }, /* #13/1/0/m = #668 */
    { 0x0400, 0x99ea, 0xbba0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaaddde,16370) }, /* #13/1/0/u = #669 */
    { 0x0420, 0x99ea, 0x3b20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaaddde,16370) }, /* #13/1/0/0x20 = #670 */
    { 0x057f, 0x99ea, 0x3b20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaaddde,16370) }, /* #13/1/1/m = #671 */
    { 0x0500, 0x99ea, 0xbba0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaaddde,16370) }, /* #13/1/1/u = #672 */
    { 0x0520, 0x99ea, 0x3b20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaaddde,16370) }, /* #13/1/1/0x20 = #673 */
    { 0x067f, 0x99ea, 0x3b20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaaddde,16370) }, /* #13/1/2/m = #674 */
    { 0x0600, 0x99ea, 0xbba0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaaddde,16370) }, /* #13/1/2/u = #675 */
    { 0x0620, 0x99ea, 0x3b20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaaddde,16370) }, /* #13/1/2/0x20 = #676 */
    { 0x077f, 0x99ea, 0x3b20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaaddde,16370) }, /* #13/1/3/m = #677 */
    { 0x0700, 0x99ea, 0xbba0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaaddde,16370) }, /* #13/1/3/u = #678 */
    { 0x0720, 0x99ea, 0x3b20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaaddde,16370) }, /* #13/1/3/0x20 = #679 */
    { 0x087f, 0x99ea, 0x3920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaadddd,16370) }, /* #13/2/0/m = #680 */
    { 0x0800, 0x99ea, 0xb9a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaadddd,16370) }, /* #13/2/0/u = #681 */
    { 0x0820, 0x99ea, 0x3920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaadddd,16370) }, /* #13/2/0/0x20 = #682 */
    { 0x097f, 0x99ea, 0x3920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaadddd,16370) }, /* #13/2/1/m = #683 */
    { 0x0900, 0x99ea, 0xb9a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaadddd,16370) }, /* #13/2/1/u = #684 */
    { 0x0920, 0x99ea, 0x3920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaadddd,16370) }, /* #13/2/1/0x20 = #685 */
    { 0x0a7f, 0x99ea, 0x3920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaadddd,16370) }, /* #13/2/2/m = #686 */
    { 0x0a00, 0x99ea, 0xb9a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaadddd,16370) }, /* #13/2/2/u = #687 */
    { 0x0a20, 0x99ea, 0x3920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaadddd,16370) }, /* #13/2/2/0x20 = #688 */
    { 0x0b7f, 0x99ea, 0x3920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaadddd,16370) }, /* #13/2/3/m = #689 */
    { 0x0b00, 0x99ea, 0xb9a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaadddd,16370) }, /* #13/2/3/u = #690 */
    { 0x0b20, 0x99ea, 0x3920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaadddd,16370) }, /* #13/2/3/0x20 = #691 */
    { 0x0c7f, 0x99ea, 0x3920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaadddd,16370) }, /* #13/3/0/m = #692 */
    { 0x0c00, 0x99ea, 0xb9a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaadddd,16370) }, /* #13/3/0/u = #693 */
    { 0x0c20, 0x99ea, 0x3920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaadddd,16370) }, /* #13/3/0/0x20 = #694 */
    { 0x0d7f, 0x99ea, 0x3920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaadddd,16370) }, /* #13/3/1/m = #695 */
    { 0x0d00, 0x99ea, 0xb9a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaadddd,16370) }, /* #13/3/1/u = #696 */
    { 0x0d20, 0x99ea, 0x3920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaadddd,16370) }, /* #13/3/1/0x20 = #697 */
    { 0x0e7f, 0x99ea, 0x3920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaadddd,16370) }, /* #13/3/2/m = #698 */
    { 0x0e00, 0x99ea, 0xb9a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaadddd,16370) }, /* #13/3/2/u = #699 */
    { 0x0e20, 0x99ea, 0x3920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaadddd,16370) }, /* #13/3/2/0x20 = #700 */
    { 0x0f7f, 0x99ea, 0x3920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaadddd,16370) }, /* #13/3/3/m = #701 */
    { 0x0f00, 0x99ea, 0xb9a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaadddd,16370) }, /* #13/3/3/u = #702 */
    { 0x0f20, 0x99ea, 0x3920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffaaaaaadddd,16370) }, /* #13/3/3/0x20 = #703 */
    { 0x007f, 0x24bb, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_IND(1) }, /* #14/0/0/m = #704 */
    { 0x0000, 0x24bb, 0xb481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856) }, /* #14/0/0/u = #705 */
    { 0x0001, 0x24bb, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_IND(1) }, /* #14/0/0/0x1 = #706 */
    { 0x017f, 0x24bb, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_IND(1) }, /* #14/0/1/m = #707 */
    { 0x0100, 0x24bb, 0xb481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856) }, /* #14/0/1/u = #708 */
    { 0x0101, 0x24bb, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_IND(1) }, /* #14/0/1/0x1 = #709 */
    { 0x027f, 0x24bb, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_IND(1) }, /* #14/0/2/m = #710 */
    { 0x0200, 0x24bb, 0xb481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856) }, /* #14/0/2/u = #711 */
    { 0x0201, 0x24bb, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_IND(1) }, /* #14/0/2/0x1 = #712 */
    { 0x037f, 0x24bb, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_IND(1) }, /* #14/0/3/m = #713 */
    { 0x0300, 0x24bb, 0xb481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856) }, /* #14/0/3/u = #714 */
    { 0x0301, 0x24bb, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_IND(1) }, /* #14/0/3/0x1 = #715 */
    { 0x047f, 0x24bb, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_IND(1) }, /* #14/1/0/m = #716 */
    { 0x0400, 0x24bb, 0xb481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856) }, /* #14/1/0/u = #717 */
    { 0x0401, 0x24bb, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_IND(1) }, /* #14/1/0/0x1 = #718 */
    { 0x057f, 0x24bb, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_IND(1) }, /* #14/1/1/m = #719 */
    { 0x0500, 0x24bb, 0xb481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856) }, /* #14/1/1/u = #720 */
    { 0x0501, 0x24bb, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_IND(1) }, /* #14/1/1/0x1 = #721 */
    { 0x067f, 0x24bb, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_IND(1) }, /* #14/1/2/m = #722 */
    { 0x0600, 0x24bb, 0xb481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856) }, /* #14/1/2/u = #723 */
    { 0x0601, 0x24bb, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_IND(1) }, /* #14/1/2/0x1 = #724 */
    { 0x077f, 0x24bb, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_IND(1) }, /* #14/1/3/m = #725 */
    { 0x0700, 0x24bb, 0xb481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856) }, /* #14/1/3/u = #726 */
    { 0x0701, 0x24bb, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_IND(1) }, /* #14/1/3/0x1 = #727 */
    { 0x087f, 0x24bb, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_IND(1) }, /* #14/2/0/m = #728 */
    { 0x0800, 0x24bb, 0xb481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856) }, /* #14/2/0/u = #729 */
    { 0x0801, 0x24bb, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_IND(1) }, /* #14/2/0/0x1 = #730 */
    { 0x097f, 0x24bb, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_IND(1) }, /* #14/2/1/m = #731 */
    { 0x0900, 0x24bb, 0xb481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856) }, /* #14/2/1/u = #732 */
    { 0x0901, 0x24bb, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_IND(1) }, /* #14/2/1/0x1 = #733 */
    { 0x0a7f, 0x24bb, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_IND(1) }, /* #14/2/2/m = #734 */
    { 0x0a00, 0x24bb, 0xb481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856) }, /* #14/2/2/u = #735 */
    { 0x0a01, 0x24bb, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_IND(1) }, /* #14/2/2/0x1 = #736 */
    { 0x0b7f, 0x24bb, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_IND(1) }, /* #14/2/3/m = #737 */
    { 0x0b00, 0x24bb, 0xb481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856) }, /* #14/2/3/u = #738 */
    { 0x0b01, 0x24bb, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_IND(1) }, /* #14/2/3/0x1 = #739 */
    { 0x0c7f, 0x24bb, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_IND(1) }, /* #14/3/0/m = #740 */
    { 0x0c00, 0x24bb, 0xb481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856) }, /* #14/3/0/u = #741 */
    { 0x0c01, 0x24bb, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_IND(1) }, /* #14/3/0/0x1 = #742 */
    { 0x0d7f, 0x24bb, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_IND(1) }, /* #14/3/1/m = #743 */
    { 0x0d00, 0x24bb, 0xb481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856) }, /* #14/3/1/u = #744 */
    { 0x0d01, 0x24bb, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_IND(1) }, /* #14/3/1/0x1 = #745 */
    { 0x0e7f, 0x24bb, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_IND(1) }, /* #14/3/2/m = #746 */
    { 0x0e00, 0x24bb, 0xb481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856) }, /* #14/3/2/u = #747 */
    { 0x0e01, 0x24bb, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_IND(1) }, /* #14/3/2/0x1 = #748 */
    { 0x0f7f, 0x24bb, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_IND(1) }, /* #14/3/3/m = #749 */
    { 0x0f00, 0x24bb, 0xb481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856) }, /* #14/3/3/u = #750 */
    { 0x0f01, 0x24bb, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x13b02674a8884b49,23856), RTFLOAT80U_INIT_IND(1) }, /* #14/3/3/0x1 = #751 */
    { 0x007f, 0xa0d6, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xe4faf66adaf42171,32767) }, /* #15/0/0/m = #752 */
    { 0x0000, 0xa0d6, 0xb081, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767) }, /* #15/0/0/u = #753 */
    { 0x0001, 0xa0d6, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xe4faf66adaf42171,32767) }, /* #15/0/0/0x1 = #754 */
    { 0x017f, 0xa0d6, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xe4faf66adaf42171,32767) }, /* #15/0/1/m = #755 */
    { 0x0100, 0xa0d6, 0xb081, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767) }, /* #15/0/1/u = #756 */
    { 0x0101, 0xa0d6, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xe4faf66adaf42171,32767) }, /* #15/0/1/0x1 = #757 */
    { 0x027f, 0xa0d6, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xe4faf66adaf42171,32767) }, /* #15/0/2/m = #758 */
    { 0x0200, 0xa0d6, 0xb081, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767) }, /* #15/0/2/u = #759 */
    { 0x0201, 0xa0d6, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xe4faf66adaf42171,32767) }, /* #15/0/2/0x1 = #760 */
    { 0x037f, 0xa0d6, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xe4faf66adaf42171,32767) }, /* #15/0/3/m = #761 */
    { 0x0300, 0xa0d6, 0xb081, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767) }, /* #15/0/3/u = #762 */
    { 0x0301, 0xa0d6, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xe4faf66adaf42171,32767) }, /* #15/0/3/0x1 = #763 */
    { 0x047f, 0xa0d6, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xe4faf66adaf42171,32767) }, /* #15/1/0/m = #764 */
    { 0x0400, 0xa0d6, 0xb081, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767) }, /* #15/1/0/u = #765 */
    { 0x0401, 0xa0d6, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xe4faf66adaf42171,32767) }, /* #15/1/0/0x1 = #766 */
    { 0x057f, 0xa0d6, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xe4faf66adaf42171,32767) }, /* #15/1/1/m = #767 */
    { 0x0500, 0xa0d6, 0xb081, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767) }, /* #15/1/1/u = #768 */
    { 0x0501, 0xa0d6, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xe4faf66adaf42171,32767) }, /* #15/1/1/0x1 = #769 */
    { 0x067f, 0xa0d6, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xe4faf66adaf42171,32767) }, /* #15/1/2/m = #770 */
    { 0x0600, 0xa0d6, 0xb081, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767) }, /* #15/1/2/u = #771 */
    { 0x0601, 0xa0d6, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xe4faf66adaf42171,32767) }, /* #15/1/2/0x1 = #772 */
    { 0x077f, 0xa0d6, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xe4faf66adaf42171,32767) }, /* #15/1/3/m = #773 */
    { 0x0700, 0xa0d6, 0xb081, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767) }, /* #15/1/3/u = #774 */
    { 0x0701, 0xa0d6, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xe4faf66adaf42171,32767) }, /* #15/1/3/0x1 = #775 */
    { 0x087f, 0xa0d6, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xe4faf66adaf42171,32767) }, /* #15/2/0/m = #776 */
    { 0x0800, 0xa0d6, 0xb081, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767) }, /* #15/2/0/u = #777 */
    { 0x0801, 0xa0d6, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xe4faf66adaf42171,32767) }, /* #15/2/0/0x1 = #778 */
    { 0x097f, 0xa0d6, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xe4faf66adaf42171,32767) }, /* #15/2/1/m = #779 */
    { 0x0900, 0xa0d6, 0xb081, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767) }, /* #15/2/1/u = #780 */
    { 0x0901, 0xa0d6, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xe4faf66adaf42171,32767) }, /* #15/2/1/0x1 = #781 */
    { 0x0a7f, 0xa0d6, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xe4faf66adaf42171,32767) }, /* #15/2/2/m = #782 */
    { 0x0a00, 0xa0d6, 0xb081, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767) }, /* #15/2/2/u = #783 */
    { 0x0a01, 0xa0d6, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xe4faf66adaf42171,32767) }, /* #15/2/2/0x1 = #784 */
    { 0x0b7f, 0xa0d6, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xe4faf66adaf42171,32767) }, /* #15/2/3/m = #785 */
    { 0x0b00, 0xa0d6, 0xb081, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767) }, /* #15/2/3/u = #786 */
    { 0x0b01, 0xa0d6, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xe4faf66adaf42171,32767) }, /* #15/2/3/0x1 = #787 */
    { 0x0c7f, 0xa0d6, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xe4faf66adaf42171,32767) }, /* #15/3/0/m = #788 */
    { 0x0c00, 0xa0d6, 0xb081, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767) }, /* #15/3/0/u = #789 */
    { 0x0c01, 0xa0d6, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xe4faf66adaf42171,32767) }, /* #15/3/0/0x1 = #790 */
    { 0x0d7f, 0xa0d6, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xe4faf66adaf42171,32767) }, /* #15/3/1/m = #791 */
    { 0x0d00, 0xa0d6, 0xb081, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767) }, /* #15/3/1/u = #792 */
    { 0x0d01, 0xa0d6, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xe4faf66adaf42171,32767) }, /* #15/3/1/0x1 = #793 */
    { 0x0e7f, 0xa0d6, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xe4faf66adaf42171,32767) }, /* #15/3/2/m = #794 */
    { 0x0e00, 0xa0d6, 0xb081, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767) }, /* #15/3/2/u = #795 */
    { 0x0e01, 0xa0d6, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xe4faf66adaf42171,32767) }, /* #15/3/2/0x1 = #796 */
    { 0x0f7f, 0xa0d6, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xe4faf66adaf42171,32767) }, /* #15/3/3/m = #797 */
    { 0x0f00, 0xa0d6, 0xb081, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767) }, /* #15/3/3/u = #798 */
    { 0x0f01, 0xa0d6, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa4faf66adaf42171,32767), RTFLOAT80U_INIT_C(1,0xe4faf66adaf42171,32767) }, /* #15/3/3/0x1 = #799 */
    { 0x007f, 0xaa9b, 0x3800, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767) }, /* #16/0/0/m = #800 */
    { 0x0000, 0xaa9b, 0x3800, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767) }, /* #16/0/0/u = #801 */
    { 0x017f, 0xaa9b, 0x3800, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767) }, /* #16/0/1/m = #802 */
    { 0x0100, 0xaa9b, 0x3800, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767) }, /* #16/0/1/u = #803 */
    { 0x027f, 0xaa9b, 0x3800, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767) }, /* #16/0/2/m = #804 */
    { 0x0200, 0xaa9b, 0x3800, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767) }, /* #16/0/2/u = #805 */
    { 0x037f, 0xaa9b, 0x3800, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767) }, /* #16/0/3/m = #806 */
    { 0x0300, 0xaa9b, 0x3800, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767) }, /* #16/0/3/u = #807 */
    { 0x047f, 0xaa9b, 0x3800, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767) }, /* #16/1/0/m = #808 */
    { 0x0400, 0xaa9b, 0x3800, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767) }, /* #16/1/0/u = #809 */
    { 0x057f, 0xaa9b, 0x3800, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767) }, /* #16/1/1/m = #810 */
    { 0x0500, 0xaa9b, 0x3800, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767) }, /* #16/1/1/u = #811 */
    { 0x067f, 0xaa9b, 0x3800, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767) }, /* #16/1/2/m = #812 */
    { 0x0600, 0xaa9b, 0x3800, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767) }, /* #16/1/2/u = #813 */
    { 0x077f, 0xaa9b, 0x3800, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767) }, /* #16/1/3/m = #814 */
    { 0x0700, 0xaa9b, 0x3800, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767) }, /* #16/1/3/u = #815 */
    { 0x087f, 0xaa9b, 0x3800, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767) }, /* #16/2/0/m = #816 */
    { 0x0800, 0xaa9b, 0x3800, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767) }, /* #16/2/0/u = #817 */
    { 0x097f, 0xaa9b, 0x3800, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767) }, /* #16/2/1/m = #818 */
    { 0x0900, 0xaa9b, 0x3800, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767) }, /* #16/2/1/u = #819 */
    { 0x0a7f, 0xaa9b, 0x3800, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767) }, /* #16/2/2/m = #820 */
    { 0x0a00, 0xaa9b, 0x3800, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767) }, /* #16/2/2/u = #821 */
    { 0x0b7f, 0xaa9b, 0x3800, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767) }, /* #16/2/3/m = #822 */
    { 0x0b00, 0xaa9b, 0x3800, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767) }, /* #16/2/3/u = #823 */
    { 0x0c7f, 0xaa9b, 0x3800, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767) }, /* #16/3/0/m = #824 */
    { 0x0c00, 0xaa9b, 0x3800, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767) }, /* #16/3/0/u = #825 */
    { 0x0d7f, 0xaa9b, 0x3800, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767) }, /* #16/3/1/m = #826 */
    { 0x0d00, 0xaa9b, 0x3800, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767) }, /* #16/3/1/u = #827 */
    { 0x0e7f, 0xaa9b, 0x3800, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767) }, /* #16/3/2/m = #828 */
    { 0x0e00, 0xaa9b, 0x3800, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767) }, /* #16/3/2/u = #829 */
    { 0x0f7f, 0xaa9b, 0x3800, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767) }, /* #16/3/3/m = #830 */
    { 0x0f00, 0xaa9b, 0x3800, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767), RTFLOAT80U_INIT_C(0,0xf79e53f10c1c8e2a,32767) }, /* #16/3/3/u = #831 */
    { 0x007f, 0x4afe, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/0/0/m = #832 */
    { 0x0000, 0x4afe, 0xf081, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767) }, /* #17/0/0/u = #833 */
    { 0x0001, 0x4afe, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/0/0/0x1 = #834 */
    { 0x017f, 0x4afe, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/0/1/m = #835 */
    { 0x0100, 0x4afe, 0xf081, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767) }, /* #17/0/1/u = #836 */
    { 0x0101, 0x4afe, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/0/1/0x1 = #837 */
    { 0x027f, 0x4afe, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/0/2/m = #838 */
    { 0x0200, 0x4afe, 0xf081, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767) }, /* #17/0/2/u = #839 */
    { 0x0201, 0x4afe, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/0/2/0x1 = #840 */
    { 0x037f, 0x4afe, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/0/3/m = #841 */
    { 0x0300, 0x4afe, 0xf081, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767) }, /* #17/0/3/u = #842 */
    { 0x0301, 0x4afe, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/0/3/0x1 = #843 */
    { 0x047f, 0x4afe, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/1/0/m = #844 */
    { 0x0400, 0x4afe, 0xf081, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767) }, /* #17/1/0/u = #845 */
    { 0x0401, 0x4afe, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/1/0/0x1 = #846 */
    { 0x057f, 0x4afe, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/1/1/m = #847 */
    { 0x0500, 0x4afe, 0xf081, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767) }, /* #17/1/1/u = #848 */
    { 0x0501, 0x4afe, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/1/1/0x1 = #849 */
    { 0x067f, 0x4afe, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/1/2/m = #850 */
    { 0x0600, 0x4afe, 0xf081, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767) }, /* #17/1/2/u = #851 */
    { 0x0601, 0x4afe, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/1/2/0x1 = #852 */
    { 0x077f, 0x4afe, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/1/3/m = #853 */
    { 0x0700, 0x4afe, 0xf081, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767) }, /* #17/1/3/u = #854 */
    { 0x0701, 0x4afe, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/1/3/0x1 = #855 */
    { 0x087f, 0x4afe, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/2/0/m = #856 */
    { 0x0800, 0x4afe, 0xf081, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767) }, /* #17/2/0/u = #857 */
    { 0x0801, 0x4afe, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/2/0/0x1 = #858 */
    { 0x097f, 0x4afe, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/2/1/m = #859 */
    { 0x0900, 0x4afe, 0xf081, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767) }, /* #17/2/1/u = #860 */
    { 0x0901, 0x4afe, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/2/1/0x1 = #861 */
    { 0x0a7f, 0x4afe, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/2/2/m = #862 */
    { 0x0a00, 0x4afe, 0xf081, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767) }, /* #17/2/2/u = #863 */
    { 0x0a01, 0x4afe, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/2/2/0x1 = #864 */
    { 0x0b7f, 0x4afe, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/2/3/m = #865 */
    { 0x0b00, 0x4afe, 0xf081, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767) }, /* #17/2/3/u = #866 */
    { 0x0b01, 0x4afe, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/2/3/0x1 = #867 */
    { 0x0c7f, 0x4afe, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/3/0/m = #868 */
    { 0x0c00, 0x4afe, 0xf081, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767) }, /* #17/3/0/u = #869 */
    { 0x0c01, 0x4afe, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/3/0/0x1 = #870 */
    { 0x0d7f, 0x4afe, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/3/1/m = #871 */
    { 0x0d00, 0x4afe, 0xf081, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767) }, /* #17/3/1/u = #872 */
    { 0x0d01, 0x4afe, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/3/1/0x1 = #873 */
    { 0x0e7f, 0x4afe, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/3/2/m = #874 */
    { 0x0e00, 0x4afe, 0xf081, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767) }, /* #17/3/2/u = #875 */
    { 0x0e01, 0x4afe, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/3/2/0x1 = #876 */
    { 0x0f7f, 0x4afe, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/3/3/m = #877 */
    { 0x0f00, 0x4afe, 0xf081, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767) }, /* #17/3/3/u = #878 */
    { 0x0f01, 0x4afe, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x704872483065cc4,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/3/3/0x1 = #879 */
    { 0x007f, 0x5242, 0x7a22, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9b,16384) }, /* #18/0/0/m = #880 */
    { 0x0000, 0x5242, 0xf082, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0) }, /* #18/0/0/u = #881 */
    { 0x0022, 0x5242, 0x7a22, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9b,16384) }, /* #18/0/0/0x22 = #882 */
    { 0x0020, 0x5242, 0xf082, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0) }, /* #18/0/0/u0x2 = #883 */
    { 0x0002, 0x5242, 0xfaa2, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9b,16384) }, /* #18/0/0/u0x20 = #884 */
    { 0x017f, 0x5242, 0x7a22, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9b,16384) }, /* #18/0/1/m = #885 */
    { 0x0100, 0x5242, 0xf082, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0) }, /* #18/0/1/u = #886 */
    { 0x0122, 0x5242, 0x7a22, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9b,16384) }, /* #18/0/1/0x22 = #887 */
    { 0x0120, 0x5242, 0xf082, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0) }, /* #18/0/1/u0x2 = #888 */
    { 0x0102, 0x5242, 0xfaa2, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9b,16384) }, /* #18/0/1/u0x20 = #889 */
    { 0x027f, 0x5242, 0x7a22, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9b,16384) }, /* #18/0/2/m = #890 */
    { 0x0200, 0x5242, 0xf082, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0) }, /* #18/0/2/u = #891 */
    { 0x0222, 0x5242, 0x7a22, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9b,16384) }, /* #18/0/2/0x22 = #892 */
    { 0x0220, 0x5242, 0xf082, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0) }, /* #18/0/2/u0x2 = #893 */
    { 0x0202, 0x5242, 0xfaa2, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9b,16384) }, /* #18/0/2/u0x20 = #894 */
    { 0x037f, 0x5242, 0x7a22, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9b,16384) }, /* #18/0/3/m = #895 */
    { 0x0300, 0x5242, 0xf082, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0) }, /* #18/0/3/u = #896 */
    { 0x0322, 0x5242, 0x7a22, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9b,16384) }, /* #18/0/3/0x22 = #897 */
    { 0x0320, 0x5242, 0xf082, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0) }, /* #18/0/3/u0x2 = #898 */
    { 0x0302, 0x5242, 0xfaa2, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9b,16384) }, /* #18/0/3/u0x20 = #899 */
    { 0x047f, 0x5242, 0x7a22, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9b,16384) }, /* #18/1/0/m = #900 */
    { 0x0400, 0x5242, 0xf082, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0) }, /* #18/1/0/u = #901 */
    { 0x0422, 0x5242, 0x7a22, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9b,16384) }, /* #18/1/0/0x22 = #902 */
    { 0x0420, 0x5242, 0xf082, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0) }, /* #18/1/0/u0x2 = #903 */
    { 0x0402, 0x5242, 0xfaa2, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9b,16384) }, /* #18/1/0/u0x20 = #904 */
    { 0x057f, 0x5242, 0x7a22, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9b,16384) }, /* #18/1/1/m = #905 */
    { 0x0500, 0x5242, 0xf082, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0) }, /* #18/1/1/u = #906 */
    { 0x0522, 0x5242, 0x7a22, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9b,16384) }, /* #18/1/1/0x22 = #907 */
    { 0x0520, 0x5242, 0xf082, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0) }, /* #18/1/1/u0x2 = #908 */
    { 0x0502, 0x5242, 0xfaa2, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9b,16384) }, /* #18/1/1/u0x20 = #909 */
    { 0x067f, 0x5242, 0x7a22, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9b,16384) }, /* #18/1/2/m = #910 */
    { 0x0600, 0x5242, 0xf082, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0) }, /* #18/1/2/u = #911 */
    { 0x0622, 0x5242, 0x7a22, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9b,16384) }, /* #18/1/2/0x22 = #912 */
    { 0x0620, 0x5242, 0xf082, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0) }, /* #18/1/2/u0x2 = #913 */
    { 0x0602, 0x5242, 0xfaa2, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9b,16384) }, /* #18/1/2/u0x20 = #914 */
    { 0x077f, 0x5242, 0x7a22, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9b,16384) }, /* #18/1/3/m = #915 */
    { 0x0700, 0x5242, 0xf082, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0) }, /* #18/1/3/u = #916 */
    { 0x0722, 0x5242, 0x7a22, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9b,16384) }, /* #18/1/3/0x22 = #917 */
    { 0x0720, 0x5242, 0xf082, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0) }, /* #18/1/3/u0x2 = #918 */
    { 0x0702, 0x5242, 0xfaa2, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9b,16384) }, /* #18/1/3/u0x20 = #919 */
    { 0x087f, 0x5242, 0x7822, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9a,16384) }, /* #18/2/0/m = #920 */
    { 0x0800, 0x5242, 0xf082, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0) }, /* #18/2/0/u = #921 */
    { 0x0822, 0x5242, 0x7822, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9a,16384) }, /* #18/2/0/0x22 = #922 */
    { 0x0820, 0x5242, 0xf082, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0) }, /* #18/2/0/u0x2 = #923 */
    { 0x0802, 0x5242, 0xf8a2, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9a,16384) }, /* #18/2/0/u0x20 = #924 */
    { 0x097f, 0x5242, 0x7822, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9a,16384) }, /* #18/2/1/m = #925 */
    { 0x0900, 0x5242, 0xf082, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0) }, /* #18/2/1/u = #926 */
    { 0x0922, 0x5242, 0x7822, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9a,16384) }, /* #18/2/1/0x22 = #927 */
    { 0x0920, 0x5242, 0xf082, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0) }, /* #18/2/1/u0x2 = #928 */
    { 0x0902, 0x5242, 0xf8a2, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9a,16384) }, /* #18/2/1/u0x20 = #929 */
    { 0x0a7f, 0x5242, 0x7822, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9a,16384) }, /* #18/2/2/m = #930 */
    { 0x0a00, 0x5242, 0xf082, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0) }, /* #18/2/2/u = #931 */
    { 0x0a22, 0x5242, 0x7822, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9a,16384) }, /* #18/2/2/0x22 = #932 */
    { 0x0a20, 0x5242, 0xf082, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0) }, /* #18/2/2/u0x2 = #933 */
    { 0x0a02, 0x5242, 0xf8a2, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9a,16384) }, /* #18/2/2/u0x20 = #934 */
    { 0x0b7f, 0x5242, 0x7822, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9a,16384) }, /* #18/2/3/m = #935 */
    { 0x0b00, 0x5242, 0xf082, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0) }, /* #18/2/3/u = #936 */
    { 0x0b22, 0x5242, 0x7822, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9a,16384) }, /* #18/2/3/0x22 = #937 */
    { 0x0b20, 0x5242, 0xf082, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0) }, /* #18/2/3/u0x2 = #938 */
    { 0x0b02, 0x5242, 0xf8a2, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9a,16384) }, /* #18/2/3/u0x20 = #939 */
    { 0x0c7f, 0x5242, 0x7822, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9a,16384) }, /* #18/3/0/m = #940 */
    { 0x0c00, 0x5242, 0xf082, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0) }, /* #18/3/0/u = #941 */
    { 0x0c22, 0x5242, 0x7822, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9a,16384) }, /* #18/3/0/0x22 = #942 */
    { 0x0c20, 0x5242, 0xf082, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0) }, /* #18/3/0/u0x2 = #943 */
    { 0x0c02, 0x5242, 0xf8a2, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9a,16384) }, /* #18/3/0/u0x20 = #944 */
    { 0x0d7f, 0x5242, 0x7822, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9a,16384) }, /* #18/3/1/m = #945 */
    { 0x0d00, 0x5242, 0xf082, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0) }, /* #18/3/1/u = #946 */
    { 0x0d22, 0x5242, 0x7822, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9a,16384) }, /* #18/3/1/0x22 = #947 */
    { 0x0d20, 0x5242, 0xf082, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0) }, /* #18/3/1/u0x2 = #948 */
    { 0x0d02, 0x5242, 0xf8a2, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9a,16384) }, /* #18/3/1/u0x20 = #949 */
    { 0x0e7f, 0x5242, 0x7822, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9a,16384) }, /* #18/3/2/m = #950 */
    { 0x0e00, 0x5242, 0xf082, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0) }, /* #18/3/2/u = #951 */
    { 0x0e22, 0x5242, 0x7822, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9a,16384) }, /* #18/3/2/0x22 = #952 */
    { 0x0e20, 0x5242, 0xf082, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0) }, /* #18/3/2/u0x2 = #953 */
    { 0x0e02, 0x5242, 0xf8a2, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9a,16384) }, /* #18/3/2/u0x20 = #954 */
    { 0x0f7f, 0x5242, 0x7822, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9a,16384) }, /* #18/3/3/m = #955 */
    { 0x0f00, 0x5242, 0xf082, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0) }, /* #18/3/3/u = #956 */
    { 0x0f22, 0x5242, 0x7822, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9a,16384) }, /* #18/3/3/0x22 = #957 */
    { 0x0f20, 0x5242, 0xf082, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0) }, /* #18/3/3/u0x2 = #958 */
    { 0x0f02, 0x5242, 0xf8a2, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc4e7f6bbf676715f,0), RTFLOAT80U_INIT_C(1,0x8e7e297070cc4d9a,16384) }, /* #18/3/3/u0x20 = #959 */
    { 0x007f, 0x42cc, 0x7a22, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #19/0/0/m = #960 */
    { 0x0000, 0x42cc, 0xf082, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0) }, /* #19/0/0/u = #961 */
    { 0x0022, 0x42cc, 0x7a22, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #19/0/0/0x22 = #962 */
    { 0x0020, 0x42cc, 0xf082, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0) }, /* #19/0/0/u0x2 = #963 */
    { 0x0002, 0x42cc, 0xfaa2, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #19/0/0/u0x20 = #964 */
    { 0x017f, 0x42cc, 0x7a22, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #19/0/1/m = #965 */
    { 0x0100, 0x42cc, 0xf082, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0) }, /* #19/0/1/u = #966 */
    { 0x0122, 0x42cc, 0x7a22, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #19/0/1/0x22 = #967 */
    { 0x0120, 0x42cc, 0xf082, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0) }, /* #19/0/1/u0x2 = #968 */
    { 0x0102, 0x42cc, 0xfaa2, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #19/0/1/u0x20 = #969 */
    { 0x027f, 0x42cc, 0x7a22, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #19/0/2/m = #970 */
    { 0x0200, 0x42cc, 0xf082, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0) }, /* #19/0/2/u = #971 */
    { 0x0222, 0x42cc, 0x7a22, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #19/0/2/0x22 = #972 */
    { 0x0220, 0x42cc, 0xf082, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0) }, /* #19/0/2/u0x2 = #973 */
    { 0x0202, 0x42cc, 0xfaa2, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #19/0/2/u0x20 = #974 */
    { 0x037f, 0x42cc, 0x7a22, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #19/0/3/m = #975 */
    { 0x0300, 0x42cc, 0xf082, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0) }, /* #19/0/3/u = #976 */
    { 0x0322, 0x42cc, 0x7a22, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #19/0/3/0x22 = #977 */
    { 0x0320, 0x42cc, 0xf082, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0) }, /* #19/0/3/u0x2 = #978 */
    { 0x0302, 0x42cc, 0xfaa2, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #19/0/3/u0x20 = #979 */
    { 0x047f, 0x42cc, 0x7822, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #19/1/0/m = #980 */
    { 0x0400, 0x42cc, 0xf082, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0) }, /* #19/1/0/u = #981 */
    { 0x0422, 0x42cc, 0x7822, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #19/1/0/0x22 = #982 */
    { 0x0420, 0x42cc, 0xf082, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0) }, /* #19/1/0/u0x2 = #983 */
    { 0x0402, 0x42cc, 0xf8a2, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #19/1/0/u0x20 = #984 */
    { 0x057f, 0x42cc, 0x7822, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #19/1/1/m = #985 */
    { 0x0500, 0x42cc, 0xf082, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0) }, /* #19/1/1/u = #986 */
    { 0x0522, 0x42cc, 0x7822, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #19/1/1/0x22 = #987 */
    { 0x0520, 0x42cc, 0xf082, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0) }, /* #19/1/1/u0x2 = #988 */
    { 0x0502, 0x42cc, 0xf8a2, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #19/1/1/u0x20 = #989 */
    { 0x067f, 0x42cc, 0x7822, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #19/1/2/m = #990 */
    { 0x0600, 0x42cc, 0xf082, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0) }, /* #19/1/2/u = #991 */
    { 0x0622, 0x42cc, 0x7822, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #19/1/2/0x22 = #992 */
    { 0x0620, 0x42cc, 0xf082, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0) }, /* #19/1/2/u0x2 = #993 */
    { 0x0602, 0x42cc, 0xf8a2, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #19/1/2/u0x20 = #994 */
    { 0x077f, 0x42cc, 0x7822, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #19/1/3/m = #995 */
    { 0x0700, 0x42cc, 0xf082, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0) }, /* #19/1/3/u = #996 */
    { 0x0722, 0x42cc, 0x7822, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #19/1/3/0x22 = #997 */
    { 0x0720, 0x42cc, 0xf082, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0) }, /* #19/1/3/u0x2 = #998 */
    { 0x0702, 0x42cc, 0xf8a2, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #19/1/3/u0x20 = #999 */
    { 0x087f, 0x42cc, 0x7a22, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #19/2/0/m = #1000 */
    { 0x0800, 0x42cc, 0xf082, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0) }, /* #19/2/0/u = #1001 */
    { 0x0822, 0x42cc, 0x7a22, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #19/2/0/0x22 = #1002 */
    { 0x0820, 0x42cc, 0xf082, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0) }, /* #19/2/0/u0x2 = #1003 */
    { 0x0802, 0x42cc, 0xfaa2, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #19/2/0/u0x20 = #1004 */
    { 0x097f, 0x42cc, 0x7a22, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #19/2/1/m = #1005 */
    { 0x0900, 0x42cc, 0xf082, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0) }, /* #19/2/1/u = #1006 */
    { 0x0922, 0x42cc, 0x7a22, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #19/2/1/0x22 = #1007 */
    { 0x0920, 0x42cc, 0xf082, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0) }, /* #19/2/1/u0x2 = #1008 */
    { 0x0902, 0x42cc, 0xfaa2, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #19/2/1/u0x20 = #1009 */
    { 0x0a7f, 0x42cc, 0x7a22, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #19/2/2/m = #1010 */
    { 0x0a00, 0x42cc, 0xf082, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0) }, /* #19/2/2/u = #1011 */
    { 0x0a22, 0x42cc, 0x7a22, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #19/2/2/0x22 = #1012 */
    { 0x0a20, 0x42cc, 0xf082, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0) }, /* #19/2/2/u0x2 = #1013 */
    { 0x0a02, 0x42cc, 0xfaa2, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #19/2/2/u0x20 = #1014 */
    { 0x0b7f, 0x42cc, 0x7a22, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #19/2/3/m = #1015 */
    { 0x0b00, 0x42cc, 0xf082, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0) }, /* #19/2/3/u = #1016 */
    { 0x0b22, 0x42cc, 0x7a22, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #19/2/3/0x22 = #1017 */
    { 0x0b20, 0x42cc, 0xf082, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0) }, /* #19/2/3/u0x2 = #1018 */
    { 0x0b02, 0x42cc, 0xfaa2, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #19/2/3/u0x20 = #1019 */
    { 0x0c7f, 0x42cc, 0x7822, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #19/3/0/m = #1020 */
    { 0x0c00, 0x42cc, 0xf082, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0) }, /* #19/3/0/u = #1021 */
    { 0x0c22, 0x42cc, 0x7822, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #19/3/0/0x22 = #1022 */
    { 0x0c20, 0x42cc, 0xf082, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0) }, /* #19/3/0/u0x2 = #1023 */
    { 0x0c02, 0x42cc, 0xf8a2, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #19/3/0/u0x20 = #1024 */
    { 0x0d7f, 0x42cc, 0x7822, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #19/3/1/m = #1025 */
    { 0x0d00, 0x42cc, 0xf082, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0) }, /* #19/3/1/u = #1026 */
    { 0x0d22, 0x42cc, 0x7822, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #19/3/1/0x22 = #1027 */
    { 0x0d20, 0x42cc, 0xf082, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0) }, /* #19/3/1/u0x2 = #1028 */
    { 0x0d02, 0x42cc, 0xf8a2, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #19/3/1/u0x20 = #1029 */
    { 0x0e7f, 0x42cc, 0x7822, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #19/3/2/m = #1030 */
    { 0x0e00, 0x42cc, 0xf082, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0) }, /* #19/3/2/u = #1031 */
    { 0x0e22, 0x42cc, 0x7822, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #19/3/2/0x22 = #1032 */
    { 0x0e20, 0x42cc, 0xf082, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0) }, /* #19/3/2/u0x2 = #1033 */
    { 0x0e02, 0x42cc, 0xf8a2, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #19/3/2/u0x20 = #1034 */
    { 0x0f7f, 0x42cc, 0x7822, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #19/3/3/m = #1035 */
    { 0x0f00, 0x42cc, 0xf082, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0) }, /* #19/3/3/u = #1036 */
    { 0x0f22, 0x42cc, 0x7822, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #19/3/3/0x22 = #1037 */
    { 0x0f20, 0x42cc, 0xf082, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0) }, /* #19/3/3/u0x2 = #1038 */
    { 0x0f02, 0x42cc, 0xf8a2, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x56043462dcb8953,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #19/3/3/u0x20 = #1039 */
    { 0x007f, 0xee3d, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/0/0/m = #1040 */
    { 0x0000, 0xee3d, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/0/0/u = #1041 */
    { 0x017f, 0xee3d, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/0/1/m = #1042 */
    { 0x0100, 0xee3d, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/0/1/u = #1043 */
    { 0x027f, 0xee3d, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/0/2/m = #1044 */
    { 0x0200, 0xee3d, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/0/2/u = #1045 */
    { 0x037f, 0xee3d, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/0/3/m = #1046 */
    { 0x0300, 0xee3d, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/0/3/u = #1047 */
    { 0x047f, 0xee3d, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/1/0/m = #1048 */
    { 0x0400, 0xee3d, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/1/0/u = #1049 */
    { 0x057f, 0xee3d, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/1/1/m = #1050 */
    { 0x0500, 0xee3d, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/1/1/u = #1051 */
    { 0x067f, 0xee3d, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/1/2/m = #1052 */
    { 0x0600, 0xee3d, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/1/2/u = #1053 */
    { 0x077f, 0xee3d, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/1/3/m = #1054 */
    { 0x0700, 0xee3d, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/1/3/u = #1055 */
    { 0x087f, 0xee3d, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/2/0/m = #1056 */
    { 0x0800, 0xee3d, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/2/0/u = #1057 */
    { 0x097f, 0xee3d, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/2/1/m = #1058 */
    { 0x0900, 0xee3d, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/2/1/u = #1059 */
    { 0x0a7f, 0xee3d, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/2/2/m = #1060 */
    { 0x0a00, 0xee3d, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/2/2/u = #1061 */
    { 0x0b7f, 0xee3d, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/2/3/m = #1062 */
    { 0x0b00, 0xee3d, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/2/3/u = #1063 */
    { 0x0c7f, 0xee3d, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/3/0/m = #1064 */
    { 0x0c00, 0xee3d, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/3/0/u = #1065 */
    { 0x0d7f, 0xee3d, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/3/1/m = #1066 */
    { 0x0d00, 0xee3d, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/3/1/u = #1067 */
    { 0x0e7f, 0xee3d, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/3/2/m = #1068 */
    { 0x0e00, 0xee3d, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/3/2/u = #1069 */
    { 0x0f7f, 0xee3d, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/3/3/m = #1070 */
    { 0x0f00, 0xee3d, 0x7c00, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/3/3/u = #1071 */
    { 0x007f, 0x911c, 0x3900, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,10194), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #21/0/0/m = #1072 */
    { 0x0000, 0x911c, 0x3900, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,10194), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #21/0/0/u = #1073 */
    { 0x017f, 0x911c, 0x3900, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,10194), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #21/0/1/m = #1074 */
    { 0x0100, 0x911c, 0x3900, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,10194), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #21/0/1/u = #1075 */
    { 0x027f, 0x911c, 0x3900, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,10194), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #21/0/2/m = #1076 */
    { 0x0200, 0x911c, 0x3900, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,10194), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #21/0/2/u = #1077 */
    { 0x037f, 0x911c, 0x3900, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,10194), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #21/0/3/m = #1078 */
    { 0x0300, 0x911c, 0x3900, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,10194), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #21/0/3/u = #1079 */
    { 0x047f, 0x911c, 0x3900, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,10194), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #21/1/0/m = #1080 */
    { 0x0400, 0x911c, 0x3900, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,10194), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #21/1/0/u = #1081 */
    { 0x057f, 0x911c, 0x3900, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,10194), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #21/1/1/m = #1082 */
    { 0x0500, 0x911c, 0x3900, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,10194), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #21/1/1/u = #1083 */
    { 0x067f, 0x911c, 0x3900, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,10194), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #21/1/2/m = #1084 */
    { 0x0600, 0x911c, 0x3900, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,10194), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #21/1/2/u = #1085 */
    { 0x077f, 0x911c, 0x3900, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,10194), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #21/1/3/m = #1086 */
    { 0x0700, 0x911c, 0x3900, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,10194), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #21/1/3/u = #1087 */
    { 0x087f, 0x911c, 0x3900, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,10194), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #21/2/0/m = #1088 */
    { 0x0800, 0x911c, 0x3900, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,10194), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #21/2/0/u = #1089 */
    { 0x097f, 0x911c, 0x3900, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,10194), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #21/2/1/m = #1090 */
    { 0x0900, 0x911c, 0x3900, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,10194), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #21/2/1/u = #1091 */
    { 0x0a7f, 0x911c, 0x3900, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,10194), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #21/2/2/m = #1092 */
    { 0x0a00, 0x911c, 0x3900, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,10194), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #21/2/2/u = #1093 */
    { 0x0b7f, 0x911c, 0x3900, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,10194), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #21/2/3/m = #1094 */
    { 0x0b00, 0x911c, 0x3900, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,10194), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #21/2/3/u = #1095 */
    { 0x0c7f, 0x911c, 0x3900, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,10194), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #21/3/0/m = #1096 */
    { 0x0c00, 0x911c, 0x3900, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,10194), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #21/3/0/u = #1097 */
    { 0x0d7f, 0x911c, 0x3900, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,10194), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #21/3/1/m = #1098 */
    { 0x0d00, 0x911c, 0x3900, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,10194), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #21/3/1/u = #1099 */
    { 0x0e7f, 0x911c, 0x3900, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,10194), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #21/3/2/m = #1100 */
    { 0x0e00, 0x911c, 0x3900, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,10194), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #21/3/2/u = #1101 */
    { 0x0f7f, 0x911c, 0x3900, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,10194), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #21/3/3/m = #1102 */
    { 0x0f00, 0x911c, 0x3900, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,10194), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #21/3/3/u = #1103 */
    { 0x007f, 0xe122, 0x7901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/0/0/m = #1104 */
    { 0x0000, 0xe122, 0xf181, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #22/0/0/u = #1105 */
    { 0x0001, 0xe122, 0x7901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/0/0/0x1 = #1106 */
    { 0x017f, 0xe122, 0x7901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/0/1/m = #1107 */
    { 0x0100, 0xe122, 0xf181, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #22/0/1/u = #1108 */
    { 0x0101, 0xe122, 0x7901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/0/1/0x1 = #1109 */
    { 0x027f, 0xe122, 0x7901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/0/2/m = #1110 */
    { 0x0200, 0xe122, 0xf181, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #22/0/2/u = #1111 */
    { 0x0201, 0xe122, 0x7901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/0/2/0x1 = #1112 */
    { 0x037f, 0xe122, 0x7901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/0/3/m = #1113 */
    { 0x0300, 0xe122, 0xf181, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #22/0/3/u = #1114 */
    { 0x0301, 0xe122, 0x7901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/0/3/0x1 = #1115 */
    { 0x047f, 0xe122, 0x7901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/1/0/m = #1116 */
    { 0x0400, 0xe122, 0xf181, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #22/1/0/u = #1117 */
    { 0x0401, 0xe122, 0x7901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/1/0/0x1 = #1118 */
    { 0x057f, 0xe122, 0x7901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/1/1/m = #1119 */
    { 0x0500, 0xe122, 0xf181, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #22/1/1/u = #1120 */
    { 0x0501, 0xe122, 0x7901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/1/1/0x1 = #1121 */
    { 0x067f, 0xe122, 0x7901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/1/2/m = #1122 */
    { 0x0600, 0xe122, 0xf181, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #22/1/2/u = #1123 */
    { 0x0601, 0xe122, 0x7901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/1/2/0x1 = #1124 */
    { 0x077f, 0xe122, 0x7901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/1/3/m = #1125 */
    { 0x0700, 0xe122, 0xf181, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #22/1/3/u = #1126 */
    { 0x0701, 0xe122, 0x7901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/1/3/0x1 = #1127 */
    { 0x087f, 0xe122, 0x7901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/2/0/m = #1128 */
    { 0x0800, 0xe122, 0xf181, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #22/2/0/u = #1129 */
    { 0x0801, 0xe122, 0x7901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/2/0/0x1 = #1130 */
    { 0x097f, 0xe122, 0x7901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/2/1/m = #1131 */
    { 0x0900, 0xe122, 0xf181, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #22/2/1/u = #1132 */
    { 0x0901, 0xe122, 0x7901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/2/1/0x1 = #1133 */
    { 0x0a7f, 0xe122, 0x7901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/2/2/m = #1134 */
    { 0x0a00, 0xe122, 0xf181, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #22/2/2/u = #1135 */
    { 0x0a01, 0xe122, 0x7901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/2/2/0x1 = #1136 */
    { 0x0b7f, 0xe122, 0x7901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/2/3/m = #1137 */
    { 0x0b00, 0xe122, 0xf181, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #22/2/3/u = #1138 */
    { 0x0b01, 0xe122, 0x7901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/2/3/0x1 = #1139 */
    { 0x0c7f, 0xe122, 0x7901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/3/0/m = #1140 */
    { 0x0c00, 0xe122, 0xf181, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #22/3/0/u = #1141 */
    { 0x0c01, 0xe122, 0x7901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/3/0/0x1 = #1142 */
    { 0x0d7f, 0xe122, 0x7901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/3/1/m = #1143 */
    { 0x0d00, 0xe122, 0xf181, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #22/3/1/u = #1144 */
    { 0x0d01, 0xe122, 0x7901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/3/1/0x1 = #1145 */
    { 0x0e7f, 0xe122, 0x7901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/3/2/m = #1146 */
    { 0x0e00, 0xe122, 0xf181, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #22/3/2/u = #1147 */
    { 0x0e01, 0xe122, 0x7901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/3/2/0x1 = #1148 */
    { 0x0f7f, 0xe122, 0x7901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/3/3/m = #1149 */
    { 0x0f00, 0xe122, 0xf181, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #22/3/3/u = #1150 */
    { 0x0f01, 0xe122, 0x7901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/3/3/0x1 = #1151 */
    { 0x007f, 0xf654, 0x7e20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #23/0/0/m = #1152 */
    { 0x0000, 0xf654, 0xfea0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #23/0/0/u = #1153 */
    { 0x0020, 0xf654, 0x7e20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #23/0/0/0x20 = #1154 */
    { 0x017f, 0xf654, 0x7e20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #23/0/1/m = #1155 */
    { 0x0100, 0xf654, 0xfea0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #23/0/1/u = #1156 */
    { 0x0120, 0xf654, 0x7e20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #23/0/1/0x20 = #1157 */
    { 0x027f, 0xf654, 0x7e20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #23/0/2/m = #1158 */
    { 0x0200, 0xf654, 0xfea0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #23/0/2/u = #1159 */
    { 0x0220, 0xf654, 0x7e20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #23/0/2/0x20 = #1160 */
    { 0x037f, 0xf654, 0x7e20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #23/0/3/m = #1161 */
    { 0x0300, 0xf654, 0xfea0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #23/0/3/u = #1162 */
    { 0x0320, 0xf654, 0x7e20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #23/0/3/0x20 = #1163 */
    { 0x047f, 0xf654, 0x7e20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #23/1/0/m = #1164 */
    { 0x0400, 0xf654, 0xfea0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #23/1/0/u = #1165 */
    { 0x0420, 0xf654, 0x7e20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #23/1/0/0x20 = #1166 */
    { 0x057f, 0xf654, 0x7e20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #23/1/1/m = #1167 */
    { 0x0500, 0xf654, 0xfea0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #23/1/1/u = #1168 */
    { 0x0520, 0xf654, 0x7e20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #23/1/1/0x20 = #1169 */
    { 0x067f, 0xf654, 0x7e20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #23/1/2/m = #1170 */
    { 0x0600, 0xf654, 0xfea0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #23/1/2/u = #1171 */
    { 0x0620, 0xf654, 0x7e20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #23/1/2/0x20 = #1172 */
    { 0x077f, 0xf654, 0x7e20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #23/1/3/m = #1173 */
    { 0x0700, 0xf654, 0xfea0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #23/1/3/u = #1174 */
    { 0x0720, 0xf654, 0x7e20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #23/1/3/0x20 = #1175 */
    { 0x087f, 0xf654, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #23/2/0/m = #1176 */
    { 0x0800, 0xf654, 0xfca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #23/2/0/u = #1177 */
    { 0x0820, 0xf654, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #23/2/0/0x20 = #1178 */
    { 0x097f, 0xf654, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #23/2/1/m = #1179 */
    { 0x0900, 0xf654, 0xfca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #23/2/1/u = #1180 */
    { 0x0920, 0xf654, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #23/2/1/0x20 = #1181 */
    { 0x0a7f, 0xf654, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #23/2/2/m = #1182 */
    { 0x0a00, 0xf654, 0xfca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #23/2/2/u = #1183 */
    { 0x0a20, 0xf654, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #23/2/2/0x20 = #1184 */
    { 0x0b7f, 0xf654, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #23/2/3/m = #1185 */
    { 0x0b00, 0xf654, 0xfca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #23/2/3/u = #1186 */
    { 0x0b20, 0xf654, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #23/2/3/0x20 = #1187 */
    { 0x0c7f, 0xf654, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #23/3/0/m = #1188 */
    { 0x0c00, 0xf654, 0xfca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #23/3/0/u = #1189 */
    { 0x0c20, 0xf654, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #23/3/0/0x20 = #1190 */
    { 0x0d7f, 0xf654, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #23/3/1/m = #1191 */
    { 0x0d00, 0xf654, 0xfca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #23/3/1/u = #1192 */
    { 0x0d20, 0xf654, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #23/3/1/0x20 = #1193 */
    { 0x0e7f, 0xf654, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #23/3/2/m = #1194 */
    { 0x0e00, 0xf654, 0xfca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #23/3/2/u = #1195 */
    { 0x0e20, 0xf654, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #23/3/2/0x20 = #1196 */
    { 0x0f7f, 0xf654, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #23/3/3/m = #1197 */
    { 0x0f00, 0xf654, 0xfca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #23/3/3/u = #1198 */
    { 0x0f20, 0xf654, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12527), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #23/3/3/0x20 = #1199 */
    { 0x007f, 0xc829, 0x7801, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_IND(1) }, /* #24/0/0/m = #1200 */
    { 0x0000, 0xc829, 0xf081, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449) }, /* #24/0/0/u = #1201 */
    { 0x0001, 0xc829, 0x7801, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_IND(1) }, /* #24/0/0/0x1 = #1202 */
    { 0x017f, 0xc829, 0x7801, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_IND(1) }, /* #24/0/1/m = #1203 */
    { 0x0100, 0xc829, 0xf081, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449) }, /* #24/0/1/u = #1204 */
    { 0x0101, 0xc829, 0x7801, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_IND(1) }, /* #24/0/1/0x1 = #1205 */
    { 0x027f, 0xc829, 0x7801, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_IND(1) }, /* #24/0/2/m = #1206 */
    { 0x0200, 0xc829, 0xf081, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449) }, /* #24/0/2/u = #1207 */
    { 0x0201, 0xc829, 0x7801, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_IND(1) }, /* #24/0/2/0x1 = #1208 */
    { 0x037f, 0xc829, 0x7801, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_IND(1) }, /* #24/0/3/m = #1209 */
    { 0x0300, 0xc829, 0xf081, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449) }, /* #24/0/3/u = #1210 */
    { 0x0301, 0xc829, 0x7801, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_IND(1) }, /* #24/0/3/0x1 = #1211 */
    { 0x047f, 0xc829, 0x7801, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_IND(1) }, /* #24/1/0/m = #1212 */
    { 0x0400, 0xc829, 0xf081, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449) }, /* #24/1/0/u = #1213 */
    { 0x0401, 0xc829, 0x7801, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_IND(1) }, /* #24/1/0/0x1 = #1214 */
    { 0x057f, 0xc829, 0x7801, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_IND(1) }, /* #24/1/1/m = #1215 */
    { 0x0500, 0xc829, 0xf081, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449) }, /* #24/1/1/u = #1216 */
    { 0x0501, 0xc829, 0x7801, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_IND(1) }, /* #24/1/1/0x1 = #1217 */
    { 0x067f, 0xc829, 0x7801, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_IND(1) }, /* #24/1/2/m = #1218 */
    { 0x0600, 0xc829, 0xf081, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449) }, /* #24/1/2/u = #1219 */
    { 0x0601, 0xc829, 0x7801, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_IND(1) }, /* #24/1/2/0x1 = #1220 */
    { 0x077f, 0xc829, 0x7801, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_IND(1) }, /* #24/1/3/m = #1221 */
    { 0x0700, 0xc829, 0xf081, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449) }, /* #24/1/3/u = #1222 */
    { 0x0701, 0xc829, 0x7801, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_IND(1) }, /* #24/1/3/0x1 = #1223 */
    { 0x087f, 0xc829, 0x7801, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_IND(1) }, /* #24/2/0/m = #1224 */
    { 0x0800, 0xc829, 0xf081, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449) }, /* #24/2/0/u = #1225 */
    { 0x0801, 0xc829, 0x7801, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_IND(1) }, /* #24/2/0/0x1 = #1226 */
    { 0x097f, 0xc829, 0x7801, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_IND(1) }, /* #24/2/1/m = #1227 */
    { 0x0900, 0xc829, 0xf081, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449) }, /* #24/2/1/u = #1228 */
    { 0x0901, 0xc829, 0x7801, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_IND(1) }, /* #24/2/1/0x1 = #1229 */
    { 0x0a7f, 0xc829, 0x7801, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_IND(1) }, /* #24/2/2/m = #1230 */
    { 0x0a00, 0xc829, 0xf081, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449) }, /* #24/2/2/u = #1231 */
    { 0x0a01, 0xc829, 0x7801, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_IND(1) }, /* #24/2/2/0x1 = #1232 */
    { 0x0b7f, 0xc829, 0x7801, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_IND(1) }, /* #24/2/3/m = #1233 */
    { 0x0b00, 0xc829, 0xf081, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449) }, /* #24/2/3/u = #1234 */
    { 0x0b01, 0xc829, 0x7801, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_IND(1) }, /* #24/2/3/0x1 = #1235 */
    { 0x0c7f, 0xc829, 0x7801, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_IND(1) }, /* #24/3/0/m = #1236 */
    { 0x0c00, 0xc829, 0xf081, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449) }, /* #24/3/0/u = #1237 */
    { 0x0c01, 0xc829, 0x7801, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_IND(1) }, /* #24/3/0/0x1 = #1238 */
    { 0x0d7f, 0xc829, 0x7801, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_IND(1) }, /* #24/3/1/m = #1239 */
    { 0x0d00, 0xc829, 0xf081, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449) }, /* #24/3/1/u = #1240 */
    { 0x0d01, 0xc829, 0x7801, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_IND(1) }, /* #24/3/1/0x1 = #1241 */
    { 0x0e7f, 0xc829, 0x7801, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_IND(1) }, /* #24/3/2/m = #1242 */
    { 0x0e00, 0xc829, 0xf081, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449) }, /* #24/3/2/u = #1243 */
    { 0x0e01, 0xc829, 0x7801, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_IND(1) }, /* #24/3/2/0x1 = #1244 */
    { 0x0f7f, 0xc829, 0x7801, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_IND(1) }, /* #24/3/3/m = #1245 */
    { 0x0f00, 0xc829, 0xf081, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449) }, /* #24/3/3/u = #1246 */
    { 0x0f01, 0xc829, 0x7801, RTFLOAT80U_INIT_C(0,0x5166d26e4830553c,28753), RTFLOAT80U_INIT_C(1,0x8993b50633a90c5a,9449), RTFLOAT80U_INIT_IND(1) }, /* #24/3/3/0x1 = #1247 */
    { 0x007f, 0x128d, 0x3801, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #25/0/0/m = #1248 */
    { 0x0000, 0x128d, 0xb081, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #25/0/0/u = #1249 */
    { 0x0001, 0x128d, 0x3801, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #25/0/0/0x1 = #1250 */
    { 0x017f, 0x128d, 0x3801, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #25/0/1/m = #1251 */
    { 0x0100, 0x128d, 0xb081, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #25/0/1/u = #1252 */
    { 0x0101, 0x128d, 0x3801, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #25/0/1/0x1 = #1253 */
    { 0x027f, 0x128d, 0x3801, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #25/0/2/m = #1254 */
    { 0x0200, 0x128d, 0xb081, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #25/0/2/u = #1255 */
    { 0x0201, 0x128d, 0x3801, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #25/0/2/0x1 = #1256 */
    { 0x037f, 0x128d, 0x3801, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #25/0/3/m = #1257 */
    { 0x0300, 0x128d, 0xb081, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #25/0/3/u = #1258 */
    { 0x0301, 0x128d, 0x3801, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #25/0/3/0x1 = #1259 */
    { 0x047f, 0x128d, 0x3801, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #25/1/0/m = #1260 */
    { 0x0400, 0x128d, 0xb081, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #25/1/0/u = #1261 */
    { 0x0401, 0x128d, 0x3801, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #25/1/0/0x1 = #1262 */
    { 0x057f, 0x128d, 0x3801, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #25/1/1/m = #1263 */
    { 0x0500, 0x128d, 0xb081, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #25/1/1/u = #1264 */
    { 0x0501, 0x128d, 0x3801, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #25/1/1/0x1 = #1265 */
    { 0x067f, 0x128d, 0x3801, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #25/1/2/m = #1266 */
    { 0x0600, 0x128d, 0xb081, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #25/1/2/u = #1267 */
    { 0x0601, 0x128d, 0x3801, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #25/1/2/0x1 = #1268 */
    { 0x077f, 0x128d, 0x3801, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #25/1/3/m = #1269 */
    { 0x0700, 0x128d, 0xb081, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #25/1/3/u = #1270 */
    { 0x0701, 0x128d, 0x3801, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #25/1/3/0x1 = #1271 */
    { 0x087f, 0x128d, 0x3801, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #25/2/0/m = #1272 */
    { 0x0800, 0x128d, 0xb081, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #25/2/0/u = #1273 */
    { 0x0801, 0x128d, 0x3801, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #25/2/0/0x1 = #1274 */
    { 0x097f, 0x128d, 0x3801, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #25/2/1/m = #1275 */
    { 0x0900, 0x128d, 0xb081, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #25/2/1/u = #1276 */
    { 0x0901, 0x128d, 0x3801, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #25/2/1/0x1 = #1277 */
    { 0x0a7f, 0x128d, 0x3801, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #25/2/2/m = #1278 */
    { 0x0a00, 0x128d, 0xb081, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #25/2/2/u = #1279 */
    { 0x0a01, 0x128d, 0x3801, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #25/2/2/0x1 = #1280 */
    { 0x0b7f, 0x128d, 0x3801, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #25/2/3/m = #1281 */
    { 0x0b00, 0x128d, 0xb081, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #25/2/3/u = #1282 */
    { 0x0b01, 0x128d, 0x3801, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #25/2/3/0x1 = #1283 */
    { 0x0c7f, 0x128d, 0x3801, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #25/3/0/m = #1284 */
    { 0x0c00, 0x128d, 0xb081, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #25/3/0/u = #1285 */
    { 0x0c01, 0x128d, 0x3801, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #25/3/0/0x1 = #1286 */
    { 0x0d7f, 0x128d, 0x3801, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #25/3/1/m = #1287 */
    { 0x0d00, 0x128d, 0xb081, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #25/3/1/u = #1288 */
    { 0x0d01, 0x128d, 0x3801, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #25/3/1/0x1 = #1289 */
    { 0x0e7f, 0x128d, 0x3801, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #25/3/2/m = #1290 */
    { 0x0e00, 0x128d, 0xb081, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #25/3/2/u = #1291 */
    { 0x0e01, 0x128d, 0x3801, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #25/3/2/0x1 = #1292 */
    { 0x0f7f, 0x128d, 0x3801, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #25/3/3/m = #1293 */
    { 0x0f00, 0x128d, 0xb081, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #25/3/3/u = #1294 */
    { 0x0f01, 0x128d, 0x3801, RTFLOAT80U_INIT_C(0,0x1a5d07eea091435c,14588), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #25/3/3/0x1 = #1295 */
    { 0x007f, 0x9bbe, 0x3901, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_IND(1) }, /* #26/0/0/m = #1296 */
    { 0x0000, 0x9bbe, 0xb181, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993) }, /* #26/0/0/u = #1297 */
    { 0x0001, 0x9bbe, 0x3901, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_IND(1) }, /* #26/0/0/0x1 = #1298 */
    { 0x017f, 0x9bbe, 0x3901, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_IND(1) }, /* #26/0/1/m = #1299 */
    { 0x0100, 0x9bbe, 0xb181, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993) }, /* #26/0/1/u = #1300 */
    { 0x0101, 0x9bbe, 0x3901, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_IND(1) }, /* #26/0/1/0x1 = #1301 */
    { 0x027f, 0x9bbe, 0x3901, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_IND(1) }, /* #26/0/2/m = #1302 */
    { 0x0200, 0x9bbe, 0xb181, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993) }, /* #26/0/2/u = #1303 */
    { 0x0201, 0x9bbe, 0x3901, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_IND(1) }, /* #26/0/2/0x1 = #1304 */
    { 0x037f, 0x9bbe, 0x3901, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_IND(1) }, /* #26/0/3/m = #1305 */
    { 0x0300, 0x9bbe, 0xb181, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993) }, /* #26/0/3/u = #1306 */
    { 0x0301, 0x9bbe, 0x3901, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_IND(1) }, /* #26/0/3/0x1 = #1307 */
    { 0x047f, 0x9bbe, 0x3901, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_IND(1) }, /* #26/1/0/m = #1308 */
    { 0x0400, 0x9bbe, 0xb181, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993) }, /* #26/1/0/u = #1309 */
    { 0x0401, 0x9bbe, 0x3901, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_IND(1) }, /* #26/1/0/0x1 = #1310 */
    { 0x057f, 0x9bbe, 0x3901, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_IND(1) }, /* #26/1/1/m = #1311 */
    { 0x0500, 0x9bbe, 0xb181, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993) }, /* #26/1/1/u = #1312 */
    { 0x0501, 0x9bbe, 0x3901, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_IND(1) }, /* #26/1/1/0x1 = #1313 */
    { 0x067f, 0x9bbe, 0x3901, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_IND(1) }, /* #26/1/2/m = #1314 */
    { 0x0600, 0x9bbe, 0xb181, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993) }, /* #26/1/2/u = #1315 */
    { 0x0601, 0x9bbe, 0x3901, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_IND(1) }, /* #26/1/2/0x1 = #1316 */
    { 0x077f, 0x9bbe, 0x3901, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_IND(1) }, /* #26/1/3/m = #1317 */
    { 0x0700, 0x9bbe, 0xb181, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993) }, /* #26/1/3/u = #1318 */
    { 0x0701, 0x9bbe, 0x3901, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_IND(1) }, /* #26/1/3/0x1 = #1319 */
    { 0x087f, 0x9bbe, 0x3901, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_IND(1) }, /* #26/2/0/m = #1320 */
    { 0x0800, 0x9bbe, 0xb181, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993) }, /* #26/2/0/u = #1321 */
    { 0x0801, 0x9bbe, 0x3901, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_IND(1) }, /* #26/2/0/0x1 = #1322 */
    { 0x097f, 0x9bbe, 0x3901, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_IND(1) }, /* #26/2/1/m = #1323 */
    { 0x0900, 0x9bbe, 0xb181, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993) }, /* #26/2/1/u = #1324 */
    { 0x0901, 0x9bbe, 0x3901, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_IND(1) }, /* #26/2/1/0x1 = #1325 */
    { 0x0a7f, 0x9bbe, 0x3901, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_IND(1) }, /* #26/2/2/m = #1326 */
    { 0x0a00, 0x9bbe, 0xb181, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993) }, /* #26/2/2/u = #1327 */
    { 0x0a01, 0x9bbe, 0x3901, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_IND(1) }, /* #26/2/2/0x1 = #1328 */
    { 0x0b7f, 0x9bbe, 0x3901, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_IND(1) }, /* #26/2/3/m = #1329 */
    { 0x0b00, 0x9bbe, 0xb181, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993) }, /* #26/2/3/u = #1330 */
    { 0x0b01, 0x9bbe, 0x3901, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_IND(1) }, /* #26/2/3/0x1 = #1331 */
    { 0x0c7f, 0x9bbe, 0x3901, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_IND(1) }, /* #26/3/0/m = #1332 */
    { 0x0c00, 0x9bbe, 0xb181, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993) }, /* #26/3/0/u = #1333 */
    { 0x0c01, 0x9bbe, 0x3901, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_IND(1) }, /* #26/3/0/0x1 = #1334 */
    { 0x0d7f, 0x9bbe, 0x3901, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_IND(1) }, /* #26/3/1/m = #1335 */
    { 0x0d00, 0x9bbe, 0xb181, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993) }, /* #26/3/1/u = #1336 */
    { 0x0d01, 0x9bbe, 0x3901, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_IND(1) }, /* #26/3/1/0x1 = #1337 */
    { 0x0e7f, 0x9bbe, 0x3901, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_IND(1) }, /* #26/3/2/m = #1338 */
    { 0x0e00, 0x9bbe, 0xb181, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993) }, /* #26/3/2/u = #1339 */
    { 0x0e01, 0x9bbe, 0x3901, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_IND(1) }, /* #26/3/2/0x1 = #1340 */
    { 0x0f7f, 0x9bbe, 0x3901, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_IND(1) }, /* #26/3/3/m = #1341 */
    { 0x0f00, 0x9bbe, 0xb181, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993) }, /* #26/3/3/u = #1342 */
    { 0x0f01, 0x9bbe, 0x3901, RTFLOAT80U_INIT_C(0,0x56ac1f2420005ecd,23143), RTFLOAT80U_INIT_C(0,0x194c4eeb9f95113b,20993), RTFLOAT80U_INIT_IND(1) }, /* #26/3/3/0x1 = #1343 */
    { 0x007f, 0xe1ec, 0x7901, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/0/0/m = #1344 */
    { 0x0000, 0xe1ec, 0xf181, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767) }, /* #27/0/0/u = #1345 */
    { 0x0001, 0xe1ec, 0x7901, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/0/0/0x1 = #1346 */
    { 0x017f, 0xe1ec, 0x7901, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/0/1/m = #1347 */
    { 0x0100, 0xe1ec, 0xf181, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767) }, /* #27/0/1/u = #1348 */
    { 0x0101, 0xe1ec, 0x7901, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/0/1/0x1 = #1349 */
    { 0x027f, 0xe1ec, 0x7901, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/0/2/m = #1350 */
    { 0x0200, 0xe1ec, 0xf181, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767) }, /* #27/0/2/u = #1351 */
    { 0x0201, 0xe1ec, 0x7901, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/0/2/0x1 = #1352 */
    { 0x037f, 0xe1ec, 0x7901, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/0/3/m = #1353 */
    { 0x0300, 0xe1ec, 0xf181, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767) }, /* #27/0/3/u = #1354 */
    { 0x0301, 0xe1ec, 0x7901, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/0/3/0x1 = #1355 */
    { 0x047f, 0xe1ec, 0x7901, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/1/0/m = #1356 */
    { 0x0400, 0xe1ec, 0xf181, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767) }, /* #27/1/0/u = #1357 */
    { 0x0401, 0xe1ec, 0x7901, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/1/0/0x1 = #1358 */
    { 0x057f, 0xe1ec, 0x7901, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/1/1/m = #1359 */
    { 0x0500, 0xe1ec, 0xf181, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767) }, /* #27/1/1/u = #1360 */
    { 0x0501, 0xe1ec, 0x7901, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/1/1/0x1 = #1361 */
    { 0x067f, 0xe1ec, 0x7901, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/1/2/m = #1362 */
    { 0x0600, 0xe1ec, 0xf181, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767) }, /* #27/1/2/u = #1363 */
    { 0x0601, 0xe1ec, 0x7901, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/1/2/0x1 = #1364 */
    { 0x077f, 0xe1ec, 0x7901, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/1/3/m = #1365 */
    { 0x0700, 0xe1ec, 0xf181, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767) }, /* #27/1/3/u = #1366 */
    { 0x0701, 0xe1ec, 0x7901, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/1/3/0x1 = #1367 */
    { 0x087f, 0xe1ec, 0x7901, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/2/0/m = #1368 */
    { 0x0800, 0xe1ec, 0xf181, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767) }, /* #27/2/0/u = #1369 */
    { 0x0801, 0xe1ec, 0x7901, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/2/0/0x1 = #1370 */
    { 0x097f, 0xe1ec, 0x7901, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/2/1/m = #1371 */
    { 0x0900, 0xe1ec, 0xf181, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767) }, /* #27/2/1/u = #1372 */
    { 0x0901, 0xe1ec, 0x7901, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/2/1/0x1 = #1373 */
    { 0x0a7f, 0xe1ec, 0x7901, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/2/2/m = #1374 */
    { 0x0a00, 0xe1ec, 0xf181, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767) }, /* #27/2/2/u = #1375 */
    { 0x0a01, 0xe1ec, 0x7901, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/2/2/0x1 = #1376 */
    { 0x0b7f, 0xe1ec, 0x7901, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/2/3/m = #1377 */
    { 0x0b00, 0xe1ec, 0xf181, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767) }, /* #27/2/3/u = #1378 */
    { 0x0b01, 0xe1ec, 0x7901, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/2/3/0x1 = #1379 */
    { 0x0c7f, 0xe1ec, 0x7901, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/3/0/m = #1380 */
    { 0x0c00, 0xe1ec, 0xf181, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767) }, /* #27/3/0/u = #1381 */
    { 0x0c01, 0xe1ec, 0x7901, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/3/0/0x1 = #1382 */
    { 0x0d7f, 0xe1ec, 0x7901, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/3/1/m = #1383 */
    { 0x0d00, 0xe1ec, 0xf181, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767) }, /* #27/3/1/u = #1384 */
    { 0x0d01, 0xe1ec, 0x7901, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/3/1/0x1 = #1385 */
    { 0x0e7f, 0xe1ec, 0x7901, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/3/2/m = #1386 */
    { 0x0e00, 0xe1ec, 0xf181, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767) }, /* #27/3/2/u = #1387 */
    { 0x0e01, 0xe1ec, 0x7901, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/3/2/0x1 = #1388 */
    { 0x0f7f, 0xe1ec, 0x7901, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/3/3/m = #1389 */
    { 0x0f00, 0xe1ec, 0xf181, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767) }, /* #27/3/3/u = #1390 */
    { 0x0f01, 0xe1ec, 0x7901, RTFLOAT80U_INIT_C(1,0x6344597154f49de1,21426), RTFLOAT80U_INIT_C(1,0x95dacd109d43941f,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/3/3/0x1 = #1391 */
    { 0x007f, 0xe658, 0x7c01, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/0/0/m = #1392 */
    { 0x0000, 0xe658, 0xf481, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767) }, /* #28/0/0/u = #1393 */
    { 0x0001, 0xe658, 0x7c01, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/0/0/0x1 = #1394 */
    { 0x017f, 0xe658, 0x7c01, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/0/1/m = #1395 */
    { 0x0100, 0xe658, 0xf481, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767) }, /* #28/0/1/u = #1396 */
    { 0x0101, 0xe658, 0x7c01, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/0/1/0x1 = #1397 */
    { 0x027f, 0xe658, 0x7c01, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/0/2/m = #1398 */
    { 0x0200, 0xe658, 0xf481, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767) }, /* #28/0/2/u = #1399 */
    { 0x0201, 0xe658, 0x7c01, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/0/2/0x1 = #1400 */
    { 0x037f, 0xe658, 0x7c01, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/0/3/m = #1401 */
    { 0x0300, 0xe658, 0xf481, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767) }, /* #28/0/3/u = #1402 */
    { 0x0301, 0xe658, 0x7c01, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/0/3/0x1 = #1403 */
    { 0x047f, 0xe658, 0x7c01, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/1/0/m = #1404 */
    { 0x0400, 0xe658, 0xf481, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767) }, /* #28/1/0/u = #1405 */
    { 0x0401, 0xe658, 0x7c01, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/1/0/0x1 = #1406 */
    { 0x057f, 0xe658, 0x7c01, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/1/1/m = #1407 */
    { 0x0500, 0xe658, 0xf481, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767) }, /* #28/1/1/u = #1408 */
    { 0x0501, 0xe658, 0x7c01, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/1/1/0x1 = #1409 */
    { 0x067f, 0xe658, 0x7c01, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/1/2/m = #1410 */
    { 0x0600, 0xe658, 0xf481, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767) }, /* #28/1/2/u = #1411 */
    { 0x0601, 0xe658, 0x7c01, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/1/2/0x1 = #1412 */
    { 0x077f, 0xe658, 0x7c01, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/1/3/m = #1413 */
    { 0x0700, 0xe658, 0xf481, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767) }, /* #28/1/3/u = #1414 */
    { 0x0701, 0xe658, 0x7c01, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/1/3/0x1 = #1415 */
    { 0x087f, 0xe658, 0x7c01, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/2/0/m = #1416 */
    { 0x0800, 0xe658, 0xf481, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767) }, /* #28/2/0/u = #1417 */
    { 0x0801, 0xe658, 0x7c01, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/2/0/0x1 = #1418 */
    { 0x097f, 0xe658, 0x7c01, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/2/1/m = #1419 */
    { 0x0900, 0xe658, 0xf481, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767) }, /* #28/2/1/u = #1420 */
    { 0x0901, 0xe658, 0x7c01, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/2/1/0x1 = #1421 */
    { 0x0a7f, 0xe658, 0x7c01, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/2/2/m = #1422 */
    { 0x0a00, 0xe658, 0xf481, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767) }, /* #28/2/2/u = #1423 */
    { 0x0a01, 0xe658, 0x7c01, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/2/2/0x1 = #1424 */
    { 0x0b7f, 0xe658, 0x7c01, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/2/3/m = #1425 */
    { 0x0b00, 0xe658, 0xf481, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767) }, /* #28/2/3/u = #1426 */
    { 0x0b01, 0xe658, 0x7c01, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/2/3/0x1 = #1427 */
    { 0x0c7f, 0xe658, 0x7c01, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/3/0/m = #1428 */
    { 0x0c00, 0xe658, 0xf481, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767) }, /* #28/3/0/u = #1429 */
    { 0x0c01, 0xe658, 0x7c01, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/3/0/0x1 = #1430 */
    { 0x0d7f, 0xe658, 0x7c01, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/3/1/m = #1431 */
    { 0x0d00, 0xe658, 0xf481, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767) }, /* #28/3/1/u = #1432 */
    { 0x0d01, 0xe658, 0x7c01, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/3/1/0x1 = #1433 */
    { 0x0e7f, 0xe658, 0x7c01, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/3/2/m = #1434 */
    { 0x0e00, 0xe658, 0xf481, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767) }, /* #28/3/2/u = #1435 */
    { 0x0e01, 0xe658, 0x7c01, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/3/2/0x1 = #1436 */
    { 0x0f7f, 0xe658, 0x7c01, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/3/3/m = #1437 */
    { 0x0f00, 0xe658, 0xf481, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767) }, /* #28/3/3/u = #1438 */
    { 0x0f01, 0xe658, 0x7c01, RTFLOAT80U_INIT_C(1,0x255c89aab5dc5cee,15874), RTFLOAT80U_INIT_C(0,0xdf6a11173b173c7a,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/3/3/0x1 = #1439 */
    { 0x007f, 0x2d6a, 0x3d01, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/0/0/m = #1440 */
    { 0x0000, 0x2d6a, 0xb581, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767) }, /* #29/0/0/u = #1441 */
    { 0x0001, 0x2d6a, 0x3d01, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/0/0/0x1 = #1442 */
    { 0x017f, 0x2d6a, 0x3d01, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/0/1/m = #1443 */
    { 0x0100, 0x2d6a, 0xb581, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767) }, /* #29/0/1/u = #1444 */
    { 0x0101, 0x2d6a, 0x3d01, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/0/1/0x1 = #1445 */
    { 0x027f, 0x2d6a, 0x3d01, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/0/2/m = #1446 */
    { 0x0200, 0x2d6a, 0xb581, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767) }, /* #29/0/2/u = #1447 */
    { 0x0201, 0x2d6a, 0x3d01, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/0/2/0x1 = #1448 */
    { 0x037f, 0x2d6a, 0x3d01, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/0/3/m = #1449 */
    { 0x0300, 0x2d6a, 0xb581, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767) }, /* #29/0/3/u = #1450 */
    { 0x0301, 0x2d6a, 0x3d01, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/0/3/0x1 = #1451 */
    { 0x047f, 0x2d6a, 0x3d01, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/1/0/m = #1452 */
    { 0x0400, 0x2d6a, 0xb581, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767) }, /* #29/1/0/u = #1453 */
    { 0x0401, 0x2d6a, 0x3d01, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/1/0/0x1 = #1454 */
    { 0x057f, 0x2d6a, 0x3d01, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/1/1/m = #1455 */
    { 0x0500, 0x2d6a, 0xb581, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767) }, /* #29/1/1/u = #1456 */
    { 0x0501, 0x2d6a, 0x3d01, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/1/1/0x1 = #1457 */
    { 0x067f, 0x2d6a, 0x3d01, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/1/2/m = #1458 */
    { 0x0600, 0x2d6a, 0xb581, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767) }, /* #29/1/2/u = #1459 */
    { 0x0601, 0x2d6a, 0x3d01, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/1/2/0x1 = #1460 */
    { 0x077f, 0x2d6a, 0x3d01, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/1/3/m = #1461 */
    { 0x0700, 0x2d6a, 0xb581, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767) }, /* #29/1/3/u = #1462 */
    { 0x0701, 0x2d6a, 0x3d01, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/1/3/0x1 = #1463 */
    { 0x087f, 0x2d6a, 0x3d01, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/2/0/m = #1464 */
    { 0x0800, 0x2d6a, 0xb581, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767) }, /* #29/2/0/u = #1465 */
    { 0x0801, 0x2d6a, 0x3d01, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/2/0/0x1 = #1466 */
    { 0x097f, 0x2d6a, 0x3d01, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/2/1/m = #1467 */
    { 0x0900, 0x2d6a, 0xb581, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767) }, /* #29/2/1/u = #1468 */
    { 0x0901, 0x2d6a, 0x3d01, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/2/1/0x1 = #1469 */
    { 0x0a7f, 0x2d6a, 0x3d01, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/2/2/m = #1470 */
    { 0x0a00, 0x2d6a, 0xb581, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767) }, /* #29/2/2/u = #1471 */
    { 0x0a01, 0x2d6a, 0x3d01, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/2/2/0x1 = #1472 */
    { 0x0b7f, 0x2d6a, 0x3d01, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/2/3/m = #1473 */
    { 0x0b00, 0x2d6a, 0xb581, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767) }, /* #29/2/3/u = #1474 */
    { 0x0b01, 0x2d6a, 0x3d01, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/2/3/0x1 = #1475 */
    { 0x0c7f, 0x2d6a, 0x3d01, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/3/0/m = #1476 */
    { 0x0c00, 0x2d6a, 0xb581, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767) }, /* #29/3/0/u = #1477 */
    { 0x0c01, 0x2d6a, 0x3d01, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/3/0/0x1 = #1478 */
    { 0x0d7f, 0x2d6a, 0x3d01, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/3/1/m = #1479 */
    { 0x0d00, 0x2d6a, 0xb581, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767) }, /* #29/3/1/u = #1480 */
    { 0x0d01, 0x2d6a, 0x3d01, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/3/1/0x1 = #1481 */
    { 0x0e7f, 0x2d6a, 0x3d01, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/3/2/m = #1482 */
    { 0x0e00, 0x2d6a, 0xb581, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767) }, /* #29/3/2/u = #1483 */
    { 0x0e01, 0x2d6a, 0x3d01, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/3/2/0x1 = #1484 */
    { 0x0f7f, 0x2d6a, 0x3d01, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/3/3/m = #1485 */
    { 0x0f00, 0x2d6a, 0xb581, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767) }, /* #29/3/3/u = #1486 */
    { 0x0f01, 0x2d6a, 0x3d01, RTFLOAT80U_INIT_C(1,0x4aca468459391f5a,14090), RTFLOAT80U_INIT_C(1,0x5ebb5d65f1dfc6df,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/3/3/0x1 = #1487 */
    { 0x007f, 0xdce5, 0x7c01, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_IND(1) }, /* #30/0/0/m = #1488 */
    { 0x0000, 0xdce5, 0xf481, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0) }, /* #30/0/0/u = #1489 */
    { 0x0001, 0xdce5, 0x7c01, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_IND(1) }, /* #30/0/0/0x1 = #1490 */
    { 0x017f, 0xdce5, 0x7c01, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_IND(1) }, /* #30/0/1/m = #1491 */
    { 0x0100, 0xdce5, 0xf481, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0) }, /* #30/0/1/u = #1492 */
    { 0x0101, 0xdce5, 0x7c01, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_IND(1) }, /* #30/0/1/0x1 = #1493 */
    { 0x027f, 0xdce5, 0x7c01, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_IND(1) }, /* #30/0/2/m = #1494 */
    { 0x0200, 0xdce5, 0xf481, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0) }, /* #30/0/2/u = #1495 */
    { 0x0201, 0xdce5, 0x7c01, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_IND(1) }, /* #30/0/2/0x1 = #1496 */
    { 0x037f, 0xdce5, 0x7c01, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_IND(1) }, /* #30/0/3/m = #1497 */
    { 0x0300, 0xdce5, 0xf481, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0) }, /* #30/0/3/u = #1498 */
    { 0x0301, 0xdce5, 0x7c01, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_IND(1) }, /* #30/0/3/0x1 = #1499 */
    { 0x047f, 0xdce5, 0x7c01, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_IND(1) }, /* #30/1/0/m = #1500 */
    { 0x0400, 0xdce5, 0xf481, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0) }, /* #30/1/0/u = #1501 */
    { 0x0401, 0xdce5, 0x7c01, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_IND(1) }, /* #30/1/0/0x1 = #1502 */
    { 0x057f, 0xdce5, 0x7c01, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_IND(1) }, /* #30/1/1/m = #1503 */
    { 0x0500, 0xdce5, 0xf481, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0) }, /* #30/1/1/u = #1504 */
    { 0x0501, 0xdce5, 0x7c01, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_IND(1) }, /* #30/1/1/0x1 = #1505 */
    { 0x067f, 0xdce5, 0x7c01, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_IND(1) }, /* #30/1/2/m = #1506 */
    { 0x0600, 0xdce5, 0xf481, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0) }, /* #30/1/2/u = #1507 */
    { 0x0601, 0xdce5, 0x7c01, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_IND(1) }, /* #30/1/2/0x1 = #1508 */
    { 0x077f, 0xdce5, 0x7c01, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_IND(1) }, /* #30/1/3/m = #1509 */
    { 0x0700, 0xdce5, 0xf481, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0) }, /* #30/1/3/u = #1510 */
    { 0x0701, 0xdce5, 0x7c01, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_IND(1) }, /* #30/1/3/0x1 = #1511 */
    { 0x087f, 0xdce5, 0x7c01, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_IND(1) }, /* #30/2/0/m = #1512 */
    { 0x0800, 0xdce5, 0xf481, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0) }, /* #30/2/0/u = #1513 */
    { 0x0801, 0xdce5, 0x7c01, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_IND(1) }, /* #30/2/0/0x1 = #1514 */
    { 0x097f, 0xdce5, 0x7c01, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_IND(1) }, /* #30/2/1/m = #1515 */
    { 0x0900, 0xdce5, 0xf481, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0) }, /* #30/2/1/u = #1516 */
    { 0x0901, 0xdce5, 0x7c01, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_IND(1) }, /* #30/2/1/0x1 = #1517 */
    { 0x0a7f, 0xdce5, 0x7c01, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_IND(1) }, /* #30/2/2/m = #1518 */
    { 0x0a00, 0xdce5, 0xf481, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0) }, /* #30/2/2/u = #1519 */
    { 0x0a01, 0xdce5, 0x7c01, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_IND(1) }, /* #30/2/2/0x1 = #1520 */
    { 0x0b7f, 0xdce5, 0x7c01, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_IND(1) }, /* #30/2/3/m = #1521 */
    { 0x0b00, 0xdce5, 0xf481, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0) }, /* #30/2/3/u = #1522 */
    { 0x0b01, 0xdce5, 0x7c01, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_IND(1) }, /* #30/2/3/0x1 = #1523 */
    { 0x0c7f, 0xdce5, 0x7c01, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_IND(1) }, /* #30/3/0/m = #1524 */
    { 0x0c00, 0xdce5, 0xf481, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0) }, /* #30/3/0/u = #1525 */
    { 0x0c01, 0xdce5, 0x7c01, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_IND(1) }, /* #30/3/0/0x1 = #1526 */
    { 0x0d7f, 0xdce5, 0x7c01, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_IND(1) }, /* #30/3/1/m = #1527 */
    { 0x0d00, 0xdce5, 0xf481, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0) }, /* #30/3/1/u = #1528 */
    { 0x0d01, 0xdce5, 0x7c01, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_IND(1) }, /* #30/3/1/0x1 = #1529 */
    { 0x0e7f, 0xdce5, 0x7c01, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_IND(1) }, /* #30/3/2/m = #1530 */
    { 0x0e00, 0xdce5, 0xf481, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0) }, /* #30/3/2/u = #1531 */
    { 0x0e01, 0xdce5, 0x7c01, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_IND(1) }, /* #30/3/2/0x1 = #1532 */
    { 0x0f7f, 0xdce5, 0x7c01, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_IND(1) }, /* #30/3/3/m = #1533 */
    { 0x0f00, 0xdce5, 0xf481, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0) }, /* #30/3/3/u = #1534 */
    { 0x0f01, 0xdce5, 0x7c01, RTFLOAT80U_INIT_C(0,0x197ec7edc2e1e588,30159), RTFLOAT80U_INIT_C(1,0x85866c72d39d3c95,0), RTFLOAT80U_INIT_IND(1) }, /* #30/3/3/0x1 = #1535 */
    { 0x007f, 0x7fa2, 0x7d01, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_IND(1) }, /* #31/0/0/m = #1536 */
    { 0x0000, 0x7fa2, 0xf581, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0) }, /* #31/0/0/u = #1537 */
    { 0x0001, 0x7fa2, 0x7d01, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_IND(1) }, /* #31/0/0/0x1 = #1538 */
    { 0x017f, 0x7fa2, 0x7d01, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_IND(1) }, /* #31/0/1/m = #1539 */
    { 0x0100, 0x7fa2, 0xf581, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0) }, /* #31/0/1/u = #1540 */
    { 0x0101, 0x7fa2, 0x7d01, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_IND(1) }, /* #31/0/1/0x1 = #1541 */
    { 0x027f, 0x7fa2, 0x7d01, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_IND(1) }, /* #31/0/2/m = #1542 */
    { 0x0200, 0x7fa2, 0xf581, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0) }, /* #31/0/2/u = #1543 */
    { 0x0201, 0x7fa2, 0x7d01, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_IND(1) }, /* #31/0/2/0x1 = #1544 */
    { 0x037f, 0x7fa2, 0x7d01, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_IND(1) }, /* #31/0/3/m = #1545 */
    { 0x0300, 0x7fa2, 0xf581, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0) }, /* #31/0/3/u = #1546 */
    { 0x0301, 0x7fa2, 0x7d01, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_IND(1) }, /* #31/0/3/0x1 = #1547 */
    { 0x047f, 0x7fa2, 0x7d01, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_IND(1) }, /* #31/1/0/m = #1548 */
    { 0x0400, 0x7fa2, 0xf581, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0) }, /* #31/1/0/u = #1549 */
    { 0x0401, 0x7fa2, 0x7d01, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_IND(1) }, /* #31/1/0/0x1 = #1550 */
    { 0x057f, 0x7fa2, 0x7d01, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_IND(1) }, /* #31/1/1/m = #1551 */
    { 0x0500, 0x7fa2, 0xf581, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0) }, /* #31/1/1/u = #1552 */
    { 0x0501, 0x7fa2, 0x7d01, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_IND(1) }, /* #31/1/1/0x1 = #1553 */
    { 0x067f, 0x7fa2, 0x7d01, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_IND(1) }, /* #31/1/2/m = #1554 */
    { 0x0600, 0x7fa2, 0xf581, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0) }, /* #31/1/2/u = #1555 */
    { 0x0601, 0x7fa2, 0x7d01, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_IND(1) }, /* #31/1/2/0x1 = #1556 */
    { 0x077f, 0x7fa2, 0x7d01, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_IND(1) }, /* #31/1/3/m = #1557 */
    { 0x0700, 0x7fa2, 0xf581, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0) }, /* #31/1/3/u = #1558 */
    { 0x0701, 0x7fa2, 0x7d01, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_IND(1) }, /* #31/1/3/0x1 = #1559 */
    { 0x087f, 0x7fa2, 0x7d01, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_IND(1) }, /* #31/2/0/m = #1560 */
    { 0x0800, 0x7fa2, 0xf581, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0) }, /* #31/2/0/u = #1561 */
    { 0x0801, 0x7fa2, 0x7d01, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_IND(1) }, /* #31/2/0/0x1 = #1562 */
    { 0x097f, 0x7fa2, 0x7d01, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_IND(1) }, /* #31/2/1/m = #1563 */
    { 0x0900, 0x7fa2, 0xf581, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0) }, /* #31/2/1/u = #1564 */
    { 0x0901, 0x7fa2, 0x7d01, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_IND(1) }, /* #31/2/1/0x1 = #1565 */
    { 0x0a7f, 0x7fa2, 0x7d01, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_IND(1) }, /* #31/2/2/m = #1566 */
    { 0x0a00, 0x7fa2, 0xf581, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0) }, /* #31/2/2/u = #1567 */
    { 0x0a01, 0x7fa2, 0x7d01, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_IND(1) }, /* #31/2/2/0x1 = #1568 */
    { 0x0b7f, 0x7fa2, 0x7d01, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_IND(1) }, /* #31/2/3/m = #1569 */
    { 0x0b00, 0x7fa2, 0xf581, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0) }, /* #31/2/3/u = #1570 */
    { 0x0b01, 0x7fa2, 0x7d01, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_IND(1) }, /* #31/2/3/0x1 = #1571 */
    { 0x0c7f, 0x7fa2, 0x7d01, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_IND(1) }, /* #31/3/0/m = #1572 */
    { 0x0c00, 0x7fa2, 0xf581, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0) }, /* #31/3/0/u = #1573 */
    { 0x0c01, 0x7fa2, 0x7d01, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_IND(1) }, /* #31/3/0/0x1 = #1574 */
    { 0x0d7f, 0x7fa2, 0x7d01, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_IND(1) }, /* #31/3/1/m = #1575 */
    { 0x0d00, 0x7fa2, 0xf581, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0) }, /* #31/3/1/u = #1576 */
    { 0x0d01, 0x7fa2, 0x7d01, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_IND(1) }, /* #31/3/1/0x1 = #1577 */
    { 0x0e7f, 0x7fa2, 0x7d01, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_IND(1) }, /* #31/3/2/m = #1578 */
    { 0x0e00, 0x7fa2, 0xf581, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0) }, /* #31/3/2/u = #1579 */
    { 0x0e01, 0x7fa2, 0x7d01, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_IND(1) }, /* #31/3/2/0x1 = #1580 */
    { 0x0f7f, 0x7fa2, 0x7d01, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_IND(1) }, /* #31/3/3/m = #1581 */
    { 0x0f00, 0x7fa2, 0xf581, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0) }, /* #31/3/3/u = #1582 */
    { 0x0f01, 0x7fa2, 0x7d01, RTFLOAT80U_INIT_C(1,0x1b8338429650d936,1867), RTFLOAT80U_INIT_C(0,0x1bea36806621e5a8,0), RTFLOAT80U_INIT_IND(1) }, /* #31/3/3/0x1 = #1583 */
    { 0x007f, 0xe65a, 0x7c01, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/0/0/m = #1584 */
    { 0x0000, 0xe65a, 0xf481, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/0/0/u = #1585 */
    { 0x0001, 0xe65a, 0x7c01, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/0/0/0x1 = #1586 */
    { 0x017f, 0xe65a, 0x7c01, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/0/1/m = #1587 */
    { 0x0100, 0xe65a, 0xf481, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/0/1/u = #1588 */
    { 0x0101, 0xe65a, 0x7c01, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/0/1/0x1 = #1589 */
    { 0x027f, 0xe65a, 0x7c01, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/0/2/m = #1590 */
    { 0x0200, 0xe65a, 0xf481, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/0/2/u = #1591 */
    { 0x0201, 0xe65a, 0x7c01, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/0/2/0x1 = #1592 */
    { 0x037f, 0xe65a, 0x7c01, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/0/3/m = #1593 */
    { 0x0300, 0xe65a, 0xf481, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/0/3/u = #1594 */
    { 0x0301, 0xe65a, 0x7c01, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/0/3/0x1 = #1595 */
    { 0x047f, 0xe65a, 0x7c01, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/1/0/m = #1596 */
    { 0x0400, 0xe65a, 0xf481, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/1/0/u = #1597 */
    { 0x0401, 0xe65a, 0x7c01, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/1/0/0x1 = #1598 */
    { 0x057f, 0xe65a, 0x7c01, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/1/1/m = #1599 */
    { 0x0500, 0xe65a, 0xf481, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/1/1/u = #1600 */
    { 0x0501, 0xe65a, 0x7c01, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/1/1/0x1 = #1601 */
    { 0x067f, 0xe65a, 0x7c01, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/1/2/m = #1602 */
    { 0x0600, 0xe65a, 0xf481, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/1/2/u = #1603 */
    { 0x0601, 0xe65a, 0x7c01, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/1/2/0x1 = #1604 */
    { 0x077f, 0xe65a, 0x7c01, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/1/3/m = #1605 */
    { 0x0700, 0xe65a, 0xf481, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/1/3/u = #1606 */
    { 0x0701, 0xe65a, 0x7c01, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/1/3/0x1 = #1607 */
    { 0x087f, 0xe65a, 0x7c01, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/2/0/m = #1608 */
    { 0x0800, 0xe65a, 0xf481, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/2/0/u = #1609 */
    { 0x0801, 0xe65a, 0x7c01, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/2/0/0x1 = #1610 */
    { 0x097f, 0xe65a, 0x7c01, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/2/1/m = #1611 */
    { 0x0900, 0xe65a, 0xf481, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/2/1/u = #1612 */
    { 0x0901, 0xe65a, 0x7c01, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/2/1/0x1 = #1613 */
    { 0x0a7f, 0xe65a, 0x7c01, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/2/2/m = #1614 */
    { 0x0a00, 0xe65a, 0xf481, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/2/2/u = #1615 */
    { 0x0a01, 0xe65a, 0x7c01, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/2/2/0x1 = #1616 */
    { 0x0b7f, 0xe65a, 0x7c01, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/2/3/m = #1617 */
    { 0x0b00, 0xe65a, 0xf481, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/2/3/u = #1618 */
    { 0x0b01, 0xe65a, 0x7c01, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/2/3/0x1 = #1619 */
    { 0x0c7f, 0xe65a, 0x7c01, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/3/0/m = #1620 */
    { 0x0c00, 0xe65a, 0xf481, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/3/0/u = #1621 */
    { 0x0c01, 0xe65a, 0x7c01, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/3/0/0x1 = #1622 */
    { 0x0d7f, 0xe65a, 0x7c01, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/3/1/m = #1623 */
    { 0x0d00, 0xe65a, 0xf481, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/3/1/u = #1624 */
    { 0x0d01, 0xe65a, 0x7c01, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/3/1/0x1 = #1625 */
    { 0x0e7f, 0xe65a, 0x7c01, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/3/2/m = #1626 */
    { 0x0e00, 0xe65a, 0xf481, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/3/2/u = #1627 */
    { 0x0e01, 0xe65a, 0x7c01, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/3/2/0x1 = #1628 */
    { 0x0f7f, 0xe65a, 0x7c01, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/3/3/m = #1629 */
    { 0x0f00, 0xe65a, 0xf481, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/3/3/u = #1630 */
    { 0x0f01, 0xe65a, 0x7c01, RTFLOAT80U_INIT_C(1,0x4c797479245e48b2,15490), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #32/3/3/0x1 = #1631 */
    { 0x007f, 0x60e4, 0x7801, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #33/0/0/m = #1632 */
    { 0x0000, 0x60e4, 0xf081, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #33/0/0/u = #1633 */
    { 0x0001, 0x60e4, 0x7801, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #33/0/0/0x1 = #1634 */
    { 0x017f, 0x60e4, 0x7801, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #33/0/1/m = #1635 */
    { 0x0100, 0x60e4, 0xf081, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #33/0/1/u = #1636 */
    { 0x0101, 0x60e4, 0x7801, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #33/0/1/0x1 = #1637 */
    { 0x027f, 0x60e4, 0x7801, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #33/0/2/m = #1638 */
    { 0x0200, 0x60e4, 0xf081, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #33/0/2/u = #1639 */
    { 0x0201, 0x60e4, 0x7801, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #33/0/2/0x1 = #1640 */
    { 0x037f, 0x60e4, 0x7801, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #33/0/3/m = #1641 */
    { 0x0300, 0x60e4, 0xf081, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #33/0/3/u = #1642 */
    { 0x0301, 0x60e4, 0x7801, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #33/0/3/0x1 = #1643 */
    { 0x047f, 0x60e4, 0x7801, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #33/1/0/m = #1644 */
    { 0x0400, 0x60e4, 0xf081, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #33/1/0/u = #1645 */
    { 0x0401, 0x60e4, 0x7801, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #33/1/0/0x1 = #1646 */
    { 0x057f, 0x60e4, 0x7801, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #33/1/1/m = #1647 */
    { 0x0500, 0x60e4, 0xf081, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #33/1/1/u = #1648 */
    { 0x0501, 0x60e4, 0x7801, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #33/1/1/0x1 = #1649 */
    { 0x067f, 0x60e4, 0x7801, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #33/1/2/m = #1650 */
    { 0x0600, 0x60e4, 0xf081, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #33/1/2/u = #1651 */
    { 0x0601, 0x60e4, 0x7801, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #33/1/2/0x1 = #1652 */
    { 0x077f, 0x60e4, 0x7801, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #33/1/3/m = #1653 */
    { 0x0700, 0x60e4, 0xf081, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #33/1/3/u = #1654 */
    { 0x0701, 0x60e4, 0x7801, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #33/1/3/0x1 = #1655 */
    { 0x087f, 0x60e4, 0x7801, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #33/2/0/m = #1656 */
    { 0x0800, 0x60e4, 0xf081, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #33/2/0/u = #1657 */
    { 0x0801, 0x60e4, 0x7801, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #33/2/0/0x1 = #1658 */
    { 0x097f, 0x60e4, 0x7801, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #33/2/1/m = #1659 */
    { 0x0900, 0x60e4, 0xf081, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #33/2/1/u = #1660 */
    { 0x0901, 0x60e4, 0x7801, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #33/2/1/0x1 = #1661 */
    { 0x0a7f, 0x60e4, 0x7801, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #33/2/2/m = #1662 */
    { 0x0a00, 0x60e4, 0xf081, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #33/2/2/u = #1663 */
    { 0x0a01, 0x60e4, 0x7801, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #33/2/2/0x1 = #1664 */
    { 0x0b7f, 0x60e4, 0x7801, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #33/2/3/m = #1665 */
    { 0x0b00, 0x60e4, 0xf081, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #33/2/3/u = #1666 */
    { 0x0b01, 0x60e4, 0x7801, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #33/2/3/0x1 = #1667 */
    { 0x0c7f, 0x60e4, 0x7801, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #33/3/0/m = #1668 */
    { 0x0c00, 0x60e4, 0xf081, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #33/3/0/u = #1669 */
    { 0x0c01, 0x60e4, 0x7801, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #33/3/0/0x1 = #1670 */
    { 0x0d7f, 0x60e4, 0x7801, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #33/3/1/m = #1671 */
    { 0x0d00, 0x60e4, 0xf081, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #33/3/1/u = #1672 */
    { 0x0d01, 0x60e4, 0x7801, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #33/3/1/0x1 = #1673 */
    { 0x0e7f, 0x60e4, 0x7801, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #33/3/2/m = #1674 */
    { 0x0e00, 0x60e4, 0xf081, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #33/3/2/u = #1675 */
    { 0x0e01, 0x60e4, 0x7801, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #33/3/2/0x1 = #1676 */
    { 0x0f7f, 0x60e4, 0x7801, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #33/3/3/m = #1677 */
    { 0x0f00, 0x60e4, 0xf081, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #33/3/3/u = #1678 */
    { 0x0f01, 0x60e4, 0x7801, RTFLOAT80U_INIT_C(1,0x7fab4ceca9437b68,5641), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #33/3/3/0x1 = #1679 */
    { 0x007f, 0x525c, 0x7801, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/0/0/m = #1680 */
    { 0x0000, 0x525c, 0xf081, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #34/0/0/u = #1681 */
    { 0x0001, 0x525c, 0x7801, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/0/0/0x1 = #1682 */
    { 0x017f, 0x525c, 0x7801, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/0/1/m = #1683 */
    { 0x0100, 0x525c, 0xf081, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #34/0/1/u = #1684 */
    { 0x0101, 0x525c, 0x7801, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/0/1/0x1 = #1685 */
    { 0x027f, 0x525c, 0x7801, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/0/2/m = #1686 */
    { 0x0200, 0x525c, 0xf081, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #34/0/2/u = #1687 */
    { 0x0201, 0x525c, 0x7801, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/0/2/0x1 = #1688 */
    { 0x037f, 0x525c, 0x7801, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/0/3/m = #1689 */
    { 0x0300, 0x525c, 0xf081, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #34/0/3/u = #1690 */
    { 0x0301, 0x525c, 0x7801, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/0/3/0x1 = #1691 */
    { 0x047f, 0x525c, 0x7801, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/1/0/m = #1692 */
    { 0x0400, 0x525c, 0xf081, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #34/1/0/u = #1693 */
    { 0x0401, 0x525c, 0x7801, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/1/0/0x1 = #1694 */
    { 0x057f, 0x525c, 0x7801, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/1/1/m = #1695 */
    { 0x0500, 0x525c, 0xf081, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #34/1/1/u = #1696 */
    { 0x0501, 0x525c, 0x7801, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/1/1/0x1 = #1697 */
    { 0x067f, 0x525c, 0x7801, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/1/2/m = #1698 */
    { 0x0600, 0x525c, 0xf081, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #34/1/2/u = #1699 */
    { 0x0601, 0x525c, 0x7801, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/1/2/0x1 = #1700 */
    { 0x077f, 0x525c, 0x7801, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/1/3/m = #1701 */
    { 0x0700, 0x525c, 0xf081, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #34/1/3/u = #1702 */
    { 0x0701, 0x525c, 0x7801, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/1/3/0x1 = #1703 */
    { 0x087f, 0x525c, 0x7801, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/2/0/m = #1704 */
    { 0x0800, 0x525c, 0xf081, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #34/2/0/u = #1705 */
    { 0x0801, 0x525c, 0x7801, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/2/0/0x1 = #1706 */
    { 0x097f, 0x525c, 0x7801, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/2/1/m = #1707 */
    { 0x0900, 0x525c, 0xf081, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #34/2/1/u = #1708 */
    { 0x0901, 0x525c, 0x7801, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/2/1/0x1 = #1709 */
    { 0x0a7f, 0x525c, 0x7801, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/2/2/m = #1710 */
    { 0x0a00, 0x525c, 0xf081, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #34/2/2/u = #1711 */
    { 0x0a01, 0x525c, 0x7801, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/2/2/0x1 = #1712 */
    { 0x0b7f, 0x525c, 0x7801, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/2/3/m = #1713 */
    { 0x0b00, 0x525c, 0xf081, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #34/2/3/u = #1714 */
    { 0x0b01, 0x525c, 0x7801, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/2/3/0x1 = #1715 */
    { 0x0c7f, 0x525c, 0x7801, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/3/0/m = #1716 */
    { 0x0c00, 0x525c, 0xf081, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #34/3/0/u = #1717 */
    { 0x0c01, 0x525c, 0x7801, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/3/0/0x1 = #1718 */
    { 0x0d7f, 0x525c, 0x7801, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/3/1/m = #1719 */
    { 0x0d00, 0x525c, 0xf081, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #34/3/1/u = #1720 */
    { 0x0d01, 0x525c, 0x7801, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/3/1/0x1 = #1721 */
    { 0x0e7f, 0x525c, 0x7801, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/3/2/m = #1722 */
    { 0x0e00, 0x525c, 0xf081, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #34/3/2/u = #1723 */
    { 0x0e01, 0x525c, 0x7801, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/3/2/0x1 = #1724 */
    { 0x0f7f, 0x525c, 0x7801, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/3/3/m = #1725 */
    { 0x0f00, 0x525c, 0xf081, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #34/3/3/u = #1726 */
    { 0x0f01, 0x525c, 0x7801, RTFLOAT80U_INIT_C(0,0x575c771053392b5b,30102), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/3/3/0x1 = #1727 */
    { 0x007f, 0x8864, 0x3801, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #35/0/0/m = #1728 */
    { 0x0000, 0x8864, 0xb081, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(0) }, /* #35/0/0/u = #1729 */
    { 0x0001, 0x8864, 0x3801, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #35/0/0/0x1 = #1730 */
    { 0x017f, 0x8864, 0x3801, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #35/0/1/m = #1731 */
    { 0x0100, 0x8864, 0xb081, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(0) }, /* #35/0/1/u = #1732 */
    { 0x0101, 0x8864, 0x3801, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #35/0/1/0x1 = #1733 */
    { 0x027f, 0x8864, 0x3801, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #35/0/2/m = #1734 */
    { 0x0200, 0x8864, 0xb081, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(0) }, /* #35/0/2/u = #1735 */
    { 0x0201, 0x8864, 0x3801, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #35/0/2/0x1 = #1736 */
    { 0x037f, 0x8864, 0x3801, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #35/0/3/m = #1737 */
    { 0x0300, 0x8864, 0xb081, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(0) }, /* #35/0/3/u = #1738 */
    { 0x0301, 0x8864, 0x3801, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #35/0/3/0x1 = #1739 */
    { 0x047f, 0x8864, 0x3801, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #35/1/0/m = #1740 */
    { 0x0400, 0x8864, 0xb081, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(0) }, /* #35/1/0/u = #1741 */
    { 0x0401, 0x8864, 0x3801, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #35/1/0/0x1 = #1742 */
    { 0x057f, 0x8864, 0x3801, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #35/1/1/m = #1743 */
    { 0x0500, 0x8864, 0xb081, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(0) }, /* #35/1/1/u = #1744 */
    { 0x0501, 0x8864, 0x3801, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #35/1/1/0x1 = #1745 */
    { 0x067f, 0x8864, 0x3801, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #35/1/2/m = #1746 */
    { 0x0600, 0x8864, 0xb081, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(0) }, /* #35/1/2/u = #1747 */
    { 0x0601, 0x8864, 0x3801, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #35/1/2/0x1 = #1748 */
    { 0x077f, 0x8864, 0x3801, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #35/1/3/m = #1749 */
    { 0x0700, 0x8864, 0xb081, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(0) }, /* #35/1/3/u = #1750 */
    { 0x0701, 0x8864, 0x3801, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #35/1/3/0x1 = #1751 */
    { 0x087f, 0x8864, 0x3801, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #35/2/0/m = #1752 */
    { 0x0800, 0x8864, 0xb081, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(0) }, /* #35/2/0/u = #1753 */
    { 0x0801, 0x8864, 0x3801, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #35/2/0/0x1 = #1754 */
    { 0x097f, 0x8864, 0x3801, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #35/2/1/m = #1755 */
    { 0x0900, 0x8864, 0xb081, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(0) }, /* #35/2/1/u = #1756 */
    { 0x0901, 0x8864, 0x3801, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #35/2/1/0x1 = #1757 */
    { 0x0a7f, 0x8864, 0x3801, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #35/2/2/m = #1758 */
    { 0x0a00, 0x8864, 0xb081, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(0) }, /* #35/2/2/u = #1759 */
    { 0x0a01, 0x8864, 0x3801, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #35/2/2/0x1 = #1760 */
    { 0x0b7f, 0x8864, 0x3801, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #35/2/3/m = #1761 */
    { 0x0b00, 0x8864, 0xb081, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(0) }, /* #35/2/3/u = #1762 */
    { 0x0b01, 0x8864, 0x3801, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #35/2/3/0x1 = #1763 */
    { 0x0c7f, 0x8864, 0x3801, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #35/3/0/m = #1764 */
    { 0x0c00, 0x8864, 0xb081, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(0) }, /* #35/3/0/u = #1765 */
    { 0x0c01, 0x8864, 0x3801, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #35/3/0/0x1 = #1766 */
    { 0x0d7f, 0x8864, 0x3801, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #35/3/1/m = #1767 */
    { 0x0d00, 0x8864, 0xb081, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(0) }, /* #35/3/1/u = #1768 */
    { 0x0d01, 0x8864, 0x3801, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #35/3/1/0x1 = #1769 */
    { 0x0e7f, 0x8864, 0x3801, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #35/3/2/m = #1770 */
    { 0x0e00, 0x8864, 0xb081, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(0) }, /* #35/3/2/u = #1771 */
    { 0x0e01, 0x8864, 0x3801, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #35/3/2/0x1 = #1772 */
    { 0x0f7f, 0x8864, 0x3801, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #35/3/3/m = #1773 */
    { 0x0f00, 0x8864, 0xb081, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(0) }, /* #35/3/3/u = #1774 */
    { 0x0f01, 0x8864, 0x3801, RTFLOAT80U_INIT_C(0,0x46d8c071d1b9dc5b,21069), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #35/3/3/0x1 = #1775 */
    { 0x007f, 0x7442, 0x7c01, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xe3ba942391c4d65a,32767) }, /* #36/0/0/m = #1776 */
    { 0x0000, 0x7442, 0xf481, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038) }, /* #36/0/0/u = #1777 */
    { 0x0001, 0x7442, 0x7c01, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xe3ba942391c4d65a,32767) }, /* #36/0/0/0x1 = #1778 */
    { 0x017f, 0x7442, 0x7c01, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xe3ba942391c4d65a,32767) }, /* #36/0/1/m = #1779 */
    { 0x0100, 0x7442, 0xf481, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038) }, /* #36/0/1/u = #1780 */
    { 0x0101, 0x7442, 0x7c01, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xe3ba942391c4d65a,32767) }, /* #36/0/1/0x1 = #1781 */
    { 0x027f, 0x7442, 0x7c01, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xe3ba942391c4d65a,32767) }, /* #36/0/2/m = #1782 */
    { 0x0200, 0x7442, 0xf481, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038) }, /* #36/0/2/u = #1783 */
    { 0x0201, 0x7442, 0x7c01, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xe3ba942391c4d65a,32767) }, /* #36/0/2/0x1 = #1784 */
    { 0x037f, 0x7442, 0x7c01, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xe3ba942391c4d65a,32767) }, /* #36/0/3/m = #1785 */
    { 0x0300, 0x7442, 0xf481, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038) }, /* #36/0/3/u = #1786 */
    { 0x0301, 0x7442, 0x7c01, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xe3ba942391c4d65a,32767) }, /* #36/0/3/0x1 = #1787 */
    { 0x047f, 0x7442, 0x7c01, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xe3ba942391c4d65a,32767) }, /* #36/1/0/m = #1788 */
    { 0x0400, 0x7442, 0xf481, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038) }, /* #36/1/0/u = #1789 */
    { 0x0401, 0x7442, 0x7c01, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xe3ba942391c4d65a,32767) }, /* #36/1/0/0x1 = #1790 */
    { 0x057f, 0x7442, 0x7c01, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xe3ba942391c4d65a,32767) }, /* #36/1/1/m = #1791 */
    { 0x0500, 0x7442, 0xf481, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038) }, /* #36/1/1/u = #1792 */
    { 0x0501, 0x7442, 0x7c01, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xe3ba942391c4d65a,32767) }, /* #36/1/1/0x1 = #1793 */
    { 0x067f, 0x7442, 0x7c01, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xe3ba942391c4d65a,32767) }, /* #36/1/2/m = #1794 */
    { 0x0600, 0x7442, 0xf481, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038) }, /* #36/1/2/u = #1795 */
    { 0x0601, 0x7442, 0x7c01, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xe3ba942391c4d65a,32767) }, /* #36/1/2/0x1 = #1796 */
    { 0x077f, 0x7442, 0x7c01, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xe3ba942391c4d65a,32767) }, /* #36/1/3/m = #1797 */
    { 0x0700, 0x7442, 0xf481, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038) }, /* #36/1/3/u = #1798 */
    { 0x0701, 0x7442, 0x7c01, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xe3ba942391c4d65a,32767) }, /* #36/1/3/0x1 = #1799 */
    { 0x087f, 0x7442, 0x7c01, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xe3ba942391c4d65a,32767) }, /* #36/2/0/m = #1800 */
    { 0x0800, 0x7442, 0xf481, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038) }, /* #36/2/0/u = #1801 */
    { 0x0801, 0x7442, 0x7c01, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xe3ba942391c4d65a,32767) }, /* #36/2/0/0x1 = #1802 */
    { 0x097f, 0x7442, 0x7c01, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xe3ba942391c4d65a,32767) }, /* #36/2/1/m = #1803 */
    { 0x0900, 0x7442, 0xf481, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038) }, /* #36/2/1/u = #1804 */
    { 0x0901, 0x7442, 0x7c01, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xe3ba942391c4d65a,32767) }, /* #36/2/1/0x1 = #1805 */
    { 0x0a7f, 0x7442, 0x7c01, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xe3ba942391c4d65a,32767) }, /* #36/2/2/m = #1806 */
    { 0x0a00, 0x7442, 0xf481, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038) }, /* #36/2/2/u = #1807 */
    { 0x0a01, 0x7442, 0x7c01, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xe3ba942391c4d65a,32767) }, /* #36/2/2/0x1 = #1808 */
    { 0x0b7f, 0x7442, 0x7c01, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xe3ba942391c4d65a,32767) }, /* #36/2/3/m = #1809 */
    { 0x0b00, 0x7442, 0xf481, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038) }, /* #36/2/3/u = #1810 */
    { 0x0b01, 0x7442, 0x7c01, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xe3ba942391c4d65a,32767) }, /* #36/2/3/0x1 = #1811 */
    { 0x0c7f, 0x7442, 0x7c01, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xe3ba942391c4d65a,32767) }, /* #36/3/0/m = #1812 */
    { 0x0c00, 0x7442, 0xf481, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038) }, /* #36/3/0/u = #1813 */
    { 0x0c01, 0x7442, 0x7c01, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xe3ba942391c4d65a,32767) }, /* #36/3/0/0x1 = #1814 */
    { 0x0d7f, 0x7442, 0x7c01, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xe3ba942391c4d65a,32767) }, /* #36/3/1/m = #1815 */
    { 0x0d00, 0x7442, 0xf481, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038) }, /* #36/3/1/u = #1816 */
    { 0x0d01, 0x7442, 0x7c01, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xe3ba942391c4d65a,32767) }, /* #36/3/1/0x1 = #1817 */
    { 0x0e7f, 0x7442, 0x7c01, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xe3ba942391c4d65a,32767) }, /* #36/3/2/m = #1818 */
    { 0x0e00, 0x7442, 0xf481, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038) }, /* #36/3/2/u = #1819 */
    { 0x0e01, 0x7442, 0x7c01, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xe3ba942391c4d65a,32767) }, /* #36/3/2/0x1 = #1820 */
    { 0x0f7f, 0x7442, 0x7c01, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xe3ba942391c4d65a,32767) }, /* #36/3/3/m = #1821 */
    { 0x0f00, 0x7442, 0xf481, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038) }, /* #36/3/3/u = #1822 */
    { 0x0f01, 0x7442, 0x7c01, RTFLOAT80U_INIT_C(1,0xa3ba942391c4d65a,32767), RTFLOAT80U_INIT_C(1,0xa8557c41519f2d86,4038), RTFLOAT80U_INIT_C(1,0xe3ba942391c4d65a,32767) }, /* #36/3/3/0x1 = #1823 */
    { 0x007f, 0x86dc, 0x3c01, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xcb894fc5b1cf10f2,32767) }, /* #37/0/0/m = #1824 */
    { 0x0000, 0x86dc, 0xb481, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1) }, /* #37/0/0/u = #1825 */
    { 0x0001, 0x86dc, 0x3c01, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xcb894fc5b1cf10f2,32767) }, /* #37/0/0/0x1 = #1826 */
    { 0x017f, 0x86dc, 0x3c01, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xcb894fc5b1cf10f2,32767) }, /* #37/0/1/m = #1827 */
    { 0x0100, 0x86dc, 0xb481, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1) }, /* #37/0/1/u = #1828 */
    { 0x0101, 0x86dc, 0x3c01, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xcb894fc5b1cf10f2,32767) }, /* #37/0/1/0x1 = #1829 */
    { 0x027f, 0x86dc, 0x3c01, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xcb894fc5b1cf10f2,32767) }, /* #37/0/2/m = #1830 */
    { 0x0200, 0x86dc, 0xb481, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1) }, /* #37/0/2/u = #1831 */
    { 0x0201, 0x86dc, 0x3c01, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xcb894fc5b1cf10f2,32767) }, /* #37/0/2/0x1 = #1832 */
    { 0x037f, 0x86dc, 0x3c01, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xcb894fc5b1cf10f2,32767) }, /* #37/0/3/m = #1833 */
    { 0x0300, 0x86dc, 0xb481, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1) }, /* #37/0/3/u = #1834 */
    { 0x0301, 0x86dc, 0x3c01, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xcb894fc5b1cf10f2,32767) }, /* #37/0/3/0x1 = #1835 */
    { 0x047f, 0x86dc, 0x3c01, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xcb894fc5b1cf10f2,32767) }, /* #37/1/0/m = #1836 */
    { 0x0400, 0x86dc, 0xb481, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1) }, /* #37/1/0/u = #1837 */
    { 0x0401, 0x86dc, 0x3c01, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xcb894fc5b1cf10f2,32767) }, /* #37/1/0/0x1 = #1838 */
    { 0x057f, 0x86dc, 0x3c01, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xcb894fc5b1cf10f2,32767) }, /* #37/1/1/m = #1839 */
    { 0x0500, 0x86dc, 0xb481, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1) }, /* #37/1/1/u = #1840 */
    { 0x0501, 0x86dc, 0x3c01, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xcb894fc5b1cf10f2,32767) }, /* #37/1/1/0x1 = #1841 */
    { 0x067f, 0x86dc, 0x3c01, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xcb894fc5b1cf10f2,32767) }, /* #37/1/2/m = #1842 */
    { 0x0600, 0x86dc, 0xb481, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1) }, /* #37/1/2/u = #1843 */
    { 0x0601, 0x86dc, 0x3c01, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xcb894fc5b1cf10f2,32767) }, /* #37/1/2/0x1 = #1844 */
    { 0x077f, 0x86dc, 0x3c01, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xcb894fc5b1cf10f2,32767) }, /* #37/1/3/m = #1845 */
    { 0x0700, 0x86dc, 0xb481, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1) }, /* #37/1/3/u = #1846 */
    { 0x0701, 0x86dc, 0x3c01, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xcb894fc5b1cf10f2,32767) }, /* #37/1/3/0x1 = #1847 */
    { 0x087f, 0x86dc, 0x3c01, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xcb894fc5b1cf10f2,32767) }, /* #37/2/0/m = #1848 */
    { 0x0800, 0x86dc, 0xb481, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1) }, /* #37/2/0/u = #1849 */
    { 0x0801, 0x86dc, 0x3c01, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xcb894fc5b1cf10f2,32767) }, /* #37/2/0/0x1 = #1850 */
    { 0x097f, 0x86dc, 0x3c01, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xcb894fc5b1cf10f2,32767) }, /* #37/2/1/m = #1851 */
    { 0x0900, 0x86dc, 0xb481, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1) }, /* #37/2/1/u = #1852 */
    { 0x0901, 0x86dc, 0x3c01, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xcb894fc5b1cf10f2,32767) }, /* #37/2/1/0x1 = #1853 */
    { 0x0a7f, 0x86dc, 0x3c01, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xcb894fc5b1cf10f2,32767) }, /* #37/2/2/m = #1854 */
    { 0x0a00, 0x86dc, 0xb481, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1) }, /* #37/2/2/u = #1855 */
    { 0x0a01, 0x86dc, 0x3c01, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xcb894fc5b1cf10f2,32767) }, /* #37/2/2/0x1 = #1856 */
    { 0x0b7f, 0x86dc, 0x3c01, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xcb894fc5b1cf10f2,32767) }, /* #37/2/3/m = #1857 */
    { 0x0b00, 0x86dc, 0xb481, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1) }, /* #37/2/3/u = #1858 */
    { 0x0b01, 0x86dc, 0x3c01, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xcb894fc5b1cf10f2,32767) }, /* #37/2/3/0x1 = #1859 */
    { 0x0c7f, 0x86dc, 0x3c01, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xcb894fc5b1cf10f2,32767) }, /* #37/3/0/m = #1860 */
    { 0x0c00, 0x86dc, 0xb481, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1) }, /* #37/3/0/u = #1861 */
    { 0x0c01, 0x86dc, 0x3c01, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xcb894fc5b1cf10f2,32767) }, /* #37/3/0/0x1 = #1862 */
    { 0x0d7f, 0x86dc, 0x3c01, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xcb894fc5b1cf10f2,32767) }, /* #37/3/1/m = #1863 */
    { 0x0d00, 0x86dc, 0xb481, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1) }, /* #37/3/1/u = #1864 */
    { 0x0d01, 0x86dc, 0x3c01, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xcb894fc5b1cf10f2,32767) }, /* #37/3/1/0x1 = #1865 */
    { 0x0e7f, 0x86dc, 0x3c01, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xcb894fc5b1cf10f2,32767) }, /* #37/3/2/m = #1866 */
    { 0x0e00, 0x86dc, 0xb481, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1) }, /* #37/3/2/u = #1867 */
    { 0x0e01, 0x86dc, 0x3c01, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xcb894fc5b1cf10f2,32767) }, /* #37/3/2/0x1 = #1868 */
    { 0x0f7f, 0x86dc, 0x3c01, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xcb894fc5b1cf10f2,32767) }, /* #37/3/3/m = #1869 */
    { 0x0f00, 0x86dc, 0xb481, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1) }, /* #37/3/3/u = #1870 */
    { 0x0f01, 0x86dc, 0x3c01, RTFLOAT80U_INIT_C(1,0x8b894fc5b1cf10f2,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xcb894fc5b1cf10f2,32767) }, /* #37/3/3/0x1 = #1871 */
    { 0x007f, 0x3fb8, 0x3d01, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_IND(1) }, /* #38/0/0/m = #1872 */
    { 0x0000, 0x3fb8, 0xb581, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146) }, /* #38/0/0/u = #1873 */
    { 0x0001, 0x3fb8, 0x3d01, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_IND(1) }, /* #38/0/0/0x1 = #1874 */
    { 0x017f, 0x3fb8, 0x3d01, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_IND(1) }, /* #38/0/1/m = #1875 */
    { 0x0100, 0x3fb8, 0xb581, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146) }, /* #38/0/1/u = #1876 */
    { 0x0101, 0x3fb8, 0x3d01, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_IND(1) }, /* #38/0/1/0x1 = #1877 */
    { 0x027f, 0x3fb8, 0x3d01, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_IND(1) }, /* #38/0/2/m = #1878 */
    { 0x0200, 0x3fb8, 0xb581, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146) }, /* #38/0/2/u = #1879 */
    { 0x0201, 0x3fb8, 0x3d01, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_IND(1) }, /* #38/0/2/0x1 = #1880 */
    { 0x037f, 0x3fb8, 0x3d01, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_IND(1) }, /* #38/0/3/m = #1881 */
    { 0x0300, 0x3fb8, 0xb581, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146) }, /* #38/0/3/u = #1882 */
    { 0x0301, 0x3fb8, 0x3d01, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_IND(1) }, /* #38/0/3/0x1 = #1883 */
    { 0x047f, 0x3fb8, 0x3d01, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_IND(1) }, /* #38/1/0/m = #1884 */
    { 0x0400, 0x3fb8, 0xb581, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146) }, /* #38/1/0/u = #1885 */
    { 0x0401, 0x3fb8, 0x3d01, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_IND(1) }, /* #38/1/0/0x1 = #1886 */
    { 0x057f, 0x3fb8, 0x3d01, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_IND(1) }, /* #38/1/1/m = #1887 */
    { 0x0500, 0x3fb8, 0xb581, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146) }, /* #38/1/1/u = #1888 */
    { 0x0501, 0x3fb8, 0x3d01, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_IND(1) }, /* #38/1/1/0x1 = #1889 */
    { 0x067f, 0x3fb8, 0x3d01, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_IND(1) }, /* #38/1/2/m = #1890 */
    { 0x0600, 0x3fb8, 0xb581, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146) }, /* #38/1/2/u = #1891 */
    { 0x0601, 0x3fb8, 0x3d01, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_IND(1) }, /* #38/1/2/0x1 = #1892 */
    { 0x077f, 0x3fb8, 0x3d01, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_IND(1) }, /* #38/1/3/m = #1893 */
    { 0x0700, 0x3fb8, 0xb581, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146) }, /* #38/1/3/u = #1894 */
    { 0x0701, 0x3fb8, 0x3d01, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_IND(1) }, /* #38/1/3/0x1 = #1895 */
    { 0x087f, 0x3fb8, 0x3d01, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_IND(1) }, /* #38/2/0/m = #1896 */
    { 0x0800, 0x3fb8, 0xb581, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146) }, /* #38/2/0/u = #1897 */
    { 0x0801, 0x3fb8, 0x3d01, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_IND(1) }, /* #38/2/0/0x1 = #1898 */
    { 0x097f, 0x3fb8, 0x3d01, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_IND(1) }, /* #38/2/1/m = #1899 */
    { 0x0900, 0x3fb8, 0xb581, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146) }, /* #38/2/1/u = #1900 */
    { 0x0901, 0x3fb8, 0x3d01, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_IND(1) }, /* #38/2/1/0x1 = #1901 */
    { 0x0a7f, 0x3fb8, 0x3d01, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_IND(1) }, /* #38/2/2/m = #1902 */
    { 0x0a00, 0x3fb8, 0xb581, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146) }, /* #38/2/2/u = #1903 */
    { 0x0a01, 0x3fb8, 0x3d01, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_IND(1) }, /* #38/2/2/0x1 = #1904 */
    { 0x0b7f, 0x3fb8, 0x3d01, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_IND(1) }, /* #38/2/3/m = #1905 */
    { 0x0b00, 0x3fb8, 0xb581, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146) }, /* #38/2/3/u = #1906 */
    { 0x0b01, 0x3fb8, 0x3d01, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_IND(1) }, /* #38/2/3/0x1 = #1907 */
    { 0x0c7f, 0x3fb8, 0x3d01, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_IND(1) }, /* #38/3/0/m = #1908 */
    { 0x0c00, 0x3fb8, 0xb581, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146) }, /* #38/3/0/u = #1909 */
    { 0x0c01, 0x3fb8, 0x3d01, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_IND(1) }, /* #38/3/0/0x1 = #1910 */
    { 0x0d7f, 0x3fb8, 0x3d01, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_IND(1) }, /* #38/3/1/m = #1911 */
    { 0x0d00, 0x3fb8, 0xb581, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146) }, /* #38/3/1/u = #1912 */
    { 0x0d01, 0x3fb8, 0x3d01, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_IND(1) }, /* #38/3/1/0x1 = #1913 */
    { 0x0e7f, 0x3fb8, 0x3d01, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_IND(1) }, /* #38/3/2/m = #1914 */
    { 0x0e00, 0x3fb8, 0xb581, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146) }, /* #38/3/2/u = #1915 */
    { 0x0e01, 0x3fb8, 0x3d01, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_IND(1) }, /* #38/3/2/0x1 = #1916 */
    { 0x0f7f, 0x3fb8, 0x3d01, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_IND(1) }, /* #38/3/3/m = #1917 */
    { 0x0f00, 0x3fb8, 0xb581, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146) }, /* #38/3/3/u = #1918 */
    { 0x0f01, 0x3fb8, 0x3d01, RTFLOAT80U_INIT_C(1,0xbab842cec942613a,32767), RTFLOAT80U_INIT_C(0,0x3567c666db20b862,18146), RTFLOAT80U_INIT_IND(1) }, /* #38/3/3/0x1 = #1919 */
    { 0x007f, 0x0f83, 0x3d01, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0xec50630edf08fa14,32767) }, /* #39/0/0/m = #1920 */
    { 0x0000, 0x0f83, 0xb581, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767) }, /* #39/0/0/u = #1921 */
    { 0x0001, 0x0f83, 0x3d01, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0xec50630edf08fa14,32767) }, /* #39/0/0/0x1 = #1922 */
    { 0x017f, 0x0f83, 0x3d01, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0xec50630edf08fa14,32767) }, /* #39/0/1/m = #1923 */
    { 0x0100, 0x0f83, 0xb581, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767) }, /* #39/0/1/u = #1924 */
    { 0x0101, 0x0f83, 0x3d01, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0xec50630edf08fa14,32767) }, /* #39/0/1/0x1 = #1925 */
    { 0x027f, 0x0f83, 0x3d01, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0xec50630edf08fa14,32767) }, /* #39/0/2/m = #1926 */
    { 0x0200, 0x0f83, 0xb581, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767) }, /* #39/0/2/u = #1927 */
    { 0x0201, 0x0f83, 0x3d01, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0xec50630edf08fa14,32767) }, /* #39/0/2/0x1 = #1928 */
    { 0x037f, 0x0f83, 0x3d01, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0xec50630edf08fa14,32767) }, /* #39/0/3/m = #1929 */
    { 0x0300, 0x0f83, 0xb581, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767) }, /* #39/0/3/u = #1930 */
    { 0x0301, 0x0f83, 0x3d01, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0xec50630edf08fa14,32767) }, /* #39/0/3/0x1 = #1931 */
    { 0x047f, 0x0f83, 0x3d01, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0xec50630edf08fa14,32767) }, /* #39/1/0/m = #1932 */
    { 0x0400, 0x0f83, 0xb581, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767) }, /* #39/1/0/u = #1933 */
    { 0x0401, 0x0f83, 0x3d01, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0xec50630edf08fa14,32767) }, /* #39/1/0/0x1 = #1934 */
    { 0x057f, 0x0f83, 0x3d01, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0xec50630edf08fa14,32767) }, /* #39/1/1/m = #1935 */
    { 0x0500, 0x0f83, 0xb581, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767) }, /* #39/1/1/u = #1936 */
    { 0x0501, 0x0f83, 0x3d01, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0xec50630edf08fa14,32767) }, /* #39/1/1/0x1 = #1937 */
    { 0x067f, 0x0f83, 0x3d01, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0xec50630edf08fa14,32767) }, /* #39/1/2/m = #1938 */
    { 0x0600, 0x0f83, 0xb581, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767) }, /* #39/1/2/u = #1939 */
    { 0x0601, 0x0f83, 0x3d01, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0xec50630edf08fa14,32767) }, /* #39/1/2/0x1 = #1940 */
    { 0x077f, 0x0f83, 0x3d01, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0xec50630edf08fa14,32767) }, /* #39/1/3/m = #1941 */
    { 0x0700, 0x0f83, 0xb581, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767) }, /* #39/1/3/u = #1942 */
    { 0x0701, 0x0f83, 0x3d01, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0xec50630edf08fa14,32767) }, /* #39/1/3/0x1 = #1943 */
    { 0x087f, 0x0f83, 0x3d01, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0xec50630edf08fa14,32767) }, /* #39/2/0/m = #1944 */
    { 0x0800, 0x0f83, 0xb581, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767) }, /* #39/2/0/u = #1945 */
    { 0x0801, 0x0f83, 0x3d01, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0xec50630edf08fa14,32767) }, /* #39/2/0/0x1 = #1946 */
    { 0x097f, 0x0f83, 0x3d01, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0xec50630edf08fa14,32767) }, /* #39/2/1/m = #1947 */
    { 0x0900, 0x0f83, 0xb581, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767) }, /* #39/2/1/u = #1948 */
    { 0x0901, 0x0f83, 0x3d01, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0xec50630edf08fa14,32767) }, /* #39/2/1/0x1 = #1949 */
    { 0x0a7f, 0x0f83, 0x3d01, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0xec50630edf08fa14,32767) }, /* #39/2/2/m = #1950 */
    { 0x0a00, 0x0f83, 0xb581, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767) }, /* #39/2/2/u = #1951 */
    { 0x0a01, 0x0f83, 0x3d01, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0xec50630edf08fa14,32767) }, /* #39/2/2/0x1 = #1952 */
    { 0x0b7f, 0x0f83, 0x3d01, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0xec50630edf08fa14,32767) }, /* #39/2/3/m = #1953 */
    { 0x0b00, 0x0f83, 0xb581, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767) }, /* #39/2/3/u = #1954 */
    { 0x0b01, 0x0f83, 0x3d01, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0xec50630edf08fa14,32767) }, /* #39/2/3/0x1 = #1955 */
    { 0x0c7f, 0x0f83, 0x3d01, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0xec50630edf08fa14,32767) }, /* #39/3/0/m = #1956 */
    { 0x0c00, 0x0f83, 0xb581, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767) }, /* #39/3/0/u = #1957 */
    { 0x0c01, 0x0f83, 0x3d01, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0xec50630edf08fa14,32767) }, /* #39/3/0/0x1 = #1958 */
    { 0x0d7f, 0x0f83, 0x3d01, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0xec50630edf08fa14,32767) }, /* #39/3/1/m = #1959 */
    { 0x0d00, 0x0f83, 0xb581, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767) }, /* #39/3/1/u = #1960 */
    { 0x0d01, 0x0f83, 0x3d01, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0xec50630edf08fa14,32767) }, /* #39/3/1/0x1 = #1961 */
    { 0x0e7f, 0x0f83, 0x3d01, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0xec50630edf08fa14,32767) }, /* #39/3/2/m = #1962 */
    { 0x0e00, 0x0f83, 0xb581, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767) }, /* #39/3/2/u = #1963 */
    { 0x0e01, 0x0f83, 0x3d01, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0xec50630edf08fa14,32767) }, /* #39/3/2/0x1 = #1964 */
    { 0x0f7f, 0x0f83, 0x3d01, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0xec50630edf08fa14,32767) }, /* #39/3/3/m = #1965 */
    { 0x0f00, 0x0f83, 0xb581, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767) }, /* #39/3/3/u = #1966 */
    { 0x0f01, 0x0f83, 0x3d01, RTFLOAT80U_INIT_C(1,0xac50630edf08fa14,32767), RTFLOAT80U_INIT_C(1,0x9ef0cab9bc7c651d,32767), RTFLOAT80U_INIT_C(1,0xec50630edf08fa14,32767) }, /* #39/3/3/0x1 = #1967 */
    { 0x007f, 0x0ca5, 0x3c01, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/0/0/m = #1968 */
    { 0x0000, 0x0ca5, 0xb481, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/0/0/u = #1969 */
    { 0x0001, 0x0ca5, 0x3c01, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/0/0/0x1 = #1970 */
    { 0x017f, 0x0ca5, 0x3c01, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/0/1/m = #1971 */
    { 0x0100, 0x0ca5, 0xb481, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/0/1/u = #1972 */
    { 0x0101, 0x0ca5, 0x3c01, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/0/1/0x1 = #1973 */
    { 0x027f, 0x0ca5, 0x3c01, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/0/2/m = #1974 */
    { 0x0200, 0x0ca5, 0xb481, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/0/2/u = #1975 */
    { 0x0201, 0x0ca5, 0x3c01, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/0/2/0x1 = #1976 */
    { 0x037f, 0x0ca5, 0x3c01, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/0/3/m = #1977 */
    { 0x0300, 0x0ca5, 0xb481, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/0/3/u = #1978 */
    { 0x0301, 0x0ca5, 0x3c01, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/0/3/0x1 = #1979 */
    { 0x047f, 0x0ca5, 0x3c01, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/1/0/m = #1980 */
    { 0x0400, 0x0ca5, 0xb481, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/1/0/u = #1981 */
    { 0x0401, 0x0ca5, 0x3c01, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/1/0/0x1 = #1982 */
    { 0x057f, 0x0ca5, 0x3c01, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/1/1/m = #1983 */
    { 0x0500, 0x0ca5, 0xb481, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/1/1/u = #1984 */
    { 0x0501, 0x0ca5, 0x3c01, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/1/1/0x1 = #1985 */
    { 0x067f, 0x0ca5, 0x3c01, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/1/2/m = #1986 */
    { 0x0600, 0x0ca5, 0xb481, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/1/2/u = #1987 */
    { 0x0601, 0x0ca5, 0x3c01, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/1/2/0x1 = #1988 */
    { 0x077f, 0x0ca5, 0x3c01, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/1/3/m = #1989 */
    { 0x0700, 0x0ca5, 0xb481, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/1/3/u = #1990 */
    { 0x0701, 0x0ca5, 0x3c01, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/1/3/0x1 = #1991 */
    { 0x087f, 0x0ca5, 0x3c01, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/2/0/m = #1992 */
    { 0x0800, 0x0ca5, 0xb481, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/2/0/u = #1993 */
    { 0x0801, 0x0ca5, 0x3c01, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/2/0/0x1 = #1994 */
    { 0x097f, 0x0ca5, 0x3c01, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/2/1/m = #1995 */
    { 0x0900, 0x0ca5, 0xb481, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/2/1/u = #1996 */
    { 0x0901, 0x0ca5, 0x3c01, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/2/1/0x1 = #1997 */
    { 0x0a7f, 0x0ca5, 0x3c01, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/2/2/m = #1998 */
    { 0x0a00, 0x0ca5, 0xb481, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/2/2/u = #1999 */
    { 0x0a01, 0x0ca5, 0x3c01, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/2/2/0x1 = #2000 */
    { 0x0b7f, 0x0ca5, 0x3c01, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/2/3/m = #2001 */
    { 0x0b00, 0x0ca5, 0xb481, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/2/3/u = #2002 */
    { 0x0b01, 0x0ca5, 0x3c01, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/2/3/0x1 = #2003 */
    { 0x0c7f, 0x0ca5, 0x3c01, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/3/0/m = #2004 */
    { 0x0c00, 0x0ca5, 0xb481, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/3/0/u = #2005 */
    { 0x0c01, 0x0ca5, 0x3c01, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/3/0/0x1 = #2006 */
    { 0x0d7f, 0x0ca5, 0x3c01, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/3/1/m = #2007 */
    { 0x0d00, 0x0ca5, 0xb481, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/3/1/u = #2008 */
    { 0x0d01, 0x0ca5, 0x3c01, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/3/1/0x1 = #2009 */
    { 0x0e7f, 0x0ca5, 0x3c01, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/3/2/m = #2010 */
    { 0x0e00, 0x0ca5, 0xb481, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/3/2/u = #2011 */
    { 0x0e01, 0x0ca5, 0x3c01, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/3/2/0x1 = #2012 */
    { 0x0f7f, 0x0ca5, 0x3c01, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/3/3/m = #2013 */
    { 0x0f00, 0x0ca5, 0xb481, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/3/3/u = #2014 */
    { 0x0f01, 0x0ca5, 0x3c01, RTFLOAT80U_INIT_C(1,0x8c73df02e6c68a38,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767), RTFLOAT80U_INIT_C(0,0xda8a7cc7f5fb9541,32767) }, /* #40/3/3/0x1 = #2015 */
    { 0x007f, 0x98e8, 0x3801, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/0/0/m = #2016 */
    { 0x0000, 0x98e8, 0xb081, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767) }, /* #41/0/0/u = #2017 */
    { 0x0001, 0x98e8, 0x3801, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/0/0/0x1 = #2018 */
    { 0x017f, 0x98e8, 0x3801, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/0/1/m = #2019 */
    { 0x0100, 0x98e8, 0xb081, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767) }, /* #41/0/1/u = #2020 */
    { 0x0101, 0x98e8, 0x3801, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/0/1/0x1 = #2021 */
    { 0x027f, 0x98e8, 0x3801, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/0/2/m = #2022 */
    { 0x0200, 0x98e8, 0xb081, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767) }, /* #41/0/2/u = #2023 */
    { 0x0201, 0x98e8, 0x3801, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/0/2/0x1 = #2024 */
    { 0x037f, 0x98e8, 0x3801, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/0/3/m = #2025 */
    { 0x0300, 0x98e8, 0xb081, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767) }, /* #41/0/3/u = #2026 */
    { 0x0301, 0x98e8, 0x3801, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/0/3/0x1 = #2027 */
    { 0x047f, 0x98e8, 0x3801, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/1/0/m = #2028 */
    { 0x0400, 0x98e8, 0xb081, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767) }, /* #41/1/0/u = #2029 */
    { 0x0401, 0x98e8, 0x3801, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/1/0/0x1 = #2030 */
    { 0x057f, 0x98e8, 0x3801, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/1/1/m = #2031 */
    { 0x0500, 0x98e8, 0xb081, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767) }, /* #41/1/1/u = #2032 */
    { 0x0501, 0x98e8, 0x3801, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/1/1/0x1 = #2033 */
    { 0x067f, 0x98e8, 0x3801, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/1/2/m = #2034 */
    { 0x0600, 0x98e8, 0xb081, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767) }, /* #41/1/2/u = #2035 */
    { 0x0601, 0x98e8, 0x3801, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/1/2/0x1 = #2036 */
    { 0x077f, 0x98e8, 0x3801, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/1/3/m = #2037 */
    { 0x0700, 0x98e8, 0xb081, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767) }, /* #41/1/3/u = #2038 */
    { 0x0701, 0x98e8, 0x3801, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/1/3/0x1 = #2039 */
    { 0x087f, 0x98e8, 0x3801, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/2/0/m = #2040 */
    { 0x0800, 0x98e8, 0xb081, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767) }, /* #41/2/0/u = #2041 */
    { 0x0801, 0x98e8, 0x3801, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/2/0/0x1 = #2042 */
    { 0x097f, 0x98e8, 0x3801, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/2/1/m = #2043 */
    { 0x0900, 0x98e8, 0xb081, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767) }, /* #41/2/1/u = #2044 */
    { 0x0901, 0x98e8, 0x3801, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/2/1/0x1 = #2045 */
    { 0x0a7f, 0x98e8, 0x3801, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/2/2/m = #2046 */
    { 0x0a00, 0x98e8, 0xb081, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767) }, /* #41/2/2/u = #2047 */
    { 0x0a01, 0x98e8, 0x3801, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/2/2/0x1 = #2048 */
    { 0x0b7f, 0x98e8, 0x3801, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/2/3/m = #2049 */
    { 0x0b00, 0x98e8, 0xb081, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767) }, /* #41/2/3/u = #2050 */
    { 0x0b01, 0x98e8, 0x3801, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/2/3/0x1 = #2051 */
    { 0x0c7f, 0x98e8, 0x3801, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/3/0/m = #2052 */
    { 0x0c00, 0x98e8, 0xb081, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767) }, /* #41/3/0/u = #2053 */
    { 0x0c01, 0x98e8, 0x3801, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/3/0/0x1 = #2054 */
    { 0x0d7f, 0x98e8, 0x3801, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/3/1/m = #2055 */
    { 0x0d00, 0x98e8, 0xb081, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767) }, /* #41/3/1/u = #2056 */
    { 0x0d01, 0x98e8, 0x3801, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/3/1/0x1 = #2057 */
    { 0x0e7f, 0x98e8, 0x3801, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/3/2/m = #2058 */
    { 0x0e00, 0x98e8, 0xb081, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767) }, /* #41/3/2/u = #2059 */
    { 0x0e01, 0x98e8, 0x3801, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/3/2/0x1 = #2060 */
    { 0x0f7f, 0x98e8, 0x3801, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/3/3/m = #2061 */
    { 0x0f00, 0x98e8, 0xb081, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767) }, /* #41/3/3/u = #2062 */
    { 0x0f01, 0x98e8, 0x3801, RTFLOAT80U_INIT_C(0,0xa62ae33292ea9629,32767), RTFLOAT80U_INIT_C(0,0x36dbc591b81203d3,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/3/3/0x1 = #2063 */
    { 0x007f, 0xf1dd, 0x7901, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0xfdfc8b43fe48c79e,32767) }, /* #42/0/0/m = #2064 */
    { 0x0000, 0xf1dd, 0xf181, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0) }, /* #42/0/0/u = #2065 */
    { 0x0001, 0xf1dd, 0x7901, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0xfdfc8b43fe48c79e,32767) }, /* #42/0/0/0x1 = #2066 */
    { 0x017f, 0xf1dd, 0x7901, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0xfdfc8b43fe48c79e,32767) }, /* #42/0/1/m = #2067 */
    { 0x0100, 0xf1dd, 0xf181, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0) }, /* #42/0/1/u = #2068 */
    { 0x0101, 0xf1dd, 0x7901, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0xfdfc8b43fe48c79e,32767) }, /* #42/0/1/0x1 = #2069 */
    { 0x027f, 0xf1dd, 0x7901, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0xfdfc8b43fe48c79e,32767) }, /* #42/0/2/m = #2070 */
    { 0x0200, 0xf1dd, 0xf181, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0) }, /* #42/0/2/u = #2071 */
    { 0x0201, 0xf1dd, 0x7901, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0xfdfc8b43fe48c79e,32767) }, /* #42/0/2/0x1 = #2072 */
    { 0x037f, 0xf1dd, 0x7901, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0xfdfc8b43fe48c79e,32767) }, /* #42/0/3/m = #2073 */
    { 0x0300, 0xf1dd, 0xf181, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0) }, /* #42/0/3/u = #2074 */
    { 0x0301, 0xf1dd, 0x7901, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0xfdfc8b43fe48c79e,32767) }, /* #42/0/3/0x1 = #2075 */
    { 0x047f, 0xf1dd, 0x7901, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0xfdfc8b43fe48c79e,32767) }, /* #42/1/0/m = #2076 */
    { 0x0400, 0xf1dd, 0xf181, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0) }, /* #42/1/0/u = #2077 */
    { 0x0401, 0xf1dd, 0x7901, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0xfdfc8b43fe48c79e,32767) }, /* #42/1/0/0x1 = #2078 */
    { 0x057f, 0xf1dd, 0x7901, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0xfdfc8b43fe48c79e,32767) }, /* #42/1/1/m = #2079 */
    { 0x0500, 0xf1dd, 0xf181, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0) }, /* #42/1/1/u = #2080 */
    { 0x0501, 0xf1dd, 0x7901, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0xfdfc8b43fe48c79e,32767) }, /* #42/1/1/0x1 = #2081 */
    { 0x067f, 0xf1dd, 0x7901, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0xfdfc8b43fe48c79e,32767) }, /* #42/1/2/m = #2082 */
    { 0x0600, 0xf1dd, 0xf181, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0) }, /* #42/1/2/u = #2083 */
    { 0x0601, 0xf1dd, 0x7901, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0xfdfc8b43fe48c79e,32767) }, /* #42/1/2/0x1 = #2084 */
    { 0x077f, 0xf1dd, 0x7901, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0xfdfc8b43fe48c79e,32767) }, /* #42/1/3/m = #2085 */
    { 0x0700, 0xf1dd, 0xf181, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0) }, /* #42/1/3/u = #2086 */
    { 0x0701, 0xf1dd, 0x7901, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0xfdfc8b43fe48c79e,32767) }, /* #42/1/3/0x1 = #2087 */
    { 0x087f, 0xf1dd, 0x7901, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0xfdfc8b43fe48c79e,32767) }, /* #42/2/0/m = #2088 */
    { 0x0800, 0xf1dd, 0xf181, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0) }, /* #42/2/0/u = #2089 */
    { 0x0801, 0xf1dd, 0x7901, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0xfdfc8b43fe48c79e,32767) }, /* #42/2/0/0x1 = #2090 */
    { 0x097f, 0xf1dd, 0x7901, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0xfdfc8b43fe48c79e,32767) }, /* #42/2/1/m = #2091 */
    { 0x0900, 0xf1dd, 0xf181, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0) }, /* #42/2/1/u = #2092 */
    { 0x0901, 0xf1dd, 0x7901, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0xfdfc8b43fe48c79e,32767) }, /* #42/2/1/0x1 = #2093 */
    { 0x0a7f, 0xf1dd, 0x7901, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0xfdfc8b43fe48c79e,32767) }, /* #42/2/2/m = #2094 */
    { 0x0a00, 0xf1dd, 0xf181, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0) }, /* #42/2/2/u = #2095 */
    { 0x0a01, 0xf1dd, 0x7901, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0xfdfc8b43fe48c79e,32767) }, /* #42/2/2/0x1 = #2096 */
    { 0x0b7f, 0xf1dd, 0x7901, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0xfdfc8b43fe48c79e,32767) }, /* #42/2/3/m = #2097 */
    { 0x0b00, 0xf1dd, 0xf181, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0) }, /* #42/2/3/u = #2098 */
    { 0x0b01, 0xf1dd, 0x7901, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0xfdfc8b43fe48c79e,32767) }, /* #42/2/3/0x1 = #2099 */
    { 0x0c7f, 0xf1dd, 0x7901, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0xfdfc8b43fe48c79e,32767) }, /* #42/3/0/m = #2100 */
    { 0x0c00, 0xf1dd, 0xf181, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0) }, /* #42/3/0/u = #2101 */
    { 0x0c01, 0xf1dd, 0x7901, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0xfdfc8b43fe48c79e,32767) }, /* #42/3/0/0x1 = #2102 */
    { 0x0d7f, 0xf1dd, 0x7901, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0xfdfc8b43fe48c79e,32767) }, /* #42/3/1/m = #2103 */
    { 0x0d00, 0xf1dd, 0xf181, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0) }, /* #42/3/1/u = #2104 */
    { 0x0d01, 0xf1dd, 0x7901, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0xfdfc8b43fe48c79e,32767) }, /* #42/3/1/0x1 = #2105 */
    { 0x0e7f, 0xf1dd, 0x7901, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0xfdfc8b43fe48c79e,32767) }, /* #42/3/2/m = #2106 */
    { 0x0e00, 0xf1dd, 0xf181, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0) }, /* #42/3/2/u = #2107 */
    { 0x0e01, 0xf1dd, 0x7901, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0xfdfc8b43fe48c79e,32767) }, /* #42/3/2/0x1 = #2108 */
    { 0x0f7f, 0xf1dd, 0x7901, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0xfdfc8b43fe48c79e,32767) }, /* #42/3/3/m = #2109 */
    { 0x0f00, 0xf1dd, 0xf181, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0) }, /* #42/3/3/u = #2110 */
    { 0x0f01, 0xf1dd, 0x7901, RTFLOAT80U_INIT_C(0,0xbdfc8b43fe48c79e,32767), RTFLOAT80U_INIT_C(0,0x860ea783578d5b3f,0), RTFLOAT80U_INIT_C(0,0xfdfc8b43fe48c79e,32767) }, /* #42/3/3/0x1 = #2111 */
    { 0x007f, 0xbc01, 0x3c01, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(0,0xcee43975bb45a1ba,32767) }, /* #43/0/0/m = #2112 */
    { 0x0000, 0xbc01, 0xb481, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0) }, /* #43/0/0/u = #2113 */
    { 0x0001, 0xbc01, 0x3c01, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(0,0xcee43975bb45a1ba,32767) }, /* #43/0/0/0x1 = #2114 */
    { 0x017f, 0xbc01, 0x3c01, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(0,0xcee43975bb45a1ba,32767) }, /* #43/0/1/m = #2115 */
    { 0x0100, 0xbc01, 0xb481, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0) }, /* #43/0/1/u = #2116 */
    { 0x0101, 0xbc01, 0x3c01, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(0,0xcee43975bb45a1ba,32767) }, /* #43/0/1/0x1 = #2117 */
    { 0x027f, 0xbc01, 0x3c01, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(0,0xcee43975bb45a1ba,32767) }, /* #43/0/2/m = #2118 */
    { 0x0200, 0xbc01, 0xb481, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0) }, /* #43/0/2/u = #2119 */
    { 0x0201, 0xbc01, 0x3c01, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(0,0xcee43975bb45a1ba,32767) }, /* #43/0/2/0x1 = #2120 */
    { 0x037f, 0xbc01, 0x3c01, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(0,0xcee43975bb45a1ba,32767) }, /* #43/0/3/m = #2121 */
    { 0x0300, 0xbc01, 0xb481, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0) }, /* #43/0/3/u = #2122 */
    { 0x0301, 0xbc01, 0x3c01, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(0,0xcee43975bb45a1ba,32767) }, /* #43/0/3/0x1 = #2123 */
    { 0x047f, 0xbc01, 0x3c01, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(0,0xcee43975bb45a1ba,32767) }, /* #43/1/0/m = #2124 */
    { 0x0400, 0xbc01, 0xb481, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0) }, /* #43/1/0/u = #2125 */
    { 0x0401, 0xbc01, 0x3c01, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(0,0xcee43975bb45a1ba,32767) }, /* #43/1/0/0x1 = #2126 */
    { 0x057f, 0xbc01, 0x3c01, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(0,0xcee43975bb45a1ba,32767) }, /* #43/1/1/m = #2127 */
    { 0x0500, 0xbc01, 0xb481, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0) }, /* #43/1/1/u = #2128 */
    { 0x0501, 0xbc01, 0x3c01, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(0,0xcee43975bb45a1ba,32767) }, /* #43/1/1/0x1 = #2129 */
    { 0x067f, 0xbc01, 0x3c01, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(0,0xcee43975bb45a1ba,32767) }, /* #43/1/2/m = #2130 */
    { 0x0600, 0xbc01, 0xb481, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0) }, /* #43/1/2/u = #2131 */
    { 0x0601, 0xbc01, 0x3c01, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(0,0xcee43975bb45a1ba,32767) }, /* #43/1/2/0x1 = #2132 */
    { 0x077f, 0xbc01, 0x3c01, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(0,0xcee43975bb45a1ba,32767) }, /* #43/1/3/m = #2133 */
    { 0x0700, 0xbc01, 0xb481, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0) }, /* #43/1/3/u = #2134 */
    { 0x0701, 0xbc01, 0x3c01, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(0,0xcee43975bb45a1ba,32767) }, /* #43/1/3/0x1 = #2135 */
    { 0x087f, 0xbc01, 0x3c01, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(0,0xcee43975bb45a1ba,32767) }, /* #43/2/0/m = #2136 */
    { 0x0800, 0xbc01, 0xb481, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0) }, /* #43/2/0/u = #2137 */
    { 0x0801, 0xbc01, 0x3c01, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(0,0xcee43975bb45a1ba,32767) }, /* #43/2/0/0x1 = #2138 */
    { 0x097f, 0xbc01, 0x3c01, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(0,0xcee43975bb45a1ba,32767) }, /* #43/2/1/m = #2139 */
    { 0x0900, 0xbc01, 0xb481, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0) }, /* #43/2/1/u = #2140 */
    { 0x0901, 0xbc01, 0x3c01, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(0,0xcee43975bb45a1ba,32767) }, /* #43/2/1/0x1 = #2141 */
    { 0x0a7f, 0xbc01, 0x3c01, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(0,0xcee43975bb45a1ba,32767) }, /* #43/2/2/m = #2142 */
    { 0x0a00, 0xbc01, 0xb481, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0) }, /* #43/2/2/u = #2143 */
    { 0x0a01, 0xbc01, 0x3c01, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(0,0xcee43975bb45a1ba,32767) }, /* #43/2/2/0x1 = #2144 */
    { 0x0b7f, 0xbc01, 0x3c01, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(0,0xcee43975bb45a1ba,32767) }, /* #43/2/3/m = #2145 */
    { 0x0b00, 0xbc01, 0xb481, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0) }, /* #43/2/3/u = #2146 */
    { 0x0b01, 0xbc01, 0x3c01, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(0,0xcee43975bb45a1ba,32767) }, /* #43/2/3/0x1 = #2147 */
    { 0x0c7f, 0xbc01, 0x3c01, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(0,0xcee43975bb45a1ba,32767) }, /* #43/3/0/m = #2148 */
    { 0x0c00, 0xbc01, 0xb481, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0) }, /* #43/3/0/u = #2149 */
    { 0x0c01, 0xbc01, 0x3c01, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(0,0xcee43975bb45a1ba,32767) }, /* #43/3/0/0x1 = #2150 */
    { 0x0d7f, 0xbc01, 0x3c01, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(0,0xcee43975bb45a1ba,32767) }, /* #43/3/1/m = #2151 */
    { 0x0d00, 0xbc01, 0xb481, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0) }, /* #43/3/1/u = #2152 */
    { 0x0d01, 0xbc01, 0x3c01, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(0,0xcee43975bb45a1ba,32767) }, /* #43/3/1/0x1 = #2153 */
    { 0x0e7f, 0xbc01, 0x3c01, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(0,0xcee43975bb45a1ba,32767) }, /* #43/3/2/m = #2154 */
    { 0x0e00, 0xbc01, 0xb481, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0) }, /* #43/3/2/u = #2155 */
    { 0x0e01, 0xbc01, 0x3c01, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(0,0xcee43975bb45a1ba,32767) }, /* #43/3/2/0x1 = #2156 */
    { 0x0f7f, 0xbc01, 0x3c01, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(0,0xcee43975bb45a1ba,32767) }, /* #43/3/3/m = #2157 */
    { 0x0f00, 0xbc01, 0xb481, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0) }, /* #43/3/3/u = #2158 */
    { 0x0f01, 0xbc01, 0x3c01, RTFLOAT80U_INIT_C(0,0x8ee43975bb45a1ba,32767), RTFLOAT80U_INIT_C(1,0x245b164bba60ea28,0), RTFLOAT80U_INIT_C(0,0xcee43975bb45a1ba,32767) }, /* #43/3/3/0x1 = #2159 */
    { 0x007f, 0x11b4, 0x3901, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/0/0/m = #2160 */
    { 0x0000, 0x11b4, 0xb181, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/0/0/u = #2161 */
    { 0x0001, 0x11b4, 0x3901, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/0/0/0x1 = #2162 */
    { 0x017f, 0x11b4, 0x3901, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/0/1/m = #2163 */
    { 0x0100, 0x11b4, 0xb181, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/0/1/u = #2164 */
    { 0x0101, 0x11b4, 0x3901, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/0/1/0x1 = #2165 */
    { 0x027f, 0x11b4, 0x3901, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/0/2/m = #2166 */
    { 0x0200, 0x11b4, 0xb181, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/0/2/u = #2167 */
    { 0x0201, 0x11b4, 0x3901, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/0/2/0x1 = #2168 */
    { 0x037f, 0x11b4, 0x3901, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/0/3/m = #2169 */
    { 0x0300, 0x11b4, 0xb181, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/0/3/u = #2170 */
    { 0x0301, 0x11b4, 0x3901, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/0/3/0x1 = #2171 */
    { 0x047f, 0x11b4, 0x3901, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/1/0/m = #2172 */
    { 0x0400, 0x11b4, 0xb181, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/1/0/u = #2173 */
    { 0x0401, 0x11b4, 0x3901, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/1/0/0x1 = #2174 */
    { 0x057f, 0x11b4, 0x3901, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/1/1/m = #2175 */
    { 0x0500, 0x11b4, 0xb181, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/1/1/u = #2176 */
    { 0x0501, 0x11b4, 0x3901, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/1/1/0x1 = #2177 */
    { 0x067f, 0x11b4, 0x3901, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/1/2/m = #2178 */
    { 0x0600, 0x11b4, 0xb181, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/1/2/u = #2179 */
    { 0x0601, 0x11b4, 0x3901, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/1/2/0x1 = #2180 */
    { 0x077f, 0x11b4, 0x3901, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/1/3/m = #2181 */
    { 0x0700, 0x11b4, 0xb181, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/1/3/u = #2182 */
    { 0x0701, 0x11b4, 0x3901, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/1/3/0x1 = #2183 */
    { 0x087f, 0x11b4, 0x3901, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/2/0/m = #2184 */
    { 0x0800, 0x11b4, 0xb181, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/2/0/u = #2185 */
    { 0x0801, 0x11b4, 0x3901, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/2/0/0x1 = #2186 */
    { 0x097f, 0x11b4, 0x3901, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/2/1/m = #2187 */
    { 0x0900, 0x11b4, 0xb181, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/2/1/u = #2188 */
    { 0x0901, 0x11b4, 0x3901, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/2/1/0x1 = #2189 */
    { 0x0a7f, 0x11b4, 0x3901, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/2/2/m = #2190 */
    { 0x0a00, 0x11b4, 0xb181, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/2/2/u = #2191 */
    { 0x0a01, 0x11b4, 0x3901, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/2/2/0x1 = #2192 */
    { 0x0b7f, 0x11b4, 0x3901, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/2/3/m = #2193 */
    { 0x0b00, 0x11b4, 0xb181, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/2/3/u = #2194 */
    { 0x0b01, 0x11b4, 0x3901, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/2/3/0x1 = #2195 */
    { 0x0c7f, 0x11b4, 0x3901, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/3/0/m = #2196 */
    { 0x0c00, 0x11b4, 0xb181, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/3/0/u = #2197 */
    { 0x0c01, 0x11b4, 0x3901, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/3/0/0x1 = #2198 */
    { 0x0d7f, 0x11b4, 0x3901, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/3/1/m = #2199 */
    { 0x0d00, 0x11b4, 0xb181, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/3/1/u = #2200 */
    { 0x0d01, 0x11b4, 0x3901, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/3/1/0x1 = #2201 */
    { 0x0e7f, 0x11b4, 0x3901, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/3/2/m = #2202 */
    { 0x0e00, 0x11b4, 0xb181, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/3/2/u = #2203 */
    { 0x0e01, 0x11b4, 0x3901, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/3/2/0x1 = #2204 */
    { 0x0f7f, 0x11b4, 0x3901, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/3/3/m = #2205 */
    { 0x0f00, 0x11b4, 0xb181, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/3/3/u = #2206 */
    { 0x0f01, 0x11b4, 0x3901, RTFLOAT80U_INIT_C(0,0xaefa2e3fad36cbe1,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/3/3/0x1 = #2207 */
    { 0x007f, 0x9423, 0x3c01, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xdf20ec5a0a5cbd23,32767) }, /* #45/0/0/m = #2208 */
    { 0x0000, 0x9423, 0xb481, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #45/0/0/u = #2209 */
    { 0x0001, 0x9423, 0x3c01, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xdf20ec5a0a5cbd23,32767) }, /* #45/0/0/0x1 = #2210 */
    { 0x017f, 0x9423, 0x3c01, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xdf20ec5a0a5cbd23,32767) }, /* #45/0/1/m = #2211 */
    { 0x0100, 0x9423, 0xb481, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #45/0/1/u = #2212 */
    { 0x0101, 0x9423, 0x3c01, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xdf20ec5a0a5cbd23,32767) }, /* #45/0/1/0x1 = #2213 */
    { 0x027f, 0x9423, 0x3c01, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xdf20ec5a0a5cbd23,32767) }, /* #45/0/2/m = #2214 */
    { 0x0200, 0x9423, 0xb481, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #45/0/2/u = #2215 */
    { 0x0201, 0x9423, 0x3c01, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xdf20ec5a0a5cbd23,32767) }, /* #45/0/2/0x1 = #2216 */
    { 0x037f, 0x9423, 0x3c01, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xdf20ec5a0a5cbd23,32767) }, /* #45/0/3/m = #2217 */
    { 0x0300, 0x9423, 0xb481, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #45/0/3/u = #2218 */
    { 0x0301, 0x9423, 0x3c01, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xdf20ec5a0a5cbd23,32767) }, /* #45/0/3/0x1 = #2219 */
    { 0x047f, 0x9423, 0x3c01, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xdf20ec5a0a5cbd23,32767) }, /* #45/1/0/m = #2220 */
    { 0x0400, 0x9423, 0xb481, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #45/1/0/u = #2221 */
    { 0x0401, 0x9423, 0x3c01, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xdf20ec5a0a5cbd23,32767) }, /* #45/1/0/0x1 = #2222 */
    { 0x057f, 0x9423, 0x3c01, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xdf20ec5a0a5cbd23,32767) }, /* #45/1/1/m = #2223 */
    { 0x0500, 0x9423, 0xb481, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #45/1/1/u = #2224 */
    { 0x0501, 0x9423, 0x3c01, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xdf20ec5a0a5cbd23,32767) }, /* #45/1/1/0x1 = #2225 */
    { 0x067f, 0x9423, 0x3c01, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xdf20ec5a0a5cbd23,32767) }, /* #45/1/2/m = #2226 */
    { 0x0600, 0x9423, 0xb481, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #45/1/2/u = #2227 */
    { 0x0601, 0x9423, 0x3c01, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xdf20ec5a0a5cbd23,32767) }, /* #45/1/2/0x1 = #2228 */
    { 0x077f, 0x9423, 0x3c01, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xdf20ec5a0a5cbd23,32767) }, /* #45/1/3/m = #2229 */
    { 0x0700, 0x9423, 0xb481, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #45/1/3/u = #2230 */
    { 0x0701, 0x9423, 0x3c01, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xdf20ec5a0a5cbd23,32767) }, /* #45/1/3/0x1 = #2231 */
    { 0x087f, 0x9423, 0x3c01, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xdf20ec5a0a5cbd23,32767) }, /* #45/2/0/m = #2232 */
    { 0x0800, 0x9423, 0xb481, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #45/2/0/u = #2233 */
    { 0x0801, 0x9423, 0x3c01, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xdf20ec5a0a5cbd23,32767) }, /* #45/2/0/0x1 = #2234 */
    { 0x097f, 0x9423, 0x3c01, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xdf20ec5a0a5cbd23,32767) }, /* #45/2/1/m = #2235 */
    { 0x0900, 0x9423, 0xb481, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #45/2/1/u = #2236 */
    { 0x0901, 0x9423, 0x3c01, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xdf20ec5a0a5cbd23,32767) }, /* #45/2/1/0x1 = #2237 */
    { 0x0a7f, 0x9423, 0x3c01, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xdf20ec5a0a5cbd23,32767) }, /* #45/2/2/m = #2238 */
    { 0x0a00, 0x9423, 0xb481, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #45/2/2/u = #2239 */
    { 0x0a01, 0x9423, 0x3c01, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xdf20ec5a0a5cbd23,32767) }, /* #45/2/2/0x1 = #2240 */
    { 0x0b7f, 0x9423, 0x3c01, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xdf20ec5a0a5cbd23,32767) }, /* #45/2/3/m = #2241 */
    { 0x0b00, 0x9423, 0xb481, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #45/2/3/u = #2242 */
    { 0x0b01, 0x9423, 0x3c01, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xdf20ec5a0a5cbd23,32767) }, /* #45/2/3/0x1 = #2243 */
    { 0x0c7f, 0x9423, 0x3c01, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xdf20ec5a0a5cbd23,32767) }, /* #45/3/0/m = #2244 */
    { 0x0c00, 0x9423, 0xb481, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #45/3/0/u = #2245 */
    { 0x0c01, 0x9423, 0x3c01, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xdf20ec5a0a5cbd23,32767) }, /* #45/3/0/0x1 = #2246 */
    { 0x0d7f, 0x9423, 0x3c01, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xdf20ec5a0a5cbd23,32767) }, /* #45/3/1/m = #2247 */
    { 0x0d00, 0x9423, 0xb481, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #45/3/1/u = #2248 */
    { 0x0d01, 0x9423, 0x3c01, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xdf20ec5a0a5cbd23,32767) }, /* #45/3/1/0x1 = #2249 */
    { 0x0e7f, 0x9423, 0x3c01, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xdf20ec5a0a5cbd23,32767) }, /* #45/3/2/m = #2250 */
    { 0x0e00, 0x9423, 0xb481, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #45/3/2/u = #2251 */
    { 0x0e01, 0x9423, 0x3c01, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xdf20ec5a0a5cbd23,32767) }, /* #45/3/2/0x1 = #2252 */
    { 0x0f7f, 0x9423, 0x3c01, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xdf20ec5a0a5cbd23,32767) }, /* #45/3/3/m = #2253 */
    { 0x0f00, 0x9423, 0xb481, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #45/3/3/u = #2254 */
    { 0x0f01, 0x9423, 0x3c01, RTFLOAT80U_INIT_C(0,0x9f20ec5a0a5cbd23,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xdf20ec5a0a5cbd23,32767) }, /* #45/3/3/0x1 = #2255 */
    { 0x007f, 0xbd88, 0x3d01, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/0/0/m = #2256 */
    { 0x0000, 0xbd88, 0xb581, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #46/0/0/u = #2257 */
    { 0x0001, 0xbd88, 0x3d01, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/0/0/0x1 = #2258 */
    { 0x017f, 0xbd88, 0x3d01, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/0/1/m = #2259 */
    { 0x0100, 0xbd88, 0xb581, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #46/0/1/u = #2260 */
    { 0x0101, 0xbd88, 0x3d01, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/0/1/0x1 = #2261 */
    { 0x027f, 0xbd88, 0x3d01, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/0/2/m = #2262 */
    { 0x0200, 0xbd88, 0xb581, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #46/0/2/u = #2263 */
    { 0x0201, 0xbd88, 0x3d01, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/0/2/0x1 = #2264 */
    { 0x037f, 0xbd88, 0x3d01, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/0/3/m = #2265 */
    { 0x0300, 0xbd88, 0xb581, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #46/0/3/u = #2266 */
    { 0x0301, 0xbd88, 0x3d01, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/0/3/0x1 = #2267 */
    { 0x047f, 0xbd88, 0x3d01, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/1/0/m = #2268 */
    { 0x0400, 0xbd88, 0xb581, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #46/1/0/u = #2269 */
    { 0x0401, 0xbd88, 0x3d01, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/1/0/0x1 = #2270 */
    { 0x057f, 0xbd88, 0x3d01, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/1/1/m = #2271 */
    { 0x0500, 0xbd88, 0xb581, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #46/1/1/u = #2272 */
    { 0x0501, 0xbd88, 0x3d01, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/1/1/0x1 = #2273 */
    { 0x067f, 0xbd88, 0x3d01, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/1/2/m = #2274 */
    { 0x0600, 0xbd88, 0xb581, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #46/1/2/u = #2275 */
    { 0x0601, 0xbd88, 0x3d01, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/1/2/0x1 = #2276 */
    { 0x077f, 0xbd88, 0x3d01, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/1/3/m = #2277 */
    { 0x0700, 0xbd88, 0xb581, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #46/1/3/u = #2278 */
    { 0x0701, 0xbd88, 0x3d01, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/1/3/0x1 = #2279 */
    { 0x087f, 0xbd88, 0x3d01, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/2/0/m = #2280 */
    { 0x0800, 0xbd88, 0xb581, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #46/2/0/u = #2281 */
    { 0x0801, 0xbd88, 0x3d01, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/2/0/0x1 = #2282 */
    { 0x097f, 0xbd88, 0x3d01, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/2/1/m = #2283 */
    { 0x0900, 0xbd88, 0xb581, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #46/2/1/u = #2284 */
    { 0x0901, 0xbd88, 0x3d01, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/2/1/0x1 = #2285 */
    { 0x0a7f, 0xbd88, 0x3d01, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/2/2/m = #2286 */
    { 0x0a00, 0xbd88, 0xb581, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #46/2/2/u = #2287 */
    { 0x0a01, 0xbd88, 0x3d01, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/2/2/0x1 = #2288 */
    { 0x0b7f, 0xbd88, 0x3d01, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/2/3/m = #2289 */
    { 0x0b00, 0xbd88, 0xb581, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #46/2/3/u = #2290 */
    { 0x0b01, 0xbd88, 0x3d01, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/2/3/0x1 = #2291 */
    { 0x0c7f, 0xbd88, 0x3d01, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/3/0/m = #2292 */
    { 0x0c00, 0xbd88, 0xb581, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #46/3/0/u = #2293 */
    { 0x0c01, 0xbd88, 0x3d01, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/3/0/0x1 = #2294 */
    { 0x0d7f, 0xbd88, 0x3d01, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/3/1/m = #2295 */
    { 0x0d00, 0xbd88, 0xb581, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #46/3/1/u = #2296 */
    { 0x0d01, 0xbd88, 0x3d01, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/3/1/0x1 = #2297 */
    { 0x0e7f, 0xbd88, 0x3d01, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/3/2/m = #2298 */
    { 0x0e00, 0xbd88, 0xb581, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #46/3/2/u = #2299 */
    { 0x0e01, 0xbd88, 0x3d01, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/3/2/0x1 = #2300 */
    { 0x0f7f, 0xbd88, 0x3d01, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/3/3/m = #2301 */
    { 0x0f00, 0xbd88, 0xb581, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #46/3/3/u = #2302 */
    { 0x0f01, 0xbd88, 0x3d01, RTFLOAT80U_INIT_C(1,0xaaaa075ee31c1500,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/3/3/0x1 = #2303 */
    { 0x007f, 0xe09a, 0x7801, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xdbec98be2c34e0d5,32767) }, /* #47/0/0/m = #2304 */
    { 0x0000, 0xe09a, 0xf081, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(0) }, /* #47/0/0/u = #2305 */
    { 0x0001, 0xe09a, 0x7801, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xdbec98be2c34e0d5,32767) }, /* #47/0/0/0x1 = #2306 */
    { 0x017f, 0xe09a, 0x7801, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xdbec98be2c34e0d5,32767) }, /* #47/0/1/m = #2307 */
    { 0x0100, 0xe09a, 0xf081, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(0) }, /* #47/0/1/u = #2308 */
    { 0x0101, 0xe09a, 0x7801, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xdbec98be2c34e0d5,32767) }, /* #47/0/1/0x1 = #2309 */
    { 0x027f, 0xe09a, 0x7801, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xdbec98be2c34e0d5,32767) }, /* #47/0/2/m = #2310 */
    { 0x0200, 0xe09a, 0xf081, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(0) }, /* #47/0/2/u = #2311 */
    { 0x0201, 0xe09a, 0x7801, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xdbec98be2c34e0d5,32767) }, /* #47/0/2/0x1 = #2312 */
    { 0x037f, 0xe09a, 0x7801, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xdbec98be2c34e0d5,32767) }, /* #47/0/3/m = #2313 */
    { 0x0300, 0xe09a, 0xf081, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(0) }, /* #47/0/3/u = #2314 */
    { 0x0301, 0xe09a, 0x7801, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xdbec98be2c34e0d5,32767) }, /* #47/0/3/0x1 = #2315 */
    { 0x047f, 0xe09a, 0x7801, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xdbec98be2c34e0d5,32767) }, /* #47/1/0/m = #2316 */
    { 0x0400, 0xe09a, 0xf081, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(0) }, /* #47/1/0/u = #2317 */
    { 0x0401, 0xe09a, 0x7801, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xdbec98be2c34e0d5,32767) }, /* #47/1/0/0x1 = #2318 */
    { 0x057f, 0xe09a, 0x7801, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xdbec98be2c34e0d5,32767) }, /* #47/1/1/m = #2319 */
    { 0x0500, 0xe09a, 0xf081, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(0) }, /* #47/1/1/u = #2320 */
    { 0x0501, 0xe09a, 0x7801, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xdbec98be2c34e0d5,32767) }, /* #47/1/1/0x1 = #2321 */
    { 0x067f, 0xe09a, 0x7801, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xdbec98be2c34e0d5,32767) }, /* #47/1/2/m = #2322 */
    { 0x0600, 0xe09a, 0xf081, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(0) }, /* #47/1/2/u = #2323 */
    { 0x0601, 0xe09a, 0x7801, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xdbec98be2c34e0d5,32767) }, /* #47/1/2/0x1 = #2324 */
    { 0x077f, 0xe09a, 0x7801, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xdbec98be2c34e0d5,32767) }, /* #47/1/3/m = #2325 */
    { 0x0700, 0xe09a, 0xf081, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(0) }, /* #47/1/3/u = #2326 */
    { 0x0701, 0xe09a, 0x7801, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xdbec98be2c34e0d5,32767) }, /* #47/1/3/0x1 = #2327 */
    { 0x087f, 0xe09a, 0x7801, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xdbec98be2c34e0d5,32767) }, /* #47/2/0/m = #2328 */
    { 0x0800, 0xe09a, 0xf081, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(0) }, /* #47/2/0/u = #2329 */
    { 0x0801, 0xe09a, 0x7801, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xdbec98be2c34e0d5,32767) }, /* #47/2/0/0x1 = #2330 */
    { 0x097f, 0xe09a, 0x7801, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xdbec98be2c34e0d5,32767) }, /* #47/2/1/m = #2331 */
    { 0x0900, 0xe09a, 0xf081, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(0) }, /* #47/2/1/u = #2332 */
    { 0x0901, 0xe09a, 0x7801, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xdbec98be2c34e0d5,32767) }, /* #47/2/1/0x1 = #2333 */
    { 0x0a7f, 0xe09a, 0x7801, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xdbec98be2c34e0d5,32767) }, /* #47/2/2/m = #2334 */
    { 0x0a00, 0xe09a, 0xf081, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(0) }, /* #47/2/2/u = #2335 */
    { 0x0a01, 0xe09a, 0x7801, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xdbec98be2c34e0d5,32767) }, /* #47/2/2/0x1 = #2336 */
    { 0x0b7f, 0xe09a, 0x7801, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xdbec98be2c34e0d5,32767) }, /* #47/2/3/m = #2337 */
    { 0x0b00, 0xe09a, 0xf081, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(0) }, /* #47/2/3/u = #2338 */
    { 0x0b01, 0xe09a, 0x7801, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xdbec98be2c34e0d5,32767) }, /* #47/2/3/0x1 = #2339 */
    { 0x0c7f, 0xe09a, 0x7801, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xdbec98be2c34e0d5,32767) }, /* #47/3/0/m = #2340 */
    { 0x0c00, 0xe09a, 0xf081, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(0) }, /* #47/3/0/u = #2341 */
    { 0x0c01, 0xe09a, 0x7801, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xdbec98be2c34e0d5,32767) }, /* #47/3/0/0x1 = #2342 */
    { 0x0d7f, 0xe09a, 0x7801, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xdbec98be2c34e0d5,32767) }, /* #47/3/1/m = #2343 */
    { 0x0d00, 0xe09a, 0xf081, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(0) }, /* #47/3/1/u = #2344 */
    { 0x0d01, 0xe09a, 0x7801, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xdbec98be2c34e0d5,32767) }, /* #47/3/1/0x1 = #2345 */
    { 0x0e7f, 0xe09a, 0x7801, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xdbec98be2c34e0d5,32767) }, /* #47/3/2/m = #2346 */
    { 0x0e00, 0xe09a, 0xf081, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(0) }, /* #47/3/2/u = #2347 */
    { 0x0e01, 0xe09a, 0x7801, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xdbec98be2c34e0d5,32767) }, /* #47/3/2/0x1 = #2348 */
    { 0x0f7f, 0xe09a, 0x7801, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xdbec98be2c34e0d5,32767) }, /* #47/3/3/m = #2349 */
    { 0x0f00, 0xe09a, 0xf081, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(0) }, /* #47/3/3/u = #2350 */
    { 0x0f01, 0xe09a, 0x7801, RTFLOAT80U_INIT_C(1,0x9bec98be2c34e0d5,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xdbec98be2c34e0d5,32767) }, /* #47/3/3/0x1 = #2351 */
    { 0x007f, 0xa7b2, 0x3d00, RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767), RTFLOAT80U_INIT_C(1,0xe0543b38300bccda,15177), RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767) }, /* #48/0/0/m = #2352 */
    { 0x0000, 0xa7b2, 0x3d00, RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767), RTFLOAT80U_INIT_C(1,0xe0543b38300bccda,15177), RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767) }, /* #48/0/0/u = #2353 */
    { 0x017f, 0xa7b2, 0x3d00, RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767), RTFLOAT80U_INIT_C(1,0xe0543b38300bccda,15177), RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767) }, /* #48/0/1/m = #2354 */
    { 0x0100, 0xa7b2, 0x3d00, RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767), RTFLOAT80U_INIT_C(1,0xe0543b38300bccda,15177), RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767) }, /* #48/0/1/u = #2355 */
    { 0x027f, 0xa7b2, 0x3d00, RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767), RTFLOAT80U_INIT_C(1,0xe0543b38300bccda,15177), RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767) }, /* #48/0/2/m = #2356 */
    { 0x0200, 0xa7b2, 0x3d00, RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767), RTFLOAT80U_INIT_C(1,0xe0543b38300bccda,15177), RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767) }, /* #48/0/2/u = #2357 */
    { 0x037f, 0xa7b2, 0x3d00, RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767), RTFLOAT80U_INIT_C(1,0xe0543b38300bccda,15177), RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767) }, /* #48/0/3/m = #2358 */
    { 0x0300, 0xa7b2, 0x3d00, RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767), RTFLOAT80U_INIT_C(1,0xe0543b38300bccda,15177), RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767) }, /* #48/0/3/u = #2359 */
    { 0x047f, 0xa7b2, 0x3d00, RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767), RTFLOAT80U_INIT_C(1,0xe0543b38300bccda,15177), RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767) }, /* #48/1/0/m = #2360 */
    { 0x0400, 0xa7b2, 0x3d00, RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767), RTFLOAT80U_INIT_C(1,0xe0543b38300bccda,15177), RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767) }, /* #48/1/0/u = #2361 */
    { 0x057f, 0xa7b2, 0x3d00, RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767), RTFLOAT80U_INIT_C(1,0xe0543b38300bccda,15177), RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767) }, /* #48/1/1/m = #2362 */
    { 0x0500, 0xa7b2, 0x3d00, RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767), RTFLOAT80U_INIT_C(1,0xe0543b38300bccda,15177), RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767) }, /* #48/1/1/u = #2363 */
    { 0x067f, 0xa7b2, 0x3d00, RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767), RTFLOAT80U_INIT_C(1,0xe0543b38300bccda,15177), RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767) }, /* #48/1/2/m = #2364 */
    { 0x0600, 0xa7b2, 0x3d00, RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767), RTFLOAT80U_INIT_C(1,0xe0543b38300bccda,15177), RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767) }, /* #48/1/2/u = #2365 */
    { 0x077f, 0xa7b2, 0x3d00, RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767), RTFLOAT80U_INIT_C(1,0xe0543b38300bccda,15177), RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767) }, /* #48/1/3/m = #2366 */
    { 0x0700, 0xa7b2, 0x3d00, RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767), RTFLOAT80U_INIT_C(1,0xe0543b38300bccda,15177), RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767) }, /* #48/1/3/u = #2367 */
    { 0x087f, 0xa7b2, 0x3d00, RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767), RTFLOAT80U_INIT_C(1,0xe0543b38300bccda,15177), RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767) }, /* #48/2/0/m = #2368 */
    { 0x0800, 0xa7b2, 0x3d00, RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767), RTFLOAT80U_INIT_C(1,0xe0543b38300bccda,15177), RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767) }, /* #48/2/0/u = #2369 */
    { 0x097f, 0xa7b2, 0x3d00, RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767), RTFLOAT80U_INIT_C(1,0xe0543b38300bccda,15177), RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767) }, /* #48/2/1/m = #2370 */
    { 0x0900, 0xa7b2, 0x3d00, RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767), RTFLOAT80U_INIT_C(1,0xe0543b38300bccda,15177), RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767) }, /* #48/2/1/u = #2371 */
    { 0x0a7f, 0xa7b2, 0x3d00, RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767), RTFLOAT80U_INIT_C(1,0xe0543b38300bccda,15177), RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767) }, /* #48/2/2/m = #2372 */
    { 0x0a00, 0xa7b2, 0x3d00, RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767), RTFLOAT80U_INIT_C(1,0xe0543b38300bccda,15177), RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767) }, /* #48/2/2/u = #2373 */
    { 0x0b7f, 0xa7b2, 0x3d00, RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767), RTFLOAT80U_INIT_C(1,0xe0543b38300bccda,15177), RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767) }, /* #48/2/3/m = #2374 */
    { 0x0b00, 0xa7b2, 0x3d00, RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767), RTFLOAT80U_INIT_C(1,0xe0543b38300bccda,15177), RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767) }, /* #48/2/3/u = #2375 */
    { 0x0c7f, 0xa7b2, 0x3d00, RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767), RTFLOAT80U_INIT_C(1,0xe0543b38300bccda,15177), RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767) }, /* #48/3/0/m = #2376 */
    { 0x0c00, 0xa7b2, 0x3d00, RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767), RTFLOAT80U_INIT_C(1,0xe0543b38300bccda,15177), RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767) }, /* #48/3/0/u = #2377 */
    { 0x0d7f, 0xa7b2, 0x3d00, RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767), RTFLOAT80U_INIT_C(1,0xe0543b38300bccda,15177), RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767) }, /* #48/3/1/m = #2378 */
    { 0x0d00, 0xa7b2, 0x3d00, RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767), RTFLOAT80U_INIT_C(1,0xe0543b38300bccda,15177), RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767) }, /* #48/3/1/u = #2379 */
    { 0x0e7f, 0xa7b2, 0x3d00, RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767), RTFLOAT80U_INIT_C(1,0xe0543b38300bccda,15177), RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767) }, /* #48/3/2/m = #2380 */
    { 0x0e00, 0xa7b2, 0x3d00, RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767), RTFLOAT80U_INIT_C(1,0xe0543b38300bccda,15177), RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767) }, /* #48/3/2/u = #2381 */
    { 0x0f7f, 0xa7b2, 0x3d00, RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767), RTFLOAT80U_INIT_C(1,0xe0543b38300bccda,15177), RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767) }, /* #48/3/3/m = #2382 */
    { 0x0f00, 0xa7b2, 0x3d00, RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767), RTFLOAT80U_INIT_C(1,0xe0543b38300bccda,15177), RTFLOAT80U_INIT_C(0,0xd6ff284b41c9bb3e,32767) }, /* #48/3/3/u = #2383 */
    { 0x007f, 0x2f79, 0x3d00, RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,11819), RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767) }, /* #49/0/0/m = #2384 */
    { 0x0000, 0x2f79, 0x3d00, RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,11819), RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767) }, /* #49/0/0/u = #2385 */
    { 0x017f, 0x2f79, 0x3d00, RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,11819), RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767) }, /* #49/0/1/m = #2386 */
    { 0x0100, 0x2f79, 0x3d00, RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,11819), RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767) }, /* #49/0/1/u = #2387 */
    { 0x027f, 0x2f79, 0x3d00, RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,11819), RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767) }, /* #49/0/2/m = #2388 */
    { 0x0200, 0x2f79, 0x3d00, RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,11819), RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767) }, /* #49/0/2/u = #2389 */
    { 0x037f, 0x2f79, 0x3d00, RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,11819), RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767) }, /* #49/0/3/m = #2390 */
    { 0x0300, 0x2f79, 0x3d00, RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,11819), RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767) }, /* #49/0/3/u = #2391 */
    { 0x047f, 0x2f79, 0x3d00, RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,11819), RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767) }, /* #49/1/0/m = #2392 */
    { 0x0400, 0x2f79, 0x3d00, RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,11819), RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767) }, /* #49/1/0/u = #2393 */
    { 0x057f, 0x2f79, 0x3d00, RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,11819), RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767) }, /* #49/1/1/m = #2394 */
    { 0x0500, 0x2f79, 0x3d00, RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,11819), RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767) }, /* #49/1/1/u = #2395 */
    { 0x067f, 0x2f79, 0x3d00, RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,11819), RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767) }, /* #49/1/2/m = #2396 */
    { 0x0600, 0x2f79, 0x3d00, RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,11819), RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767) }, /* #49/1/2/u = #2397 */
    { 0x077f, 0x2f79, 0x3d00, RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,11819), RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767) }, /* #49/1/3/m = #2398 */
    { 0x0700, 0x2f79, 0x3d00, RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,11819), RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767) }, /* #49/1/3/u = #2399 */
    { 0x087f, 0x2f79, 0x3d00, RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,11819), RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767) }, /* #49/2/0/m = #2400 */
    { 0x0800, 0x2f79, 0x3d00, RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,11819), RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767) }, /* #49/2/0/u = #2401 */
    { 0x097f, 0x2f79, 0x3d00, RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,11819), RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767) }, /* #49/2/1/m = #2402 */
    { 0x0900, 0x2f79, 0x3d00, RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,11819), RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767) }, /* #49/2/1/u = #2403 */
    { 0x0a7f, 0x2f79, 0x3d00, RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,11819), RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767) }, /* #49/2/2/m = #2404 */
    { 0x0a00, 0x2f79, 0x3d00, RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,11819), RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767) }, /* #49/2/2/u = #2405 */
    { 0x0b7f, 0x2f79, 0x3d00, RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,11819), RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767) }, /* #49/2/3/m = #2406 */
    { 0x0b00, 0x2f79, 0x3d00, RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,11819), RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767) }, /* #49/2/3/u = #2407 */
    { 0x0c7f, 0x2f79, 0x3d00, RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,11819), RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767) }, /* #49/3/0/m = #2408 */
    { 0x0c00, 0x2f79, 0x3d00, RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,11819), RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767) }, /* #49/3/0/u = #2409 */
    { 0x0d7f, 0x2f79, 0x3d00, RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,11819), RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767) }, /* #49/3/1/m = #2410 */
    { 0x0d00, 0x2f79, 0x3d00, RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,11819), RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767) }, /* #49/3/1/u = #2411 */
    { 0x0e7f, 0x2f79, 0x3d00, RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,11819), RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767) }, /* #49/3/2/m = #2412 */
    { 0x0e00, 0x2f79, 0x3d00, RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,11819), RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767) }, /* #49/3/2/u = #2413 */
    { 0x0f7f, 0x2f79, 0x3d00, RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,11819), RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767) }, /* #49/3/3/m = #2414 */
    { 0x0f00, 0x2f79, 0x3d00, RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,11819), RTFLOAT80U_INIT_C(0,0xe0c1a4c4509e0b87,32767) }, /* #49/3/3/u = #2415 */
    { 0x007f, 0x1f58, 0x3d01, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_IND(1) }, /* #50/0/0/m = #2416 */
    { 0x0000, 0x1f58, 0xb581, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917) }, /* #50/0/0/u = #2417 */
    { 0x0001, 0x1f58, 0x3d01, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_IND(1) }, /* #50/0/0/0x1 = #2418 */
    { 0x017f, 0x1f58, 0x3d01, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_IND(1) }, /* #50/0/1/m = #2419 */
    { 0x0100, 0x1f58, 0xb581, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917) }, /* #50/0/1/u = #2420 */
    { 0x0101, 0x1f58, 0x3d01, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_IND(1) }, /* #50/0/1/0x1 = #2421 */
    { 0x027f, 0x1f58, 0x3d01, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_IND(1) }, /* #50/0/2/m = #2422 */
    { 0x0200, 0x1f58, 0xb581, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917) }, /* #50/0/2/u = #2423 */
    { 0x0201, 0x1f58, 0x3d01, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_IND(1) }, /* #50/0/2/0x1 = #2424 */
    { 0x037f, 0x1f58, 0x3d01, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_IND(1) }, /* #50/0/3/m = #2425 */
    { 0x0300, 0x1f58, 0xb581, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917) }, /* #50/0/3/u = #2426 */
    { 0x0301, 0x1f58, 0x3d01, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_IND(1) }, /* #50/0/3/0x1 = #2427 */
    { 0x047f, 0x1f58, 0x3d01, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_IND(1) }, /* #50/1/0/m = #2428 */
    { 0x0400, 0x1f58, 0xb581, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917) }, /* #50/1/0/u = #2429 */
    { 0x0401, 0x1f58, 0x3d01, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_IND(1) }, /* #50/1/0/0x1 = #2430 */
    { 0x057f, 0x1f58, 0x3d01, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_IND(1) }, /* #50/1/1/m = #2431 */
    { 0x0500, 0x1f58, 0xb581, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917) }, /* #50/1/1/u = #2432 */
    { 0x0501, 0x1f58, 0x3d01, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_IND(1) }, /* #50/1/1/0x1 = #2433 */
    { 0x067f, 0x1f58, 0x3d01, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_IND(1) }, /* #50/1/2/m = #2434 */
    { 0x0600, 0x1f58, 0xb581, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917) }, /* #50/1/2/u = #2435 */
    { 0x0601, 0x1f58, 0x3d01, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_IND(1) }, /* #50/1/2/0x1 = #2436 */
    { 0x077f, 0x1f58, 0x3d01, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_IND(1) }, /* #50/1/3/m = #2437 */
    { 0x0700, 0x1f58, 0xb581, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917) }, /* #50/1/3/u = #2438 */
    { 0x0701, 0x1f58, 0x3d01, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_IND(1) }, /* #50/1/3/0x1 = #2439 */
    { 0x087f, 0x1f58, 0x3d01, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_IND(1) }, /* #50/2/0/m = #2440 */
    { 0x0800, 0x1f58, 0xb581, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917) }, /* #50/2/0/u = #2441 */
    { 0x0801, 0x1f58, 0x3d01, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_IND(1) }, /* #50/2/0/0x1 = #2442 */
    { 0x097f, 0x1f58, 0x3d01, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_IND(1) }, /* #50/2/1/m = #2443 */
    { 0x0900, 0x1f58, 0xb581, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917) }, /* #50/2/1/u = #2444 */
    { 0x0901, 0x1f58, 0x3d01, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_IND(1) }, /* #50/2/1/0x1 = #2445 */
    { 0x0a7f, 0x1f58, 0x3d01, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_IND(1) }, /* #50/2/2/m = #2446 */
    { 0x0a00, 0x1f58, 0xb581, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917) }, /* #50/2/2/u = #2447 */
    { 0x0a01, 0x1f58, 0x3d01, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_IND(1) }, /* #50/2/2/0x1 = #2448 */
    { 0x0b7f, 0x1f58, 0x3d01, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_IND(1) }, /* #50/2/3/m = #2449 */
    { 0x0b00, 0x1f58, 0xb581, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917) }, /* #50/2/3/u = #2450 */
    { 0x0b01, 0x1f58, 0x3d01, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_IND(1) }, /* #50/2/3/0x1 = #2451 */
    { 0x0c7f, 0x1f58, 0x3d01, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_IND(1) }, /* #50/3/0/m = #2452 */
    { 0x0c00, 0x1f58, 0xb581, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917) }, /* #50/3/0/u = #2453 */
    { 0x0c01, 0x1f58, 0x3d01, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_IND(1) }, /* #50/3/0/0x1 = #2454 */
    { 0x0d7f, 0x1f58, 0x3d01, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_IND(1) }, /* #50/3/1/m = #2455 */
    { 0x0d00, 0x1f58, 0xb581, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917) }, /* #50/3/1/u = #2456 */
    { 0x0d01, 0x1f58, 0x3d01, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_IND(1) }, /* #50/3/1/0x1 = #2457 */
    { 0x0e7f, 0x1f58, 0x3d01, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_IND(1) }, /* #50/3/2/m = #2458 */
    { 0x0e00, 0x1f58, 0xb581, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917) }, /* #50/3/2/u = #2459 */
    { 0x0e01, 0x1f58, 0x3d01, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_IND(1) }, /* #50/3/2/0x1 = #2460 */
    { 0x0f7f, 0x1f58, 0x3d01, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_IND(1) }, /* #50/3/3/m = #2461 */
    { 0x0f00, 0x1f58, 0xb581, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917) }, /* #50/3/3/u = #2462 */
    { 0x0f01, 0x1f58, 0x3d01, RTFLOAT80U_INIT_C(1,0xe5a17ef4b04ed9fd,32767), RTFLOAT80U_INIT_C(1,0x5262da312443a4f,20917), RTFLOAT80U_INIT_IND(1) }, /* #50/3/3/0x1 = #2463 */
    { 0x007f, 0x829c, 0x3801, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767) }, /* #51/0/0/m = #2464 */
    { 0x0000, 0x829c, 0xb081, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767) }, /* #51/0/0/u = #2465 */
    { 0x0001, 0x829c, 0x3801, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767) }, /* #51/0/0/0x1 = #2466 */
    { 0x017f, 0x829c, 0x3801, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767) }, /* #51/0/1/m = #2467 */
    { 0x0100, 0x829c, 0xb081, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767) }, /* #51/0/1/u = #2468 */
    { 0x0101, 0x829c, 0x3801, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767) }, /* #51/0/1/0x1 = #2469 */
    { 0x027f, 0x829c, 0x3801, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767) }, /* #51/0/2/m = #2470 */
    { 0x0200, 0x829c, 0xb081, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767) }, /* #51/0/2/u = #2471 */
    { 0x0201, 0x829c, 0x3801, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767) }, /* #51/0/2/0x1 = #2472 */
    { 0x037f, 0x829c, 0x3801, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767) }, /* #51/0/3/m = #2473 */
    { 0x0300, 0x829c, 0xb081, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767) }, /* #51/0/3/u = #2474 */
    { 0x0301, 0x829c, 0x3801, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767) }, /* #51/0/3/0x1 = #2475 */
    { 0x047f, 0x829c, 0x3801, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767) }, /* #51/1/0/m = #2476 */
    { 0x0400, 0x829c, 0xb081, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767) }, /* #51/1/0/u = #2477 */
    { 0x0401, 0x829c, 0x3801, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767) }, /* #51/1/0/0x1 = #2478 */
    { 0x057f, 0x829c, 0x3801, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767) }, /* #51/1/1/m = #2479 */
    { 0x0500, 0x829c, 0xb081, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767) }, /* #51/1/1/u = #2480 */
    { 0x0501, 0x829c, 0x3801, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767) }, /* #51/1/1/0x1 = #2481 */
    { 0x067f, 0x829c, 0x3801, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767) }, /* #51/1/2/m = #2482 */
    { 0x0600, 0x829c, 0xb081, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767) }, /* #51/1/2/u = #2483 */
    { 0x0601, 0x829c, 0x3801, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767) }, /* #51/1/2/0x1 = #2484 */
    { 0x077f, 0x829c, 0x3801, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767) }, /* #51/1/3/m = #2485 */
    { 0x0700, 0x829c, 0xb081, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767) }, /* #51/1/3/u = #2486 */
    { 0x0701, 0x829c, 0x3801, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767) }, /* #51/1/3/0x1 = #2487 */
    { 0x087f, 0x829c, 0x3801, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767) }, /* #51/2/0/m = #2488 */
    { 0x0800, 0x829c, 0xb081, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767) }, /* #51/2/0/u = #2489 */
    { 0x0801, 0x829c, 0x3801, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767) }, /* #51/2/0/0x1 = #2490 */
    { 0x097f, 0x829c, 0x3801, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767) }, /* #51/2/1/m = #2491 */
    { 0x0900, 0x829c, 0xb081, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767) }, /* #51/2/1/u = #2492 */
    { 0x0901, 0x829c, 0x3801, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767) }, /* #51/2/1/0x1 = #2493 */
    { 0x0a7f, 0x829c, 0x3801, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767) }, /* #51/2/2/m = #2494 */
    { 0x0a00, 0x829c, 0xb081, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767) }, /* #51/2/2/u = #2495 */
    { 0x0a01, 0x829c, 0x3801, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767) }, /* #51/2/2/0x1 = #2496 */
    { 0x0b7f, 0x829c, 0x3801, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767) }, /* #51/2/3/m = #2497 */
    { 0x0b00, 0x829c, 0xb081, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767) }, /* #51/2/3/u = #2498 */
    { 0x0b01, 0x829c, 0x3801, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767) }, /* #51/2/3/0x1 = #2499 */
    { 0x0c7f, 0x829c, 0x3801, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767) }, /* #51/3/0/m = #2500 */
    { 0x0c00, 0x829c, 0xb081, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767) }, /* #51/3/0/u = #2501 */
    { 0x0c01, 0x829c, 0x3801, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767) }, /* #51/3/0/0x1 = #2502 */
    { 0x0d7f, 0x829c, 0x3801, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767) }, /* #51/3/1/m = #2503 */
    { 0x0d00, 0x829c, 0xb081, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767) }, /* #51/3/1/u = #2504 */
    { 0x0d01, 0x829c, 0x3801, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767) }, /* #51/3/1/0x1 = #2505 */
    { 0x0e7f, 0x829c, 0x3801, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767) }, /* #51/3/2/m = #2506 */
    { 0x0e00, 0x829c, 0xb081, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767) }, /* #51/3/2/u = #2507 */
    { 0x0e01, 0x829c, 0x3801, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767) }, /* #51/3/2/0x1 = #2508 */
    { 0x0f7f, 0x829c, 0x3801, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767) }, /* #51/3/3/m = #2509 */
    { 0x0f00, 0x829c, 0xb081, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767) }, /* #51/3/3/u = #2510 */
    { 0x0f01, 0x829c, 0x3801, RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767), RTFLOAT80U_INIT_C(0,0x9b08f7113fe70914,32767), RTFLOAT80U_INIT_C(1,0xe0958324925f2c7a,32767) }, /* #51/3/3/0x1 = #2511 */
    { 0x007f, 0x4bc2, 0x7900, RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767), RTFLOAT80U_INIT_C(0,0xd514c833193e6595,32767), RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767) }, /* #52/0/0/m = #2512 */
    { 0x0000, 0x4bc2, 0x7900, RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767), RTFLOAT80U_INIT_C(0,0xd514c833193e6595,32767), RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767) }, /* #52/0/0/u = #2513 */
    { 0x017f, 0x4bc2, 0x7900, RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767), RTFLOAT80U_INIT_C(0,0xd514c833193e6595,32767), RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767) }, /* #52/0/1/m = #2514 */
    { 0x0100, 0x4bc2, 0x7900, RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767), RTFLOAT80U_INIT_C(0,0xd514c833193e6595,32767), RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767) }, /* #52/0/1/u = #2515 */
    { 0x027f, 0x4bc2, 0x7900, RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767), RTFLOAT80U_INIT_C(0,0xd514c833193e6595,32767), RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767) }, /* #52/0/2/m = #2516 */
    { 0x0200, 0x4bc2, 0x7900, RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767), RTFLOAT80U_INIT_C(0,0xd514c833193e6595,32767), RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767) }, /* #52/0/2/u = #2517 */
    { 0x037f, 0x4bc2, 0x7900, RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767), RTFLOAT80U_INIT_C(0,0xd514c833193e6595,32767), RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767) }, /* #52/0/3/m = #2518 */
    { 0x0300, 0x4bc2, 0x7900, RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767), RTFLOAT80U_INIT_C(0,0xd514c833193e6595,32767), RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767) }, /* #52/0/3/u = #2519 */
    { 0x047f, 0x4bc2, 0x7900, RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767), RTFLOAT80U_INIT_C(0,0xd514c833193e6595,32767), RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767) }, /* #52/1/0/m = #2520 */
    { 0x0400, 0x4bc2, 0x7900, RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767), RTFLOAT80U_INIT_C(0,0xd514c833193e6595,32767), RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767) }, /* #52/1/0/u = #2521 */
    { 0x057f, 0x4bc2, 0x7900, RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767), RTFLOAT80U_INIT_C(0,0xd514c833193e6595,32767), RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767) }, /* #52/1/1/m = #2522 */
    { 0x0500, 0x4bc2, 0x7900, RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767), RTFLOAT80U_INIT_C(0,0xd514c833193e6595,32767), RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767) }, /* #52/1/1/u = #2523 */
    { 0x067f, 0x4bc2, 0x7900, RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767), RTFLOAT80U_INIT_C(0,0xd514c833193e6595,32767), RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767) }, /* #52/1/2/m = #2524 */
    { 0x0600, 0x4bc2, 0x7900, RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767), RTFLOAT80U_INIT_C(0,0xd514c833193e6595,32767), RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767) }, /* #52/1/2/u = #2525 */
    { 0x077f, 0x4bc2, 0x7900, RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767), RTFLOAT80U_INIT_C(0,0xd514c833193e6595,32767), RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767) }, /* #52/1/3/m = #2526 */
    { 0x0700, 0x4bc2, 0x7900, RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767), RTFLOAT80U_INIT_C(0,0xd514c833193e6595,32767), RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767) }, /* #52/1/3/u = #2527 */
    { 0x087f, 0x4bc2, 0x7900, RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767), RTFLOAT80U_INIT_C(0,0xd514c833193e6595,32767), RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767) }, /* #52/2/0/m = #2528 */
    { 0x0800, 0x4bc2, 0x7900, RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767), RTFLOAT80U_INIT_C(0,0xd514c833193e6595,32767), RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767) }, /* #52/2/0/u = #2529 */
    { 0x097f, 0x4bc2, 0x7900, RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767), RTFLOAT80U_INIT_C(0,0xd514c833193e6595,32767), RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767) }, /* #52/2/1/m = #2530 */
    { 0x0900, 0x4bc2, 0x7900, RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767), RTFLOAT80U_INIT_C(0,0xd514c833193e6595,32767), RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767) }, /* #52/2/1/u = #2531 */
    { 0x0a7f, 0x4bc2, 0x7900, RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767), RTFLOAT80U_INIT_C(0,0xd514c833193e6595,32767), RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767) }, /* #52/2/2/m = #2532 */
    { 0x0a00, 0x4bc2, 0x7900, RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767), RTFLOAT80U_INIT_C(0,0xd514c833193e6595,32767), RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767) }, /* #52/2/2/u = #2533 */
    { 0x0b7f, 0x4bc2, 0x7900, RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767), RTFLOAT80U_INIT_C(0,0xd514c833193e6595,32767), RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767) }, /* #52/2/3/m = #2534 */
    { 0x0b00, 0x4bc2, 0x7900, RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767), RTFLOAT80U_INIT_C(0,0xd514c833193e6595,32767), RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767) }, /* #52/2/3/u = #2535 */
    { 0x0c7f, 0x4bc2, 0x7900, RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767), RTFLOAT80U_INIT_C(0,0xd514c833193e6595,32767), RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767) }, /* #52/3/0/m = #2536 */
    { 0x0c00, 0x4bc2, 0x7900, RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767), RTFLOAT80U_INIT_C(0,0xd514c833193e6595,32767), RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767) }, /* #52/3/0/u = #2537 */
    { 0x0d7f, 0x4bc2, 0x7900, RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767), RTFLOAT80U_INIT_C(0,0xd514c833193e6595,32767), RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767) }, /* #52/3/1/m = #2538 */
    { 0x0d00, 0x4bc2, 0x7900, RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767), RTFLOAT80U_INIT_C(0,0xd514c833193e6595,32767), RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767) }, /* #52/3/1/u = #2539 */
    { 0x0e7f, 0x4bc2, 0x7900, RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767), RTFLOAT80U_INIT_C(0,0xd514c833193e6595,32767), RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767) }, /* #52/3/2/m = #2540 */
    { 0x0e00, 0x4bc2, 0x7900, RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767), RTFLOAT80U_INIT_C(0,0xd514c833193e6595,32767), RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767) }, /* #52/3/2/u = #2541 */
    { 0x0f7f, 0x4bc2, 0x7900, RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767), RTFLOAT80U_INIT_C(0,0xd514c833193e6595,32767), RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767) }, /* #52/3/3/m = #2542 */
    { 0x0f00, 0x4bc2, 0x7900, RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767), RTFLOAT80U_INIT_C(0,0xd514c833193e6595,32767), RTFLOAT80U_INIT_C(0,0xeadc6e7691ca2e4a,32767) }, /* #52/3/3/u = #2543 */
    { 0x007f, 0x8787, 0x3d01, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/0/0/m = #2544 */
    { 0x0000, 0x8787, 0xb581, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767) }, /* #53/0/0/u = #2545 */
    { 0x0001, 0x8787, 0x3d01, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/0/0/0x1 = #2546 */
    { 0x017f, 0x8787, 0x3d01, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/0/1/m = #2547 */
    { 0x0100, 0x8787, 0xb581, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767) }, /* #53/0/1/u = #2548 */
    { 0x0101, 0x8787, 0x3d01, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/0/1/0x1 = #2549 */
    { 0x027f, 0x8787, 0x3d01, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/0/2/m = #2550 */
    { 0x0200, 0x8787, 0xb581, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767) }, /* #53/0/2/u = #2551 */
    { 0x0201, 0x8787, 0x3d01, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/0/2/0x1 = #2552 */
    { 0x037f, 0x8787, 0x3d01, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/0/3/m = #2553 */
    { 0x0300, 0x8787, 0xb581, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767) }, /* #53/0/3/u = #2554 */
    { 0x0301, 0x8787, 0x3d01, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/0/3/0x1 = #2555 */
    { 0x047f, 0x8787, 0x3d01, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/1/0/m = #2556 */
    { 0x0400, 0x8787, 0xb581, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767) }, /* #53/1/0/u = #2557 */
    { 0x0401, 0x8787, 0x3d01, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/1/0/0x1 = #2558 */
    { 0x057f, 0x8787, 0x3d01, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/1/1/m = #2559 */
    { 0x0500, 0x8787, 0xb581, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767) }, /* #53/1/1/u = #2560 */
    { 0x0501, 0x8787, 0x3d01, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/1/1/0x1 = #2561 */
    { 0x067f, 0x8787, 0x3d01, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/1/2/m = #2562 */
    { 0x0600, 0x8787, 0xb581, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767) }, /* #53/1/2/u = #2563 */
    { 0x0601, 0x8787, 0x3d01, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/1/2/0x1 = #2564 */
    { 0x077f, 0x8787, 0x3d01, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/1/3/m = #2565 */
    { 0x0700, 0x8787, 0xb581, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767) }, /* #53/1/3/u = #2566 */
    { 0x0701, 0x8787, 0x3d01, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/1/3/0x1 = #2567 */
    { 0x087f, 0x8787, 0x3d01, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/2/0/m = #2568 */
    { 0x0800, 0x8787, 0xb581, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767) }, /* #53/2/0/u = #2569 */
    { 0x0801, 0x8787, 0x3d01, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/2/0/0x1 = #2570 */
    { 0x097f, 0x8787, 0x3d01, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/2/1/m = #2571 */
    { 0x0900, 0x8787, 0xb581, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767) }, /* #53/2/1/u = #2572 */
    { 0x0901, 0x8787, 0x3d01, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/2/1/0x1 = #2573 */
    { 0x0a7f, 0x8787, 0x3d01, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/2/2/m = #2574 */
    { 0x0a00, 0x8787, 0xb581, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767) }, /* #53/2/2/u = #2575 */
    { 0x0a01, 0x8787, 0x3d01, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/2/2/0x1 = #2576 */
    { 0x0b7f, 0x8787, 0x3d01, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/2/3/m = #2577 */
    { 0x0b00, 0x8787, 0xb581, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767) }, /* #53/2/3/u = #2578 */
    { 0x0b01, 0x8787, 0x3d01, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/2/3/0x1 = #2579 */
    { 0x0c7f, 0x8787, 0x3d01, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/3/0/m = #2580 */
    { 0x0c00, 0x8787, 0xb581, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767) }, /* #53/3/0/u = #2581 */
    { 0x0c01, 0x8787, 0x3d01, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/3/0/0x1 = #2582 */
    { 0x0d7f, 0x8787, 0x3d01, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/3/1/m = #2583 */
    { 0x0d00, 0x8787, 0xb581, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767) }, /* #53/3/1/u = #2584 */
    { 0x0d01, 0x8787, 0x3d01, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/3/1/0x1 = #2585 */
    { 0x0e7f, 0x8787, 0x3d01, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/3/2/m = #2586 */
    { 0x0e00, 0x8787, 0xb581, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767) }, /* #53/3/2/u = #2587 */
    { 0x0e01, 0x8787, 0x3d01, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/3/2/0x1 = #2588 */
    { 0x0f7f, 0x8787, 0x3d01, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/3/3/m = #2589 */
    { 0x0f00, 0x8787, 0xb581, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767) }, /* #53/3/3/u = #2590 */
    { 0x0f01, 0x8787, 0x3d01, RTFLOAT80U_INIT_C(1,0xe022e07e4520f554,32767), RTFLOAT80U_INIT_C(0,0x53b4d4f7678cb21c,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/3/3/0x1 = #2591 */
    { 0x007f, 0x27c0, 0x3d00, RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767), RTFLOAT80U_INIT_C(1,0xa67a31c0bf8ce0da,0), RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767) }, /* #54/0/0/m = #2592 */
    { 0x0000, 0x27c0, 0x3d00, RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767), RTFLOAT80U_INIT_C(1,0xa67a31c0bf8ce0da,0), RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767) }, /* #54/0/0/u = #2593 */
    { 0x017f, 0x27c0, 0x3d00, RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767), RTFLOAT80U_INIT_C(1,0xa67a31c0bf8ce0da,0), RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767) }, /* #54/0/1/m = #2594 */
    { 0x0100, 0x27c0, 0x3d00, RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767), RTFLOAT80U_INIT_C(1,0xa67a31c0bf8ce0da,0), RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767) }, /* #54/0/1/u = #2595 */
    { 0x027f, 0x27c0, 0x3d00, RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767), RTFLOAT80U_INIT_C(1,0xa67a31c0bf8ce0da,0), RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767) }, /* #54/0/2/m = #2596 */
    { 0x0200, 0x27c0, 0x3d00, RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767), RTFLOAT80U_INIT_C(1,0xa67a31c0bf8ce0da,0), RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767) }, /* #54/0/2/u = #2597 */
    { 0x037f, 0x27c0, 0x3d00, RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767), RTFLOAT80U_INIT_C(1,0xa67a31c0bf8ce0da,0), RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767) }, /* #54/0/3/m = #2598 */
    { 0x0300, 0x27c0, 0x3d00, RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767), RTFLOAT80U_INIT_C(1,0xa67a31c0bf8ce0da,0), RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767) }, /* #54/0/3/u = #2599 */
    { 0x047f, 0x27c0, 0x3d00, RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767), RTFLOAT80U_INIT_C(1,0xa67a31c0bf8ce0da,0), RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767) }, /* #54/1/0/m = #2600 */
    { 0x0400, 0x27c0, 0x3d00, RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767), RTFLOAT80U_INIT_C(1,0xa67a31c0bf8ce0da,0), RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767) }, /* #54/1/0/u = #2601 */
    { 0x057f, 0x27c0, 0x3d00, RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767), RTFLOAT80U_INIT_C(1,0xa67a31c0bf8ce0da,0), RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767) }, /* #54/1/1/m = #2602 */
    { 0x0500, 0x27c0, 0x3d00, RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767), RTFLOAT80U_INIT_C(1,0xa67a31c0bf8ce0da,0), RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767) }, /* #54/1/1/u = #2603 */
    { 0x067f, 0x27c0, 0x3d00, RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767), RTFLOAT80U_INIT_C(1,0xa67a31c0bf8ce0da,0), RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767) }, /* #54/1/2/m = #2604 */
    { 0x0600, 0x27c0, 0x3d00, RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767), RTFLOAT80U_INIT_C(1,0xa67a31c0bf8ce0da,0), RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767) }, /* #54/1/2/u = #2605 */
    { 0x077f, 0x27c0, 0x3d00, RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767), RTFLOAT80U_INIT_C(1,0xa67a31c0bf8ce0da,0), RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767) }, /* #54/1/3/m = #2606 */
    { 0x0700, 0x27c0, 0x3d00, RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767), RTFLOAT80U_INIT_C(1,0xa67a31c0bf8ce0da,0), RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767) }, /* #54/1/3/u = #2607 */
    { 0x087f, 0x27c0, 0x3d00, RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767), RTFLOAT80U_INIT_C(1,0xa67a31c0bf8ce0da,0), RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767) }, /* #54/2/0/m = #2608 */
    { 0x0800, 0x27c0, 0x3d00, RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767), RTFLOAT80U_INIT_C(1,0xa67a31c0bf8ce0da,0), RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767) }, /* #54/2/0/u = #2609 */
    { 0x097f, 0x27c0, 0x3d00, RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767), RTFLOAT80U_INIT_C(1,0xa67a31c0bf8ce0da,0), RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767) }, /* #54/2/1/m = #2610 */
    { 0x0900, 0x27c0, 0x3d00, RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767), RTFLOAT80U_INIT_C(1,0xa67a31c0bf8ce0da,0), RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767) }, /* #54/2/1/u = #2611 */
    { 0x0a7f, 0x27c0, 0x3d00, RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767), RTFLOAT80U_INIT_C(1,0xa67a31c0bf8ce0da,0), RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767) }, /* #54/2/2/m = #2612 */
    { 0x0a00, 0x27c0, 0x3d00, RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767), RTFLOAT80U_INIT_C(1,0xa67a31c0bf8ce0da,0), RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767) }, /* #54/2/2/u = #2613 */
    { 0x0b7f, 0x27c0, 0x3d00, RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767), RTFLOAT80U_INIT_C(1,0xa67a31c0bf8ce0da,0), RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767) }, /* #54/2/3/m = #2614 */
    { 0x0b00, 0x27c0, 0x3d00, RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767), RTFLOAT80U_INIT_C(1,0xa67a31c0bf8ce0da,0), RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767) }, /* #54/2/3/u = #2615 */
    { 0x0c7f, 0x27c0, 0x3d00, RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767), RTFLOAT80U_INIT_C(1,0xa67a31c0bf8ce0da,0), RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767) }, /* #54/3/0/m = #2616 */
    { 0x0c00, 0x27c0, 0x3d00, RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767), RTFLOAT80U_INIT_C(1,0xa67a31c0bf8ce0da,0), RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767) }, /* #54/3/0/u = #2617 */
    { 0x0d7f, 0x27c0, 0x3d00, RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767), RTFLOAT80U_INIT_C(1,0xa67a31c0bf8ce0da,0), RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767) }, /* #54/3/1/m = #2618 */
    { 0x0d00, 0x27c0, 0x3d00, RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767), RTFLOAT80U_INIT_C(1,0xa67a31c0bf8ce0da,0), RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767) }, /* #54/3/1/u = #2619 */
    { 0x0e7f, 0x27c0, 0x3d00, RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767), RTFLOAT80U_INIT_C(1,0xa67a31c0bf8ce0da,0), RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767) }, /* #54/3/2/m = #2620 */
    { 0x0e00, 0x27c0, 0x3d00, RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767), RTFLOAT80U_INIT_C(1,0xa67a31c0bf8ce0da,0), RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767) }, /* #54/3/2/u = #2621 */
    { 0x0f7f, 0x27c0, 0x3d00, RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767), RTFLOAT80U_INIT_C(1,0xa67a31c0bf8ce0da,0), RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767) }, /* #54/3/3/m = #2622 */
    { 0x0f00, 0x27c0, 0x3d00, RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767), RTFLOAT80U_INIT_C(1,0xa67a31c0bf8ce0da,0), RTFLOAT80U_INIT_C(0,0xf760d8b9e9869ab8,32767) }, /* #54/3/3/u = #2623 */
    { 0x007f, 0xea29, 0x7800, RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767), RTFLOAT80U_INIT_C(0,0x3f11d21efd8112e1,0), RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767) }, /* #55/0/0/m = #2624 */
    { 0x0000, 0xea29, 0x7800, RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767), RTFLOAT80U_INIT_C(0,0x3f11d21efd8112e1,0), RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767) }, /* #55/0/0/u = #2625 */
    { 0x017f, 0xea29, 0x7800, RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767), RTFLOAT80U_INIT_C(0,0x3f11d21efd8112e1,0), RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767) }, /* #55/0/1/m = #2626 */
    { 0x0100, 0xea29, 0x7800, RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767), RTFLOAT80U_INIT_C(0,0x3f11d21efd8112e1,0), RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767) }, /* #55/0/1/u = #2627 */
    { 0x027f, 0xea29, 0x7800, RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767), RTFLOAT80U_INIT_C(0,0x3f11d21efd8112e1,0), RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767) }, /* #55/0/2/m = #2628 */
    { 0x0200, 0xea29, 0x7800, RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767), RTFLOAT80U_INIT_C(0,0x3f11d21efd8112e1,0), RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767) }, /* #55/0/2/u = #2629 */
    { 0x037f, 0xea29, 0x7800, RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767), RTFLOAT80U_INIT_C(0,0x3f11d21efd8112e1,0), RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767) }, /* #55/0/3/m = #2630 */
    { 0x0300, 0xea29, 0x7800, RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767), RTFLOAT80U_INIT_C(0,0x3f11d21efd8112e1,0), RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767) }, /* #55/0/3/u = #2631 */
    { 0x047f, 0xea29, 0x7800, RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767), RTFLOAT80U_INIT_C(0,0x3f11d21efd8112e1,0), RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767) }, /* #55/1/0/m = #2632 */
    { 0x0400, 0xea29, 0x7800, RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767), RTFLOAT80U_INIT_C(0,0x3f11d21efd8112e1,0), RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767) }, /* #55/1/0/u = #2633 */
    { 0x057f, 0xea29, 0x7800, RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767), RTFLOAT80U_INIT_C(0,0x3f11d21efd8112e1,0), RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767) }, /* #55/1/1/m = #2634 */
    { 0x0500, 0xea29, 0x7800, RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767), RTFLOAT80U_INIT_C(0,0x3f11d21efd8112e1,0), RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767) }, /* #55/1/1/u = #2635 */
    { 0x067f, 0xea29, 0x7800, RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767), RTFLOAT80U_INIT_C(0,0x3f11d21efd8112e1,0), RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767) }, /* #55/1/2/m = #2636 */
    { 0x0600, 0xea29, 0x7800, RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767), RTFLOAT80U_INIT_C(0,0x3f11d21efd8112e1,0), RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767) }, /* #55/1/2/u = #2637 */
    { 0x077f, 0xea29, 0x7800, RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767), RTFLOAT80U_INIT_C(0,0x3f11d21efd8112e1,0), RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767) }, /* #55/1/3/m = #2638 */
    { 0x0700, 0xea29, 0x7800, RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767), RTFLOAT80U_INIT_C(0,0x3f11d21efd8112e1,0), RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767) }, /* #55/1/3/u = #2639 */
    { 0x087f, 0xea29, 0x7800, RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767), RTFLOAT80U_INIT_C(0,0x3f11d21efd8112e1,0), RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767) }, /* #55/2/0/m = #2640 */
    { 0x0800, 0xea29, 0x7800, RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767), RTFLOAT80U_INIT_C(0,0x3f11d21efd8112e1,0), RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767) }, /* #55/2/0/u = #2641 */
    { 0x097f, 0xea29, 0x7800, RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767), RTFLOAT80U_INIT_C(0,0x3f11d21efd8112e1,0), RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767) }, /* #55/2/1/m = #2642 */
    { 0x0900, 0xea29, 0x7800, RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767), RTFLOAT80U_INIT_C(0,0x3f11d21efd8112e1,0), RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767) }, /* #55/2/1/u = #2643 */
    { 0x0a7f, 0xea29, 0x7800, RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767), RTFLOAT80U_INIT_C(0,0x3f11d21efd8112e1,0), RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767) }, /* #55/2/2/m = #2644 */
    { 0x0a00, 0xea29, 0x7800, RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767), RTFLOAT80U_INIT_C(0,0x3f11d21efd8112e1,0), RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767) }, /* #55/2/2/u = #2645 */
    { 0x0b7f, 0xea29, 0x7800, RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767), RTFLOAT80U_INIT_C(0,0x3f11d21efd8112e1,0), RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767) }, /* #55/2/3/m = #2646 */
    { 0x0b00, 0xea29, 0x7800, RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767), RTFLOAT80U_INIT_C(0,0x3f11d21efd8112e1,0), RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767) }, /* #55/2/3/u = #2647 */
    { 0x0c7f, 0xea29, 0x7800, RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767), RTFLOAT80U_INIT_C(0,0x3f11d21efd8112e1,0), RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767) }, /* #55/3/0/m = #2648 */
    { 0x0c00, 0xea29, 0x7800, RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767), RTFLOAT80U_INIT_C(0,0x3f11d21efd8112e1,0), RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767) }, /* #55/3/0/u = #2649 */
    { 0x0d7f, 0xea29, 0x7800, RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767), RTFLOAT80U_INIT_C(0,0x3f11d21efd8112e1,0), RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767) }, /* #55/3/1/m = #2650 */
    { 0x0d00, 0xea29, 0x7800, RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767), RTFLOAT80U_INIT_C(0,0x3f11d21efd8112e1,0), RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767) }, /* #55/3/1/u = #2651 */
    { 0x0e7f, 0xea29, 0x7800, RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767), RTFLOAT80U_INIT_C(0,0x3f11d21efd8112e1,0), RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767) }, /* #55/3/2/m = #2652 */
    { 0x0e00, 0xea29, 0x7800, RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767), RTFLOAT80U_INIT_C(0,0x3f11d21efd8112e1,0), RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767) }, /* #55/3/2/u = #2653 */
    { 0x0f7f, 0xea29, 0x7800, RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767), RTFLOAT80U_INIT_C(0,0x3f11d21efd8112e1,0), RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767) }, /* #55/3/3/m = #2654 */
    { 0x0f00, 0xea29, 0x7800, RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767), RTFLOAT80U_INIT_C(0,0x3f11d21efd8112e1,0), RTFLOAT80U_INIT_C(0,0xf86fd0af55ed4fbd,32767) }, /* #55/3/3/u = #2655 */
    { 0x007f, 0x9724, 0x3d00, RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767) }, /* #56/0/0/m = #2656 */
    { 0x0000, 0x9724, 0x3d00, RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767) }, /* #56/0/0/u = #2657 */
    { 0x017f, 0x9724, 0x3d00, RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767) }, /* #56/0/1/m = #2658 */
    { 0x0100, 0x9724, 0x3d00, RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767) }, /* #56/0/1/u = #2659 */
    { 0x027f, 0x9724, 0x3d00, RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767) }, /* #56/0/2/m = #2660 */
    { 0x0200, 0x9724, 0x3d00, RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767) }, /* #56/0/2/u = #2661 */
    { 0x037f, 0x9724, 0x3d00, RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767) }, /* #56/0/3/m = #2662 */
    { 0x0300, 0x9724, 0x3d00, RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767) }, /* #56/0/3/u = #2663 */
    { 0x047f, 0x9724, 0x3d00, RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767) }, /* #56/1/0/m = #2664 */
    { 0x0400, 0x9724, 0x3d00, RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767) }, /* #56/1/0/u = #2665 */
    { 0x057f, 0x9724, 0x3d00, RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767) }, /* #56/1/1/m = #2666 */
    { 0x0500, 0x9724, 0x3d00, RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767) }, /* #56/1/1/u = #2667 */
    { 0x067f, 0x9724, 0x3d00, RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767) }, /* #56/1/2/m = #2668 */
    { 0x0600, 0x9724, 0x3d00, RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767) }, /* #56/1/2/u = #2669 */
    { 0x077f, 0x9724, 0x3d00, RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767) }, /* #56/1/3/m = #2670 */
    { 0x0700, 0x9724, 0x3d00, RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767) }, /* #56/1/3/u = #2671 */
    { 0x087f, 0x9724, 0x3d00, RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767) }, /* #56/2/0/m = #2672 */
    { 0x0800, 0x9724, 0x3d00, RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767) }, /* #56/2/0/u = #2673 */
    { 0x097f, 0x9724, 0x3d00, RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767) }, /* #56/2/1/m = #2674 */
    { 0x0900, 0x9724, 0x3d00, RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767) }, /* #56/2/1/u = #2675 */
    { 0x0a7f, 0x9724, 0x3d00, RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767) }, /* #56/2/2/m = #2676 */
    { 0x0a00, 0x9724, 0x3d00, RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767) }, /* #56/2/2/u = #2677 */
    { 0x0b7f, 0x9724, 0x3d00, RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767) }, /* #56/2/3/m = #2678 */
    { 0x0b00, 0x9724, 0x3d00, RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767) }, /* #56/2/3/u = #2679 */
    { 0x0c7f, 0x9724, 0x3d00, RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767) }, /* #56/3/0/m = #2680 */
    { 0x0c00, 0x9724, 0x3d00, RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767) }, /* #56/3/0/u = #2681 */
    { 0x0d7f, 0x9724, 0x3d00, RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767) }, /* #56/3/1/m = #2682 */
    { 0x0d00, 0x9724, 0x3d00, RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767) }, /* #56/3/1/u = #2683 */
    { 0x0e7f, 0x9724, 0x3d00, RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767) }, /* #56/3/2/m = #2684 */
    { 0x0e00, 0x9724, 0x3d00, RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767) }, /* #56/3/2/u = #2685 */
    { 0x0f7f, 0x9724, 0x3d00, RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767) }, /* #56/3/3/m = #2686 */
    { 0x0f00, 0x9724, 0x3d00, RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xf6d8c11f54b9de8b,32767) }, /* #56/3/3/u = #2687 */
    { 0x007f, 0x9ba2, 0x3900, RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767) }, /* #57/0/0/m = #2688 */
    { 0x0000, 0x9ba2, 0x3900, RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767) }, /* #57/0/0/u = #2689 */
    { 0x017f, 0x9ba2, 0x3900, RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767) }, /* #57/0/1/m = #2690 */
    { 0x0100, 0x9ba2, 0x3900, RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767) }, /* #57/0/1/u = #2691 */
    { 0x027f, 0x9ba2, 0x3900, RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767) }, /* #57/0/2/m = #2692 */
    { 0x0200, 0x9ba2, 0x3900, RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767) }, /* #57/0/2/u = #2693 */
    { 0x037f, 0x9ba2, 0x3900, RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767) }, /* #57/0/3/m = #2694 */
    { 0x0300, 0x9ba2, 0x3900, RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767) }, /* #57/0/3/u = #2695 */
    { 0x047f, 0x9ba2, 0x3900, RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767) }, /* #57/1/0/m = #2696 */
    { 0x0400, 0x9ba2, 0x3900, RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767) }, /* #57/1/0/u = #2697 */
    { 0x057f, 0x9ba2, 0x3900, RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767) }, /* #57/1/1/m = #2698 */
    { 0x0500, 0x9ba2, 0x3900, RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767) }, /* #57/1/1/u = #2699 */
    { 0x067f, 0x9ba2, 0x3900, RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767) }, /* #57/1/2/m = #2700 */
    { 0x0600, 0x9ba2, 0x3900, RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767) }, /* #57/1/2/u = #2701 */
    { 0x077f, 0x9ba2, 0x3900, RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767) }, /* #57/1/3/m = #2702 */
    { 0x0700, 0x9ba2, 0x3900, RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767) }, /* #57/1/3/u = #2703 */
    { 0x087f, 0x9ba2, 0x3900, RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767) }, /* #57/2/0/m = #2704 */
    { 0x0800, 0x9ba2, 0x3900, RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767) }, /* #57/2/0/u = #2705 */
    { 0x097f, 0x9ba2, 0x3900, RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767) }, /* #57/2/1/m = #2706 */
    { 0x0900, 0x9ba2, 0x3900, RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767) }, /* #57/2/1/u = #2707 */
    { 0x0a7f, 0x9ba2, 0x3900, RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767) }, /* #57/2/2/m = #2708 */
    { 0x0a00, 0x9ba2, 0x3900, RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767) }, /* #57/2/2/u = #2709 */
    { 0x0b7f, 0x9ba2, 0x3900, RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767) }, /* #57/2/3/m = #2710 */
    { 0x0b00, 0x9ba2, 0x3900, RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767) }, /* #57/2/3/u = #2711 */
    { 0x0c7f, 0x9ba2, 0x3900, RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767) }, /* #57/3/0/m = #2712 */
    { 0x0c00, 0x9ba2, 0x3900, RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767) }, /* #57/3/0/u = #2713 */
    { 0x0d7f, 0x9ba2, 0x3900, RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767) }, /* #57/3/1/m = #2714 */
    { 0x0d00, 0x9ba2, 0x3900, RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767) }, /* #57/3/1/u = #2715 */
    { 0x0e7f, 0x9ba2, 0x3900, RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767) }, /* #57/3/2/m = #2716 */
    { 0x0e00, 0x9ba2, 0x3900, RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767) }, /* #57/3/2/u = #2717 */
    { 0x0f7f, 0x9ba2, 0x3900, RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767) }, /* #57/3/3/m = #2718 */
    { 0x0f00, 0x9ba2, 0x3900, RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xfdbbfce2000cb3d5,32767) }, /* #57/3/3/u = #2719 */
    { 0x007f, 0x887d, 0x3801, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/0/0/m = #2720 */
    { 0x0000, 0x887d, 0xb081, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #58/0/0/u = #2721 */
    { 0x0001, 0x887d, 0x3801, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/0/0/0x1 = #2722 */
    { 0x017f, 0x887d, 0x3801, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/0/1/m = #2723 */
    { 0x0100, 0x887d, 0xb081, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #58/0/1/u = #2724 */
    { 0x0101, 0x887d, 0x3801, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/0/1/0x1 = #2725 */
    { 0x027f, 0x887d, 0x3801, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/0/2/m = #2726 */
    { 0x0200, 0x887d, 0xb081, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #58/0/2/u = #2727 */
    { 0x0201, 0x887d, 0x3801, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/0/2/0x1 = #2728 */
    { 0x037f, 0x887d, 0x3801, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/0/3/m = #2729 */
    { 0x0300, 0x887d, 0xb081, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #58/0/3/u = #2730 */
    { 0x0301, 0x887d, 0x3801, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/0/3/0x1 = #2731 */
    { 0x047f, 0x887d, 0x3801, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/1/0/m = #2732 */
    { 0x0400, 0x887d, 0xb081, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #58/1/0/u = #2733 */
    { 0x0401, 0x887d, 0x3801, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/1/0/0x1 = #2734 */
    { 0x057f, 0x887d, 0x3801, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/1/1/m = #2735 */
    { 0x0500, 0x887d, 0xb081, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #58/1/1/u = #2736 */
    { 0x0501, 0x887d, 0x3801, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/1/1/0x1 = #2737 */
    { 0x067f, 0x887d, 0x3801, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/1/2/m = #2738 */
    { 0x0600, 0x887d, 0xb081, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #58/1/2/u = #2739 */
    { 0x0601, 0x887d, 0x3801, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/1/2/0x1 = #2740 */
    { 0x077f, 0x887d, 0x3801, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/1/3/m = #2741 */
    { 0x0700, 0x887d, 0xb081, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #58/1/3/u = #2742 */
    { 0x0701, 0x887d, 0x3801, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/1/3/0x1 = #2743 */
    { 0x087f, 0x887d, 0x3801, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/2/0/m = #2744 */
    { 0x0800, 0x887d, 0xb081, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #58/2/0/u = #2745 */
    { 0x0801, 0x887d, 0x3801, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/2/0/0x1 = #2746 */
    { 0x097f, 0x887d, 0x3801, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/2/1/m = #2747 */
    { 0x0900, 0x887d, 0xb081, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #58/2/1/u = #2748 */
    { 0x0901, 0x887d, 0x3801, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/2/1/0x1 = #2749 */
    { 0x0a7f, 0x887d, 0x3801, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/2/2/m = #2750 */
    { 0x0a00, 0x887d, 0xb081, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #58/2/2/u = #2751 */
    { 0x0a01, 0x887d, 0x3801, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/2/2/0x1 = #2752 */
    { 0x0b7f, 0x887d, 0x3801, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/2/3/m = #2753 */
    { 0x0b00, 0x887d, 0xb081, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #58/2/3/u = #2754 */
    { 0x0b01, 0x887d, 0x3801, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/2/3/0x1 = #2755 */
    { 0x0c7f, 0x887d, 0x3801, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/3/0/m = #2756 */
    { 0x0c00, 0x887d, 0xb081, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #58/3/0/u = #2757 */
    { 0x0c01, 0x887d, 0x3801, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/3/0/0x1 = #2758 */
    { 0x0d7f, 0x887d, 0x3801, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/3/1/m = #2759 */
    { 0x0d00, 0x887d, 0xb081, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #58/3/1/u = #2760 */
    { 0x0d01, 0x887d, 0x3801, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/3/1/0x1 = #2761 */
    { 0x0e7f, 0x887d, 0x3801, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/3/2/m = #2762 */
    { 0x0e00, 0x887d, 0xb081, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #58/3/2/u = #2763 */
    { 0x0e01, 0x887d, 0x3801, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/3/2/0x1 = #2764 */
    { 0x0f7f, 0x887d, 0x3801, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/3/3/m = #2765 */
    { 0x0f00, 0x887d, 0xb081, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #58/3/3/u = #2766 */
    { 0x0f01, 0x887d, 0x3801, RTFLOAT80U_INIT_C(0,0xd56c1f65ebfa0a49,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/3/3/0x1 = #2767 */
    { 0x007f, 0xd485, 0x7c00, RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767) }, /* #59/0/0/m = #2768 */
    { 0x0000, 0xd485, 0x7c00, RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767) }, /* #59/0/0/u = #2769 */
    { 0x017f, 0xd485, 0x7c00, RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767) }, /* #59/0/1/m = #2770 */
    { 0x0100, 0xd485, 0x7c00, RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767) }, /* #59/0/1/u = #2771 */
    { 0x027f, 0xd485, 0x7c00, RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767) }, /* #59/0/2/m = #2772 */
    { 0x0200, 0xd485, 0x7c00, RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767) }, /* #59/0/2/u = #2773 */
    { 0x037f, 0xd485, 0x7c00, RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767) }, /* #59/0/3/m = #2774 */
    { 0x0300, 0xd485, 0x7c00, RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767) }, /* #59/0/3/u = #2775 */
    { 0x047f, 0xd485, 0x7c00, RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767) }, /* #59/1/0/m = #2776 */
    { 0x0400, 0xd485, 0x7c00, RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767) }, /* #59/1/0/u = #2777 */
    { 0x057f, 0xd485, 0x7c00, RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767) }, /* #59/1/1/m = #2778 */
    { 0x0500, 0xd485, 0x7c00, RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767) }, /* #59/1/1/u = #2779 */
    { 0x067f, 0xd485, 0x7c00, RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767) }, /* #59/1/2/m = #2780 */
    { 0x0600, 0xd485, 0x7c00, RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767) }, /* #59/1/2/u = #2781 */
    { 0x077f, 0xd485, 0x7c00, RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767) }, /* #59/1/3/m = #2782 */
    { 0x0700, 0xd485, 0x7c00, RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767) }, /* #59/1/3/u = #2783 */
    { 0x087f, 0xd485, 0x7c00, RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767) }, /* #59/2/0/m = #2784 */
    { 0x0800, 0xd485, 0x7c00, RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767) }, /* #59/2/0/u = #2785 */
    { 0x097f, 0xd485, 0x7c00, RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767) }, /* #59/2/1/m = #2786 */
    { 0x0900, 0xd485, 0x7c00, RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767) }, /* #59/2/1/u = #2787 */
    { 0x0a7f, 0xd485, 0x7c00, RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767) }, /* #59/2/2/m = #2788 */
    { 0x0a00, 0xd485, 0x7c00, RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767) }, /* #59/2/2/u = #2789 */
    { 0x0b7f, 0xd485, 0x7c00, RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767) }, /* #59/2/3/m = #2790 */
    { 0x0b00, 0xd485, 0x7c00, RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767) }, /* #59/2/3/u = #2791 */
    { 0x0c7f, 0xd485, 0x7c00, RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767) }, /* #59/3/0/m = #2792 */
    { 0x0c00, 0xd485, 0x7c00, RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767) }, /* #59/3/0/u = #2793 */
    { 0x0d7f, 0xd485, 0x7c00, RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767) }, /* #59/3/1/m = #2794 */
    { 0x0d00, 0xd485, 0x7c00, RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767) }, /* #59/3/1/u = #2795 */
    { 0x0e7f, 0xd485, 0x7c00, RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767) }, /* #59/3/2/m = #2796 */
    { 0x0e00, 0xd485, 0x7c00, RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767) }, /* #59/3/2/u = #2797 */
    { 0x0f7f, 0xd485, 0x7c00, RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767) }, /* #59/3/3/m = #2798 */
    { 0x0f00, 0xd485, 0x7c00, RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(1,0xc17c92d78bb03cd9,32767) }, /* #59/3/3/u = #2799 */
    { 0x007f, 0x7800, 0x7801, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_IND(1) }, /* #60/0/0/m = #2800 */
    { 0x0000, 0x7800, 0xf081, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310) }, /* #60/0/0/u = #2801 */
    { 0x0001, 0x7800, 0x7801, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_IND(1) }, /* #60/0/0/0x1 = #2802 */
    { 0x017f, 0x7800, 0x7801, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_IND(1) }, /* #60/0/1/m = #2803 */
    { 0x0100, 0x7800, 0xf081, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310) }, /* #60/0/1/u = #2804 */
    { 0x0101, 0x7800, 0x7801, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_IND(1) }, /* #60/0/1/0x1 = #2805 */
    { 0x027f, 0x7800, 0x7801, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_IND(1) }, /* #60/0/2/m = #2806 */
    { 0x0200, 0x7800, 0xf081, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310) }, /* #60/0/2/u = #2807 */
    { 0x0201, 0x7800, 0x7801, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_IND(1) }, /* #60/0/2/0x1 = #2808 */
    { 0x037f, 0x7800, 0x7801, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_IND(1) }, /* #60/0/3/m = #2809 */
    { 0x0300, 0x7800, 0xf081, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310) }, /* #60/0/3/u = #2810 */
    { 0x0301, 0x7800, 0x7801, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_IND(1) }, /* #60/0/3/0x1 = #2811 */
    { 0x047f, 0x7800, 0x7801, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_IND(1) }, /* #60/1/0/m = #2812 */
    { 0x0400, 0x7800, 0xf081, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310) }, /* #60/1/0/u = #2813 */
    { 0x0401, 0x7800, 0x7801, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_IND(1) }, /* #60/1/0/0x1 = #2814 */
    { 0x057f, 0x7800, 0x7801, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_IND(1) }, /* #60/1/1/m = #2815 */
    { 0x0500, 0x7800, 0xf081, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310) }, /* #60/1/1/u = #2816 */
    { 0x0501, 0x7800, 0x7801, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_IND(1) }, /* #60/1/1/0x1 = #2817 */
    { 0x067f, 0x7800, 0x7801, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_IND(1) }, /* #60/1/2/m = #2818 */
    { 0x0600, 0x7800, 0xf081, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310) }, /* #60/1/2/u = #2819 */
    { 0x0601, 0x7800, 0x7801, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_IND(1) }, /* #60/1/2/0x1 = #2820 */
    { 0x077f, 0x7800, 0x7801, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_IND(1) }, /* #60/1/3/m = #2821 */
    { 0x0700, 0x7800, 0xf081, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310) }, /* #60/1/3/u = #2822 */
    { 0x0701, 0x7800, 0x7801, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_IND(1) }, /* #60/1/3/0x1 = #2823 */
    { 0x087f, 0x7800, 0x7801, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_IND(1) }, /* #60/2/0/m = #2824 */
    { 0x0800, 0x7800, 0xf081, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310) }, /* #60/2/0/u = #2825 */
    { 0x0801, 0x7800, 0x7801, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_IND(1) }, /* #60/2/0/0x1 = #2826 */
    { 0x097f, 0x7800, 0x7801, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_IND(1) }, /* #60/2/1/m = #2827 */
    { 0x0900, 0x7800, 0xf081, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310) }, /* #60/2/1/u = #2828 */
    { 0x0901, 0x7800, 0x7801, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_IND(1) }, /* #60/2/1/0x1 = #2829 */
    { 0x0a7f, 0x7800, 0x7801, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_IND(1) }, /* #60/2/2/m = #2830 */
    { 0x0a00, 0x7800, 0xf081, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310) }, /* #60/2/2/u = #2831 */
    { 0x0a01, 0x7800, 0x7801, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_IND(1) }, /* #60/2/2/0x1 = #2832 */
    { 0x0b7f, 0x7800, 0x7801, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_IND(1) }, /* #60/2/3/m = #2833 */
    { 0x0b00, 0x7800, 0xf081, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310) }, /* #60/2/3/u = #2834 */
    { 0x0b01, 0x7800, 0x7801, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_IND(1) }, /* #60/2/3/0x1 = #2835 */
    { 0x0c7f, 0x7800, 0x7801, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_IND(1) }, /* #60/3/0/m = #2836 */
    { 0x0c00, 0x7800, 0xf081, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310) }, /* #60/3/0/u = #2837 */
    { 0x0c01, 0x7800, 0x7801, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_IND(1) }, /* #60/3/0/0x1 = #2838 */
    { 0x0d7f, 0x7800, 0x7801, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_IND(1) }, /* #60/3/1/m = #2839 */
    { 0x0d00, 0x7800, 0xf081, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310) }, /* #60/3/1/u = #2840 */
    { 0x0d01, 0x7800, 0x7801, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_IND(1) }, /* #60/3/1/0x1 = #2841 */
    { 0x0e7f, 0x7800, 0x7801, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_IND(1) }, /* #60/3/2/m = #2842 */
    { 0x0e00, 0x7800, 0xf081, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310) }, /* #60/3/2/u = #2843 */
    { 0x0e01, 0x7800, 0x7801, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_IND(1) }, /* #60/3/2/0x1 = #2844 */
    { 0x0f7f, 0x7800, 0x7801, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_IND(1) }, /* #60/3/3/m = #2845 */
    { 0x0f00, 0x7800, 0xf081, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310) }, /* #60/3/3/u = #2846 */
    { 0x0f01, 0x7800, 0x7801, RTFLOAT80U_INIT_C(1,0xdac407478d4f4e9,32767), RTFLOAT80U_INIT_C(1,0xed7c716a23b340b4,31310), RTFLOAT80U_INIT_IND(1) }, /* #60/3/3/0x1 = #2847 */
    { 0x007f, 0x5198, 0x7901, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_IND(1) }, /* #61/0/0/m = #2848 */
    { 0x0000, 0x5198, 0xf181, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488) }, /* #61/0/0/u = #2849 */
    { 0x0001, 0x5198, 0x7901, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_IND(1) }, /* #61/0/0/0x1 = #2850 */
    { 0x017f, 0x5198, 0x7901, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_IND(1) }, /* #61/0/1/m = #2851 */
    { 0x0100, 0x5198, 0xf181, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488) }, /* #61/0/1/u = #2852 */
    { 0x0101, 0x5198, 0x7901, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_IND(1) }, /* #61/0/1/0x1 = #2853 */
    { 0x027f, 0x5198, 0x7901, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_IND(1) }, /* #61/0/2/m = #2854 */
    { 0x0200, 0x5198, 0xf181, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488) }, /* #61/0/2/u = #2855 */
    { 0x0201, 0x5198, 0x7901, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_IND(1) }, /* #61/0/2/0x1 = #2856 */
    { 0x037f, 0x5198, 0x7901, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_IND(1) }, /* #61/0/3/m = #2857 */
    { 0x0300, 0x5198, 0xf181, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488) }, /* #61/0/3/u = #2858 */
    { 0x0301, 0x5198, 0x7901, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_IND(1) }, /* #61/0/3/0x1 = #2859 */
    { 0x047f, 0x5198, 0x7901, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_IND(1) }, /* #61/1/0/m = #2860 */
    { 0x0400, 0x5198, 0xf181, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488) }, /* #61/1/0/u = #2861 */
    { 0x0401, 0x5198, 0x7901, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_IND(1) }, /* #61/1/0/0x1 = #2862 */
    { 0x057f, 0x5198, 0x7901, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_IND(1) }, /* #61/1/1/m = #2863 */
    { 0x0500, 0x5198, 0xf181, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488) }, /* #61/1/1/u = #2864 */
    { 0x0501, 0x5198, 0x7901, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_IND(1) }, /* #61/1/1/0x1 = #2865 */
    { 0x067f, 0x5198, 0x7901, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_IND(1) }, /* #61/1/2/m = #2866 */
    { 0x0600, 0x5198, 0xf181, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488) }, /* #61/1/2/u = #2867 */
    { 0x0601, 0x5198, 0x7901, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_IND(1) }, /* #61/1/2/0x1 = #2868 */
    { 0x077f, 0x5198, 0x7901, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_IND(1) }, /* #61/1/3/m = #2869 */
    { 0x0700, 0x5198, 0xf181, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488) }, /* #61/1/3/u = #2870 */
    { 0x0701, 0x5198, 0x7901, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_IND(1) }, /* #61/1/3/0x1 = #2871 */
    { 0x087f, 0x5198, 0x7901, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_IND(1) }, /* #61/2/0/m = #2872 */
    { 0x0800, 0x5198, 0xf181, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488) }, /* #61/2/0/u = #2873 */
    { 0x0801, 0x5198, 0x7901, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_IND(1) }, /* #61/2/0/0x1 = #2874 */
    { 0x097f, 0x5198, 0x7901, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_IND(1) }, /* #61/2/1/m = #2875 */
    { 0x0900, 0x5198, 0xf181, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488) }, /* #61/2/1/u = #2876 */
    { 0x0901, 0x5198, 0x7901, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_IND(1) }, /* #61/2/1/0x1 = #2877 */
    { 0x0a7f, 0x5198, 0x7901, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_IND(1) }, /* #61/2/2/m = #2878 */
    { 0x0a00, 0x5198, 0xf181, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488) }, /* #61/2/2/u = #2879 */
    { 0x0a01, 0x5198, 0x7901, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_IND(1) }, /* #61/2/2/0x1 = #2880 */
    { 0x0b7f, 0x5198, 0x7901, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_IND(1) }, /* #61/2/3/m = #2881 */
    { 0x0b00, 0x5198, 0xf181, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488) }, /* #61/2/3/u = #2882 */
    { 0x0b01, 0x5198, 0x7901, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_IND(1) }, /* #61/2/3/0x1 = #2883 */
    { 0x0c7f, 0x5198, 0x7901, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_IND(1) }, /* #61/3/0/m = #2884 */
    { 0x0c00, 0x5198, 0xf181, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488) }, /* #61/3/0/u = #2885 */
    { 0x0c01, 0x5198, 0x7901, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_IND(1) }, /* #61/3/0/0x1 = #2886 */
    { 0x0d7f, 0x5198, 0x7901, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_IND(1) }, /* #61/3/1/m = #2887 */
    { 0x0d00, 0x5198, 0xf181, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488) }, /* #61/3/1/u = #2888 */
    { 0x0d01, 0x5198, 0x7901, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_IND(1) }, /* #61/3/1/0x1 = #2889 */
    { 0x0e7f, 0x5198, 0x7901, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_IND(1) }, /* #61/3/2/m = #2890 */
    { 0x0e00, 0x5198, 0xf181, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488) }, /* #61/3/2/u = #2891 */
    { 0x0e01, 0x5198, 0x7901, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_IND(1) }, /* #61/3/2/0x1 = #2892 */
    { 0x0f7f, 0x5198, 0x7901, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_IND(1) }, /* #61/3/3/m = #2893 */
    { 0x0f00, 0x5198, 0xf181, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488) }, /* #61/3/3/u = #2894 */
    { 0x0f01, 0x5198, 0x7901, RTFLOAT80U_INIT_C(1,0x74b487f1fe95bf91,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,10488), RTFLOAT80U_INIT_IND(1) }, /* #61/3/3/0x1 = #2895 */
    { 0x007f, 0xfd43, 0x7d01, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_IND(1) }, /* #62/0/0/m = #2896 */
    { 0x0000, 0xfd43, 0xf581, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714) }, /* #62/0/0/u = #2897 */
    { 0x0001, 0xfd43, 0x7d01, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_IND(1) }, /* #62/0/0/0x1 = #2898 */
    { 0x017f, 0xfd43, 0x7d01, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_IND(1) }, /* #62/0/1/m = #2899 */
    { 0x0100, 0xfd43, 0xf581, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714) }, /* #62/0/1/u = #2900 */
    { 0x0101, 0xfd43, 0x7d01, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_IND(1) }, /* #62/0/1/0x1 = #2901 */
    { 0x027f, 0xfd43, 0x7d01, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_IND(1) }, /* #62/0/2/m = #2902 */
    { 0x0200, 0xfd43, 0xf581, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714) }, /* #62/0/2/u = #2903 */
    { 0x0201, 0xfd43, 0x7d01, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_IND(1) }, /* #62/0/2/0x1 = #2904 */
    { 0x037f, 0xfd43, 0x7d01, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_IND(1) }, /* #62/0/3/m = #2905 */
    { 0x0300, 0xfd43, 0xf581, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714) }, /* #62/0/3/u = #2906 */
    { 0x0301, 0xfd43, 0x7d01, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_IND(1) }, /* #62/0/3/0x1 = #2907 */
    { 0x047f, 0xfd43, 0x7d01, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_IND(1) }, /* #62/1/0/m = #2908 */
    { 0x0400, 0xfd43, 0xf581, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714) }, /* #62/1/0/u = #2909 */
    { 0x0401, 0xfd43, 0x7d01, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_IND(1) }, /* #62/1/0/0x1 = #2910 */
    { 0x057f, 0xfd43, 0x7d01, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_IND(1) }, /* #62/1/1/m = #2911 */
    { 0x0500, 0xfd43, 0xf581, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714) }, /* #62/1/1/u = #2912 */
    { 0x0501, 0xfd43, 0x7d01, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_IND(1) }, /* #62/1/1/0x1 = #2913 */
    { 0x067f, 0xfd43, 0x7d01, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_IND(1) }, /* #62/1/2/m = #2914 */
    { 0x0600, 0xfd43, 0xf581, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714) }, /* #62/1/2/u = #2915 */
    { 0x0601, 0xfd43, 0x7d01, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_IND(1) }, /* #62/1/2/0x1 = #2916 */
    { 0x077f, 0xfd43, 0x7d01, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_IND(1) }, /* #62/1/3/m = #2917 */
    { 0x0700, 0xfd43, 0xf581, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714) }, /* #62/1/3/u = #2918 */
    { 0x0701, 0xfd43, 0x7d01, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_IND(1) }, /* #62/1/3/0x1 = #2919 */
    { 0x087f, 0xfd43, 0x7d01, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_IND(1) }, /* #62/2/0/m = #2920 */
    { 0x0800, 0xfd43, 0xf581, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714) }, /* #62/2/0/u = #2921 */
    { 0x0801, 0xfd43, 0x7d01, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_IND(1) }, /* #62/2/0/0x1 = #2922 */
    { 0x097f, 0xfd43, 0x7d01, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_IND(1) }, /* #62/2/1/m = #2923 */
    { 0x0900, 0xfd43, 0xf581, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714) }, /* #62/2/1/u = #2924 */
    { 0x0901, 0xfd43, 0x7d01, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_IND(1) }, /* #62/2/1/0x1 = #2925 */
    { 0x0a7f, 0xfd43, 0x7d01, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_IND(1) }, /* #62/2/2/m = #2926 */
    { 0x0a00, 0xfd43, 0xf581, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714) }, /* #62/2/2/u = #2927 */
    { 0x0a01, 0xfd43, 0x7d01, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_IND(1) }, /* #62/2/2/0x1 = #2928 */
    { 0x0b7f, 0xfd43, 0x7d01, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_IND(1) }, /* #62/2/3/m = #2929 */
    { 0x0b00, 0xfd43, 0xf581, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714) }, /* #62/2/3/u = #2930 */
    { 0x0b01, 0xfd43, 0x7d01, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_IND(1) }, /* #62/2/3/0x1 = #2931 */
    { 0x0c7f, 0xfd43, 0x7d01, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_IND(1) }, /* #62/3/0/m = #2932 */
    { 0x0c00, 0xfd43, 0xf581, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714) }, /* #62/3/0/u = #2933 */
    { 0x0c01, 0xfd43, 0x7d01, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_IND(1) }, /* #62/3/0/0x1 = #2934 */
    { 0x0d7f, 0xfd43, 0x7d01, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_IND(1) }, /* #62/3/1/m = #2935 */
    { 0x0d00, 0xfd43, 0xf581, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714) }, /* #62/3/1/u = #2936 */
    { 0x0d01, 0xfd43, 0x7d01, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_IND(1) }, /* #62/3/1/0x1 = #2937 */
    { 0x0e7f, 0xfd43, 0x7d01, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_IND(1) }, /* #62/3/2/m = #2938 */
    { 0x0e00, 0xfd43, 0xf581, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714) }, /* #62/3/2/u = #2939 */
    { 0x0e01, 0xfd43, 0x7d01, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_IND(1) }, /* #62/3/2/0x1 = #2940 */
    { 0x0f7f, 0xfd43, 0x7d01, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_IND(1) }, /* #62/3/3/m = #2941 */
    { 0x0f00, 0xfd43, 0xf581, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714) }, /* #62/3/3/u = #2942 */
    { 0x0f01, 0xfd43, 0x7d01, RTFLOAT80U_INIT_C(0,0x6899817c7f1e4708,32767), RTFLOAT80U_INIT_C(1,0x195af5947098067f,714), RTFLOAT80U_INIT_IND(1) }, /* #62/3/3/0x1 = #2943 */
    { 0x007f, 0xb7ee, 0x3d01, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/0/0/m = #2944 */
    { 0x0000, 0xb7ee, 0xb581, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767) }, /* #63/0/0/u = #2945 */
    { 0x0001, 0xb7ee, 0x3d01, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/0/0/0x1 = #2946 */
    { 0x017f, 0xb7ee, 0x3d01, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/0/1/m = #2947 */
    { 0x0100, 0xb7ee, 0xb581, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767) }, /* #63/0/1/u = #2948 */
    { 0x0101, 0xb7ee, 0x3d01, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/0/1/0x1 = #2949 */
    { 0x027f, 0xb7ee, 0x3d01, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/0/2/m = #2950 */
    { 0x0200, 0xb7ee, 0xb581, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767) }, /* #63/0/2/u = #2951 */
    { 0x0201, 0xb7ee, 0x3d01, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/0/2/0x1 = #2952 */
    { 0x037f, 0xb7ee, 0x3d01, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/0/3/m = #2953 */
    { 0x0300, 0xb7ee, 0xb581, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767) }, /* #63/0/3/u = #2954 */
    { 0x0301, 0xb7ee, 0x3d01, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/0/3/0x1 = #2955 */
    { 0x047f, 0xb7ee, 0x3d01, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/1/0/m = #2956 */
    { 0x0400, 0xb7ee, 0xb581, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767) }, /* #63/1/0/u = #2957 */
    { 0x0401, 0xb7ee, 0x3d01, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/1/0/0x1 = #2958 */
    { 0x057f, 0xb7ee, 0x3d01, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/1/1/m = #2959 */
    { 0x0500, 0xb7ee, 0xb581, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767) }, /* #63/1/1/u = #2960 */
    { 0x0501, 0xb7ee, 0x3d01, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/1/1/0x1 = #2961 */
    { 0x067f, 0xb7ee, 0x3d01, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/1/2/m = #2962 */
    { 0x0600, 0xb7ee, 0xb581, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767) }, /* #63/1/2/u = #2963 */
    { 0x0601, 0xb7ee, 0x3d01, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/1/2/0x1 = #2964 */
    { 0x077f, 0xb7ee, 0x3d01, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/1/3/m = #2965 */
    { 0x0700, 0xb7ee, 0xb581, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767) }, /* #63/1/3/u = #2966 */
    { 0x0701, 0xb7ee, 0x3d01, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/1/3/0x1 = #2967 */
    { 0x087f, 0xb7ee, 0x3d01, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/2/0/m = #2968 */
    { 0x0800, 0xb7ee, 0xb581, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767) }, /* #63/2/0/u = #2969 */
    { 0x0801, 0xb7ee, 0x3d01, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/2/0/0x1 = #2970 */
    { 0x097f, 0xb7ee, 0x3d01, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/2/1/m = #2971 */
    { 0x0900, 0xb7ee, 0xb581, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767) }, /* #63/2/1/u = #2972 */
    { 0x0901, 0xb7ee, 0x3d01, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/2/1/0x1 = #2973 */
    { 0x0a7f, 0xb7ee, 0x3d01, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/2/2/m = #2974 */
    { 0x0a00, 0xb7ee, 0xb581, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767) }, /* #63/2/2/u = #2975 */
    { 0x0a01, 0xb7ee, 0x3d01, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/2/2/0x1 = #2976 */
    { 0x0b7f, 0xb7ee, 0x3d01, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/2/3/m = #2977 */
    { 0x0b00, 0xb7ee, 0xb581, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767) }, /* #63/2/3/u = #2978 */
    { 0x0b01, 0xb7ee, 0x3d01, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/2/3/0x1 = #2979 */
    { 0x0c7f, 0xb7ee, 0x3d01, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/3/0/m = #2980 */
    { 0x0c00, 0xb7ee, 0xb581, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767) }, /* #63/3/0/u = #2981 */
    { 0x0c01, 0xb7ee, 0x3d01, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/3/0/0x1 = #2982 */
    { 0x0d7f, 0xb7ee, 0x3d01, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/3/1/m = #2983 */
    { 0x0d00, 0xb7ee, 0xb581, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767) }, /* #63/3/1/u = #2984 */
    { 0x0d01, 0xb7ee, 0x3d01, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/3/1/0x1 = #2985 */
    { 0x0e7f, 0xb7ee, 0x3d01, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/3/2/m = #2986 */
    { 0x0e00, 0xb7ee, 0xb581, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767) }, /* #63/3/2/u = #2987 */
    { 0x0e01, 0xb7ee, 0x3d01, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/3/2/0x1 = #2988 */
    { 0x0f7f, 0xb7ee, 0x3d01, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/3/3/m = #2989 */
    { 0x0f00, 0xb7ee, 0xb581, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767) }, /* #63/3/3/u = #2990 */
    { 0x0f01, 0xb7ee, 0x3d01, RTFLOAT80U_INIT_C(0,0x6461f1bf4c423151,32767), RTFLOAT80U_INIT_C(1,0x9d2bb1492a8ef6bc,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/3/3/0x1 = #2991 */
    { 0x007f, 0xc7cc, 0x7d01, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/0/0/m = #2992 */
    { 0x0000, 0xc7cc, 0xf581, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767) }, /* #64/0/0/u = #2993 */
    { 0x0001, 0xc7cc, 0x7d01, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/0/0/0x1 = #2994 */
    { 0x017f, 0xc7cc, 0x7d01, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/0/1/m = #2995 */
    { 0x0100, 0xc7cc, 0xf581, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767) }, /* #64/0/1/u = #2996 */
    { 0x0101, 0xc7cc, 0x7d01, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/0/1/0x1 = #2997 */
    { 0x027f, 0xc7cc, 0x7d01, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/0/2/m = #2998 */
    { 0x0200, 0xc7cc, 0xf581, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767) }, /* #64/0/2/u = #2999 */
    { 0x0201, 0xc7cc, 0x7d01, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/0/2/0x1 = #3000 */
    { 0x037f, 0xc7cc, 0x7d01, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/0/3/m = #3001 */
    { 0x0300, 0xc7cc, 0xf581, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767) }, /* #64/0/3/u = #3002 */
    { 0x0301, 0xc7cc, 0x7d01, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/0/3/0x1 = #3003 */
    { 0x047f, 0xc7cc, 0x7d01, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/1/0/m = #3004 */
    { 0x0400, 0xc7cc, 0xf581, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767) }, /* #64/1/0/u = #3005 */
    { 0x0401, 0xc7cc, 0x7d01, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/1/0/0x1 = #3006 */
    { 0x057f, 0xc7cc, 0x7d01, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/1/1/m = #3007 */
    { 0x0500, 0xc7cc, 0xf581, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767) }, /* #64/1/1/u = #3008 */
    { 0x0501, 0xc7cc, 0x7d01, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/1/1/0x1 = #3009 */
    { 0x067f, 0xc7cc, 0x7d01, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/1/2/m = #3010 */
    { 0x0600, 0xc7cc, 0xf581, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767) }, /* #64/1/2/u = #3011 */
    { 0x0601, 0xc7cc, 0x7d01, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/1/2/0x1 = #3012 */
    { 0x077f, 0xc7cc, 0x7d01, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/1/3/m = #3013 */
    { 0x0700, 0xc7cc, 0xf581, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767) }, /* #64/1/3/u = #3014 */
    { 0x0701, 0xc7cc, 0x7d01, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/1/3/0x1 = #3015 */
    { 0x087f, 0xc7cc, 0x7d01, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/2/0/m = #3016 */
    { 0x0800, 0xc7cc, 0xf581, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767) }, /* #64/2/0/u = #3017 */
    { 0x0801, 0xc7cc, 0x7d01, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/2/0/0x1 = #3018 */
    { 0x097f, 0xc7cc, 0x7d01, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/2/1/m = #3019 */
    { 0x0900, 0xc7cc, 0xf581, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767) }, /* #64/2/1/u = #3020 */
    { 0x0901, 0xc7cc, 0x7d01, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/2/1/0x1 = #3021 */
    { 0x0a7f, 0xc7cc, 0x7d01, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/2/2/m = #3022 */
    { 0x0a00, 0xc7cc, 0xf581, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767) }, /* #64/2/2/u = #3023 */
    { 0x0a01, 0xc7cc, 0x7d01, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/2/2/0x1 = #3024 */
    { 0x0b7f, 0xc7cc, 0x7d01, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/2/3/m = #3025 */
    { 0x0b00, 0xc7cc, 0xf581, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767) }, /* #64/2/3/u = #3026 */
    { 0x0b01, 0xc7cc, 0x7d01, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/2/3/0x1 = #3027 */
    { 0x0c7f, 0xc7cc, 0x7d01, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/3/0/m = #3028 */
    { 0x0c00, 0xc7cc, 0xf581, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767) }, /* #64/3/0/u = #3029 */
    { 0x0c01, 0xc7cc, 0x7d01, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/3/0/0x1 = #3030 */
    { 0x0d7f, 0xc7cc, 0x7d01, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/3/1/m = #3031 */
    { 0x0d00, 0xc7cc, 0xf581, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767) }, /* #64/3/1/u = #3032 */
    { 0x0d01, 0xc7cc, 0x7d01, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/3/1/0x1 = #3033 */
    { 0x0e7f, 0xc7cc, 0x7d01, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/3/2/m = #3034 */
    { 0x0e00, 0xc7cc, 0xf581, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767) }, /* #64/3/2/u = #3035 */
    { 0x0e01, 0xc7cc, 0x7d01, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/3/2/0x1 = #3036 */
    { 0x0f7f, 0xc7cc, 0x7d01, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/3/3/m = #3037 */
    { 0x0f00, 0xc7cc, 0xf581, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767) }, /* #64/3/3/u = #3038 */
    { 0x0f01, 0xc7cc, 0x7d01, RTFLOAT80U_INIT_C(1,0x7b5b87e26642df5,32767), RTFLOAT80U_INIT_C(0,0xcfb8f2ec5916a7b3,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/3/3/0x1 = #3039 */
    { 0x007f, 0xacb3, 0x3c01, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/0/0/m = #3040 */
    { 0x0000, 0xacb3, 0xb481, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767) }, /* #65/0/0/u = #3041 */
    { 0x0001, 0xacb3, 0x3c01, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/0/0/0x1 = #3042 */
    { 0x017f, 0xacb3, 0x3c01, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/0/1/m = #3043 */
    { 0x0100, 0xacb3, 0xb481, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767) }, /* #65/0/1/u = #3044 */
    { 0x0101, 0xacb3, 0x3c01, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/0/1/0x1 = #3045 */
    { 0x027f, 0xacb3, 0x3c01, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/0/2/m = #3046 */
    { 0x0200, 0xacb3, 0xb481, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767) }, /* #65/0/2/u = #3047 */
    { 0x0201, 0xacb3, 0x3c01, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/0/2/0x1 = #3048 */
    { 0x037f, 0xacb3, 0x3c01, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/0/3/m = #3049 */
    { 0x0300, 0xacb3, 0xb481, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767) }, /* #65/0/3/u = #3050 */
    { 0x0301, 0xacb3, 0x3c01, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/0/3/0x1 = #3051 */
    { 0x047f, 0xacb3, 0x3c01, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/1/0/m = #3052 */
    { 0x0400, 0xacb3, 0xb481, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767) }, /* #65/1/0/u = #3053 */
    { 0x0401, 0xacb3, 0x3c01, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/1/0/0x1 = #3054 */
    { 0x057f, 0xacb3, 0x3c01, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/1/1/m = #3055 */
    { 0x0500, 0xacb3, 0xb481, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767) }, /* #65/1/1/u = #3056 */
    { 0x0501, 0xacb3, 0x3c01, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/1/1/0x1 = #3057 */
    { 0x067f, 0xacb3, 0x3c01, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/1/2/m = #3058 */
    { 0x0600, 0xacb3, 0xb481, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767) }, /* #65/1/2/u = #3059 */
    { 0x0601, 0xacb3, 0x3c01, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/1/2/0x1 = #3060 */
    { 0x077f, 0xacb3, 0x3c01, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/1/3/m = #3061 */
    { 0x0700, 0xacb3, 0xb481, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767) }, /* #65/1/3/u = #3062 */
    { 0x0701, 0xacb3, 0x3c01, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/1/3/0x1 = #3063 */
    { 0x087f, 0xacb3, 0x3c01, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/2/0/m = #3064 */
    { 0x0800, 0xacb3, 0xb481, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767) }, /* #65/2/0/u = #3065 */
    { 0x0801, 0xacb3, 0x3c01, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/2/0/0x1 = #3066 */
    { 0x097f, 0xacb3, 0x3c01, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/2/1/m = #3067 */
    { 0x0900, 0xacb3, 0xb481, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767) }, /* #65/2/1/u = #3068 */
    { 0x0901, 0xacb3, 0x3c01, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/2/1/0x1 = #3069 */
    { 0x0a7f, 0xacb3, 0x3c01, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/2/2/m = #3070 */
    { 0x0a00, 0xacb3, 0xb481, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767) }, /* #65/2/2/u = #3071 */
    { 0x0a01, 0xacb3, 0x3c01, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/2/2/0x1 = #3072 */
    { 0x0b7f, 0xacb3, 0x3c01, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/2/3/m = #3073 */
    { 0x0b00, 0xacb3, 0xb481, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767) }, /* #65/2/3/u = #3074 */
    { 0x0b01, 0xacb3, 0x3c01, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/2/3/0x1 = #3075 */
    { 0x0c7f, 0xacb3, 0x3c01, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/3/0/m = #3076 */
    { 0x0c00, 0xacb3, 0xb481, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767) }, /* #65/3/0/u = #3077 */
    { 0x0c01, 0xacb3, 0x3c01, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/3/0/0x1 = #3078 */
    { 0x0d7f, 0xacb3, 0x3c01, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/3/1/m = #3079 */
    { 0x0d00, 0xacb3, 0xb481, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767) }, /* #65/3/1/u = #3080 */
    { 0x0d01, 0xacb3, 0x3c01, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/3/1/0x1 = #3081 */
    { 0x0e7f, 0xacb3, 0x3c01, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/3/2/m = #3082 */
    { 0x0e00, 0xacb3, 0xb481, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767) }, /* #65/3/2/u = #3083 */
    { 0x0e01, 0xacb3, 0x3c01, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/3/2/0x1 = #3084 */
    { 0x0f7f, 0xacb3, 0x3c01, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/3/3/m = #3085 */
    { 0x0f00, 0xacb3, 0xb481, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767) }, /* #65/3/3/u = #3086 */
    { 0x0f01, 0xacb3, 0x3c01, RTFLOAT80U_INIT_C(0,0x7f6a1c0e83b1dce2,32767), RTFLOAT80U_INIT_C(1,0x58d442770233d62d,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/3/3/0x1 = #3087 */
    { 0x007f, 0xbb01, 0x3901, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_IND(1) }, /* #66/0/0/m = #3088 */
    { 0x0000, 0xbb01, 0xb181, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0) }, /* #66/0/0/u = #3089 */
    { 0x0001, 0xbb01, 0x3901, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_IND(1) }, /* #66/0/0/0x1 = #3090 */
    { 0x017f, 0xbb01, 0x3901, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_IND(1) }, /* #66/0/1/m = #3091 */
    { 0x0100, 0xbb01, 0xb181, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0) }, /* #66/0/1/u = #3092 */
    { 0x0101, 0xbb01, 0x3901, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_IND(1) }, /* #66/0/1/0x1 = #3093 */
    { 0x027f, 0xbb01, 0x3901, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_IND(1) }, /* #66/0/2/m = #3094 */
    { 0x0200, 0xbb01, 0xb181, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0) }, /* #66/0/2/u = #3095 */
    { 0x0201, 0xbb01, 0x3901, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_IND(1) }, /* #66/0/2/0x1 = #3096 */
    { 0x037f, 0xbb01, 0x3901, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_IND(1) }, /* #66/0/3/m = #3097 */
    { 0x0300, 0xbb01, 0xb181, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0) }, /* #66/0/3/u = #3098 */
    { 0x0301, 0xbb01, 0x3901, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_IND(1) }, /* #66/0/3/0x1 = #3099 */
    { 0x047f, 0xbb01, 0x3901, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_IND(1) }, /* #66/1/0/m = #3100 */
    { 0x0400, 0xbb01, 0xb181, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0) }, /* #66/1/0/u = #3101 */
    { 0x0401, 0xbb01, 0x3901, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_IND(1) }, /* #66/1/0/0x1 = #3102 */
    { 0x057f, 0xbb01, 0x3901, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_IND(1) }, /* #66/1/1/m = #3103 */
    { 0x0500, 0xbb01, 0xb181, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0) }, /* #66/1/1/u = #3104 */
    { 0x0501, 0xbb01, 0x3901, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_IND(1) }, /* #66/1/1/0x1 = #3105 */
    { 0x067f, 0xbb01, 0x3901, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_IND(1) }, /* #66/1/2/m = #3106 */
    { 0x0600, 0xbb01, 0xb181, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0) }, /* #66/1/2/u = #3107 */
    { 0x0601, 0xbb01, 0x3901, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_IND(1) }, /* #66/1/2/0x1 = #3108 */
    { 0x077f, 0xbb01, 0x3901, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_IND(1) }, /* #66/1/3/m = #3109 */
    { 0x0700, 0xbb01, 0xb181, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0) }, /* #66/1/3/u = #3110 */
    { 0x0701, 0xbb01, 0x3901, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_IND(1) }, /* #66/1/3/0x1 = #3111 */
    { 0x087f, 0xbb01, 0x3901, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_IND(1) }, /* #66/2/0/m = #3112 */
    { 0x0800, 0xbb01, 0xb181, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0) }, /* #66/2/0/u = #3113 */
    { 0x0801, 0xbb01, 0x3901, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_IND(1) }, /* #66/2/0/0x1 = #3114 */
    { 0x097f, 0xbb01, 0x3901, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_IND(1) }, /* #66/2/1/m = #3115 */
    { 0x0900, 0xbb01, 0xb181, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0) }, /* #66/2/1/u = #3116 */
    { 0x0901, 0xbb01, 0x3901, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_IND(1) }, /* #66/2/1/0x1 = #3117 */
    { 0x0a7f, 0xbb01, 0x3901, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_IND(1) }, /* #66/2/2/m = #3118 */
    { 0x0a00, 0xbb01, 0xb181, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0) }, /* #66/2/2/u = #3119 */
    { 0x0a01, 0xbb01, 0x3901, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_IND(1) }, /* #66/2/2/0x1 = #3120 */
    { 0x0b7f, 0xbb01, 0x3901, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_IND(1) }, /* #66/2/3/m = #3121 */
    { 0x0b00, 0xbb01, 0xb181, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0) }, /* #66/2/3/u = #3122 */
    { 0x0b01, 0xbb01, 0x3901, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_IND(1) }, /* #66/2/3/0x1 = #3123 */
    { 0x0c7f, 0xbb01, 0x3901, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_IND(1) }, /* #66/3/0/m = #3124 */
    { 0x0c00, 0xbb01, 0xb181, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0) }, /* #66/3/0/u = #3125 */
    { 0x0c01, 0xbb01, 0x3901, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_IND(1) }, /* #66/3/0/0x1 = #3126 */
    { 0x0d7f, 0xbb01, 0x3901, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_IND(1) }, /* #66/3/1/m = #3127 */
    { 0x0d00, 0xbb01, 0xb181, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0) }, /* #66/3/1/u = #3128 */
    { 0x0d01, 0xbb01, 0x3901, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_IND(1) }, /* #66/3/1/0x1 = #3129 */
    { 0x0e7f, 0xbb01, 0x3901, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_IND(1) }, /* #66/3/2/m = #3130 */
    { 0x0e00, 0xbb01, 0xb181, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0) }, /* #66/3/2/u = #3131 */
    { 0x0e01, 0xbb01, 0x3901, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_IND(1) }, /* #66/3/2/0x1 = #3132 */
    { 0x0f7f, 0xbb01, 0x3901, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_IND(1) }, /* #66/3/3/m = #3133 */
    { 0x0f00, 0xbb01, 0xb181, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0) }, /* #66/3/3/u = #3134 */
    { 0x0f01, 0xbb01, 0x3901, RTFLOAT80U_INIT_C(0,0x293b5290b14ebb59,32767), RTFLOAT80U_INIT_C(1,0xfe05f43816483077,0), RTFLOAT80U_INIT_IND(1) }, /* #66/3/3/0x1 = #3135 */
    { 0x007f, 0xfa05, 0x7801, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_IND(1) }, /* #67/0/0/m = #3136 */
    { 0x0000, 0xfa05, 0xf081, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0) }, /* #67/0/0/u = #3137 */
    { 0x0001, 0xfa05, 0x7801, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_IND(1) }, /* #67/0/0/0x1 = #3138 */
    { 0x017f, 0xfa05, 0x7801, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_IND(1) }, /* #67/0/1/m = #3139 */
    { 0x0100, 0xfa05, 0xf081, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0) }, /* #67/0/1/u = #3140 */
    { 0x0101, 0xfa05, 0x7801, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_IND(1) }, /* #67/0/1/0x1 = #3141 */
    { 0x027f, 0xfa05, 0x7801, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_IND(1) }, /* #67/0/2/m = #3142 */
    { 0x0200, 0xfa05, 0xf081, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0) }, /* #67/0/2/u = #3143 */
    { 0x0201, 0xfa05, 0x7801, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_IND(1) }, /* #67/0/2/0x1 = #3144 */
    { 0x037f, 0xfa05, 0x7801, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_IND(1) }, /* #67/0/3/m = #3145 */
    { 0x0300, 0xfa05, 0xf081, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0) }, /* #67/0/3/u = #3146 */
    { 0x0301, 0xfa05, 0x7801, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_IND(1) }, /* #67/0/3/0x1 = #3147 */
    { 0x047f, 0xfa05, 0x7801, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_IND(1) }, /* #67/1/0/m = #3148 */
    { 0x0400, 0xfa05, 0xf081, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0) }, /* #67/1/0/u = #3149 */
    { 0x0401, 0xfa05, 0x7801, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_IND(1) }, /* #67/1/0/0x1 = #3150 */
    { 0x057f, 0xfa05, 0x7801, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_IND(1) }, /* #67/1/1/m = #3151 */
    { 0x0500, 0xfa05, 0xf081, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0) }, /* #67/1/1/u = #3152 */
    { 0x0501, 0xfa05, 0x7801, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_IND(1) }, /* #67/1/1/0x1 = #3153 */
    { 0x067f, 0xfa05, 0x7801, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_IND(1) }, /* #67/1/2/m = #3154 */
    { 0x0600, 0xfa05, 0xf081, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0) }, /* #67/1/2/u = #3155 */
    { 0x0601, 0xfa05, 0x7801, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_IND(1) }, /* #67/1/2/0x1 = #3156 */
    { 0x077f, 0xfa05, 0x7801, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_IND(1) }, /* #67/1/3/m = #3157 */
    { 0x0700, 0xfa05, 0xf081, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0) }, /* #67/1/3/u = #3158 */
    { 0x0701, 0xfa05, 0x7801, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_IND(1) }, /* #67/1/3/0x1 = #3159 */
    { 0x087f, 0xfa05, 0x7801, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_IND(1) }, /* #67/2/0/m = #3160 */
    { 0x0800, 0xfa05, 0xf081, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0) }, /* #67/2/0/u = #3161 */
    { 0x0801, 0xfa05, 0x7801, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_IND(1) }, /* #67/2/0/0x1 = #3162 */
    { 0x097f, 0xfa05, 0x7801, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_IND(1) }, /* #67/2/1/m = #3163 */
    { 0x0900, 0xfa05, 0xf081, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0) }, /* #67/2/1/u = #3164 */
    { 0x0901, 0xfa05, 0x7801, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_IND(1) }, /* #67/2/1/0x1 = #3165 */
    { 0x0a7f, 0xfa05, 0x7801, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_IND(1) }, /* #67/2/2/m = #3166 */
    { 0x0a00, 0xfa05, 0xf081, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0) }, /* #67/2/2/u = #3167 */
    { 0x0a01, 0xfa05, 0x7801, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_IND(1) }, /* #67/2/2/0x1 = #3168 */
    { 0x0b7f, 0xfa05, 0x7801, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_IND(1) }, /* #67/2/3/m = #3169 */
    { 0x0b00, 0xfa05, 0xf081, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0) }, /* #67/2/3/u = #3170 */
    { 0x0b01, 0xfa05, 0x7801, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_IND(1) }, /* #67/2/3/0x1 = #3171 */
    { 0x0c7f, 0xfa05, 0x7801, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_IND(1) }, /* #67/3/0/m = #3172 */
    { 0x0c00, 0xfa05, 0xf081, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0) }, /* #67/3/0/u = #3173 */
    { 0x0c01, 0xfa05, 0x7801, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_IND(1) }, /* #67/3/0/0x1 = #3174 */
    { 0x0d7f, 0xfa05, 0x7801, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_IND(1) }, /* #67/3/1/m = #3175 */
    { 0x0d00, 0xfa05, 0xf081, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0) }, /* #67/3/1/u = #3176 */
    { 0x0d01, 0xfa05, 0x7801, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_IND(1) }, /* #67/3/1/0x1 = #3177 */
    { 0x0e7f, 0xfa05, 0x7801, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_IND(1) }, /* #67/3/2/m = #3178 */
    { 0x0e00, 0xfa05, 0xf081, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0) }, /* #67/3/2/u = #3179 */
    { 0x0e01, 0xfa05, 0x7801, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_IND(1) }, /* #67/3/2/0x1 = #3180 */
    { 0x0f7f, 0xfa05, 0x7801, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_IND(1) }, /* #67/3/3/m = #3181 */
    { 0x0f00, 0xfa05, 0xf081, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0) }, /* #67/3/3/u = #3182 */
    { 0x0f01, 0xfa05, 0x7801, RTFLOAT80U_INIT_C(0,0xc56ef34f730a588,32767), RTFLOAT80U_INIT_C(0,0x3c34a0cf6bdec747,0), RTFLOAT80U_INIT_IND(1) }, /* #67/3/3/0x1 = #3183 */
    { 0x007f, 0x4638, 0x7c01, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/0/0/m = #3184 */
    { 0x0000, 0x4638, 0xf481, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #68/0/0/u = #3185 */
    { 0x0001, 0x4638, 0x7c01, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/0/0/0x1 = #3186 */
    { 0x017f, 0x4638, 0x7c01, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/0/1/m = #3187 */
    { 0x0100, 0x4638, 0xf481, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #68/0/1/u = #3188 */
    { 0x0101, 0x4638, 0x7c01, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/0/1/0x1 = #3189 */
    { 0x027f, 0x4638, 0x7c01, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/0/2/m = #3190 */
    { 0x0200, 0x4638, 0xf481, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #68/0/2/u = #3191 */
    { 0x0201, 0x4638, 0x7c01, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/0/2/0x1 = #3192 */
    { 0x037f, 0x4638, 0x7c01, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/0/3/m = #3193 */
    { 0x0300, 0x4638, 0xf481, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #68/0/3/u = #3194 */
    { 0x0301, 0x4638, 0x7c01, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/0/3/0x1 = #3195 */
    { 0x047f, 0x4638, 0x7c01, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/1/0/m = #3196 */
    { 0x0400, 0x4638, 0xf481, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #68/1/0/u = #3197 */
    { 0x0401, 0x4638, 0x7c01, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/1/0/0x1 = #3198 */
    { 0x057f, 0x4638, 0x7c01, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/1/1/m = #3199 */
    { 0x0500, 0x4638, 0xf481, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #68/1/1/u = #3200 */
    { 0x0501, 0x4638, 0x7c01, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/1/1/0x1 = #3201 */
    { 0x067f, 0x4638, 0x7c01, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/1/2/m = #3202 */
    { 0x0600, 0x4638, 0xf481, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #68/1/2/u = #3203 */
    { 0x0601, 0x4638, 0x7c01, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/1/2/0x1 = #3204 */
    { 0x077f, 0x4638, 0x7c01, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/1/3/m = #3205 */
    { 0x0700, 0x4638, 0xf481, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #68/1/3/u = #3206 */
    { 0x0701, 0x4638, 0x7c01, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/1/3/0x1 = #3207 */
    { 0x087f, 0x4638, 0x7c01, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/2/0/m = #3208 */
    { 0x0800, 0x4638, 0xf481, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #68/2/0/u = #3209 */
    { 0x0801, 0x4638, 0x7c01, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/2/0/0x1 = #3210 */
    { 0x097f, 0x4638, 0x7c01, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/2/1/m = #3211 */
    { 0x0900, 0x4638, 0xf481, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #68/2/1/u = #3212 */
    { 0x0901, 0x4638, 0x7c01, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/2/1/0x1 = #3213 */
    { 0x0a7f, 0x4638, 0x7c01, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/2/2/m = #3214 */
    { 0x0a00, 0x4638, 0xf481, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #68/2/2/u = #3215 */
    { 0x0a01, 0x4638, 0x7c01, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/2/2/0x1 = #3216 */
    { 0x0b7f, 0x4638, 0x7c01, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/2/3/m = #3217 */
    { 0x0b00, 0x4638, 0xf481, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #68/2/3/u = #3218 */
    { 0x0b01, 0x4638, 0x7c01, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/2/3/0x1 = #3219 */
    { 0x0c7f, 0x4638, 0x7c01, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/3/0/m = #3220 */
    { 0x0c00, 0x4638, 0xf481, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #68/3/0/u = #3221 */
    { 0x0c01, 0x4638, 0x7c01, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/3/0/0x1 = #3222 */
    { 0x0d7f, 0x4638, 0x7c01, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/3/1/m = #3223 */
    { 0x0d00, 0x4638, 0xf481, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #68/3/1/u = #3224 */
    { 0x0d01, 0x4638, 0x7c01, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/3/1/0x1 = #3225 */
    { 0x0e7f, 0x4638, 0x7c01, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/3/2/m = #3226 */
    { 0x0e00, 0x4638, 0xf481, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #68/3/2/u = #3227 */
    { 0x0e01, 0x4638, 0x7c01, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/3/2/0x1 = #3228 */
    { 0x0f7f, 0x4638, 0x7c01, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/3/3/m = #3229 */
    { 0x0f00, 0x4638, 0xf481, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #68/3/3/u = #3230 */
    { 0x0f01, 0x4638, 0x7c01, RTFLOAT80U_INIT_C(0,0x6f0e7492d32c573e,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/3/3/0x1 = #3231 */
    { 0x007f, 0x5c2c, 0x7c01, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #69/0/0/m = #3232 */
    { 0x0000, 0x5c2c, 0xf481, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #69/0/0/u = #3233 */
    { 0x0001, 0x5c2c, 0x7c01, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #69/0/0/0x1 = #3234 */
    { 0x017f, 0x5c2c, 0x7c01, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #69/0/1/m = #3235 */
    { 0x0100, 0x5c2c, 0xf481, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #69/0/1/u = #3236 */
    { 0x0101, 0x5c2c, 0x7c01, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #69/0/1/0x1 = #3237 */
    { 0x027f, 0x5c2c, 0x7c01, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #69/0/2/m = #3238 */
    { 0x0200, 0x5c2c, 0xf481, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #69/0/2/u = #3239 */
    { 0x0201, 0x5c2c, 0x7c01, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #69/0/2/0x1 = #3240 */
    { 0x037f, 0x5c2c, 0x7c01, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #69/0/3/m = #3241 */
    { 0x0300, 0x5c2c, 0xf481, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #69/0/3/u = #3242 */
    { 0x0301, 0x5c2c, 0x7c01, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #69/0/3/0x1 = #3243 */
    { 0x047f, 0x5c2c, 0x7c01, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #69/1/0/m = #3244 */
    { 0x0400, 0x5c2c, 0xf481, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #69/1/0/u = #3245 */
    { 0x0401, 0x5c2c, 0x7c01, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #69/1/0/0x1 = #3246 */
    { 0x057f, 0x5c2c, 0x7c01, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #69/1/1/m = #3247 */
    { 0x0500, 0x5c2c, 0xf481, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #69/1/1/u = #3248 */
    { 0x0501, 0x5c2c, 0x7c01, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #69/1/1/0x1 = #3249 */
    { 0x067f, 0x5c2c, 0x7c01, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #69/1/2/m = #3250 */
    { 0x0600, 0x5c2c, 0xf481, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #69/1/2/u = #3251 */
    { 0x0601, 0x5c2c, 0x7c01, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #69/1/2/0x1 = #3252 */
    { 0x077f, 0x5c2c, 0x7c01, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #69/1/3/m = #3253 */
    { 0x0700, 0x5c2c, 0xf481, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #69/1/3/u = #3254 */
    { 0x0701, 0x5c2c, 0x7c01, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #69/1/3/0x1 = #3255 */
    { 0x087f, 0x5c2c, 0x7c01, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #69/2/0/m = #3256 */
    { 0x0800, 0x5c2c, 0xf481, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #69/2/0/u = #3257 */
    { 0x0801, 0x5c2c, 0x7c01, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #69/2/0/0x1 = #3258 */
    { 0x097f, 0x5c2c, 0x7c01, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #69/2/1/m = #3259 */
    { 0x0900, 0x5c2c, 0xf481, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #69/2/1/u = #3260 */
    { 0x0901, 0x5c2c, 0x7c01, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #69/2/1/0x1 = #3261 */
    { 0x0a7f, 0x5c2c, 0x7c01, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #69/2/2/m = #3262 */
    { 0x0a00, 0x5c2c, 0xf481, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #69/2/2/u = #3263 */
    { 0x0a01, 0x5c2c, 0x7c01, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #69/2/2/0x1 = #3264 */
    { 0x0b7f, 0x5c2c, 0x7c01, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #69/2/3/m = #3265 */
    { 0x0b00, 0x5c2c, 0xf481, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #69/2/3/u = #3266 */
    { 0x0b01, 0x5c2c, 0x7c01, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #69/2/3/0x1 = #3267 */
    { 0x0c7f, 0x5c2c, 0x7c01, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #69/3/0/m = #3268 */
    { 0x0c00, 0x5c2c, 0xf481, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #69/3/0/u = #3269 */
    { 0x0c01, 0x5c2c, 0x7c01, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #69/3/0/0x1 = #3270 */
    { 0x0d7f, 0x5c2c, 0x7c01, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #69/3/1/m = #3271 */
    { 0x0d00, 0x5c2c, 0xf481, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #69/3/1/u = #3272 */
    { 0x0d01, 0x5c2c, 0x7c01, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #69/3/1/0x1 = #3273 */
    { 0x0e7f, 0x5c2c, 0x7c01, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #69/3/2/m = #3274 */
    { 0x0e00, 0x5c2c, 0xf481, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #69/3/2/u = #3275 */
    { 0x0e01, 0x5c2c, 0x7c01, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #69/3/2/0x1 = #3276 */
    { 0x0f7f, 0x5c2c, 0x7c01, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #69/3/3/m = #3277 */
    { 0x0f00, 0x5c2c, 0xf481, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #69/3/3/u = #3278 */
    { 0x0f01, 0x5c2c, 0x7c01, RTFLOAT80U_INIT_C(1,0x2026e3879d906cb5,32767), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #69/3/3/0x1 = #3279 */
    { 0x007f, 0x6ebd, 0x7c01, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/0/0/m = #3280 */
    { 0x0000, 0x6ebd, 0xf481, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #70/0/0/u = #3281 */
    { 0x0001, 0x6ebd, 0x7c01, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/0/0/0x1 = #3282 */
    { 0x017f, 0x6ebd, 0x7c01, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/0/1/m = #3283 */
    { 0x0100, 0x6ebd, 0xf481, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #70/0/1/u = #3284 */
    { 0x0101, 0x6ebd, 0x7c01, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/0/1/0x1 = #3285 */
    { 0x027f, 0x6ebd, 0x7c01, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/0/2/m = #3286 */
    { 0x0200, 0x6ebd, 0xf481, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #70/0/2/u = #3287 */
    { 0x0201, 0x6ebd, 0x7c01, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/0/2/0x1 = #3288 */
    { 0x037f, 0x6ebd, 0x7c01, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/0/3/m = #3289 */
    { 0x0300, 0x6ebd, 0xf481, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #70/0/3/u = #3290 */
    { 0x0301, 0x6ebd, 0x7c01, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/0/3/0x1 = #3291 */
    { 0x047f, 0x6ebd, 0x7c01, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/1/0/m = #3292 */
    { 0x0400, 0x6ebd, 0xf481, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #70/1/0/u = #3293 */
    { 0x0401, 0x6ebd, 0x7c01, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/1/0/0x1 = #3294 */
    { 0x057f, 0x6ebd, 0x7c01, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/1/1/m = #3295 */
    { 0x0500, 0x6ebd, 0xf481, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #70/1/1/u = #3296 */
    { 0x0501, 0x6ebd, 0x7c01, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/1/1/0x1 = #3297 */
    { 0x067f, 0x6ebd, 0x7c01, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/1/2/m = #3298 */
    { 0x0600, 0x6ebd, 0xf481, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #70/1/2/u = #3299 */
    { 0x0601, 0x6ebd, 0x7c01, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/1/2/0x1 = #3300 */
    { 0x077f, 0x6ebd, 0x7c01, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/1/3/m = #3301 */
    { 0x0700, 0x6ebd, 0xf481, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #70/1/3/u = #3302 */
    { 0x0701, 0x6ebd, 0x7c01, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/1/3/0x1 = #3303 */
    { 0x087f, 0x6ebd, 0x7c01, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/2/0/m = #3304 */
    { 0x0800, 0x6ebd, 0xf481, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #70/2/0/u = #3305 */
    { 0x0801, 0x6ebd, 0x7c01, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/2/0/0x1 = #3306 */
    { 0x097f, 0x6ebd, 0x7c01, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/2/1/m = #3307 */
    { 0x0900, 0x6ebd, 0xf481, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #70/2/1/u = #3308 */
    { 0x0901, 0x6ebd, 0x7c01, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/2/1/0x1 = #3309 */
    { 0x0a7f, 0x6ebd, 0x7c01, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/2/2/m = #3310 */
    { 0x0a00, 0x6ebd, 0xf481, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #70/2/2/u = #3311 */
    { 0x0a01, 0x6ebd, 0x7c01, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/2/2/0x1 = #3312 */
    { 0x0b7f, 0x6ebd, 0x7c01, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/2/3/m = #3313 */
    { 0x0b00, 0x6ebd, 0xf481, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #70/2/3/u = #3314 */
    { 0x0b01, 0x6ebd, 0x7c01, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/2/3/0x1 = #3315 */
    { 0x0c7f, 0x6ebd, 0x7c01, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/3/0/m = #3316 */
    { 0x0c00, 0x6ebd, 0xf481, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #70/3/0/u = #3317 */
    { 0x0c01, 0x6ebd, 0x7c01, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/3/0/0x1 = #3318 */
    { 0x0d7f, 0x6ebd, 0x7c01, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/3/1/m = #3319 */
    { 0x0d00, 0x6ebd, 0xf481, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #70/3/1/u = #3320 */
    { 0x0d01, 0x6ebd, 0x7c01, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/3/1/0x1 = #3321 */
    { 0x0e7f, 0x6ebd, 0x7c01, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/3/2/m = #3322 */
    { 0x0e00, 0x6ebd, 0xf481, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #70/3/2/u = #3323 */
    { 0x0e01, 0x6ebd, 0x7c01, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/3/2/0x1 = #3324 */
    { 0x0f7f, 0x6ebd, 0x7c01, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/3/3/m = #3325 */
    { 0x0f00, 0x6ebd, 0xf481, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #70/3/3/u = #3326 */
    { 0x0f01, 0x6ebd, 0x7c01, RTFLOAT80U_INIT_C(0,0x2fe71e30766a20d5,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/3/3/0x1 = #3327 */
    { 0x007f, 0x29d1, 0x3901, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #71/0/0/m = #3328 */
    { 0x0000, 0x29d1, 0xb181, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #71/0/0/u = #3329 */
    { 0x0001, 0x29d1, 0x3901, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #71/0/0/0x1 = #3330 */
    { 0x017f, 0x29d1, 0x3901, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #71/0/1/m = #3331 */
    { 0x0100, 0x29d1, 0xb181, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #71/0/1/u = #3332 */
    { 0x0101, 0x29d1, 0x3901, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #71/0/1/0x1 = #3333 */
    { 0x027f, 0x29d1, 0x3901, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #71/0/2/m = #3334 */
    { 0x0200, 0x29d1, 0xb181, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #71/0/2/u = #3335 */
    { 0x0201, 0x29d1, 0x3901, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #71/0/2/0x1 = #3336 */
    { 0x037f, 0x29d1, 0x3901, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #71/0/3/m = #3337 */
    { 0x0300, 0x29d1, 0xb181, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #71/0/3/u = #3338 */
    { 0x0301, 0x29d1, 0x3901, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #71/0/3/0x1 = #3339 */
    { 0x047f, 0x29d1, 0x3901, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #71/1/0/m = #3340 */
    { 0x0400, 0x29d1, 0xb181, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #71/1/0/u = #3341 */
    { 0x0401, 0x29d1, 0x3901, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #71/1/0/0x1 = #3342 */
    { 0x057f, 0x29d1, 0x3901, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #71/1/1/m = #3343 */
    { 0x0500, 0x29d1, 0xb181, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #71/1/1/u = #3344 */
    { 0x0501, 0x29d1, 0x3901, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #71/1/1/0x1 = #3345 */
    { 0x067f, 0x29d1, 0x3901, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #71/1/2/m = #3346 */
    { 0x0600, 0x29d1, 0xb181, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #71/1/2/u = #3347 */
    { 0x0601, 0x29d1, 0x3901, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #71/1/2/0x1 = #3348 */
    { 0x077f, 0x29d1, 0x3901, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #71/1/3/m = #3349 */
    { 0x0700, 0x29d1, 0xb181, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #71/1/3/u = #3350 */
    { 0x0701, 0x29d1, 0x3901, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #71/1/3/0x1 = #3351 */
    { 0x087f, 0x29d1, 0x3901, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #71/2/0/m = #3352 */
    { 0x0800, 0x29d1, 0xb181, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #71/2/0/u = #3353 */
    { 0x0801, 0x29d1, 0x3901, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #71/2/0/0x1 = #3354 */
    { 0x097f, 0x29d1, 0x3901, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #71/2/1/m = #3355 */
    { 0x0900, 0x29d1, 0xb181, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #71/2/1/u = #3356 */
    { 0x0901, 0x29d1, 0x3901, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #71/2/1/0x1 = #3357 */
    { 0x0a7f, 0x29d1, 0x3901, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #71/2/2/m = #3358 */
    { 0x0a00, 0x29d1, 0xb181, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #71/2/2/u = #3359 */
    { 0x0a01, 0x29d1, 0x3901, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #71/2/2/0x1 = #3360 */
    { 0x0b7f, 0x29d1, 0x3901, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #71/2/3/m = #3361 */
    { 0x0b00, 0x29d1, 0xb181, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #71/2/3/u = #3362 */
    { 0x0b01, 0x29d1, 0x3901, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #71/2/3/0x1 = #3363 */
    { 0x0c7f, 0x29d1, 0x3901, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #71/3/0/m = #3364 */
    { 0x0c00, 0x29d1, 0xb181, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #71/3/0/u = #3365 */
    { 0x0c01, 0x29d1, 0x3901, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #71/3/0/0x1 = #3366 */
    { 0x0d7f, 0x29d1, 0x3901, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #71/3/1/m = #3367 */
    { 0x0d00, 0x29d1, 0xb181, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #71/3/1/u = #3368 */
    { 0x0d01, 0x29d1, 0x3901, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #71/3/1/0x1 = #3369 */
    { 0x0e7f, 0x29d1, 0x3901, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #71/3/2/m = #3370 */
    { 0x0e00, 0x29d1, 0xb181, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #71/3/2/u = #3371 */
    { 0x0e01, 0x29d1, 0x3901, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #71/3/2/0x1 = #3372 */
    { 0x0f7f, 0x29d1, 0x3901, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #71/3/3/m = #3373 */
    { 0x0f00, 0x29d1, 0xb181, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #71/3/3/u = #3374 */
    { 0x0f01, 0x29d1, 0x3901, RTFLOAT80U_INIT_C(0,0x4633f141a84f5da6,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #71/3/3/0x1 = #3375 */
    { 0x007f, 0x1ed7, 0x3c22, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/0/0/m = #3376 */
    { 0x0000, 0x1ed7, 0xb482, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201) }, /* #72/0/0/u = #3377 */
    { 0x0022, 0x1ed7, 0x3c22, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/0/0/0x22 = #3378 */
    { 0x0020, 0x1ed7, 0xb482, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201) }, /* #72/0/0/u0x2 = #3379 */
    { 0x0002, 0x1ed7, 0xbca2, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/0/0/u0x20 = #3380 */
    { 0x017f, 0x1ed7, 0x3c22, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/0/1/m = #3381 */
    { 0x0100, 0x1ed7, 0xb482, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201) }, /* #72/0/1/u = #3382 */
    { 0x0122, 0x1ed7, 0x3c22, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/0/1/0x22 = #3383 */
    { 0x0120, 0x1ed7, 0xb482, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201) }, /* #72/0/1/u0x2 = #3384 */
    { 0x0102, 0x1ed7, 0xbca2, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/0/1/u0x20 = #3385 */
    { 0x027f, 0x1ed7, 0x3c22, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/0/2/m = #3386 */
    { 0x0200, 0x1ed7, 0xb482, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201) }, /* #72/0/2/u = #3387 */
    { 0x0222, 0x1ed7, 0x3c22, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/0/2/0x22 = #3388 */
    { 0x0220, 0x1ed7, 0xb482, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201) }, /* #72/0/2/u0x2 = #3389 */
    { 0x0202, 0x1ed7, 0xbca2, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/0/2/u0x20 = #3390 */
    { 0x037f, 0x1ed7, 0x3c22, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/0/3/m = #3391 */
    { 0x0300, 0x1ed7, 0xb482, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201) }, /* #72/0/3/u = #3392 */
    { 0x0322, 0x1ed7, 0x3c22, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/0/3/0x22 = #3393 */
    { 0x0320, 0x1ed7, 0xb482, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201) }, /* #72/0/3/u0x2 = #3394 */
    { 0x0302, 0x1ed7, 0xbca2, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/0/3/u0x20 = #3395 */
    { 0x047f, 0x1ed7, 0x3c22, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/1/0/m = #3396 */
    { 0x0400, 0x1ed7, 0xb482, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201) }, /* #72/1/0/u = #3397 */
    { 0x0422, 0x1ed7, 0x3c22, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/1/0/0x22 = #3398 */
    { 0x0420, 0x1ed7, 0xb482, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201) }, /* #72/1/0/u0x2 = #3399 */
    { 0x0402, 0x1ed7, 0xbca2, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/1/0/u0x20 = #3400 */
    { 0x057f, 0x1ed7, 0x3c22, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/1/1/m = #3401 */
    { 0x0500, 0x1ed7, 0xb482, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201) }, /* #72/1/1/u = #3402 */
    { 0x0522, 0x1ed7, 0x3c22, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/1/1/0x22 = #3403 */
    { 0x0520, 0x1ed7, 0xb482, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201) }, /* #72/1/1/u0x2 = #3404 */
    { 0x0502, 0x1ed7, 0xbca2, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/1/1/u0x20 = #3405 */
    { 0x067f, 0x1ed7, 0x3c22, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/1/2/m = #3406 */
    { 0x0600, 0x1ed7, 0xb482, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201) }, /* #72/1/2/u = #3407 */
    { 0x0622, 0x1ed7, 0x3c22, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/1/2/0x22 = #3408 */
    { 0x0620, 0x1ed7, 0xb482, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201) }, /* #72/1/2/u0x2 = #3409 */
    { 0x0602, 0x1ed7, 0xbca2, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/1/2/u0x20 = #3410 */
    { 0x077f, 0x1ed7, 0x3c22, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/1/3/m = #3411 */
    { 0x0700, 0x1ed7, 0xb482, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201) }, /* #72/1/3/u = #3412 */
    { 0x0722, 0x1ed7, 0x3c22, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/1/3/0x22 = #3413 */
    { 0x0720, 0x1ed7, 0xb482, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201) }, /* #72/1/3/u0x2 = #3414 */
    { 0x0702, 0x1ed7, 0xbca2, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/1/3/u0x20 = #3415 */
    { 0x087f, 0x1ed7, 0x3c22, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/2/0/m = #3416 */
    { 0x0800, 0x1ed7, 0xb482, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201) }, /* #72/2/0/u = #3417 */
    { 0x0822, 0x1ed7, 0x3c22, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/2/0/0x22 = #3418 */
    { 0x0820, 0x1ed7, 0xb482, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201) }, /* #72/2/0/u0x2 = #3419 */
    { 0x0802, 0x1ed7, 0xbca2, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/2/0/u0x20 = #3420 */
    { 0x097f, 0x1ed7, 0x3c22, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/2/1/m = #3421 */
    { 0x0900, 0x1ed7, 0xb482, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201) }, /* #72/2/1/u = #3422 */
    { 0x0922, 0x1ed7, 0x3c22, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/2/1/0x22 = #3423 */
    { 0x0920, 0x1ed7, 0xb482, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201) }, /* #72/2/1/u0x2 = #3424 */
    { 0x0902, 0x1ed7, 0xbca2, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/2/1/u0x20 = #3425 */
    { 0x0a7f, 0x1ed7, 0x3c22, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/2/2/m = #3426 */
    { 0x0a00, 0x1ed7, 0xb482, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201) }, /* #72/2/2/u = #3427 */
    { 0x0a22, 0x1ed7, 0x3c22, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/2/2/0x22 = #3428 */
    { 0x0a20, 0x1ed7, 0xb482, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201) }, /* #72/2/2/u0x2 = #3429 */
    { 0x0a02, 0x1ed7, 0xbca2, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/2/2/u0x20 = #3430 */
    { 0x0b7f, 0x1ed7, 0x3c22, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/2/3/m = #3431 */
    { 0x0b00, 0x1ed7, 0xb482, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201) }, /* #72/2/3/u = #3432 */
    { 0x0b22, 0x1ed7, 0x3c22, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/2/3/0x22 = #3433 */
    { 0x0b20, 0x1ed7, 0xb482, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201) }, /* #72/2/3/u0x2 = #3434 */
    { 0x0b02, 0x1ed7, 0xbca2, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/2/3/u0x20 = #3435 */
    { 0x0c7f, 0x1ed7, 0x3c22, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/3/0/m = #3436 */
    { 0x0c00, 0x1ed7, 0xb482, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201) }, /* #72/3/0/u = #3437 */
    { 0x0c22, 0x1ed7, 0x3c22, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/3/0/0x22 = #3438 */
    { 0x0c20, 0x1ed7, 0xb482, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201) }, /* #72/3/0/u0x2 = #3439 */
    { 0x0c02, 0x1ed7, 0xbca2, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/3/0/u0x20 = #3440 */
    { 0x0d7f, 0x1ed7, 0x3c22, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/3/1/m = #3441 */
    { 0x0d00, 0x1ed7, 0xb482, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201) }, /* #72/3/1/u = #3442 */
    { 0x0d22, 0x1ed7, 0x3c22, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/3/1/0x22 = #3443 */
    { 0x0d20, 0x1ed7, 0xb482, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201) }, /* #72/3/1/u0x2 = #3444 */
    { 0x0d02, 0x1ed7, 0xbca2, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/3/1/u0x20 = #3445 */
    { 0x0e7f, 0x1ed7, 0x3c22, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/3/2/m = #3446 */
    { 0x0e00, 0x1ed7, 0xb482, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201) }, /* #72/3/2/u = #3447 */
    { 0x0e22, 0x1ed7, 0x3c22, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/3/2/0x22 = #3448 */
    { 0x0e20, 0x1ed7, 0xb482, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201) }, /* #72/3/2/u0x2 = #3449 */
    { 0x0e02, 0x1ed7, 0xbca2, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/3/2/u0x20 = #3450 */
    { 0x0f7f, 0x1ed7, 0x3c22, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/3/3/m = #3451 */
    { 0x0f00, 0x1ed7, 0xb482, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201) }, /* #72/3/3/u = #3452 */
    { 0x0f22, 0x1ed7, 0x3c22, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/3/3/0x22 = #3453 */
    { 0x0f20, 0x1ed7, 0xb482, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201) }, /* #72/3/3/u0x2 = #3454 */
    { 0x0f02, 0x1ed7, 0xbca2, RTFLOAT80U_INIT_C(0,0x93e6edee2bcc1bcb,0), RTFLOAT80U_INIT_C(0,0xbf099315ce3bee1c,2201), RTFLOAT80U_INIT_C(0,0xc63248c37e756136,14182) }, /* #72/3/3/u0x20 = #3455 */
    { 0x007f, 0x390d, 0x3b22, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #73/0/0/m = #3456 */
    { 0x0000, 0x390d, 0xb182, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044) }, /* #73/0/0/u = #3457 */
    { 0x0022, 0x390d, 0x3b22, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #73/0/0/0x22 = #3458 */
    { 0x0020, 0x390d, 0xb182, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044) }, /* #73/0/0/u0x2 = #3459 */
    { 0x0002, 0x390d, 0xbba2, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #73/0/0/u0x20 = #3460 */
    { 0x017f, 0x390d, 0x3b22, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #73/0/1/m = #3461 */
    { 0x0100, 0x390d, 0xb182, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044) }, /* #73/0/1/u = #3462 */
    { 0x0122, 0x390d, 0x3b22, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #73/0/1/0x22 = #3463 */
    { 0x0120, 0x390d, 0xb182, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044) }, /* #73/0/1/u0x2 = #3464 */
    { 0x0102, 0x390d, 0xbba2, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #73/0/1/u0x20 = #3465 */
    { 0x027f, 0x390d, 0x3b22, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #73/0/2/m = #3466 */
    { 0x0200, 0x390d, 0xb182, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044) }, /* #73/0/2/u = #3467 */
    { 0x0222, 0x390d, 0x3b22, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #73/0/2/0x22 = #3468 */
    { 0x0220, 0x390d, 0xb182, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044) }, /* #73/0/2/u0x2 = #3469 */
    { 0x0202, 0x390d, 0xbba2, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #73/0/2/u0x20 = #3470 */
    { 0x037f, 0x390d, 0x3b22, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #73/0/3/m = #3471 */
    { 0x0300, 0x390d, 0xb182, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044) }, /* #73/0/3/u = #3472 */
    { 0x0322, 0x390d, 0x3b22, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #73/0/3/0x22 = #3473 */
    { 0x0320, 0x390d, 0xb182, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044) }, /* #73/0/3/u0x2 = #3474 */
    { 0x0302, 0x390d, 0xbba2, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #73/0/3/u0x20 = #3475 */
    { 0x047f, 0x390d, 0x3922, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #73/1/0/m = #3476 */
    { 0x0400, 0x390d, 0xb182, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044) }, /* #73/1/0/u = #3477 */
    { 0x0422, 0x390d, 0x3922, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #73/1/0/0x22 = #3478 */
    { 0x0420, 0x390d, 0xb182, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044) }, /* #73/1/0/u0x2 = #3479 */
    { 0x0402, 0x390d, 0xb9a2, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #73/1/0/u0x20 = #3480 */
    { 0x057f, 0x390d, 0x3922, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #73/1/1/m = #3481 */
    { 0x0500, 0x390d, 0xb182, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044) }, /* #73/1/1/u = #3482 */
    { 0x0522, 0x390d, 0x3922, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #73/1/1/0x22 = #3483 */
    { 0x0520, 0x390d, 0xb182, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044) }, /* #73/1/1/u0x2 = #3484 */
    { 0x0502, 0x390d, 0xb9a2, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #73/1/1/u0x20 = #3485 */
    { 0x067f, 0x390d, 0x3922, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #73/1/2/m = #3486 */
    { 0x0600, 0x390d, 0xb182, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044) }, /* #73/1/2/u = #3487 */
    { 0x0622, 0x390d, 0x3922, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #73/1/2/0x22 = #3488 */
    { 0x0620, 0x390d, 0xb182, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044) }, /* #73/1/2/u0x2 = #3489 */
    { 0x0602, 0x390d, 0xb9a2, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #73/1/2/u0x20 = #3490 */
    { 0x077f, 0x390d, 0x3922, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #73/1/3/m = #3491 */
    { 0x0700, 0x390d, 0xb182, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044) }, /* #73/1/3/u = #3492 */
    { 0x0722, 0x390d, 0x3922, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #73/1/3/0x22 = #3493 */
    { 0x0720, 0x390d, 0xb182, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044) }, /* #73/1/3/u0x2 = #3494 */
    { 0x0702, 0x390d, 0xb9a2, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #73/1/3/u0x20 = #3495 */
    { 0x087f, 0x390d, 0x3b22, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #73/2/0/m = #3496 */
    { 0x0800, 0x390d, 0xb182, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044) }, /* #73/2/0/u = #3497 */
    { 0x0822, 0x390d, 0x3b22, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #73/2/0/0x22 = #3498 */
    { 0x0820, 0x390d, 0xb182, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044) }, /* #73/2/0/u0x2 = #3499 */
    { 0x0802, 0x390d, 0xbba2, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #73/2/0/u0x20 = #3500 */
    { 0x097f, 0x390d, 0x3b22, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #73/2/1/m = #3501 */
    { 0x0900, 0x390d, 0xb182, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044) }, /* #73/2/1/u = #3502 */
    { 0x0922, 0x390d, 0x3b22, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #73/2/1/0x22 = #3503 */
    { 0x0920, 0x390d, 0xb182, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044) }, /* #73/2/1/u0x2 = #3504 */
    { 0x0902, 0x390d, 0xbba2, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #73/2/1/u0x20 = #3505 */
    { 0x0a7f, 0x390d, 0x3b22, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #73/2/2/m = #3506 */
    { 0x0a00, 0x390d, 0xb182, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044) }, /* #73/2/2/u = #3507 */
    { 0x0a22, 0x390d, 0x3b22, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #73/2/2/0x22 = #3508 */
    { 0x0a20, 0x390d, 0xb182, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044) }, /* #73/2/2/u0x2 = #3509 */
    { 0x0a02, 0x390d, 0xbba2, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #73/2/2/u0x20 = #3510 */
    { 0x0b7f, 0x390d, 0x3b22, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #73/2/3/m = #3511 */
    { 0x0b00, 0x390d, 0xb182, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044) }, /* #73/2/3/u = #3512 */
    { 0x0b22, 0x390d, 0x3b22, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #73/2/3/0x22 = #3513 */
    { 0x0b20, 0x390d, 0xb182, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044) }, /* #73/2/3/u0x2 = #3514 */
    { 0x0b02, 0x390d, 0xbba2, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #73/2/3/u0x20 = #3515 */
    { 0x0c7f, 0x390d, 0x3922, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #73/3/0/m = #3516 */
    { 0x0c00, 0x390d, 0xb182, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044) }, /* #73/3/0/u = #3517 */
    { 0x0c22, 0x390d, 0x3922, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #73/3/0/0x22 = #3518 */
    { 0x0c20, 0x390d, 0xb182, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044) }, /* #73/3/0/u0x2 = #3519 */
    { 0x0c02, 0x390d, 0xb9a2, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #73/3/0/u0x20 = #3520 */
    { 0x0d7f, 0x390d, 0x3922, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #73/3/1/m = #3521 */
    { 0x0d00, 0x390d, 0xb182, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044) }, /* #73/3/1/u = #3522 */
    { 0x0d22, 0x390d, 0x3922, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #73/3/1/0x22 = #3523 */
    { 0x0d20, 0x390d, 0xb182, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044) }, /* #73/3/1/u0x2 = #3524 */
    { 0x0d02, 0x390d, 0xb9a2, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #73/3/1/u0x20 = #3525 */
    { 0x0e7f, 0x390d, 0x3922, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #73/3/2/m = #3526 */
    { 0x0e00, 0x390d, 0xb182, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044) }, /* #73/3/2/u = #3527 */
    { 0x0e22, 0x390d, 0x3922, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #73/3/2/0x22 = #3528 */
    { 0x0e20, 0x390d, 0xb182, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044) }, /* #73/3/2/u0x2 = #3529 */
    { 0x0e02, 0x390d, 0xb9a2, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #73/3/2/u0x20 = #3530 */
    { 0x0f7f, 0x390d, 0x3922, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #73/3/3/m = #3531 */
    { 0x0f00, 0x390d, 0xb182, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044) }, /* #73/3/3/u = #3532 */
    { 0x0f22, 0x390d, 0x3922, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #73/3/3/0x22 = #3533 */
    { 0x0f20, 0x390d, 0xb182, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044) }, /* #73/3/3/u0x2 = #3534 */
    { 0x0f02, 0x390d, 0xb9a2, RTFLOAT80U_INIT_C(0,0xc08bbc2ce77e287f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,27044), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #73/3/3/u0x20 = #3535 */
    { 0x007f, 0xfa15, 0x7801, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_IND(1) }, /* #74/0/0/m = #3536 */
    { 0x0000, 0xfa15, 0xf081, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877) }, /* #74/0/0/u = #3537 */
    { 0x0001, 0xfa15, 0x7801, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_IND(1) }, /* #74/0/0/0x1 = #3538 */
    { 0x017f, 0xfa15, 0x7801, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_IND(1) }, /* #74/0/1/m = #3539 */
    { 0x0100, 0xfa15, 0xf081, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877) }, /* #74/0/1/u = #3540 */
    { 0x0101, 0xfa15, 0x7801, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_IND(1) }, /* #74/0/1/0x1 = #3541 */
    { 0x027f, 0xfa15, 0x7801, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_IND(1) }, /* #74/0/2/m = #3542 */
    { 0x0200, 0xfa15, 0xf081, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877) }, /* #74/0/2/u = #3543 */
    { 0x0201, 0xfa15, 0x7801, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_IND(1) }, /* #74/0/2/0x1 = #3544 */
    { 0x037f, 0xfa15, 0x7801, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_IND(1) }, /* #74/0/3/m = #3545 */
    { 0x0300, 0xfa15, 0xf081, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877) }, /* #74/0/3/u = #3546 */
    { 0x0301, 0xfa15, 0x7801, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_IND(1) }, /* #74/0/3/0x1 = #3547 */
    { 0x047f, 0xfa15, 0x7801, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_IND(1) }, /* #74/1/0/m = #3548 */
    { 0x0400, 0xfa15, 0xf081, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877) }, /* #74/1/0/u = #3549 */
    { 0x0401, 0xfa15, 0x7801, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_IND(1) }, /* #74/1/0/0x1 = #3550 */
    { 0x057f, 0xfa15, 0x7801, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_IND(1) }, /* #74/1/1/m = #3551 */
    { 0x0500, 0xfa15, 0xf081, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877) }, /* #74/1/1/u = #3552 */
    { 0x0501, 0xfa15, 0x7801, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_IND(1) }, /* #74/1/1/0x1 = #3553 */
    { 0x067f, 0xfa15, 0x7801, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_IND(1) }, /* #74/1/2/m = #3554 */
    { 0x0600, 0xfa15, 0xf081, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877) }, /* #74/1/2/u = #3555 */
    { 0x0601, 0xfa15, 0x7801, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_IND(1) }, /* #74/1/2/0x1 = #3556 */
    { 0x077f, 0xfa15, 0x7801, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_IND(1) }, /* #74/1/3/m = #3557 */
    { 0x0700, 0xfa15, 0xf081, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877) }, /* #74/1/3/u = #3558 */
    { 0x0701, 0xfa15, 0x7801, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_IND(1) }, /* #74/1/3/0x1 = #3559 */
    { 0x087f, 0xfa15, 0x7801, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_IND(1) }, /* #74/2/0/m = #3560 */
    { 0x0800, 0xfa15, 0xf081, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877) }, /* #74/2/0/u = #3561 */
    { 0x0801, 0xfa15, 0x7801, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_IND(1) }, /* #74/2/0/0x1 = #3562 */
    { 0x097f, 0xfa15, 0x7801, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_IND(1) }, /* #74/2/1/m = #3563 */
    { 0x0900, 0xfa15, 0xf081, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877) }, /* #74/2/1/u = #3564 */
    { 0x0901, 0xfa15, 0x7801, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_IND(1) }, /* #74/2/1/0x1 = #3565 */
    { 0x0a7f, 0xfa15, 0x7801, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_IND(1) }, /* #74/2/2/m = #3566 */
    { 0x0a00, 0xfa15, 0xf081, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877) }, /* #74/2/2/u = #3567 */
    { 0x0a01, 0xfa15, 0x7801, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_IND(1) }, /* #74/2/2/0x1 = #3568 */
    { 0x0b7f, 0xfa15, 0x7801, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_IND(1) }, /* #74/2/3/m = #3569 */
    { 0x0b00, 0xfa15, 0xf081, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877) }, /* #74/2/3/u = #3570 */
    { 0x0b01, 0xfa15, 0x7801, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_IND(1) }, /* #74/2/3/0x1 = #3571 */
    { 0x0c7f, 0xfa15, 0x7801, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_IND(1) }, /* #74/3/0/m = #3572 */
    { 0x0c00, 0xfa15, 0xf081, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877) }, /* #74/3/0/u = #3573 */
    { 0x0c01, 0xfa15, 0x7801, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_IND(1) }, /* #74/3/0/0x1 = #3574 */
    { 0x0d7f, 0xfa15, 0x7801, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_IND(1) }, /* #74/3/1/m = #3575 */
    { 0x0d00, 0xfa15, 0xf081, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877) }, /* #74/3/1/u = #3576 */
    { 0x0d01, 0xfa15, 0x7801, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_IND(1) }, /* #74/3/1/0x1 = #3577 */
    { 0x0e7f, 0xfa15, 0x7801, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_IND(1) }, /* #74/3/2/m = #3578 */
    { 0x0e00, 0xfa15, 0xf081, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877) }, /* #74/3/2/u = #3579 */
    { 0x0e01, 0xfa15, 0x7801, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_IND(1) }, /* #74/3/2/0x1 = #3580 */
    { 0x0f7f, 0xfa15, 0x7801, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_IND(1) }, /* #74/3/3/m = #3581 */
    { 0x0f00, 0xfa15, 0xf081, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877) }, /* #74/3/3/u = #3582 */
    { 0x0f01, 0xfa15, 0x7801, RTFLOAT80U_INIT_C(0,0x86c6288deea2df4b,0), RTFLOAT80U_INIT_C(0,0x343d2339c0595118,11877), RTFLOAT80U_INIT_IND(1) }, /* #74/3/3/0x1 = #3583 */
    { 0x007f, 0xed2a, 0x7d01, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xf2392a56af5773f9,32767) }, /* #75/0/0/m = #3584 */
    { 0x0000, 0xed2a, 0xf581, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767) }, /* #75/0/0/u = #3585 */
    { 0x0001, 0xed2a, 0x7d01, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xf2392a56af5773f9,32767) }, /* #75/0/0/0x1 = #3586 */
    { 0x017f, 0xed2a, 0x7d01, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xf2392a56af5773f9,32767) }, /* #75/0/1/m = #3587 */
    { 0x0100, 0xed2a, 0xf581, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767) }, /* #75/0/1/u = #3588 */
    { 0x0101, 0xed2a, 0x7d01, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xf2392a56af5773f9,32767) }, /* #75/0/1/0x1 = #3589 */
    { 0x027f, 0xed2a, 0x7d01, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xf2392a56af5773f9,32767) }, /* #75/0/2/m = #3590 */
    { 0x0200, 0xed2a, 0xf581, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767) }, /* #75/0/2/u = #3591 */
    { 0x0201, 0xed2a, 0x7d01, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xf2392a56af5773f9,32767) }, /* #75/0/2/0x1 = #3592 */
    { 0x037f, 0xed2a, 0x7d01, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xf2392a56af5773f9,32767) }, /* #75/0/3/m = #3593 */
    { 0x0300, 0xed2a, 0xf581, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767) }, /* #75/0/3/u = #3594 */
    { 0x0301, 0xed2a, 0x7d01, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xf2392a56af5773f9,32767) }, /* #75/0/3/0x1 = #3595 */
    { 0x047f, 0xed2a, 0x7d01, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xf2392a56af5773f9,32767) }, /* #75/1/0/m = #3596 */
    { 0x0400, 0xed2a, 0xf581, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767) }, /* #75/1/0/u = #3597 */
    { 0x0401, 0xed2a, 0x7d01, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xf2392a56af5773f9,32767) }, /* #75/1/0/0x1 = #3598 */
    { 0x057f, 0xed2a, 0x7d01, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xf2392a56af5773f9,32767) }, /* #75/1/1/m = #3599 */
    { 0x0500, 0xed2a, 0xf581, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767) }, /* #75/1/1/u = #3600 */
    { 0x0501, 0xed2a, 0x7d01, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xf2392a56af5773f9,32767) }, /* #75/1/1/0x1 = #3601 */
    { 0x067f, 0xed2a, 0x7d01, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xf2392a56af5773f9,32767) }, /* #75/1/2/m = #3602 */
    { 0x0600, 0xed2a, 0xf581, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767) }, /* #75/1/2/u = #3603 */
    { 0x0601, 0xed2a, 0x7d01, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xf2392a56af5773f9,32767) }, /* #75/1/2/0x1 = #3604 */
    { 0x077f, 0xed2a, 0x7d01, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xf2392a56af5773f9,32767) }, /* #75/1/3/m = #3605 */
    { 0x0700, 0xed2a, 0xf581, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767) }, /* #75/1/3/u = #3606 */
    { 0x0701, 0xed2a, 0x7d01, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xf2392a56af5773f9,32767) }, /* #75/1/3/0x1 = #3607 */
    { 0x087f, 0xed2a, 0x7d01, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xf2392a56af5773f9,32767) }, /* #75/2/0/m = #3608 */
    { 0x0800, 0xed2a, 0xf581, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767) }, /* #75/2/0/u = #3609 */
    { 0x0801, 0xed2a, 0x7d01, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xf2392a56af5773f9,32767) }, /* #75/2/0/0x1 = #3610 */
    { 0x097f, 0xed2a, 0x7d01, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xf2392a56af5773f9,32767) }, /* #75/2/1/m = #3611 */
    { 0x0900, 0xed2a, 0xf581, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767) }, /* #75/2/1/u = #3612 */
    { 0x0901, 0xed2a, 0x7d01, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xf2392a56af5773f9,32767) }, /* #75/2/1/0x1 = #3613 */
    { 0x0a7f, 0xed2a, 0x7d01, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xf2392a56af5773f9,32767) }, /* #75/2/2/m = #3614 */
    { 0x0a00, 0xed2a, 0xf581, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767) }, /* #75/2/2/u = #3615 */
    { 0x0a01, 0xed2a, 0x7d01, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xf2392a56af5773f9,32767) }, /* #75/2/2/0x1 = #3616 */
    { 0x0b7f, 0xed2a, 0x7d01, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xf2392a56af5773f9,32767) }, /* #75/2/3/m = #3617 */
    { 0x0b00, 0xed2a, 0xf581, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767) }, /* #75/2/3/u = #3618 */
    { 0x0b01, 0xed2a, 0x7d01, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xf2392a56af5773f9,32767) }, /* #75/2/3/0x1 = #3619 */
    { 0x0c7f, 0xed2a, 0x7d01, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xf2392a56af5773f9,32767) }, /* #75/3/0/m = #3620 */
    { 0x0c00, 0xed2a, 0xf581, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767) }, /* #75/3/0/u = #3621 */
    { 0x0c01, 0xed2a, 0x7d01, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xf2392a56af5773f9,32767) }, /* #75/3/0/0x1 = #3622 */
    { 0x0d7f, 0xed2a, 0x7d01, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xf2392a56af5773f9,32767) }, /* #75/3/1/m = #3623 */
    { 0x0d00, 0xed2a, 0xf581, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767) }, /* #75/3/1/u = #3624 */
    { 0x0d01, 0xed2a, 0x7d01, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xf2392a56af5773f9,32767) }, /* #75/3/1/0x1 = #3625 */
    { 0x0e7f, 0xed2a, 0x7d01, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xf2392a56af5773f9,32767) }, /* #75/3/2/m = #3626 */
    { 0x0e00, 0xed2a, 0xf581, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767) }, /* #75/3/2/u = #3627 */
    { 0x0e01, 0xed2a, 0x7d01, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xf2392a56af5773f9,32767) }, /* #75/3/2/0x1 = #3628 */
    { 0x0f7f, 0xed2a, 0x7d01, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xf2392a56af5773f9,32767) }, /* #75/3/3/m = #3629 */
    { 0x0f00, 0xed2a, 0xf581, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767) }, /* #75/3/3/u = #3630 */
    { 0x0f01, 0xed2a, 0x7d01, RTFLOAT80U_INIT_C(0,0xd517654ce582fe1b,0), RTFLOAT80U_INIT_C(0,0xb2392a56af5773f9,32767), RTFLOAT80U_INIT_C(0,0xf2392a56af5773f9,32767) }, /* #75/3/3/0x1 = #3631 */
    { 0x007f, 0x8228, 0x3800, RTFLOAT80U_INIT_C(0,0xdfd1fe67d1118999,0), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767) }, /* #76/0/0/m = #3632 */
    { 0x0000, 0x8228, 0x3800, RTFLOAT80U_INIT_C(0,0xdfd1fe67d1118999,0), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767) }, /* #76/0/0/u = #3633 */
    { 0x017f, 0x8228, 0x3800, RTFLOAT80U_INIT_C(0,0xdfd1fe67d1118999,0), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767) }, /* #76/0/1/m = #3634 */
    { 0x0100, 0x8228, 0x3800, RTFLOAT80U_INIT_C(0,0xdfd1fe67d1118999,0), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767) }, /* #76/0/1/u = #3635 */
    { 0x027f, 0x8228, 0x3800, RTFLOAT80U_INIT_C(0,0xdfd1fe67d1118999,0), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767) }, /* #76/0/2/m = #3636 */
    { 0x0200, 0x8228, 0x3800, RTFLOAT80U_INIT_C(0,0xdfd1fe67d1118999,0), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767) }, /* #76/0/2/u = #3637 */
    { 0x037f, 0x8228, 0x3800, RTFLOAT80U_INIT_C(0,0xdfd1fe67d1118999,0), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767) }, /* #76/0/3/m = #3638 */
    { 0x0300, 0x8228, 0x3800, RTFLOAT80U_INIT_C(0,0xdfd1fe67d1118999,0), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767) }, /* #76/0/3/u = #3639 */
    { 0x047f, 0x8228, 0x3800, RTFLOAT80U_INIT_C(0,0xdfd1fe67d1118999,0), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767) }, /* #76/1/0/m = #3640 */
    { 0x0400, 0x8228, 0x3800, RTFLOAT80U_INIT_C(0,0xdfd1fe67d1118999,0), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767) }, /* #76/1/0/u = #3641 */
    { 0x057f, 0x8228, 0x3800, RTFLOAT80U_INIT_C(0,0xdfd1fe67d1118999,0), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767) }, /* #76/1/1/m = #3642 */
    { 0x0500, 0x8228, 0x3800, RTFLOAT80U_INIT_C(0,0xdfd1fe67d1118999,0), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767) }, /* #76/1/1/u = #3643 */
    { 0x067f, 0x8228, 0x3800, RTFLOAT80U_INIT_C(0,0xdfd1fe67d1118999,0), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767) }, /* #76/1/2/m = #3644 */
    { 0x0600, 0x8228, 0x3800, RTFLOAT80U_INIT_C(0,0xdfd1fe67d1118999,0), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767) }, /* #76/1/2/u = #3645 */
    { 0x077f, 0x8228, 0x3800, RTFLOAT80U_INIT_C(0,0xdfd1fe67d1118999,0), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767) }, /* #76/1/3/m = #3646 */
    { 0x0700, 0x8228, 0x3800, RTFLOAT80U_INIT_C(0,0xdfd1fe67d1118999,0), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767) }, /* #76/1/3/u = #3647 */
    { 0x087f, 0x8228, 0x3800, RTFLOAT80U_INIT_C(0,0xdfd1fe67d1118999,0), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767) }, /* #76/2/0/m = #3648 */
    { 0x0800, 0x8228, 0x3800, RTFLOAT80U_INIT_C(0,0xdfd1fe67d1118999,0), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767) }, /* #76/2/0/u = #3649 */
    { 0x097f, 0x8228, 0x3800, RTFLOAT80U_INIT_C(0,0xdfd1fe67d1118999,0), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767) }, /* #76/2/1/m = #3650 */
    { 0x0900, 0x8228, 0x3800, RTFLOAT80U_INIT_C(0,0xdfd1fe67d1118999,0), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767) }, /* #76/2/1/u = #3651 */
    { 0x0a7f, 0x8228, 0x3800, RTFLOAT80U_INIT_C(0,0xdfd1fe67d1118999,0), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767) }, /* #76/2/2/m = #3652 */
    { 0x0a00, 0x8228, 0x3800, RTFLOAT80U_INIT_C(0,0xdfd1fe67d1118999,0), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767) }, /* #76/2/2/u = #3653 */
    { 0x0b7f, 0x8228, 0x3800, RTFLOAT80U_INIT_C(0,0xdfd1fe67d1118999,0), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767) }, /* #76/2/3/m = #3654 */
    { 0x0b00, 0x8228, 0x3800, RTFLOAT80U_INIT_C(0,0xdfd1fe67d1118999,0), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767) }, /* #76/2/3/u = #3655 */
    { 0x0c7f, 0x8228, 0x3800, RTFLOAT80U_INIT_C(0,0xdfd1fe67d1118999,0), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767) }, /* #76/3/0/m = #3656 */
    { 0x0c00, 0x8228, 0x3800, RTFLOAT80U_INIT_C(0,0xdfd1fe67d1118999,0), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767) }, /* #76/3/0/u = #3657 */
    { 0x0d7f, 0x8228, 0x3800, RTFLOAT80U_INIT_C(0,0xdfd1fe67d1118999,0), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767) }, /* #76/3/1/m = #3658 */
    { 0x0d00, 0x8228, 0x3800, RTFLOAT80U_INIT_C(0,0xdfd1fe67d1118999,0), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767) }, /* #76/3/1/u = #3659 */
    { 0x0e7f, 0x8228, 0x3800, RTFLOAT80U_INIT_C(0,0xdfd1fe67d1118999,0), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767) }, /* #76/3/2/m = #3660 */
    { 0x0e00, 0x8228, 0x3800, RTFLOAT80U_INIT_C(0,0xdfd1fe67d1118999,0), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767) }, /* #76/3/2/u = #3661 */
    { 0x0f7f, 0x8228, 0x3800, RTFLOAT80U_INIT_C(0,0xdfd1fe67d1118999,0), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767) }, /* #76/3/3/m = #3662 */
    { 0x0f00, 0x8228, 0x3800, RTFLOAT80U_INIT_C(0,0xdfd1fe67d1118999,0), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767), RTFLOAT80U_INIT_C(1,0xce5352ca58bc8d0e,32767) }, /* #76/3/3/u = #3663 */
    { 0x007f, 0x9f95, 0x3d01, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/0/0/m = #3664 */
    { 0x0000, 0x9f95, 0xb581, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767) }, /* #77/0/0/u = #3665 */
    { 0x0001, 0x9f95, 0x3d01, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/0/0/0x1 = #3666 */
    { 0x017f, 0x9f95, 0x3d01, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/0/1/m = #3667 */
    { 0x0100, 0x9f95, 0xb581, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767) }, /* #77/0/1/u = #3668 */
    { 0x0101, 0x9f95, 0x3d01, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/0/1/0x1 = #3669 */
    { 0x027f, 0x9f95, 0x3d01, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/0/2/m = #3670 */
    { 0x0200, 0x9f95, 0xb581, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767) }, /* #77/0/2/u = #3671 */
    { 0x0201, 0x9f95, 0x3d01, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/0/2/0x1 = #3672 */
    { 0x037f, 0x9f95, 0x3d01, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/0/3/m = #3673 */
    { 0x0300, 0x9f95, 0xb581, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767) }, /* #77/0/3/u = #3674 */
    { 0x0301, 0x9f95, 0x3d01, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/0/3/0x1 = #3675 */
    { 0x047f, 0x9f95, 0x3d01, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/1/0/m = #3676 */
    { 0x0400, 0x9f95, 0xb581, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767) }, /* #77/1/0/u = #3677 */
    { 0x0401, 0x9f95, 0x3d01, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/1/0/0x1 = #3678 */
    { 0x057f, 0x9f95, 0x3d01, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/1/1/m = #3679 */
    { 0x0500, 0x9f95, 0xb581, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767) }, /* #77/1/1/u = #3680 */
    { 0x0501, 0x9f95, 0x3d01, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/1/1/0x1 = #3681 */
    { 0x067f, 0x9f95, 0x3d01, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/1/2/m = #3682 */
    { 0x0600, 0x9f95, 0xb581, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767) }, /* #77/1/2/u = #3683 */
    { 0x0601, 0x9f95, 0x3d01, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/1/2/0x1 = #3684 */
    { 0x077f, 0x9f95, 0x3d01, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/1/3/m = #3685 */
    { 0x0700, 0x9f95, 0xb581, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767) }, /* #77/1/3/u = #3686 */
    { 0x0701, 0x9f95, 0x3d01, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/1/3/0x1 = #3687 */
    { 0x087f, 0x9f95, 0x3d01, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/2/0/m = #3688 */
    { 0x0800, 0x9f95, 0xb581, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767) }, /* #77/2/0/u = #3689 */
    { 0x0801, 0x9f95, 0x3d01, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/2/0/0x1 = #3690 */
    { 0x097f, 0x9f95, 0x3d01, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/2/1/m = #3691 */
    { 0x0900, 0x9f95, 0xb581, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767) }, /* #77/2/1/u = #3692 */
    { 0x0901, 0x9f95, 0x3d01, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/2/1/0x1 = #3693 */
    { 0x0a7f, 0x9f95, 0x3d01, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/2/2/m = #3694 */
    { 0x0a00, 0x9f95, 0xb581, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767) }, /* #77/2/2/u = #3695 */
    { 0x0a01, 0x9f95, 0x3d01, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/2/2/0x1 = #3696 */
    { 0x0b7f, 0x9f95, 0x3d01, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/2/3/m = #3697 */
    { 0x0b00, 0x9f95, 0xb581, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767) }, /* #77/2/3/u = #3698 */
    { 0x0b01, 0x9f95, 0x3d01, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/2/3/0x1 = #3699 */
    { 0x0c7f, 0x9f95, 0x3d01, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/3/0/m = #3700 */
    { 0x0c00, 0x9f95, 0xb581, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767) }, /* #77/3/0/u = #3701 */
    { 0x0c01, 0x9f95, 0x3d01, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/3/0/0x1 = #3702 */
    { 0x0d7f, 0x9f95, 0x3d01, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/3/1/m = #3703 */
    { 0x0d00, 0x9f95, 0xb581, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767) }, /* #77/3/1/u = #3704 */
    { 0x0d01, 0x9f95, 0x3d01, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/3/1/0x1 = #3705 */
    { 0x0e7f, 0x9f95, 0x3d01, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/3/2/m = #3706 */
    { 0x0e00, 0x9f95, 0xb581, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767) }, /* #77/3/2/u = #3707 */
    { 0x0e01, 0x9f95, 0x3d01, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/3/2/0x1 = #3708 */
    { 0x0f7f, 0x9f95, 0x3d01, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/3/3/m = #3709 */
    { 0x0f00, 0x9f95, 0xb581, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767) }, /* #77/3/3/u = #3710 */
    { 0x0f01, 0x9f95, 0x3d01, RTFLOAT80U_INIT_C(1,0x95c40e18346e8c54,0), RTFLOAT80U_INIT_C(0,0x7de582d721966bc6,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/3/3/0x1 = #3711 */
    { 0x007f, 0x5cf9, 0x7c22, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/0/0/m = #3712 */
    { 0x0000, 0x5cf9, 0xf482, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0) }, /* #78/0/0/u = #3713 */
    { 0x0022, 0x5cf9, 0x7c22, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/0/0/0x22 = #3714 */
    { 0x0020, 0x5cf9, 0xf482, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0) }, /* #78/0/0/u0x2 = #3715 */
    { 0x0002, 0x5cf9, 0xfca2, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/0/0/u0x20 = #3716 */
    { 0x017f, 0x5cf9, 0x7c22, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/0/1/m = #3717 */
    { 0x0100, 0x5cf9, 0xf482, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0) }, /* #78/0/1/u = #3718 */
    { 0x0122, 0x5cf9, 0x7c22, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/0/1/0x22 = #3719 */
    { 0x0120, 0x5cf9, 0xf482, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0) }, /* #78/0/1/u0x2 = #3720 */
    { 0x0102, 0x5cf9, 0xfca2, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/0/1/u0x20 = #3721 */
    { 0x027f, 0x5cf9, 0x7c22, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/0/2/m = #3722 */
    { 0x0200, 0x5cf9, 0xf482, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0) }, /* #78/0/2/u = #3723 */
    { 0x0222, 0x5cf9, 0x7c22, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/0/2/0x22 = #3724 */
    { 0x0220, 0x5cf9, 0xf482, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0) }, /* #78/0/2/u0x2 = #3725 */
    { 0x0202, 0x5cf9, 0xfca2, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/0/2/u0x20 = #3726 */
    { 0x037f, 0x5cf9, 0x7c22, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/0/3/m = #3727 */
    { 0x0300, 0x5cf9, 0xf482, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0) }, /* #78/0/3/u = #3728 */
    { 0x0322, 0x5cf9, 0x7c22, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/0/3/0x22 = #3729 */
    { 0x0320, 0x5cf9, 0xf482, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0) }, /* #78/0/3/u0x2 = #3730 */
    { 0x0302, 0x5cf9, 0xfca2, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/0/3/u0x20 = #3731 */
    { 0x047f, 0x5cf9, 0x7e22, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a2,16382) }, /* #78/1/0/m = #3732 */
    { 0x0400, 0x5cf9, 0xf482, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0) }, /* #78/1/0/u = #3733 */
    { 0x0422, 0x5cf9, 0x7e22, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a2,16382) }, /* #78/1/0/0x22 = #3734 */
    { 0x0420, 0x5cf9, 0xf482, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0) }, /* #78/1/0/u0x2 = #3735 */
    { 0x0402, 0x5cf9, 0xfea2, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a2,16382) }, /* #78/1/0/u0x20 = #3736 */
    { 0x057f, 0x5cf9, 0x7e22, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a2,16382) }, /* #78/1/1/m = #3737 */
    { 0x0500, 0x5cf9, 0xf482, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0) }, /* #78/1/1/u = #3738 */
    { 0x0522, 0x5cf9, 0x7e22, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a2,16382) }, /* #78/1/1/0x22 = #3739 */
    { 0x0520, 0x5cf9, 0xf482, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0) }, /* #78/1/1/u0x2 = #3740 */
    { 0x0502, 0x5cf9, 0xfea2, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a2,16382) }, /* #78/1/1/u0x20 = #3741 */
    { 0x067f, 0x5cf9, 0x7e22, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a2,16382) }, /* #78/1/2/m = #3742 */
    { 0x0600, 0x5cf9, 0xf482, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0) }, /* #78/1/2/u = #3743 */
    { 0x0622, 0x5cf9, 0x7e22, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a2,16382) }, /* #78/1/2/0x22 = #3744 */
    { 0x0620, 0x5cf9, 0xf482, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0) }, /* #78/1/2/u0x2 = #3745 */
    { 0x0602, 0x5cf9, 0xfea2, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a2,16382) }, /* #78/1/2/u0x20 = #3746 */
    { 0x077f, 0x5cf9, 0x7e22, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a2,16382) }, /* #78/1/3/m = #3747 */
    { 0x0700, 0x5cf9, 0xf482, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0) }, /* #78/1/3/u = #3748 */
    { 0x0722, 0x5cf9, 0x7e22, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a2,16382) }, /* #78/1/3/0x22 = #3749 */
    { 0x0720, 0x5cf9, 0xf482, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0) }, /* #78/1/3/u0x2 = #3750 */
    { 0x0702, 0x5cf9, 0xfea2, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a2,16382) }, /* #78/1/3/u0x20 = #3751 */
    { 0x087f, 0x5cf9, 0x7c22, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/2/0/m = #3752 */
    { 0x0800, 0x5cf9, 0xf482, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0) }, /* #78/2/0/u = #3753 */
    { 0x0822, 0x5cf9, 0x7c22, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/2/0/0x22 = #3754 */
    { 0x0820, 0x5cf9, 0xf482, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0) }, /* #78/2/0/u0x2 = #3755 */
    { 0x0802, 0x5cf9, 0xfca2, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/2/0/u0x20 = #3756 */
    { 0x097f, 0x5cf9, 0x7c22, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/2/1/m = #3757 */
    { 0x0900, 0x5cf9, 0xf482, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0) }, /* #78/2/1/u = #3758 */
    { 0x0922, 0x5cf9, 0x7c22, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/2/1/0x22 = #3759 */
    { 0x0920, 0x5cf9, 0xf482, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0) }, /* #78/2/1/u0x2 = #3760 */
    { 0x0902, 0x5cf9, 0xfca2, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/2/1/u0x20 = #3761 */
    { 0x0a7f, 0x5cf9, 0x7c22, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/2/2/m = #3762 */
    { 0x0a00, 0x5cf9, 0xf482, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0) }, /* #78/2/2/u = #3763 */
    { 0x0a22, 0x5cf9, 0x7c22, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/2/2/0x22 = #3764 */
    { 0x0a20, 0x5cf9, 0xf482, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0) }, /* #78/2/2/u0x2 = #3765 */
    { 0x0a02, 0x5cf9, 0xfca2, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/2/2/u0x20 = #3766 */
    { 0x0b7f, 0x5cf9, 0x7c22, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/2/3/m = #3767 */
    { 0x0b00, 0x5cf9, 0xf482, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0) }, /* #78/2/3/u = #3768 */
    { 0x0b22, 0x5cf9, 0x7c22, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/2/3/0x22 = #3769 */
    { 0x0b20, 0x5cf9, 0xf482, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0) }, /* #78/2/3/u0x2 = #3770 */
    { 0x0b02, 0x5cf9, 0xfca2, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/2/3/u0x20 = #3771 */
    { 0x0c7f, 0x5cf9, 0x7c22, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/3/0/m = #3772 */
    { 0x0c00, 0x5cf9, 0xf482, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0) }, /* #78/3/0/u = #3773 */
    { 0x0c22, 0x5cf9, 0x7c22, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/3/0/0x22 = #3774 */
    { 0x0c20, 0x5cf9, 0xf482, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0) }, /* #78/3/0/u0x2 = #3775 */
    { 0x0c02, 0x5cf9, 0xfca2, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/3/0/u0x20 = #3776 */
    { 0x0d7f, 0x5cf9, 0x7c22, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/3/1/m = #3777 */
    { 0x0d00, 0x5cf9, 0xf482, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0) }, /* #78/3/1/u = #3778 */
    { 0x0d22, 0x5cf9, 0x7c22, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/3/1/0x22 = #3779 */
    { 0x0d20, 0x5cf9, 0xf482, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0) }, /* #78/3/1/u0x2 = #3780 */
    { 0x0d02, 0x5cf9, 0xfca2, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/3/1/u0x20 = #3781 */
    { 0x0e7f, 0x5cf9, 0x7c22, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/3/2/m = #3782 */
    { 0x0e00, 0x5cf9, 0xf482, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0) }, /* #78/3/2/u = #3783 */
    { 0x0e22, 0x5cf9, 0x7c22, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/3/2/0x22 = #3784 */
    { 0x0e20, 0x5cf9, 0xf482, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0) }, /* #78/3/2/u0x2 = #3785 */
    { 0x0e02, 0x5cf9, 0xfca2, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/3/2/u0x20 = #3786 */
    { 0x0f7f, 0x5cf9, 0x7c22, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/3/3/m = #3787 */
    { 0x0f00, 0x5cf9, 0xf482, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0) }, /* #78/3/3/u = #3788 */
    { 0x0f22, 0x5cf9, 0x7c22, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/3/3/0x22 = #3789 */
    { 0x0f20, 0x5cf9, 0xf482, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0) }, /* #78/3/3/u0x2 = #3790 */
    { 0x0f02, 0x5cf9, 0xfca2, RTFLOAT80U_INIT_C(1,0xa33f0dfbaf49777f,0), RTFLOAT80U_INIT_C(0,0xec504a6f308449b3,0), RTFLOAT80U_INIT_C(1,0x9ac24af1e61014a1,16382) }, /* #78/3/3/u0x20 = #3791 */
    { 0x007f, 0x21ff, 0x3b22, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b1,16383) }, /* #79/0/0/m = #3792 */
    { 0x0000, 0x21ff, 0xb182, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0) }, /* #79/0/0/u = #3793 */
    { 0x0022, 0x21ff, 0x3b22, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b1,16383) }, /* #79/0/0/0x22 = #3794 */
    { 0x0020, 0x21ff, 0xb182, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0) }, /* #79/0/0/u0x2 = #3795 */
    { 0x0002, 0x21ff, 0xbba2, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b1,16383) }, /* #79/0/0/u0x20 = #3796 */
    { 0x017f, 0x21ff, 0x3b22, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b1,16383) }, /* #79/0/1/m = #3797 */
    { 0x0100, 0x21ff, 0xb182, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0) }, /* #79/0/1/u = #3798 */
    { 0x0122, 0x21ff, 0x3b22, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b1,16383) }, /* #79/0/1/0x22 = #3799 */
    { 0x0120, 0x21ff, 0xb182, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0) }, /* #79/0/1/u0x2 = #3800 */
    { 0x0102, 0x21ff, 0xbba2, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b1,16383) }, /* #79/0/1/u0x20 = #3801 */
    { 0x027f, 0x21ff, 0x3b22, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b1,16383) }, /* #79/0/2/m = #3802 */
    { 0x0200, 0x21ff, 0xb182, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0) }, /* #79/0/2/u = #3803 */
    { 0x0222, 0x21ff, 0x3b22, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b1,16383) }, /* #79/0/2/0x22 = #3804 */
    { 0x0220, 0x21ff, 0xb182, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0) }, /* #79/0/2/u0x2 = #3805 */
    { 0x0202, 0x21ff, 0xbba2, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b1,16383) }, /* #79/0/2/u0x20 = #3806 */
    { 0x037f, 0x21ff, 0x3b22, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b1,16383) }, /* #79/0/3/m = #3807 */
    { 0x0300, 0x21ff, 0xb182, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0) }, /* #79/0/3/u = #3808 */
    { 0x0322, 0x21ff, 0x3b22, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b1,16383) }, /* #79/0/3/0x22 = #3809 */
    { 0x0320, 0x21ff, 0xb182, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0) }, /* #79/0/3/u0x2 = #3810 */
    { 0x0302, 0x21ff, 0xbba2, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b1,16383) }, /* #79/0/3/u0x20 = #3811 */
    { 0x047f, 0x21ff, 0x3b22, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b1,16383) }, /* #79/1/0/m = #3812 */
    { 0x0400, 0x21ff, 0xb182, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0) }, /* #79/1/0/u = #3813 */
    { 0x0422, 0x21ff, 0x3b22, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b1,16383) }, /* #79/1/0/0x22 = #3814 */
    { 0x0420, 0x21ff, 0xb182, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0) }, /* #79/1/0/u0x2 = #3815 */
    { 0x0402, 0x21ff, 0xbba2, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b1,16383) }, /* #79/1/0/u0x20 = #3816 */
    { 0x057f, 0x21ff, 0x3b22, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b1,16383) }, /* #79/1/1/m = #3817 */
    { 0x0500, 0x21ff, 0xb182, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0) }, /* #79/1/1/u = #3818 */
    { 0x0522, 0x21ff, 0x3b22, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b1,16383) }, /* #79/1/1/0x22 = #3819 */
    { 0x0520, 0x21ff, 0xb182, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0) }, /* #79/1/1/u0x2 = #3820 */
    { 0x0502, 0x21ff, 0xbba2, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b1,16383) }, /* #79/1/1/u0x20 = #3821 */
    { 0x067f, 0x21ff, 0x3b22, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b1,16383) }, /* #79/1/2/m = #3822 */
    { 0x0600, 0x21ff, 0xb182, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0) }, /* #79/1/2/u = #3823 */
    { 0x0622, 0x21ff, 0x3b22, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b1,16383) }, /* #79/1/2/0x22 = #3824 */
    { 0x0620, 0x21ff, 0xb182, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0) }, /* #79/1/2/u0x2 = #3825 */
    { 0x0602, 0x21ff, 0xbba2, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b1,16383) }, /* #79/1/2/u0x20 = #3826 */
    { 0x077f, 0x21ff, 0x3b22, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b1,16383) }, /* #79/1/3/m = #3827 */
    { 0x0700, 0x21ff, 0xb182, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0) }, /* #79/1/3/u = #3828 */
    { 0x0722, 0x21ff, 0x3b22, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b1,16383) }, /* #79/1/3/0x22 = #3829 */
    { 0x0720, 0x21ff, 0xb182, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0) }, /* #79/1/3/u0x2 = #3830 */
    { 0x0702, 0x21ff, 0xbba2, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b1,16383) }, /* #79/1/3/u0x20 = #3831 */
    { 0x087f, 0x21ff, 0x3922, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b0,16383) }, /* #79/2/0/m = #3832 */
    { 0x0800, 0x21ff, 0xb182, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0) }, /* #79/2/0/u = #3833 */
    { 0x0822, 0x21ff, 0x3922, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b0,16383) }, /* #79/2/0/0x22 = #3834 */
    { 0x0820, 0x21ff, 0xb182, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0) }, /* #79/2/0/u0x2 = #3835 */
    { 0x0802, 0x21ff, 0xb9a2, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b0,16383) }, /* #79/2/0/u0x20 = #3836 */
    { 0x097f, 0x21ff, 0x3922, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b0,16383) }, /* #79/2/1/m = #3837 */
    { 0x0900, 0x21ff, 0xb182, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0) }, /* #79/2/1/u = #3838 */
    { 0x0922, 0x21ff, 0x3922, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b0,16383) }, /* #79/2/1/0x22 = #3839 */
    { 0x0920, 0x21ff, 0xb182, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0) }, /* #79/2/1/u0x2 = #3840 */
    { 0x0902, 0x21ff, 0xb9a2, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b0,16383) }, /* #79/2/1/u0x20 = #3841 */
    { 0x0a7f, 0x21ff, 0x3922, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b0,16383) }, /* #79/2/2/m = #3842 */
    { 0x0a00, 0x21ff, 0xb182, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0) }, /* #79/2/2/u = #3843 */
    { 0x0a22, 0x21ff, 0x3922, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b0,16383) }, /* #79/2/2/0x22 = #3844 */
    { 0x0a20, 0x21ff, 0xb182, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0) }, /* #79/2/2/u0x2 = #3845 */
    { 0x0a02, 0x21ff, 0xb9a2, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b0,16383) }, /* #79/2/2/u0x20 = #3846 */
    { 0x0b7f, 0x21ff, 0x3922, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b0,16383) }, /* #79/2/3/m = #3847 */
    { 0x0b00, 0x21ff, 0xb182, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0) }, /* #79/2/3/u = #3848 */
    { 0x0b22, 0x21ff, 0x3922, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b0,16383) }, /* #79/2/3/0x22 = #3849 */
    { 0x0b20, 0x21ff, 0xb182, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0) }, /* #79/2/3/u0x2 = #3850 */
    { 0x0b02, 0x21ff, 0xb9a2, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b0,16383) }, /* #79/2/3/u0x20 = #3851 */
    { 0x0c7f, 0x21ff, 0x3922, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b0,16383) }, /* #79/3/0/m = #3852 */
    { 0x0c00, 0x21ff, 0xb182, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0) }, /* #79/3/0/u = #3853 */
    { 0x0c22, 0x21ff, 0x3922, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b0,16383) }, /* #79/3/0/0x22 = #3854 */
    { 0x0c20, 0x21ff, 0xb182, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0) }, /* #79/3/0/u0x2 = #3855 */
    { 0x0c02, 0x21ff, 0xb9a2, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b0,16383) }, /* #79/3/0/u0x20 = #3856 */
    { 0x0d7f, 0x21ff, 0x3922, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b0,16383) }, /* #79/3/1/m = #3857 */
    { 0x0d00, 0x21ff, 0xb182, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0) }, /* #79/3/1/u = #3858 */
    { 0x0d22, 0x21ff, 0x3922, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b0,16383) }, /* #79/3/1/0x22 = #3859 */
    { 0x0d20, 0x21ff, 0xb182, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0) }, /* #79/3/1/u0x2 = #3860 */
    { 0x0d02, 0x21ff, 0xb9a2, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b0,16383) }, /* #79/3/1/u0x20 = #3861 */
    { 0x0e7f, 0x21ff, 0x3922, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b0,16383) }, /* #79/3/2/m = #3862 */
    { 0x0e00, 0x21ff, 0xb182, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0) }, /* #79/3/2/u = #3863 */
    { 0x0e22, 0x21ff, 0x3922, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b0,16383) }, /* #79/3/2/0x22 = #3864 */
    { 0x0e20, 0x21ff, 0xb182, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0) }, /* #79/3/2/u0x2 = #3865 */
    { 0x0e02, 0x21ff, 0xb9a2, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b0,16383) }, /* #79/3/2/u0x20 = #3866 */
    { 0x0f7f, 0x21ff, 0x3922, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b0,16383) }, /* #79/3/3/m = #3867 */
    { 0x0f00, 0x21ff, 0xb182, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0) }, /* #79/3/3/u = #3868 */
    { 0x0f22, 0x21ff, 0x3922, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b0,16383) }, /* #79/3/3/0x22 = #3869 */
    { 0x0f20, 0x21ff, 0xb182, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0) }, /* #79/3/3/u0x2 = #3870 */
    { 0x0f02, 0x21ff, 0xb9a2, RTFLOAT80U_INIT_C(1,0xf8b6732bd6618e48,0), RTFLOAT80U_INIT_C(1,0x29635d7471b03508,0), RTFLOAT80U_INIT_C(1,0xde2b3ec10699f4b0,16383) }, /* #79/3/3/u0x20 = #3871 */
    { 0x007f, 0x4df0, 0x7d00, RTFLOAT80U_INIT_C(0,0xe993208cb8569855,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/0/0/m = #3872 */
    { 0x0000, 0x4df0, 0x7d00, RTFLOAT80U_INIT_C(0,0xe993208cb8569855,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/0/0/u = #3873 */
    { 0x017f, 0x4df0, 0x7d00, RTFLOAT80U_INIT_C(0,0xe993208cb8569855,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/0/1/m = #3874 */
    { 0x0100, 0x4df0, 0x7d00, RTFLOAT80U_INIT_C(0,0xe993208cb8569855,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/0/1/u = #3875 */
    { 0x027f, 0x4df0, 0x7d00, RTFLOAT80U_INIT_C(0,0xe993208cb8569855,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/0/2/m = #3876 */
    { 0x0200, 0x4df0, 0x7d00, RTFLOAT80U_INIT_C(0,0xe993208cb8569855,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/0/2/u = #3877 */
    { 0x037f, 0x4df0, 0x7d00, RTFLOAT80U_INIT_C(0,0xe993208cb8569855,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/0/3/m = #3878 */
    { 0x0300, 0x4df0, 0x7d00, RTFLOAT80U_INIT_C(0,0xe993208cb8569855,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/0/3/u = #3879 */
    { 0x047f, 0x4df0, 0x7d00, RTFLOAT80U_INIT_C(0,0xe993208cb8569855,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/1/0/m = #3880 */
    { 0x0400, 0x4df0, 0x7d00, RTFLOAT80U_INIT_C(0,0xe993208cb8569855,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/1/0/u = #3881 */
    { 0x057f, 0x4df0, 0x7d00, RTFLOAT80U_INIT_C(0,0xe993208cb8569855,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/1/1/m = #3882 */
    { 0x0500, 0x4df0, 0x7d00, RTFLOAT80U_INIT_C(0,0xe993208cb8569855,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/1/1/u = #3883 */
    { 0x067f, 0x4df0, 0x7d00, RTFLOAT80U_INIT_C(0,0xe993208cb8569855,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/1/2/m = #3884 */
    { 0x0600, 0x4df0, 0x7d00, RTFLOAT80U_INIT_C(0,0xe993208cb8569855,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/1/2/u = #3885 */
    { 0x077f, 0x4df0, 0x7d00, RTFLOAT80U_INIT_C(0,0xe993208cb8569855,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/1/3/m = #3886 */
    { 0x0700, 0x4df0, 0x7d00, RTFLOAT80U_INIT_C(0,0xe993208cb8569855,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/1/3/u = #3887 */
    { 0x087f, 0x4df0, 0x7d00, RTFLOAT80U_INIT_C(0,0xe993208cb8569855,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/2/0/m = #3888 */
    { 0x0800, 0x4df0, 0x7d00, RTFLOAT80U_INIT_C(0,0xe993208cb8569855,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/2/0/u = #3889 */
    { 0x097f, 0x4df0, 0x7d00, RTFLOAT80U_INIT_C(0,0xe993208cb8569855,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/2/1/m = #3890 */
    { 0x0900, 0x4df0, 0x7d00, RTFLOAT80U_INIT_C(0,0xe993208cb8569855,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/2/1/u = #3891 */
    { 0x0a7f, 0x4df0, 0x7d00, RTFLOAT80U_INIT_C(0,0xe993208cb8569855,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/2/2/m = #3892 */
    { 0x0a00, 0x4df0, 0x7d00, RTFLOAT80U_INIT_C(0,0xe993208cb8569855,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/2/2/u = #3893 */
    { 0x0b7f, 0x4df0, 0x7d00, RTFLOAT80U_INIT_C(0,0xe993208cb8569855,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/2/3/m = #3894 */
    { 0x0b00, 0x4df0, 0x7d00, RTFLOAT80U_INIT_C(0,0xe993208cb8569855,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/2/3/u = #3895 */
    { 0x0c7f, 0x4df0, 0x7d00, RTFLOAT80U_INIT_C(0,0xe993208cb8569855,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/3/0/m = #3896 */
    { 0x0c00, 0x4df0, 0x7d00, RTFLOAT80U_INIT_C(0,0xe993208cb8569855,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/3/0/u = #3897 */
    { 0x0d7f, 0x4df0, 0x7d00, RTFLOAT80U_INIT_C(0,0xe993208cb8569855,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/3/1/m = #3898 */
    { 0x0d00, 0x4df0, 0x7d00, RTFLOAT80U_INIT_C(0,0xe993208cb8569855,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/3/1/u = #3899 */
    { 0x0e7f, 0x4df0, 0x7d00, RTFLOAT80U_INIT_C(0,0xe993208cb8569855,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/3/2/m = #3900 */
    { 0x0e00, 0x4df0, 0x7d00, RTFLOAT80U_INIT_C(0,0xe993208cb8569855,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/3/2/u = #3901 */
    { 0x0f7f, 0x4df0, 0x7d00, RTFLOAT80U_INIT_C(0,0xe993208cb8569855,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/3/3/m = #3902 */
    { 0x0f00, 0x4df0, 0x7d00, RTFLOAT80U_INIT_C(0,0xe993208cb8569855,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/3/3/u = #3903 */
    { 0x007f, 0x0a3d, 0x3a22, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #81/0/0/m = #3904 */
    { 0x0000, 0x0a3d, 0xb082, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/0/0/u = #3905 */
    { 0x0022, 0x0a3d, 0x3a22, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #81/0/0/0x22 = #3906 */
    { 0x0020, 0x0a3d, 0xb082, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/0/0/u0x2 = #3907 */
    { 0x0002, 0x0a3d, 0xbaa2, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #81/0/0/u0x20 = #3908 */
    { 0x017f, 0x0a3d, 0x3a22, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #81/0/1/m = #3909 */
    { 0x0100, 0x0a3d, 0xb082, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/0/1/u = #3910 */
    { 0x0122, 0x0a3d, 0x3a22, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #81/0/1/0x22 = #3911 */
    { 0x0120, 0x0a3d, 0xb082, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/0/1/u0x2 = #3912 */
    { 0x0102, 0x0a3d, 0xbaa2, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #81/0/1/u0x20 = #3913 */
    { 0x027f, 0x0a3d, 0x3a22, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #81/0/2/m = #3914 */
    { 0x0200, 0x0a3d, 0xb082, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/0/2/u = #3915 */
    { 0x0222, 0x0a3d, 0x3a22, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #81/0/2/0x22 = #3916 */
    { 0x0220, 0x0a3d, 0xb082, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/0/2/u0x2 = #3917 */
    { 0x0202, 0x0a3d, 0xbaa2, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #81/0/2/u0x20 = #3918 */
    { 0x037f, 0x0a3d, 0x3a22, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #81/0/3/m = #3919 */
    { 0x0300, 0x0a3d, 0xb082, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/0/3/u = #3920 */
    { 0x0322, 0x0a3d, 0x3a22, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #81/0/3/0x22 = #3921 */
    { 0x0320, 0x0a3d, 0xb082, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/0/3/u0x2 = #3922 */
    { 0x0302, 0x0a3d, 0xbaa2, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #81/0/3/u0x20 = #3923 */
    { 0x047f, 0x0a3d, 0x3a22, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #81/1/0/m = #3924 */
    { 0x0400, 0x0a3d, 0xb082, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/1/0/u = #3925 */
    { 0x0422, 0x0a3d, 0x3a22, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #81/1/0/0x22 = #3926 */
    { 0x0420, 0x0a3d, 0xb082, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/1/0/u0x2 = #3927 */
    { 0x0402, 0x0a3d, 0xbaa2, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #81/1/0/u0x20 = #3928 */
    { 0x057f, 0x0a3d, 0x3a22, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #81/1/1/m = #3929 */
    { 0x0500, 0x0a3d, 0xb082, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/1/1/u = #3930 */
    { 0x0522, 0x0a3d, 0x3a22, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #81/1/1/0x22 = #3931 */
    { 0x0520, 0x0a3d, 0xb082, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/1/1/u0x2 = #3932 */
    { 0x0502, 0x0a3d, 0xbaa2, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #81/1/1/u0x20 = #3933 */
    { 0x067f, 0x0a3d, 0x3a22, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #81/1/2/m = #3934 */
    { 0x0600, 0x0a3d, 0xb082, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/1/2/u = #3935 */
    { 0x0622, 0x0a3d, 0x3a22, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #81/1/2/0x22 = #3936 */
    { 0x0620, 0x0a3d, 0xb082, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/1/2/u0x2 = #3937 */
    { 0x0602, 0x0a3d, 0xbaa2, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #81/1/2/u0x20 = #3938 */
    { 0x077f, 0x0a3d, 0x3a22, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #81/1/3/m = #3939 */
    { 0x0700, 0x0a3d, 0xb082, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/1/3/u = #3940 */
    { 0x0722, 0x0a3d, 0x3a22, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #81/1/3/0x22 = #3941 */
    { 0x0720, 0x0a3d, 0xb082, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/1/3/u0x2 = #3942 */
    { 0x0702, 0x0a3d, 0xbaa2, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #81/1/3/u0x20 = #3943 */
    { 0x087f, 0x0a3d, 0x3822, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #81/2/0/m = #3944 */
    { 0x0800, 0x0a3d, 0xb082, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/2/0/u = #3945 */
    { 0x0822, 0x0a3d, 0x3822, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #81/2/0/0x22 = #3946 */
    { 0x0820, 0x0a3d, 0xb082, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/2/0/u0x2 = #3947 */
    { 0x0802, 0x0a3d, 0xb8a2, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #81/2/0/u0x20 = #3948 */
    { 0x097f, 0x0a3d, 0x3822, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #81/2/1/m = #3949 */
    { 0x0900, 0x0a3d, 0xb082, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/2/1/u = #3950 */
    { 0x0922, 0x0a3d, 0x3822, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #81/2/1/0x22 = #3951 */
    { 0x0920, 0x0a3d, 0xb082, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/2/1/u0x2 = #3952 */
    { 0x0902, 0x0a3d, 0xb8a2, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #81/2/1/u0x20 = #3953 */
    { 0x0a7f, 0x0a3d, 0x3822, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #81/2/2/m = #3954 */
    { 0x0a00, 0x0a3d, 0xb082, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/2/2/u = #3955 */
    { 0x0a22, 0x0a3d, 0x3822, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #81/2/2/0x22 = #3956 */
    { 0x0a20, 0x0a3d, 0xb082, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/2/2/u0x2 = #3957 */
    { 0x0a02, 0x0a3d, 0xb8a2, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #81/2/2/u0x20 = #3958 */
    { 0x0b7f, 0x0a3d, 0x3822, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #81/2/3/m = #3959 */
    { 0x0b00, 0x0a3d, 0xb082, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/2/3/u = #3960 */
    { 0x0b22, 0x0a3d, 0x3822, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #81/2/3/0x22 = #3961 */
    { 0x0b20, 0x0a3d, 0xb082, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/2/3/u0x2 = #3962 */
    { 0x0b02, 0x0a3d, 0xb8a2, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #81/2/3/u0x20 = #3963 */
    { 0x0c7f, 0x0a3d, 0x3822, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #81/3/0/m = #3964 */
    { 0x0c00, 0x0a3d, 0xb082, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/3/0/u = #3965 */
    { 0x0c22, 0x0a3d, 0x3822, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #81/3/0/0x22 = #3966 */
    { 0x0c20, 0x0a3d, 0xb082, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/3/0/u0x2 = #3967 */
    { 0x0c02, 0x0a3d, 0xb8a2, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #81/3/0/u0x20 = #3968 */
    { 0x0d7f, 0x0a3d, 0x3822, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #81/3/1/m = #3969 */
    { 0x0d00, 0x0a3d, 0xb082, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/3/1/u = #3970 */
    { 0x0d22, 0x0a3d, 0x3822, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #81/3/1/0x22 = #3971 */
    { 0x0d20, 0x0a3d, 0xb082, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/3/1/u0x2 = #3972 */
    { 0x0d02, 0x0a3d, 0xb8a2, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #81/3/1/u0x20 = #3973 */
    { 0x0e7f, 0x0a3d, 0x3822, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #81/3/2/m = #3974 */
    { 0x0e00, 0x0a3d, 0xb082, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/3/2/u = #3975 */
    { 0x0e22, 0x0a3d, 0x3822, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #81/3/2/0x22 = #3976 */
    { 0x0e20, 0x0a3d, 0xb082, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/3/2/u0x2 = #3977 */
    { 0x0e02, 0x0a3d, 0xb8a2, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #81/3/2/u0x20 = #3978 */
    { 0x0f7f, 0x0a3d, 0x3822, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #81/3/3/m = #3979 */
    { 0x0f00, 0x0a3d, 0xb082, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/3/3/u = #3980 */
    { 0x0f22, 0x0a3d, 0x3822, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #81/3/3/0x22 = #3981 */
    { 0x0f20, 0x0a3d, 0xb082, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/3/3/u0x2 = #3982 */
    { 0x0f02, 0x0a3d, 0xb8a2, RTFLOAT80U_INIT_C(1,0xaee4c3970a5a0e07,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #81/3/3/u0x20 = #3983 */
    { 0x007f, 0xbfe3, 0x3d01, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/0/0/m = #3984 */
    { 0x0000, 0xbfe3, 0xb581, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #82/0/0/u = #3985 */
    { 0x0001, 0xbfe3, 0x3d01, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/0/0/0x1 = #3986 */
    { 0x017f, 0xbfe3, 0x3d01, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/0/1/m = #3987 */
    { 0x0100, 0xbfe3, 0xb581, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #82/0/1/u = #3988 */
    { 0x0101, 0xbfe3, 0x3d01, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/0/1/0x1 = #3989 */
    { 0x027f, 0xbfe3, 0x3d01, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/0/2/m = #3990 */
    { 0x0200, 0xbfe3, 0xb581, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #82/0/2/u = #3991 */
    { 0x0201, 0xbfe3, 0x3d01, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/0/2/0x1 = #3992 */
    { 0x037f, 0xbfe3, 0x3d01, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/0/3/m = #3993 */
    { 0x0300, 0xbfe3, 0xb581, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #82/0/3/u = #3994 */
    { 0x0301, 0xbfe3, 0x3d01, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/0/3/0x1 = #3995 */
    { 0x047f, 0xbfe3, 0x3d01, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/1/0/m = #3996 */
    { 0x0400, 0xbfe3, 0xb581, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #82/1/0/u = #3997 */
    { 0x0401, 0xbfe3, 0x3d01, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/1/0/0x1 = #3998 */
    { 0x057f, 0xbfe3, 0x3d01, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/1/1/m = #3999 */
    { 0x0500, 0xbfe3, 0xb581, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #82/1/1/u = #4000 */
    { 0x0501, 0xbfe3, 0x3d01, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/1/1/0x1 = #4001 */
    { 0x067f, 0xbfe3, 0x3d01, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/1/2/m = #4002 */
    { 0x0600, 0xbfe3, 0xb581, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #82/1/2/u = #4003 */
    { 0x0601, 0xbfe3, 0x3d01, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/1/2/0x1 = #4004 */
    { 0x077f, 0xbfe3, 0x3d01, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/1/3/m = #4005 */
    { 0x0700, 0xbfe3, 0xb581, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #82/1/3/u = #4006 */
    { 0x0701, 0xbfe3, 0x3d01, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/1/3/0x1 = #4007 */
    { 0x087f, 0xbfe3, 0x3d01, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/2/0/m = #4008 */
    { 0x0800, 0xbfe3, 0xb581, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #82/2/0/u = #4009 */
    { 0x0801, 0xbfe3, 0x3d01, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/2/0/0x1 = #4010 */
    { 0x097f, 0xbfe3, 0x3d01, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/2/1/m = #4011 */
    { 0x0900, 0xbfe3, 0xb581, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #82/2/1/u = #4012 */
    { 0x0901, 0xbfe3, 0x3d01, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/2/1/0x1 = #4013 */
    { 0x0a7f, 0xbfe3, 0x3d01, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/2/2/m = #4014 */
    { 0x0a00, 0xbfe3, 0xb581, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #82/2/2/u = #4015 */
    { 0x0a01, 0xbfe3, 0x3d01, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/2/2/0x1 = #4016 */
    { 0x0b7f, 0xbfe3, 0x3d01, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/2/3/m = #4017 */
    { 0x0b00, 0xbfe3, 0xb581, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #82/2/3/u = #4018 */
    { 0x0b01, 0xbfe3, 0x3d01, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/2/3/0x1 = #4019 */
    { 0x0c7f, 0xbfe3, 0x3d01, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/3/0/m = #4020 */
    { 0x0c00, 0xbfe3, 0xb581, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #82/3/0/u = #4021 */
    { 0x0c01, 0xbfe3, 0x3d01, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/3/0/0x1 = #4022 */
    { 0x0d7f, 0xbfe3, 0x3d01, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/3/1/m = #4023 */
    { 0x0d00, 0xbfe3, 0xb581, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #82/3/1/u = #4024 */
    { 0x0d01, 0xbfe3, 0x3d01, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/3/1/0x1 = #4025 */
    { 0x0e7f, 0xbfe3, 0x3d01, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/3/2/m = #4026 */
    { 0x0e00, 0xbfe3, 0xb581, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #82/3/2/u = #4027 */
    { 0x0e01, 0xbfe3, 0x3d01, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/3/2/0x1 = #4028 */
    { 0x0f7f, 0xbfe3, 0x3d01, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/3/3/m = #4029 */
    { 0x0f00, 0xbfe3, 0xb581, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #82/3/3/u = #4030 */
    { 0x0f01, 0xbfe3, 0x3d01, RTFLOAT80U_INIT_C(1,0x95837a9bc9e2284d,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/3/3/0x1 = #4031 */
    { 0x007f, 0xba89, 0x3a22, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #83/0/0/m = #4032 */
    { 0x0000, 0xba89, 0xb082, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #83/0/0/u = #4033 */
    { 0x0022, 0xba89, 0x3a22, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #83/0/0/0x22 = #4034 */
    { 0x0020, 0xba89, 0xb082, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #83/0/0/u0x2 = #4035 */
    { 0x0002, 0xba89, 0xbaa2, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #83/0/0/u0x20 = #4036 */
    { 0x017f, 0xba89, 0x3a22, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #83/0/1/m = #4037 */
    { 0x0100, 0xba89, 0xb082, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #83/0/1/u = #4038 */
    { 0x0122, 0xba89, 0x3a22, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #83/0/1/0x22 = #4039 */
    { 0x0120, 0xba89, 0xb082, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #83/0/1/u0x2 = #4040 */
    { 0x0102, 0xba89, 0xbaa2, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #83/0/1/u0x20 = #4041 */
    { 0x027f, 0xba89, 0x3a22, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #83/0/2/m = #4042 */
    { 0x0200, 0xba89, 0xb082, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #83/0/2/u = #4043 */
    { 0x0222, 0xba89, 0x3a22, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #83/0/2/0x22 = #4044 */
    { 0x0220, 0xba89, 0xb082, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #83/0/2/u0x2 = #4045 */
    { 0x0202, 0xba89, 0xbaa2, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #83/0/2/u0x20 = #4046 */
    { 0x037f, 0xba89, 0x3a22, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #83/0/3/m = #4047 */
    { 0x0300, 0xba89, 0xb082, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #83/0/3/u = #4048 */
    { 0x0322, 0xba89, 0x3a22, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #83/0/3/0x22 = #4049 */
    { 0x0320, 0xba89, 0xb082, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #83/0/3/u0x2 = #4050 */
    { 0x0302, 0xba89, 0xbaa2, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #83/0/3/u0x20 = #4051 */
    { 0x047f, 0xba89, 0x3822, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #83/1/0/m = #4052 */
    { 0x0400, 0xba89, 0xb082, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #83/1/0/u = #4053 */
    { 0x0422, 0xba89, 0x3822, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #83/1/0/0x22 = #4054 */
    { 0x0420, 0xba89, 0xb082, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #83/1/0/u0x2 = #4055 */
    { 0x0402, 0xba89, 0xb8a2, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #83/1/0/u0x20 = #4056 */
    { 0x057f, 0xba89, 0x3822, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #83/1/1/m = #4057 */
    { 0x0500, 0xba89, 0xb082, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #83/1/1/u = #4058 */
    { 0x0522, 0xba89, 0x3822, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #83/1/1/0x22 = #4059 */
    { 0x0520, 0xba89, 0xb082, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #83/1/1/u0x2 = #4060 */
    { 0x0502, 0xba89, 0xb8a2, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #83/1/1/u0x20 = #4061 */
    { 0x067f, 0xba89, 0x3822, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #83/1/2/m = #4062 */
    { 0x0600, 0xba89, 0xb082, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #83/1/2/u = #4063 */
    { 0x0622, 0xba89, 0x3822, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #83/1/2/0x22 = #4064 */
    { 0x0620, 0xba89, 0xb082, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #83/1/2/u0x2 = #4065 */
    { 0x0602, 0xba89, 0xb8a2, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #83/1/2/u0x20 = #4066 */
    { 0x077f, 0xba89, 0x3822, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #83/1/3/m = #4067 */
    { 0x0700, 0xba89, 0xb082, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #83/1/3/u = #4068 */
    { 0x0722, 0xba89, 0x3822, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #83/1/3/0x22 = #4069 */
    { 0x0720, 0xba89, 0xb082, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #83/1/3/u0x2 = #4070 */
    { 0x0702, 0xba89, 0xb8a2, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #83/1/3/u0x20 = #4071 */
    { 0x087f, 0xba89, 0x3a22, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #83/2/0/m = #4072 */
    { 0x0800, 0xba89, 0xb082, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #83/2/0/u = #4073 */
    { 0x0822, 0xba89, 0x3a22, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #83/2/0/0x22 = #4074 */
    { 0x0820, 0xba89, 0xb082, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #83/2/0/u0x2 = #4075 */
    { 0x0802, 0xba89, 0xbaa2, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #83/2/0/u0x20 = #4076 */
    { 0x097f, 0xba89, 0x3a22, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #83/2/1/m = #4077 */
    { 0x0900, 0xba89, 0xb082, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #83/2/1/u = #4078 */
    { 0x0922, 0xba89, 0x3a22, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #83/2/1/0x22 = #4079 */
    { 0x0920, 0xba89, 0xb082, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #83/2/1/u0x2 = #4080 */
    { 0x0902, 0xba89, 0xbaa2, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #83/2/1/u0x20 = #4081 */
    { 0x0a7f, 0xba89, 0x3a22, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #83/2/2/m = #4082 */
    { 0x0a00, 0xba89, 0xb082, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #83/2/2/u = #4083 */
    { 0x0a22, 0xba89, 0x3a22, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #83/2/2/0x22 = #4084 */
    { 0x0a20, 0xba89, 0xb082, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #83/2/2/u0x2 = #4085 */
    { 0x0a02, 0xba89, 0xbaa2, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #83/2/2/u0x20 = #4086 */
    { 0x0b7f, 0xba89, 0x3a22, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #83/2/3/m = #4087 */
    { 0x0b00, 0xba89, 0xb082, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #83/2/3/u = #4088 */
    { 0x0b22, 0xba89, 0x3a22, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #83/2/3/0x22 = #4089 */
    { 0x0b20, 0xba89, 0xb082, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #83/2/3/u0x2 = #4090 */
    { 0x0b02, 0xba89, 0xbaa2, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #83/2/3/u0x20 = #4091 */
    { 0x0c7f, 0xba89, 0x3822, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #83/3/0/m = #4092 */
    { 0x0c00, 0xba89, 0xb082, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #83/3/0/u = #4093 */
    { 0x0c22, 0xba89, 0x3822, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #83/3/0/0x22 = #4094 */
    { 0x0c20, 0xba89, 0xb082, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #83/3/0/u0x2 = #4095 */
    { 0x0c02, 0xba89, 0xb8a2, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #83/3/0/u0x20 = #4096 */
    { 0x0d7f, 0xba89, 0x3822, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #83/3/1/m = #4097 */
    { 0x0d00, 0xba89, 0xb082, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #83/3/1/u = #4098 */
    { 0x0d22, 0xba89, 0x3822, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #83/3/1/0x22 = #4099 */
    { 0x0d20, 0xba89, 0xb082, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #83/3/1/u0x2 = #4100 */
    { 0x0d02, 0xba89, 0xb8a2, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #83/3/1/u0x20 = #4101 */
    { 0x0e7f, 0xba89, 0x3822, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #83/3/2/m = #4102 */
    { 0x0e00, 0xba89, 0xb082, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #83/3/2/u = #4103 */
    { 0x0e22, 0xba89, 0x3822, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #83/3/2/0x22 = #4104 */
    { 0x0e20, 0xba89, 0xb082, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #83/3/2/u0x2 = #4105 */
    { 0x0e02, 0xba89, 0xb8a2, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #83/3/2/u0x20 = #4106 */
    { 0x0f7f, 0xba89, 0x3822, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #83/3/3/m = #4107 */
    { 0x0f00, 0xba89, 0xb082, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #83/3/3/u = #4108 */
    { 0x0f22, 0xba89, 0x3822, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #83/3/3/0x22 = #4109 */
    { 0x0f20, 0xba89, 0xb082, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #83/3/3/u0x2 = #4110 */
    { 0x0f02, 0xba89, 0xb8a2, RTFLOAT80U_INIT_C(0,0xf2da1c132f8184c5,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #83/3/3/u0x20 = #4111 */
    { 0x007f, 0x0992, 0x3b22, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #84/0/0/m = #4112 */
    { 0x0000, 0x0992, 0xb182, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616) }, /* #84/0/0/u = #4113 */
    { 0x0022, 0x0992, 0x3b22, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #84/0/0/0x22 = #4114 */
    { 0x0020, 0x0992, 0xb182, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616) }, /* #84/0/0/u0x2 = #4115 */
    { 0x0002, 0x0992, 0xbba2, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #84/0/0/u0x20 = #4116 */
    { 0x017f, 0x0992, 0x3b22, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #84/0/1/m = #4117 */
    { 0x0100, 0x0992, 0xb182, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616) }, /* #84/0/1/u = #4118 */
    { 0x0122, 0x0992, 0x3b22, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #84/0/1/0x22 = #4119 */
    { 0x0120, 0x0992, 0xb182, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616) }, /* #84/0/1/u0x2 = #4120 */
    { 0x0102, 0x0992, 0xbba2, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #84/0/1/u0x20 = #4121 */
    { 0x027f, 0x0992, 0x3b22, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #84/0/2/m = #4122 */
    { 0x0200, 0x0992, 0xb182, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616) }, /* #84/0/2/u = #4123 */
    { 0x0222, 0x0992, 0x3b22, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #84/0/2/0x22 = #4124 */
    { 0x0220, 0x0992, 0xb182, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616) }, /* #84/0/2/u0x2 = #4125 */
    { 0x0202, 0x0992, 0xbba2, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #84/0/2/u0x20 = #4126 */
    { 0x037f, 0x0992, 0x3b22, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #84/0/3/m = #4127 */
    { 0x0300, 0x0992, 0xb182, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616) }, /* #84/0/3/u = #4128 */
    { 0x0322, 0x0992, 0x3b22, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #84/0/3/0x22 = #4129 */
    { 0x0320, 0x0992, 0xb182, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616) }, /* #84/0/3/u0x2 = #4130 */
    { 0x0302, 0x0992, 0xbba2, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #84/0/3/u0x20 = #4131 */
    { 0x047f, 0x0992, 0x3922, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #84/1/0/m = #4132 */
    { 0x0400, 0x0992, 0xb182, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616) }, /* #84/1/0/u = #4133 */
    { 0x0422, 0x0992, 0x3922, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #84/1/0/0x22 = #4134 */
    { 0x0420, 0x0992, 0xb182, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616) }, /* #84/1/0/u0x2 = #4135 */
    { 0x0402, 0x0992, 0xb9a2, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #84/1/0/u0x20 = #4136 */
    { 0x057f, 0x0992, 0x3922, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #84/1/1/m = #4137 */
    { 0x0500, 0x0992, 0xb182, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616) }, /* #84/1/1/u = #4138 */
    { 0x0522, 0x0992, 0x3922, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #84/1/1/0x22 = #4139 */
    { 0x0520, 0x0992, 0xb182, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616) }, /* #84/1/1/u0x2 = #4140 */
    { 0x0502, 0x0992, 0xb9a2, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #84/1/1/u0x20 = #4141 */
    { 0x067f, 0x0992, 0x3922, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #84/1/2/m = #4142 */
    { 0x0600, 0x0992, 0xb182, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616) }, /* #84/1/2/u = #4143 */
    { 0x0622, 0x0992, 0x3922, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #84/1/2/0x22 = #4144 */
    { 0x0620, 0x0992, 0xb182, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616) }, /* #84/1/2/u0x2 = #4145 */
    { 0x0602, 0x0992, 0xb9a2, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #84/1/2/u0x20 = #4146 */
    { 0x077f, 0x0992, 0x3922, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #84/1/3/m = #4147 */
    { 0x0700, 0x0992, 0xb182, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616) }, /* #84/1/3/u = #4148 */
    { 0x0722, 0x0992, 0x3922, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #84/1/3/0x22 = #4149 */
    { 0x0720, 0x0992, 0xb182, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616) }, /* #84/1/3/u0x2 = #4150 */
    { 0x0702, 0x0992, 0xb9a2, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #84/1/3/u0x20 = #4151 */
    { 0x087f, 0x0992, 0x3b22, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #84/2/0/m = #4152 */
    { 0x0800, 0x0992, 0xb182, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616) }, /* #84/2/0/u = #4153 */
    { 0x0822, 0x0992, 0x3b22, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #84/2/0/0x22 = #4154 */
    { 0x0820, 0x0992, 0xb182, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616) }, /* #84/2/0/u0x2 = #4155 */
    { 0x0802, 0x0992, 0xbba2, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #84/2/0/u0x20 = #4156 */
    { 0x097f, 0x0992, 0x3b22, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #84/2/1/m = #4157 */
    { 0x0900, 0x0992, 0xb182, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616) }, /* #84/2/1/u = #4158 */
    { 0x0922, 0x0992, 0x3b22, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #84/2/1/0x22 = #4159 */
    { 0x0920, 0x0992, 0xb182, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616) }, /* #84/2/1/u0x2 = #4160 */
    { 0x0902, 0x0992, 0xbba2, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #84/2/1/u0x20 = #4161 */
    { 0x0a7f, 0x0992, 0x3b22, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #84/2/2/m = #4162 */
    { 0x0a00, 0x0992, 0xb182, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616) }, /* #84/2/2/u = #4163 */
    { 0x0a22, 0x0992, 0x3b22, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #84/2/2/0x22 = #4164 */
    { 0x0a20, 0x0992, 0xb182, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616) }, /* #84/2/2/u0x2 = #4165 */
    { 0x0a02, 0x0992, 0xbba2, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #84/2/2/u0x20 = #4166 */
    { 0x0b7f, 0x0992, 0x3b22, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #84/2/3/m = #4167 */
    { 0x0b00, 0x0992, 0xb182, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616) }, /* #84/2/3/u = #4168 */
    { 0x0b22, 0x0992, 0x3b22, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #84/2/3/0x22 = #4169 */
    { 0x0b20, 0x0992, 0xb182, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616) }, /* #84/2/3/u0x2 = #4170 */
    { 0x0b02, 0x0992, 0xbba2, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #84/2/3/u0x20 = #4171 */
    { 0x0c7f, 0x0992, 0x3922, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #84/3/0/m = #4172 */
    { 0x0c00, 0x0992, 0xb182, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616) }, /* #84/3/0/u = #4173 */
    { 0x0c22, 0x0992, 0x3922, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #84/3/0/0x22 = #4174 */
    { 0x0c20, 0x0992, 0xb182, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616) }, /* #84/3/0/u0x2 = #4175 */
    { 0x0c02, 0x0992, 0xb9a2, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #84/3/0/u0x20 = #4176 */
    { 0x0d7f, 0x0992, 0x3922, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #84/3/1/m = #4177 */
    { 0x0d00, 0x0992, 0xb182, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616) }, /* #84/3/1/u = #4178 */
    { 0x0d22, 0x0992, 0x3922, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #84/3/1/0x22 = #4179 */
    { 0x0d20, 0x0992, 0xb182, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616) }, /* #84/3/1/u0x2 = #4180 */
    { 0x0d02, 0x0992, 0xb9a2, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #84/3/1/u0x20 = #4181 */
    { 0x0e7f, 0x0992, 0x3922, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #84/3/2/m = #4182 */
    { 0x0e00, 0x0992, 0xb182, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616) }, /* #84/3/2/u = #4183 */
    { 0x0e22, 0x0992, 0x3922, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #84/3/2/0x22 = #4184 */
    { 0x0e20, 0x0992, 0xb182, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616) }, /* #84/3/2/u0x2 = #4185 */
    { 0x0e02, 0x0992, 0xb9a2, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #84/3/2/u0x20 = #4186 */
    { 0x0f7f, 0x0992, 0x3922, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #84/3/3/m = #4187 */
    { 0x0f00, 0x0992, 0xb182, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616) }, /* #84/3/3/u = #4188 */
    { 0x0f22, 0x0992, 0x3922, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #84/3/3/0x22 = #4189 */
    { 0x0f20, 0x0992, 0xb182, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616) }, /* #84/3/3/u0x2 = #4190 */
    { 0x0f02, 0x0992, 0xb9a2, RTFLOAT80U_INIT_C(0,0x6ab436bfd2e8f440,0), RTFLOAT80U_INIT_C(1,0xce490202fd25ae63,21616), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #84/3/3/u0x20 = #4191 */
    { 0x007f, 0xec0a, 0x7e22, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #85/0/0/m = #4192 */
    { 0x0000, 0xec0a, 0xf482, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856) }, /* #85/0/0/u = #4193 */
    { 0x0022, 0xec0a, 0x7e22, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #85/0/0/0x22 = #4194 */
    { 0x0020, 0xec0a, 0xf482, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856) }, /* #85/0/0/u0x2 = #4195 */
    { 0x0002, 0xec0a, 0xfea2, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #85/0/0/u0x20 = #4196 */
    { 0x017f, 0xec0a, 0x7e22, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #85/0/1/m = #4197 */
    { 0x0100, 0xec0a, 0xf482, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856) }, /* #85/0/1/u = #4198 */
    { 0x0122, 0xec0a, 0x7e22, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #85/0/1/0x22 = #4199 */
    { 0x0120, 0xec0a, 0xf482, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856) }, /* #85/0/1/u0x2 = #4200 */
    { 0x0102, 0xec0a, 0xfea2, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #85/0/1/u0x20 = #4201 */
    { 0x027f, 0xec0a, 0x7e22, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #85/0/2/m = #4202 */
    { 0x0200, 0xec0a, 0xf482, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856) }, /* #85/0/2/u = #4203 */
    { 0x0222, 0xec0a, 0x7e22, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #85/0/2/0x22 = #4204 */
    { 0x0220, 0xec0a, 0xf482, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856) }, /* #85/0/2/u0x2 = #4205 */
    { 0x0202, 0xec0a, 0xfea2, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #85/0/2/u0x20 = #4206 */
    { 0x037f, 0xec0a, 0x7e22, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #85/0/3/m = #4207 */
    { 0x0300, 0xec0a, 0xf482, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856) }, /* #85/0/3/u = #4208 */
    { 0x0322, 0xec0a, 0x7e22, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #85/0/3/0x22 = #4209 */
    { 0x0320, 0xec0a, 0xf482, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856) }, /* #85/0/3/u0x2 = #4210 */
    { 0x0302, 0xec0a, 0xfea2, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #85/0/3/u0x20 = #4211 */
    { 0x047f, 0xec0a, 0x7c22, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #85/1/0/m = #4212 */
    { 0x0400, 0xec0a, 0xf482, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856) }, /* #85/1/0/u = #4213 */
    { 0x0422, 0xec0a, 0x7c22, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #85/1/0/0x22 = #4214 */
    { 0x0420, 0xec0a, 0xf482, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856) }, /* #85/1/0/u0x2 = #4215 */
    { 0x0402, 0xec0a, 0xfca2, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #85/1/0/u0x20 = #4216 */
    { 0x057f, 0xec0a, 0x7c22, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #85/1/1/m = #4217 */
    { 0x0500, 0xec0a, 0xf482, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856) }, /* #85/1/1/u = #4218 */
    { 0x0522, 0xec0a, 0x7c22, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #85/1/1/0x22 = #4219 */
    { 0x0520, 0xec0a, 0xf482, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856) }, /* #85/1/1/u0x2 = #4220 */
    { 0x0502, 0xec0a, 0xfca2, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #85/1/1/u0x20 = #4221 */
    { 0x067f, 0xec0a, 0x7c22, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #85/1/2/m = #4222 */
    { 0x0600, 0xec0a, 0xf482, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856) }, /* #85/1/2/u = #4223 */
    { 0x0622, 0xec0a, 0x7c22, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #85/1/2/0x22 = #4224 */
    { 0x0620, 0xec0a, 0xf482, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856) }, /* #85/1/2/u0x2 = #4225 */
    { 0x0602, 0xec0a, 0xfca2, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #85/1/2/u0x20 = #4226 */
    { 0x077f, 0xec0a, 0x7c22, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #85/1/3/m = #4227 */
    { 0x0700, 0xec0a, 0xf482, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856) }, /* #85/1/3/u = #4228 */
    { 0x0722, 0xec0a, 0x7c22, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #85/1/3/0x22 = #4229 */
    { 0x0720, 0xec0a, 0xf482, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856) }, /* #85/1/3/u0x2 = #4230 */
    { 0x0702, 0xec0a, 0xfca2, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #85/1/3/u0x20 = #4231 */
    { 0x087f, 0xec0a, 0x7e22, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #85/2/0/m = #4232 */
    { 0x0800, 0xec0a, 0xf482, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856) }, /* #85/2/0/u = #4233 */
    { 0x0822, 0xec0a, 0x7e22, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #85/2/0/0x22 = #4234 */
    { 0x0820, 0xec0a, 0xf482, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856) }, /* #85/2/0/u0x2 = #4235 */
    { 0x0802, 0xec0a, 0xfea2, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #85/2/0/u0x20 = #4236 */
    { 0x097f, 0xec0a, 0x7e22, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #85/2/1/m = #4237 */
    { 0x0900, 0xec0a, 0xf482, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856) }, /* #85/2/1/u = #4238 */
    { 0x0922, 0xec0a, 0x7e22, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #85/2/1/0x22 = #4239 */
    { 0x0920, 0xec0a, 0xf482, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856) }, /* #85/2/1/u0x2 = #4240 */
    { 0x0902, 0xec0a, 0xfea2, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #85/2/1/u0x20 = #4241 */
    { 0x0a7f, 0xec0a, 0x7e22, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #85/2/2/m = #4242 */
    { 0x0a00, 0xec0a, 0xf482, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856) }, /* #85/2/2/u = #4243 */
    { 0x0a22, 0xec0a, 0x7e22, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #85/2/2/0x22 = #4244 */
    { 0x0a20, 0xec0a, 0xf482, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856) }, /* #85/2/2/u0x2 = #4245 */
    { 0x0a02, 0xec0a, 0xfea2, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #85/2/2/u0x20 = #4246 */
    { 0x0b7f, 0xec0a, 0x7e22, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #85/2/3/m = #4247 */
    { 0x0b00, 0xec0a, 0xf482, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856) }, /* #85/2/3/u = #4248 */
    { 0x0b22, 0xec0a, 0x7e22, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #85/2/3/0x22 = #4249 */
    { 0x0b20, 0xec0a, 0xf482, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856) }, /* #85/2/3/u0x2 = #4250 */
    { 0x0b02, 0xec0a, 0xfea2, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #85/2/3/u0x20 = #4251 */
    { 0x0c7f, 0xec0a, 0x7c22, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #85/3/0/m = #4252 */
    { 0x0c00, 0xec0a, 0xf482, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856) }, /* #85/3/0/u = #4253 */
    { 0x0c22, 0xec0a, 0x7c22, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #85/3/0/0x22 = #4254 */
    { 0x0c20, 0xec0a, 0xf482, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856) }, /* #85/3/0/u0x2 = #4255 */
    { 0x0c02, 0xec0a, 0xfca2, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #85/3/0/u0x20 = #4256 */
    { 0x0d7f, 0xec0a, 0x7c22, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #85/3/1/m = #4257 */
    { 0x0d00, 0xec0a, 0xf482, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856) }, /* #85/3/1/u = #4258 */
    { 0x0d22, 0xec0a, 0x7c22, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #85/3/1/0x22 = #4259 */
    { 0x0d20, 0xec0a, 0xf482, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856) }, /* #85/3/1/u0x2 = #4260 */
    { 0x0d02, 0xec0a, 0xfca2, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #85/3/1/u0x20 = #4261 */
    { 0x0e7f, 0xec0a, 0x7c22, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #85/3/2/m = #4262 */
    { 0x0e00, 0xec0a, 0xf482, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856) }, /* #85/3/2/u = #4263 */
    { 0x0e22, 0xec0a, 0x7c22, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #85/3/2/0x22 = #4264 */
    { 0x0e20, 0xec0a, 0xf482, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856) }, /* #85/3/2/u0x2 = #4265 */
    { 0x0e02, 0xec0a, 0xfca2, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #85/3/2/u0x20 = #4266 */
    { 0x0f7f, 0xec0a, 0x7c22, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #85/3/3/m = #4267 */
    { 0x0f00, 0xec0a, 0xf482, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856) }, /* #85/3/3/u = #4268 */
    { 0x0f22, 0xec0a, 0x7c22, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #85/3/3/0x22 = #4269 */
    { 0x0f20, 0xec0a, 0xf482, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856) }, /* #85/3/3/u0x2 = #4270 */
    { 0x0f02, 0xec0a, 0xfca2, RTFLOAT80U_INIT_C(0,0x381a506eb0237f01,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,31856), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #85/3/3/u0x20 = #4271 */
    { 0x007f, 0x9e02, 0x3c01, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_IND(1) }, /* #86/0/0/m = #4272 */
    { 0x0000, 0x9e02, 0xb481, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53) }, /* #86/0/0/u = #4273 */
    { 0x0001, 0x9e02, 0x3c01, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_IND(1) }, /* #86/0/0/0x1 = #4274 */
    { 0x017f, 0x9e02, 0x3c01, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_IND(1) }, /* #86/0/1/m = #4275 */
    { 0x0100, 0x9e02, 0xb481, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53) }, /* #86/0/1/u = #4276 */
    { 0x0101, 0x9e02, 0x3c01, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_IND(1) }, /* #86/0/1/0x1 = #4277 */
    { 0x027f, 0x9e02, 0x3c01, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_IND(1) }, /* #86/0/2/m = #4278 */
    { 0x0200, 0x9e02, 0xb481, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53) }, /* #86/0/2/u = #4279 */
    { 0x0201, 0x9e02, 0x3c01, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_IND(1) }, /* #86/0/2/0x1 = #4280 */
    { 0x037f, 0x9e02, 0x3c01, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_IND(1) }, /* #86/0/3/m = #4281 */
    { 0x0300, 0x9e02, 0xb481, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53) }, /* #86/0/3/u = #4282 */
    { 0x0301, 0x9e02, 0x3c01, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_IND(1) }, /* #86/0/3/0x1 = #4283 */
    { 0x047f, 0x9e02, 0x3c01, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_IND(1) }, /* #86/1/0/m = #4284 */
    { 0x0400, 0x9e02, 0xb481, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53) }, /* #86/1/0/u = #4285 */
    { 0x0401, 0x9e02, 0x3c01, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_IND(1) }, /* #86/1/0/0x1 = #4286 */
    { 0x057f, 0x9e02, 0x3c01, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_IND(1) }, /* #86/1/1/m = #4287 */
    { 0x0500, 0x9e02, 0xb481, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53) }, /* #86/1/1/u = #4288 */
    { 0x0501, 0x9e02, 0x3c01, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_IND(1) }, /* #86/1/1/0x1 = #4289 */
    { 0x067f, 0x9e02, 0x3c01, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_IND(1) }, /* #86/1/2/m = #4290 */
    { 0x0600, 0x9e02, 0xb481, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53) }, /* #86/1/2/u = #4291 */
    { 0x0601, 0x9e02, 0x3c01, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_IND(1) }, /* #86/1/2/0x1 = #4292 */
    { 0x077f, 0x9e02, 0x3c01, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_IND(1) }, /* #86/1/3/m = #4293 */
    { 0x0700, 0x9e02, 0xb481, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53) }, /* #86/1/3/u = #4294 */
    { 0x0701, 0x9e02, 0x3c01, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_IND(1) }, /* #86/1/3/0x1 = #4295 */
    { 0x087f, 0x9e02, 0x3c01, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_IND(1) }, /* #86/2/0/m = #4296 */
    { 0x0800, 0x9e02, 0xb481, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53) }, /* #86/2/0/u = #4297 */
    { 0x0801, 0x9e02, 0x3c01, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_IND(1) }, /* #86/2/0/0x1 = #4298 */
    { 0x097f, 0x9e02, 0x3c01, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_IND(1) }, /* #86/2/1/m = #4299 */
    { 0x0900, 0x9e02, 0xb481, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53) }, /* #86/2/1/u = #4300 */
    { 0x0901, 0x9e02, 0x3c01, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_IND(1) }, /* #86/2/1/0x1 = #4301 */
    { 0x0a7f, 0x9e02, 0x3c01, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_IND(1) }, /* #86/2/2/m = #4302 */
    { 0x0a00, 0x9e02, 0xb481, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53) }, /* #86/2/2/u = #4303 */
    { 0x0a01, 0x9e02, 0x3c01, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_IND(1) }, /* #86/2/2/0x1 = #4304 */
    { 0x0b7f, 0x9e02, 0x3c01, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_IND(1) }, /* #86/2/3/m = #4305 */
    { 0x0b00, 0x9e02, 0xb481, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53) }, /* #86/2/3/u = #4306 */
    { 0x0b01, 0x9e02, 0x3c01, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_IND(1) }, /* #86/2/3/0x1 = #4307 */
    { 0x0c7f, 0x9e02, 0x3c01, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_IND(1) }, /* #86/3/0/m = #4308 */
    { 0x0c00, 0x9e02, 0xb481, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53) }, /* #86/3/0/u = #4309 */
    { 0x0c01, 0x9e02, 0x3c01, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_IND(1) }, /* #86/3/0/0x1 = #4310 */
    { 0x0d7f, 0x9e02, 0x3c01, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_IND(1) }, /* #86/3/1/m = #4311 */
    { 0x0d00, 0x9e02, 0xb481, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53) }, /* #86/3/1/u = #4312 */
    { 0x0d01, 0x9e02, 0x3c01, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_IND(1) }, /* #86/3/1/0x1 = #4313 */
    { 0x0e7f, 0x9e02, 0x3c01, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_IND(1) }, /* #86/3/2/m = #4314 */
    { 0x0e00, 0x9e02, 0xb481, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53) }, /* #86/3/2/u = #4315 */
    { 0x0e01, 0x9e02, 0x3c01, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_IND(1) }, /* #86/3/2/0x1 = #4316 */
    { 0x0f7f, 0x9e02, 0x3c01, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_IND(1) }, /* #86/3/3/m = #4317 */
    { 0x0f00, 0x9e02, 0xb481, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53) }, /* #86/3/3/u = #4318 */
    { 0x0f01, 0x9e02, 0x3c01, RTFLOAT80U_INIT_C(0,0xa5650ac5b9ea475,0), RTFLOAT80U_INIT_C(1,0x21463ff3e97d8f5c,53), RTFLOAT80U_INIT_IND(1) }, /* #86/3/3/0x1 = #4319 */
    { 0x007f, 0xd736, 0x7d01, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0xdd63940d5164a0c1,32767) }, /* #87/0/0/m = #4320 */
    { 0x0000, 0xd736, 0xf581, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767) }, /* #87/0/0/u = #4321 */
    { 0x0001, 0xd736, 0x7d01, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0xdd63940d5164a0c1,32767) }, /* #87/0/0/0x1 = #4322 */
    { 0x017f, 0xd736, 0x7d01, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0xdd63940d5164a0c1,32767) }, /* #87/0/1/m = #4323 */
    { 0x0100, 0xd736, 0xf581, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767) }, /* #87/0/1/u = #4324 */
    { 0x0101, 0xd736, 0x7d01, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0xdd63940d5164a0c1,32767) }, /* #87/0/1/0x1 = #4325 */
    { 0x027f, 0xd736, 0x7d01, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0xdd63940d5164a0c1,32767) }, /* #87/0/2/m = #4326 */
    { 0x0200, 0xd736, 0xf581, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767) }, /* #87/0/2/u = #4327 */
    { 0x0201, 0xd736, 0x7d01, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0xdd63940d5164a0c1,32767) }, /* #87/0/2/0x1 = #4328 */
    { 0x037f, 0xd736, 0x7d01, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0xdd63940d5164a0c1,32767) }, /* #87/0/3/m = #4329 */
    { 0x0300, 0xd736, 0xf581, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767) }, /* #87/0/3/u = #4330 */
    { 0x0301, 0xd736, 0x7d01, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0xdd63940d5164a0c1,32767) }, /* #87/0/3/0x1 = #4331 */
    { 0x047f, 0xd736, 0x7d01, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0xdd63940d5164a0c1,32767) }, /* #87/1/0/m = #4332 */
    { 0x0400, 0xd736, 0xf581, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767) }, /* #87/1/0/u = #4333 */
    { 0x0401, 0xd736, 0x7d01, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0xdd63940d5164a0c1,32767) }, /* #87/1/0/0x1 = #4334 */
    { 0x057f, 0xd736, 0x7d01, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0xdd63940d5164a0c1,32767) }, /* #87/1/1/m = #4335 */
    { 0x0500, 0xd736, 0xf581, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767) }, /* #87/1/1/u = #4336 */
    { 0x0501, 0xd736, 0x7d01, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0xdd63940d5164a0c1,32767) }, /* #87/1/1/0x1 = #4337 */
    { 0x067f, 0xd736, 0x7d01, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0xdd63940d5164a0c1,32767) }, /* #87/1/2/m = #4338 */
    { 0x0600, 0xd736, 0xf581, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767) }, /* #87/1/2/u = #4339 */
    { 0x0601, 0xd736, 0x7d01, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0xdd63940d5164a0c1,32767) }, /* #87/1/2/0x1 = #4340 */
    { 0x077f, 0xd736, 0x7d01, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0xdd63940d5164a0c1,32767) }, /* #87/1/3/m = #4341 */
    { 0x0700, 0xd736, 0xf581, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767) }, /* #87/1/3/u = #4342 */
    { 0x0701, 0xd736, 0x7d01, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0xdd63940d5164a0c1,32767) }, /* #87/1/3/0x1 = #4343 */
    { 0x087f, 0xd736, 0x7d01, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0xdd63940d5164a0c1,32767) }, /* #87/2/0/m = #4344 */
    { 0x0800, 0xd736, 0xf581, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767) }, /* #87/2/0/u = #4345 */
    { 0x0801, 0xd736, 0x7d01, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0xdd63940d5164a0c1,32767) }, /* #87/2/0/0x1 = #4346 */
    { 0x097f, 0xd736, 0x7d01, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0xdd63940d5164a0c1,32767) }, /* #87/2/1/m = #4347 */
    { 0x0900, 0xd736, 0xf581, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767) }, /* #87/2/1/u = #4348 */
    { 0x0901, 0xd736, 0x7d01, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0xdd63940d5164a0c1,32767) }, /* #87/2/1/0x1 = #4349 */
    { 0x0a7f, 0xd736, 0x7d01, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0xdd63940d5164a0c1,32767) }, /* #87/2/2/m = #4350 */
    { 0x0a00, 0xd736, 0xf581, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767) }, /* #87/2/2/u = #4351 */
    { 0x0a01, 0xd736, 0x7d01, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0xdd63940d5164a0c1,32767) }, /* #87/2/2/0x1 = #4352 */
    { 0x0b7f, 0xd736, 0x7d01, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0xdd63940d5164a0c1,32767) }, /* #87/2/3/m = #4353 */
    { 0x0b00, 0xd736, 0xf581, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767) }, /* #87/2/3/u = #4354 */
    { 0x0b01, 0xd736, 0x7d01, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0xdd63940d5164a0c1,32767) }, /* #87/2/3/0x1 = #4355 */
    { 0x0c7f, 0xd736, 0x7d01, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0xdd63940d5164a0c1,32767) }, /* #87/3/0/m = #4356 */
    { 0x0c00, 0xd736, 0xf581, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767) }, /* #87/3/0/u = #4357 */
    { 0x0c01, 0xd736, 0x7d01, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0xdd63940d5164a0c1,32767) }, /* #87/3/0/0x1 = #4358 */
    { 0x0d7f, 0xd736, 0x7d01, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0xdd63940d5164a0c1,32767) }, /* #87/3/1/m = #4359 */
    { 0x0d00, 0xd736, 0xf581, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767) }, /* #87/3/1/u = #4360 */
    { 0x0d01, 0xd736, 0x7d01, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0xdd63940d5164a0c1,32767) }, /* #87/3/1/0x1 = #4361 */
    { 0x0e7f, 0xd736, 0x7d01, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0xdd63940d5164a0c1,32767) }, /* #87/3/2/m = #4362 */
    { 0x0e00, 0xd736, 0xf581, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767) }, /* #87/3/2/u = #4363 */
    { 0x0e01, 0xd736, 0x7d01, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0xdd63940d5164a0c1,32767) }, /* #87/3/2/0x1 = #4364 */
    { 0x0f7f, 0xd736, 0x7d01, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0xdd63940d5164a0c1,32767) }, /* #87/3/3/m = #4365 */
    { 0x0f00, 0xd736, 0xf581, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767) }, /* #87/3/3/u = #4366 */
    { 0x0f01, 0xd736, 0x7d01, RTFLOAT80U_INIT_C(0,0x68c3ca6734cf0bf2,0), RTFLOAT80U_INIT_C(0,0x9d63940d5164a0c1,32767), RTFLOAT80U_INIT_C(0,0xdd63940d5164a0c1,32767) }, /* #87/3/3/0x1 = #4367 */
    { 0x007f, 0x27fc, 0x3d00, RTFLOAT80U_INIT_C(1,0x52f1267f890b9cf6,0), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767) }, /* #88/0/0/m = #4368 */
    { 0x0000, 0x27fc, 0x3d00, RTFLOAT80U_INIT_C(1,0x52f1267f890b9cf6,0), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767) }, /* #88/0/0/u = #4369 */
    { 0x017f, 0x27fc, 0x3d00, RTFLOAT80U_INIT_C(1,0x52f1267f890b9cf6,0), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767) }, /* #88/0/1/m = #4370 */
    { 0x0100, 0x27fc, 0x3d00, RTFLOAT80U_INIT_C(1,0x52f1267f890b9cf6,0), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767) }, /* #88/0/1/u = #4371 */
    { 0x027f, 0x27fc, 0x3d00, RTFLOAT80U_INIT_C(1,0x52f1267f890b9cf6,0), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767) }, /* #88/0/2/m = #4372 */
    { 0x0200, 0x27fc, 0x3d00, RTFLOAT80U_INIT_C(1,0x52f1267f890b9cf6,0), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767) }, /* #88/0/2/u = #4373 */
    { 0x037f, 0x27fc, 0x3d00, RTFLOAT80U_INIT_C(1,0x52f1267f890b9cf6,0), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767) }, /* #88/0/3/m = #4374 */
    { 0x0300, 0x27fc, 0x3d00, RTFLOAT80U_INIT_C(1,0x52f1267f890b9cf6,0), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767) }, /* #88/0/3/u = #4375 */
    { 0x047f, 0x27fc, 0x3d00, RTFLOAT80U_INIT_C(1,0x52f1267f890b9cf6,0), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767) }, /* #88/1/0/m = #4376 */
    { 0x0400, 0x27fc, 0x3d00, RTFLOAT80U_INIT_C(1,0x52f1267f890b9cf6,0), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767) }, /* #88/1/0/u = #4377 */
    { 0x057f, 0x27fc, 0x3d00, RTFLOAT80U_INIT_C(1,0x52f1267f890b9cf6,0), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767) }, /* #88/1/1/m = #4378 */
    { 0x0500, 0x27fc, 0x3d00, RTFLOAT80U_INIT_C(1,0x52f1267f890b9cf6,0), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767) }, /* #88/1/1/u = #4379 */
    { 0x067f, 0x27fc, 0x3d00, RTFLOAT80U_INIT_C(1,0x52f1267f890b9cf6,0), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767) }, /* #88/1/2/m = #4380 */
    { 0x0600, 0x27fc, 0x3d00, RTFLOAT80U_INIT_C(1,0x52f1267f890b9cf6,0), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767) }, /* #88/1/2/u = #4381 */
    { 0x077f, 0x27fc, 0x3d00, RTFLOAT80U_INIT_C(1,0x52f1267f890b9cf6,0), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767) }, /* #88/1/3/m = #4382 */
    { 0x0700, 0x27fc, 0x3d00, RTFLOAT80U_INIT_C(1,0x52f1267f890b9cf6,0), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767) }, /* #88/1/3/u = #4383 */
    { 0x087f, 0x27fc, 0x3d00, RTFLOAT80U_INIT_C(1,0x52f1267f890b9cf6,0), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767) }, /* #88/2/0/m = #4384 */
    { 0x0800, 0x27fc, 0x3d00, RTFLOAT80U_INIT_C(1,0x52f1267f890b9cf6,0), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767) }, /* #88/2/0/u = #4385 */
    { 0x097f, 0x27fc, 0x3d00, RTFLOAT80U_INIT_C(1,0x52f1267f890b9cf6,0), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767) }, /* #88/2/1/m = #4386 */
    { 0x0900, 0x27fc, 0x3d00, RTFLOAT80U_INIT_C(1,0x52f1267f890b9cf6,0), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767) }, /* #88/2/1/u = #4387 */
    { 0x0a7f, 0x27fc, 0x3d00, RTFLOAT80U_INIT_C(1,0x52f1267f890b9cf6,0), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767) }, /* #88/2/2/m = #4388 */
    { 0x0a00, 0x27fc, 0x3d00, RTFLOAT80U_INIT_C(1,0x52f1267f890b9cf6,0), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767) }, /* #88/2/2/u = #4389 */
    { 0x0b7f, 0x27fc, 0x3d00, RTFLOAT80U_INIT_C(1,0x52f1267f890b9cf6,0), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767) }, /* #88/2/3/m = #4390 */
    { 0x0b00, 0x27fc, 0x3d00, RTFLOAT80U_INIT_C(1,0x52f1267f890b9cf6,0), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767) }, /* #88/2/3/u = #4391 */
    { 0x0c7f, 0x27fc, 0x3d00, RTFLOAT80U_INIT_C(1,0x52f1267f890b9cf6,0), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767) }, /* #88/3/0/m = #4392 */
    { 0x0c00, 0x27fc, 0x3d00, RTFLOAT80U_INIT_C(1,0x52f1267f890b9cf6,0), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767) }, /* #88/3/0/u = #4393 */
    { 0x0d7f, 0x27fc, 0x3d00, RTFLOAT80U_INIT_C(1,0x52f1267f890b9cf6,0), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767) }, /* #88/3/1/m = #4394 */
    { 0x0d00, 0x27fc, 0x3d00, RTFLOAT80U_INIT_C(1,0x52f1267f890b9cf6,0), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767) }, /* #88/3/1/u = #4395 */
    { 0x0e7f, 0x27fc, 0x3d00, RTFLOAT80U_INIT_C(1,0x52f1267f890b9cf6,0), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767) }, /* #88/3/2/m = #4396 */
    { 0x0e00, 0x27fc, 0x3d00, RTFLOAT80U_INIT_C(1,0x52f1267f890b9cf6,0), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767) }, /* #88/3/2/u = #4397 */
    { 0x0f7f, 0x27fc, 0x3d00, RTFLOAT80U_INIT_C(1,0x52f1267f890b9cf6,0), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767) }, /* #88/3/3/m = #4398 */
    { 0x0f00, 0x27fc, 0x3d00, RTFLOAT80U_INIT_C(1,0x52f1267f890b9cf6,0), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767), RTFLOAT80U_INIT_C(1,0xf466ad5a8df16d9d,32767) }, /* #88/3/3/u = #4399 */
    { 0x007f, 0x1b17, 0x3901, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/0/0/m = #4400 */
    { 0x0000, 0x1b17, 0xb181, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767) }, /* #89/0/0/u = #4401 */
    { 0x0001, 0x1b17, 0x3901, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/0/0/0x1 = #4402 */
    { 0x017f, 0x1b17, 0x3901, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/0/1/m = #4403 */
    { 0x0100, 0x1b17, 0xb181, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767) }, /* #89/0/1/u = #4404 */
    { 0x0101, 0x1b17, 0x3901, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/0/1/0x1 = #4405 */
    { 0x027f, 0x1b17, 0x3901, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/0/2/m = #4406 */
    { 0x0200, 0x1b17, 0xb181, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767) }, /* #89/0/2/u = #4407 */
    { 0x0201, 0x1b17, 0x3901, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/0/2/0x1 = #4408 */
    { 0x037f, 0x1b17, 0x3901, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/0/3/m = #4409 */
    { 0x0300, 0x1b17, 0xb181, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767) }, /* #89/0/3/u = #4410 */
    { 0x0301, 0x1b17, 0x3901, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/0/3/0x1 = #4411 */
    { 0x047f, 0x1b17, 0x3901, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/1/0/m = #4412 */
    { 0x0400, 0x1b17, 0xb181, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767) }, /* #89/1/0/u = #4413 */
    { 0x0401, 0x1b17, 0x3901, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/1/0/0x1 = #4414 */
    { 0x057f, 0x1b17, 0x3901, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/1/1/m = #4415 */
    { 0x0500, 0x1b17, 0xb181, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767) }, /* #89/1/1/u = #4416 */
    { 0x0501, 0x1b17, 0x3901, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/1/1/0x1 = #4417 */
    { 0x067f, 0x1b17, 0x3901, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/1/2/m = #4418 */
    { 0x0600, 0x1b17, 0xb181, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767) }, /* #89/1/2/u = #4419 */
    { 0x0601, 0x1b17, 0x3901, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/1/2/0x1 = #4420 */
    { 0x077f, 0x1b17, 0x3901, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/1/3/m = #4421 */
    { 0x0700, 0x1b17, 0xb181, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767) }, /* #89/1/3/u = #4422 */
    { 0x0701, 0x1b17, 0x3901, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/1/3/0x1 = #4423 */
    { 0x087f, 0x1b17, 0x3901, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/2/0/m = #4424 */
    { 0x0800, 0x1b17, 0xb181, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767) }, /* #89/2/0/u = #4425 */
    { 0x0801, 0x1b17, 0x3901, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/2/0/0x1 = #4426 */
    { 0x097f, 0x1b17, 0x3901, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/2/1/m = #4427 */
    { 0x0900, 0x1b17, 0xb181, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767) }, /* #89/2/1/u = #4428 */
    { 0x0901, 0x1b17, 0x3901, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/2/1/0x1 = #4429 */
    { 0x0a7f, 0x1b17, 0x3901, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/2/2/m = #4430 */
    { 0x0a00, 0x1b17, 0xb181, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767) }, /* #89/2/2/u = #4431 */
    { 0x0a01, 0x1b17, 0x3901, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/2/2/0x1 = #4432 */
    { 0x0b7f, 0x1b17, 0x3901, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/2/3/m = #4433 */
    { 0x0b00, 0x1b17, 0xb181, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767) }, /* #89/2/3/u = #4434 */
    { 0x0b01, 0x1b17, 0x3901, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/2/3/0x1 = #4435 */
    { 0x0c7f, 0x1b17, 0x3901, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/3/0/m = #4436 */
    { 0x0c00, 0x1b17, 0xb181, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767) }, /* #89/3/0/u = #4437 */
    { 0x0c01, 0x1b17, 0x3901, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/3/0/0x1 = #4438 */
    { 0x0d7f, 0x1b17, 0x3901, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/3/1/m = #4439 */
    { 0x0d00, 0x1b17, 0xb181, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767) }, /* #89/3/1/u = #4440 */
    { 0x0d01, 0x1b17, 0x3901, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/3/1/0x1 = #4441 */
    { 0x0e7f, 0x1b17, 0x3901, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/3/2/m = #4442 */
    { 0x0e00, 0x1b17, 0xb181, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767) }, /* #89/3/2/u = #4443 */
    { 0x0e01, 0x1b17, 0x3901, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/3/2/0x1 = #4444 */
    { 0x0f7f, 0x1b17, 0x3901, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/3/3/m = #4445 */
    { 0x0f00, 0x1b17, 0xb181, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767) }, /* #89/3/3/u = #4446 */
    { 0x0f01, 0x1b17, 0x3901, RTFLOAT80U_INIT_C(1,0x2433b0317f67a331,0), RTFLOAT80U_INIT_C(0,0x60a7b8a633d0c896,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/3/3/0x1 = #4447 */
    { 0x007f, 0x4e3e, 0x7e22, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155814,16381) }, /* #90/0/0/m = #4448 */
    { 0x0000, 0x4e3e, 0xf482, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0) }, /* #90/0/0/u = #4449 */
    { 0x0022, 0x4e3e, 0x7e22, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155814,16381) }, /* #90/0/0/0x22 = #4450 */
    { 0x0020, 0x4e3e, 0xf482, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0) }, /* #90/0/0/u0x2 = #4451 */
    { 0x0002, 0x4e3e, 0xfea2, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155814,16381) }, /* #90/0/0/u0x20 = #4452 */
    { 0x017f, 0x4e3e, 0x7e22, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155814,16381) }, /* #90/0/1/m = #4453 */
    { 0x0100, 0x4e3e, 0xf482, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0) }, /* #90/0/1/u = #4454 */
    { 0x0122, 0x4e3e, 0x7e22, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155814,16381) }, /* #90/0/1/0x22 = #4455 */
    { 0x0120, 0x4e3e, 0xf482, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0) }, /* #90/0/1/u0x2 = #4456 */
    { 0x0102, 0x4e3e, 0xfea2, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155814,16381) }, /* #90/0/1/u0x20 = #4457 */
    { 0x027f, 0x4e3e, 0x7e22, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155814,16381) }, /* #90/0/2/m = #4458 */
    { 0x0200, 0x4e3e, 0xf482, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0) }, /* #90/0/2/u = #4459 */
    { 0x0222, 0x4e3e, 0x7e22, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155814,16381) }, /* #90/0/2/0x22 = #4460 */
    { 0x0220, 0x4e3e, 0xf482, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0) }, /* #90/0/2/u0x2 = #4461 */
    { 0x0202, 0x4e3e, 0xfea2, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155814,16381) }, /* #90/0/2/u0x20 = #4462 */
    { 0x037f, 0x4e3e, 0x7e22, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155814,16381) }, /* #90/0/3/m = #4463 */
    { 0x0300, 0x4e3e, 0xf482, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0) }, /* #90/0/3/u = #4464 */
    { 0x0322, 0x4e3e, 0x7e22, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155814,16381) }, /* #90/0/3/0x22 = #4465 */
    { 0x0320, 0x4e3e, 0xf482, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0) }, /* #90/0/3/u0x2 = #4466 */
    { 0x0302, 0x4e3e, 0xfea2, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155814,16381) }, /* #90/0/3/u0x20 = #4467 */
    { 0x047f, 0x4e3e, 0x7e22, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155814,16381) }, /* #90/1/0/m = #4468 */
    { 0x0400, 0x4e3e, 0xf482, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0) }, /* #90/1/0/u = #4469 */
    { 0x0422, 0x4e3e, 0x7e22, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155814,16381) }, /* #90/1/0/0x22 = #4470 */
    { 0x0420, 0x4e3e, 0xf482, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0) }, /* #90/1/0/u0x2 = #4471 */
    { 0x0402, 0x4e3e, 0xfea2, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155814,16381) }, /* #90/1/0/u0x20 = #4472 */
    { 0x057f, 0x4e3e, 0x7e22, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155814,16381) }, /* #90/1/1/m = #4473 */
    { 0x0500, 0x4e3e, 0xf482, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0) }, /* #90/1/1/u = #4474 */
    { 0x0522, 0x4e3e, 0x7e22, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155814,16381) }, /* #90/1/1/0x22 = #4475 */
    { 0x0520, 0x4e3e, 0xf482, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0) }, /* #90/1/1/u0x2 = #4476 */
    { 0x0502, 0x4e3e, 0xfea2, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155814,16381) }, /* #90/1/1/u0x20 = #4477 */
    { 0x067f, 0x4e3e, 0x7e22, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155814,16381) }, /* #90/1/2/m = #4478 */
    { 0x0600, 0x4e3e, 0xf482, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0) }, /* #90/1/2/u = #4479 */
    { 0x0622, 0x4e3e, 0x7e22, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155814,16381) }, /* #90/1/2/0x22 = #4480 */
    { 0x0620, 0x4e3e, 0xf482, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0) }, /* #90/1/2/u0x2 = #4481 */
    { 0x0602, 0x4e3e, 0xfea2, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155814,16381) }, /* #90/1/2/u0x20 = #4482 */
    { 0x077f, 0x4e3e, 0x7e22, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155814,16381) }, /* #90/1/3/m = #4483 */
    { 0x0700, 0x4e3e, 0xf482, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0) }, /* #90/1/3/u = #4484 */
    { 0x0722, 0x4e3e, 0x7e22, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155814,16381) }, /* #90/1/3/0x22 = #4485 */
    { 0x0720, 0x4e3e, 0xf482, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0) }, /* #90/1/3/u0x2 = #4486 */
    { 0x0702, 0x4e3e, 0xfea2, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155814,16381) }, /* #90/1/3/u0x20 = #4487 */
    { 0x087f, 0x4e3e, 0x7c22, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155813,16381) }, /* #90/2/0/m = #4488 */
    { 0x0800, 0x4e3e, 0xf482, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0) }, /* #90/2/0/u = #4489 */
    { 0x0822, 0x4e3e, 0x7c22, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155813,16381) }, /* #90/2/0/0x22 = #4490 */
    { 0x0820, 0x4e3e, 0xf482, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0) }, /* #90/2/0/u0x2 = #4491 */
    { 0x0802, 0x4e3e, 0xfca2, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155813,16381) }, /* #90/2/0/u0x20 = #4492 */
    { 0x097f, 0x4e3e, 0x7c22, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155813,16381) }, /* #90/2/1/m = #4493 */
    { 0x0900, 0x4e3e, 0xf482, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0) }, /* #90/2/1/u = #4494 */
    { 0x0922, 0x4e3e, 0x7c22, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155813,16381) }, /* #90/2/1/0x22 = #4495 */
    { 0x0920, 0x4e3e, 0xf482, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0) }, /* #90/2/1/u0x2 = #4496 */
    { 0x0902, 0x4e3e, 0xfca2, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155813,16381) }, /* #90/2/1/u0x20 = #4497 */
    { 0x0a7f, 0x4e3e, 0x7c22, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155813,16381) }, /* #90/2/2/m = #4498 */
    { 0x0a00, 0x4e3e, 0xf482, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0) }, /* #90/2/2/u = #4499 */
    { 0x0a22, 0x4e3e, 0x7c22, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155813,16381) }, /* #90/2/2/0x22 = #4500 */
    { 0x0a20, 0x4e3e, 0xf482, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0) }, /* #90/2/2/u0x2 = #4501 */
    { 0x0a02, 0x4e3e, 0xfca2, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155813,16381) }, /* #90/2/2/u0x20 = #4502 */
    { 0x0b7f, 0x4e3e, 0x7c22, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155813,16381) }, /* #90/2/3/m = #4503 */
    { 0x0b00, 0x4e3e, 0xf482, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0) }, /* #90/2/3/u = #4504 */
    { 0x0b22, 0x4e3e, 0x7c22, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155813,16381) }, /* #90/2/3/0x22 = #4505 */
    { 0x0b20, 0x4e3e, 0xf482, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0) }, /* #90/2/3/u0x2 = #4506 */
    { 0x0b02, 0x4e3e, 0xfca2, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155813,16381) }, /* #90/2/3/u0x20 = #4507 */
    { 0x0c7f, 0x4e3e, 0x7c22, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155813,16381) }, /* #90/3/0/m = #4508 */
    { 0x0c00, 0x4e3e, 0xf482, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0) }, /* #90/3/0/u = #4509 */
    { 0x0c22, 0x4e3e, 0x7c22, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155813,16381) }, /* #90/3/0/0x22 = #4510 */
    { 0x0c20, 0x4e3e, 0xf482, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0) }, /* #90/3/0/u0x2 = #4511 */
    { 0x0c02, 0x4e3e, 0xfca2, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155813,16381) }, /* #90/3/0/u0x20 = #4512 */
    { 0x0d7f, 0x4e3e, 0x7c22, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155813,16381) }, /* #90/3/1/m = #4513 */
    { 0x0d00, 0x4e3e, 0xf482, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0) }, /* #90/3/1/u = #4514 */
    { 0x0d22, 0x4e3e, 0x7c22, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155813,16381) }, /* #90/3/1/0x22 = #4515 */
    { 0x0d20, 0x4e3e, 0xf482, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0) }, /* #90/3/1/u0x2 = #4516 */
    { 0x0d02, 0x4e3e, 0xfca2, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155813,16381) }, /* #90/3/1/u0x20 = #4517 */
    { 0x0e7f, 0x4e3e, 0x7c22, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155813,16381) }, /* #90/3/2/m = #4518 */
    { 0x0e00, 0x4e3e, 0xf482, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0) }, /* #90/3/2/u = #4519 */
    { 0x0e22, 0x4e3e, 0x7c22, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155813,16381) }, /* #90/3/2/0x22 = #4520 */
    { 0x0e20, 0x4e3e, 0xf482, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0) }, /* #90/3/2/u0x2 = #4521 */
    { 0x0e02, 0x4e3e, 0xfca2, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155813,16381) }, /* #90/3/2/u0x20 = #4522 */
    { 0x0f7f, 0x4e3e, 0x7c22, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155813,16381) }, /* #90/3/3/m = #4523 */
    { 0x0f00, 0x4e3e, 0xf482, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0) }, /* #90/3/3/u = #4524 */
    { 0x0f22, 0x4e3e, 0x7c22, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155813,16381) }, /* #90/3/3/0x22 = #4525 */
    { 0x0f20, 0x4e3e, 0xf482, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0) }, /* #90/3/3/u0x2 = #4526 */
    { 0x0f02, 0x4e3e, 0xfca2, RTFLOAT80U_INIT_C(1,0x6cc0161ee34125cd,0), RTFLOAT80U_INIT_C(0,0xdf524c83e8e8942f,0), RTFLOAT80U_INIT_C(1,0xe805917c67155813,16381) }, /* #90/3/3/u0x20 = #4527 */
    { 0x007f, 0x8f3b, 0x3f22, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1772,16383) }, /* #91/0/0/m = #4528 */
    { 0x0000, 0x8f3b, 0xb582, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0) }, /* #91/0/0/u = #4529 */
    { 0x0022, 0x8f3b, 0x3f22, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1772,16383) }, /* #91/0/0/0x22 = #4530 */
    { 0x0020, 0x8f3b, 0xb582, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0) }, /* #91/0/0/u0x2 = #4531 */
    { 0x0002, 0x8f3b, 0xbfa2, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1772,16383) }, /* #91/0/0/u0x20 = #4532 */
    { 0x017f, 0x8f3b, 0x3f22, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1772,16383) }, /* #91/0/1/m = #4533 */
    { 0x0100, 0x8f3b, 0xb582, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0) }, /* #91/0/1/u = #4534 */
    { 0x0122, 0x8f3b, 0x3f22, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1772,16383) }, /* #91/0/1/0x22 = #4535 */
    { 0x0120, 0x8f3b, 0xb582, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0) }, /* #91/0/1/u0x2 = #4536 */
    { 0x0102, 0x8f3b, 0xbfa2, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1772,16383) }, /* #91/0/1/u0x20 = #4537 */
    { 0x027f, 0x8f3b, 0x3f22, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1772,16383) }, /* #91/0/2/m = #4538 */
    { 0x0200, 0x8f3b, 0xb582, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0) }, /* #91/0/2/u = #4539 */
    { 0x0222, 0x8f3b, 0x3f22, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1772,16383) }, /* #91/0/2/0x22 = #4540 */
    { 0x0220, 0x8f3b, 0xb582, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0) }, /* #91/0/2/u0x2 = #4541 */
    { 0x0202, 0x8f3b, 0xbfa2, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1772,16383) }, /* #91/0/2/u0x20 = #4542 */
    { 0x037f, 0x8f3b, 0x3f22, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1772,16383) }, /* #91/0/3/m = #4543 */
    { 0x0300, 0x8f3b, 0xb582, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0) }, /* #91/0/3/u = #4544 */
    { 0x0322, 0x8f3b, 0x3f22, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1772,16383) }, /* #91/0/3/0x22 = #4545 */
    { 0x0320, 0x8f3b, 0xb582, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0) }, /* #91/0/3/u0x2 = #4546 */
    { 0x0302, 0x8f3b, 0xbfa2, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1772,16383) }, /* #91/0/3/u0x20 = #4547 */
    { 0x047f, 0x8f3b, 0x3f22, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1772,16383) }, /* #91/1/0/m = #4548 */
    { 0x0400, 0x8f3b, 0xb582, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0) }, /* #91/1/0/u = #4549 */
    { 0x0422, 0x8f3b, 0x3f22, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1772,16383) }, /* #91/1/0/0x22 = #4550 */
    { 0x0420, 0x8f3b, 0xb582, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0) }, /* #91/1/0/u0x2 = #4551 */
    { 0x0402, 0x8f3b, 0xbfa2, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1772,16383) }, /* #91/1/0/u0x20 = #4552 */
    { 0x057f, 0x8f3b, 0x3f22, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1772,16383) }, /* #91/1/1/m = #4553 */
    { 0x0500, 0x8f3b, 0xb582, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0) }, /* #91/1/1/u = #4554 */
    { 0x0522, 0x8f3b, 0x3f22, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1772,16383) }, /* #91/1/1/0x22 = #4555 */
    { 0x0520, 0x8f3b, 0xb582, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0) }, /* #91/1/1/u0x2 = #4556 */
    { 0x0502, 0x8f3b, 0xbfa2, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1772,16383) }, /* #91/1/1/u0x20 = #4557 */
    { 0x067f, 0x8f3b, 0x3f22, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1772,16383) }, /* #91/1/2/m = #4558 */
    { 0x0600, 0x8f3b, 0xb582, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0) }, /* #91/1/2/u = #4559 */
    { 0x0622, 0x8f3b, 0x3f22, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1772,16383) }, /* #91/1/2/0x22 = #4560 */
    { 0x0620, 0x8f3b, 0xb582, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0) }, /* #91/1/2/u0x2 = #4561 */
    { 0x0602, 0x8f3b, 0xbfa2, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1772,16383) }, /* #91/1/2/u0x20 = #4562 */
    { 0x077f, 0x8f3b, 0x3f22, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1772,16383) }, /* #91/1/3/m = #4563 */
    { 0x0700, 0x8f3b, 0xb582, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0) }, /* #91/1/3/u = #4564 */
    { 0x0722, 0x8f3b, 0x3f22, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1772,16383) }, /* #91/1/3/0x22 = #4565 */
    { 0x0720, 0x8f3b, 0xb582, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0) }, /* #91/1/3/u0x2 = #4566 */
    { 0x0702, 0x8f3b, 0xbfa2, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1772,16383) }, /* #91/1/3/u0x20 = #4567 */
    { 0x087f, 0x8f3b, 0x3d22, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1771,16383) }, /* #91/2/0/m = #4568 */
    { 0x0800, 0x8f3b, 0xb582, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0) }, /* #91/2/0/u = #4569 */
    { 0x0822, 0x8f3b, 0x3d22, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1771,16383) }, /* #91/2/0/0x22 = #4570 */
    { 0x0820, 0x8f3b, 0xb582, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0) }, /* #91/2/0/u0x2 = #4571 */
    { 0x0802, 0x8f3b, 0xbda2, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1771,16383) }, /* #91/2/0/u0x20 = #4572 */
    { 0x097f, 0x8f3b, 0x3d22, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1771,16383) }, /* #91/2/1/m = #4573 */
    { 0x0900, 0x8f3b, 0xb582, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0) }, /* #91/2/1/u = #4574 */
    { 0x0922, 0x8f3b, 0x3d22, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1771,16383) }, /* #91/2/1/0x22 = #4575 */
    { 0x0920, 0x8f3b, 0xb582, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0) }, /* #91/2/1/u0x2 = #4576 */
    { 0x0902, 0x8f3b, 0xbda2, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1771,16383) }, /* #91/2/1/u0x20 = #4577 */
    { 0x0a7f, 0x8f3b, 0x3d22, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1771,16383) }, /* #91/2/2/m = #4578 */
    { 0x0a00, 0x8f3b, 0xb582, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0) }, /* #91/2/2/u = #4579 */
    { 0x0a22, 0x8f3b, 0x3d22, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1771,16383) }, /* #91/2/2/0x22 = #4580 */
    { 0x0a20, 0x8f3b, 0xb582, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0) }, /* #91/2/2/u0x2 = #4581 */
    { 0x0a02, 0x8f3b, 0xbda2, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1771,16383) }, /* #91/2/2/u0x20 = #4582 */
    { 0x0b7f, 0x8f3b, 0x3d22, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1771,16383) }, /* #91/2/3/m = #4583 */
    { 0x0b00, 0x8f3b, 0xb582, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0) }, /* #91/2/3/u = #4584 */
    { 0x0b22, 0x8f3b, 0x3d22, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1771,16383) }, /* #91/2/3/0x22 = #4585 */
    { 0x0b20, 0x8f3b, 0xb582, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0) }, /* #91/2/3/u0x2 = #4586 */
    { 0x0b02, 0x8f3b, 0xbda2, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1771,16383) }, /* #91/2/3/u0x20 = #4587 */
    { 0x0c7f, 0x8f3b, 0x3d22, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1771,16383) }, /* #91/3/0/m = #4588 */
    { 0x0c00, 0x8f3b, 0xb582, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0) }, /* #91/3/0/u = #4589 */
    { 0x0c22, 0x8f3b, 0x3d22, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1771,16383) }, /* #91/3/0/0x22 = #4590 */
    { 0x0c20, 0x8f3b, 0xb582, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0) }, /* #91/3/0/u0x2 = #4591 */
    { 0x0c02, 0x8f3b, 0xbda2, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1771,16383) }, /* #91/3/0/u0x20 = #4592 */
    { 0x0d7f, 0x8f3b, 0x3d22, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1771,16383) }, /* #91/3/1/m = #4593 */
    { 0x0d00, 0x8f3b, 0xb582, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0) }, /* #91/3/1/u = #4594 */
    { 0x0d22, 0x8f3b, 0x3d22, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1771,16383) }, /* #91/3/1/0x22 = #4595 */
    { 0x0d20, 0x8f3b, 0xb582, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0) }, /* #91/3/1/u0x2 = #4596 */
    { 0x0d02, 0x8f3b, 0xbda2, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1771,16383) }, /* #91/3/1/u0x20 = #4597 */
    { 0x0e7f, 0x8f3b, 0x3d22, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1771,16383) }, /* #91/3/2/m = #4598 */
    { 0x0e00, 0x8f3b, 0xb582, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0) }, /* #91/3/2/u = #4599 */
    { 0x0e22, 0x8f3b, 0x3d22, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1771,16383) }, /* #91/3/2/0x22 = #4600 */
    { 0x0e20, 0x8f3b, 0xb582, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0) }, /* #91/3/2/u0x2 = #4601 */
    { 0x0e02, 0x8f3b, 0xbda2, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1771,16383) }, /* #91/3/2/u0x20 = #4602 */
    { 0x0f7f, 0x8f3b, 0x3d22, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1771,16383) }, /* #91/3/3/m = #4603 */
    { 0x0f00, 0x8f3b, 0xb582, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0) }, /* #91/3/3/u = #4604 */
    { 0x0f22, 0x8f3b, 0x3d22, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1771,16383) }, /* #91/3/3/0x22 = #4605 */
    { 0x0f20, 0x8f3b, 0xb582, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0) }, /* #91/3/3/u0x2 = #4606 */
    { 0x0f02, 0x8f3b, 0xbda2, RTFLOAT80U_INIT_C(1,0x71b559f623bfbe6a,0), RTFLOAT80U_INIT_C(1,0x2711b1b2ee30c738,0), RTFLOAT80U_INIT_C(1,0xf36c888bf66f1771,16383) }, /* #91/3/3/u0x20 = #4607 */
    { 0x007f, 0xab35, 0x3900, RTFLOAT80U_INIT_C(0,0x3cf2ff187a45e877,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/0/0/m = #4608 */
    { 0x0000, 0xab35, 0x3900, RTFLOAT80U_INIT_C(0,0x3cf2ff187a45e877,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/0/0/u = #4609 */
    { 0x017f, 0xab35, 0x3900, RTFLOAT80U_INIT_C(0,0x3cf2ff187a45e877,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/0/1/m = #4610 */
    { 0x0100, 0xab35, 0x3900, RTFLOAT80U_INIT_C(0,0x3cf2ff187a45e877,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/0/1/u = #4611 */
    { 0x027f, 0xab35, 0x3900, RTFLOAT80U_INIT_C(0,0x3cf2ff187a45e877,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/0/2/m = #4612 */
    { 0x0200, 0xab35, 0x3900, RTFLOAT80U_INIT_C(0,0x3cf2ff187a45e877,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/0/2/u = #4613 */
    { 0x037f, 0xab35, 0x3900, RTFLOAT80U_INIT_C(0,0x3cf2ff187a45e877,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/0/3/m = #4614 */
    { 0x0300, 0xab35, 0x3900, RTFLOAT80U_INIT_C(0,0x3cf2ff187a45e877,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/0/3/u = #4615 */
    { 0x047f, 0xab35, 0x3900, RTFLOAT80U_INIT_C(0,0x3cf2ff187a45e877,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/1/0/m = #4616 */
    { 0x0400, 0xab35, 0x3900, RTFLOAT80U_INIT_C(0,0x3cf2ff187a45e877,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/1/0/u = #4617 */
    { 0x057f, 0xab35, 0x3900, RTFLOAT80U_INIT_C(0,0x3cf2ff187a45e877,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/1/1/m = #4618 */
    { 0x0500, 0xab35, 0x3900, RTFLOAT80U_INIT_C(0,0x3cf2ff187a45e877,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/1/1/u = #4619 */
    { 0x067f, 0xab35, 0x3900, RTFLOAT80U_INIT_C(0,0x3cf2ff187a45e877,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/1/2/m = #4620 */
    { 0x0600, 0xab35, 0x3900, RTFLOAT80U_INIT_C(0,0x3cf2ff187a45e877,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/1/2/u = #4621 */
    { 0x077f, 0xab35, 0x3900, RTFLOAT80U_INIT_C(0,0x3cf2ff187a45e877,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/1/3/m = #4622 */
    { 0x0700, 0xab35, 0x3900, RTFLOAT80U_INIT_C(0,0x3cf2ff187a45e877,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/1/3/u = #4623 */
    { 0x087f, 0xab35, 0x3900, RTFLOAT80U_INIT_C(0,0x3cf2ff187a45e877,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/2/0/m = #4624 */
    { 0x0800, 0xab35, 0x3900, RTFLOAT80U_INIT_C(0,0x3cf2ff187a45e877,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/2/0/u = #4625 */
    { 0x097f, 0xab35, 0x3900, RTFLOAT80U_INIT_C(0,0x3cf2ff187a45e877,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/2/1/m = #4626 */
    { 0x0900, 0xab35, 0x3900, RTFLOAT80U_INIT_C(0,0x3cf2ff187a45e877,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/2/1/u = #4627 */
    { 0x0a7f, 0xab35, 0x3900, RTFLOAT80U_INIT_C(0,0x3cf2ff187a45e877,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/2/2/m = #4628 */
    { 0x0a00, 0xab35, 0x3900, RTFLOAT80U_INIT_C(0,0x3cf2ff187a45e877,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/2/2/u = #4629 */
    { 0x0b7f, 0xab35, 0x3900, RTFLOAT80U_INIT_C(0,0x3cf2ff187a45e877,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/2/3/m = #4630 */
    { 0x0b00, 0xab35, 0x3900, RTFLOAT80U_INIT_C(0,0x3cf2ff187a45e877,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/2/3/u = #4631 */
    { 0x0c7f, 0xab35, 0x3900, RTFLOAT80U_INIT_C(0,0x3cf2ff187a45e877,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/3/0/m = #4632 */
    { 0x0c00, 0xab35, 0x3900, RTFLOAT80U_INIT_C(0,0x3cf2ff187a45e877,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/3/0/u = #4633 */
    { 0x0d7f, 0xab35, 0x3900, RTFLOAT80U_INIT_C(0,0x3cf2ff187a45e877,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/3/1/m = #4634 */
    { 0x0d00, 0xab35, 0x3900, RTFLOAT80U_INIT_C(0,0x3cf2ff187a45e877,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/3/1/u = #4635 */
    { 0x0e7f, 0xab35, 0x3900, RTFLOAT80U_INIT_C(0,0x3cf2ff187a45e877,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/3/2/m = #4636 */
    { 0x0e00, 0xab35, 0x3900, RTFLOAT80U_INIT_C(0,0x3cf2ff187a45e877,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/3/2/u = #4637 */
    { 0x0f7f, 0xab35, 0x3900, RTFLOAT80U_INIT_C(0,0x3cf2ff187a45e877,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/3/3/m = #4638 */
    { 0x0f00, 0xab35, 0x3900, RTFLOAT80U_INIT_C(0,0x3cf2ff187a45e877,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/3/3/u = #4639 */
    { 0x007f, 0x01f0, 0x3902, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #93/0/0/m = #4640 */
    { 0x0000, 0x01f0, 0xb182, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/0/0/u = #4641 */
    { 0x0002, 0x01f0, 0x3902, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #93/0/0/0x2 = #4642 */
    { 0x017f, 0x01f0, 0x3902, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #93/0/1/m = #4643 */
    { 0x0100, 0x01f0, 0xb182, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/0/1/u = #4644 */
    { 0x0102, 0x01f0, 0x3902, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #93/0/1/0x2 = #4645 */
    { 0x027f, 0x01f0, 0x3902, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #93/0/2/m = #4646 */
    { 0x0200, 0x01f0, 0xb182, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/0/2/u = #4647 */
    { 0x0202, 0x01f0, 0x3902, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #93/0/2/0x2 = #4648 */
    { 0x037f, 0x01f0, 0x3902, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #93/0/3/m = #4649 */
    { 0x0300, 0x01f0, 0xb182, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/0/3/u = #4650 */
    { 0x0302, 0x01f0, 0x3902, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #93/0/3/0x2 = #4651 */
    { 0x047f, 0x01f0, 0x3902, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #93/1/0/m = #4652 */
    { 0x0400, 0x01f0, 0xb182, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/1/0/u = #4653 */
    { 0x0402, 0x01f0, 0x3902, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #93/1/0/0x2 = #4654 */
    { 0x057f, 0x01f0, 0x3902, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #93/1/1/m = #4655 */
    { 0x0500, 0x01f0, 0xb182, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/1/1/u = #4656 */
    { 0x0502, 0x01f0, 0x3902, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #93/1/1/0x2 = #4657 */
    { 0x067f, 0x01f0, 0x3902, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #93/1/2/m = #4658 */
    { 0x0600, 0x01f0, 0xb182, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/1/2/u = #4659 */
    { 0x0602, 0x01f0, 0x3902, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #93/1/2/0x2 = #4660 */
    { 0x077f, 0x01f0, 0x3902, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #93/1/3/m = #4661 */
    { 0x0700, 0x01f0, 0xb182, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/1/3/u = #4662 */
    { 0x0702, 0x01f0, 0x3902, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #93/1/3/0x2 = #4663 */
    { 0x087f, 0x01f0, 0x3902, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #93/2/0/m = #4664 */
    { 0x0800, 0x01f0, 0xb182, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/2/0/u = #4665 */
    { 0x0802, 0x01f0, 0x3902, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #93/2/0/0x2 = #4666 */
    { 0x097f, 0x01f0, 0x3902, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #93/2/1/m = #4667 */
    { 0x0900, 0x01f0, 0xb182, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/2/1/u = #4668 */
    { 0x0902, 0x01f0, 0x3902, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #93/2/1/0x2 = #4669 */
    { 0x0a7f, 0x01f0, 0x3902, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #93/2/2/m = #4670 */
    { 0x0a00, 0x01f0, 0xb182, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/2/2/u = #4671 */
    { 0x0a02, 0x01f0, 0x3902, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #93/2/2/0x2 = #4672 */
    { 0x0b7f, 0x01f0, 0x3902, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #93/2/3/m = #4673 */
    { 0x0b00, 0x01f0, 0xb182, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/2/3/u = #4674 */
    { 0x0b02, 0x01f0, 0x3902, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #93/2/3/0x2 = #4675 */
    { 0x0c7f, 0x01f0, 0x3902, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #93/3/0/m = #4676 */
    { 0x0c00, 0x01f0, 0xb182, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/3/0/u = #4677 */
    { 0x0c02, 0x01f0, 0x3902, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #93/3/0/0x2 = #4678 */
    { 0x0d7f, 0x01f0, 0x3902, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #93/3/1/m = #4679 */
    { 0x0d00, 0x01f0, 0xb182, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/3/1/u = #4680 */
    { 0x0d02, 0x01f0, 0x3902, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #93/3/1/0x2 = #4681 */
    { 0x0e7f, 0x01f0, 0x3902, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #93/3/2/m = #4682 */
    { 0x0e00, 0x01f0, 0xb182, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/3/2/u = #4683 */
    { 0x0e02, 0x01f0, 0x3902, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #93/3/2/0x2 = #4684 */
    { 0x0f7f, 0x01f0, 0x3902, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #93/3/3/m = #4685 */
    { 0x0f00, 0x01f0, 0xb182, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/3/3/u = #4686 */
    { 0x0f02, 0x01f0, 0x3902, RTFLOAT80U_INIT_C(1,0x5931b12885a98e15,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_ZERO(1) }, /* #93/3/3/0x2 = #4687 */
    { 0x007f, 0x9173, 0x3901, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/0/0/m = #4688 */
    { 0x0000, 0x9173, 0xb181, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #94/0/0/u = #4689 */
    { 0x0001, 0x9173, 0x3901, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/0/0/0x1 = #4690 */
    { 0x017f, 0x9173, 0x3901, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/0/1/m = #4691 */
    { 0x0100, 0x9173, 0xb181, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #94/0/1/u = #4692 */
    { 0x0101, 0x9173, 0x3901, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/0/1/0x1 = #4693 */
    { 0x027f, 0x9173, 0x3901, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/0/2/m = #4694 */
    { 0x0200, 0x9173, 0xb181, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #94/0/2/u = #4695 */
    { 0x0201, 0x9173, 0x3901, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/0/2/0x1 = #4696 */
    { 0x037f, 0x9173, 0x3901, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/0/3/m = #4697 */
    { 0x0300, 0x9173, 0xb181, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #94/0/3/u = #4698 */
    { 0x0301, 0x9173, 0x3901, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/0/3/0x1 = #4699 */
    { 0x047f, 0x9173, 0x3901, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/1/0/m = #4700 */
    { 0x0400, 0x9173, 0xb181, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #94/1/0/u = #4701 */
    { 0x0401, 0x9173, 0x3901, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/1/0/0x1 = #4702 */
    { 0x057f, 0x9173, 0x3901, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/1/1/m = #4703 */
    { 0x0500, 0x9173, 0xb181, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #94/1/1/u = #4704 */
    { 0x0501, 0x9173, 0x3901, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/1/1/0x1 = #4705 */
    { 0x067f, 0x9173, 0x3901, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/1/2/m = #4706 */
    { 0x0600, 0x9173, 0xb181, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #94/1/2/u = #4707 */
    { 0x0601, 0x9173, 0x3901, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/1/2/0x1 = #4708 */
    { 0x077f, 0x9173, 0x3901, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/1/3/m = #4709 */
    { 0x0700, 0x9173, 0xb181, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #94/1/3/u = #4710 */
    { 0x0701, 0x9173, 0x3901, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/1/3/0x1 = #4711 */
    { 0x087f, 0x9173, 0x3901, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/2/0/m = #4712 */
    { 0x0800, 0x9173, 0xb181, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #94/2/0/u = #4713 */
    { 0x0801, 0x9173, 0x3901, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/2/0/0x1 = #4714 */
    { 0x097f, 0x9173, 0x3901, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/2/1/m = #4715 */
    { 0x0900, 0x9173, 0xb181, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #94/2/1/u = #4716 */
    { 0x0901, 0x9173, 0x3901, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/2/1/0x1 = #4717 */
    { 0x0a7f, 0x9173, 0x3901, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/2/2/m = #4718 */
    { 0x0a00, 0x9173, 0xb181, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #94/2/2/u = #4719 */
    { 0x0a01, 0x9173, 0x3901, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/2/2/0x1 = #4720 */
    { 0x0b7f, 0x9173, 0x3901, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/2/3/m = #4721 */
    { 0x0b00, 0x9173, 0xb181, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #94/2/3/u = #4722 */
    { 0x0b01, 0x9173, 0x3901, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/2/3/0x1 = #4723 */
    { 0x0c7f, 0x9173, 0x3901, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/3/0/m = #4724 */
    { 0x0c00, 0x9173, 0xb181, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #94/3/0/u = #4725 */
    { 0x0c01, 0x9173, 0x3901, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/3/0/0x1 = #4726 */
    { 0x0d7f, 0x9173, 0x3901, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/3/1/m = #4727 */
    { 0x0d00, 0x9173, 0xb181, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #94/3/1/u = #4728 */
    { 0x0d01, 0x9173, 0x3901, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/3/1/0x1 = #4729 */
    { 0x0e7f, 0x9173, 0x3901, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/3/2/m = #4730 */
    { 0x0e00, 0x9173, 0xb181, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #94/3/2/u = #4731 */
    { 0x0e01, 0x9173, 0x3901, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/3/2/0x1 = #4732 */
    { 0x0f7f, 0x9173, 0x3901, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/3/3/m = #4733 */
    { 0x0f00, 0x9173, 0xb181, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #94/3/3/u = #4734 */
    { 0x0f01, 0x9173, 0x3901, RTFLOAT80U_INIT_C(0,0x5213cd55873eee4e,0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/3/3/0x1 = #4735 */
    { 0x007f, 0xa43e, 0x3e22, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #95/0/0/m = #4736 */
    { 0x0000, 0xa43e, 0xb482, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #95/0/0/u = #4737 */
    { 0x0022, 0xa43e, 0x3e22, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #95/0/0/0x22 = #4738 */
    { 0x0020, 0xa43e, 0xb482, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #95/0/0/u0x2 = #4739 */
    { 0x0002, 0xa43e, 0xbea2, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #95/0/0/u0x20 = #4740 */
    { 0x017f, 0xa43e, 0x3e22, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #95/0/1/m = #4741 */
    { 0x0100, 0xa43e, 0xb482, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #95/0/1/u = #4742 */
    { 0x0122, 0xa43e, 0x3e22, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #95/0/1/0x22 = #4743 */
    { 0x0120, 0xa43e, 0xb482, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #95/0/1/u0x2 = #4744 */
    { 0x0102, 0xa43e, 0xbea2, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #95/0/1/u0x20 = #4745 */
    { 0x027f, 0xa43e, 0x3e22, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #95/0/2/m = #4746 */
    { 0x0200, 0xa43e, 0xb482, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #95/0/2/u = #4747 */
    { 0x0222, 0xa43e, 0x3e22, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #95/0/2/0x22 = #4748 */
    { 0x0220, 0xa43e, 0xb482, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #95/0/2/u0x2 = #4749 */
    { 0x0202, 0xa43e, 0xbea2, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #95/0/2/u0x20 = #4750 */
    { 0x037f, 0xa43e, 0x3e22, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #95/0/3/m = #4751 */
    { 0x0300, 0xa43e, 0xb482, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #95/0/3/u = #4752 */
    { 0x0322, 0xa43e, 0x3e22, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #95/0/3/0x22 = #4753 */
    { 0x0320, 0xa43e, 0xb482, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #95/0/3/u0x2 = #4754 */
    { 0x0302, 0xa43e, 0xbea2, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #95/0/3/u0x20 = #4755 */
    { 0x047f, 0xa43e, 0x3c22, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #95/1/0/m = #4756 */
    { 0x0400, 0xa43e, 0xb482, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #95/1/0/u = #4757 */
    { 0x0422, 0xa43e, 0x3c22, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #95/1/0/0x22 = #4758 */
    { 0x0420, 0xa43e, 0xb482, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #95/1/0/u0x2 = #4759 */
    { 0x0402, 0xa43e, 0xbca2, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #95/1/0/u0x20 = #4760 */
    { 0x057f, 0xa43e, 0x3c22, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #95/1/1/m = #4761 */
    { 0x0500, 0xa43e, 0xb482, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #95/1/1/u = #4762 */
    { 0x0522, 0xa43e, 0x3c22, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #95/1/1/0x22 = #4763 */
    { 0x0520, 0xa43e, 0xb482, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #95/1/1/u0x2 = #4764 */
    { 0x0502, 0xa43e, 0xbca2, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #95/1/1/u0x20 = #4765 */
    { 0x067f, 0xa43e, 0x3c22, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #95/1/2/m = #4766 */
    { 0x0600, 0xa43e, 0xb482, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #95/1/2/u = #4767 */
    { 0x0622, 0xa43e, 0x3c22, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #95/1/2/0x22 = #4768 */
    { 0x0620, 0xa43e, 0xb482, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #95/1/2/u0x2 = #4769 */
    { 0x0602, 0xa43e, 0xbca2, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #95/1/2/u0x20 = #4770 */
    { 0x077f, 0xa43e, 0x3c22, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #95/1/3/m = #4771 */
    { 0x0700, 0xa43e, 0xb482, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #95/1/3/u = #4772 */
    { 0x0722, 0xa43e, 0x3c22, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #95/1/3/0x22 = #4773 */
    { 0x0720, 0xa43e, 0xb482, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #95/1/3/u0x2 = #4774 */
    { 0x0702, 0xa43e, 0xbca2, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #95/1/3/u0x20 = #4775 */
    { 0x087f, 0xa43e, 0x3e22, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #95/2/0/m = #4776 */
    { 0x0800, 0xa43e, 0xb482, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #95/2/0/u = #4777 */
    { 0x0822, 0xa43e, 0x3e22, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #95/2/0/0x22 = #4778 */
    { 0x0820, 0xa43e, 0xb482, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #95/2/0/u0x2 = #4779 */
    { 0x0802, 0xa43e, 0xbea2, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #95/2/0/u0x20 = #4780 */
    { 0x097f, 0xa43e, 0x3e22, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #95/2/1/m = #4781 */
    { 0x0900, 0xa43e, 0xb482, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #95/2/1/u = #4782 */
    { 0x0922, 0xa43e, 0x3e22, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #95/2/1/0x22 = #4783 */
    { 0x0920, 0xa43e, 0xb482, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #95/2/1/u0x2 = #4784 */
    { 0x0902, 0xa43e, 0xbea2, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #95/2/1/u0x20 = #4785 */
    { 0x0a7f, 0xa43e, 0x3e22, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #95/2/2/m = #4786 */
    { 0x0a00, 0xa43e, 0xb482, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #95/2/2/u = #4787 */
    { 0x0a22, 0xa43e, 0x3e22, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #95/2/2/0x22 = #4788 */
    { 0x0a20, 0xa43e, 0xb482, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #95/2/2/u0x2 = #4789 */
    { 0x0a02, 0xa43e, 0xbea2, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #95/2/2/u0x20 = #4790 */
    { 0x0b7f, 0xa43e, 0x3e22, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #95/2/3/m = #4791 */
    { 0x0b00, 0xa43e, 0xb482, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #95/2/3/u = #4792 */
    { 0x0b22, 0xa43e, 0x3e22, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #95/2/3/0x22 = #4793 */
    { 0x0b20, 0xa43e, 0xb482, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #95/2/3/u0x2 = #4794 */
    { 0x0b02, 0xa43e, 0xbea2, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #95/2/3/u0x20 = #4795 */
    { 0x0c7f, 0xa43e, 0x3c22, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #95/3/0/m = #4796 */
    { 0x0c00, 0xa43e, 0xb482, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #95/3/0/u = #4797 */
    { 0x0c22, 0xa43e, 0x3c22, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #95/3/0/0x22 = #4798 */
    { 0x0c20, 0xa43e, 0xb482, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #95/3/0/u0x2 = #4799 */
    { 0x0c02, 0xa43e, 0xbca2, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #95/3/0/u0x20 = #4800 */
    { 0x0d7f, 0xa43e, 0x3c22, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #95/3/1/m = #4801 */
    { 0x0d00, 0xa43e, 0xb482, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #95/3/1/u = #4802 */
    { 0x0d22, 0xa43e, 0x3c22, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #95/3/1/0x22 = #4803 */
    { 0x0d20, 0xa43e, 0xb482, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #95/3/1/u0x2 = #4804 */
    { 0x0d02, 0xa43e, 0xbca2, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #95/3/1/u0x20 = #4805 */
    { 0x0e7f, 0xa43e, 0x3c22, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #95/3/2/m = #4806 */
    { 0x0e00, 0xa43e, 0xb482, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #95/3/2/u = #4807 */
    { 0x0e22, 0xa43e, 0x3c22, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #95/3/2/0x22 = #4808 */
    { 0x0e20, 0xa43e, 0xb482, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #95/3/2/u0x2 = #4809 */
    { 0x0e02, 0xa43e, 0xbca2, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #95/3/2/u0x20 = #4810 */
    { 0x0f7f, 0xa43e, 0x3c22, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #95/3/3/m = #4811 */
    { 0x0f00, 0xa43e, 0xb482, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #95/3/3/u = #4812 */
    { 0x0f22, 0xa43e, 0x3c22, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #95/3/3/0x22 = #4813 */
    { 0x0f20, 0xa43e, 0xb482, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #95/3/3/u0x2 = #4814 */
    { 0x0f02, 0xa43e, 0xbca2, RTFLOAT80U_INIT_C(0,0x1dbcc6558c7eaff3,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #95/3/3/u0x20 = #4815 */
    { 0x007f, 0x857d, 0x3d00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xab600d7d7b03750a,22252), RTFLOAT80U_INIT_IND(0) }, /* #96/0/0/m = #4816 */
    { 0x0000, 0x857d, 0x3d00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xab600d7d7b03750a,22252), RTFLOAT80U_INIT_IND(0) }, /* #96/0/0/u = #4817 */
    { 0x017f, 0x857d, 0x3d00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xab600d7d7b03750a,22252), RTFLOAT80U_INIT_IND(0) }, /* #96/0/1/m = #4818 */
    { 0x0100, 0x857d, 0x3d00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xab600d7d7b03750a,22252), RTFLOAT80U_INIT_IND(0) }, /* #96/0/1/u = #4819 */
    { 0x027f, 0x857d, 0x3d00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xab600d7d7b03750a,22252), RTFLOAT80U_INIT_IND(0) }, /* #96/0/2/m = #4820 */
    { 0x0200, 0x857d, 0x3d00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xab600d7d7b03750a,22252), RTFLOAT80U_INIT_IND(0) }, /* #96/0/2/u = #4821 */
    { 0x037f, 0x857d, 0x3d00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xab600d7d7b03750a,22252), RTFLOAT80U_INIT_IND(0) }, /* #96/0/3/m = #4822 */
    { 0x0300, 0x857d, 0x3d00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xab600d7d7b03750a,22252), RTFLOAT80U_INIT_IND(0) }, /* #96/0/3/u = #4823 */
    { 0x047f, 0x857d, 0x3d00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xab600d7d7b03750a,22252), RTFLOAT80U_INIT_IND(0) }, /* #96/1/0/m = #4824 */
    { 0x0400, 0x857d, 0x3d00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xab600d7d7b03750a,22252), RTFLOAT80U_INIT_IND(0) }, /* #96/1/0/u = #4825 */
    { 0x057f, 0x857d, 0x3d00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xab600d7d7b03750a,22252), RTFLOAT80U_INIT_IND(0) }, /* #96/1/1/m = #4826 */
    { 0x0500, 0x857d, 0x3d00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xab600d7d7b03750a,22252), RTFLOAT80U_INIT_IND(0) }, /* #96/1/1/u = #4827 */
    { 0x067f, 0x857d, 0x3d00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xab600d7d7b03750a,22252), RTFLOAT80U_INIT_IND(0) }, /* #96/1/2/m = #4828 */
    { 0x0600, 0x857d, 0x3d00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xab600d7d7b03750a,22252), RTFLOAT80U_INIT_IND(0) }, /* #96/1/2/u = #4829 */
    { 0x077f, 0x857d, 0x3d00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xab600d7d7b03750a,22252), RTFLOAT80U_INIT_IND(0) }, /* #96/1/3/m = #4830 */
    { 0x0700, 0x857d, 0x3d00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xab600d7d7b03750a,22252), RTFLOAT80U_INIT_IND(0) }, /* #96/1/3/u = #4831 */
    { 0x087f, 0x857d, 0x3d00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xab600d7d7b03750a,22252), RTFLOAT80U_INIT_IND(0) }, /* #96/2/0/m = #4832 */
    { 0x0800, 0x857d, 0x3d00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xab600d7d7b03750a,22252), RTFLOAT80U_INIT_IND(0) }, /* #96/2/0/u = #4833 */
    { 0x097f, 0x857d, 0x3d00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xab600d7d7b03750a,22252), RTFLOAT80U_INIT_IND(0) }, /* #96/2/1/m = #4834 */
    { 0x0900, 0x857d, 0x3d00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xab600d7d7b03750a,22252), RTFLOAT80U_INIT_IND(0) }, /* #96/2/1/u = #4835 */
    { 0x0a7f, 0x857d, 0x3d00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xab600d7d7b03750a,22252), RTFLOAT80U_INIT_IND(0) }, /* #96/2/2/m = #4836 */
    { 0x0a00, 0x857d, 0x3d00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xab600d7d7b03750a,22252), RTFLOAT80U_INIT_IND(0) }, /* #96/2/2/u = #4837 */
    { 0x0b7f, 0x857d, 0x3d00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xab600d7d7b03750a,22252), RTFLOAT80U_INIT_IND(0) }, /* #96/2/3/m = #4838 */
    { 0x0b00, 0x857d, 0x3d00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xab600d7d7b03750a,22252), RTFLOAT80U_INIT_IND(0) }, /* #96/2/3/u = #4839 */
    { 0x0c7f, 0x857d, 0x3d00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xab600d7d7b03750a,22252), RTFLOAT80U_INIT_IND(0) }, /* #96/3/0/m = #4840 */
    { 0x0c00, 0x857d, 0x3d00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xab600d7d7b03750a,22252), RTFLOAT80U_INIT_IND(0) }, /* #96/3/0/u = #4841 */
    { 0x0d7f, 0x857d, 0x3d00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xab600d7d7b03750a,22252), RTFLOAT80U_INIT_IND(0) }, /* #96/3/1/m = #4842 */
    { 0x0d00, 0x857d, 0x3d00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xab600d7d7b03750a,22252), RTFLOAT80U_INIT_IND(0) }, /* #96/3/1/u = #4843 */
    { 0x0e7f, 0x857d, 0x3d00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xab600d7d7b03750a,22252), RTFLOAT80U_INIT_IND(0) }, /* #96/3/2/m = #4844 */
    { 0x0e00, 0x857d, 0x3d00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xab600d7d7b03750a,22252), RTFLOAT80U_INIT_IND(0) }, /* #96/3/2/u = #4845 */
    { 0x0f7f, 0x857d, 0x3d00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xab600d7d7b03750a,22252), RTFLOAT80U_INIT_IND(0) }, /* #96/3/3/m = #4846 */
    { 0x0f00, 0x857d, 0x3d00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xab600d7d7b03750a,22252), RTFLOAT80U_INIT_IND(0) }, /* #96/3/3/u = #4847 */
    { 0x007f, 0x9659, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(0) }, /* #97/0/0/m = #4848 */
    { 0x0000, 0x9659, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(0) }, /* #97/0/0/u = #4849 */
    { 0x017f, 0x9659, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(0) }, /* #97/0/1/m = #4850 */
    { 0x0100, 0x9659, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(0) }, /* #97/0/1/u = #4851 */
    { 0x027f, 0x9659, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(0) }, /* #97/0/2/m = #4852 */
    { 0x0200, 0x9659, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(0) }, /* #97/0/2/u = #4853 */
    { 0x037f, 0x9659, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(0) }, /* #97/0/3/m = #4854 */
    { 0x0300, 0x9659, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(0) }, /* #97/0/3/u = #4855 */
    { 0x047f, 0x9659, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(0) }, /* #97/1/0/m = #4856 */
    { 0x0400, 0x9659, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(0) }, /* #97/1/0/u = #4857 */
    { 0x057f, 0x9659, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(0) }, /* #97/1/1/m = #4858 */
    { 0x0500, 0x9659, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(0) }, /* #97/1/1/u = #4859 */
    { 0x067f, 0x9659, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(0) }, /* #97/1/2/m = #4860 */
    { 0x0600, 0x9659, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(0) }, /* #97/1/2/u = #4861 */
    { 0x077f, 0x9659, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(0) }, /* #97/1/3/m = #4862 */
    { 0x0700, 0x9659, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(0) }, /* #97/1/3/u = #4863 */
    { 0x087f, 0x9659, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(0) }, /* #97/2/0/m = #4864 */
    { 0x0800, 0x9659, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(0) }, /* #97/2/0/u = #4865 */
    { 0x097f, 0x9659, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(0) }, /* #97/2/1/m = #4866 */
    { 0x0900, 0x9659, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(0) }, /* #97/2/1/u = #4867 */
    { 0x0a7f, 0x9659, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(0) }, /* #97/2/2/m = #4868 */
    { 0x0a00, 0x9659, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(0) }, /* #97/2/2/u = #4869 */
    { 0x0b7f, 0x9659, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(0) }, /* #97/2/3/m = #4870 */
    { 0x0b00, 0x9659, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(0) }, /* #97/2/3/u = #4871 */
    { 0x0c7f, 0x9659, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(0) }, /* #97/3/0/m = #4872 */
    { 0x0c00, 0x9659, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(0) }, /* #97/3/0/u = #4873 */
    { 0x0d7f, 0x9659, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(0) }, /* #97/3/1/m = #4874 */
    { 0x0d00, 0x9659, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(0) }, /* #97/3/1/u = #4875 */
    { 0x0e7f, 0x9659, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(0) }, /* #97/3/2/m = #4876 */
    { 0x0e00, 0x9659, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(0) }, /* #97/3/2/u = #4877 */
    { 0x0f7f, 0x9659, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(0) }, /* #97/3/3/m = #4878 */
    { 0x0f00, 0x9659, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(0) }, /* #97/3/3/u = #4879 */
    { 0x007f, 0x6960, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_IND(1) }, /* #98/0/0/m = #4880 */
    { 0x0000, 0x6960, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340) }, /* #98/0/0/u = #4881 */
    { 0x0001, 0x6960, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_IND(1) }, /* #98/0/0/0x1 = #4882 */
    { 0x017f, 0x6960, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_IND(1) }, /* #98/0/1/m = #4883 */
    { 0x0100, 0x6960, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340) }, /* #98/0/1/u = #4884 */
    { 0x0101, 0x6960, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_IND(1) }, /* #98/0/1/0x1 = #4885 */
    { 0x027f, 0x6960, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_IND(1) }, /* #98/0/2/m = #4886 */
    { 0x0200, 0x6960, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340) }, /* #98/0/2/u = #4887 */
    { 0x0201, 0x6960, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_IND(1) }, /* #98/0/2/0x1 = #4888 */
    { 0x037f, 0x6960, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_IND(1) }, /* #98/0/3/m = #4889 */
    { 0x0300, 0x6960, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340) }, /* #98/0/3/u = #4890 */
    { 0x0301, 0x6960, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_IND(1) }, /* #98/0/3/0x1 = #4891 */
    { 0x047f, 0x6960, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_IND(1) }, /* #98/1/0/m = #4892 */
    { 0x0400, 0x6960, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340) }, /* #98/1/0/u = #4893 */
    { 0x0401, 0x6960, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_IND(1) }, /* #98/1/0/0x1 = #4894 */
    { 0x057f, 0x6960, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_IND(1) }, /* #98/1/1/m = #4895 */
    { 0x0500, 0x6960, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340) }, /* #98/1/1/u = #4896 */
    { 0x0501, 0x6960, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_IND(1) }, /* #98/1/1/0x1 = #4897 */
    { 0x067f, 0x6960, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_IND(1) }, /* #98/1/2/m = #4898 */
    { 0x0600, 0x6960, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340) }, /* #98/1/2/u = #4899 */
    { 0x0601, 0x6960, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_IND(1) }, /* #98/1/2/0x1 = #4900 */
    { 0x077f, 0x6960, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_IND(1) }, /* #98/1/3/m = #4901 */
    { 0x0700, 0x6960, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340) }, /* #98/1/3/u = #4902 */
    { 0x0701, 0x6960, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_IND(1) }, /* #98/1/3/0x1 = #4903 */
    { 0x087f, 0x6960, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_IND(1) }, /* #98/2/0/m = #4904 */
    { 0x0800, 0x6960, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340) }, /* #98/2/0/u = #4905 */
    { 0x0801, 0x6960, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_IND(1) }, /* #98/2/0/0x1 = #4906 */
    { 0x097f, 0x6960, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_IND(1) }, /* #98/2/1/m = #4907 */
    { 0x0900, 0x6960, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340) }, /* #98/2/1/u = #4908 */
    { 0x0901, 0x6960, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_IND(1) }, /* #98/2/1/0x1 = #4909 */
    { 0x0a7f, 0x6960, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_IND(1) }, /* #98/2/2/m = #4910 */
    { 0x0a00, 0x6960, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340) }, /* #98/2/2/u = #4911 */
    { 0x0a01, 0x6960, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_IND(1) }, /* #98/2/2/0x1 = #4912 */
    { 0x0b7f, 0x6960, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_IND(1) }, /* #98/2/3/m = #4913 */
    { 0x0b00, 0x6960, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340) }, /* #98/2/3/u = #4914 */
    { 0x0b01, 0x6960, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_IND(1) }, /* #98/2/3/0x1 = #4915 */
    { 0x0c7f, 0x6960, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_IND(1) }, /* #98/3/0/m = #4916 */
    { 0x0c00, 0x6960, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340) }, /* #98/3/0/u = #4917 */
    { 0x0c01, 0x6960, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_IND(1) }, /* #98/3/0/0x1 = #4918 */
    { 0x0d7f, 0x6960, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_IND(1) }, /* #98/3/1/m = #4919 */
    { 0x0d00, 0x6960, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340) }, /* #98/3/1/u = #4920 */
    { 0x0d01, 0x6960, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_IND(1) }, /* #98/3/1/0x1 = #4921 */
    { 0x0e7f, 0x6960, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_IND(1) }, /* #98/3/2/m = #4922 */
    { 0x0e00, 0x6960, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340) }, /* #98/3/2/u = #4923 */
    { 0x0e01, 0x6960, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_IND(1) }, /* #98/3/2/0x1 = #4924 */
    { 0x0f7f, 0x6960, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_IND(1) }, /* #98/3/3/m = #4925 */
    { 0x0f00, 0x6960, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340) }, /* #98/3/3/u = #4926 */
    { 0x0f01, 0x6960, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x27ae02b94ffdb070,32340), RTFLOAT80U_INIT_IND(1) }, /* #98/3/3/0x1 = #4927 */
    { 0x007f, 0xc343, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_IND(1) }, /* #99/0/0/m = #4928 */
    { 0x0000, 0xc343, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767) }, /* #99/0/0/u = #4929 */
    { 0x0001, 0xc343, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_IND(1) }, /* #99/0/0/0x1 = #4930 */
    { 0x017f, 0xc343, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_IND(1) }, /* #99/0/1/m = #4931 */
    { 0x0100, 0xc343, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767) }, /* #99/0/1/u = #4932 */
    { 0x0101, 0xc343, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_IND(1) }, /* #99/0/1/0x1 = #4933 */
    { 0x027f, 0xc343, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_IND(1) }, /* #99/0/2/m = #4934 */
    { 0x0200, 0xc343, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767) }, /* #99/0/2/u = #4935 */
    { 0x0201, 0xc343, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_IND(1) }, /* #99/0/2/0x1 = #4936 */
    { 0x037f, 0xc343, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_IND(1) }, /* #99/0/3/m = #4937 */
    { 0x0300, 0xc343, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767) }, /* #99/0/3/u = #4938 */
    { 0x0301, 0xc343, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_IND(1) }, /* #99/0/3/0x1 = #4939 */
    { 0x047f, 0xc343, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_IND(1) }, /* #99/1/0/m = #4940 */
    { 0x0400, 0xc343, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767) }, /* #99/1/0/u = #4941 */
    { 0x0401, 0xc343, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_IND(1) }, /* #99/1/0/0x1 = #4942 */
    { 0x057f, 0xc343, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_IND(1) }, /* #99/1/1/m = #4943 */
    { 0x0500, 0xc343, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767) }, /* #99/1/1/u = #4944 */
    { 0x0501, 0xc343, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_IND(1) }, /* #99/1/1/0x1 = #4945 */
    { 0x067f, 0xc343, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_IND(1) }, /* #99/1/2/m = #4946 */
    { 0x0600, 0xc343, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767) }, /* #99/1/2/u = #4947 */
    { 0x0601, 0xc343, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_IND(1) }, /* #99/1/2/0x1 = #4948 */
    { 0x077f, 0xc343, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_IND(1) }, /* #99/1/3/m = #4949 */
    { 0x0700, 0xc343, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767) }, /* #99/1/3/u = #4950 */
    { 0x0701, 0xc343, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_IND(1) }, /* #99/1/3/0x1 = #4951 */
    { 0x087f, 0xc343, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_IND(1) }, /* #99/2/0/m = #4952 */
    { 0x0800, 0xc343, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767) }, /* #99/2/0/u = #4953 */
    { 0x0801, 0xc343, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_IND(1) }, /* #99/2/0/0x1 = #4954 */
    { 0x097f, 0xc343, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_IND(1) }, /* #99/2/1/m = #4955 */
    { 0x0900, 0xc343, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767) }, /* #99/2/1/u = #4956 */
    { 0x0901, 0xc343, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_IND(1) }, /* #99/2/1/0x1 = #4957 */
    { 0x0a7f, 0xc343, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_IND(1) }, /* #99/2/2/m = #4958 */
    { 0x0a00, 0xc343, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767) }, /* #99/2/2/u = #4959 */
    { 0x0a01, 0xc343, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_IND(1) }, /* #99/2/2/0x1 = #4960 */
    { 0x0b7f, 0xc343, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_IND(1) }, /* #99/2/3/m = #4961 */
    { 0x0b00, 0xc343, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767) }, /* #99/2/3/u = #4962 */
    { 0x0b01, 0xc343, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_IND(1) }, /* #99/2/3/0x1 = #4963 */
    { 0x0c7f, 0xc343, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_IND(1) }, /* #99/3/0/m = #4964 */
    { 0x0c00, 0xc343, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767) }, /* #99/3/0/u = #4965 */
    { 0x0c01, 0xc343, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_IND(1) }, /* #99/3/0/0x1 = #4966 */
    { 0x0d7f, 0xc343, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_IND(1) }, /* #99/3/1/m = #4967 */
    { 0x0d00, 0xc343, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767) }, /* #99/3/1/u = #4968 */
    { 0x0d01, 0xc343, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_IND(1) }, /* #99/3/1/0x1 = #4969 */
    { 0x0e7f, 0xc343, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_IND(1) }, /* #99/3/2/m = #4970 */
    { 0x0e00, 0xc343, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767) }, /* #99/3/2/u = #4971 */
    { 0x0e01, 0xc343, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_IND(1) }, /* #99/3/2/0x1 = #4972 */
    { 0x0f7f, 0xc343, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_IND(1) }, /* #99/3/3/m = #4973 */
    { 0x0f00, 0xc343, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767) }, /* #99/3/3/u = #4974 */
    { 0x0f01, 0xc343, 0x7901, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xbe48ba04d79971b7,32767), RTFLOAT80U_INIT_IND(1) }, /* #99/3/3/0x1 = #4975 */
    { 0x007f, 0x1617, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767) }, /* #100/0/0/m = #4976 */
    { 0x0000, 0x1617, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767) }, /* #100/0/0/u = #4977 */
    { 0x017f, 0x1617, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767) }, /* #100/0/1/m = #4978 */
    { 0x0100, 0x1617, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767) }, /* #100/0/1/u = #4979 */
    { 0x027f, 0x1617, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767) }, /* #100/0/2/m = #4980 */
    { 0x0200, 0x1617, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767) }, /* #100/0/2/u = #4981 */
    { 0x037f, 0x1617, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767) }, /* #100/0/3/m = #4982 */
    { 0x0300, 0x1617, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767) }, /* #100/0/3/u = #4983 */
    { 0x047f, 0x1617, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767) }, /* #100/1/0/m = #4984 */
    { 0x0400, 0x1617, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767) }, /* #100/1/0/u = #4985 */
    { 0x057f, 0x1617, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767) }, /* #100/1/1/m = #4986 */
    { 0x0500, 0x1617, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767) }, /* #100/1/1/u = #4987 */
    { 0x067f, 0x1617, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767) }, /* #100/1/2/m = #4988 */
    { 0x0600, 0x1617, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767) }, /* #100/1/2/u = #4989 */
    { 0x077f, 0x1617, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767) }, /* #100/1/3/m = #4990 */
    { 0x0700, 0x1617, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767) }, /* #100/1/3/u = #4991 */
    { 0x087f, 0x1617, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767) }, /* #100/2/0/m = #4992 */
    { 0x0800, 0x1617, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767) }, /* #100/2/0/u = #4993 */
    { 0x097f, 0x1617, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767) }, /* #100/2/1/m = #4994 */
    { 0x0900, 0x1617, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767) }, /* #100/2/1/u = #4995 */
    { 0x0a7f, 0x1617, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767) }, /* #100/2/2/m = #4996 */
    { 0x0a00, 0x1617, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767) }, /* #100/2/2/u = #4997 */
    { 0x0b7f, 0x1617, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767) }, /* #100/2/3/m = #4998 */
    { 0x0b00, 0x1617, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767) }, /* #100/2/3/u = #4999 */
    { 0x0c7f, 0x1617, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767) }, /* #100/3/0/m = #5000 */
    { 0x0c00, 0x1617, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767) }, /* #100/3/0/u = #5001 */
    { 0x0d7f, 0x1617, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767) }, /* #100/3/1/m = #5002 */
    { 0x0d00, 0x1617, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767) }, /* #100/3/1/u = #5003 */
    { 0x0e7f, 0x1617, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767) }, /* #100/3/2/m = #5004 */
    { 0x0e00, 0x1617, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767) }, /* #100/3/2/u = #5005 */
    { 0x0f7f, 0x1617, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767) }, /* #100/3/3/m = #5006 */
    { 0x0f00, 0x1617, 0x3c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767), RTFLOAT80U_INIT_C(1,0xca4bf6ca41a982d5,32767) }, /* #100/3/3/u = #5007 */
    { 0x007f, 0x57c7, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/0/0/m = #5008 */
    { 0x0000, 0x57c7, 0xf581, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767) }, /* #101/0/0/u = #5009 */
    { 0x0001, 0x57c7, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/0/0/0x1 = #5010 */
    { 0x017f, 0x57c7, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/0/1/m = #5011 */
    { 0x0100, 0x57c7, 0xf581, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767) }, /* #101/0/1/u = #5012 */
    { 0x0101, 0x57c7, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/0/1/0x1 = #5013 */
    { 0x027f, 0x57c7, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/0/2/m = #5014 */
    { 0x0200, 0x57c7, 0xf581, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767) }, /* #101/0/2/u = #5015 */
    { 0x0201, 0x57c7, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/0/2/0x1 = #5016 */
    { 0x037f, 0x57c7, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/0/3/m = #5017 */
    { 0x0300, 0x57c7, 0xf581, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767) }, /* #101/0/3/u = #5018 */
    { 0x0301, 0x57c7, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/0/3/0x1 = #5019 */
    { 0x047f, 0x57c7, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/1/0/m = #5020 */
    { 0x0400, 0x57c7, 0xf581, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767) }, /* #101/1/0/u = #5021 */
    { 0x0401, 0x57c7, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/1/0/0x1 = #5022 */
    { 0x057f, 0x57c7, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/1/1/m = #5023 */
    { 0x0500, 0x57c7, 0xf581, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767) }, /* #101/1/1/u = #5024 */
    { 0x0501, 0x57c7, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/1/1/0x1 = #5025 */
    { 0x067f, 0x57c7, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/1/2/m = #5026 */
    { 0x0600, 0x57c7, 0xf581, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767) }, /* #101/1/2/u = #5027 */
    { 0x0601, 0x57c7, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/1/2/0x1 = #5028 */
    { 0x077f, 0x57c7, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/1/3/m = #5029 */
    { 0x0700, 0x57c7, 0xf581, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767) }, /* #101/1/3/u = #5030 */
    { 0x0701, 0x57c7, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/1/3/0x1 = #5031 */
    { 0x087f, 0x57c7, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/2/0/m = #5032 */
    { 0x0800, 0x57c7, 0xf581, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767) }, /* #101/2/0/u = #5033 */
    { 0x0801, 0x57c7, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/2/0/0x1 = #5034 */
    { 0x097f, 0x57c7, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/2/1/m = #5035 */
    { 0x0900, 0x57c7, 0xf581, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767) }, /* #101/2/1/u = #5036 */
    { 0x0901, 0x57c7, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/2/1/0x1 = #5037 */
    { 0x0a7f, 0x57c7, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/2/2/m = #5038 */
    { 0x0a00, 0x57c7, 0xf581, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767) }, /* #101/2/2/u = #5039 */
    { 0x0a01, 0x57c7, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/2/2/0x1 = #5040 */
    { 0x0b7f, 0x57c7, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/2/3/m = #5041 */
    { 0x0b00, 0x57c7, 0xf581, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767) }, /* #101/2/3/u = #5042 */
    { 0x0b01, 0x57c7, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/2/3/0x1 = #5043 */
    { 0x0c7f, 0x57c7, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/3/0/m = #5044 */
    { 0x0c00, 0x57c7, 0xf581, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767) }, /* #101/3/0/u = #5045 */
    { 0x0c01, 0x57c7, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/3/0/0x1 = #5046 */
    { 0x0d7f, 0x57c7, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/3/1/m = #5047 */
    { 0x0d00, 0x57c7, 0xf581, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767) }, /* #101/3/1/u = #5048 */
    { 0x0d01, 0x57c7, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/3/1/0x1 = #5049 */
    { 0x0e7f, 0x57c7, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/3/2/m = #5050 */
    { 0x0e00, 0x57c7, 0xf581, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767) }, /* #101/3/2/u = #5051 */
    { 0x0e01, 0x57c7, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/3/2/0x1 = #5052 */
    { 0x0f7f, 0x57c7, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/3/3/m = #5053 */
    { 0x0f00, 0x57c7, 0xf581, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767) }, /* #101/3/3/u = #5054 */
    { 0x0f01, 0x57c7, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x103ce75b88b8ac83,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/3/3/0x1 = #5055 */
    { 0x007f, 0x8edf, 0x3c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xd67dd84bed8b6f10,0), RTFLOAT80U_INIT_IND(1) }, /* #102/0/0/m = #5056 */
    { 0x0000, 0x8edf, 0x3c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xd67dd84bed8b6f10,0), RTFLOAT80U_INIT_IND(1) }, /* #102/0/0/u = #5057 */
    { 0x017f, 0x8edf, 0x3c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xd67dd84bed8b6f10,0), RTFLOAT80U_INIT_IND(1) }, /* #102/0/1/m = #5058 */
    { 0x0100, 0x8edf, 0x3c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xd67dd84bed8b6f10,0), RTFLOAT80U_INIT_IND(1) }, /* #102/0/1/u = #5059 */
    { 0x027f, 0x8edf, 0x3c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xd67dd84bed8b6f10,0), RTFLOAT80U_INIT_IND(1) }, /* #102/0/2/m = #5060 */
    { 0x0200, 0x8edf, 0x3c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xd67dd84bed8b6f10,0), RTFLOAT80U_INIT_IND(1) }, /* #102/0/2/u = #5061 */
    { 0x037f, 0x8edf, 0x3c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xd67dd84bed8b6f10,0), RTFLOAT80U_INIT_IND(1) }, /* #102/0/3/m = #5062 */
    { 0x0300, 0x8edf, 0x3c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xd67dd84bed8b6f10,0), RTFLOAT80U_INIT_IND(1) }, /* #102/0/3/u = #5063 */
    { 0x047f, 0x8edf, 0x3c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xd67dd84bed8b6f10,0), RTFLOAT80U_INIT_IND(1) }, /* #102/1/0/m = #5064 */
    { 0x0400, 0x8edf, 0x3c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xd67dd84bed8b6f10,0), RTFLOAT80U_INIT_IND(1) }, /* #102/1/0/u = #5065 */
    { 0x057f, 0x8edf, 0x3c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xd67dd84bed8b6f10,0), RTFLOAT80U_INIT_IND(1) }, /* #102/1/1/m = #5066 */
    { 0x0500, 0x8edf, 0x3c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xd67dd84bed8b6f10,0), RTFLOAT80U_INIT_IND(1) }, /* #102/1/1/u = #5067 */
    { 0x067f, 0x8edf, 0x3c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xd67dd84bed8b6f10,0), RTFLOAT80U_INIT_IND(1) }, /* #102/1/2/m = #5068 */
    { 0x0600, 0x8edf, 0x3c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xd67dd84bed8b6f10,0), RTFLOAT80U_INIT_IND(1) }, /* #102/1/2/u = #5069 */
    { 0x077f, 0x8edf, 0x3c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xd67dd84bed8b6f10,0), RTFLOAT80U_INIT_IND(1) }, /* #102/1/3/m = #5070 */
    { 0x0700, 0x8edf, 0x3c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xd67dd84bed8b6f10,0), RTFLOAT80U_INIT_IND(1) }, /* #102/1/3/u = #5071 */
    { 0x087f, 0x8edf, 0x3c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xd67dd84bed8b6f10,0), RTFLOAT80U_INIT_IND(1) }, /* #102/2/0/m = #5072 */
    { 0x0800, 0x8edf, 0x3c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xd67dd84bed8b6f10,0), RTFLOAT80U_INIT_IND(1) }, /* #102/2/0/u = #5073 */
    { 0x097f, 0x8edf, 0x3c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xd67dd84bed8b6f10,0), RTFLOAT80U_INIT_IND(1) }, /* #102/2/1/m = #5074 */
    { 0x0900, 0x8edf, 0x3c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xd67dd84bed8b6f10,0), RTFLOAT80U_INIT_IND(1) }, /* #102/2/1/u = #5075 */
    { 0x0a7f, 0x8edf, 0x3c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xd67dd84bed8b6f10,0), RTFLOAT80U_INIT_IND(1) }, /* #102/2/2/m = #5076 */
    { 0x0a00, 0x8edf, 0x3c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xd67dd84bed8b6f10,0), RTFLOAT80U_INIT_IND(1) }, /* #102/2/2/u = #5077 */
    { 0x0b7f, 0x8edf, 0x3c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xd67dd84bed8b6f10,0), RTFLOAT80U_INIT_IND(1) }, /* #102/2/3/m = #5078 */
    { 0x0b00, 0x8edf, 0x3c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xd67dd84bed8b6f10,0), RTFLOAT80U_INIT_IND(1) }, /* #102/2/3/u = #5079 */
    { 0x0c7f, 0x8edf, 0x3c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xd67dd84bed8b6f10,0), RTFLOAT80U_INIT_IND(1) }, /* #102/3/0/m = #5080 */
    { 0x0c00, 0x8edf, 0x3c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xd67dd84bed8b6f10,0), RTFLOAT80U_INIT_IND(1) }, /* #102/3/0/u = #5081 */
    { 0x0d7f, 0x8edf, 0x3c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xd67dd84bed8b6f10,0), RTFLOAT80U_INIT_IND(1) }, /* #102/3/1/m = #5082 */
    { 0x0d00, 0x8edf, 0x3c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xd67dd84bed8b6f10,0), RTFLOAT80U_INIT_IND(1) }, /* #102/3/1/u = #5083 */
    { 0x0e7f, 0x8edf, 0x3c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xd67dd84bed8b6f10,0), RTFLOAT80U_INIT_IND(1) }, /* #102/3/2/m = #5084 */
    { 0x0e00, 0x8edf, 0x3c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xd67dd84bed8b6f10,0), RTFLOAT80U_INIT_IND(1) }, /* #102/3/2/u = #5085 */
    { 0x0f7f, 0x8edf, 0x3c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xd67dd84bed8b6f10,0), RTFLOAT80U_INIT_IND(1) }, /* #102/3/3/m = #5086 */
    { 0x0f00, 0x8edf, 0x3c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xd67dd84bed8b6f10,0), RTFLOAT80U_INIT_IND(1) }, /* #102/3/3/u = #5087 */
    { 0x007f, 0x5390, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x35f0bd6e2b5f50cd,0), RTFLOAT80U_INIT_IND(0) }, /* #103/0/0/m = #5088 */
    { 0x0000, 0x5390, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x35f0bd6e2b5f50cd,0), RTFLOAT80U_INIT_IND(0) }, /* #103/0/0/u = #5089 */
    { 0x017f, 0x5390, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x35f0bd6e2b5f50cd,0), RTFLOAT80U_INIT_IND(0) }, /* #103/0/1/m = #5090 */
    { 0x0100, 0x5390, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x35f0bd6e2b5f50cd,0), RTFLOAT80U_INIT_IND(0) }, /* #103/0/1/u = #5091 */
    { 0x027f, 0x5390, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x35f0bd6e2b5f50cd,0), RTFLOAT80U_INIT_IND(0) }, /* #103/0/2/m = #5092 */
    { 0x0200, 0x5390, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x35f0bd6e2b5f50cd,0), RTFLOAT80U_INIT_IND(0) }, /* #103/0/2/u = #5093 */
    { 0x037f, 0x5390, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x35f0bd6e2b5f50cd,0), RTFLOAT80U_INIT_IND(0) }, /* #103/0/3/m = #5094 */
    { 0x0300, 0x5390, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x35f0bd6e2b5f50cd,0), RTFLOAT80U_INIT_IND(0) }, /* #103/0/3/u = #5095 */
    { 0x047f, 0x5390, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x35f0bd6e2b5f50cd,0), RTFLOAT80U_INIT_IND(0) }, /* #103/1/0/m = #5096 */
    { 0x0400, 0x5390, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x35f0bd6e2b5f50cd,0), RTFLOAT80U_INIT_IND(0) }, /* #103/1/0/u = #5097 */
    { 0x057f, 0x5390, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x35f0bd6e2b5f50cd,0), RTFLOAT80U_INIT_IND(0) }, /* #103/1/1/m = #5098 */
    { 0x0500, 0x5390, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x35f0bd6e2b5f50cd,0), RTFLOAT80U_INIT_IND(0) }, /* #103/1/1/u = #5099 */
    { 0x067f, 0x5390, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x35f0bd6e2b5f50cd,0), RTFLOAT80U_INIT_IND(0) }, /* #103/1/2/m = #5100 */
    { 0x0600, 0x5390, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x35f0bd6e2b5f50cd,0), RTFLOAT80U_INIT_IND(0) }, /* #103/1/2/u = #5101 */
    { 0x077f, 0x5390, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x35f0bd6e2b5f50cd,0), RTFLOAT80U_INIT_IND(0) }, /* #103/1/3/m = #5102 */
    { 0x0700, 0x5390, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x35f0bd6e2b5f50cd,0), RTFLOAT80U_INIT_IND(0) }, /* #103/1/3/u = #5103 */
    { 0x087f, 0x5390, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x35f0bd6e2b5f50cd,0), RTFLOAT80U_INIT_IND(0) }, /* #103/2/0/m = #5104 */
    { 0x0800, 0x5390, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x35f0bd6e2b5f50cd,0), RTFLOAT80U_INIT_IND(0) }, /* #103/2/0/u = #5105 */
    { 0x097f, 0x5390, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x35f0bd6e2b5f50cd,0), RTFLOAT80U_INIT_IND(0) }, /* #103/2/1/m = #5106 */
    { 0x0900, 0x5390, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x35f0bd6e2b5f50cd,0), RTFLOAT80U_INIT_IND(0) }, /* #103/2/1/u = #5107 */
    { 0x0a7f, 0x5390, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x35f0bd6e2b5f50cd,0), RTFLOAT80U_INIT_IND(0) }, /* #103/2/2/m = #5108 */
    { 0x0a00, 0x5390, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x35f0bd6e2b5f50cd,0), RTFLOAT80U_INIT_IND(0) }, /* #103/2/2/u = #5109 */
    { 0x0b7f, 0x5390, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x35f0bd6e2b5f50cd,0), RTFLOAT80U_INIT_IND(0) }, /* #103/2/3/m = #5110 */
    { 0x0b00, 0x5390, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x35f0bd6e2b5f50cd,0), RTFLOAT80U_INIT_IND(0) }, /* #103/2/3/u = #5111 */
    { 0x0c7f, 0x5390, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x35f0bd6e2b5f50cd,0), RTFLOAT80U_INIT_IND(0) }, /* #103/3/0/m = #5112 */
    { 0x0c00, 0x5390, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x35f0bd6e2b5f50cd,0), RTFLOAT80U_INIT_IND(0) }, /* #103/3/0/u = #5113 */
    { 0x0d7f, 0x5390, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x35f0bd6e2b5f50cd,0), RTFLOAT80U_INIT_IND(0) }, /* #103/3/1/m = #5114 */
    { 0x0d00, 0x5390, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x35f0bd6e2b5f50cd,0), RTFLOAT80U_INIT_IND(0) }, /* #103/3/1/u = #5115 */
    { 0x0e7f, 0x5390, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x35f0bd6e2b5f50cd,0), RTFLOAT80U_INIT_IND(0) }, /* #103/3/2/m = #5116 */
    { 0x0e00, 0x5390, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x35f0bd6e2b5f50cd,0), RTFLOAT80U_INIT_IND(0) }, /* #103/3/2/u = #5117 */
    { 0x0f7f, 0x5390, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x35f0bd6e2b5f50cd,0), RTFLOAT80U_INIT_IND(0) }, /* #103/3/3/m = #5118 */
    { 0x0f00, 0x5390, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x35f0bd6e2b5f50cd,0), RTFLOAT80U_INIT_IND(0) }, /* #103/3/3/u = #5119 */
    { 0x007f, 0xcaee, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #104/0/0/m = #5120 */
    { 0x0000, 0xcaee, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #104/0/0/u = #5121 */
    { 0x017f, 0xcaee, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #104/0/1/m = #5122 */
    { 0x0100, 0xcaee, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #104/0/1/u = #5123 */
    { 0x027f, 0xcaee, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #104/0/2/m = #5124 */
    { 0x0200, 0xcaee, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #104/0/2/u = #5125 */
    { 0x037f, 0xcaee, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #104/0/3/m = #5126 */
    { 0x0300, 0xcaee, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #104/0/3/u = #5127 */
    { 0x047f, 0xcaee, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #104/1/0/m = #5128 */
    { 0x0400, 0xcaee, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #104/1/0/u = #5129 */
    { 0x057f, 0xcaee, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #104/1/1/m = #5130 */
    { 0x0500, 0xcaee, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #104/1/1/u = #5131 */
    { 0x067f, 0xcaee, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #104/1/2/m = #5132 */
    { 0x0600, 0xcaee, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #104/1/2/u = #5133 */
    { 0x077f, 0xcaee, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #104/1/3/m = #5134 */
    { 0x0700, 0xcaee, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #104/1/3/u = #5135 */
    { 0x087f, 0xcaee, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #104/2/0/m = #5136 */
    { 0x0800, 0xcaee, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #104/2/0/u = #5137 */
    { 0x097f, 0xcaee, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #104/2/1/m = #5138 */
    { 0x0900, 0xcaee, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #104/2/1/u = #5139 */
    { 0x0a7f, 0xcaee, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #104/2/2/m = #5140 */
    { 0x0a00, 0xcaee, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #104/2/2/u = #5141 */
    { 0x0b7f, 0xcaee, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #104/2/3/m = #5142 */
    { 0x0b00, 0xcaee, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #104/2/3/u = #5143 */
    { 0x0c7f, 0xcaee, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #104/3/0/m = #5144 */
    { 0x0c00, 0xcaee, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #104/3/0/u = #5145 */
    { 0x0d7f, 0xcaee, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #104/3/1/m = #5146 */
    { 0x0d00, 0xcaee, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #104/3/1/u = #5147 */
    { 0x0e7f, 0xcaee, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #104/3/2/m = #5148 */
    { 0x0e00, 0xcaee, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #104/3/2/u = #5149 */
    { 0x0f7f, 0xcaee, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #104/3/3/m = #5150 */
    { 0x0f00, 0xcaee, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #104/3/3/u = #5151 */
    { 0x007f, 0xd4e1, 0x7c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/0/0/m = #5152 */
    { 0x0000, 0xd4e1, 0x7c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/0/0/u = #5153 */
    { 0x017f, 0xd4e1, 0x7c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/0/1/m = #5154 */
    { 0x0100, 0xd4e1, 0x7c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/0/1/u = #5155 */
    { 0x027f, 0xd4e1, 0x7c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/0/2/m = #5156 */
    { 0x0200, 0xd4e1, 0x7c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/0/2/u = #5157 */
    { 0x037f, 0xd4e1, 0x7c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/0/3/m = #5158 */
    { 0x0300, 0xd4e1, 0x7c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/0/3/u = #5159 */
    { 0x047f, 0xd4e1, 0x7c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/1/0/m = #5160 */
    { 0x0400, 0xd4e1, 0x7c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/1/0/u = #5161 */
    { 0x057f, 0xd4e1, 0x7c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/1/1/m = #5162 */
    { 0x0500, 0xd4e1, 0x7c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/1/1/u = #5163 */
    { 0x067f, 0xd4e1, 0x7c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/1/2/m = #5164 */
    { 0x0600, 0xd4e1, 0x7c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/1/2/u = #5165 */
    { 0x077f, 0xd4e1, 0x7c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/1/3/m = #5166 */
    { 0x0700, 0xd4e1, 0x7c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/1/3/u = #5167 */
    { 0x087f, 0xd4e1, 0x7c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/2/0/m = #5168 */
    { 0x0800, 0xd4e1, 0x7c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/2/0/u = #5169 */
    { 0x097f, 0xd4e1, 0x7c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/2/1/m = #5170 */
    { 0x0900, 0xd4e1, 0x7c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/2/1/u = #5171 */
    { 0x0a7f, 0xd4e1, 0x7c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/2/2/m = #5172 */
    { 0x0a00, 0xd4e1, 0x7c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/2/2/u = #5173 */
    { 0x0b7f, 0xd4e1, 0x7c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/2/3/m = #5174 */
    { 0x0b00, 0xd4e1, 0x7c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/2/3/u = #5175 */
    { 0x0c7f, 0xd4e1, 0x7c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/3/0/m = #5176 */
    { 0x0c00, 0xd4e1, 0x7c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/3/0/u = #5177 */
    { 0x0d7f, 0xd4e1, 0x7c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/3/1/m = #5178 */
    { 0x0d00, 0xd4e1, 0x7c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/3/1/u = #5179 */
    { 0x0e7f, 0xd4e1, 0x7c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/3/2/m = #5180 */
    { 0x0e00, 0xd4e1, 0x7c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/3/2/u = #5181 */
    { 0x0f7f, 0xd4e1, 0x7c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/3/3/m = #5182 */
    { 0x0f00, 0xd4e1, 0x7c00, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/3/3/u = #5183 */
    { 0x007f, 0xc701, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/0/0/m = #5184 */
    { 0x0000, 0xc701, 0xf581, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #106/0/0/u = #5185 */
    { 0x0001, 0xc701, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/0/0/0x1 = #5186 */
    { 0x017f, 0xc701, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/0/1/m = #5187 */
    { 0x0100, 0xc701, 0xf581, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #106/0/1/u = #5188 */
    { 0x0101, 0xc701, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/0/1/0x1 = #5189 */
    { 0x027f, 0xc701, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/0/2/m = #5190 */
    { 0x0200, 0xc701, 0xf581, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #106/0/2/u = #5191 */
    { 0x0201, 0xc701, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/0/2/0x1 = #5192 */
    { 0x037f, 0xc701, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/0/3/m = #5193 */
    { 0x0300, 0xc701, 0xf581, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #106/0/3/u = #5194 */
    { 0x0301, 0xc701, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/0/3/0x1 = #5195 */
    { 0x047f, 0xc701, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/1/0/m = #5196 */
    { 0x0400, 0xc701, 0xf581, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #106/1/0/u = #5197 */
    { 0x0401, 0xc701, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/1/0/0x1 = #5198 */
    { 0x057f, 0xc701, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/1/1/m = #5199 */
    { 0x0500, 0xc701, 0xf581, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #106/1/1/u = #5200 */
    { 0x0501, 0xc701, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/1/1/0x1 = #5201 */
    { 0x067f, 0xc701, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/1/2/m = #5202 */
    { 0x0600, 0xc701, 0xf581, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #106/1/2/u = #5203 */
    { 0x0601, 0xc701, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/1/2/0x1 = #5204 */
    { 0x077f, 0xc701, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/1/3/m = #5205 */
    { 0x0700, 0xc701, 0xf581, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #106/1/3/u = #5206 */
    { 0x0701, 0xc701, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/1/3/0x1 = #5207 */
    { 0x087f, 0xc701, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/2/0/m = #5208 */
    { 0x0800, 0xc701, 0xf581, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #106/2/0/u = #5209 */
    { 0x0801, 0xc701, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/2/0/0x1 = #5210 */
    { 0x097f, 0xc701, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/2/1/m = #5211 */
    { 0x0900, 0xc701, 0xf581, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #106/2/1/u = #5212 */
    { 0x0901, 0xc701, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/2/1/0x1 = #5213 */
    { 0x0a7f, 0xc701, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/2/2/m = #5214 */
    { 0x0a00, 0xc701, 0xf581, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #106/2/2/u = #5215 */
    { 0x0a01, 0xc701, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/2/2/0x1 = #5216 */
    { 0x0b7f, 0xc701, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/2/3/m = #5217 */
    { 0x0b00, 0xc701, 0xf581, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #106/2/3/u = #5218 */
    { 0x0b01, 0xc701, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/2/3/0x1 = #5219 */
    { 0x0c7f, 0xc701, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/3/0/m = #5220 */
    { 0x0c00, 0xc701, 0xf581, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #106/3/0/u = #5221 */
    { 0x0c01, 0xc701, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/3/0/0x1 = #5222 */
    { 0x0d7f, 0xc701, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/3/1/m = #5223 */
    { 0x0d00, 0xc701, 0xf581, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #106/3/1/u = #5224 */
    { 0x0d01, 0xc701, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/3/1/0x1 = #5225 */
    { 0x0e7f, 0xc701, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/3/2/m = #5226 */
    { 0x0e00, 0xc701, 0xf581, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #106/3/2/u = #5227 */
    { 0x0e01, 0xc701, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/3/2/0x1 = #5228 */
    { 0x0f7f, 0xc701, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/3/3/m = #5229 */
    { 0x0f00, 0xc701, 0xf581, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #106/3/3/u = #5230 */
    { 0x0f01, 0xc701, 0x7d01, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/3/3/0x1 = #5231 */
    { 0x007f, 0x7f3f, 0x7d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #107/0/0/m = #5232 */
    { 0x0000, 0x7f3f, 0x7d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #107/0/0/u = #5233 */
    { 0x017f, 0x7f3f, 0x7d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #107/0/1/m = #5234 */
    { 0x0100, 0x7f3f, 0x7d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #107/0/1/u = #5235 */
    { 0x027f, 0x7f3f, 0x7d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #107/0/2/m = #5236 */
    { 0x0200, 0x7f3f, 0x7d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #107/0/2/u = #5237 */
    { 0x037f, 0x7f3f, 0x7d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #107/0/3/m = #5238 */
    { 0x0300, 0x7f3f, 0x7d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #107/0/3/u = #5239 */
    { 0x047f, 0x7f3f, 0x7d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #107/1/0/m = #5240 */
    { 0x0400, 0x7f3f, 0x7d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #107/1/0/u = #5241 */
    { 0x057f, 0x7f3f, 0x7d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #107/1/1/m = #5242 */
    { 0x0500, 0x7f3f, 0x7d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #107/1/1/u = #5243 */
    { 0x067f, 0x7f3f, 0x7d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #107/1/2/m = #5244 */
    { 0x0600, 0x7f3f, 0x7d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #107/1/2/u = #5245 */
    { 0x077f, 0x7f3f, 0x7d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #107/1/3/m = #5246 */
    { 0x0700, 0x7f3f, 0x7d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #107/1/3/u = #5247 */
    { 0x087f, 0x7f3f, 0x7d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #107/2/0/m = #5248 */
    { 0x0800, 0x7f3f, 0x7d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #107/2/0/u = #5249 */
    { 0x097f, 0x7f3f, 0x7d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #107/2/1/m = #5250 */
    { 0x0900, 0x7f3f, 0x7d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #107/2/1/u = #5251 */
    { 0x0a7f, 0x7f3f, 0x7d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #107/2/2/m = #5252 */
    { 0x0a00, 0x7f3f, 0x7d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #107/2/2/u = #5253 */
    { 0x0b7f, 0x7f3f, 0x7d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #107/2/3/m = #5254 */
    { 0x0b00, 0x7f3f, 0x7d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #107/2/3/u = #5255 */
    { 0x0c7f, 0x7f3f, 0x7d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #107/3/0/m = #5256 */
    { 0x0c00, 0x7f3f, 0x7d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #107/3/0/u = #5257 */
    { 0x0d7f, 0x7f3f, 0x7d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #107/3/1/m = #5258 */
    { 0x0d00, 0x7f3f, 0x7d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #107/3/1/u = #5259 */
    { 0x0e7f, 0x7f3f, 0x7d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #107/3/2/m = #5260 */
    { 0x0e00, 0x7f3f, 0x7d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #107/3/2/u = #5261 */
    { 0x0f7f, 0x7f3f, 0x7d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #107/3/3/m = #5262 */
    { 0x0f00, 0x7f3f, 0x7d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #107/3/3/u = #5263 */
    { 0x007f, 0x45d5, 0x7f20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #108/0/0/m = #5264 */
    { 0x0000, 0x45d5, 0xffa0, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #108/0/0/u = #5265 */
    { 0x0020, 0x45d5, 0x7f20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #108/0/0/0x20 = #5266 */
    { 0x017f, 0x45d5, 0x7f20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #108/0/1/m = #5267 */
    { 0x0100, 0x45d5, 0xffa0, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #108/0/1/u = #5268 */
    { 0x0120, 0x45d5, 0x7f20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #108/0/1/0x20 = #5269 */
    { 0x027f, 0x45d5, 0x7f20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #108/0/2/m = #5270 */
    { 0x0200, 0x45d5, 0xffa0, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #108/0/2/u = #5271 */
    { 0x0220, 0x45d5, 0x7f20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #108/0/2/0x20 = #5272 */
    { 0x037f, 0x45d5, 0x7f20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #108/0/3/m = #5273 */
    { 0x0300, 0x45d5, 0xffa0, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #108/0/3/u = #5274 */
    { 0x0320, 0x45d5, 0x7f20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #108/0/3/0x20 = #5275 */
    { 0x047f, 0x45d5, 0x7d20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #108/1/0/m = #5276 */
    { 0x0400, 0x45d5, 0xfda0, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #108/1/0/u = #5277 */
    { 0x0420, 0x45d5, 0x7d20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #108/1/0/0x20 = #5278 */
    { 0x057f, 0x45d5, 0x7d20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #108/1/1/m = #5279 */
    { 0x0500, 0x45d5, 0xfda0, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #108/1/1/u = #5280 */
    { 0x0520, 0x45d5, 0x7d20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #108/1/1/0x20 = #5281 */
    { 0x067f, 0x45d5, 0x7d20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #108/1/2/m = #5282 */
    { 0x0600, 0x45d5, 0xfda0, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #108/1/2/u = #5283 */
    { 0x0620, 0x45d5, 0x7d20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #108/1/2/0x20 = #5284 */
    { 0x077f, 0x45d5, 0x7d20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #108/1/3/m = #5285 */
    { 0x0700, 0x45d5, 0xfda0, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #108/1/3/u = #5286 */
    { 0x0720, 0x45d5, 0x7d20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #108/1/3/0x20 = #5287 */
    { 0x087f, 0x45d5, 0x7f20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #108/2/0/m = #5288 */
    { 0x0800, 0x45d5, 0xffa0, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #108/2/0/u = #5289 */
    { 0x0820, 0x45d5, 0x7f20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #108/2/0/0x20 = #5290 */
    { 0x097f, 0x45d5, 0x7f20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #108/2/1/m = #5291 */
    { 0x0900, 0x45d5, 0xffa0, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #108/2/1/u = #5292 */
    { 0x0920, 0x45d5, 0x7f20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #108/2/1/0x20 = #5293 */
    { 0x0a7f, 0x45d5, 0x7f20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #108/2/2/m = #5294 */
    { 0x0a00, 0x45d5, 0xffa0, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #108/2/2/u = #5295 */
    { 0x0a20, 0x45d5, 0x7f20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #108/2/2/0x20 = #5296 */
    { 0x0b7f, 0x45d5, 0x7f20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #108/2/3/m = #5297 */
    { 0x0b00, 0x45d5, 0xffa0, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #108/2/3/u = #5298 */
    { 0x0b20, 0x45d5, 0x7f20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #108/2/3/0x20 = #5299 */
    { 0x0c7f, 0x45d5, 0x7d20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #108/3/0/m = #5300 */
    { 0x0c00, 0x45d5, 0xfda0, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #108/3/0/u = #5301 */
    { 0x0c20, 0x45d5, 0x7d20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #108/3/0/0x20 = #5302 */
    { 0x0d7f, 0x45d5, 0x7d20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #108/3/1/m = #5303 */
    { 0x0d00, 0x45d5, 0xfda0, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #108/3/1/u = #5304 */
    { 0x0d20, 0x45d5, 0x7d20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #108/3/1/0x20 = #5305 */
    { 0x0e7f, 0x45d5, 0x7d20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #108/3/2/m = #5306 */
    { 0x0e00, 0x45d5, 0xfda0, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #108/3/2/u = #5307 */
    { 0x0e20, 0x45d5, 0x7d20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #108/3/2/0x20 = #5308 */
    { 0x0f7f, 0x45d5, 0x7d20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #108/3/3/m = #5309 */
    { 0x0f00, 0x45d5, 0xfda0, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #108/3/3/u = #5310 */
    { 0x0f20, 0x45d5, 0x7d20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xc503296e963284ac,28386), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #108/3/3/0x20 = #5311 */
    { 0x007f, 0xed0f, 0x7f20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #109/0/0/m = #5312 */
    { 0x0000, 0xed0f, 0xffa0, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #109/0/0/u = #5313 */
    { 0x0020, 0xed0f, 0x7f20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #109/0/0/0x20 = #5314 */
    { 0x017f, 0xed0f, 0x7f20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #109/0/1/m = #5315 */
    { 0x0100, 0xed0f, 0xffa0, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #109/0/1/u = #5316 */
    { 0x0120, 0xed0f, 0x7f20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #109/0/1/0x20 = #5317 */
    { 0x027f, 0xed0f, 0x7f20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #109/0/2/m = #5318 */
    { 0x0200, 0xed0f, 0xffa0, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #109/0/2/u = #5319 */
    { 0x0220, 0xed0f, 0x7f20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #109/0/2/0x20 = #5320 */
    { 0x037f, 0xed0f, 0x7f20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #109/0/3/m = #5321 */
    { 0x0300, 0xed0f, 0xffa0, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #109/0/3/u = #5322 */
    { 0x0320, 0xed0f, 0x7f20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #109/0/3/0x20 = #5323 */
    { 0x047f, 0xed0f, 0x7d20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #109/1/0/m = #5324 */
    { 0x0400, 0xed0f, 0xfda0, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #109/1/0/u = #5325 */
    { 0x0420, 0xed0f, 0x7d20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #109/1/0/0x20 = #5326 */
    { 0x057f, 0xed0f, 0x7d20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #109/1/1/m = #5327 */
    { 0x0500, 0xed0f, 0xfda0, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #109/1/1/u = #5328 */
    { 0x0520, 0xed0f, 0x7d20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #109/1/1/0x20 = #5329 */
    { 0x067f, 0xed0f, 0x7d20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #109/1/2/m = #5330 */
    { 0x0600, 0xed0f, 0xfda0, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #109/1/2/u = #5331 */
    { 0x0620, 0xed0f, 0x7d20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #109/1/2/0x20 = #5332 */
    { 0x077f, 0xed0f, 0x7d20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #109/1/3/m = #5333 */
    { 0x0700, 0xed0f, 0xfda0, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #109/1/3/u = #5334 */
    { 0x0720, 0xed0f, 0x7d20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #109/1/3/0x20 = #5335 */
    { 0x087f, 0xed0f, 0x7f20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #109/2/0/m = #5336 */
    { 0x0800, 0xed0f, 0xffa0, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #109/2/0/u = #5337 */
    { 0x0820, 0xed0f, 0x7f20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #109/2/0/0x20 = #5338 */
    { 0x097f, 0xed0f, 0x7f20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #109/2/1/m = #5339 */
    { 0x0900, 0xed0f, 0xffa0, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #109/2/1/u = #5340 */
    { 0x0920, 0xed0f, 0x7f20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #109/2/1/0x20 = #5341 */
    { 0x0a7f, 0xed0f, 0x7f20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #109/2/2/m = #5342 */
    { 0x0a00, 0xed0f, 0xffa0, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #109/2/2/u = #5343 */
    { 0x0a20, 0xed0f, 0x7f20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #109/2/2/0x20 = #5344 */
    { 0x0b7f, 0xed0f, 0x7f20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #109/2/3/m = #5345 */
    { 0x0b00, 0xed0f, 0xffa0, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #109/2/3/u = #5346 */
    { 0x0b20, 0xed0f, 0x7f20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #109/2/3/0x20 = #5347 */
    { 0x0c7f, 0xed0f, 0x7d20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #109/3/0/m = #5348 */
    { 0x0c00, 0xed0f, 0xfda0, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #109/3/0/u = #5349 */
    { 0x0c20, 0xed0f, 0x7d20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #109/3/0/0x20 = #5350 */
    { 0x0d7f, 0xed0f, 0x7d20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #109/3/1/m = #5351 */
    { 0x0d00, 0xed0f, 0xfda0, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #109/3/1/u = #5352 */
    { 0x0d20, 0xed0f, 0x7d20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #109/3/1/0x20 = #5353 */
    { 0x0e7f, 0xed0f, 0x7d20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #109/3/2/m = #5354 */
    { 0x0e00, 0xed0f, 0xfda0, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #109/3/2/u = #5355 */
    { 0x0e20, 0xed0f, 0x7d20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #109/3/2/0x20 = #5356 */
    { 0x0f7f, 0xed0f, 0x7d20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #109/3/3/m = #5357 */
    { 0x0f00, 0xed0f, 0xfda0, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #109/3/3/u = #5358 */
    { 0x0f20, 0xed0f, 0x7d20, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,12215), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #109/3/3/0x20 = #5359 */
    { 0x007f, 0x308b, 0x3801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_IND(1) }, /* #110/0/0/m = #5360 */
    { 0x0000, 0x308b, 0xb081, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590) }, /* #110/0/0/u = #5361 */
    { 0x0001, 0x308b, 0x3801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_IND(1) }, /* #110/0/0/0x1 = #5362 */
    { 0x017f, 0x308b, 0x3801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_IND(1) }, /* #110/0/1/m = #5363 */
    { 0x0100, 0x308b, 0xb081, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590) }, /* #110/0/1/u = #5364 */
    { 0x0101, 0x308b, 0x3801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_IND(1) }, /* #110/0/1/0x1 = #5365 */
    { 0x027f, 0x308b, 0x3801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_IND(1) }, /* #110/0/2/m = #5366 */
    { 0x0200, 0x308b, 0xb081, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590) }, /* #110/0/2/u = #5367 */
    { 0x0201, 0x308b, 0x3801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_IND(1) }, /* #110/0/2/0x1 = #5368 */
    { 0x037f, 0x308b, 0x3801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_IND(1) }, /* #110/0/3/m = #5369 */
    { 0x0300, 0x308b, 0xb081, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590) }, /* #110/0/3/u = #5370 */
    { 0x0301, 0x308b, 0x3801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_IND(1) }, /* #110/0/3/0x1 = #5371 */
    { 0x047f, 0x308b, 0x3801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_IND(1) }, /* #110/1/0/m = #5372 */
    { 0x0400, 0x308b, 0xb081, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590) }, /* #110/1/0/u = #5373 */
    { 0x0401, 0x308b, 0x3801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_IND(1) }, /* #110/1/0/0x1 = #5374 */
    { 0x057f, 0x308b, 0x3801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_IND(1) }, /* #110/1/1/m = #5375 */
    { 0x0500, 0x308b, 0xb081, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590) }, /* #110/1/1/u = #5376 */
    { 0x0501, 0x308b, 0x3801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_IND(1) }, /* #110/1/1/0x1 = #5377 */
    { 0x067f, 0x308b, 0x3801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_IND(1) }, /* #110/1/2/m = #5378 */
    { 0x0600, 0x308b, 0xb081, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590) }, /* #110/1/2/u = #5379 */
    { 0x0601, 0x308b, 0x3801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_IND(1) }, /* #110/1/2/0x1 = #5380 */
    { 0x077f, 0x308b, 0x3801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_IND(1) }, /* #110/1/3/m = #5381 */
    { 0x0700, 0x308b, 0xb081, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590) }, /* #110/1/3/u = #5382 */
    { 0x0701, 0x308b, 0x3801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_IND(1) }, /* #110/1/3/0x1 = #5383 */
    { 0x087f, 0x308b, 0x3801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_IND(1) }, /* #110/2/0/m = #5384 */
    { 0x0800, 0x308b, 0xb081, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590) }, /* #110/2/0/u = #5385 */
    { 0x0801, 0x308b, 0x3801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_IND(1) }, /* #110/2/0/0x1 = #5386 */
    { 0x097f, 0x308b, 0x3801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_IND(1) }, /* #110/2/1/m = #5387 */
    { 0x0900, 0x308b, 0xb081, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590) }, /* #110/2/1/u = #5388 */
    { 0x0901, 0x308b, 0x3801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_IND(1) }, /* #110/2/1/0x1 = #5389 */
    { 0x0a7f, 0x308b, 0x3801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_IND(1) }, /* #110/2/2/m = #5390 */
    { 0x0a00, 0x308b, 0xb081, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590) }, /* #110/2/2/u = #5391 */
    { 0x0a01, 0x308b, 0x3801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_IND(1) }, /* #110/2/2/0x1 = #5392 */
    { 0x0b7f, 0x308b, 0x3801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_IND(1) }, /* #110/2/3/m = #5393 */
    { 0x0b00, 0x308b, 0xb081, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590) }, /* #110/2/3/u = #5394 */
    { 0x0b01, 0x308b, 0x3801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_IND(1) }, /* #110/2/3/0x1 = #5395 */
    { 0x0c7f, 0x308b, 0x3801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_IND(1) }, /* #110/3/0/m = #5396 */
    { 0x0c00, 0x308b, 0xb081, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590) }, /* #110/3/0/u = #5397 */
    { 0x0c01, 0x308b, 0x3801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_IND(1) }, /* #110/3/0/0x1 = #5398 */
    { 0x0d7f, 0x308b, 0x3801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_IND(1) }, /* #110/3/1/m = #5399 */
    { 0x0d00, 0x308b, 0xb081, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590) }, /* #110/3/1/u = #5400 */
    { 0x0d01, 0x308b, 0x3801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_IND(1) }, /* #110/3/1/0x1 = #5401 */
    { 0x0e7f, 0x308b, 0x3801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_IND(1) }, /* #110/3/2/m = #5402 */
    { 0x0e00, 0x308b, 0xb081, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590) }, /* #110/3/2/u = #5403 */
    { 0x0e01, 0x308b, 0x3801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_IND(1) }, /* #110/3/2/0x1 = #5404 */
    { 0x0f7f, 0x308b, 0x3801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_IND(1) }, /* #110/3/3/m = #5405 */
    { 0x0f00, 0x308b, 0xb081, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590) }, /* #110/3/3/u = #5406 */
    { 0x0f01, 0x308b, 0x3801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x2e5188d474309937,32590), RTFLOAT80U_INIT_IND(1) }, /* #110/3/3/0x1 = #5407 */
    { 0x007f, 0xc466, 0x7c01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0xc2a933166fb0ff73,32767) }, /* #111/0/0/m = #5408 */
    { 0x0000, 0xc466, 0xf481, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767) }, /* #111/0/0/u = #5409 */
    { 0x0001, 0xc466, 0x7c01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0xc2a933166fb0ff73,32767) }, /* #111/0/0/0x1 = #5410 */
    { 0x017f, 0xc466, 0x7c01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0xc2a933166fb0ff73,32767) }, /* #111/0/1/m = #5411 */
    { 0x0100, 0xc466, 0xf481, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767) }, /* #111/0/1/u = #5412 */
    { 0x0101, 0xc466, 0x7c01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0xc2a933166fb0ff73,32767) }, /* #111/0/1/0x1 = #5413 */
    { 0x027f, 0xc466, 0x7c01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0xc2a933166fb0ff73,32767) }, /* #111/0/2/m = #5414 */
    { 0x0200, 0xc466, 0xf481, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767) }, /* #111/0/2/u = #5415 */
    { 0x0201, 0xc466, 0x7c01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0xc2a933166fb0ff73,32767) }, /* #111/0/2/0x1 = #5416 */
    { 0x037f, 0xc466, 0x7c01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0xc2a933166fb0ff73,32767) }, /* #111/0/3/m = #5417 */
    { 0x0300, 0xc466, 0xf481, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767) }, /* #111/0/3/u = #5418 */
    { 0x0301, 0xc466, 0x7c01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0xc2a933166fb0ff73,32767) }, /* #111/0/3/0x1 = #5419 */
    { 0x047f, 0xc466, 0x7c01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0xc2a933166fb0ff73,32767) }, /* #111/1/0/m = #5420 */
    { 0x0400, 0xc466, 0xf481, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767) }, /* #111/1/0/u = #5421 */
    { 0x0401, 0xc466, 0x7c01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0xc2a933166fb0ff73,32767) }, /* #111/1/0/0x1 = #5422 */
    { 0x057f, 0xc466, 0x7c01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0xc2a933166fb0ff73,32767) }, /* #111/1/1/m = #5423 */
    { 0x0500, 0xc466, 0xf481, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767) }, /* #111/1/1/u = #5424 */
    { 0x0501, 0xc466, 0x7c01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0xc2a933166fb0ff73,32767) }, /* #111/1/1/0x1 = #5425 */
    { 0x067f, 0xc466, 0x7c01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0xc2a933166fb0ff73,32767) }, /* #111/1/2/m = #5426 */
    { 0x0600, 0xc466, 0xf481, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767) }, /* #111/1/2/u = #5427 */
    { 0x0601, 0xc466, 0x7c01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0xc2a933166fb0ff73,32767) }, /* #111/1/2/0x1 = #5428 */
    { 0x077f, 0xc466, 0x7c01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0xc2a933166fb0ff73,32767) }, /* #111/1/3/m = #5429 */
    { 0x0700, 0xc466, 0xf481, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767) }, /* #111/1/3/u = #5430 */
    { 0x0701, 0xc466, 0x7c01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0xc2a933166fb0ff73,32767) }, /* #111/1/3/0x1 = #5431 */
    { 0x087f, 0xc466, 0x7c01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0xc2a933166fb0ff73,32767) }, /* #111/2/0/m = #5432 */
    { 0x0800, 0xc466, 0xf481, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767) }, /* #111/2/0/u = #5433 */
    { 0x0801, 0xc466, 0x7c01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0xc2a933166fb0ff73,32767) }, /* #111/2/0/0x1 = #5434 */
    { 0x097f, 0xc466, 0x7c01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0xc2a933166fb0ff73,32767) }, /* #111/2/1/m = #5435 */
    { 0x0900, 0xc466, 0xf481, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767) }, /* #111/2/1/u = #5436 */
    { 0x0901, 0xc466, 0x7c01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0xc2a933166fb0ff73,32767) }, /* #111/2/1/0x1 = #5437 */
    { 0x0a7f, 0xc466, 0x7c01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0xc2a933166fb0ff73,32767) }, /* #111/2/2/m = #5438 */
    { 0x0a00, 0xc466, 0xf481, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767) }, /* #111/2/2/u = #5439 */
    { 0x0a01, 0xc466, 0x7c01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0xc2a933166fb0ff73,32767) }, /* #111/2/2/0x1 = #5440 */
    { 0x0b7f, 0xc466, 0x7c01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0xc2a933166fb0ff73,32767) }, /* #111/2/3/m = #5441 */
    { 0x0b00, 0xc466, 0xf481, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767) }, /* #111/2/3/u = #5442 */
    { 0x0b01, 0xc466, 0x7c01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0xc2a933166fb0ff73,32767) }, /* #111/2/3/0x1 = #5443 */
    { 0x0c7f, 0xc466, 0x7c01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0xc2a933166fb0ff73,32767) }, /* #111/3/0/m = #5444 */
    { 0x0c00, 0xc466, 0xf481, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767) }, /* #111/3/0/u = #5445 */
    { 0x0c01, 0xc466, 0x7c01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0xc2a933166fb0ff73,32767) }, /* #111/3/0/0x1 = #5446 */
    { 0x0d7f, 0xc466, 0x7c01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0xc2a933166fb0ff73,32767) }, /* #111/3/1/m = #5447 */
    { 0x0d00, 0xc466, 0xf481, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767) }, /* #111/3/1/u = #5448 */
    { 0x0d01, 0xc466, 0x7c01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0xc2a933166fb0ff73,32767) }, /* #111/3/1/0x1 = #5449 */
    { 0x0e7f, 0xc466, 0x7c01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0xc2a933166fb0ff73,32767) }, /* #111/3/2/m = #5450 */
    { 0x0e00, 0xc466, 0xf481, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767) }, /* #111/3/2/u = #5451 */
    { 0x0e01, 0xc466, 0x7c01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0xc2a933166fb0ff73,32767) }, /* #111/3/2/0x1 = #5452 */
    { 0x0f7f, 0xc466, 0x7c01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0xc2a933166fb0ff73,32767) }, /* #111/3/3/m = #5453 */
    { 0x0f00, 0xc466, 0xf481, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767) }, /* #111/3/3/u = #5454 */
    { 0x0f01, 0xc466, 0x7c01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x82a933166fb0ff73,32767), RTFLOAT80U_INIT_C(0,0xc2a933166fb0ff73,32767) }, /* #111/3/3/0x1 = #5455 */
    { 0x007f, 0x18cf, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767) }, /* #112/0/0/m = #5456 */
    { 0x0000, 0x18cf, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767) }, /* #112/0/0/u = #5457 */
    { 0x017f, 0x18cf, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767) }, /* #112/0/1/m = #5458 */
    { 0x0100, 0x18cf, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767) }, /* #112/0/1/u = #5459 */
    { 0x027f, 0x18cf, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767) }, /* #112/0/2/m = #5460 */
    { 0x0200, 0x18cf, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767) }, /* #112/0/2/u = #5461 */
    { 0x037f, 0x18cf, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767) }, /* #112/0/3/m = #5462 */
    { 0x0300, 0x18cf, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767) }, /* #112/0/3/u = #5463 */
    { 0x047f, 0x18cf, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767) }, /* #112/1/0/m = #5464 */
    { 0x0400, 0x18cf, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767) }, /* #112/1/0/u = #5465 */
    { 0x057f, 0x18cf, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767) }, /* #112/1/1/m = #5466 */
    { 0x0500, 0x18cf, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767) }, /* #112/1/1/u = #5467 */
    { 0x067f, 0x18cf, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767) }, /* #112/1/2/m = #5468 */
    { 0x0600, 0x18cf, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767) }, /* #112/1/2/u = #5469 */
    { 0x077f, 0x18cf, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767) }, /* #112/1/3/m = #5470 */
    { 0x0700, 0x18cf, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767) }, /* #112/1/3/u = #5471 */
    { 0x087f, 0x18cf, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767) }, /* #112/2/0/m = #5472 */
    { 0x0800, 0x18cf, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767) }, /* #112/2/0/u = #5473 */
    { 0x097f, 0x18cf, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767) }, /* #112/2/1/m = #5474 */
    { 0x0900, 0x18cf, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767) }, /* #112/2/1/u = #5475 */
    { 0x0a7f, 0x18cf, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767) }, /* #112/2/2/m = #5476 */
    { 0x0a00, 0x18cf, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767) }, /* #112/2/2/u = #5477 */
    { 0x0b7f, 0x18cf, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767) }, /* #112/2/3/m = #5478 */
    { 0x0b00, 0x18cf, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767) }, /* #112/2/3/u = #5479 */
    { 0x0c7f, 0x18cf, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767) }, /* #112/3/0/m = #5480 */
    { 0x0c00, 0x18cf, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767) }, /* #112/3/0/u = #5481 */
    { 0x0d7f, 0x18cf, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767) }, /* #112/3/1/m = #5482 */
    { 0x0d00, 0x18cf, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767) }, /* #112/3/1/u = #5483 */
    { 0x0e7f, 0x18cf, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767) }, /* #112/3/2/m = #5484 */
    { 0x0e00, 0x18cf, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767) }, /* #112/3/2/u = #5485 */
    { 0x0f7f, 0x18cf, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767) }, /* #112/3/3/m = #5486 */
    { 0x0f00, 0x18cf, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767), RTFLOAT80U_INIT_C(0,0xda90f338f1349bd6,32767) }, /* #112/3/3/u = #5487 */
    { 0x007f, 0xbf16, 0x3d01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/0/0/m = #5488 */
    { 0x0000, 0xbf16, 0xb581, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767) }, /* #113/0/0/u = #5489 */
    { 0x0001, 0xbf16, 0x3d01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/0/0/0x1 = #5490 */
    { 0x017f, 0xbf16, 0x3d01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/0/1/m = #5491 */
    { 0x0100, 0xbf16, 0xb581, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767) }, /* #113/0/1/u = #5492 */
    { 0x0101, 0xbf16, 0x3d01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/0/1/0x1 = #5493 */
    { 0x027f, 0xbf16, 0x3d01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/0/2/m = #5494 */
    { 0x0200, 0xbf16, 0xb581, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767) }, /* #113/0/2/u = #5495 */
    { 0x0201, 0xbf16, 0x3d01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/0/2/0x1 = #5496 */
    { 0x037f, 0xbf16, 0x3d01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/0/3/m = #5497 */
    { 0x0300, 0xbf16, 0xb581, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767) }, /* #113/0/3/u = #5498 */
    { 0x0301, 0xbf16, 0x3d01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/0/3/0x1 = #5499 */
    { 0x047f, 0xbf16, 0x3d01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/1/0/m = #5500 */
    { 0x0400, 0xbf16, 0xb581, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767) }, /* #113/1/0/u = #5501 */
    { 0x0401, 0xbf16, 0x3d01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/1/0/0x1 = #5502 */
    { 0x057f, 0xbf16, 0x3d01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/1/1/m = #5503 */
    { 0x0500, 0xbf16, 0xb581, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767) }, /* #113/1/1/u = #5504 */
    { 0x0501, 0xbf16, 0x3d01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/1/1/0x1 = #5505 */
    { 0x067f, 0xbf16, 0x3d01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/1/2/m = #5506 */
    { 0x0600, 0xbf16, 0xb581, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767) }, /* #113/1/2/u = #5507 */
    { 0x0601, 0xbf16, 0x3d01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/1/2/0x1 = #5508 */
    { 0x077f, 0xbf16, 0x3d01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/1/3/m = #5509 */
    { 0x0700, 0xbf16, 0xb581, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767) }, /* #113/1/3/u = #5510 */
    { 0x0701, 0xbf16, 0x3d01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/1/3/0x1 = #5511 */
    { 0x087f, 0xbf16, 0x3d01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/2/0/m = #5512 */
    { 0x0800, 0xbf16, 0xb581, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767) }, /* #113/2/0/u = #5513 */
    { 0x0801, 0xbf16, 0x3d01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/2/0/0x1 = #5514 */
    { 0x097f, 0xbf16, 0x3d01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/2/1/m = #5515 */
    { 0x0900, 0xbf16, 0xb581, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767) }, /* #113/2/1/u = #5516 */
    { 0x0901, 0xbf16, 0x3d01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/2/1/0x1 = #5517 */
    { 0x0a7f, 0xbf16, 0x3d01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/2/2/m = #5518 */
    { 0x0a00, 0xbf16, 0xb581, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767) }, /* #113/2/2/u = #5519 */
    { 0x0a01, 0xbf16, 0x3d01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/2/2/0x1 = #5520 */
    { 0x0b7f, 0xbf16, 0x3d01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/2/3/m = #5521 */
    { 0x0b00, 0xbf16, 0xb581, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767) }, /* #113/2/3/u = #5522 */
    { 0x0b01, 0xbf16, 0x3d01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/2/3/0x1 = #5523 */
    { 0x0c7f, 0xbf16, 0x3d01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/3/0/m = #5524 */
    { 0x0c00, 0xbf16, 0xb581, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767) }, /* #113/3/0/u = #5525 */
    { 0x0c01, 0xbf16, 0x3d01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/3/0/0x1 = #5526 */
    { 0x0d7f, 0xbf16, 0x3d01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/3/1/m = #5527 */
    { 0x0d00, 0xbf16, 0xb581, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767) }, /* #113/3/1/u = #5528 */
    { 0x0d01, 0xbf16, 0x3d01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/3/1/0x1 = #5529 */
    { 0x0e7f, 0xbf16, 0x3d01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/3/2/m = #5530 */
    { 0x0e00, 0xbf16, 0xb581, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767) }, /* #113/3/2/u = #5531 */
    { 0x0e01, 0xbf16, 0x3d01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/3/2/0x1 = #5532 */
    { 0x0f7f, 0xbf16, 0x3d01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/3/3/m = #5533 */
    { 0x0f00, 0xbf16, 0xb581, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767) }, /* #113/3/3/u = #5534 */
    { 0x0f01, 0xbf16, 0x3d01, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x3aa176a5ea51f834,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/3/3/0x1 = #5535 */
    { 0x007f, 0xb27d, 0x3a22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #114/0/0/m = #5536 */
    { 0x0000, 0xb27d, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0) }, /* #114/0/0/u = #5537 */
    { 0x0022, 0xb27d, 0x3a22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #114/0/0/0x22 = #5538 */
    { 0x0020, 0xb27d, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0) }, /* #114/0/0/u0x2 = #5539 */
    { 0x0002, 0xb27d, 0xbaa2, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #114/0/0/u0x20 = #5540 */
    { 0x017f, 0xb27d, 0x3a22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #114/0/1/m = #5541 */
    { 0x0100, 0xb27d, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0) }, /* #114/0/1/u = #5542 */
    { 0x0122, 0xb27d, 0x3a22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #114/0/1/0x22 = #5543 */
    { 0x0120, 0xb27d, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0) }, /* #114/0/1/u0x2 = #5544 */
    { 0x0102, 0xb27d, 0xbaa2, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #114/0/1/u0x20 = #5545 */
    { 0x027f, 0xb27d, 0x3a22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #114/0/2/m = #5546 */
    { 0x0200, 0xb27d, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0) }, /* #114/0/2/u = #5547 */
    { 0x0222, 0xb27d, 0x3a22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #114/0/2/0x22 = #5548 */
    { 0x0220, 0xb27d, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0) }, /* #114/0/2/u0x2 = #5549 */
    { 0x0202, 0xb27d, 0xbaa2, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #114/0/2/u0x20 = #5550 */
    { 0x037f, 0xb27d, 0x3a22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #114/0/3/m = #5551 */
    { 0x0300, 0xb27d, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0) }, /* #114/0/3/u = #5552 */
    { 0x0322, 0xb27d, 0x3a22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #114/0/3/0x22 = #5553 */
    { 0x0320, 0xb27d, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0) }, /* #114/0/3/u0x2 = #5554 */
    { 0x0302, 0xb27d, 0xbaa2, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #114/0/3/u0x20 = #5555 */
    { 0x047f, 0xb27d, 0x3822, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #114/1/0/m = #5556 */
    { 0x0400, 0xb27d, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0) }, /* #114/1/0/u = #5557 */
    { 0x0422, 0xb27d, 0x3822, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #114/1/0/0x22 = #5558 */
    { 0x0420, 0xb27d, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0) }, /* #114/1/0/u0x2 = #5559 */
    { 0x0402, 0xb27d, 0xb8a2, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #114/1/0/u0x20 = #5560 */
    { 0x057f, 0xb27d, 0x3822, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #114/1/1/m = #5561 */
    { 0x0500, 0xb27d, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0) }, /* #114/1/1/u = #5562 */
    { 0x0522, 0xb27d, 0x3822, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #114/1/1/0x22 = #5563 */
    { 0x0520, 0xb27d, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0) }, /* #114/1/1/u0x2 = #5564 */
    { 0x0502, 0xb27d, 0xb8a2, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #114/1/1/u0x20 = #5565 */
    { 0x067f, 0xb27d, 0x3822, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #114/1/2/m = #5566 */
    { 0x0600, 0xb27d, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0) }, /* #114/1/2/u = #5567 */
    { 0x0622, 0xb27d, 0x3822, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #114/1/2/0x22 = #5568 */
    { 0x0620, 0xb27d, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0) }, /* #114/1/2/u0x2 = #5569 */
    { 0x0602, 0xb27d, 0xb8a2, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #114/1/2/u0x20 = #5570 */
    { 0x077f, 0xb27d, 0x3822, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #114/1/3/m = #5571 */
    { 0x0700, 0xb27d, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0) }, /* #114/1/3/u = #5572 */
    { 0x0722, 0xb27d, 0x3822, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #114/1/3/0x22 = #5573 */
    { 0x0720, 0xb27d, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0) }, /* #114/1/3/u0x2 = #5574 */
    { 0x0702, 0xb27d, 0xb8a2, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #114/1/3/u0x20 = #5575 */
    { 0x087f, 0xb27d, 0x3a22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #114/2/0/m = #5576 */
    { 0x0800, 0xb27d, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0) }, /* #114/2/0/u = #5577 */
    { 0x0822, 0xb27d, 0x3a22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #114/2/0/0x22 = #5578 */
    { 0x0820, 0xb27d, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0) }, /* #114/2/0/u0x2 = #5579 */
    { 0x0802, 0xb27d, 0xbaa2, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #114/2/0/u0x20 = #5580 */
    { 0x097f, 0xb27d, 0x3a22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #114/2/1/m = #5581 */
    { 0x0900, 0xb27d, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0) }, /* #114/2/1/u = #5582 */
    { 0x0922, 0xb27d, 0x3a22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #114/2/1/0x22 = #5583 */
    { 0x0920, 0xb27d, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0) }, /* #114/2/1/u0x2 = #5584 */
    { 0x0902, 0xb27d, 0xbaa2, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #114/2/1/u0x20 = #5585 */
    { 0x0a7f, 0xb27d, 0x3a22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #114/2/2/m = #5586 */
    { 0x0a00, 0xb27d, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0) }, /* #114/2/2/u = #5587 */
    { 0x0a22, 0xb27d, 0x3a22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #114/2/2/0x22 = #5588 */
    { 0x0a20, 0xb27d, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0) }, /* #114/2/2/u0x2 = #5589 */
    { 0x0a02, 0xb27d, 0xbaa2, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #114/2/2/u0x20 = #5590 */
    { 0x0b7f, 0xb27d, 0x3a22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #114/2/3/m = #5591 */
    { 0x0b00, 0xb27d, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0) }, /* #114/2/3/u = #5592 */
    { 0x0b22, 0xb27d, 0x3a22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #114/2/3/0x22 = #5593 */
    { 0x0b20, 0xb27d, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0) }, /* #114/2/3/u0x2 = #5594 */
    { 0x0b02, 0xb27d, 0xbaa2, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #114/2/3/u0x20 = #5595 */
    { 0x0c7f, 0xb27d, 0x3822, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #114/3/0/m = #5596 */
    { 0x0c00, 0xb27d, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0) }, /* #114/3/0/u = #5597 */
    { 0x0c22, 0xb27d, 0x3822, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #114/3/0/0x22 = #5598 */
    { 0x0c20, 0xb27d, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0) }, /* #114/3/0/u0x2 = #5599 */
    { 0x0c02, 0xb27d, 0xb8a2, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #114/3/0/u0x20 = #5600 */
    { 0x0d7f, 0xb27d, 0x3822, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #114/3/1/m = #5601 */
    { 0x0d00, 0xb27d, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0) }, /* #114/3/1/u = #5602 */
    { 0x0d22, 0xb27d, 0x3822, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #114/3/1/0x22 = #5603 */
    { 0x0d20, 0xb27d, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0) }, /* #114/3/1/u0x2 = #5604 */
    { 0x0d02, 0xb27d, 0xb8a2, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #114/3/1/u0x20 = #5605 */
    { 0x0e7f, 0xb27d, 0x3822, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #114/3/2/m = #5606 */
    { 0x0e00, 0xb27d, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0) }, /* #114/3/2/u = #5607 */
    { 0x0e22, 0xb27d, 0x3822, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #114/3/2/0x22 = #5608 */
    { 0x0e20, 0xb27d, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0) }, /* #114/3/2/u0x2 = #5609 */
    { 0x0e02, 0xb27d, 0xb8a2, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #114/3/2/u0x20 = #5610 */
    { 0x0f7f, 0xb27d, 0x3822, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #114/3/3/m = #5611 */
    { 0x0f00, 0xb27d, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0) }, /* #114/3/3/u = #5612 */
    { 0x0f22, 0xb27d, 0x3822, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #114/3/3/0x22 = #5613 */
    { 0x0f20, 0xb27d, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0) }, /* #114/3/3/u0x2 = #5614 */
    { 0x0f02, 0xb27d, 0xb8a2, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xd490cedc4ea7478d,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #114/3/3/u0x20 = #5615 */
    { 0x007f, 0x8674, 0x3e22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #115/0/0/m = #5616 */
    { 0x0000, 0x8674, 0xb482, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0) }, /* #115/0/0/u = #5617 */
    { 0x0022, 0x8674, 0x3e22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #115/0/0/0x22 = #5618 */
    { 0x0020, 0x8674, 0xb482, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0) }, /* #115/0/0/u0x2 = #5619 */
    { 0x0002, 0x8674, 0xbea2, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #115/0/0/u0x20 = #5620 */
    { 0x017f, 0x8674, 0x3e22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #115/0/1/m = #5621 */
    { 0x0100, 0x8674, 0xb482, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0) }, /* #115/0/1/u = #5622 */
    { 0x0122, 0x8674, 0x3e22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #115/0/1/0x22 = #5623 */
    { 0x0120, 0x8674, 0xb482, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0) }, /* #115/0/1/u0x2 = #5624 */
    { 0x0102, 0x8674, 0xbea2, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #115/0/1/u0x20 = #5625 */
    { 0x027f, 0x8674, 0x3e22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #115/0/2/m = #5626 */
    { 0x0200, 0x8674, 0xb482, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0) }, /* #115/0/2/u = #5627 */
    { 0x0222, 0x8674, 0x3e22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #115/0/2/0x22 = #5628 */
    { 0x0220, 0x8674, 0xb482, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0) }, /* #115/0/2/u0x2 = #5629 */
    { 0x0202, 0x8674, 0xbea2, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #115/0/2/u0x20 = #5630 */
    { 0x037f, 0x8674, 0x3e22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #115/0/3/m = #5631 */
    { 0x0300, 0x8674, 0xb482, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0) }, /* #115/0/3/u = #5632 */
    { 0x0322, 0x8674, 0x3e22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #115/0/3/0x22 = #5633 */
    { 0x0320, 0x8674, 0xb482, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0) }, /* #115/0/3/u0x2 = #5634 */
    { 0x0302, 0x8674, 0xbea2, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #115/0/3/u0x20 = #5635 */
    { 0x047f, 0x8674, 0x3c22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #115/1/0/m = #5636 */
    { 0x0400, 0x8674, 0xb482, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0) }, /* #115/1/0/u = #5637 */
    { 0x0422, 0x8674, 0x3c22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #115/1/0/0x22 = #5638 */
    { 0x0420, 0x8674, 0xb482, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0) }, /* #115/1/0/u0x2 = #5639 */
    { 0x0402, 0x8674, 0xbca2, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #115/1/0/u0x20 = #5640 */
    { 0x057f, 0x8674, 0x3c22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #115/1/1/m = #5641 */
    { 0x0500, 0x8674, 0xb482, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0) }, /* #115/1/1/u = #5642 */
    { 0x0522, 0x8674, 0x3c22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #115/1/1/0x22 = #5643 */
    { 0x0520, 0x8674, 0xb482, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0) }, /* #115/1/1/u0x2 = #5644 */
    { 0x0502, 0x8674, 0xbca2, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #115/1/1/u0x20 = #5645 */
    { 0x067f, 0x8674, 0x3c22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #115/1/2/m = #5646 */
    { 0x0600, 0x8674, 0xb482, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0) }, /* #115/1/2/u = #5647 */
    { 0x0622, 0x8674, 0x3c22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #115/1/2/0x22 = #5648 */
    { 0x0620, 0x8674, 0xb482, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0) }, /* #115/1/2/u0x2 = #5649 */
    { 0x0602, 0x8674, 0xbca2, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #115/1/2/u0x20 = #5650 */
    { 0x077f, 0x8674, 0x3c22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #115/1/3/m = #5651 */
    { 0x0700, 0x8674, 0xb482, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0) }, /* #115/1/3/u = #5652 */
    { 0x0722, 0x8674, 0x3c22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #115/1/3/0x22 = #5653 */
    { 0x0720, 0x8674, 0xb482, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0) }, /* #115/1/3/u0x2 = #5654 */
    { 0x0702, 0x8674, 0xbca2, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #115/1/3/u0x20 = #5655 */
    { 0x087f, 0x8674, 0x3e22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #115/2/0/m = #5656 */
    { 0x0800, 0x8674, 0xb482, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0) }, /* #115/2/0/u = #5657 */
    { 0x0822, 0x8674, 0x3e22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #115/2/0/0x22 = #5658 */
    { 0x0820, 0x8674, 0xb482, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0) }, /* #115/2/0/u0x2 = #5659 */
    { 0x0802, 0x8674, 0xbea2, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #115/2/0/u0x20 = #5660 */
    { 0x097f, 0x8674, 0x3e22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #115/2/1/m = #5661 */
    { 0x0900, 0x8674, 0xb482, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0) }, /* #115/2/1/u = #5662 */
    { 0x0922, 0x8674, 0x3e22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #115/2/1/0x22 = #5663 */
    { 0x0920, 0x8674, 0xb482, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0) }, /* #115/2/1/u0x2 = #5664 */
    { 0x0902, 0x8674, 0xbea2, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #115/2/1/u0x20 = #5665 */
    { 0x0a7f, 0x8674, 0x3e22, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xafc057039df3c15,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #115/2/2/m = #5666 */
    { 0x0a00, 0x8674, 0xb482, RTFLOAT80U_INIT_INF(0), R