---
template: overrides/main.html
title: Insiders
---

# Insiders

Material for MkDocs follows the __sponsorware__ release strategy, which means
that new features are first exclusively released to sponsors as part of
[Insiders]. Read on to learn [what sponsorships achieve],
[how to become a sponsor] to get access to Insiders, and
[what's in for you][available features]!

<figure class="mdx-video" markdown>
  <div class="mdx-video__inner">
    <iframe src="https://streamable.com/e/yslhdu" allowfullscreen></iframe>
  </div>
  <figcaption markdown>

This documentation is built with Insiders
[squidfunk.github.io/mkdocs-material][Material for MkDocs]

  </figcaption>
</figure>

  [Insiders]: #what-is-insiders
  [what sponsorships achieve]: #what-sponsorships-achieve
  [how to become a sponsor]: #how-to-become-a-sponsor
  [available features]: #available-features
  [Material for MkDocs]: https://squidfunk.github.io/mkdocs-material/

## What is Insiders?

Material for MkDocs Insiders is a private fork of Material for MkDocs, hosted as
a private GitHub repository. Almost[^1] all new features are developed as part of
this fork, which means that they are immediately available to all eligible
sponsors, as they are made collaborators of this repository.

  [^1]:
    In general, every new feature is first exclusively released to sponsors, but
    sometimes upstream dependencies like [Python Markdown Extensions] enhance
    existing features that must be supported by Material for MkDocs.

Every feature is tied to a [funding goal] in monthly subscriptions. When a
funding goal is hit, the features that are tied to it are merged back into
Material for MkDocs and released for general availability, making them available
to all users. Bugfixes are always released in tandem.

Sponsorships start as low as [__$10 a month__][how to become a sponsor].[^2]

  [^2]:
    Note that $10 a month is the minimum amount to become eligible for
    Insiders. While GitHub Sponsors also allows to sponsor lower amounts or
    one-time amounts, those can't be granted access to Insiders due to
    technical reasons.

  [Python Markdown Extensions]: https://facelessuser.github.io/pymdown-extensions/
  [funding goal]: #funding

## What sponsorships achieve

Sponsorships make this project sustainable, as they buy the maintainers of this
project time – a very scarce resource – which is spent on the development of new
features, bug fixing, stability improvement, issue triage and general support.
The biggest bottleneck in Open Source is time.[^3]

  [^3]:
    Making an Open Source project sustainable is exceptionally hard: maintainers
    burn out, projects are abandoned. That's not great and very unpredictable.
    The sponsorware model ensures that if you decide to use Material for MkDocs,
    you can be sure that bugs are fixed quickly and new features are added
    regularly.

If you're unsure if you should sponsor this project, check out the list of
[completed funding goals] to learn whether you're already using features that
were developed with the help of sponsorships. You're most likely using at least
a handful of them, [thanks to our awesome sponsors]!

  [completed funding goals]: #goals-completed
  [thanks to our awesome sponsors]: #how-to-become-a-sponsor

## How to become a sponsor

Thanks for your interest in sponsoring! In order to become an eligible sponsor
with your GitHub account, visit [squidfunk's sponsor profile], and complete
a sponsorship of __$10 a month or more__. You can use your individual or
organization GitHub account for sponsoring.

__Important__: If you're sponsoring @squidfunk through a GitHub organization,
please send a short email to sponsors@squidfunk.com with the name of your
organization and the GitHub account of the individual that should be added as a 
collaborator.[^4]

You can cancel your sponsorship anytime.[^5]

  [^4]:
    It's currently not possible to grant access to each member of an
    organization, as GitHub only allows for adding users. Thus, after
    sponsoring, please send an email to sponsors@squidfunk.com, stating which
    account should become a collaborator of the Insiders repository. We're
    working on a solution which will make access to organizations much simpler.
    To ensure that access is not tied to a particular individual GitHub account,
    create a bot account (i.e. a GitHub account that is not tied to a specific
    individual), and use this account for the sponsoring. After being added to
    the list of collaborators, the bot account can create a private fork of the
    private Insiders GitHub repository, and grant access to all members of the
    organizations.

  [^5]:
    If you cancel your sponsorship, GitHub schedules a cancellation request
    which will become effective at the end of the billing cycle. This means
    that even though you cancel your sponsorship, you will keep your access to
    Insiders as long as your cancellation isn't effective. All charges are
    processed by GitHub through Stripe. As we don't receive any information
    regarding your payment, and GitHub doesn't offer refunds, sponsorships are
    non-refundable.

[:octicons-heart-fill-24:{ .mdx-heart } &nbsp; Join our <span class="mdx-sponsorship-count" data-mdx-component="sponsorship-count"></span> awesome sponsors][squidfunk's sponsor profile]{ .md-button .md-button--primary .mdx-sponsorship-button }

<hr />

<div class="mdx-premium" markdown>

**Special thanks** to our **premium sponsors**:

[![Cirrus CI]](https://cirrus-ci.org/){ target=_blank title="Cirrus CI" }
[![Basler]](https://docs.baslerweb.com/){ target=_blank title="Basler" }
[![Hummingbot]](https://hummingbot.io/){ target=_blank title="Hummingbot" }
[![KX]](https://kx.com/){ target=_blank title="KX Systems" }
[![Manticore Games]](https://www.manticoregames.com/){ target=_blank title="Manticore Games" }
[![Account technologies]](https://www.accounttechnologies.com/){ target=_blank title="Account technologies" }
[![Prefect]](https://orion-docs.prefect.io/){ target=_blank title="Prefect" }
[![Datadog]](https://datadoghq.com/){ target=_blank title="Datadog" }
[![Zenoss]](https://zenoss.com/){ target=_blank title="Zenoss" }
[![Elli]](https://www.elli.eco/en/home){ target=_blank title="Elli - A Brand of the Volkswagen Group" }
[![RStudio]](https://solutions.rstudio.com){ target=_blank title="RStudio" }
[![n8n]](https://n8n.io){ target=_blank title="n8n" }

</div>

  [Cirrus CI]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-cirrus-ci.png
  [Basler]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-basler.png
  [Hummingbot]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-hummingbot.png
  [KX]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-kx.png
  [Manticore Games]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-manticore-games.png
  [Account technologies]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-account-technologies.png
  [Prefect]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-prefect.png
  [Datadog]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-datadog.png
  [Zenoss]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-zenoss.png
  [Elli]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-elli.png
  [RStudio]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-rstudio.png
  [n8n]: https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-n8n.png

<hr />

<div class="mdx-sponsorship" data-mdx-component="sponsorship" hidden>
  <div class="mdx-sponsorship__list"></div>
  <small>
    If you sponsor publicly, you're automatically added here with a link to
    your profile and avatar to show your support for Material for MkDocs.
    Alternatively, if you wish to keep your sponsorship private, you'll be a
    silent +1. You can select visibility during checkout and change it
    afterwards.
  </small>
</div>

  [squidfunk's sponsor profile]: https://github.com/sponsors/squidfunk

## Available features

The following features are solely available via Material for MkDocs Insiders:

<div class="mdx-columns" markdown>

- [x] [Card grids] :material-new-box:
- [x] [Offline plugin] :material-new-box:
- [x] [Privacy plugin]
- [x] [Table of contents anchor following]
- [x] [Annotations]
- [x] [Navigation icons]
- [x] [Code annotations: anchor links]
- [x] [Code annotations: strip comments]
- [x] [Dismissable announcement bar]
- [x] [Was this page helpful?]
- [x] [Brand new search plugin]
- [x] [Rich search previews]
- [x] [Tokenizer with lookahead]
- [x] [Advanced search highlighting]
- [x] [Excluding content from search]
- [x] [Social cards]
- [x] [Cookie consent]
- [x] [Linking content tabs]
- [x] [Boosting pages in search]
- [x] [Custom admonition icons]

</div>

## Funding <span class="mdx-sponsorship-total" data-mdx-component="sponsorship-total"></span>

### Goals

The following section lists all funding goals. Each goal contains a list of
features prefixed with a checkmark symbol, denoting whether a feature is
:octicons-check-circle-fill-24:{ style="color: #00e676" } already available or 
:octicons-check-circle-fill-24:{ style="color: var(--md-default-fg-color--lightest)" } planned, but not yet implemented. When the funding goal is hit, the features
are released for general availability.

#### $ 6,000 – Trinidad Scorpion

- [x] [Boosting pages in search]
- [x] [Custom admonition icons]
- [x] [Linking content tabs]

  [Boosting pages in search]: ../setup/setting-up-site-search.md#search-boosting
  [Custom admonition icons]: ../reference/admonitions.md#admonition-icons
  [Linking content tabs]: ../reference/content-tabs.md#linked-content-tabs

#### $ 7,000 – Royal Gold

- [x] [Cookie consent]
- [x] [Was this page helpful?]
- [x] [Dismissable announcement bar]

  [Cookie consent]: ../setup/ensuring-data-privacy.md#cookie-consent
  [Was this page helpful?]: ../setup/setting-up-site-analytics.md#was-this-page-helpful
  [Dismissable announcement bar]: ../setup/setting-up-the-header.md#mark-as-read

#### $ 8,000 – Scotch Bonnet

- [x] [Social cards]
- [x] [Code annotations: anchor links]
- [x] [Code annotations: strip comments]
- [x] [Table of contents anchor following]
- [x] Sidebars automatically scroll to active item
- [ ] Stay on page when switching languages

  [Social cards]: ../setup/setting-up-social-cards.md
  [Code annotations: anchor links]: ../reference/code-blocks.md#anchor-links
  [Code annotations: strip comments]: ../reference/code-blocks.md#stripping-comments
  [Table of contents anchor following]: ../setup/setting-up-navigation.md#anchor-following

#### $ 10,000 – Carolina Reaper

- [x] [Brand new search plugin]
- [x] [Rich search previews]
- [x] [Tokenizer with lookahead]
- [x] [Advanced search highlighting]
- [x] [Excluding content from search]
- [x] [Offline plugin]

  [Brand new search plugin]: ../blog/2021/search-better-faster-smaller.md
  [Rich search previews]: ../blog/2021/search-better-faster-smaller.md#rich-search-previews
  [Tokenizer with lookahead]: ../blog/2021/search-better-faster-smaller.md#tokenizer-lookahead
  [Advanced search highlighting]: ../blog/2021/search-better-faster-smaller.md#accurate-highlighting
  [Excluding content from search]: ../setup/setting-up-site-search.md#search-exclusion
  [Offline plugin]: ../setup/building-for-offline-usage.md

#### $ 12,000 – Piri Piri

- [x] [Annotations]
- [x] [Navigation icons]
- [ ] Navigation status badges
- [ ] Navigation pruning
- [ ] Blog

  [Annotations]: ../reference/annotations.md
  [Navigation icons]: ../reference/index.md#setting-the-page-icon

#### $ 14,000 – Goat's Horn

- [x] [Privacy plugin]
- [x] [Card grids]
- [ ] [Instant previews]
- [ ] and much more, to be announced ...

  [Privacy plugin]: ../setup/ensuring-data-privacy.md
  [Card grids]: ../reference/grids.md
  [Instant previews]: https://twitter.com/squidfunk/status/1466794654213492743

### Goals completed

This section lists all funding goals that were previously completed, which means
that those features were part of Insiders, but are now generally available and
can be used by all users.

#### $ 5,000 – Aji Panca

- [x] [Mermaid.js integration]
- [x] Stay on page when switching versions
- [x] [Tags with search integration]

  [Mermaid.js integration]: ../reference/diagrams.md
  [Tags with search integration]: ../setup/setting-up-tags.md

#### $ 4,000 – Ghost Pepper

- [x] [Anchor tracking]
- [x] [Code annotations]
- [x] [Version warning]

  [Anchor tracking]: ../setup/setting-up-navigation.md#anchor-tracking
  [Code annotations]: ../reference/code-blocks.md#adding-annotations
  [Version warning]: ../setup/setting-up-versioning.md#version-warning

#### $ 3,000 – Caribbean Red

- [x] [Sticky navigation tabs]
- [x] [Section index pages]
- [x] [Remove generator notice]

  [Sticky navigation tabs]: ../setup/setting-up-navigation.md#sticky-navigation-tabs
  [Section index pages]: ../setup/setting-up-navigation.md#section-index-pages
  [Remove generator notice]: ../setup/setting-up-the-footer.md#generator-notice

#### $ 2,500 – Biquinho Vermelho

- [x] [Search suggestions]
- [x] [Search highlighting]
- [x] [Search sharing]

  [Search suggestions]: ../setup/setting-up-site-search.md#search-suggestions
  [Search highlighting]: ../setup/setting-up-site-search.md#search-highlighting
  [Search sharing]: ../setup/setting-up-site-search.md#search-sharing

#### $ 2,000 – Black Pearl

- [x] Latest release tag
- [x] [Color palette toggle]
- [x] [Back-to-top button]

  [Color palette toggle]: ../setup/changing-the-colors.md#color-palette-toggle
  [Back-to-top button]: ../setup/setting-up-navigation.md#back-to-top-button

#### $ 1,500 – Bhut Jolokia

- [x] [Admonition inline blocks]
- [x] [Site language selection]
- [x] [Versioning]

  [Admonition inline blocks]: ../reference/admonitions.md#inline-blocks
  [Site language selection]: ../setup/changing-the-language.md#site-language-selector
  [Versioning]: ../setup/setting-up-versioning.md#versioning

#### $ 1,000 – Prairie Fire

- [x] [Navigation sections]
- [x] [Navigation expansion]
- [x] [Hiding the sidebars]
- [x] [Table of contents in navigation]
- [x] [Header hides on scroll]

  [Navigation sections]: ../setup/setting-up-navigation.md#navigation-sections
  [Navigation expansion]: ../setup/setting-up-navigation.md#navigation-expansion
  [Hiding the sidebars]: ../setup/setting-up-navigation.md#hiding-the-sidebars
  [Table of contents in navigation]: ../setup/setting-up-navigation.md#navigation-integration
  [Header hides on scroll]: ../setup/setting-up-the-header.md#automatic-hiding

#### $ 500 – Madame Jeanette

- [x] Improved search result grouping
- [x] Improved search result relevance and scoring
- [x] Missing query terms in search results

## Frequently asked questions

### Compatibility

_We're running an open source project and want to make sure that users can
change and build the documentation without having access to Insiders. Is this
still possible?_

Yes. Insiders is compatible with Material for MkDocs. Almost all new features
are implemented behind feature flags; almost all configuration changes are 
backward-compatible. This means that developers will be able to build the
documentation locally with Material for MkDocs and when they push their changes,
it can be built with Insiders (e.g. as part of GitHub Actions).

When using built-in plugins that are solely available via Insiders, it might be 
necessary to split the `mkdocs.yml` configuration into a base configuration, and
one with plugin overrides. Note that this is a limitation of MkDocs, which can
be mitigated by using [configuration inheritance].

See the [getting started guide] for more information.

  [configuration inheritance]: https://www.mkdocs.org/user-guide/configuration/#configuration-inheritance
  [getting started guide]: getting-started.md#caveats

### Payment

_We don't want to pay for sponsorship every month. Are there any other options?_

Yes. You can sponsor on a yearly basis by [switching your GitHub account to a
yearly billing cycle][billing cycle]. If for some reason you cannot do that, you
could also create a dedicated GitHub account with a yearly billing cycle, which
you only use for sponsoring (some sponsors already do that).

If you have any problems or further questions, please reach out to
sponsors@squidfunk.com.

  [billing cycle]: https://docs.github.com/en/github/setting-up-and-managing-billing-and-payments-on-github/changing-the-duration-of-your-billing-cycle

### Terms

_Are we allowed to use Insiders under the same terms and conditions as
Material for MkDocs?_

Yes. Whether you're an individual or a company, you may use _Material for MkDocs
Insiders_ precisely under the same terms as Material for MkDocs, which are given
by the [MIT license]. However, we kindly ask you to respect the following
guidelines:

- Please __don't distribute the source code__ of Insiders. You may freely use
  it for public, private or commercial projects, privately fork or mirror it,
  but please don't make the source code public, as it would counteract the 
  sponsorware strategy.

- If you cancel your subscription, you're automatically removed as a
  collaborator and will miss out on all future updates of Insiders. However, you
  may __use the latest version__ that's available to you __as long as you like__.
  Just remember that [GitHub deletes private forks].

  [MIT license]: ../license.md
  [GitHub deletes private forks]: https://docs.github.com/en/github/setting-up-and-managing-your-github-user-account/removing-a-collaborator-from-a-personal-repository
