/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jmock.core.Formatting;
import org.jmock.core.SelfDescribing;

public class Invocation
implements SelfDescribing {
    public final Object invokedObject;
    public final Method invokedMethod;
    public final List parameterValues;

    public Invocation(Object object, Method method, Object[] objectArray) {
        this.invokedObject = object;
        this.invokedMethod = method;
        this.parameterValues = objectArray == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(Arrays.asList(objectArray));
    }

    public String toString() {
        return this.describeTo(new StringBuffer()).toString();
    }

    public boolean equals(Object object) {
        return object instanceof Invocation && this.equals((Invocation)object);
    }

    public boolean equals(Invocation invocation) {
        return invocation != null && this.invokedObject == invocation.invokedObject && this.invokedMethod.equals(invocation.invokedMethod) && ((Object)this.parameterValues).equals(invocation.parameterValues);
    }

    public int hashCode() {
        return this.invokedObject.hashCode() ^ this.invokedMethod.hashCode() ^ ((Object)this.parameterValues).hashCode();
    }

    public StringBuffer describeTo(StringBuffer stringBuffer) {
        stringBuffer.append(this.invokedMethod.getDeclaringClass().getName());
        stringBuffer.append(".");
        stringBuffer.append(this.invokedMethod.getName());
        Formatting.join(this.parameterValues, stringBuffer, "(", ")");
        return stringBuffer;
    }
}

