/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import org.joda.time.MutablePeriod;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadWritablePeriod;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.FormatUtils;
import org.joda.time.format.PeriodParser;
import org.joda.time.format.PeriodPrinter;

public class PeriodFormatter {
    private final PeriodPrinter iPrinter;
    private final PeriodParser iParser;
    private final Locale iLocale;
    private final PeriodType iParseType;

    public PeriodFormatter(PeriodPrinter printer, PeriodParser parser) {
        this.iPrinter = printer;
        this.iParser = parser;
        this.iLocale = null;
        this.iParseType = null;
    }

    private PeriodFormatter(PeriodPrinter printer, PeriodParser parser, Locale locale, PeriodType type) {
        this.iPrinter = printer;
        this.iParser = parser;
        this.iLocale = locale;
        this.iParseType = type;
    }

    public boolean isPrinter() {
        return this.iPrinter != null;
    }

    public PeriodPrinter getPrinter() {
        return this.iPrinter;
    }

    public boolean isParser() {
        return this.iParser != null;
    }

    public PeriodParser getParser() {
        return this.iParser;
    }

    public PeriodFormatter withLocale(Locale locale) {
        if (locale == this.getLocale() || locale != null && locale.equals(this.getLocale())) {
            return this;
        }
        return new PeriodFormatter(this.iPrinter, this.iParser, locale, this.iParseType);
    }

    public Locale getLocale() {
        return this.iLocale;
    }

    public PeriodFormatter withParseType(PeriodType type) {
        if (type == this.iParseType) {
            return this;
        }
        return new PeriodFormatter(this.iPrinter, this.iParser, this.iLocale, type);
    }

    public PeriodType getParseType() {
        return this.iParseType;
    }

    public void printTo(StringBuffer buf, ReadablePeriod period) {
        this.checkPrinter();
        this.checkPeriod(period);
        this.getPrinter().printTo(buf, period, this.iLocale);
    }

    public void printTo(Writer out, ReadablePeriod period) throws IOException {
        this.checkPrinter();
        this.checkPeriod(period);
        this.getPrinter().printTo(out, period, this.iLocale);
    }

    public String print(ReadablePeriod period) {
        this.checkPrinter();
        this.checkPeriod(period);
        PeriodPrinter printer = this.getPrinter();
        StringBuffer buf = new StringBuffer(printer.calculatePrintedLength(period, this.iLocale));
        printer.printTo(buf, period, this.iLocale);
        return buf.toString();
    }

    private void checkPrinter() {
        if (this.iPrinter == null) {
            throw new UnsupportedOperationException("Printing not supported");
        }
    }

    private void checkPeriod(ReadablePeriod period) {
        if (period == null) {
            throw new IllegalArgumentException("Period must not be null");
        }
    }

    public int parseInto(ReadWritablePeriod period, String text, int position) {
        this.checkParser();
        this.checkPeriod(period);
        return this.getParser().parseInto(period, text, position, this.iLocale);
    }

    public Period parsePeriod(String text) {
        this.checkParser();
        return this.parseMutablePeriod(text).toPeriod();
    }

    public MutablePeriod parseMutablePeriod(String text) {
        this.checkParser();
        MutablePeriod period = new MutablePeriod(0L, this.iParseType);
        int newPos = this.getParser().parseInto(period, text, 0, this.iLocale);
        if (newPos >= 0) {
            if (newPos >= text.length()) {
                return period;
            }
        } else {
            newPos ^= 0xFFFFFFFF;
        }
        throw new IllegalArgumentException(FormatUtils.createErrorMessage(text, newPos));
    }

    private void checkParser() {
        if (this.iParser == null) {
            throw new UnsupportedOperationException("Parsing not supported");
        }
    }
}

