/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.util.Arrays;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;

public class DateTimeParserBucket {
    private final Chronology iChrono;
    private final long iMillis;
    private DateTimeZone iZone;
    private int iOffset;
    private Locale iLocale;
    private Integer iPivotYear;
    private SavedField[] iSavedFields = new SavedField[8];
    private int iSavedFieldsCount;
    private boolean iSavedFieldsShared;
    private Object iSavedState;

    public DateTimeParserBucket(long instantLocal, Chronology chrono, Locale locale) {
        this(instantLocal, chrono, locale, null);
    }

    public DateTimeParserBucket(long instantLocal, Chronology chrono, Locale locale, Integer pivotYear) {
        chrono = DateTimeUtils.getChronology(chrono);
        this.iMillis = instantLocal;
        this.iChrono = chrono.withUTC();
        this.iLocale = locale == null ? Locale.getDefault() : locale;
        this.setZone(chrono.getZone());
        this.iPivotYear = pivotYear;
    }

    public Chronology getChronology() {
        return this.iChrono;
    }

    public Locale getLocale() {
        return this.iLocale;
    }

    public DateTimeZone getZone() {
        return this.iZone;
    }

    public void setZone(DateTimeZone zone) {
        this.iSavedState = null;
        this.iZone = zone == DateTimeZone.UTC ? null : zone;
        this.iOffset = 0;
    }

    public int getOffset() {
        return this.iOffset;
    }

    public void setOffset(int offset) {
        this.iSavedState = null;
        this.iOffset = offset;
        this.iZone = null;
    }

    public Integer getPivotYear() {
        return this.iPivotYear;
    }

    public void setPivotYear(Integer pivotYear) {
        this.iPivotYear = pivotYear;
    }

    public void saveField(DateTimeField field, int value) {
        this.saveField(new SavedField(field, value));
    }

    public void saveField(DateTimeFieldType fieldType, int value) {
        this.saveField(new SavedField(fieldType.getField(this.iChrono), value));
    }

    public void saveField(DateTimeFieldType fieldType, String text, Locale locale) {
        this.saveField(new SavedField(fieldType.getField(this.iChrono), text, locale));
    }

    private void saveField(SavedField field) {
        int savedFieldsCount = this.iSavedFieldsCount;
        SavedField[] savedFields = this.iSavedFields;
        if (savedFieldsCount == savedFields.length || this.iSavedFieldsShared) {
            SavedField[] newArray = new SavedField[savedFieldsCount == savedFields.length ? savedFieldsCount * 2 : savedFields.length];
            System.arraycopy(savedFields, 0, newArray, 0, savedFieldsCount);
            savedFields = newArray;
            this.iSavedFields = newArray;
            this.iSavedFieldsShared = false;
        }
        this.iSavedState = null;
        savedFields[savedFieldsCount] = field;
        this.iSavedFieldsCount = savedFieldsCount + 1;
    }

    public Object saveState() {
        if (this.iSavedState == null) {
            this.iSavedState = new SavedState();
        }
        return this.iSavedState;
    }

    public boolean restoreState(Object savedState) {
        if (savedState instanceof SavedState && ((SavedState)savedState).restoreState(this)) {
            this.iSavedState = savedState;
            return true;
        }
        return false;
    }

    public long computeMillis() {
        return this.computeMillis(false);
    }

    public long computeMillis(boolean resetFields) {
        Comparable[] savedFields = this.iSavedFields;
        int count = this.iSavedFieldsCount;
        if (this.iSavedFieldsShared) {
            savedFields = (SavedField[])this.iSavedFields.clone();
            this.iSavedFields = savedFields;
            this.iSavedFieldsShared = false;
        }
        DateTimeParserBucket.sort(savedFields, count);
        long millis = this.iMillis;
        int i = 0;
        while (i < count) {
            millis = ((SavedField)savedFields[i]).set(millis, resetFields);
            ++i;
        }
        if (this.iZone == null) {
            millis -= (long)this.iOffset;
        } else {
            int offset = this.iZone.getOffsetFromLocal(millis);
            if (offset != this.iZone.getOffset(millis -= (long)offset)) {
                throw new IllegalArgumentException("Illegal instant due to time zone offset transition");
            }
        }
        return millis;
    }

    private static void sort(Comparable[] array, int high) {
        if (high > 10) {
            Arrays.sort(array, 0, high);
        } else {
            int i = 0;
            while (i < high) {
                int j = i;
                while (j > 0 && array[j - 1].compareTo(array[j]) > 0) {
                    Comparable t = array[j];
                    array[j] = array[j - 1];
                    array[j - 1] = t;
                    --j;
                }
                ++i;
            }
        }
    }

    static /* synthetic */ SavedField[] access$202(DateTimeParserBucket x0, SavedField[] x1) {
        x0.iSavedFields = x1;
        return x1;
    }

    static class SavedField
    implements Comparable {
        final DateTimeField iField;
        final int iValue;
        final String iText;
        final Locale iLocale;

        SavedField(DateTimeField field, int value) {
            this.iField = field;
            this.iValue = value;
            this.iText = null;
            this.iLocale = null;
        }

        SavedField(DateTimeField field, String text, Locale locale) {
            this.iField = field;
            this.iValue = 0;
            this.iText = text;
            this.iLocale = locale;
        }

        long set(long millis, boolean reset) {
            millis = this.iText == null ? this.iField.set(millis, this.iValue) : this.iField.set(millis, this.iText, this.iLocale);
            if (reset) {
                millis = this.iField.roundFloor(millis);
            }
            return millis;
        }

        public int compareTo(Object obj) {
            DateTimeField other = ((SavedField)obj).iField;
            int result = this.compareReverse(this.iField.getRangeDurationField(), other.getRangeDurationField());
            if (result != 0) {
                return result;
            }
            return this.compareReverse(this.iField.getDurationField(), other.getDurationField());
        }

        private int compareReverse(DurationField a, DurationField b) {
            if (a == null || !a.isSupported()) {
                if (b == null || !b.isSupported()) {
                    return 0;
                }
                return -1;
            }
            if (b == null || !b.isSupported()) {
                return 1;
            }
            return -a.compareTo(b);
        }
    }

    class SavedState {
        final DateTimeZone iZone;
        final int iOffset;
        final SavedField[] iSavedFields;
        final int iSavedFieldsCount;

        SavedState() {
            this.iZone = DateTimeParserBucket.this.iZone;
            this.iOffset = DateTimeParserBucket.this.iOffset;
            this.iSavedFields = DateTimeParserBucket.this.iSavedFields;
            this.iSavedFieldsCount = DateTimeParserBucket.this.iSavedFieldsCount;
        }

        boolean restoreState(DateTimeParserBucket enclosing) {
            if (enclosing != DateTimeParserBucket.this) {
                return false;
            }
            enclosing.iZone = this.iZone;
            enclosing.iOffset = this.iOffset;
            DateTimeParserBucket.access$202(enclosing, this.iSavedFields);
            if (this.iSavedFieldsCount < enclosing.iSavedFieldsCount) {
                enclosing.iSavedFieldsShared = true;
            }
            enclosing.iSavedFieldsCount = this.iSavedFieldsCount;
            return true;
        }
    }
}

