/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import java.io.Serializable;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;

public class DelegatedDurationField
extends DurationField
implements Serializable {
    private static final long serialVersionUID = -5576443481242007829L;
    private final DurationField iField;
    private final DurationFieldType iType;

    protected DelegatedDurationField(DurationField field) {
        this(field, null);
    }

    protected DelegatedDurationField(DurationField field, DurationFieldType type) {
        if (field == null) {
            throw new IllegalArgumentException("The field must not be null");
        }
        this.iField = field;
        this.iType = type == null ? field.getType() : type;
    }

    public final DurationField getWrappedField() {
        return this.iField;
    }

    public DurationFieldType getType() {
        return this.iType;
    }

    public String getName() {
        return this.iType.getName();
    }

    public boolean isSupported() {
        return this.iField.isSupported();
    }

    public boolean isPrecise() {
        return this.iField.isPrecise();
    }

    public int getValue(long duration) {
        return this.iField.getValue(duration);
    }

    public long getValueAsLong(long duration) {
        return this.iField.getValueAsLong(duration);
    }

    public int getValue(long duration, long instant) {
        return this.iField.getValue(duration, instant);
    }

    public long getValueAsLong(long duration, long instant) {
        return this.iField.getValueAsLong(duration, instant);
    }

    public long getMillis(int value) {
        return this.iField.getMillis(value);
    }

    public long getMillis(long value) {
        return this.iField.getMillis(value);
    }

    public long getMillis(int value, long instant) {
        return this.iField.getMillis(value, instant);
    }

    public long getMillis(long value, long instant) {
        return this.iField.getMillis(value, instant);
    }

    public long add(long instant, int value) {
        return this.iField.add(instant, value);
    }

    public long add(long instant, long value) {
        return this.iField.add(instant, value);
    }

    public int getDifference(long minuendInstant, long subtrahendInstant) {
        return this.iField.getDifference(minuendInstant, subtrahendInstant);
    }

    public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
        return this.iField.getDifferenceAsLong(minuendInstant, subtrahendInstant);
    }

    public long getUnitMillis() {
        return this.iField.getUnitMillis();
    }

    public int compareTo(Object durationField) {
        return this.iField.compareTo(durationField);
    }

    public String toString() {
        return this.iType == null ? this.iField.toString() : "DurationField[" + this.iType + ']';
    }
}

