/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import java.util.Date;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public abstract class AbstractInstant
implements ReadableInstant {
    protected AbstractInstant() {
    }

    public DateTimeZone getZone() {
        return this.getChronology().getZone();
    }

    public int get(DateTimeFieldType type) {
        if (type == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        return type.getField(this.getChronology()).get(this.getMillis());
    }

    public boolean isSupported(DateTimeFieldType type) {
        if (type == null) {
            return false;
        }
        return type.getField(this.getChronology()).isSupported();
    }

    public int get(DateTimeField field) {
        if (field == null) {
            throw new IllegalArgumentException("The DateTimeField must not be null");
        }
        return field.get(this.getMillis());
    }

    public Instant toInstant() {
        return new Instant(this.getMillis());
    }

    public DateTime toDateTime() {
        return new DateTime(this.getMillis(), this.getZone());
    }

    public DateTime toDateTimeISO() {
        return new DateTime(this.getMillis(), (Chronology)ISOChronology.getInstance(this.getZone()));
    }

    public DateTime toDateTime(DateTimeZone zone) {
        Chronology chrono = DateTimeUtils.getChronology(this.getChronology());
        chrono = chrono.withZone(zone);
        return new DateTime(this.getMillis(), chrono);
    }

    public DateTime toDateTime(Chronology chronology) {
        return new DateTime(this.getMillis(), chronology);
    }

    public MutableDateTime toMutableDateTime() {
        return new MutableDateTime(this.getMillis(), this.getZone());
    }

    public MutableDateTime toMutableDateTimeISO() {
        return new MutableDateTime(this.getMillis(), (Chronology)ISOChronology.getInstance(this.getZone()));
    }

    public MutableDateTime toMutableDateTime(DateTimeZone zone) {
        Chronology chrono = DateTimeUtils.getChronology(this.getChronology());
        chrono = chrono.withZone(zone);
        return new MutableDateTime(this.getMillis(), chrono);
    }

    public MutableDateTime toMutableDateTime(Chronology chronology) {
        return new MutableDateTime(this.getMillis(), chronology);
    }

    public Date toDate() {
        return new Date(this.getMillis());
    }

    public boolean equals(Object readableInstant) {
        if (this == readableInstant) {
            return true;
        }
        if (readableInstant instanceof ReadableInstant) {
            ReadableInstant otherInstant = (ReadableInstant)readableInstant;
            if (this.getMillis() == otherInstant.getMillis()) {
                Chronology chrono = this.getChronology();
                if (chrono == otherInstant.getChronology()) {
                    return true;
                }
                if (chrono != null && chrono.equals(otherInstant.getChronology())) {
                    return true;
                }
            }
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.getMillis() ^ this.getMillis() >>> 32) + this.getChronology().hashCode();
    }

    public int compareTo(Object instant) {
        if (this == instant) {
            return 0;
        }
        ReadableInstant otherInstant = (ReadableInstant)instant;
        long otherMillis = otherInstant.getMillis();
        long thisMillis = this.getMillis();
        if (thisMillis == otherMillis) {
            return 0;
        }
        if (thisMillis < otherMillis) {
            return -1;
        }
        return 1;
    }

    public boolean isAfter(long instant) {
        return this.getMillis() > instant;
    }

    public boolean isAfterNow() {
        return this.isAfter(DateTimeUtils.currentTimeMillis());
    }

    public boolean isAfter(ReadableInstant instant) {
        long instantMillis = DateTimeUtils.getInstantMillis(instant);
        return this.isAfter(instantMillis);
    }

    public boolean isBefore(long instant) {
        return this.getMillis() < instant;
    }

    public boolean isBeforeNow() {
        return this.isBefore(DateTimeUtils.currentTimeMillis());
    }

    public boolean isBefore(ReadableInstant instant) {
        long instantMillis = DateTimeUtils.getInstantMillis(instant);
        return this.isBefore(instantMillis);
    }

    public boolean isEqual(long instant) {
        return this.getMillis() == instant;
    }

    public boolean isEqualNow() {
        return this.isEqual(DateTimeUtils.currentTimeMillis());
    }

    public boolean isEqual(ReadableInstant instant) {
        long instantMillis = DateTimeUtils.getInstantMillis(instant);
        return this.isEqual(instantMillis);
    }

    public String toString() {
        return ISODateTimeFormat.dateTime().print(this);
    }

    public String toString(DateTimeFormatter formatter) {
        if (formatter == null) {
            return this.toString();
        }
        return formatter.print(this);
    }

    public abstract Chronology getChronology();

    public abstract long getMillis();
}

