/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DelegateAction
extends AbstractAction {
    private Action _action;
    private JComponent _target;

    public DelegateAction() {
    }

    public DelegateAction(Action action) {
        this._action = action;
    }

    public DelegateAction(Action action, JComponent jComponent) {
        this._action = action;
        this._target = jComponent;
    }

    @Override
    public boolean isEnabled() {
        return this.isDelegateEnabled() || this._action != null && this._action.isEnabled();
    }

    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        if (!this.delegateActionPerformed(actionEvent) && this._action != null) {
            if (this._target == null) {
                this._action.actionPerformed(actionEvent);
            } else {
                this._action.actionPerformed(new ActionEvent(this.getTarget(), actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getWhen(), actionEvent.getModifiers()));
            }
        }
    }

    protected Action getAction() {
        return this._action;
    }

    protected void setAction(Action action) {
        this._action = action;
    }

    protected JComponent getTarget() {
        return this._target;
    }

    protected void setTarget(JComponent jComponent) {
        this._target = jComponent;
    }

    public boolean isDelegateEnabled() {
        return super.isEnabled();
    }

    public abstract boolean delegateActionPerformed(ActionEvent var1);

    public static void replaceAction(JComponent jComponent, int n, KeyStroke keyStroke, DelegateAction delegateAction) {
        DelegateAction.replaceAction(jComponent, n, jComponent, n, keyStroke, delegateAction);
    }

    public static void replaceAction(JComponent jComponent, int n, KeyStroke keyStroke, DelegateAction delegateAction, boolean bl) {
        DelegateAction.replaceAction(jComponent, n, jComponent, n, keyStroke, delegateAction, bl);
    }

    public static void replaceAction(JComponent jComponent, int n, JComponent jComponent2, int n2, KeyStroke keyStroke) {
        DelegateAction.replaceAction(jComponent, n, jComponent2, n2, keyStroke, new PassthroughDelegateAction(), false);
    }

    public static void replaceAction(JComponent jComponent, int n, JComponent jComponent2, int n2, KeyStroke keyStroke, DelegateAction delegateAction) {
        DelegateAction.replaceAction(jComponent, n, jComponent2, n2, keyStroke, delegateAction, false);
    }

    public static void replaceAction(JComponent jComponent, int n, JComponent jComponent2, int n2, KeyStroke keyStroke, DelegateAction delegateAction, boolean bl) {
        Object object = jComponent2.getInputMap(n2).get(keyStroke);
        if (object != null) {
            Action action = jComponent2.getActionMap().get(object);
            if (action != delegateAction) {
                if (!bl && action instanceof DelegateAction) {
                    delegateAction.setAction(((DelegateAction)action).getAction());
                    ((DelegateAction)action).setAction(delegateAction);
                    delegateAction = (DelegateAction)action;
                } else {
                    delegateAction.setAction(action);
                }
                if (jComponent2 != jComponent) {
                    delegateAction.setTarget(jComponent2);
                    DelegateAction.replaceAction(jComponent, n, keyStroke, delegateAction);
                } else {
                    jComponent.getActionMap().put(object, delegateAction);
                }
            }
        } else if (jComponent2 != jComponent) {
            delegateAction.setTarget(jComponent2);
            DelegateAction.replaceAction(jComponent, n, keyStroke, delegateAction);
        } else {
            jComponent.registerKeyboardAction(delegateAction, keyStroke, n);
        }
    }

    public static void restoreAction(JComponent jComponent, int n, KeyStroke keyStroke) {
        if (jComponent == null) {
            return;
        }
        ActionListener actionListener = jComponent.getActionForKeyStroke(keyStroke);
        if (actionListener instanceof DelegateAction) {
            jComponent.registerKeyboardAction(((DelegateAction)actionListener).getAction(), keyStroke, n);
        }
    }

    public static void restoreAction(JComponent jComponent, int n, KeyStroke keyStroke, Class<?> clazz) {
        ActionListener actionListener;
        ActionListener actionListener2 = actionListener = jComponent.getActionForKeyStroke(keyStroke);
        ActionListener actionListener3 = actionListener;
        while (actionListener instanceof DelegateAction) {
            if (clazz.isAssignableFrom(actionListener.getClass())) {
                if (actionListener3 == actionListener) {
                    jComponent.registerKeyboardAction(((DelegateAction)actionListener).getAction(), keyStroke, n);
                    break;
                }
                ((DelegateAction)actionListener2).setAction(((DelegateAction)actionListener).getAction());
                break;
            }
            actionListener2 = actionListener;
            actionListener = ((DelegateAction)actionListener).getAction();
        }
    }

    public static void restoreAction(JComponent jComponent, int n, KeyStroke keyStroke, Action action) {
        ActionListener actionListener;
        ActionListener actionListener2 = actionListener = jComponent.getActionForKeyStroke(keyStroke);
        ActionListener actionListener3 = actionListener;
        while (actionListener instanceof DelegateAction) {
            if (action == actionListener) {
                if (actionListener3 == actionListener) {
                    jComponent.registerKeyboardAction(((DelegateAction)actionListener).getAction(), keyStroke, n);
                    break;
                }
                ((DelegateAction)actionListener2).setAction(((DelegateAction)actionListener).getAction());
                break;
            }
            actionListener2 = actionListener;
            actionListener = ((DelegateAction)actionListener).getAction();
        }
    }

    public static class PassthroughDelegateAction
    extends DelegateAction {
        private static final long serialVersionUID = -1555177105658867899L;

        public boolean delegateActionPerformed(ActionEvent actionEvent) {
            return false;
        }

        public boolean isDelegateEnabled() {
            return false;
        }
    }
}

