/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.eclipse;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;

public class EclipseUtils {
    private static final BasicStroke DOTTED_STROKE = new BasicStroke(1.0f, 2, 1, 1.0f, new float[]{0.0f, 2.0f, 0.0f, 2.0f}, 0.0f);
    static final double RATIO1 = 0.67;
    static final double RATIO2 = 0.78;
    static final double RATIO3 = 0.86;

    static Color getLighterColor(Color color) {
        int n = EclipseUtils.getLighterColor(color.getRed());
        int n2 = EclipseUtils.getLighterColor(color.getGreen());
        int n3 = EclipseUtils.getLighterColor(color.getBlue());
        if (n >= 255) {
            n = 255;
        }
        if (n2 >= 255) {
            n2 = 255;
        }
        if (n3 >= 255) {
            n3 = 255;
        }
        return new Color(n, n2, n3);
    }

    static int getLighterColor(int n) {
        return (int)((double)n * 36.0 / 255.0 + 219.5);
    }

    static Color getMenuSelectionColor(Color color) {
        int n = EclipseUtils.getMenuSelectionValue(color.getRed());
        int n2 = EclipseUtils.getMenuSelectionValue(color.getGreen());
        int n3 = EclipseUtils.getMenuSelectionValue(color.getBlue());
        if (n >= 255) {
            n = 255;
        }
        if (n2 >= 255) {
            n2 = 255;
        }
        if (n3 >= 255) {
            n3 = 255;
        }
        return new Color(n, n2, n3);
    }

    static int getMenuSelectionValue(int n) {
        return (int)((double)n * 76.0 / 255.0 + 179.5);
    }

    static Color getMenuBackgroundColor(Color color) {
        int n = EclipseUtils.getMenuValue(color.getRed());
        int n2 = EclipseUtils.getMenuValue(color.getGreen());
        int n3 = EclipseUtils.getMenuValue(color.getBlue());
        if (n >= 255) {
            n = 255;
        }
        if (n2 >= 255) {
            n2 = 255;
        }
        if (n3 >= 255) {
            n3 = 255;
        }
        return new Color(n, n2, n3);
    }

    static int getMenuValue(int n) {
        return (int)((double)n * 36.0 / 255.0 + 219.5);
    }

    static Color getDefaultBackgroundColor(Color color) {
        Color color2;
        if (color.getRed() == 212 && color.getGreen() == 208 && color.getBlue() == 200) {
            color2 = new Color(247, 243, 233);
        } else if (color.getRed() == 236 && color.getGreen() == 233 && color.getBlue() == 216) {
            color2 = new Color(255, 251, 233);
        } else {
            int n = color.getRed() + 35;
            int n2 = color.getGreen() + 35;
            int n3 = color.getBlue() + 35;
            if (n >= 255) {
                n = 255;
            }
            if (n2 >= 255) {
                n2 = 255;
            }
            if (n3 >= 255) {
                n3 = 255;
            }
            color2 = new Color(n, n2, n3);
        }
        return color2;
    }

    public static void fillRectWithHatch(Graphics2D graphics2D, Rectangle rectangle, Color color) {
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.setColor(color);
        graphics2D.setStroke(DOTTED_STROKE);
        for (int i = 0; i < rectangle.width; ++i) {
            if (i % 2 == 0) {
                graphics2D.drawLine(rectangle.x + i, rectangle.y, rectangle.x + i, rectangle.y + rectangle.height - 1);
                continue;
            }
            graphics2D.drawLine(rectangle.x + i, rectangle.y + 1, rectangle.x + i, rectangle.y + rectangle.height - 1);
        }
        graphics2D.setStroke(stroke);
    }

    static int getLightColor(int n, double d) {
        return (int)((double)(255 - n) * d + (double)n);
    }

    static Color getLighterColor(Color color, double d) {
        int n = EclipseUtils.getLightColor(color.getRed(), d);
        int n2 = EclipseUtils.getLightColor(color.getGreen(), d) + 1;
        int n3 = EclipseUtils.getLightColor(color.getBlue(), d);
        if (n >= 255) {
            n = 255;
        }
        if (n2 >= 255) {
            n2 = 255;
        }
        if (n3 >= 255) {
            n3 = 255;
        }
        return new Color(n, n2, n3);
    }

    static Color getSelectedAndFocusedButtonColor(Color color) {
        return EclipseUtils.getLighterColor(color, 0.67);
    }

    static Color getFocusedButtonColor(Color color) {
        return EclipseUtils.getLighterColor(color, 0.78);
    }

    static Color getSelectedButtonColor(Color color) {
        return EclipseUtils.getLighterColor(color, 0.86);
    }
}

