/*
 * Decompiled with CFR 0.152.
 */
package com.tivo.jipviewer;

import com.tivo.jipviewer.MethodRow;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class MethodRowTableModel
extends AbstractTableModel {
    public static final int PERCENT_TOTAL = 0;
    public static final int TOTAL_TIME = 1;
    public static final int COUNT = 2;
    public static final int PERCENT_NET = 3;
    public static final int NET_TIME = 4;
    public static final int METHOD_NAME = 5;
    public static final int CLASS_NAME = 6;
    public static final int PACKAGE_NAME = 7;
    List<MethodRow> mvRow = new ArrayList<MethodRow>();

    MethodRowTableModel() {
    }

    public void add(MethodRow methodRow) {
        this.mvRow.add(methodRow);
        int n = this.mvRow.size();
        this.fireTableRowsInserted(n, n);
    }

    public void clear() {
        int n = this.mvRow.size();
        this.mvRow.clear();
        this.fireTableRowsDeleted(0, n);
    }

    public MethodRow getRow(int n) {
        return this.mvRow.get(n);
    }

    public int getRowCount() {
        return this.mvRow.size();
    }

    public int getColumnCount() {
        return 8;
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "%total";
            }
            case 3: {
                return "%net";
            }
            case 2: {
                return "count";
            }
            case 1: {
                return "total";
            }
            case 4: {
                return "net";
            }
            case 5: {
                return "method";
            }
            case 6: {
                return "class";
            }
            case 7: {
                return "package";
            }
        }
        throw new RuntimeException("bad column index");
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return Double.class;
            }
            case 3: {
                return Double.class;
            }
            case 2: {
                return Long.class;
            }
            case 1: {
                return Double.class;
            }
            case 4: {
                return Double.class;
            }
            case 5: {
                return String.class;
            }
            case 6: {
                return String.class;
            }
            case 7: {
                return String.class;
            }
        }
        throw new RuntimeException("bad column index");
    }

    public Object getValueAt(int n, int n2) {
        MethodRow methodRow = this.mvRow.get(n);
        switch (n2) {
            case 0: {
                return new Double(methodRow.getPercentTotal());
            }
            case 3: {
                return new Double(methodRow.getPercentNet());
            }
            case 2: {
                return new Long(methodRow.getCount());
            }
            case 1: {
                return new Double(MethodRowTableModel.toMsec(methodRow.getTotalTime()));
            }
            case 4: {
                return new Double(MethodRowTableModel.toMsec(methodRow.getNetTime()));
            }
            case 5: {
                return methodRow.getMethod().getMethodName();
            }
            case 6: {
                return methodRow.getMethod().getClassName();
            }
            case 7: {
                return methodRow.getMethod().getPackageName();
            }
        }
        throw new RuntimeException("bad column index");
    }

    private static double toMsec(long l) {
        return Math.floor((double)l / 1000000.0 * 10.0) / 10.0;
    }
}

