/*
 * Decompiled with CFR 0.152.
 */
package com.tivo.jipviewer;

import com.tivo.jipviewer.IJipParseHandler;
import com.tivo.jipviewer.JipRun;
import java.io.FileReader;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class JipParser
extends DefaultHandler {
    private IJipParseHandler mHandler;

    private JipParser(IJipParseHandler iJipParseHandler) {
        this.mHandler = iJipParseHandler;
    }

    public static JipRun parse(String string) throws Exception {
        JipRun jipRun = new JipRun();
        JipParser jipParser = new JipParser(jipRun);
        XMLReader xMLReader = XMLReaderFactory.createXMLReader();
        xMLReader.setContentHandler(jipParser);
        xMLReader.setErrorHandler(jipParser);
        FileReader fileReader = new FileReader(string);
        xMLReader.parse(new InputSource(fileReader));
        return jipRun;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (string2.equals("profile")) {
            String string4 = this.getAttrString(attributes, "date");
            this.mHandler.setDate(string4);
        } else if (string2.equals("thread")) {
            this.mHandler.startThread(this.getAttrLong(attributes, "id"));
        } else if (string2.equals("interaction")) {
            this.mHandler.startInteraction(this.getAttrLong(attributes, "id"));
        } else if (string2.equals("frame")) {
            this.mHandler.startFrame(this.getAttrString(attributes, "cn"), this.getAttrString(attributes, "mn"), this.getAttrLong(attributes, "c"), this.getAttrLong(attributes, "t"));
        } else if (string2.equals("entry")) {
            this.mHandler.addToClassMap(this.getAttrString(attributes, "s"), this.getAttrString(attributes, "f"));
        } else if (!(string2.equals("allocation") || string2.equals("class") || string2.equals("class-map"))) {
            throw new RuntimeException("unexpected tag <" + string2 + ">");
        }
    }

    public void endElement(String string, String string2, String string3) {
        if (string2.equals("thread")) {
            this.mHandler.endThread();
        } else if (string2.equals("interaction")) {
            this.mHandler.endInteraction();
        } else if (string2.equals("frame")) {
            this.mHandler.endFrame();
        }
    }

    private String getAttrString(Attributes attributes, String string) {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            throw new RuntimeException("no value for '" + string + "'");
        }
        return string2;
    }

    private long getAttrLong(Attributes attributes, String string) {
        String string2 = this.getAttrString(attributes, string);
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException(string + " (" + string2 + ") isn't a long");
        }
    }
}

