/*
 * JSubSplit.java
 *
 * Created on March 5, 2007, 2:48 AM
 *
 * This file is part of Jubler.
 *
 * Jubler is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 *
 *
 * Jubler is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jubler; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

package com.panayotis.jubler.tools;

import static com.panayotis.jubler.i18n.I18N.__;
import com.panayotis.jubler.subs.Subtitles;

import com.panayotis.jubler.time.Time;
import com.panayotis.jubler.time.gui.JTimeSingleSelection;
import java.awt.BorderLayout;
import javax.swing.JPanel;

/**
 *
 * @author teras
 */
public class SubSplitGUI extends JPanel {

    private JTimeSingleSelection split;
    private Subtitles subs;

    /**
     * Creates new form JSubSplit
     */
    public SubSplitGUI() {
        initComponents();
        split = new JTimeSingleSelection(__("Splitting time"));
        split.setToolTip(__("Use the following time (inclusive) in order to create the new splitted subtitles"));
        TimeContainer.add(split, BorderLayout.CENTER);
    }

    public void setSubtitle(Subtitles subs, int index) {
        this.subs = subs;
        SplitS.setValue(100 * index / subs.size());
        split.setTime(subs.elementAt(index).getStartTime());
    }

    public Time getTime() {
        return split.getTime();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        TimeContainer = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        SplitS = new javax.swing.JSlider();

        setLayout(new java.awt.BorderLayout());

        jPanel1.setLayout(new java.awt.BorderLayout());

        TimeContainer.setLayout(new java.awt.BorderLayout());
        jPanel1.add(TimeContainer, java.awt.BorderLayout.NORTH);

        jPanel2.setBorder(javax.swing.BorderFactory.createEmptyBorder(16, 0, 0, 0));
        jPanel2.setLayout(new java.awt.BorderLayout());

        jLabel1.setText(__("Split at given subtitle line (in percent)"));
        jPanel2.add(jLabel1, java.awt.BorderLayout.NORTH);

        SplitS.setMajorTickSpacing(10);
        SplitS.setMinorTickSpacing(1);
        SplitS.setPaintLabels(true);
        SplitS.setPaintTicks(true);
        SplitS.setPaintTrack(false);
        SplitS.setToolTipText(__("Percentage of subtitles to divide"));
        SplitS.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                SplitSStateChanged(evt);
            }
        });
        jPanel2.add(SplitS, java.awt.BorderLayout.CENTER);

        jPanel1.add(jPanel2, java.awt.BorderLayout.CENTER);

        add(jPanel1, java.awt.BorderLayout.NORTH);
    }// </editor-fold>//GEN-END:initComponents

    private void SplitSStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_SplitSStateChanged
        split.setTime(subs.elementAt(SplitS.getValue() * (subs.size() - 1) / 100).getStartTime());
    }//GEN-LAST:event_SplitSStateChanged
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JSlider SplitS;
    private javax.swing.JPanel TimeContainer;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    // End of variables declaration//GEN-END:variables
}
