/*
 * JSubJoin.java
 *
 * Created on 25 Ιούνιος 2005, 3:31 μμ
 * 
 * This file is part of Jubler.
 *
 * Jubler is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 *
 *
 * Jubler is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jubler; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

package com.panayotis.jubler.tools;

import com.panayotis.jubler.os.SystemDependent;
import javax.swing.JPanel;
import com.panayotis.jubler.time.gui.JTimeSpinner;
import java.awt.BorderLayout;

import static com.panayotis.jubler.i18n.I18N.__;

//  Join files 
/**
 *
 * @author teras
 */
public class SubJoinGUI extends JPanel {

    JTimeSpinner joinpos;

    /**
     * Creates new form JSplit
     */
    public SubJoinGUI() {
        joinpos = new JTimeSpinner();
        initComponents();
        TShift.add(joinpos, BorderLayout.CENTER);
        joinpos.setToolTipText(__("Use the selected amount of time as space between the two subtitles"));
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        Position = new javax.swing.ButtonGroup();
        jPanel1 = new javax.swing.JPanel();
        SubWindow = new javax.swing.JComboBox();
        RPrepend = new javax.swing.JRadioButton();
        RAppend = new javax.swing.JRadioButton();
        TShift = new javax.swing.JPanel();

        setLayout(new java.awt.BorderLayout());

        jPanel1.setBorder(SystemDependent.getBorder(__("Use the following subtitles")));
        jPanel1.setOpaque(false);
        jPanel1.setLayout(new java.awt.GridLayout(0, 1));

        SubWindow.setToolTipText(__("Subtitles file to use"));
        jPanel1.add(SubWindow);

        Position.add(RPrepend);
        RPrepend.setText(__("Prepend subtitles"));
        RPrepend.setToolTipText(__("Put subtitles in the beginning of the current subtitles"));
        jPanel1.add(RPrepend);

        Position.add(RAppend);
        RAppend.setSelected(true);
        RAppend.setText(__("Append Subtitles"));
        RAppend.setToolTipText(__("Put subtitles at the end of the current subtitles"));
        jPanel1.add(RAppend);

        add(jPanel1, java.awt.BorderLayout.CENTER);

        TShift.setBorder(SystemDependent.getBorder(__("Leave gap")));
        TShift.setOpaque(false);
        TShift.setLayout(new java.awt.BorderLayout());
        add(TShift, java.awt.BorderLayout.SOUTH);
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup Position;
    javax.swing.JRadioButton RAppend;
    javax.swing.JRadioButton RPrepend;
    javax.swing.JComboBox SubWindow;
    private javax.swing.JPanel TShift;
    private javax.swing.JPanel jPanel1;
    // End of variables declaration//GEN-END:variables
}
