/*
 * JTimePosition.java
 *
 * Created on 24 Ιούνιος 2005, 11:42 μμ
 *
 * This file is part of Jubler.
 *
 * Jubler is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 *
 *
 * Jubler is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jubler; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

package com.panayotis.jubler.time.gui;

import static com.panayotis.jubler.i18n.I18N.__;
import com.panayotis.jubler.os.SystemDependent;
import com.panayotis.jubler.subs.SubEntry;
import com.panayotis.jubler.subs.Subtitles;
import java.awt.BorderLayout;
import java.util.ArrayList;
import com.panayotis.jubler.subs.style.SubStyle;

/**
 *
 * @author teras
 */
public class JTimeFullSelection extends JTimeArea {

    JTimeRegion tregion;

    /**
     * Creates new form JTimePosition
     */
    public JTimeFullSelection() {
        super();
        initComponents();
        add(SubCP, BorderLayout.SOUTH);

        tregion = new JTimeRegion();
        TimePanel.add(tregion, BorderLayout.CENTER);
        tregion.setEnabled(false);
        tregion.remove(tregion.SubCP);
    }

    @Override
    public void updateData(Subtitles subs, int[] selected) {
        super.updateData(subs, selected);
        tregion.updateData(subs, selected);

        // Update styles
        int selvalue = StyleSel.getSelectedIndex();
        StyleSel.removeAllItems();
        for (SubStyle style : subs.getStyleList())
            StyleSel.addItem(style);
        if (subs.getStyleList().size() < 2) {
            if (byStyle.isSelected())
                bySelection.setSelected(true);
            byStyle.setEnabled(false);
            StyleSel.setEnabled(false);
        } else {
            byStyle.setEnabled(true);
            StyleSel.setEnabled(true);
            if (selvalue < 0)
                selvalue = 0;
            if (selvalue < subs.getStyleList().size())
                StyleSel.setSelectedIndex(selvalue);
        }

        // Select wanted widget
        switch (selection_model) {
            case DEFAULTS_BYSELECTION:
                bySelection.doClick();
                break;
            case DEFAULTS_BYCOLOR:
                byColor.doClick();
                break;
            case DEFAULTS_BYTHEME:
                byStyle.doClick();
                break;
            case DEFAULTS_BYREGION:
                byRange.doClick();
                break;
        }
    }

    public ArrayList<SubEntry> getAffectedSubs() {
        ArrayList<SubEntry> affected;
        SubEntry csub;
        int i;

        affected = new ArrayList<SubEntry>();

        if (bySelection.isSelected())
            /* Select affected subtitles by user selection */
            for (i = 0; i < selected.length; i++)
                affected.add(subs.elementAt(selected[i]));
        else if (byColor.isSelected()) {
            /* Select affected subtitles by marking */
            int selmark = ColorSel.getSelectedIndex();

            for (i = 0; i < subs.size(); i++) {
                csub = subs.elementAt(i);
                if (selmark == csub.getMark())
                    affected.add(csub);
            }
        } else if (byStyle.isSelected()) {
            /* Select affected subtitles by marking */
            SubStyle style = (SubStyle) StyleSel.getSelectedItem();

            for (i = 0; i < subs.size(); i++) {
                csub = subs.elementAt(i);
                if (style == csub.getStyle())
                    affected.add(csub);
            }
        } else
            affected = tregion.getAffectedSubs();
        return affected;
    }

    public void forceFullRangeSelection() {
        byRange.setSelected(true);
        tregion.setEnabled(true);
        tregion.setRegionToMaximum();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        Type = new javax.swing.ButtonGroup();
        SelectionPanel = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        bySelection = new javax.swing.JRadioButton();
        jPanel6 = new javax.swing.JPanel();
        byColor = new javax.swing.JRadioButton();
        ColorSel = new javax.swing.JComboBox();
        StylePanel = new javax.swing.JPanel();
        byStyle = new javax.swing.JRadioButton();
        StyleSel = new javax.swing.JComboBox();
        jPanel2 = new javax.swing.JPanel();
        byRange = new javax.swing.JRadioButton();
        TimePanel = new javax.swing.JPanel();

        setBorder(SystemDependent.getBorder(__("Select subtitles to work on")));
        setLayout(new java.awt.BorderLayout());

        SelectionPanel.setOpaque(false);
        SelectionPanel.setLayout(new javax.swing.BoxLayout(SelectionPanel, javax.swing.BoxLayout.Y_AXIS));

        jPanel1.setOpaque(false);
        jPanel1.setLayout(new java.awt.BorderLayout());

        Type.add(bySelection);
        bySelection.setSelected(true);
        bySelection.setText(__("By user selection"));
        bySelection.setToolTipText(__("Select subtitles depending on user selection"));
        bySelection.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bySelectionActionPerformed(evt);
            }
        });
        jPanel1.add(bySelection, java.awt.BorderLayout.CENTER);

        SelectionPanel.add(jPanel1);

        jPanel6.setOpaque(false);
        jPanel6.setLayout(new java.awt.GridLayout(1, 2));

        Type.add(byColor);
        byColor.setText(__("By color marking"));
        byColor.setToolTipText(__("Select subtitles depending on their color"));
        byColor.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                byColorActionPerformed(evt);
            }
        });
        jPanel6.add(byColor);

        ColorSel.setModel(new javax.swing.DefaultComboBoxModel(SubEntry.MarkNames));
        ColorSel.setToolTipText(__("The subtitle color to use for selection"));
        ColorSel.setEnabled(false);
        jPanel6.add(ColorSel);

        SelectionPanel.add(jPanel6);

        StylePanel.setOpaque(false);
        StylePanel.setLayout(new java.awt.GridLayout(1, 0));

        Type.add(byStyle);
        byStyle.setText(__("By theme"));
        byStyle.setToolTipText(__("Select subtitles depending on their theme"));
        byStyle.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                byStyleActionPerformed(evt);
            }
        });
        StylePanel.add(byStyle);

        StyleSel.setToolTipText(__("The theme to use for selection"));
        StyleSel.setEnabled(false);
        StylePanel.add(StyleSel);

        SelectionPanel.add(StylePanel);

        jPanel2.setOpaque(false);
        jPanel2.setLayout(new java.awt.BorderLayout());

        Type.add(byRange);
        byRange.setText(__("By time range"));
        byRange.setToolTipText(__("Select subtitles depending on a specified region"));
        byRange.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                byRangeActionPerformed(evt);
            }
        });
        jPanel2.add(byRange, java.awt.BorderLayout.CENTER);

        SelectionPanel.add(jPanel2);

        add(SelectionPanel, java.awt.BorderLayout.NORTH);

        TimePanel.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 16, 0, 0));
        TimePanel.setOpaque(false);
        TimePanel.setLayout(new java.awt.BorderLayout());
        add(TimePanel, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents
    private void byStyleActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_byStyleActionPerformed
        tregion.setEnabled(false);
        ColorSel.setEnabled(false);
        StyleSel.setEnabled(true);
        selection_model = DEFAULTS_BYTHEME;
    }//GEN-LAST:event_byStyleActionPerformed

    private void byRangeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_byRangeActionPerformed
        tregion.setEnabled(true);
        ColorSel.setEnabled(false);
        StyleSel.setEnabled(false);
        selection_model = DEFAULTS_BYREGION;
    }//GEN-LAST:event_byRangeActionPerformed

    private void byColorActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_byColorActionPerformed
        tregion.setEnabled(false);
        ColorSel.setEnabled(true);
        StyleSel.setEnabled(false);
        selection_model = DEFAULTS_BYCOLOR;
    }//GEN-LAST:event_byColorActionPerformed

    private void bySelectionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bySelectionActionPerformed
        tregion.setEnabled(false);
        ColorSel.setEnabled(false);
        StyleSel.setEnabled(false);
        selection_model = DEFAULTS_BYSELECTION;
    }//GEN-LAST:event_bySelectionActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox ColorSel;
    private javax.swing.JPanel SelectionPanel;
    private javax.swing.JPanel StylePanel;
    private javax.swing.JComboBox StyleSel;
    private javax.swing.JPanel TimePanel;
    private javax.swing.ButtonGroup Type;
    protected javax.swing.JRadioButton byColor;
    protected javax.swing.JRadioButton byRange;
    protected javax.swing.JRadioButton bySelection;
    private javax.swing.JRadioButton byStyle;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel6;
    // End of variables declaration//GEN-END:variables
}
