/*
 * JAlphaColorDialog.java
 *
 * Created on 2 Σεπτέμβριος 2005, 2:59 μμ
 *
 * This file is part of Jubler.
 *
 * Jubler is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 *
 *
 * Jubler is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jubler; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

package com.panayotis.jubler.subs.style.gui;

import static com.panayotis.jubler.i18n.I18N.__;
import com.panayotis.jubler.os.SystemDependent;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionListener;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/**
 *
 * @author teras
 */
public class JAlphaColorDialog extends JDialog implements ActionListener, ChangeListener {

    private JColorChooser chooser;
    private AlphaPanel apanel;
    private AlphaColor retcolor, origcolor;

    /**
     * Creates new form JColor
     */
    public JAlphaColorDialog(java.awt.Frame parent) {
        super(parent, true);
        initComponents();
        chooser = new JColorChooser();
        chooser.setBorder(new EmptyBorder(4, 4, 4, 4));
        apanel = new AlphaPanel(new AlphaColor(Color.CYAN, 255));

        add(chooser, BorderLayout.CENTER);
        AlphaP.add(apanel, BorderLayout.CENTER);

        chooser.getSelectionModel().addChangeListener(this);

        pack();
    }

    public void setAlphaColor(AlphaColor c) {
        if (c == null)
            return;
        chooser.setColor(c);
        AlphaS.setValue(c.getAlpha());
        apanel.setAlphaColor(c);
        origcolor = c;
        retcolor = null;
    }

    public AlphaColor getAlphaColor() {
        return retcolor;
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        OKB = new javax.swing.JButton();
        CancelB = new javax.swing.JButton();
        ResetB = new javax.swing.JButton();
        AlphaP = new javax.swing.JPanel();
        AlphaS = new javax.swing.JSlider();

        setTitle(__("Color Chooser"));
        setResizable(false);

        jPanel1.setBorder(javax.swing.BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel1.setLayout(new java.awt.BorderLayout());

        jPanel2.setLayout(new java.awt.GridLayout(1, 0, 5, 0));

        OKB.setText(__("OK"));
        OKB.addActionListener(this);
        jPanel2.add(OKB);

        CancelB.setText(__("Cancel"));
        CancelB.addActionListener(this);
        jPanel2.add(CancelB);

        ResetB.setText(__("Reset"));
        ResetB.addActionListener(this);
        jPanel2.add(ResetB);

        jPanel1.add(jPanel2, java.awt.BorderLayout.EAST);

        getContentPane().add(jPanel1, java.awt.BorderLayout.SOUTH);

        AlphaP.setBorder(SystemDependent.getBorder(__("Alpha Channel")));
        AlphaP.setOpaque(false);
        AlphaP.setLayout(new java.awt.BorderLayout());

        AlphaS.setMaximum(255);
        AlphaS.setValue(200);
        AlphaS.setBorder(javax.swing.BorderFactory.createEmptyBorder(5, 0, 1, 0));
        AlphaP.add(AlphaS, java.awt.BorderLayout.NORTH);

        getContentPane().add(AlphaP, java.awt.BorderLayout.NORTH);

        pack();
    }

    // Code for dispatching events from components to event handlers.

    public void actionPerformed(java.awt.event.ActionEvent evt) {
        if (evt.getSource() == OKB) {
            JAlphaColorDialog.this.OKBActionPerformed(evt);
        }
        else if (evt.getSource() == CancelB) {
            JAlphaColorDialog.this.CancelBActionPerformed(evt);
        }
        else if (evt.getSource() == ResetB) {
            JAlphaColorDialog.this.ResetBActionPerformed(evt);
        }
    }// </editor-fold>//GEN-END:initComponents

    private void ResetBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ResetBActionPerformed
        chooser.setColor(origcolor);
        apanel.setAlphaColor(origcolor);
        AlphaS.setValue(origcolor.getAlpha());
    }//GEN-LAST:event_ResetBActionPerformed

    private void CancelBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_CancelBActionPerformed
        setVisible(false);
    }//GEN-LAST:event_CancelBActionPerformed

    private void OKBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_OKBActionPerformed
        retcolor = new AlphaColor(chooser.getColor(), AlphaS.getValue());
        setVisible(false);
    }//GEN-LAST:event_OKBActionPerformed

    public void stateChanged(ChangeEvent e) {
        apanel.setColorOnly(chooser.getColor());
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel AlphaP;
    private javax.swing.JSlider AlphaS;
    private javax.swing.JButton CancelB;
    private javax.swing.JButton OKB;
    private javax.swing.JButton ResetB;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    // End of variables declaration//GEN-END:variables
}
