/*
 * JOptionTabs.java
 *
 * Created on June 1, 2007, 2:29 PM
 *
 * This file is part of Jubler.
 *
 * Jubler is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 *
 *
 * Jubler is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jubler; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

package com.panayotis.jubler.options.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Dimension;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

/**
 *
 * @author teras
 */
public class JOptionTabs extends JPanel {

    private ArrayList<TabPage> tabs;
    JToggleButton first;
    private Window parent;

    /**
     * Creates new form JOptionTabs
     */
    public JOptionTabs(Window parent) {
        initComponents();
        tabs = new ArrayList<TabPage>();
        this.parent = parent;
    }

    public void addTab(TabPage page) {
        JToggleButton selector = new JToggleButton(page.getTabName(), page.getTabIcon());
        selector.setActionCommand(Integer.toString(tabs.size()));
        selector.setToolTipText(page.getTabTooltip());
        selector.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        selector.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        Dimension d = selector.getPreferredSize();
        if (d.width < 100)
            d.width = 70;
        selector.setPreferredSize(d);
        selector.setMinimumSize(d);
        selector.setMaximumSize(d);

        if (first == null)
            first = selector;
        TabsBG.add(selector);
        tabs.add(page);

        selector.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                setVisibleTab(Integer.parseInt(evt.getActionCommand()));
            }
        });
        BarIcons.add(selector);
        Tabs.add(page.getTabPanel(), selector.getActionCommand());
    }

    public void setVisibleTab(int index) {
        ((CardLayout) (Tabs.getLayout())).show(Tabs, Integer.toString(index));
    }

    public ArrayList<TabPage> getTabArray() {
        return tabs;
    }

    public void initTabs() {
        first.doClick();
        parent.pack();
    }

    public JPanel getTab() {
        remove(Tabs);
        Tabs.revalidate();
        return Tabs;
    }

    public void putTabBack() {
        add(Tabs, BorderLayout.CENTER);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        TabsBG = new javax.swing.ButtonGroup();
        BarIcons = new javax.swing.JToolBar();
        Tabs = new javax.swing.JPanel();

        setLayout(new java.awt.BorderLayout());

        BarIcons.setFloatable(false);
        add(BarIcons, java.awt.BorderLayout.NORTH);

        Tabs.setBorder(javax.swing.BorderFactory.createEmptyBorder(12, 8, 4, 8));
        Tabs.setLayout(new java.awt.CardLayout());
        add(Tabs, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JToolBar BarIcons;
    javax.swing.JPanel Tabs;
    private javax.swing.ButtonGroup TabsBG;
    // End of variables declaration//GEN-END:variables
}
