/*
 * JAudioLoader.java
 *
 * Created on 20 Οκτώβριος 2005, 7:50 μμ
 *
 * This file is part of Jubler.
 *
 * Jubler is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 *
 *
 * Jubler is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jubler; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

package com.panayotis.jubler.media.preview;

import static com.panayotis.jubler.i18n.I18N.__;
import com.panayotis.jubler.media.MediaFile;

/**
 *
 * @author teras
 */
public class JAudioLoader extends javax.swing.JPanel {

    private MediaFile mfile;

    /**
     * Creates new form JAudioLoader
     */
    public JAudioLoader() {
        initComponents();
    }

    public void setValue(int value) {
        ProgressB.setValue(value);
    }

    public void setFilename(String fname) {
        FileL.setText(fname);
        validate();
    }

    public void updateMediaFile(MediaFile mfile) {
        this.mfile = mfile;
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        ProgressB = new javax.swing.JProgressBar();
        FileL = new javax.swing.JLabel();
        AssignInterruptB = new javax.swing.JButton();

        jPanel1.setLayout(new java.awt.BorderLayout());

        ProgressB.setStringPainted(true);
        jPanel1.add(ProgressB, java.awt.BorderLayout.CENTER);
        jPanel1.add(FileL, java.awt.BorderLayout.NORTH);

        AssignInterruptB.setText(__("Cancel"));
        AssignInterruptB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                AssignInterruptBActionPerformed(evt);
            }
        });
        jPanel1.add(AssignInterruptB, java.awt.BorderLayout.EAST);

        add(jPanel1);
    }// </editor-fold>//GEN-END:initComponents

    private void AssignInterruptBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_AssignInterruptBActionPerformed
        if (mfile != null)
            mfile.interruptCacheCreation(true);
    }//GEN-LAST:event_AssignInterruptBActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton AssignInterruptB;
    private javax.swing.JLabel FileL;
    private javax.swing.JProgressBar ProgressB;
    private javax.swing.JPanel jPanel1;
    // End of variables declaration//GEN-END:variables
}
