---
layout: "language"
page_title: "Resource Behavior - Configuration Language"
description: "Learn how Terraform uses resource blocks to create infrastructure objects. Also learn about resource dependencies and how to access resource attributes."
---

# Resource Behavior

A `resource` block declares that you want a particular infrastructure object
to exist with the given settings. If you are writing a new configuration for
the first time, the resources it defines will exist _only_ in the configuration,
and will not yet represent real infrastructure objects in the target platform.

_Applying_ a Terraform configuration is the process of creating, updating,
and destroying real infrastructure objects in order to make their settings
match the configuration.

## How Terraform Applies a Configuration

When Terraform creates a new infrastructure object represented by a `resource`
block, the identifier for that real object is saved in Terraform's
[state](/docs/language/state/index.html), allowing it to be updated and destroyed
in response to future changes. For resource blocks that already have an
associated infrastructure object in the state, Terraform compares the
actual configuration of the object with the arguments given in the
configuration and, if necessary, updates the object to match the configuration.

In summary, applying a Terraform configuration will:

- _Create_ resources that exist in the configuration but are not associated with a real infrastructure object in the state.
- _Destroy_ resources that exist in the state but no longer exist in the configuration.
- _Update in-place_ resources whose arguments have changed.
- _Destroy and re-create_ resources whose arguments have changed but which cannot be updated in-place due to remote API limitations.

This general behavior applies for all resources, regardless of type. The
details of what it means to create, update, or destroy a resource are different
for each resource type, but this standard set of verbs is common across them
all.

The meta-arguments within `resource` blocks, documented in the
sections below, allow some details of this standard resource behavior to be
customized on a per-resource basis.

## Accessing Resource Attributes

[Expressions](/docs/language/expressions/index.html) within a Terraform module can access
information about resources in the same module, and you can use that information
to help configure other resources. Use the `<RESOURCE TYPE>.<NAME>.<ATTRIBUTE>`
syntax to reference a resource attribute in an expression.

In addition to arguments specified in the configuration, resources often provide
read-only attributes with information obtained from the remote API; this often
includes things that can't be known until the resource is created, like the
resource's unique random ID.

Many providers also include [data sources](/docs/language/data-sources/index.html),
which are a special type of resource used only for looking up information.

For a list of the attributes a resource or data source type provides, consult
its documentation; these are generally included in a second list below its list
of configurable arguments.

For more information about referencing resource attributes in expressions, see
[Expressions: References to Resource Attributes](/docs/language/expressions/references.html#references-to-resource-attributes).

## Resource Dependencies

Most resources in a configuration don't have any particular relationship, and
Terraform can make changes to several unrelated resources in parallel.

However, some resources must be processed after other specific resources;
sometimes this is because of how the resource works, and sometimes the
resource's configuration just requires information generated by another
resource.

Most resource dependencies are handled automatically. Terraform analyses any
[expressions](/docs/language/expressions/index.html) within a `resource` block to find references
to other objects, and treats those references as implicit ordering requirements
when creating, updating, or destroying resources. Since most resources with
behavioral dependencies on other resources also refer to those resources' data,
it's usually not necessary to manually specify dependencies between resources.

However, some dependencies cannot be recognized implicitly in configuration. For
example, if Terraform must manage access control policies _and_ take actions
that require those policies to be present, there is a hidden dependency between
the access policy and a resource whose creation depends on it. In these rare
cases,
[the `depends_on` meta-argument](/docs/language/meta-arguments/depends_on.html)
can explicitly specify a dependency.

## Local-only Resources

While most resource types correspond to an infrastructure object type that
is managed via a remote network API, there are certain specialized resource
types that operate only within Terraform itself, calculating some results and
saving those results in the state for future use.

For example, local-only resource types exist for
[generating private keys](https://registry.terraform.io/providers/hashicorp/tls/latest/docs/resources/private_key),
[issuing self-signed TLS certificates](https://registry.terraform.io/providers/hashicorp/tls/latest/docs/resources/self_signed_cert),
and even [generating random ids](https://registry.terraform.io/providers/hashicorp/random/latest/docs/resources/id).
While these resource types often have a more marginal purpose than those
managing "real" infrastructure objects, they can be useful as glue to help
connect together other resources.

The behavior of local-only resources is the same as all other resources, but
their result data exists only within the Terraform state. "Destroying" such
a resource means only to remove it from the state, discarding its data.

