---
layout: "docs"
page_title: "Inspecting State - Terraform CLI"
description: "Commands that allow you to read and update state."
---

# Inspecting State

Terraform includes some commands for reading and updating state without taking
any other actions.

- [The `terraform state list` command](/docs/cli/commands/state/list.html)
  shows the resource addresses for every resource Terraform knows about in a
  configuration, optionally filtered by partial resource address.

- [The `terraform state show` command](/docs/cli/commands/state/show.html)
  displays detailed state data about one resource.

- [The `terraform refresh` command](/docs/cli/commands/refresh.html) updates
  state data to match the real-world condition of the managed resources. This is
  done automatically during plans and applies, but not when interacting with
  state directly.
