---
layout: "docs"
page_title: "Command: graph"
sidebar_current: "docs-commands-graph"
description: "The terraform graph command generates a visual representation of a configuration or execution plan that you can use to generate charts."
---

# Command: graph

The `terraform graph` command is used to generate a visual
representation of either a configuration or execution plan.
The output is in the DOT format, which can be used by
[GraphViz](http://www.graphviz.org) to generate charts.


## Usage

Usage: `terraform graph [options]`

Outputs the visual execution graph of Terraform resources according to
either the current configuration or an execution plan.

The graph is outputted in DOT format. The typical program that can
read this format is GraphViz, but many web services are also available
to read this format.

The `-type` flag can be used to control the type of graph shown. Terraform
creates different graphs for different operations. See the options below
for the list of types supported. The default type is "plan" if a
configuration is given, and "apply" if a plan file is passed as an
argument.

Options:

* `-plan=tfplan`    - Render graph using the specified plan file instead of the
                      configuration in the current directory.

* `-draw-cycles`    - Highlight any cycles in the graph with colored edges.
                      This helps when diagnosing cycle errors.

* `-type=plan`      - Type of graph to output. Can be: `plan`, `plan-destroy`, `apply`,
                      `validate`, `input`, `refresh`.

* `-module-depth=n` - (deprecated) In prior versions of Terraform, specified the
                      depth of modules to show in the output.

## Generating Images

The output of `terraform graph` is in the DOT format, which can
easily be converted to an image by making use of `dot` provided
by GraphViz:

```shellsession
$ terraform graph | dot -Tsvg > graph.svg
```

Here is an example graph output:
![Graph Example](docs/graph-example.png)
