// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/dialogflow/v2beta1/entity_type.proto

package dialogflow

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "github.com/golang/protobuf/ptypes/struct"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Represents kinds of entities.
type EntityType_Kind int32

const (
	// Not specified. This value should be never used.
	EntityType_KIND_UNSPECIFIED EntityType_Kind = 0
	// Map entity types allow mapping of a group of synonyms to a canonical
	// value.
	EntityType_KIND_MAP EntityType_Kind = 1
	// List entity types contain a set of entries that do not map to canonical
	// values. However, list entity types can contain references to other entity
	// types (with or without aliases).
	EntityType_KIND_LIST EntityType_Kind = 2
)

var EntityType_Kind_name = map[int32]string{
	0: "KIND_UNSPECIFIED",
	1: "KIND_MAP",
	2: "KIND_LIST",
}

var EntityType_Kind_value = map[string]int32{
	"KIND_UNSPECIFIED": 0,
	"KIND_MAP":         1,
	"KIND_LIST":        2,
}

func (x EntityType_Kind) String() string {
	return proto.EnumName(EntityType_Kind_name, int32(x))
}

func (EntityType_Kind) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_270276916589f9d5, []int{0, 0}
}

// Represents different entity type expansion modes. Automated expansion
// allows an agent to recognize values that have not been explicitly listed in
// the entity (for example, new kinds of shopping list items).
type EntityType_AutoExpansionMode int32

const (
	// Auto expansion disabled for the entity.
	EntityType_AUTO_EXPANSION_MODE_UNSPECIFIED EntityType_AutoExpansionMode = 0
	// Allows an agent to recognize values that have not been explicitly
	// listed in the entity.
	EntityType_AUTO_EXPANSION_MODE_DEFAULT EntityType_AutoExpansionMode = 1
)

var EntityType_AutoExpansionMode_name = map[int32]string{
	0: "AUTO_EXPANSION_MODE_UNSPECIFIED",
	1: "AUTO_EXPANSION_MODE_DEFAULT",
}

var EntityType_AutoExpansionMode_value = map[string]int32{
	"AUTO_EXPANSION_MODE_UNSPECIFIED": 0,
	"AUTO_EXPANSION_MODE_DEFAULT":     1,
}

func (x EntityType_AutoExpansionMode) String() string {
	return proto.EnumName(EntityType_AutoExpansionMode_name, int32(x))
}

func (EntityType_AutoExpansionMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_270276916589f9d5, []int{0, 1}
}

// Represents an entity type.
// Entity types serve as a tool for extracting parameter values from natural
// language queries.
type EntityType struct {
	// The unique identifier of the entity type.
	// Required for [EntityTypes.UpdateEntityType][google.cloud.dialogflow.v2beta1.EntityTypes.UpdateEntityType] and
	// [EntityTypes.BatchUpdateEntityTypes][google.cloud.dialogflow.v2beta1.EntityTypes.BatchUpdateEntityTypes] methods.
	// Format: `projects/<Project ID>/agent/entityTypes/<Entity Type ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The name of the entity type.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. Indicates the kind of entity type.
	Kind EntityType_Kind `protobuf:"varint,3,opt,name=kind,proto3,enum=google.cloud.dialogflow.v2beta1.EntityType_Kind" json:"kind,omitempty"`
	// Optional. Indicates whether the entity type can be automatically
	// expanded.
	AutoExpansionMode EntityType_AutoExpansionMode `protobuf:"varint,4,opt,name=auto_expansion_mode,json=autoExpansionMode,proto3,enum=google.cloud.dialogflow.v2beta1.EntityType_AutoExpansionMode" json:"auto_expansion_mode,omitempty"`
	// Optional. The collection of entity entries associated with the entity type.
	Entities             []*EntityType_Entity `protobuf:"bytes,6,rep,name=entities,proto3" json:"entities,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *EntityType) Reset()         { *m = EntityType{} }
func (m *EntityType) String() string { return proto.CompactTextString(m) }
func (*EntityType) ProtoMessage()    {}
func (*EntityType) Descriptor() ([]byte, []int) {
	return fileDescriptor_270276916589f9d5, []int{0}
}

func (m *EntityType) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EntityType.Unmarshal(m, b)
}
func (m *EntityType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EntityType.Marshal(b, m, deterministic)
}
func (m *EntityType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EntityType.Merge(m, src)
}
func (m *EntityType) XXX_Size() int {
	return xxx_messageInfo_EntityType.Size(m)
}
func (m *EntityType) XXX_DiscardUnknown() {
	xxx_messageInfo_EntityType.DiscardUnknown(m)
}

var xxx_messageInfo_EntityType proto.InternalMessageInfo

func (m *EntityType) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EntityType) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *EntityType) GetKind() EntityType_Kind {
	if m != nil {
		return m.Kind
	}
	return EntityType_KIND_UNSPECIFIED
}

func (m *EntityType) GetAutoExpansionMode() EntityType_AutoExpansionMode {
	if m != nil {
		return m.AutoExpansionMode
	}
	return EntityType_AUTO_EXPANSION_MODE_UNSPECIFIED
}

func (m *EntityType) GetEntities() []*EntityType_Entity {
	if m != nil {
		return m.Entities
	}
	return nil
}

// An **entity entry** for an associated entity type.
type EntityType_Entity struct {
	// Required. The primary value associated with this entity entry.
	// For example, if the entity type is *vegetable*, the value could be
	// *scallions*.
	//
	// For `KIND_MAP` entity types:
	//
	// *   A canonical value to be used in place of synonyms.
	//
	// For `KIND_LIST` entity types:
	//
	// *   A string that can contain references to other entity types (with or
	//     without aliases).
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Required. A collection of value synonyms. For example, if the entity type
	// is *vegetable*, and `value` is *scallions*, a synonym could be *green
	// onions*.
	//
	// For `KIND_LIST` entity types:
	//
	// *   This collection must contain exactly one synonym equal to `value`.
	Synonyms             []string `protobuf:"bytes,2,rep,name=synonyms,proto3" json:"synonyms,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EntityType_Entity) Reset()         { *m = EntityType_Entity{} }
func (m *EntityType_Entity) String() string { return proto.CompactTextString(m) }
func (*EntityType_Entity) ProtoMessage()    {}
func (*EntityType_Entity) Descriptor() ([]byte, []int) {
	return fileDescriptor_270276916589f9d5, []int{0, 0}
}

func (m *EntityType_Entity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EntityType_Entity.Unmarshal(m, b)
}
func (m *EntityType_Entity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EntityType_Entity.Marshal(b, m, deterministic)
}
func (m *EntityType_Entity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EntityType_Entity.Merge(m, src)
}
func (m *EntityType_Entity) XXX_Size() int {
	return xxx_messageInfo_EntityType_Entity.Size(m)
}
func (m *EntityType_Entity) XXX_DiscardUnknown() {
	xxx_messageInfo_EntityType_Entity.DiscardUnknown(m)
}

var xxx_messageInfo_EntityType_Entity proto.InternalMessageInfo

func (m *EntityType_Entity) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *EntityType_Entity) GetSynonyms() []string {
	if m != nil {
		return m.Synonyms
	}
	return nil
}

// The request message for [EntityTypes.ListEntityTypes][google.cloud.dialogflow.v2beta1.EntityTypes.ListEntityTypes].
type ListEntityTypesRequest struct {
	// Required. The agent to list all entity types from.
	// Format: `projects/<Project ID>/agent`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The language to list entity synonyms for. If not specified,
	// the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow/docs/reference/language)
	// are supported. Note: languages must be enabled in the agent before they can
	// be used.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The maximum number of items to return in a single page. By
	// default 100 and at most 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous list request.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListEntityTypesRequest) Reset()         { *m = ListEntityTypesRequest{} }
func (m *ListEntityTypesRequest) String() string { return proto.CompactTextString(m) }
func (*ListEntityTypesRequest) ProtoMessage()    {}
func (*ListEntityTypesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_270276916589f9d5, []int{1}
}

func (m *ListEntityTypesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListEntityTypesRequest.Unmarshal(m, b)
}
func (m *ListEntityTypesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListEntityTypesRequest.Marshal(b, m, deterministic)
}
func (m *ListEntityTypesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListEntityTypesRequest.Merge(m, src)
}
func (m *ListEntityTypesRequest) XXX_Size() int {
	return xxx_messageInfo_ListEntityTypesRequest.Size(m)
}
func (m *ListEntityTypesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListEntityTypesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListEntityTypesRequest proto.InternalMessageInfo

func (m *ListEntityTypesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListEntityTypesRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *ListEntityTypesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListEntityTypesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response message for [EntityTypes.ListEntityTypes][google.cloud.dialogflow.v2beta1.EntityTypes.ListEntityTypes].
type ListEntityTypesResponse struct {
	// The list of agent entity types. There will be a maximum number of items
	// returned based on the page_size field in the request.
	EntityTypes []*EntityType `protobuf:"bytes,1,rep,name=entity_types,json=entityTypes,proto3" json:"entity_types,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListEntityTypesResponse) Reset()         { *m = ListEntityTypesResponse{} }
func (m *ListEntityTypesResponse) String() string { return proto.CompactTextString(m) }
func (*ListEntityTypesResponse) ProtoMessage()    {}
func (*ListEntityTypesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_270276916589f9d5, []int{2}
}

func (m *ListEntityTypesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListEntityTypesResponse.Unmarshal(m, b)
}
func (m *ListEntityTypesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListEntityTypesResponse.Marshal(b, m, deterministic)
}
func (m *ListEntityTypesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListEntityTypesResponse.Merge(m, src)
}
func (m *ListEntityTypesResponse) XXX_Size() int {
	return xxx_messageInfo_ListEntityTypesResponse.Size(m)
}
func (m *ListEntityTypesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListEntityTypesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListEntityTypesResponse proto.InternalMessageInfo

func (m *ListEntityTypesResponse) GetEntityTypes() []*EntityType {
	if m != nil {
		return m.EntityTypes
	}
	return nil
}

func (m *ListEntityTypesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request message for [EntityTypes.GetEntityType][google.cloud.dialogflow.v2beta1.EntityTypes.GetEntityType].
type GetEntityTypeRequest struct {
	// Required. The name of the entity type.
	// Format: `projects/<Project ID>/agent/entityTypes/<EntityType ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The language to retrieve entity synonyms for. If not specified,
	// the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow/docs/reference/language)
	// are supported. Note: languages must be enabled in the agent before they can
	// be used.
	LanguageCode         string   `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetEntityTypeRequest) Reset()         { *m = GetEntityTypeRequest{} }
func (m *GetEntityTypeRequest) String() string { return proto.CompactTextString(m) }
func (*GetEntityTypeRequest) ProtoMessage()    {}
func (*GetEntityTypeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_270276916589f9d5, []int{3}
}

func (m *GetEntityTypeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetEntityTypeRequest.Unmarshal(m, b)
}
func (m *GetEntityTypeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetEntityTypeRequest.Marshal(b, m, deterministic)
}
func (m *GetEntityTypeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetEntityTypeRequest.Merge(m, src)
}
func (m *GetEntityTypeRequest) XXX_Size() int {
	return xxx_messageInfo_GetEntityTypeRequest.Size(m)
}
func (m *GetEntityTypeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetEntityTypeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetEntityTypeRequest proto.InternalMessageInfo

func (m *GetEntityTypeRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetEntityTypeRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// The request message for [EntityTypes.CreateEntityType][google.cloud.dialogflow.v2beta1.EntityTypes.CreateEntityType].
type CreateEntityTypeRequest struct {
	// Required. The agent to create a entity type for.
	// Format: `projects/<Project ID>/agent`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The entity type to create.
	EntityType *EntityType `protobuf:"bytes,2,opt,name=entity_type,json=entityType,proto3" json:"entity_type,omitempty"`
	// Optional. The language of entity synonyms defined in `entity_type`. If not
	// specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow/docs/reference/language)
	// are supported. Note: languages must be enabled in the agent before they can
	// be used.
	LanguageCode         string   `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateEntityTypeRequest) Reset()         { *m = CreateEntityTypeRequest{} }
func (m *CreateEntityTypeRequest) String() string { return proto.CompactTextString(m) }
func (*CreateEntityTypeRequest) ProtoMessage()    {}
func (*CreateEntityTypeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_270276916589f9d5, []int{4}
}

func (m *CreateEntityTypeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateEntityTypeRequest.Unmarshal(m, b)
}
func (m *CreateEntityTypeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateEntityTypeRequest.Marshal(b, m, deterministic)
}
func (m *CreateEntityTypeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateEntityTypeRequest.Merge(m, src)
}
func (m *CreateEntityTypeRequest) XXX_Size() int {
	return xxx_messageInfo_CreateEntityTypeRequest.Size(m)
}
func (m *CreateEntityTypeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateEntityTypeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateEntityTypeRequest proto.InternalMessageInfo

func (m *CreateEntityTypeRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateEntityTypeRequest) GetEntityType() *EntityType {
	if m != nil {
		return m.EntityType
	}
	return nil
}

func (m *CreateEntityTypeRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// The request message for [EntityTypes.UpdateEntityType][google.cloud.dialogflow.v2beta1.EntityTypes.UpdateEntityType].
type UpdateEntityTypeRequest struct {
	// Required. The entity type to update.
	EntityType *EntityType `protobuf:"bytes,1,opt,name=entity_type,json=entityType,proto3" json:"entity_type,omitempty"`
	// Optional. The language of entity synonyms defined in `entity_type`. If not
	// specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow/docs/reference/language)
	// are supported. Note: languages must be enabled in the agent before they can
	// be used.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The mask to control which fields get updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateEntityTypeRequest) Reset()         { *m = UpdateEntityTypeRequest{} }
func (m *UpdateEntityTypeRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateEntityTypeRequest) ProtoMessage()    {}
func (*UpdateEntityTypeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_270276916589f9d5, []int{5}
}

func (m *UpdateEntityTypeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateEntityTypeRequest.Unmarshal(m, b)
}
func (m *UpdateEntityTypeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateEntityTypeRequest.Marshal(b, m, deterministic)
}
func (m *UpdateEntityTypeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateEntityTypeRequest.Merge(m, src)
}
func (m *UpdateEntityTypeRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateEntityTypeRequest.Size(m)
}
func (m *UpdateEntityTypeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateEntityTypeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateEntityTypeRequest proto.InternalMessageInfo

func (m *UpdateEntityTypeRequest) GetEntityType() *EntityType {
	if m != nil {
		return m.EntityType
	}
	return nil
}

func (m *UpdateEntityTypeRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *UpdateEntityTypeRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// The request message for [EntityTypes.DeleteEntityType][google.cloud.dialogflow.v2beta1.EntityTypes.DeleteEntityType].
type DeleteEntityTypeRequest struct {
	// Required. The name of the entity type to delete.
	// Format: `projects/<Project ID>/agent/entityTypes/<EntityType ID>`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteEntityTypeRequest) Reset()         { *m = DeleteEntityTypeRequest{} }
func (m *DeleteEntityTypeRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteEntityTypeRequest) ProtoMessage()    {}
func (*DeleteEntityTypeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_270276916589f9d5, []int{6}
}

func (m *DeleteEntityTypeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteEntityTypeRequest.Unmarshal(m, b)
}
func (m *DeleteEntityTypeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteEntityTypeRequest.Marshal(b, m, deterministic)
}
func (m *DeleteEntityTypeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteEntityTypeRequest.Merge(m, src)
}
func (m *DeleteEntityTypeRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteEntityTypeRequest.Size(m)
}
func (m *DeleteEntityTypeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteEntityTypeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteEntityTypeRequest proto.InternalMessageInfo

func (m *DeleteEntityTypeRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request message for [EntityTypes.BatchUpdateEntityTypes][google.cloud.dialogflow.v2beta1.EntityTypes.BatchUpdateEntityTypes].
type BatchUpdateEntityTypesRequest struct {
	// Required. The name of the agent to update or create entity types in.
	// Format: `projects/<Project ID>/agent`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The source of the entity type batch.
	//
	// For each entity type in the batch:
	//
	// *   If `name` is specified, we update an existing entity type.
	// *   If `name` is not specified, we create a new entity type.
	//
	// Types that are valid to be assigned to EntityTypeBatch:
	//	*BatchUpdateEntityTypesRequest_EntityTypeBatchUri
	//	*BatchUpdateEntityTypesRequest_EntityTypeBatchInline
	EntityTypeBatch isBatchUpdateEntityTypesRequest_EntityTypeBatch `protobuf_oneof:"entity_type_batch"`
	// Optional. The language of entity synonyms defined in `entity_types`. If not
	// specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow/docs/reference/language)
	// are supported. Note: languages must be enabled in the agent before they can
	// be used.
	LanguageCode string `protobuf:"bytes,4,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The mask to control which fields get updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,5,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *BatchUpdateEntityTypesRequest) Reset()         { *m = BatchUpdateEntityTypesRequest{} }
func (m *BatchUpdateEntityTypesRequest) String() string { return proto.CompactTextString(m) }
func (*BatchUpdateEntityTypesRequest) ProtoMessage()    {}
func (*BatchUpdateEntityTypesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_270276916589f9d5, []int{7}
}

func (m *BatchUpdateEntityTypesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchUpdateEntityTypesRequest.Unmarshal(m, b)
}
func (m *BatchUpdateEntityTypesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchUpdateEntityTypesRequest.Marshal(b, m, deterministic)
}
func (m *BatchUpdateEntityTypesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchUpdateEntityTypesRequest.Merge(m, src)
}
func (m *BatchUpdateEntityTypesRequest) XXX_Size() int {
	return xxx_messageInfo_BatchUpdateEntityTypesRequest.Size(m)
}
func (m *BatchUpdateEntityTypesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchUpdateEntityTypesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchUpdateEntityTypesRequest proto.InternalMessageInfo

func (m *BatchUpdateEntityTypesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

type isBatchUpdateEntityTypesRequest_EntityTypeBatch interface {
	isBatchUpdateEntityTypesRequest_EntityTypeBatch()
}

type BatchUpdateEntityTypesRequest_EntityTypeBatchUri struct {
	EntityTypeBatchUri string `protobuf:"bytes,2,opt,name=entity_type_batch_uri,json=entityTypeBatchUri,proto3,oneof"`
}

type BatchUpdateEntityTypesRequest_EntityTypeBatchInline struct {
	EntityTypeBatchInline *EntityTypeBatch `protobuf:"bytes,3,opt,name=entity_type_batch_inline,json=entityTypeBatchInline,proto3,oneof"`
}

func (*BatchUpdateEntityTypesRequest_EntityTypeBatchUri) isBatchUpdateEntityTypesRequest_EntityTypeBatch() {
}

func (*BatchUpdateEntityTypesRequest_EntityTypeBatchInline) isBatchUpdateEntityTypesRequest_EntityTypeBatch() {
}

func (m *BatchUpdateEntityTypesRequest) GetEntityTypeBatch() isBatchUpdateEntityTypesRequest_EntityTypeBatch {
	if m != nil {
		return m.EntityTypeBatch
	}
	return nil
}

func (m *BatchUpdateEntityTypesRequest) GetEntityTypeBatchUri() string {
	if x, ok := m.GetEntityTypeBatch().(*BatchUpdateEntityTypesRequest_EntityTypeBatchUri); ok {
		return x.EntityTypeBatchUri
	}
	return ""
}

func (m *BatchUpdateEntityTypesRequest) GetEntityTypeBatchInline() *EntityTypeBatch {
	if x, ok := m.GetEntityTypeBatch().(*BatchUpdateEntityTypesRequest_EntityTypeBatchInline); ok {
		return x.EntityTypeBatchInline
	}
	return nil
}

func (m *BatchUpdateEntityTypesRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *BatchUpdateEntityTypesRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*BatchUpdateEntityTypesRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*BatchUpdateEntityTypesRequest_EntityTypeBatchUri)(nil),
		(*BatchUpdateEntityTypesRequest_EntityTypeBatchInline)(nil),
	}
}

// The response message for [EntityTypes.BatchUpdateEntityTypes][google.cloud.dialogflow.v2beta1.EntityTypes.BatchUpdateEntityTypes].
type BatchUpdateEntityTypesResponse struct {
	// The collection of updated or created entity types.
	EntityTypes          []*EntityType `protobuf:"bytes,1,rep,name=entity_types,json=entityTypes,proto3" json:"entity_types,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *BatchUpdateEntityTypesResponse) Reset()         { *m = BatchUpdateEntityTypesResponse{} }
func (m *BatchUpdateEntityTypesResponse) String() string { return proto.CompactTextString(m) }
func (*BatchUpdateEntityTypesResponse) ProtoMessage()    {}
func (*BatchUpdateEntityTypesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_270276916589f9d5, []int{8}
}

func (m *BatchUpdateEntityTypesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchUpdateEntityTypesResponse.Unmarshal(m, b)
}
func (m *BatchUpdateEntityTypesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchUpdateEntityTypesResponse.Marshal(b, m, deterministic)
}
func (m *BatchUpdateEntityTypesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchUpdateEntityTypesResponse.Merge(m, src)
}
func (m *BatchUpdateEntityTypesResponse) XXX_Size() int {
	return xxx_messageInfo_BatchUpdateEntityTypesResponse.Size(m)
}
func (m *BatchUpdateEntityTypesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchUpdateEntityTypesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BatchUpdateEntityTypesResponse proto.InternalMessageInfo

func (m *BatchUpdateEntityTypesResponse) GetEntityTypes() []*EntityType {
	if m != nil {
		return m.EntityTypes
	}
	return nil
}

// The request message for [EntityTypes.BatchDeleteEntityTypes][google.cloud.dialogflow.v2beta1.EntityTypes.BatchDeleteEntityTypes].
type BatchDeleteEntityTypesRequest struct {
	// Required. The name of the agent to delete all entities types for. Format:
	// `projects/<Project ID>/agent`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The names entity types to delete. All names must point to the
	// same agent as `parent`.
	EntityTypeNames      []string `protobuf:"bytes,2,rep,name=entity_type_names,json=entityTypeNames,proto3" json:"entity_type_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BatchDeleteEntityTypesRequest) Reset()         { *m = BatchDeleteEntityTypesRequest{} }
func (m *BatchDeleteEntityTypesRequest) String() string { return proto.CompactTextString(m) }
func (*BatchDeleteEntityTypesRequest) ProtoMessage()    {}
func (*BatchDeleteEntityTypesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_270276916589f9d5, []int{9}
}

func (m *BatchDeleteEntityTypesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchDeleteEntityTypesRequest.Unmarshal(m, b)
}
func (m *BatchDeleteEntityTypesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchDeleteEntityTypesRequest.Marshal(b, m, deterministic)
}
func (m *BatchDeleteEntityTypesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchDeleteEntityTypesRequest.Merge(m, src)
}
func (m *BatchDeleteEntityTypesRequest) XXX_Size() int {
	return xxx_messageInfo_BatchDeleteEntityTypesRequest.Size(m)
}
func (m *BatchDeleteEntityTypesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchDeleteEntityTypesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchDeleteEntityTypesRequest proto.InternalMessageInfo

func (m *BatchDeleteEntityTypesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *BatchDeleteEntityTypesRequest) GetEntityTypeNames() []string {
	if m != nil {
		return m.EntityTypeNames
	}
	return nil
}

// The request message for [EntityTypes.BatchCreateEntities][google.cloud.dialogflow.v2beta1.EntityTypes.BatchCreateEntities].
type BatchCreateEntitiesRequest struct {
	// Required. The name of the entity type to create entities in. Format:
	// `projects/<Project ID>/agent/entityTypes/<Entity Type ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The entities to create.
	Entities []*EntityType_Entity `protobuf:"bytes,2,rep,name=entities,proto3" json:"entities,omitempty"`
	// Optional. The language of entity synonyms defined in `entities`. If not
	// specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow/docs/reference/language)
	// are supported. Note: languages must be enabled in the agent before they can
	// be used.
	LanguageCode         string   `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BatchCreateEntitiesRequest) Reset()         { *m = BatchCreateEntitiesRequest{} }
func (m *BatchCreateEntitiesRequest) String() string { return proto.CompactTextString(m) }
func (*BatchCreateEntitiesRequest) ProtoMessage()    {}
func (*BatchCreateEntitiesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_270276916589f9d5, []int{10}
}

func (m *BatchCreateEntitiesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchCreateEntitiesRequest.Unmarshal(m, b)
}
func (m *BatchCreateEntitiesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchCreateEntitiesRequest.Marshal(b, m, deterministic)
}
func (m *BatchCreateEntitiesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchCreateEntitiesRequest.Merge(m, src)
}
func (m *BatchCreateEntitiesRequest) XXX_Size() int {
	return xxx_messageInfo_BatchCreateEntitiesRequest.Size(m)
}
func (m *BatchCreateEntitiesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchCreateEntitiesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchCreateEntitiesRequest proto.InternalMessageInfo

func (m *BatchCreateEntitiesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *BatchCreateEntitiesRequest) GetEntities() []*EntityType_Entity {
	if m != nil {
		return m.Entities
	}
	return nil
}

func (m *BatchCreateEntitiesRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// The request message for [EntityTypes.BatchUpdateEntities][google.cloud.dialogflow.v2beta1.EntityTypes.BatchUpdateEntities].
type BatchUpdateEntitiesRequest struct {
	// Required. The name of the entity type to update or create entities in.
	// Format: `projects/<Project ID>/agent/entityTypes/<Entity Type ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The entities to update or create.
	Entities []*EntityType_Entity `protobuf:"bytes,2,rep,name=entities,proto3" json:"entities,omitempty"`
	// Optional. The language of entity synonyms defined in `entities`. If not
	// specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow/docs/reference/language)
	// are supported. Note: languages must be enabled in the agent before they can
	// be used.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The mask to control which fields get updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *BatchUpdateEntitiesRequest) Reset()         { *m = BatchUpdateEntitiesRequest{} }
func (m *BatchUpdateEntitiesRequest) String() string { return proto.CompactTextString(m) }
func (*BatchUpdateEntitiesRequest) ProtoMessage()    {}
func (*BatchUpdateEntitiesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_270276916589f9d5, []int{11}
}

func (m *BatchUpdateEntitiesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchUpdateEntitiesRequest.Unmarshal(m, b)
}
func (m *BatchUpdateEntitiesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchUpdateEntitiesRequest.Marshal(b, m, deterministic)
}
func (m *BatchUpdateEntitiesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchUpdateEntitiesRequest.Merge(m, src)
}
func (m *BatchUpdateEntitiesRequest) XXX_Size() int {
	return xxx_messageInfo_BatchUpdateEntitiesRequest.Size(m)
}
func (m *BatchUpdateEntitiesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchUpdateEntitiesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchUpdateEntitiesRequest proto.InternalMessageInfo

func (m *BatchUpdateEntitiesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *BatchUpdateEntitiesRequest) GetEntities() []*EntityType_Entity {
	if m != nil {
		return m.Entities
	}
	return nil
}

func (m *BatchUpdateEntitiesRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *BatchUpdateEntitiesRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// The request message for [EntityTypes.BatchDeleteEntities][google.cloud.dialogflow.v2beta1.EntityTypes.BatchDeleteEntities].
type BatchDeleteEntitiesRequest struct {
	// Required. The name of the entity type to delete entries for. Format:
	// `projects/<Project ID>/agent/entityTypes/<Entity Type ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The canonical `values` of the entities to delete. Note that
	// these are not fully-qualified names, i.e. they don't start with
	// `projects/<Project ID>`.
	EntityValues []string `protobuf:"bytes,2,rep,name=entity_values,json=entityValues,proto3" json:"entity_values,omitempty"`
	// Optional. The language of entity synonyms defined in `entities`. If not
	// specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow/docs/reference/language)
	// are supported. Note: languages must be enabled in the agent before they can
	// be used.
	LanguageCode         string   `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BatchDeleteEntitiesRequest) Reset()         { *m = BatchDeleteEntitiesRequest{} }
func (m *BatchDeleteEntitiesRequest) String() string { return proto.CompactTextString(m) }
func (*BatchDeleteEntitiesRequest) ProtoMessage()    {}
func (*BatchDeleteEntitiesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_270276916589f9d5, []int{12}
}

func (m *BatchDeleteEntitiesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchDeleteEntitiesRequest.Unmarshal(m, b)
}
func (m *BatchDeleteEntitiesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchDeleteEntitiesRequest.Marshal(b, m, deterministic)
}
func (m *BatchDeleteEntitiesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchDeleteEntitiesRequest.Merge(m, src)
}
func (m *BatchDeleteEntitiesRequest) XXX_Size() int {
	return xxx_messageInfo_BatchDeleteEntitiesRequest.Size(m)
}
func (m *BatchDeleteEntitiesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchDeleteEntitiesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchDeleteEntitiesRequest proto.InternalMessageInfo

func (m *BatchDeleteEntitiesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *BatchDeleteEntitiesRequest) GetEntityValues() []string {
	if m != nil {
		return m.EntityValues
	}
	return nil
}

func (m *BatchDeleteEntitiesRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// This message is a wrapper around a collection of entity types.
type EntityTypeBatch struct {
	// A collection of entity types.
	EntityTypes          []*EntityType `protobuf:"bytes,1,rep,name=entity_types,json=entityTypes,proto3" json:"entity_types,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *EntityTypeBatch) Reset()         { *m = EntityTypeBatch{} }
func (m *EntityTypeBatch) String() string { return proto.CompactTextString(m) }
func (*EntityTypeBatch) ProtoMessage()    {}
func (*EntityTypeBatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_270276916589f9d5, []int{13}
}

func (m *EntityTypeBatch) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EntityTypeBatch.Unmarshal(m, b)
}
func (m *EntityTypeBatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EntityTypeBatch.Marshal(b, m, deterministic)
}
func (m *EntityTypeBatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EntityTypeBatch.Merge(m, src)
}
func (m *EntityTypeBatch) XXX_Size() int {
	return xxx_messageInfo_EntityTypeBatch.Size(m)
}
func (m *EntityTypeBatch) XXX_DiscardUnknown() {
	xxx_messageInfo_EntityTypeBatch.DiscardUnknown(m)
}

var xxx_messageInfo_EntityTypeBatch proto.InternalMessageInfo

func (m *EntityTypeBatch) GetEntityTypes() []*EntityType {
	if m != nil {
		return m.EntityTypes
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.EntityType_Kind", EntityType_Kind_name, EntityType_Kind_value)
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.EntityType_AutoExpansionMode", EntityType_AutoExpansionMode_name, EntityType_AutoExpansionMode_value)
	proto.RegisterType((*EntityType)(nil), "google.cloud.dialogflow.v2beta1.EntityType")
	proto.RegisterType((*EntityType_Entity)(nil), "google.cloud.dialogflow.v2beta1.EntityType.Entity")
	proto.RegisterType((*ListEntityTypesRequest)(nil), "google.cloud.dialogflow.v2beta1.ListEntityTypesRequest")
	proto.RegisterType((*ListEntityTypesResponse)(nil), "google.cloud.dialogflow.v2beta1.ListEntityTypesResponse")
	proto.RegisterType((*GetEntityTypeRequest)(nil), "google.cloud.dialogflow.v2beta1.GetEntityTypeRequest")
	proto.RegisterType((*CreateEntityTypeRequest)(nil), "google.cloud.dialogflow.v2beta1.CreateEntityTypeRequest")
	proto.RegisterType((*UpdateEntityTypeRequest)(nil), "google.cloud.dialogflow.v2beta1.UpdateEntityTypeRequest")
	proto.RegisterType((*DeleteEntityTypeRequest)(nil), "google.cloud.dialogflow.v2beta1.DeleteEntityTypeRequest")
	proto.RegisterType((*BatchUpdateEntityTypesRequest)(nil), "google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest")
	proto.RegisterType((*BatchUpdateEntityTypesResponse)(nil), "google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesResponse")
	proto.RegisterType((*BatchDeleteEntityTypesRequest)(nil), "google.cloud.dialogflow.v2beta1.BatchDeleteEntityTypesRequest")
	proto.RegisterType((*BatchCreateEntitiesRequest)(nil), "google.cloud.dialogflow.v2beta1.BatchCreateEntitiesRequest")
	proto.RegisterType((*BatchUpdateEntitiesRequest)(nil), "google.cloud.dialogflow.v2beta1.BatchUpdateEntitiesRequest")
	proto.RegisterType((*BatchDeleteEntitiesRequest)(nil), "google.cloud.dialogflow.v2beta1.BatchDeleteEntitiesRequest")
	proto.RegisterType((*EntityTypeBatch)(nil), "google.cloud.dialogflow.v2beta1.EntityTypeBatch")
}

func init() {
	proto.RegisterFile("google/cloud/dialogflow/v2beta1/entity_type.proto", fileDescriptor_270276916589f9d5)
}

var fileDescriptor_270276916589f9d5 = []byte{
	// 1381 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x58, 0xdf, 0x6f, 0xdb, 0xd4,
	0x17, 0xdf, 0x75, 0xb3, 0xaa, 0x3d, 0x69, 0xbf, 0xcd, 0xee, 0xb6, 0x36, 0xdf, 0x6c, 0xa3, 0xc5,
	0x95, 0x50, 0x55, 0x58, 0xcc, 0x32, 0x21, 0xa0, 0x63, 0x48, 0x69, 0x93, 0x6e, 0xd1, 0xfa, 0x8b,
	0xb4, 0x9d, 0x58, 0x5f, 0x22, 0x37, 0xb9, 0xcd, 0x4c, 0x9d, 0x7b, 0x4d, 0x7c, 0xb3, 0x2d, 0x43,
	0x43, 0x82, 0x27, 0x24, 0x40, 0x08, 0xed, 0x0d, 0x09, 0x09, 0x0d, 0x24, 0x34, 0x24, 0xfe, 0x10,
	0x78, 0x42, 0xf0, 0xc6, 0x33, 0x42, 0xe2, 0x3f, 0x40, 0x3c, 0x21, 0x5f, 0xdb, 0xb1, 0xe3, 0x38,
	0xb5, 0xad, 0x76, 0x13, 0x6f, 0xb9, 0x3f, 0xce, 0x8f, 0xcf, 0xe7, 0x9c, 0x73, 0xcf, 0x71, 0xe0,
	0x4a, 0x93, 0xb1, 0xa6, 0x4e, 0x94, 0xba, 0xce, 0x3a, 0x0d, 0xa5, 0xa1, 0xa9, 0x3a, 0x6b, 0x1e,
	0xe8, 0xec, 0xbe, 0x72, 0xaf, 0xb0, 0x4f, 0xb8, 0x7a, 0x45, 0x21, 0x94, 0x6b, 0xbc, 0x5b, 0xe3,
	0x5d, 0x83, 0xe4, 0x8d, 0x36, 0xe3, 0x0c, 0xcf, 0xda, 0x22, 0x79, 0x21, 0x92, 0xf7, 0x44, 0xf2,
	0x8e, 0x48, 0xee, 0xa2, 0xa3, 0x53, 0x35, 0x34, 0x45, 0xa5, 0x94, 0x71, 0x95, 0x6b, 0x8c, 0x9a,
	0xb6, 0x78, 0x6e, 0xde, 0x39, 0xd5, 0x19, 0x6d, 0xb6, 0x3b, 0x94, 0x6a, 0xb4, 0xa9, 0x30, 0x83,
	0xb4, 0xfb, 0x2e, 0x5d, 0x70, 0x2e, 0x89, 0xd5, 0x7e, 0xe7, 0x40, 0x21, 0x2d, 0x83, 0x77, 0x9d,
	0xc3, 0xb9, 0xe0, 0xe1, 0x81, 0x46, 0xf4, 0x46, 0xad, 0xa5, 0x9a, 0x87, 0xce, 0x8d, 0x8b, 0xc1,
	0x1b, 0x26, 0x6f, 0x77, 0xea, 0xdc, 0x39, 0x9d, 0xf1, 0xf9, 0x57, 0xd7, 0x35, 0x42, 0x9d, 0x03,
	0xf9, 0xab, 0x14, 0x40, 0x59, 0xe0, 0xdd, 0xe9, 0x1a, 0x04, 0x63, 0x48, 0x51, 0xb5, 0x45, 0xb2,
	0x68, 0x0e, 0x2d, 0x8c, 0x57, 0xc5, 0x6f, 0xfc, 0x22, 0x4c, 0x34, 0x34, 0xd3, 0xd0, 0xd5, 0x6e,
	0x4d, 0x9c, 0x49, 0xe2, 0x2c, 0xed, 0xec, 0x6d, 0x58, 0x57, 0x4a, 0x90, 0x3a, 0xd4, 0x68, 0x23,
	0x3b, 0x32, 0x87, 0x16, 0xfe, 0x57, 0x78, 0x35, 0x1f, 0x41, 0x57, 0xde, 0xb3, 0x98, 0xbf, 0xa5,
	0xd1, 0x46, 0x55, 0x48, 0xe3, 0x16, 0x9c, 0x55, 0x3b, 0x9c, 0xd5, 0xc8, 0x03, 0x43, 0xa5, 0xa6,
	0xc6, 0x68, 0xad, 0xc5, 0x1a, 0x24, 0x9b, 0x12, 0x4a, 0xaf, 0x27, 0x51, 0x5a, 0xec, 0x70, 0x56,
	0x76, 0xb5, 0xac, 0xb3, 0x06, 0xa9, 0x9e, 0x51, 0x83, 0x5b, 0x78, 0x03, 0xc6, 0x44, 0xa4, 0x35,
	0x62, 0x66, 0x47, 0xe7, 0x46, 0x16, 0xd2, 0x85, 0x42, 0x12, 0x1b, 0xf6, 0xcf, 0x6a, 0x4f, 0x47,
	0x6e, 0x09, 0x46, 0xed, 0x3d, 0x7c, 0x0e, 0x4e, 0xdf, 0x53, 0xf5, 0x8e, 0x4b, 0xa3, 0xbd, 0xc0,
	0x39, 0x18, 0x33, 0xbb, 0x94, 0xd1, 0x6e, 0xcb, 0xcc, 0x4a, 0x73, 0x23, 0x0b, 0xe3, 0xd5, 0xde,
	0x5a, 0x7e, 0x13, 0x52, 0x16, 0x11, 0xf8, 0x1c, 0x64, 0x6e, 0x55, 0x36, 0x4a, 0xb5, 0xdd, 0x8d,
	0xed, 0xad, 0xf2, 0x4a, 0x65, 0xb5, 0x52, 0x2e, 0x65, 0x4e, 0xe1, 0x09, 0x18, 0x13, 0xbb, 0xeb,
	0xc5, 0xad, 0x0c, 0xc2, 0x93, 0x30, 0x2e, 0x56, 0x6b, 0x95, 0xed, 0x9d, 0x8c, 0x24, 0xdf, 0x81,
	0x33, 0x03, 0x70, 0xf1, 0x3c, 0xcc, 0x16, 0x77, 0x77, 0x36, 0x6b, 0xe5, 0x77, 0xb7, 0x8a, 0x1b,
	0xdb, 0x95, 0xcd, 0x8d, 0xda, 0xfa, 0x66, 0xa9, 0x1c, 0x50, 0x3b, 0x0b, 0x17, 0xc2, 0x2e, 0x95,
	0xca, 0xab, 0xc5, 0xdd, 0xb5, 0x9d, 0x0c, 0x92, 0xbf, 0x44, 0x30, 0xbd, 0xa6, 0x99, 0xdc, 0x43,
	0x6d, 0x56, 0xc9, 0xfb, 0x1d, 0x62, 0x72, 0x3c, 0x0d, 0xa3, 0x86, 0xda, 0x26, 0x94, 0x3b, 0x18,
	0x9d, 0x15, 0x9e, 0x87, 0x49, 0x5d, 0xa5, 0xcd, 0x8e, 0xda, 0x24, 0xb5, 0xba, 0x15, 0x3d, 0x3b,
	0x5b, 0x26, 0xdc, 0xcd, 0x15, 0xcb, 0xbb, 0x0b, 0x30, 0x6e, 0x58, 0x17, 0x4c, 0xed, 0x21, 0x11,
	0x39, 0x73, 0xba, 0x3a, 0x66, 0x6d, 0x6c, 0x6b, 0x0f, 0x09, 0xbe, 0x04, 0x20, 0x0e, 0x39, 0x3b,
	0x24, 0x54, 0x04, 0x7f, 0xbc, 0x2a, 0xae, 0xef, 0x58, 0x1b, 0x96, 0x4f, 0x33, 0x03, 0x3e, 0x99,
	0x06, 0xa3, 0xa6, 0x15, 0xd1, 0x09, 0x5f, 0xed, 0x9a, 0x59, 0x24, 0xa2, 0xfa, 0x72, 0x82, 0xa8,
	0x56, 0xd3, 0xc4, 0xd3, 0x8b, 0x5f, 0x82, 0x29, 0x4a, 0x1e, 0xf0, 0x9a, 0xcf, 0x1f, 0x1b, 0xce,
	0xa4, 0xb5, 0xbd, 0xd5, 0xf3, 0x69, 0x13, 0xce, 0xdd, 0x20, 0x3e, 0x8f, 0x5c, 0x92, 0xc2, 0xaa,
	0x29, 0x0e, 0x41, 0xf2, 0x77, 0x08, 0x66, 0x56, 0xda, 0x44, 0xe5, 0x64, 0x50, 0xe9, 0x30, 0xe6,
	0xd7, 0x20, 0xed, 0x03, 0x2f, 0xd4, 0x26, 0xc4, 0x0e, 0x1e, 0xf6, 0x41, 0x37, 0x47, 0x42, 0xdc,
	0xfc, 0x09, 0xc1, 0xcc, 0xae, 0xd1, 0x08, 0x75, 0x33, 0xe0, 0x0e, 0x3a, 0x61, 0x77, 0xc2, 0xd2,
	0xea, 0x1a, 0xa4, 0x3b, 0xc2, 0x1b, 0xf1, 0x2e, 0x0a, 0x8f, 0xd3, 0x85, 0x9c, 0x6b, 0xd2, 0x7d,
	0x18, 0xf3, 0xab, 0xd6, 0xd3, 0xb9, 0xae, 0x9a, 0x87, 0x55, 0xb0, 0xaf, 0x5b, 0xbf, 0xe5, 0xcb,
	0x30, 0x53, 0x22, 0x3a, 0x09, 0x83, 0x12, 0x12, 0x46, 0xf9, 0x17, 0x09, 0x2e, 0x2d, 0xab, 0xbc,
	0x7e, 0x37, 0x88, 0x3f, 0xb2, 0x42, 0xae, 0xc2, 0x79, 0x1f, 0x31, 0xb5, 0x7d, 0x4b, 0x49, 0xad,
	0xd3, 0xd6, 0x6c, 0x48, 0x37, 0x4f, 0x55, 0xb1, 0x87, 0xdb, 0xb6, 0xd0, 0xd6, 0xf0, 0x21, 0x64,
	0x07, 0x85, 0x34, 0xaa, 0x6b, 0x94, 0x38, 0x38, 0x93, 0x3c, 0xba, 0x42, 0xed, 0xcd, 0x53, 0xd5,
	0xf3, 0x01, 0x4b, 0x15, 0xa1, 0x70, 0x90, 0xec, 0x54, 0x34, 0xd9, 0xa7, 0x93, 0x90, 0xbd, 0x7c,
	0x16, 0xce, 0x0c, 0xc0, 0x91, 0x0d, 0x78, 0x61, 0x18, 0xa3, 0xcf, 0xa6, 0xbe, 0xe5, 0xba, 0x13,
	0xc3, 0x60, 0xe0, 0x23, 0x63, 0xb8, 0xd8, 0xef, 0xbf, 0x95, 0x11, 0xee, 0x9b, 0x3e, 0xe5, 0x19,
	0xb0, 0x5a, 0xa3, 0x29, 0x3f, 0x45, 0x90, 0x13, 0x56, 0x7c, 0x05, 0xad, 0x45, 0x9b, 0xf0, 0x77,
	0x27, 0xe9, 0xf8, 0xdd, 0x29, 0x5e, 0x41, 0xff, 0xe9, 0xfa, 0xea, 0x8b, 0xc1, 0x7f, 0xd4, 0xd7,
	0x60, 0x02, 0xa6, 0x12, 0x55, 0xfb, 0x87, 0x0e, 0x4e, 0x5f, 0xe4, 0xb5, 0x58, 0xcd, 0xcd, 0x09,
	0xbb, 0xe8, 0xe8, 0x6e, 0xc8, 0x9d, 0xa4, 0xbc, 0x2d, 0xf6, 0xe2, 0x11, 0xad, 0xc2, 0x54, 0xa0,
	0x1c, 0x4f, 0x3a, 0xb9, 0x0b, 0x1f, 0x4d, 0x43, 0xda, 0x97, 0xd2, 0xf8, 0x1f, 0x04, 0x53, 0x81,
	0xc6, 0x89, 0x5f, 0x8f, 0xd4, 0x1e, 0xde, 0xfe, 0x73, 0x6f, 0x24, 0x17, 0xb4, 0x6b, 0x58, 0xe6,
	0x1f, 0xff, 0xf6, 0xc7, 0x63, 0x89, 0xe2, 0x7c, 0x6f, 0xdc, 0xfe, 0xc0, 0x66, 0xf7, 0xba, 0xd1,
	0x66, 0xef, 0x91, 0x3a, 0x37, 0x95, 0x45, 0x45, 0x6d, 0x12, 0xca, 0x1f, 0x29, 0x3e, 0x38, 0x7b,
	0x6f, 0xe1, 0xa5, 0xa3, 0x24, 0x74, 0x56, 0xb7, 0xa7, 0xe9, 0x50, 0x69, 0xfc, 0x17, 0x82, 0xc9,
	0xbe, 0x16, 0x8d, 0x5f, 0x8b, 0x44, 0x10, 0xd6, 0xd2, 0x73, 0x49, 0xe2, 0x11, 0x86, 0xd5, 0x7a,
	0x2a, 0x06, 0x90, 0xfa, 0x5d, 0x55, 0x16, 0x1f, 0xf5, 0x63, 0x0d, 0x4a, 0x0c, 0x20, 0x0d, 0x48,
	0xe3, 0x4f, 0x25, 0xc8, 0x04, 0x87, 0x07, 0x1c, 0x1d, 0xb0, 0x21, 0xf3, 0x46, 0x32, 0xc4, 0x5f,
	0x20, 0x01, 0xf9, 0x13, 0x24, 0x27, 0x8c, 0xef, 0x92, 0x7f, 0x5a, 0xd8, 0xab, 0xc8, 0xc7, 0x08,
	0x76, 0x9f, 0x2a, 0xfc, 0xad, 0x04, 0x99, 0x60, 0x47, 0x89, 0xc1, 0xc6, 0x90, 0xb1, 0x26, 0x19,
	0x1b, 0xdf, 0xdb, 0x6c, 0x7c, 0x83, 0x0a, 0x3e, 0x38, 0xfe, 0xaf, 0xcb, 0x38, 0xd9, 0xd0, 0xcf,
	0xcc, 0x6e, 0x61, 0x35, 0x9e, 0xaa, 0xa8, 0x34, 0xe9, 0x67, 0xe9, 0x77, 0x04, 0x99, 0x60, 0x17,
	0x8c, 0xc1, 0xd2, 0x90, 0x89, 0x29, 0x37, 0x3d, 0xf0, 0x0c, 0x97, 0xad, 0x8f, 0x59, 0xb7, 0x20,
	0x16, 0x13, 0x17, 0xc4, 0xe2, 0x71, 0x0a, 0xe2, 0x73, 0x09, 0xa6, 0xc3, 0x27, 0x0b, 0xfc, 0x76,
	0x24, 0xc4, 0x23, 0x87, 0xbc, 0xdc, 0x25, 0x57, 0xde, 0xf7, 0x69, 0x9f, 0xdf, 0x74, 0x3f, 0xed,
	0xe5, 0xc7, 0x76, 0x02, 0x7c, 0x86, 0x8e, 0xce, 0xe7, 0x90, 0x1c, 0xde, 0xf7, 0xcc, 0x2e, 0xa1,
	0xc5, 0xbd, 0x5b, 0xf2, 0xea, 0x31, 0x0a, 0xa2, 0x5f, 0x99, 0xc7, 0xc7, 0xc0, 0xdc, 0x13, 0x97,
	0x8f, 0x61, 0x03, 0xd3, 0x33, 0xe6, 0xc3, 0x36, 0x7b, 0x42, 0x7c, 0xf4, 0x94, 0xe1, 0xaf, 0x25,
	0x38, 0x1b, 0x32, 0xa1, 0xe1, 0x6b, 0xf1, 0xc8, 0x08, 0x9d, 0xeb, 0xa2, 0x98, 0x78, 0x6a, 0x33,
	0xf1, 0x04, 0xc9, 0xe5, 0x48, 0x26, 0x02, 0xf9, 0xac, 0xb8, 0x73, 0x92, 0x8d, 0xc3, 0x36, 0x6f,
	0x91, 0x72, 0x5b, 0x7e, 0x27, 0x11, 0x29, 0x31, 0xf5, 0x7a, 0xfc, 0xf4, 0x4f, 0x85, 0x71, 0xf9,
	0x09, 0x9d, 0x25, 0x9f, 0x1f, 0x3f, 0x5e, 0x11, 0x9d, 0x2c, 0x3f, 0x5e, 0x3d, 0xf5, 0xf8, 0xe9,
	0x9f, 0x26, 0xe3, 0xf2, 0x13, 0x3a, 0x83, 0x3e, 0x3f, 0x7e, 0xbc, 0xa2, 0x3a, 0x59, 0x7e, 0x7a,
	0x7a, 0x73, 0x0f, 0x7e, 0x2e, 0xfe, 0xdf, 0x07, 0xde, 0xc6, 0xa5, 0x1a, 0x9a, 0x99, 0xaf, 0xb3,
	0xd6, 0xaf, 0xc5, 0x3b, 0x77, 0x39, 0x37, 0xcc, 0x25, 0x45, 0xb9, 0x7f, 0x3f, 0x78, 0xa8, 0xa8,
	0x1d, 0x7e, 0xd7, 0xfe, 0xa3, 0xf6, 0xb2, 0xa1, 0xab, 0xfc, 0x80, 0xb5, 0x5b, 0xaf, 0x44, 0x5d,
	0xf7, 0x4c, 0x2d, 0xff, 0x88, 0x60, 0xbe, 0xce, 0x5a, 0x51, 0x71, 0x58, 0xf6, 0x0d, 0xe3, 0x5b,
	0x56, 0xc7, 0xda, 0x42, 0x7b, 0x15, 0x47, 0xa6, 0xc9, 0xac, 0xc1, 0x3d, 0xcf, 0xda, 0x4d, 0xa5,
	0x49, 0xa8, 0xe8, 0x67, 0x8a, 0x67, 0x75, 0xe8, 0x9f, 0xc8, 0xd7, 0xbc, 0xad, 0xbf, 0x11, 0x7a,
	0x22, 0x49, 0xa5, 0xd5, 0x1f, 0xa4, 0xd9, 0x1b, 0xb6, 0xce, 0x15, 0xe1, 0x47, 0xc9, 0xf3, 0xe3,
	0xb6, 0x2d, 0xb4, 0x3f, 0x2a, 0xf4, 0x5f, 0xfd, 0x37, 0x00, 0x00, 0xff, 0xff, 0xef, 0xf8, 0x31,
	0xf4, 0xa3, 0x16, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// EntityTypesClient is the client API for EntityTypes service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type EntityTypesClient interface {
	// Returns the list of all entity types in the specified agent.
	ListEntityTypes(ctx context.Context, in *ListEntityTypesRequest, opts ...grpc.CallOption) (*ListEntityTypesResponse, error)
	// Retrieves the specified entity type.
	GetEntityType(ctx context.Context, in *GetEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error)
	// Creates an entity type in the specified agent.
	CreateEntityType(ctx context.Context, in *CreateEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error)
	// Updates the specified entity type.
	UpdateEntityType(ctx context.Context, in *UpdateEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error)
	// Deletes the specified entity type.
	DeleteEntityType(ctx context.Context, in *DeleteEntityTypeRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Updates/Creates multiple entity types in the specified agent.
	//
	// Operation <response: [BatchUpdateEntityTypesResponse][google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesResponse]>
	BatchUpdateEntityTypes(ctx context.Context, in *BatchUpdateEntityTypesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes entity types in the specified agent.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	BatchDeleteEntityTypes(ctx context.Context, in *BatchDeleteEntityTypesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Creates multiple new entities in the specified entity type.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	BatchCreateEntities(ctx context.Context, in *BatchCreateEntitiesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates or creates multiple entities in the specified entity type. This
	// method does not affect entities in the entity type that aren't explicitly
	// specified in the request.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	BatchUpdateEntities(ctx context.Context, in *BatchUpdateEntitiesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes entities in the specified entity type.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	BatchDeleteEntities(ctx context.Context, in *BatchDeleteEntitiesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type entityTypesClient struct {
	cc *grpc.ClientConn
}

func NewEntityTypesClient(cc *grpc.ClientConn) EntityTypesClient {
	return &entityTypesClient{cc}
}

func (c *entityTypesClient) ListEntityTypes(ctx context.Context, in *ListEntityTypesRequest, opts ...grpc.CallOption) (*ListEntityTypesResponse, error) {
	out := new(ListEntityTypesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.EntityTypes/ListEntityTypes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) GetEntityType(ctx context.Context, in *GetEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error) {
	out := new(EntityType)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.EntityTypes/GetEntityType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) CreateEntityType(ctx context.Context, in *CreateEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error) {
	out := new(EntityType)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.EntityTypes/CreateEntityType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) UpdateEntityType(ctx context.Context, in *UpdateEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error) {
	out := new(EntityType)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.EntityTypes/UpdateEntityType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) DeleteEntityType(ctx context.Context, in *DeleteEntityTypeRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.EntityTypes/DeleteEntityType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) BatchUpdateEntityTypes(ctx context.Context, in *BatchUpdateEntityTypesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.EntityTypes/BatchUpdateEntityTypes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) BatchDeleteEntityTypes(ctx context.Context, in *BatchDeleteEntityTypesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.EntityTypes/BatchDeleteEntityTypes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) BatchCreateEntities(ctx context.Context, in *BatchCreateEntitiesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.EntityTypes/BatchCreateEntities", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) BatchUpdateEntities(ctx context.Context, in *BatchUpdateEntitiesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.EntityTypes/BatchUpdateEntities", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) BatchDeleteEntities(ctx context.Context, in *BatchDeleteEntitiesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.EntityTypes/BatchDeleteEntities", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// EntityTypesServer is the server API for EntityTypes service.
type EntityTypesServer interface {
	// Returns the list of all entity types in the specified agent.
	ListEntityTypes(context.Context, *ListEntityTypesRequest) (*ListEntityTypesResponse, error)
	// Retrieves the specified entity type.
	GetEntityType(context.Context, *GetEntityTypeRequest) (*EntityType, error)
	// Creates an entity type in the specified agent.
	CreateEntityType(context.Context, *CreateEntityTypeRequest) (*EntityType, error)
	// Updates the specified entity type.
	UpdateEntityType(context.Context, *UpdateEntityTypeRequest) (*EntityType, error)
	// Deletes the specified entity type.
	DeleteEntityType(context.Context, *DeleteEntityTypeRequest) (*empty.Empty, error)
	// Updates/Creates multiple entity types in the specified agent.
	//
	// Operation <response: [BatchUpdateEntityTypesResponse][google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesResponse]>
	BatchUpdateEntityTypes(context.Context, *BatchUpdateEntityTypesRequest) (*longrunning.Operation, error)
	// Deletes entity types in the specified agent.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	BatchDeleteEntityTypes(context.Context, *BatchDeleteEntityTypesRequest) (*longrunning.Operation, error)
	// Creates multiple new entities in the specified entity type.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	BatchCreateEntities(context.Context, *BatchCreateEntitiesRequest) (*longrunning.Operation, error)
	// Updates or creates multiple entities in the specified entity type. This
	// method does not affect entities in the entity type that aren't explicitly
	// specified in the request.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	BatchUpdateEntities(context.Context, *BatchUpdateEntitiesRequest) (*longrunning.Operation, error)
	// Deletes entities in the specified entity type.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	BatchDeleteEntities(context.Context, *BatchDeleteEntitiesRequest) (*longrunning.Operation, error)
}

func RegisterEntityTypesServer(s *grpc.Server, srv EntityTypesServer) {
	s.RegisterService(&_EntityTypes_serviceDesc, srv)
}

func _EntityTypes_ListEntityTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEntityTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).ListEntityTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.EntityTypes/ListEntityTypes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).ListEntityTypes(ctx, req.(*ListEntityTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_GetEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).GetEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.EntityTypes/GetEntityType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).GetEntityType(ctx, req.(*GetEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_CreateEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).CreateEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.EntityTypes/CreateEntityType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).CreateEntityType(ctx, req.(*CreateEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_UpdateEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).UpdateEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.EntityTypes/UpdateEntityType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).UpdateEntityType(ctx, req.(*UpdateEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_DeleteEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).DeleteEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.EntityTypes/DeleteEntityType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).DeleteEntityType(ctx, req.(*DeleteEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_BatchUpdateEntityTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdateEntityTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).BatchUpdateEntityTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.EntityTypes/BatchUpdateEntityTypes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).BatchUpdateEntityTypes(ctx, req.(*BatchUpdateEntityTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_BatchDeleteEntityTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteEntityTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).BatchDeleteEntityTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.EntityTypes/BatchDeleteEntityTypes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).BatchDeleteEntityTypes(ctx, req.(*BatchDeleteEntityTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_BatchCreateEntities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateEntitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).BatchCreateEntities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.EntityTypes/BatchCreateEntities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).BatchCreateEntities(ctx, req.(*BatchCreateEntitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_BatchUpdateEntities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdateEntitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).BatchUpdateEntities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.EntityTypes/BatchUpdateEntities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).BatchUpdateEntities(ctx, req.(*BatchUpdateEntitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_BatchDeleteEntities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteEntitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).BatchDeleteEntities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.EntityTypes/BatchDeleteEntities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).BatchDeleteEntities(ctx, req.(*BatchDeleteEntitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _EntityTypes_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2beta1.EntityTypes",
	HandlerType: (*EntityTypesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListEntityTypes",
			Handler:    _EntityTypes_ListEntityTypes_Handler,
		},
		{
			MethodName: "GetEntityType",
			Handler:    _EntityTypes_GetEntityType_Handler,
		},
		{
			MethodName: "CreateEntityType",
			Handler:    _EntityTypes_CreateEntityType_Handler,
		},
		{
			MethodName: "UpdateEntityType",
			Handler:    _EntityTypes_UpdateEntityType_Handler,
		},
		{
			MethodName: "DeleteEntityType",
			Handler:    _EntityTypes_DeleteEntityType_Handler,
		},
		{
			MethodName: "BatchUpdateEntityTypes",
			Handler:    _EntityTypes_BatchUpdateEntityTypes_Handler,
		},
		{
			MethodName: "BatchDeleteEntityTypes",
			Handler:    _EntityTypes_BatchDeleteEntityTypes_Handler,
		},
		{
			MethodName: "BatchCreateEntities",
			Handler:    _EntityTypes_BatchCreateEntities_Handler,
		},
		{
			MethodName: "BatchUpdateEntities",
			Handler:    _EntityTypes_BatchUpdateEntities_Handler,
		},
		{
			MethodName: "BatchDeleteEntities",
			Handler:    _EntityTypes_BatchDeleteEntities_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2beta1/entity_type.proto",
}
