# go-dbus-factory

Convenient go binding code for automating the generation of DBUS services.

## Dependencies
You can also check the "Depends" provided in the `debian/control` file.

### Build dependencies
You can also check the "Build-Depends" provided in the `debian/control` file.

## Tools

If you are debian user, you can use

```bash
make bin
```

to generate an executable file called `generater`. It can be used to auto-generate code, like

```bash
./generator org.freedesktop.notifications
```

If you want to use gomod, run:

```bash

cd ./_tool/generator

go build

mv ./generator ../../
```

To generator all interface, run the command

```bash
./gen.sh
```

The shell script will find all folders which contain `config.json` can generate the code

### Folders

The tool will generate the code to a folder, the name of the folder always be the name of that service, which is all lower case.

The package name of that go project under that folder always be the last word of the stringlist by splitting the name of the service by `.`.

You can assess the default xml, config.json and go code under the folder which is generated.

### Default xml

You can get default xml by `gdbus introspect`. For example, you can get the default xml of /org/freedesktop/Notification by:

```bash
gdbus introspect -e -d org.freedesktop.Notifications -o /org/freedesktop/Notifications -x > Notifications.xml
```

The tag of root element of the xml is `node`. The name of the xml files should be consistent with the value of `Type` in the node of `Objects` in file `config.json`.

### config.json

For example, like the config file of org.freedesktop.Notificationn.
```json
{
  "Service": "org.freedesktop.Notifications",
  "Objects": [
    {
      "Type": "Notifications",
      "Path": "/org/freedesktop/Notifications",
      "Interfaces": [
        {
          "Name": "org.freedesktop.Notifications",
          "Type": "notifications"
        }
      ]
    }
  ]
}
```

You can take a view to the code `_tool/generator/config.go` to know the detail.

In Object, if the path is fixed, you need to set the value of `Path`, else, you should not set the value of `Path`.

If the Object has multiple interfaces, then you need to set the key of `Accessor` of `interfaceConfig`, if there is one, then it is not needed.

If the Object has the interface of `org.freedesktop.DBus.ObjectManager`, then you need just set the key of `Name`, `generator` will handle it properly.

The value of `Type` is consistent with the struct name in auto.go. For example, you can take a view of `ObjectCofig` and `InterfaceConfig`.

### Fix to the interface

When the function is property or signal , you need to use key `Fixes` to mark that the functions are not dbus method but other types. The class type of the value of `Fixes` is `map[string]json.Rawmessage`.

The usable key name is

* property -> `p/`
* method -> `m/`
* signal -> `s/`

For example, if you want to mark the node `Name` in Interface is `property`, you should set the value of `Fixes` to `p/Name`. Here is an example fot the json

```json
{
  "Service": "org.freedesktop.ColorManager",
  "Objects": [
    {
      "Type": "Manager",
      "Path": "/org/freedesktop/ColorManager",
      "Interfaces": [
        {
          "Name": "org.freedesktop.ColorManager",
          "Type": "manager"
        }
      ]
    },
    {
      "Type": "Profile",
      "Interfaces": [
        {
          "Name": "org.freedesktop.ColorManager.Profile",
          "Type": "profile",
          "Fixes": {
            "p/Metadata": {
              "Type": "PropProfileMetadata",
              "ValueType": "map[string]string"
            }
          }
        }
      ]
    }
  ]
}
```

You should set the value of key `Fixed`, if it the node is dbus property, or that the generator will panic. You are allowed not to set `Fixed` for method and signal, but you will receive warning message like

```
Warning: found []interface{} in org.freedesktop.login1.Manager.CreateSession arg properties
```

### The code generated
The code generated by generator is named `auto.go`. If the code is writtened manually, we always name it as `manual.go`.

`manual.go` always is the supplement for `auto.go`

## Installation

### Build from source code

Make sure you have installed all dependencies.

This Makefile is not used in package, as methoned befored, it is used to generate code. Since now we use debian go build to package it, and if you are archlinux user, you can take a look at `archlinux/PKGBUILD`.

If you are debian user, use dpkg

```bash
dpkg-buildpackage -us -uc
```

Then you can find some `*.deb` files in the parent directory.

If you are archlinux user or Nixos user, we suggest you to use go mod instead, you do not need to package it. Like `startdde`, just run `go mod tidy`, the package will be included, then you can start packaging.


## Getting help

Any usage issues can ask for help via

* [Matrix](https://matrix.to/#/#deepin-community:matrix.org)
* [WiKi](https://wiki.deepin.org)
* [Forum](https://bbs.deepin.org)
* [Developer Center](https://github.com/linuxdeepin/developer-center/issues) 

## Getting involved

We encourage you to report issues and contribute changes

- [**Contribution guide for developers**](https://github.com/linuxdeepin/developer-center/wiki/Contribution-Guidelines-for-Developers-en) 

## License
go-dbus-factory is licensed under [GPL-3.0-or-later](LICENSE).
