package sql

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/gofrs/uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/sql/mgmt/v5.0/sql"

// AdministratorListResult a list of active directory administrators.
type AdministratorListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ServerAzureADAdministrator `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AdministratorListResult.
func (alr AdministratorListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AdministratorListResultIterator provides access to a complete listing of ServerAzureADAdministrator
// values.
type AdministratorListResultIterator struct {
	i    int
	page AdministratorListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AdministratorListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AdministratorListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AdministratorListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AdministratorListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AdministratorListResultIterator) Response() AdministratorListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AdministratorListResultIterator) Value() ServerAzureADAdministrator {
	if !iter.page.NotDone() {
		return ServerAzureADAdministrator{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AdministratorListResultIterator type.
func NewAdministratorListResultIterator(page AdministratorListResultPage) AdministratorListResultIterator {
	return AdministratorListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (alr AdministratorListResult) IsEmpty() bool {
	return alr.Value == nil || len(*alr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (alr AdministratorListResult) hasNextLink() bool {
	return alr.NextLink != nil && len(*alr.NextLink) != 0
}

// administratorListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (alr AdministratorListResult) administratorListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !alr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(alr.NextLink)))
}

// AdministratorListResultPage contains a page of ServerAzureADAdministrator values.
type AdministratorListResultPage struct {
	fn  func(context.Context, AdministratorListResult) (AdministratorListResult, error)
	alr AdministratorListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AdministratorListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AdministratorListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.alr)
		if err != nil {
			return err
		}
		page.alr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AdministratorListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AdministratorListResultPage) NotDone() bool {
	return !page.alr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AdministratorListResultPage) Response() AdministratorListResult {
	return page.alr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AdministratorListResultPage) Values() []ServerAzureADAdministrator {
	if page.alr.IsEmpty() {
		return nil
	}
	return *page.alr.Value
}

// Creates a new instance of the AdministratorListResultPage type.
func NewAdministratorListResultPage(cur AdministratorListResult, getNextPage func(context.Context, AdministratorListResult) (AdministratorListResult, error)) AdministratorListResultPage {
	return AdministratorListResultPage{
		fn:  getNextPage,
		alr: cur,
	}
}

// AdministratorProperties properties of a active directory administrator.
type AdministratorProperties struct {
	// AdministratorType - Type of the sever administrator.
	AdministratorType *string `json:"administratorType,omitempty"`
	// Login - Login name of the server administrator.
	Login *string `json:"login,omitempty"`
	// Sid - SID (object ID) of the server administrator.
	Sid *uuid.UUID `json:"sid,omitempty"`
	// TenantID - Tenant ID of the administrator.
	TenantID *uuid.UUID `json:"tenantId,omitempty"`
	// AzureADOnlyAuthentication - READ-ONLY; Azure Active Directory only Authentication enabled.
	AzureADOnlyAuthentication *bool `json:"azureADOnlyAuthentication,omitempty"`
}

// MarshalJSON is the custom marshaler for AdministratorProperties.
func (ap AdministratorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.AdministratorType != nil {
		objectMap["administratorType"] = ap.AdministratorType
	}
	if ap.Login != nil {
		objectMap["login"] = ap.Login
	}
	if ap.Sid != nil {
		objectMap["sid"] = ap.Sid
	}
	if ap.TenantID != nil {
		objectMap["tenantId"] = ap.TenantID
	}
	return json.Marshal(objectMap)
}

// AdvancedThreatProtectionProperties properties of an Advanced Threat Protection state.
type AdvancedThreatProtectionProperties struct {
	// State - Specifies the state of the Advanced Threat Protection, whether it is enabled or disabled or a state has not been applied yet on the specific database or server. Possible values include: 'AdvancedThreatProtectionStateNew', 'AdvancedThreatProtectionStateEnabled', 'AdvancedThreatProtectionStateDisabled'
	State AdvancedThreatProtectionState `json:"state,omitempty"`
	// CreationTime - READ-ONLY; Specifies the UTC creation time of the policy.
	CreationTime *date.Time `json:"creationTime,omitempty"`
}

// MarshalJSON is the custom marshaler for AdvancedThreatProtectionProperties.
func (atpp AdvancedThreatProtectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if atpp.State != "" {
		objectMap["state"] = atpp.State
	}
	return json.Marshal(objectMap)
}

// Advisor database, Server or Elastic Pool Advisor.
type Advisor struct {
	autorest.Response `json:"-"`
	// Kind - READ-ONLY; Resource kind.
	Kind *string `json:"kind,omitempty"`
	// Location - READ-ONLY; Resource location.
	Location *string `json:"location,omitempty"`
	// AdvisorProperties - Resource properties.
	*AdvisorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Advisor.
func (a Advisor) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.AdvisorProperties != nil {
		objectMap["properties"] = a.AdvisorProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Advisor struct.
func (a *Advisor) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				a.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				a.Location = &location
			}
		case "properties":
			if v != nil {
				var advisorProperties AdvisorProperties
				err = json.Unmarshal(*v, &advisorProperties)
				if err != nil {
					return err
				}
				a.AdvisorProperties = &advisorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		}
	}

	return nil
}

// AdvisorProperties properties for a Database, Server or Elastic Pool Advisor.
type AdvisorProperties struct {
	// AdvisorStatus - READ-ONLY; Gets the status of availability of this advisor to customers. Possible values are 'GA', 'PublicPreview', 'LimitedPublicPreview' and 'PrivatePreview'. Possible values include: 'AdvisorStatusGA', 'AdvisorStatusPublicPreview', 'AdvisorStatusLimitedPublicPreview', 'AdvisorStatusPrivatePreview'
	AdvisorStatus AdvisorStatus `json:"advisorStatus,omitempty"`
	// AutoExecuteStatus - Gets the auto-execute status (whether to let the system execute the recommendations) of this advisor. Possible values are 'Enabled' and 'Disabled'. Possible values include: 'AutoExecuteStatusEnabled', 'AutoExecuteStatusDisabled', 'AutoExecuteStatusDefault'
	AutoExecuteStatus AutoExecuteStatus `json:"autoExecuteStatus,omitempty"`
	// AutoExecuteStatusInheritedFrom - READ-ONLY; Gets the resource from which current value of auto-execute status is inherited. Auto-execute status can be set on (and inherited from) different levels in the resource hierarchy. Possible values are 'Subscription', 'Server', 'ElasticPool', 'Database' and 'Default' (when status is not explicitly set on any level). Possible values include: 'AutoExecuteStatusInheritedFromDefault', 'AutoExecuteStatusInheritedFromSubscription', 'AutoExecuteStatusInheritedFromServer', 'AutoExecuteStatusInheritedFromElasticPool', 'AutoExecuteStatusInheritedFromDatabase'
	AutoExecuteStatusInheritedFrom AutoExecuteStatusInheritedFrom `json:"autoExecuteStatusInheritedFrom,omitempty"`
	// RecommendationsStatus - READ-ONLY; Gets that status of recommendations for this advisor and reason for not having any recommendations. Possible values include, but are not limited to, 'Ok' (Recommendations available),LowActivity (not enough workload to analyze), 'DbSeemsTuned' (Database is doing well), etc.
	RecommendationsStatus *string `json:"recommendationsStatus,omitempty"`
	// LastChecked - READ-ONLY; Gets the time when the current resource was analyzed for recommendations by this advisor.
	LastChecked *date.Time `json:"lastChecked,omitempty"`
	// RecommendedActions - READ-ONLY; Gets the recommended actions for this advisor.
	RecommendedActions *[]RecommendedAction `json:"recommendedActions,omitempty"`
}

// MarshalJSON is the custom marshaler for AdvisorProperties.
func (ap AdvisorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.AutoExecuteStatus != "" {
		objectMap["autoExecuteStatus"] = ap.AutoExecuteStatus
	}
	return json.Marshal(objectMap)
}

// AgentConfiguration a recoverable managed database resource.
type AgentConfiguration struct {
	autorest.Response `json:"-"`
	// AgentConfigurationProperties - Resource properties.
	*AgentConfigurationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AgentConfiguration.
func (ac AgentConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ac.AgentConfigurationProperties != nil {
		objectMap["properties"] = ac.AgentConfigurationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AgentConfiguration struct.
func (ac *AgentConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var agentConfigurationProperties AgentConfigurationProperties
				err = json.Unmarshal(*v, &agentConfigurationProperties)
				if err != nil {
					return err
				}
				ac.AgentConfigurationProperties = &agentConfigurationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ac.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ac.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ac.Type = &typeVar
			}
		}
	}

	return nil
}

// AgentConfigurationProperties sql agent configuration properties.
type AgentConfigurationProperties struct {
	// State - The state of Sql Agent. Possible values include: 'StateEnabled', 'StateDisabled'
	State State `json:"state,omitempty"`
}

// AutomaticTuningOptions automatic tuning properties for individual advisors.
type AutomaticTuningOptions struct {
	// DesiredState - Automatic tuning option desired state. Possible values include: 'AutomaticTuningOptionModeDesiredOff', 'AutomaticTuningOptionModeDesiredOn', 'AutomaticTuningOptionModeDesiredDefault'
	DesiredState AutomaticTuningOptionModeDesired `json:"desiredState,omitempty"`
	// ActualState - READ-ONLY; Automatic tuning option actual state. Possible values include: 'AutomaticTuningOptionModeActualOff', 'AutomaticTuningOptionModeActualOn'
	ActualState AutomaticTuningOptionModeActual `json:"actualState,omitempty"`
	// ReasonCode - READ-ONLY; Reason code if desired and actual state are different.
	ReasonCode *int32 `json:"reasonCode,omitempty"`
	// ReasonDesc - READ-ONLY; Reason description if desired and actual state are different. Possible values include: 'AutomaticTuningDisabledReasonDefault', 'AutomaticTuningDisabledReasonDisabled', 'AutomaticTuningDisabledReasonAutoConfigured', 'AutomaticTuningDisabledReasonInheritedFromServer', 'AutomaticTuningDisabledReasonQueryStoreOff', 'AutomaticTuningDisabledReasonQueryStoreReadOnly', 'AutomaticTuningDisabledReasonNotSupported'
	ReasonDesc AutomaticTuningDisabledReason `json:"reasonDesc,omitempty"`
}

// MarshalJSON is the custom marshaler for AutomaticTuningOptions.
func (ato AutomaticTuningOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ato.DesiredState != "" {
		objectMap["desiredState"] = ato.DesiredState
	}
	return json.Marshal(objectMap)
}

// AutomaticTuningServerOptions automatic tuning properties for individual advisors.
type AutomaticTuningServerOptions struct {
	// DesiredState - Automatic tuning option desired state. Possible values include: 'AutomaticTuningOptionModeDesiredOff', 'AutomaticTuningOptionModeDesiredOn', 'AutomaticTuningOptionModeDesiredDefault'
	DesiredState AutomaticTuningOptionModeDesired `json:"desiredState,omitempty"`
	// ActualState - READ-ONLY; Automatic tuning option actual state. Possible values include: 'AutomaticTuningOptionModeActualOff', 'AutomaticTuningOptionModeActualOn'
	ActualState AutomaticTuningOptionModeActual `json:"actualState,omitempty"`
	// ReasonCode - READ-ONLY; Reason code if desired and actual state are different.
	ReasonCode *int32 `json:"reasonCode,omitempty"`
	// ReasonDesc - READ-ONLY; Reason description if desired and actual state are different. Possible values include: 'AutomaticTuningServerReasonDefault', 'AutomaticTuningServerReasonDisabled', 'AutomaticTuningServerReasonAutoConfigured'
	ReasonDesc AutomaticTuningServerReason `json:"reasonDesc,omitempty"`
}

// MarshalJSON is the custom marshaler for AutomaticTuningServerOptions.
func (atso AutomaticTuningServerOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if atso.DesiredState != "" {
		objectMap["desiredState"] = atso.DesiredState
	}
	return json.Marshal(objectMap)
}

// AutomaticTuningServerProperties server-level Automatic Tuning properties.
type AutomaticTuningServerProperties struct {
	// DesiredState - Automatic tuning desired state. Possible values include: 'AutomaticTuningServerModeCustom', 'AutomaticTuningServerModeAuto', 'AutomaticTuningServerModeUnspecified'
	DesiredState AutomaticTuningServerMode `json:"desiredState,omitempty"`
	// ActualState - READ-ONLY; Automatic tuning actual state. Possible values include: 'AutomaticTuningServerModeCustom', 'AutomaticTuningServerModeAuto', 'AutomaticTuningServerModeUnspecified'
	ActualState AutomaticTuningServerMode `json:"actualState,omitempty"`
	// Options - Automatic tuning options definition.
	Options map[string]*AutomaticTuningServerOptions `json:"options"`
}

// MarshalJSON is the custom marshaler for AutomaticTuningServerProperties.
func (atsp AutomaticTuningServerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if atsp.DesiredState != "" {
		objectMap["desiredState"] = atsp.DesiredState
	}
	if atsp.Options != nil {
		objectMap["options"] = atsp.Options
	}
	return json.Marshal(objectMap)
}

// AutoPauseDelayTimeRange supported auto pause delay time range
type AutoPauseDelayTimeRange struct {
	// MinValue - READ-ONLY; Minimum value
	MinValue *int32 `json:"minValue,omitempty"`
	// MaxValue - READ-ONLY; Maximum value
	MaxValue *int32 `json:"maxValue,omitempty"`
	// StepSize - READ-ONLY; Step value for discrete values between the minimum value and the maximum value.
	StepSize *int32 `json:"stepSize,omitempty"`
	// Default - READ-ONLY; Default value is no value is provided
	Default *int32 `json:"default,omitempty"`
	// Unit - READ-ONLY; Unit of time that delay is expressed in. Possible values include: 'PauseDelayTimeUnitMinutes'
	Unit PauseDelayTimeUnit `json:"unit,omitempty"`
	// DoNotPauseValue - READ-ONLY; Value that is used to not pause (infinite delay before pause)
	DoNotPauseValue *int32 `json:"doNotPauseValue,omitempty"`
}

// MarshalJSON is the custom marshaler for AutoPauseDelayTimeRange.
func (apdtr AutoPauseDelayTimeRange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AzureADOnlyAuthListResult a list of active directory only authentications.
type AzureADOnlyAuthListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ServerAzureADOnlyAuthentication `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureADOnlyAuthListResult.
func (aaoalr AzureADOnlyAuthListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AzureADOnlyAuthListResultIterator provides access to a complete listing of
// ServerAzureADOnlyAuthentication values.
type AzureADOnlyAuthListResultIterator struct {
	i    int
	page AzureADOnlyAuthListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AzureADOnlyAuthListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AzureADOnlyAuthListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AzureADOnlyAuthListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AzureADOnlyAuthListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AzureADOnlyAuthListResultIterator) Response() AzureADOnlyAuthListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AzureADOnlyAuthListResultIterator) Value() ServerAzureADOnlyAuthentication {
	if !iter.page.NotDone() {
		return ServerAzureADOnlyAuthentication{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AzureADOnlyAuthListResultIterator type.
func NewAzureADOnlyAuthListResultIterator(page AzureADOnlyAuthListResultPage) AzureADOnlyAuthListResultIterator {
	return AzureADOnlyAuthListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (aaoalr AzureADOnlyAuthListResult) IsEmpty() bool {
	return aaoalr.Value == nil || len(*aaoalr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (aaoalr AzureADOnlyAuthListResult) hasNextLink() bool {
	return aaoalr.NextLink != nil && len(*aaoalr.NextLink) != 0
}

// azureADOnlyAuthListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (aaoalr AzureADOnlyAuthListResult) azureADOnlyAuthListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !aaoalr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(aaoalr.NextLink)))
}

// AzureADOnlyAuthListResultPage contains a page of ServerAzureADOnlyAuthentication values.
type AzureADOnlyAuthListResultPage struct {
	fn     func(context.Context, AzureADOnlyAuthListResult) (AzureADOnlyAuthListResult, error)
	aaoalr AzureADOnlyAuthListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AzureADOnlyAuthListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AzureADOnlyAuthListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.aaoalr)
		if err != nil {
			return err
		}
		page.aaoalr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AzureADOnlyAuthListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AzureADOnlyAuthListResultPage) NotDone() bool {
	return !page.aaoalr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AzureADOnlyAuthListResultPage) Response() AzureADOnlyAuthListResult {
	return page.aaoalr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AzureADOnlyAuthListResultPage) Values() []ServerAzureADOnlyAuthentication {
	if page.aaoalr.IsEmpty() {
		return nil
	}
	return *page.aaoalr.Value
}

// Creates a new instance of the AzureADOnlyAuthListResultPage type.
func NewAzureADOnlyAuthListResultPage(cur AzureADOnlyAuthListResult, getNextPage func(context.Context, AzureADOnlyAuthListResult) (AzureADOnlyAuthListResult, error)) AzureADOnlyAuthListResultPage {
	return AzureADOnlyAuthListResultPage{
		fn:     getNextPage,
		aaoalr: cur,
	}
}

// AzureADOnlyAuthProperties properties of a active directory only authentication.
type AzureADOnlyAuthProperties struct {
	// AzureADOnlyAuthentication - Azure Active Directory only Authentication enabled.
	AzureADOnlyAuthentication *bool `json:"azureADOnlyAuthentication,omitempty"`
}

// BackupShortTermRetentionPoliciesCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type BackupShortTermRetentionPoliciesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BackupShortTermRetentionPoliciesClient) (BackupShortTermRetentionPolicy, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BackupShortTermRetentionPoliciesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BackupShortTermRetentionPoliciesCreateOrUpdateFuture.Result.
func (future *BackupShortTermRetentionPoliciesCreateOrUpdateFuture) result(client BackupShortTermRetentionPoliciesClient) (bstrp BackupShortTermRetentionPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.BackupShortTermRetentionPoliciesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		bstrp.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.BackupShortTermRetentionPoliciesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if bstrp.Response.Response, err = future.GetResult(sender); err == nil && bstrp.Response.Response.StatusCode != http.StatusNoContent {
		bstrp, err = client.CreateOrUpdateResponder(bstrp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.BackupShortTermRetentionPoliciesCreateOrUpdateFuture", "Result", bstrp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BackupShortTermRetentionPoliciesUpdateFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type BackupShortTermRetentionPoliciesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BackupShortTermRetentionPoliciesClient) (BackupShortTermRetentionPolicy, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *BackupShortTermRetentionPoliciesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for BackupShortTermRetentionPoliciesUpdateFuture.Result.
func (future *BackupShortTermRetentionPoliciesUpdateFuture) result(client BackupShortTermRetentionPoliciesClient) (bstrp BackupShortTermRetentionPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.BackupShortTermRetentionPoliciesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		bstrp.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.BackupShortTermRetentionPoliciesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if bstrp.Response.Response, err = future.GetResult(sender); err == nil && bstrp.Response.Response.StatusCode != http.StatusNoContent {
		bstrp, err = client.UpdateResponder(bstrp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.BackupShortTermRetentionPoliciesUpdateFuture", "Result", bstrp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BackupShortTermRetentionPolicy a short term retention policy.
type BackupShortTermRetentionPolicy struct {
	autorest.Response `json:"-"`
	// BackupShortTermRetentionPolicyProperties - Resource properties.
	*BackupShortTermRetentionPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupShortTermRetentionPolicy.
func (bstrp BackupShortTermRetentionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bstrp.BackupShortTermRetentionPolicyProperties != nil {
		objectMap["properties"] = bstrp.BackupShortTermRetentionPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BackupShortTermRetentionPolicy struct.
func (bstrp *BackupShortTermRetentionPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var backupShortTermRetentionPolicyProperties BackupShortTermRetentionPolicyProperties
				err = json.Unmarshal(*v, &backupShortTermRetentionPolicyProperties)
				if err != nil {
					return err
				}
				bstrp.BackupShortTermRetentionPolicyProperties = &backupShortTermRetentionPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bstrp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bstrp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bstrp.Type = &typeVar
			}
		}
	}

	return nil
}

// BackupShortTermRetentionPolicyListResult a list of short term retention policies.
type BackupShortTermRetentionPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]BackupShortTermRetentionPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupShortTermRetentionPolicyListResult.
func (bstrplr BackupShortTermRetentionPolicyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// BackupShortTermRetentionPolicyListResultIterator provides access to a complete listing of
// BackupShortTermRetentionPolicy values.
type BackupShortTermRetentionPolicyListResultIterator struct {
	i    int
	page BackupShortTermRetentionPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BackupShortTermRetentionPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BackupShortTermRetentionPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BackupShortTermRetentionPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BackupShortTermRetentionPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BackupShortTermRetentionPolicyListResultIterator) Response() BackupShortTermRetentionPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BackupShortTermRetentionPolicyListResultIterator) Value() BackupShortTermRetentionPolicy {
	if !iter.page.NotDone() {
		return BackupShortTermRetentionPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BackupShortTermRetentionPolicyListResultIterator type.
func NewBackupShortTermRetentionPolicyListResultIterator(page BackupShortTermRetentionPolicyListResultPage) BackupShortTermRetentionPolicyListResultIterator {
	return BackupShortTermRetentionPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bstrplr BackupShortTermRetentionPolicyListResult) IsEmpty() bool {
	return bstrplr.Value == nil || len(*bstrplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (bstrplr BackupShortTermRetentionPolicyListResult) hasNextLink() bool {
	return bstrplr.NextLink != nil && len(*bstrplr.NextLink) != 0
}

// backupShortTermRetentionPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bstrplr BackupShortTermRetentionPolicyListResult) backupShortTermRetentionPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !bstrplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bstrplr.NextLink)))
}

// BackupShortTermRetentionPolicyListResultPage contains a page of BackupShortTermRetentionPolicy values.
type BackupShortTermRetentionPolicyListResultPage struct {
	fn      func(context.Context, BackupShortTermRetentionPolicyListResult) (BackupShortTermRetentionPolicyListResult, error)
	bstrplr BackupShortTermRetentionPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BackupShortTermRetentionPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BackupShortTermRetentionPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.bstrplr)
		if err != nil {
			return err
		}
		page.bstrplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BackupShortTermRetentionPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BackupShortTermRetentionPolicyListResultPage) NotDone() bool {
	return !page.bstrplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BackupShortTermRetentionPolicyListResultPage) Response() BackupShortTermRetentionPolicyListResult {
	return page.bstrplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BackupShortTermRetentionPolicyListResultPage) Values() []BackupShortTermRetentionPolicy {
	if page.bstrplr.IsEmpty() {
		return nil
	}
	return *page.bstrplr.Value
}

// Creates a new instance of the BackupShortTermRetentionPolicyListResultPage type.
func NewBackupShortTermRetentionPolicyListResultPage(cur BackupShortTermRetentionPolicyListResult, getNextPage func(context.Context, BackupShortTermRetentionPolicyListResult) (BackupShortTermRetentionPolicyListResult, error)) BackupShortTermRetentionPolicyListResultPage {
	return BackupShortTermRetentionPolicyListResultPage{
		fn:      getNextPage,
		bstrplr: cur,
	}
}

// BackupShortTermRetentionPolicyProperties properties of a short term retention policy
type BackupShortTermRetentionPolicyProperties struct {
	// RetentionDays - The backup retention period in days. This is how many days Point-in-Time Restore will be supported.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
	// DiffBackupIntervalInHours - The differential backup interval in hours. This is how many interval hours between each differential backup will be supported. This is only applicable to live databases but not dropped databases.
	DiffBackupIntervalInHours *int32 `json:"diffBackupIntervalInHours,omitempty"`
}

// Baseline SQL Vulnerability Assessment baseline Details
type Baseline struct {
	// ExpectedResults - READ-ONLY; SQL Vulnerability Assessment baseline expected results
	ExpectedResults *[][]string `json:"expectedResults,omitempty"`
	// UpdatedTime - READ-ONLY; SQL Vulnerability Assessment baseline update time (UTC)
	UpdatedTime *date.Time `json:"updatedTime,omitempty"`
}

// MarshalJSON is the custom marshaler for Baseline.
func (b Baseline) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// BaselineAdjustedResult SQL Vulnerability Assessment baseline adjusted results
type BaselineAdjustedResult struct {
	// Baseline - READ-ONLY; SQL Vulnerability Assessment baseline details
	Baseline *Baseline `json:"baseline,omitempty"`
	// Status - READ-ONLY; SQL Vulnerability Assessment baseline status. Possible values include: 'RuleStatusNonFinding', 'RuleStatusFinding', 'RuleStatusInternalError'
	Status RuleStatus `json:"status,omitempty"`
	// ResultsNotInBaseline - READ-ONLY; SQL Vulnerability Assessment results that are not in baseline
	ResultsNotInBaseline *[][]string `json:"resultsNotInBaseline,omitempty"`
	// ResultsOnlyInBaseline - READ-ONLY; SQL Vulnerability Assessment results that are in baseline.
	ResultsOnlyInBaseline *[][]string `json:"resultsOnlyInBaseline,omitempty"`
}

// MarshalJSON is the custom marshaler for BaselineAdjustedResult.
func (bar BaselineAdjustedResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// BaseLongTermRetentionPolicyProperties properties of a long term retention policy
type BaseLongTermRetentionPolicyProperties struct {
	// WeeklyRetention - The weekly retention policy for an LTR backup in an ISO 8601 format.
	WeeklyRetention *string `json:"weeklyRetention,omitempty"`
	// MonthlyRetention - The monthly retention policy for an LTR backup in an ISO 8601 format.
	MonthlyRetention *string `json:"monthlyRetention,omitempty"`
	// YearlyRetention - The yearly retention policy for an LTR backup in an ISO 8601 format.
	YearlyRetention *string `json:"yearlyRetention,omitempty"`
	// WeekOfYear - The week of year to take the yearly backup in an ISO 8601 format.
	WeekOfYear *int32 `json:"weekOfYear,omitempty"`
}

// BenchmarkReference SQL Vulnerability Assessment benchmark reference
type BenchmarkReference struct {
	// Benchmark - READ-ONLY; SQL Vulnerability Assessment benchmark name
	Benchmark *string `json:"benchmark,omitempty"`
	// Reference - READ-ONLY; SQL Vulnerability Assessment benchmark reference.
	Reference *string `json:"reference,omitempty"`
}

// MarshalJSON is the custom marshaler for BenchmarkReference.
func (br BenchmarkReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CheckNameAvailabilityRequest a request to check whether the specified name for a resource is available.
type CheckNameAvailabilityRequest struct {
	Name *string `json:"name,omitempty"`
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityResponse the result of a name availability check.
type CheckNameAvailabilityResponse struct {
	autorest.Response `json:"-"`
	// Name - READ-ONLY; The name whose availability was checked.
	Name *string `json:"name,omitempty"`
	// Available - READ-ONLY; True if the name is available, otherwise false.
	Available *bool `json:"available,omitempty"`
	// Reason - READ-ONLY; The reason code explaining why the name is unavailable. Will be undefined if the name is available. Possible values include: 'CheckNameAvailabilityReasonInvalid', 'CheckNameAvailabilityReasonAlreadyExists'
	Reason CheckNameAvailabilityReason `json:"reason,omitempty"`
	// Message - READ-ONLY; A message explaining why the name is unavailable. Will be undefined if the name is available.
	Message *string `json:"message,omitempty"`
}

// MarshalJSON is the custom marshaler for CheckNameAvailabilityResponse.
func (cnar CheckNameAvailabilityResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CompleteDatabaseRestoreDefinition contains the information necessary to perform a complete database
// restore operation.
type CompleteDatabaseRestoreDefinition struct {
	// LastBackupName - The last backup name to apply
	LastBackupName *string `json:"lastBackupName,omitempty"`
}

// CopyLongTermRetentionBackupParameters contains the information necessary to perform long term retention
// backup copy operation.
type CopyLongTermRetentionBackupParameters struct {
	// CopyLongTermRetentionBackupParametersProperties - Resource properties.
	*CopyLongTermRetentionBackupParametersProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CopyLongTermRetentionBackupParameters.
func (cltrbp CopyLongTermRetentionBackupParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cltrbp.CopyLongTermRetentionBackupParametersProperties != nil {
		objectMap["properties"] = cltrbp.CopyLongTermRetentionBackupParametersProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CopyLongTermRetentionBackupParameters struct.
func (cltrbp *CopyLongTermRetentionBackupParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var copyLongTermRetentionBackupParametersProperties CopyLongTermRetentionBackupParametersProperties
				err = json.Unmarshal(*v, &copyLongTermRetentionBackupParametersProperties)
				if err != nil {
					return err
				}
				cltrbp.CopyLongTermRetentionBackupParametersProperties = &copyLongTermRetentionBackupParametersProperties
			}
		}
	}

	return nil
}

// CopyLongTermRetentionBackupParametersProperties contains the properties to perform long term retention
// backup copy operation.
type CopyLongTermRetentionBackupParametersProperties struct {
	// TargetSubscriptionID - The subscription that owns the target server
	TargetSubscriptionID *string `json:"targetSubscriptionId,omitempty"`
	// TargetResourceGroup - The resource group that owns the target server
	TargetResourceGroup *string `json:"targetResourceGroup,omitempty"`
	// TargetServerResourceID - The resource Id of the target server that owns the database
	TargetServerResourceID *string `json:"targetServerResourceId,omitempty"`
	// TargetServerFullyQualifiedDomainName - The fully qualified domain name of the target server
	TargetServerFullyQualifiedDomainName *string `json:"targetServerFullyQualifiedDomainName,omitempty"`
	// TargetDatabaseName - The name of the database owns the copied backup.
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty"`
	// TargetBackupStorageRedundancy - The storage redundancy type of the copied backup. Possible values include: 'BackupStorageRedundancyGeo', 'BackupStorageRedundancyLocal', 'BackupStorageRedundancyZone', 'BackupStorageRedundancyGeoZone'
	TargetBackupStorageRedundancy BackupStorageRedundancy `json:"targetBackupStorageRedundancy,omitempty"`
}

// CreateDatabaseRestorePointDefinition contains the information necessary to perform a create database
// restore point operation.
type CreateDatabaseRestorePointDefinition struct {
	// RestorePointLabel - The restore point label to apply
	RestorePointLabel *string `json:"restorePointLabel,omitempty"`
}

// Database a database resource.
type Database struct {
	autorest.Response `json:"-"`
	// Sku - The database SKU.
	//
	// The list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family, and capacity) that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API or one of the following commands:
	//
	// ```azurecli
	// az sql db list-editions -l <location> -o table
	// ````
	//
	// ```powershell
	// Get-AzSqlServerServiceObjective -Location <location>
	// ````
	Sku *Sku `json:"sku,omitempty"`
	// Kind - READ-ONLY; Kind of database. This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// ManagedBy - READ-ONLY; Resource that manages the database.
	ManagedBy *string `json:"managedBy,omitempty"`
	// Identity - The Azure Active Directory identity of the database.
	Identity *DatabaseIdentity `json:"identity,omitempty"`
	// DatabaseProperties - Resource properties.
	*DatabaseProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Database.
func (d Database) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.Sku != nil {
		objectMap["sku"] = d.Sku
	}
	if d.Identity != nil {
		objectMap["identity"] = d.Identity
	}
	if d.DatabaseProperties != nil {
		objectMap["properties"] = d.DatabaseProperties
	}
	if d.Location != nil {
		objectMap["location"] = d.Location
	}
	if d.Tags != nil {
		objectMap["tags"] = d.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Database struct.
func (d *Database) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				d.Sku = &sku
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				d.Kind = &kind
			}
		case "managedBy":
			if v != nil {
				var managedBy string
				err = json.Unmarshal(*v, &managedBy)
				if err != nil {
					return err
				}
				d.ManagedBy = &managedBy
			}
		case "identity":
			if v != nil {
				var identity DatabaseIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				d.Identity = &identity
			}
		case "properties":
			if v != nil {
				var databaseProperties DatabaseProperties
				err = json.Unmarshal(*v, &databaseProperties)
				if err != nil {
					return err
				}
				d.DatabaseProperties = &databaseProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				d.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				d.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseAdvancedThreatProtection a database Advanced Threat Protection.
type DatabaseAdvancedThreatProtection struct {
	autorest.Response `json:"-"`
	// SystemData - READ-ONLY; SystemData of AdvancedThreatProtectionResource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// AdvancedThreatProtectionProperties - Resource properties.
	*AdvancedThreatProtectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseAdvancedThreatProtection.
func (datp DatabaseAdvancedThreatProtection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if datp.AdvancedThreatProtectionProperties != nil {
		objectMap["properties"] = datp.AdvancedThreatProtectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseAdvancedThreatProtection struct.
func (datp *DatabaseAdvancedThreatProtection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				datp.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var advancedThreatProtectionProperties AdvancedThreatProtectionProperties
				err = json.Unmarshal(*v, &advancedThreatProtectionProperties)
				if err != nil {
					return err
				}
				datp.AdvancedThreatProtectionProperties = &advancedThreatProtectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				datp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				datp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				datp.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseAdvancedThreatProtectionListResult a list of the database's Advanced Threat Protection
// configurations.
type DatabaseAdvancedThreatProtectionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]DatabaseAdvancedThreatProtection `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseAdvancedThreatProtectionListResult.
func (datplr DatabaseAdvancedThreatProtectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DatabaseAdvancedThreatProtectionListResultIterator provides access to a complete listing of
// DatabaseAdvancedThreatProtection values.
type DatabaseAdvancedThreatProtectionListResultIterator struct {
	i    int
	page DatabaseAdvancedThreatProtectionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DatabaseAdvancedThreatProtectionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseAdvancedThreatProtectionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DatabaseAdvancedThreatProtectionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DatabaseAdvancedThreatProtectionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DatabaseAdvancedThreatProtectionListResultIterator) Response() DatabaseAdvancedThreatProtectionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DatabaseAdvancedThreatProtectionListResultIterator) Value() DatabaseAdvancedThreatProtection {
	if !iter.page.NotDone() {
		return DatabaseAdvancedThreatProtection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DatabaseAdvancedThreatProtectionListResultIterator type.
func NewDatabaseAdvancedThreatProtectionListResultIterator(page DatabaseAdvancedThreatProtectionListResultPage) DatabaseAdvancedThreatProtectionListResultIterator {
	return DatabaseAdvancedThreatProtectionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (datplr DatabaseAdvancedThreatProtectionListResult) IsEmpty() bool {
	return datplr.Value == nil || len(*datplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (datplr DatabaseAdvancedThreatProtectionListResult) hasNextLink() bool {
	return datplr.NextLink != nil && len(*datplr.NextLink) != 0
}

// databaseAdvancedThreatProtectionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (datplr DatabaseAdvancedThreatProtectionListResult) databaseAdvancedThreatProtectionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !datplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(datplr.NextLink)))
}

// DatabaseAdvancedThreatProtectionListResultPage contains a page of DatabaseAdvancedThreatProtection
// values.
type DatabaseAdvancedThreatProtectionListResultPage struct {
	fn     func(context.Context, DatabaseAdvancedThreatProtectionListResult) (DatabaseAdvancedThreatProtectionListResult, error)
	datplr DatabaseAdvancedThreatProtectionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DatabaseAdvancedThreatProtectionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseAdvancedThreatProtectionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.datplr)
		if err != nil {
			return err
		}
		page.datplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DatabaseAdvancedThreatProtectionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DatabaseAdvancedThreatProtectionListResultPage) NotDone() bool {
	return !page.datplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DatabaseAdvancedThreatProtectionListResultPage) Response() DatabaseAdvancedThreatProtectionListResult {
	return page.datplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DatabaseAdvancedThreatProtectionListResultPage) Values() []DatabaseAdvancedThreatProtection {
	if page.datplr.IsEmpty() {
		return nil
	}
	return *page.datplr.Value
}

// Creates a new instance of the DatabaseAdvancedThreatProtectionListResultPage type.
func NewDatabaseAdvancedThreatProtectionListResultPage(cur DatabaseAdvancedThreatProtectionListResult, getNextPage func(context.Context, DatabaseAdvancedThreatProtectionListResult) (DatabaseAdvancedThreatProtectionListResult, error)) DatabaseAdvancedThreatProtectionListResultPage {
	return DatabaseAdvancedThreatProtectionListResultPage{
		fn:     getNextPage,
		datplr: cur,
	}
}

// DatabaseAutomaticTuning database-level Automatic Tuning.
type DatabaseAutomaticTuning struct {
	autorest.Response `json:"-"`
	// DatabaseAutomaticTuningProperties - Resource properties.
	*DatabaseAutomaticTuningProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseAutomaticTuning.
func (dat DatabaseAutomaticTuning) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dat.DatabaseAutomaticTuningProperties != nil {
		objectMap["properties"] = dat.DatabaseAutomaticTuningProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseAutomaticTuning struct.
func (dat *DatabaseAutomaticTuning) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var databaseAutomaticTuningProperties DatabaseAutomaticTuningProperties
				err = json.Unmarshal(*v, &databaseAutomaticTuningProperties)
				if err != nil {
					return err
				}
				dat.DatabaseAutomaticTuningProperties = &databaseAutomaticTuningProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dat.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dat.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dat.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseAutomaticTuningProperties database-level Automatic Tuning properties.
type DatabaseAutomaticTuningProperties struct {
	// DesiredState - Automatic tuning desired state. Possible values include: 'AutomaticTuningModeInherit', 'AutomaticTuningModeCustom', 'AutomaticTuningModeAuto', 'AutomaticTuningModeUnspecified'
	DesiredState AutomaticTuningMode `json:"desiredState,omitempty"`
	// ActualState - READ-ONLY; Automatic tuning actual state. Possible values include: 'AutomaticTuningModeInherit', 'AutomaticTuningModeCustom', 'AutomaticTuningModeAuto', 'AutomaticTuningModeUnspecified'
	ActualState AutomaticTuningMode `json:"actualState,omitempty"`
	// Options - Automatic tuning options definition.
	Options map[string]*AutomaticTuningOptions `json:"options"`
}

// MarshalJSON is the custom marshaler for DatabaseAutomaticTuningProperties.
func (datp DatabaseAutomaticTuningProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if datp.DesiredState != "" {
		objectMap["desiredState"] = datp.DesiredState
	}
	if datp.Options != nil {
		objectMap["options"] = datp.Options
	}
	return json.Marshal(objectMap)
}

// DatabaseBlobAuditingPolicy a database blob auditing policy.
type DatabaseBlobAuditingPolicy struct {
	autorest.Response `json:"-"`
	// Kind - READ-ONLY; Resource kind.
	Kind *string `json:"kind,omitempty"`
	// DatabaseBlobAuditingPolicyProperties - Resource properties.
	*DatabaseBlobAuditingPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseBlobAuditingPolicy.
func (dbap DatabaseBlobAuditingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dbap.DatabaseBlobAuditingPolicyProperties != nil {
		objectMap["properties"] = dbap.DatabaseBlobAuditingPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseBlobAuditingPolicy struct.
func (dbap *DatabaseBlobAuditingPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dbap.Kind = &kind
			}
		case "properties":
			if v != nil {
				var databaseBlobAuditingPolicyProperties DatabaseBlobAuditingPolicyProperties
				err = json.Unmarshal(*v, &databaseBlobAuditingPolicyProperties)
				if err != nil {
					return err
				}
				dbap.DatabaseBlobAuditingPolicyProperties = &databaseBlobAuditingPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dbap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dbap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dbap.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseBlobAuditingPolicyListResult a list of database auditing settings.
type DatabaseBlobAuditingPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]DatabaseBlobAuditingPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseBlobAuditingPolicyListResult.
func (dbaplr DatabaseBlobAuditingPolicyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DatabaseBlobAuditingPolicyListResultIterator provides access to a complete listing of
// DatabaseBlobAuditingPolicy values.
type DatabaseBlobAuditingPolicyListResultIterator struct {
	i    int
	page DatabaseBlobAuditingPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DatabaseBlobAuditingPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseBlobAuditingPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DatabaseBlobAuditingPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DatabaseBlobAuditingPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DatabaseBlobAuditingPolicyListResultIterator) Response() DatabaseBlobAuditingPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DatabaseBlobAuditingPolicyListResultIterator) Value() DatabaseBlobAuditingPolicy {
	if !iter.page.NotDone() {
		return DatabaseBlobAuditingPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DatabaseBlobAuditingPolicyListResultIterator type.
func NewDatabaseBlobAuditingPolicyListResultIterator(page DatabaseBlobAuditingPolicyListResultPage) DatabaseBlobAuditingPolicyListResultIterator {
	return DatabaseBlobAuditingPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dbaplr DatabaseBlobAuditingPolicyListResult) IsEmpty() bool {
	return dbaplr.Value == nil || len(*dbaplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dbaplr DatabaseBlobAuditingPolicyListResult) hasNextLink() bool {
	return dbaplr.NextLink != nil && len(*dbaplr.NextLink) != 0
}

// databaseBlobAuditingPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dbaplr DatabaseBlobAuditingPolicyListResult) databaseBlobAuditingPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dbaplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dbaplr.NextLink)))
}

// DatabaseBlobAuditingPolicyListResultPage contains a page of DatabaseBlobAuditingPolicy values.
type DatabaseBlobAuditingPolicyListResultPage struct {
	fn     func(context.Context, DatabaseBlobAuditingPolicyListResult) (DatabaseBlobAuditingPolicyListResult, error)
	dbaplr DatabaseBlobAuditingPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DatabaseBlobAuditingPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseBlobAuditingPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dbaplr)
		if err != nil {
			return err
		}
		page.dbaplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DatabaseBlobAuditingPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DatabaseBlobAuditingPolicyListResultPage) NotDone() bool {
	return !page.dbaplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DatabaseBlobAuditingPolicyListResultPage) Response() DatabaseBlobAuditingPolicyListResult {
	return page.dbaplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DatabaseBlobAuditingPolicyListResultPage) Values() []DatabaseBlobAuditingPolicy {
	if page.dbaplr.IsEmpty() {
		return nil
	}
	return *page.dbaplr.Value
}

// Creates a new instance of the DatabaseBlobAuditingPolicyListResultPage type.
func NewDatabaseBlobAuditingPolicyListResultPage(cur DatabaseBlobAuditingPolicyListResult, getNextPage func(context.Context, DatabaseBlobAuditingPolicyListResult) (DatabaseBlobAuditingPolicyListResult, error)) DatabaseBlobAuditingPolicyListResultPage {
	return DatabaseBlobAuditingPolicyListResultPage{
		fn:     getNextPage,
		dbaplr: cur,
	}
}

// DatabaseBlobAuditingPolicyProperties properties of a database blob auditing policy.
type DatabaseBlobAuditingPolicyProperties struct {
	// RetentionDays - Specifies the number of days to keep in the audit logs in the storage account.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
	// AuditActionsAndGroups - Specifies the Actions-Groups and Actions to audit.
	//
	// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:
	//
	// BATCH_COMPLETED_GROUP,
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
	// FAILED_DATABASE_AUTHENTICATION_GROUP.
	//
	// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
	//
	// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
	//
	// APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
	// BACKUP_RESTORE_GROUP
	// DATABASE_LOGOUT_GROUP
	// DATABASE_OBJECT_CHANGE_GROUP
	// DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
	// DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
	// DATABASE_OPERATION_GROUP
	// DATABASE_PERMISSION_CHANGE_GROUP
	// DATABASE_PRINCIPAL_CHANGE_GROUP
	// DATABASE_PRINCIPAL_IMPERSONATION_GROUP
	// DATABASE_ROLE_MEMBER_CHANGE_GROUP
	// FAILED_DATABASE_AUTHENTICATION_GROUP
	// SCHEMA_OBJECT_ACCESS_GROUP
	// SCHEMA_OBJECT_CHANGE_GROUP
	// SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
	// SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
	// USER_CHANGE_PASSWORD_GROUP
	// BATCH_STARTED_GROUP
	// BATCH_COMPLETED_GROUP
	// DBCC_GROUP
	// DATABASE_OWNERSHIP_CHANGE_GROUP
	// DATABASE_CHANGE_GROUP
	// LEDGER_OPERATION_GROUP
	//
	// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.
	//
	// For more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
	//
	// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:
	// SELECT
	// UPDATE
	// INSERT
	// DELETE
	// EXECUTE
	// RECEIVE
	// REFERENCES
	//
	// The general form for defining an action to be audited is:
	// {action} ON {object} BY {principal}
	//
	// Note that <object> in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
	//
	// For example:
	// SELECT on dbo.myTable by public
	// SELECT on DATABASE::myDatabase by public
	// SELECT on SCHEMA::mySchema by public
	//
	// For more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
	AuditActionsAndGroups *[]string `json:"auditActionsAndGroups,omitempty"`
	// IsStorageSecondaryKeyInUse - Specifies whether storageAccountAccessKey value is the storage's secondary key.
	IsStorageSecondaryKeyInUse *bool `json:"isStorageSecondaryKeyInUse,omitempty"`
	// IsAzureMonitorTargetEnabled - Specifies whether audit events are sent to Azure Monitor.
	// In order to send the events to Azure Monitor, specify 'State' as 'Enabled' and 'IsAzureMonitorTargetEnabled' as true.
	//
	// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.
	// Note that for server level audit you should use the 'master' database as {databaseName}.
	//
	// Diagnostic Settings URI format:
	// PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	//
	// For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
	// or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
	IsAzureMonitorTargetEnabled *bool `json:"isAzureMonitorTargetEnabled,omitempty"`
	// QueueDelayMs - Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed.
	// The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
	QueueDelayMs *int32 `json:"queueDelayMs,omitempty"`
	// IsManagedIdentityInUse - Specifies whether Managed Identity is used to access blob storage
	IsManagedIdentityInUse *bool `json:"isManagedIdentityInUse,omitempty"`
	// State - Specifies the state of the audit. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required. Possible values include: 'BlobAuditingPolicyStateEnabled', 'BlobAuditingPolicyStateDisabled'
	State BlobAuditingPolicyState `json:"state,omitempty"`
	// StorageEndpoint - Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled is required.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the auditing storage account.
	// If state is Enabled and storageEndpoint is specified, not specifying the storageAccountAccessKey will use SQL server system-assigned managed identity to access the storage.
	// Prerequisites for using managed identity authentication:
	// 1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
	// 2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server identity.
	// For more information, see [Auditing to storage using Managed Identity authentication](https://go.microsoft.com/fwlink/?linkid=2114355)
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// StorageAccountSubscriptionID - Specifies the blob storage subscription Id.
	StorageAccountSubscriptionID *uuid.UUID `json:"storageAccountSubscriptionId,omitempty"`
}

// DatabaseColumn a database column resource.
type DatabaseColumn struct {
	autorest.Response `json:"-"`
	// DatabaseColumnProperties - Resource properties.
	*DatabaseColumnProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseColumn.
func (dc DatabaseColumn) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dc.DatabaseColumnProperties != nil {
		objectMap["properties"] = dc.DatabaseColumnProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseColumn struct.
func (dc *DatabaseColumn) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var databaseColumnProperties DatabaseColumnProperties
				err = json.Unmarshal(*v, &databaseColumnProperties)
				if err != nil {
					return err
				}
				dc.DatabaseColumnProperties = &databaseColumnProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dc.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseColumnListResult a list of database columns.
type DatabaseColumnListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]DatabaseColumn `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseColumnListResult.
func (dclr DatabaseColumnListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DatabaseColumnListResultIterator provides access to a complete listing of DatabaseColumn values.
type DatabaseColumnListResultIterator struct {
	i    int
	page DatabaseColumnListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DatabaseColumnListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseColumnListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DatabaseColumnListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DatabaseColumnListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DatabaseColumnListResultIterator) Response() DatabaseColumnListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DatabaseColumnListResultIterator) Value() DatabaseColumn {
	if !iter.page.NotDone() {
		return DatabaseColumn{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DatabaseColumnListResultIterator type.
func NewDatabaseColumnListResultIterator(page DatabaseColumnListResultPage) DatabaseColumnListResultIterator {
	return DatabaseColumnListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dclr DatabaseColumnListResult) IsEmpty() bool {
	return dclr.Value == nil || len(*dclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dclr DatabaseColumnListResult) hasNextLink() bool {
	return dclr.NextLink != nil && len(*dclr.NextLink) != 0
}

// databaseColumnListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dclr DatabaseColumnListResult) databaseColumnListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dclr.NextLink)))
}

// DatabaseColumnListResultPage contains a page of DatabaseColumn values.
type DatabaseColumnListResultPage struct {
	fn   func(context.Context, DatabaseColumnListResult) (DatabaseColumnListResult, error)
	dclr DatabaseColumnListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DatabaseColumnListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseColumnListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dclr)
		if err != nil {
			return err
		}
		page.dclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DatabaseColumnListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DatabaseColumnListResultPage) NotDone() bool {
	return !page.dclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DatabaseColumnListResultPage) Response() DatabaseColumnListResult {
	return page.dclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DatabaseColumnListResultPage) Values() []DatabaseColumn {
	if page.dclr.IsEmpty() {
		return nil
	}
	return *page.dclr.Value
}

// Creates a new instance of the DatabaseColumnListResultPage type.
func NewDatabaseColumnListResultPage(cur DatabaseColumnListResult, getNextPage func(context.Context, DatabaseColumnListResult) (DatabaseColumnListResult, error)) DatabaseColumnListResultPage {
	return DatabaseColumnListResultPage{
		fn:   getNextPage,
		dclr: cur,
	}
}

// DatabaseColumnProperties database column properties.
type DatabaseColumnProperties struct {
	// ColumnType - The column data type. Possible values include: 'ColumnDataTypeImage', 'ColumnDataTypeText', 'ColumnDataTypeUniqueidentifier', 'ColumnDataTypeDate', 'ColumnDataTypeTime', 'ColumnDataTypeDatetime2', 'ColumnDataTypeDatetimeoffset', 'ColumnDataTypeTinyint', 'ColumnDataTypeSmallint', 'ColumnDataTypeInt', 'ColumnDataTypeSmalldatetime', 'ColumnDataTypeReal', 'ColumnDataTypeMoney', 'ColumnDataTypeDatetime', 'ColumnDataTypeFloat', 'ColumnDataTypeSQLVariant', 'ColumnDataTypeNtext', 'ColumnDataTypeBit', 'ColumnDataTypeDecimal', 'ColumnDataTypeNumeric', 'ColumnDataTypeSmallmoney', 'ColumnDataTypeBigint', 'ColumnDataTypeHierarchyid', 'ColumnDataTypeGeometry', 'ColumnDataTypeGeography', 'ColumnDataTypeVarbinary', 'ColumnDataTypeVarchar', 'ColumnDataTypeBinary', 'ColumnDataTypeChar', 'ColumnDataTypeTimestamp', 'ColumnDataTypeNvarchar', 'ColumnDataTypeNchar', 'ColumnDataTypeXML', 'ColumnDataTypeSysname'
	ColumnType ColumnDataType `json:"columnType,omitempty"`
	// TemporalType - The table temporal type. Possible values include: 'TableTemporalTypeNonTemporalTable', 'TableTemporalTypeHistoryTable', 'TableTemporalTypeSystemVersionedTemporalTable'
	TemporalType TableTemporalType `json:"temporalType,omitempty"`
	// MemoryOptimized - Whether or not the column belongs to a memory optimized table.
	MemoryOptimized *bool `json:"memoryOptimized,omitempty"`
	// IsComputed - Whether or not the column is computed.
	IsComputed *bool `json:"isComputed,omitempty"`
}

// DatabaseExtensions an export managed database operation result resource.
type DatabaseExtensions struct {
	// DatabaseExtensionsProperties - Resource properties.
	*DatabaseExtensionsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseExtensions.
func (de DatabaseExtensions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if de.DatabaseExtensionsProperties != nil {
		objectMap["properties"] = de.DatabaseExtensionsProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseExtensions struct.
func (de *DatabaseExtensions) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var databaseExtensionsProperties DatabaseExtensionsProperties
				err = json.Unmarshal(*v, &databaseExtensionsProperties)
				if err != nil {
					return err
				}
				de.DatabaseExtensionsProperties = &databaseExtensionsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				de.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				de.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				de.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseExtensionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DatabaseExtensionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabaseExtensionsClient) (ImportExportExtensionsOperationResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabaseExtensionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabaseExtensionsCreateOrUpdateFuture.Result.
func (future *DatabaseExtensionsCreateOrUpdateFuture) result(client DatabaseExtensionsClient) (ieeor ImportExportExtensionsOperationResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseExtensionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ieeor.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.DatabaseExtensionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ieeor.Response.Response, err = future.GetResult(sender); err == nil && ieeor.Response.Response.StatusCode != http.StatusNoContent {
		ieeor, err = client.CreateOrUpdateResponder(ieeor.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabaseExtensionsCreateOrUpdateFuture", "Result", ieeor.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabaseExtensionsProperties contains the database information after successful export.
type DatabaseExtensionsProperties struct {
	// OperationMode - Operation Mode.
	OperationMode *string `json:"operationMode,omitempty"`
	// StorageKeyType - Storage key type. Possible values include: 'StorageKeyTypeSharedAccessKey', 'StorageKeyTypeStorageAccessKey'
	StorageKeyType StorageKeyType `json:"storageKeyType,omitempty"`
	// StorageKey - Storage key.
	StorageKey *string `json:"storageKey,omitempty"`
	// StorageURI - Storage Uri.
	StorageURI *string `json:"storageUri,omitempty"`
}

// DatabaseIdentity azure Active Directory identity configuration for a resource.
type DatabaseIdentity struct {
	// Type - The identity type. Possible values include: 'DatabaseIdentityTypeNone', 'DatabaseIdentityTypeUserAssigned'
	Type DatabaseIdentityType `json:"type,omitempty"`
	// TenantID - READ-ONLY; The Azure Active Directory tenant id.
	TenantID *uuid.UUID `json:"tenantId,omitempty"`
	// UserAssignedIdentities - The resource ids of the user assigned identities to use
	UserAssignedIdentities map[string]*DatabaseUserIdentity `json:"userAssignedIdentities"`
}

// MarshalJSON is the custom marshaler for DatabaseIdentity.
func (di DatabaseIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if di.Type != "" {
		objectMap["type"] = di.Type
	}
	if di.UserAssignedIdentities != nil {
		objectMap["userAssignedIdentities"] = di.UserAssignedIdentities
	}
	return json.Marshal(objectMap)
}

// DatabaseListResult a list of databases.
type DatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]Database `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseListResult.
func (dlr DatabaseListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DatabaseListResultIterator provides access to a complete listing of Database values.
type DatabaseListResultIterator struct {
	i    int
	page DatabaseListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DatabaseListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DatabaseListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DatabaseListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DatabaseListResultIterator) Response() DatabaseListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DatabaseListResultIterator) Value() Database {
	if !iter.page.NotDone() {
		return Database{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DatabaseListResultIterator type.
func NewDatabaseListResultIterator(page DatabaseListResultPage) DatabaseListResultIterator {
	return DatabaseListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dlr DatabaseListResult) IsEmpty() bool {
	return dlr.Value == nil || len(*dlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dlr DatabaseListResult) hasNextLink() bool {
	return dlr.NextLink != nil && len(*dlr.NextLink) != 0
}

// databaseListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dlr DatabaseListResult) databaseListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dlr.NextLink)))
}

// DatabaseListResultPage contains a page of Database values.
type DatabaseListResultPage struct {
	fn  func(context.Context, DatabaseListResult) (DatabaseListResult, error)
	dlr DatabaseListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DatabaseListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dlr)
		if err != nil {
			return err
		}
		page.dlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DatabaseListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DatabaseListResultPage) NotDone() bool {
	return !page.dlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DatabaseListResultPage) Response() DatabaseListResult {
	return page.dlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DatabaseListResultPage) Values() []Database {
	if page.dlr.IsEmpty() {
		return nil
	}
	return *page.dlr.Value
}

// Creates a new instance of the DatabaseListResultPage type.
func NewDatabaseListResultPage(cur DatabaseListResult, getNextPage func(context.Context, DatabaseListResult) (DatabaseListResult, error)) DatabaseListResultPage {
	return DatabaseListResultPage{
		fn:  getNextPage,
		dlr: cur,
	}
}

// DatabaseOperation a database operation.
type DatabaseOperation struct {
	// DatabaseOperationProperties - Resource properties.
	*DatabaseOperationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseOperation.
func (do DatabaseOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if do.DatabaseOperationProperties != nil {
		objectMap["properties"] = do.DatabaseOperationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseOperation struct.
func (do *DatabaseOperation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var databaseOperationProperties DatabaseOperationProperties
				err = json.Unmarshal(*v, &databaseOperationProperties)
				if err != nil {
					return err
				}
				do.DatabaseOperationProperties = &databaseOperationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				do.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				do.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				do.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseOperationListResult the response to a list database operations request
type DatabaseOperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]DatabaseOperation `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseOperationListResult.
func (dolr DatabaseOperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DatabaseOperationListResultIterator provides access to a complete listing of DatabaseOperation values.
type DatabaseOperationListResultIterator struct {
	i    int
	page DatabaseOperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DatabaseOperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseOperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DatabaseOperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DatabaseOperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DatabaseOperationListResultIterator) Response() DatabaseOperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DatabaseOperationListResultIterator) Value() DatabaseOperation {
	if !iter.page.NotDone() {
		return DatabaseOperation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DatabaseOperationListResultIterator type.
func NewDatabaseOperationListResultIterator(page DatabaseOperationListResultPage) DatabaseOperationListResultIterator {
	return DatabaseOperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dolr DatabaseOperationListResult) IsEmpty() bool {
	return dolr.Value == nil || len(*dolr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dolr DatabaseOperationListResult) hasNextLink() bool {
	return dolr.NextLink != nil && len(*dolr.NextLink) != 0
}

// databaseOperationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dolr DatabaseOperationListResult) databaseOperationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dolr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dolr.NextLink)))
}

// DatabaseOperationListResultPage contains a page of DatabaseOperation values.
type DatabaseOperationListResultPage struct {
	fn   func(context.Context, DatabaseOperationListResult) (DatabaseOperationListResult, error)
	dolr DatabaseOperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DatabaseOperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseOperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dolr)
		if err != nil {
			return err
		}
		page.dolr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DatabaseOperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DatabaseOperationListResultPage) NotDone() bool {
	return !page.dolr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DatabaseOperationListResultPage) Response() DatabaseOperationListResult {
	return page.dolr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DatabaseOperationListResultPage) Values() []DatabaseOperation {
	if page.dolr.IsEmpty() {
		return nil
	}
	return *page.dolr.Value
}

// Creates a new instance of the DatabaseOperationListResultPage type.
func NewDatabaseOperationListResultPage(cur DatabaseOperationListResult, getNextPage func(context.Context, DatabaseOperationListResult) (DatabaseOperationListResult, error)) DatabaseOperationListResultPage {
	return DatabaseOperationListResultPage{
		fn:   getNextPage,
		dolr: cur,
	}
}

// DatabaseOperationProperties the properties of a database operation.
type DatabaseOperationProperties struct {
	// DatabaseName - READ-ONLY; The name of the database the operation is being performed on.
	DatabaseName *string `json:"databaseName,omitempty"`
	// Operation - READ-ONLY; The name of operation.
	Operation *string `json:"operation,omitempty"`
	// OperationFriendlyName - READ-ONLY; The friendly name of operation.
	OperationFriendlyName *string `json:"operationFriendlyName,omitempty"`
	// PercentComplete - READ-ONLY; The percentage of the operation completed.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// ServerName - READ-ONLY; The name of the server.
	ServerName *string `json:"serverName,omitempty"`
	// StartTime - READ-ONLY; The operation start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// State - READ-ONLY; The operation state. Possible values include: 'ManagementOperationStatePending', 'ManagementOperationStateInProgress', 'ManagementOperationStateSucceeded', 'ManagementOperationStateFailed', 'ManagementOperationStateCancelInProgress', 'ManagementOperationStateCancelled'
	State ManagementOperationState `json:"state,omitempty"`
	// ErrorCode - READ-ONLY; The operation error code.
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// ErrorDescription - READ-ONLY; The operation error description.
	ErrorDescription *string `json:"errorDescription,omitempty"`
	// ErrorSeverity - READ-ONLY; The operation error severity.
	ErrorSeverity *int32 `json:"errorSeverity,omitempty"`
	// IsUserError - READ-ONLY; Whether or not the error is a user error.
	IsUserError *bool `json:"isUserError,omitempty"`
	// EstimatedCompletionTime - READ-ONLY; The estimated completion time of the operation.
	EstimatedCompletionTime *date.Time `json:"estimatedCompletionTime,omitempty"`
	// Description - READ-ONLY; The operation description.
	Description *string `json:"description,omitempty"`
	// IsCancellable - READ-ONLY; Whether the operation can be cancelled.
	IsCancellable *bool `json:"isCancellable,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseOperationProperties.
func (dop DatabaseOperationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DatabaseProperties the database's properties.
type DatabaseProperties struct {
	// CreateMode - Specifies the mode of database creation.
	//
	// Default: regular database creation.
	//
	// Copy: creates a database as a copy of an existing database. sourceDatabaseId must be specified as the resource ID of the source database.
	//
	// Secondary: creates a database as a secondary replica of an existing database. sourceDatabaseId must be specified as the resource ID of the existing primary database.
	//
	// PointInTimeRestore: Creates a database by restoring a point in time backup of an existing database. sourceDatabaseId must be specified as the resource ID of the existing database, and restorePointInTime must be specified.
	//
	// Recovery: Creates a database by restoring a geo-replicated backup. sourceDatabaseId must be specified as the recoverable database resource ID to restore.
	//
	// Restore: Creates a database by restoring a backup of a deleted database. sourceDatabaseId must be specified. If sourceDatabaseId is the database's original resource ID, then sourceDatabaseDeletionDate must be specified. Otherwise sourceDatabaseId must be the restorable dropped database resource ID and sourceDatabaseDeletionDate is ignored. restorePointInTime may also be specified to restore from an earlier point in time.
	//
	// RestoreLongTermRetentionBackup: Creates a database by restoring from a long term retention vault. recoveryServicesRecoveryPointResourceId must be specified as the recovery point resource ID.
	//
	// Copy, Secondary, and RestoreLongTermRetentionBackup are not supported for DataWarehouse edition. Possible values include: 'CreateModeDefault', 'CreateModeCopy', 'CreateModeSecondary', 'CreateModePointInTimeRestore', 'CreateModeRestore', 'CreateModeRecovery', 'CreateModeRestoreExternalBackup', 'CreateModeRestoreExternalBackupSecondary', 'CreateModeRestoreLongTermRetentionBackup', 'CreateModeOnlineSecondary'
	CreateMode CreateMode `json:"createMode,omitempty"`
	// Collation - The collation of the database.
	Collation *string `json:"collation,omitempty"`
	// MaxSizeBytes - The max size of the database expressed in bytes.
	MaxSizeBytes *int64 `json:"maxSizeBytes,omitempty"`
	// SampleName - The name of the sample schema to apply when creating this database. Possible values include: 'SampleNameAdventureWorksLT', 'SampleNameWideWorldImportersStd', 'SampleNameWideWorldImportersFull'
	SampleName SampleName `json:"sampleName,omitempty"`
	// ElasticPoolID - The resource identifier of the elastic pool containing this database.
	ElasticPoolID *string `json:"elasticPoolId,omitempty"`
	// SourceDatabaseID - The resource identifier of the source database associated with create operation of this database.
	SourceDatabaseID *string `json:"sourceDatabaseId,omitempty"`
	// Status - READ-ONLY; The status of the database. Possible values include: 'DatabaseStatusOnline', 'DatabaseStatusRestoring', 'DatabaseStatusRecoveryPending', 'DatabaseStatusRecovering', 'DatabaseStatusSuspect', 'DatabaseStatusOffline', 'DatabaseStatusStandby', 'DatabaseStatusShutdown', 'DatabaseStatusEmergencyMode', 'DatabaseStatusAutoClosed', 'DatabaseStatusCopying', 'DatabaseStatusCreating', 'DatabaseStatusInaccessible', 'DatabaseStatusOfflineSecondary', 'DatabaseStatusPausing', 'DatabaseStatusPaused', 'DatabaseStatusResuming', 'DatabaseStatusScaling', 'DatabaseStatusOfflineChangingDwPerformanceTiers', 'DatabaseStatusOnlineChangingDwPerformanceTiers', 'DatabaseStatusDisabled', 'DatabaseStatusStopping', 'DatabaseStatusStopped', 'DatabaseStatusStarting'
	Status DatabaseStatus `json:"status,omitempty"`
	// DatabaseID - READ-ONLY; The ID of the database.
	DatabaseID *uuid.UUID `json:"databaseId,omitempty"`
	// CreationDate - READ-ONLY; The creation date of the database (ISO8601 format).
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// CurrentServiceObjectiveName - READ-ONLY; The current service level objective name of the database.
	CurrentServiceObjectiveName *string `json:"currentServiceObjectiveName,omitempty"`
	// RequestedServiceObjectiveName - READ-ONLY; The requested service level objective name of the database.
	RequestedServiceObjectiveName *string `json:"requestedServiceObjectiveName,omitempty"`
	// DefaultSecondaryLocation - READ-ONLY; The default secondary region for this database.
	DefaultSecondaryLocation *string `json:"defaultSecondaryLocation,omitempty"`
	// FailoverGroupID - READ-ONLY; Failover Group resource identifier that this database belongs to.
	FailoverGroupID *string `json:"failoverGroupId,omitempty"`
	// RestorePointInTime - Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new database.
	RestorePointInTime *date.Time `json:"restorePointInTime,omitempty"`
	// SourceDatabaseDeletionDate - Specifies the time that the database was deleted.
	SourceDatabaseDeletionDate *date.Time `json:"sourceDatabaseDeletionDate,omitempty"`
	// RecoveryServicesRecoveryPointID - The resource identifier of the recovery point associated with create operation of this database.
	RecoveryServicesRecoveryPointID *string `json:"recoveryServicesRecoveryPointId,omitempty"`
	// LongTermRetentionBackupResourceID - The resource identifier of the long term retention backup associated with create operation of this database.
	LongTermRetentionBackupResourceID *string `json:"longTermRetentionBackupResourceId,omitempty"`
	// RecoverableDatabaseID - The resource identifier of the recoverable database associated with create operation of this database.
	RecoverableDatabaseID *string `json:"recoverableDatabaseId,omitempty"`
	// RestorableDroppedDatabaseID - The resource identifier of the restorable dropped database associated with create operation of this database.
	RestorableDroppedDatabaseID *string `json:"restorableDroppedDatabaseId,omitempty"`
	// CatalogCollation - Collation of the metadata catalog. Possible values include: 'CatalogCollationTypeDATABASEDEFAULT', 'CatalogCollationTypeSQLLatin1GeneralCP1CIAS'
	CatalogCollation CatalogCollationType `json:"catalogCollation,omitempty"`
	// ZoneRedundant - Whether or not this database is zone redundant, which means the replicas of this database will be spread across multiple availability zones.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
	// LicenseType - The license type to apply for this database. `LicenseIncluded` if you need a license, or `BasePrice` if you have a license and are eligible for the Azure Hybrid Benefit. Possible values include: 'DatabaseLicenseTypeLicenseIncluded', 'DatabaseLicenseTypeBasePrice'
	LicenseType DatabaseLicenseType `json:"licenseType,omitempty"`
	// MaxLogSizeBytes - READ-ONLY; The max log size for this database.
	MaxLogSizeBytes *int64 `json:"maxLogSizeBytes,omitempty"`
	// EarliestRestoreDate - READ-ONLY; This records the earliest start date and time that restore is available for this database (ISO8601 format).
	EarliestRestoreDate *date.Time `json:"earliestRestoreDate,omitempty"`
	// ReadScale - The state of read-only routing. If enabled, connections that have application intent set to readonly in their connection string may be routed to a readonly secondary replica in the same region. Not applicable to a Hyperscale database within an elastic pool. Possible values include: 'DatabaseReadScaleEnabled', 'DatabaseReadScaleDisabled'
	ReadScale DatabaseReadScale `json:"readScale,omitempty"`
	// HighAvailabilityReplicaCount - The number of secondary replicas associated with the database that are used to provide high availability. Not applicable to a Hyperscale database within an elastic pool.
	HighAvailabilityReplicaCount *int32 `json:"highAvailabilityReplicaCount,omitempty"`
	// SecondaryType - The secondary type of the database if it is a secondary.  Valid values are Geo, Named and Standby. Possible values include: 'SecondaryTypeGeo', 'SecondaryTypeNamed', 'SecondaryTypeStandby'
	SecondaryType SecondaryType `json:"secondaryType,omitempty"`
	// CurrentSku - READ-ONLY; The name and tier of the SKU.
	CurrentSku *Sku `json:"currentSku,omitempty"`
	// AutoPauseDelay - Time in minutes after which database is automatically paused. A value of -1 means that automatic pause is disabled
	AutoPauseDelay *int32 `json:"autoPauseDelay,omitempty"`
	// CurrentBackupStorageRedundancy - READ-ONLY; The storage account type used to store backups for this database. Possible values include: 'BackupStorageRedundancyGeo', 'BackupStorageRedundancyLocal', 'BackupStorageRedundancyZone', 'BackupStorageRedundancyGeoZone'
	CurrentBackupStorageRedundancy BackupStorageRedundancy `json:"currentBackupStorageRedundancy,omitempty"`
	// RequestedBackupStorageRedundancy - The storage account type to be used to store backups for this database. Possible values include: 'BackupStorageRedundancyGeo', 'BackupStorageRedundancyLocal', 'BackupStorageRedundancyZone', 'BackupStorageRedundancyGeoZone'
	RequestedBackupStorageRedundancy BackupStorageRedundancy `json:"requestedBackupStorageRedundancy,omitempty"`
	// MinCapacity - Minimal capacity that database will always have allocated, if not paused
	MinCapacity *float64 `json:"minCapacity,omitempty"`
	// PausedDate - READ-ONLY; The date when database was paused by user configuration or action(ISO8601 format). Null if the database is ready.
	PausedDate *date.Time `json:"pausedDate,omitempty"`
	// ResumedDate - READ-ONLY; The date when database was resumed by user action or database login (ISO8601 format). Null if the database is paused.
	ResumedDate *date.Time `json:"resumedDate,omitempty"`
	// MaintenanceConfigurationID - Maintenance configuration id assigned to the database. This configuration defines the period when the maintenance updates will occur.
	MaintenanceConfigurationID *string `json:"maintenanceConfigurationId,omitempty"`
	// IsLedgerOn - Whether or not this database is a ledger database, which means all tables in the database are ledger tables. Note: the value of this property cannot be changed after the database has been created.
	IsLedgerOn *bool `json:"isLedgerOn,omitempty"`
	// IsInfraEncryptionEnabled - READ-ONLY; Infra encryption is enabled for this database.
	IsInfraEncryptionEnabled *bool `json:"isInfraEncryptionEnabled,omitempty"`
	// FederatedClientID - The Client id used for cross tenant per database CMK scenario
	FederatedClientID *uuid.UUID `json:"federatedClientId,omitempty"`
	// SourceResourceID - The resource identifier of the source associated with the create operation of this database.
	//
	// This property is only supported for DataWarehouse edition and allows to restore across subscriptions.
	//
	// When sourceResourceId is specified, sourceDatabaseId, recoverableDatabaseId, restorableDroppedDatabaseId and sourceDatabaseDeletionDate must not be specified and CreateMode must be PointInTimeRestore, Restore or Recover.
	//
	// When createMode is PointInTimeRestore, sourceResourceId must be the resource ID of the existing database or existing sql pool, and restorePointInTime must be specified.
	//
	// When createMode is Restore, sourceResourceId must be the resource ID of restorable dropped database or restorable dropped sql pool.
	//
	// When createMode is Recover, sourceResourceId must be the resource ID of recoverable database or recoverable sql pool.
	//
	// When source subscription belongs to a different tenant than target subscription, “x-ms-authorization-auxiliary” header must contain authentication token for the source tenant. For more details about “x-ms-authorization-auxiliary” header see https://docs.microsoft.com/en-us/azure/azure-resource-manager/management/authenticate-multi-tenant
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseProperties.
func (dp DatabaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dp.CreateMode != "" {
		objectMap["createMode"] = dp.CreateMode
	}
	if dp.Collation != nil {
		objectMap["collation"] = dp.Collation
	}
	if dp.MaxSizeBytes != nil {
		objectMap["maxSizeBytes"] = dp.MaxSizeBytes
	}
	if dp.SampleName != "" {
		objectMap["sampleName"] = dp.SampleName
	}
	if dp.ElasticPoolID != nil {
		objectMap["elasticPoolId"] = dp.ElasticPoolID
	}
	if dp.SourceDatabaseID != nil {
		objectMap["sourceDatabaseId"] = dp.SourceDatabaseID
	}
	if dp.RestorePointInTime != nil {
		objectMap["restorePointInTime"] = dp.RestorePointInTime
	}
	if dp.SourceDatabaseDeletionDate != nil {
		objectMap["sourceDatabaseDeletionDate"] = dp.SourceDatabaseDeletionDate
	}
	if dp.RecoveryServicesRecoveryPointID != nil {
		objectMap["recoveryServicesRecoveryPointId"] = dp.RecoveryServicesRecoveryPointID
	}
	if dp.LongTermRetentionBackupResourceID != nil {
		objectMap["longTermRetentionBackupResourceId"] = dp.LongTermRetentionBackupResourceID
	}
	if dp.RecoverableDatabaseID != nil {
		objectMap["recoverableDatabaseId"] = dp.RecoverableDatabaseID
	}
	if dp.RestorableDroppedDatabaseID != nil {
		objectMap["restorableDroppedDatabaseId"] = dp.RestorableDroppedDatabaseID
	}
	if dp.CatalogCollation != "" {
		objectMap["catalogCollation"] = dp.CatalogCollation
	}
	if dp.ZoneRedundant != nil {
		objectMap["zoneRedundant"] = dp.ZoneRedundant
	}
	if dp.LicenseType != "" {
		objectMap["licenseType"] = dp.LicenseType
	}
	if dp.ReadScale != "" {
		objectMap["readScale"] = dp.ReadScale
	}
	if dp.HighAvailabilityReplicaCount != nil {
		objectMap["highAvailabilityReplicaCount"] = dp.HighAvailabilityReplicaCount
	}
	if dp.SecondaryType != "" {
		objectMap["secondaryType"] = dp.SecondaryType
	}
	if dp.AutoPauseDelay != nil {
		objectMap["autoPauseDelay"] = dp.AutoPauseDelay
	}
	if dp.RequestedBackupStorageRedundancy != "" {
		objectMap["requestedBackupStorageRedundancy"] = dp.RequestedBackupStorageRedundancy
	}
	if dp.MinCapacity != nil {
		objectMap["minCapacity"] = dp.MinCapacity
	}
	if dp.MaintenanceConfigurationID != nil {
		objectMap["maintenanceConfigurationId"] = dp.MaintenanceConfigurationID
	}
	if dp.IsLedgerOn != nil {
		objectMap["isLedgerOn"] = dp.IsLedgerOn
	}
	if dp.FederatedClientID != nil {
		objectMap["federatedClientId"] = dp.FederatedClientID
	}
	if dp.SourceResourceID != nil {
		objectMap["sourceResourceId"] = dp.SourceResourceID
	}
	return json.Marshal(objectMap)
}

// DatabaseSchema a database schema resource.
type DatabaseSchema struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseSchema.
func (ds DatabaseSchema) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DatabaseSchemaListResult a list of database schemas.
type DatabaseSchemaListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]DatabaseSchema `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseSchemaListResult.
func (dslr DatabaseSchemaListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DatabaseSchemaListResultIterator provides access to a complete listing of DatabaseSchema values.
type DatabaseSchemaListResultIterator struct {
	i    int
	page DatabaseSchemaListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DatabaseSchemaListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseSchemaListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DatabaseSchemaListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DatabaseSchemaListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DatabaseSchemaListResultIterator) Response() DatabaseSchemaListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DatabaseSchemaListResultIterator) Value() DatabaseSchema {
	if !iter.page.NotDone() {
		return DatabaseSchema{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DatabaseSchemaListResultIterator type.
func NewDatabaseSchemaListResultIterator(page DatabaseSchemaListResultPage) DatabaseSchemaListResultIterator {
	return DatabaseSchemaListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dslr DatabaseSchemaListResult) IsEmpty() bool {
	return dslr.Value == nil || len(*dslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dslr DatabaseSchemaListResult) hasNextLink() bool {
	return dslr.NextLink != nil && len(*dslr.NextLink) != 0
}

// databaseSchemaListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dslr DatabaseSchemaListResult) databaseSchemaListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dslr.NextLink)))
}

// DatabaseSchemaListResultPage contains a page of DatabaseSchema values.
type DatabaseSchemaListResultPage struct {
	fn   func(context.Context, DatabaseSchemaListResult) (DatabaseSchemaListResult, error)
	dslr DatabaseSchemaListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DatabaseSchemaListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseSchemaListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dslr)
		if err != nil {
			return err
		}
		page.dslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DatabaseSchemaListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DatabaseSchemaListResultPage) NotDone() bool {
	return !page.dslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DatabaseSchemaListResultPage) Response() DatabaseSchemaListResult {
	return page.dslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DatabaseSchemaListResultPage) Values() []DatabaseSchema {
	if page.dslr.IsEmpty() {
		return nil
	}
	return *page.dslr.Value
}

// Creates a new instance of the DatabaseSchemaListResultPage type.
func NewDatabaseSchemaListResultPage(cur DatabaseSchemaListResult, getNextPage func(context.Context, DatabaseSchemaListResult) (DatabaseSchemaListResult, error)) DatabaseSchemaListResultPage {
	return DatabaseSchemaListResultPage{
		fn:   getNextPage,
		dslr: cur,
	}
}

// DatabasesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (Database, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesCreateOrUpdateFuture.Result.
func (future *DatabasesCreateOrUpdateFuture) result(client DatabasesClient) (d Database, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		d.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.CreateOrUpdateResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesCreateOrUpdateFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabasesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesDeleteFuture.Result.
func (future *DatabasesDeleteFuture) result(client DatabasesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseSecurityAlertListResult a list of the database's security alert policies.
type DatabaseSecurityAlertListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]DatabaseSecurityAlertPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseSecurityAlertListResult.
func (dsalr DatabaseSecurityAlertListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DatabaseSecurityAlertListResultIterator provides access to a complete listing of
// DatabaseSecurityAlertPolicy values.
type DatabaseSecurityAlertListResultIterator struct {
	i    int
	page DatabaseSecurityAlertListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DatabaseSecurityAlertListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseSecurityAlertListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DatabaseSecurityAlertListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DatabaseSecurityAlertListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DatabaseSecurityAlertListResultIterator) Response() DatabaseSecurityAlertListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DatabaseSecurityAlertListResultIterator) Value() DatabaseSecurityAlertPolicy {
	if !iter.page.NotDone() {
		return DatabaseSecurityAlertPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DatabaseSecurityAlertListResultIterator type.
func NewDatabaseSecurityAlertListResultIterator(page DatabaseSecurityAlertListResultPage) DatabaseSecurityAlertListResultIterator {
	return DatabaseSecurityAlertListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dsalr DatabaseSecurityAlertListResult) IsEmpty() bool {
	return dsalr.Value == nil || len(*dsalr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dsalr DatabaseSecurityAlertListResult) hasNextLink() bool {
	return dsalr.NextLink != nil && len(*dsalr.NextLink) != 0
}

// databaseSecurityAlertListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dsalr DatabaseSecurityAlertListResult) databaseSecurityAlertListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dsalr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dsalr.NextLink)))
}

// DatabaseSecurityAlertListResultPage contains a page of DatabaseSecurityAlertPolicy values.
type DatabaseSecurityAlertListResultPage struct {
	fn    func(context.Context, DatabaseSecurityAlertListResult) (DatabaseSecurityAlertListResult, error)
	dsalr DatabaseSecurityAlertListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DatabaseSecurityAlertListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseSecurityAlertListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dsalr)
		if err != nil {
			return err
		}
		page.dsalr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DatabaseSecurityAlertListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DatabaseSecurityAlertListResultPage) NotDone() bool {
	return !page.dsalr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DatabaseSecurityAlertListResultPage) Response() DatabaseSecurityAlertListResult {
	return page.dsalr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DatabaseSecurityAlertListResultPage) Values() []DatabaseSecurityAlertPolicy {
	if page.dsalr.IsEmpty() {
		return nil
	}
	return *page.dsalr.Value
}

// Creates a new instance of the DatabaseSecurityAlertListResultPage type.
func NewDatabaseSecurityAlertListResultPage(cur DatabaseSecurityAlertListResult, getNextPage func(context.Context, DatabaseSecurityAlertListResult) (DatabaseSecurityAlertListResult, error)) DatabaseSecurityAlertListResultPage {
	return DatabaseSecurityAlertListResultPage{
		fn:    getNextPage,
		dsalr: cur,
	}
}

// DatabaseSecurityAlertPolicy a database security alert policy.
type DatabaseSecurityAlertPolicy struct {
	autorest.Response `json:"-"`
	// SystemData - READ-ONLY; SystemData of SecurityAlertPolicyResource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// SecurityAlertsPolicyProperties - Resource properties.
	*SecurityAlertsPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseSecurityAlertPolicy.
func (dsap DatabaseSecurityAlertPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dsap.SecurityAlertsPolicyProperties != nil {
		objectMap["properties"] = dsap.SecurityAlertsPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseSecurityAlertPolicy struct.
func (dsap *DatabaseSecurityAlertPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				dsap.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var securityAlertsPolicyProperties SecurityAlertsPolicyProperties
				err = json.Unmarshal(*v, &securityAlertsPolicyProperties)
				if err != nil {
					return err
				}
				dsap.SecurityAlertsPolicyProperties = &securityAlertsPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dsap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dsap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dsap.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabasesExportFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesExportFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (ImportExportOperationResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesExportFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesExportFuture.Result.
func (future *DatabasesExportFuture) result(client DatabasesClient) (ieor ImportExportOperationResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesExportFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ieor.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesExportFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ieor.Response.Response, err = future.GetResult(sender); err == nil && ieor.Response.Response.StatusCode != http.StatusNoContent {
		ieor, err = client.ExportResponder(ieor.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesExportFuture", "Result", ieor.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabasesFailoverFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesFailoverFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesFailoverFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesFailoverFuture.Result.
func (future *DatabasesFailoverFuture) result(client DatabasesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesFailoverFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesFailoverFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabasesImportFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesImportFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (ImportExportOperationResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesImportFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesImportFuture.Result.
func (future *DatabasesImportFuture) result(client DatabasesClient) (ieor ImportExportOperationResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesImportFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ieor.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesImportFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ieor.Response.Response, err = future.GetResult(sender); err == nil && ieor.Response.Response.StatusCode != http.StatusNoContent {
		ieor, err = client.ImportResponder(ieor.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesImportFuture", "Result", ieor.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabasesPauseFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesPauseFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (Database, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesPauseFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesPauseFuture.Result.
func (future *DatabasesPauseFuture) result(client DatabasesClient) (d Database, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesPauseFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		d.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesPauseFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.PauseResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesPauseFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabaseSQLVulnerabilityAssessmentBaselineSet a database sql vulnerability assessment baseline set.
type DatabaseSQLVulnerabilityAssessmentBaselineSet struct {
	autorest.Response `json:"-"`
	// SystemData - READ-ONLY; SystemData of DatabaseSqlVulnerabilityAssessmentBaselineSetResource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// DatabaseSQLVulnerabilityAssessmentBaselineSetProperties - Resource properties.
	*DatabaseSQLVulnerabilityAssessmentBaselineSetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseSQLVulnerabilityAssessmentBaselineSet.
func (dsvabs DatabaseSQLVulnerabilityAssessmentBaselineSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dsvabs.DatabaseSQLVulnerabilityAssessmentBaselineSetProperties != nil {
		objectMap["properties"] = dsvabs.DatabaseSQLVulnerabilityAssessmentBaselineSetProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseSQLVulnerabilityAssessmentBaselineSet struct.
func (dsvabs *DatabaseSQLVulnerabilityAssessmentBaselineSet) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				dsvabs.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var databaseSQLVulnerabilityAssessmentBaselineSetProperties DatabaseSQLVulnerabilityAssessmentBaselineSetProperties
				err = json.Unmarshal(*v, &databaseSQLVulnerabilityAssessmentBaselineSetProperties)
				if err != nil {
					return err
				}
				dsvabs.DatabaseSQLVulnerabilityAssessmentBaselineSetProperties = &databaseSQLVulnerabilityAssessmentBaselineSetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dsvabs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dsvabs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dsvabs.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseSQLVulnerabilityAssessmentBaselineSetListResult a list of SQL Vulnerability Assessments baseline
// set.
type DatabaseSQLVulnerabilityAssessmentBaselineSetListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]DatabaseSQLVulnerabilityAssessmentBaselineSet `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseSQLVulnerabilityAssessmentBaselineSetListResult.
func (dsvabslr DatabaseSQLVulnerabilityAssessmentBaselineSetListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DatabaseSQLVulnerabilityAssessmentBaselineSetListResultIterator provides access to a complete listing of
// DatabaseSQLVulnerabilityAssessmentBaselineSet values.
type DatabaseSQLVulnerabilityAssessmentBaselineSetListResultIterator struct {
	i    int
	page DatabaseSQLVulnerabilityAssessmentBaselineSetListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DatabaseSQLVulnerabilityAssessmentBaselineSetListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseSQLVulnerabilityAssessmentBaselineSetListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DatabaseSQLVulnerabilityAssessmentBaselineSetListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DatabaseSQLVulnerabilityAssessmentBaselineSetListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DatabaseSQLVulnerabilityAssessmentBaselineSetListResultIterator) Response() DatabaseSQLVulnerabilityAssessmentBaselineSetListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DatabaseSQLVulnerabilityAssessmentBaselineSetListResultIterator) Value() DatabaseSQLVulnerabilityAssessmentBaselineSet {
	if !iter.page.NotDone() {
		return DatabaseSQLVulnerabilityAssessmentBaselineSet{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DatabaseSQLVulnerabilityAssessmentBaselineSetListResultIterator type.
func NewDatabaseSQLVulnerabilityAssessmentBaselineSetListResultIterator(page DatabaseSQLVulnerabilityAssessmentBaselineSetListResultPage) DatabaseSQLVulnerabilityAssessmentBaselineSetListResultIterator {
	return DatabaseSQLVulnerabilityAssessmentBaselineSetListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dsvabslr DatabaseSQLVulnerabilityAssessmentBaselineSetListResult) IsEmpty() bool {
	return dsvabslr.Value == nil || len(*dsvabslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dsvabslr DatabaseSQLVulnerabilityAssessmentBaselineSetListResult) hasNextLink() bool {
	return dsvabslr.NextLink != nil && len(*dsvabslr.NextLink) != 0
}

// databaseSQLVulnerabilityAssessmentBaselineSetListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dsvabslr DatabaseSQLVulnerabilityAssessmentBaselineSetListResult) databaseSQLVulnerabilityAssessmentBaselineSetListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dsvabslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dsvabslr.NextLink)))
}

// DatabaseSQLVulnerabilityAssessmentBaselineSetListResultPage contains a page of
// DatabaseSQLVulnerabilityAssessmentBaselineSet values.
type DatabaseSQLVulnerabilityAssessmentBaselineSetListResultPage struct {
	fn       func(context.Context, DatabaseSQLVulnerabilityAssessmentBaselineSetListResult) (DatabaseSQLVulnerabilityAssessmentBaselineSetListResult, error)
	dsvabslr DatabaseSQLVulnerabilityAssessmentBaselineSetListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DatabaseSQLVulnerabilityAssessmentBaselineSetListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseSQLVulnerabilityAssessmentBaselineSetListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dsvabslr)
		if err != nil {
			return err
		}
		page.dsvabslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DatabaseSQLVulnerabilityAssessmentBaselineSetListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DatabaseSQLVulnerabilityAssessmentBaselineSetListResultPage) NotDone() bool {
	return !page.dsvabslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DatabaseSQLVulnerabilityAssessmentBaselineSetListResultPage) Response() DatabaseSQLVulnerabilityAssessmentBaselineSetListResult {
	return page.dsvabslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DatabaseSQLVulnerabilityAssessmentBaselineSetListResultPage) Values() []DatabaseSQLVulnerabilityAssessmentBaselineSet {
	if page.dsvabslr.IsEmpty() {
		return nil
	}
	return *page.dsvabslr.Value
}

// Creates a new instance of the DatabaseSQLVulnerabilityAssessmentBaselineSetListResultPage type.
func NewDatabaseSQLVulnerabilityAssessmentBaselineSetListResultPage(cur DatabaseSQLVulnerabilityAssessmentBaselineSetListResult, getNextPage func(context.Context, DatabaseSQLVulnerabilityAssessmentBaselineSetListResult) (DatabaseSQLVulnerabilityAssessmentBaselineSetListResult, error)) DatabaseSQLVulnerabilityAssessmentBaselineSetListResultPage {
	return DatabaseSQLVulnerabilityAssessmentBaselineSetListResultPage{
		fn:       getNextPage,
		dsvabslr: cur,
	}
}

// DatabaseSQLVulnerabilityAssessmentBaselineSetProperties properties of a database Sql Vulnerability
// Assessment baseline set.
type DatabaseSQLVulnerabilityAssessmentBaselineSetProperties struct {
	// Results - The baseline set result
	Results map[string][][]string `json:"results"`
}

// MarshalJSON is the custom marshaler for DatabaseSQLVulnerabilityAssessmentBaselineSetProperties.
func (dsvabsp DatabaseSQLVulnerabilityAssessmentBaselineSetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dsvabsp.Results != nil {
		objectMap["results"] = dsvabsp.Results
	}
	return json.Marshal(objectMap)
}

// DatabaseSQLVulnerabilityAssessmentExecuteScanExecuteFuture an abstraction for monitoring and retrieving
// the results of a long-running operation.
type DatabaseSQLVulnerabilityAssessmentExecuteScanExecuteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabaseSQLVulnerabilityAssessmentExecuteScanClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabaseSQLVulnerabilityAssessmentExecuteScanExecuteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabaseSQLVulnerabilityAssessmentExecuteScanExecuteFuture.Result.
func (future *DatabaseSQLVulnerabilityAssessmentExecuteScanExecuteFuture) result(client DatabaseSQLVulnerabilityAssessmentExecuteScanClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseSQLVulnerabilityAssessmentExecuteScanExecuteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.DatabaseSQLVulnerabilityAssessmentExecuteScanExecuteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseSQLVulnerabilityAssessmentRuleBaseline a database sql vulnerability assessment rule baseline.
type DatabaseSQLVulnerabilityAssessmentRuleBaseline struct {
	autorest.Response `json:"-"`
	// SystemData - READ-ONLY; SystemData of DatabaseSqlVulnerabilityAssessmentRuleBaselineResource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// DatabaseSQLVulnerabilityAssessmentRuleBaselineProperties - Resource properties.
	*DatabaseSQLVulnerabilityAssessmentRuleBaselineProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseSQLVulnerabilityAssessmentRuleBaseline.
func (dsvarb DatabaseSQLVulnerabilityAssessmentRuleBaseline) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dsvarb.DatabaseSQLVulnerabilityAssessmentRuleBaselineProperties != nil {
		objectMap["properties"] = dsvarb.DatabaseSQLVulnerabilityAssessmentRuleBaselineProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseSQLVulnerabilityAssessmentRuleBaseline struct.
func (dsvarb *DatabaseSQLVulnerabilityAssessmentRuleBaseline) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				dsvarb.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var databaseSQLVulnerabilityAssessmentRuleBaselineProperties DatabaseSQLVulnerabilityAssessmentRuleBaselineProperties
				err = json.Unmarshal(*v, &databaseSQLVulnerabilityAssessmentRuleBaselineProperties)
				if err != nil {
					return err
				}
				dsvarb.DatabaseSQLVulnerabilityAssessmentRuleBaselineProperties = &databaseSQLVulnerabilityAssessmentRuleBaselineProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dsvarb.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dsvarb.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dsvarb.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseSQLVulnerabilityAssessmentRuleBaselineInput a database sql vulnerability assessment rule
// baseline input.
type DatabaseSQLVulnerabilityAssessmentRuleBaselineInput struct {
	// SystemData - READ-ONLY; SystemData of DatabaseSqlVulnerabilityAssessmentRuleBaselineInputResource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// DatabaseSQLVulnerabilityAssessmentRuleBaselineInputProperties - Resource properties.
	*DatabaseSQLVulnerabilityAssessmentRuleBaselineInputProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseSQLVulnerabilityAssessmentRuleBaselineInput.
func (dsvarbi DatabaseSQLVulnerabilityAssessmentRuleBaselineInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dsvarbi.DatabaseSQLVulnerabilityAssessmentRuleBaselineInputProperties != nil {
		objectMap["properties"] = dsvarbi.DatabaseSQLVulnerabilityAssessmentRuleBaselineInputProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseSQLVulnerabilityAssessmentRuleBaselineInput struct.
func (dsvarbi *DatabaseSQLVulnerabilityAssessmentRuleBaselineInput) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				dsvarbi.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var databaseSQLVulnerabilityAssessmentRuleBaselineInputProperties DatabaseSQLVulnerabilityAssessmentRuleBaselineInputProperties
				err = json.Unmarshal(*v, &databaseSQLVulnerabilityAssessmentRuleBaselineInputProperties)
				if err != nil {
					return err
				}
				dsvarbi.DatabaseSQLVulnerabilityAssessmentRuleBaselineInputProperties = &databaseSQLVulnerabilityAssessmentRuleBaselineInputProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dsvarbi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dsvarbi.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dsvarbi.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseSQLVulnerabilityAssessmentRuleBaselineInputProperties properties of a database Sql Vulnerability
// Assessment rule baseline.
type DatabaseSQLVulnerabilityAssessmentRuleBaselineInputProperties struct {
	// LatestScan - The latest scan flag
	LatestScan *bool `json:"latestScan,omitempty"`
	// Results - The rule baseline result
	Results *[][]string `json:"results,omitempty"`
}

// DatabaseSQLVulnerabilityAssessmentRuleBaselineListInput a database sql vulnerability assessment rule
// baseline list input.
type DatabaseSQLVulnerabilityAssessmentRuleBaselineListInput struct {
	// SystemData - READ-ONLY; SystemData of DatabaseSqlVulnerabilityAssessmentRuleBaselineListInputResource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// DatabaseSQLVulnerabilityAssessmentRuleBaselineListInputProperties - Resource properties.
	*DatabaseSQLVulnerabilityAssessmentRuleBaselineListInputProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseSQLVulnerabilityAssessmentRuleBaselineListInput.
func (dsvarbli DatabaseSQLVulnerabilityAssessmentRuleBaselineListInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dsvarbli.DatabaseSQLVulnerabilityAssessmentRuleBaselineListInputProperties != nil {
		objectMap["properties"] = dsvarbli.DatabaseSQLVulnerabilityAssessmentRuleBaselineListInputProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseSQLVulnerabilityAssessmentRuleBaselineListInput struct.
func (dsvarbli *DatabaseSQLVulnerabilityAssessmentRuleBaselineListInput) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				dsvarbli.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var databaseSQLVulnerabilityAssessmentRuleBaselineListInputProperties DatabaseSQLVulnerabilityAssessmentRuleBaselineListInputProperties
				err = json.Unmarshal(*v, &databaseSQLVulnerabilityAssessmentRuleBaselineListInputProperties)
				if err != nil {
					return err
				}
				dsvarbli.DatabaseSQLVulnerabilityAssessmentRuleBaselineListInputProperties = &databaseSQLVulnerabilityAssessmentRuleBaselineListInputProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dsvarbli.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dsvarbli.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dsvarbli.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseSQLVulnerabilityAssessmentRuleBaselineListInputProperties properties of a database Sql
// Vulnerability Assessment rule baseline.
type DatabaseSQLVulnerabilityAssessmentRuleBaselineListInputProperties struct {
	// LatestScan - The latest scan flag
	LatestScan *bool `json:"latestScan,omitempty"`
	// Results - The rule baseline result list
	Results map[string][][]string `json:"results"`
}

// MarshalJSON is the custom marshaler for DatabaseSQLVulnerabilityAssessmentRuleBaselineListInputProperties.
func (dsvarblip DatabaseSQLVulnerabilityAssessmentRuleBaselineListInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dsvarblip.LatestScan != nil {
		objectMap["latestScan"] = dsvarblip.LatestScan
	}
	if dsvarblip.Results != nil {
		objectMap["results"] = dsvarblip.Results
	}
	return json.Marshal(objectMap)
}

// DatabaseSQLVulnerabilityAssessmentRuleBaselineListResult a list of SQL Vulnerability Assessments rule
// baseline.
type DatabaseSQLVulnerabilityAssessmentRuleBaselineListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]DatabaseSQLVulnerabilityAssessmentRuleBaseline `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseSQLVulnerabilityAssessmentRuleBaselineListResult.
func (dsvarblr DatabaseSQLVulnerabilityAssessmentRuleBaselineListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DatabaseSQLVulnerabilityAssessmentRuleBaselineListResultIterator provides access to a complete listing
// of DatabaseSQLVulnerabilityAssessmentRuleBaseline values.
type DatabaseSQLVulnerabilityAssessmentRuleBaselineListResultIterator struct {
	i    int
	page DatabaseSQLVulnerabilityAssessmentRuleBaselineListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DatabaseSQLVulnerabilityAssessmentRuleBaselineListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseSQLVulnerabilityAssessmentRuleBaselineListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DatabaseSQLVulnerabilityAssessmentRuleBaselineListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DatabaseSQLVulnerabilityAssessmentRuleBaselineListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DatabaseSQLVulnerabilityAssessmentRuleBaselineListResultIterator) Response() DatabaseSQLVulnerabilityAssessmentRuleBaselineListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DatabaseSQLVulnerabilityAssessmentRuleBaselineListResultIterator) Value() DatabaseSQLVulnerabilityAssessmentRuleBaseline {
	if !iter.page.NotDone() {
		return DatabaseSQLVulnerabilityAssessmentRuleBaseline{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DatabaseSQLVulnerabilityAssessmentRuleBaselineListResultIterator type.
func NewDatabaseSQLVulnerabilityAssessmentRuleBaselineListResultIterator(page DatabaseSQLVulnerabilityAssessmentRuleBaselineListResultPage) DatabaseSQLVulnerabilityAssessmentRuleBaselineListResultIterator {
	return DatabaseSQLVulnerabilityAssessmentRuleBaselineListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dsvarblr DatabaseSQLVulnerabilityAssessmentRuleBaselineListResult) IsEmpty() bool {
	return dsvarblr.Value == nil || len(*dsvarblr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dsvarblr DatabaseSQLVulnerabilityAssessmentRuleBaselineListResult) hasNextLink() bool {
	return dsvarblr.NextLink != nil && len(*dsvarblr.NextLink) != 0
}

// databaseSQLVulnerabilityAssessmentRuleBaselineListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dsvarblr DatabaseSQLVulnerabilityAssessmentRuleBaselineListResult) databaseSQLVulnerabilityAssessmentRuleBaselineListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dsvarblr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dsvarblr.NextLink)))
}

// DatabaseSQLVulnerabilityAssessmentRuleBaselineListResultPage contains a page of
// DatabaseSQLVulnerabilityAssessmentRuleBaseline values.
type DatabaseSQLVulnerabilityAssessmentRuleBaselineListResultPage struct {
	fn       func(context.Context, DatabaseSQLVulnerabilityAssessmentRuleBaselineListResult) (DatabaseSQLVulnerabilityAssessmentRuleBaselineListResult, error)
	dsvarblr DatabaseSQLVulnerabilityAssessmentRuleBaselineListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DatabaseSQLVulnerabilityAssessmentRuleBaselineListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseSQLVulnerabilityAssessmentRuleBaselineListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dsvarblr)
		if err != nil {
			return err
		}
		page.dsvarblr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DatabaseSQLVulnerabilityAssessmentRuleBaselineListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DatabaseSQLVulnerabilityAssessmentRuleBaselineListResultPage) NotDone() bool {
	return !page.dsvarblr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DatabaseSQLVulnerabilityAssessmentRuleBaselineListResultPage) Response() DatabaseSQLVulnerabilityAssessmentRuleBaselineListResult {
	return page.dsvarblr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DatabaseSQLVulnerabilityAssessmentRuleBaselineListResultPage) Values() []DatabaseSQLVulnerabilityAssessmentRuleBaseline {
	if page.dsvarblr.IsEmpty() {
		return nil
	}
	return *page.dsvarblr.Value
}

// Creates a new instance of the DatabaseSQLVulnerabilityAssessmentRuleBaselineListResultPage type.
func NewDatabaseSQLVulnerabilityAssessmentRuleBaselineListResultPage(cur DatabaseSQLVulnerabilityAssessmentRuleBaselineListResult, getNextPage func(context.Context, DatabaseSQLVulnerabilityAssessmentRuleBaselineListResult) (DatabaseSQLVulnerabilityAssessmentRuleBaselineListResult, error)) DatabaseSQLVulnerabilityAssessmentRuleBaselineListResultPage {
	return DatabaseSQLVulnerabilityAssessmentRuleBaselineListResultPage{
		fn:       getNextPage,
		dsvarblr: cur,
	}
}

// DatabaseSQLVulnerabilityAssessmentRuleBaselineProperties properties of a database Sql Vulnerability
// Assessment rule baseline.
type DatabaseSQLVulnerabilityAssessmentRuleBaselineProperties struct {
	// Results - The rule baseline result
	Results *[][]string `json:"results,omitempty"`
}

// DatabasesResumeFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesResumeFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (Database, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesResumeFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesResumeFuture.Result.
func (future *DatabasesResumeFuture) result(client DatabasesClient) (d Database, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesResumeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		d.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesResumeFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.ResumeResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesResumeFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabasesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (Database, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesUpdateFuture.Result.
func (future *DatabasesUpdateFuture) result(client DatabasesClient) (d Database, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		d.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.UpdateResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesUpdateFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabasesUpgradeDataWarehouseFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DatabasesUpgradeDataWarehouseFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesUpgradeDataWarehouseFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesUpgradeDataWarehouseFuture.Result.
func (future *DatabasesUpgradeDataWarehouseFuture) result(client DatabasesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesUpgradeDataWarehouseFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesUpgradeDataWarehouseFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseTable a database table resource.
type DatabaseTable struct {
	autorest.Response `json:"-"`
	// DatabaseTableProperties - Resource properties.
	*DatabaseTableProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseTable.
func (dt DatabaseTable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dt.DatabaseTableProperties != nil {
		objectMap["properties"] = dt.DatabaseTableProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseTable struct.
func (dt *DatabaseTable) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var databaseTableProperties DatabaseTableProperties
				err = json.Unmarshal(*v, &databaseTableProperties)
				if err != nil {
					return err
				}
				dt.DatabaseTableProperties = &databaseTableProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dt.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dt.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dt.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseTableListResult a list of database tables.
type DatabaseTableListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]DatabaseTable `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseTableListResult.
func (dtlr DatabaseTableListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DatabaseTableListResultIterator provides access to a complete listing of DatabaseTable values.
type DatabaseTableListResultIterator struct {
	i    int
	page DatabaseTableListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DatabaseTableListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseTableListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DatabaseTableListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DatabaseTableListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DatabaseTableListResultIterator) Response() DatabaseTableListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DatabaseTableListResultIterator) Value() DatabaseTable {
	if !iter.page.NotDone() {
		return DatabaseTable{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DatabaseTableListResultIterator type.
func NewDatabaseTableListResultIterator(page DatabaseTableListResultPage) DatabaseTableListResultIterator {
	return DatabaseTableListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dtlr DatabaseTableListResult) IsEmpty() bool {
	return dtlr.Value == nil || len(*dtlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dtlr DatabaseTableListResult) hasNextLink() bool {
	return dtlr.NextLink != nil && len(*dtlr.NextLink) != 0
}

// databaseTableListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dtlr DatabaseTableListResult) databaseTableListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dtlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dtlr.NextLink)))
}

// DatabaseTableListResultPage contains a page of DatabaseTable values.
type DatabaseTableListResultPage struct {
	fn   func(context.Context, DatabaseTableListResult) (DatabaseTableListResult, error)
	dtlr DatabaseTableListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DatabaseTableListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseTableListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dtlr)
		if err != nil {
			return err
		}
		page.dtlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DatabaseTableListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DatabaseTableListResultPage) NotDone() bool {
	return !page.dtlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DatabaseTableListResultPage) Response() DatabaseTableListResult {
	return page.dtlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DatabaseTableListResultPage) Values() []DatabaseTable {
	if page.dtlr.IsEmpty() {
		return nil
	}
	return *page.dtlr.Value
}

// Creates a new instance of the DatabaseTableListResultPage type.
func NewDatabaseTableListResultPage(cur DatabaseTableListResult, getNextPage func(context.Context, DatabaseTableListResult) (DatabaseTableListResult, error)) DatabaseTableListResultPage {
	return DatabaseTableListResultPage{
		fn:   getNextPage,
		dtlr: cur,
	}
}

// DatabaseTableProperties database table properties.
type DatabaseTableProperties struct {
	// TemporalType - The table temporal type. Possible values include: 'TableTemporalTypeNonTemporalTable', 'TableTemporalTypeHistoryTable', 'TableTemporalTypeSystemVersionedTemporalTable'
	TemporalType TableTemporalType `json:"temporalType,omitempty"`
	// MemoryOptimized - Whether or not the table is memory optimized.
	MemoryOptimized *bool `json:"memoryOptimized,omitempty"`
}

// DatabaseUpdate a database update resource.
type DatabaseUpdate struct {
	// Sku - The name and tier of the SKU.
	Sku *Sku `json:"sku,omitempty"`
	// Identity - Database identity
	Identity *DatabaseIdentity `json:"identity,omitempty"`
	// DatabaseUpdateProperties - Resource properties.
	*DatabaseUpdateProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DatabaseUpdate.
func (du DatabaseUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if du.Sku != nil {
		objectMap["sku"] = du.Sku
	}
	if du.Identity != nil {
		objectMap["identity"] = du.Identity
	}
	if du.DatabaseUpdateProperties != nil {
		objectMap["properties"] = du.DatabaseUpdateProperties
	}
	if du.Tags != nil {
		objectMap["tags"] = du.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseUpdate struct.
func (du *DatabaseUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				du.Sku = &sku
			}
		case "identity":
			if v != nil {
				var identity DatabaseIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				du.Identity = &identity
			}
		case "properties":
			if v != nil {
				var databaseUpdateProperties DatabaseUpdateProperties
				err = json.Unmarshal(*v, &databaseUpdateProperties)
				if err != nil {
					return err
				}
				du.DatabaseUpdateProperties = &databaseUpdateProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				du.Tags = tags
			}
		}
	}

	return nil
}

// DatabaseUpdateProperties a database update properties.
type DatabaseUpdateProperties struct {
	// CreateMode - Specifies the mode of database creation.
	//
	// Default: regular database creation.
	//
	// Copy: creates a database as a copy of an existing database. sourceDatabaseId must be specified as the resource ID of the source database.
	//
	// Secondary: creates a database as a secondary replica of an existing database. sourceDatabaseId must be specified as the resource ID of the existing primary database.
	//
	// PointInTimeRestore: Creates a database by restoring a point in time backup of an existing database. sourceDatabaseId must be specified as the resource ID of the existing database, and restorePointInTime must be specified.
	//
	// Recovery: Creates a database by restoring a geo-replicated backup. sourceDatabaseId must be specified as the recoverable database resource ID to restore.
	//
	// Restore: Creates a database by restoring a backup of a deleted database. sourceDatabaseId must be specified. If sourceDatabaseId is the database's original resource ID, then sourceDatabaseDeletionDate must be specified. Otherwise sourceDatabaseId must be the restorable dropped database resource ID and sourceDatabaseDeletionDate is ignored. restorePointInTime may also be specified to restore from an earlier point in time.
	//
	// RestoreLongTermRetentionBackup: Creates a database by restoring from a long term retention vault. recoveryServicesRecoveryPointResourceId must be specified as the recovery point resource ID.
	//
	// Copy, Secondary, and RestoreLongTermRetentionBackup are not supported for DataWarehouse edition. Possible values include: 'CreateModeDefault', 'CreateModeCopy', 'CreateModeSecondary', 'CreateModePointInTimeRestore', 'CreateModeRestore', 'CreateModeRecovery', 'CreateModeRestoreExternalBackup', 'CreateModeRestoreExternalBackupSecondary', 'CreateModeRestoreLongTermRetentionBackup', 'CreateModeOnlineSecondary'
	CreateMode CreateMode `json:"createMode,omitempty"`
	// Collation - The collation of the database.
	Collation *string `json:"collation,omitempty"`
	// MaxSizeBytes - The max size of the database expressed in bytes.
	MaxSizeBytes *int64 `json:"maxSizeBytes,omitempty"`
	// SampleName - The name of the sample schema to apply when creating this database. Possible values include: 'SampleNameAdventureWorksLT', 'SampleNameWideWorldImportersStd', 'SampleNameWideWorldImportersFull'
	SampleName SampleName `json:"sampleName,omitempty"`
	// ElasticPoolID - The resource identifier of the elastic pool containing this database.
	ElasticPoolID *string `json:"elasticPoolId,omitempty"`
	// SourceDatabaseID - The resource identifier of the source database associated with create operation of this database.
	SourceDatabaseID *string `json:"sourceDatabaseId,omitempty"`
	// Status - READ-ONLY; The status of the database. Possible values include: 'DatabaseStatusOnline', 'DatabaseStatusRestoring', 'DatabaseStatusRecoveryPending', 'DatabaseStatusRecovering', 'DatabaseStatusSuspect', 'DatabaseStatusOffline', 'DatabaseStatusStandby', 'DatabaseStatusShutdown', 'DatabaseStatusEmergencyMode', 'DatabaseStatusAutoClosed', 'DatabaseStatusCopying', 'DatabaseStatusCreating', 'DatabaseStatusInaccessible', 'DatabaseStatusOfflineSecondary', 'DatabaseStatusPausing', 'DatabaseStatusPaused', 'DatabaseStatusResuming', 'DatabaseStatusScaling', 'DatabaseStatusOfflineChangingDwPerformanceTiers', 'DatabaseStatusOnlineChangingDwPerformanceTiers', 'DatabaseStatusDisabled', 'DatabaseStatusStopping', 'DatabaseStatusStopped', 'DatabaseStatusStarting'
	Status DatabaseStatus `json:"status,omitempty"`
	// DatabaseID - READ-ONLY; The ID of the database.
	DatabaseID *uuid.UUID `json:"databaseId,omitempty"`
	// CreationDate - READ-ONLY; The creation date of the database (ISO8601 format).
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// CurrentServiceObjectiveName - READ-ONLY; The current service level objective name of the database.
	CurrentServiceObjectiveName *string `json:"currentServiceObjectiveName,omitempty"`
	// RequestedServiceObjectiveName - READ-ONLY; The requested service level objective name of the database.
	RequestedServiceObjectiveName *string `json:"requestedServiceObjectiveName,omitempty"`
	// DefaultSecondaryLocation - READ-ONLY; The default secondary region for this database.
	DefaultSecondaryLocation *string `json:"defaultSecondaryLocation,omitempty"`
	// FailoverGroupID - READ-ONLY; Failover Group resource identifier that this database belongs to.
	FailoverGroupID *string `json:"failoverGroupId,omitempty"`
	// RestorePointInTime - Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new database.
	RestorePointInTime *date.Time `json:"restorePointInTime,omitempty"`
	// SourceDatabaseDeletionDate - Specifies the time that the database was deleted.
	SourceDatabaseDeletionDate *date.Time `json:"sourceDatabaseDeletionDate,omitempty"`
	// RecoveryServicesRecoveryPointID - The resource identifier of the recovery point associated with create operation of this database.
	RecoveryServicesRecoveryPointID *string `json:"recoveryServicesRecoveryPointId,omitempty"`
	// LongTermRetentionBackupResourceID - The resource identifier of the long term retention backup associated with create operation of this database.
	LongTermRetentionBackupResourceID *string `json:"longTermRetentionBackupResourceId,omitempty"`
	// RecoverableDatabaseID - The resource identifier of the recoverable database associated with create operation of this database.
	RecoverableDatabaseID *string `json:"recoverableDatabaseId,omitempty"`
	// RestorableDroppedDatabaseID - The resource identifier of the restorable dropped database associated with create operation of this database.
	RestorableDroppedDatabaseID *string `json:"restorableDroppedDatabaseId,omitempty"`
	// CatalogCollation - Collation of the metadata catalog. Possible values include: 'CatalogCollationTypeDATABASEDEFAULT', 'CatalogCollationTypeSQLLatin1GeneralCP1CIAS'
	CatalogCollation CatalogCollationType `json:"catalogCollation,omitempty"`
	// ZoneRedundant - Whether or not this database is zone redundant, which means the replicas of this database will be spread across multiple availability zones.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
	// LicenseType - The license type to apply for this database. `LicenseIncluded` if you need a license, or `BasePrice` if you have a license and are eligible for the Azure Hybrid Benefit. Possible values include: 'DatabaseLicenseTypeLicenseIncluded', 'DatabaseLicenseTypeBasePrice'
	LicenseType DatabaseLicenseType `json:"licenseType,omitempty"`
	// MaxLogSizeBytes - READ-ONLY; The max log size for this database.
	MaxLogSizeBytes *int64 `json:"maxLogSizeBytes,omitempty"`
	// EarliestRestoreDate - READ-ONLY; This records the earliest start date and time that restore is available for this database (ISO8601 format).
	EarliestRestoreDate *date.Time `json:"earliestRestoreDate,omitempty"`
	// ReadScale - The state of read-only routing. If enabled, connections that have application intent set to readonly in their connection string may be routed to a readonly secondary replica in the same region. Not applicable to a Hyperscale database within an elastic pool. Possible values include: 'DatabaseReadScaleEnabled', 'DatabaseReadScaleDisabled'
	ReadScale DatabaseReadScale `json:"readScale,omitempty"`
	// HighAvailabilityReplicaCount - The number of secondary replicas associated with the database that are used to provide high availability. Not applicable to a Hyperscale database within an elastic pool.
	HighAvailabilityReplicaCount *int32 `json:"highAvailabilityReplicaCount,omitempty"`
	// SecondaryType - The secondary type of the database if it is a secondary.  Valid values are Geo, Named and Standby. Possible values include: 'SecondaryTypeGeo', 'SecondaryTypeNamed', 'SecondaryTypeStandby'
	SecondaryType SecondaryType `json:"secondaryType,omitempty"`
	// CurrentSku - READ-ONLY; The name and tier of the SKU.
	CurrentSku *Sku `json:"currentSku,omitempty"`
	// AutoPauseDelay - Time in minutes after which database is automatically paused. A value of -1 means that automatic pause is disabled
	AutoPauseDelay *int32 `json:"autoPauseDelay,omitempty"`
	// CurrentBackupStorageRedundancy - READ-ONLY; The storage account type used to store backups for this database. Possible values include: 'BackupStorageRedundancyGeo', 'BackupStorageRedundancyLocal', 'BackupStorageRedundancyZone', 'BackupStorageRedundancyGeoZone'
	CurrentBackupStorageRedundancy BackupStorageRedundancy `json:"currentBackupStorageRedundancy,omitempty"`
	// RequestedBackupStorageRedundancy - The storage account type to be used to store backups for this database. Possible values include: 'BackupStorageRedundancyGeo', 'BackupStorageRedundancyLocal', 'BackupStorageRedundancyZone', 'BackupStorageRedundancyGeoZone'
	RequestedBackupStorageRedundancy BackupStorageRedundancy `json:"requestedBackupStorageRedundancy,omitempty"`
	// MinCapacity - Minimal capacity that database will always have allocated, if not paused
	MinCapacity *float64 `json:"minCapacity,omitempty"`
	// PausedDate - READ-ONLY; The date when database was paused by user configuration or action(ISO8601 format). Null if the database is ready.
	PausedDate *date.Time `json:"pausedDate,omitempty"`
	// ResumedDate - READ-ONLY; The date when database was resumed by user action or database login (ISO8601 format). Null if the database is paused.
	ResumedDate *date.Time `json:"resumedDate,omitempty"`
	// MaintenanceConfigurationID - Maintenance configuration id assigned to the database. This configuration defines the period when the maintenance updates will occur.
	MaintenanceConfigurationID *string `json:"maintenanceConfigurationId,omitempty"`
	// IsLedgerOn - Whether or not this database is a ledger database, which means all tables in the database are ledger tables. Note: the value of this property cannot be changed after the database has been created.
	IsLedgerOn *bool `json:"isLedgerOn,omitempty"`
	// IsInfraEncryptionEnabled - READ-ONLY; Infra encryption is enabled for this database.
	IsInfraEncryptionEnabled *bool `json:"isInfraEncryptionEnabled,omitempty"`
	// FederatedClientID - The Client id used for cross tenant per database CMK scenario
	FederatedClientID *uuid.UUID `json:"federatedClientId,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseUpdateProperties.
func (dup DatabaseUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dup.CreateMode != "" {
		objectMap["createMode"] = dup.CreateMode
	}
	if dup.Collation != nil {
		objectMap["collation"] = dup.Collation
	}
	if dup.MaxSizeBytes != nil {
		objectMap["maxSizeBytes"] = dup.MaxSizeBytes
	}
	if dup.SampleName != "" {
		objectMap["sampleName"] = dup.SampleName
	}
	if dup.ElasticPoolID != nil {
		objectMap["elasticPoolId"] = dup.ElasticPoolID
	}
	if dup.SourceDatabaseID != nil {
		objectMap["sourceDatabaseId"] = dup.SourceDatabaseID
	}
	if dup.RestorePointInTime != nil {
		objectMap["restorePointInTime"] = dup.RestorePointInTime
	}
	if dup.SourceDatabaseDeletionDate != nil {
		objectMap["sourceDatabaseDeletionDate"] = dup.SourceDatabaseDeletionDate
	}
	if dup.RecoveryServicesRecoveryPointID != nil {
		objectMap["recoveryServicesRecoveryPointId"] = dup.RecoveryServicesRecoveryPointID
	}
	if dup.LongTermRetentionBackupResourceID != nil {
		objectMap["longTermRetentionBackupResourceId"] = dup.LongTermRetentionBackupResourceID
	}
	if dup.RecoverableDatabaseID != nil {
		objectMap["recoverableDatabaseId"] = dup.RecoverableDatabaseID
	}
	if dup.RestorableDroppedDatabaseID != nil {
		objectMap["restorableDroppedDatabaseId"] = dup.RestorableDroppedDatabaseID
	}
	if dup.CatalogCollation != "" {
		objectMap["catalogCollation"] = dup.CatalogCollation
	}
	if dup.ZoneRedundant != nil {
		objectMap["zoneRedundant"] = dup.ZoneRedundant
	}
	if dup.LicenseType != "" {
		objectMap["licenseType"] = dup.LicenseType
	}
	if dup.ReadScale != "" {
		objectMap["readScale"] = dup.ReadScale
	}
	if dup.HighAvailabilityReplicaCount != nil {
		objectMap["highAvailabilityReplicaCount"] = dup.HighAvailabilityReplicaCount
	}
	if dup.SecondaryType != "" {
		objectMap["secondaryType"] = dup.SecondaryType
	}
	if dup.AutoPauseDelay != nil {
		objectMap["autoPauseDelay"] = dup.AutoPauseDelay
	}
	if dup.RequestedBackupStorageRedundancy != "" {
		objectMap["requestedBackupStorageRedundancy"] = dup.RequestedBackupStorageRedundancy
	}
	if dup.MinCapacity != nil {
		objectMap["minCapacity"] = dup.MinCapacity
	}
	if dup.MaintenanceConfigurationID != nil {
		objectMap["maintenanceConfigurationId"] = dup.MaintenanceConfigurationID
	}
	if dup.IsLedgerOn != nil {
		objectMap["isLedgerOn"] = dup.IsLedgerOn
	}
	if dup.FederatedClientID != nil {
		objectMap["federatedClientId"] = dup.FederatedClientID
	}
	return json.Marshal(objectMap)
}

// DatabaseUsage usage metric of a database.
type DatabaseUsage struct {
	// DatabaseUsageProperties - Resource properties.
	*DatabaseUsageProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseUsage.
func (du DatabaseUsage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if du.DatabaseUsageProperties != nil {
		objectMap["properties"] = du.DatabaseUsageProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseUsage struct.
func (du *DatabaseUsage) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var databaseUsageProperties DatabaseUsageProperties
				err = json.Unmarshal(*v, &databaseUsageProperties)
				if err != nil {
					return err
				}
				du.DatabaseUsageProperties = &databaseUsageProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				du.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				du.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				du.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseUsageListResult a list of database usage metrics.
type DatabaseUsageListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]DatabaseUsage `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseUsageListResult.
func (dulr DatabaseUsageListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DatabaseUsageListResultIterator provides access to a complete listing of DatabaseUsage values.
type DatabaseUsageListResultIterator struct {
	i    int
	page DatabaseUsageListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DatabaseUsageListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseUsageListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DatabaseUsageListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DatabaseUsageListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DatabaseUsageListResultIterator) Response() DatabaseUsageListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DatabaseUsageListResultIterator) Value() DatabaseUsage {
	if !iter.page.NotDone() {
		return DatabaseUsage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DatabaseUsageListResultIterator type.
func NewDatabaseUsageListResultIterator(page DatabaseUsageListResultPage) DatabaseUsageListResultIterator {
	return DatabaseUsageListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dulr DatabaseUsageListResult) IsEmpty() bool {
	return dulr.Value == nil || len(*dulr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dulr DatabaseUsageListResult) hasNextLink() bool {
	return dulr.NextLink != nil && len(*dulr.NextLink) != 0
}

// databaseUsageListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dulr DatabaseUsageListResult) databaseUsageListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dulr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dulr.NextLink)))
}

// DatabaseUsageListResultPage contains a page of DatabaseUsage values.
type DatabaseUsageListResultPage struct {
	fn   func(context.Context, DatabaseUsageListResult) (DatabaseUsageListResult, error)
	dulr DatabaseUsageListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DatabaseUsageListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseUsageListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dulr)
		if err != nil {
			return err
		}
		page.dulr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DatabaseUsageListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DatabaseUsageListResultPage) NotDone() bool {
	return !page.dulr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DatabaseUsageListResultPage) Response() DatabaseUsageListResult {
	return page.dulr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DatabaseUsageListResultPage) Values() []DatabaseUsage {
	if page.dulr.IsEmpty() {
		return nil
	}
	return *page.dulr.Value
}

// Creates a new instance of the DatabaseUsageListResultPage type.
func NewDatabaseUsageListResultPage(cur DatabaseUsageListResult, getNextPage func(context.Context, DatabaseUsageListResult) (DatabaseUsageListResult, error)) DatabaseUsageListResultPage {
	return DatabaseUsageListResultPage{
		fn:   getNextPage,
		dulr: cur,
	}
}

// DatabaseUsageProperties properties of a database usage.
type DatabaseUsageProperties struct {
	// DisplayName - READ-ONLY; User-readable name of the metric.
	DisplayName *string `json:"displayName,omitempty"`
	// CurrentValue - READ-ONLY; Current value of the metric.
	CurrentValue *float64 `json:"currentValue,omitempty"`
	// Limit - READ-ONLY; Boundary value of the metric.
	Limit *float64 `json:"limit,omitempty"`
	// Unit - READ-ONLY; Unit of the metric.
	Unit *string `json:"unit,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseUsageProperties.
func (dup DatabaseUsageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DatabaseUserIdentity azure Active Directory identity configuration for a resource.
type DatabaseUserIdentity struct {
	// PrincipalID - READ-ONLY; The Azure Active Directory principal id.
	PrincipalID *uuid.UUID `json:"principalId,omitempty"`
	// ClientID - READ-ONLY; The Azure Active Directory client id.
	ClientID *uuid.UUID `json:"clientId,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseUserIdentity.
func (dui DatabaseUserIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DatabaseVulnerabilityAssessment a database vulnerability assessment.
type DatabaseVulnerabilityAssessment struct {
	autorest.Response `json:"-"`
	// DatabaseVulnerabilityAssessmentProperties - Resource properties.
	*DatabaseVulnerabilityAssessmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseVulnerabilityAssessment.
func (dva DatabaseVulnerabilityAssessment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dva.DatabaseVulnerabilityAssessmentProperties != nil {
		objectMap["properties"] = dva.DatabaseVulnerabilityAssessmentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseVulnerabilityAssessment struct.
func (dva *DatabaseVulnerabilityAssessment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var databaseVulnerabilityAssessmentProperties DatabaseVulnerabilityAssessmentProperties
				err = json.Unmarshal(*v, &databaseVulnerabilityAssessmentProperties)
				if err != nil {
					return err
				}
				dva.DatabaseVulnerabilityAssessmentProperties = &databaseVulnerabilityAssessmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dva.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dva.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dva.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseVulnerabilityAssessmentListResult a list of the database's vulnerability assessments.
type DatabaseVulnerabilityAssessmentListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]DatabaseVulnerabilityAssessment `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseVulnerabilityAssessmentListResult.
func (dvalr DatabaseVulnerabilityAssessmentListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DatabaseVulnerabilityAssessmentListResultIterator provides access to a complete listing of
// DatabaseVulnerabilityAssessment values.
type DatabaseVulnerabilityAssessmentListResultIterator struct {
	i    int
	page DatabaseVulnerabilityAssessmentListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DatabaseVulnerabilityAssessmentListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseVulnerabilityAssessmentListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DatabaseVulnerabilityAssessmentListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DatabaseVulnerabilityAssessmentListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DatabaseVulnerabilityAssessmentListResultIterator) Response() DatabaseVulnerabilityAssessmentListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DatabaseVulnerabilityAssessmentListResultIterator) Value() DatabaseVulnerabilityAssessment {
	if !iter.page.NotDone() {
		return DatabaseVulnerabilityAssessment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DatabaseVulnerabilityAssessmentListResultIterator type.
func NewDatabaseVulnerabilityAssessmentListResultIterator(page DatabaseVulnerabilityAssessmentListResultPage) DatabaseVulnerabilityAssessmentListResultIterator {
	return DatabaseVulnerabilityAssessmentListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dvalr DatabaseVulnerabilityAssessmentListResult) IsEmpty() bool {
	return dvalr.Value == nil || len(*dvalr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dvalr DatabaseVulnerabilityAssessmentListResult) hasNextLink() bool {
	return dvalr.NextLink != nil && len(*dvalr.NextLink) != 0
}

// databaseVulnerabilityAssessmentListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dvalr DatabaseVulnerabilityAssessmentListResult) databaseVulnerabilityAssessmentListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dvalr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dvalr.NextLink)))
}

// DatabaseVulnerabilityAssessmentListResultPage contains a page of DatabaseVulnerabilityAssessment values.
type DatabaseVulnerabilityAssessmentListResultPage struct {
	fn    func(context.Context, DatabaseVulnerabilityAssessmentListResult) (DatabaseVulnerabilityAssessmentListResult, error)
	dvalr DatabaseVulnerabilityAssessmentListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DatabaseVulnerabilityAssessmentListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseVulnerabilityAssessmentListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dvalr)
		if err != nil {
			return err
		}
		page.dvalr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DatabaseVulnerabilityAssessmentListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DatabaseVulnerabilityAssessmentListResultPage) NotDone() bool {
	return !page.dvalr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DatabaseVulnerabilityAssessmentListResultPage) Response() DatabaseVulnerabilityAssessmentListResult {
	return page.dvalr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DatabaseVulnerabilityAssessmentListResultPage) Values() []DatabaseVulnerabilityAssessment {
	if page.dvalr.IsEmpty() {
		return nil
	}
	return *page.dvalr.Value
}

// Creates a new instance of the DatabaseVulnerabilityAssessmentListResultPage type.
func NewDatabaseVulnerabilityAssessmentListResultPage(cur DatabaseVulnerabilityAssessmentListResult, getNextPage func(context.Context, DatabaseVulnerabilityAssessmentListResult) (DatabaseVulnerabilityAssessmentListResult, error)) DatabaseVulnerabilityAssessmentListResultPage {
	return DatabaseVulnerabilityAssessmentListResultPage{
		fn:    getNextPage,
		dvalr: cur,
	}
}

// DatabaseVulnerabilityAssessmentProperties properties of a database Vulnerability Assessment.
type DatabaseVulnerabilityAssessmentProperties struct {
	// StorageContainerPath - A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).  It is required if server level vulnerability assessment policy doesn't set
	StorageContainerPath *string `json:"storageContainerPath,omitempty"`
	// StorageContainerSasKey - A shared access signature (SAS Key) that has write access to the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is required.
	StorageContainerSasKey *string `json:"storageContainerSasKey,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RecurringScans - The recurring scans settings
	RecurringScans *VulnerabilityAssessmentRecurringScansProperties `json:"recurringScans,omitempty"`
}

// DatabaseVulnerabilityAssessmentRuleBaseline a database vulnerability assessment rule baseline.
type DatabaseVulnerabilityAssessmentRuleBaseline struct {
	autorest.Response `json:"-"`
	// DatabaseVulnerabilityAssessmentRuleBaselineProperties - Resource properties.
	*DatabaseVulnerabilityAssessmentRuleBaselineProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseVulnerabilityAssessmentRuleBaseline.
func (dvarb DatabaseVulnerabilityAssessmentRuleBaseline) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dvarb.DatabaseVulnerabilityAssessmentRuleBaselineProperties != nil {
		objectMap["properties"] = dvarb.DatabaseVulnerabilityAssessmentRuleBaselineProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseVulnerabilityAssessmentRuleBaseline struct.
func (dvarb *DatabaseVulnerabilityAssessmentRuleBaseline) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var databaseVulnerabilityAssessmentRuleBaselineProperties DatabaseVulnerabilityAssessmentRuleBaselineProperties
				err = json.Unmarshal(*v, &databaseVulnerabilityAssessmentRuleBaselineProperties)
				if err != nil {
					return err
				}
				dvarb.DatabaseVulnerabilityAssessmentRuleBaselineProperties = &databaseVulnerabilityAssessmentRuleBaselineProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dvarb.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dvarb.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dvarb.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseVulnerabilityAssessmentRuleBaselineItem properties for an Azure SQL Database Vulnerability
// Assessment rule baseline's result.
type DatabaseVulnerabilityAssessmentRuleBaselineItem struct {
	// Result - The rule baseline result
	Result *[]string `json:"result,omitempty"`
}

// DatabaseVulnerabilityAssessmentRuleBaselineProperties properties of a database Vulnerability Assessment
// rule baseline.
type DatabaseVulnerabilityAssessmentRuleBaselineProperties struct {
	// BaselineResults - The rule baseline result
	BaselineResults *[]DatabaseVulnerabilityAssessmentRuleBaselineItem `json:"baselineResults,omitempty"`
}

// DatabaseVulnerabilityAssessmentScanExportProperties properties of the export operation's result.
type DatabaseVulnerabilityAssessmentScanExportProperties struct {
	// ExportedReportLocation - READ-ONLY; Location of the exported report (e.g. https://myStorage.blob.core.windows.net/VaScans/scans/serverName/databaseName/scan_scanId.xlsx).
	ExportedReportLocation *string `json:"exportedReportLocation,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseVulnerabilityAssessmentScanExportProperties.
func (dvasep DatabaseVulnerabilityAssessmentScanExportProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DatabaseVulnerabilityAssessmentScansExport a database Vulnerability Assessment scan export resource.
type DatabaseVulnerabilityAssessmentScansExport struct {
	autorest.Response `json:"-"`
	// DatabaseVulnerabilityAssessmentScanExportProperties - Resource properties.
	*DatabaseVulnerabilityAssessmentScanExportProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseVulnerabilityAssessmentScansExport.
func (dvase DatabaseVulnerabilityAssessmentScansExport) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dvase.DatabaseVulnerabilityAssessmentScanExportProperties != nil {
		objectMap["properties"] = dvase.DatabaseVulnerabilityAssessmentScanExportProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseVulnerabilityAssessmentScansExport struct.
func (dvase *DatabaseVulnerabilityAssessmentScansExport) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var databaseVulnerabilityAssessmentScanExportProperties DatabaseVulnerabilityAssessmentScanExportProperties
				err = json.Unmarshal(*v, &databaseVulnerabilityAssessmentScanExportProperties)
				if err != nil {
					return err
				}
				dvase.DatabaseVulnerabilityAssessmentScanExportProperties = &databaseVulnerabilityAssessmentScanExportProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dvase.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dvase.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dvase.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseVulnerabilityAssessmentScansInitiateScanFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type DatabaseVulnerabilityAssessmentScansInitiateScanFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabaseVulnerabilityAssessmentScansClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabaseVulnerabilityAssessmentScansInitiateScanFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabaseVulnerabilityAssessmentScansInitiateScanFuture.Result.
func (future *DatabaseVulnerabilityAssessmentScansInitiateScanFuture) result(client DatabaseVulnerabilityAssessmentScansClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseVulnerabilityAssessmentScansInitiateScanFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.DatabaseVulnerabilityAssessmentScansInitiateScanFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DataMaskingPolicy represents a database data masking policy.
type DataMaskingPolicy struct {
	autorest.Response `json:"-"`
	// DataMaskingPolicyProperties - The properties of the data masking policy.
	*DataMaskingPolicyProperties `json:"properties,omitempty"`
	// Location - READ-ONLY; The location of the data masking policy.
	Location *string `json:"location,omitempty"`
	// Kind - READ-ONLY; The kind of data masking policy. Metadata, used for Azure portal.
	Kind *string `json:"kind,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DataMaskingPolicy.
func (dmp DataMaskingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dmp.DataMaskingPolicyProperties != nil {
		objectMap["properties"] = dmp.DataMaskingPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataMaskingPolicy struct.
func (dmp *DataMaskingPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dataMaskingPolicyProperties DataMaskingPolicyProperties
				err = json.Unmarshal(*v, &dataMaskingPolicyProperties)
				if err != nil {
					return err
				}
				dmp.DataMaskingPolicyProperties = &dataMaskingPolicyProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dmp.Location = &location
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dmp.Kind = &kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dmp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dmp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dmp.Type = &typeVar
			}
		}
	}

	return nil
}

// DataMaskingPolicyProperties the properties of a database data masking policy.
type DataMaskingPolicyProperties struct {
	// DataMaskingState - The state of the data masking policy. Possible values include: 'DataMaskingStateDisabled', 'DataMaskingStateEnabled'
	DataMaskingState DataMaskingState `json:"dataMaskingState,omitempty"`
	// ExemptPrincipals - The list of the exempt principals. Specifies the semicolon-separated list of database users for which the data masking policy does not apply. The specified users receive data results without masking for all of the database queries.
	ExemptPrincipals *string `json:"exemptPrincipals,omitempty"`
	// ApplicationPrincipals - READ-ONLY; The list of the application principals. This is a legacy parameter and is no longer used.
	ApplicationPrincipals *string `json:"applicationPrincipals,omitempty"`
	// MaskingLevel - READ-ONLY; The masking level. This is a legacy parameter and is no longer used.
	MaskingLevel *string `json:"maskingLevel,omitempty"`
}

// MarshalJSON is the custom marshaler for DataMaskingPolicyProperties.
func (dmpp DataMaskingPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dmpp.DataMaskingState != "" {
		objectMap["dataMaskingState"] = dmpp.DataMaskingState
	}
	if dmpp.ExemptPrincipals != nil {
		objectMap["exemptPrincipals"] = dmpp.ExemptPrincipals
	}
	return json.Marshal(objectMap)
}

// DataMaskingRule represents a database data masking rule.
type DataMaskingRule struct {
	autorest.Response `json:"-"`
	// DataMaskingRuleProperties - The properties of the resource.
	*DataMaskingRuleProperties `json:"properties,omitempty"`
	// Location - READ-ONLY; The location of the data masking rule.
	Location *string `json:"location,omitempty"`
	// Kind - READ-ONLY; The kind of Data Masking Rule. Metadata, used for Azure portal.
	Kind *string `json:"kind,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DataMaskingRule.
func (dmr DataMaskingRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dmr.DataMaskingRuleProperties != nil {
		objectMap["properties"] = dmr.DataMaskingRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataMaskingRule struct.
func (dmr *DataMaskingRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dataMaskingRuleProperties DataMaskingRuleProperties
				err = json.Unmarshal(*v, &dataMaskingRuleProperties)
				if err != nil {
					return err
				}
				dmr.DataMaskingRuleProperties = &dataMaskingRuleProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dmr.Location = &location
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dmr.Kind = &kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dmr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dmr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dmr.Type = &typeVar
			}
		}
	}

	return nil
}

// DataMaskingRuleListResult the response to a list data masking rules request.
type DataMaskingRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of database data masking rules.
	Value *[]DataMaskingRule `json:"value,omitempty"`
}

// DataMaskingRuleProperties the properties of a database data masking rule.
type DataMaskingRuleProperties struct {
	// ID - READ-ONLY; The rule Id.
	ID *string `json:"id,omitempty"`
	// AliasName - The alias name. This is a legacy parameter and is no longer used.
	AliasName *string `json:"aliasName,omitempty"`
	// RuleState - The rule state. Used to delete a rule. To delete an existing rule, specify the schemaName, tableName, columnName, maskingFunction, and specify ruleState as disabled. However, if the rule doesn't already exist, the rule will be created with ruleState set to enabled, regardless of the provided value of ruleState. Possible values include: 'DataMaskingRuleStateDisabled', 'DataMaskingRuleStateEnabled'
	RuleState DataMaskingRuleState `json:"ruleState,omitempty"`
	// SchemaName - The schema name on which the data masking rule is applied.
	SchemaName *string `json:"schemaName,omitempty"`
	// TableName - The table name on which the data masking rule is applied.
	TableName *string `json:"tableName,omitempty"`
	// ColumnName - The column name on which the data masking rule is applied.
	ColumnName *string `json:"columnName,omitempty"`
	// MaskingFunction - The masking function that is used for the data masking rule. Possible values include: 'DataMaskingFunctionDefault', 'DataMaskingFunctionCCN', 'DataMaskingFunctionEmail', 'DataMaskingFunctionNumber', 'DataMaskingFunctionSSN', 'DataMaskingFunctionText'
	MaskingFunction DataMaskingFunction `json:"maskingFunction,omitempty"`
	// NumberFrom - The numberFrom property of the masking rule. Required if maskingFunction is set to Number, otherwise this parameter will be ignored.
	NumberFrom *string `json:"numberFrom,omitempty"`
	// NumberTo - The numberTo property of the data masking rule. Required if maskingFunction is set to Number, otherwise this parameter will be ignored.
	NumberTo *string `json:"numberTo,omitempty"`
	// PrefixSize - If maskingFunction is set to Text, the number of characters to show unmasked in the beginning of the string. Otherwise, this parameter will be ignored.
	PrefixSize *string `json:"prefixSize,omitempty"`
	// SuffixSize - If maskingFunction is set to Text, the number of characters to show unmasked at the end of the string. Otherwise, this parameter will be ignored.
	SuffixSize *string `json:"suffixSize,omitempty"`
	// ReplacementString - If maskingFunction is set to Text, the character to use for masking the unexposed part of the string. Otherwise, this parameter will be ignored.
	ReplacementString *string `json:"replacementString,omitempty"`
}

// MarshalJSON is the custom marshaler for DataMaskingRuleProperties.
func (dmrp DataMaskingRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dmrp.AliasName != nil {
		objectMap["aliasName"] = dmrp.AliasName
	}
	if dmrp.RuleState != "" {
		objectMap["ruleState"] = dmrp.RuleState
	}
	if dmrp.SchemaName != nil {
		objectMap["schemaName"] = dmrp.SchemaName
	}
	if dmrp.TableName != nil {
		objectMap["tableName"] = dmrp.TableName
	}
	if dmrp.ColumnName != nil {
		objectMap["columnName"] = dmrp.ColumnName
	}
	if dmrp.MaskingFunction != "" {
		objectMap["maskingFunction"] = dmrp.MaskingFunction
	}
	if dmrp.NumberFrom != nil {
		objectMap["numberFrom"] = dmrp.NumberFrom
	}
	if dmrp.NumberTo != nil {
		objectMap["numberTo"] = dmrp.NumberTo
	}
	if dmrp.PrefixSize != nil {
		objectMap["prefixSize"] = dmrp.PrefixSize
	}
	if dmrp.SuffixSize != nil {
		objectMap["suffixSize"] = dmrp.SuffixSize
	}
	if dmrp.ReplacementString != nil {
		objectMap["replacementString"] = dmrp.ReplacementString
	}
	return json.Marshal(objectMap)
}

// DataWarehouseUserActivities user activities of a data warehouse
type DataWarehouseUserActivities struct {
	autorest.Response `json:"-"`
	// DataWarehouseUserActivitiesProperties - Resource properties.
	*DataWarehouseUserActivitiesProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DataWarehouseUserActivities.
func (dwua DataWarehouseUserActivities) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dwua.DataWarehouseUserActivitiesProperties != nil {
		objectMap["properties"] = dwua.DataWarehouseUserActivitiesProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataWarehouseUserActivities struct.
func (dwua *DataWarehouseUserActivities) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dataWarehouseUserActivitiesProperties DataWarehouseUserActivitiesProperties
				err = json.Unmarshal(*v, &dataWarehouseUserActivitiesProperties)
				if err != nil {
					return err
				}
				dwua.DataWarehouseUserActivitiesProperties = &dataWarehouseUserActivitiesProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dwua.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dwua.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dwua.Type = &typeVar
			}
		}
	}

	return nil
}

// DataWarehouseUserActivitiesListResult user activities of a data warehouse
type DataWarehouseUserActivitiesListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]DataWarehouseUserActivities `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DataWarehouseUserActivitiesListResult.
func (dwualr DataWarehouseUserActivitiesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DataWarehouseUserActivitiesListResultIterator provides access to a complete listing of
// DataWarehouseUserActivities values.
type DataWarehouseUserActivitiesListResultIterator struct {
	i    int
	page DataWarehouseUserActivitiesListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DataWarehouseUserActivitiesListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataWarehouseUserActivitiesListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DataWarehouseUserActivitiesListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DataWarehouseUserActivitiesListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DataWarehouseUserActivitiesListResultIterator) Response() DataWarehouseUserActivitiesListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DataWarehouseUserActivitiesListResultIterator) Value() DataWarehouseUserActivities {
	if !iter.page.NotDone() {
		return DataWarehouseUserActivities{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DataWarehouseUserActivitiesListResultIterator type.
func NewDataWarehouseUserActivitiesListResultIterator(page DataWarehouseUserActivitiesListResultPage) DataWarehouseUserActivitiesListResultIterator {
	return DataWarehouseUserActivitiesListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dwualr DataWarehouseUserActivitiesListResult) IsEmpty() bool {
	return dwualr.Value == nil || len(*dwualr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dwualr DataWarehouseUserActivitiesListResult) hasNextLink() bool {
	return dwualr.NextLink != nil && len(*dwualr.NextLink) != 0
}

// dataWarehouseUserActivitiesListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dwualr DataWarehouseUserActivitiesListResult) dataWarehouseUserActivitiesListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dwualr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dwualr.NextLink)))
}

// DataWarehouseUserActivitiesListResultPage contains a page of DataWarehouseUserActivities values.
type DataWarehouseUserActivitiesListResultPage struct {
	fn     func(context.Context, DataWarehouseUserActivitiesListResult) (DataWarehouseUserActivitiesListResult, error)
	dwualr DataWarehouseUserActivitiesListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DataWarehouseUserActivitiesListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataWarehouseUserActivitiesListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dwualr)
		if err != nil {
			return err
		}
		page.dwualr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DataWarehouseUserActivitiesListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DataWarehouseUserActivitiesListResultPage) NotDone() bool {
	return !page.dwualr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DataWarehouseUserActivitiesListResultPage) Response() DataWarehouseUserActivitiesListResult {
	return page.dwualr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DataWarehouseUserActivitiesListResultPage) Values() []DataWarehouseUserActivities {
	if page.dwualr.IsEmpty() {
		return nil
	}
	return *page.dwualr.Value
}

// Creates a new instance of the DataWarehouseUserActivitiesListResultPage type.
func NewDataWarehouseUserActivitiesListResultPage(cur DataWarehouseUserActivitiesListResult, getNextPage func(context.Context, DataWarehouseUserActivitiesListResult) (DataWarehouseUserActivitiesListResult, error)) DataWarehouseUserActivitiesListResultPage {
	return DataWarehouseUserActivitiesListResultPage{
		fn:     getNextPage,
		dwualr: cur,
	}
}

// DataWarehouseUserActivitiesProperties user activities of a data warehouse. This currently includes the
// count of running or suspended queries. For more information, please view the sys.dm_pdw_exec_requests
// dynamic management view (DMV).
type DataWarehouseUserActivitiesProperties struct {
	// ActiveQueriesCount - READ-ONLY; Count of running and suspended queries.
	ActiveQueriesCount *int32 `json:"activeQueriesCount,omitempty"`
}

// MarshalJSON is the custom marshaler for DataWarehouseUserActivitiesProperties.
func (dwuap DataWarehouseUserActivitiesProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DeletedServer a deleted server.
type DeletedServer struct {
	autorest.Response `json:"-"`
	// DeletedServerProperties - Resource properties.
	*DeletedServerProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DeletedServer.
func (ds DeletedServer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ds.DeletedServerProperties != nil {
		objectMap["properties"] = ds.DeletedServerProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DeletedServer struct.
func (ds *DeletedServer) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var deletedServerProperties DeletedServerProperties
				err = json.Unmarshal(*v, &deletedServerProperties)
				if err != nil {
					return err
				}
				ds.DeletedServerProperties = &deletedServerProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ds.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ds.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ds.Type = &typeVar
			}
		}
	}

	return nil
}

// DeletedServerListResult a list of deleted servers.
type DeletedServerListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]DeletedServer `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DeletedServerListResult.
func (dslr DeletedServerListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DeletedServerListResultIterator provides access to a complete listing of DeletedServer values.
type DeletedServerListResultIterator struct {
	i    int
	page DeletedServerListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeletedServerListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeletedServerListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DeletedServerListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeletedServerListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeletedServerListResultIterator) Response() DeletedServerListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeletedServerListResultIterator) Value() DeletedServer {
	if !iter.page.NotDone() {
		return DeletedServer{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DeletedServerListResultIterator type.
func NewDeletedServerListResultIterator(page DeletedServerListResultPage) DeletedServerListResultIterator {
	return DeletedServerListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dslr DeletedServerListResult) IsEmpty() bool {
	return dslr.Value == nil || len(*dslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dslr DeletedServerListResult) hasNextLink() bool {
	return dslr.NextLink != nil && len(*dslr.NextLink) != 0
}

// deletedServerListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dslr DeletedServerListResult) deletedServerListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dslr.NextLink)))
}

// DeletedServerListResultPage contains a page of DeletedServer values.
type DeletedServerListResultPage struct {
	fn   func(context.Context, DeletedServerListResult) (DeletedServerListResult, error)
	dslr DeletedServerListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeletedServerListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeletedServerListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dslr)
		if err != nil {
			return err
		}
		page.dslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DeletedServerListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeletedServerListResultPage) NotDone() bool {
	return !page.dslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeletedServerListResultPage) Response() DeletedServerListResult {
	return page.dslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeletedServerListResultPage) Values() []DeletedServer {
	if page.dslr.IsEmpty() {
		return nil
	}
	return *page.dslr.Value
}

// Creates a new instance of the DeletedServerListResultPage type.
func NewDeletedServerListResultPage(cur DeletedServerListResult, getNextPage func(context.Context, DeletedServerListResult) (DeletedServerListResult, error)) DeletedServerListResultPage {
	return DeletedServerListResultPage{
		fn:   getNextPage,
		dslr: cur,
	}
}

// DeletedServerProperties the properties of a deleted server.
type DeletedServerProperties struct {
	// Version - READ-ONLY; The version of the deleted server.
	Version *string `json:"version,omitempty"`
	// DeletionTime - READ-ONLY; The deletion time of the deleted server.
	DeletionTime *date.Time `json:"deletionTime,omitempty"`
	// OriginalID - READ-ONLY; The original ID of the server before deletion.
	OriginalID *string `json:"originalId,omitempty"`
	// FullyQualifiedDomainName - READ-ONLY; The fully qualified domain name of the server.
	FullyQualifiedDomainName *string `json:"fullyQualifiedDomainName,omitempty"`
}

// MarshalJSON is the custom marshaler for DeletedServerProperties.
func (dsp DeletedServerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DeletedServersRecoverFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DeletedServersRecoverFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeletedServersClient) (DeletedServer, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeletedServersRecoverFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeletedServersRecoverFuture.Result.
func (future *DeletedServersRecoverFuture) result(client DeletedServersClient) (ds DeletedServer, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DeletedServersRecoverFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ds.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.DeletedServersRecoverFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ds.Response.Response, err = future.GetResult(sender); err == nil && ds.Response.Response.StatusCode != http.StatusNoContent {
		ds, err = client.RecoverResponder(ds.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DeletedServersRecoverFuture", "Result", ds.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DistributedAvailabilityGroup distributed availability group between box and Sql Managed Instance.
type DistributedAvailabilityGroup struct {
	autorest.Response `json:"-"`
	// DistributedAvailabilityGroupProperties - Resource properties.
	*DistributedAvailabilityGroupProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DistributedAvailabilityGroup.
func (dag DistributedAvailabilityGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dag.DistributedAvailabilityGroupProperties != nil {
		objectMap["properties"] = dag.DistributedAvailabilityGroupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DistributedAvailabilityGroup struct.
func (dag *DistributedAvailabilityGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var distributedAvailabilityGroupProperties DistributedAvailabilityGroupProperties
				err = json.Unmarshal(*v, &distributedAvailabilityGroupProperties)
				if err != nil {
					return err
				}
				dag.DistributedAvailabilityGroupProperties = &distributedAvailabilityGroupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dag.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dag.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dag.Type = &typeVar
			}
		}
	}

	return nil
}

// DistributedAvailabilityGroupProperties the properties of a distributed availability group.
type DistributedAvailabilityGroupProperties struct {
	// TargetDatabase - The name of the target database
	TargetDatabase *string `json:"targetDatabase,omitempty"`
	// SourceEndpoint - The source endpoint
	SourceEndpoint *string `json:"sourceEndpoint,omitempty"`
	// PrimaryAvailabilityGroupName - The primary availability group name
	PrimaryAvailabilityGroupName *string `json:"primaryAvailabilityGroupName,omitempty"`
	// SecondaryAvailabilityGroupName - The secondary availability group name
	SecondaryAvailabilityGroupName *string `json:"secondaryAvailabilityGroupName,omitempty"`
	// ReplicationMode - The replication mode of a distributed availability group. Parameter will be ignored during link creation. Possible values include: 'ReplicationModeAsync', 'ReplicationModeSync'
	ReplicationMode ReplicationMode `json:"replicationMode,omitempty"`
	// DistributedAvailabilityGroupID - READ-ONLY; The distributed availability group id
	DistributedAvailabilityGroupID *uuid.UUID `json:"distributedAvailabilityGroupId,omitempty"`
	// SourceReplicaID - READ-ONLY; The source replica id
	SourceReplicaID *uuid.UUID `json:"sourceReplicaId,omitempty"`
	// TargetReplicaID - READ-ONLY; The target replica id
	TargetReplicaID *uuid.UUID `json:"targetReplicaId,omitempty"`
	// LinkState - READ-ONLY; The link state
	LinkState *string `json:"linkState,omitempty"`
	// LastHardenedLsn - READ-ONLY; The last hardened lsn
	LastHardenedLsn *string `json:"lastHardenedLsn,omitempty"`
}

// MarshalJSON is the custom marshaler for DistributedAvailabilityGroupProperties.
func (dagp DistributedAvailabilityGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dagp.TargetDatabase != nil {
		objectMap["targetDatabase"] = dagp.TargetDatabase
	}
	if dagp.SourceEndpoint != nil {
		objectMap["sourceEndpoint"] = dagp.SourceEndpoint
	}
	if dagp.PrimaryAvailabilityGroupName != nil {
		objectMap["primaryAvailabilityGroupName"] = dagp.PrimaryAvailabilityGroupName
	}
	if dagp.SecondaryAvailabilityGroupName != nil {
		objectMap["secondaryAvailabilityGroupName"] = dagp.SecondaryAvailabilityGroupName
	}
	if dagp.ReplicationMode != "" {
		objectMap["replicationMode"] = dagp.ReplicationMode
	}
	return json.Marshal(objectMap)
}

// DistributedAvailabilityGroupsCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type DistributedAvailabilityGroupsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DistributedAvailabilityGroupsClient) (DistributedAvailabilityGroup, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DistributedAvailabilityGroupsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DistributedAvailabilityGroupsCreateOrUpdateFuture.Result.
func (future *DistributedAvailabilityGroupsCreateOrUpdateFuture) result(client DistributedAvailabilityGroupsClient) (dag DistributedAvailabilityGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DistributedAvailabilityGroupsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		dag.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.DistributedAvailabilityGroupsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dag.Response.Response, err = future.GetResult(sender); err == nil && dag.Response.Response.StatusCode != http.StatusNoContent {
		dag, err = client.CreateOrUpdateResponder(dag.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DistributedAvailabilityGroupsCreateOrUpdateFuture", "Result", dag.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DistributedAvailabilityGroupsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DistributedAvailabilityGroupsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DistributedAvailabilityGroupsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DistributedAvailabilityGroupsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DistributedAvailabilityGroupsDeleteFuture.Result.
func (future *DistributedAvailabilityGroupsDeleteFuture) result(client DistributedAvailabilityGroupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DistributedAvailabilityGroupsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.DistributedAvailabilityGroupsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DistributedAvailabilityGroupsListResult a list of distributed availability groups in instance.
type DistributedAvailabilityGroupsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]DistributedAvailabilityGroup `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DistributedAvailabilityGroupsListResult.
func (daglr DistributedAvailabilityGroupsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DistributedAvailabilityGroupsListResultIterator provides access to a complete listing of
// DistributedAvailabilityGroup values.
type DistributedAvailabilityGroupsListResultIterator struct {
	i    int
	page DistributedAvailabilityGroupsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DistributedAvailabilityGroupsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DistributedAvailabilityGroupsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DistributedAvailabilityGroupsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DistributedAvailabilityGroupsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DistributedAvailabilityGroupsListResultIterator) Response() DistributedAvailabilityGroupsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DistributedAvailabilityGroupsListResultIterator) Value() DistributedAvailabilityGroup {
	if !iter.page.NotDone() {
		return DistributedAvailabilityGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DistributedAvailabilityGroupsListResultIterator type.
func NewDistributedAvailabilityGroupsListResultIterator(page DistributedAvailabilityGroupsListResultPage) DistributedAvailabilityGroupsListResultIterator {
	return DistributedAvailabilityGroupsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (daglr DistributedAvailabilityGroupsListResult) IsEmpty() bool {
	return daglr.Value == nil || len(*daglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (daglr DistributedAvailabilityGroupsListResult) hasNextLink() bool {
	return daglr.NextLink != nil && len(*daglr.NextLink) != 0
}

// distributedAvailabilityGroupsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (daglr DistributedAvailabilityGroupsListResult) distributedAvailabilityGroupsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !daglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(daglr.NextLink)))
}

// DistributedAvailabilityGroupsListResultPage contains a page of DistributedAvailabilityGroup values.
type DistributedAvailabilityGroupsListResultPage struct {
	fn    func(context.Context, DistributedAvailabilityGroupsListResult) (DistributedAvailabilityGroupsListResult, error)
	daglr DistributedAvailabilityGroupsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DistributedAvailabilityGroupsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DistributedAvailabilityGroupsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.daglr)
		if err != nil {
			return err
		}
		page.daglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DistributedAvailabilityGroupsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DistributedAvailabilityGroupsListResultPage) NotDone() bool {
	return !page.daglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DistributedAvailabilityGroupsListResultPage) Response() DistributedAvailabilityGroupsListResult {
	return page.daglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DistributedAvailabilityGroupsListResultPage) Values() []DistributedAvailabilityGroup {
	if page.daglr.IsEmpty() {
		return nil
	}
	return *page.daglr.Value
}

// Creates a new instance of the DistributedAvailabilityGroupsListResultPage type.
func NewDistributedAvailabilityGroupsListResultPage(cur DistributedAvailabilityGroupsListResult, getNextPage func(context.Context, DistributedAvailabilityGroupsListResult) (DistributedAvailabilityGroupsListResult, error)) DistributedAvailabilityGroupsListResultPage {
	return DistributedAvailabilityGroupsListResultPage{
		fn:    getNextPage,
		daglr: cur,
	}
}

// DistributedAvailabilityGroupsUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DistributedAvailabilityGroupsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DistributedAvailabilityGroupsClient) (DistributedAvailabilityGroup, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DistributedAvailabilityGroupsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DistributedAvailabilityGroupsUpdateFuture.Result.
func (future *DistributedAvailabilityGroupsUpdateFuture) result(client DistributedAvailabilityGroupsClient) (dag DistributedAvailabilityGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DistributedAvailabilityGroupsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		dag.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.DistributedAvailabilityGroupsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dag.Response.Response, err = future.GetResult(sender); err == nil && dag.Response.Response.StatusCode != http.StatusNoContent {
		dag, err = client.UpdateResponder(dag.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DistributedAvailabilityGroupsUpdateFuture", "Result", dag.Response.Response, "Failure responding to request")
		}
	}
	return
}

// EditionCapability the edition capability.
type EditionCapability struct {
	// Name - READ-ONLY; The database edition name.
	Name *string `json:"name,omitempty"`
	// SupportedServiceLevelObjectives - READ-ONLY; The list of supported service objectives for the edition.
	SupportedServiceLevelObjectives *[]ServiceObjectiveCapability `json:"supportedServiceLevelObjectives,omitempty"`
	// ZoneRedundant - READ-ONLY; Whether or not zone redundancy is supported for the edition.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
	// ReadScale - READ-ONLY; The read scale capability for the edition.
	ReadScale *ReadScaleCapability `json:"readScale,omitempty"`
	// SupportedStorageCapabilities - READ-ONLY; The list of supported storage capabilities for this edition
	SupportedStorageCapabilities *[]StorageCapability `json:"supportedStorageCapabilities,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for EditionCapability.
func (ec EditionCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ec.Reason != nil {
		objectMap["reason"] = ec.Reason
	}
	return json.Marshal(objectMap)
}

// ElasticPool an elastic pool.
type ElasticPool struct {
	autorest.Response `json:"-"`
	// Sku - The elastic pool SKU.
	//
	// The list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family, and capacity) that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API or the following command:
	//
	// ```azurecli
	// az sql elastic-pool list-editions -l <location> -o table
	// ````
	Sku *Sku `json:"sku,omitempty"`
	// Kind - READ-ONLY; Kind of elastic pool. This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// ElasticPoolProperties - Resource properties.
	*ElasticPoolProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPool.
func (ep ElasticPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ep.Sku != nil {
		objectMap["sku"] = ep.Sku
	}
	if ep.ElasticPoolProperties != nil {
		objectMap["properties"] = ep.ElasticPoolProperties
	}
	if ep.Location != nil {
		objectMap["location"] = ep.Location
	}
	if ep.Tags != nil {
		objectMap["tags"] = ep.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ElasticPool struct.
func (ep *ElasticPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				ep.Sku = &sku
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ep.Kind = &kind
			}
		case "properties":
			if v != nil {
				var elasticPoolProperties ElasticPoolProperties
				err = json.Unmarshal(*v, &elasticPoolProperties)
				if err != nil {
					return err
				}
				ep.ElasticPoolProperties = &elasticPoolProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ep.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ep.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ep.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ep.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ep.Type = &typeVar
			}
		}
	}

	return nil
}

// ElasticPoolActivity represents the activity on an elastic pool.
type ElasticPoolActivity struct {
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ElasticPoolActivityProperties - The properties representing the resource.
	*ElasticPoolActivityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolActivity.
func (epa ElasticPoolActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epa.Location != nil {
		objectMap["location"] = epa.Location
	}
	if epa.ElasticPoolActivityProperties != nil {
		objectMap["properties"] = epa.ElasticPoolActivityProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ElasticPoolActivity struct.
func (epa *ElasticPoolActivity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				epa.Location = &location
			}
		case "properties":
			if v != nil {
				var elasticPoolActivityProperties ElasticPoolActivityProperties
				err = json.Unmarshal(*v, &elasticPoolActivityProperties)
				if err != nil {
					return err
				}
				epa.ElasticPoolActivityProperties = &elasticPoolActivityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				epa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				epa.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				epa.Type = &typeVar
			}
		}
	}

	return nil
}

// ElasticPoolActivityListResult represents the response to a list elastic pool activity request.
type ElasticPoolActivityListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of elastic pool activities.
	Value *[]ElasticPoolActivity `json:"value,omitempty"`
}

// ElasticPoolActivityProperties represents the properties of an elastic pool.
type ElasticPoolActivityProperties struct {
	// EndTime - READ-ONLY; The time the operation finished (ISO8601 format).
	EndTime *date.Time `json:"endTime,omitempty"`
	// ErrorCode - READ-ONLY; The error code if available.
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// ErrorMessage - READ-ONLY; The error message if available.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// ErrorSeverity - READ-ONLY; The error severity if available.
	ErrorSeverity *int32 `json:"errorSeverity,omitempty"`
	// Operation - READ-ONLY; The operation name.
	Operation *string `json:"operation,omitempty"`
	// OperationID - READ-ONLY; The unique operation ID.
	OperationID *uuid.UUID `json:"operationId,omitempty"`
	// PercentComplete - READ-ONLY; The percentage complete if available.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// RequestedDatabaseDtuMax - READ-ONLY; The requested max DTU per database if available.
	RequestedDatabaseDtuMax *int32 `json:"requestedDatabaseDtuMax,omitempty"`
	// RequestedDatabaseDtuMin - READ-ONLY; The requested min DTU per database if available.
	RequestedDatabaseDtuMin *int32 `json:"requestedDatabaseDtuMin,omitempty"`
	// RequestedDtu - READ-ONLY; The requested DTU for the pool if available.
	RequestedDtu *int32 `json:"requestedDtu,omitempty"`
	// RequestedElasticPoolName - READ-ONLY; The requested name for the elastic pool if available.
	RequestedElasticPoolName *string `json:"requestedElasticPoolName,omitempty"`
	// RequestedStorageLimitInGB - READ-ONLY; The requested storage limit for the pool in GB if available.
	RequestedStorageLimitInGB *int64 `json:"requestedStorageLimitInGB,omitempty"`
	// ElasticPoolName - READ-ONLY; The name of the elastic pool.
	ElasticPoolName *string `json:"elasticPoolName,omitempty"`
	// ServerName - READ-ONLY; The name of the server the elastic pool is in.
	ServerName *string `json:"serverName,omitempty"`
	// StartTime - READ-ONLY; The time the operation started (ISO8601 format).
	StartTime *date.Time `json:"startTime,omitempty"`
	// State - READ-ONLY; The current state of the operation.
	State *string `json:"state,omitempty"`
	// RequestedStorageLimitInMB - READ-ONLY; The requested storage limit in MB.
	RequestedStorageLimitInMB *int32 `json:"requestedStorageLimitInMB,omitempty"`
	// RequestedDatabaseDtuGuarantee - READ-ONLY; The requested per database DTU guarantee.
	RequestedDatabaseDtuGuarantee *int32 `json:"requestedDatabaseDtuGuarantee,omitempty"`
	// RequestedDatabaseDtuCap - READ-ONLY; The requested per database DTU cap.
	RequestedDatabaseDtuCap *int32 `json:"requestedDatabaseDtuCap,omitempty"`
	// RequestedDtuGuarantee - READ-ONLY; The requested DTU guarantee.
	RequestedDtuGuarantee *int32 `json:"requestedDtuGuarantee,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolActivityProperties.
func (epap ElasticPoolActivityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ElasticPoolDatabaseActivity represents the activity on an elastic pool.
type ElasticPoolDatabaseActivity struct {
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ElasticPoolDatabaseActivityProperties - The properties representing the resource.
	*ElasticPoolDatabaseActivityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolDatabaseActivity.
func (epda ElasticPoolDatabaseActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epda.Location != nil {
		objectMap["location"] = epda.Location
	}
	if epda.ElasticPoolDatabaseActivityProperties != nil {
		objectMap["properties"] = epda.ElasticPoolDatabaseActivityProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ElasticPoolDatabaseActivity struct.
func (epda *ElasticPoolDatabaseActivity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				epda.Location = &location
			}
		case "properties":
			if v != nil {
				var elasticPoolDatabaseActivityProperties ElasticPoolDatabaseActivityProperties
				err = json.Unmarshal(*v, &elasticPoolDatabaseActivityProperties)
				if err != nil {
					return err
				}
				epda.ElasticPoolDatabaseActivityProperties = &elasticPoolDatabaseActivityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				epda.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				epda.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				epda.Type = &typeVar
			}
		}
	}

	return nil
}

// ElasticPoolDatabaseActivityListResult represents the response to a list elastic pool database activity
// request.
type ElasticPoolDatabaseActivityListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of elastic pool database activities.
	Value *[]ElasticPoolDatabaseActivity `json:"value,omitempty"`
}

// ElasticPoolDatabaseActivityProperties represents the properties of an elastic pool database activity.
type ElasticPoolDatabaseActivityProperties struct {
	// DatabaseName - READ-ONLY; The database name.
	DatabaseName *string `json:"databaseName,omitempty"`
	// EndTime - READ-ONLY; The time the operation finished (ISO8601 format).
	EndTime *date.Time `json:"endTime,omitempty"`
	// ErrorCode - READ-ONLY; The error code if available.
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// ErrorMessage - READ-ONLY; The error message if available.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// ErrorSeverity - READ-ONLY; The error severity if available.
	ErrorSeverity *int32 `json:"errorSeverity,omitempty"`
	// Operation - READ-ONLY; The operation name.
	Operation *string `json:"operation,omitempty"`
	// OperationID - READ-ONLY; The unique operation ID.
	OperationID *uuid.UUID `json:"operationId,omitempty"`
	// PercentComplete - READ-ONLY; The percentage complete if available.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// RequestedElasticPoolName - READ-ONLY; The name for the elastic pool the database is moving into if available.
	RequestedElasticPoolName *string `json:"requestedElasticPoolName,omitempty"`
	// CurrentElasticPoolName - READ-ONLY; The name of the current elastic pool the database is in if available.
	CurrentElasticPoolName *string `json:"currentElasticPoolName,omitempty"`
	// CurrentServiceObjective - READ-ONLY; The name of the current service objective if available.
	CurrentServiceObjective *string `json:"currentServiceObjective,omitempty"`
	// RequestedServiceObjective - READ-ONLY; The name of the requested service objective if available.
	RequestedServiceObjective *string `json:"requestedServiceObjective,omitempty"`
	// ServerName - READ-ONLY; The name of the server the elastic pool is in.
	ServerName *string `json:"serverName,omitempty"`
	// StartTime - READ-ONLY; The time the operation started (ISO8601 format).
	StartTime *date.Time `json:"startTime,omitempty"`
	// State - READ-ONLY; The current state of the operation.
	State *string `json:"state,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolDatabaseActivityProperties.
func (epdap ElasticPoolDatabaseActivityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ElasticPoolEditionCapability the elastic pool edition capability.
type ElasticPoolEditionCapability struct {
	// Name - READ-ONLY; The elastic pool edition name.
	Name *string `json:"name,omitempty"`
	// SupportedElasticPoolPerformanceLevels - READ-ONLY; The list of supported elastic pool DTU levels for the edition.
	SupportedElasticPoolPerformanceLevels *[]ElasticPoolPerformanceLevelCapability `json:"supportedElasticPoolPerformanceLevels,omitempty"`
	// ZoneRedundant - READ-ONLY; Whether or not zone redundancy is supported for the edition.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolEditionCapability.
func (epec ElasticPoolEditionCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epec.Reason != nil {
		objectMap["reason"] = epec.Reason
	}
	return json.Marshal(objectMap)
}

// ElasticPoolListResult the result of an elastic pool list request.
type ElasticPoolListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ElasticPool `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolListResult.
func (eplr ElasticPoolListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ElasticPoolListResultIterator provides access to a complete listing of ElasticPool values.
type ElasticPoolListResultIterator struct {
	i    int
	page ElasticPoolListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ElasticPoolListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ElasticPoolListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ElasticPoolListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ElasticPoolListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ElasticPoolListResultIterator) Response() ElasticPoolListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ElasticPoolListResultIterator) Value() ElasticPool {
	if !iter.page.NotDone() {
		return ElasticPool{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ElasticPoolListResultIterator type.
func NewElasticPoolListResultIterator(page ElasticPoolListResultPage) ElasticPoolListResultIterator {
	return ElasticPoolListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (eplr ElasticPoolListResult) IsEmpty() bool {
	return eplr.Value == nil || len(*eplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (eplr ElasticPoolListResult) hasNextLink() bool {
	return eplr.NextLink != nil && len(*eplr.NextLink) != 0
}

// elasticPoolListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (eplr ElasticPoolListResult) elasticPoolListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !eplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(eplr.NextLink)))
}

// ElasticPoolListResultPage contains a page of ElasticPool values.
type ElasticPoolListResultPage struct {
	fn   func(context.Context, ElasticPoolListResult) (ElasticPoolListResult, error)
	eplr ElasticPoolListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ElasticPoolListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ElasticPoolListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.eplr)
		if err != nil {
			return err
		}
		page.eplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ElasticPoolListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ElasticPoolListResultPage) NotDone() bool {
	return !page.eplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ElasticPoolListResultPage) Response() ElasticPoolListResult {
	return page.eplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ElasticPoolListResultPage) Values() []ElasticPool {
	if page.eplr.IsEmpty() {
		return nil
	}
	return *page.eplr.Value
}

// Creates a new instance of the ElasticPoolListResultPage type.
func NewElasticPoolListResultPage(cur ElasticPoolListResult, getNextPage func(context.Context, ElasticPoolListResult) (ElasticPoolListResult, error)) ElasticPoolListResultPage {
	return ElasticPoolListResultPage{
		fn:   getNextPage,
		eplr: cur,
	}
}

// ElasticPoolOperation a elastic pool operation.
type ElasticPoolOperation struct {
	// ElasticPoolOperationProperties - Resource properties.
	*ElasticPoolOperationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolOperation.
func (epo ElasticPoolOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epo.ElasticPoolOperationProperties != nil {
		objectMap["properties"] = epo.ElasticPoolOperationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ElasticPoolOperation struct.
func (epo *ElasticPoolOperation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var elasticPoolOperationProperties ElasticPoolOperationProperties
				err = json.Unmarshal(*v, &elasticPoolOperationProperties)
				if err != nil {
					return err
				}
				epo.ElasticPoolOperationProperties = &elasticPoolOperationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				epo.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				epo.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				epo.Type = &typeVar
			}
		}
	}

	return nil
}

// ElasticPoolOperationListResult the response to a list elastic pool operations request
type ElasticPoolOperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ElasticPoolOperation `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolOperationListResult.
func (epolr ElasticPoolOperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ElasticPoolOperationListResultIterator provides access to a complete listing of ElasticPoolOperation
// values.
type ElasticPoolOperationListResultIterator struct {
	i    int
	page ElasticPoolOperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ElasticPoolOperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ElasticPoolOperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ElasticPoolOperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ElasticPoolOperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ElasticPoolOperationListResultIterator) Response() ElasticPoolOperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ElasticPoolOperationListResultIterator) Value() ElasticPoolOperation {
	if !iter.page.NotDone() {
		return ElasticPoolOperation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ElasticPoolOperationListResultIterator type.
func NewElasticPoolOperationListResultIterator(page ElasticPoolOperationListResultPage) ElasticPoolOperationListResultIterator {
	return ElasticPoolOperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (epolr ElasticPoolOperationListResult) IsEmpty() bool {
	return epolr.Value == nil || len(*epolr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (epolr ElasticPoolOperationListResult) hasNextLink() bool {
	return epolr.NextLink != nil && len(*epolr.NextLink) != 0
}

// elasticPoolOperationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (epolr ElasticPoolOperationListResult) elasticPoolOperationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !epolr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(epolr.NextLink)))
}

// ElasticPoolOperationListResultPage contains a page of ElasticPoolOperation values.
type ElasticPoolOperationListResultPage struct {
	fn    func(context.Context, ElasticPoolOperationListResult) (ElasticPoolOperationListResult, error)
	epolr ElasticPoolOperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ElasticPoolOperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ElasticPoolOperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.epolr)
		if err != nil {
			return err
		}
		page.epolr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ElasticPoolOperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ElasticPoolOperationListResultPage) NotDone() bool {
	return !page.epolr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ElasticPoolOperationListResultPage) Response() ElasticPoolOperationListResult {
	return page.epolr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ElasticPoolOperationListResultPage) Values() []ElasticPoolOperation {
	if page.epolr.IsEmpty() {
		return nil
	}
	return *page.epolr.Value
}

// Creates a new instance of the ElasticPoolOperationListResultPage type.
func NewElasticPoolOperationListResultPage(cur ElasticPoolOperationListResult, getNextPage func(context.Context, ElasticPoolOperationListResult) (ElasticPoolOperationListResult, error)) ElasticPoolOperationListResultPage {
	return ElasticPoolOperationListResultPage{
		fn:    getNextPage,
		epolr: cur,
	}
}

// ElasticPoolOperationProperties the properties of a elastic pool operation.
type ElasticPoolOperationProperties struct {
	// ElasticPoolName - READ-ONLY; The name of the elastic pool the operation is being performed on.
	ElasticPoolName *string `json:"elasticPoolName,omitempty"`
	// Operation - READ-ONLY; The name of operation.
	Operation *string `json:"operation,omitempty"`
	// OperationFriendlyName - READ-ONLY; The friendly name of operation.
	OperationFriendlyName *string `json:"operationFriendlyName,omitempty"`
	// PercentComplete - READ-ONLY; The percentage of the operation completed.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// ServerName - READ-ONLY; The name of the server.
	ServerName *string `json:"serverName,omitempty"`
	// StartTime - READ-ONLY; The operation start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// State - READ-ONLY; The operation state.
	State *string `json:"state,omitempty"`
	// ErrorCode - READ-ONLY; The operation error code.
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// ErrorDescription - READ-ONLY; The operation error description.
	ErrorDescription *string `json:"errorDescription,omitempty"`
	// ErrorSeverity - READ-ONLY; The operation error severity.
	ErrorSeverity *int32 `json:"errorSeverity,omitempty"`
	// IsUserError - READ-ONLY; Whether or not the error is a user error.
	IsUserError *bool `json:"isUserError,omitempty"`
	// EstimatedCompletionTime - READ-ONLY; The estimated completion time of the operation.
	EstimatedCompletionTime *date.Time `json:"estimatedCompletionTime,omitempty"`
	// Description - READ-ONLY; The operation description.
	Description *string `json:"description,omitempty"`
	// IsCancellable - READ-ONLY; Whether the operation can be cancelled.
	IsCancellable *bool `json:"isCancellable,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolOperationProperties.
func (epop ElasticPoolOperationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ElasticPoolPerDatabaseMaxPerformanceLevelCapability the max per-database performance level capability.
type ElasticPoolPerDatabaseMaxPerformanceLevelCapability struct {
	// Limit - READ-ONLY; The maximum performance level per database.
	Limit *float64 `json:"limit,omitempty"`
	// Unit - READ-ONLY; Unit type used to measure performance level. Possible values include: 'PerformanceLevelUnitDTU', 'PerformanceLevelUnitVCores'
	Unit PerformanceLevelUnit `json:"unit,omitempty"`
	// SupportedPerDatabaseMinPerformanceLevels - READ-ONLY; The list of supported min database performance levels.
	SupportedPerDatabaseMinPerformanceLevels *[]ElasticPoolPerDatabaseMinPerformanceLevelCapability `json:"supportedPerDatabaseMinPerformanceLevels,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolPerDatabaseMaxPerformanceLevelCapability.
func (eppdmplc ElasticPoolPerDatabaseMaxPerformanceLevelCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if eppdmplc.Reason != nil {
		objectMap["reason"] = eppdmplc.Reason
	}
	return json.Marshal(objectMap)
}

// ElasticPoolPerDatabaseMinPerformanceLevelCapability the minimum per-database performance level
// capability.
type ElasticPoolPerDatabaseMinPerformanceLevelCapability struct {
	// Limit - READ-ONLY; The minimum performance level per database.
	Limit *float64 `json:"limit,omitempty"`
	// Unit - READ-ONLY; Unit type used to measure performance level. Possible values include: 'PerformanceLevelUnitDTU', 'PerformanceLevelUnitVCores'
	Unit PerformanceLevelUnit `json:"unit,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolPerDatabaseMinPerformanceLevelCapability.
func (eppdmplc ElasticPoolPerDatabaseMinPerformanceLevelCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if eppdmplc.Reason != nil {
		objectMap["reason"] = eppdmplc.Reason
	}
	return json.Marshal(objectMap)
}

// ElasticPoolPerDatabaseSettings per database settings of an elastic pool.
type ElasticPoolPerDatabaseSettings struct {
	// MinCapacity - The minimum capacity all databases are guaranteed.
	MinCapacity *float64 `json:"minCapacity,omitempty"`
	// MaxCapacity - The maximum capacity any one database can consume.
	MaxCapacity *float64 `json:"maxCapacity,omitempty"`
}

// ElasticPoolPerformanceLevelCapability the Elastic Pool performance level capability.
type ElasticPoolPerformanceLevelCapability struct {
	// PerformanceLevel - READ-ONLY; The performance level for the pool.
	PerformanceLevel *PerformanceLevelCapability `json:"performanceLevel,omitempty"`
	// Sku - READ-ONLY; The sku.
	Sku *Sku `json:"sku,omitempty"`
	// SupportedLicenseTypes - READ-ONLY; List of supported license types.
	SupportedLicenseTypes *[]LicenseTypeCapability `json:"supportedLicenseTypes,omitempty"`
	// MaxDatabaseCount - READ-ONLY; The maximum number of databases supported.
	MaxDatabaseCount *int32 `json:"maxDatabaseCount,omitempty"`
	// IncludedMaxSize - READ-ONLY; The included (free) max size for this performance level.
	IncludedMaxSize *MaxSizeCapability `json:"includedMaxSize,omitempty"`
	// SupportedMaxSizes - READ-ONLY; The list of supported max sizes.
	SupportedMaxSizes *[]MaxSizeRangeCapability `json:"supportedMaxSizes,omitempty"`
	// SupportedPerDatabaseMaxSizes - READ-ONLY; The list of supported per database max sizes.
	SupportedPerDatabaseMaxSizes *[]MaxSizeRangeCapability `json:"supportedPerDatabaseMaxSizes,omitempty"`
	// SupportedPerDatabaseMaxPerformanceLevels - READ-ONLY; The list of supported per database max performance levels.
	SupportedPerDatabaseMaxPerformanceLevels *[]ElasticPoolPerDatabaseMaxPerformanceLevelCapability `json:"supportedPerDatabaseMaxPerformanceLevels,omitempty"`
	// ZoneRedundant - READ-ONLY; Whether or not zone redundancy is supported for the performance level.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
	// SupportedMaintenanceConfigurations - READ-ONLY; List of supported maintenance configurations
	SupportedMaintenanceConfigurations *[]MaintenanceConfigurationCapability `json:"supportedMaintenanceConfigurations,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolPerformanceLevelCapability.
func (epplc ElasticPoolPerformanceLevelCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epplc.Reason != nil {
		objectMap["reason"] = epplc.Reason
	}
	return json.Marshal(objectMap)
}

// ElasticPoolProperties properties of an elastic pool
type ElasticPoolProperties struct {
	// State - READ-ONLY; The state of the elastic pool. Possible values include: 'ElasticPoolStateCreating', 'ElasticPoolStateReady', 'ElasticPoolStateDisabled'
	State ElasticPoolState `json:"state,omitempty"`
	// CreationDate - READ-ONLY; The creation date of the elastic pool (ISO8601 format).
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// MaxSizeBytes - The storage limit for the database elastic pool in bytes.
	MaxSizeBytes *int64 `json:"maxSizeBytes,omitempty"`
	// PerDatabaseSettings - The per database settings for the elastic pool.
	PerDatabaseSettings *ElasticPoolPerDatabaseSettings `json:"perDatabaseSettings,omitempty"`
	// ZoneRedundant - Whether or not this elastic pool is zone redundant, which means the replicas of this elastic pool will be spread across multiple availability zones.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
	// LicenseType - The license type to apply for this elastic pool. Possible values include: 'ElasticPoolLicenseTypeLicenseIncluded', 'ElasticPoolLicenseTypeBasePrice'
	LicenseType ElasticPoolLicenseType `json:"licenseType,omitempty"`
	// MaintenanceConfigurationID - Maintenance configuration id assigned to the elastic pool. This configuration defines the period when the maintenance updates will will occur.
	MaintenanceConfigurationID *string `json:"maintenanceConfigurationId,omitempty"`
	// HighAvailabilityReplicaCount - The number of secondary replicas associated with the elastic pool that are used to provide high availability.
	HighAvailabilityReplicaCount *int32 `json:"highAvailabilityReplicaCount,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolProperties.
func (epp ElasticPoolProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epp.MaxSizeBytes != nil {
		objectMap["maxSizeBytes"] = epp.MaxSizeBytes
	}
	if epp.PerDatabaseSettings != nil {
		objectMap["perDatabaseSettings"] = epp.PerDatabaseSettings
	}
	if epp.ZoneRedundant != nil {
		objectMap["zoneRedundant"] = epp.ZoneRedundant
	}
	if epp.LicenseType != "" {
		objectMap["licenseType"] = epp.LicenseType
	}
	if epp.MaintenanceConfigurationID != nil {
		objectMap["maintenanceConfigurationId"] = epp.MaintenanceConfigurationID
	}
	if epp.HighAvailabilityReplicaCount != nil {
		objectMap["highAvailabilityReplicaCount"] = epp.HighAvailabilityReplicaCount
	}
	return json.Marshal(objectMap)
}

// ElasticPoolsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ElasticPoolsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ElasticPoolsClient) (ElasticPool, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ElasticPoolsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ElasticPoolsCreateOrUpdateFuture.Result.
func (future *ElasticPoolsCreateOrUpdateFuture) result(client ElasticPoolsClient) (ep ElasticPool, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ElasticPoolsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ep.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ElasticPoolsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ep.Response.Response, err = future.GetResult(sender); err == nil && ep.Response.Response.StatusCode != http.StatusNoContent {
		ep, err = client.CreateOrUpdateResponder(ep.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ElasticPoolsCreateOrUpdateFuture", "Result", ep.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ElasticPoolsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ElasticPoolsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ElasticPoolsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ElasticPoolsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ElasticPoolsDeleteFuture.Result.
func (future *ElasticPoolsDeleteFuture) result(client ElasticPoolsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ElasticPoolsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ElasticPoolsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ElasticPoolsFailoverFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ElasticPoolsFailoverFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ElasticPoolsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ElasticPoolsFailoverFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ElasticPoolsFailoverFuture.Result.
func (future *ElasticPoolsFailoverFuture) result(client ElasticPoolsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ElasticPoolsFailoverFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ElasticPoolsFailoverFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ElasticPoolsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ElasticPoolsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ElasticPoolsClient) (ElasticPool, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ElasticPoolsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ElasticPoolsUpdateFuture.Result.
func (future *ElasticPoolsUpdateFuture) result(client ElasticPoolsClient) (ep ElasticPool, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ElasticPoolsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ep.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ElasticPoolsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ep.Response.Response, err = future.GetResult(sender); err == nil && ep.Response.Response.StatusCode != http.StatusNoContent {
		ep, err = client.UpdateResponder(ep.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ElasticPoolsUpdateFuture", "Result", ep.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ElasticPoolUpdate an elastic pool update.
type ElasticPoolUpdate struct {
	Sku *Sku `json:"sku,omitempty"`
	// ElasticPoolUpdateProperties - Resource properties.
	*ElasticPoolUpdateProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ElasticPoolUpdate.
func (epu ElasticPoolUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epu.Sku != nil {
		objectMap["sku"] = epu.Sku
	}
	if epu.ElasticPoolUpdateProperties != nil {
		objectMap["properties"] = epu.ElasticPoolUpdateProperties
	}
	if epu.Tags != nil {
		objectMap["tags"] = epu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ElasticPoolUpdate struct.
func (epu *ElasticPoolUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				epu.Sku = &sku
			}
		case "properties":
			if v != nil {
				var elasticPoolUpdateProperties ElasticPoolUpdateProperties
				err = json.Unmarshal(*v, &elasticPoolUpdateProperties)
				if err != nil {
					return err
				}
				epu.ElasticPoolUpdateProperties = &elasticPoolUpdateProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				epu.Tags = tags
			}
		}
	}

	return nil
}

// ElasticPoolUpdateProperties properties of an elastic pool
type ElasticPoolUpdateProperties struct {
	// MaxSizeBytes - The storage limit for the database elastic pool in bytes.
	MaxSizeBytes *int64 `json:"maxSizeBytes,omitempty"`
	// PerDatabaseSettings - The per database settings for the elastic pool.
	PerDatabaseSettings *ElasticPoolPerDatabaseSettings `json:"perDatabaseSettings,omitempty"`
	// ZoneRedundant - Whether or not this elastic pool is zone redundant, which means the replicas of this elastic pool will be spread across multiple availability zones.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
	// LicenseType - The license type to apply for this elastic pool. Possible values include: 'ElasticPoolLicenseTypeLicenseIncluded', 'ElasticPoolLicenseTypeBasePrice'
	LicenseType ElasticPoolLicenseType `json:"licenseType,omitempty"`
	// MaintenanceConfigurationID - Maintenance configuration id assigned to the elastic pool. This configuration defines the period when the maintenance updates will will occur.
	MaintenanceConfigurationID *string `json:"maintenanceConfigurationId,omitempty"`
	// HighAvailabilityReplicaCount - The number of secondary replicas associated with the elastic pool that are used to provide high availability. Applicable only to Hyperscale elastic pools.
	HighAvailabilityReplicaCount *int32 `json:"highAvailabilityReplicaCount,omitempty"`
}

// EncryptionProtector the server encryption protector.
type EncryptionProtector struct {
	autorest.Response `json:"-"`
	// Kind - READ-ONLY; Kind of encryption protector. This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// Location - READ-ONLY; Resource location.
	Location *string `json:"location,omitempty"`
	// EncryptionProtectorProperties - Resource properties.
	*EncryptionProtectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EncryptionProtector.
func (ep EncryptionProtector) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ep.EncryptionProtectorProperties != nil {
		objectMap["properties"] = ep.EncryptionProtectorProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EncryptionProtector struct.
func (ep *EncryptionProtector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ep.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ep.Location = &location
			}
		case "properties":
			if v != nil {
				var encryptionProtectorProperties EncryptionProtectorProperties
				err = json.Unmarshal(*v, &encryptionProtectorProperties)
				if err != nil {
					return err
				}
				ep.EncryptionProtectorProperties = &encryptionProtectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ep.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ep.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ep.Type = &typeVar
			}
		}
	}

	return nil
}

// EncryptionProtectorListResult a list of server encryption protectors.
type EncryptionProtectorListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]EncryptionProtector `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for EncryptionProtectorListResult.
func (eplr EncryptionProtectorListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// EncryptionProtectorListResultIterator provides access to a complete listing of EncryptionProtector
// values.
type EncryptionProtectorListResultIterator struct {
	i    int
	page EncryptionProtectorListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EncryptionProtectorListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EncryptionProtectorListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EncryptionProtectorListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EncryptionProtectorListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EncryptionProtectorListResultIterator) Response() EncryptionProtectorListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EncryptionProtectorListResultIterator) Value() EncryptionProtector {
	if !iter.page.NotDone() {
		return EncryptionProtector{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EncryptionProtectorListResultIterator type.
func NewEncryptionProtectorListResultIterator(page EncryptionProtectorListResultPage) EncryptionProtectorListResultIterator {
	return EncryptionProtectorListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (eplr EncryptionProtectorListResult) IsEmpty() bool {
	return eplr.Value == nil || len(*eplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (eplr EncryptionProtectorListResult) hasNextLink() bool {
	return eplr.NextLink != nil && len(*eplr.NextLink) != 0
}

// encryptionProtectorListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (eplr EncryptionProtectorListResult) encryptionProtectorListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !eplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(eplr.NextLink)))
}

// EncryptionProtectorListResultPage contains a page of EncryptionProtector values.
type EncryptionProtectorListResultPage struct {
	fn   func(context.Context, EncryptionProtectorListResult) (EncryptionProtectorListResult, error)
	eplr EncryptionProtectorListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EncryptionProtectorListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EncryptionProtectorListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.eplr)
		if err != nil {
			return err
		}
		page.eplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EncryptionProtectorListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EncryptionProtectorListResultPage) NotDone() bool {
	return !page.eplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EncryptionProtectorListResultPage) Response() EncryptionProtectorListResult {
	return page.eplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EncryptionProtectorListResultPage) Values() []EncryptionProtector {
	if page.eplr.IsEmpty() {
		return nil
	}
	return *page.eplr.Value
}

// Creates a new instance of the EncryptionProtectorListResultPage type.
func NewEncryptionProtectorListResultPage(cur EncryptionProtectorListResult, getNextPage func(context.Context, EncryptionProtectorListResult) (EncryptionProtectorListResult, error)) EncryptionProtectorListResultPage {
	return EncryptionProtectorListResultPage{
		fn:   getNextPage,
		eplr: cur,
	}
}

// EncryptionProtectorProperties properties for an encryption protector execution.
type EncryptionProtectorProperties struct {
	// Subregion - READ-ONLY; Subregion of the encryption protector.
	Subregion *string `json:"subregion,omitempty"`
	// ServerKeyName - The name of the server key.
	ServerKeyName *string `json:"serverKeyName,omitempty"`
	// ServerKeyType - The encryption protector type like 'ServiceManaged', 'AzureKeyVault'. Possible values include: 'ServerKeyTypeServiceManaged', 'ServerKeyTypeAzureKeyVault'
	ServerKeyType ServerKeyType `json:"serverKeyType,omitempty"`
	// URI - READ-ONLY; The URI of the server key.
	URI *string `json:"uri,omitempty"`
	// Thumbprint - READ-ONLY; Thumbprint of the server key.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// AutoRotationEnabled - Key auto rotation opt-in flag. Either true or false.
	AutoRotationEnabled *bool `json:"autoRotationEnabled,omitempty"`
}

// MarshalJSON is the custom marshaler for EncryptionProtectorProperties.
func (epp EncryptionProtectorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epp.ServerKeyName != nil {
		objectMap["serverKeyName"] = epp.ServerKeyName
	}
	if epp.ServerKeyType != "" {
		objectMap["serverKeyType"] = epp.ServerKeyType
	}
	if epp.AutoRotationEnabled != nil {
		objectMap["autoRotationEnabled"] = epp.AutoRotationEnabled
	}
	return json.Marshal(objectMap)
}

// EncryptionProtectorsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type EncryptionProtectorsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EncryptionProtectorsClient) (EncryptionProtector, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *EncryptionProtectorsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for EncryptionProtectorsCreateOrUpdateFuture.Result.
func (future *EncryptionProtectorsCreateOrUpdateFuture) result(client EncryptionProtectorsClient) (ep EncryptionProtector, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.EncryptionProtectorsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ep.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.EncryptionProtectorsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ep.Response.Response, err = future.GetResult(sender); err == nil && ep.Response.Response.StatusCode != http.StatusNoContent {
		ep, err = client.CreateOrUpdateResponder(ep.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.EncryptionProtectorsCreateOrUpdateFuture", "Result", ep.Response.Response, "Failure responding to request")
		}
	}
	return
}

// EncryptionProtectorsRevalidateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type EncryptionProtectorsRevalidateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EncryptionProtectorsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *EncryptionProtectorsRevalidateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for EncryptionProtectorsRevalidateFuture.Result.
func (future *EncryptionProtectorsRevalidateFuture) result(client EncryptionProtectorsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.EncryptionProtectorsRevalidateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.EncryptionProtectorsRevalidateFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// EndpointCertificate certificate used on an endpoint on the Managed Instance.
type EndpointCertificate struct {
	autorest.Response `json:"-"`
	// EndpointCertificateProperties - Resource properties.
	*EndpointCertificateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EndpointCertificate.
func (ec EndpointCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ec.EndpointCertificateProperties != nil {
		objectMap["properties"] = ec.EndpointCertificateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EndpointCertificate struct.
func (ec *EndpointCertificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var endpointCertificateProperties EndpointCertificateProperties
				err = json.Unmarshal(*v, &endpointCertificateProperties)
				if err != nil {
					return err
				}
				ec.EndpointCertificateProperties = &endpointCertificateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ec.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ec.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ec.Type = &typeVar
			}
		}
	}

	return nil
}

// EndpointCertificateListResult a list of endpoint certificates on the target instance.
type EndpointCertificateListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]EndpointCertificate `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for EndpointCertificateListResult.
func (eclr EndpointCertificateListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// EndpointCertificateListResultIterator provides access to a complete listing of EndpointCertificate
// values.
type EndpointCertificateListResultIterator struct {
	i    int
	page EndpointCertificateListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EndpointCertificateListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EndpointCertificateListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EndpointCertificateListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EndpointCertificateListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EndpointCertificateListResultIterator) Response() EndpointCertificateListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EndpointCertificateListResultIterator) Value() EndpointCertificate {
	if !iter.page.NotDone() {
		return EndpointCertificate{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EndpointCertificateListResultIterator type.
func NewEndpointCertificateListResultIterator(page EndpointCertificateListResultPage) EndpointCertificateListResultIterator {
	return EndpointCertificateListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (eclr EndpointCertificateListResult) IsEmpty() bool {
	return eclr.Value == nil || len(*eclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (eclr EndpointCertificateListResult) hasNextLink() bool {
	return eclr.NextLink != nil && len(*eclr.NextLink) != 0
}

// endpointCertificateListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (eclr EndpointCertificateListResult) endpointCertificateListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !eclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(eclr.NextLink)))
}

// EndpointCertificateListResultPage contains a page of EndpointCertificate values.
type EndpointCertificateListResultPage struct {
	fn   func(context.Context, EndpointCertificateListResult) (EndpointCertificateListResult, error)
	eclr EndpointCertificateListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EndpointCertificateListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EndpointCertificateListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.eclr)
		if err != nil {
			return err
		}
		page.eclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EndpointCertificateListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EndpointCertificateListResultPage) NotDone() bool {
	return !page.eclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EndpointCertificateListResultPage) Response() EndpointCertificateListResult {
	return page.eclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EndpointCertificateListResultPage) Values() []EndpointCertificate {
	if page.eclr.IsEmpty() {
		return nil
	}
	return *page.eclr.Value
}

// Creates a new instance of the EndpointCertificateListResultPage type.
func NewEndpointCertificateListResultPage(cur EndpointCertificateListResult, getNextPage func(context.Context, EndpointCertificateListResult) (EndpointCertificateListResult, error)) EndpointCertificateListResultPage {
	return EndpointCertificateListResultPage{
		fn:   getNextPage,
		eclr: cur,
	}
}

// EndpointCertificateProperties the properties of an endpoint certificate.
type EndpointCertificateProperties struct {
	// PublicBlob - The certificate public blob
	PublicBlob *string `json:"publicBlob,omitempty"`
}

// ExportDatabaseDefinition contains the information necessary to perform export database operation.
type ExportDatabaseDefinition struct {
	// StorageKeyType - Storage key type. Possible values include: 'StorageKeyTypeSharedAccessKey', 'StorageKeyTypeStorageAccessKey'
	StorageKeyType StorageKeyType `json:"storageKeyType,omitempty"`
	// StorageKey - Storage key.
	StorageKey *string `json:"storageKey,omitempty"`
	// StorageURI - Storage Uri.
	StorageURI *string `json:"storageUri,omitempty"`
	// AdministratorLogin - Administrator login name.
	AdministratorLogin *string `json:"administratorLogin,omitempty"`
	// AdministratorLoginPassword - Administrator login password.
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`
	// AuthenticationType - Authentication type.
	AuthenticationType *string `json:"authenticationType,omitempty"`
	// NetworkIsolation - Optional resource information to enable network isolation for request.
	NetworkIsolation *NetworkIsolationSettings `json:"networkIsolation,omitempty"`
}

// ExtendedDatabaseBlobAuditingPolicy an extended database blob auditing policy.
type ExtendedDatabaseBlobAuditingPolicy struct {
	autorest.Response `json:"-"`
	// ExtendedDatabaseBlobAuditingPolicyProperties - Resource properties.
	*ExtendedDatabaseBlobAuditingPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ExtendedDatabaseBlobAuditingPolicy.
func (edbap ExtendedDatabaseBlobAuditingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if edbap.ExtendedDatabaseBlobAuditingPolicyProperties != nil {
		objectMap["properties"] = edbap.ExtendedDatabaseBlobAuditingPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExtendedDatabaseBlobAuditingPolicy struct.
func (edbap *ExtendedDatabaseBlobAuditingPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var extendedDatabaseBlobAuditingPolicyProperties ExtendedDatabaseBlobAuditingPolicyProperties
				err = json.Unmarshal(*v, &extendedDatabaseBlobAuditingPolicyProperties)
				if err != nil {
					return err
				}
				edbap.ExtendedDatabaseBlobAuditingPolicyProperties = &extendedDatabaseBlobAuditingPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				edbap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				edbap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				edbap.Type = &typeVar
			}
		}
	}

	return nil
}

// ExtendedDatabaseBlobAuditingPolicyListResult a list of database extended auditing settings.
type ExtendedDatabaseBlobAuditingPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ExtendedDatabaseBlobAuditingPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ExtendedDatabaseBlobAuditingPolicyListResult.
func (edbaplr ExtendedDatabaseBlobAuditingPolicyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ExtendedDatabaseBlobAuditingPolicyListResultIterator provides access to a complete listing of
// ExtendedDatabaseBlobAuditingPolicy values.
type ExtendedDatabaseBlobAuditingPolicyListResultIterator struct {
	i    int
	page ExtendedDatabaseBlobAuditingPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExtendedDatabaseBlobAuditingPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExtendedDatabaseBlobAuditingPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExtendedDatabaseBlobAuditingPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExtendedDatabaseBlobAuditingPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExtendedDatabaseBlobAuditingPolicyListResultIterator) Response() ExtendedDatabaseBlobAuditingPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExtendedDatabaseBlobAuditingPolicyListResultIterator) Value() ExtendedDatabaseBlobAuditingPolicy {
	if !iter.page.NotDone() {
		return ExtendedDatabaseBlobAuditingPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExtendedDatabaseBlobAuditingPolicyListResultIterator type.
func NewExtendedDatabaseBlobAuditingPolicyListResultIterator(page ExtendedDatabaseBlobAuditingPolicyListResultPage) ExtendedDatabaseBlobAuditingPolicyListResultIterator {
	return ExtendedDatabaseBlobAuditingPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (edbaplr ExtendedDatabaseBlobAuditingPolicyListResult) IsEmpty() bool {
	return edbaplr.Value == nil || len(*edbaplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (edbaplr ExtendedDatabaseBlobAuditingPolicyListResult) hasNextLink() bool {
	return edbaplr.NextLink != nil && len(*edbaplr.NextLink) != 0
}

// extendedDatabaseBlobAuditingPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (edbaplr ExtendedDatabaseBlobAuditingPolicyListResult) extendedDatabaseBlobAuditingPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !edbaplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(edbaplr.NextLink)))
}

// ExtendedDatabaseBlobAuditingPolicyListResultPage contains a page of ExtendedDatabaseBlobAuditingPolicy
// values.
type ExtendedDatabaseBlobAuditingPolicyListResultPage struct {
	fn      func(context.Context, ExtendedDatabaseBlobAuditingPolicyListResult) (ExtendedDatabaseBlobAuditingPolicyListResult, error)
	edbaplr ExtendedDatabaseBlobAuditingPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExtendedDatabaseBlobAuditingPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExtendedDatabaseBlobAuditingPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.edbaplr)
		if err != nil {
			return err
		}
		page.edbaplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExtendedDatabaseBlobAuditingPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExtendedDatabaseBlobAuditingPolicyListResultPage) NotDone() bool {
	return !page.edbaplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExtendedDatabaseBlobAuditingPolicyListResultPage) Response() ExtendedDatabaseBlobAuditingPolicyListResult {
	return page.edbaplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExtendedDatabaseBlobAuditingPolicyListResultPage) Values() []ExtendedDatabaseBlobAuditingPolicy {
	if page.edbaplr.IsEmpty() {
		return nil
	}
	return *page.edbaplr.Value
}

// Creates a new instance of the ExtendedDatabaseBlobAuditingPolicyListResultPage type.
func NewExtendedDatabaseBlobAuditingPolicyListResultPage(cur ExtendedDatabaseBlobAuditingPolicyListResult, getNextPage func(context.Context, ExtendedDatabaseBlobAuditingPolicyListResult) (ExtendedDatabaseBlobAuditingPolicyListResult, error)) ExtendedDatabaseBlobAuditingPolicyListResultPage {
	return ExtendedDatabaseBlobAuditingPolicyListResultPage{
		fn:      getNextPage,
		edbaplr: cur,
	}
}

// ExtendedDatabaseBlobAuditingPolicyProperties properties of an extended database blob auditing policy.
type ExtendedDatabaseBlobAuditingPolicyProperties struct {
	// PredicateExpression - Specifies condition of where clause when creating an audit.
	PredicateExpression *string `json:"predicateExpression,omitempty"`
	// RetentionDays - Specifies the number of days to keep in the audit logs in the storage account.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
	// AuditActionsAndGroups - Specifies the Actions-Groups and Actions to audit.
	//
	// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:
	//
	// BATCH_COMPLETED_GROUP,
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
	// FAILED_DATABASE_AUTHENTICATION_GROUP.
	//
	// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
	//
	// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
	//
	// APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
	// BACKUP_RESTORE_GROUP
	// DATABASE_LOGOUT_GROUP
	// DATABASE_OBJECT_CHANGE_GROUP
	// DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
	// DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
	// DATABASE_OPERATION_GROUP
	// DATABASE_PERMISSION_CHANGE_GROUP
	// DATABASE_PRINCIPAL_CHANGE_GROUP
	// DATABASE_PRINCIPAL_IMPERSONATION_GROUP
	// DATABASE_ROLE_MEMBER_CHANGE_GROUP
	// FAILED_DATABASE_AUTHENTICATION_GROUP
	// SCHEMA_OBJECT_ACCESS_GROUP
	// SCHEMA_OBJECT_CHANGE_GROUP
	// SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
	// SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
	// USER_CHANGE_PASSWORD_GROUP
	// BATCH_STARTED_GROUP
	// BATCH_COMPLETED_GROUP
	// DBCC_GROUP
	// DATABASE_OWNERSHIP_CHANGE_GROUP
	// DATABASE_CHANGE_GROUP
	// LEDGER_OPERATION_GROUP
	//
	// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.
	//
	// For more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
	//
	// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:
	// SELECT
	// UPDATE
	// INSERT
	// DELETE
	// EXECUTE
	// RECEIVE
	// REFERENCES
	//
	// The general form for defining an action to be audited is:
	// {action} ON {object} BY {principal}
	//
	// Note that <object> in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
	//
	// For example:
	// SELECT on dbo.myTable by public
	// SELECT on DATABASE::myDatabase by public
	// SELECT on SCHEMA::mySchema by public
	//
	// For more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
	AuditActionsAndGroups *[]string `json:"auditActionsAndGroups,omitempty"`
	// IsStorageSecondaryKeyInUse - Specifies whether storageAccountAccessKey value is the storage's secondary key.
	IsStorageSecondaryKeyInUse *bool `json:"isStorageSecondaryKeyInUse,omitempty"`
	// IsAzureMonitorTargetEnabled - Specifies whether audit events are sent to Azure Monitor.
	// In order to send the events to Azure Monitor, specify 'State' as 'Enabled' and 'IsAzureMonitorTargetEnabled' as true.
	//
	// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.
	// Note that for server level audit you should use the 'master' database as {databaseName}.
	//
	// Diagnostic Settings URI format:
	// PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	//
	// For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
	// or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
	IsAzureMonitorTargetEnabled *bool `json:"isAzureMonitorTargetEnabled,omitempty"`
	// QueueDelayMs - Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed.
	// The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
	QueueDelayMs *int32 `json:"queueDelayMs,omitempty"`
	// IsManagedIdentityInUse - Specifies whether Managed Identity is used to access blob storage
	IsManagedIdentityInUse *bool `json:"isManagedIdentityInUse,omitempty"`
	// State - Specifies the state of the audit. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required. Possible values include: 'BlobAuditingPolicyStateEnabled', 'BlobAuditingPolicyStateDisabled'
	State BlobAuditingPolicyState `json:"state,omitempty"`
	// StorageEndpoint - Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled is required.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the auditing storage account.
	// If state is Enabled and storageEndpoint is specified, not specifying the storageAccountAccessKey will use SQL server system-assigned managed identity to access the storage.
	// Prerequisites for using managed identity authentication:
	// 1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
	// 2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server identity.
	// For more information, see [Auditing to storage using Managed Identity authentication](https://go.microsoft.com/fwlink/?linkid=2114355)
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// StorageAccountSubscriptionID - Specifies the blob storage subscription Id.
	StorageAccountSubscriptionID *uuid.UUID `json:"storageAccountSubscriptionId,omitempty"`
}

// ExtendedServerBlobAuditingPoliciesCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ExtendedServerBlobAuditingPoliciesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExtendedServerBlobAuditingPoliciesClient) (ExtendedServerBlobAuditingPolicy, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExtendedServerBlobAuditingPoliciesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExtendedServerBlobAuditingPoliciesCreateOrUpdateFuture.Result.
func (future *ExtendedServerBlobAuditingPoliciesCreateOrUpdateFuture) result(client ExtendedServerBlobAuditingPoliciesClient) (esbap ExtendedServerBlobAuditingPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ExtendedServerBlobAuditingPoliciesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		esbap.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ExtendedServerBlobAuditingPoliciesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if esbap.Response.Response, err = future.GetResult(sender); err == nil && esbap.Response.Response.StatusCode != http.StatusNoContent {
		esbap, err = client.CreateOrUpdateResponder(esbap.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ExtendedServerBlobAuditingPoliciesCreateOrUpdateFuture", "Result", esbap.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ExtendedServerBlobAuditingPolicy an extended server blob auditing policy.
type ExtendedServerBlobAuditingPolicy struct {
	autorest.Response `json:"-"`
	// ExtendedServerBlobAuditingPolicyProperties - Resource properties.
	*ExtendedServerBlobAuditingPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ExtendedServerBlobAuditingPolicy.
func (esbap ExtendedServerBlobAuditingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if esbap.ExtendedServerBlobAuditingPolicyProperties != nil {
		objectMap["properties"] = esbap.ExtendedServerBlobAuditingPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExtendedServerBlobAuditingPolicy struct.
func (esbap *ExtendedServerBlobAuditingPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var extendedServerBlobAuditingPolicyProperties ExtendedServerBlobAuditingPolicyProperties
				err = json.Unmarshal(*v, &extendedServerBlobAuditingPolicyProperties)
				if err != nil {
					return err
				}
				esbap.ExtendedServerBlobAuditingPolicyProperties = &extendedServerBlobAuditingPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				esbap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				esbap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				esbap.Type = &typeVar
			}
		}
	}

	return nil
}

// ExtendedServerBlobAuditingPolicyListResult a list of server extended auditing settings.
type ExtendedServerBlobAuditingPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ExtendedServerBlobAuditingPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ExtendedServerBlobAuditingPolicyListResult.
func (esbaplr ExtendedServerBlobAuditingPolicyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ExtendedServerBlobAuditingPolicyListResultIterator provides access to a complete listing of
// ExtendedServerBlobAuditingPolicy values.
type ExtendedServerBlobAuditingPolicyListResultIterator struct {
	i    int
	page ExtendedServerBlobAuditingPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExtendedServerBlobAuditingPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExtendedServerBlobAuditingPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExtendedServerBlobAuditingPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExtendedServerBlobAuditingPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExtendedServerBlobAuditingPolicyListResultIterator) Response() ExtendedServerBlobAuditingPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExtendedServerBlobAuditingPolicyListResultIterator) Value() ExtendedServerBlobAuditingPolicy {
	if !iter.page.NotDone() {
		return ExtendedServerBlobAuditingPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExtendedServerBlobAuditingPolicyListResultIterator type.
func NewExtendedServerBlobAuditingPolicyListResultIterator(page ExtendedServerBlobAuditingPolicyListResultPage) ExtendedServerBlobAuditingPolicyListResultIterator {
	return ExtendedServerBlobAuditingPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (esbaplr ExtendedServerBlobAuditingPolicyListResult) IsEmpty() bool {
	return esbaplr.Value == nil || len(*esbaplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (esbaplr ExtendedServerBlobAuditingPolicyListResult) hasNextLink() bool {
	return esbaplr.NextLink != nil && len(*esbaplr.NextLink) != 0
}

// extendedServerBlobAuditingPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (esbaplr ExtendedServerBlobAuditingPolicyListResult) extendedServerBlobAuditingPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !esbaplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(esbaplr.NextLink)))
}

// ExtendedServerBlobAuditingPolicyListResultPage contains a page of ExtendedServerBlobAuditingPolicy
// values.
type ExtendedServerBlobAuditingPolicyListResultPage struct {
	fn      func(context.Context, ExtendedServerBlobAuditingPolicyListResult) (ExtendedServerBlobAuditingPolicyListResult, error)
	esbaplr ExtendedServerBlobAuditingPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExtendedServerBlobAuditingPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExtendedServerBlobAuditingPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.esbaplr)
		if err != nil {
			return err
		}
		page.esbaplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExtendedServerBlobAuditingPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExtendedServerBlobAuditingPolicyListResultPage) NotDone() bool {
	return !page.esbaplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExtendedServerBlobAuditingPolicyListResultPage) Response() ExtendedServerBlobAuditingPolicyListResult {
	return page.esbaplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExtendedServerBlobAuditingPolicyListResultPage) Values() []ExtendedServerBlobAuditingPolicy {
	if page.esbaplr.IsEmpty() {
		return nil
	}
	return *page.esbaplr.Value
}

// Creates a new instance of the ExtendedServerBlobAuditingPolicyListResultPage type.
func NewExtendedServerBlobAuditingPolicyListResultPage(cur ExtendedServerBlobAuditingPolicyListResult, getNextPage func(context.Context, ExtendedServerBlobAuditingPolicyListResult) (ExtendedServerBlobAuditingPolicyListResult, error)) ExtendedServerBlobAuditingPolicyListResultPage {
	return ExtendedServerBlobAuditingPolicyListResultPage{
		fn:      getNextPage,
		esbaplr: cur,
	}
}

// ExtendedServerBlobAuditingPolicyProperties properties of an extended server blob auditing policy.
type ExtendedServerBlobAuditingPolicyProperties struct {
	// IsDevopsAuditEnabled - Specifies the state of devops audit. If state is Enabled, devops logs will be sent to Azure Monitor.
	// In order to send the events to Azure Monitor, specify 'State' as 'Enabled', 'IsAzureMonitorTargetEnabled' as true and 'IsDevopsAuditEnabled' as true
	//
	// When using REST API to configure auditing, Diagnostic Settings with 'DevOpsOperationsAudit' diagnostic logs category on the master database should also be created.
	//
	// Diagnostic Settings URI format:
	// PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/master/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	//
	// For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
	// or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
	IsDevopsAuditEnabled *bool `json:"isDevopsAuditEnabled,omitempty"`
	// PredicateExpression - Specifies condition of where clause when creating an audit.
	PredicateExpression *string `json:"predicateExpression,omitempty"`
	// RetentionDays - Specifies the number of days to keep in the audit logs in the storage account.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
	// AuditActionsAndGroups - Specifies the Actions-Groups and Actions to audit.
	//
	// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:
	//
	// BATCH_COMPLETED_GROUP,
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
	// FAILED_DATABASE_AUTHENTICATION_GROUP.
	//
	// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
	//
	// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
	//
	// APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
	// BACKUP_RESTORE_GROUP
	// DATABASE_LOGOUT_GROUP
	// DATABASE_OBJECT_CHANGE_GROUP
	// DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
	// DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
	// DATABASE_OPERATION_GROUP
	// DATABASE_PERMISSION_CHANGE_GROUP
	// DATABASE_PRINCIPAL_CHANGE_GROUP
	// DATABASE_PRINCIPAL_IMPERSONATION_GROUP
	// DATABASE_ROLE_MEMBER_CHANGE_GROUP
	// FAILED_DATABASE_AUTHENTICATION_GROUP
	// SCHEMA_OBJECT_ACCESS_GROUP
	// SCHEMA_OBJECT_CHANGE_GROUP
	// SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
	// SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
	// USER_CHANGE_PASSWORD_GROUP
	// BATCH_STARTED_GROUP
	// BATCH_COMPLETED_GROUP
	// DBCC_GROUP
	// DATABASE_OWNERSHIP_CHANGE_GROUP
	// DATABASE_CHANGE_GROUP
	// LEDGER_OPERATION_GROUP
	//
	// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.
	//
	// For more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
	//
	// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:
	// SELECT
	// UPDATE
	// INSERT
	// DELETE
	// EXECUTE
	// RECEIVE
	// REFERENCES
	//
	// The general form for defining an action to be audited is:
	// {action} ON {object} BY {principal}
	//
	// Note that <object> in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
	//
	// For example:
	// SELECT on dbo.myTable by public
	// SELECT on DATABASE::myDatabase by public
	// SELECT on SCHEMA::mySchema by public
	//
	// For more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
	AuditActionsAndGroups *[]string `json:"auditActionsAndGroups,omitempty"`
	// IsStorageSecondaryKeyInUse - Specifies whether storageAccountAccessKey value is the storage's secondary key.
	IsStorageSecondaryKeyInUse *bool `json:"isStorageSecondaryKeyInUse,omitempty"`
	// IsAzureMonitorTargetEnabled - Specifies whether audit events are sent to Azure Monitor.
	// In order to send the events to Azure Monitor, specify 'State' as 'Enabled' and 'IsAzureMonitorTargetEnabled' as true.
	//
	// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.
	// Note that for server level audit you should use the 'master' database as {databaseName}.
	//
	// Diagnostic Settings URI format:
	// PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	//
	// For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
	// or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
	IsAzureMonitorTargetEnabled *bool `json:"isAzureMonitorTargetEnabled,omitempty"`
	// QueueDelayMs - Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed.
	// The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
	QueueDelayMs *int32 `json:"queueDelayMs,omitempty"`
	// IsManagedIdentityInUse - Specifies whether Managed Identity is used to access blob storage
	IsManagedIdentityInUse *bool `json:"isManagedIdentityInUse,omitempty"`
	// State - Specifies the state of the audit. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required. Possible values include: 'BlobAuditingPolicyStateEnabled', 'BlobAuditingPolicyStateDisabled'
	State BlobAuditingPolicyState `json:"state,omitempty"`
	// StorageEndpoint - Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled is required.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the auditing storage account.
	// If state is Enabled and storageEndpoint is specified, not specifying the storageAccountAccessKey will use SQL server system-assigned managed identity to access the storage.
	// Prerequisites for using managed identity authentication:
	// 1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
	// 2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server identity.
	// For more information, see [Auditing to storage using Managed Identity authentication](https://go.microsoft.com/fwlink/?linkid=2114355)
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// StorageAccountSubscriptionID - Specifies the blob storage subscription Id.
	StorageAccountSubscriptionID *uuid.UUID `json:"storageAccountSubscriptionId,omitempty"`
}

// FailoverGroup a failover group.
type FailoverGroup struct {
	autorest.Response `json:"-"`
	// Location - READ-ONLY; Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// FailoverGroupProperties - Resource properties.
	*FailoverGroupProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for FailoverGroup.
func (fg FailoverGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fg.Tags != nil {
		objectMap["tags"] = fg.Tags
	}
	if fg.FailoverGroupProperties != nil {
		objectMap["properties"] = fg.FailoverGroupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FailoverGroup struct.
func (fg *FailoverGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				fg.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				fg.Tags = tags
			}
		case "properties":
			if v != nil {
				var failoverGroupProperties FailoverGroupProperties
				err = json.Unmarshal(*v, &failoverGroupProperties)
				if err != nil {
					return err
				}
				fg.FailoverGroupProperties = &failoverGroupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fg.Type = &typeVar
			}
		}
	}

	return nil
}

// FailoverGroupListResult a list of failover groups.
type FailoverGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]FailoverGroup `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for FailoverGroupListResult.
func (fglr FailoverGroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// FailoverGroupListResultIterator provides access to a complete listing of FailoverGroup values.
type FailoverGroupListResultIterator struct {
	i    int
	page FailoverGroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FailoverGroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FailoverGroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *FailoverGroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FailoverGroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FailoverGroupListResultIterator) Response() FailoverGroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FailoverGroupListResultIterator) Value() FailoverGroup {
	if !iter.page.NotDone() {
		return FailoverGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the FailoverGroupListResultIterator type.
func NewFailoverGroupListResultIterator(page FailoverGroupListResultPage) FailoverGroupListResultIterator {
	return FailoverGroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (fglr FailoverGroupListResult) IsEmpty() bool {
	return fglr.Value == nil || len(*fglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (fglr FailoverGroupListResult) hasNextLink() bool {
	return fglr.NextLink != nil && len(*fglr.NextLink) != 0
}

// failoverGroupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (fglr FailoverGroupListResult) failoverGroupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !fglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(fglr.NextLink)))
}

// FailoverGroupListResultPage contains a page of FailoverGroup values.
type FailoverGroupListResultPage struct {
	fn   func(context.Context, FailoverGroupListResult) (FailoverGroupListResult, error)
	fglr FailoverGroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FailoverGroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FailoverGroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.fglr)
		if err != nil {
			return err
		}
		page.fglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *FailoverGroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FailoverGroupListResultPage) NotDone() bool {
	return !page.fglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FailoverGroupListResultPage) Response() FailoverGroupListResult {
	return page.fglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FailoverGroupListResultPage) Values() []FailoverGroup {
	if page.fglr.IsEmpty() {
		return nil
	}
	return *page.fglr.Value
}

// Creates a new instance of the FailoverGroupListResultPage type.
func NewFailoverGroupListResultPage(cur FailoverGroupListResult, getNextPage func(context.Context, FailoverGroupListResult) (FailoverGroupListResult, error)) FailoverGroupListResultPage {
	return FailoverGroupListResultPage{
		fn:   getNextPage,
		fglr: cur,
	}
}

// FailoverGroupProperties properties of a failover group.
type FailoverGroupProperties struct {
	// ReadWriteEndpoint - Read-write endpoint of the failover group instance.
	ReadWriteEndpoint *FailoverGroupReadWriteEndpoint `json:"readWriteEndpoint,omitempty"`
	// ReadOnlyEndpoint - Read-only endpoint of the failover group instance.
	ReadOnlyEndpoint *FailoverGroupReadOnlyEndpoint `json:"readOnlyEndpoint,omitempty"`
	// ReplicationRole - READ-ONLY; Local replication role of the failover group instance. Possible values include: 'FailoverGroupReplicationRolePrimary', 'FailoverGroupReplicationRoleSecondary'
	ReplicationRole FailoverGroupReplicationRole `json:"replicationRole,omitempty"`
	// ReplicationState - READ-ONLY; Replication state of the failover group instance.
	ReplicationState *string `json:"replicationState,omitempty"`
	// PartnerServers - List of partner server information for the failover group.
	PartnerServers *[]PartnerInfo `json:"partnerServers,omitempty"`
	// Databases - List of databases in the failover group.
	Databases *[]string `json:"databases,omitempty"`
}

// MarshalJSON is the custom marshaler for FailoverGroupProperties.
func (fgp FailoverGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fgp.ReadWriteEndpoint != nil {
		objectMap["readWriteEndpoint"] = fgp.ReadWriteEndpoint
	}
	if fgp.ReadOnlyEndpoint != nil {
		objectMap["readOnlyEndpoint"] = fgp.ReadOnlyEndpoint
	}
	if fgp.PartnerServers != nil {
		objectMap["partnerServers"] = fgp.PartnerServers
	}
	if fgp.Databases != nil {
		objectMap["databases"] = fgp.Databases
	}
	return json.Marshal(objectMap)
}

// FailoverGroupReadOnlyEndpoint read-only endpoint of the failover group instance.
type FailoverGroupReadOnlyEndpoint struct {
	// FailoverPolicy - Failover policy of the read-only endpoint for the failover group. Possible values include: 'ReadOnlyEndpointFailoverPolicyDisabled', 'ReadOnlyEndpointFailoverPolicyEnabled'
	FailoverPolicy ReadOnlyEndpointFailoverPolicy `json:"failoverPolicy,omitempty"`
}

// FailoverGroupReadWriteEndpoint read-write endpoint of the failover group instance.
type FailoverGroupReadWriteEndpoint struct {
	// FailoverPolicy - Failover policy of the read-write endpoint for the failover group. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required. Possible values include: 'ReadWriteEndpointFailoverPolicyManual', 'ReadWriteEndpointFailoverPolicyAutomatic'
	FailoverPolicy ReadWriteEndpointFailoverPolicy `json:"failoverPolicy,omitempty"`
	// FailoverWithDataLossGracePeriodMinutes - Grace period before failover with data loss is attempted for the read-write endpoint. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
	FailoverWithDataLossGracePeriodMinutes *int32 `json:"failoverWithDataLossGracePeriodMinutes,omitempty"`
}

// FailoverGroupsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type FailoverGroupsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FailoverGroupsClient) (FailoverGroup, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *FailoverGroupsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for FailoverGroupsCreateOrUpdateFuture.Result.
func (future *FailoverGroupsCreateOrUpdateFuture) result(client FailoverGroupsClient) (fg FailoverGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.FailoverGroupsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		fg.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.FailoverGroupsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if fg.Response.Response, err = future.GetResult(sender); err == nil && fg.Response.Response.StatusCode != http.StatusNoContent {
		fg, err = client.CreateOrUpdateResponder(fg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.FailoverGroupsCreateOrUpdateFuture", "Result", fg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// FailoverGroupsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type FailoverGroupsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FailoverGroupsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *FailoverGroupsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for FailoverGroupsDeleteFuture.Result.
func (future *FailoverGroupsDeleteFuture) result(client FailoverGroupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.FailoverGroupsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.FailoverGroupsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// FailoverGroupsFailoverFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type FailoverGroupsFailoverFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FailoverGroupsClient) (FailoverGroup, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *FailoverGroupsFailoverFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for FailoverGroupsFailoverFuture.Result.
func (future *FailoverGroupsFailoverFuture) result(client FailoverGroupsClient) (fg FailoverGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.FailoverGroupsFailoverFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		fg.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.FailoverGroupsFailoverFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if fg.Response.Response, err = future.GetResult(sender); err == nil && fg.Response.Response.StatusCode != http.StatusNoContent {
		fg, err = client.FailoverResponder(fg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.FailoverGroupsFailoverFuture", "Result", fg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// FailoverGroupsForceFailoverAllowDataLossFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type FailoverGroupsForceFailoverAllowDataLossFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FailoverGroupsClient) (FailoverGroup, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *FailoverGroupsForceFailoverAllowDataLossFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for FailoverGroupsForceFailoverAllowDataLossFuture.Result.
func (future *FailoverGroupsForceFailoverAllowDataLossFuture) result(client FailoverGroupsClient) (fg FailoverGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.FailoverGroupsForceFailoverAllowDataLossFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		fg.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.FailoverGroupsForceFailoverAllowDataLossFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if fg.Response.Response, err = future.GetResult(sender); err == nil && fg.Response.Response.StatusCode != http.StatusNoContent {
		fg, err = client.ForceFailoverAllowDataLossResponder(fg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.FailoverGroupsForceFailoverAllowDataLossFuture", "Result", fg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// FailoverGroupsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type FailoverGroupsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FailoverGroupsClient) (FailoverGroup, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *FailoverGroupsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for FailoverGroupsUpdateFuture.Result.
func (future *FailoverGroupsUpdateFuture) result(client FailoverGroupsClient) (fg FailoverGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.FailoverGroupsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		fg.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.FailoverGroupsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if fg.Response.Response, err = future.GetResult(sender); err == nil && fg.Response.Response.StatusCode != http.StatusNoContent {
		fg, err = client.UpdateResponder(fg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.FailoverGroupsUpdateFuture", "Result", fg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// FailoverGroupUpdate a failover group update request.
type FailoverGroupUpdate struct {
	// FailoverGroupUpdateProperties - Resource properties.
	*FailoverGroupUpdateProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for FailoverGroupUpdate.
func (fgu FailoverGroupUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fgu.FailoverGroupUpdateProperties != nil {
		objectMap["properties"] = fgu.FailoverGroupUpdateProperties
	}
	if fgu.Tags != nil {
		objectMap["tags"] = fgu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FailoverGroupUpdate struct.
func (fgu *FailoverGroupUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var failoverGroupUpdateProperties FailoverGroupUpdateProperties
				err = json.Unmarshal(*v, &failoverGroupUpdateProperties)
				if err != nil {
					return err
				}
				fgu.FailoverGroupUpdateProperties = &failoverGroupUpdateProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				fgu.Tags = tags
			}
		}
	}

	return nil
}

// FailoverGroupUpdateProperties properties of a failover group update.
type FailoverGroupUpdateProperties struct {
	// ReadWriteEndpoint - Read-write endpoint of the failover group instance.
	ReadWriteEndpoint *FailoverGroupReadWriteEndpoint `json:"readWriteEndpoint,omitempty"`
	// ReadOnlyEndpoint - Read-only endpoint of the failover group instance.
	ReadOnlyEndpoint *FailoverGroupReadOnlyEndpoint `json:"readOnlyEndpoint,omitempty"`
	// Databases - List of databases in the failover group.
	Databases *[]string `json:"databases,omitempty"`
}

// FirewallRule a server firewall rule.
type FirewallRule struct {
	autorest.Response `json:"-"`
	// ServerFirewallRuleProperties - Resource properties.
	*ServerFirewallRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for FirewallRule.
func (fr FirewallRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fr.ServerFirewallRuleProperties != nil {
		objectMap["properties"] = fr.ServerFirewallRuleProperties
	}
	if fr.Name != nil {
		objectMap["name"] = fr.Name
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FirewallRule struct.
func (fr *FirewallRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serverFirewallRuleProperties ServerFirewallRuleProperties
				err = json.Unmarshal(*v, &serverFirewallRuleProperties)
				if err != nil {
					return err
				}
				fr.ServerFirewallRuleProperties = &serverFirewallRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fr.Type = &typeVar
			}
		}
	}

	return nil
}

// FirewallRuleList a list of server firewall rules.
type FirewallRuleList struct {
	Values *[]FirewallRule `json:"values,omitempty"`
}

// FirewallRuleListResult the response to a list firewall rules request
type FirewallRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]FirewallRule `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for FirewallRuleListResult.
func (frlr FirewallRuleListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// FirewallRuleListResultIterator provides access to a complete listing of FirewallRule values.
type FirewallRuleListResultIterator struct {
	i    int
	page FirewallRuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FirewallRuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FirewallRuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *FirewallRuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FirewallRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FirewallRuleListResultIterator) Response() FirewallRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FirewallRuleListResultIterator) Value() FirewallRule {
	if !iter.page.NotDone() {
		return FirewallRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the FirewallRuleListResultIterator type.
func NewFirewallRuleListResultIterator(page FirewallRuleListResultPage) FirewallRuleListResultIterator {
	return FirewallRuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (frlr FirewallRuleListResult) IsEmpty() bool {
	return frlr.Value == nil || len(*frlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (frlr FirewallRuleListResult) hasNextLink() bool {
	return frlr.NextLink != nil && len(*frlr.NextLink) != 0
}

// firewallRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (frlr FirewallRuleListResult) firewallRuleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !frlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(frlr.NextLink)))
}

// FirewallRuleListResultPage contains a page of FirewallRule values.
type FirewallRuleListResultPage struct {
	fn   func(context.Context, FirewallRuleListResult) (FirewallRuleListResult, error)
	frlr FirewallRuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FirewallRuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FirewallRuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.frlr)
		if err != nil {
			return err
		}
		page.frlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *FirewallRuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FirewallRuleListResultPage) NotDone() bool {
	return !page.frlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FirewallRuleListResultPage) Response() FirewallRuleListResult {
	return page.frlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FirewallRuleListResultPage) Values() []FirewallRule {
	if page.frlr.IsEmpty() {
		return nil
	}
	return *page.frlr.Value
}

// Creates a new instance of the FirewallRuleListResultPage type.
func NewFirewallRuleListResultPage(cur FirewallRuleListResult, getNextPage func(context.Context, FirewallRuleListResult) (FirewallRuleListResult, error)) FirewallRuleListResultPage {
	return FirewallRuleListResultPage{
		fn:   getNextPage,
		frlr: cur,
	}
}

// GeoBackupPolicy a database geo backup policy.
type GeoBackupPolicy struct {
	autorest.Response `json:"-"`
	// GeoBackupPolicyProperties - The properties of the geo backup policy.
	*GeoBackupPolicyProperties `json:"properties,omitempty"`
	// Kind - READ-ONLY; Kind of geo backup policy.  This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// Location - READ-ONLY; Backup policy location.
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for GeoBackupPolicy.
func (gbp GeoBackupPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gbp.GeoBackupPolicyProperties != nil {
		objectMap["properties"] = gbp.GeoBackupPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GeoBackupPolicy struct.
func (gbp *GeoBackupPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var geoBackupPolicyProperties GeoBackupPolicyProperties
				err = json.Unmarshal(*v, &geoBackupPolicyProperties)
				if err != nil {
					return err
				}
				gbp.GeoBackupPolicyProperties = &geoBackupPolicyProperties
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				gbp.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				gbp.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gbp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gbp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gbp.Type = &typeVar
			}
		}
	}

	return nil
}

// GeoBackupPolicyListResult the response to a list geo backup policies request.
type GeoBackupPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of geo backup policies.
	Value *[]GeoBackupPolicy `json:"value,omitempty"`
}

// GeoBackupPolicyProperties the properties of the geo backup policy.
type GeoBackupPolicyProperties struct {
	// State - The state of the geo backup policy. Possible values include: 'GeoBackupPolicyStateDisabled', 'GeoBackupPolicyStateEnabled'
	State GeoBackupPolicyState `json:"state,omitempty"`
	// StorageType - READ-ONLY; The storage type of the geo backup policy.
	StorageType *string `json:"storageType,omitempty"`
}

// MarshalJSON is the custom marshaler for GeoBackupPolicyProperties.
func (gbpp GeoBackupPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gbpp.State != "" {
		objectMap["state"] = gbpp.State
	}
	return json.Marshal(objectMap)
}

// ImportExistingDatabaseDefinition contains the information necessary to perform import operation for
// existing database.
type ImportExistingDatabaseDefinition struct {
	// StorageKeyType - Storage key type. Possible values include: 'StorageKeyTypeSharedAccessKey', 'StorageKeyTypeStorageAccessKey'
	StorageKeyType StorageKeyType `json:"storageKeyType,omitempty"`
	// StorageKey - Storage key.
	StorageKey *string `json:"storageKey,omitempty"`
	// StorageURI - Storage Uri.
	StorageURI *string `json:"storageUri,omitempty"`
	// AdministratorLogin - Administrator login name.
	AdministratorLogin *string `json:"administratorLogin,omitempty"`
	// AdministratorLoginPassword - Administrator login password.
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`
	// AuthenticationType - Authentication type.
	AuthenticationType *string `json:"authenticationType,omitempty"`
	// NetworkIsolation - Optional resource information to enable network isolation for request.
	NetworkIsolation *NetworkIsolationSettings `json:"networkIsolation,omitempty"`
}

// ImportExportExtensionsOperationListResult import export operation extensions list.
type ImportExportExtensionsOperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ImportExportExtensionsOperationResult `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ImportExportExtensionsOperationListResult.
func (ieeolr ImportExportExtensionsOperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ImportExportExtensionsOperationListResultIterator provides access to a complete listing of
// ImportExportExtensionsOperationResult values.
type ImportExportExtensionsOperationListResultIterator struct {
	i    int
	page ImportExportExtensionsOperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ImportExportExtensionsOperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ImportExportExtensionsOperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ImportExportExtensionsOperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ImportExportExtensionsOperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ImportExportExtensionsOperationListResultIterator) Response() ImportExportExtensionsOperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ImportExportExtensionsOperationListResultIterator) Value() ImportExportExtensionsOperationResult {
	if !iter.page.NotDone() {
		return ImportExportExtensionsOperationResult{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ImportExportExtensionsOperationListResultIterator type.
func NewImportExportExtensionsOperationListResultIterator(page ImportExportExtensionsOperationListResultPage) ImportExportExtensionsOperationListResultIterator {
	return ImportExportExtensionsOperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ieeolr ImportExportExtensionsOperationListResult) IsEmpty() bool {
	return ieeolr.Value == nil || len(*ieeolr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ieeolr ImportExportExtensionsOperationListResult) hasNextLink() bool {
	return ieeolr.NextLink != nil && len(*ieeolr.NextLink) != 0
}

// importExportExtensionsOperationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ieeolr ImportExportExtensionsOperationListResult) importExportExtensionsOperationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ieeolr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ieeolr.NextLink)))
}

// ImportExportExtensionsOperationListResultPage contains a page of ImportExportExtensionsOperationResult
// values.
type ImportExportExtensionsOperationListResultPage struct {
	fn     func(context.Context, ImportExportExtensionsOperationListResult) (ImportExportExtensionsOperationListResult, error)
	ieeolr ImportExportExtensionsOperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ImportExportExtensionsOperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ImportExportExtensionsOperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ieeolr)
		if err != nil {
			return err
		}
		page.ieeolr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ImportExportExtensionsOperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ImportExportExtensionsOperationListResultPage) NotDone() bool {
	return !page.ieeolr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ImportExportExtensionsOperationListResultPage) Response() ImportExportExtensionsOperationListResult {
	return page.ieeolr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ImportExportExtensionsOperationListResultPage) Values() []ImportExportExtensionsOperationResult {
	if page.ieeolr.IsEmpty() {
		return nil
	}
	return *page.ieeolr.Value
}

// Creates a new instance of the ImportExportExtensionsOperationListResultPage type.
func NewImportExportExtensionsOperationListResultPage(cur ImportExportExtensionsOperationListResult, getNextPage func(context.Context, ImportExportExtensionsOperationListResult) (ImportExportExtensionsOperationListResult, error)) ImportExportExtensionsOperationListResultPage {
	return ImportExportExtensionsOperationListResultPage{
		fn:     getNextPage,
		ieeolr: cur,
	}
}

// ImportExportExtensionsOperationResult an Extension operation result resource.
type ImportExportExtensionsOperationResult struct {
	autorest.Response `json:"-"`
	// ImportExportExtensionsOperationResultProperties - Resource properties.
	*ImportExportExtensionsOperationResultProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ImportExportExtensionsOperationResult.
func (ieeor ImportExportExtensionsOperationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ieeor.ImportExportExtensionsOperationResultProperties != nil {
		objectMap["properties"] = ieeor.ImportExportExtensionsOperationResultProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ImportExportExtensionsOperationResult struct.
func (ieeor *ImportExportExtensionsOperationResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var importExportExtensionsOperationResultProperties ImportExportExtensionsOperationResultProperties
				err = json.Unmarshal(*v, &importExportExtensionsOperationResultProperties)
				if err != nil {
					return err
				}
				ieeor.ImportExportExtensionsOperationResultProperties = &importExportExtensionsOperationResultProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ieeor.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ieeor.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ieeor.Type = &typeVar
			}
		}
	}

	return nil
}

// ImportExportExtensionsOperationResultProperties contains the operation result properties for
// import/export operation.
type ImportExportExtensionsOperationResultProperties struct {
	// RequestID - READ-ONLY; Request Id.
	RequestID *uuid.UUID `json:"requestId,omitempty"`
	// RequestType - READ-ONLY; Request type.
	RequestType *string `json:"requestType,omitempty"`
	// LastModifiedTime - READ-ONLY; Last modified time.
	LastModifiedTime *string `json:"lastModifiedTime,omitempty"`
	// ServerName - READ-ONLY; Server name.
	ServerName *string `json:"serverName,omitempty"`
	// DatabaseName - READ-ONLY; Database name.
	DatabaseName *string `json:"databaseName,omitempty"`
	// Status - READ-ONLY; Operation status.
	Status *string `json:"status,omitempty"`
	// ErrorMessage - READ-ONLY; Error message.
	ErrorMessage *string `json:"errorMessage,omitempty"`
}

// MarshalJSON is the custom marshaler for ImportExportExtensionsOperationResultProperties.
func (ieeorp ImportExportExtensionsOperationResultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ImportExportOperationResult an ImportExport operation result resource.
type ImportExportOperationResult struct {
	autorest.Response `json:"-"`
	// ImportExportOperationResultProperties - Resource properties.
	*ImportExportOperationResultProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ImportExportOperationResult.
func (ieor ImportExportOperationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ieor.ImportExportOperationResultProperties != nil {
		objectMap["properties"] = ieor.ImportExportOperationResultProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ImportExportOperationResult struct.
func (ieor *ImportExportOperationResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var importExportOperationResultProperties ImportExportOperationResultProperties
				err = json.Unmarshal(*v, &importExportOperationResultProperties)
				if err != nil {
					return err
				}
				ieor.ImportExportOperationResultProperties = &importExportOperationResultProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ieor.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ieor.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ieor.Type = &typeVar
			}
		}
	}

	return nil
}

// ImportExportOperationResultProperties contains the operation result properties for import/export
// operation.
type ImportExportOperationResultProperties struct {
	// RequestID - READ-ONLY; Request Id.
	RequestID *uuid.UUID `json:"requestId,omitempty"`
	// RequestType - READ-ONLY; Request type.
	RequestType *string `json:"requestType,omitempty"`
	// QueuedTime - READ-ONLY; Queued time.
	QueuedTime *string `json:"queuedTime,omitempty"`
	// LastModifiedTime - READ-ONLY; Last modified time.
	LastModifiedTime *string `json:"lastModifiedTime,omitempty"`
	// BlobURI - READ-ONLY; Blob Uri.
	BlobURI *string `json:"blobUri,omitempty"`
	// ServerName - READ-ONLY; Server name.
	ServerName *string `json:"serverName,omitempty"`
	// DatabaseName - READ-ONLY; Database name.
	DatabaseName *string `json:"databaseName,omitempty"`
	// Status - READ-ONLY; Operation status.
	Status *string `json:"status,omitempty"`
	// ErrorMessage - READ-ONLY; Error message.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// PrivateEndpointConnections - READ-ONLY; Gets the status of private endpoints associated with this request.
	PrivateEndpointConnections *[]PrivateEndpointConnectionRequestStatus `json:"privateEndpointConnections,omitempty"`
}

// MarshalJSON is the custom marshaler for ImportExportOperationResultProperties.
func (ieorp ImportExportOperationResultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ImportNewDatabaseDefinition contains the information necessary to perform import operation for new
// database.
type ImportNewDatabaseDefinition struct {
	// DatabaseName - Name of the import database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// Edition - Edition of the import database.
	Edition *string `json:"edition,omitempty"`
	// ServiceObjectiveName - Service level objective name of the import database.
	ServiceObjectiveName *string `json:"serviceObjectiveName,omitempty"`
	// MaxSizeBytes - Max size in bytes for the import database.
	MaxSizeBytes *string `json:"maxSizeBytes,omitempty"`
	// StorageKeyType - Storage key type. Possible values include: 'StorageKeyTypeSharedAccessKey', 'StorageKeyTypeStorageAccessKey'
	StorageKeyType StorageKeyType `json:"storageKeyType,omitempty"`
	// StorageKey - Storage key.
	StorageKey *string `json:"storageKey,omitempty"`
	// StorageURI - Storage Uri.
	StorageURI *string `json:"storageUri,omitempty"`
	// AdministratorLogin - Administrator login name.
	AdministratorLogin *string `json:"administratorLogin,omitempty"`
	// AdministratorLoginPassword - Administrator login password.
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`
	// AuthenticationType - Authentication type.
	AuthenticationType *string `json:"authenticationType,omitempty"`
	// NetworkIsolation - Optional resource information to enable network isolation for request.
	NetworkIsolation *NetworkIsolationSettings `json:"networkIsolation,omitempty"`
}

// InstanceFailoverGroup an instance failover group.
type InstanceFailoverGroup struct {
	autorest.Response `json:"-"`
	// InstanceFailoverGroupProperties - Resource properties.
	*InstanceFailoverGroupProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for InstanceFailoverGroup.
func (ifg InstanceFailoverGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ifg.InstanceFailoverGroupProperties != nil {
		objectMap["properties"] = ifg.InstanceFailoverGroupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InstanceFailoverGroup struct.
func (ifg *InstanceFailoverGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var instanceFailoverGroupProperties InstanceFailoverGroupProperties
				err = json.Unmarshal(*v, &instanceFailoverGroupProperties)
				if err != nil {
					return err
				}
				ifg.InstanceFailoverGroupProperties = &instanceFailoverGroupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ifg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ifg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ifg.Type = &typeVar
			}
		}
	}

	return nil
}

// InstanceFailoverGroupListResult a list of instance failover groups.
type InstanceFailoverGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]InstanceFailoverGroup `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for InstanceFailoverGroupListResult.
func (ifglr InstanceFailoverGroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// InstanceFailoverGroupListResultIterator provides access to a complete listing of InstanceFailoverGroup
// values.
type InstanceFailoverGroupListResultIterator struct {
	i    int
	page InstanceFailoverGroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InstanceFailoverGroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InstanceFailoverGroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *InstanceFailoverGroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InstanceFailoverGroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InstanceFailoverGroupListResultIterator) Response() InstanceFailoverGroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InstanceFailoverGroupListResultIterator) Value() InstanceFailoverGroup {
	if !iter.page.NotDone() {
		return InstanceFailoverGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the InstanceFailoverGroupListResultIterator type.
func NewInstanceFailoverGroupListResultIterator(page InstanceFailoverGroupListResultPage) InstanceFailoverGroupListResultIterator {
	return InstanceFailoverGroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ifglr InstanceFailoverGroupListResult) IsEmpty() bool {
	return ifglr.Value == nil || len(*ifglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ifglr InstanceFailoverGroupListResult) hasNextLink() bool {
	return ifglr.NextLink != nil && len(*ifglr.NextLink) != 0
}

// instanceFailoverGroupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ifglr InstanceFailoverGroupListResult) instanceFailoverGroupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ifglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ifglr.NextLink)))
}

// InstanceFailoverGroupListResultPage contains a page of InstanceFailoverGroup values.
type InstanceFailoverGroupListResultPage struct {
	fn    func(context.Context, InstanceFailoverGroupListResult) (InstanceFailoverGroupListResult, error)
	ifglr InstanceFailoverGroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InstanceFailoverGroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InstanceFailoverGroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ifglr)
		if err != nil {
			return err
		}
		page.ifglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *InstanceFailoverGroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InstanceFailoverGroupListResultPage) NotDone() bool {
	return !page.ifglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InstanceFailoverGroupListResultPage) Response() InstanceFailoverGroupListResult {
	return page.ifglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InstanceFailoverGroupListResultPage) Values() []InstanceFailoverGroup {
	if page.ifglr.IsEmpty() {
		return nil
	}
	return *page.ifglr.Value
}

// Creates a new instance of the InstanceFailoverGroupListResultPage type.
func NewInstanceFailoverGroupListResultPage(cur InstanceFailoverGroupListResult, getNextPage func(context.Context, InstanceFailoverGroupListResult) (InstanceFailoverGroupListResult, error)) InstanceFailoverGroupListResultPage {
	return InstanceFailoverGroupListResultPage{
		fn:    getNextPage,
		ifglr: cur,
	}
}

// InstanceFailoverGroupProperties properties of a instance failover group.
type InstanceFailoverGroupProperties struct {
	// ReadWriteEndpoint - Read-write endpoint of the failover group instance.
	ReadWriteEndpoint *InstanceFailoverGroupReadWriteEndpoint `json:"readWriteEndpoint,omitempty"`
	// ReadOnlyEndpoint - Read-only endpoint of the failover group instance.
	ReadOnlyEndpoint *InstanceFailoverGroupReadOnlyEndpoint `json:"readOnlyEndpoint,omitempty"`
	// ReplicationRole - READ-ONLY; Local replication role of the failover group instance. Possible values include: 'InstanceFailoverGroupReplicationRolePrimary', 'InstanceFailoverGroupReplicationRoleSecondary'
	ReplicationRole InstanceFailoverGroupReplicationRole `json:"replicationRole,omitempty"`
	// ReplicationState - READ-ONLY; Replication state of the failover group instance.
	ReplicationState *string `json:"replicationState,omitempty"`
	// PartnerRegions - Partner region information for the failover group.
	PartnerRegions *[]PartnerRegionInfo `json:"partnerRegions,omitempty"`
	// ManagedInstancePairs - List of managed instance pairs in the failover group.
	ManagedInstancePairs *[]ManagedInstancePairInfo `json:"managedInstancePairs,omitempty"`
}

// MarshalJSON is the custom marshaler for InstanceFailoverGroupProperties.
func (ifgp InstanceFailoverGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ifgp.ReadWriteEndpoint != nil {
		objectMap["readWriteEndpoint"] = ifgp.ReadWriteEndpoint
	}
	if ifgp.ReadOnlyEndpoint != nil {
		objectMap["readOnlyEndpoint"] = ifgp.ReadOnlyEndpoint
	}
	if ifgp.PartnerRegions != nil {
		objectMap["partnerRegions"] = ifgp.PartnerRegions
	}
	if ifgp.ManagedInstancePairs != nil {
		objectMap["managedInstancePairs"] = ifgp.ManagedInstancePairs
	}
	return json.Marshal(objectMap)
}

// InstanceFailoverGroupReadOnlyEndpoint read-only endpoint of the failover group instance.
type InstanceFailoverGroupReadOnlyEndpoint struct {
	// FailoverPolicy - Failover policy of the read-only endpoint for the failover group. Possible values include: 'ReadOnlyEndpointFailoverPolicyDisabled', 'ReadOnlyEndpointFailoverPolicyEnabled'
	FailoverPolicy ReadOnlyEndpointFailoverPolicy `json:"failoverPolicy,omitempty"`
}

// InstanceFailoverGroupReadWriteEndpoint read-write endpoint of the failover group instance.
type InstanceFailoverGroupReadWriteEndpoint struct {
	// FailoverPolicy - Failover policy of the read-write endpoint for the failover group. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required. Possible values include: 'ReadWriteEndpointFailoverPolicyManual', 'ReadWriteEndpointFailoverPolicyAutomatic'
	FailoverPolicy ReadWriteEndpointFailoverPolicy `json:"failoverPolicy,omitempty"`
	// FailoverWithDataLossGracePeriodMinutes - Grace period before failover with data loss is attempted for the read-write endpoint. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
	FailoverWithDataLossGracePeriodMinutes *int32 `json:"failoverWithDataLossGracePeriodMinutes,omitempty"`
}

// InstanceFailoverGroupsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type InstanceFailoverGroupsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InstanceFailoverGroupsClient) (InstanceFailoverGroup, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *InstanceFailoverGroupsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for InstanceFailoverGroupsCreateOrUpdateFuture.Result.
func (future *InstanceFailoverGroupsCreateOrUpdateFuture) result(client InstanceFailoverGroupsClient) (ifg InstanceFailoverGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.InstanceFailoverGroupsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ifg.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.InstanceFailoverGroupsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ifg.Response.Response, err = future.GetResult(sender); err == nil && ifg.Response.Response.StatusCode != http.StatusNoContent {
		ifg, err = client.CreateOrUpdateResponder(ifg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.InstanceFailoverGroupsCreateOrUpdateFuture", "Result", ifg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// InstanceFailoverGroupsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type InstanceFailoverGroupsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InstanceFailoverGroupsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *InstanceFailoverGroupsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for InstanceFailoverGroupsDeleteFuture.Result.
func (future *InstanceFailoverGroupsDeleteFuture) result(client InstanceFailoverGroupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.InstanceFailoverGroupsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.InstanceFailoverGroupsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// InstanceFailoverGroupsFailoverFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type InstanceFailoverGroupsFailoverFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InstanceFailoverGroupsClient) (InstanceFailoverGroup, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *InstanceFailoverGroupsFailoverFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for InstanceFailoverGroupsFailoverFuture.Result.
func (future *InstanceFailoverGroupsFailoverFuture) result(client InstanceFailoverGroupsClient) (ifg InstanceFailoverGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.InstanceFailoverGroupsFailoverFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ifg.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.InstanceFailoverGroupsFailoverFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ifg.Response.Response, err = future.GetResult(sender); err == nil && ifg.Response.Response.StatusCode != http.StatusNoContent {
		ifg, err = client.FailoverResponder(ifg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.InstanceFailoverGroupsFailoverFuture", "Result", ifg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// InstanceFailoverGroupsForceFailoverAllowDataLossFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type InstanceFailoverGroupsForceFailoverAllowDataLossFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InstanceFailoverGroupsClient) (InstanceFailoverGroup, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *InstanceFailoverGroupsForceFailoverAllowDataLossFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for InstanceFailoverGroupsForceFailoverAllowDataLossFuture.Result.
func (future *InstanceFailoverGroupsForceFailoverAllowDataLossFuture) result(client InstanceFailoverGroupsClient) (ifg InstanceFailoverGroup, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.InstanceFailoverGroupsForceFailoverAllowDataLossFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ifg.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.InstanceFailoverGroupsForceFailoverAllowDataLossFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ifg.Response.Response, err = future.GetResult(sender); err == nil && ifg.Response.Response.StatusCode != http.StatusNoContent {
		ifg, err = client.ForceFailoverAllowDataLossResponder(ifg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.InstanceFailoverGroupsForceFailoverAllowDataLossFuture", "Result", ifg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// InstancePool an Azure SQL instance pool.
type InstancePool struct {
	autorest.Response `json:"-"`
	// Sku - The name and tier of the SKU.
	Sku *Sku `json:"sku,omitempty"`
	// InstancePoolProperties - Resource properties.
	*InstancePoolProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for InstancePool.
func (IP InstancePool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if IP.Sku != nil {
		objectMap["sku"] = IP.Sku
	}
	if IP.InstancePoolProperties != nil {
		objectMap["properties"] = IP.InstancePoolProperties
	}
	if IP.Location != nil {
		objectMap["location"] = IP.Location
	}
	if IP.Tags != nil {
		objectMap["tags"] = IP.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InstancePool struct.
func (IP *InstancePool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				IP.Sku = &sku
			}
		case "properties":
			if v != nil {
				var instancePoolProperties InstancePoolProperties
				err = json.Unmarshal(*v, &instancePoolProperties)
				if err != nil {
					return err
				}
				IP.InstancePoolProperties = &instancePoolProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				IP.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				IP.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				IP.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				IP.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				IP.Type = &typeVar
			}
		}
	}

	return nil
}

// InstancePoolEditionCapability the instance pool capability
type InstancePoolEditionCapability struct {
	// Name - READ-ONLY; The instance pool version name.
	Name *string `json:"name,omitempty"`
	// SupportedFamilies - READ-ONLY; The supported families.
	SupportedFamilies *[]InstancePoolFamilyCapability `json:"supportedFamilies,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for InstancePoolEditionCapability.
func (ipec InstancePoolEditionCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ipec.Reason != nil {
		objectMap["reason"] = ipec.Reason
	}
	return json.Marshal(objectMap)
}

// InstancePoolFamilyCapability the instance pool family capability.
type InstancePoolFamilyCapability struct {
	// Name - READ-ONLY; Family name.
	Name *string `json:"name,omitempty"`
	// SupportedLicenseTypes - READ-ONLY; List of supported license types.
	SupportedLicenseTypes *[]LicenseTypeCapability `json:"supportedLicenseTypes,omitempty"`
	// SupportedVcoresValues - READ-ONLY; List of supported virtual cores values.
	SupportedVcoresValues *[]InstancePoolVcoresCapability `json:"supportedVcoresValues,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for InstancePoolFamilyCapability.
func (ipfc InstancePoolFamilyCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ipfc.Reason != nil {
		objectMap["reason"] = ipfc.Reason
	}
	return json.Marshal(objectMap)
}

// InstancePoolListResult a list of Azure SQL instance pools.
type InstancePoolListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]InstancePool `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for InstancePoolListResult.
func (iplr InstancePoolListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// InstancePoolListResultIterator provides access to a complete listing of InstancePool values.
type InstancePoolListResultIterator struct {
	i    int
	page InstancePoolListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InstancePoolListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InstancePoolListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *InstancePoolListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InstancePoolListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InstancePoolListResultIterator) Response() InstancePoolListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InstancePoolListResultIterator) Value() InstancePool {
	if !iter.page.NotDone() {
		return InstancePool{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the InstancePoolListResultIterator type.
func NewInstancePoolListResultIterator(page InstancePoolListResultPage) InstancePoolListResultIterator {
	return InstancePoolListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (iplr InstancePoolListResult) IsEmpty() bool {
	return iplr.Value == nil || len(*iplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (iplr InstancePoolListResult) hasNextLink() bool {
	return iplr.NextLink != nil && len(*iplr.NextLink) != 0
}

// instancePoolListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (iplr InstancePoolListResult) instancePoolListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !iplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(iplr.NextLink)))
}

// InstancePoolListResultPage contains a page of InstancePool values.
type InstancePoolListResultPage struct {
	fn   func(context.Context, InstancePoolListResult) (InstancePoolListResult, error)
	iplr InstancePoolListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InstancePoolListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InstancePoolListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.iplr)
		if err != nil {
			return err
		}
		page.iplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *InstancePoolListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InstancePoolListResultPage) NotDone() bool {
	return !page.iplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InstancePoolListResultPage) Response() InstancePoolListResult {
	return page.iplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InstancePoolListResultPage) Values() []InstancePool {
	if page.iplr.IsEmpty() {
		return nil
	}
	return *page.iplr.Value
}

// Creates a new instance of the InstancePoolListResultPage type.
func NewInstancePoolListResultPage(cur InstancePoolListResult, getNextPage func(context.Context, InstancePoolListResult) (InstancePoolListResult, error)) InstancePoolListResultPage {
	return InstancePoolListResultPage{
		fn:   getNextPage,
		iplr: cur,
	}
}

// InstancePoolProperties properties of an instance pool.
type InstancePoolProperties struct {
	// SubnetID - Resource ID of the subnet to place this instance pool in.
	SubnetID *string `json:"subnetId,omitempty"`
	// VCores - Count of vCores belonging to this instance pool.
	VCores *int32 `json:"vCores,omitempty"`
	// LicenseType - The license type. Possible values are 'LicenseIncluded' (price for SQL license is included) and 'BasePrice' (without SQL license price). Possible values include: 'InstancePoolLicenseTypeLicenseIncluded', 'InstancePoolLicenseTypeBasePrice'
	LicenseType InstancePoolLicenseType `json:"licenseType,omitempty"`
}

// InstancePoolsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type InstancePoolsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InstancePoolsClient) (InstancePool, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *InstancePoolsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for InstancePoolsCreateOrUpdateFuture.Result.
func (future *InstancePoolsCreateOrUpdateFuture) result(client InstancePoolsClient) (IP InstancePool, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.InstancePoolsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		IP.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.InstancePoolsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if IP.Response.Response, err = future.GetResult(sender); err == nil && IP.Response.Response.StatusCode != http.StatusNoContent {
		IP, err = client.CreateOrUpdateResponder(IP.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.InstancePoolsCreateOrUpdateFuture", "Result", IP.Response.Response, "Failure responding to request")
		}
	}
	return
}

// InstancePoolsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type InstancePoolsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InstancePoolsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *InstancePoolsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for InstancePoolsDeleteFuture.Result.
func (future *InstancePoolsDeleteFuture) result(client InstancePoolsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.InstancePoolsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.InstancePoolsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// InstancePoolsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type InstancePoolsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(InstancePoolsClient) (InstancePool, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *InstancePoolsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for InstancePoolsUpdateFuture.Result.
func (future *InstancePoolsUpdateFuture) result(client InstancePoolsClient) (IP InstancePool, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.InstancePoolsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		IP.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.InstancePoolsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if IP.Response.Response, err = future.GetResult(sender); err == nil && IP.Response.Response.StatusCode != http.StatusNoContent {
		IP, err = client.UpdateResponder(IP.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.InstancePoolsUpdateFuture", "Result", IP.Response.Response, "Failure responding to request")
		}
	}
	return
}

// InstancePoolUpdate an update to an Instance pool.
type InstancePoolUpdate struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for InstancePoolUpdate.
func (ipu InstancePoolUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ipu.Tags != nil {
		objectMap["tags"] = ipu.Tags
	}
	return json.Marshal(objectMap)
}

// InstancePoolVcoresCapability the managed instance virtual cores capability.
type InstancePoolVcoresCapability struct {
	// Name - READ-ONLY; The virtual cores identifier.
	Name *string `json:"name,omitempty"`
	// Value - READ-ONLY; The virtual cores value.
	Value *int32 `json:"value,omitempty"`
	// StorageLimit - READ-ONLY; Storage limit.
	StorageLimit *MaxSizeCapability `json:"storageLimit,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for InstancePoolVcoresCapability.
func (ipvc InstancePoolVcoresCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ipvc.Reason != nil {
		objectMap["reason"] = ipvc.Reason
	}
	return json.Marshal(objectMap)
}

// IPv6FirewallRule an IPv6 server firewall rule.
type IPv6FirewallRule struct {
	autorest.Response `json:"-"`
	// IPv6ServerFirewallRuleProperties - Resource properties.
	*IPv6ServerFirewallRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for IPv6FirewallRule.
func (ip6fr IPv6FirewallRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ip6fr.IPv6ServerFirewallRuleProperties != nil {
		objectMap["properties"] = ip6fr.IPv6ServerFirewallRuleProperties
	}
	if ip6fr.Name != nil {
		objectMap["name"] = ip6fr.Name
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IPv6FirewallRule struct.
func (ip6fr *IPv6FirewallRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var iPv6ServerFirewallRuleProperties IPv6ServerFirewallRuleProperties
				err = json.Unmarshal(*v, &iPv6ServerFirewallRuleProperties)
				if err != nil {
					return err
				}
				ip6fr.IPv6ServerFirewallRuleProperties = &iPv6ServerFirewallRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ip6fr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ip6fr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ip6fr.Type = &typeVar
			}
		}
	}

	return nil
}

// IPv6FirewallRuleListResult the response to a list IPv6 firewall rules request
type IPv6FirewallRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]IPv6FirewallRule `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for IPv6FirewallRuleListResult.
func (ip6frlr IPv6FirewallRuleListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// IPv6FirewallRuleListResultIterator provides access to a complete listing of IPv6FirewallRule values.
type IPv6FirewallRuleListResultIterator struct {
	i    int
	page IPv6FirewallRuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IPv6FirewallRuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IPv6FirewallRuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IPv6FirewallRuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IPv6FirewallRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IPv6FirewallRuleListResultIterator) Response() IPv6FirewallRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IPv6FirewallRuleListResultIterator) Value() IPv6FirewallRule {
	if !iter.page.NotDone() {
		return IPv6FirewallRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IPv6FirewallRuleListResultIterator type.
func NewIPv6FirewallRuleListResultIterator(page IPv6FirewallRuleListResultPage) IPv6FirewallRuleListResultIterator {
	return IPv6FirewallRuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ip6frlr IPv6FirewallRuleListResult) IsEmpty() bool {
	return ip6frlr.Value == nil || len(*ip6frlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ip6frlr IPv6FirewallRuleListResult) hasNextLink() bool {
	return ip6frlr.NextLink != nil && len(*ip6frlr.NextLink) != 0
}

// iPv6FirewallRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ip6frlr IPv6FirewallRuleListResult) iPv6FirewallRuleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ip6frlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ip6frlr.NextLink)))
}

// IPv6FirewallRuleListResultPage contains a page of IPv6FirewallRule values.
type IPv6FirewallRuleListResultPage struct {
	fn      func(context.Context, IPv6FirewallRuleListResult) (IPv6FirewallRuleListResult, error)
	ip6frlr IPv6FirewallRuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IPv6FirewallRuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IPv6FirewallRuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ip6frlr)
		if err != nil {
			return err
		}
		page.ip6frlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IPv6FirewallRuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IPv6FirewallRuleListResultPage) NotDone() bool {
	return !page.ip6frlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IPv6FirewallRuleListResultPage) Response() IPv6FirewallRuleListResult {
	return page.ip6frlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IPv6FirewallRuleListResultPage) Values() []IPv6FirewallRule {
	if page.ip6frlr.IsEmpty() {
		return nil
	}
	return *page.ip6frlr.Value
}

// Creates a new instance of the IPv6FirewallRuleListResultPage type.
func NewIPv6FirewallRuleListResultPage(cur IPv6FirewallRuleListResult, getNextPage func(context.Context, IPv6FirewallRuleListResult) (IPv6FirewallRuleListResult, error)) IPv6FirewallRuleListResultPage {
	return IPv6FirewallRuleListResultPage{
		fn:      getNextPage,
		ip6frlr: cur,
	}
}

// IPv6ServerFirewallRuleProperties the properties of an IPv6 server firewall rule.
type IPv6ServerFirewallRuleProperties struct {
	// StartIPv6Address - The start IP address of the firewall rule. Must be IPv6 format.
	StartIPv6Address *string `json:"startIPv6Address,omitempty"`
	// EndIPv6Address - The end IP address of the firewall rule. Must be IPv6 format. Must be greater than or equal to startIpAddress.
	EndIPv6Address *string `json:"endIPv6Address,omitempty"`
}

// Job a job.
type Job struct {
	autorest.Response `json:"-"`
	// JobProperties - Resource properties.
	*JobProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Job.
func (j Job) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if j.JobProperties != nil {
		objectMap["properties"] = j.JobProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Job struct.
func (j *Job) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobProperties JobProperties
				err = json.Unmarshal(*v, &jobProperties)
				if err != nil {
					return err
				}
				j.JobProperties = &jobProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				j.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				j.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				j.Type = &typeVar
			}
		}
	}

	return nil
}

// JobAgent an Azure SQL job agent.
type JobAgent struct {
	autorest.Response `json:"-"`
	// Sku - The name and tier of the SKU.
	Sku *Sku `json:"sku,omitempty"`
	// JobAgentProperties - Resource properties.
	*JobAgentProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for JobAgent.
func (ja JobAgent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ja.Sku != nil {
		objectMap["sku"] = ja.Sku
	}
	if ja.JobAgentProperties != nil {
		objectMap["properties"] = ja.JobAgentProperties
	}
	if ja.Location != nil {
		objectMap["location"] = ja.Location
	}
	if ja.Tags != nil {
		objectMap["tags"] = ja.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobAgent struct.
func (ja *JobAgent) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				ja.Sku = &sku
			}
		case "properties":
			if v != nil {
				var jobAgentProperties JobAgentProperties
				err = json.Unmarshal(*v, &jobAgentProperties)
				if err != nil {
					return err
				}
				ja.JobAgentProperties = &jobAgentProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ja.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ja.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ja.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ja.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ja.Type = &typeVar
			}
		}
	}

	return nil
}

// JobAgentListResult a list of Azure SQL job agents.
type JobAgentListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]JobAgent `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for JobAgentListResult.
func (jalr JobAgentListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// JobAgentListResultIterator provides access to a complete listing of JobAgent values.
type JobAgentListResultIterator struct {
	i    int
	page JobAgentListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobAgentListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobAgentListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobAgentListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobAgentListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobAgentListResultIterator) Response() JobAgentListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobAgentListResultIterator) Value() JobAgent {
	if !iter.page.NotDone() {
		return JobAgent{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobAgentListResultIterator type.
func NewJobAgentListResultIterator(page JobAgentListResultPage) JobAgentListResultIterator {
	return JobAgentListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jalr JobAgentListResult) IsEmpty() bool {
	return jalr.Value == nil || len(*jalr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (jalr JobAgentListResult) hasNextLink() bool {
	return jalr.NextLink != nil && len(*jalr.NextLink) != 0
}

// jobAgentListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jalr JobAgentListResult) jobAgentListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !jalr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jalr.NextLink)))
}

// JobAgentListResultPage contains a page of JobAgent values.
type JobAgentListResultPage struct {
	fn   func(context.Context, JobAgentListResult) (JobAgentListResult, error)
	jalr JobAgentListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobAgentListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobAgentListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.jalr)
		if err != nil {
			return err
		}
		page.jalr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobAgentListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobAgentListResultPage) NotDone() bool {
	return !page.jalr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobAgentListResultPage) Response() JobAgentListResult {
	return page.jalr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobAgentListResultPage) Values() []JobAgent {
	if page.jalr.IsEmpty() {
		return nil
	}
	return *page.jalr.Value
}

// Creates a new instance of the JobAgentListResultPage type.
func NewJobAgentListResultPage(cur JobAgentListResult, getNextPage func(context.Context, JobAgentListResult) (JobAgentListResult, error)) JobAgentListResultPage {
	return JobAgentListResultPage{
		fn:   getNextPage,
		jalr: cur,
	}
}

// JobAgentProperties properties of a job agent.
type JobAgentProperties struct {
	// DatabaseID - Resource ID of the database to store job metadata in.
	DatabaseID *string `json:"databaseId,omitempty"`
	// State - READ-ONLY; The state of the job agent. Possible values include: 'JobAgentStateCreating', 'JobAgentStateReady', 'JobAgentStateUpdating', 'JobAgentStateDeleting', 'JobAgentStateDisabled'
	State JobAgentState `json:"state,omitempty"`
}

// MarshalJSON is the custom marshaler for JobAgentProperties.
func (jap JobAgentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jap.DatabaseID != nil {
		objectMap["databaseId"] = jap.DatabaseID
	}
	return json.Marshal(objectMap)
}

// JobAgentsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type JobAgentsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(JobAgentsClient) (JobAgent, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *JobAgentsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for JobAgentsCreateOrUpdateFuture.Result.
func (future *JobAgentsCreateOrUpdateFuture) result(client JobAgentsClient) (ja JobAgent, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.JobAgentsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ja.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.JobAgentsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ja.Response.Response, err = future.GetResult(sender); err == nil && ja.Response.Response.StatusCode != http.StatusNoContent {
		ja, err = client.CreateOrUpdateResponder(ja.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.JobAgentsCreateOrUpdateFuture", "Result", ja.Response.Response, "Failure responding to request")
		}
	}
	return
}

// JobAgentsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type JobAgentsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(JobAgentsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *JobAgentsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for JobAgentsDeleteFuture.Result.
func (future *JobAgentsDeleteFuture) result(client JobAgentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.JobAgentsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.JobAgentsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// JobAgentsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type JobAgentsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(JobAgentsClient) (JobAgent, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *JobAgentsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for JobAgentsUpdateFuture.Result.
func (future *JobAgentsUpdateFuture) result(client JobAgentsClient) (ja JobAgent, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.JobAgentsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ja.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.JobAgentsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ja.Response.Response, err = future.GetResult(sender); err == nil && ja.Response.Response.StatusCode != http.StatusNoContent {
		ja, err = client.UpdateResponder(ja.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.JobAgentsUpdateFuture", "Result", ja.Response.Response, "Failure responding to request")
		}
	}
	return
}

// JobAgentUpdate an update to an Azure SQL job agent.
type JobAgentUpdate struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for JobAgentUpdate.
func (jau JobAgentUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jau.Tags != nil {
		objectMap["tags"] = jau.Tags
	}
	return json.Marshal(objectMap)
}

// JobCredential a stored credential that can be used by a job to connect to target databases.
type JobCredential struct {
	autorest.Response `json:"-"`
	// JobCredentialProperties - Resource properties.
	*JobCredentialProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for JobCredential.
func (jc JobCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jc.JobCredentialProperties != nil {
		objectMap["properties"] = jc.JobCredentialProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobCredential struct.
func (jc *JobCredential) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobCredentialProperties JobCredentialProperties
				err = json.Unmarshal(*v, &jobCredentialProperties)
				if err != nil {
					return err
				}
				jc.JobCredentialProperties = &jobCredentialProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				jc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				jc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				jc.Type = &typeVar
			}
		}
	}

	return nil
}

// JobCredentialListResult a list of job credentials.
type JobCredentialListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]JobCredential `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for JobCredentialListResult.
func (jclr JobCredentialListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// JobCredentialListResultIterator provides access to a complete listing of JobCredential values.
type JobCredentialListResultIterator struct {
	i    int
	page JobCredentialListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobCredentialListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobCredentialListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobCredentialListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobCredentialListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobCredentialListResultIterator) Response() JobCredentialListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobCredentialListResultIterator) Value() JobCredential {
	if !iter.page.NotDone() {
		return JobCredential{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobCredentialListResultIterator type.
func NewJobCredentialListResultIterator(page JobCredentialListResultPage) JobCredentialListResultIterator {
	return JobCredentialListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jclr JobCredentialListResult) IsEmpty() bool {
	return jclr.Value == nil || len(*jclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (jclr JobCredentialListResult) hasNextLink() bool {
	return jclr.NextLink != nil && len(*jclr.NextLink) != 0
}

// jobCredentialListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jclr JobCredentialListResult) jobCredentialListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !jclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jclr.NextLink)))
}

// JobCredentialListResultPage contains a page of JobCredential values.
type JobCredentialListResultPage struct {
	fn   func(context.Context, JobCredentialListResult) (JobCredentialListResult, error)
	jclr JobCredentialListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobCredentialListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobCredentialListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.jclr)
		if err != nil {
			return err
		}
		page.jclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobCredentialListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobCredentialListResultPage) NotDone() bool {
	return !page.jclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobCredentialListResultPage) Response() JobCredentialListResult {
	return page.jclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobCredentialListResultPage) Values() []JobCredential {
	if page.jclr.IsEmpty() {
		return nil
	}
	return *page.jclr.Value
}

// Creates a new instance of the JobCredentialListResultPage type.
func NewJobCredentialListResultPage(cur JobCredentialListResult, getNextPage func(context.Context, JobCredentialListResult) (JobCredentialListResult, error)) JobCredentialListResultPage {
	return JobCredentialListResultPage{
		fn:   getNextPage,
		jclr: cur,
	}
}

// JobCredentialProperties properties of a job credential.
type JobCredentialProperties struct {
	// Username - The credential user name.
	Username *string `json:"username,omitempty"`
	// Password - The credential password.
	Password *string `json:"password,omitempty"`
}

// JobExecution an execution of a job
type JobExecution struct {
	autorest.Response `json:"-"`
	// JobExecutionProperties - Resource properties.
	*JobExecutionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for JobExecution.
func (je JobExecution) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if je.JobExecutionProperties != nil {
		objectMap["properties"] = je.JobExecutionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobExecution struct.
func (je *JobExecution) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobExecutionProperties JobExecutionProperties
				err = json.Unmarshal(*v, &jobExecutionProperties)
				if err != nil {
					return err
				}
				je.JobExecutionProperties = &jobExecutionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				je.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				je.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				je.Type = &typeVar
			}
		}
	}

	return nil
}

// JobExecutionListResult a list of job executions.
type JobExecutionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]JobExecution `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for JobExecutionListResult.
func (jelr JobExecutionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// JobExecutionListResultIterator provides access to a complete listing of JobExecution values.
type JobExecutionListResultIterator struct {
	i    int
	page JobExecutionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobExecutionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobExecutionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobExecutionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobExecutionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobExecutionListResultIterator) Response() JobExecutionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobExecutionListResultIterator) Value() JobExecution {
	if !iter.page.NotDone() {
		return JobExecution{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobExecutionListResultIterator type.
func NewJobExecutionListResultIterator(page JobExecutionListResultPage) JobExecutionListResultIterator {
	return JobExecutionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jelr JobExecutionListResult) IsEmpty() bool {
	return jelr.Value == nil || len(*jelr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (jelr JobExecutionListResult) hasNextLink() bool {
	return jelr.NextLink != nil && len(*jelr.NextLink) != 0
}

// jobExecutionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jelr JobExecutionListResult) jobExecutionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !jelr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jelr.NextLink)))
}

// JobExecutionListResultPage contains a page of JobExecution values.
type JobExecutionListResultPage struct {
	fn   func(context.Context, JobExecutionListResult) (JobExecutionListResult, error)
	jelr JobExecutionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobExecutionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobExecutionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.jelr)
		if err != nil {
			return err
		}
		page.jelr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobExecutionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobExecutionListResultPage) NotDone() bool {
	return !page.jelr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobExecutionListResultPage) Response() JobExecutionListResult {
	return page.jelr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobExecutionListResultPage) Values() []JobExecution {
	if page.jelr.IsEmpty() {
		return nil
	}
	return *page.jelr.Value
}

// Creates a new instance of the JobExecutionListResultPage type.
func NewJobExecutionListResultPage(cur JobExecutionListResult, getNextPage func(context.Context, JobExecutionListResult) (JobExecutionListResult, error)) JobExecutionListResultPage {
	return JobExecutionListResultPage{
		fn:   getNextPage,
		jelr: cur,
	}
}

// JobExecutionProperties properties for an Azure SQL Database Elastic job execution.
type JobExecutionProperties struct {
	// JobVersion - READ-ONLY; The job version number.
	JobVersion *int32 `json:"jobVersion,omitempty"`
	// StepName - READ-ONLY; The job step name.
	StepName *string `json:"stepName,omitempty"`
	// StepID - READ-ONLY; The job step id.
	StepID *int32 `json:"stepId,omitempty"`
	// JobExecutionID - READ-ONLY; The unique identifier of the job execution.
	JobExecutionID *uuid.UUID `json:"jobExecutionId,omitempty"`
	// Lifecycle - READ-ONLY; The detailed state of the job execution. Possible values include: 'JobExecutionLifecycleCreated', 'JobExecutionLifecycleInProgress', 'JobExecutionLifecycleWaitingForChildJobExecutions', 'JobExecutionLifecycleWaitingForRetry', 'JobExecutionLifecycleSucceeded', 'JobExecutionLifecycleSucceededWithSkipped', 'JobExecutionLifecycleFailed', 'JobExecutionLifecycleTimedOut', 'JobExecutionLifecycleCanceled', 'JobExecutionLifecycleSkipped'
	Lifecycle JobExecutionLifecycle `json:"lifecycle,omitempty"`
	// ProvisioningState - READ-ONLY; The ARM provisioning state of the job execution. Possible values include: 'ProvisioningStateCreated', 'ProvisioningStateInProgress', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// CreateTime - READ-ONLY; The time that the job execution was created.
	CreateTime *date.Time `json:"createTime,omitempty"`
	// StartTime - READ-ONLY; The time that the job execution started.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The time that the job execution completed.
	EndTime *date.Time `json:"endTime,omitempty"`
	// CurrentAttempts - Number of times the job execution has been attempted.
	CurrentAttempts *int32 `json:"currentAttempts,omitempty"`
	// CurrentAttemptStartTime - READ-ONLY; Start time of the current attempt.
	CurrentAttemptStartTime *date.Time `json:"currentAttemptStartTime,omitempty"`
	// LastMessage - READ-ONLY; The last status or error message.
	LastMessage *string `json:"lastMessage,omitempty"`
	// Target - READ-ONLY; The target that this execution is executed on.
	Target *JobExecutionTarget `json:"target,omitempty"`
}

// MarshalJSON is the custom marshaler for JobExecutionProperties.
func (jep JobExecutionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jep.CurrentAttempts != nil {
		objectMap["currentAttempts"] = jep.CurrentAttempts
	}
	return json.Marshal(objectMap)
}

// JobExecutionsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type JobExecutionsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(JobExecutionsClient) (JobExecution, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *JobExecutionsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for JobExecutionsCreateFuture.Result.
func (future *JobExecutionsCreateFuture) result(client JobExecutionsClient) (je JobExecution, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.JobExecutionsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		je.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.JobExecutionsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if je.Response.Response, err = future.GetResult(sender); err == nil && je.Response.Response.StatusCode != http.StatusNoContent {
		je, err = client.CreateResponder(je.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.JobExecutionsCreateFuture", "Result", je.Response.Response, "Failure responding to request")
		}
	}
	return
}

// JobExecutionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type JobExecutionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(JobExecutionsClient) (JobExecution, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *JobExecutionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for JobExecutionsCreateOrUpdateFuture.Result.
func (future *JobExecutionsCreateOrUpdateFuture) result(client JobExecutionsClient) (je JobExecution, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.JobExecutionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		je.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.JobExecutionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if je.Response.Response, err = future.GetResult(sender); err == nil && je.Response.Response.StatusCode != http.StatusNoContent {
		je, err = client.CreateOrUpdateResponder(je.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.JobExecutionsCreateOrUpdateFuture", "Result", je.Response.Response, "Failure responding to request")
		}
	}
	return
}

// JobExecutionTarget the target that a job execution is executed on.
type JobExecutionTarget struct {
	// Type - READ-ONLY; The type of the target. Possible values include: 'JobTargetTypeTargetGroup', 'JobTargetTypeSQLDatabase', 'JobTargetTypeSQLElasticPool', 'JobTargetTypeSQLShardMap', 'JobTargetTypeSQLServer'
	Type JobTargetType `json:"type,omitempty"`
	// ServerName - READ-ONLY; The server name.
	ServerName *string `json:"serverName,omitempty"`
	// DatabaseName - READ-ONLY; The database name.
	DatabaseName *string `json:"databaseName,omitempty"`
}

// MarshalJSON is the custom marshaler for JobExecutionTarget.
func (jet JobExecutionTarget) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// JobListResult a list of jobs.
type JobListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]Job `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for JobListResult.
func (jlr JobListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// JobListResultIterator provides access to a complete listing of Job values.
type JobListResultIterator struct {
	i    int
	page JobListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobListResultIterator) Response() JobListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobListResultIterator) Value() Job {
	if !iter.page.NotDone() {
		return Job{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobListResultIterator type.
func NewJobListResultIterator(page JobListResultPage) JobListResultIterator {
	return JobListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jlr JobListResult) IsEmpty() bool {
	return jlr.Value == nil || len(*jlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (jlr JobListResult) hasNextLink() bool {
	return jlr.NextLink != nil && len(*jlr.NextLink) != 0
}

// jobListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jlr JobListResult) jobListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !jlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jlr.NextLink)))
}

// JobListResultPage contains a page of Job values.
type JobListResultPage struct {
	fn  func(context.Context, JobListResult) (JobListResult, error)
	jlr JobListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.jlr)
		if err != nil {
			return err
		}
		page.jlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobListResultPage) NotDone() bool {
	return !page.jlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobListResultPage) Response() JobListResult {
	return page.jlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobListResultPage) Values() []Job {
	if page.jlr.IsEmpty() {
		return nil
	}
	return *page.jlr.Value
}

// Creates a new instance of the JobListResultPage type.
func NewJobListResultPage(cur JobListResult, getNextPage func(context.Context, JobListResult) (JobListResult, error)) JobListResultPage {
	return JobListResultPage{
		fn:  getNextPage,
		jlr: cur,
	}
}

// JobProperties properties of a job.
type JobProperties struct {
	// Description - User-defined description of the job.
	Description *string `json:"description,omitempty"`
	// Version - READ-ONLY; The job version number.
	Version *int32 `json:"version,omitempty"`
	// Schedule - Schedule properties of the job.
	Schedule *JobSchedule `json:"schedule,omitempty"`
}

// MarshalJSON is the custom marshaler for JobProperties.
func (jp JobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jp.Description != nil {
		objectMap["description"] = jp.Description
	}
	if jp.Schedule != nil {
		objectMap["schedule"] = jp.Schedule
	}
	return json.Marshal(objectMap)
}

// JobSchedule scheduling properties of a job.
type JobSchedule struct {
	// StartTime - Schedule start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Schedule end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Type - Schedule interval type. Possible values include: 'JobScheduleTypeOnce', 'JobScheduleTypeRecurring'
	Type JobScheduleType `json:"type,omitempty"`
	// Enabled - Whether or not the schedule is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// Interval - Value of the schedule's recurring interval, if the ScheduleType is recurring. ISO8601 duration format.
	Interval *string `json:"interval,omitempty"`
}

// JobStep a job step.
type JobStep struct {
	autorest.Response `json:"-"`
	// JobStepProperties - Resource properties.
	*JobStepProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for JobStep.
func (js JobStep) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if js.JobStepProperties != nil {
		objectMap["properties"] = js.JobStepProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobStep struct.
func (js *JobStep) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobStepProperties JobStepProperties
				err = json.Unmarshal(*v, &jobStepProperties)
				if err != nil {
					return err
				}
				js.JobStepProperties = &jobStepProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				js.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				js.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				js.Type = &typeVar
			}
		}
	}

	return nil
}

// JobStepAction the action to be executed by a job step.
type JobStepAction struct {
	// Type - Type of action being executed by the job step. Possible values include: 'JobStepActionTypeTSQL'
	Type JobStepActionType `json:"type,omitempty"`
	// Source - The source of the action to execute. Possible values include: 'JobStepActionSourceInline'
	Source JobStepActionSource `json:"source,omitempty"`
	// Value - The action value, for example the text of the T-SQL script to execute.
	Value *string `json:"value,omitempty"`
}

// JobStepExecutionOptions the execution options of a job step.
type JobStepExecutionOptions struct {
	// TimeoutSeconds - Execution timeout for the job step.
	TimeoutSeconds *int32 `json:"timeoutSeconds,omitempty"`
	// RetryAttempts - Maximum number of times the job step will be reattempted if the first attempt fails.
	RetryAttempts *int32 `json:"retryAttempts,omitempty"`
	// InitialRetryIntervalSeconds - Initial delay between retries for job step execution.
	InitialRetryIntervalSeconds *int32 `json:"initialRetryIntervalSeconds,omitempty"`
	// MaximumRetryIntervalSeconds - The maximum amount of time to wait between retries for job step execution.
	MaximumRetryIntervalSeconds *int32 `json:"maximumRetryIntervalSeconds,omitempty"`
	// RetryIntervalBackoffMultiplier - The backoff multiplier for the time between retries.
	RetryIntervalBackoffMultiplier *float64 `json:"retryIntervalBackoffMultiplier,omitempty"`
}

// JobStepListResult a list of job steps.
type JobStepListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]JobStep `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for JobStepListResult.
func (jslr JobStepListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// JobStepListResultIterator provides access to a complete listing of JobStep values.
type JobStepListResultIterator struct {
	i    int
	page JobStepListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobStepListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobStepListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobStepListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobStepListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobStepListResultIterator) Response() JobStepListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobStepListResultIterator) Value() JobStep {
	if !iter.page.NotDone() {
		return JobStep{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobStepListResultIterator type.
func NewJobStepListResultIterator(page JobStepListResultPage) JobStepListResultIterator {
	return JobStepListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jslr JobStepListResult) IsEmpty() bool {
	return jslr.Value == nil || len(*jslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (jslr JobStepListResult) hasNextLink() bool {
	return jslr.NextLink != nil && len(*jslr.NextLink) != 0
}

// jobStepListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jslr JobStepListResult) jobStepListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !jslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jslr.NextLink)))
}

// JobStepListResultPage contains a page of JobStep values.
type JobStepListResultPage struct {
	fn   func(context.Context, JobStepListResult) (JobStepListResult, error)
	jslr JobStepListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobStepListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobStepListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.jslr)
		if err != nil {
			return err
		}
		page.jslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobStepListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobStepListResultPage) NotDone() bool {
	return !page.jslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobStepListResultPage) Response() JobStepListResult {
	return page.jslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobStepListResultPage) Values() []JobStep {
	if page.jslr.IsEmpty() {
		return nil
	}
	return *page.jslr.Value
}

// Creates a new instance of the JobStepListResultPage type.
func NewJobStepListResultPage(cur JobStepListResult, getNextPage func(context.Context, JobStepListResult) (JobStepListResult, error)) JobStepListResultPage {
	return JobStepListResultPage{
		fn:   getNextPage,
		jslr: cur,
	}
}

// JobStepOutput the output configuration of a job step.
type JobStepOutput struct {
	// Type - The output destination type. Possible values include: 'JobStepOutputTypeSQLDatabase'
	Type JobStepOutputType `json:"type,omitempty"`
	// SubscriptionID - The output destination subscription id.
	SubscriptionID *uuid.UUID `json:"subscriptionId,omitempty"`
	// ResourceGroupName - The output destination resource group.
	ResourceGroupName *string `json:"resourceGroupName,omitempty"`
	// ServerName - The output destination server name.
	ServerName *string `json:"serverName,omitempty"`
	// DatabaseName - The output destination database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// SchemaName - The output destination schema.
	SchemaName *string `json:"schemaName,omitempty"`
	// TableName - The output destination table.
	TableName *string `json:"tableName,omitempty"`
	// Credential - The resource ID of the credential to use to connect to the output destination.
	Credential *string `json:"credential,omitempty"`
}

// JobStepProperties properties of a job step.
type JobStepProperties struct {
	// StepID - The job step's index within the job. If not specified when creating the job step, it will be created as the last step. If not specified when updating the job step, the step id is not modified.
	StepID *int32 `json:"stepId,omitempty"`
	// TargetGroup - The resource ID of the target group that the job step will be executed on.
	TargetGroup *string `json:"targetGroup,omitempty"`
	// Credential - The resource ID of the job credential that will be used to connect to the targets.
	Credential *string `json:"credential,omitempty"`
	// Action - The action payload of the job step.
	Action *JobStepAction `json:"action,omitempty"`
	// Output - Output destination properties of the job step.
	Output *JobStepOutput `json:"output,omitempty"`
	// ExecutionOptions - Execution options for the job step.
	ExecutionOptions *JobStepExecutionOptions `json:"executionOptions,omitempty"`
}

// JobTarget a job target, for example a specific database or a container of databases that is evaluated
// during job execution.
type JobTarget struct {
	// MembershipType - Whether the target is included or excluded from the group. Possible values include: 'JobTargetGroupMembershipTypeInclude', 'JobTargetGroupMembershipTypeExclude'
	MembershipType JobTargetGroupMembershipType `json:"membershipType,omitempty"`
	// Type - The target type. Possible values include: 'JobTargetTypeTargetGroup', 'JobTargetTypeSQLDatabase', 'JobTargetTypeSQLElasticPool', 'JobTargetTypeSQLShardMap', 'JobTargetTypeSQLServer'
	Type JobTargetType `json:"type,omitempty"`
	// ServerName - The target server name.
	ServerName *string `json:"serverName,omitempty"`
	// DatabaseName - The target database name.
	DatabaseName *string `json:"databaseName,omitempty"`
	// ElasticPoolName - The target elastic pool name.
	ElasticPoolName *string `json:"elasticPoolName,omitempty"`
	// ShardMapName - The target shard map.
	ShardMapName *string `json:"shardMapName,omitempty"`
	// RefreshCredential - The resource ID of the credential that is used during job execution to connect to the target and determine the list of databases inside the target.
	RefreshCredential *string `json:"refreshCredential,omitempty"`
}

// JobTargetGroup a group of job targets.
type JobTargetGroup struct {
	autorest.Response `json:"-"`
	// JobTargetGroupProperties - Resource properties.
	*JobTargetGroupProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for JobTargetGroup.
func (jtg JobTargetGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jtg.JobTargetGroupProperties != nil {
		objectMap["properties"] = jtg.JobTargetGroupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobTargetGroup struct.
func (jtg *JobTargetGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobTargetGroupProperties JobTargetGroupProperties
				err = json.Unmarshal(*v, &jobTargetGroupProperties)
				if err != nil {
					return err
				}
				jtg.JobTargetGroupProperties = &jobTargetGroupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				jtg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				jtg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				jtg.Type = &typeVar
			}
		}
	}

	return nil
}

// JobTargetGroupListResult a list of target groups.
type JobTargetGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]JobTargetGroup `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for JobTargetGroupListResult.
func (jtglr JobTargetGroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// JobTargetGroupListResultIterator provides access to a complete listing of JobTargetGroup values.
type JobTargetGroupListResultIterator struct {
	i    int
	page JobTargetGroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobTargetGroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobTargetGroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobTargetGroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobTargetGroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobTargetGroupListResultIterator) Response() JobTargetGroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobTargetGroupListResultIterator) Value() JobTargetGroup {
	if !iter.page.NotDone() {
		return JobTargetGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobTargetGroupListResultIterator type.
func NewJobTargetGroupListResultIterator(page JobTargetGroupListResultPage) JobTargetGroupListResultIterator {
	return JobTargetGroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jtglr JobTargetGroupListResult) IsEmpty() bool {
	return jtglr.Value == nil || len(*jtglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (jtglr JobTargetGroupListResult) hasNextLink() bool {
	return jtglr.NextLink != nil && len(*jtglr.NextLink) != 0
}

// jobTargetGroupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jtglr JobTargetGroupListResult) jobTargetGroupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !jtglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jtglr.NextLink)))
}

// JobTargetGroupListResultPage contains a page of JobTargetGroup values.
type JobTargetGroupListResultPage struct {
	fn    func(context.Context, JobTargetGroupListResult) (JobTargetGroupListResult, error)
	jtglr JobTargetGroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobTargetGroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobTargetGroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.jtglr)
		if err != nil {
			return err
		}
		page.jtglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobTargetGroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobTargetGroupListResultPage) NotDone() bool {
	return !page.jtglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobTargetGroupListResultPage) Response() JobTargetGroupListResult {
	return page.jtglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobTargetGroupListResultPage) Values() []JobTargetGroup {
	if page.jtglr.IsEmpty() {
		return nil
	}
	return *page.jtglr.Value
}

// Creates a new instance of the JobTargetGroupListResultPage type.
func NewJobTargetGroupListResultPage(cur JobTargetGroupListResult, getNextPage func(context.Context, JobTargetGroupListResult) (JobTargetGroupListResult, error)) JobTargetGroupListResultPage {
	return JobTargetGroupListResultPage{
		fn:    getNextPage,
		jtglr: cur,
	}
}

// JobTargetGroupProperties properties of job target group.
type JobTargetGroupProperties struct {
	// Members - Members of the target group.
	Members *[]JobTarget `json:"members,omitempty"`
}

// JobVersion a job version.
type JobVersion struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for JobVersion.
func (jv JobVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// JobVersionListResult a list of job versions.
type JobVersionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]JobVersion `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for JobVersionListResult.
func (jvlr JobVersionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// JobVersionListResultIterator provides access to a complete listing of JobVersion values.
type JobVersionListResultIterator struct {
	i    int
	page JobVersionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobVersionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobVersionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobVersionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobVersionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobVersionListResultIterator) Response() JobVersionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobVersionListResultIterator) Value() JobVersion {
	if !iter.page.NotDone() {
		return JobVersion{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobVersionListResultIterator type.
func NewJobVersionListResultIterator(page JobVersionListResultPage) JobVersionListResultIterator {
	return JobVersionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jvlr JobVersionListResult) IsEmpty() bool {
	return jvlr.Value == nil || len(*jvlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (jvlr JobVersionListResult) hasNextLink() bool {
	return jvlr.NextLink != nil && len(*jvlr.NextLink) != 0
}

// jobVersionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jvlr JobVersionListResult) jobVersionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !jvlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jvlr.NextLink)))
}

// JobVersionListResultPage contains a page of JobVersion values.
type JobVersionListResultPage struct {
	fn   func(context.Context, JobVersionListResult) (JobVersionListResult, error)
	jvlr JobVersionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobVersionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobVersionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.jvlr)
		if err != nil {
			return err
		}
		page.jvlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobVersionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobVersionListResultPage) NotDone() bool {
	return !page.jvlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobVersionListResultPage) Response() JobVersionListResult {
	return page.jvlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobVersionListResultPage) Values() []JobVersion {
	if page.jvlr.IsEmpty() {
		return nil
	}
	return *page.jvlr.Value
}

// Creates a new instance of the JobVersionListResultPage type.
func NewJobVersionListResultPage(cur JobVersionListResult, getNextPage func(context.Context, JobVersionListResult) (JobVersionListResult, error)) JobVersionListResultPage {
	return JobVersionListResultPage{
		fn:   getNextPage,
		jvlr: cur,
	}
}

// LedgerDigestUploads azure SQL Database ledger digest upload settings.
type LedgerDigestUploads struct {
	autorest.Response `json:"-"`
	// LedgerDigestUploadsProperties - Resource properties.
	*LedgerDigestUploadsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for LedgerDigestUploads.
func (ldu LedgerDigestUploads) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ldu.LedgerDigestUploadsProperties != nil {
		objectMap["properties"] = ldu.LedgerDigestUploadsProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LedgerDigestUploads struct.
func (ldu *LedgerDigestUploads) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var ledgerDigestUploadsProperties LedgerDigestUploadsProperties
				err = json.Unmarshal(*v, &ledgerDigestUploadsProperties)
				if err != nil {
					return err
				}
				ldu.LedgerDigestUploadsProperties = &ledgerDigestUploadsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ldu.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ldu.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ldu.Type = &typeVar
			}
		}
	}

	return nil
}

// LedgerDigestUploadsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type LedgerDigestUploadsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LedgerDigestUploadsClient) (LedgerDigestUploads, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LedgerDigestUploadsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LedgerDigestUploadsCreateOrUpdateFuture.Result.
func (future *LedgerDigestUploadsCreateOrUpdateFuture) result(client LedgerDigestUploadsClient) (ldu LedgerDigestUploads, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LedgerDigestUploadsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ldu.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.LedgerDigestUploadsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ldu.Response.Response, err = future.GetResult(sender); err == nil && ldu.Response.Response.StatusCode != http.StatusNoContent {
		ldu, err = client.CreateOrUpdateResponder(ldu.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.LedgerDigestUploadsCreateOrUpdateFuture", "Result", ldu.Response.Response, "Failure responding to request")
		}
	}
	return
}

// LedgerDigestUploadsDisableFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type LedgerDigestUploadsDisableFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LedgerDigestUploadsClient) (LedgerDigestUploads, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LedgerDigestUploadsDisableFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LedgerDigestUploadsDisableFuture.Result.
func (future *LedgerDigestUploadsDisableFuture) result(client LedgerDigestUploadsClient) (ldu LedgerDigestUploads, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LedgerDigestUploadsDisableFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ldu.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.LedgerDigestUploadsDisableFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ldu.Response.Response, err = future.GetResult(sender); err == nil && ldu.Response.Response.StatusCode != http.StatusNoContent {
		ldu, err = client.DisableResponder(ldu.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.LedgerDigestUploadsDisableFuture", "Result", ldu.Response.Response, "Failure responding to request")
		}
	}
	return
}

// LedgerDigestUploadsListResult a list of ledger digest upload settings.
type LedgerDigestUploadsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]LedgerDigestUploads `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for LedgerDigestUploadsListResult.
func (ldulr LedgerDigestUploadsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// LedgerDigestUploadsListResultIterator provides access to a complete listing of LedgerDigestUploads
// values.
type LedgerDigestUploadsListResultIterator struct {
	i    int
	page LedgerDigestUploadsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LedgerDigestUploadsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LedgerDigestUploadsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LedgerDigestUploadsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LedgerDigestUploadsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LedgerDigestUploadsListResultIterator) Response() LedgerDigestUploadsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LedgerDigestUploadsListResultIterator) Value() LedgerDigestUploads {
	if !iter.page.NotDone() {
		return LedgerDigestUploads{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LedgerDigestUploadsListResultIterator type.
func NewLedgerDigestUploadsListResultIterator(page LedgerDigestUploadsListResultPage) LedgerDigestUploadsListResultIterator {
	return LedgerDigestUploadsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ldulr LedgerDigestUploadsListResult) IsEmpty() bool {
	return ldulr.Value == nil || len(*ldulr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ldulr LedgerDigestUploadsListResult) hasNextLink() bool {
	return ldulr.NextLink != nil && len(*ldulr.NextLink) != 0
}

// ledgerDigestUploadsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ldulr LedgerDigestUploadsListResult) ledgerDigestUploadsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ldulr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ldulr.NextLink)))
}

// LedgerDigestUploadsListResultPage contains a page of LedgerDigestUploads values.
type LedgerDigestUploadsListResultPage struct {
	fn    func(context.Context, LedgerDigestUploadsListResult) (LedgerDigestUploadsListResult, error)
	ldulr LedgerDigestUploadsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LedgerDigestUploadsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LedgerDigestUploadsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ldulr)
		if err != nil {
			return err
		}
		page.ldulr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LedgerDigestUploadsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LedgerDigestUploadsListResultPage) NotDone() bool {
	return !page.ldulr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LedgerDigestUploadsListResultPage) Response() LedgerDigestUploadsListResult {
	return page.ldulr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LedgerDigestUploadsListResultPage) Values() []LedgerDigestUploads {
	if page.ldulr.IsEmpty() {
		return nil
	}
	return *page.ldulr.Value
}

// Creates a new instance of the LedgerDigestUploadsListResultPage type.
func NewLedgerDigestUploadsListResultPage(cur LedgerDigestUploadsListResult, getNextPage func(context.Context, LedgerDigestUploadsListResult) (LedgerDigestUploadsListResult, error)) LedgerDigestUploadsListResultPage {
	return LedgerDigestUploadsListResultPage{
		fn:    getNextPage,
		ldulr: cur,
	}
}

// LedgerDigestUploadsProperties the properties of a database ledger digest upload settings.
type LedgerDigestUploadsProperties struct {
	// DigestStorageEndpoint - The digest storage endpoint, which must be either an Azure blob storage endpoint or an URI for Azure Confidential Ledger.
	DigestStorageEndpoint *string `json:"digestStorageEndpoint,omitempty"`
	// State - READ-ONLY; Specifies the state of ledger digest upload. Possible values include: 'LedgerDigestUploadsStateEnabled', 'LedgerDigestUploadsStateDisabled'
	State LedgerDigestUploadsState `json:"state,omitempty"`
}

// MarshalJSON is the custom marshaler for LedgerDigestUploadsProperties.
func (ldup LedgerDigestUploadsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ldup.DigestStorageEndpoint != nil {
		objectMap["digestStorageEndpoint"] = ldup.DigestStorageEndpoint
	}
	return json.Marshal(objectMap)
}

// LicenseTypeCapability the license type capability
type LicenseTypeCapability struct {
	// Name - READ-ONLY; License type identifier.
	Name *string `json:"name,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for LicenseTypeCapability.
func (ltc LicenseTypeCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ltc.Reason != nil {
		objectMap["reason"] = ltc.Reason
	}
	return json.Marshal(objectMap)
}

// ListAdvisor ...
type ListAdvisor struct {
	autorest.Response `json:"-"`
	Value             *[]Advisor `json:"value,omitempty"`
}

// ListRecommendedAction ...
type ListRecommendedAction struct {
	autorest.Response `json:"-"`
	Value             *[]RecommendedAction `json:"value,omitempty"`
}

// LocationCapabilities the location capability.
type LocationCapabilities struct {
	autorest.Response `json:"-"`
	// Name - READ-ONLY; The location name.
	Name *string `json:"name,omitempty"`
	// SupportedServerVersions - READ-ONLY; The list of supported server versions.
	SupportedServerVersions *[]ServerVersionCapability `json:"supportedServerVersions,omitempty"`
	// SupportedManagedInstanceVersions - READ-ONLY; The list of supported managed instance versions.
	SupportedManagedInstanceVersions *[]ManagedInstanceVersionCapability `json:"supportedManagedInstanceVersions,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for LocationCapabilities.
func (lc LocationCapabilities) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lc.Reason != nil {
		objectMap["reason"] = lc.Reason
	}
	return json.Marshal(objectMap)
}

// LogicalDatabaseTransparentDataEncryption a logical database transparent data encryption state.
type LogicalDatabaseTransparentDataEncryption struct {
	autorest.Response `json:"-"`
	// TransparentDataEncryptionProperties - Resource properties.
	*TransparentDataEncryptionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for LogicalDatabaseTransparentDataEncryption.
func (ldtde LogicalDatabaseTransparentDataEncryption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ldtde.TransparentDataEncryptionProperties != nil {
		objectMap["properties"] = ldtde.TransparentDataEncryptionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LogicalDatabaseTransparentDataEncryption struct.
func (ldtde *LogicalDatabaseTransparentDataEncryption) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var transparentDataEncryptionProperties TransparentDataEncryptionProperties
				err = json.Unmarshal(*v, &transparentDataEncryptionProperties)
				if err != nil {
					return err
				}
				ldtde.TransparentDataEncryptionProperties = &transparentDataEncryptionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ldtde.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ldtde.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ldtde.Type = &typeVar
			}
		}
	}

	return nil
}

// LogicalDatabaseTransparentDataEncryptionListResult a list of transparent data encryptions
type LogicalDatabaseTransparentDataEncryptionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]LogicalDatabaseTransparentDataEncryption `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for LogicalDatabaseTransparentDataEncryptionListResult.
func (ldtdelr LogicalDatabaseTransparentDataEncryptionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// LogicalDatabaseTransparentDataEncryptionListResultIterator provides access to a complete listing of
// LogicalDatabaseTransparentDataEncryption values.
type LogicalDatabaseTransparentDataEncryptionListResultIterator struct {
	i    int
	page LogicalDatabaseTransparentDataEncryptionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LogicalDatabaseTransparentDataEncryptionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LogicalDatabaseTransparentDataEncryptionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LogicalDatabaseTransparentDataEncryptionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LogicalDatabaseTransparentDataEncryptionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LogicalDatabaseTransparentDataEncryptionListResultIterator) Response() LogicalDatabaseTransparentDataEncryptionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LogicalDatabaseTransparentDataEncryptionListResultIterator) Value() LogicalDatabaseTransparentDataEncryption {
	if !iter.page.NotDone() {
		return LogicalDatabaseTransparentDataEncryption{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LogicalDatabaseTransparentDataEncryptionListResultIterator type.
func NewLogicalDatabaseTransparentDataEncryptionListResultIterator(page LogicalDatabaseTransparentDataEncryptionListResultPage) LogicalDatabaseTransparentDataEncryptionListResultIterator {
	return LogicalDatabaseTransparentDataEncryptionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ldtdelr LogicalDatabaseTransparentDataEncryptionListResult) IsEmpty() bool {
	return ldtdelr.Value == nil || len(*ldtdelr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ldtdelr LogicalDatabaseTransparentDataEncryptionListResult) hasNextLink() bool {
	return ldtdelr.NextLink != nil && len(*ldtdelr.NextLink) != 0
}

// logicalDatabaseTransparentDataEncryptionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ldtdelr LogicalDatabaseTransparentDataEncryptionListResult) logicalDatabaseTransparentDataEncryptionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ldtdelr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ldtdelr.NextLink)))
}

// LogicalDatabaseTransparentDataEncryptionListResultPage contains a page of
// LogicalDatabaseTransparentDataEncryption values.
type LogicalDatabaseTransparentDataEncryptionListResultPage struct {
	fn      func(context.Context, LogicalDatabaseTransparentDataEncryptionListResult) (LogicalDatabaseTransparentDataEncryptionListResult, error)
	ldtdelr LogicalDatabaseTransparentDataEncryptionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LogicalDatabaseTransparentDataEncryptionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LogicalDatabaseTransparentDataEncryptionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ldtdelr)
		if err != nil {
			return err
		}
		page.ldtdelr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LogicalDatabaseTransparentDataEncryptionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LogicalDatabaseTransparentDataEncryptionListResultPage) NotDone() bool {
	return !page.ldtdelr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LogicalDatabaseTransparentDataEncryptionListResultPage) Response() LogicalDatabaseTransparentDataEncryptionListResult {
	return page.ldtdelr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LogicalDatabaseTransparentDataEncryptionListResultPage) Values() []LogicalDatabaseTransparentDataEncryption {
	if page.ldtdelr.IsEmpty() {
		return nil
	}
	return *page.ldtdelr.Value
}

// Creates a new instance of the LogicalDatabaseTransparentDataEncryptionListResultPage type.
func NewLogicalDatabaseTransparentDataEncryptionListResultPage(cur LogicalDatabaseTransparentDataEncryptionListResult, getNextPage func(context.Context, LogicalDatabaseTransparentDataEncryptionListResult) (LogicalDatabaseTransparentDataEncryptionListResult, error)) LogicalDatabaseTransparentDataEncryptionListResultPage {
	return LogicalDatabaseTransparentDataEncryptionListResultPage{
		fn:      getNextPage,
		ldtdelr: cur,
	}
}

// LogicalServerAdvancedThreatProtectionListResult a list of the server's Advanced Threat Protection
// configurations.
type LogicalServerAdvancedThreatProtectionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ServerAdvancedThreatProtection `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for LogicalServerAdvancedThreatProtectionListResult.
func (lsatplr LogicalServerAdvancedThreatProtectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// LogicalServerAdvancedThreatProtectionListResultIterator provides access to a complete listing of
// ServerAdvancedThreatProtection values.
type LogicalServerAdvancedThreatProtectionListResultIterator struct {
	i    int
	page LogicalServerAdvancedThreatProtectionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LogicalServerAdvancedThreatProtectionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LogicalServerAdvancedThreatProtectionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LogicalServerAdvancedThreatProtectionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LogicalServerAdvancedThreatProtectionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LogicalServerAdvancedThreatProtectionListResultIterator) Response() LogicalServerAdvancedThreatProtectionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LogicalServerAdvancedThreatProtectionListResultIterator) Value() ServerAdvancedThreatProtection {
	if !iter.page.NotDone() {
		return ServerAdvancedThreatProtection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LogicalServerAdvancedThreatProtectionListResultIterator type.
func NewLogicalServerAdvancedThreatProtectionListResultIterator(page LogicalServerAdvancedThreatProtectionListResultPage) LogicalServerAdvancedThreatProtectionListResultIterator {
	return LogicalServerAdvancedThreatProtectionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lsatplr LogicalServerAdvancedThreatProtectionListResult) IsEmpty() bool {
	return lsatplr.Value == nil || len(*lsatplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lsatplr LogicalServerAdvancedThreatProtectionListResult) hasNextLink() bool {
	return lsatplr.NextLink != nil && len(*lsatplr.NextLink) != 0
}

// logicalServerAdvancedThreatProtectionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lsatplr LogicalServerAdvancedThreatProtectionListResult) logicalServerAdvancedThreatProtectionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lsatplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lsatplr.NextLink)))
}

// LogicalServerAdvancedThreatProtectionListResultPage contains a page of ServerAdvancedThreatProtection
// values.
type LogicalServerAdvancedThreatProtectionListResultPage struct {
	fn      func(context.Context, LogicalServerAdvancedThreatProtectionListResult) (LogicalServerAdvancedThreatProtectionListResult, error)
	lsatplr LogicalServerAdvancedThreatProtectionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LogicalServerAdvancedThreatProtectionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LogicalServerAdvancedThreatProtectionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lsatplr)
		if err != nil {
			return err
		}
		page.lsatplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LogicalServerAdvancedThreatProtectionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LogicalServerAdvancedThreatProtectionListResultPage) NotDone() bool {
	return !page.lsatplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LogicalServerAdvancedThreatProtectionListResultPage) Response() LogicalServerAdvancedThreatProtectionListResult {
	return page.lsatplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LogicalServerAdvancedThreatProtectionListResultPage) Values() []ServerAdvancedThreatProtection {
	if page.lsatplr.IsEmpty() {
		return nil
	}
	return *page.lsatplr.Value
}

// Creates a new instance of the LogicalServerAdvancedThreatProtectionListResultPage type.
func NewLogicalServerAdvancedThreatProtectionListResultPage(cur LogicalServerAdvancedThreatProtectionListResult, getNextPage func(context.Context, LogicalServerAdvancedThreatProtectionListResult) (LogicalServerAdvancedThreatProtectionListResult, error)) LogicalServerAdvancedThreatProtectionListResultPage {
	return LogicalServerAdvancedThreatProtectionListResultPage{
		fn:      getNextPage,
		lsatplr: cur,
	}
}

// LogicalServerSecurityAlertPolicyListResult a list of the server's security alert policies.
type LogicalServerSecurityAlertPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ServerSecurityAlertPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for LogicalServerSecurityAlertPolicyListResult.
func (lssaplr LogicalServerSecurityAlertPolicyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// LogicalServerSecurityAlertPolicyListResultIterator provides access to a complete listing of
// ServerSecurityAlertPolicy values.
type LogicalServerSecurityAlertPolicyListResultIterator struct {
	i    int
	page LogicalServerSecurityAlertPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LogicalServerSecurityAlertPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LogicalServerSecurityAlertPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LogicalServerSecurityAlertPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LogicalServerSecurityAlertPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LogicalServerSecurityAlertPolicyListResultIterator) Response() LogicalServerSecurityAlertPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LogicalServerSecurityAlertPolicyListResultIterator) Value() ServerSecurityAlertPolicy {
	if !iter.page.NotDone() {
		return ServerSecurityAlertPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LogicalServerSecurityAlertPolicyListResultIterator type.
func NewLogicalServerSecurityAlertPolicyListResultIterator(page LogicalServerSecurityAlertPolicyListResultPage) LogicalServerSecurityAlertPolicyListResultIterator {
	return LogicalServerSecurityAlertPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lssaplr LogicalServerSecurityAlertPolicyListResult) IsEmpty() bool {
	return lssaplr.Value == nil || len(*lssaplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lssaplr LogicalServerSecurityAlertPolicyListResult) hasNextLink() bool {
	return lssaplr.NextLink != nil && len(*lssaplr.NextLink) != 0
}

// logicalServerSecurityAlertPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lssaplr LogicalServerSecurityAlertPolicyListResult) logicalServerSecurityAlertPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lssaplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lssaplr.NextLink)))
}

// LogicalServerSecurityAlertPolicyListResultPage contains a page of ServerSecurityAlertPolicy values.
type LogicalServerSecurityAlertPolicyListResultPage struct {
	fn      func(context.Context, LogicalServerSecurityAlertPolicyListResult) (LogicalServerSecurityAlertPolicyListResult, error)
	lssaplr LogicalServerSecurityAlertPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LogicalServerSecurityAlertPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LogicalServerSecurityAlertPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lssaplr)
		if err != nil {
			return err
		}
		page.lssaplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LogicalServerSecurityAlertPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LogicalServerSecurityAlertPolicyListResultPage) NotDone() bool {
	return !page.lssaplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LogicalServerSecurityAlertPolicyListResultPage) Response() LogicalServerSecurityAlertPolicyListResult {
	return page.lssaplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LogicalServerSecurityAlertPolicyListResultPage) Values() []ServerSecurityAlertPolicy {
	if page.lssaplr.IsEmpty() {
		return nil
	}
	return *page.lssaplr.Value
}

// Creates a new instance of the LogicalServerSecurityAlertPolicyListResultPage type.
func NewLogicalServerSecurityAlertPolicyListResultPage(cur LogicalServerSecurityAlertPolicyListResult, getNextPage func(context.Context, LogicalServerSecurityAlertPolicyListResult) (LogicalServerSecurityAlertPolicyListResult, error)) LogicalServerSecurityAlertPolicyListResultPage {
	return LogicalServerSecurityAlertPolicyListResultPage{
		fn:      getNextPage,
		lssaplr: cur,
	}
}

// LogSizeCapability the log size capability.
type LogSizeCapability struct {
	// Limit - READ-ONLY; The log size limit (see 'unit' for the units).
	Limit *int32 `json:"limit,omitempty"`
	// Unit - READ-ONLY; The units that the limit is expressed in. Possible values include: 'LogSizeUnitMegabytes', 'LogSizeUnitGigabytes', 'LogSizeUnitTerabytes', 'LogSizeUnitPetabytes', 'LogSizeUnitPercent'
	Unit LogSizeUnit `json:"unit,omitempty"`
}

// MarshalJSON is the custom marshaler for LogSizeCapability.
func (lsc LogSizeCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// LongTermRetentionBackup a long term retention backup.
type LongTermRetentionBackup struct {
	autorest.Response `json:"-"`
	// LongTermRetentionBackupProperties - Resource properties.
	*LongTermRetentionBackupProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for LongTermRetentionBackup.
func (ltrb LongTermRetentionBackup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ltrb.LongTermRetentionBackupProperties != nil {
		objectMap["properties"] = ltrb.LongTermRetentionBackupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LongTermRetentionBackup struct.
func (ltrb *LongTermRetentionBackup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var longTermRetentionBackupProperties LongTermRetentionBackupProperties
				err = json.Unmarshal(*v, &longTermRetentionBackupProperties)
				if err != nil {
					return err
				}
				ltrb.LongTermRetentionBackupProperties = &longTermRetentionBackupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ltrb.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ltrb.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ltrb.Type = &typeVar
			}
		}
	}

	return nil
}

// LongTermRetentionBackupListResult a list of long term retention backups.
type LongTermRetentionBackupListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]LongTermRetentionBackup `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for LongTermRetentionBackupListResult.
func (ltrblr LongTermRetentionBackupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// LongTermRetentionBackupListResultIterator provides access to a complete listing of
// LongTermRetentionBackup values.
type LongTermRetentionBackupListResultIterator struct {
	i    int
	page LongTermRetentionBackupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LongTermRetentionBackupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionBackupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LongTermRetentionBackupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LongTermRetentionBackupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LongTermRetentionBackupListResultIterator) Response() LongTermRetentionBackupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LongTermRetentionBackupListResultIterator) Value() LongTermRetentionBackup {
	if !iter.page.NotDone() {
		return LongTermRetentionBackup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LongTermRetentionBackupListResultIterator type.
func NewLongTermRetentionBackupListResultIterator(page LongTermRetentionBackupListResultPage) LongTermRetentionBackupListResultIterator {
	return LongTermRetentionBackupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ltrblr LongTermRetentionBackupListResult) IsEmpty() bool {
	return ltrblr.Value == nil || len(*ltrblr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ltrblr LongTermRetentionBackupListResult) hasNextLink() bool {
	return ltrblr.NextLink != nil && len(*ltrblr.NextLink) != 0
}

// longTermRetentionBackupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ltrblr LongTermRetentionBackupListResult) longTermRetentionBackupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ltrblr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ltrblr.NextLink)))
}

// LongTermRetentionBackupListResultPage contains a page of LongTermRetentionBackup values.
type LongTermRetentionBackupListResultPage struct {
	fn     func(context.Context, LongTermRetentionBackupListResult) (LongTermRetentionBackupListResult, error)
	ltrblr LongTermRetentionBackupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LongTermRetentionBackupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionBackupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ltrblr)
		if err != nil {
			return err
		}
		page.ltrblr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LongTermRetentionBackupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LongTermRetentionBackupListResultPage) NotDone() bool {
	return !page.ltrblr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LongTermRetentionBackupListResultPage) Response() LongTermRetentionBackupListResult {
	return page.ltrblr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LongTermRetentionBackupListResultPage) Values() []LongTermRetentionBackup {
	if page.ltrblr.IsEmpty() {
		return nil
	}
	return *page.ltrblr.Value
}

// Creates a new instance of the LongTermRetentionBackupListResultPage type.
func NewLongTermRetentionBackupListResultPage(cur LongTermRetentionBackupListResult, getNextPage func(context.Context, LongTermRetentionBackupListResult) (LongTermRetentionBackupListResult, error)) LongTermRetentionBackupListResultPage {
	return LongTermRetentionBackupListResultPage{
		fn:     getNextPage,
		ltrblr: cur,
	}
}

// LongTermRetentionBackupOperationResult a LongTermRetentionBackup operation result resource.
type LongTermRetentionBackupOperationResult struct {
	autorest.Response `json:"-"`
	// LongTermRetentionOperationResultProperties - Resource properties.
	*LongTermRetentionOperationResultProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for LongTermRetentionBackupOperationResult.
func (ltrbor LongTermRetentionBackupOperationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ltrbor.LongTermRetentionOperationResultProperties != nil {
		objectMap["properties"] = ltrbor.LongTermRetentionOperationResultProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LongTermRetentionBackupOperationResult struct.
func (ltrbor *LongTermRetentionBackupOperationResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var longTermRetentionOperationResultProperties LongTermRetentionOperationResultProperties
				err = json.Unmarshal(*v, &longTermRetentionOperationResultProperties)
				if err != nil {
					return err
				}
				ltrbor.LongTermRetentionOperationResultProperties = &longTermRetentionOperationResultProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ltrbor.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ltrbor.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ltrbor.Type = &typeVar
			}
		}
	}

	return nil
}

// LongTermRetentionBackupProperties properties of a long term retention backup
type LongTermRetentionBackupProperties struct {
	// ServerName - READ-ONLY; The server name that the backup database belong to.
	ServerName *string `json:"serverName,omitempty"`
	// ServerCreateTime - READ-ONLY; The create time of the server.
	ServerCreateTime *date.Time `json:"serverCreateTime,omitempty"`
	// DatabaseName - READ-ONLY; The name of the database the backup belong to
	DatabaseName *string `json:"databaseName,omitempty"`
	// DatabaseDeletionTime - READ-ONLY; The delete time of the database
	DatabaseDeletionTime *date.Time `json:"databaseDeletionTime,omitempty"`
	// BackupTime - READ-ONLY; The time the backup was taken
	BackupTime *date.Time `json:"backupTime,omitempty"`
	// BackupExpirationTime - READ-ONLY; The time the long term retention backup will expire.
	BackupExpirationTime *date.Time `json:"backupExpirationTime,omitempty"`
	// BackupStorageRedundancy - READ-ONLY; The storage redundancy type of the backup. Possible values include: 'BackupStorageRedundancyGeo', 'BackupStorageRedundancyLocal', 'BackupStorageRedundancyZone', 'BackupStorageRedundancyGeoZone'
	BackupStorageRedundancy BackupStorageRedundancy `json:"backupStorageRedundancy,omitempty"`
	// RequestedBackupStorageRedundancy - The storage redundancy type of the backup. Possible values include: 'BackupStorageRedundancyGeo', 'BackupStorageRedundancyLocal', 'BackupStorageRedundancyZone', 'BackupStorageRedundancyGeoZone'
	RequestedBackupStorageRedundancy BackupStorageRedundancy `json:"requestedBackupStorageRedundancy,omitempty"`
}

// MarshalJSON is the custom marshaler for LongTermRetentionBackupProperties.
func (ltrbp LongTermRetentionBackupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ltrbp.RequestedBackupStorageRedundancy != "" {
		objectMap["requestedBackupStorageRedundancy"] = ltrbp.RequestedBackupStorageRedundancy
	}
	return json.Marshal(objectMap)
}

// LongTermRetentionBackupsCopyByResourceGroupFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type LongTermRetentionBackupsCopyByResourceGroupFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LongTermRetentionBackupsClient) (LongTermRetentionBackupOperationResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LongTermRetentionBackupsCopyByResourceGroupFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LongTermRetentionBackupsCopyByResourceGroupFuture.Result.
func (future *LongTermRetentionBackupsCopyByResourceGroupFuture) result(client LongTermRetentionBackupsClient) (ltrbor LongTermRetentionBackupOperationResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsCopyByResourceGroupFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ltrbor.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.LongTermRetentionBackupsCopyByResourceGroupFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ltrbor.Response.Response, err = future.GetResult(sender); err == nil && ltrbor.Response.Response.StatusCode != http.StatusNoContent {
		ltrbor, err = client.CopyByResourceGroupResponder(ltrbor.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsCopyByResourceGroupFuture", "Result", ltrbor.Response.Response, "Failure responding to request")
		}
	}
	return
}

// LongTermRetentionBackupsCopyFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type LongTermRetentionBackupsCopyFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LongTermRetentionBackupsClient) (LongTermRetentionBackupOperationResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LongTermRetentionBackupsCopyFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LongTermRetentionBackupsCopyFuture.Result.
func (future *LongTermRetentionBackupsCopyFuture) result(client LongTermRetentionBackupsClient) (ltrbor LongTermRetentionBackupOperationResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsCopyFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ltrbor.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.LongTermRetentionBackupsCopyFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ltrbor.Response.Response, err = future.GetResult(sender); err == nil && ltrbor.Response.Response.StatusCode != http.StatusNoContent {
		ltrbor, err = client.CopyResponder(ltrbor.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsCopyFuture", "Result", ltrbor.Response.Response, "Failure responding to request")
		}
	}
	return
}

// LongTermRetentionBackupsDeleteByResourceGroupFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type LongTermRetentionBackupsDeleteByResourceGroupFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LongTermRetentionBackupsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LongTermRetentionBackupsDeleteByResourceGroupFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LongTermRetentionBackupsDeleteByResourceGroupFuture.Result.
func (future *LongTermRetentionBackupsDeleteByResourceGroupFuture) result(client LongTermRetentionBackupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsDeleteByResourceGroupFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.LongTermRetentionBackupsDeleteByResourceGroupFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LongTermRetentionBackupsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type LongTermRetentionBackupsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LongTermRetentionBackupsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LongTermRetentionBackupsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LongTermRetentionBackupsDeleteFuture.Result.
func (future *LongTermRetentionBackupsDeleteFuture) result(client LongTermRetentionBackupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.LongTermRetentionBackupsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LongTermRetentionBackupsUpdateByResourceGroupFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type LongTermRetentionBackupsUpdateByResourceGroupFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LongTermRetentionBackupsClient) (LongTermRetentionBackupOperationResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LongTermRetentionBackupsUpdateByResourceGroupFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LongTermRetentionBackupsUpdateByResourceGroupFuture.Result.
func (future *LongTermRetentionBackupsUpdateByResourceGroupFuture) result(client LongTermRetentionBackupsClient) (ltrbor LongTermRetentionBackupOperationResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsUpdateByResourceGroupFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ltrbor.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.LongTermRetentionBackupsUpdateByResourceGroupFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ltrbor.Response.Response, err = future.GetResult(sender); err == nil && ltrbor.Response.Response.StatusCode != http.StatusNoContent {
		ltrbor, err = client.UpdateByResourceGroupResponder(ltrbor.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsUpdateByResourceGroupFuture", "Result", ltrbor.Response.Response, "Failure responding to request")
		}
	}
	return
}

// LongTermRetentionBackupsUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type LongTermRetentionBackupsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LongTermRetentionBackupsClient) (LongTermRetentionBackupOperationResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LongTermRetentionBackupsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LongTermRetentionBackupsUpdateFuture.Result.
func (future *LongTermRetentionBackupsUpdateFuture) result(client LongTermRetentionBackupsClient) (ltrbor LongTermRetentionBackupOperationResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ltrbor.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.LongTermRetentionBackupsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ltrbor.Response.Response, err = future.GetResult(sender); err == nil && ltrbor.Response.Response.StatusCode != http.StatusNoContent {
		ltrbor, err = client.UpdateResponder(ltrbor.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsUpdateFuture", "Result", ltrbor.Response.Response, "Failure responding to request")
		}
	}
	return
}

// LongTermRetentionManagedInstanceBackupsDeleteByResourceGroupFuture an abstraction for monitoring and
// retrieving the results of a long-running operation.
type LongTermRetentionManagedInstanceBackupsDeleteByResourceGroupFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LongTermRetentionManagedInstanceBackupsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LongTermRetentionManagedInstanceBackupsDeleteByResourceGroupFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LongTermRetentionManagedInstanceBackupsDeleteByResourceGroupFuture.Result.
func (future *LongTermRetentionManagedInstanceBackupsDeleteByResourceGroupFuture) result(client LongTermRetentionManagedInstanceBackupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsDeleteByResourceGroupFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.LongTermRetentionManagedInstanceBackupsDeleteByResourceGroupFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LongTermRetentionManagedInstanceBackupsDeleteFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type LongTermRetentionManagedInstanceBackupsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LongTermRetentionManagedInstanceBackupsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LongTermRetentionManagedInstanceBackupsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LongTermRetentionManagedInstanceBackupsDeleteFuture.Result.
func (future *LongTermRetentionManagedInstanceBackupsDeleteFuture) result(client LongTermRetentionManagedInstanceBackupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionManagedInstanceBackupsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.LongTermRetentionManagedInstanceBackupsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LongTermRetentionOperationResultProperties contains the operation result properties for long term
// retention backup operation.
type LongTermRetentionOperationResultProperties struct {
	// RequestID - READ-ONLY; Request Id.
	RequestID *uuid.UUID `json:"requestId,omitempty"`
	// OperationType - READ-ONLY; Operation type.
	OperationType *string `json:"operationType,omitempty"`
	// FromBackupResourceID - READ-ONLY; Source backup resource id
	FromBackupResourceID *string `json:"fromBackupResourceId,omitempty"`
	// ToBackupResourceID - READ-ONLY; Target backup resource id
	ToBackupResourceID *string `json:"toBackupResourceId,omitempty"`
	// TargetBackupStorageRedundancy - READ-ONLY; The storage redundancy type of the copied backup. Possible values include: 'BackupStorageRedundancyGeo', 'BackupStorageRedundancyLocal', 'BackupStorageRedundancyZone', 'BackupStorageRedundancyGeoZone'
	TargetBackupStorageRedundancy BackupStorageRedundancy `json:"targetBackupStorageRedundancy,omitempty"`
	// Status - READ-ONLY; Operation status
	Status *string `json:"status,omitempty"`
	// Message - READ-ONLY; Progress message
	Message *string `json:"message,omitempty"`
}

// MarshalJSON is the custom marshaler for LongTermRetentionOperationResultProperties.
func (ltrorp LongTermRetentionOperationResultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// LongTermRetentionPoliciesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type LongTermRetentionPoliciesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LongTermRetentionPoliciesClient) (LongTermRetentionPolicy, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LongTermRetentionPoliciesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LongTermRetentionPoliciesCreateOrUpdateFuture.Result.
func (future *LongTermRetentionPoliciesCreateOrUpdateFuture) result(client LongTermRetentionPoliciesClient) (ltrp LongTermRetentionPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionPoliciesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ltrp.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.LongTermRetentionPoliciesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ltrp.Response.Response, err = future.GetResult(sender); err == nil && ltrp.Response.Response.StatusCode != http.StatusNoContent {
		ltrp, err = client.CreateOrUpdateResponder(ltrp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.LongTermRetentionPoliciesCreateOrUpdateFuture", "Result", ltrp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// LongTermRetentionPolicy a long term retention policy.
type LongTermRetentionPolicy struct {
	autorest.Response `json:"-"`
	// BaseLongTermRetentionPolicyProperties - Resource properties.
	*BaseLongTermRetentionPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for LongTermRetentionPolicy.
func (ltrp LongTermRetentionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ltrp.BaseLongTermRetentionPolicyProperties != nil {
		objectMap["properties"] = ltrp.BaseLongTermRetentionPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LongTermRetentionPolicy struct.
func (ltrp *LongTermRetentionPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var baseLongTermRetentionPolicyProperties BaseLongTermRetentionPolicyProperties
				err = json.Unmarshal(*v, &baseLongTermRetentionPolicyProperties)
				if err != nil {
					return err
				}
				ltrp.BaseLongTermRetentionPolicyProperties = &baseLongTermRetentionPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ltrp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ltrp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ltrp.Type = &typeVar
			}
		}
	}

	return nil
}

// LongTermRetentionPolicyListResult a list of long term retention policies.
type LongTermRetentionPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]LongTermRetentionPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for LongTermRetentionPolicyListResult.
func (ltrplr LongTermRetentionPolicyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// LongTermRetentionPolicyListResultIterator provides access to a complete listing of
// LongTermRetentionPolicy values.
type LongTermRetentionPolicyListResultIterator struct {
	i    int
	page LongTermRetentionPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LongTermRetentionPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LongTermRetentionPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LongTermRetentionPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LongTermRetentionPolicyListResultIterator) Response() LongTermRetentionPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LongTermRetentionPolicyListResultIterator) Value() LongTermRetentionPolicy {
	if !iter.page.NotDone() {
		return LongTermRetentionPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LongTermRetentionPolicyListResultIterator type.
func NewLongTermRetentionPolicyListResultIterator(page LongTermRetentionPolicyListResultPage) LongTermRetentionPolicyListResultIterator {
	return LongTermRetentionPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ltrplr LongTermRetentionPolicyListResult) IsEmpty() bool {
	return ltrplr.Value == nil || len(*ltrplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ltrplr LongTermRetentionPolicyListResult) hasNextLink() bool {
	return ltrplr.NextLink != nil && len(*ltrplr.NextLink) != 0
}

// longTermRetentionPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ltrplr LongTermRetentionPolicyListResult) longTermRetentionPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ltrplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ltrplr.NextLink)))
}

// LongTermRetentionPolicyListResultPage contains a page of LongTermRetentionPolicy values.
type LongTermRetentionPolicyListResultPage struct {
	fn     func(context.Context, LongTermRetentionPolicyListResult) (LongTermRetentionPolicyListResult, error)
	ltrplr LongTermRetentionPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LongTermRetentionPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ltrplr)
		if err != nil {
			return err
		}
		page.ltrplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LongTermRetentionPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LongTermRetentionPolicyListResultPage) NotDone() bool {
	return !page.ltrplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LongTermRetentionPolicyListResultPage) Response() LongTermRetentionPolicyListResult {
	return page.ltrplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LongTermRetentionPolicyListResultPage) Values() []LongTermRetentionPolicy {
	if page.ltrplr.IsEmpty() {
		return nil
	}
	return *page.ltrplr.Value
}

// Creates a new instance of the LongTermRetentionPolicyListResultPage type.
func NewLongTermRetentionPolicyListResultPage(cur LongTermRetentionPolicyListResult, getNextPage func(context.Context, LongTermRetentionPolicyListResult) (LongTermRetentionPolicyListResult, error)) LongTermRetentionPolicyListResultPage {
	return LongTermRetentionPolicyListResultPage{
		fn:     getNextPage,
		ltrplr: cur,
	}
}

// MaintenanceConfigurationCapability the maintenance configuration capability
type MaintenanceConfigurationCapability struct {
	// Name - READ-ONLY; Maintenance configuration name
	Name *string `json:"name,omitempty"`
	// ZoneRedundant - READ-ONLY; Whether or not zone redundancy is supported for the maintenance configuration.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for MaintenanceConfigurationCapability.
func (mcc MaintenanceConfigurationCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mcc.Reason != nil {
		objectMap["reason"] = mcc.Reason
	}
	return json.Marshal(objectMap)
}

// MaintenanceWindowOptions maintenance window options.
type MaintenanceWindowOptions struct {
	autorest.Response `json:"-"`
	// MaintenanceWindowOptionsProperties - Resource properties.
	*MaintenanceWindowOptionsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for MaintenanceWindowOptions.
func (mwo MaintenanceWindowOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mwo.MaintenanceWindowOptionsProperties != nil {
		objectMap["properties"] = mwo.MaintenanceWindowOptionsProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MaintenanceWindowOptions struct.
func (mwo *MaintenanceWindowOptions) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var maintenanceWindowOptionsProperties MaintenanceWindowOptionsProperties
				err = json.Unmarshal(*v, &maintenanceWindowOptionsProperties)
				if err != nil {
					return err
				}
				mwo.MaintenanceWindowOptionsProperties = &maintenanceWindowOptionsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mwo.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mwo.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mwo.Type = &typeVar
			}
		}
	}

	return nil
}

// MaintenanceWindowOptionsProperties maintenance window options properties.
type MaintenanceWindowOptionsProperties struct {
	// IsEnabled - Whether maintenance windows are enabled for the database.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// MaintenanceWindowCycles - Available maintenance cycles e.g. {Saturday, 0, 48*60}, {Wednesday, 0, 24*60}.
	MaintenanceWindowCycles *[]MaintenanceWindowTimeRange `json:"maintenanceWindowCycles,omitempty"`
	// MinDurationInMinutes - Minimum duration of maintenance window.
	MinDurationInMinutes *int32 `json:"minDurationInMinutes,omitempty"`
	// DefaultDurationInMinutes - Default duration for maintenance window.
	DefaultDurationInMinutes *int32 `json:"defaultDurationInMinutes,omitempty"`
	// MinCycles - Minimum number of maintenance windows cycles to be set on the database.
	MinCycles *int32 `json:"minCycles,omitempty"`
	// TimeGranularityInMinutes - Time granularity in minutes for maintenance windows.
	TimeGranularityInMinutes *int32 `json:"timeGranularityInMinutes,omitempty"`
	// AllowMultipleMaintenanceWindowsPerCycle - Whether we allow multiple maintenance windows per cycle.
	AllowMultipleMaintenanceWindowsPerCycle *bool `json:"allowMultipleMaintenanceWindowsPerCycle,omitempty"`
}

// MaintenanceWindows maintenance windows.
type MaintenanceWindows struct {
	autorest.Response `json:"-"`
	// MaintenanceWindowsProperties - Resource properties.
	*MaintenanceWindowsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for MaintenanceWindows.
func (mw MaintenanceWindows) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mw.MaintenanceWindowsProperties != nil {
		objectMap["properties"] = mw.MaintenanceWindowsProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MaintenanceWindows struct.
func (mw *MaintenanceWindows) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var maintenanceWindowsProperties MaintenanceWindowsProperties
				err = json.Unmarshal(*v, &maintenanceWindowsProperties)
				if err != nil {
					return err
				}
				mw.MaintenanceWindowsProperties = &maintenanceWindowsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mw.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mw.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mw.Type = &typeVar
			}
		}
	}

	return nil
}

// MaintenanceWindowsProperties maintenance windows resource properties.
type MaintenanceWindowsProperties struct {
	TimeRanges *[]MaintenanceWindowTimeRange `json:"timeRanges,omitempty"`
}

// MaintenanceWindowTimeRange maintenance window time range.
type MaintenanceWindowTimeRange struct {
	// DayOfWeek - Day of maintenance window. Possible values include: 'DayOfWeekSunday', 'DayOfWeekMonday', 'DayOfWeekTuesday', 'DayOfWeekWednesday', 'DayOfWeekThursday', 'DayOfWeekFriday', 'DayOfWeekSaturday'
	DayOfWeek DayOfWeek `json:"dayOfWeek,omitempty"`
	// StartTime - Start time minutes offset from 12am.
	StartTime *string `json:"startTime,omitempty"`
	// Duration - Duration of maintenance window in minutes.
	Duration *string `json:"duration,omitempty"`
}

// ManagedBackupShortTermRetentionPoliciesCreateOrUpdateFuture an abstraction for monitoring and retrieving
// the results of a long-running operation.
type ManagedBackupShortTermRetentionPoliciesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedBackupShortTermRetentionPoliciesClient) (ManagedBackupShortTermRetentionPolicy, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedBackupShortTermRetentionPoliciesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedBackupShortTermRetentionPoliciesCreateOrUpdateFuture.Result.
func (future *ManagedBackupShortTermRetentionPoliciesCreateOrUpdateFuture) result(client ManagedBackupShortTermRetentionPoliciesClient) (mbstrp ManagedBackupShortTermRetentionPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedBackupShortTermRetentionPoliciesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		mbstrp.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedBackupShortTermRetentionPoliciesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mbstrp.Response.Response, err = future.GetResult(sender); err == nil && mbstrp.Response.Response.StatusCode != http.StatusNoContent {
		mbstrp, err = client.CreateOrUpdateResponder(mbstrp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedBackupShortTermRetentionPoliciesCreateOrUpdateFuture", "Result", mbstrp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedBackupShortTermRetentionPoliciesUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ManagedBackupShortTermRetentionPoliciesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedBackupShortTermRetentionPoliciesClient) (ManagedBackupShortTermRetentionPolicy, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedBackupShortTermRetentionPoliciesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedBackupShortTermRetentionPoliciesUpdateFuture.Result.
func (future *ManagedBackupShortTermRetentionPoliciesUpdateFuture) result(client ManagedBackupShortTermRetentionPoliciesClient) (mbstrp ManagedBackupShortTermRetentionPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedBackupShortTermRetentionPoliciesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		mbstrp.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedBackupShortTermRetentionPoliciesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mbstrp.Response.Response, err = future.GetResult(sender); err == nil && mbstrp.Response.Response.StatusCode != http.StatusNoContent {
		mbstrp, err = client.UpdateResponder(mbstrp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedBackupShortTermRetentionPoliciesUpdateFuture", "Result", mbstrp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedBackupShortTermRetentionPolicy a short term retention policy.
type ManagedBackupShortTermRetentionPolicy struct {
	autorest.Response `json:"-"`
	// ManagedBackupShortTermRetentionPolicyProperties - Resource properties.
	*ManagedBackupShortTermRetentionPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedBackupShortTermRetentionPolicy.
func (mbstrp ManagedBackupShortTermRetentionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mbstrp.ManagedBackupShortTermRetentionPolicyProperties != nil {
		objectMap["properties"] = mbstrp.ManagedBackupShortTermRetentionPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedBackupShortTermRetentionPolicy struct.
func (mbstrp *ManagedBackupShortTermRetentionPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedBackupShortTermRetentionPolicyProperties ManagedBackupShortTermRetentionPolicyProperties
				err = json.Unmarshal(*v, &managedBackupShortTermRetentionPolicyProperties)
				if err != nil {
					return err
				}
				mbstrp.ManagedBackupShortTermRetentionPolicyProperties = &managedBackupShortTermRetentionPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mbstrp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mbstrp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mbstrp.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedBackupShortTermRetentionPolicyListResult a list of short term retention policies.
type ManagedBackupShortTermRetentionPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedBackupShortTermRetentionPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedBackupShortTermRetentionPolicyListResult.
func (mbstrplr ManagedBackupShortTermRetentionPolicyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedBackupShortTermRetentionPolicyListResultIterator provides access to a complete listing of
// ManagedBackupShortTermRetentionPolicy values.
type ManagedBackupShortTermRetentionPolicyListResultIterator struct {
	i    int
	page ManagedBackupShortTermRetentionPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedBackupShortTermRetentionPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedBackupShortTermRetentionPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedBackupShortTermRetentionPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedBackupShortTermRetentionPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedBackupShortTermRetentionPolicyListResultIterator) Response() ManagedBackupShortTermRetentionPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedBackupShortTermRetentionPolicyListResultIterator) Value() ManagedBackupShortTermRetentionPolicy {
	if !iter.page.NotDone() {
		return ManagedBackupShortTermRetentionPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedBackupShortTermRetentionPolicyListResultIterator type.
func NewManagedBackupShortTermRetentionPolicyListResultIterator(page ManagedBackupShortTermRetentionPolicyListResultPage) ManagedBackupShortTermRetentionPolicyListResultIterator {
	return ManagedBackupShortTermRetentionPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mbstrplr ManagedBackupShortTermRetentionPolicyListResult) IsEmpty() bool {
	return mbstrplr.Value == nil || len(*mbstrplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mbstrplr ManagedBackupShortTermRetentionPolicyListResult) hasNextLink() bool {
	return mbstrplr.NextLink != nil && len(*mbstrplr.NextLink) != 0
}

// managedBackupShortTermRetentionPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mbstrplr ManagedBackupShortTermRetentionPolicyListResult) managedBackupShortTermRetentionPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mbstrplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mbstrplr.NextLink)))
}

// ManagedBackupShortTermRetentionPolicyListResultPage contains a page of
// ManagedBackupShortTermRetentionPolicy values.
type ManagedBackupShortTermRetentionPolicyListResultPage struct {
	fn       func(context.Context, ManagedBackupShortTermRetentionPolicyListResult) (ManagedBackupShortTermRetentionPolicyListResult, error)
	mbstrplr ManagedBackupShortTermRetentionPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedBackupShortTermRetentionPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedBackupShortTermRetentionPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mbstrplr)
		if err != nil {
			return err
		}
		page.mbstrplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedBackupShortTermRetentionPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedBackupShortTermRetentionPolicyListResultPage) NotDone() bool {
	return !page.mbstrplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedBackupShortTermRetentionPolicyListResultPage) Response() ManagedBackupShortTermRetentionPolicyListResult {
	return page.mbstrplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedBackupShortTermRetentionPolicyListResultPage) Values() []ManagedBackupShortTermRetentionPolicy {
	if page.mbstrplr.IsEmpty() {
		return nil
	}
	return *page.mbstrplr.Value
}

// Creates a new instance of the ManagedBackupShortTermRetentionPolicyListResultPage type.
func NewManagedBackupShortTermRetentionPolicyListResultPage(cur ManagedBackupShortTermRetentionPolicyListResult, getNextPage func(context.Context, ManagedBackupShortTermRetentionPolicyListResult) (ManagedBackupShortTermRetentionPolicyListResult, error)) ManagedBackupShortTermRetentionPolicyListResultPage {
	return ManagedBackupShortTermRetentionPolicyListResultPage{
		fn:       getNextPage,
		mbstrplr: cur,
	}
}

// ManagedBackupShortTermRetentionPolicyProperties properties of a short term retention policy
type ManagedBackupShortTermRetentionPolicyProperties struct {
	// RetentionDays - The backup retention period in days. This is how many days Point-in-Time Restore will be supported.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
}

// ManagedDatabase a managed database resource.
type ManagedDatabase struct {
	autorest.Response `json:"-"`
	// ManagedDatabaseProperties - Resource properties.
	*ManagedDatabaseProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedDatabase.
func (md ManagedDatabase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if md.ManagedDatabaseProperties != nil {
		objectMap["properties"] = md.ManagedDatabaseProperties
	}
	if md.Location != nil {
		objectMap["location"] = md.Location
	}
	if md.Tags != nil {
		objectMap["tags"] = md.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedDatabase struct.
func (md *ManagedDatabase) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedDatabaseProperties ManagedDatabaseProperties
				err = json.Unmarshal(*v, &managedDatabaseProperties)
				if err != nil {
					return err
				}
				md.ManagedDatabaseProperties = &managedDatabaseProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				md.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				md.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				md.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				md.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				md.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedDatabaseAdvancedThreatProtection a managed database Advanced Threat Protection.
type ManagedDatabaseAdvancedThreatProtection struct {
	autorest.Response `json:"-"`
	// SystemData - READ-ONLY; SystemData of AdvancedThreatProtectionResource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// AdvancedThreatProtectionProperties - Resource properties.
	*AdvancedThreatProtectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedDatabaseAdvancedThreatProtection.
func (mdatp ManagedDatabaseAdvancedThreatProtection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdatp.AdvancedThreatProtectionProperties != nil {
		objectMap["properties"] = mdatp.AdvancedThreatProtectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedDatabaseAdvancedThreatProtection struct.
func (mdatp *ManagedDatabaseAdvancedThreatProtection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				mdatp.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var advancedThreatProtectionProperties AdvancedThreatProtectionProperties
				err = json.Unmarshal(*v, &advancedThreatProtectionProperties)
				if err != nil {
					return err
				}
				mdatp.AdvancedThreatProtectionProperties = &advancedThreatProtectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mdatp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mdatp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mdatp.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedDatabaseAdvancedThreatProtectionListResult a list of the managed database's Advanced Threat
// Protection settings.
type ManagedDatabaseAdvancedThreatProtectionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedDatabaseAdvancedThreatProtection `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedDatabaseAdvancedThreatProtectionListResult.
func (mdatplr ManagedDatabaseAdvancedThreatProtectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedDatabaseAdvancedThreatProtectionListResultIterator provides access to a complete listing of
// ManagedDatabaseAdvancedThreatProtection values.
type ManagedDatabaseAdvancedThreatProtectionListResultIterator struct {
	i    int
	page ManagedDatabaseAdvancedThreatProtectionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedDatabaseAdvancedThreatProtectionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedDatabaseAdvancedThreatProtectionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedDatabaseAdvancedThreatProtectionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedDatabaseAdvancedThreatProtectionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedDatabaseAdvancedThreatProtectionListResultIterator) Response() ManagedDatabaseAdvancedThreatProtectionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedDatabaseAdvancedThreatProtectionListResultIterator) Value() ManagedDatabaseAdvancedThreatProtection {
	if !iter.page.NotDone() {
		return ManagedDatabaseAdvancedThreatProtection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedDatabaseAdvancedThreatProtectionListResultIterator type.
func NewManagedDatabaseAdvancedThreatProtectionListResultIterator(page ManagedDatabaseAdvancedThreatProtectionListResultPage) ManagedDatabaseAdvancedThreatProtectionListResultIterator {
	return ManagedDatabaseAdvancedThreatProtectionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mdatplr ManagedDatabaseAdvancedThreatProtectionListResult) IsEmpty() bool {
	return mdatplr.Value == nil || len(*mdatplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mdatplr ManagedDatabaseAdvancedThreatProtectionListResult) hasNextLink() bool {
	return mdatplr.NextLink != nil && len(*mdatplr.NextLink) != 0
}

// managedDatabaseAdvancedThreatProtectionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mdatplr ManagedDatabaseAdvancedThreatProtectionListResult) managedDatabaseAdvancedThreatProtectionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mdatplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mdatplr.NextLink)))
}

// ManagedDatabaseAdvancedThreatProtectionListResultPage contains a page of
// ManagedDatabaseAdvancedThreatProtection values.
type ManagedDatabaseAdvancedThreatProtectionListResultPage struct {
	fn      func(context.Context, ManagedDatabaseAdvancedThreatProtectionListResult) (ManagedDatabaseAdvancedThreatProtectionListResult, error)
	mdatplr ManagedDatabaseAdvancedThreatProtectionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedDatabaseAdvancedThreatProtectionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedDatabaseAdvancedThreatProtectionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mdatplr)
		if err != nil {
			return err
		}
		page.mdatplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedDatabaseAdvancedThreatProtectionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedDatabaseAdvancedThreatProtectionListResultPage) NotDone() bool {
	return !page.mdatplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedDatabaseAdvancedThreatProtectionListResultPage) Response() ManagedDatabaseAdvancedThreatProtectionListResult {
	return page.mdatplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedDatabaseAdvancedThreatProtectionListResultPage) Values() []ManagedDatabaseAdvancedThreatProtection {
	if page.mdatplr.IsEmpty() {
		return nil
	}
	return *page.mdatplr.Value
}

// Creates a new instance of the ManagedDatabaseAdvancedThreatProtectionListResultPage type.
func NewManagedDatabaseAdvancedThreatProtectionListResultPage(cur ManagedDatabaseAdvancedThreatProtectionListResult, getNextPage func(context.Context, ManagedDatabaseAdvancedThreatProtectionListResult) (ManagedDatabaseAdvancedThreatProtectionListResult, error)) ManagedDatabaseAdvancedThreatProtectionListResultPage {
	return ManagedDatabaseAdvancedThreatProtectionListResultPage{
		fn:      getNextPage,
		mdatplr: cur,
	}
}

// ManagedDatabaseListResult a list of managed databases.
type ManagedDatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedDatabase `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedDatabaseListResult.
func (mdlr ManagedDatabaseListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedDatabaseListResultIterator provides access to a complete listing of ManagedDatabase values.
type ManagedDatabaseListResultIterator struct {
	i    int
	page ManagedDatabaseListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedDatabaseListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedDatabaseListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedDatabaseListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedDatabaseListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedDatabaseListResultIterator) Response() ManagedDatabaseListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedDatabaseListResultIterator) Value() ManagedDatabase {
	if !iter.page.NotDone() {
		return ManagedDatabase{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedDatabaseListResultIterator type.
func NewManagedDatabaseListResultIterator(page ManagedDatabaseListResultPage) ManagedDatabaseListResultIterator {
	return ManagedDatabaseListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mdlr ManagedDatabaseListResult) IsEmpty() bool {
	return mdlr.Value == nil || len(*mdlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mdlr ManagedDatabaseListResult) hasNextLink() bool {
	return mdlr.NextLink != nil && len(*mdlr.NextLink) != 0
}

// managedDatabaseListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mdlr ManagedDatabaseListResult) managedDatabaseListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mdlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mdlr.NextLink)))
}

// ManagedDatabaseListResultPage contains a page of ManagedDatabase values.
type ManagedDatabaseListResultPage struct {
	fn   func(context.Context, ManagedDatabaseListResult) (ManagedDatabaseListResult, error)
	mdlr ManagedDatabaseListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedDatabaseListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedDatabaseListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mdlr)
		if err != nil {
			return err
		}
		page.mdlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedDatabaseListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedDatabaseListResultPage) NotDone() bool {
	return !page.mdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedDatabaseListResultPage) Response() ManagedDatabaseListResult {
	return page.mdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedDatabaseListResultPage) Values() []ManagedDatabase {
	if page.mdlr.IsEmpty() {
		return nil
	}
	return *page.mdlr.Value
}

// Creates a new instance of the ManagedDatabaseListResultPage type.
func NewManagedDatabaseListResultPage(cur ManagedDatabaseListResult, getNextPage func(context.Context, ManagedDatabaseListResult) (ManagedDatabaseListResult, error)) ManagedDatabaseListResultPage {
	return ManagedDatabaseListResultPage{
		fn:   getNextPage,
		mdlr: cur,
	}
}

// ManagedDatabaseMoveDefinition contains the information necessary to perform a managed database move.
type ManagedDatabaseMoveDefinition struct {
	// DestinationManagedDatabaseID - The destination managed database ID
	DestinationManagedDatabaseID *string `json:"destinationManagedDatabaseId,omitempty"`
}

// ManagedDatabaseMoveOperationListResult list of managed database move operations.
type ManagedDatabaseMoveOperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedDatabaseMoveOperationResult `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedDatabaseMoveOperationListResult.
func (mdmolr ManagedDatabaseMoveOperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedDatabaseMoveOperationListResultIterator provides access to a complete listing of
// ManagedDatabaseMoveOperationResult values.
type ManagedDatabaseMoveOperationListResultIterator struct {
	i    int
	page ManagedDatabaseMoveOperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedDatabaseMoveOperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedDatabaseMoveOperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedDatabaseMoveOperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedDatabaseMoveOperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedDatabaseMoveOperationListResultIterator) Response() ManagedDatabaseMoveOperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedDatabaseMoveOperationListResultIterator) Value() ManagedDatabaseMoveOperationResult {
	if !iter.page.NotDone() {
		return ManagedDatabaseMoveOperationResult{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedDatabaseMoveOperationListResultIterator type.
func NewManagedDatabaseMoveOperationListResultIterator(page ManagedDatabaseMoveOperationListResultPage) ManagedDatabaseMoveOperationListResultIterator {
	return ManagedDatabaseMoveOperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mdmolr ManagedDatabaseMoveOperationListResult) IsEmpty() bool {
	return mdmolr.Value == nil || len(*mdmolr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mdmolr ManagedDatabaseMoveOperationListResult) hasNextLink() bool {
	return mdmolr.NextLink != nil && len(*mdmolr.NextLink) != 0
}

// managedDatabaseMoveOperationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mdmolr ManagedDatabaseMoveOperationListResult) managedDatabaseMoveOperationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mdmolr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mdmolr.NextLink)))
}

// ManagedDatabaseMoveOperationListResultPage contains a page of ManagedDatabaseMoveOperationResult values.
type ManagedDatabaseMoveOperationListResultPage struct {
	fn     func(context.Context, ManagedDatabaseMoveOperationListResult) (ManagedDatabaseMoveOperationListResult, error)
	mdmolr ManagedDatabaseMoveOperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedDatabaseMoveOperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedDatabaseMoveOperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mdmolr)
		if err != nil {
			return err
		}
		page.mdmolr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedDatabaseMoveOperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedDatabaseMoveOperationListResultPage) NotDone() bool {
	return !page.mdmolr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedDatabaseMoveOperationListResultPage) Response() ManagedDatabaseMoveOperationListResult {
	return page.mdmolr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedDatabaseMoveOperationListResultPage) Values() []ManagedDatabaseMoveOperationResult {
	if page.mdmolr.IsEmpty() {
		return nil
	}
	return *page.mdmolr.Value
}

// Creates a new instance of the ManagedDatabaseMoveOperationListResultPage type.
func NewManagedDatabaseMoveOperationListResultPage(cur ManagedDatabaseMoveOperationListResult, getNextPage func(context.Context, ManagedDatabaseMoveOperationListResult) (ManagedDatabaseMoveOperationListResult, error)) ManagedDatabaseMoveOperationListResultPage {
	return ManagedDatabaseMoveOperationListResultPage{
		fn:     getNextPage,
		mdmolr: cur,
	}
}

// ManagedDatabaseMoveOperationResult a managed database move operation.
type ManagedDatabaseMoveOperationResult struct {
	autorest.Response `json:"-"`
	// ManagedDatabaseMoveOperationResultProperties - Resource properties.
	*ManagedDatabaseMoveOperationResultProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedDatabaseMoveOperationResult.
func (mdmor ManagedDatabaseMoveOperationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdmor.ManagedDatabaseMoveOperationResultProperties != nil {
		objectMap["properties"] = mdmor.ManagedDatabaseMoveOperationResultProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedDatabaseMoveOperationResult struct.
func (mdmor *ManagedDatabaseMoveOperationResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedDatabaseMoveOperationResultProperties ManagedDatabaseMoveOperationResultProperties
				err = json.Unmarshal(*v, &managedDatabaseMoveOperationResultProperties)
				if err != nil {
					return err
				}
				mdmor.ManagedDatabaseMoveOperationResultProperties = &managedDatabaseMoveOperationResultProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mdmor.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mdmor.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mdmor.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedDatabaseMoveOperationResultProperties contains the operation result properties for managed
// database move operation.
type ManagedDatabaseMoveOperationResultProperties struct {
	// Operation - READ-ONLY; The name of operation.
	Operation *string `json:"operation,omitempty"`
	// OperationFriendlyName - READ-ONLY; The friendly name of operation.
	OperationFriendlyName *string `json:"operationFriendlyName,omitempty"`
	// StartTime - READ-ONLY; The operation start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// State - READ-ONLY; The operation state. Possible values include: 'ManagementOperationStatePending', 'ManagementOperationStateInProgress', 'ManagementOperationStateSucceeded', 'ManagementOperationStateFailed', 'ManagementOperationStateCancelInProgress', 'ManagementOperationStateCancelled'
	State ManagementOperationState `json:"state,omitempty"`
	// OperationMode - READ-ONLY; Operation mode. Possible values include: 'MoveOperationModeMove', 'MoveOperationModeCopy'
	OperationMode MoveOperationMode `json:"operationMode,omitempty"`
	// SourceManagedInstanceName - READ-ONLY; Source Managed Instance name.
	SourceManagedInstanceName *string `json:"sourceManagedInstanceName,omitempty"`
	// TargetManagedInstanceName - READ-ONLY; Target Managed Instance name.
	TargetManagedInstanceName *string `json:"targetManagedInstanceName,omitempty"`
	// SourceManagedInstanceID - READ-ONLY; Source Managed Instance resource id.
	SourceManagedInstanceID *string `json:"sourceManagedInstanceId,omitempty"`
	// TargetManagedInstanceID - READ-ONLY; Target Managed instance resource id.
	TargetManagedInstanceID *string `json:"targetManagedInstanceId,omitempty"`
	// SourceDatabaseName - READ-ONLY; Source database name.
	SourceDatabaseName *string `json:"sourceDatabaseName,omitempty"`
	// TargetDatabaseName - READ-ONLY; Target database name.
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty"`
	// IsCancellable - READ-ONLY; Is move operation cancellable.
	IsCancellable *bool `json:"isCancellable,omitempty"`
	// ErrorCode - READ-ONLY; The operation error code.
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// ErrorDescription - READ-ONLY; The operation error description.
	ErrorDescription *string `json:"errorDescription,omitempty"`
	// ErrorSeverity - READ-ONLY; The operation error severity.
	ErrorSeverity *int32 `json:"errorSeverity,omitempty"`
	// IsUserError - READ-ONLY; Whether or not the error is a user error.
	IsUserError *bool `json:"isUserError,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedDatabaseMoveOperationResultProperties.
func (mdmorp ManagedDatabaseMoveOperationResultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedDatabaseProperties the managed database's properties.
type ManagedDatabaseProperties struct {
	// Collation - Collation of the managed database.
	Collation *string `json:"collation,omitempty"`
	// Status - READ-ONLY; Status of the database. Possible values include: 'ManagedDatabaseStatusOnline', 'ManagedDatabaseStatusOffline', 'ManagedDatabaseStatusShutdown', 'ManagedDatabaseStatusCreating', 'ManagedDatabaseStatusInaccessible', 'ManagedDatabaseStatusRestoring', 'ManagedDatabaseStatusUpdating'
	Status ManagedDatabaseStatus `json:"status,omitempty"`
	// CreationDate - READ-ONLY; Creation date of the database.
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// EarliestRestorePoint - READ-ONLY; Earliest restore point in time for point in time restore.
	EarliestRestorePoint *date.Time `json:"earliestRestorePoint,omitempty"`
	// RestorePointInTime - Conditional. If createMode is PointInTimeRestore, this value is required. Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new database.
	RestorePointInTime *date.Time `json:"restorePointInTime,omitempty"`
	// DefaultSecondaryLocation - READ-ONLY; Geo paired region.
	DefaultSecondaryLocation *string `json:"defaultSecondaryLocation,omitempty"`
	// CatalogCollation - Collation of the metadata catalog. Possible values include: 'CatalogCollationTypeDATABASEDEFAULT', 'CatalogCollationTypeSQLLatin1GeneralCP1CIAS'
	CatalogCollation CatalogCollationType `json:"catalogCollation,omitempty"`
	// CreateMode - Managed database create mode. PointInTimeRestore: Create a database by restoring a point in time backup of an existing database. SourceDatabaseName, SourceManagedInstanceName and PointInTime must be specified. RestoreExternalBackup: Create a database by restoring from external backup files. Collation, StorageContainerUri and StorageContainerSasToken must be specified. Recovery: Creates a database by restoring a geo-replicated backup. RecoverableDatabaseId must be specified as the recoverable database resource ID to restore. RestoreLongTermRetentionBackup: Create a database by restoring from a long term retention backup (longTermRetentionBackupResourceId required). Possible values include: 'ManagedDatabaseCreateModeDefault', 'ManagedDatabaseCreateModeRestoreExternalBackup', 'ManagedDatabaseCreateModePointInTimeRestore', 'ManagedDatabaseCreateModeRecovery', 'ManagedDatabaseCreateModeRestoreLongTermRetentionBackup'
	CreateMode ManagedDatabaseCreateMode `json:"createMode,omitempty"`
	// StorageContainerURI - Conditional. If createMode is RestoreExternalBackup, this value is required. Specifies the uri of the storage container where backups for this restore are stored.
	StorageContainerURI *string `json:"storageContainerUri,omitempty"`
	// SourceDatabaseID - The resource identifier of the source database associated with create operation of this database.
	SourceDatabaseID *string `json:"sourceDatabaseId,omitempty"`
	// RestorableDroppedDatabaseID - The restorable dropped database resource id to restore when creating this database.
	RestorableDroppedDatabaseID *string `json:"restorableDroppedDatabaseId,omitempty"`
	// StorageContainerIdentity - Conditional. If createMode is RestoreExternalBackup, this value is used. Specifies the identity used for storage container authentication. Can be 'SharedAccessSignature' or 'ManagedIdentity'; if not specified 'SharedAccessSignature' is assumed.
	StorageContainerIdentity *string `json:"storageContainerIdentity,omitempty"`
	// StorageContainerSasToken - Conditional. If createMode is RestoreExternalBackup and storageContainerIdentity is not ManagedIdentity, this value is required. Specifies the storage container sas token.
	StorageContainerSasToken *string `json:"storageContainerSasToken,omitempty"`
	// FailoverGroupID - READ-ONLY; Instance Failover Group resource identifier that this managed database belongs to.
	FailoverGroupID *string `json:"failoverGroupId,omitempty"`
	// RecoverableDatabaseID - The resource identifier of the recoverable database associated with create operation of this database.
	RecoverableDatabaseID *string `json:"recoverableDatabaseId,omitempty"`
	// LongTermRetentionBackupResourceID - The name of the Long Term Retention backup to be used for restore of this managed database.
	LongTermRetentionBackupResourceID *string `json:"longTermRetentionBackupResourceId,omitempty"`
	// AutoCompleteRestore - Whether to auto complete restore of this managed database.
	AutoCompleteRestore *bool `json:"autoCompleteRestore,omitempty"`
	// LastBackupName - Last backup file name for restore of this managed database.
	LastBackupName *string `json:"lastBackupName,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedDatabaseProperties.
func (mdp ManagedDatabaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdp.Collation != nil {
		objectMap["collation"] = mdp.Collation
	}
	if mdp.RestorePointInTime != nil {
		objectMap["restorePointInTime"] = mdp.RestorePointInTime
	}
	if mdp.CatalogCollation != "" {
		objectMap["catalogCollation"] = mdp.CatalogCollation
	}
	if mdp.CreateMode != "" {
		objectMap["createMode"] = mdp.CreateMode
	}
	if mdp.StorageContainerURI != nil {
		objectMap["storageContainerUri"] = mdp.StorageContainerURI
	}
	if mdp.SourceDatabaseID != nil {
		objectMap["sourceDatabaseId"] = mdp.SourceDatabaseID
	}
	if mdp.RestorableDroppedDatabaseID != nil {
		objectMap["restorableDroppedDatabaseId"] = mdp.RestorableDroppedDatabaseID
	}
	if mdp.StorageContainerIdentity != nil {
		objectMap["storageContainerIdentity"] = mdp.StorageContainerIdentity
	}
	if mdp.StorageContainerSasToken != nil {
		objectMap["storageContainerSasToken"] = mdp.StorageContainerSasToken
	}
	if mdp.RecoverableDatabaseID != nil {
		objectMap["recoverableDatabaseId"] = mdp.RecoverableDatabaseID
	}
	if mdp.LongTermRetentionBackupResourceID != nil {
		objectMap["longTermRetentionBackupResourceId"] = mdp.LongTermRetentionBackupResourceID
	}
	if mdp.AutoCompleteRestore != nil {
		objectMap["autoCompleteRestore"] = mdp.AutoCompleteRestore
	}
	if mdp.LastBackupName != nil {
		objectMap["lastBackupName"] = mdp.LastBackupName
	}
	return json.Marshal(objectMap)
}

// ManagedDatabaseRestoreDetailsBackupSetProperties the managed database's restore details backup set
// properties.
type ManagedDatabaseRestoreDetailsBackupSetProperties struct {
	// Status - READ-ONLY; Backup set status.
	Status *string `json:"status,omitempty"`
	// FirstStripeName - READ-ONLY; First stripe name.
	FirstStripeName *string `json:"firstStripeName,omitempty"`
	// NumberOfStripes - READ-ONLY; Number of stripes.
	NumberOfStripes *int32 `json:"numberOfStripes,omitempty"`
	// BackupSizeMB - READ-ONLY; Backup size.
	BackupSizeMB *int32 `json:"backupSizeMB,omitempty"`
	// RestoreStartedTimestampUtc - READ-ONLY; Last restored file time.
	RestoreStartedTimestampUtc *date.Time `json:"restoreStartedTimestampUtc,omitempty"`
	// RestoreFinishedTimestampUtc - READ-ONLY; Last restored file time.
	RestoreFinishedTimestampUtc *date.Time `json:"restoreFinishedTimestampUtc,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedDatabaseRestoreDetailsBackupSetProperties.
func (mdrdbsp ManagedDatabaseRestoreDetailsBackupSetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedDatabaseRestoreDetailsProperties the managed database's restore details properties.
type ManagedDatabaseRestoreDetailsProperties struct {
	// Type - READ-ONLY; Restore type.
	Type *string `json:"type,omitempty"`
	// Status - READ-ONLY; Restore status.
	Status *string `json:"status,omitempty"`
	// BlockReason - READ-ONLY; The reason why restore is in Blocked state.
	BlockReason *string `json:"blockReason,omitempty"`
	// LastUploadedFileName - READ-ONLY; Last uploaded file name.
	LastUploadedFileName *string `json:"lastUploadedFileName,omitempty"`
	// LastUploadedFileTime - READ-ONLY; Last uploaded file time.
	LastUploadedFileTime *date.Time `json:"lastUploadedFileTime,omitempty"`
	// LastRestoredFileName - READ-ONLY; Last restored file name.
	LastRestoredFileName *string `json:"lastRestoredFileName,omitempty"`
	// LastRestoredFileTime - READ-ONLY; Last restored file time.
	LastRestoredFileTime *date.Time `json:"lastRestoredFileTime,omitempty"`
	// PercentCompleted - READ-ONLY; Percent completed.
	PercentCompleted *int32 `json:"percentCompleted,omitempty"`
	// CurrentRestoredSizeMB - READ-ONLY; Current restored size MB.
	CurrentRestoredSizeMB *int32 `json:"currentRestoredSizeMB,omitempty"`
	// CurrentRestorePlanSizeMB - READ-ONLY; Current restore plan size MB.
	CurrentRestorePlanSizeMB *int32 `json:"currentRestorePlanSizeMB,omitempty"`
	// CurrentBackupType - READ-ONLY; Current backup type.
	CurrentBackupType *string `json:"currentBackupType,omitempty"`
	// CurrentRestoringFileName - READ-ONLY; Current restoring file name.
	CurrentRestoringFileName *string `json:"currentRestoringFileName,omitempty"`
	// NumberOfFilesDetected - READ-ONLY; Number of files detected.
	NumberOfFilesDetected *int32 `json:"numberOfFilesDetected,omitempty"`
	// NumberOfFilesQueued - READ-ONLY; Number of files queued.
	NumberOfFilesQueued *int32 `json:"numberOfFilesQueued,omitempty"`
	// NumberOfFilesSkipped - READ-ONLY; Number of files skipped.
	NumberOfFilesSkipped *int32 `json:"numberOfFilesSkipped,omitempty"`
	// NumberOfFilesRestoring - READ-ONLY; Number of files restoring.
	NumberOfFilesRestoring *int32 `json:"numberOfFilesRestoring,omitempty"`
	// NumberOfFilesRestored - READ-ONLY; Number of files restored.
	NumberOfFilesRestored *int32 `json:"numberOfFilesRestored,omitempty"`
	// NumberOfFilesUnrestorable - READ-ONLY; Number of files unrestorable.
	NumberOfFilesUnrestorable *int32 `json:"numberOfFilesUnrestorable,omitempty"`
	// FullBackupSets - READ-ONLY; Full backup sets.
	FullBackupSets *[]ManagedDatabaseRestoreDetailsBackupSetProperties `json:"fullBackupSets,omitempty"`
	// DiffBackupSets - READ-ONLY; Diff backup sets.
	DiffBackupSets *[]ManagedDatabaseRestoreDetailsBackupSetProperties `json:"diffBackupSets,omitempty"`
	// LogBackupSets - READ-ONLY; Log backup sets.
	LogBackupSets *[]ManagedDatabaseRestoreDetailsBackupSetProperties `json:"logBackupSets,omitempty"`
	// UnrestorableFiles - READ-ONLY; Unrestorable files.
	UnrestorableFiles *[]ManagedDatabaseRestoreDetailsUnrestorableFileProperties `json:"unrestorableFiles,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedDatabaseRestoreDetailsProperties.
func (mdrdp ManagedDatabaseRestoreDetailsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedDatabaseRestoreDetailsResult a managed database restore details.
type ManagedDatabaseRestoreDetailsResult struct {
	autorest.Response `json:"-"`
	// ManagedDatabaseRestoreDetailsProperties - Resource properties.
	*ManagedDatabaseRestoreDetailsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedDatabaseRestoreDetailsResult.
func (mdrdr ManagedDatabaseRestoreDetailsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdrdr.ManagedDatabaseRestoreDetailsProperties != nil {
		objectMap["properties"] = mdrdr.ManagedDatabaseRestoreDetailsProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedDatabaseRestoreDetailsResult struct.
func (mdrdr *ManagedDatabaseRestoreDetailsResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedDatabaseRestoreDetailsProperties ManagedDatabaseRestoreDetailsProperties
				err = json.Unmarshal(*v, &managedDatabaseRestoreDetailsProperties)
				if err != nil {
					return err
				}
				mdrdr.ManagedDatabaseRestoreDetailsProperties = &managedDatabaseRestoreDetailsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mdrdr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mdrdr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mdrdr.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedDatabaseRestoreDetailsUnrestorableFileProperties the managed database's restore details
// unrestorable file properties.
type ManagedDatabaseRestoreDetailsUnrestorableFileProperties struct {
	// Name - READ-ONLY; File name.
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedDatabaseRestoreDetailsUnrestorableFileProperties.
func (mdrdufp ManagedDatabaseRestoreDetailsUnrestorableFileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedDatabasesCancelMoveFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedDatabasesCancelMoveFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedDatabasesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedDatabasesCancelMoveFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedDatabasesCancelMoveFuture.Result.
func (future *ManagedDatabasesCancelMoveFuture) result(client ManagedDatabasesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedDatabasesCancelMoveFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedDatabasesCancelMoveFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedDatabasesCompleteMoveFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedDatabasesCompleteMoveFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedDatabasesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedDatabasesCompleteMoveFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedDatabasesCompleteMoveFuture.Result.
func (future *ManagedDatabasesCompleteMoveFuture) result(client ManagedDatabasesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedDatabasesCompleteMoveFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedDatabasesCompleteMoveFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedDatabasesCompleteRestoreFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedDatabasesCompleteRestoreFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedDatabasesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedDatabasesCompleteRestoreFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedDatabasesCompleteRestoreFuture.Result.
func (future *ManagedDatabasesCompleteRestoreFuture) result(client ManagedDatabasesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedDatabasesCompleteRestoreFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedDatabasesCompleteRestoreFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedDatabasesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedDatabasesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedDatabasesClient) (ManagedDatabase, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedDatabasesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedDatabasesCreateOrUpdateFuture.Result.
func (future *ManagedDatabasesCreateOrUpdateFuture) result(client ManagedDatabasesClient) (md ManagedDatabase, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedDatabasesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		md.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedDatabasesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if md.Response.Response, err = future.GetResult(sender); err == nil && md.Response.Response.StatusCode != http.StatusNoContent {
		md, err = client.CreateOrUpdateResponder(md.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedDatabasesCreateOrUpdateFuture", "Result", md.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedDatabasesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ManagedDatabasesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedDatabasesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedDatabasesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedDatabasesDeleteFuture.Result.
func (future *ManagedDatabasesDeleteFuture) result(client ManagedDatabasesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedDatabasesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedDatabasesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedDatabaseSecurityAlertPolicy a managed database security alert policy.
type ManagedDatabaseSecurityAlertPolicy struct {
	autorest.Response `json:"-"`
	// SecurityAlertPolicyProperties - Resource properties.
	*SecurityAlertPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedDatabaseSecurityAlertPolicy.
func (mdsap ManagedDatabaseSecurityAlertPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdsap.SecurityAlertPolicyProperties != nil {
		objectMap["properties"] = mdsap.SecurityAlertPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedDatabaseSecurityAlertPolicy struct.
func (mdsap *ManagedDatabaseSecurityAlertPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var securityAlertPolicyProperties SecurityAlertPolicyProperties
				err = json.Unmarshal(*v, &securityAlertPolicyProperties)
				if err != nil {
					return err
				}
				mdsap.SecurityAlertPolicyProperties = &securityAlertPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mdsap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mdsap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mdsap.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedDatabaseSecurityAlertPolicyListResult a list of the managed database's security alert policies.
type ManagedDatabaseSecurityAlertPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedDatabaseSecurityAlertPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedDatabaseSecurityAlertPolicyListResult.
func (mdsaplr ManagedDatabaseSecurityAlertPolicyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedDatabaseSecurityAlertPolicyListResultIterator provides access to a complete listing of
// ManagedDatabaseSecurityAlertPolicy values.
type ManagedDatabaseSecurityAlertPolicyListResultIterator struct {
	i    int
	page ManagedDatabaseSecurityAlertPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedDatabaseSecurityAlertPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedDatabaseSecurityAlertPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedDatabaseSecurityAlertPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedDatabaseSecurityAlertPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedDatabaseSecurityAlertPolicyListResultIterator) Response() ManagedDatabaseSecurityAlertPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedDatabaseSecurityAlertPolicyListResultIterator) Value() ManagedDatabaseSecurityAlertPolicy {
	if !iter.page.NotDone() {
		return ManagedDatabaseSecurityAlertPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedDatabaseSecurityAlertPolicyListResultIterator type.
func NewManagedDatabaseSecurityAlertPolicyListResultIterator(page ManagedDatabaseSecurityAlertPolicyListResultPage) ManagedDatabaseSecurityAlertPolicyListResultIterator {
	return ManagedDatabaseSecurityAlertPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mdsaplr ManagedDatabaseSecurityAlertPolicyListResult) IsEmpty() bool {
	return mdsaplr.Value == nil || len(*mdsaplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mdsaplr ManagedDatabaseSecurityAlertPolicyListResult) hasNextLink() bool {
	return mdsaplr.NextLink != nil && len(*mdsaplr.NextLink) != 0
}

// managedDatabaseSecurityAlertPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mdsaplr ManagedDatabaseSecurityAlertPolicyListResult) managedDatabaseSecurityAlertPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mdsaplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mdsaplr.NextLink)))
}

// ManagedDatabaseSecurityAlertPolicyListResultPage contains a page of ManagedDatabaseSecurityAlertPolicy
// values.
type ManagedDatabaseSecurityAlertPolicyListResultPage struct {
	fn      func(context.Context, ManagedDatabaseSecurityAlertPolicyListResult) (ManagedDatabaseSecurityAlertPolicyListResult, error)
	mdsaplr ManagedDatabaseSecurityAlertPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedDatabaseSecurityAlertPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedDatabaseSecurityAlertPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mdsaplr)
		if err != nil {
			return err
		}
		page.mdsaplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedDatabaseSecurityAlertPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedDatabaseSecurityAlertPolicyListResultPage) NotDone() bool {
	return !page.mdsaplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedDatabaseSecurityAlertPolicyListResultPage) Response() ManagedDatabaseSecurityAlertPolicyListResult {
	return page.mdsaplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedDatabaseSecurityAlertPolicyListResultPage) Values() []ManagedDatabaseSecurityAlertPolicy {
	if page.mdsaplr.IsEmpty() {
		return nil
	}
	return *page.mdsaplr.Value
}

// Creates a new instance of the ManagedDatabaseSecurityAlertPolicyListResultPage type.
func NewManagedDatabaseSecurityAlertPolicyListResultPage(cur ManagedDatabaseSecurityAlertPolicyListResult, getNextPage func(context.Context, ManagedDatabaseSecurityAlertPolicyListResult) (ManagedDatabaseSecurityAlertPolicyListResult, error)) ManagedDatabaseSecurityAlertPolicyListResultPage {
	return ManagedDatabaseSecurityAlertPolicyListResultPage{
		fn:      getNextPage,
		mdsaplr: cur,
	}
}

// ManagedDatabasesStartMoveFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedDatabasesStartMoveFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedDatabasesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedDatabasesStartMoveFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedDatabasesStartMoveFuture.Result.
func (future *ManagedDatabasesStartMoveFuture) result(client ManagedDatabasesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedDatabasesStartMoveFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedDatabasesStartMoveFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedDatabaseStartMoveDefinition contains the information necessary to start a managed database move.
type ManagedDatabaseStartMoveDefinition struct {
	// DestinationManagedDatabaseID - The destination managed database ID
	DestinationManagedDatabaseID *string `json:"destinationManagedDatabaseId,omitempty"`
	// OperationMode - The move operation mode. Possible values include: 'MoveOperationModeMove', 'MoveOperationModeCopy'
	OperationMode MoveOperationMode `json:"operationMode,omitempty"`
}

// ManagedDatabasesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ManagedDatabasesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedDatabasesClient) (ManagedDatabase, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedDatabasesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedDatabasesUpdateFuture.Result.
func (future *ManagedDatabasesUpdateFuture) result(client ManagedDatabasesClient) (md ManagedDatabase, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedDatabasesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		md.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedDatabasesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if md.Response.Response, err = future.GetResult(sender); err == nil && md.Response.Response.StatusCode != http.StatusNoContent {
		md, err = client.UpdateResponder(md.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedDatabasesUpdateFuture", "Result", md.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedDatabaseUpdate an managed database update.
type ManagedDatabaseUpdate struct {
	// ManagedDatabaseProperties - Resource properties.
	*ManagedDatabaseProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ManagedDatabaseUpdate.
func (mdu ManagedDatabaseUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdu.ManagedDatabaseProperties != nil {
		objectMap["properties"] = mdu.ManagedDatabaseProperties
	}
	if mdu.Tags != nil {
		objectMap["tags"] = mdu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedDatabaseUpdate struct.
func (mdu *ManagedDatabaseUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedDatabaseProperties ManagedDatabaseProperties
				err = json.Unmarshal(*v, &managedDatabaseProperties)
				if err != nil {
					return err
				}
				mdu.ManagedDatabaseProperties = &managedDatabaseProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mdu.Tags = tags
			}
		}
	}

	return nil
}

// ManagedDatabaseVulnerabilityAssessmentScansInitiateScanFuture an abstraction for monitoring and
// retrieving the results of a long-running operation.
type ManagedDatabaseVulnerabilityAssessmentScansInitiateScanFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedDatabaseVulnerabilityAssessmentScansClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedDatabaseVulnerabilityAssessmentScansInitiateScanFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedDatabaseVulnerabilityAssessmentScansInitiateScanFuture.Result.
func (future *ManagedDatabaseVulnerabilityAssessmentScansInitiateScanFuture) result(client ManagedDatabaseVulnerabilityAssessmentScansClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedDatabaseVulnerabilityAssessmentScansInitiateScanFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedDatabaseVulnerabilityAssessmentScansInitiateScanFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedInstance an Azure SQL managed instance.
type ManagedInstance struct {
	autorest.Response `json:"-"`
	// Identity - The Azure Active Directory identity of the managed instance.
	Identity *ResourceIdentity `json:"identity,omitempty"`
	// Sku - Managed instance SKU. Allowed values for sku.name: GP_Gen4, GP_Gen5, BC_Gen4, BC_Gen5
	Sku *Sku `json:"sku,omitempty"`
	// ManagedInstanceProperties - Resource properties.
	*ManagedInstanceProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstance.
func (mi ManagedInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mi.Identity != nil {
		objectMap["identity"] = mi.Identity
	}
	if mi.Sku != nil {
		objectMap["sku"] = mi.Sku
	}
	if mi.ManagedInstanceProperties != nil {
		objectMap["properties"] = mi.ManagedInstanceProperties
	}
	if mi.Location != nil {
		objectMap["location"] = mi.Location
	}
	if mi.Tags != nil {
		objectMap["tags"] = mi.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedInstance struct.
func (mi *ManagedInstance) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "identity":
			if v != nil {
				var identity ResourceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				mi.Identity = &identity
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				mi.Sku = &sku
			}
		case "properties":
			if v != nil {
				var managedInstanceProperties ManagedInstanceProperties
				err = json.Unmarshal(*v, &managedInstanceProperties)
				if err != nil {
					return err
				}
				mi.ManagedInstanceProperties = &managedInstanceProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mi.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mi.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mi.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mi.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedInstanceAdministrator an Azure SQL managed instance administrator.
type ManagedInstanceAdministrator struct {
	autorest.Response `json:"-"`
	// ManagedInstanceAdministratorProperties - Resource properties.
	*ManagedInstanceAdministratorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceAdministrator.
func (mia ManagedInstanceAdministrator) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mia.ManagedInstanceAdministratorProperties != nil {
		objectMap["properties"] = mia.ManagedInstanceAdministratorProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedInstanceAdministrator struct.
func (mia *ManagedInstanceAdministrator) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedInstanceAdministratorProperties ManagedInstanceAdministratorProperties
				err = json.Unmarshal(*v, &managedInstanceAdministratorProperties)
				if err != nil {
					return err
				}
				mia.ManagedInstanceAdministratorProperties = &managedInstanceAdministratorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mia.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mia.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mia.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedInstanceAdministratorListResult a list of managed instance administrators.
type ManagedInstanceAdministratorListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedInstanceAdministrator `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceAdministratorListResult.
func (mialr ManagedInstanceAdministratorListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedInstanceAdministratorListResultIterator provides access to a complete listing of
// ManagedInstanceAdministrator values.
type ManagedInstanceAdministratorListResultIterator struct {
	i    int
	page ManagedInstanceAdministratorListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedInstanceAdministratorListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceAdministratorListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedInstanceAdministratorListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedInstanceAdministratorListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedInstanceAdministratorListResultIterator) Response() ManagedInstanceAdministratorListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedInstanceAdministratorListResultIterator) Value() ManagedInstanceAdministrator {
	if !iter.page.NotDone() {
		return ManagedInstanceAdministrator{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedInstanceAdministratorListResultIterator type.
func NewManagedInstanceAdministratorListResultIterator(page ManagedInstanceAdministratorListResultPage) ManagedInstanceAdministratorListResultIterator {
	return ManagedInstanceAdministratorListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mialr ManagedInstanceAdministratorListResult) IsEmpty() bool {
	return mialr.Value == nil || len(*mialr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mialr ManagedInstanceAdministratorListResult) hasNextLink() bool {
	return mialr.NextLink != nil && len(*mialr.NextLink) != 0
}

// managedInstanceAdministratorListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mialr ManagedInstanceAdministratorListResult) managedInstanceAdministratorListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mialr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mialr.NextLink)))
}

// ManagedInstanceAdministratorListResultPage contains a page of ManagedInstanceAdministrator values.
type ManagedInstanceAdministratorListResultPage struct {
	fn    func(context.Context, ManagedInstanceAdministratorListResult) (ManagedInstanceAdministratorListResult, error)
	mialr ManagedInstanceAdministratorListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedInstanceAdministratorListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceAdministratorListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mialr)
		if err != nil {
			return err
		}
		page.mialr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedInstanceAdministratorListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedInstanceAdministratorListResultPage) NotDone() bool {
	return !page.mialr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedInstanceAdministratorListResultPage) Response() ManagedInstanceAdministratorListResult {
	return page.mialr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedInstanceAdministratorListResultPage) Values() []ManagedInstanceAdministrator {
	if page.mialr.IsEmpty() {
		return nil
	}
	return *page.mialr.Value
}

// Creates a new instance of the ManagedInstanceAdministratorListResultPage type.
func NewManagedInstanceAdministratorListResultPage(cur ManagedInstanceAdministratorListResult, getNextPage func(context.Context, ManagedInstanceAdministratorListResult) (ManagedInstanceAdministratorListResult, error)) ManagedInstanceAdministratorListResultPage {
	return ManagedInstanceAdministratorListResultPage{
		fn:    getNextPage,
		mialr: cur,
	}
}

// ManagedInstanceAdministratorProperties the properties of a managed instance administrator.
type ManagedInstanceAdministratorProperties struct {
	// AdministratorType - Type of the managed instance administrator.
	AdministratorType *string `json:"administratorType,omitempty"`
	// Login - Login name of the managed instance administrator.
	Login *string `json:"login,omitempty"`
	// Sid - SID (object ID) of the managed instance administrator.
	Sid *uuid.UUID `json:"sid,omitempty"`
	// TenantID - Tenant ID of the managed instance administrator.
	TenantID *uuid.UUID `json:"tenantId,omitempty"`
}

// ManagedInstanceAdministratorsCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ManagedInstanceAdministratorsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedInstanceAdministratorsClient) (ManagedInstanceAdministrator, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedInstanceAdministratorsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedInstanceAdministratorsCreateOrUpdateFuture.Result.
func (future *ManagedInstanceAdministratorsCreateOrUpdateFuture) result(client ManagedInstanceAdministratorsClient) (mia ManagedInstanceAdministrator, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstanceAdministratorsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		mia.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstanceAdministratorsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mia.Response.Response, err = future.GetResult(sender); err == nil && mia.Response.Response.StatusCode != http.StatusNoContent {
		mia, err = client.CreateOrUpdateResponder(mia.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedInstanceAdministratorsCreateOrUpdateFuture", "Result", mia.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedInstanceAdministratorsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedInstanceAdministratorsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedInstanceAdministratorsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedInstanceAdministratorsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedInstanceAdministratorsDeleteFuture.Result.
func (future *ManagedInstanceAdministratorsDeleteFuture) result(client ManagedInstanceAdministratorsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstanceAdministratorsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstanceAdministratorsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedInstanceAdvancedThreatProtection a managed instance Advanced Threat Protection.
type ManagedInstanceAdvancedThreatProtection struct {
	autorest.Response `json:"-"`
	// SystemData - READ-ONLY; SystemData of AdvancedThreatProtectionResource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// AdvancedThreatProtectionProperties - Resource properties.
	*AdvancedThreatProtectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceAdvancedThreatProtection.
func (miatp ManagedInstanceAdvancedThreatProtection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if miatp.AdvancedThreatProtectionProperties != nil {
		objectMap["properties"] = miatp.AdvancedThreatProtectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedInstanceAdvancedThreatProtection struct.
func (miatp *ManagedInstanceAdvancedThreatProtection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				miatp.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var advancedThreatProtectionProperties AdvancedThreatProtectionProperties
				err = json.Unmarshal(*v, &advancedThreatProtectionProperties)
				if err != nil {
					return err
				}
				miatp.AdvancedThreatProtectionProperties = &advancedThreatProtectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				miatp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				miatp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				miatp.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedInstanceAdvancedThreatProtectionListResult a list of the managed instance's Advanced Threat
// Protection settings.
type ManagedInstanceAdvancedThreatProtectionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedInstanceAdvancedThreatProtection `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceAdvancedThreatProtectionListResult.
func (miatplr ManagedInstanceAdvancedThreatProtectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedInstanceAdvancedThreatProtectionListResultIterator provides access to a complete listing of
// ManagedInstanceAdvancedThreatProtection values.
type ManagedInstanceAdvancedThreatProtectionListResultIterator struct {
	i    int
	page ManagedInstanceAdvancedThreatProtectionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedInstanceAdvancedThreatProtectionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceAdvancedThreatProtectionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedInstanceAdvancedThreatProtectionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedInstanceAdvancedThreatProtectionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedInstanceAdvancedThreatProtectionListResultIterator) Response() ManagedInstanceAdvancedThreatProtectionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedInstanceAdvancedThreatProtectionListResultIterator) Value() ManagedInstanceAdvancedThreatProtection {
	if !iter.page.NotDone() {
		return ManagedInstanceAdvancedThreatProtection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedInstanceAdvancedThreatProtectionListResultIterator type.
func NewManagedInstanceAdvancedThreatProtectionListResultIterator(page ManagedInstanceAdvancedThreatProtectionListResultPage) ManagedInstanceAdvancedThreatProtectionListResultIterator {
	return ManagedInstanceAdvancedThreatProtectionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (miatplr ManagedInstanceAdvancedThreatProtectionListResult) IsEmpty() bool {
	return miatplr.Value == nil || len(*miatplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (miatplr ManagedInstanceAdvancedThreatProtectionListResult) hasNextLink() bool {
	return miatplr.NextLink != nil && len(*miatplr.NextLink) != 0
}

// managedInstanceAdvancedThreatProtectionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (miatplr ManagedInstanceAdvancedThreatProtectionListResult) managedInstanceAdvancedThreatProtectionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !miatplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(miatplr.NextLink)))
}

// ManagedInstanceAdvancedThreatProtectionListResultPage contains a page of
// ManagedInstanceAdvancedThreatProtection values.
type ManagedInstanceAdvancedThreatProtectionListResultPage struct {
	fn      func(context.Context, ManagedInstanceAdvancedThreatProtectionListResult) (ManagedInstanceAdvancedThreatProtectionListResult, error)
	miatplr ManagedInstanceAdvancedThreatProtectionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedInstanceAdvancedThreatProtectionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceAdvancedThreatProtectionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.miatplr)
		if err != nil {
			return err
		}
		page.miatplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedInstanceAdvancedThreatProtectionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedInstanceAdvancedThreatProtectionListResultPage) NotDone() bool {
	return !page.miatplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedInstanceAdvancedThreatProtectionListResultPage) Response() ManagedInstanceAdvancedThreatProtectionListResult {
	return page.miatplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedInstanceAdvancedThreatProtectionListResultPage) Values() []ManagedInstanceAdvancedThreatProtection {
	if page.miatplr.IsEmpty() {
		return nil
	}
	return *page.miatplr.Value
}

// Creates a new instance of the ManagedInstanceAdvancedThreatProtectionListResultPage type.
func NewManagedInstanceAdvancedThreatProtectionListResultPage(cur ManagedInstanceAdvancedThreatProtectionListResult, getNextPage func(context.Context, ManagedInstanceAdvancedThreatProtectionListResult) (ManagedInstanceAdvancedThreatProtectionListResult, error)) ManagedInstanceAdvancedThreatProtectionListResultPage {
	return ManagedInstanceAdvancedThreatProtectionListResultPage{
		fn:      getNextPage,
		miatplr: cur,
	}
}

// ManagedInstanceAdvancedThreatProtectionSettingsCreateOrUpdateFuture an abstraction for monitoring and
// retrieving the results of a long-running operation.
type ManagedInstanceAdvancedThreatProtectionSettingsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedInstanceAdvancedThreatProtectionSettingsClient) (ManagedInstanceAdvancedThreatProtection, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedInstanceAdvancedThreatProtectionSettingsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedInstanceAdvancedThreatProtectionSettingsCreateOrUpdateFuture.Result.
func (future *ManagedInstanceAdvancedThreatProtectionSettingsCreateOrUpdateFuture) result(client ManagedInstanceAdvancedThreatProtectionSettingsClient) (miatp ManagedInstanceAdvancedThreatProtection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstanceAdvancedThreatProtectionSettingsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		miatp.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstanceAdvancedThreatProtectionSettingsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if miatp.Response.Response, err = future.GetResult(sender); err == nil && miatp.Response.Response.StatusCode != http.StatusNoContent {
		miatp, err = client.CreateOrUpdateResponder(miatp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedInstanceAdvancedThreatProtectionSettingsCreateOrUpdateFuture", "Result", miatp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedInstanceAzureADOnlyAuthentication azure Active Directory only authentication.
type ManagedInstanceAzureADOnlyAuthentication struct {
	autorest.Response `json:"-"`
	// ManagedInstanceAzureADOnlyAuthProperties - Resource properties.
	*ManagedInstanceAzureADOnlyAuthProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceAzureADOnlyAuthentication.
func (miaaoa ManagedInstanceAzureADOnlyAuthentication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if miaaoa.ManagedInstanceAzureADOnlyAuthProperties != nil {
		objectMap["properties"] = miaaoa.ManagedInstanceAzureADOnlyAuthProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedInstanceAzureADOnlyAuthentication struct.
func (miaaoa *ManagedInstanceAzureADOnlyAuthentication) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedInstanceAzureADOnlyAuthProperties ManagedInstanceAzureADOnlyAuthProperties
				err = json.Unmarshal(*v, &managedInstanceAzureADOnlyAuthProperties)
				if err != nil {
					return err
				}
				miaaoa.ManagedInstanceAzureADOnlyAuthProperties = &managedInstanceAzureADOnlyAuthProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				miaaoa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				miaaoa.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				miaaoa.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedInstanceAzureADOnlyAuthenticationsCreateOrUpdateFuture an abstraction for monitoring and
// retrieving the results of a long-running operation.
type ManagedInstanceAzureADOnlyAuthenticationsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedInstanceAzureADOnlyAuthenticationsClient) (ManagedInstanceAzureADOnlyAuthentication, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedInstanceAzureADOnlyAuthenticationsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedInstanceAzureADOnlyAuthenticationsCreateOrUpdateFuture.Result.
func (future *ManagedInstanceAzureADOnlyAuthenticationsCreateOrUpdateFuture) result(client ManagedInstanceAzureADOnlyAuthenticationsClient) (miaaoa ManagedInstanceAzureADOnlyAuthentication, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstanceAzureADOnlyAuthenticationsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		miaaoa.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstanceAzureADOnlyAuthenticationsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if miaaoa.Response.Response, err = future.GetResult(sender); err == nil && miaaoa.Response.Response.StatusCode != http.StatusNoContent {
		miaaoa, err = client.CreateOrUpdateResponder(miaaoa.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedInstanceAzureADOnlyAuthenticationsCreateOrUpdateFuture", "Result", miaaoa.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedInstanceAzureADOnlyAuthenticationsDeleteFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ManagedInstanceAzureADOnlyAuthenticationsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedInstanceAzureADOnlyAuthenticationsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedInstanceAzureADOnlyAuthenticationsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedInstanceAzureADOnlyAuthenticationsDeleteFuture.Result.
func (future *ManagedInstanceAzureADOnlyAuthenticationsDeleteFuture) result(client ManagedInstanceAzureADOnlyAuthenticationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstanceAzureADOnlyAuthenticationsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstanceAzureADOnlyAuthenticationsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedInstanceAzureADOnlyAuthListResult a list of active directory only authentications.
type ManagedInstanceAzureADOnlyAuthListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedInstanceAzureADOnlyAuthentication `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceAzureADOnlyAuthListResult.
func (miaaoalr ManagedInstanceAzureADOnlyAuthListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedInstanceAzureADOnlyAuthListResultIterator provides access to a complete listing of
// ManagedInstanceAzureADOnlyAuthentication values.
type ManagedInstanceAzureADOnlyAuthListResultIterator struct {
	i    int
	page ManagedInstanceAzureADOnlyAuthListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedInstanceAzureADOnlyAuthListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceAzureADOnlyAuthListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedInstanceAzureADOnlyAuthListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedInstanceAzureADOnlyAuthListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedInstanceAzureADOnlyAuthListResultIterator) Response() ManagedInstanceAzureADOnlyAuthListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedInstanceAzureADOnlyAuthListResultIterator) Value() ManagedInstanceAzureADOnlyAuthentication {
	if !iter.page.NotDone() {
		return ManagedInstanceAzureADOnlyAuthentication{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedInstanceAzureADOnlyAuthListResultIterator type.
func NewManagedInstanceAzureADOnlyAuthListResultIterator(page ManagedInstanceAzureADOnlyAuthListResultPage) ManagedInstanceAzureADOnlyAuthListResultIterator {
	return ManagedInstanceAzureADOnlyAuthListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (miaaoalr ManagedInstanceAzureADOnlyAuthListResult) IsEmpty() bool {
	return miaaoalr.Value == nil || len(*miaaoalr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (miaaoalr ManagedInstanceAzureADOnlyAuthListResult) hasNextLink() bool {
	return miaaoalr.NextLink != nil && len(*miaaoalr.NextLink) != 0
}

// managedInstanceAzureADOnlyAuthListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (miaaoalr ManagedInstanceAzureADOnlyAuthListResult) managedInstanceAzureADOnlyAuthListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !miaaoalr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(miaaoalr.NextLink)))
}

// ManagedInstanceAzureADOnlyAuthListResultPage contains a page of ManagedInstanceAzureADOnlyAuthentication
// values.
type ManagedInstanceAzureADOnlyAuthListResultPage struct {
	fn       func(context.Context, ManagedInstanceAzureADOnlyAuthListResult) (ManagedInstanceAzureADOnlyAuthListResult, error)
	miaaoalr ManagedInstanceAzureADOnlyAuthListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedInstanceAzureADOnlyAuthListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceAzureADOnlyAuthListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.miaaoalr)
		if err != nil {
			return err
		}
		page.miaaoalr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedInstanceAzureADOnlyAuthListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedInstanceAzureADOnlyAuthListResultPage) NotDone() bool {
	return !page.miaaoalr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedInstanceAzureADOnlyAuthListResultPage) Response() ManagedInstanceAzureADOnlyAuthListResult {
	return page.miaaoalr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedInstanceAzureADOnlyAuthListResultPage) Values() []ManagedInstanceAzureADOnlyAuthentication {
	if page.miaaoalr.IsEmpty() {
		return nil
	}
	return *page.miaaoalr.Value
}

// Creates a new instance of the ManagedInstanceAzureADOnlyAuthListResultPage type.
func NewManagedInstanceAzureADOnlyAuthListResultPage(cur ManagedInstanceAzureADOnlyAuthListResult, getNextPage func(context.Context, ManagedInstanceAzureADOnlyAuthListResult) (ManagedInstanceAzureADOnlyAuthListResult, error)) ManagedInstanceAzureADOnlyAuthListResultPage {
	return ManagedInstanceAzureADOnlyAuthListResultPage{
		fn:       getNextPage,
		miaaoalr: cur,
	}
}

// ManagedInstanceAzureADOnlyAuthProperties properties of a active directory only authentication for
// Managed Instance.
type ManagedInstanceAzureADOnlyAuthProperties struct {
	// AzureADOnlyAuthentication - Azure Active Directory only Authentication enabled.
	AzureADOnlyAuthentication *bool `json:"azureADOnlyAuthentication,omitempty"`
}

// ManagedInstanceDtc SQL Managed Instance DTC
type ManagedInstanceDtc struct {
	autorest.Response `json:"-"`
	// ManagedInstanceDtcProperties - Resource properties.
	*ManagedInstanceDtcProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceDtc.
func (mid ManagedInstanceDtc) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mid.ManagedInstanceDtcProperties != nil {
		objectMap["properties"] = mid.ManagedInstanceDtcProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedInstanceDtc struct.
func (mid *ManagedInstanceDtc) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedInstanceDtcProperties ManagedInstanceDtcProperties
				err = json.Unmarshal(*v, &managedInstanceDtcProperties)
				if err != nil {
					return err
				}
				mid.ManagedInstanceDtcProperties = &managedInstanceDtcProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mid.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mid.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mid.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedInstanceDtcListResult a list of managed instance's DTCs.
type ManagedInstanceDtcListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedInstanceDtc `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceDtcListResult.
func (midlr ManagedInstanceDtcListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedInstanceDtcListResultIterator provides access to a complete listing of ManagedInstanceDtc values.
type ManagedInstanceDtcListResultIterator struct {
	i    int
	page ManagedInstanceDtcListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedInstanceDtcListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceDtcListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedInstanceDtcListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedInstanceDtcListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedInstanceDtcListResultIterator) Response() ManagedInstanceDtcListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedInstanceDtcListResultIterator) Value() ManagedInstanceDtc {
	if !iter.page.NotDone() {
		return ManagedInstanceDtc{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedInstanceDtcListResultIterator type.
func NewManagedInstanceDtcListResultIterator(page ManagedInstanceDtcListResultPage) ManagedInstanceDtcListResultIterator {
	return ManagedInstanceDtcListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (midlr ManagedInstanceDtcListResult) IsEmpty() bool {
	return midlr.Value == nil || len(*midlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (midlr ManagedInstanceDtcListResult) hasNextLink() bool {
	return midlr.NextLink != nil && len(*midlr.NextLink) != 0
}

// managedInstanceDtcListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (midlr ManagedInstanceDtcListResult) managedInstanceDtcListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !midlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(midlr.NextLink)))
}

// ManagedInstanceDtcListResultPage contains a page of ManagedInstanceDtc values.
type ManagedInstanceDtcListResultPage struct {
	fn    func(context.Context, ManagedInstanceDtcListResult) (ManagedInstanceDtcListResult, error)
	midlr ManagedInstanceDtcListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedInstanceDtcListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceDtcListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.midlr)
		if err != nil {
			return err
		}
		page.midlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedInstanceDtcListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedInstanceDtcListResultPage) NotDone() bool {
	return !page.midlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedInstanceDtcListResultPage) Response() ManagedInstanceDtcListResult {
	return page.midlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedInstanceDtcListResultPage) Values() []ManagedInstanceDtc {
	if page.midlr.IsEmpty() {
		return nil
	}
	return *page.midlr.Value
}

// Creates a new instance of the ManagedInstanceDtcListResultPage type.
func NewManagedInstanceDtcListResultPage(cur ManagedInstanceDtcListResult, getNextPage func(context.Context, ManagedInstanceDtcListResult) (ManagedInstanceDtcListResult, error)) ManagedInstanceDtcListResultPage {
	return ManagedInstanceDtcListResultPage{
		fn:    getNextPage,
		midlr: cur,
	}
}

// ManagedInstanceDtcProperties the properties of managed instance DTC.
type ManagedInstanceDtcProperties struct {
	// DtcEnabled - Active status of managed instance DTC.
	DtcEnabled *bool `json:"dtcEnabled,omitempty"`
	// SecuritySettings - Security settings of managed instance DTC.
	SecuritySettings *ManagedInstanceDtcSecuritySettings `json:"securitySettings,omitempty"`
	// ExternalDNSSuffixSearchList - External dns suffix search list of managed instance DTC.
	ExternalDNSSuffixSearchList *[]string `json:"externalDnsSuffixSearchList,omitempty"`
	// DtcHostNameDNSSuffix - READ-ONLY; Host name dns suffix of managed instance DTC.
	DtcHostNameDNSSuffix *string `json:"dtcHostNameDnsSuffix,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of managed instance DTC. Possible values include: 'ProvisioningStateCreated', 'ProvisioningStateInProgress', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceDtcProperties.
func (midp ManagedInstanceDtcProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if midp.DtcEnabled != nil {
		objectMap["dtcEnabled"] = midp.DtcEnabled
	}
	if midp.SecuritySettings != nil {
		objectMap["securitySettings"] = midp.SecuritySettings
	}
	if midp.ExternalDNSSuffixSearchList != nil {
		objectMap["externalDnsSuffixSearchList"] = midp.ExternalDNSSuffixSearchList
	}
	return json.Marshal(objectMap)
}

// ManagedInstanceDtcsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedInstanceDtcsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedInstanceDtcsClient) (ManagedInstanceDtc, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedInstanceDtcsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedInstanceDtcsCreateOrUpdateFuture.Result.
func (future *ManagedInstanceDtcsCreateOrUpdateFuture) result(client ManagedInstanceDtcsClient) (mid ManagedInstanceDtc, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstanceDtcsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		mid.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstanceDtcsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mid.Response.Response, err = future.GetResult(sender); err == nil && mid.Response.Response.StatusCode != http.StatusNoContent {
		mid, err = client.CreateOrUpdateResponder(mid.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedInstanceDtcsCreateOrUpdateFuture", "Result", mid.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedInstanceDtcSecuritySettings the Security Settings of managed instance DTC.
type ManagedInstanceDtcSecuritySettings struct {
	// TransactionManagerCommunicationSettings - Transaction Manager communication settings of managed instance DTC.
	TransactionManagerCommunicationSettings *ManagedInstanceDtcTransactionManagerCommunicationSettings `json:"transactionManagerCommunicationSettings,omitempty"`
	// XaTransactionsEnabled - Allow XA Transactions to managed instance DTC.
	XaTransactionsEnabled *bool `json:"xaTransactionsEnabled,omitempty"`
	// SnaLu6point2TransactionsEnabled - Allow SNA LU 6.2 Transactions to managed instance DTC.
	SnaLu6point2TransactionsEnabled *bool `json:"snaLu6point2TransactionsEnabled,omitempty"`
	// XaTransactionsDefaultTimeout - Default timeout for XA Transactions (in seconds).
	XaTransactionsDefaultTimeout *int32 `json:"xaTransactionsDefaultTimeout,omitempty"`
	// XaTransactionsMaximumTimeout - Maximum timeout for XA Transactions (in seconds).
	XaTransactionsMaximumTimeout *int32 `json:"xaTransactionsMaximumTimeout,omitempty"`
}

// ManagedInstanceDtcTransactionManagerCommunicationSettings the Transaction Manager Communication Settings
// of managed instance DTC.
type ManagedInstanceDtcTransactionManagerCommunicationSettings struct {
	// AllowInboundEnabled - Allow Inbound traffic to managed instance DTC.
	AllowInboundEnabled *bool `json:"allowInboundEnabled,omitempty"`
	// AllowOutboundEnabled - Allow Outbound traffic of managed instance DTC.
	AllowOutboundEnabled *bool `json:"allowOutboundEnabled,omitempty"`
	// Authentication - Authentication type of managed instance DTC.
	Authentication *string `json:"authentication,omitempty"`
}

// ManagedInstanceEditionCapability the managed server capability
type ManagedInstanceEditionCapability struct {
	// Name - READ-ONLY; The managed server version name.
	Name *string `json:"name,omitempty"`
	// SupportedFamilies - READ-ONLY; The supported families.
	SupportedFamilies *[]ManagedInstanceFamilyCapability `json:"supportedFamilies,omitempty"`
	// SupportedStorageCapabilities - READ-ONLY; The list of supported storage capabilities for this edition
	SupportedStorageCapabilities *[]StorageCapability `json:"supportedStorageCapabilities,omitempty"`
	// ZoneRedundant - READ-ONLY; Whether or not zone redundancy is supported for the edition.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceEditionCapability.
func (miec ManagedInstanceEditionCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if miec.Reason != nil {
		objectMap["reason"] = miec.Reason
	}
	return json.Marshal(objectMap)
}

// ManagedInstanceEncryptionProtector the managed instance encryption protector.
type ManagedInstanceEncryptionProtector struct {
	autorest.Response `json:"-"`
	// Kind - READ-ONLY; Kind of encryption protector. This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// ManagedInstanceEncryptionProtectorProperties - Resource properties.
	*ManagedInstanceEncryptionProtectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceEncryptionProtector.
func (miep ManagedInstanceEncryptionProtector) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if miep.ManagedInstanceEncryptionProtectorProperties != nil {
		objectMap["properties"] = miep.ManagedInstanceEncryptionProtectorProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedInstanceEncryptionProtector struct.
func (miep *ManagedInstanceEncryptionProtector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				miep.Kind = &kind
			}
		case "properties":
			if v != nil {
				var managedInstanceEncryptionProtectorProperties ManagedInstanceEncryptionProtectorProperties
				err = json.Unmarshal(*v, &managedInstanceEncryptionProtectorProperties)
				if err != nil {
					return err
				}
				miep.ManagedInstanceEncryptionProtectorProperties = &managedInstanceEncryptionProtectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				miep.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				miep.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				miep.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedInstanceEncryptionProtectorListResult a list of managed instance encryption protectors.
type ManagedInstanceEncryptionProtectorListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedInstanceEncryptionProtector `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceEncryptionProtectorListResult.
func (mieplr ManagedInstanceEncryptionProtectorListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedInstanceEncryptionProtectorListResultIterator provides access to a complete listing of
// ManagedInstanceEncryptionProtector values.
type ManagedInstanceEncryptionProtectorListResultIterator struct {
	i    int
	page ManagedInstanceEncryptionProtectorListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedInstanceEncryptionProtectorListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceEncryptionProtectorListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedInstanceEncryptionProtectorListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedInstanceEncryptionProtectorListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedInstanceEncryptionProtectorListResultIterator) Response() ManagedInstanceEncryptionProtectorListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedInstanceEncryptionProtectorListResultIterator) Value() ManagedInstanceEncryptionProtector {
	if !iter.page.NotDone() {
		return ManagedInstanceEncryptionProtector{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedInstanceEncryptionProtectorListResultIterator type.
func NewManagedInstanceEncryptionProtectorListResultIterator(page ManagedInstanceEncryptionProtectorListResultPage) ManagedInstanceEncryptionProtectorListResultIterator {
	return ManagedInstanceEncryptionProtectorListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mieplr ManagedInstanceEncryptionProtectorListResult) IsEmpty() bool {
	return mieplr.Value == nil || len(*mieplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mieplr ManagedInstanceEncryptionProtectorListResult) hasNextLink() bool {
	return mieplr.NextLink != nil && len(*mieplr.NextLink) != 0
}

// managedInstanceEncryptionProtectorListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mieplr ManagedInstanceEncryptionProtectorListResult) managedInstanceEncryptionProtectorListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mieplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mieplr.NextLink)))
}

// ManagedInstanceEncryptionProtectorListResultPage contains a page of ManagedInstanceEncryptionProtector
// values.
type ManagedInstanceEncryptionProtectorListResultPage struct {
	fn     func(context.Context, ManagedInstanceEncryptionProtectorListResult) (ManagedInstanceEncryptionProtectorListResult, error)
	mieplr ManagedInstanceEncryptionProtectorListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedInstanceEncryptionProtectorListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceEncryptionProtectorListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mieplr)
		if err != nil {
			return err
		}
		page.mieplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedInstanceEncryptionProtectorListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedInstanceEncryptionProtectorListResultPage) NotDone() bool {
	return !page.mieplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedInstanceEncryptionProtectorListResultPage) Response() ManagedInstanceEncryptionProtectorListResult {
	return page.mieplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedInstanceEncryptionProtectorListResultPage) Values() []ManagedInstanceEncryptionProtector {
	if page.mieplr.IsEmpty() {
		return nil
	}
	return *page.mieplr.Value
}

// Creates a new instance of the ManagedInstanceEncryptionProtectorListResultPage type.
func NewManagedInstanceEncryptionProtectorListResultPage(cur ManagedInstanceEncryptionProtectorListResult, getNextPage func(context.Context, ManagedInstanceEncryptionProtectorListResult) (ManagedInstanceEncryptionProtectorListResult, error)) ManagedInstanceEncryptionProtectorListResultPage {
	return ManagedInstanceEncryptionProtectorListResultPage{
		fn:     getNextPage,
		mieplr: cur,
	}
}

// ManagedInstanceEncryptionProtectorProperties properties for an encryption protector execution.
type ManagedInstanceEncryptionProtectorProperties struct {
	// ServerKeyName - The name of the managed instance key.
	ServerKeyName *string `json:"serverKeyName,omitempty"`
	// ServerKeyType - The encryption protector type like 'ServiceManaged', 'AzureKeyVault'. Possible values include: 'ServerKeyTypeServiceManaged', 'ServerKeyTypeAzureKeyVault'
	ServerKeyType ServerKeyType `json:"serverKeyType,omitempty"`
	// URI - READ-ONLY; The URI of the server key.
	URI *string `json:"uri,omitempty"`
	// Thumbprint - READ-ONLY; Thumbprint of the server key.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// AutoRotationEnabled - Key auto rotation opt-in flag. Either true or false.
	AutoRotationEnabled *bool `json:"autoRotationEnabled,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceEncryptionProtectorProperties.
func (miepp ManagedInstanceEncryptionProtectorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if miepp.ServerKeyName != nil {
		objectMap["serverKeyName"] = miepp.ServerKeyName
	}
	if miepp.ServerKeyType != "" {
		objectMap["serverKeyType"] = miepp.ServerKeyType
	}
	if miepp.AutoRotationEnabled != nil {
		objectMap["autoRotationEnabled"] = miepp.AutoRotationEnabled
	}
	return json.Marshal(objectMap)
}

// ManagedInstanceEncryptionProtectorsCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ManagedInstanceEncryptionProtectorsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedInstanceEncryptionProtectorsClient) (ManagedInstanceEncryptionProtector, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedInstanceEncryptionProtectorsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedInstanceEncryptionProtectorsCreateOrUpdateFuture.Result.
func (future *ManagedInstanceEncryptionProtectorsCreateOrUpdateFuture) result(client ManagedInstanceEncryptionProtectorsClient) (miep ManagedInstanceEncryptionProtector, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstanceEncryptionProtectorsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		miep.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstanceEncryptionProtectorsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if miep.Response.Response, err = future.GetResult(sender); err == nil && miep.Response.Response.StatusCode != http.StatusNoContent {
		miep, err = client.CreateOrUpdateResponder(miep.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedInstanceEncryptionProtectorsCreateOrUpdateFuture", "Result", miep.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedInstanceEncryptionProtectorsRevalidateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ManagedInstanceEncryptionProtectorsRevalidateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedInstanceEncryptionProtectorsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedInstanceEncryptionProtectorsRevalidateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedInstanceEncryptionProtectorsRevalidateFuture.Result.
func (future *ManagedInstanceEncryptionProtectorsRevalidateFuture) result(client ManagedInstanceEncryptionProtectorsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstanceEncryptionProtectorsRevalidateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstanceEncryptionProtectorsRevalidateFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedInstanceExternalAdministrator properties of a active directory administrator.
type ManagedInstanceExternalAdministrator struct {
	// AdministratorType - Type of the sever administrator. Possible values include: 'AdministratorTypeActiveDirectory'
	AdministratorType AdministratorType `json:"administratorType,omitempty"`
	// PrincipalType - Principal Type of the sever administrator. Possible values include: 'PrincipalTypeUser', 'PrincipalTypeGroup', 'PrincipalTypeApplication'
	PrincipalType PrincipalType `json:"principalType,omitempty"`
	// Login - Login name of the server administrator.
	Login *string `json:"login,omitempty"`
	// Sid - SID (object ID) of the server administrator.
	Sid *uuid.UUID `json:"sid,omitempty"`
	// TenantID - Tenant ID of the administrator.
	TenantID *uuid.UUID `json:"tenantId,omitempty"`
	// AzureADOnlyAuthentication - Azure Active Directory only Authentication enabled.
	AzureADOnlyAuthentication *bool `json:"azureADOnlyAuthentication,omitempty"`
}

// ManagedInstanceFamilyCapability the managed server family capability.
type ManagedInstanceFamilyCapability struct {
	// Name - READ-ONLY; Family name.
	Name *string `json:"name,omitempty"`
	// Sku - READ-ONLY; SKU name.
	Sku *string `json:"sku,omitempty"`
	// SupportedLicenseTypes - READ-ONLY; List of supported license types.
	SupportedLicenseTypes *[]LicenseTypeCapability `json:"supportedLicenseTypes,omitempty"`
	// SupportedVcoresValues - READ-ONLY; List of supported virtual cores values.
	SupportedVcoresValues *[]ManagedInstanceVcoresCapability `json:"supportedVcoresValues,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceFamilyCapability.
func (mifc ManagedInstanceFamilyCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mifc.Reason != nil {
		objectMap["reason"] = mifc.Reason
	}
	return json.Marshal(objectMap)
}

// ManagedInstanceKey a managed instance key.
type ManagedInstanceKey struct {
	autorest.Response `json:"-"`
	// Kind - READ-ONLY; Kind of encryption protector. This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// ManagedInstanceKeyProperties - Resource properties.
	*ManagedInstanceKeyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceKey.
func (mik ManagedInstanceKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mik.ManagedInstanceKeyProperties != nil {
		objectMap["properties"] = mik.ManagedInstanceKeyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedInstanceKey struct.
func (mik *ManagedInstanceKey) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mik.Kind = &kind
			}
		case "properties":
			if v != nil {
				var managedInstanceKeyProperties ManagedInstanceKeyProperties
				err = json.Unmarshal(*v, &managedInstanceKeyProperties)
				if err != nil {
					return err
				}
				mik.ManagedInstanceKeyProperties = &managedInstanceKeyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mik.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mik.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mik.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedInstanceKeyListResult a list of managed instance keys.
type ManagedInstanceKeyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedInstanceKey `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceKeyListResult.
func (miklr ManagedInstanceKeyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedInstanceKeyListResultIterator provides access to a complete listing of ManagedInstanceKey values.
type ManagedInstanceKeyListResultIterator struct {
	i    int
	page ManagedInstanceKeyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedInstanceKeyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceKeyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedInstanceKeyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedInstanceKeyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedInstanceKeyListResultIterator) Response() ManagedInstanceKeyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedInstanceKeyListResultIterator) Value() ManagedInstanceKey {
	if !iter.page.NotDone() {
		return ManagedInstanceKey{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedInstanceKeyListResultIterator type.
func NewManagedInstanceKeyListResultIterator(page ManagedInstanceKeyListResultPage) ManagedInstanceKeyListResultIterator {
	return ManagedInstanceKeyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (miklr ManagedInstanceKeyListResult) IsEmpty() bool {
	return miklr.Value == nil || len(*miklr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (miklr ManagedInstanceKeyListResult) hasNextLink() bool {
	return miklr.NextLink != nil && len(*miklr.NextLink) != 0
}

// managedInstanceKeyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (miklr ManagedInstanceKeyListResult) managedInstanceKeyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !miklr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(miklr.NextLink)))
}

// ManagedInstanceKeyListResultPage contains a page of ManagedInstanceKey values.
type ManagedInstanceKeyListResultPage struct {
	fn    func(context.Context, ManagedInstanceKeyListResult) (ManagedInstanceKeyListResult, error)
	miklr ManagedInstanceKeyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedInstanceKeyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceKeyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.miklr)
		if err != nil {
			return err
		}
		page.miklr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedInstanceKeyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedInstanceKeyListResultPage) NotDone() bool {
	return !page.miklr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedInstanceKeyListResultPage) Response() ManagedInstanceKeyListResult {
	return page.miklr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedInstanceKeyListResultPage) Values() []ManagedInstanceKey {
	if page.miklr.IsEmpty() {
		return nil
	}
	return *page.miklr.Value
}

// Creates a new instance of the ManagedInstanceKeyListResultPage type.
func NewManagedInstanceKeyListResultPage(cur ManagedInstanceKeyListResult, getNextPage func(context.Context, ManagedInstanceKeyListResult) (ManagedInstanceKeyListResult, error)) ManagedInstanceKeyListResultPage {
	return ManagedInstanceKeyListResultPage{
		fn:    getNextPage,
		miklr: cur,
	}
}

// ManagedInstanceKeyProperties properties for a key execution.
type ManagedInstanceKeyProperties struct {
	// ServerKeyType - The key type like 'ServiceManaged', 'AzureKeyVault'. Possible values include: 'ServerKeyTypeServiceManaged', 'ServerKeyTypeAzureKeyVault'
	ServerKeyType ServerKeyType `json:"serverKeyType,omitempty"`
	// URI - The URI of the key. If the ServerKeyType is AzureKeyVault, then the URI is required.
	URI *string `json:"uri,omitempty"`
	// Thumbprint - READ-ONLY; Thumbprint of the key.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// CreationDate - READ-ONLY; The key creation date.
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// AutoRotationEnabled - READ-ONLY; Key auto rotation opt-in flag. Either true or false.
	AutoRotationEnabled *bool `json:"autoRotationEnabled,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceKeyProperties.
func (mikp ManagedInstanceKeyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mikp.ServerKeyType != "" {
		objectMap["serverKeyType"] = mikp.ServerKeyType
	}
	if mikp.URI != nil {
		objectMap["uri"] = mikp.URI
	}
	return json.Marshal(objectMap)
}

// ManagedInstanceKeysCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedInstanceKeysCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedInstanceKeysClient) (ManagedInstanceKey, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedInstanceKeysCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedInstanceKeysCreateOrUpdateFuture.Result.
func (future *ManagedInstanceKeysCreateOrUpdateFuture) result(client ManagedInstanceKeysClient) (mik ManagedInstanceKey, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstanceKeysCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		mik.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstanceKeysCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mik.Response.Response, err = future.GetResult(sender); err == nil && mik.Response.Response.StatusCode != http.StatusNoContent {
		mik, err = client.CreateOrUpdateResponder(mik.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedInstanceKeysCreateOrUpdateFuture", "Result", mik.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedInstanceKeysDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedInstanceKeysDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedInstanceKeysClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedInstanceKeysDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedInstanceKeysDeleteFuture.Result.
func (future *ManagedInstanceKeysDeleteFuture) result(client ManagedInstanceKeysClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstanceKeysDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstanceKeysDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedInstanceListResult a list of managed instances.
type ManagedInstanceListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedInstance `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceListResult.
func (milr ManagedInstanceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedInstanceListResultIterator provides access to a complete listing of ManagedInstance values.
type ManagedInstanceListResultIterator struct {
	i    int
	page ManagedInstanceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedInstanceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedInstanceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedInstanceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedInstanceListResultIterator) Response() ManagedInstanceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedInstanceListResultIterator) Value() ManagedInstance {
	if !iter.page.NotDone() {
		return ManagedInstance{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedInstanceListResultIterator type.
func NewManagedInstanceListResultIterator(page ManagedInstanceListResultPage) ManagedInstanceListResultIterator {
	return ManagedInstanceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (milr ManagedInstanceListResult) IsEmpty() bool {
	return milr.Value == nil || len(*milr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (milr ManagedInstanceListResult) hasNextLink() bool {
	return milr.NextLink != nil && len(*milr.NextLink) != 0
}

// managedInstanceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (milr ManagedInstanceListResult) managedInstanceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !milr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(milr.NextLink)))
}

// ManagedInstanceListResultPage contains a page of ManagedInstance values.
type ManagedInstanceListResultPage struct {
	fn   func(context.Context, ManagedInstanceListResult) (ManagedInstanceListResult, error)
	milr ManagedInstanceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedInstanceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.milr)
		if err != nil {
			return err
		}
		page.milr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedInstanceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedInstanceListResultPage) NotDone() bool {
	return !page.milr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedInstanceListResultPage) Response() ManagedInstanceListResult {
	return page.milr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedInstanceListResultPage) Values() []ManagedInstance {
	if page.milr.IsEmpty() {
		return nil
	}
	return *page.milr.Value
}

// Creates a new instance of the ManagedInstanceListResultPage type.
func NewManagedInstanceListResultPage(cur ManagedInstanceListResult, getNextPage func(context.Context, ManagedInstanceListResult) (ManagedInstanceListResult, error)) ManagedInstanceListResultPage {
	return ManagedInstanceListResultPage{
		fn:   getNextPage,
		milr: cur,
	}
}

// ManagedInstanceLongTermRetentionBackup a long term retention backup for a managed database.
type ManagedInstanceLongTermRetentionBackup struct {
	autorest.Response `json:"-"`
	// ManagedInstanceLongTermRetentionBackupProperties - Resource properties.
	*ManagedInstanceLongTermRetentionBackupProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceLongTermRetentionBackup.
func (miltrb ManagedInstanceLongTermRetentionBackup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if miltrb.ManagedInstanceLongTermRetentionBackupProperties != nil {
		objectMap["properties"] = miltrb.ManagedInstanceLongTermRetentionBackupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedInstanceLongTermRetentionBackup struct.
func (miltrb *ManagedInstanceLongTermRetentionBackup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedInstanceLongTermRetentionBackupProperties ManagedInstanceLongTermRetentionBackupProperties
				err = json.Unmarshal(*v, &managedInstanceLongTermRetentionBackupProperties)
				if err != nil {
					return err
				}
				miltrb.ManagedInstanceLongTermRetentionBackupProperties = &managedInstanceLongTermRetentionBackupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				miltrb.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				miltrb.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				miltrb.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedInstanceLongTermRetentionBackupListResult a list of long term retention backups for managed
// database(s).
type ManagedInstanceLongTermRetentionBackupListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedInstanceLongTermRetentionBackup `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceLongTermRetentionBackupListResult.
func (miltrblr ManagedInstanceLongTermRetentionBackupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedInstanceLongTermRetentionBackupListResultIterator provides access to a complete listing of
// ManagedInstanceLongTermRetentionBackup values.
type ManagedInstanceLongTermRetentionBackupListResultIterator struct {
	i    int
	page ManagedInstanceLongTermRetentionBackupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedInstanceLongTermRetentionBackupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceLongTermRetentionBackupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedInstanceLongTermRetentionBackupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedInstanceLongTermRetentionBackupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedInstanceLongTermRetentionBackupListResultIterator) Response() ManagedInstanceLongTermRetentionBackupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedInstanceLongTermRetentionBackupListResultIterator) Value() ManagedInstanceLongTermRetentionBackup {
	if !iter.page.NotDone() {
		return ManagedInstanceLongTermRetentionBackup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedInstanceLongTermRetentionBackupListResultIterator type.
func NewManagedInstanceLongTermRetentionBackupListResultIterator(page ManagedInstanceLongTermRetentionBackupListResultPage) ManagedInstanceLongTermRetentionBackupListResultIterator {
	return ManagedInstanceLongTermRetentionBackupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (miltrblr ManagedInstanceLongTermRetentionBackupListResult) IsEmpty() bool {
	return miltrblr.Value == nil || len(*miltrblr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (miltrblr ManagedInstanceLongTermRetentionBackupListResult) hasNextLink() bool {
	return miltrblr.NextLink != nil && len(*miltrblr.NextLink) != 0
}

// managedInstanceLongTermRetentionBackupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (miltrblr ManagedInstanceLongTermRetentionBackupListResult) managedInstanceLongTermRetentionBackupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !miltrblr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(miltrblr.NextLink)))
}

// ManagedInstanceLongTermRetentionBackupListResultPage contains a page of
// ManagedInstanceLongTermRetentionBackup values.
type ManagedInstanceLongTermRetentionBackupListResultPage struct {
	fn       func(context.Context, ManagedInstanceLongTermRetentionBackupListResult) (ManagedInstanceLongTermRetentionBackupListResult, error)
	miltrblr ManagedInstanceLongTermRetentionBackupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedInstanceLongTermRetentionBackupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceLongTermRetentionBackupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.miltrblr)
		if err != nil {
			return err
		}
		page.miltrblr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedInstanceLongTermRetentionBackupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedInstanceLongTermRetentionBackupListResultPage) NotDone() bool {
	return !page.miltrblr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedInstanceLongTermRetentionBackupListResultPage) Response() ManagedInstanceLongTermRetentionBackupListResult {
	return page.miltrblr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedInstanceLongTermRetentionBackupListResultPage) Values() []ManagedInstanceLongTermRetentionBackup {
	if page.miltrblr.IsEmpty() {
		return nil
	}
	return *page.miltrblr.Value
}

// Creates a new instance of the ManagedInstanceLongTermRetentionBackupListResultPage type.
func NewManagedInstanceLongTermRetentionBackupListResultPage(cur ManagedInstanceLongTermRetentionBackupListResult, getNextPage func(context.Context, ManagedInstanceLongTermRetentionBackupListResult) (ManagedInstanceLongTermRetentionBackupListResult, error)) ManagedInstanceLongTermRetentionBackupListResultPage {
	return ManagedInstanceLongTermRetentionBackupListResultPage{
		fn:       getNextPage,
		miltrblr: cur,
	}
}

// ManagedInstanceLongTermRetentionBackupProperties properties of a long term retention backup
type ManagedInstanceLongTermRetentionBackupProperties struct {
	// ManagedInstanceName - READ-ONLY; The managed instance that the backup database belongs to.
	ManagedInstanceName *string `json:"managedInstanceName,omitempty"`
	// ManagedInstanceCreateTime - READ-ONLY; The create time of the instance.
	ManagedInstanceCreateTime *date.Time `json:"managedInstanceCreateTime,omitempty"`
	// DatabaseName - READ-ONLY; The name of the database the backup belong to
	DatabaseName *string `json:"databaseName,omitempty"`
	// DatabaseDeletionTime - READ-ONLY; The delete time of the database
	DatabaseDeletionTime *date.Time `json:"databaseDeletionTime,omitempty"`
	// BackupTime - READ-ONLY; The time the backup was taken
	BackupTime *date.Time `json:"backupTime,omitempty"`
	// BackupExpirationTime - READ-ONLY; The time the long term retention backup will expire.
	BackupExpirationTime *date.Time `json:"backupExpirationTime,omitempty"`
	// BackupStorageRedundancy - READ-ONLY; The storage redundancy type of the backup. Possible values include: 'BackupStorageRedundancyGeo', 'BackupStorageRedundancyLocal', 'BackupStorageRedundancyZone', 'BackupStorageRedundancyGeoZone'
	BackupStorageRedundancy BackupStorageRedundancy `json:"backupStorageRedundancy,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceLongTermRetentionBackupProperties.
func (miltrbp ManagedInstanceLongTermRetentionBackupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedInstanceLongTermRetentionPoliciesCreateOrUpdateFuture an abstraction for monitoring and
// retrieving the results of a long-running operation.
type ManagedInstanceLongTermRetentionPoliciesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedInstanceLongTermRetentionPoliciesClient) (ManagedInstanceLongTermRetentionPolicy, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedInstanceLongTermRetentionPoliciesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedInstanceLongTermRetentionPoliciesCreateOrUpdateFuture.Result.
func (future *ManagedInstanceLongTermRetentionPoliciesCreateOrUpdateFuture) result(client ManagedInstanceLongTermRetentionPoliciesClient) (miltrp ManagedInstanceLongTermRetentionPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstanceLongTermRetentionPoliciesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		miltrp.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstanceLongTermRetentionPoliciesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if miltrp.Response.Response, err = future.GetResult(sender); err == nil && miltrp.Response.Response.StatusCode != http.StatusNoContent {
		miltrp, err = client.CreateOrUpdateResponder(miltrp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedInstanceLongTermRetentionPoliciesCreateOrUpdateFuture", "Result", miltrp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedInstanceLongTermRetentionPolicy a long term retention policy.
type ManagedInstanceLongTermRetentionPolicy struct {
	autorest.Response `json:"-"`
	// BaseLongTermRetentionPolicyProperties - Resource properties.
	*BaseLongTermRetentionPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceLongTermRetentionPolicy.
func (miltrp ManagedInstanceLongTermRetentionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if miltrp.BaseLongTermRetentionPolicyProperties != nil {
		objectMap["properties"] = miltrp.BaseLongTermRetentionPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedInstanceLongTermRetentionPolicy struct.
func (miltrp *ManagedInstanceLongTermRetentionPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var baseLongTermRetentionPolicyProperties BaseLongTermRetentionPolicyProperties
				err = json.Unmarshal(*v, &baseLongTermRetentionPolicyProperties)
				if err != nil {
					return err
				}
				miltrp.BaseLongTermRetentionPolicyProperties = &baseLongTermRetentionPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				miltrp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				miltrp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				miltrp.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedInstanceLongTermRetentionPolicyListResult a list of long term retention policies.
type ManagedInstanceLongTermRetentionPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedInstanceLongTermRetentionPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceLongTermRetentionPolicyListResult.
func (miltrplr ManagedInstanceLongTermRetentionPolicyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedInstanceLongTermRetentionPolicyListResultIterator provides access to a complete listing of
// ManagedInstanceLongTermRetentionPolicy values.
type ManagedInstanceLongTermRetentionPolicyListResultIterator struct {
	i    int
	page ManagedInstanceLongTermRetentionPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedInstanceLongTermRetentionPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceLongTermRetentionPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedInstanceLongTermRetentionPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedInstanceLongTermRetentionPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedInstanceLongTermRetentionPolicyListResultIterator) Response() ManagedInstanceLongTermRetentionPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedInstanceLongTermRetentionPolicyListResultIterator) Value() ManagedInstanceLongTermRetentionPolicy {
	if !iter.page.NotDone() {
		return ManagedInstanceLongTermRetentionPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedInstanceLongTermRetentionPolicyListResultIterator type.
func NewManagedInstanceLongTermRetentionPolicyListResultIterator(page ManagedInstanceLongTermRetentionPolicyListResultPage) ManagedInstanceLongTermRetentionPolicyListResultIterator {
	return ManagedInstanceLongTermRetentionPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (miltrplr ManagedInstanceLongTermRetentionPolicyListResult) IsEmpty() bool {
	return miltrplr.Value == nil || len(*miltrplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (miltrplr ManagedInstanceLongTermRetentionPolicyListResult) hasNextLink() bool {
	return miltrplr.NextLink != nil && len(*miltrplr.NextLink) != 0
}

// managedInstanceLongTermRetentionPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (miltrplr ManagedInstanceLongTermRetentionPolicyListResult) managedInstanceLongTermRetentionPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !miltrplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(miltrplr.NextLink)))
}

// ManagedInstanceLongTermRetentionPolicyListResultPage contains a page of
// ManagedInstanceLongTermRetentionPolicy values.
type ManagedInstanceLongTermRetentionPolicyListResultPage struct {
	fn       func(context.Context, ManagedInstanceLongTermRetentionPolicyListResult) (ManagedInstanceLongTermRetentionPolicyListResult, error)
	miltrplr ManagedInstanceLongTermRetentionPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedInstanceLongTermRetentionPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceLongTermRetentionPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.miltrplr)
		if err != nil {
			return err
		}
		page.miltrplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedInstanceLongTermRetentionPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedInstanceLongTermRetentionPolicyListResultPage) NotDone() bool {
	return !page.miltrplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedInstanceLongTermRetentionPolicyListResultPage) Response() ManagedInstanceLongTermRetentionPolicyListResult {
	return page.miltrplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedInstanceLongTermRetentionPolicyListResultPage) Values() []ManagedInstanceLongTermRetentionPolicy {
	if page.miltrplr.IsEmpty() {
		return nil
	}
	return *page.miltrplr.Value
}

// Creates a new instance of the ManagedInstanceLongTermRetentionPolicyListResultPage type.
func NewManagedInstanceLongTermRetentionPolicyListResultPage(cur ManagedInstanceLongTermRetentionPolicyListResult, getNextPage func(context.Context, ManagedInstanceLongTermRetentionPolicyListResult) (ManagedInstanceLongTermRetentionPolicyListResult, error)) ManagedInstanceLongTermRetentionPolicyListResultPage {
	return ManagedInstanceLongTermRetentionPolicyListResultPage{
		fn:       getNextPage,
		miltrplr: cur,
	}
}

// ManagedInstanceMaintenanceConfigurationCapability the maintenance configuration capability
type ManagedInstanceMaintenanceConfigurationCapability struct {
	// Name - READ-ONLY; Maintenance configuration name
	Name *string `json:"name,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceMaintenanceConfigurationCapability.
func (mimcc ManagedInstanceMaintenanceConfigurationCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mimcc.Reason != nil {
		objectMap["reason"] = mimcc.Reason
	}
	return json.Marshal(objectMap)
}

// ManagedInstanceOperation a managed instance operation.
type ManagedInstanceOperation struct {
	autorest.Response `json:"-"`
	// ManagedInstanceOperationProperties - Resource properties.
	*ManagedInstanceOperationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceOperation.
func (mio ManagedInstanceOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mio.ManagedInstanceOperationProperties != nil {
		objectMap["properties"] = mio.ManagedInstanceOperationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedInstanceOperation struct.
func (mio *ManagedInstanceOperation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedInstanceOperationProperties ManagedInstanceOperationProperties
				err = json.Unmarshal(*v, &managedInstanceOperationProperties)
				if err != nil {
					return err
				}
				mio.ManagedInstanceOperationProperties = &managedInstanceOperationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mio.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mio.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mio.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedInstanceOperationListResult the response to a list managed instance operations request
type ManagedInstanceOperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedInstanceOperation `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceOperationListResult.
func (miolr ManagedInstanceOperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedInstanceOperationListResultIterator provides access to a complete listing of
// ManagedInstanceOperation values.
type ManagedInstanceOperationListResultIterator struct {
	i    int
	page ManagedInstanceOperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedInstanceOperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceOperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedInstanceOperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedInstanceOperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedInstanceOperationListResultIterator) Response() ManagedInstanceOperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedInstanceOperationListResultIterator) Value() ManagedInstanceOperation {
	if !iter.page.NotDone() {
		return ManagedInstanceOperation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedInstanceOperationListResultIterator type.
func NewManagedInstanceOperationListResultIterator(page ManagedInstanceOperationListResultPage) ManagedInstanceOperationListResultIterator {
	return ManagedInstanceOperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (miolr ManagedInstanceOperationListResult) IsEmpty() bool {
	return miolr.Value == nil || len(*miolr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (miolr ManagedInstanceOperationListResult) hasNextLink() bool {
	return miolr.NextLink != nil && len(*miolr.NextLink) != 0
}

// managedInstanceOperationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (miolr ManagedInstanceOperationListResult) managedInstanceOperationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !miolr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(miolr.NextLink)))
}

// ManagedInstanceOperationListResultPage contains a page of ManagedInstanceOperation values.
type ManagedInstanceOperationListResultPage struct {
	fn    func(context.Context, ManagedInstanceOperationListResult) (ManagedInstanceOperationListResult, error)
	miolr ManagedInstanceOperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedInstanceOperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceOperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.miolr)
		if err != nil {
			return err
		}
		page.miolr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedInstanceOperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedInstanceOperationListResultPage) NotDone() bool {
	return !page.miolr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedInstanceOperationListResultPage) Response() ManagedInstanceOperationListResult {
	return page.miolr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedInstanceOperationListResultPage) Values() []ManagedInstanceOperation {
	if page.miolr.IsEmpty() {
		return nil
	}
	return *page.miolr.Value
}

// Creates a new instance of the ManagedInstanceOperationListResultPage type.
func NewManagedInstanceOperationListResultPage(cur ManagedInstanceOperationListResult, getNextPage func(context.Context, ManagedInstanceOperationListResult) (ManagedInstanceOperationListResult, error)) ManagedInstanceOperationListResultPage {
	return ManagedInstanceOperationListResultPage{
		fn:    getNextPage,
		miolr: cur,
	}
}

// ManagedInstanceOperationParametersPair the parameters of a managed instance operation.
type ManagedInstanceOperationParametersPair struct {
	// CurrentParameters - READ-ONLY; The current parameters.
	CurrentParameters *UpsertManagedServerOperationParameters `json:"currentParameters,omitempty"`
	// RequestedParameters - READ-ONLY; The requested parameters.
	RequestedParameters *UpsertManagedServerOperationParameters `json:"requestedParameters,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceOperationParametersPair.
func (miopp ManagedInstanceOperationParametersPair) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedInstanceOperationProperties the properties of a managed instance operation.
type ManagedInstanceOperationProperties struct {
	// ManagedInstanceName - READ-ONLY; The name of the managed instance the operation is being performed on.
	ManagedInstanceName *string `json:"managedInstanceName,omitempty"`
	// Operation - READ-ONLY; The name of operation.
	Operation *string `json:"operation,omitempty"`
	// OperationFriendlyName - READ-ONLY; The friendly name of operation.
	OperationFriendlyName *string `json:"operationFriendlyName,omitempty"`
	// PercentComplete - READ-ONLY; The percentage of the operation completed.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// StartTime - READ-ONLY; The operation start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// State - READ-ONLY; The operation state. Possible values include: 'ManagementOperationStatePending', 'ManagementOperationStateInProgress', 'ManagementOperationStateSucceeded', 'ManagementOperationStateFailed', 'ManagementOperationStateCancelInProgress', 'ManagementOperationStateCancelled'
	State ManagementOperationState `json:"state,omitempty"`
	// ErrorCode - READ-ONLY; The operation error code.
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// ErrorDescription - READ-ONLY; The operation error description.
	ErrorDescription *string `json:"errorDescription,omitempty"`
	// ErrorSeverity - READ-ONLY; The operation error severity.
	ErrorSeverity *int32 `json:"errorSeverity,omitempty"`
	// IsUserError - READ-ONLY; Whether or not the error is a user error.
	IsUserError *bool `json:"isUserError,omitempty"`
	// EstimatedCompletionTime - READ-ONLY; The estimated completion time of the operation.
	EstimatedCompletionTime *date.Time `json:"estimatedCompletionTime,omitempty"`
	// Description - READ-ONLY; The operation description.
	Description *string `json:"description,omitempty"`
	// IsCancellable - READ-ONLY; Whether the operation can be cancelled.
	IsCancellable *bool `json:"isCancellable,omitempty"`
	// OperationParameters - READ-ONLY; The operation parameters.
	OperationParameters *ManagedInstanceOperationParametersPair `json:"operationParameters,omitempty"`
	// OperationSteps - READ-ONLY; The operation steps.
	OperationSteps *ManagedInstanceOperationSteps `json:"operationSteps,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceOperationProperties.
func (miop ManagedInstanceOperationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedInstanceOperationSteps the steps of a managed instance operation.
type ManagedInstanceOperationSteps struct {
	// TotalSteps - READ-ONLY; The total number of operation steps.
	TotalSteps *string `json:"totalSteps,omitempty"`
	// CurrentStep - READ-ONLY; The number of current operation steps.
	CurrentStep *int32 `json:"currentStep,omitempty"`
	// StepsList - READ-ONLY; The operation steps list.
	StepsList *[]UpsertManagedServerOperationStep `json:"stepsList,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceOperationSteps.
func (mios ManagedInstanceOperationSteps) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedInstancePairInfo pairs of Managed Instances in the failover group.
type ManagedInstancePairInfo struct {
	// PrimaryManagedInstanceID - Id of Primary Managed Instance in pair.
	PrimaryManagedInstanceID *string `json:"primaryManagedInstanceId,omitempty"`
	// PartnerManagedInstanceID - Id of Partner Managed Instance in pair.
	PartnerManagedInstanceID *string `json:"partnerManagedInstanceId,omitempty"`
}

// ManagedInstancePecProperty a private endpoint connection under a managed instance
type ManagedInstancePecProperty struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Properties - READ-ONLY; Private endpoint connection properties
	Properties *ManagedInstancePrivateEndpointConnectionProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstancePecProperty.
func (mipp ManagedInstancePecProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedInstancePrivateEndpointConnection a private endpoint connection
type ManagedInstancePrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	// ManagedInstancePrivateEndpointConnectionProperties - Resource properties.
	*ManagedInstancePrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstancePrivateEndpointConnection.
func (mipec ManagedInstancePrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mipec.ManagedInstancePrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = mipec.ManagedInstancePrivateEndpointConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedInstancePrivateEndpointConnection struct.
func (mipec *ManagedInstancePrivateEndpointConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedInstancePrivateEndpointConnectionProperties ManagedInstancePrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &managedInstancePrivateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				mipec.ManagedInstancePrivateEndpointConnectionProperties = &managedInstancePrivateEndpointConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mipec.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mipec.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mipec.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedInstancePrivateEndpointConnectionListResult a list of private endpoint connections.
type ManagedInstancePrivateEndpointConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedInstancePrivateEndpointConnection `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstancePrivateEndpointConnectionListResult.
func (mipeclr ManagedInstancePrivateEndpointConnectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedInstancePrivateEndpointConnectionListResultIterator provides access to a complete listing of
// ManagedInstancePrivateEndpointConnection values.
type ManagedInstancePrivateEndpointConnectionListResultIterator struct {
	i    int
	page ManagedInstancePrivateEndpointConnectionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedInstancePrivateEndpointConnectionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstancePrivateEndpointConnectionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedInstancePrivateEndpointConnectionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedInstancePrivateEndpointConnectionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedInstancePrivateEndpointConnectionListResultIterator) Response() ManagedInstancePrivateEndpointConnectionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedInstancePrivateEndpointConnectionListResultIterator) Value() ManagedInstancePrivateEndpointConnection {
	if !iter.page.NotDone() {
		return ManagedInstancePrivateEndpointConnection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedInstancePrivateEndpointConnectionListResultIterator type.
func NewManagedInstancePrivateEndpointConnectionListResultIterator(page ManagedInstancePrivateEndpointConnectionListResultPage) ManagedInstancePrivateEndpointConnectionListResultIterator {
	return ManagedInstancePrivateEndpointConnectionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mipeclr ManagedInstancePrivateEndpointConnectionListResult) IsEmpty() bool {
	return mipeclr.Value == nil || len(*mipeclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mipeclr ManagedInstancePrivateEndpointConnectionListResult) hasNextLink() bool {
	return mipeclr.NextLink != nil && len(*mipeclr.NextLink) != 0
}

// managedInstancePrivateEndpointConnectionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mipeclr ManagedInstancePrivateEndpointConnectionListResult) managedInstancePrivateEndpointConnectionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mipeclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mipeclr.NextLink)))
}

// ManagedInstancePrivateEndpointConnectionListResultPage contains a page of
// ManagedInstancePrivateEndpointConnection values.
type ManagedInstancePrivateEndpointConnectionListResultPage struct {
	fn      func(context.Context, ManagedInstancePrivateEndpointConnectionListResult) (ManagedInstancePrivateEndpointConnectionListResult, error)
	mipeclr ManagedInstancePrivateEndpointConnectionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedInstancePrivateEndpointConnectionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstancePrivateEndpointConnectionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mipeclr)
		if err != nil {
			return err
		}
		page.mipeclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedInstancePrivateEndpointConnectionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedInstancePrivateEndpointConnectionListResultPage) NotDone() bool {
	return !page.mipeclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedInstancePrivateEndpointConnectionListResultPage) Response() ManagedInstancePrivateEndpointConnectionListResult {
	return page.mipeclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedInstancePrivateEndpointConnectionListResultPage) Values() []ManagedInstancePrivateEndpointConnection {
	if page.mipeclr.IsEmpty() {
		return nil
	}
	return *page.mipeclr.Value
}

// Creates a new instance of the ManagedInstancePrivateEndpointConnectionListResultPage type.
func NewManagedInstancePrivateEndpointConnectionListResultPage(cur ManagedInstancePrivateEndpointConnectionListResult, getNextPage func(context.Context, ManagedInstancePrivateEndpointConnectionListResult) (ManagedInstancePrivateEndpointConnectionListResult, error)) ManagedInstancePrivateEndpointConnectionListResultPage {
	return ManagedInstancePrivateEndpointConnectionListResultPage{
		fn:      getNextPage,
		mipeclr: cur,
	}
}

// ManagedInstancePrivateEndpointConnectionProperties properties of a private endpoint connection.
type ManagedInstancePrivateEndpointConnectionProperties struct {
	// PrivateEndpoint - Private endpoint which the connection belongs to.
	PrivateEndpoint *ManagedInstancePrivateEndpointProperty `json:"privateEndpoint,omitempty"`
	// PrivateLinkServiceConnectionState - Connection State of the Private Endpoint Connection.
	PrivateLinkServiceConnectionState *ManagedInstancePrivateLinkServiceConnectionStateProperty `json:"privateLinkServiceConnectionState,omitempty"`
	// ProvisioningState - READ-ONLY; State of the Private Endpoint Connection.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstancePrivateEndpointConnectionProperties.
func (mipecp ManagedInstancePrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mipecp.PrivateEndpoint != nil {
		objectMap["privateEndpoint"] = mipecp.PrivateEndpoint
	}
	if mipecp.PrivateLinkServiceConnectionState != nil {
		objectMap["privateLinkServiceConnectionState"] = mipecp.PrivateLinkServiceConnectionState
	}
	return json.Marshal(objectMap)
}

// ManagedInstancePrivateEndpointConnectionsCreateOrUpdateFuture an abstraction for monitoring and
// retrieving the results of a long-running operation.
type ManagedInstancePrivateEndpointConnectionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedInstancePrivateEndpointConnectionsClient) (ManagedInstancePrivateEndpointConnection, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedInstancePrivateEndpointConnectionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedInstancePrivateEndpointConnectionsCreateOrUpdateFuture.Result.
func (future *ManagedInstancePrivateEndpointConnectionsCreateOrUpdateFuture) result(client ManagedInstancePrivateEndpointConnectionsClient) (mipec ManagedInstancePrivateEndpointConnection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstancePrivateEndpointConnectionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		mipec.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstancePrivateEndpointConnectionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mipec.Response.Response, err = future.GetResult(sender); err == nil && mipec.Response.Response.StatusCode != http.StatusNoContent {
		mipec, err = client.CreateOrUpdateResponder(mipec.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedInstancePrivateEndpointConnectionsCreateOrUpdateFuture", "Result", mipec.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedInstancePrivateEndpointConnectionsDeleteFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ManagedInstancePrivateEndpointConnectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedInstancePrivateEndpointConnectionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedInstancePrivateEndpointConnectionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedInstancePrivateEndpointConnectionsDeleteFuture.Result.
func (future *ManagedInstancePrivateEndpointConnectionsDeleteFuture) result(client ManagedInstancePrivateEndpointConnectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstancePrivateEndpointConnectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstancePrivateEndpointConnectionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedInstancePrivateEndpointProperty ...
type ManagedInstancePrivateEndpointProperty struct {
	// ID - Resource id of the private endpoint.
	ID *string `json:"id,omitempty"`
}

// ManagedInstancePrivateLink a private link resource
type ManagedInstancePrivateLink struct {
	autorest.Response `json:"-"`
	// Properties - READ-ONLY; The private link resource group id.
	Properties *ManagedInstancePrivateLinkProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstancePrivateLink.
func (mipl ManagedInstancePrivateLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedInstancePrivateLinkListResult a list of private link resources
type ManagedInstancePrivateLinkListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedInstancePrivateLink `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstancePrivateLinkListResult.
func (mipllr ManagedInstancePrivateLinkListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedInstancePrivateLinkListResultIterator provides access to a complete listing of
// ManagedInstancePrivateLink values.
type ManagedInstancePrivateLinkListResultIterator struct {
	i    int
	page ManagedInstancePrivateLinkListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedInstancePrivateLinkListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstancePrivateLinkListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedInstancePrivateLinkListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedInstancePrivateLinkListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedInstancePrivateLinkListResultIterator) Response() ManagedInstancePrivateLinkListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedInstancePrivateLinkListResultIterator) Value() ManagedInstancePrivateLink {
	if !iter.page.NotDone() {
		return ManagedInstancePrivateLink{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedInstancePrivateLinkListResultIterator type.
func NewManagedInstancePrivateLinkListResultIterator(page ManagedInstancePrivateLinkListResultPage) ManagedInstancePrivateLinkListResultIterator {
	return ManagedInstancePrivateLinkListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mipllr ManagedInstancePrivateLinkListResult) IsEmpty() bool {
	return mipllr.Value == nil || len(*mipllr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mipllr ManagedInstancePrivateLinkListResult) hasNextLink() bool {
	return mipllr.NextLink != nil && len(*mipllr.NextLink) != 0
}

// managedInstancePrivateLinkListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mipllr ManagedInstancePrivateLinkListResult) managedInstancePrivateLinkListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mipllr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mipllr.NextLink)))
}

// ManagedInstancePrivateLinkListResultPage contains a page of ManagedInstancePrivateLink values.
type ManagedInstancePrivateLinkListResultPage struct {
	fn     func(context.Context, ManagedInstancePrivateLinkListResult) (ManagedInstancePrivateLinkListResult, error)
	mipllr ManagedInstancePrivateLinkListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedInstancePrivateLinkListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstancePrivateLinkListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mipllr)
		if err != nil {
			return err
		}
		page.mipllr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedInstancePrivateLinkListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedInstancePrivateLinkListResultPage) NotDone() bool {
	return !page.mipllr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedInstancePrivateLinkListResultPage) Response() ManagedInstancePrivateLinkListResult {
	return page.mipllr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedInstancePrivateLinkListResultPage) Values() []ManagedInstancePrivateLink {
	if page.mipllr.IsEmpty() {
		return nil
	}
	return *page.mipllr.Value
}

// Creates a new instance of the ManagedInstancePrivateLinkListResultPage type.
func NewManagedInstancePrivateLinkListResultPage(cur ManagedInstancePrivateLinkListResult, getNextPage func(context.Context, ManagedInstancePrivateLinkListResult) (ManagedInstancePrivateLinkListResult, error)) ManagedInstancePrivateLinkListResultPage {
	return ManagedInstancePrivateLinkListResultPage{
		fn:     getNextPage,
		mipllr: cur,
	}
}

// ManagedInstancePrivateLinkProperties properties of a private link resource.
type ManagedInstancePrivateLinkProperties struct {
	// GroupID - READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - READ-ONLY; The private link resource required member names.
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstancePrivateLinkProperties.
func (miplp ManagedInstancePrivateLinkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedInstancePrivateLinkServiceConnectionStateProperty ...
type ManagedInstancePrivateLinkServiceConnectionStateProperty struct {
	// Status - The private link service connection status.
	Status *string `json:"status,omitempty"`
	// Description - The private link service connection description.
	Description *string `json:"description,omitempty"`
	// ActionsRequired - READ-ONLY; The private link service connection description.
	ActionsRequired *string `json:"actionsRequired,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstancePrivateLinkServiceConnectionStateProperty.
func (miplscsp ManagedInstancePrivateLinkServiceConnectionStateProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if miplscsp.Status != nil {
		objectMap["status"] = miplscsp.Status
	}
	if miplscsp.Description != nil {
		objectMap["description"] = miplscsp.Description
	}
	return json.Marshal(objectMap)
}

// ManagedInstanceProperties the properties of a managed instance.
type ManagedInstanceProperties struct {
	// ProvisioningState - READ-ONLY; Possible values include: 'ProvisioningState1Creating', 'ProvisioningState1Deleting', 'ProvisioningState1Updating', 'ProvisioningState1Unknown', 'ProvisioningState1Succeeded', 'ProvisioningState1Failed', 'ProvisioningState1Accepted', 'ProvisioningState1Created', 'ProvisioningState1Deleted', 'ProvisioningState1Unrecognized', 'ProvisioningState1Running', 'ProvisioningState1Canceled', 'ProvisioningState1NotSpecified', 'ProvisioningState1Registering', 'ProvisioningState1TimedOut'
	ProvisioningState ProvisioningState1 `json:"provisioningState,omitempty"`
	// ManagedInstanceCreateMode - Specifies the mode of database creation.
	//
	// Default: Regular instance creation.
	//
	// Restore: Creates an instance by restoring a set of backups to specific point in time. RestorePointInTime and SourceManagedInstanceId must be specified. Possible values include: 'ManagedServerCreateModeDefault', 'ManagedServerCreateModePointInTimeRestore'
	ManagedInstanceCreateMode ManagedServerCreateMode `json:"managedInstanceCreateMode,omitempty"`
	// FullyQualifiedDomainName - READ-ONLY; The fully qualified domain name of the managed instance.
	FullyQualifiedDomainName *string `json:"fullyQualifiedDomainName,omitempty"`
	// AdministratorLogin - Administrator username for the managed instance. Can only be specified when the managed instance is being created (and is required for creation).
	AdministratorLogin *string `json:"administratorLogin,omitempty"`
	// AdministratorLoginPassword - The administrator login password (required for managed instance creation).
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`
	// SubnetID - Subnet resource ID for the managed instance.
	SubnetID *string `json:"subnetId,omitempty"`
	// State - READ-ONLY; The state of the managed instance.
	State *string `json:"state,omitempty"`
	// LicenseType - The license type. Possible values are 'LicenseIncluded' (regular price inclusive of a new SQL license) and 'BasePrice' (discounted AHB price for bringing your own SQL licenses). Possible values include: 'ManagedInstanceLicenseTypeLicenseIncluded', 'ManagedInstanceLicenseTypeBasePrice'
	LicenseType ManagedInstanceLicenseType `json:"licenseType,omitempty"`
	// VCores - The number of vCores. Allowed values: 8, 16, 24, 32, 40, 64, 80.
	VCores *int32 `json:"vCores,omitempty"`
	// StorageSizeInGB - Storage size in GB. Minimum value: 32. Maximum value: 8192. Increments of 32 GB allowed only.
	StorageSizeInGB *int32 `json:"storageSizeInGB,omitempty"`
	// Collation - Collation of the managed instance.
	Collation *string `json:"collation,omitempty"`
	// DNSZone - READ-ONLY; The Dns Zone that the managed instance is in.
	DNSZone *string `json:"dnsZone,omitempty"`
	// DNSZonePartner - The resource id of another managed instance whose DNS zone this managed instance will share after creation.
	DNSZonePartner *string `json:"dnsZonePartner,omitempty"`
	// PublicDataEndpointEnabled - Whether or not the public data endpoint is enabled.
	PublicDataEndpointEnabled *bool `json:"publicDataEndpointEnabled,omitempty"`
	// SourceManagedInstanceID - The resource identifier of the source managed instance associated with create operation of this instance.
	SourceManagedInstanceID *string `json:"sourceManagedInstanceId,omitempty"`
	// RestorePointInTime - Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new database.
	RestorePointInTime *date.Time `json:"restorePointInTime,omitempty"`
	// ProxyOverride - Connection type used for connecting to the instance. Possible values include: 'ManagedInstanceProxyOverrideProxy', 'ManagedInstanceProxyOverrideRedirect', 'ManagedInstanceProxyOverrideDefault'
	ProxyOverride ManagedInstanceProxyOverride `json:"proxyOverride,omitempty"`
	// TimezoneID - Id of the timezone. Allowed values are timezones supported by Windows.
	// Windows keeps details on supported timezones, including the id, in registry under
	// KEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones.
	// You can get those registry values via SQL Server by querying SELECT name AS timezone_id FROM sys.time_zone_info.
	// List of Ids can also be obtained by executing [System.TimeZoneInfo]::GetSystemTimeZones() in PowerShell.
	// An example of valid timezone id is "Pacific Standard Time" or "W. Europe Standard Time".
	TimezoneID *string `json:"timezoneId,omitempty"`
	// InstancePoolID - The Id of the instance pool this managed server belongs to.
	InstancePoolID *string `json:"instancePoolId,omitempty"`
	// MaintenanceConfigurationID - Specifies maintenance configuration id to apply to this managed instance.
	MaintenanceConfigurationID *string `json:"maintenanceConfigurationId,omitempty"`
	// PrivateEndpointConnections - READ-ONLY; List of private endpoint connections on a managed instance.
	PrivateEndpointConnections *[]ManagedInstancePecProperty `json:"privateEndpointConnections,omitempty"`
	// MinimalTLSVersion - Minimal TLS version. Allowed values: 'None', '1.0', '1.1', '1.2'
	MinimalTLSVersion *string `json:"minimalTlsVersion,omitempty"`
	// CurrentBackupStorageRedundancy - READ-ONLY; The storage account type used to store backups for this instance. The options are Local (LocallyRedundantStorage), Zone (ZoneRedundantStorage), Geo (GeoRedundantStorage) and GeoZone(GeoZoneRedundantStorage). Possible values include: 'BackupStorageRedundancyGeo', 'BackupStorageRedundancyLocal', 'BackupStorageRedundancyZone', 'BackupStorageRedundancyGeoZone'
	CurrentBackupStorageRedundancy BackupStorageRedundancy `json:"currentBackupStorageRedundancy,omitempty"`
	// RequestedBackupStorageRedundancy - The storage account type to be used to store backups for this instance. The options are Local (LocallyRedundantStorage), Zone (ZoneRedundantStorage), Geo (GeoRedundantStorage) and GeoZone(GeoZoneRedundantStorage). Possible values include: 'BackupStorageRedundancyGeo', 'BackupStorageRedundancyLocal', 'BackupStorageRedundancyZone', 'BackupStorageRedundancyGeoZone'
	RequestedBackupStorageRedundancy BackupStorageRedundancy `json:"requestedBackupStorageRedundancy,omitempty"`
	// ZoneRedundant - Whether or not the multi-az is enabled.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
	// PrimaryUserAssignedIdentityID - The resource id of a user assigned identity to be used by default.
	PrimaryUserAssignedIdentityID *string `json:"primaryUserAssignedIdentityId,omitempty"`
	// KeyID - A CMK URI of the key to use for encryption.
	KeyID *string `json:"keyId,omitempty"`
	// Administrators - The Azure Active Directory administrator of the server.
	Administrators *ManagedInstanceExternalAdministrator `json:"administrators,omitempty"`
	// ServicePrincipal - The managed instance's service principal.
	ServicePrincipal *ServicePrincipal `json:"servicePrincipal,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceProperties.
func (mip ManagedInstanceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mip.ManagedInstanceCreateMode != "" {
		objectMap["managedInstanceCreateMode"] = mip.ManagedInstanceCreateMode
	}
	if mip.AdministratorLogin != nil {
		objectMap["administratorLogin"] = mip.AdministratorLogin
	}
	if mip.AdministratorLoginPassword != nil {
		objectMap["administratorLoginPassword"] = mip.AdministratorLoginPassword
	}
	if mip.SubnetID != nil {
		objectMap["subnetId"] = mip.SubnetID
	}
	if mip.LicenseType != "" {
		objectMap["licenseType"] = mip.LicenseType
	}
	if mip.VCores != nil {
		objectMap["vCores"] = mip.VCores
	}
	if mip.StorageSizeInGB != nil {
		objectMap["storageSizeInGB"] = mip.StorageSizeInGB
	}
	if mip.Collation != nil {
		objectMap["collation"] = mip.Collation
	}
	if mip.DNSZonePartner != nil {
		objectMap["dnsZonePartner"] = mip.DNSZonePartner
	}
	if mip.PublicDataEndpointEnabled != nil {
		objectMap["publicDataEndpointEnabled"] = mip.PublicDataEndpointEnabled
	}
	if mip.SourceManagedInstanceID != nil {
		objectMap["sourceManagedInstanceId"] = mip.SourceManagedInstanceID
	}
	if mip.RestorePointInTime != nil {
		objectMap["restorePointInTime"] = mip.RestorePointInTime
	}
	if mip.ProxyOverride != "" {
		objectMap["proxyOverride"] = mip.ProxyOverride
	}
	if mip.TimezoneID != nil {
		objectMap["timezoneId"] = mip.TimezoneID
	}
	if mip.InstancePoolID != nil {
		objectMap["instancePoolId"] = mip.InstancePoolID
	}
	if mip.MaintenanceConfigurationID != nil {
		objectMap["maintenanceConfigurationId"] = mip.MaintenanceConfigurationID
	}
	if mip.MinimalTLSVersion != nil {
		objectMap["minimalTlsVersion"] = mip.MinimalTLSVersion
	}
	if mip.RequestedBackupStorageRedundancy != "" {
		objectMap["requestedBackupStorageRedundancy"] = mip.RequestedBackupStorageRedundancy
	}
	if mip.ZoneRedundant != nil {
		objectMap["zoneRedundant"] = mip.ZoneRedundant
	}
	if mip.PrimaryUserAssignedIdentityID != nil {
		objectMap["primaryUserAssignedIdentityId"] = mip.PrimaryUserAssignedIdentityID
	}
	if mip.KeyID != nil {
		objectMap["keyId"] = mip.KeyID
	}
	if mip.Administrators != nil {
		objectMap["administrators"] = mip.Administrators
	}
	if mip.ServicePrincipal != nil {
		objectMap["servicePrincipal"] = mip.ServicePrincipal
	}
	return json.Marshal(objectMap)
}

// ManagedInstanceQuery database query.
type ManagedInstanceQuery struct {
	autorest.Response `json:"-"`
	// QueryProperties - Resource properties.
	*QueryProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceQuery.
func (miq ManagedInstanceQuery) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if miq.QueryProperties != nil {
		objectMap["properties"] = miq.QueryProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedInstanceQuery struct.
func (miq *ManagedInstanceQuery) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var queryProperties QueryProperties
				err = json.Unmarshal(*v, &queryProperties)
				if err != nil {
					return err
				}
				miq.QueryProperties = &queryProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				miq.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				miq.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				miq.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedInstanceQueryStatistics execution statistics for one particular query
type ManagedInstanceQueryStatistics struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]QueryStatistics `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceQueryStatistics.
func (miqs ManagedInstanceQueryStatistics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedInstanceQueryStatisticsIterator provides access to a complete listing of QueryStatistics values.
type ManagedInstanceQueryStatisticsIterator struct {
	i    int
	page ManagedInstanceQueryStatisticsPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedInstanceQueryStatisticsIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceQueryStatisticsIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedInstanceQueryStatisticsIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedInstanceQueryStatisticsIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedInstanceQueryStatisticsIterator) Response() ManagedInstanceQueryStatistics {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedInstanceQueryStatisticsIterator) Value() QueryStatistics {
	if !iter.page.NotDone() {
		return QueryStatistics{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedInstanceQueryStatisticsIterator type.
func NewManagedInstanceQueryStatisticsIterator(page ManagedInstanceQueryStatisticsPage) ManagedInstanceQueryStatisticsIterator {
	return ManagedInstanceQueryStatisticsIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (miqs ManagedInstanceQueryStatistics) IsEmpty() bool {
	return miqs.Value == nil || len(*miqs.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (miqs ManagedInstanceQueryStatistics) hasNextLink() bool {
	return miqs.NextLink != nil && len(*miqs.NextLink) != 0
}

// managedInstanceQueryStatisticsPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (miqs ManagedInstanceQueryStatistics) managedInstanceQueryStatisticsPreparer(ctx context.Context) (*http.Request, error) {
	if !miqs.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(miqs.NextLink)))
}

// ManagedInstanceQueryStatisticsPage contains a page of QueryStatistics values.
type ManagedInstanceQueryStatisticsPage struct {
	fn   func(context.Context, ManagedInstanceQueryStatistics) (ManagedInstanceQueryStatistics, error)
	miqs ManagedInstanceQueryStatistics
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedInstanceQueryStatisticsPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceQueryStatisticsPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.miqs)
		if err != nil {
			return err
		}
		page.miqs = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedInstanceQueryStatisticsPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedInstanceQueryStatisticsPage) NotDone() bool {
	return !page.miqs.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedInstanceQueryStatisticsPage) Response() ManagedInstanceQueryStatistics {
	return page.miqs
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedInstanceQueryStatisticsPage) Values() []QueryStatistics {
	if page.miqs.IsEmpty() {
		return nil
	}
	return *page.miqs.Value
}

// Creates a new instance of the ManagedInstanceQueryStatisticsPage type.
func NewManagedInstanceQueryStatisticsPage(cur ManagedInstanceQueryStatistics, getNextPage func(context.Context, ManagedInstanceQueryStatistics) (ManagedInstanceQueryStatistics, error)) ManagedInstanceQueryStatisticsPage {
	return ManagedInstanceQueryStatisticsPage{
		fn:   getNextPage,
		miqs: cur,
	}
}

// ManagedInstancesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedInstancesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedInstancesClient) (ManagedInstance, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedInstancesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedInstancesCreateOrUpdateFuture.Result.
func (future *ManagedInstancesCreateOrUpdateFuture) result(client ManagedInstancesClient) (mi ManagedInstance, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstancesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		mi.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstancesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mi.Response.Response, err = future.GetResult(sender); err == nil && mi.Response.Response.StatusCode != http.StatusNoContent {
		mi, err = client.CreateOrUpdateResponder(mi.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedInstancesCreateOrUpdateFuture", "Result", mi.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedInstancesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ManagedInstancesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedInstancesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedInstancesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedInstancesDeleteFuture.Result.
func (future *ManagedInstancesDeleteFuture) result(client ManagedInstancesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstancesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstancesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedInstancesFailoverFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedInstancesFailoverFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedInstancesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedInstancesFailoverFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedInstancesFailoverFuture.Result.
func (future *ManagedInstancesFailoverFuture) result(client ManagedInstancesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstancesFailoverFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstancesFailoverFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedInstancesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ManagedInstancesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedInstancesClient) (ManagedInstance, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedInstancesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedInstancesUpdateFuture.Result.
func (future *ManagedInstancesUpdateFuture) result(client ManagedInstancesClient) (mi ManagedInstance, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstancesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		mi.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstancesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mi.Response.Response, err = future.GetResult(sender); err == nil && mi.Response.Response.StatusCode != http.StatusNoContent {
		mi, err = client.UpdateResponder(mi.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedInstancesUpdateFuture", "Result", mi.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedInstanceTdeCertificatesCreateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedInstanceTdeCertificatesCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedInstanceTdeCertificatesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedInstanceTdeCertificatesCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedInstanceTdeCertificatesCreateFuture.Result.
func (future *ManagedInstanceTdeCertificatesCreateFuture) result(client ManagedInstanceTdeCertificatesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstanceTdeCertificatesCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstanceTdeCertificatesCreateFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedInstanceUpdate an update request for an Azure SQL Database managed instance.
type ManagedInstanceUpdate struct {
	// Sku - Managed instance sku
	Sku *Sku `json:"sku,omitempty"`
	// Identity - Managed instance identity
	Identity *ResourceIdentity `json:"identity,omitempty"`
	// ManagedInstanceProperties - Resource properties.
	*ManagedInstanceProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceUpdate.
func (miu ManagedInstanceUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if miu.Sku != nil {
		objectMap["sku"] = miu.Sku
	}
	if miu.Identity != nil {
		objectMap["identity"] = miu.Identity
	}
	if miu.ManagedInstanceProperties != nil {
		objectMap["properties"] = miu.ManagedInstanceProperties
	}
	if miu.Tags != nil {
		objectMap["tags"] = miu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedInstanceUpdate struct.
func (miu *ManagedInstanceUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				miu.Sku = &sku
			}
		case "identity":
			if v != nil {
				var identity ResourceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				miu.Identity = &identity
			}
		case "properties":
			if v != nil {
				var managedInstanceProperties ManagedInstanceProperties
				err = json.Unmarshal(*v, &managedInstanceProperties)
				if err != nil {
					return err
				}
				miu.ManagedInstanceProperties = &managedInstanceProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				miu.Tags = tags
			}
		}
	}

	return nil
}

// ManagedInstanceVcoresCapability the managed instance virtual cores capability.
type ManagedInstanceVcoresCapability struct {
	// Name - READ-ONLY; The virtual cores identifier.
	Name *string `json:"name,omitempty"`
	// Value - READ-ONLY; The virtual cores value.
	Value *int32 `json:"value,omitempty"`
	// IncludedMaxSize - READ-ONLY; Included size.
	IncludedMaxSize *MaxSizeCapability `json:"includedMaxSize,omitempty"`
	// SupportedStorageSizes - READ-ONLY; Storage size ranges.
	SupportedStorageSizes *[]MaxSizeRangeCapability `json:"supportedStorageSizes,omitempty"`
	// InstancePoolSupported - READ-ONLY; True if this service objective is supported for managed instances in an instance pool.
	InstancePoolSupported *bool `json:"instancePoolSupported,omitempty"`
	// StandaloneSupported - READ-ONLY; True if this service objective is supported for standalone managed instances.
	StandaloneSupported *bool `json:"standaloneSupported,omitempty"`
	// SupportedMaintenanceConfigurations - READ-ONLY; List of supported maintenance configurations
	SupportedMaintenanceConfigurations *[]ManagedInstanceMaintenanceConfigurationCapability `json:"supportedMaintenanceConfigurations,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceVcoresCapability.
func (mivc ManagedInstanceVcoresCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mivc.Reason != nil {
		objectMap["reason"] = mivc.Reason
	}
	return json.Marshal(objectMap)
}

// ManagedInstanceVersionCapability the managed instance capability
type ManagedInstanceVersionCapability struct {
	// Name - READ-ONLY; The server version name.
	Name *string `json:"name,omitempty"`
	// SupportedEditions - READ-ONLY; The list of supported managed instance editions.
	SupportedEditions *[]ManagedInstanceEditionCapability `json:"supportedEditions,omitempty"`
	// SupportedInstancePoolEditions - READ-ONLY; The list of supported instance pool editions.
	SupportedInstancePoolEditions *[]InstancePoolEditionCapability `json:"supportedInstancePoolEditions,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceVersionCapability.
func (mivc ManagedInstanceVersionCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mivc.Reason != nil {
		objectMap["reason"] = mivc.Reason
	}
	return json.Marshal(objectMap)
}

// ManagedInstanceVulnerabilityAssessment a managed instance vulnerability assessment.
type ManagedInstanceVulnerabilityAssessment struct {
	autorest.Response `json:"-"`
	// ManagedInstanceVulnerabilityAssessmentProperties - Resource properties.
	*ManagedInstanceVulnerabilityAssessmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceVulnerabilityAssessment.
func (miva ManagedInstanceVulnerabilityAssessment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if miva.ManagedInstanceVulnerabilityAssessmentProperties != nil {
		objectMap["properties"] = miva.ManagedInstanceVulnerabilityAssessmentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedInstanceVulnerabilityAssessment struct.
func (miva *ManagedInstanceVulnerabilityAssessment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedInstanceVulnerabilityAssessmentProperties ManagedInstanceVulnerabilityAssessmentProperties
				err = json.Unmarshal(*v, &managedInstanceVulnerabilityAssessmentProperties)
				if err != nil {
					return err
				}
				miva.ManagedInstanceVulnerabilityAssessmentProperties = &managedInstanceVulnerabilityAssessmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				miva.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				miva.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				miva.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedInstanceVulnerabilityAssessmentListResult a list of the ManagedInstance's vulnerability
// assessments.
type ManagedInstanceVulnerabilityAssessmentListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedInstanceVulnerabilityAssessment `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceVulnerabilityAssessmentListResult.
func (mivalr ManagedInstanceVulnerabilityAssessmentListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedInstanceVulnerabilityAssessmentListResultIterator provides access to a complete listing of
// ManagedInstanceVulnerabilityAssessment values.
type ManagedInstanceVulnerabilityAssessmentListResultIterator struct {
	i    int
	page ManagedInstanceVulnerabilityAssessmentListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedInstanceVulnerabilityAssessmentListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceVulnerabilityAssessmentListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedInstanceVulnerabilityAssessmentListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedInstanceVulnerabilityAssessmentListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedInstanceVulnerabilityAssessmentListResultIterator) Response() ManagedInstanceVulnerabilityAssessmentListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedInstanceVulnerabilityAssessmentListResultIterator) Value() ManagedInstanceVulnerabilityAssessment {
	if !iter.page.NotDone() {
		return ManagedInstanceVulnerabilityAssessment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedInstanceVulnerabilityAssessmentListResultIterator type.
func NewManagedInstanceVulnerabilityAssessmentListResultIterator(page ManagedInstanceVulnerabilityAssessmentListResultPage) ManagedInstanceVulnerabilityAssessmentListResultIterator {
	return ManagedInstanceVulnerabilityAssessmentListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mivalr ManagedInstanceVulnerabilityAssessmentListResult) IsEmpty() bool {
	return mivalr.Value == nil || len(*mivalr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mivalr ManagedInstanceVulnerabilityAssessmentListResult) hasNextLink() bool {
	return mivalr.NextLink != nil && len(*mivalr.NextLink) != 0
}

// managedInstanceVulnerabilityAssessmentListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mivalr ManagedInstanceVulnerabilityAssessmentListResult) managedInstanceVulnerabilityAssessmentListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mivalr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mivalr.NextLink)))
}

// ManagedInstanceVulnerabilityAssessmentListResultPage contains a page of
// ManagedInstanceVulnerabilityAssessment values.
type ManagedInstanceVulnerabilityAssessmentListResultPage struct {
	fn     func(context.Context, ManagedInstanceVulnerabilityAssessmentListResult) (ManagedInstanceVulnerabilityAssessmentListResult, error)
	mivalr ManagedInstanceVulnerabilityAssessmentListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedInstanceVulnerabilityAssessmentListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceVulnerabilityAssessmentListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mivalr)
		if err != nil {
			return err
		}
		page.mivalr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedInstanceVulnerabilityAssessmentListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedInstanceVulnerabilityAssessmentListResultPage) NotDone() bool {
	return !page.mivalr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedInstanceVulnerabilityAssessmentListResultPage) Response() ManagedInstanceVulnerabilityAssessmentListResult {
	return page.mivalr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedInstanceVulnerabilityAssessmentListResultPage) Values() []ManagedInstanceVulnerabilityAssessment {
	if page.mivalr.IsEmpty() {
		return nil
	}
	return *page.mivalr.Value
}

// Creates a new instance of the ManagedInstanceVulnerabilityAssessmentListResultPage type.
func NewManagedInstanceVulnerabilityAssessmentListResultPage(cur ManagedInstanceVulnerabilityAssessmentListResult, getNextPage func(context.Context, ManagedInstanceVulnerabilityAssessmentListResult) (ManagedInstanceVulnerabilityAssessmentListResult, error)) ManagedInstanceVulnerabilityAssessmentListResultPage {
	return ManagedInstanceVulnerabilityAssessmentListResultPage{
		fn:     getNextPage,
		mivalr: cur,
	}
}

// ManagedInstanceVulnerabilityAssessmentProperties properties of a managed instance vulnerability
// assessment.
type ManagedInstanceVulnerabilityAssessmentProperties struct {
	// StorageContainerPath - A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).
	StorageContainerPath *string `json:"storageContainerPath,omitempty"`
	// StorageContainerSasKey - A shared access signature (SAS Key) that has write access to the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is required. Applies only if the storage account is not behind a Vnet or a firewall
	StorageContainerSasKey *string `json:"storageContainerSasKey,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required. Applies only if the storage account is not behind a Vnet or a firewall
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RecurringScans - The recurring scans settings
	RecurringScans *VulnerabilityAssessmentRecurringScansProperties `json:"recurringScans,omitempty"`
}

// ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesCreateOrUpdateFuture an abstraction for
// monitoring and retrieving the results of a long-running operation.
type ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient) (ManagedBackupShortTermRetentionPolicy, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesCreateOrUpdateFuture.Result.
func (future *ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesCreateOrUpdateFuture) result(client ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient) (mbstrp ManagedBackupShortTermRetentionPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		mbstrp.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mbstrp.Response.Response, err = future.GetResult(sender); err == nil && mbstrp.Response.Response.StatusCode != http.StatusNoContent {
		mbstrp, err = client.CreateOrUpdateResponder(mbstrp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesCreateOrUpdateFuture", "Result", mbstrp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesUpdateFuture an abstraction for
// monitoring and retrieving the results of a long-running operation.
type ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient) (ManagedBackupShortTermRetentionPolicy, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesUpdateFuture.Result.
func (future *ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesUpdateFuture) result(client ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient) (mbstrp ManagedBackupShortTermRetentionPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		mbstrp.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mbstrp.Response.Response, err = future.GetResult(sender); err == nil && mbstrp.Response.Response.StatusCode != http.StatusNoContent {
		mbstrp, err = client.UpdateResponder(mbstrp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesUpdateFuture", "Result", mbstrp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedServerDNSAlias a managed server DNS alias.
type ManagedServerDNSAlias struct {
	autorest.Response `json:"-"`
	// ManagedServerDNSAliasProperties - Resource properties.
	*ManagedServerDNSAliasProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedServerDNSAlias.
func (msda ManagedServerDNSAlias) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if msda.ManagedServerDNSAliasProperties != nil {
		objectMap["properties"] = msda.ManagedServerDNSAliasProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedServerDNSAlias struct.
func (msda *ManagedServerDNSAlias) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedServerDNSAliasProperties ManagedServerDNSAliasProperties
				err = json.Unmarshal(*v, &managedServerDNSAliasProperties)
				if err != nil {
					return err
				}
				msda.ManagedServerDNSAliasProperties = &managedServerDNSAliasProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				msda.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				msda.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				msda.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedServerDNSAliasAcquisition a managed server DNS alias acquisition request.
type ManagedServerDNSAliasAcquisition struct {
	// OldManagedServerDNSAliasResourceID - The resource ID of the managed server DNS alias that will be acquired to point to this managed server instead.
	OldManagedServerDNSAliasResourceID *string `json:"oldManagedServerDnsAliasResourceId,omitempty"`
}

// ManagedServerDNSAliasCreation a managed server dns alias creation request.
type ManagedServerDNSAliasCreation struct {
	// CreateDNSRecord - Whether or not DNS record should be created for this alias.
	CreateDNSRecord *bool `json:"createDnsRecord,omitempty"`
}

// ManagedServerDNSAliasesAcquireFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedServerDNSAliasesAcquireFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedServerDNSAliasesClient) (ManagedServerDNSAlias, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedServerDNSAliasesAcquireFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedServerDNSAliasesAcquireFuture.Result.
func (future *ManagedServerDNSAliasesAcquireFuture) result(client ManagedServerDNSAliasesClient) (msda ManagedServerDNSAlias, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedServerDNSAliasesAcquireFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		msda.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedServerDNSAliasesAcquireFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if msda.Response.Response, err = future.GetResult(sender); err == nil && msda.Response.Response.StatusCode != http.StatusNoContent {
		msda, err = client.AcquireResponder(msda.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedServerDNSAliasesAcquireFuture", "Result", msda.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedServerDNSAliasesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type ManagedServerDNSAliasesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedServerDNSAliasesClient) (ManagedServerDNSAlias, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedServerDNSAliasesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedServerDNSAliasesCreateOrUpdateFuture.Result.
func (future *ManagedServerDNSAliasesCreateOrUpdateFuture) result(client ManagedServerDNSAliasesClient) (msda ManagedServerDNSAlias, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedServerDNSAliasesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		msda.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedServerDNSAliasesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if msda.Response.Response, err = future.GetResult(sender); err == nil && msda.Response.Response.StatusCode != http.StatusNoContent {
		msda, err = client.CreateOrUpdateResponder(msda.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedServerDNSAliasesCreateOrUpdateFuture", "Result", msda.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedServerDNSAliasesDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedServerDNSAliasesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedServerDNSAliasesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedServerDNSAliasesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedServerDNSAliasesDeleteFuture.Result.
func (future *ManagedServerDNSAliasesDeleteFuture) result(client ManagedServerDNSAliasesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedServerDNSAliasesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedServerDNSAliasesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedServerDNSAliasListResult a list of managed server DNS aliases.
type ManagedServerDNSAliasListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedServerDNSAlias `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedServerDNSAliasListResult.
func (msdalr ManagedServerDNSAliasListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedServerDNSAliasListResultIterator provides access to a complete listing of ManagedServerDNSAlias
// values.
type ManagedServerDNSAliasListResultIterator struct {
	i    int
	page ManagedServerDNSAliasListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedServerDNSAliasListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedServerDNSAliasListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedServerDNSAliasListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedServerDNSAliasListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedServerDNSAliasListResultIterator) Response() ManagedServerDNSAliasListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedServerDNSAliasListResultIterator) Value() ManagedServerDNSAlias {
	if !iter.page.NotDone() {
		return ManagedServerDNSAlias{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedServerDNSAliasListResultIterator type.
func NewManagedServerDNSAliasListResultIterator(page ManagedServerDNSAliasListResultPage) ManagedServerDNSAliasListResultIterator {
	return ManagedServerDNSAliasListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (msdalr ManagedServerDNSAliasListResult) IsEmpty() bool {
	return msdalr.Value == nil || len(*msdalr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (msdalr ManagedServerDNSAliasListResult) hasNextLink() bool {
	return msdalr.NextLink != nil && len(*msdalr.NextLink) != 0
}

// managedServerDNSAliasListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (msdalr ManagedServerDNSAliasListResult) managedServerDNSAliasListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !msdalr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(msdalr.NextLink)))
}

// ManagedServerDNSAliasListResultPage contains a page of ManagedServerDNSAlias values.
type ManagedServerDNSAliasListResultPage struct {
	fn     func(context.Context, ManagedServerDNSAliasListResult) (ManagedServerDNSAliasListResult, error)
	msdalr ManagedServerDNSAliasListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedServerDNSAliasListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedServerDNSAliasListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.msdalr)
		if err != nil {
			return err
		}
		page.msdalr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedServerDNSAliasListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedServerDNSAliasListResultPage) NotDone() bool {
	return !page.msdalr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedServerDNSAliasListResultPage) Response() ManagedServerDNSAliasListResult {
	return page.msdalr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedServerDNSAliasListResultPage) Values() []ManagedServerDNSAlias {
	if page.msdalr.IsEmpty() {
		return nil
	}
	return *page.msdalr.Value
}

// Creates a new instance of the ManagedServerDNSAliasListResultPage type.
func NewManagedServerDNSAliasListResultPage(cur ManagedServerDNSAliasListResult, getNextPage func(context.Context, ManagedServerDNSAliasListResult) (ManagedServerDNSAliasListResult, error)) ManagedServerDNSAliasListResultPage {
	return ManagedServerDNSAliasListResultPage{
		fn:     getNextPage,
		msdalr: cur,
	}
}

// ManagedServerDNSAliasProperties properties of a managed server DNS alias.
type ManagedServerDNSAliasProperties struct {
	// AzureDNSRecord - READ-ONLY; The fully qualified DNS record for managed server alias
	AzureDNSRecord *string `json:"azureDnsRecord,omitempty"`
	// PublicAzureDNSRecord - READ-ONLY; The fully qualified public DNS record for managed server alias
	PublicAzureDNSRecord *string `json:"publicAzureDnsRecord,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedServerDNSAliasProperties.
func (msdap ManagedServerDNSAliasProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedServerSecurityAlertPoliciesCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ManagedServerSecurityAlertPoliciesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedServerSecurityAlertPoliciesClient) (ManagedServerSecurityAlertPolicy, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedServerSecurityAlertPoliciesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedServerSecurityAlertPoliciesCreateOrUpdateFuture.Result.
func (future *ManagedServerSecurityAlertPoliciesCreateOrUpdateFuture) result(client ManagedServerSecurityAlertPoliciesClient) (mssap ManagedServerSecurityAlertPolicy, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedServerSecurityAlertPoliciesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		mssap.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ManagedServerSecurityAlertPoliciesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mssap.Response.Response, err = future.GetResult(sender); err == nil && mssap.Response.Response.StatusCode != http.StatusNoContent {
		mssap, err = client.CreateOrUpdateResponder(mssap.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedServerSecurityAlertPoliciesCreateOrUpdateFuture", "Result", mssap.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedServerSecurityAlertPolicy a managed server security alert policy.
type ManagedServerSecurityAlertPolicy struct {
	autorest.Response `json:"-"`
	// SystemData - READ-ONLY; SystemData of SecurityAlertPolicyResource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// SecurityAlertsPolicyProperties - Resource properties.
	*SecurityAlertsPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedServerSecurityAlertPolicy.
func (mssap ManagedServerSecurityAlertPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mssap.SecurityAlertsPolicyProperties != nil {
		objectMap["properties"] = mssap.SecurityAlertsPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedServerSecurityAlertPolicy struct.
func (mssap *ManagedServerSecurityAlertPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				mssap.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var securityAlertsPolicyProperties SecurityAlertsPolicyProperties
				err = json.Unmarshal(*v, &securityAlertsPolicyProperties)
				if err != nil {
					return err
				}
				mssap.SecurityAlertsPolicyProperties = &securityAlertsPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mssap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mssap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mssap.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedServerSecurityAlertPolicyListResult a list of the managed Server's security alert policies.
type ManagedServerSecurityAlertPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedServerSecurityAlertPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedServerSecurityAlertPolicyListResult.
func (mssaplr ManagedServerSecurityAlertPolicyListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedServerSecurityAlertPolicyListResultIterator provides access to a complete listing of
// ManagedServerSecurityAlertPolicy values.
type ManagedServerSecurityAlertPolicyListResultIterator struct {
	i    int
	page ManagedServerSecurityAlertPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedServerSecurityAlertPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedServerSecurityAlertPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedServerSecurityAlertPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedServerSecurityAlertPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedServerSecurityAlertPolicyListResultIterator) Response() ManagedServerSecurityAlertPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedServerSecurityAlertPolicyListResultIterator) Value() ManagedServerSecurityAlertPolicy {
	if !iter.page.NotDone() {
		return ManagedServerSecurityAlertPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedServerSecurityAlertPolicyListResultIterator type.
func NewManagedServerSecurityAlertPolicyListResultIterator(page ManagedServerSecurityAlertPolicyListResultPage) ManagedServerSecurityAlertPolicyListResultIterator {
	return ManagedServerSecurityAlertPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mssaplr ManagedServerSecurityAlertPolicyListResult) IsEmpty() bool {
	return mssaplr.Value == nil || len(*mssaplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mssaplr ManagedServerSecurityAlertPolicyListResult) hasNextLink() bool {
	return mssaplr.NextLink != nil && len(*mssaplr.NextLink) != 0
}

// managedServerSecurityAlertPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mssaplr ManagedServerSecurityAlertPolicyListResult) managedServerSecurityAlertPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mssaplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mssaplr.NextLink)))
}

// ManagedServerSecurityAlertPolicyListResultPage contains a page of ManagedServerSecurityAlertPolicy
// values.
type ManagedServerSecurityAlertPolicyListResultPage struct {
	fn      func(context.Context, ManagedServerSecurityAlertPolicyListResult) (ManagedServerSecurityAlertPolicyListResult, error)
	mssaplr ManagedServerSecurityAlertPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedServerSecurityAlertPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedServerSecurityAlertPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mssaplr)
		if err != nil {
			return err
		}
		page.mssaplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedServerSecurityAlertPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedServerSecurityAlertPolicyListResultPage) NotDone() bool {
	return !page.mssaplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedServerSecurityAlertPolicyListResultPage) Response() ManagedServerSecurityAlertPolicyListResult {
	return page.mssaplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedServerSecurityAlertPolicyListResultPage) Values() []ManagedServerSecurityAlertPolicy {
	if page.mssaplr.IsEmpty() {
		return nil
	}
	return *page.mssaplr.Value
}

// Creates a new instance of the ManagedServerSecurityAlertPolicyListResultPage type.
func NewManagedServerSecurityAlertPolicyListResultPage(cur ManagedServerSecurityAlertPolicyListResult, getNextPage func(context.Context, ManagedServerSecurityAlertPolicyListResult) (ManagedServerSecurityAlertPolicyListResult, error)) ManagedServerSecurityAlertPolicyListResultPage {
	return ManagedServerSecurityAlertPolicyListResultPage{
		fn:      getNextPage,
		mssaplr: cur,
	}
}

// ManagedTransparentDataEncryption a managed database transparent data encryption state.
type ManagedTransparentDataEncryption struct {
	autorest.Response `json:"-"`
	// ManagedTransparentDataEncryptionProperties - Resource properties.
	*ManagedTransparentDataEncryptionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedTransparentDataEncryption.
func (mtde ManagedTransparentDataEncryption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mtde.ManagedTransparentDataEncryptionProperties != nil {
		objectMap["properties"] = mtde.ManagedTransparentDataEncryptionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedTransparentDataEncryption struct.
func (mtde *ManagedTransparentDataEncryption) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedTransparentDataEncryptionProperties ManagedTransparentDataEncryptionProperties
				err = json.Unmarshal(*v, &managedTransparentDataEncryptionProperties)
				if err != nil {
					return err
				}
				mtde.ManagedTransparentDataEncryptionProperties = &managedTransparentDataEncryptionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mtde.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mtde.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mtde.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedTransparentDataEncryptionListResult a list of managed transparent data encryptions
type ManagedTransparentDataEncryptionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedTransparentDataEncryption `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedTransparentDataEncryptionListResult.
func (mtdelr ManagedTransparentDataEncryptionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedTransparentDataEncryptionListResultIterator provides access to a complete listing of
// ManagedTransparentDataEncryption values.
type ManagedTransparentDataEncryptionListResultIterator struct {
	i    int
	page ManagedTransparentDataEncryptionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedTransparentDataEncryptionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedTransparentDataEncryptionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedTransparentDataEncryptionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedTransparentDataEncryptionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedTransparentDataEncryptionListResultIterator) Response() ManagedTransparentDataEncryptionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedTransparentDataEncryptionListResultIterator) Value() ManagedTransparentDataEncryption {
	if !iter.page.NotDone() {
		return ManagedTransparentDataEncryption{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedTransparentDataEncryptionListResultIterator type.
func NewManagedTransparentDataEncryptionListResultIterator(page ManagedTransparentDataEncryptionListResultPage) ManagedTransparentDataEncryptionListResultIterator {
	return ManagedTransparentDataEncryptionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mtdelr ManagedTransparentDataEncryptionListResult) IsEmpty() bool {
	return mtdelr.Value == nil || len(*mtdelr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mtdelr ManagedTransparentDataEncryptionListResult) hasNextLink() bool {
	return mtdelr.NextLink != nil && len(*mtdelr.NextLink) != 0
}

// managedTransparentDataEncryptionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mtdelr ManagedTransparentDataEncryptionListResult) managedTransparentDataEncryptionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mtdelr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mtdelr.NextLink)))
}

// ManagedTransparentDataEncryptionListResultPage contains a page of ManagedTransparentDataEncryption
// values.
type ManagedTransparentDataEncryptionListResultPage struct {
	fn     func(context.Context, ManagedTransparentDataEncryptionListResult) (ManagedTransparentDataEncryptionListResult, error)
	mtdelr ManagedTransparentDataEncryptionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedTransparentDataEncryptionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedTransparentDataEncryptionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mtdelr)
		if err != nil {
			return err
		}
		page.mtdelr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedTransparentDataEncryptionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedTransparentDataEncryptionListResultPage) NotDone() bool {
	return !page.mtdelr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedTransparentDataEncryptionListResultPage) Response() ManagedTransparentDataEncryptionListResult {
	return page.mtdelr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedTransparentDataEncryptionListResultPage) Values() []ManagedTransparentDataEncryption {
	if page.mtdelr.IsEmpty() {
		return nil
	}
	return *page.mtdelr.Value
}

// Creates a new instance of the ManagedTransparentDataEncryptionListResultPage type.
func NewManagedTransparentDataEncryptionListResultPage(cur ManagedTransparentDataEncryptionListResult, getNextPage func(context.Context, ManagedTransparentDataEncryptionListResult) (ManagedTransparentDataEncryptionListResult, error)) ManagedTransparentDataEncryptionListResultPage {
	return ManagedTransparentDataEncryptionListResultPage{
		fn:     getNextPage,
		mtdelr: cur,
	}
}

// ManagedTransparentDataEncryptionProperties properties of a transparent data encryption.
type ManagedTransparentDataEncryptionProperties struct {
	// State - Specifies the state of the transparent data encryption. Possible values include: 'TransparentDataEncryptionStateEnabled', 'TransparentDataEncryptionStateDisabled'
	State TransparentDataEncryptionState `json:"state,omitempty"`
}

// MaxSizeCapability the maximum size capability.
type MaxSizeCapability struct {
	// Limit - READ-ONLY; The maximum size limit (see 'unit' for the units).
	Limit *int32 `json:"limit,omitempty"`
	// Unit - READ-ONLY; The units that the limit is expressed in. Possible values include: 'MaxSizeUnitMegabytes', 'MaxSizeUnitGigabytes', 'MaxSizeUnitTerabytes', 'MaxSizeUnitPetabytes'
	Unit MaxSizeUnit `json:"unit,omitempty"`
}

// MarshalJSON is the custom marshaler for MaxSizeCapability.
func (msc MaxSizeCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// MaxSizeRangeCapability the maximum size range capability.
type MaxSizeRangeCapability struct {
	// MinValue - READ-ONLY; Minimum value.
	MinValue *MaxSizeCapability `json:"minValue,omitempty"`
	// MaxValue - READ-ONLY; Maximum value.
	MaxValue *MaxSizeCapability `json:"maxValue,omitempty"`
	// ScaleSize - READ-ONLY; Scale/step size for discrete values between the minimum value and the maximum value.
	ScaleSize *MaxSizeCapability `json:"scaleSize,omitempty"`
	// LogSize - READ-ONLY; Size of transaction log.
	LogSize *LogSizeCapability `json:"logSize,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for MaxSizeRangeCapability.
func (msrc MaxSizeRangeCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if msrc.Reason != nil {
		objectMap["reason"] = msrc.Reason
	}
	return json.Marshal(objectMap)
}

// Metric database metrics.
type Metric struct {
	// StartTime - READ-ONLY; The start time for the metric (ISO-8601 format).
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The end time for the metric (ISO-8601 format).
	EndTime *date.Time `json:"endTime,omitempty"`
	// TimeGrain - READ-ONLY; The time step to be used to summarize the metric values.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Unit - READ-ONLY; The unit of the metric. Possible values include: 'UnitTypeCount', 'UnitTypeBytes', 'UnitTypeSeconds', 'UnitTypePercent', 'UnitTypeCountPerSecond', 'UnitTypeBytesPerSecond'
	Unit UnitType `json:"unit,omitempty"`
	// Name - READ-ONLY; The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
	// MetricValues - READ-ONLY; The metric values for the specified time window and timestep.
	MetricValues *[]MetricValue `json:"metricValues,omitempty"`
}

// MarshalJSON is the custom marshaler for Metric.
func (mVar Metric) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// MetricAvailability a metric availability value.
type MetricAvailability struct {
	// Retention - READ-ONLY; The length of retention for the database metric.
	Retention *string `json:"retention,omitempty"`
	// TimeGrain - READ-ONLY; The granularity of the database metric.
	TimeGrain *string `json:"timeGrain,omitempty"`
}

// MarshalJSON is the custom marshaler for MetricAvailability.
func (ma MetricAvailability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// MetricDefinition a database metric definition.
type MetricDefinition struct {
	// Name - READ-ONLY; The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
	// PrimaryAggregationType - READ-ONLY; The primary aggregation type defining how metric values are displayed. Possible values include: 'PrimaryAggregationTypeNone', 'PrimaryAggregationTypeAverage', 'PrimaryAggregationTypeCount', 'PrimaryAggregationTypeMinimum', 'PrimaryAggregationTypeMaximum', 'PrimaryAggregationTypeTotal'
	PrimaryAggregationType PrimaryAggregationType `json:"primaryAggregationType,omitempty"`
	// ResourceURI - READ-ONLY; The resource uri of the database.
	ResourceURI *string `json:"resourceUri,omitempty"`
	// Unit - READ-ONLY; The unit of the metric. Possible values include: 'UnitDefinitionTypeCount', 'UnitDefinitionTypeBytes', 'UnitDefinitionTypeSeconds', 'UnitDefinitionTypePercent', 'UnitDefinitionTypeCountPerSecond', 'UnitDefinitionTypeBytesPerSecond'
	Unit UnitDefinitionType `json:"unit,omitempty"`
	// MetricAvailabilities - READ-ONLY; The list of database metric availabilities for the metric.
	MetricAvailabilities *[]MetricAvailability `json:"metricAvailabilities,omitempty"`
}

// MarshalJSON is the custom marshaler for MetricDefinition.
func (md MetricDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// MetricDefinitionListResult the response to a list database metric definitions request.
type MetricDefinitionListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of metric definitions for the database.
	Value *[]MetricDefinition `json:"value,omitempty"`
}

// MetricListResult the response to a list database metrics request.
type MetricListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of metrics for the database.
	Value *[]Metric `json:"value,omitempty"`
}

// MetricName a database metric name.
type MetricName struct {
	// Value - READ-ONLY; The name of the database metric.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - READ-ONLY; The friendly name of the database metric.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// MarshalJSON is the custom marshaler for MetricName.
func (mn MetricName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// MetricValue represents database metrics.
type MetricValue struct {
	// Count - READ-ONLY; The number of values for the metric.
	Count *float64 `json:"count,omitempty"`
	// Average - READ-ONLY; The average value of the metric.
	Average *float64 `json:"average,omitempty"`
	// Maximum - READ-ONLY; The max value of the metric.
	Maximum *float64 `json:"maximum,omitempty"`
	// Minimum - READ-ONLY; The min value of the metric.
	Minimum *float64 `json:"minimum,omitempty"`
	// Timestamp - READ-ONLY; The metric timestamp (ISO-8601 format).
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Total - READ-ONLY; The total value of the metric.
	Total *float64 `json:"total,omitempty"`
}

// MarshalJSON is the custom marshaler for MetricValue.
func (mv MetricValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// MinCapacityCapability the min capacity capability
type MinCapacityCapability struct {
	// Value - READ-ONLY; Min capacity value
	Value *float64 `json:"value,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for MinCapacityCapability.
func (mcc MinCapacityCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mcc.Reason != nil {
		objectMap["reason"] = mcc.Reason
	}
	return json.Marshal(objectMap)
}

// Name ARM Usage Name
type Name struct {
	// Value - Usage name value
	Value *string `json:"value,omitempty"`
	// LocalizedValue - Usage name localized value.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// NetworkIsolationSettings contains the ARM resources for which to create private endpoint connection.
type NetworkIsolationSettings struct {
	// StorageAccountResourceID - The resource id for the storage account used to store BACPAC file. If set, private endpoint connection will be created for the storage account. Must match storage account used for StorageUri parameter.
	StorageAccountResourceID *string `json:"storageAccountResourceId,omitempty"`
	// SQLServerResourceID - The resource id for the SQL server which is the target of this request. If set, private endpoint connection will be created for the SQL server. Must match server which is target of the operation.
	SQLServerResourceID *string `json:"sqlServerResourceId,omitempty"`
}

// Operation SQL REST API operation definition.
type Operation struct {
	// Name - READ-ONLY; The name of the operation being performed on this particular object.
	Name *string `json:"name,omitempty"`
	// Display - READ-ONLY; The localized display information for this particular operation / action.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - READ-ONLY; The intended executor of the operation. Possible values include: 'OperationOriginUser', 'OperationOriginSystem'
	Origin OperationOrigin `json:"origin,omitempty"`
	// Properties - READ-ONLY; Additional descriptions for the operation.
	Properties map[string]interface{} `json:"properties"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationDisplay display metadata associated with the operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; The localized friendly form of the resource provider name.
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; The localized friendly form of the resource type related to this action/operation.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; The localized friendly name for the operation.
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; The localized friendly description for the operation.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationDisplay.
func (od OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationImpact the impact of an operation, both in absolute and relative terms.
type OperationImpact struct {
	// Name - READ-ONLY; The name of the impact dimension.
	Name *string `json:"name,omitempty"`
	// Unit - READ-ONLY; The unit in which estimated impact to dimension is measured.
	Unit *string `json:"unit,omitempty"`
	// ChangeValueAbsolute - READ-ONLY; The absolute impact to dimension.
	ChangeValueAbsolute *float64 `json:"changeValueAbsolute,omitempty"`
	// ChangeValueRelative - READ-ONLY; The relative impact to dimension (null if not applicable)
	ChangeValueRelative *float64 `json:"changeValueRelative,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationImpact.
func (oi OperationImpact) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationListResult result of the request to list SQL operations.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationListResult.
func (olr OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// OutboundFirewallRule an Azure SQL DB Server Outbound Firewall Rule.
type OutboundFirewallRule struct {
	autorest.Response `json:"-"`
	// OutboundFirewallRuleProperties - Resource properties.
	*OutboundFirewallRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for OutboundFirewallRule.
func (ofr OutboundFirewallRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ofr.OutboundFirewallRuleProperties != nil {
		objectMap["properties"] = ofr.OutboundFirewallRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OutboundFirewallRule struct.
func (ofr *OutboundFirewallRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var outboundFirewallRuleProperties OutboundFirewallRuleProperties
				err = json.Unmarshal(*v, &outboundFirewallRuleProperties)
				if err != nil {
					return err
				}
				ofr.OutboundFirewallRuleProperties = &outboundFirewallRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ofr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ofr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ofr.Type = &typeVar
			}
		}
	}

	return nil
}

// OutboundFirewallRuleListResult a list of outbound rules.
type OutboundFirewallRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]OutboundFirewallRule `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OutboundFirewallRuleListResult.
func (ofrlr OutboundFirewallRuleListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OutboundFirewallRuleListResultIterator provides access to a complete listing of OutboundFirewallRule
// values.
type OutboundFirewallRuleListResultIterator struct {
	i    int
	page OutboundFirewallRuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OutboundFirewallRuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OutboundFirewallRuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OutboundFirewallRuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OutboundFirewallRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OutboundFirewallRuleListResultIterator) Response() OutboundFirewallRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OutboundFirewallRuleListResultIterator) Value() OutboundFirewallRule {
	if !iter.page.NotDone() {
		return OutboundFirewallRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OutboundFirewallRuleListResultIterator type.
func NewOutboundFirewallRuleListResultIterator(page OutboundFirewallRuleListResultPage) OutboundFirewallRuleListResultIterator {
	return OutboundFirewallRuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ofrlr OutboundFirewallRuleListResult) IsEmpty() bool {
	return ofrlr.Value == nil || len(*ofrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ofrlr OutboundFirewallRuleListResult) hasNextLink() bool {
	return ofrlr.NextLink != nil && len(*ofrlr.NextLink) != 0
}

// outboundFirewallRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ofrlr OutboundFirewallRuleListResult) outboundFirewallRuleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ofrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ofrlr.NextLink)))
}

// OutboundFirewallRuleListResultPage contains a page of OutboundFirewallRule values.
type OutboundFirewallRuleListResultPage struct {
	fn    func(context.Context, OutboundFirewallRuleListResult) (OutboundFirewallRuleListResult, error)
	ofrlr OutboundFirewallRuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OutboundFirewallRuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OutboundFirewallRuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ofrlr)
		if err != nil {
			return err
		}
		page.ofrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OutboundFirewallRuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OutboundFirewallRuleListResultPage) NotDone() bool {
	return !page.ofrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OutboundFirewallRuleListResultPage) Response() OutboundFirewallRuleListResult {
	return page.ofrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OutboundFirewallRuleListResultPage) Values() []OutboundFirewallRule {
	if page.ofrlr.IsEmpty() {
		return nil
	}
	return *page.ofrlr.Value
}

// Creates a new instance of the OutboundFirewallRuleListResultPage type.
func NewOutboundFirewallRuleListResultPage(cur OutboundFirewallRuleListResult, getNextPage func(context.Context, OutboundFirewallRuleListResult) (OutboundFirewallRuleListResult, error)) OutboundFirewallRuleListResultPage {
	return OutboundFirewallRuleListResultPage{
		fn:    getNextPage,
		ofrlr: cur,
	}
}

// OutboundFirewallRuleProperties the properties of an outbound firewall rule.
type OutboundFirewallRuleProperties struct {
	// ProvisioningState - READ-ONLY; The state of the outbound rule.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for OutboundFirewallRuleProperties.
func (ofrp OutboundFirewallRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OutboundFirewallRulesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type OutboundFirewallRulesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(OutboundFirewallRulesClient) (OutboundFirewallRule, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *OutboundFirewallRulesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for OutboundFirewallRulesCreateOrUpdateFuture.Result.
func (future *OutboundFirewallRulesCreateOrUpdateFuture) result(client OutboundFirewallRulesClient) (ofr OutboundFirewallRule, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.OutboundFirewallRulesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ofr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.OutboundFirewallRulesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ofr.Response.Response, err = future.GetResult(sender); err == nil && ofr.Response.Response.StatusCode != http.StatusNoContent {
		ofr, err = client.CreateOrUpdateResponder(ofr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.OutboundFirewallRulesCreateOrUpdateFuture", "Result", ofr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// OutboundFirewallRulesDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type OutboundFirewallRulesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(OutboundFirewallRulesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *OutboundFirewallRulesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for OutboundFirewallRulesDeleteFuture.Result.
func (future *OutboundFirewallRulesDeleteFuture) result(client OutboundFirewallRulesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.OutboundFirewallRulesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.OutboundFirewallRulesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PartnerInfo partner server information for the failover group.
type PartnerInfo struct {
	// ID - Resource identifier of the partner server.
	ID *string `json:"id,omitempty"`
	// Location - READ-ONLY; Geo location of the partner server.
	Location *string `json:"location,omitempty"`
	// ReplicationRole - READ-ONLY; Replication role of the partner server. Possible values include: 'FailoverGroupReplicationRolePrimary', 'FailoverGroupReplicationRoleSecondary'
	ReplicationRole FailoverGroupReplicationRole `json:"replicationRole,omitempty"`
}

// MarshalJSON is the custom marshaler for PartnerInfo.
func (pi PartnerInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pi.ID != nil {
		objectMap["id"] = pi.ID
	}
	return json.Marshal(objectMap)
}

// PartnerRegionInfo partner region information for the failover group.
type PartnerRegionInfo struct {
	// Location - Geo location of the partner managed instances.
	Location *string `json:"location,omitempty"`
	// ReplicationRole - READ-ONLY; Replication role of the partner managed instances. Possible values include: 'InstanceFailoverGroupReplicationRolePrimary', 'InstanceFailoverGroupReplicationRoleSecondary'
	ReplicationRole InstanceFailoverGroupReplicationRole `json:"replicationRole,omitempty"`
}

// MarshalJSON is the custom marshaler for PartnerRegionInfo.
func (pri PartnerRegionInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pri.Location != nil {
		objectMap["location"] = pri.Location
	}
	return json.Marshal(objectMap)
}

// PerformanceLevelCapability the performance level capability.
type PerformanceLevelCapability struct {
	// Value - READ-ONLY; Performance level value.
	Value *float64 `json:"value,omitempty"`
	// Unit - READ-ONLY; Unit type used to measure performance level. Possible values include: 'PerformanceLevelUnitDTU', 'PerformanceLevelUnitVCores'
	Unit PerformanceLevelUnit `json:"unit,omitempty"`
}

// MarshalJSON is the custom marshaler for PerformanceLevelCapability.
func (plc PerformanceLevelCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PrivateEndpointConnection a private endpoint connection
type PrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	// PrivateEndpointConnectionProperties - Resource properties.
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnection.
func (pec PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = pec.PrivateEndpointConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnection struct.
func (pec *PrivateEndpointConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				pec.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pec.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pec.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pec.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionListResult a list of private endpoint connections.
type PrivateEndpointConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]PrivateEndpointConnection `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnectionListResult.
func (peclr PrivateEndpointConnectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PrivateEndpointConnectionListResultIterator provides access to a complete listing of
// PrivateEndpointConnection values.
type PrivateEndpointConnectionListResultIterator struct {
	i    int
	page PrivateEndpointConnectionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateEndpointConnectionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointConnectionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateEndpointConnectionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateEndpointConnectionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateEndpointConnectionListResultIterator) Response() PrivateEndpointConnectionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateEndpointConnectionListResultIterator) Value() PrivateEndpointConnection {
	if !iter.page.NotDone() {
		return PrivateEndpointConnection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateEndpointConnectionListResultIterator type.
func NewPrivateEndpointConnectionListResultIterator(page PrivateEndpointConnectionListResultPage) PrivateEndpointConnectionListResultIterator {
	return PrivateEndpointConnectionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (peclr PrivateEndpointConnectionListResult) IsEmpty() bool {
	return peclr.Value == nil || len(*peclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (peclr PrivateEndpointConnectionListResult) hasNextLink() bool {
	return peclr.NextLink != nil && len(*peclr.NextLink) != 0
}

// privateEndpointConnectionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (peclr PrivateEndpointConnectionListResult) privateEndpointConnectionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !peclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(peclr.NextLink)))
}

// PrivateEndpointConnectionListResultPage contains a page of PrivateEndpointConnection values.
type PrivateEndpointConnectionListResultPage struct {
	fn    func(context.Context, PrivateEndpointConnectionListResult) (PrivateEndpointConnectionListResult, error)
	peclr PrivateEndpointConnectionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateEndpointConnectionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointConnectionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.peclr)
		if err != nil {
			return err
		}
		page.peclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateEndpointConnectionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateEndpointConnectionListResultPage) NotDone() bool {
	return !page.peclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateEndpointConnectionListResultPage) Response() PrivateEndpointConnectionListResult {
	return page.peclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateEndpointConnectionListResultPage) Values() []PrivateEndpointConnection {
	if page.peclr.IsEmpty() {
		return nil
	}
	return *page.peclr.Value
}

// Creates a new instance of the PrivateEndpointConnectionListResultPage type.
func NewPrivateEndpointConnectionListResultPage(cur PrivateEndpointConnectionListResult, getNextPage func(context.Context, PrivateEndpointConnectionListResult) (PrivateEndpointConnectionListResult, error)) PrivateEndpointConnectionListResultPage {
	return PrivateEndpointConnectionListResultPage{
		fn:    getNextPage,
		peclr: cur,
	}
}

// PrivateEndpointConnectionProperties properties of a private endpoint connection.
type PrivateEndpointConnectionProperties struct {
	// PrivateEndpoint - Private endpoint which the connection belongs to.
	PrivateEndpoint *PrivateEndpointProperty `json:"privateEndpoint,omitempty"`
	// PrivateLinkServiceConnectionState - Connection state of the private endpoint connection.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionStateProperty `json:"privateLinkServiceConnectionState,omitempty"`
	// ProvisioningState - READ-ONLY; State of the private endpoint connection. Possible values include: 'PrivateEndpointProvisioningStateApproving', 'PrivateEndpointProvisioningStateReady', 'PrivateEndpointProvisioningStateDropping', 'PrivateEndpointProvisioningStateFailed', 'PrivateEndpointProvisioningStateRejecting'
	ProvisioningState PrivateEndpointProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnectionProperties.
func (pecp PrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pecp.PrivateEndpoint != nil {
		objectMap["privateEndpoint"] = pecp.PrivateEndpoint
	}
	if pecp.PrivateLinkServiceConnectionState != nil {
		objectMap["privateLinkServiceConnectionState"] = pecp.PrivateLinkServiceConnectionState
	}
	return json.Marshal(objectMap)
}

// PrivateEndpointConnectionRequestStatus contains the private endpoint connection requests status.
type PrivateEndpointConnectionRequestStatus struct {
	// PrivateLinkServiceID - READ-ONLY; Resource id for which the private endpoint is created.
	PrivateLinkServiceID *string `json:"privateLinkServiceId,omitempty"`
	// PrivateEndpointConnectionName - READ-ONLY; The connection name for the private endpoint.
	PrivateEndpointConnectionName *string `json:"privateEndpointConnectionName,omitempty"`
	// Status - READ-ONLY; Status of this private endpoint connection.
	Status *string `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnectionRequestStatus.
func (pecrs PrivateEndpointConnectionRequestStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PrivateEndpointConnectionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type PrivateEndpointConnectionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (PrivateEndpointConnection, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateEndpointConnectionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateEndpointConnectionsCreateOrUpdateFuture.Result.
func (future *PrivateEndpointConnectionsCreateOrUpdateFuture) result(client PrivateEndpointConnectionsClient) (pec PrivateEndpointConnection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.PrivateEndpointConnectionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		pec.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.PrivateEndpointConnectionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pec.Response.Response, err = future.GetResult(sender); err == nil && pec.Response.Response.StatusCode != http.StatusNoContent {
		pec, err = client.CreateOrUpdateResponder(pec.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.PrivateEndpointConnectionsCreateOrUpdateFuture", "Result", pec.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PrivateEndpointConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateEndpointConnectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateEndpointConnectionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateEndpointConnectionsDeleteFuture.Result.
func (future *PrivateEndpointConnectionsDeleteFuture) result(client PrivateEndpointConnectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.PrivateEndpointConnectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.PrivateEndpointConnectionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PrivateEndpointProperty ...
type PrivateEndpointProperty struct {
	// ID - Resource id of the private endpoint.
	ID *string `json:"id,omitempty"`
}

// PrivateLinkResource a private link resource
type PrivateLinkResource struct {
	autorest.Response `json:"-"`
	// Properties - READ-ONLY; The private link resource group id.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResource.
func (plr PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PrivateLinkResourceListResult a list of private link resources
type PrivateLinkResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]PrivateLinkResource `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResourceListResult.
func (plrlr PrivateLinkResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PrivateLinkResourceListResultIterator provides access to a complete listing of PrivateLinkResource
// values.
type PrivateLinkResourceListResultIterator struct {
	i    int
	page PrivateLinkResourceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateLinkResourceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateLinkResourceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateLinkResourceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateLinkResourceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateLinkResourceListResultIterator) Response() PrivateLinkResourceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateLinkResourceListResultIterator) Value() PrivateLinkResource {
	if !iter.page.NotDone() {
		return PrivateLinkResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateLinkResourceListResultIterator type.
func NewPrivateLinkResourceListResultIterator(page PrivateLinkResourceListResultPage) PrivateLinkResourceListResultIterator {
	return PrivateLinkResourceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plrlr PrivateLinkResourceListResult) IsEmpty() bool {
	return plrlr.Value == nil || len(*plrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (plrlr PrivateLinkResourceListResult) hasNextLink() bool {
	return plrlr.NextLink != nil && len(*plrlr.NextLink) != 0
}

// privateLinkResourceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plrlr PrivateLinkResourceListResult) privateLinkResourceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !plrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plrlr.NextLink)))
}

// PrivateLinkResourceListResultPage contains a page of PrivateLinkResource values.
type PrivateLinkResourceListResultPage struct {
	fn    func(context.Context, PrivateLinkResourceListResult) (PrivateLinkResourceListResult, error)
	plrlr PrivateLinkResourceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateLinkResourceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateLinkResourceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.plrlr)
		if err != nil {
			return err
		}
		page.plrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateLinkResourceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateLinkResourceListResultPage) NotDone() bool {
	return !page.plrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateLinkResourceListResultPage) Response() PrivateLinkResourceListResult {
	return page.plrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateLinkResourceListResultPage) Values() []PrivateLinkResource {
	if page.plrlr.IsEmpty() {
		return nil
	}
	return *page.plrlr.Value
}

// Creates a new instance of the PrivateLinkResourceListResultPage type.
func NewPrivateLinkResourceListResultPage(cur PrivateLinkResourceListResult, getNextPage func(context.Context, PrivateLinkResourceListResult) (PrivateLinkResourceListResult, error)) PrivateLinkResourceListResultPage {
	return PrivateLinkResourceListResultPage{
		fn:    getNextPage,
		plrlr: cur,
	}
}

// PrivateLinkResourceProperties properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// GroupID - READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - READ-ONLY; The private link resource required member names.
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
	// RequiredZoneNames - READ-ONLY; The private link resource required zone names.
	RequiredZoneNames *[]string `json:"requiredZoneNames,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResourceProperties.
func (plrp PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PrivateLinkServiceConnectionStateProperty ...
type PrivateLinkServiceConnectionStateProperty struct {
	// Status - The private link service connection status. Possible values include: 'PrivateLinkServiceConnectionStateStatusApproved', 'PrivateLinkServiceConnectionStateStatusPending', 'PrivateLinkServiceConnectionStateStatusRejected', 'PrivateLinkServiceConnectionStateStatusDisconnected'
	Status PrivateLinkServiceConnectionStateStatus `json:"status,omitempty"`
	// Description - The private link service connection description.
	Description *string `json:"description,omitempty"`
	// ActionsRequired - READ-ONLY; The actions required for private link service connection. Possible values include: 'PrivateLinkServiceConnectionStateActionsRequireNone'
	ActionsRequired PrivateLinkServiceConnectionStateActionsRequire `json:"actionsRequired,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkServiceConnectionStateProperty.
func (plscsp PrivateLinkServiceConnectionStateProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plscsp.Status != "" {
		objectMap["status"] = plscsp.Status
	}
	if plscsp.Description != nil {
		objectMap["description"] = plscsp.Description
	}
	return json.Marshal(objectMap)
}

// ProxyResource ARM proxy resource.
type ProxyResource struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ProxyResourceWithWritableName ARM proxy resource.
type ProxyResourceWithWritableName struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResourceWithWritableName.
func (prwwn ProxyResourceWithWritableName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if prwwn.Name != nil {
		objectMap["name"] = prwwn.Name
	}
	return json.Marshal(objectMap)
}

// QueryCheck SQL Vulnerability Assessment query check object.
type QueryCheck struct {
	// Query - READ-ONLY; SQL Vulnerability Assessment rule query.
	Query *string `json:"query,omitempty"`
	// ExpectedResult - READ-ONLY; SQL Vulnerability Assessment query expected result.
	ExpectedResult *[][]string `json:"expectedResult,omitempty"`
	// ColumnNames - READ-ONLY; SQL Vulnerability Assessment column names of query expected result.
	ColumnNames *[]string `json:"columnNames,omitempty"`
}

// MarshalJSON is the custom marshaler for QueryCheck.
func (qc QueryCheck) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// QueryMetricInterval properties of a query metrics interval.
type QueryMetricInterval struct {
	// IntervalStartTime - READ-ONLY; The start time for the metric interval (ISO-8601 format).
	IntervalStartTime *string `json:"intervalStartTime,omitempty"`
	// IntervalType - READ-ONLY; Interval type (length). Possible values include: 'QueryTimeGrainTypePT1H', 'QueryTimeGrainTypeP1D'
	IntervalType QueryTimeGrainType `json:"intervalType,omitempty"`
	// ExecutionCount - READ-ONLY; Execution count of a query in this interval.
	ExecutionCount *int64 `json:"executionCount,omitempty"`
	// Metrics - List of metric objects for this interval
	Metrics *[]QueryMetricProperties `json:"metrics,omitempty"`
}

// MarshalJSON is the custom marshaler for QueryMetricInterval.
func (qmi QueryMetricInterval) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if qmi.Metrics != nil {
		objectMap["metrics"] = qmi.Metrics
	}
	return json.Marshal(objectMap)
}

// QueryMetricProperties properties of a topquery metric in one interval.
type QueryMetricProperties struct {
	// Name - READ-ONLY; The name information for the metric.
	Name *string `json:"name,omitempty"`
	// DisplayName - READ-ONLY; The UI appropriate name for the metric.
	DisplayName *string `json:"displayName,omitempty"`
	// Unit - READ-ONLY; The unit of the metric. Possible values include: 'QueryMetricUnitTypePercentage', 'QueryMetricUnitTypeKB', 'QueryMetricUnitTypeMicroseconds', 'QueryMetricUnitTypeCount'
	Unit QueryMetricUnitType `json:"unit,omitempty"`
	// Value - READ-ONLY; The value of the metric.
	Value *float64 `json:"value,omitempty"`
	// Min - READ-ONLY; Metric value when min() aggregate function is used over the interval.
	Min *float64 `json:"min,omitempty"`
	// Max - READ-ONLY; Metric value when max() aggregate function is used over the interval.
	Max *float64 `json:"max,omitempty"`
	// Avg - READ-ONLY; Metric value when avg() aggregate function is used over the interval.
	Avg *float64 `json:"avg,omitempty"`
	// Sum - READ-ONLY; Metric value when sum() aggregate function is used over the interval.
	Sum *float64 `json:"sum,omitempty"`
	// Stdev - READ-ONLY; Metric value when stdev aggregate function is used over the interval.
	Stdev *float64 `json:"stdev,omitempty"`
}

// MarshalJSON is the custom marshaler for QueryMetricProperties.
func (qmp QueryMetricProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// QueryProperties properties of a database query.
type QueryProperties struct {
	// QueryText - Query text.
	QueryText *string `json:"queryText,omitempty"`
}

// QueryStatistics ...
type QueryStatistics struct {
	// QueryStatisticsProperties - Resource properties.
	*QueryStatisticsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for QueryStatistics.
func (qs QueryStatistics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if qs.QueryStatisticsProperties != nil {
		objectMap["properties"] = qs.QueryStatisticsProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for QueryStatistics struct.
func (qs *QueryStatistics) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var queryStatisticsProperties QueryStatisticsProperties
				err = json.Unmarshal(*v, &queryStatisticsProperties)
				if err != nil {
					return err
				}
				qs.QueryStatisticsProperties = &queryStatisticsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				qs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				qs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				qs.Type = &typeVar
			}
		}
	}

	return nil
}

// QueryStatisticsProperties properties of a query execution statistics.
type QueryStatisticsProperties struct {
	// DatabaseName - READ-ONLY; Database name of the database in which this query was executed.
	DatabaseName *string `json:"databaseName,omitempty"`
	// QueryID - READ-ONLY; Unique query id (unique within one database).
	QueryID *string `json:"queryId,omitempty"`
	// StartTime - READ-ONLY; The start time for the metric (ISO-8601 format).
	StartTime *string `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The end time for the metric (ISO-8601 format).
	EndTime *string `json:"endTime,omitempty"`
	// Intervals - List of intervals with appropriate metric data
	Intervals *[]QueryMetricInterval `json:"intervals,omitempty"`
}

// MarshalJSON is the custom marshaler for QueryStatisticsProperties.
func (qsp QueryStatisticsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if qsp.Intervals != nil {
		objectMap["intervals"] = qsp.Intervals
	}
	return json.Marshal(objectMap)
}

// ReadScaleCapability the read scale capability.
type ReadScaleCapability struct {
	// MaxNumberOfReplicas - READ-ONLY; The maximum number of read scale replicas.
	MaxNumberOfReplicas *int32 `json:"maxNumberOfReplicas,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// Reason - The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for ReadScaleCapability.
func (rsc ReadScaleCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rsc.Reason != nil {
		objectMap["reason"] = rsc.Reason
	}
	return json.Marshal(objectMap)
}

// RecommendedAction database, Server or Elastic Pool Recommended Action.
type RecommendedAction struct {
	autorest.Response `json:"-"`
	// Kind - READ-ONLY; Resource kind.
	Kind *string `json:"kind,omitempty"`
	// Location - READ-ONLY; Resource location.
	Location *string `json:"location,omitempty"`
	// RecommendedActionProperties - Resource properties.
	*RecommendedActionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RecommendedAction.
func (ra RecommendedAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ra.RecommendedActionProperties != nil {
		objectMap["properties"] = ra.RecommendedActionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RecommendedAction struct.
func (ra *RecommendedAction) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ra.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ra.Location = &location
			}
		case "properties":
			if v != nil {
				var recommendedActionProperties RecommendedActionProperties
				err = json.Unmarshal(*v, &recommendedActionProperties)
				if err != nil {
					return err
				}
				ra.RecommendedActionProperties = &recommendedActionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ra.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ra.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ra.Type = &typeVar
			}
		}
	}

	return nil
}

// RecommendedActionErrorInfo contains error information for an Azure SQL Database, Server or Elastic Pool
// Recommended Action.
type RecommendedActionErrorInfo struct {
	// ErrorCode - READ-ONLY; Gets the reason why the recommended action was put to error state. e.g., DatabaseHasQdsOff, IndexAlreadyExists
	ErrorCode *string `json:"errorCode,omitempty"`
	// IsRetryable - READ-ONLY; Gets whether the error could be ignored and recommended action could be retried. Possible values are: Yes/No. Possible values include: 'IsRetryableYes', 'IsRetryableNo'
	IsRetryable IsRetryable `json:"isRetryable,omitempty"`
}

// MarshalJSON is the custom marshaler for RecommendedActionErrorInfo.
func (raei RecommendedActionErrorInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RecommendedActionImpactRecord contains information of estimated or observed impact on various metrics
// for an Azure SQL Database, Server or Elastic Pool Recommended Action.
type RecommendedActionImpactRecord struct {
	// DimensionName - READ-ONLY; Gets the name of the impact dimension. e.g., CPUChange, DiskSpaceChange, NumberOfQueriesAffected.
	DimensionName *string `json:"dimensionName,omitempty"`
	// Unit - READ-ONLY; Gets the name of the impact dimension. e.g., CPUChange, DiskSpaceChange, NumberOfQueriesAffected.
	Unit *string `json:"unit,omitempty"`
	// AbsoluteValue - READ-ONLY; Gets the absolute value of this dimension if applicable. e.g., Number of Queries affected
	AbsoluteValue *float64 `json:"absoluteValue,omitempty"`
	// ChangeValueAbsolute - READ-ONLY; Gets the absolute change in the value of this dimension. e.g., Absolute Disk space change in Megabytes
	ChangeValueAbsolute *float64 `json:"changeValueAbsolute,omitempty"`
	// ChangeValueRelative - READ-ONLY; Gets the relative change in the value of this dimension. e.g., Relative Disk space change in Percentage
	ChangeValueRelative *float64 `json:"changeValueRelative,omitempty"`
}

// MarshalJSON is the custom marshaler for RecommendedActionImpactRecord.
func (rair RecommendedActionImpactRecord) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RecommendedActionImplementationInfo contains information for manual implementation for an Azure SQL
// Database, Server or Elastic Pool Recommended Action.
type RecommendedActionImplementationInfo struct {
	// Method - READ-ONLY; Gets the method in which this recommended action can be manually implemented. e.g., TSql, AzurePowerShell. Possible values include: 'ImplementationMethodTSQL', 'ImplementationMethodAzurePowerShell'
	Method ImplementationMethod `json:"method,omitempty"`
	// Script - READ-ONLY; Gets the manual implementation script. e.g., T-SQL script that could be executed on the database.
	Script *string `json:"script,omitempty"`
}

// MarshalJSON is the custom marshaler for RecommendedActionImplementationInfo.
func (raii RecommendedActionImplementationInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RecommendedActionMetricInfo contains time series of various impacted metrics for an Azure SQL Database,
// Server or Elastic Pool Recommended Action.
type RecommendedActionMetricInfo struct {
	// MetricName - READ-ONLY; Gets the name of the metric. e.g., CPU, Number of Queries.
	MetricName *string `json:"metricName,omitempty"`
	// Unit - READ-ONLY; Gets the unit in which metric is measured. e.g., DTU, Frequency
	Unit *string `json:"unit,omitempty"`
	// TimeGrain - READ-ONLY; Gets the duration of time interval for the value given by this MetricInfo. e.g., PT1H (1 hour)
	TimeGrain *string `json:"timeGrain,omitempty"`
	// StartTime - READ-ONLY; Gets the start time of time interval given by this MetricInfo.
	StartTime *date.Time `json:"startTime,omitempty"`
	// Value - READ-ONLY; Gets the value of the metric in the time interval given by this MetricInfo.
	Value *float64 `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for RecommendedActionMetricInfo.
func (rami RecommendedActionMetricInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RecommendedActionProperties properties for a Database, Server or Elastic Pool Recommended Action.
type RecommendedActionProperties struct {
	// RecommendationReason - READ-ONLY; Gets the reason for recommending this action. e.g., DuplicateIndex
	RecommendationReason *string `json:"recommendationReason,omitempty"`
	// ValidSince - READ-ONLY; Gets the time since when this recommended action is valid.
	ValidSince *date.Time `json:"validSince,omitempty"`
	// LastRefresh - READ-ONLY; Gets time when this recommended action was last refreshed.
	LastRefresh *date.Time `json:"lastRefresh,omitempty"`
	// State - Gets the info of the current state the recommended action is in.
	State *RecommendedActionStateInfo `json:"state,omitempty"`
	// IsExecutableAction - READ-ONLY; Gets if this recommended action is actionable by user
	IsExecutableAction *bool `json:"isExecutableAction,omitempty"`
	// IsRevertableAction - READ-ONLY; Gets if changes applied by this recommended action can be reverted by user
	IsRevertableAction *bool `json:"isRevertableAction,omitempty"`
	// IsArchivedAction - READ-ONLY; Gets if this recommended action was suggested some time ago but user chose to ignore this and system added a new recommended action again.
	IsArchivedAction *bool `json:"isArchivedAction,omitempty"`
	// ExecuteActionStartTime - READ-ONLY; Gets the time when system started applying this recommended action on the user resource. e.g., index creation start time
	ExecuteActionStartTime *date.Time `json:"executeActionStartTime,omitempty"`
	// ExecuteActionDuration - READ-ONLY; Gets the time taken for applying this recommended action on user resource. e.g., time taken for index creation
	ExecuteActionDuration *string `json:"executeActionDuration,omitempty"`
	// RevertActionStartTime - READ-ONLY; Gets the time when system started reverting changes of this recommended action on user resource. e.g., time when index drop is executed.
	RevertActionStartTime *date.Time `json:"revertActionStartTime,omitempty"`
	// RevertActionDuration - READ-ONLY; Gets the time taken for reverting changes of this recommended action on user resource. e.g., time taken for dropping the created index.
	RevertActionDuration *string `json:"revertActionDuration,omitempty"`
	// ExecuteActionInitiatedBy - READ-ONLY; Gets if approval for applying this recommended action was given by user/system. Possible values include: 'RecommendedActionInitiatedByUser', 'RecommendedActionInitiatedBySystem'
	ExecuteActionInitiatedBy RecommendedActionInitiatedBy `json:"executeActionInitiatedBy,omitempty"`
	// ExecuteActionInitiatedTime - READ-ONLY; Gets the time when this recommended action was approved for execution.
	ExecuteActionInitiatedTime *date.Time `json:"executeActionInitiatedTime,omitempty"`
	// RevertActionInitiatedBy - READ-ONLY; Gets if approval for reverting this recommended action was given by user/system. Possible values include: 'RecommendedActionInitiatedByUser', 'RecommendedActionInitiatedBySystem'
	RevertActionInitiatedBy RecommendedActionInitiatedBy `json:"revertActionInitiatedBy,omitempty"`
	// RevertActionInitiatedTime - READ-ONLY; Gets the time when this recommended action was approved for revert.
	RevertActionInitiatedTime *date.Time `json:"revertActionInitiatedTime,omitempty"`
	// Score - READ-ONLY; Gets the impact of this recommended action. Possible values are 1 - Low impact, 2 - Medium Impact and 3 - High Impact
	Score *int32 `json:"score,omitempty"`
	// ImplementationDetails - READ-ONLY; Gets the implementation details of this recommended action for user to apply it manually.
	ImplementationDetails *RecommendedActionImplementationInfo `json:"implementationDetails,omitempty"`
	// ErrorDetails - READ-ONLY; Gets the error details if and why this recommended action is put to error state.
	ErrorDetails *RecommendedActionErrorInfo `json:"errorDetails,omitempty"`
	// EstimatedImpact - READ-ONLY; Gets the estimated impact info for this recommended action e.g., Estimated CPU gain, Estimated Disk Space change
	EstimatedImpact *[]RecommendedActionImpactRecord `json:"estimatedImpact,omitempty"`
	// ObservedImpact - READ-ONLY; Gets the observed/actual impact info for this recommended action e.g., Actual CPU gain, Actual Disk Space change
	ObservedImpact *[]RecommendedActionImpactRecord `json:"observedImpact,omitempty"`
	// TimeSeries - READ-ONLY; Gets the time series info of metrics for this recommended action e.g., CPU consumption time series
	TimeSeries *[]RecommendedActionMetricInfo `json:"timeSeries,omitempty"`
	// LinkedObjects - READ-ONLY; Gets the linked objects, if any.
	LinkedObjects *[]string `json:"linkedObjects,omitempty"`
	// Details - READ-ONLY; Gets additional details specific to this recommended action.
	Details map[string]interface{} `json:"details"`
}

// MarshalJSON is the custom marshaler for RecommendedActionProperties.
func (rap RecommendedActionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rap.State != nil {
		objectMap["state"] = rap.State
	}
	return json.Marshal(objectMap)
}

// RecommendedActionStateInfo contains information of current state for an Azure SQL Database, Server or
// Elastic Pool Recommended Action.
type RecommendedActionStateInfo struct {
	// CurrentValue - Current state the recommended action is in. Some commonly used states are: Active      -> recommended action is active and no action has been taken yet. Pending     -> recommended action is approved for and is awaiting execution. Executing   -> recommended action is being applied on the user database. Verifying   -> recommended action was applied and is being verified of its usefulness by the system. Success     -> recommended action was applied and improvement found during verification. Pending Revert  -> verification found little or no improvement so recommended action is queued for revert or user has manually reverted. Reverting   -> changes made while applying recommended action are being reverted on the user database. Reverted    -> successfully reverted the changes made by recommended action on user database. Ignored     -> user explicitly ignored/discarded the recommended action. Possible values include: 'RecommendedActionCurrentStateActive', 'RecommendedActionCurrentStatePending', 'RecommendedActionCurrentStateExecuting', 'RecommendedActionCurrentStateVerifying', 'RecommendedActionCurrentStatePendingRevert', 'RecommendedActionCurrentStateRevertCancelled', 'RecommendedActionCurrentStateReverting', 'RecommendedActionCurrentStateReverted', 'RecommendedActionCurrentStateIgnored', 'RecommendedActionCurrentStateExpired', 'RecommendedActionCurrentStateMonitoring', 'RecommendedActionCurrentStateResolved', 'RecommendedActionCurrentStateSuccess', 'RecommendedActionCurrentStateError'
	CurrentValue RecommendedActionCurrentState `json:"currentValue,omitempty"`
	// ActionInitiatedBy - READ-ONLY; Gets who initiated the execution of this recommended action. Possible Value are: User    -> When user explicity notified system to apply the recommended action. System  -> When auto-execute status of this advisor was set to 'Enabled', in which case the system applied it. Possible values include: 'RecommendedActionInitiatedByUser', 'RecommendedActionInitiatedBySystem'
	ActionInitiatedBy RecommendedActionInitiatedBy `json:"actionInitiatedBy,omitempty"`
	// LastModified - READ-ONLY; Gets the time when the state was last modified
	LastModified *date.Time `json:"lastModified,omitempty"`
}

// MarshalJSON is the custom marshaler for RecommendedActionStateInfo.
func (rasi Rec