package mysqlflexibleservers

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ConfigurationSource enumerates the values for configuration source.
type ConfigurationSource string

const (
	// ConfigurationSourceSystemDefault ...
	ConfigurationSourceSystemDefault ConfigurationSource = "system-default"
	// ConfigurationSourceUserOverride ...
	ConfigurationSourceUserOverride ConfigurationSource = "user-override"
)

// PossibleConfigurationSourceValues returns an array of possible values for the ConfigurationSource const type.
func PossibleConfigurationSourceValues() []ConfigurationSource {
	return []ConfigurationSource{ConfigurationSourceSystemDefault, ConfigurationSourceUserOverride}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// CreatedByTypeApplication ...
	CreatedByTypeApplication CreatedByType = "Application"
	// CreatedByTypeKey ...
	CreatedByTypeKey CreatedByType = "Key"
	// CreatedByTypeManagedIdentity ...
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	// CreatedByTypeUser ...
	CreatedByTypeUser CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{CreatedByTypeApplication, CreatedByTypeKey, CreatedByTypeManagedIdentity, CreatedByTypeUser}
}

// CreateMode enumerates the values for create mode.
type CreateMode string

const (
	// CreateModeDefault ...
	CreateModeDefault CreateMode = "Default"
	// CreateModeGeoRestore ...
	CreateModeGeoRestore CreateMode = "GeoRestore"
	// CreateModePointInTimeRestore ...
	CreateModePointInTimeRestore CreateMode = "PointInTimeRestore"
	// CreateModeReplica ...
	CreateModeReplica CreateMode = "Replica"
)

// PossibleCreateModeValues returns an array of possible values for the CreateMode const type.
func PossibleCreateModeValues() []CreateMode {
	return []CreateMode{CreateModeDefault, CreateModeGeoRestore, CreateModePointInTimeRestore, CreateModeReplica}
}

// EnableStatusEnum enumerates the values for enable status enum.
type EnableStatusEnum string

const (
	// EnableStatusEnumDisabled ...
	EnableStatusEnumDisabled EnableStatusEnum = "Disabled"
	// EnableStatusEnumEnabled ...
	EnableStatusEnumEnabled EnableStatusEnum = "Enabled"
)

// PossibleEnableStatusEnumValues returns an array of possible values for the EnableStatusEnum const type.
func PossibleEnableStatusEnumValues() []EnableStatusEnum {
	return []EnableStatusEnum{EnableStatusEnumDisabled, EnableStatusEnumEnabled}
}

// HighAvailabilityMode enumerates the values for high availability mode.
type HighAvailabilityMode string

const (
	// HighAvailabilityModeDisabled ...
	HighAvailabilityModeDisabled HighAvailabilityMode = "Disabled"
	// HighAvailabilityModeEnabled ...
	HighAvailabilityModeEnabled HighAvailabilityMode = "Enabled"
	// HighAvailabilityModeSameZone ...
	HighAvailabilityModeSameZone HighAvailabilityMode = "SameZone"
	// HighAvailabilityModeZoneRedundant ...
	HighAvailabilityModeZoneRedundant HighAvailabilityMode = "ZoneRedundant"
)

// PossibleHighAvailabilityModeValues returns an array of possible values for the HighAvailabilityMode const type.
func PossibleHighAvailabilityModeValues() []HighAvailabilityMode {
	return []HighAvailabilityMode{HighAvailabilityModeDisabled, HighAvailabilityModeEnabled, HighAvailabilityModeSameZone, HighAvailabilityModeZoneRedundant}
}

// HighAvailabilityState enumerates the values for high availability state.
type HighAvailabilityState string

const (
	// HighAvailabilityStateCreatingStandby ...
	HighAvailabilityStateCreatingStandby HighAvailabilityState = "CreatingStandby"
	// HighAvailabilityStateFailingOver ...
	HighAvailabilityStateFailingOver HighAvailabilityState = "FailingOver"
	// HighAvailabilityStateHealthy ...
	HighAvailabilityStateHealthy HighAvailabilityState = "Healthy"
	// HighAvailabilityStateNotEnabled ...
	HighAvailabilityStateNotEnabled HighAvailabilityState = "NotEnabled"
	// HighAvailabilityStateRemovingStandby ...
	HighAvailabilityStateRemovingStandby HighAvailabilityState = "RemovingStandby"
)

// PossibleHighAvailabilityStateValues returns an array of possible values for the HighAvailabilityState const type.
func PossibleHighAvailabilityStateValues() []HighAvailabilityState {
	return []HighAvailabilityState{HighAvailabilityStateCreatingStandby, HighAvailabilityStateFailingOver, HighAvailabilityStateHealthy, HighAvailabilityStateNotEnabled, HighAvailabilityStateRemovingStandby}
}

// IsConfigPendingRestart enumerates the values for is config pending restart.
type IsConfigPendingRestart string

const (
	// IsConfigPendingRestartFalse ...
	IsConfigPendingRestartFalse IsConfigPendingRestart = "False"
	// IsConfigPendingRestartTrue ...
	IsConfigPendingRestartTrue IsConfigPendingRestart = "True"
)

// PossibleIsConfigPendingRestartValues returns an array of possible values for the IsConfigPendingRestart const type.
func PossibleIsConfigPendingRestartValues() []IsConfigPendingRestart {
	return []IsConfigPendingRestart{IsConfigPendingRestartFalse, IsConfigPendingRestartTrue}
}

// IsDynamicConfig enumerates the values for is dynamic config.
type IsDynamicConfig string

const (
	// IsDynamicConfigFalse ...
	IsDynamicConfigFalse IsDynamicConfig = "False"
	// IsDynamicConfigTrue ...
	IsDynamicConfigTrue IsDynamicConfig = "True"
)

// PossibleIsDynamicConfigValues returns an array of possible values for the IsDynamicConfig const type.
func PossibleIsDynamicConfigValues() []IsDynamicConfig {
	return []IsDynamicConfig{IsDynamicConfigFalse, IsDynamicConfigTrue}
}

// IsReadOnly enumerates the values for is read only.
type IsReadOnly string

const (
	// IsReadOnlyFalse ...
	IsReadOnlyFalse IsReadOnly = "False"
	// IsReadOnlyTrue ...
	IsReadOnlyTrue IsReadOnly = "True"
)

// PossibleIsReadOnlyValues returns an array of possible values for the IsReadOnly const type.
func PossibleIsReadOnlyValues() []IsReadOnly {
	return []IsReadOnly{IsReadOnlyFalse, IsReadOnlyTrue}
}

// ReplicationRole enumerates the values for replication role.
type ReplicationRole string

const (
	// ReplicationRoleNone ...
	ReplicationRoleNone ReplicationRole = "None"
	// ReplicationRoleReplica ...
	ReplicationRoleReplica ReplicationRole = "Replica"
	// ReplicationRoleSource ...
	ReplicationRoleSource ReplicationRole = "Source"
)

// PossibleReplicationRoleValues returns an array of possible values for the ReplicationRole const type.
func PossibleReplicationRoleValues() []ReplicationRole {
	return []ReplicationRole{ReplicationRoleNone, ReplicationRoleReplica, ReplicationRoleSource}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// ResourceIdentityTypeSystemAssigned ...
	ResourceIdentityTypeSystemAssigned ResourceIdentityType = "SystemAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{ResourceIdentityTypeSystemAssigned}
}

// ServerState enumerates the values for server state.
type ServerState string

const (
	// ServerStateDisabled ...
	ServerStateDisabled ServerState = "Disabled"
	// ServerStateDropping ...
	ServerStateDropping ServerState = "Dropping"
	// ServerStateReady ...
	ServerStateReady ServerState = "Ready"
	// ServerStateStarting ...
	ServerStateStarting ServerState = "Starting"
	// ServerStateStopped ...
	ServerStateStopped ServerState = "Stopped"
	// ServerStateStopping ...
	ServerStateStopping ServerState = "Stopping"
	// ServerStateUpdating ...
	ServerStateUpdating ServerState = "Updating"
)

// PossibleServerStateValues returns an array of possible values for the ServerState const type.
func PossibleServerStateValues() []ServerState {
	return []ServerState{ServerStateDisabled, ServerStateDropping, ServerStateReady, ServerStateStarting, ServerStateStopped, ServerStateStopping, ServerStateUpdating}
}

// ServerVersion enumerates the values for server version.
type ServerVersion string

const (
	// ServerVersionEightFullStopZeroFullStopTwoOne ...
	ServerVersionEightFullStopZeroFullStopTwoOne ServerVersion = "8.0.21"
	// ServerVersionFiveFullStopSeven ...
	ServerVersionFiveFullStopSeven ServerVersion = "5.7"
)

// PossibleServerVersionValues returns an array of possible values for the ServerVersion const type.
func PossibleServerVersionValues() []ServerVersion {
	return []ServerVersion{ServerVersionEightFullStopZeroFullStopTwoOne, ServerVersionFiveFullStopSeven}
}

// SkuTier enumerates the values for sku tier.
type SkuTier string

const (
	// SkuTierBurstable ...
	SkuTierBurstable SkuTier = "Burstable"
	// SkuTierGeneralPurpose ...
	SkuTierGeneralPurpose SkuTier = "GeneralPurpose"
	// SkuTierMemoryOptimized ...
	SkuTierMemoryOptimized SkuTier = "MemoryOptimized"
)

// PossibleSkuTierValues returns an array of possible values for the SkuTier const type.
func PossibleSkuTierValues() []SkuTier {
	return []SkuTier{SkuTierBurstable, SkuTierGeneralPurpose, SkuTierMemoryOptimized}
}
