package textanalyticsapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/cognitiveservices/v2.1/textanalytics"
)

// BaseClientAPI contains the set of methods on the BaseClient type.
type BaseClientAPI interface {
	DetectLanguage(ctx context.Context, showStats *bool, languageBatchInput *textanalytics.LanguageBatchInput) (result textanalytics.LanguageBatchResult, err error)
	Entities(ctx context.Context, showStats *bool, multiLanguageBatchInput *textanalytics.MultiLanguageBatchInput) (result textanalytics.EntitiesBatchResult, err error)
	KeyPhrases(ctx context.Context, showStats *bool, multiLanguageBatchInput *textanalytics.MultiLanguageBatchInput) (result textanalytics.KeyPhraseBatchResult, err error)
	Sentiment(ctx context.Context, showStats *bool, multiLanguageBatchInput *textanalytics.MultiLanguageBatchInput) (result textanalytics.SentimentBatchResult, err error)
}

var _ BaseClientAPI = (*textanalytics.BaseClient)(nil)
