// Copyright 2022 the V8 project authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is automatically generated by `tools/dev/gen-static-roots.py`. Do
// not edit manually.

#ifndef V8_ROOTS_STATIC_ROOTS_H_
#define V8_ROOTS_STATIC_ROOTS_H_

#include "src/common/globals.h"

#if V8_STATIC_ROOTS_BOOL

#include "src/roots/roots.h"

// Disabling Wasm or Intl invalidates the contents of static-roots.h.
// TODO(olivf): To support static roots for multiple build configurations we
//              will need to generate target specific versions of this file.
static_assert(V8_ENABLE_WEBASSEMBLY);
static_assert(V8_INTL_SUPPORT);

namespace v8 {
namespace internal {

struct StaticReadOnlyRoot {
  static constexpr Tagged_t kUndefinedValue = 0x61;
  static constexpr Tagged_t kNullValue = 0x7d;
  static constexpr Tagged_t kempty_string = 0x99;
  static constexpr Tagged_t kFalseValue = 0xa5;
  static constexpr Tagged_t kTrueValue = 0xc1;
  static constexpr Tagged_t kSeqTwoByteStringMap = 0xdd;
  static constexpr Tagged_t kSeqOneByteStringMap = 0x105;
  static constexpr Tagged_t kConsTwoByteStringMap = 0x12d;
  static constexpr Tagged_t kConsOneByteStringMap = 0x155;
  static constexpr Tagged_t kSlicedTwoByteStringMap = 0x17d;
  static constexpr Tagged_t kSlicedOneByteStringMap = 0x1a5;
  static constexpr Tagged_t kExternalTwoByteStringMap = 0x1cd;
  static constexpr Tagged_t kExternalOneByteStringMap = 0x1f5;
  static constexpr Tagged_t kUncachedExternalTwoByteStringMap = 0x21d;
  static constexpr Tagged_t kUncachedExternalOneByteStringMap = 0x245;
  static constexpr Tagged_t kSharedExternalTwoByteStringMap = 0x26d;
  static constexpr Tagged_t kSharedExternalOneByteStringMap = 0x295;
  static constexpr Tagged_t kSharedUncachedExternalTwoByteStringMap = 0x2bd;
  static constexpr Tagged_t kSharedUncachedExternalOneByteStringMap = 0x2e5;
  static constexpr Tagged_t kExternalInternalizedTwoByteStringMap = 0x30d;
  static constexpr Tagged_t kExternalInternalizedOneByteStringMap = 0x335;
  static constexpr Tagged_t kUncachedExternalInternalizedTwoByteStringMap =
      0x35d;
  static constexpr Tagged_t kUncachedExternalInternalizedOneByteStringMap =
      0x385;
  static constexpr Tagged_t kInternalizedTwoByteStringMap = 0x3ad;
  static constexpr Tagged_t kInternalizedOneByteStringMap = 0x3d5;
  static constexpr Tagged_t kThinTwoByteStringMap = 0x3fd;
  static constexpr Tagged_t kThinOneByteStringMap = 0x425;
  static constexpr Tagged_t kSharedSeqTwoByteStringMap = 0x44d;
  static constexpr Tagged_t kSharedSeqOneByteStringMap = 0x475;
  static constexpr Tagged_t kSymbolMap = 0x49d;
  static constexpr Tagged_t kMetaMap = 0x4c5;
  static constexpr Tagged_t kUndefinedMap = 0x4ed;
  static constexpr Tagged_t kNullMap = 0x515;
  static constexpr Tagged_t kBooleanMap = 0x53d;
  static constexpr Tagged_t kFixedArrayMap = 0x565;
  static constexpr Tagged_t kTrustedFixedArrayMap = 0x58d;
  static constexpr Tagged_t kWeakFixedArrayMap = 0x5b5;
  static constexpr Tagged_t kWeakArrayListMap = 0x5dd;
  static constexpr Tagged_t kFixedCOWArrayMap = 0x605;
  static constexpr Tagged_t kDescriptorArrayMap = 0x62d;
  static constexpr Tagged_t kHoleMap = 0x655;
  static constexpr Tagged_t kCallSiteInfoMap = 0x67d;
  static constexpr Tagged_t kEnumCacheMap = 0x6a5;
  static constexpr Tagged_t kEmptyFixedArray = 0x6cd;
  static constexpr Tagged_t kEmptyWeakFixedArray = 0x6d5;
  static constexpr Tagged_t kEmptyWeakArrayList = 0x6dd;
  static constexpr Tagged_t kTheHoleValue = 0x6e9;
  static constexpr Tagged_t kEmptyEnumCache = 0x6f5;
  static constexpr Tagged_t kEmptyDescriptorArray = 0x701;
  static constexpr Tagged_t kScopeInfoMap = 0x711;
  static constexpr Tagged_t kModuleInfoMap = 0x739;
  static constexpr Tagged_t kClosureFeedbackCellArrayMap = 0x761;
  static constexpr Tagged_t kFeedbackVectorMap = 0x789;
  static constexpr Tagged_t kHeapNumberMap = 0x7b1;
  static constexpr Tagged_t kBigIntMap = 0x7d9;
  static constexpr Tagged_t kForeignMap = 0x801;
  static constexpr Tagged_t kMegaDomHandlerMap = 0x829;
  static constexpr Tagged_t kFixedDoubleArrayMap = 0x851;
  static constexpr Tagged_t kFeedbackMetadataArrayMap = 0x879;
  static constexpr Tagged_t kByteArrayMap = 0x8a1;
  static constexpr Tagged_t kTrustedByteArrayMap = 0x8c9;
  static constexpr Tagged_t kBytecodeArrayMap = 0x8f1;
  static constexpr Tagged_t kFreeSpaceMap = 0x919;
  static constexpr Tagged_t kPropertyArrayMap = 0x941;
  static constexpr Tagged_t kSmallOrderedHashMapMap = 0x969;
  static constexpr Tagged_t kSmallOrderedHashSetMap = 0x991;
  static constexpr Tagged_t kSmallOrderedNameDictionaryMap = 0x9b9;
  static constexpr Tagged_t kInstructionStreamMap = 0x9e1;
  static constexpr Tagged_t kCellMap = 0xa09;
  static constexpr Tagged_t kInvalidPrototypeValidityCell = 0xa31;
  static constexpr Tagged_t kGlobalPropertyCellMap = 0xa39;
  static constexpr Tagged_t kOnePointerFillerMap = 0xa61;
  static constexpr Tagged_t kTwoPointerFillerMap = 0xa89;
  static constexpr Tagged_t kNoClosuresCellMap = 0xab1;
  static constexpr Tagged_t kOneClosureCellMap = 0xad9;
  static constexpr Tagged_t kManyClosuresCellMap = 0xb01;
  static constexpr Tagged_t kTransitionArrayMap = 0xb29;
  static constexpr Tagged_t kHashTableMap = 0xb51;
  static constexpr Tagged_t kOrderedNameDictionaryMap = 0xb79;
  static constexpr Tagged_t kNameDictionaryMap = 0xba1;
  static constexpr Tagged_t kSwissNameDictionaryMap = 0xbc9;
  static constexpr Tagged_t kGlobalDictionaryMap = 0xbf1;
  static constexpr Tagged_t kNumberDictionaryMap = 0xc19;
  static constexpr Tagged_t kRegisteredSymbolTableMap = 0xc41;
  static constexpr Tagged_t kArrayListMap = 0xc69;
  static constexpr Tagged_t kAccessorInfoMap = 0xc91;
  static constexpr Tagged_t kPreparseDataMap = 0xcb9;
  static constexpr Tagged_t kSharedFunctionInfoMap = 0xce1;
  static constexpr Tagged_t kCodeMap = 0xd09;
  static constexpr Tagged_t kHashSeed = 0xd31;
  static constexpr Tagged_t klength_string = 0xd41;
  static constexpr Tagged_t kprototype_string = 0xd55;
  static constexpr Tagged_t kname_string = 0xd6d;
  static constexpr Tagged_t kenumerable_string = 0xd7d;
  static constexpr Tagged_t kconfigurable_string = 0xd95;
  static constexpr Tagged_t kvalue_string = 0xdad;
  static constexpr Tagged_t kwritable_string = 0xdc1;
  static constexpr Tagged_t knot_mapped_symbol = 0xdd5;
  static constexpr Tagged_t kuninitialized_symbol = 0xde5;
  static constexpr Tagged_t kmegamorphic_symbol = 0xdf5;
  static constexpr Tagged_t kelements_transition_symbol = 0xe05;
  static constexpr Tagged_t kmega_dom_symbol = 0xe15;
  static constexpr Tagged_t kEmptyPropertyDictionary = 0xe25;
  static constexpr Tagged_t kEmptyOrderedPropertyDictionary = 0xe51;
  static constexpr Tagged_t kEmptyByteArray = 0xe69;
  static constexpr Tagged_t kEmptyScopeInfo = 0xe71;
  static constexpr Tagged_t kEmptyPropertyArray = 0xe81;
  static constexpr Tagged_t kMinusZeroValue = 0xe89;
  static constexpr Tagged_t kNanValue = 0xe95;
  static constexpr Tagged_t kHoleNanValue = 0xea1;
  static constexpr Tagged_t kInfinityValue = 0xead;
  static constexpr Tagged_t kMinusInfinityValue = 0xeb9;
  static constexpr Tagged_t kMaxSafeInteger = 0xec5;
  static constexpr Tagged_t kMaxUInt32 = 0xed1;
  static constexpr Tagged_t kSmiMinValue = 0xedd;
  static constexpr Tagged_t kSmiMaxValuePlusOne = 0xee9;
  static constexpr Tagged_t kPromiseFulfillReactionJobTaskMap = 0xef5;
  static constexpr Tagged_t kPromiseRejectReactionJobTaskMap = 0xf1d;
  static constexpr Tagged_t kCallableTaskMap = 0xf45;
  static constexpr Tagged_t kCallbackTaskMap = 0xf6d;
  static constexpr Tagged_t kPromiseResolveThenableJobTaskMap = 0xf95;
  static constexpr Tagged_t kFunctionTemplateInfoMap = 0xfbd;
  static constexpr Tagged_t kObjectTemplateInfoMap = 0xfe5;
  static constexpr Tagged_t kAccessCheckInfoMap = 0x100d;
  static constexpr Tagged_t kAccessorPairMap = 0x1035;
  static constexpr Tagged_t kAliasedArgumentsEntryMap = 0x105d;
  static constexpr Tagged_t kAllocationMementoMap = 0x1085;
  static constexpr Tagged_t kArrayBoilerplateDescriptionMap = 0x10ad;
  static constexpr Tagged_t kAsmWasmDataMap = 0x10d5;
  static constexpr Tagged_t kAsyncGeneratorRequestMap = 0x10fd;
  static constexpr Tagged_t kBreakPointMap = 0x1125;
  static constexpr Tagged_t kBreakPointInfoMap = 0x114d;
  static constexpr Tagged_t kBytecodeWrapperMap = 0x1175;
  static constexpr Tagged_t kClassBoilerplateMap = 0x119d;
  static constexpr Tagged_t kClassPositionsMap = 0x11c5;
  static constexpr Tagged_t kCodeWrapperMap = 0x11ed;
  static constexpr Tagged_t kDebugInfoMap = 0x1215;
  static constexpr Tagged_t kErrorStackDataMap = 0x123d;
  static constexpr Tagged_t kFunctionTemplateRareDataMap = 0x1265;
  static constexpr Tagged_t kInterceptorInfoMap = 0x128d;
  static constexpr Tagged_t kModuleRequestMap = 0x12b5;
  static constexpr Tagged_t kPromiseCapabilityMap = 0x12dd;
  static constexpr Tagged_t kPromiseOnStackMap = 0x1305;
  static constexpr Tagged_t kPromiseReactionMap = 0x132d;
  static constexpr Tagged_t kPropertyDescriptorObjectMap = 0x1355;
  static constexpr Tagged_t kPrototypeInfoMap = 0x137d;
  static constexpr Tagged_t kRegExpBoilerplateDescriptionMap = 0x13a5;
  static constexpr Tagged_t kScriptMap = 0x13cd;
  static constexpr Tagged_t kScriptOrModuleMap = 0x13f5;
  static constexpr Tagged_t kSourceTextModuleInfoEntryMap = 0x141d;
  static constexpr Tagged_t kStackFrameInfoMap = 0x1445;
  static constexpr Tagged_t kTemplateObjectDescriptionMap = 0x146d;
  static constexpr Tagged_t kTuple2Map = 0x1495;
  static constexpr Tagged_t kWasmExceptionTagMap = 0x14bd;
  static constexpr Tagged_t kWasmIndirectFunctionTableMap = 0x14e5;
  static constexpr Tagged_t kAllocationSiteWithWeakNextMap = 0x150d;
  static constexpr Tagged_t kAllocationSiteWithoutWeakNextMap = 0x1535;
  static constexpr Tagged_t kLoadHandler1Map = 0x155d;
  static constexpr Tagged_t kLoadHandler2Map = 0x1585;
  static constexpr Tagged_t kLoadHandler3Map = 0x15ad;
  static constexpr Tagged_t kStoreHandler0Map = 0x15d5;
  static constexpr Tagged_t kStoreHandler1Map = 0x15fd;
  static constexpr Tagged_t kStoreHandler2Map = 0x1625;
  static constexpr Tagged_t kStoreHandler3Map = 0x164d;
  static constexpr Tagged_t kUncompiledDataWithoutPreparseDataMap = 0x1675;
  static constexpr Tagged_t kUncompiledDataWithPreparseDataMap = 0x169d;
  static constexpr Tagged_t kUncompiledDataWithoutPreparseDataWithJobMap =
      0x16c5;
  static constexpr Tagged_t kUncompiledDataWithPreparseDataAndJobMap = 0x16ed;
  static constexpr Tagged_t kOnHeapBasicBlockProfilerDataMap = 0x1715;
  static constexpr Tagged_t kTurbofanBitsetTypeMap = 0x173d;
  static constexpr Tagged_t kTurbofanUnionTypeMap = 0x1765;
  static constexpr Tagged_t kTurbofanRangeTypeMap = 0x178d;
  static constexpr Tagged_t kTurbofanHeapConstantTypeMap = 0x17b5;
  static constexpr Tagged_t kTurbofanOtherNumberConstantTypeMap = 0x17dd;
  static constexpr Tagged_t kTurboshaftWord32TypeMap = 0x1805;
  static constexpr Tagged_t kTurboshaftWord32RangeTypeMap = 0x182d;
  static constexpr Tagged_t kTurboshaftWord64TypeMap = 0x1855;
  static constexpr Tagged_t kTurboshaftWord64RangeTypeMap = 0x187d;
  static constexpr Tagged_t kTurboshaftFloat64TypeMap = 0x18a5;
  static constexpr Tagged_t kTurboshaftFloat64RangeTypeMap = 0x18cd;
  static constexpr Tagged_t kInternalClassMap = 0x18f5;
  static constexpr Tagged_t kSmiPairMap = 0x191d;
  static constexpr Tagged_t kSmiBoxMap = 0x1945;
  static constexpr Tagged_t kExportedSubClassBaseMap = 0x196d;
  static constexpr Tagged_t kExportedSubClassMap = 0x1995;
  static constexpr Tagged_t kAbstractInternalClassSubclass1Map = 0x19bd;
  static constexpr Tagged_t kAbstractInternalClassSubclass2Map = 0x19e5;
  static constexpr Tagged_t kExportedSubClass2Map = 0x1a0d;
  static constexpr Tagged_t kSortStateMap = 0x1a35;
  static constexpr Tagged_t kWasmStringViewIterMap = 0x1a5d;
  static constexpr Tagged_t kSloppyArgumentsElementsMap = 0x1a85;
  static constexpr Tagged_t kStrongDescriptorArrayMap = 0x1aad;
  static constexpr Tagged_t kTurboshaftWord32SetTypeMap = 0x1ad5;
  static constexpr Tagged_t kTurboshaftWord64SetTypeMap = 0x1afd;
  static constexpr Tagged_t kTurboshaftFloat64SetTypeMap = 0x1b25;
  static constexpr Tagged_t kInternalClassWithStructElementsMap = 0x1b4d;
  static constexpr Tagged_t kOrderedHashMapMap = 0x1b75;
  static constexpr Tagged_t kOrderedHashSetMap = 0x1b9d;
  static constexpr Tagged_t kSimpleNumberDictionaryMap = 0x1bc5;
  static constexpr Tagged_t kNameToIndexHashTableMap = 0x1bed;
  static constexpr Tagged_t kEmbedderDataArrayMap = 0x1c15;
  static constexpr Tagged_t kEphemeronHashTableMap = 0x1c3d;
  static constexpr Tagged_t kScriptContextTableMap = 0x1c65;
  static constexpr Tagged_t kObjectBoilerplateDescriptionMap = 0x1c8d;
  static constexpr Tagged_t kCoverageInfoMap = 0x1cb5;
  static constexpr Tagged_t kRegExpMatchInfoMap = 0x1cdd;
  static constexpr Tagged_t kSideEffectCallHandlerInfoMap = 0x1d05;
  static constexpr Tagged_t kSideEffectFreeCallHandlerInfoMap = 0x1d2d;
  static constexpr Tagged_t kSourceTextModuleMap = 0x1d55;
  static constexpr Tagged_t kSyntheticModuleMap = 0x1d7d;
  static constexpr Tagged_t kWasmApiFunctionRefMap = 0x1da5;
  static constexpr Tagged_t kWasmCapiFunctionDataMap = 0x1dcd;
  static constexpr Tagged_t kWasmExportedFunctionDataMap = 0x1df5;
  static constexpr Tagged_t kWasmInternalFunctionMap = 0x1e1d;
  static constexpr Tagged_t kWasmJSFunctionDataMap = 0x1e45;
  static constexpr Tagged_t kWasmResumeDataMap = 0x1e6d;
  static constexpr Tagged_t kWasmTypeInfoMap = 0x1e95;
  static constexpr Tagged_t kWasmContinuationObjectMap = 0x1ebd;
  static constexpr Tagged_t kWasmNullMap = 0x1ee5;
  static constexpr Tagged_t kWasmTrustedInstanceDataMap = 0x1f0d;
  static constexpr Tagged_t kWeakCellMap = 0x1f35;
  static constexpr Tagged_t kExternalPointerArrayMap = 0x1f5d;
  static constexpr Tagged_t kInterpreterDataMap = 0x1f85;
  static constexpr Tagged_t kNoOpInterceptorInfo = 0x1fad;
  static constexpr Tagged_t kEmptyArrayList = 0x1fd5;
  static constexpr Tagged_t kEmptyObjectBoilerplateDescription = 0x1fe1;
  static constexpr Tagged_t kEmptyArrayBoilerplateDescription = 0x1ff1;
  static constexpr Tagged_t kEmptyClosureFeedbackCellArray = 0x1ffd;
  static constexpr Tagged_t kEmptySwissPropertyDictionary = 0x2011;
  static constexpr Tagged_t kSingleCharacterStringTable = 0x2031;
  static constexpr Tagged_t kdot_string = 0x2719;
  static constexpr Tagged_t kzero_string = 0x2739;
  static constexpr Tagged_t kone_string = 0x2749;
  static constexpr Tagged_t kadoptText_string = 0x3439;
  static constexpr Tagged_t kapproximatelySign_string = 0x3451;
  static constexpr Tagged_t kbaseName_string = 0x3471;
  static constexpr Tagged_t kaccounting_string = 0x3485;
  static constexpr Tagged_t kbreakType_string = 0x349d;
  static constexpr Tagged_t kcalendars_string = 0x34b5;
  static constexpr Tagged_t kcardinal_string = 0x34cd;
  static constexpr Tagged_t kcaseFirst_string = 0x34e1;
  static constexpr Tagged_t kceil_string = 0x34f9;
  static constexpr Tagged_t kcompare_string = 0x3509;
  static constexpr Tagged_t kcollation_string = 0x351d;
  static constexpr Tagged_t kcollations_string = 0x3535;
  static constexpr Tagged_t kcompact_string = 0x354d;
  static constexpr Tagged_t kcompactDisplay_string = 0x3561;
  static constexpr Tagged_t kcurrency_string = 0x357d;
  static constexpr Tagged_t kcurrencyDisplay_string = 0x3591;
  static constexpr Tagged_t kcurrencySign_string = 0x35ad;
  static constexpr Tagged_t kdateStyle_string = 0x35c5;
  static constexpr Tagged_t kdateTimeField_string = 0x35dd;
  static constexpr Tagged_t kdayPeriod_string = 0x35f9;
  static constexpr Tagged_t kdaysDisplay_string = 0x3611;
  static constexpr Tagged_t kdecimal_string = 0x3629;
  static constexpr Tagged_t kdialect_string = 0x363d;
  static constexpr Tagged_t kdigital_string = 0x3651;
  static constexpr Tagged_t kdirection_string = 0x3665;
  static constexpr Tagged_t kendRange_string = 0x367d;
  static constexpr Tagged_t kengineering_string = 0x3691;
  static constexpr Tagged_t kexceptZero_string = 0x36a9;
  static constexpr Tagged_t kexpand_string = 0x36c1;
  static constexpr Tagged_t kexponentInteger_string = 0x36d5;
  static constexpr Tagged_t kexponentMinusSign_string = 0x36f1;
  static constexpr Tagged_t kexponentSeparator_string = 0x3711;
  static constexpr Tagged_t kfallback_string = 0x3731;
  static constexpr Tagged_t kfirst_string = 0x3745;
  static constexpr Tagged_t kfirstDay_string = 0x3759;
  static constexpr Tagged_t kfloor_string = 0x376d;
  static constexpr Tagged_t kformat_string = 0x3781;
  static constexpr Tagged_t kfraction_string = 0x3795;
  static constexpr Tagged_t kfractionalDigits_string = 0x37a9;
  static constexpr Tagged_t kfractionalSecond_string = 0x37c5;
  static constexpr Tagged_t kfull_string = 0x37e1;
  static constexpr Tagged_t kgranularity_string = 0x37f1;
  static constexpr Tagged_t kgrapheme_string = 0x3809;
  static constexpr Tagged_t kgroup_string = 0x381d;
  static constexpr Tagged_t kh11_string = 0x3831;
  static constexpr Tagged_t kh12_string = 0x3841;
  static constexpr Tagged_t kh23_string = 0x3851;
  static constexpr Tagged_t kh24_string = 0x3861;
  static constexpr Tagged_t khalfCeil_string = 0x3871;
  static constexpr Tagged_t khalfEven_string = 0x3885;
  static constexpr Tagged_t khalfExpand_string = 0x3899;
  static constexpr Tagged_t khalfFloor_string = 0x38b1;
  static constexpr Tagged_t khalfTrunc_string = 0x38c9;
  static constexpr Tagged_t khour12_string = 0x38e1;
  static constexpr Tagged_t khourCycle_string = 0x38f5;
  static constexpr Tagged_t khourCycles_string = 0x390d;
  static constexpr Tagged_t khoursDisplay_string = 0x3925;
  static constexpr Tagged_t kideo_string = 0x393d;
  static constexpr Tagged_t kignorePunctuation_string = 0x394d;
  static constexpr Tagged_t kInvalid_Date_string = 0x396d;
  static constexpr Tagged_t kinteger_string = 0x3985;
  static constexpr Tagged_t kisWordLike_string = 0x3999;
  static constexpr Tagged_t kkana_string = 0x39b1;
  static constexpr Tagged_t klanguage_string = 0x39c1;
  static constexpr Tagged_t klanguageDisplay_string = 0x39d5;
  static constexpr Tagged_t klessPrecision_string = 0x39f1;
  static constexpr Tagged_t kletter_string = 0x3a0d;
  static constexpr Tagged_t klist_string = 0x3a21;
  static constexpr Tagged_t kliteral_string = 0x3a31;
  static constexpr Tagged_t klocale_string = 0x3a45;
  static constexpr Tagged_t kloose_string = 0x3a59;
  static constexpr Tagged_t klower_string = 0x3a6d;
  static constexpr Tagged_t kltr_string = 0x3a81;
  static constexpr Tagged_t kmaximumFractionDigits_string = 0x3a91;
  static constexpr Tagged_t kmaximumSignificantDigits_string = 0x3ab5;
  static constexpr Tagged_t kmicrosecondsDisplay_string = 0x3ad9;
  static constexpr Tagged_t kmillisecondsDisplay_string = 0x3af9;
  static constexpr Tagged_t kmin2_string = 0x3b19;
  static constexpr Tagged_t kminimalDays_string = 0x3b29;
  static constexpr Tagged_t kminimumFractionDigits_string = 0x3b41;
  static constexpr Tagged_t kminimumIntegerDigits_string = 0x3b65;
  static constexpr Tagged_t kminimumSignificantDigits_string = 0x3b85;
  static constexpr Tagged_t kminus_0 = 0x3ba9;
  static constexpr Tagged_t kminusSign_string = 0x3bb9;
  static constexpr Tagged_t kminutesDisplay_string = 0x3bd1;
  static constexpr Tagged_t kmonthsDisplay_string = 0x3bed;
  static constexpr Tagged_t kmorePrecision_string = 0x3c09;
  static constexpr Tagged_t knan_string = 0x3c25;
  static constexpr Tagged_t knanosecondsDisplay_string = 0x3c35;
  static constexpr Tagged_t knarrowSymbol_string = 0x3c55;
  static constexpr Tagged_t knegative_string = 0x3c6d;
  static constexpr Tagged_t knever_string = 0x3c81;
  static constexpr Tagged_t knone_string = 0x3c95;
  static constexpr Tagged_t knotation_string = 0x3ca5;
  static constexpr Tagged_t knormal_string = 0x3cb9;
  static constexpr Tagged_t knumberingSystem_string = 0x3ccd;
  static constexpr Tagged_t knumberingSystems_string = 0x3ce9;
  static constexpr Tagged_t knumeric_string = 0x3d05;
  static constexpr Tagged_t kordinal_string = 0x3d19;
  static constexpr Tagged_t kpercentSign_string = 0x3d2d;
  static constexpr Tagged_t kplusSign_string = 0x3d45;
  static constexpr Tagged_t kquarter_string = 0x3d59;
  static constexpr Tagged_t kregion_string = 0x3d6d;
  static constexpr Tagged_t krelatedYear_string = 0x3d81;
  static constexpr Tagged_t kroundingMode_string = 0x3d99;
  static constexpr Tagged_t kroundingPriority_string = 0x3db1;
  static constexpr Tagged_t krtl_string = 0x3dcd;
  static constexpr Tagged_t kscientific_string = 0x3ddd;
  static constexpr Tagged_t ksecondsDisplay_string = 0x3df5;
  static constexpr Tagged_t ksegment_string = 0x3e11;
  static constexpr Tagged_t kSegmentIterator_string = 0x3e25;
  static constexpr Tagged_t kSegments_string = 0x3e41;
  static constexpr Tagged_t ksensitivity_string = 0x3e55;
  static constexpr Tagged_t ksep_string = 0x3e6d;
  static constexpr Tagged_t kshared_string = 0x3e7d;
  static constexpr Tagged_t ksignDisplay_string = 0x3e91;
  static constexpr Tagged_t kstandard_string = 0x3ea9;
  static constexpr Tagged_t kstartRange_string = 0x3ebd;
  static constexpr Tagged_t kstrict_string = 0x3ed5;
  static constexpr Tagged_t kstripIfInteger_string = 0x3ee9;
  static constexpr Tagged_t kstyle_string = 0x3f05;
  static constexpr Tagged_t kterm_string = 0x3f19;
  static constexpr Tagged_t ktextInfo_string = 0x3f29;
  static constexpr Tagged_t ktimeStyle_string = 0x3f3d;
  static constexpr Tagged_t ktimeZones_string = 0x3f55;
  static constexpr Tagged_t ktimeZoneName_string = 0x3f6d;
  static constexpr Tagged_t ktrailingZeroDisplay_string = 0x3f85;
  static constexpr Tagged_t ktrunc_string = 0x3fa5;
  static constexpr Tagged_t ktwo_digit_string = 0x3fb9;
  static constexpr Tagged_t ktype_string = 0x3fcd;
  static constexpr Tagged_t kunknown_string = 0x3fdd;
  static constexpr Tagged_t kupper_string = 0x3ff1;
  static constexpr Tagged_t kusage_string = 0x4005;
  static constexpr Tagged_t kuseGrouping_string = 0x4019;
  static constexpr Tagged_t kunitDisplay_string = 0x4031;
  static constexpr Tagged_t kweekday_string = 0x4049;
  static constexpr Tagged_t kweekend_string = 0x405d;
  static constexpr Tagged_t kweeksDisplay_string = 0x4071;
  static constexpr Tagged_t kweekInfo_string = 0x4089;
  static constexpr Tagged_t kyearName_string = 0x409d;
  static constexpr Tagged_t kyearsDisplay_string = 0x40b1;
  static constexpr Tagged_t kadd_string = 0x40c9;
  static constexpr Tagged_t kAggregateError_string = 0x40d9;
  static constexpr Tagged_t kalways_string = 0x40f5;
  static constexpr Tagged_t kanonymous_function_string = 0x4109;
  static constexpr Tagged_t kanonymous_string = 0x4129;
  static constexpr Tagged_t kapply_string = 0x4141;
  static constexpr Tagged_t kArguments_string = 0x4155;
  static constexpr Tagged_t karguments_string = 0x416d;
  static constexpr Tagged_t karguments_to_string = 0x4185;
  static constexpr Tagged_t kArray_string = 0x41a5;
  static constexpr Tagged_t karray_to_string = 0x41b9;
  static constexpr Tagged_t kArrayBuffer_string = 0x41d5;
  static constexpr Tagged_t kArrayIterator_string = 0x41ed;
  static constexpr Tagged_t kas_string = 0x4209;
  static constexpr Tagged_t kassert_string = 0x4219;
  static constexpr Tagged_t kasync_string = 0x422d;
  static constexpr Tagged_t kAtomicsCondition_string = 0x4241;
  static constexpr Tagged_t kAtomicsMutex_string = 0x4261;
  static constexpr Tagged_t kauto_string = 0x427d;
  static constexpr Tagged_t kawait_string = 0x428d;
  static constexpr Tagged_t kBigInt_string = 0x42a1;
  static constexpr Tagged_t kbigint_string = 0x42b5;
  static constexpr Tagged_t kBigInt64Array_string = 0x42c9;
  static constexpr Tagged_t kBigUint64Array_string = 0x42e5;
  static constexpr Tagged_t kbind_string = 0x4301;
  static constexpr Tagged_t kblank_string = 0x4311;
  static constexpr Tagged_t kBoolean_string = 0x4325;
  static constexpr Tagged_t kboolean_string = 0x4339;
  static constexpr Tagged_t kboolean_to_string = 0x434d;
  static constexpr Tagged_t kbound__string = 0x4369;
  static constexpr Tagged_t kbuffer_string = 0x437d;
  static constexpr Tagged_t kbyte_length_string = 0x4391;
  static constexpr Tagged_t kbyte_offset_string = 0x43a9;
  static constexpr Tagged_t kCompileError_string = 0x43c1;
  static constexpr Tagged_t kcalendar_string = 0x43d9;
  static constexpr Tagged_t kcallee_string = 0x43ed;
  static constexpr Tagged_t kcaller_string = 0x4401;
  static constexpr Tagged_t kcause_string = 0x4415;
  static constexpr Tagged_t kcharacter_string = 0x4429;
  static constexpr Tagged_t kcode_string = 0x4441;
  static constexpr Tagged_t kcolumn_string = 0x4451;
  static constexpr Tagged_t kcomputed_string = 0x4465;
  static constexpr Tagged_t kconjunction_string = 0x447d;
  static constexpr Tagged_t kconsole_string = 0x4495;
  static constexpr Tagged_t kconstrain_string = 0x44a9;
  static constexpr Tagged_t kconstruct_string = 0x44c1;
  static constexpr Tagged_t kcurrent_string = 0x44d9;
  static constexpr Tagged_t kDate_string = 0x44ed;
  static constexpr Tagged_t kdate_to_string = 0x44fd;
  static constexpr Tagged_t kdateAdd_string = 0x4519;
  static constexpr Tagged_t kdateFromFields_string = 0x452d;
  static constexpr Tagged_t kdateUntil_string = 0x4549;
  static constexpr Tagged_t kday_string = 0x4561;
  static constexpr Tagged_t kdayOfWeek_string = 0x4571;
  static constexpr Tagged_t kdayOfYear_string = 0x4589;
  static constexpr Tagged_t kdays_string = 0x45a1;
  static constexpr Tagged_t kdaysInMonth_string = 0x45b1;
  static constexpr Tagged_t kdaysInWeek_string = 0x45c9;
  static constexpr Tagged_t kdaysInYear_string = 0x45e1;
  static constexpr Tagged_t kdefault_string = 0x45f9;
  static constexpr Tagged_t kdefineProperty_string = 0x460d;
  static constexpr Tagged_t kdeleteProperty_string = 0x4629;
  static constexpr Tagged_t kdetached_string = 0x4645;
  static constexpr Tagged_t kdisjunction_string = 0x4659;
  static constexpr Tagged_t kdone_string = 0x4671;
  static constexpr Tagged_t kdot_brand_string = 0x4681;
  static constexpr Tagged_t kdot_catch_string = 0x4695;
  static constexpr Tagged_t kdot_default_string = 0x46a9;
  static constexpr Tagged_t kdot_for_string = 0x46bd;
  static constexpr Tagged_t kdot_generator_object_string = 0x46cd;
  static constexpr Tagged_t kdot_home_object_string = 0x46ed;
  static constexpr Tagged_t kdot_new_target_string = 0x4705;
  static constexpr Tagged_t knew_target_string = 0x4705;
  static constexpr Tagged_t kdot_result_string = 0x471d;
  static constexpr Tagged_t kdot_repl_result_string = 0x4731;
  static constexpr Tagged_t kdot_static_home_object_string = 0x4749;
  static constexpr Tagged_t kdot_switch_tag_string = 0x4769;
  static constexpr Tagged_t kdotAll_string = 0x4781;
  static constexpr Tagged_t kError_string = 0x4795;
  static constexpr Tagged_t kEvalError_string = 0x47a9;
  static constexpr Tagged_t kelement_string = 0x47c1;
  static constexpr Tagged_t kepochMicroseconds_string = 0x47d5;
  static constexpr Tagged_t kepochMilliseconds_string = 0x47f5;
  static constexpr Tagged_t kepochNanoseconds_string = 0x4815;
  static constexpr Tagged_t kepochSeconds_string = 0x4831;
  static constexpr Tagged_t kera_string = 0x4849;
  static constexpr Tagged_t keraYear_string = 0x4859;
  static constexpr Tagged_t kerror_string = 0x486d;
  static constexpr Tagged_t kerrors_string = 0x4881;
  static constexpr Tagged_t kerror_to_string = 0x4895;
  static constexpr Tagged_t keval_string = 0x48b1;
  static constexpr Tagged_t kexception_string = 0x48c1;
  static constexpr Tagged_t kexec_string = 0x48d9;
  static constexpr Tagged_t kfalse_string = 0x48e9;
  static constexpr Tagged_t kfields_string = 0x48fd;
  static constexpr Tagged_t kFinalizationRegistry_string = 0x4911;
  static constexpr Tagged_t kflags_string = 0x4931;
  static constexpr Tagged_t kFloat32Array_string = 0x4945;
  static constexpr Tagged_t kFloat64Array_string = 0x495d;
  static constexpr Tagged_t kfractionalSecondDigits_string = 0x4975;
  static constexpr Tagged_t kfrom_string = 0x4999;
  static constexpr Tagged_t kFunction_string = 0x49a9;
  static constexpr Tagged_t kfunction_native_code_string = 0x49bd;
  static constexpr Tagged_t kfunction_string = 0x49e9;
  static constexpr Tagged_t kfunction_to_string = 0x49fd;
  static constexpr Tagged_t kGenerator_string = 0x4a1d;
  static constexpr Tagged_t kget_space_string = 0x4a35;
  static constexpr Tagged_t kget_string = 0x4a45;
  static constexpr Tagged_t kgetOffsetNanosecondsFor_string = 0x4a55;
  static constexpr Tagged_t kgetOwnPropertyDescriptor_string = 0x4a79;
  static constexpr Tagged_t kgetPossibleInstantsFor_string = 0x4a9d;
  static constexpr Tagged_t kgetPrototypeOf_string = 0x4ac1;
  static constexpr Tagged_t kglobal_string = 0x4add;
  static constexpr Tagged_t kglobalThis_string = 0x4af1;
  static constexpr Tagged_t kgroups_string = 0x4b09;
  static constexpr Tagged_t kgrowable_string = 0x4b1d;
  static constexpr Tagged_t khas_string = 0x4b31;
  static constexpr Tagged_t khasIndices_string = 0x4b41;
  static constexpr Tagged_t khour_string = 0x4b59;
  static constexpr Tagged_t khours_string = 0x4b69;
  static constexpr Tagged_t khoursInDay_string = 0x4b7d;
  static constexpr Tagged_t kignoreCase_string = 0x4b95;
  static constexpr Tagged_t kid_string = 0x4bad;
  static constexpr Tagged_t killegal_access_string = 0x4bbd;
  static constexpr Tagged_t killegal_argument_string = 0x4bd9;
  static constexpr Tagged_t kinLeapYear_string = 0x4bf5;
  static constexpr Tagged_t kindex_string = 0x4c0d;
  static constexpr Tagged_t kindices_string = 0x4c21;
  static constexpr Tagged_t kInfinity_string = 0x4c35;
  static constexpr Tagged_t kinfinity_string = 0x4c49;
  static constexpr Tagged_t kinput_string = 0x4c5d;
  static constexpr Tagged_t kinstance_members_initializer_string = 0x4c71;
  static constexpr Tagged_t kInt16Array_string = 0x4c9d;
  static constexpr Tagged_t kInt32Array_string = 0x4cb5;
  static constexpr Tagged_t kInt8Array_string = 0x4ccd;
  static constexpr Tagged_t kisExtensible_string = 0x4ce5;
  static constexpr Tagged_t kiso8601_string = 0x4cfd;
  static constexpr Tagged_t kisoDay_string = 0x4d11;
  static constexpr Tagged_t kisoHour_string = 0x4d25;
  static constexpr Tagged_t kisoMicrosecond_string = 0x4d39;
  static constexpr Tagged_t kisoMillisecond_string = 0x4d55;
  static constexpr Tagged_t kisoMinute_string = 0x4d71;
  static constexpr Tagged_t kisoMonth_string = 0x4d89;
  static constexpr Tagged_t kisoNanosecond_string = 0x4d9d;
  static constexpr Tagged_t kisoSecond_string = 0x4db9;
  static constexpr Tagged_t kisoYear_string = 0x4dd1;
  static constexpr Tagged_t kIterator_string = 0x4de5;
  static constexpr Tagged_t kjsMemoryEstimate_string = 0x4df9;
  static constexpr Tagged_t kjsMemoryRange_string = 0x4e15;
  static constexpr Tagged_t kkeys_string = 0x4e31;
  static constexpr Tagged_t klargestUnit_string = 0x4e41;
  static constexpr Tagged_t klastIndex_string = 0x4e59;
  static constexpr Tagged_t klet_string = 0x4e71;
  static constexpr Tagged_t kline_string = 0x4e81;
  static constexpr Tagged_t klinear_string = 0x4e91;
  static constexpr Tagged_t kLinkError_string = 0x4ea5;
  static constexpr Tagged_t klong_string = 0x4ebd;
  static constexpr Tagged_t kMap_string = 0x4ecd;
  static constexpr Tagged_t kMapIterator_string = 0x4edd;
  static constexpr Tagged_t kmax_byte_length_string = 0x4ef5;
  static constexpr Tagged_t kmedium_string = 0x4f11;
  static constexpr Tagged_t kmergeFields_string = 0x4f25;
  static constexpr Tagged_t kmessage_string = 0x4f3d;
  static constexpr Tagged_t kmeta_string = 0x4f51;
  static constexpr Tagged_t kminus_Infinity_string = 0x4f61;
  static constexpr Tagged_t kmicrosecond_string = 0x4f79;
  static constexpr Tagged_t kmicroseconds_string = 0x4f91;
  static constexpr Tagged_t kmillisecond_string = 0x4fa9;
  static constexpr Tagged_t kmilliseconds_string = 0x4fc1;
  static constexpr Tagged_t kminute_string = 0x4fd9;
  static constexpr Tagged_t kminutes_string = 0x4fed;
  static constexpr Tagged_t kModule_string = 0x5001;
  static constexpr Tagged_t kmonth_string = 0x5015;
  static constexpr Tagged_t kmonthDayFromFields_string = 0x5029;
  static constexpr Tagged_t kmonths_string = 0x5049;
  static constexpr Tagged_t kmonthsInYear_string = 0x505d;
  static constexpr Tagged_t kmonthCode_string = 0x5075;
  static constexpr Tagged_t kmultiline_string = 0x508d;
  static constexpr Tagged_t kNaN_string = 0x50a5;
  static constexpr Tagged_t knanosecond_string = 0x50b5;
  static constexpr Tagged_t knanoseconds_string = 0x50cd;
  static constexpr Tagged_t knarrow_string = 0x50e5;
  static constexpr Tagged_t knative_string = 0x50f9;
  static constexpr Tagged_t kNFC_string = 0x510d;
  static constexpr Tagged_t kNFD_string = 0x511d;
  static constexpr Tagged_t kNFKC_string = 0x512d;
  static constexpr Tagged_t kNFKD_string = 0x513d;
  static constexpr Tagged_t knot_equal_string = 0x514d;
  static constexpr Tagged_t knull_string = 0x5165;
  static constexpr Tagged_t knull_to_string = 0x5175;
  static constexpr Tagged_t kNumber_string = 0x5191;
  static constexpr Tagged_t knumber_string = 0x51a5;
  static constexpr Tagged_t knumber_to_string = 0x51b9;
  static constexpr Tagged_t kObject_string = 0x51d5;
  static constexpr Tagged_t kobject_string = 0x51e9;
  static constexpr Tagged_t kobject_to_string = 0x51fd;
  static constexpr Tagged_t kObject_prototype_string = 0x5219;
  static constexpr Tagged_t kof_string = 0x5235;
  static constexpr Tagged_t koffset_string = 0x5245;
  static constexpr Tagged_t koffsetNanoseconds_string = 0x5259;
  static constexpr Tagged_t kok_string = 0x5279;
  static constexpr Tagged_t kother_string = 0x5289;
  static constexpr Tagged_t koverflow_string = 0x529d;
  static constexpr Tagged_t kownKeys_string = 0x52b1;
  static constexpr Tagged_t kpercent_string = 0x52c5;
  static constexpr Tagged_t kplainDate_string = 0x52d9;
  static constexpr Tagged_t kplainTime_string = 0x52f1;
  static constexpr Tagged_t kposition_string = 0x5309;
  static constexpr Tagged_t kpreventExtensions_string = 0x531d;
  static constexpr Tagged_t kprivate_constructor_string = 0x533d;
  static constexpr Tagged_t kPromise_string = 0x5355;
  static constexpr Tagged_t kpromise_string = 0x5369;
  static constexpr Tagged_t kproto_string = 0x537d;
  static constexpr Tagged_t kproxy_string = 0x5395;
  static constexpr Tagged_t kProxy_string = 0x53a9;
  static constexpr Tagged_t kquery_colon_string = 0x53bd;
  static constexpr Tagged_t kRangeError_string = 0x53cd;
  static constexpr Tagged_t kraw_json_string = 0x53e5;
  static constexpr Tagged_t kraw_string = 0x53f9;
  static constexpr Tagged_t kReferenceError_string = 0x5409;
  static constexpr Tagged_t kReflectGet_string = 0x5425;
  static constexpr Tagged_t kReflectHas_string = 0x543d;
  static constexpr Tagged_t kRegExp_string = 0x5455;
  static constexpr Tagged_t kregexp_to_string = 0x5469;
  static constexpr Tagged_t kreject_string = 0x5485;
  static constexpr Tagged_t krelativeTo_string = 0x5499;
  static constexpr Tagged_t kresizable_string = 0x54b1;
  static constexpr Tagged_t kResizableArrayBuffer_string = 0x54c9;
  static constexpr Tagged_t kreturn_string = 0x54e9;
  static constexpr Tagged_t krevoke_string = 0x54fd;
  static constexpr Tagged_t kroundingIncrement_string = 0x5511;
  static constexpr Tagged_t kRuntimeError_string = 0x5531;
  static constexpr Tagged_t kWebAssemblyException_string = 0x5549;
  static constexpr Tagged_t kScript_string = 0x556d;
  static constexpr Tagged_t kscript_string = 0x5581;
  static constexpr Tagged_t ksecond_string = 0x5595;
  static constexpr Tagged_t kseconds_string = 0x55a9;
  static constexpr Tagged_t kshort_string = 0x55bd;
  static constexpr Tagged_t kSet_string = 0x55d1;
  static constexpr Tagged_t ksentence_string = 0x55e1;
  static constexpr Tagged_t kset_space_string = 0x55f5;
  static constexpr Tagged_t kset_string = 0x5605;
  static constexpr Tagged_t kSetIterator_string = 0x5615;
  static constexpr Tagged_t ksetPrototypeOf_string = 0x562d;
  static constexpr Tagged_t kShadowRealm_string = 0x5649;
  static constexpr Tagged_t kSharedArray_string = 0x5661;
  static constexpr Tagged_t kSharedArrayBuffer_string = 0x5679;
  static constexpr Tagged_t kSharedStruct_string = 0x5699;
  static constexpr Tagged_t ksign_string = 0x56b1;
  static constexpr Tagged_t ksize_string = 0x56c1;
  static constexpr Tagged_t ksmallestUnit_string = 0x56d1;
  static constexpr Tagged_t ksource_string = 0x56e9;
  static constexpr Tagged_t ksourceText_string = 0x56fd;
  static constexpr Tagged_t kstack_string = 0x5715;
  static constexpr Tagged_t kstackTraceLimit_string = 0x5729;
  static constexpr Tagged_t kstatic_initializer_string = 0x5745;
  static constexpr Tagged_t ksticky_string = 0x5765;
  static constexpr Tagged_t kString_string = 0x5779;
  static constexpr Tagged_t kstring_string = 0x578d;
  static constexpr Tagged_t kstring_to_string = 0x57a1;
  static constexpr Tagged_t ksuppressed_string = 0x57bd;
  static constexpr Tagged_t kSuppressedError_string = 0x57d5;
  static constexpr Tagged_t kSymbol_iterator_string = 0x57f1;
  static constexpr Tagged_t kSymbol_match_all_string = 0x580d;
  static constexpr Tagged_t kSymbol_replace_string = 0x5829;
  static constexpr Tagged_t ksymbol_species_string = 0x5845;
  static constexpr Tagged_t kSymbol_species_string = 0x5861;
  static constexpr Tagged_t kSymbol_split_string = 0x587d;
  static constexpr Tagged_t kSymbol_string = 0x5895;
  static constexpr Tagged_t ksymbol_string = 0x58a9;
  static constexpr Tagged_t kSyntaxError_string = 0x58bd;
  static constexpr Tagged_t ktarget_string = 0x58d5;
  static constexpr Tagged_t kthis_function_string = 0x58e9;
  static constexpr Tagged_t kthis_string = 0x5905;
  static constexpr Tagged_t kthrow_string = 0x5915;
  static constexpr Tagged_t ktimed_out_string = 0x5929;
  static constexpr Tagged_t ktimeZone_string = 0x5941;
  static constexpr Tagged_t ktoJSON_string = 0x5955;
  static constexpr Tagged_t ktoString_string = 0x5969;
  static constexpr Tagged_t ktrue_string = 0x597d;
  static constexpr Tagged_t ktotal_string = 0x598d;
  static constexpr Tagged_t kTypeError_string = 0x59a1;
  static constexpr Tagged_t kUint16Array_string = 0x59b9;
  static constexpr Tagged_t kUint32Array_string = 0x59d1;
  static constexpr Tagged_t kUint8Array_string = 0x59e9;
  static constexpr Tagged_t kUint8ClampedArray_string = 0x5a01;
  static constexpr Tagged_t kundefined_string = 0x5a21;
  static constexpr Tagged_t kundefined_to_string = 0x5a39;
  static constexpr Tagged_t kunicode_string = 0x5a59;
  static constexpr Tagged_t kunicodeSets_string = 0x5a6d;
  static constexpr Tagged_t kunit_string = 0x5a85;
  static constexpr Tagged_t kURIError_string = 0x5a95;
  static constexpr Tagged_t kUTC_string = 0x5aa9;
  static constexpr Tagged_t kvalueOf_string = 0x5ab9;
  static constexpr Tagged_t kWeakMap_string = 0x5acd;
  static constexpr Tagged_t kWeakRef_string = 0x5ae1;
  static constexpr Tagged_t kWeakSet_string = 0x5af5;
  static constexpr Tagged_t kweek_string = 0x5b09;
  static constexpr Tagged_t kweeks_string = 0x5b19;
  static constexpr Tagged_t kweekOfYear_string = 0x5b2d;
  static constexpr Tagged_t kwith_string = 0x5b45;
  static constexpr Tagged_t kword_string = 0x5b55;
  static constexpr Tagged_t kyearMonthFromFields_string = 0x5b65;
  static constexpr Tagged_t kyear_string = 0x5b85;
  static constexpr Tagged_t kyears_string = 0x5b95;
  static constexpr Tagged_t kPropertyCellHoleValue = 0x5ba9;
  static constexpr Tagged_t kHashTableHoleValue = 0x5bb5;
  static constexpr Tagged_t kPromiseHoleValue = 0x5bc1;
  static constexpr Tagged_t kUninitializedValue = 0x5bcd;
  static constexpr Tagged_t kArgumentsMarker = 0x5bd9;
  static constexpr Tagged_t kTerminationException = 0x5be5;
  static constexpr Tagged_t kException = 0x5bf1;
  static constexpr Tagged_t kOptimizedOut = 0x5bfd;
  static constexpr Tagged_t kStaleRegister = 0x5c09;
  static constexpr Tagged_t kSelfReferenceMarker = 0x5c15;
  static constexpr Tagged_t kBasicBlockCountersMarker = 0x5c21;
  static constexpr Tagged_t karray_buffer_wasm_memory_symbol = 0x5c2d;
  static constexpr Tagged_t kcall_site_info_symbol = 0x5c3d;
  static constexpr Tagged_t kconsole_context_id_symbol = 0x5c4d;
  static constexpr Tagged_t kconsole_context_name_symbol = 0x5c5d;
  static constexpr Tagged_t kclass_fields_symbol = 0x5c6d;
  static constexpr Tagged_t kclass_positions_symbol = 0x5c7d;
  static constexpr Tagged_t kerror_end_pos_symbol = 0x5c8d;
  static constexpr Tagged_t kerror_script_symbol = 0x5c9d;
  static constexpr Tagged_t kerror_stack_symbol = 0x5cad;
  static constexpr Tagged_t kerror_start_pos_symbol = 0x5cbd;
  static constexpr Tagged_t kfrozen_symbol = 0x5ccd;
  static constexpr Tagged_t kinterpreter_trampoline_symbol = 0x5cdd;
  static constexpr Tagged_t knative_context_index_symbol = 0x5ced;
  static constexpr Tagged_t knonextensible_symbol = 0x5cfd;
  static constexpr Tagged_t kpromise_debug_marker_symbol = 0x5d0d;
  static constexpr Tagged_t kpromise_debug_message_symbol = 0x5d1d;
  static constexpr Tagged_t kpromise_forwarding_handler_symbol = 0x5d2d;
  static constexpr Tagged_t kpromise_handled_by_symbol = 0x5d3d;
  static constexpr Tagged_t kpromise_awaited_by_symbol = 0x5d4d;
  static constexpr Tagged_t kregexp_result_names_symbol = 0x5d5d;
  static constexpr Tagged_t kregexp_result_regexp_input_symbol = 0x5d6d;
  static constexpr Tagged_t kregexp_result_regexp_last_index_symbol = 0x5d7d;
  static constexpr Tagged_t ksealed_symbol = 0x5d8d;
  static constexpr Tagged_t kshared_struct_map_elements_template_symbol =
      0x5d9d;
  static constexpr Tagged_t kshared_struct_map_registry_key_symbol = 0x5dad;
  static constexpr Tagged_t kstrict_function_transition_symbol = 0x5dbd;
  static constexpr Tagged_t ktemplate_literal_function_literal_id_symbol =
      0x5dcd;
  static constexpr Tagged_t ktemplate_literal_slot_id_symbol = 0x5ddd;
  static constexpr Tagged_t kwasm_exception_tag_symbol = 0x5ded;
  static constexpr Tagged_t kwasm_exception_values_symbol = 0x5dfd;
  static constexpr Tagged_t kwasm_uncatchable_symbol = 0x5e0d;
  static constexpr Tagged_t kwasm_wrapped_object_symbol = 0x5e1d;
  static constexpr Tagged_t kwasm_debug_proxy_cache_symbol = 0x5e2d;
  static constexpr Tagged_t kwasm_debug_proxy_names_symbol = 0x5e3d;
  static constexpr Tagged_t kasync_iterator_symbol = 0x5e4d;
  static constexpr Tagged_t kintl_fallback_symbol = 0x5e7d;
  static constexpr Tagged_t kmatch_symbol = 0x5eb5;
  static constexpr Tagged_t ksearch_symbol = 0x5edd;
  static constexpr Tagged_t kto_primitive_symbol = 0x5f09;
  static constexpr Tagged_t kunscopables_symbol = 0x5f39;
  static constexpr Tagged_t khas_instance_symbol = 0x5f69;
  static constexpr Tagged_t kto_string_tag_symbol = 0x5f99;
  static constexpr Tagged_t kconstructor_string = 0x5ff1;
  static constexpr Tagged_t knext_string = 0x6009;
  static constexpr Tagged_t kresolve_string = 0x6019;
  static constexpr Tagged_t kthen_string = 0x602d;
  static constexpr Tagged_t kiterator_symbol = 0x603d;
  static constexpr Tagged_t kmatch_all_symbol = 0x604d;
  static constexpr Tagged_t kreplace_symbol = 0x605d;
  static constexpr Tagged_t kspecies_symbol = 0x606d;
  static constexpr Tagged_t ksplit_symbol = 0x607d;
  static constexpr Tagged_t kis_concat_spreadable_symbol = 0x608d;
  static constexpr Tagged_t kEmptySlowElementDictionary = 0x609d;
  static constexpr Tagged_t kEmptySymbolTable = 0x60c1;
  static constexpr Tagged_t kEmptyOrderedHashMap = 0x60dd;
  static constexpr Tagged_t kEmptyOrderedHashSet = 0x60f1;
  static constexpr Tagged_t kEmptyFeedbackMetadata = 0x6105;
  static constexpr Tagged_t kGlobalThisBindingScopeInfo = 0x6111;
  static constexpr Tagged_t kEmptyFunctionScopeInfo = 0x6131;
  static constexpr Tagged_t kNativeScopeInfo = 0x6155;
  static constexpr Tagged_t kShadowRealmScopeInfo = 0x616d;
  static constexpr Tagged_t kEmptyExternalPointerArray = 0x6185;
  static constexpr Tagged_t kWasmNullPadding = 0x618d;
  static constexpr Tagged_t kWasmNull = 0xfffd;
  static constexpr Tagged_t kJSSharedArrayMap = 0x20001;
  static constexpr Tagged_t kJSAtomicsMutexMap = 0x20045;
  static constexpr Tagged_t kJSAtomicsConditionMap = 0x2006d;
};

static constexpr std::array<Tagged_t, 757> StaticReadOnlyRootsPointerTable = {
    StaticReadOnlyRoot::kFreeSpaceMap,
    StaticReadOnlyRoot::kOnePointerFillerMap,
    StaticReadOnlyRoot::kTwoPointerFillerMap,
    StaticReadOnlyRoot::kUninitializedValue,
    StaticReadOnlyRoot::kUndefinedValue,
    StaticReadOnlyRoot::kTheHoleValue,
    StaticReadOnlyRoot::kNullValue,
    StaticReadOnlyRoot::kTrueValue,
    StaticReadOnlyRoot::kFalseValue,
    StaticReadOnlyRoot::kempty_string,
    StaticReadOnlyRoot::kMetaMap,
    StaticReadOnlyRoot::kByteArrayMap,
    StaticReadOnlyRoot::kFixedArrayMap,
    StaticReadOnlyRoot::kFixedCOWArrayMap,
    StaticReadOnlyRoot::kFixedDoubleArrayMap,
    StaticReadOnlyRoot::kHashTableMap,
    StaticReadOnlyRoot::kSymbolMap,
    StaticReadOnlyRoot::kSeqOneByteStringMap,
    StaticReadOnlyRoot::kInternalizedOneByteStringMap,
    StaticReadOnlyRoot::kScopeInfoMap,
    StaticReadOnlyRoot::kSharedFunctionInfoMap,
    StaticReadOnlyRoot::kInstructionStreamMap,
    StaticReadOnlyRoot::kCellMap,
    StaticReadOnlyRoot::kGlobalPropertyCellMap,
    StaticReadOnlyRoot::kForeignMap,
    StaticReadOnlyRoot::kHeapNumberMap,
    StaticReadOnlyRoot::kTransitionArrayMap,
    StaticReadOnlyRoot::kFeedbackVectorMap,
    StaticReadOnlyRoot::kEmptyScopeInfo,
    StaticReadOnlyRoot::kEmptyFixedArray,
    StaticReadOnlyRoot::kEmptyDescriptorArray,
    StaticReadOnlyRoot::kArgumentsMarker,
    StaticReadOnlyRoot::kException,
    StaticReadOnlyRoot::kTerminationException,
    StaticReadOnlyRoot::kOptimizedOut,
    StaticReadOnlyRoot::kStaleRegister,
    StaticReadOnlyRoot::kPropertyCellHoleValue,
    StaticReadOnlyRoot::kHashTableHoleValue,
    StaticReadOnlyRoot::kPromiseHoleValue,
    StaticReadOnlyRoot::kScriptContextTableMap,
    StaticReadOnlyRoot::kClosureFeedbackCellArrayMap,
    StaticReadOnlyRoot::kFeedbackMetadataArrayMap,
    StaticReadOnlyRoot::kArrayListMap,
    StaticReadOnlyRoot::kBigIntMap,
    StaticReadOnlyRoot::kObjectBoilerplateDescriptionMap,
    StaticReadOnlyRoot::kBytecodeArrayMap,
    StaticReadOnlyRoot::kCodeMap,
    StaticReadOnlyRoot::kCoverageInfoMap,
    StaticReadOnlyRoot::kGlobalDictionaryMap,
    StaticReadOnlyRoot::kManyClosuresCellMap,
    StaticReadOnlyRoot::kMegaDomHandlerMap,
    StaticReadOnlyRoot::kModuleInfoMap,
    StaticReadOnlyRoot::kNameDictionaryMap,
    StaticReadOnlyRoot::kNoClosuresCellMap,
    StaticReadOnlyRoot::kNumberDictionaryMap,
    StaticReadOnlyRoot::kOneClosureCellMap,
    StaticReadOnlyRoot::kOrderedHashMapMap,
    StaticReadOnlyRoot::kOrderedHashSetMap,
    StaticReadOnlyRoot::kNameToIndexHashTableMap,
    StaticReadOnlyRoot::kRegisteredSymbolTableMap,
    StaticReadOnlyRoot::kOrderedNameDictionaryMap,
    StaticReadOnlyRoot::kPreparseDataMap,
    StaticReadOnlyRoot::kPropertyArrayMap,
    StaticReadOnlyRoot::kAccessorInfoMap,
    StaticReadOnlyRoot::kRegExpMatchInfoMap,
    StaticReadOnlyRoot::kSideEffectCallHandlerInfoMap,
    StaticReadOnlyRoot::kSideEffectFreeCallHandlerInfoMap,
    StaticReadOnlyRoot::kSimpleNumberDictionaryMap,
    StaticReadOnlyRoot::kSmallOrderedHashMapMap,
    StaticReadOnlyRoot::kSmallOrderedHashSetMap,
    StaticReadOnlyRoot::kSmallOrderedNameDictionaryMap,
    StaticReadOnlyRoot::kSourceTextModuleMap,
    StaticReadOnlyRoot::kSwissNameDictionaryMap,
    StaticReadOnlyRoot::kSyntheticModuleMap,
    StaticReadOnlyRoot::kWasmApiFunctionRefMap,
    StaticReadOnlyRoot::kWasmCapiFunctionDataMap,
    StaticReadOnlyRoot::kWasmExportedFunctionDataMap,
    StaticReadOnlyRoot::kWasmInternalFunctionMap,
    StaticReadOnlyRoot::kWasmJSFunctionDataMap,
    StaticReadOnlyRoot::kWasmResumeDataMap,
    StaticReadOnlyRoot::kWasmTypeInfoMap,
    StaticReadOnlyRoot::kWasmContinuationObjectMap,
    StaticReadOnlyRoot::kWasmNullMap,
    StaticReadOnlyRoot::kWasmTrustedInstanceDataMap,
    StaticReadOnlyRoot::kWeakFixedArrayMap,
    StaticReadOnlyRoot::kWeakArrayListMap,
    StaticReadOnlyRoot::kEphemeronHashTableMap,
    StaticReadOnlyRoot::kEmbedderDataArrayMap,
    StaticReadOnlyRoot::kWeakCellMap,
    StaticReadOnlyRoot::kExternalPointerArrayMap,
    StaticReadOnlyRoot::kTrustedFixedArrayMap,
    StaticReadOnlyRoot::kTrustedByteArrayMap,
    StaticReadOnlyRoot::kInterpreterDataMap,
    StaticReadOnlyRoot::kSeqTwoByteStringMap,
    StaticReadOnlyRoot::kConsTwoByteStringMap,
    StaticReadOnlyRoot::kConsOneByteStringMap,
    StaticReadOnlyRoot::kThinTwoByteStringMap,
    StaticReadOnlyRoot::kThinOneByteStringMap,
    StaticReadOnlyRoot::kSlicedTwoByteStringMap,
    StaticReadOnlyRoot::kSlicedOneByteStringMap,
    StaticReadOnlyRoot::kExternalTwoByteStringMap,
    StaticReadOnlyRoot::kExternalOneByteStringMap,
    StaticReadOnlyRoot::kInternalizedTwoByteStringMap,
    StaticReadOnlyRoot::kExternalInternalizedTwoByteStringMap,
    StaticReadOnlyRoot::kExternalInternalizedOneByteStringMap,
    StaticReadOnlyRoot::kUncachedExternalInternalizedTwoByteStringMap,
    StaticReadOnlyRoot::kUncachedExternalInternalizedOneByteStringMap,
    StaticReadOnlyRoot::kUncachedExternalTwoByteStringMap,
    StaticReadOnlyRoot::kUncachedExternalOneByteStringMap,
    StaticReadOnlyRoot::kSharedSeqOneByteStringMap,
    StaticReadOnlyRoot::kSharedSeqTwoByteStringMap,
    StaticReadOnlyRoot::kSharedExternalOneByteStringMap,
    StaticReadOnlyRoot::kSharedExternalTwoByteStringMap,
    StaticReadOnlyRoot::kSharedUncachedExternalOneByteStringMap,
    StaticReadOnlyRoot::kSharedUncachedExternalTwoByteStringMap,
    StaticReadOnlyRoot::kUndefinedMap,
    StaticReadOnlyRoot::kNullMap,
    StaticReadOnlyRoot::kBooleanMap,
    StaticReadOnlyRoot::kHoleMap,
    StaticReadOnlyRoot::kJSSharedArrayMap,
    StaticReadOnlyRoot::kJSAtomicsMutexMap,
    StaticReadOnlyRoot::kJSAtomicsConditionMap,
    StaticReadOnlyRoot::kEmptyEnumCache,
    StaticReadOnlyRoot::kEmptyPropertyArray,
    StaticReadOnlyRoot::kEmptyByteArray,
    StaticReadOnlyRoot::kEmptyExternalPointerArray,
    StaticReadOnlyRoot::kEmptyObjectBoilerplateDescription,
    StaticReadOnlyRoot::kEmptyArrayBoilerplateDescription,
    StaticReadOnlyRoot::kEmptyClosureFeedbackCellArray,
    StaticReadOnlyRoot::kEmptySlowElementDictionary,
    StaticReadOnlyRoot::kEmptyOrderedHashMap,
    StaticReadOnlyRoot::kEmptyOrderedHashSet,
    StaticReadOnlyRoot::kEmptyFeedbackMetadata,
    StaticReadOnlyRoot::kEmptyPropertyDictionary,
    StaticReadOnlyRoot::kEmptyOrderedPropertyDictionary,
    StaticReadOnlyRoot::kEmptySwissPropertyDictionary,
    StaticReadOnlyRoot::kNoOpInterceptorInfo,
    StaticReadOnlyRoot::kEmptyArrayList,
    StaticReadOnlyRoot::kEmptyWeakFixedArray,
    StaticReadOnlyRoot::kEmptyWeakArrayList,
    StaticReadOnlyRoot::kInvalidPrototypeValidityCell,
    StaticReadOnlyRoot::kNanValue,
    StaticReadOnlyRoot::kHoleNanValue,
    StaticReadOnlyRoot::kInfinityValue,
    StaticReadOnlyRoot::kMinusZeroValue,
    StaticReadOnlyRoot::kMinusInfinityValue,
    StaticReadOnlyRoot::kMaxSafeInteger,
    StaticReadOnlyRoot::kMaxUInt32,
    StaticReadOnlyRoot::kSmiMinValue,
    StaticReadOnlyRoot::kSmiMaxValuePlusOne,
    StaticReadOnlyRoot::kSingleCharacterStringTable,
    StaticReadOnlyRoot::kSelfReferenceMarker,
    StaticReadOnlyRoot::kBasicBlockCountersMarker,
    StaticReadOnlyRoot::kGlobalThisBindingScopeInfo,
    StaticReadOnlyRoot::kEmptyFunctionScopeInfo,
    StaticReadOnlyRoot::kNativeScopeInfo,
    StaticReadOnlyRoot::kShadowRealmScopeInfo,
    StaticReadOnlyRoot::kEmptySymbolTable,
    StaticReadOnlyRoot::kHashSeed,
    StaticReadOnlyRoot::kWasmNullPadding,
    StaticReadOnlyRoot::kWasmNull,
    StaticReadOnlyRoot::klength_string,
    StaticReadOnlyRoot::kprototype_string,
    StaticReadOnlyRoot::kname_string,
    StaticReadOnlyRoot::kenumerable_string,
    StaticReadOnlyRoot::kconfigurable_string,
    StaticReadOnlyRoot::kvalue_string,
    StaticReadOnlyRoot::kwritable_string,
    StaticReadOnlyRoot::kadoptText_string,
    StaticReadOnlyRoot::kapproximatelySign_string,
    StaticReadOnlyRoot::kbaseName_string,
    StaticReadOnlyRoot::kaccounting_string,
    StaticReadOnlyRoot::kbreakType_string,
    StaticReadOnlyRoot::kcalendars_string,
    StaticReadOnlyRoot::kcardinal_string,
    StaticReadOnlyRoot::kcaseFirst_string,
    StaticReadOnlyRoot::kceil_string,
    StaticReadOnlyRoot::kcompare_string,
    StaticReadOnlyRoot::kcollation_string,
    StaticReadOnlyRoot::kcollations_string,
    StaticReadOnlyRoot::kcompact_string,
    StaticReadOnlyRoot::kcompactDisplay_string,
    StaticReadOnlyRoot::kcurrency_string,
    StaticReadOnlyRoot::kcurrencyDisplay_string,
    StaticReadOnlyRoot::kcurrencySign_string,
    StaticReadOnlyRoot::kdateStyle_string,
    StaticReadOnlyRoot::kdateTimeField_string,
    StaticReadOnlyRoot::kdayPeriod_string,
    StaticReadOnlyRoot::kdaysDisplay_string,
    StaticReadOnlyRoot::kdecimal_string,
    StaticReadOnlyRoot::kdialect_string,
    StaticReadOnlyRoot::kdigital_string,
    StaticReadOnlyRoot::kdirection_string,
    StaticReadOnlyRoot::kendRange_string,
    StaticReadOnlyRoot::kengineering_string,
    StaticReadOnlyRoot::kexceptZero_string,
    StaticReadOnlyRoot::kexpand_string,
    StaticReadOnlyRoot::kexponentInteger_string,
    StaticReadOnlyRoot::kexponentMinusSign_string,
    StaticReadOnlyRoot::kexponentSeparator_string,
    StaticReadOnlyRoot::kfallback_string,
    StaticReadOnlyRoot::kfirst_string,
    StaticReadOnlyRoot::kfirstDay_string,
    StaticReadOnlyRoot::kfloor_string,
    StaticReadOnlyRoot::kformat_string,
    StaticReadOnlyRoot::kfraction_string,
    StaticReadOnlyRoot::kfractionalDigits_string,
    StaticReadOnlyRoot::kfractionalSecond_string,
    StaticReadOnlyRoot::kfull_string,
    StaticReadOnlyRoot::kgranularity_string,
    StaticReadOnlyRoot::kgrapheme_string,
    StaticReadOnlyRoot::kgroup_string,
    StaticReadOnlyRoot::kh11_string,
    StaticReadOnlyRoot::kh12_string,
    StaticReadOnlyRoot::kh23_string,
    StaticReadOnlyRoot::kh24_string,
    StaticReadOnlyRoot::khalfCeil_string,
    StaticReadOnlyRoot::khalfEven_string,
    StaticReadOnlyRoot::khalfExpand_string,
    StaticReadOnlyRoot::khalfFloor_string,
    StaticReadOnlyRoot::khalfTrunc_string,
    StaticReadOnlyRoot::khour12_string,
    StaticReadOnlyRoot::khourCycle_string,
    StaticReadOnlyRoot::khourCycles_string,
    StaticReadOnlyRoot::khoursDisplay_string,
    StaticReadOnlyRoot::kideo_string,
    StaticReadOnlyRoot::kignorePunctuation_string,
    StaticReadOnlyRoot::kInvalid_Date_string,
    StaticReadOnlyRoot::kinteger_string,
    StaticReadOnlyRoot::kisWordLike_string,
    StaticReadOnlyRoot::kkana_string,
    StaticReadOnlyRoot::klanguage_string,
    StaticReadOnlyRoot::klanguageDisplay_string,
    StaticReadOnlyRoot::klessPrecision_string,
    StaticReadOnlyRoot::kletter_string,
    StaticReadOnlyRoot::klist_string,
    StaticReadOnlyRoot::kliteral_string,
    StaticReadOnlyRoot::klocale_string,
    StaticReadOnlyRoot::kloose_string,
    StaticReadOnlyRoot::klower_string,
    StaticReadOnlyRoot::kltr_string,
    StaticReadOnlyRoot::kmaximumFractionDigits_string,
    StaticReadOnlyRoot::kmaximumSignificantDigits_string,
    StaticReadOnlyRoot::kmicrosecondsDisplay_string,
    StaticReadOnlyRoot::kmillisecondsDisplay_string,
    StaticReadOnlyRoot::kmin2_string,
    StaticReadOnlyRoot::kminimalDays_string,
    StaticReadOnlyRoot::kminimumFractionDigits_string,
    StaticReadOnlyRoot::kminimumIntegerDigits_string,
    StaticReadOnlyRoot::kminimumSignificantDigits_string,
    StaticReadOnlyRoot::kminus_0,
    StaticReadOnlyRoot::kminusSign_string,
    StaticReadOnlyRoot::kminutesDisplay_string,
    StaticReadOnlyRoot::kmonthsDisplay_string,
    StaticReadOnlyRoot::kmorePrecision_string,
    StaticReadOnlyRoot::knan_string,
    StaticReadOnlyRoot::knanosecondsDisplay_string,
    StaticReadOnlyRoot::knarrowSymbol_string,
    StaticReadOnlyRoot::knegative_string,
    StaticReadOnlyRoot::knever_string,
    StaticReadOnlyRoot::knone_string,
    StaticReadOnlyRoot::knotation_string,
    StaticReadOnlyRoot::knormal_string,
    StaticReadOnlyRoot::knumberingSystem_string,
    StaticReadOnlyRoot::knumberingSystems_string,
    StaticReadOnlyRoot::knumeric_string,
    StaticReadOnlyRoot::kordinal_string,
    StaticReadOnlyRoot::kpercentSign_string,
    StaticReadOnlyRoot::kplusSign_string,
    StaticReadOnlyRoot::kquarter_string,
    StaticReadOnlyRoot::kregion_string,
    StaticReadOnlyRoot::krelatedYear_string,
    StaticReadOnlyRoot::kroundingMode_string,
    StaticReadOnlyRoot::kroundingPriority_string,
    StaticReadOnlyRoot::krtl_string,
    StaticReadOnlyRoot::kscientific_string,
    StaticReadOnlyRoot::ksecondsDisplay_string,
    StaticReadOnlyRoot::ksegment_string,
    StaticReadOnlyRoot::kSegmentIterator_string,
    StaticReadOnlyRoot::kSegments_string,
    StaticReadOnlyRoot::ksensitivity_string,
    StaticReadOnlyRoot::ksep_string,
    StaticReadOnlyRoot::kshared_string,
    StaticReadOnlyRoot::ksignDisplay_string,
    StaticReadOnlyRoot::kstandard_string,
    StaticReadOnlyRoot::kstartRange_string,
    StaticReadOnlyRoot::kstrict_string,
    StaticReadOnlyRoot::kstripIfInteger_string,
    StaticReadOnlyRoot::kstyle_string,
    StaticReadOnlyRoot::kterm_string,
    StaticReadOnlyRoot::ktextInfo_string,
    StaticReadOnlyRoot::ktimeStyle_string,
    StaticReadOnlyRoot::ktimeZones_string,
    StaticReadOnlyRoot::ktimeZoneName_string,
    StaticReadOnlyRoot::ktrailingZeroDisplay_string,
    StaticReadOnlyRoot::ktrunc_string,
    StaticReadOnlyRoot::ktwo_digit_string,
    StaticReadOnlyRoot::ktype_string,
    StaticReadOnlyRoot::kunknown_string,
    StaticReadOnlyRoot::kupper_string,
    StaticReadOnlyRoot::kusage_string,
    StaticReadOnlyRoot::kuseGrouping_string,
    StaticReadOnlyRoot::kunitDisplay_string,
    StaticReadOnlyRoot::kweekday_string,
    StaticReadOnlyRoot::kweekend_string,
    StaticReadOnlyRoot::kweeksDisplay_string,
    StaticReadOnlyRoot::kweekInfo_string,
    StaticReadOnlyRoot::kyearName_string,
    StaticReadOnlyRoot::kyearsDisplay_string,
    StaticReadOnlyRoot::kadd_string,
    StaticReadOnlyRoot::kAggregateError_string,
    StaticReadOnlyRoot::kalways_string,
    StaticReadOnlyRoot::kanonymous_function_string,
    StaticReadOnlyRoot::kanonymous_string,
    StaticReadOnlyRoot::kapply_string,
    StaticReadOnlyRoot::kArguments_string,
    StaticReadOnlyRoot::karguments_string,
    StaticReadOnlyRoot::karguments_to_string,
    StaticReadOnlyRoot::kArray_string,
    StaticReadOnlyRoot::karray_to_string,
    StaticReadOnlyRoot::kArrayBuffer_string,
    StaticReadOnlyRoot::kArrayIterator_string,
    StaticReadOnlyRoot::kas_string,
    StaticReadOnlyRoot::kassert_string,
    StaticReadOnlyRoot::kasync_string,
    StaticReadOnlyRoot::kAtomicsCondition_string,
    StaticReadOnlyRoot::kAtomicsMutex_string,
    StaticReadOnlyRoot::kauto_string,
    StaticReadOnlyRoot::kawait_string,
    StaticReadOnlyRoot::kBigInt_string,
    StaticReadOnlyRoot::kbigint_string,
    StaticReadOnlyRoot::kBigInt64Array_string,
    StaticReadOnlyRoot::kBigUint64Array_string,
    StaticReadOnlyRoot::kbind_string,
    StaticReadOnlyRoot::kblank_string,
    StaticReadOnlyRoot::kBoolean_string,
    StaticReadOnlyRoot::kboolean_string,
    StaticReadOnlyRoot::kboolean_to_string,
    StaticReadOnlyRoot::kbound__string,
    StaticReadOnlyRoot::kbuffer_string,
    StaticReadOnlyRoot::kbyte_length_string,
    StaticReadOnlyRoot::kbyte_offset_string,
    StaticReadOnlyRoot::kCompileError_string,
    StaticReadOnlyRoot::kcalendar_string,
    StaticReadOnlyRoot::kcallee_string,
    StaticReadOnlyRoot::kcaller_string,
    StaticReadOnlyRoot::kcause_string,
    StaticReadOnlyRoot::kcharacter_string,
    StaticReadOnlyRoot::kcode_string,
    StaticReadOnlyRoot::kcolumn_string,
    StaticReadOnlyRoot::kcomputed_string,
    StaticReadOnlyRoot::kconjunction_string,
    StaticReadOnlyRoot::kconsole_string,
    StaticReadOnlyRoot::kconstrain_string,
    StaticReadOnlyRoot::kconstruct_string,
    StaticReadOnlyRoot::kcurrent_string,
    StaticReadOnlyRoot::kDate_string,
    StaticReadOnlyRoot::kdate_to_string,
    StaticReadOnlyRoot::kdateAdd_string,
    StaticReadOnlyRoot::kdateFromFields_string,
    StaticReadOnlyRoot::kdateUntil_string,
    StaticReadOnlyRoot::kday_string,
    StaticReadOnlyRoot::kdayOfWeek_string,
    StaticReadOnlyRoot::kdayOfYear_string,
    StaticReadOnlyRoot::kdays_string,
    StaticReadOnlyRoot::kdaysInMonth_string,
    StaticReadOnlyRoot::kdaysInWeek_string,
    StaticReadOnlyRoot::kdaysInYear_string,
    StaticReadOnlyRoot::kdefault_string,
    StaticReadOnlyRoot::kdefineProperty_string,
    StaticReadOnlyRoot::kdeleteProperty_string,
    StaticReadOnlyRoot::kdetached_string,
    StaticReadOnlyRoot::kdisjunction_string,
    StaticReadOnlyRoot::kdone_string,
    StaticReadOnlyRoot::kdot_brand_string,
    StaticReadOnlyRoot::kdot_catch_string,
    StaticReadOnlyRoot::kdot_default_string,
    StaticReadOnlyRoot::kdot_for_string,
    StaticReadOnlyRoot::kdot_generator_object_string,
    StaticReadOnlyRoot::kdot_home_object_string,
    StaticReadOnlyRoot::kdot_new_target_string,
    StaticReadOnlyRoot::kdot_result_string,
    StaticReadOnlyRoot::kdot_repl_result_string,
    StaticReadOnlyRoot::kdot_static_home_object_string,
    StaticReadOnlyRoot::kdot_string,
    StaticReadOnlyRoot::kdot_switch_tag_string,
    StaticReadOnlyRoot::kdotAll_string,
    StaticReadOnlyRoot::kError_string,
    StaticReadOnlyRoot::kEvalError_string,
    StaticReadOnlyRoot::kelement_string,
    StaticReadOnlyRoot::kepochMicroseconds_string,
    StaticReadOnlyRoot::kepochMilliseconds_string,
    StaticReadOnlyRoot::kepochNanoseconds_string,
    StaticReadOnlyRoot::kepochSeconds_string,
    StaticReadOnlyRoot::kera_string,
    StaticReadOnlyRoot::keraYear_string,
    StaticReadOnlyRoot::kerror_string,
    StaticReadOnlyRoot::kerrors_string,
    StaticReadOnlyRoot::kerror_to_string,
    StaticReadOnlyRoot::keval_string,
    StaticReadOnlyRoot::kexception_string,
    StaticReadOnlyRoot::kexec_string,
    StaticReadOnlyRoot::kfalse_string,
    StaticReadOnlyRoot::kfields_string,
    StaticReadOnlyRoot::kFinalizationRegistry_string,
    StaticReadOnlyRoot::kflags_string,
    StaticReadOnlyRoot::kFloat32Array_string,
    StaticReadOnlyRoot::kFloat64Array_string,
    StaticReadOnlyRoot::kfractionalSecondDigits_string,
    StaticReadOnlyRoot::kfrom_string,
    StaticReadOnlyRoot::kFunction_string,
    StaticReadOnlyRoot::kfunction_native_code_string,
    StaticReadOnlyRoot::kfunction_string,
    StaticReadOnlyRoot::kfunction_to_string,
    StaticReadOnlyRoot::kGenerator_string,
    StaticReadOnlyRoot::kget_space_string,
    StaticReadOnlyRoot::kget_string,
    StaticReadOnlyRoot::kgetOffsetNanosecondsFor_string,
    StaticReadOnlyRoot::kgetOwnPropertyDescriptor_string,
    StaticReadOnlyRoot::kgetPossibleInstantsFor_string,
    StaticReadOnlyRoot::kgetPrototypeOf_string,
    StaticReadOnlyRoot::kglobal_string,
    StaticReadOnlyRoot::kglobalThis_string,
    StaticReadOnlyRoot::kgroups_string,
    StaticReadOnlyRoot::kgrowable_string,
    StaticReadOnlyRoot::khas_string,
    StaticReadOnlyRoot::khasIndices_string,
    StaticReadOnlyRoot::khour_string,
    StaticReadOnlyRoot::khours_string,
    StaticReadOnlyRoot::khoursInDay_string,
    StaticReadOnlyRoot::kignoreCase_string,
    StaticReadOnlyRoot::kid_string,
    StaticReadOnlyRoot::killegal_access_string,
    StaticReadOnlyRoot::killegal_argument_string,
    StaticReadOnlyRoot::kinLeapYear_string,
    StaticReadOnlyRoot::kindex_string,
    StaticReadOnlyRoot::kindices_string,
    StaticReadOnlyRoot::kInfinity_string,
    StaticReadOnlyRoot::kinfinity_string,
    StaticReadOnlyRoot::kinput_string,
    StaticReadOnlyRoot::kinstance_members_initializer_string,
    StaticReadOnlyRoot::kInt16Array_string,
    StaticReadOnlyRoot::kInt32Array_string,
    StaticReadOnlyRoot::kInt8Array_string,
    StaticReadOnlyRoot::kisExtensible_string,
    StaticReadOnlyRoot::kiso8601_string,
    StaticReadOnlyRoot::kisoDay_string,
    StaticReadOnlyRoot::kisoHour_string,
    StaticReadOnlyRoot::kisoMicrosecond_string,
    StaticReadOnlyRoot::kisoMillisecond_string,
    StaticReadOnlyRoot::kisoMinute_string,
    StaticReadOnlyRoot::kisoMonth_string,
    StaticReadOnlyRoot::kisoNanosecond_string,
    StaticReadOnlyRoot::kisoSecond_string,
    StaticReadOnlyRoot::kisoYear_string,
    StaticReadOnlyRoot::kIterator_string,
    StaticReadOnlyRoot::kjsMemoryEstimate_string,
    StaticReadOnlyRoot::kjsMemoryRange_string,
    StaticReadOnlyRoot::kkeys_string,
    StaticReadOnlyRoot::klargestUnit_string,
    StaticReadOnlyRoot::klastIndex_string,
    StaticReadOnlyRoot::klet_string,
    StaticReadOnlyRoot::kline_string,
    StaticReadOnlyRoot::klinear_string,
    StaticReadOnlyRoot::kLinkError_string,
    StaticReadOnlyRoot::klong_string,
    StaticReadOnlyRoot::kMap_string,
    StaticReadOnlyRoot::kMapIterator_string,
    StaticReadOnlyRoot::kmax_byte_length_string,
    StaticReadOnlyRoot::kmedium_string,
    StaticReadOnlyRoot::kmergeFields_string,
    StaticReadOnlyRoot::kmessage_string,
    StaticReadOnlyRoot::kmeta_string,
    StaticReadOnlyRoot::kminus_Infinity_string,
    StaticReadOnlyRoot::kmicrosecond_string,
    StaticReadOnlyRoot::kmicroseconds_string,
    StaticReadOnlyRoot::kmillisecond_string,
    StaticReadOnlyRoot::kmilliseconds_string,
    StaticReadOnlyRoot::kminute_string,
    StaticReadOnlyRoot::kminutes_string,
    StaticReadOnlyRoot::kModule_string,
    StaticReadOnlyRoot::kmonth_string,
    StaticReadOnlyRoot::kmonthDayFromFields_string,
    StaticReadOnlyRoot::kmonths_string,
    StaticReadOnlyRoot::kmonthsInYear_string,
    StaticReadOnlyRoot::kmonthCode_string,
    StaticReadOnlyRoot::kmultiline_string,
    StaticReadOnlyRoot::kNaN_string,
    StaticReadOnlyRoot::knanosecond_string,
    StaticReadOnlyRoot::knanoseconds_string,
    StaticReadOnlyRoot::knarrow_string,
    StaticReadOnlyRoot::knative_string,
    StaticReadOnlyRoot::knew_target_string,
    StaticReadOnlyRoot::kNFC_string,
    StaticReadOnlyRoot::kNFD_string,
    StaticReadOnlyRoot::kNFKC_string,
    StaticReadOnlyRoot::kNFKD_string,
    StaticReadOnlyRoot::knot_equal_string,
    StaticReadOnlyRoot::knull_string,
    StaticReadOnlyRoot::knull_to_string,
    StaticReadOnlyRoot::kNumber_string,
    StaticReadOnlyRoot::knumber_string,
    StaticReadOnlyRoot::knumber_to_string,
    StaticReadOnlyRoot::kObject_string,
    StaticReadOnlyRoot::kobject_string,
    StaticReadOnlyRoot::kobject_to_string,
    StaticReadOnlyRoot::kObject_prototype_string,
    StaticReadOnlyRoot::kof_string,
    StaticReadOnlyRoot::koffset_string,
    StaticReadOnlyRoot::koffsetNanoseconds_string,
    StaticReadOnlyRoot::kok_string,
    StaticReadOnlyRoot::kone_string,
    StaticReadOnlyRoot::kother_string,
    StaticReadOnlyRoot::koverflow_string,
    StaticReadOnlyRoot::kownKeys_string,
    StaticReadOnlyRoot::kpercent_string,
    StaticReadOnlyRoot::kplainDate_string,
    StaticReadOnlyRoot::kplainTime_string,
    StaticReadOnlyRoot::kposition_string,
    StaticReadOnlyRoot::kpreventExtensions_string,
    StaticReadOnlyRoot::kprivate_constructor_string,
    StaticReadOnlyRoot::kPromise_string,
    StaticReadOnlyRoot::kpromise_string,
    StaticReadOnlyRoot::kproto_string,
    StaticReadOnlyRoot::kproxy_string,
    StaticReadOnlyRoot::kProxy_string,
    StaticReadOnlyRoot::kquery_colon_string,
    StaticReadOnlyRoot::kRangeError_string,
    StaticReadOnlyRoot::kraw_json_string,
    StaticReadOnlyRoot::kraw_string,
    StaticReadOnlyRoot::kReferenceError_string,
    StaticReadOnlyRoot::kReflectGet_string,
    StaticReadOnlyRoot::kReflectHas_string,
    StaticReadOnlyRoot::kRegExp_string,
    StaticReadOnlyRoot::kregexp_to_string,
    StaticReadOnlyRoot::kreject_string,
    StaticReadOnlyRoot::krelativeTo_string,
    StaticReadOnlyRoot::kresizable_string,
    StaticReadOnlyRoot::kResizableArrayBuffer_string,
    StaticReadOnlyRoot::kreturn_string,
    StaticReadOnlyRoot::krevoke_string,
    StaticReadOnlyRoot::kroundingIncrement_string,
    StaticReadOnlyRoot::kRuntimeError_string,
    StaticReadOnlyRoot::kWebAssemblyException_string,
    StaticReadOnlyRoot::kScript_string,
    StaticReadOnlyRoot::kscript_string,
    StaticReadOnlyRoot::ksecond_string,
    StaticReadOnlyRoot::kseconds_string,
    StaticReadOnlyRoot::kshort_string,
    StaticReadOnlyRoot::kSet_string,
    StaticReadOnlyRoot::ksentence_string,
    StaticReadOnlyRoot::kset_space_string,
    StaticReadOnlyRoot::kset_string,
    StaticReadOnlyRoot::kSetIterator_string,
    StaticReadOnlyRoot::ksetPrototypeOf_string,
    StaticReadOnlyRoot::kShadowRealm_string,
    StaticReadOnlyRoot::kSharedArray_string,
    StaticReadOnlyRoot::kSharedArrayBuffer_string,
    StaticReadOnlyRoot::kSharedStruct_string,
    StaticReadOnlyRoot::ksign_string,
    StaticReadOnlyRoot::ksize_string,
    StaticReadOnlyRoot::ksmallestUnit_string,
    StaticReadOnlyRoot::ksource_string,
    StaticReadOnlyRoot::ksourceText_string,
    StaticReadOnlyRoot::kstack_string,
    StaticReadOnlyRoot::kstackTraceLimit_string,
    StaticReadOnlyRoot::kstatic_initializer_string,
    StaticReadOnlyRoot::ksticky_string,
    StaticReadOnlyRoot::kString_string,
    StaticReadOnlyRoot::kstring_string,
    StaticReadOnlyRoot::kstring_to_string,
    StaticReadOnlyRoot::ksuppressed_string,
    StaticReadOnlyRoot::kSuppressedError_string,
    StaticReadOnlyRoot::kSymbol_iterator_string,
    StaticReadOnlyRoot::kSymbol_match_all_string,
    StaticReadOnlyRoot::kSymbol_replace_string,
    StaticReadOnlyRoot::ksymbol_species_string,
    StaticReadOnlyRoot::kSymbol_species_string,
    StaticReadOnlyRoot::kSymbol_split_string,
    StaticReadOnlyRoot::kSymbol_string,
    StaticReadOnlyRoot::ksymbol_string,
    StaticReadOnlyRoot::kSyntaxError_string,
    StaticReadOnlyRoot::ktarget_string,
    StaticReadOnlyRoot::kthis_function_string,
    StaticReadOnlyRoot::kthis_string,
    StaticReadOnlyRoot::kthrow_string,
    StaticReadOnlyRoot::ktimed_out_string,
    StaticReadOnlyRoot::ktimeZone_string,
    StaticReadOnlyRoot::ktoJSON_string,
    StaticReadOnlyRoot::ktoString_string,
    StaticReadOnlyRoot::ktrue_string,
    StaticReadOnlyRoot::ktotal_string,
    StaticReadOnlyRoot::kTypeError_string,
    StaticReadOnlyRoot::kUint16Array_string,
    StaticReadOnlyRoot::kUint32Array_string,
    StaticReadOnlyRoot::kUint8Array_string,
    StaticReadOnlyRoot::kUint8ClampedArray_string,
    StaticReadOnlyRoot::kundefined_string,
    StaticReadOnlyRoot::kundefined_to_string,
    StaticReadOnlyRoot::kunicode_string,
    StaticReadOnlyRoot::kunicodeSets_string,
    StaticReadOnlyRoot::kunit_string,
    StaticReadOnlyRoot::kURIError_string,
    StaticReadOnlyRoot::kUTC_string,
    StaticReadOnlyRoot::kvalueOf_string,
    StaticReadOnlyRoot::kWeakMap_string,
    StaticReadOnlyRoot::kWeakRef_string,
    StaticReadOnlyRoot::kWeakSet_string,
    StaticReadOnlyRoot::kweek_string,
    StaticReadOnlyRoot::kweeks_string,
    StaticReadOnlyRoot::kweekOfYear_string,
    StaticReadOnlyRoot::kwith_string,
    StaticReadOnlyRoot::kword_string,
    StaticReadOnlyRoot::kyearMonthFromFields_string,
    StaticReadOnlyRoot::kyear_string,
    StaticReadOnlyRoot::kyears_string,
    StaticReadOnlyRoot::kzero_string,
    StaticReadOnlyRoot::knot_mapped_symbol,
    StaticReadOnlyRoot::kuninitialized_symbol,
    StaticReadOnlyRoot::kmegamorphic_symbol,
    StaticReadOnlyRoot::kelements_transition_symbol,
    StaticReadOnlyRoot::kmega_dom_symbol,
    StaticReadOnlyRoot::karray_buffer_wasm_memory_symbol,
    StaticReadOnlyRoot::kcall_site_info_symbol,
    StaticReadOnlyRoot::kconsole_context_id_symbol,
    StaticReadOnlyRoot::kconsole_context_name_symbol,
    StaticReadOnlyRoot::kclass_fields_symbol,
    StaticReadOnlyRoot::kclass_positions_symbol,
    StaticReadOnlyRoot::kerror_end_pos_symbol,
    StaticReadOnlyRoot::kerror_script_symbol,
    StaticReadOnlyRoot::kerror_stack_symbol,
    StaticReadOnlyRoot::kerror_start_pos_symbol,
    StaticReadOnlyRoot::kfrozen_symbol,
    StaticReadOnlyRoot::kinterpreter_trampoline_symbol,
    StaticReadOnlyRoot::knative_context_index_symbol,
    StaticReadOnlyRoot::knonextensible_symbol,
    StaticReadOnlyRoot::kpromise_debug_marker_symbol,
    StaticReadOnlyRoot::kpromise_debug_message_symbol,
    StaticReadOnlyRoot::kpromise_forwarding_handler_symbol,
    StaticReadOnlyRoot::kpromise_handled_by_symbol,
    StaticReadOnlyRoot::kpromise_awaited_by_symbol,
    StaticReadOnlyRoot::kregexp_result_names_symbol,
    StaticReadOnlyRoot::kregexp_result_regexp_input_symbol,
    StaticReadOnlyRoot::kregexp_result_regexp_last_index_symbol,
    StaticReadOnlyRoot::ksealed_symbol,
    StaticReadOnlyRoot::kshared_struct_map_elements_template_symbol,
    StaticReadOnlyRoot::kshared_struct_map_registry_key_symbol,
    StaticReadOnlyRoot::kstrict_function_transition_symbol,
    StaticReadOnlyRoot::ktemplate_literal_function_literal_id_symbol,
    StaticReadOnlyRoot::ktemplate_literal_slot_id_symbol,
    StaticReadOnlyRoot::kwasm_exception_tag_symbol,
    StaticReadOnlyRoot::kwasm_exception_values_symbol,
    StaticReadOnlyRoot::kwasm_uncatchable_symbol,
    StaticReadOnlyRoot::kwasm_wrapped_object_symbol,
    StaticReadOnlyRoot::kwasm_debug_proxy_cache_symbol,
    StaticReadOnlyRoot::kwasm_debug_proxy_names_symbol,
    StaticReadOnlyRoot::kasync_iterator_symbol,
    StaticReadOnlyRoot::kintl_fallback_symbol,
    StaticReadOnlyRoot::kmatch_symbol,
    StaticReadOnlyRoot::ksearch_symbol,
    StaticReadOnlyRoot::kto_primitive_symbol,
    StaticReadOnlyRoot::kunscopables_symbol,
    StaticReadOnlyRoot::khas_instance_symbol,
    StaticReadOnlyRoot::kto_string_tag_symbol,
    StaticReadOnlyRoot::kPromiseFulfillReactionJobTaskMap,
    StaticReadOnlyRoot::kPromiseRejectReactionJobTaskMap,
    StaticReadOnlyRoot::kCallableTaskMap,
    StaticReadOnlyRoot::kCallbackTaskMap,
    StaticReadOnlyRoot::kPromiseResolveThenableJobTaskMap,
    StaticReadOnlyRoot::kFunctionTemplateInfoMap,
    StaticReadOnlyRoot::kObjectTemplateInfoMap,
    StaticReadOnlyRoot::kAccessCheckInfoMap,
    StaticReadOnlyRoot::kAccessorPairMap,
    StaticReadOnlyRoot::kAliasedArgumentsEntryMap,
    StaticReadOnlyRoot::kAllocationMementoMap,
    StaticReadOnlyRoot::kArrayBoilerplateDescriptionMap,
    StaticReadOnlyRoot::kAsmWasmDataMap,
    StaticReadOnlyRoot::kAsyncGeneratorRequestMap,
    StaticReadOnlyRoot::kBreakPointMap,
    StaticReadOnlyRoot::kBreakPointInfoMap,
    StaticReadOnlyRoot::kBytecodeWrapperMap,
    StaticReadOnlyRoot::kCallSiteInfoMap,
    StaticReadOnlyRoot::kClassBoilerplateMap,
    StaticReadOnlyRoot::kClassPositionsMap,
    StaticReadOnlyRoot::kCodeWrapperMap,
    StaticReadOnlyRoot::kDebugInfoMap,
    StaticReadOnlyRoot::kEnumCacheMap,
    StaticReadOnlyRoot::kErrorStackDataMap,
    StaticReadOnlyRoot::kFunctionTemplateRareDataMap,
    StaticReadOnlyRoot::kInterceptorInfoMap,
    StaticReadOnlyRoot::kModuleRequestMap,
    StaticReadOnlyRoot::kPromiseCapabilityMap,
    StaticReadOnlyRoot::kPromiseOnStackMap,
    StaticReadOnlyRoot::kPromiseReactionMap,
    StaticReadOnlyRoot::kPropertyDescriptorObjectMap,
    StaticReadOnlyRoot::kPrototypeInfoMap,
    StaticReadOnlyRoot::kRegExpBoilerplateDescriptionMap,
    StaticReadOnlyRoot::kScriptMap,
    StaticReadOnlyRoot::kScriptOrModuleMap,
    StaticReadOnlyRoot::kSourceTextModuleInfoEntryMap,
    StaticReadOnlyRoot::kStackFrameInfoMap,
    StaticReadOnlyRoot::kTemplateObjectDescriptionMap,
    StaticReadOnlyRoot::kTuple2Map,
    StaticReadOnlyRoot::kWasmExceptionTagMap,
    StaticReadOnlyRoot::kWasmIndirectFunctionTableMap,
    StaticReadOnlyRoot::kSloppyArgumentsElementsMap,
    StaticReadOnlyRoot::kDescriptorArrayMap,
    StaticReadOnlyRoot::kStrongDescriptorArrayMap,
    StaticReadOnlyRoot::kUncompiledDataWithoutPreparseDataMap,
    StaticReadOnlyRoot::kUncompiledDataWithPreparseDataMap,
    StaticReadOnlyRoot::kUncompiledDataWithoutPreparseDataWithJobMap,
    StaticReadOnlyRoot::kUncompiledDataWithPreparseDataAndJobMap,
    StaticReadOnlyRoot::kOnHeapBasicBlockProfilerDataMap,
    StaticReadOnlyRoot::kTurbofanBitsetTypeMap,
    StaticReadOnlyRoot::kTurbofanUnionTypeMap,
    StaticReadOnlyRoot::kTurbofanRangeTypeMap,
    StaticReadOnlyRoot::kTurbofanHeapConstantTypeMap,
    StaticReadOnlyRoot::kTurbofanOtherNumberConstantTypeMap,
    StaticReadOnlyRoot::kTurboshaftWord32TypeMap,
    StaticReadOnlyRoot::kTurboshaftWord32RangeTypeMap,
    StaticReadOnlyRoot::kTurboshaftWord32SetTypeMap,
    StaticReadOnlyRoot::kTurboshaftWord64TypeMap,
    StaticReadOnlyRoot::kTurboshaftWord64RangeTypeMap,
    StaticReadOnlyRoot::kTurboshaftWord64SetTypeMap,
    StaticReadOnlyRoot::kTurboshaftFloat64TypeMap,
    StaticReadOnlyRoot::kTurboshaftFloat64RangeTypeMap,
    StaticReadOnlyRoot::kTurboshaftFloat64SetTypeMap,
    StaticReadOnlyRoot::kInternalClassMap,
    StaticReadOnlyRoot::kSmiPairMap,
    StaticReadOnlyRoot::kSmiBoxMap,
    StaticReadOnlyRoot::kExportedSubClassBaseMap,
    StaticReadOnlyRoot::kExportedSubClassMap,
    StaticReadOnlyRoot::kAbstractInternalClassSubclass1Map,
    StaticReadOnlyRoot::kAbstractInternalClassSubclass2Map,
    StaticReadOnlyRoot::kInternalClassWithStructElementsMap,
    StaticReadOnlyRoot::kExportedSubClass2Map,
    StaticReadOnlyRoot::kSortStateMap,
    StaticReadOnlyRoot::kWasmStringViewIterMap,
    StaticReadOnlyRoot::kAllocationSiteWithWeakNextMap,
    StaticReadOnlyRoot::kAllocationSiteWithoutWeakNextMap,
    StaticReadOnlyRoot::kconstructor_string,
    StaticReadOnlyRoot::knext_string,
    StaticReadOnlyRoot::kresolve_string,
    StaticReadOnlyRoot::kthen_string,
    StaticReadOnlyRoot::kiterator_symbol,
    StaticReadOnlyRoot::kmatch_all_symbol,
    StaticReadOnlyRoot::kreplace_symbol,
    StaticReadOnlyRoot::kspecies_symbol,
    StaticReadOnlyRoot::ksplit_symbol,
    StaticReadOnlyRoot::kis_concat_spreadable_symbol,
    StaticReadOnlyRoot::kLoadHandler1Map,
    StaticReadOnlyRoot::kLoadHandler2Map,
    StaticReadOnlyRoot::kLoadHandler3Map,
    StaticReadOnlyRoot::kStoreHandler0Map,
    StaticReadOnlyRoot::kStoreHandler1Map,
    StaticReadOnlyRoot::kStoreHandler2Map,
    StaticReadOnlyRoot::kStoreHandler3Map,
};

}  // namespace internal
}  // namespace v8
#endif  // V8_STATIC_ROOTS_BOOL
#endif  // V8_ROOTS_STATIC_ROOTS_H_
