//
// Created by 张雪明 <zhangxueming@uniontech.com> on 2023/9/28.
//

#ifndef UOS_RECOVERY_OSTREE_WORKER_THREAD_H
#define UOS_RECOVERY_OSTREE_WORKER_THREAD_H

#include <QThread>
#include <QtDBus/QDBusInterface>
#include "utils/global.h"

class OSTreeWorkerThread : public QThread {
    Q_OBJECT
public:
    explicit OSTreeWorkerThread(OperateType opType);
    virtual ~OSTreeWorkerThread();

    void run() override;
    void setRequest(const SystemRestoreRequest &request);

Q_SIGNALS:
    void StateChanged(int operate, int state, const QString &version, const QString &msg);
    void error(const QString &msg);
    void success(const QString &msg);

protected:
    void factoryRestore(const SystemRestoreRequest &request);

private Q_SLOTS:
    void onStateChanged(int operate, int state, const QString &version, const QString &msg);

protected:
    OperateType m_opType;
    QString m_operateID;
    SystemRestoreRequest m_request;
    QDBusInterface *m_atomicUpgradeInterface = nullptr;
};

#endif // UOS_RECOVERY_OSTREE_WORKER_THREAD_H
