//
// Created by 张雪明 <zhangxueming@uniontech.com> on 2024/12/4.
//

#ifndef UOS_RECOVERY_IMMUITEMFRAME_H
#define UOS_RECOVERY_IMMUITEMFRAME_H

#include <DWidget>
#include <DLabel>
#include <DFrame>
#include <DTipLabel>
#include <QHBoxLayout>
#include <DColoredProgressBar>
#include <QColor>
#include <QPushButton>
#include <QPixmap>

DTK_USE_NAMESPACE
DWIDGET_USE_NAMESPACE

class SpaceItemFrame : public DFrame {
    Q_OBJECT
public:
    explicit SpaceItemFrame(QWidget *parent = nullptr);

protected:
    void paintEvent(QPaintEvent *event) override;
};

class ImmuItemFrame : public DFrame
{
    Q_OBJECT
public:
    explicit ImmuItemFrame(const QString &title, const QString &titleDes, const QString &icon, QWidget *parent = nullptr);
    virtual ~ImmuItemFrame();
    virtual void initUI() = 0;
    virtual void initLayout() = 0;

    void setIconPixmap(const QString &iconRes, const QSize &iconSize);
    void setStoreText(const QString &text);
    void setStoreUsedValue(int value);

    void setItemFrameAccessibleName(const QString &name);
    void setTitleAccessibleName(const QString &name);
    void setTitleDesAccessibleName(const QString &name);
    void setIconAccessibleName(const QString &name);
    void updateTheme();

protected:
    DLabel *m_icon = nullptr;
    DLabel *m_title = nullptr;
    DTipLabel *m_titleDes = nullptr;
    Dtk::Widget::DColoredProgressBar *m_storeUsed;
    DTipLabel *m_storeText = nullptr;
    DLabel *m_usedLabelIcon = nullptr;
    DTipLabel *m_usedLabel = nullptr;
    DLabel *m_availableLabelIcon = nullptr;
    DTipLabel *m_availableLabel = nullptr;
    QHBoxLayout *m_mainHLayout = nullptr;
    QColor m_greenColor = QColor(35, 196, 108);
    QColor m_redColor = QColor(255, 69, 58);
    QPixmap m_greenPixmap;
    QPixmap m_grayPixmap;
    QPixmap m_grayDarkPixmap;
    QPixmap m_redPixmap;
    bool needUpdateUsedLabelIcon = false;
};

#endif //UOS_RECOVERY_IMMUITEMFRAME_H
