/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multiview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.multiview.Accessor;
import org.netbeans.core.multiview.ContextAwareDescription;
import org.netbeans.core.multiview.EmptyViewDescription;
import org.netbeans.core.multiview.GetLeftEditorAction;
import org.netbeans.core.multiview.GetRightEditorAction;
import org.netbeans.core.multiview.MultiViewActionMap;
import org.netbeans.core.multiview.MultiViewCloneableTopComponent;
import org.netbeans.core.multiview.MultiViewHandlerDelegate;
import org.netbeans.core.multiview.MultiViewModel;
import org.netbeans.core.multiview.MultiViewTopComponent;
import org.netbeans.core.multiview.MultiViewTopComponentLookup;
import org.netbeans.core.multiview.SpiAccessor;
import org.netbeans.core.multiview.Splitable;
import org.netbeans.core.multiview.TabsComponent;
import org.netbeans.core.spi.multiview.CloseOperationHandler;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.openide.awt.UndoRedo;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.util.WeakListeners;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;

public final class MultiViewPeer
implements PropertyChangeListener {
    static final String MULTIVIEW_ID = "MultiView-";
    private static final String TOOLBAR_VISIBLE_PROP = "toolbarVisible";
    private static final Preferences editorSettingsPreferences;
    private Lookup.Provider context;
    private String mimeType;
    MultiViewModel model;
    TabsComponent tabs;
    SelectionListener selListener;
    CloseOperationHandler closeHandler;
    transient MultiViewTopComponentLookup lookup;
    TopComponent peer;
    private MultiViewModel.ActionRequestObserverFactory factory;
    private MultiViewActionMap delegatingMap;
    private boolean activated = false;
    private final PreferenceChangeListener editorSettingsListener = new PreferenceChangeListenerImpl();
    private final PropertyChangeListener propListener;
    private DelegateUndoRedo delegateUndoRedo;
    private int splitOrientation = -1;
    private int initialSplitOrientation = -1;
    private MultiViewDescription initialSplitDescription;

    MultiViewPeer(TopComponent topComponent, MultiViewModel.ActionRequestObserverFactory actionRequestObserverFactory) {
        this.selListener = new SelectionListener();
        this.peer = topComponent;
        this.factory = actionRequestObserverFactory;
        this.delegateUndoRedo = new DelegateUndoRedo();
        this.propListener = WeakListeners.propertyChange((PropertyChangeListener)this, null);
    }

    void copyMimeContext(MultiViewPeer multiViewPeer) {
        this.context = multiViewPeer.context;
        this.mimeType = multiViewPeer.mimeType;
    }

    public void setMimeLookup(String string, Lookup.Provider provider) {
        this.context = provider;
        this.mimeType = string;
        ArrayList<MultiViewDescription> arrayList = new ArrayList<MultiViewDescription>();
        Lookup lookup = MimeLookup.getLookup((String)string);
        for (ContextAwareDescription contextAwareDescription : lookup.lookupAll(ContextAwareDescription.class)) {
            contextAwareDescription = contextAwareDescription.createContextAwareDescription(provider.getLookup(), false);
            arrayList.add(contextAwareDescription);
            contextAwareDescription = contextAwareDescription.createContextAwareDescription(provider.getLookup(), true);
            arrayList.add(contextAwareDescription);
        }
        if (arrayList.isEmpty()) {
            arrayList.add(new EmptyViewDescription(string));
        }
        if (this.model != null) {
            this.model.removeElementSelectionListener(this.selListener);
        }
        this.model = new MultiViewModel(arrayList.toArray(new MultiViewDescription[0]), (MultiViewDescription)arrayList.get(0), this.factory);
        this.model.addElementSelectionListener(this.selListener);
        this.tabs.setModel(this.model);
        Object object = (CloseOperationHandler)lookup.lookup(CloseOperationHandler.class);
        if (object == null) {
            object = SpiAccessor.DEFAULT.createDefaultCloseHandler();
        }
        this.closeHandler = object;
    }

    public void setMultiViewDescriptions(MultiViewDescription[] multiViewDescriptionArray, MultiViewDescription multiViewDescription) {
        assert (this.context == null);
        this._setMultiViewDescriptions(multiViewDescriptionArray, multiViewDescription);
    }

    private void _setMultiViewDescriptions(MultiViewDescription[] multiViewDescriptionArray, MultiViewDescription multiViewDescription) {
        Map<MultiViewDescription, MultiViewElement> map = Collections.emptyMap();
        if (this.model != null) {
            this.model.removeElementSelectionListener(this.selListener);
            map = this.model.getCreatedElementsMap();
        }
        this.model = new MultiViewModel(multiViewDescriptionArray, multiViewDescription, this.factory, map);
        this.model.addElementSelectionListener(this.selListener);
        this.tabs.setModel(this.model);
    }

    public void setCloseOperationHandler(CloseOperationHandler closeOperationHandler) {
        assert (this.context == null);
        this.closeHandler = closeOperationHandler;
    }

    void setDeserializedMultiViewDescriptions(int n, MultiViewDescription[] multiViewDescriptionArray, MultiViewDescription multiViewDescription, MultiViewDescription multiViewDescription2, Map<MultiViewDescription, MultiViewElement> map) {
        if (this.model != null) {
            this.model.removeElementSelectionListener(this.selListener);
        }
        if (n != -1) {
            multiViewDescription2 = multiViewDescription2.getDisplayName().startsWith("&Design") ? multiViewDescriptionArray[1] : multiViewDescription2;
        }
        this.model = new MultiViewModel(multiViewDescriptionArray, multiViewDescription, this.factory, map);
        this.model.addElementSelectionListener(this.selListener);
        this.tabs.setModel(this.model);
        this.initialSplitOrientation = n;
        this.initialSplitDescription = multiViewDescription2;
    }

    MultiViewModel getModel() {
        return this.model;
    }

    void initComponents() {
        this.initActionMap();
        this.peer.setLayout((LayoutManager)new BorderLayout());
        this.tabs = new TabsComponent(this.isToolbarVisible());
        this.peer.add((Component)this.tabs);
        ActionMap actionMap = this.peer.getActionMap();
        AccessTogglesAction accessTogglesAction = new AccessTogglesAction();
        actionMap.put("NextViewAction", new GetRightEditorAction());
        actionMap.put("PreviousViewAction", new GetLeftEditorAction());
        actionMap.put("accesstoggles", accessTogglesAction);
        InputMap inputMap = this.peer.getInputMap(1);
        KeyStroke keyStroke = KeyStroke.getKeyStroke("control F10");
        inputMap.put(keyStroke, "accesstoggles");
        inputMap = this.peer.getInputMap(0);
        inputMap.put(keyStroke, "accesstoggles");
        this.peer.putClientProperty((Object)"MultiViewBorderHack.topOffset", (Object)new Integer(this.tabs.getPreferredSize().height - 1));
    }

    private void assignLookup(MultiViewElement multiViewElement, MultiViewTopComponentLookup multiViewTopComponentLookup) {
        Lookup lookup = multiViewElement.getLookup();
        assert (null != lookup) : "Null lookup from " + multiViewElement;
        multiViewTopComponentLookup.setElementLookup(lookup);
    }

    private void assignLookup(MultiViewElement multiViewElement) {
        this.assignLookup(multiViewElement, (MultiViewTopComponentLookup)this.peer.getLookup());
    }

    final void assignLookup(MultiViewTopComponentLookup multiViewTopComponentLookup) {
        if (multiViewTopComponentLookup.isInitialized()) {
            return;
        }
        MultiViewElement multiViewElement = this.getModel().getActiveElement();
        if (multiViewElement != null) {
            this.assignLookup(multiViewElement, multiViewTopComponentLookup);
        }
    }

    private void initActionMap() {
        this.delegatingMap = new MultiViewActionMap(this.peer, new ActionMap());
        if (this.peer instanceof TopComponent.Cloneable) {
            this.delegatingMap.put("cloneWindow", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TopComponent topComponent = ((TopComponent.Cloneable)MultiViewPeer.this.peer).cloneComponent();
                    topComponent.open();
                    topComponent.requestActive();
                }
            });
        }
        if (this.peer instanceof MultiViewTopComponent || this.peer instanceof MultiViewCloneableTopComponent) {
            this.delegatingMap.put("splitWindowHorizantally", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MultiViewPeer.this.peer instanceof Splitable) {
                        TopComponent topComponent = ((Splitable)MultiViewPeer.this.peer).splitComponent(1, -1);
                        topComponent.open();
                        topComponent.requestActive();
                    }
                }
            });
            this.delegatingMap.put("splitWindowVertically", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MultiViewPeer.this.peer instanceof Splitable) {
                        TopComponent topComponent = ((Splitable)MultiViewPeer.this.peer).splitComponent(0, -1);
                        topComponent.open();
                        topComponent.requestActive();
                    }
                }
            });
            this.delegatingMap.put("clearSplit", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MultiViewPeer.this.peer instanceof Splitable) {
                        TopComponent topComponent = ((Splitable)MultiViewPeer.this.peer).clearSplit(-1);
                        topComponent.open();
                        topComponent.requestActive();
                    }
                }
            });
        }
        this.delegatingMap.put("closeWindow", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultiViewPeer.this.peer.close();
            }
        });
        this.peer.setActionMap((ActionMap)this.delegatingMap);
    }

    void peerComponentClosed() {
        for (MultiViewElement multiViewElement : this.model.getCreatedElements()) {
            this.model.markAsHidden(multiViewElement);
            multiViewElement.componentClosed();
        }
        this.tabs.peerComponentClosed();
    }

    void peerComponentShowing() {
        MultiViewElement multiViewElement = this.model.getActiveElement();
        multiViewElement.componentShowing();
        this.delegatingMap.setDelegateMap(multiViewElement.getVisualRepresentation().getActionMap());
        this.assignLookup(multiViewElement);
        JComponent jComponent = multiViewElement.getToolbarRepresentation();
        assert (jComponent != null) : "MultiViewElement " + multiViewElement.getClass() + " returns null as toolbar component.";
        jComponent.setOpaque(false);
        boolean bl = false;
        MultiViewDescription multiViewDescription = this.model.getActiveDescription();
        if (multiViewDescription instanceof ContextAwareDescription) {
            bl = ((ContextAwareDescription)multiViewDescription).isSplitDescription();
        }
        this.tabs.setInnerToolBar(jComponent, bl);
        this.tabs.setToolbarBarVisible(this.isToolbarVisible());
        if (editorSettingsPreferences != null) {
            editorSettingsPreferences.addPreferenceChangeListener(this.editorSettingsListener);
        }
        if (this.initialSplitOrientation != -1) {
            this.splitOrientation = this.initialSplitOrientation;
            this.tabs.peerSplitComponent(this.splitOrientation, this, this.getModel().getActiveDescription(), this.initialSplitDescription, -1);
            this.initialSplitDescription = null;
            this.initialSplitOrientation = -1;
        }
    }

    void peerComponentHidden() {
        this.model.getActiveElement().componentHidden();
        if (editorSettingsPreferences != null) {
            editorSettingsPreferences.removePreferenceChangeListener(this.editorSettingsListener);
        }
    }

    void peerComponentDeactivated() {
        this.activated = false;
        this.model.getActiveElement().componentDeactivated();
    }

    boolean isActivated() {
        return this.activated;
    }

    void peerComponentActivated() {
        this.activated = true;
        this.model.getActiveElement().componentActivated();
    }

    void peerComponentOpened() {
        this.showCurrentElement(true);
        this.tabs.setToolbarBarVisible(this.isToolbarVisible());
        this.addPropertyChangeListeners();
    }

    private void addPropertyChangeListeners() {
        if (null != this.model) {
            for (MultiViewDescription multiViewDescription : this.model.getDescriptions()) {
                CloneableEditorSupport.Pane pane;
                CloneableTopComponent cloneableTopComponent;
                MultiViewElement multiViewElement;
                if (multiViewDescription instanceof ContextAwareDescription && ((ContextAwareDescription)multiViewDescription).isSplitDescription() || (multiViewElement = this.model.getElementForDescription(multiViewDescription, false)) == null || !(multiViewElement.getVisualRepresentation() instanceof CloneableEditorSupport.Pane) || Arrays.asList((cloneableTopComponent = (pane = (CloneableEditorSupport.Pane)multiViewElement.getVisualRepresentation()).getComponent()).getPropertyChangeListeners()).contains(this.propListener)) continue;
                cloneableTopComponent.addPropertyChangeListener(this.propListener);
            }
        }
    }

    void peerSplitComponent(int n, int n2) {
        this.splitOrientation = n;
        this.tabs.peerSplitComponent(n, this, null, null, n2);
    }

    void peerClearSplit(int n) {
        this.tabs.peerClearSplit(n);
        this.showCurrentElement();
        this.model.fireActivateCurrent();
        this.splitOrientation = -1;
    }

    int getSplitOrientation() {
        return this.splitOrientation;
    }

    boolean requestFocusInWindow() {
        if (this.model == null) {
            return false;
        }
        return this.model.getActiveElement().getVisualRepresentation().requestFocusInWindow();
    }

    void requestFocus() {
        if (this.model != null) {
            this.model.getActiveElement().getVisualRepresentation().requestFocus();
        }
    }

    void hideElement(MultiViewDescription multiViewDescription) {
        if (multiViewDescription != null && this.splitOrientation != -1) {
            MultiViewDescription multiViewDescription2 = this.tabs.getTopComponentDescription();
            MultiViewDescription multiViewDescription3 = this.tabs.getBottomComponentDescription();
            if (!(!this.tabs.isHiddenTriggeredByMultiViewButton() || multiViewDescription2.getDisplayName().equals(multiViewDescription.getDisplayName()) && multiViewDescription3.getDisplayName().equals(multiViewDescription.getDisplayName()))) {
                MultiViewElement multiViewElement = this.model.getElementForDescription(multiViewDescription);
                multiViewElement.componentHidden();
            }
            return;
        }
        if (multiViewDescription != null) {
            MultiViewElement multiViewElement = this.model.getElementForDescription(multiViewDescription);
            multiViewElement.componentHidden();
        }
    }

    void showCurrentElement() {
        this.showCurrentElement(false);
    }

    private void showCurrentElement(boolean bl) {
        MultiViewElement multiViewElement = this.model.getActiveElement();
        MultiViewDescription multiViewDescription = this.model.getActiveDescription();
        boolean bl2 = false;
        if (multiViewDescription instanceof ContextAwareDescription) {
            bl2 = ((ContextAwareDescription)multiViewDescription).isSplitDescription();
        }
        this.tabs.switchToCard(multiViewElement, multiViewDescription.getDisplayName(), bl2);
        if (null == this.peer.getIcon()) {
            MultiViewDescription[] multiViewDescriptionArray;
            Image image = multiViewDescription.getIcon();
            if (null == image && null != (multiViewDescriptionArray = this.model.getDescriptions()) && multiViewDescriptionArray.length > 0) {
                image = multiViewDescriptionArray[0].getIcon();
            }
            this.peer.setIcon(image);
        }
        if ((this.peer.isOpened() || bl) && !this.model.wasShownBefore(multiViewElement)) {
            multiViewElement.componentOpened();
            this.model.markAsShown(multiViewElement);
        }
        if (!bl) {
            if (this.peer.isVisible()) {
                multiViewElement.componentShowing();
            }
            this.delegatingMap.setDelegateMap(multiViewElement.getVisualRepresentation().getActionMap());
            this.assignLookup(multiViewElement);
            if (this.peer.isVisible()) {
                this.tabs.setInnerToolBar(multiViewElement.getToolbarRepresentation(), bl2);
                this.tabs.setToolbarBarVisible(this.isToolbarVisible());
            }
        }
    }

    Action[] peerGetActions(Action[] actionArray) {
        Action[] actionArray2 = this.model.getActiveElement().getActions();
        Action[] actionArray3 = new Action[actionArray.length];
        System.arraycopy(actionArray, 0, actionArray3, 0, actionArray.length);
        block0: for (int i = 0; i < actionArray2.length; ++i) {
            Action action = actionArray2[i];
            for (int j = 0; j < actionArray3.length; ++j) {
                Action action2 = actionArray3[j];
                if (action == null && action2 == null) continue block0;
                if (action2 == null || action == null || !action2.getClass().equals(action.getClass())) continue;
                actionArray2[i] = actionArray3[j];
                actionArray3[j] = null;
                continue block0;
            }
        }
        return actionArray2;
    }

    MultiViewHandlerDelegate getMultiViewHandlerDelegate() {
        return new MVTCHandler();
    }

    int getPersistenceType() {
        int n = 2;
        if (null != this.model) {
            MultiViewDescription[] multiViewDescriptionArray = this.model.getDescriptions();
            for (int i = 0; i < multiViewDescriptionArray.length; ++i) {
                if (this.context == null && !(multiViewDescriptionArray[i] instanceof Serializable)) {
                    Logger.getLogger(MultiViewTopComponent.class.getName()).warning("The MultiviewDescription instance " + multiViewDescriptionArray[i].getClass() + " is not serializable. Cannot persist TopComponent.");
                    n = 2;
                    break;
                }
                if (multiViewDescriptionArray[i].getPersistenceType() == 0) {
                    n = multiViewDescriptionArray[i].getPersistenceType();
                }
                if (multiViewDescriptionArray[i].getPersistenceType() != 1 || n == 0) continue;
                n = multiViewDescriptionArray[i].getPersistenceType();
            }
        }
        return n;
    }

    String preferredID() {
        StringBuffer stringBuffer = new StringBuffer(MULTIVIEW_ID);
        assert (this.model != null) : "Multiview Model not set, error on deserialization of client code. Please add comment to issue #121119 at netbeans.org and attach the ~/.netbeans/var/log/messages.log file";
        MultiViewDescription[] multiViewDescriptionArray = this.model.getDescriptions();
        for (int i = 0; i < multiViewDescriptionArray.length; ++i) {
            stringBuffer.append(multiViewDescriptionArray[i].preferredID());
            stringBuffer.append("|");
        }
        return stringBuffer.toString();
    }

    void peerWriteExternal(ObjectOutput objectOutput) throws IOException {
        boolean bl;
        if (this.context != null) {
            objectOutput.writeObject(this.mimeType);
            objectOutput.writeObject(this.context);
            bl = true;
        } else {
            if (this.closeHandler != null) {
                if (this.closeHandler instanceof Serializable) {
                    objectOutput.writeObject(this.closeHandler);
                } else {
                    Logger.getAnonymousLogger().info("The CloseOperationHandler isn not serializable. MultiView component id=" + this.preferredID());
                }
            }
            bl = false;
        }
        MultiViewDescription[] multiViewDescriptionArray = this.model.getDescriptions();
        MultiViewDescription multiViewDescription = this.tabs.getTopComponentDescription();
        MultiViewDescription multiViewDescription2 = this.tabs.getBottomComponentDescription();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < multiViewDescriptionArray.length; ++i) {
            MultiViewElement multiViewElement;
            if (multiViewDescriptionArray[i] instanceof RuntimeMultiViewDescription) continue;
            if (!bl) {
                objectOutput.writeObject(multiViewDescriptionArray[i]);
            } else {
                objectOutput.writeObject(multiViewDescriptionArray[i].preferredID());
            }
            if (multiViewDescriptionArray[i].getPersistenceType() != 2 && (multiViewElement = this.model.getElementForDescription(multiViewDescriptionArray[i], false)) instanceof Serializable) {
                objectOutput.writeObject(multiViewElement);
            }
            if (multiViewDescriptionArray[i] == multiViewDescription) {
                n = i;
            }
            if (multiViewDescriptionArray[i] != multiViewDescription2) continue;
            n2 = i;
        }
        objectOutput.writeObject(new Integer(n));
        objectOutput.writeObject(new Integer(n2));
        objectOutput.writeObject(new Integer(this.splitOrientation));
        String string = this.peer.getHtmlDisplayName();
        if (null != string) {
            objectOutput.writeObject(string);
        }
    }

    void peerReadExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        MultiViewDescription multiViewDescription;
        ArrayList<MultiViewDescription> arrayList = new ArrayList<MultiViewDescription>();
        HashMap<MultiViewDescription, MultiViewElement> hashMap = new HashMap<MultiViewDescription, MultiViewElement>();
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        CloseOperationHandler closeOperationHandler = null;
        try {
            Object object;
            Object object2;
            int n4 = 0;
            int n5 = 0;
            multiViewDescription = null;
            while (true) {
                if ((object2 = objectInput.readObject()) instanceof String && n4++ == 0) {
                    object = (Lookup.Provider)objectInput.readObject();
                    this.setMimeLookup((String)object2, (Lookup.Provider)object);
                    arrayList.addAll(Arrays.asList(this.model.getDescriptions()));
                    continue;
                }
                if (object2 instanceof MultiViewDescription) {
                    multiViewDescription = (MultiViewDescription)object2;
                    arrayList.add(multiViewDescription);
                } else if (object2 instanceof String) {
                    boolean bl = false;
                    for (MultiViewDescription multiViewDescription2 : arrayList) {
                        if (!multiViewDescription2.preferredID().equals(object2)) continue;
                        multiViewDescription = multiViewDescription2;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        throw new IOException("Cannot find multiview description for id \"" + object2 + "\". Maybe some module(s) is not installed or activated.");
                    }
                } else if (object2 instanceof MultiViewElement) {
                    assert (multiViewDescription != null);
                    hashMap.put(multiViewDescription, (MultiViewElement)object2);
                    multiViewDescription = null;
                } else if (object2 instanceof Integer) {
                    object = (Integer)object2;
                    if (n5 == 0) {
                        ++n5;
                        n = (Integer)object;
                    } else if (n5 == 1) {
                        ++n5;
                        n2 = (Integer)object;
                    } else if (n5 == 2) break;
                }
                if (!(object2 instanceof CloseOperationHandler)) continue;
                closeOperationHandler = (CloseOperationHandler)object2;
            }
            n3 = (Integer)object;
            try {
                object2 = objectInput.readObject();
                if (object2 instanceof String) {
                    this.peer.setHtmlDisplayName((String)object2);
                }
            }
            catch (OptionalDataException optionalDataException) {
                if (!optionalDataException.eof) {
                    throw optionalDataException;
                }
            }
        }
        catch (IOException iOException) {
            if (this.context == null) {
                if (closeOperationHandler == null) {
                    closeOperationHandler = SpiAccessor.DEFAULT.createDefaultCloseHandler();
                }
                this.setCloseOperationHandler(closeOperationHandler);
            }
            if (arrayList.size() > 0) {
                MultiViewDescription[] multiViewDescriptionArray = new MultiViewDescription[arrayList.size()];
                multiViewDescriptionArray = arrayList.toArray(multiViewDescriptionArray);
                MultiViewDescription multiViewDescription3 = multiViewDescriptionArray[0];
                MultiViewDescription multiViewDescription4 = multiViewDescriptionArray[1];
                hashMap.clear();
                this.setDeserializedMultiViewDescriptions(1, multiViewDescriptionArray, multiViewDescription3, multiViewDescription4, hashMap);
            }
            throw iOException;
        }
        if (this.context == null) {
            if (closeOperationHandler == null) {
                closeOperationHandler = SpiAccessor.DEFAULT.createDefaultCloseHandler();
            }
            this.setCloseOperationHandler(closeOperationHandler);
        }
        MultiViewDescription[] multiViewDescriptionArray = new MultiViewDescription[arrayList.size()];
        multiViewDescriptionArray = arrayList.toArray(multiViewDescriptionArray);
        MultiViewDescription multiViewDescription5 = multiViewDescriptionArray[n];
        multiViewDescription = multiViewDescriptionArray[n2];
        this.setDeserializedMultiViewDescriptions(n3, multiViewDescriptionArray, multiViewDescription5, multiViewDescription, hashMap);
    }

    private Action[] getDefaultTCActions() {
        if (this.peer instanceof MultiViewTopComponent) {
            return ((MultiViewTopComponent)this.peer).getDefaultTCActions();
        }
        return new Action[0];
    }

    JEditorPane getEditorPane() {
        MultiViewElement multiViewElement;
        if (this.model != null && (multiViewElement = this.model.getActiveElement()) != null && multiViewElement.getVisualRepresentation() instanceof CloneableEditorSupport.Pane) {
            CloneableEditorSupport.Pane pane = (CloneableEditorSupport.Pane)multiViewElement.getVisualRepresentation();
            return pane.getEditorPane();
        }
        return null;
    }

    HelpCtx getHelpCtx() {
        return this.model.getActiveDescription().getHelpCtx();
    }

    UndoRedo peerGetUndoRedo() {
        return this.delegateUndoRedo;
    }

    private UndoRedo privateGetUndoRedo() {
        return this.model.getActiveElement().getUndoRedo() != null ? this.model.getActiveElement().getUndoRedo() : UndoRedo.NONE;
    }

    boolean canClose() {
        CloseOperationState[] closeOperationStateArray;
        Collection collection = this.model.getCreatedElements();
        Iterator iterator = collection.iterator();
        ArrayList<CloseOperationState> arrayList = new ArrayList<CloseOperationState>();
        while (iterator.hasNext()) {
            closeOperationStateArray = (CloseOperationState[])iterator.next();
            CloseOperationState closeOperationState = closeOperationStateArray.canCloseElement();
            if (closeOperationState.canClose()) continue;
            arrayList.add(closeOperationState);
        }
        if (arrayList.size() > 0) {
            closeOperationStateArray = new CloseOperationState[arrayList.size()];
            boolean bl = this.closeHandler.resolveCloseOperation(closeOperationStateArray = arrayList.toArray(closeOperationStateArray));
            if (bl && SpiAccessor.DEFAULT.shouldCheckCanCloseAgain(this.closeHandler)) {
                collection = this.model.getCreatedElements();
                for (MultiViewElement multiViewElement : collection) {
                    CloseOperationState closeOperationState = multiViewElement.canCloseElement();
                    if (closeOperationState.canClose()) continue;
                    bl = false;
                    break;
                }
            }
            return bl;
        }
        return true;
    }

    public void updateName() {
        if (this.model != null) {
            for (MultiViewDescription multiViewDescription : this.model.getDescriptions()) {
                MultiViewElement multiViewElement;
                if (multiViewDescription instanceof ContextAwareDescription && ((ContextAwareDescription)multiViewDescription).isSplitDescription() || (multiViewElement = this.model.getElementForDescription(multiViewDescription, MultiViewCloneableTopComponent.isSourceView(multiViewDescription))) == null || !(multiViewElement.getVisualRepresentation() instanceof CloneableEditorSupport.Pane)) continue;
                CloneableEditorSupport.Pane pane = (CloneableEditorSupport.Pane)multiViewElement.getVisualRepresentation();
                pane.updateName();
                CloneableTopComponent cloneableTopComponent = pane.getComponent();
                this.peer.setDisplayName(cloneableTopComponent.getDisplayName());
                this.peer.setIcon(cloneableTopComponent.getIcon());
                if (Arrays.asList(cloneableTopComponent.getPropertyChangeListeners()).contains(this.propListener)) continue;
                cloneableTopComponent.addPropertyChangeListener(this.propListener);
            }
        }
    }

    public Lookup getLookup() {
        if (this.lookup == null) {
            this.lookup = new MultiViewTopComponentLookup(this.delegatingMap);
        }
        return this.lookup;
    }

    private boolean isToolbarVisible() {
        return editorSettingsPreferences == null || editorSettingsPreferences.getBoolean(TOOLBAR_VISIBLE_PROP, true);
    }

    public String toString() {
        return "[model=" + this.model + "]";
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("icon".equals(propertyChangeEvent.getPropertyName()) || "name".equals(propertyChangeEvent.getPropertyName()) || "displayName".equals(propertyChangeEvent.getPropertyName()) || "htmlDisplayName".equals(propertyChangeEvent.getPropertyName())) {
            this.updateName();
        }
    }

    static {
        String string;
        Preferences preferences = (Preferences)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(Preferences.class);
        if (preferences == null && (string = System.getProperty("test.multiview.toolbar.settings")) != null) {
            preferences = NbPreferences.root().node(string);
        }
        editorSettingsPreferences = preferences;
    }

    private class PreferenceChangeListenerImpl
    implements PreferenceChangeListener,
    Runnable {
        @Override
        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            if (MultiViewPeer.TOOLBAR_VISIBLE_PROP.equals(preferenceChangeEvent.getKey())) {
                EventQueue.invokeLater(this);
            }
        }

        @Override
        public void run() {
            MultiViewPeer.this.tabs.setToolbarBarVisible(MultiViewPeer.this.isToolbarVisible());
        }
    }

    private class DelegateUndoRedo
    implements UndoRedo {
        private List<ChangeListener> listeners = new ArrayList<ChangeListener>();

        private DelegateUndoRedo() {
        }

        public boolean canUndo() {
            return MultiViewPeer.this.privateGetUndoRedo().canUndo();
        }

        public boolean canRedo() {
            return MultiViewPeer.this.privateGetUndoRedo().canRedo();
        }

        public void undo() throws CannotUndoException {
            MultiViewPeer.this.privateGetUndoRedo().undo();
        }

        public void redo() throws CannotRedoException {
            MultiViewPeer.this.privateGetUndoRedo().redo();
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.listeners.add(changeListener);
            MultiViewPeer.this.privateGetUndoRedo().addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.listeners.remove(changeListener);
            MultiViewPeer.this.privateGetUndoRedo().removeChangeListener(changeListener);
        }

        public String getUndoPresentationName() {
            return MultiViewPeer.this.privateGetUndoRedo().getUndoPresentationName();
        }

        public String getRedoPresentationName() {
            return MultiViewPeer.this.privateGetUndoRedo().getRedoPresentationName();
        }

        private void fireElementChange() {
            for (ChangeListener changeListener : new ArrayList<ChangeListener>(this.listeners)) {
                ChangeEvent changeEvent = new ChangeEvent(this);
                changeListener.stateChanged(changeEvent);
            }
        }

        void updateListeners(MultiViewElement multiViewElement, MultiViewElement multiViewElement2) {
            for (ChangeListener changeListener : this.listeners) {
                if (multiViewElement.getUndoRedo() != null) {
                    multiViewElement.getUndoRedo().removeChangeListener(changeListener);
                }
                if (multiViewElement2.getUndoRedo() == null) continue;
                multiViewElement2.getUndoRedo().addChangeListener(changeListener);
            }
            this.fireElementChange();
        }
    }

    private class AccessTogglesAction
    extends AbstractAction {
        AccessTogglesAction() {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control F10"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MultiViewPeer.this.tabs.requestFocusForSelectedButton();
        }
    }

    private static class RuntimeMultiViewDescription
    implements ContextAwareDescription {
        private final MultiViewDescription delegate;
        private final boolean split;

        public RuntimeMultiViewDescription(MultiViewDescription multiViewDescription, boolean bl) {
            this.delegate = multiViewDescription;
            this.split = bl;
        }

        @Override
        public ContextAwareDescription createContextAwareDescription(Lookup lookup, boolean bl) {
            return new RuntimeMultiViewDescription(this.delegate, bl);
        }

        @Override
        public boolean isSplitDescription() {
            return this.split;
        }

        @Override
        public int getPersistenceType() {
            return this.delegate.getPersistenceType();
        }

        @Override
        public String getDisplayName() {
            return this.delegate.getDisplayName();
        }

        @Override
        public Image getIcon() {
            return this.delegate.getIcon();
        }

        @Override
        public HelpCtx getHelpCtx() {
            return this.delegate.getHelpCtx();
        }

        @Override
        public String preferredID() {
            return this.delegate.preferredID();
        }

        @Override
        public MultiViewElement createElement() {
            return this.delegate.createElement();
        }
    }

    private class MVTCHandler
    implements MultiViewHandlerDelegate {
        private MultiViewPerspective[] perspectives = null;

        private MVTCHandler() {
        }

        @Override
        public MultiViewPerspective[] getDescriptions() {
            return MultiViewPeer.this.model.getPerspectives();
        }

        @Override
        public MultiViewPerspective getSelectedDescription() {
            return MultiViewPeer.this.model.getSelectedPerspective();
        }

        @Override
        public void requestActive(MultiViewPerspective multiViewPerspective) {
            MultiViewDescription multiViewDescription = Accessor.DEFAULT.extractDescription(multiViewPerspective);
            if (MultiViewPeer.this.model.getActiveDescription() != multiViewDescription) {
                MultiViewPeer.this.tabs.changeActiveManually(multiViewDescription);
                MultiViewPeer.this.model.getActiveElement().componentActivated();
            }
        }

        @Override
        public void requestVisible(MultiViewPerspective multiViewPerspective) {
            MultiViewDescription multiViewDescription = Accessor.DEFAULT.extractDescription(multiViewPerspective);
            MultiViewPeer.this.tabs.changeVisibleManually(multiViewDescription);
        }

        @Override
        public void addMultiViewDescription(MultiViewDescription multiViewDescription, int n) {
            if (-1 != MultiViewPeer.this.splitOrientation) {
                MultiViewPeer.this.peerClearSplit(0);
            }
            MultiViewDescription[] multiViewDescriptionArray = MultiViewPeer.this.model.getDescriptions();
            if (n < 0 || n >= multiViewDescriptionArray.length / 2) {
                n = multiViewDescriptionArray.length / 2;
            }
            RuntimeMultiViewDescription runtimeMultiViewDescription = new RuntimeMultiViewDescription(multiViewDescription, false);
            RuntimeMultiViewDescription runtimeMultiViewDescription2 = new RuntimeMultiViewDescription(multiViewDescription, true);
            MultiViewDescription[] multiViewDescriptionArray2 = new MultiViewDescription[multiViewDescriptionArray.length + 2];
            int n2 = 0;
            for (int i = 0; i < multiViewDescriptionArray2.length / 2; ++i) {
                if (i == n) {
                    multiViewDescriptionArray2[2 * i] = runtimeMultiViewDescription;
                    multiViewDescriptionArray2[2 * i + 1] = runtimeMultiViewDescription2;
                    continue;
                }
                multiViewDescriptionArray2[2 * i] = multiViewDescriptionArray[n2++];
                multiViewDescriptionArray2[2 * i + 1] = multiViewDescriptionArray[n2++];
            }
            MultiViewPeer.this._setMultiViewDescriptions(multiViewDescriptionArray2, null);
            MultiViewPeer.this.tabs.changeActiveManually(runtimeMultiViewDescription);
        }

        @Override
        public void removeMultiViewDescription(MultiViewDescription multiViewDescription) {
            MultiViewDescription[] multiViewDescriptionArray = MultiViewPeer.this.model.getDescriptions();
            int n = -1;
            for (int i = 0; i < multiViewDescriptionArray.length / 2; ++i) {
                RuntimeMultiViewDescription runtimeMultiViewDescription;
                if (!(multiViewDescriptionArray[2 * i] instanceof RuntimeMultiViewDescription) || !(runtimeMultiViewDescription = (RuntimeMultiViewDescription)multiViewDescriptionArray[2 * i]).delegate.equals(multiViewDescription)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                return;
            }
            if (-1 != MultiViewPeer.this.splitOrientation) {
                MultiViewPeer.this.peerClearSplit(0);
            }
            MultiViewDescription[] multiViewDescriptionArray2 = new MultiViewDescription[multiViewDescriptionArray.length - 2];
            int n2 = 0;
            for (int i = 0; i < multiViewDescriptionArray.length / 2; ++i) {
                if (i == n) continue;
                multiViewDescriptionArray2[n2++] = multiViewDescriptionArray[2 * i];
                multiViewDescriptionArray2[n2++] = multiViewDescriptionArray[2 * i + 1];
            }
            MultiViewPeer.this._setMultiViewDescriptions(multiViewDescriptionArray2, null);
            MultiViewPeer.this.tabs.changeActiveManually(multiViewDescriptionArray2[0]);
            MultiViewPeer.this.model.setActiveDescription(multiViewDescriptionArray2[0]);
            MultiViewPeer.this.showCurrentElement();
        }
    }

    private class SelectionListener
    implements MultiViewModel.ElementSelectionListener {
        private SelectionListener() {
        }

        @Override
        public void selectionChanged(MultiViewDescription multiViewDescription, MultiViewDescription multiViewDescription2) {
            if (MultiViewPeer.this.isActivated()) {
                MultiViewElement multiViewElement = MultiViewPeer.this.model.getElementForDescription(multiViewDescription);
                multiViewElement.componentDeactivated();
            }
            MultiViewPeer.this.hideElement(multiViewDescription);
            MultiViewPeer.this.showCurrentElement();
            MultiViewPeer.this.delegateUndoRedo.updateListeners(MultiViewPeer.this.model.getElementForDescription(multiViewDescription), MultiViewPeer.this.model.getElementForDescription(multiViewDescription2));
        }

        @Override
        public void selectionActivatedByButton() {
            MultiViewElement multiViewElement = MultiViewPeer.this.model.getActiveElement();
            multiViewElement.getVisualRepresentation().requestFocus();
            multiViewElement.componentActivated();
        }
    }
}

