/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.net.openssl.OpenSSLStatus;
import org.apache.tomcat.util.res.StringManager;

public class OpenSSLLifecycleListener
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(OpenSSLLifecycleListener.class);
    protected static final StringManager sm = StringManager.getManager(OpenSSLLifecycleListener.class);
    protected static final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAvailable() {
        if (OpenSSLStatus.isInstanceCreated()) {
            Object object = lock;
            synchronized (object) {
                if (!JreCompat.isJre22Available()) {
                    OpenSSLStatus.setInitialized((boolean)true);
                } else {
                    try {
                        Class<?> clazz = Class.forName("org.apache.tomcat.util.net.openssl.panama.OpenSSLLibrary");
                        clazz.getMethod("init", new Class[0]).invoke(null, new Object[0]);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable);
                        ExceptionUtils.handleThrowable((Throwable)throwable2);
                        log.error((Object)sm.getString("openssllistener.sslInit"), throwable2);
                    }
                }
            }
        }
        return OpenSSLStatus.isAvailable();
    }

    public OpenSSLLifecycleListener() {
        OpenSSLStatus.setInstanceCreated((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        Throwable throwable;
        Object object;
        Object object2;
        boolean bl = false;
        if ("before_init".equals(lifecycleEvent.getType())) {
            if (!(lifecycleEvent.getLifecycle() instanceof Server)) {
                log.warn((Object)sm.getString("listener.notServer", new Object[]{lifecycleEvent.getLifecycle().getClass().getSimpleName()}));
            }
            object2 = lock;
            synchronized (object2) {
                if (!JreCompat.isJre22Available()) {
                    log.info((Object)sm.getString("openssllistener.java22"));
                    OpenSSLStatus.setInitialized((boolean)true);
                    return;
                }
                try {
                    object = Class.forName("org.apache.tomcat.util.net.openssl.panama.OpenSSLLibrary");
                    ((Class)object).getMethod("init", new Class[0]).invoke(null, new Object[0]);
                }
                catch (Throwable throwable2) {
                    throwable = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable2);
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    log.error((Object)sm.getString("openssllistener.sslInit"), throwable);
                    bl = true;
                }
                if (null != this.getFIPSMode() && !"off".equalsIgnoreCase(this.getFIPSMode()) && !this.isFIPSModeActive()) {
                    object = sm.getString("openssllistener.initializeFIPSFailed");
                    throwable = new Error((String)object);
                    log.fatal(object, throwable);
                    bl = true;
                }
            }
        }
        if (bl || "after_destroy".equals(lifecycleEvent.getType())) {
            object2 = lock;
            synchronized (object2) {
                if (!JreCompat.isJre22Available()) {
                    return;
                }
                try {
                    object = Class.forName("org.apache.tomcat.util.net.openssl.panama.OpenSSLLibrary");
                    ((Class)object).getMethod("destroy", new Class[0]).invoke(null, new Object[0]);
                }
                catch (Throwable throwable3) {
                    throwable = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable3);
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    log.warn((Object)sm.getString("openssllistener.destroy"), throwable);
                }
            }
        }
    }

    public String getSSLEngine() {
        if (JreCompat.isJre22Available()) {
            try {
                Class<?> clazz = Class.forName("org.apache.tomcat.util.net.openssl.panama.OpenSSLLibrary");
                return (String)clazz.getMethod("getSSLEngine", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable);
                ExceptionUtils.handleThrowable((Throwable)throwable2);
            }
        }
        return null;
    }

    public void setSSLEngine(String string) {
        if (JreCompat.isJre22Available()) {
            try {
                Class<?> clazz = Class.forName("org.apache.tomcat.util.net.openssl.panama.OpenSSLLibrary");
                clazz.getMethod("setSSLEngine", String.class).invoke(null, string);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable);
                ExceptionUtils.handleThrowable((Throwable)throwable2);
            }
        }
    }

    public String getSSLRandomSeed() {
        if (JreCompat.isJre22Available()) {
            try {
                Class<?> clazz = Class.forName("org.apache.tomcat.util.net.openssl.panama.OpenSSLLibrary");
                return (String)clazz.getMethod("getSSLRandomSeed", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable);
                ExceptionUtils.handleThrowable((Throwable)throwable2);
            }
        }
        return null;
    }

    public void setSSLRandomSeed(String string) {
        if (JreCompat.isJre22Available()) {
            try {
                Class<?> clazz = Class.forName("org.apache.tomcat.util.net.openssl.panama.OpenSSLLibrary");
                clazz.getMethod("setSSLRandomSeed", String.class).invoke(null, string);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable);
                ExceptionUtils.handleThrowable((Throwable)throwable2);
            }
        }
    }

    public String getFIPSMode() {
        if (JreCompat.isJre22Available()) {
            try {
                Class<?> clazz = Class.forName("org.apache.tomcat.util.net.openssl.panama.OpenSSLLibrary");
                return (String)clazz.getMethod("getFIPSMode", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable);
                ExceptionUtils.handleThrowable((Throwable)throwable2);
            }
        }
        return null;
    }

    public void setFIPSMode(String string) {
        if (JreCompat.isJre22Available()) {
            try {
                Class<?> clazz = Class.forName("org.apache.tomcat.util.net.openssl.panama.OpenSSLLibrary");
                clazz.getMethod("setFIPSMode", String.class).invoke(null, string);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable);
                ExceptionUtils.handleThrowable((Throwable)throwable2);
            }
        }
    }

    public boolean isFIPSModeActive() {
        if (JreCompat.isJre22Available()) {
            try {
                Class<?> clazz = Class.forName("org.apache.tomcat.util.net.openssl.panama.OpenSSLLibrary");
                return (Boolean)clazz.getMethod("isFIPSModeActive", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = ExceptionUtils.unwrapInvocationTargetException((Throwable)throwable);
                ExceptionUtils.handleThrowable((Throwable)throwable2);
            }
        }
        return false;
    }

    public void setUseOpenSSL(boolean bl) {
        if (bl != OpenSSLStatus.getUseOpenSSL()) {
            OpenSSLStatus.setUseOpenSSL((boolean)bl);
        }
    }

    public static boolean getUseOpenSSL() {
        return OpenSSLStatus.getUseOpenSSL();
    }
}

