/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import net.sf.sdedit.config.Configuration;
import net.sf.sdedit.config.ConfigurationManager;
import net.sf.sdedit.config.PrintConfiguration;
import net.sf.sdedit.error.DiagramError;
import net.sf.sdedit.multipage.MultipageExporter;
import net.sf.sdedit.ui.components.ButtonPanel;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.ConfigurationUI;
import net.sf.sdedit.ui.components.configuration.ConfigurationUIListener;
import net.sf.sdedit.ui.impl.DiagramTab;
import net.sf.sdedit.ui.impl.UserInterfaceImpl;
import net.sf.sdedit.util.Grep;
import net.sf.sdedit.util.OS;
import net.sf.sdedit.util.UIUtilities;
import net.sf.sdedit.util.WindowsRegistry;

public class PrintDialog
extends JDialog
implements ConfigurationUIListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private String fileType;
    private UserInterfaceImpl ui;
    private JScrollPane preview;
    private MultipageExporter exporter;
    private Bean<PrintConfiguration> printerProperties;
    private Bean<PrintConfiguration> copy;
    private JLabel scaleLabel;
    private boolean firstVisible = true;
    private DiagramTab tab;
    private Action cancel = new AbstractAction(){
        {
            this.putValue("Name", "Cancel");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PrintDialog.this.printerProperties.takeValuesFrom(PrintDialog.this.copy);
            PrintDialog.this.setVisible(false);
        }
    };
    private Action ok = new AbstractAction(){
        {
            this.putValue("Name", "OK");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = ((PrintConfiguration)PrintDialog.this.printerProperties.getDataObject()).getAction();
            if (command.equals("Export file")) {
                PrintDialog.this.export();
            } else if (command.equals("Export and print")) {
                PrintDialog.this.exportAndPrint();
            } else {
                PrintDialog.this.pipe();
            }
            PrintDialog.this.setVisible(false);
        }
    };

    public PrintDialog(UserInterfaceImpl ui) {
        super(ui);
        this.ui = ui;
        this.setModal(true);
        this.init();
    }

    private void init() {
        JPanel center = new JPanel();
        this.getContentPane().add((Component)center, "Center");
        ButtonPanel buttonPanel = new ButtonPanel();
        buttonPanel.addAction(this.cancel);
        buttonPanel.addAction(this.ok, 0, true);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.printerProperties = ConfigurationManager.getPrintConfigurationBean();
        this.setToCurrentFile();
        ConfigurationUI<PrintConfiguration> cui = new ConfigurationUI<PrintConfiguration>(this, this.printerProperties, null, null, null, null, false);
        cui.hideButtons();
        cui.hideCategoryList();
        this.printerProperties.addPropertyChangeListener(this);
        if (OS.TYPE == OS.Type.WINDOWS) {
            this.insertAcrd();
        }
        center.setLayout(new GridLayout(1, 2));
        center.add(cui);
        JPanel right = new JPanel();
        right.setBorder(new TitledBorder("Preview"));
        right.setLayout(new BorderLayout());
        this.preview = new JScrollPane();
        right.add(this.preview);
        this.scaleLabel = new JLabel("Zoom factor: 100 %");
        this.scaleLabel.setHorizontalAlignment(0);
        right.add((Component)this.scaleLabel, "South");
        center.add(right);
    }

    private void insertAcrd() {
        String[] str;
        String acrd;
        if (this.printerProperties.getDataObject().getCommand().equals("/usr/bin/lpr") && (acrd = WindowsRegistry.getValue("HKEY_CLASSES_ROOT/Applications/AcroRD32.exe/shell/Read/command", null)) != null && (str = new Grep(Grep.NO_UNESCAPE).parse("\"(.*?)\".*", acrd = acrd.replace('\\', '/'))) != null && str.length == 1) {
            this.printerProperties.getDataObject().setCommand(str[0].replace('/', '\\'));
            this.printerProperties.getDataObject().setAction("Export and print");
        }
    }

    public void show(DiagramTab tab, String fileType) {
        this.fileType = fileType.toLowerCase();
        this.tab = tab;
        this.setTitle("Print or export multi-page " + fileType.toUpperCase() + " document");
        this.setSize(new Dimension(740, 540));
        UIUtilities.centerWindow(this, this.ui);
        this.reinitialize();
        this.copy = this.printerProperties.copy();
        if (this.firstVisible) {
            if (this.ui.getCurrentFile() != null) {
                this.printerProperties.getDataObject().setExportFile(UIUtilities.affixType(this.ui.getCurrentFile(), "pdf"));
            }
            this.firstVisible = false;
        }
        this.setVisible(true);
    }

    private void setToCurrentFile() {
        File file = this.ui.getCurrentFile();
        if (file != null) {
            String name = file.getAbsolutePath();
            int dot = name.lastIndexOf(46);
            if (dot >= 0) {
                name = name.substring(0, dot);
            }
            this.printerProperties.getDataObject().setExportFile(new File(name + ".pdf"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File export() {
        boolean export = true;
        File exportFile = this.printerProperties.getDataObject().getExportFile();
        if (exportFile.exists()) {
            export = this.ui.confirm(exportFile.getName() + " already exists. Overwrite it?");
        }
        if (export) {
            FileOutputStream stream = null;
            try {
                stream = new FileOutputStream(exportFile);
                this.exporter.exportTo(new FileOutputStream(exportFile), this.fileType);
                File file = exportFile;
                return file;
            }
            catch (IOException e) {
                this.ui.errorMessage(e, null, null);
                File file = null;
                return file;
            }
            finally {
                if (stream != null) {
                    try {
                        ((OutputStream)stream).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return null;
    }

    private void exportAndPrint() {
        File exportFile = this.export();
        if (exportFile != null) {
            String command = this.printerProperties.getDataObject().getCommand() + " " + exportFile.getAbsolutePath();
            try {
                Process proc = Runtime.getRuntime().exec(command);
                proc.waitFor();
                if (this.printerProperties.getDataObject().isEraseExportFile()) {
                    exportFile.delete();
                }
            }
            catch (IOException e) {
                this.ui.errorMessage(e, null, "Invocation of\n" + command + "\nfailed.");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void pipe() {
        OutputStream stream = null;
        try {
            Process process = Runtime.getRuntime().exec(this.printerProperties.getDataObject().getCommand());
            stream = new BufferedOutputStream(process.getOutputStream());
            this.exporter.exportTo(stream, this.fileType);
        }
        catch (IOException e) {
            this.ui.errorMessage(e, null, "Piping to printer command failed.");
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void reinitialize() {
        Configuration configuration = this.tab.getConfiguration().getDataObject();
        this.exporter = new MultipageExporter(this.printerProperties.getDataObject(), this.tab, configuration);
        try {
            this.exporter.init();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (DiagramError re) {
            // empty catch block
        }
        int scale = (int)(100.0 * this.exporter.getScale());
        this.scaleLabel.setText("Zoom factor: " + scale + " %");
        this.preview.setViewportView(this.exporter);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        PrintConfiguration prop;
        String property = evt.getPropertyName();
        if (!(property.equals("command") || property.equals("exportFile") || property.equals("commandFile"))) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PrintDialog.this.reinitialize();
                }
            });
        }
        if (property.equals("command")) {
            prop = this.printerProperties.getDataObject();
            String command = prop.getAction();
            if (command.equals("Export and print")) {
                prop.setExportFile(new File(System.getProperty("java.io.tmpdir"), "temp.pdf"));
            } else if (command.equals("Export file")) {
                this.setToCurrentFile();
            }
        }
        if (property.equals("exportFile") && (prop = this.printerProperties.getDataObject()).getExportFile().isDirectory() && this.ui.getCurrentFile() != null) {
            File ef = UIUtilities.affixType(this.ui.getCurrentFile(), "pdf");
            prop.setExportFile(new File(prop.getExportFile(), ef.getName()));
        }
    }

    @Override
    public void applyConfiguration() {
    }

    @Override
    public void cancelConfiguration() {
    }
}

