/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame.objectproperty;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.editor.OWLObjectPropertyExpressionEditor;
import org.protege.editor.owl.ui.frame.AbstractOWLFrameSectionRow;
import org.protege.editor.owl.ui.frame.OWLFrameSection;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.CollectionFactory;

public class OWLEquivalentObjectPropertiesAxiomFrameSectionRow
extends AbstractOWLFrameSectionRow<OWLObjectProperty, OWLEquivalentObjectPropertiesAxiom, OWLObjectPropertyExpression> {
    public OWLEquivalentObjectPropertiesAxiomFrameSectionRow(OWLEditorKit owlEditorKit, OWLFrameSection<OWLObjectProperty, OWLEquivalentObjectPropertiesAxiom, OWLObjectPropertyExpression> section, OWLOntology ontology, OWLObjectProperty rootObject, OWLEquivalentObjectPropertiesAxiom axiom) {
        super(owlEditorKit, section, ontology, rootObject, axiom);
    }

    @Override
    public boolean isEditable() {
        return ((OWLEquivalentObjectPropertiesAxiom)this.getAxiom()).getProperties().size() <= 2;
    }

    @Override
    public boolean isDeleteable() {
        return true;
    }

    @Override
    protected OWLObjectEditor<OWLObjectPropertyExpression> getObjectEditor() {
        OWLObjectPropertyExpressionEditor editor = new OWLObjectPropertyExpressionEditor(this.getOWLEditorKit());
        HashSet equivs = new HashSet(((OWLEquivalentObjectPropertiesAxiom)this.getAxiom()).getProperties());
        equivs.remove(this.getRootObject());
        if (equivs.size() == 1) {
            OWLObjectPropertyExpression p = (OWLObjectPropertyExpression)equivs.iterator().next();
            editor.setEditedObject(p);
        }
        return editor;
    }

    @Override
    public boolean checkEditorResults(OWLObjectEditor<OWLObjectPropertyExpression> editor) {
        Set<OWLObjectPropertyExpression> equivalents = editor.getEditedObjects();
        return equivalents.size() != 1 || !equivalents.contains(this.getRootObject());
    }

    @Override
    public void handleEditingFinished(Set<OWLObjectPropertyExpression> editedObjects) {
        editedObjects = new HashSet<OWLObjectPropertyExpression>(editedObjects);
        editedObjects.remove(this.getRootObject());
        super.handleEditingFinished(editedObjects);
    }

    @Override
    protected OWLEquivalentObjectPropertiesAxiom createAxiom(OWLObjectPropertyExpression editedObject) {
        return this.getOWLDataFactory().getOWLEquivalentObjectPropertiesAxiom(CollectionFactory.createSet((Object[])new OWLObjectPropertyExpression[]{(OWLObjectPropertyExpression)this.getRoot(), editedObject}));
    }

    @Override
    public List<OWLObjectPropertyExpression> getManipulatableObjects() {
        ArrayList<OWLObjectPropertyExpression> props = new ArrayList<OWLObjectPropertyExpression>(((OWLEquivalentObjectPropertiesAxiom)this.getAxiom()).getProperties());
        props.remove(this.getRoot());
        return props;
    }
}

