// SPDX-FileCopyrightText: Copyright (c) Kitware Inc.
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkPVCatalystSessionCore
 *
 * vtkPVCatalystSessionCore is used by vtkSMSession.
 * vtkPVCatalystSessionCore handle catalyst based proxy which don't contains any
 * real data and therefore are not allowed to execute the VTK pipeline.
 * @ingroup LiveInsitu
 */

#ifndef vtkPVCatalystSessionCore_h
#define vtkPVCatalystSessionCore_h

#include "vtkPVSessionCore.h"
#include "vtkRemotingServerManagerModule.h" //needed for exports
#include "vtkSMMessageMinimal.h"            // needed for vtkSMMessage.
#include "vtkWeakPointer.h"                 // needed for vtkMultiProcessController

class vtkPVInformation;

class VTKREMOTINGSERVERMANAGER_EXPORT vtkPVCatalystSessionCore : public vtkPVSessionCore
{
public:
  static vtkPVCatalystSessionCore* New();
  vtkTypeMacro(vtkPVCatalystSessionCore, vtkPVSessionCore);
  void PrintSelf(ostream& os, vtkIndent indent) override;

  /**
   * Gather information about an object referred by the \c globalid.
   * \c location identifies the processes to gather the information from.
   */
  bool GatherInformation(
    vtkTypeUInt32 location, vtkPVInformation* information, vtkTypeUInt32 globalid) override;

  /**
   * Update the data information for a given proxy with the given globalid.
   * This will allow the GatherInformation to work with "fake" VTK pipeline.
   * Return the real corresponding proxy id
   */
  vtkTypeUInt32 RegisterDataInformation(
    vtkTypeUInt32 globalid, unsigned int port, vtkPVInformation* information);

  void UpdateIdMap(vtkTypeUInt32* idMapArray, int size);
  void ResetIdMap();

protected:
  vtkPVCatalystSessionCore();
  ~vtkPVCatalystSessionCore() override;

private:
  vtkPVCatalystSessionCore(const vtkPVCatalystSessionCore&) = delete;
  void operator=(const vtkPVCatalystSessionCore&) = delete;

  class vtkInternal;
  vtkInternal* CatalystInternal;
};

#endif
