/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.yarn.api.ContainerManagementProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.ContainerUpdateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ContainerUpdateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetLocalizationStatusesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetLocalizationStatusesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReInitializeContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceLocalizationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersResponse;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalizationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.client.api.NMClient;
import org.apache.hadoop.yarn.client.api.impl.ContainerManagementProtocolProxy;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class NMClientImpl
extends NMClient {
    private static final Logger LOG = LoggerFactory.getLogger(NMClientImpl.class);
    protected ConcurrentMap<ContainerId, StartedContainer> startedContainers = new ConcurrentHashMap<ContainerId, StartedContainer>();
    private final AtomicBoolean cleanupRunningContainers = new AtomicBoolean(true);
    private ContainerManagementProtocolProxy cmProxy;

    public NMClientImpl() {
        super(NMClientImpl.class.getName());
    }

    public NMClientImpl(String name) {
        super(name);
    }

    @Override
    protected void serviceStop() throws Exception {
        if (this.getCleanupRunningContainers().get()) {
            this.cleanupRunningContainers();
        }
        this.cmProxy.stopAllProxies();
        super.serviceStop();
    }

    protected synchronized void cleanupRunningContainers() {
        for (StartedContainer startedContainer : this.startedContainers.values()) {
            try {
                this.stopContainer(startedContainer.getContainerId(), startedContainer.getNodeId());
            }
            catch (YarnException e) {
                LOG.error("Failed to stop Container {} when stopping NMClientImpl", (Object)startedContainer.getContainerId());
            }
            catch (IOException e) {
                LOG.error("Failed to stop Container {} when stopping NMClientImpl", (Object)startedContainer.getContainerId());
            }
        }
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        if (this.getNMTokenCache() == null) {
            throw new IllegalStateException("NMTokenCache has not been set");
        }
        this.cmProxy = new ContainerManagementProtocolProxy(conf, this.getNMTokenCache());
    }

    @Override
    public void cleanupRunningContainersOnStop(boolean enabled) {
        this.getCleanupRunningContainers().set(enabled);
    }

    private void addStartingContainer(StartedContainer startedContainer) throws YarnException {
        if (this.startedContainers.putIfAbsent(startedContainer.containerId, startedContainer) != null) {
            throw RPCUtil.getRemoteException("Container " + startedContainer.containerId.toString() + " is already started");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, ByteBuffer> startContainer(Container container, ContainerLaunchContext containerLaunchContext) throws YarnException, IOException {
        StartedContainer startingContainer;
        StartedContainer startedContainer = startingContainer = new StartedContainer(container.getId(), container.getNodeId());
        synchronized (startedContainer) {
            Map<String, ByteBuffer> allServiceResponse;
            this.addStartingContainer(startingContainer);
            ContainerManagementProtocolProxy.ContainerManagementProtocolProxyData proxy = null;
            try {
                proxy = this.cmProxy.getProxy(container.getNodeId().toString(), container.getId());
                StartContainerRequest scRequest = StartContainerRequest.newInstance(containerLaunchContext, container.getContainerToken());
                ArrayList<StartContainerRequest> list = new ArrayList<StartContainerRequest>();
                list.add(scRequest);
                StartContainersRequest allRequests = StartContainersRequest.newInstance(list);
                StartContainersResponse response = proxy.getContainerManagementProtocol().startContainers(allRequests);
                if (response.getFailedRequests() != null && response.getFailedRequests().containsKey(container.getId())) {
                    Throwable t = response.getFailedRequests().get(container.getId()).deSerialize();
                    this.parseAndThrowException(t);
                }
                allServiceResponse = response.getAllServicesMetaData();
                startingContainer.state = ContainerState.RUNNING;
                if (proxy != null) {
                    this.cmProxy.mayBeCloseProxy(proxy);
                }
            }
            catch (IOException | YarnException e) {
                try {
                    startingContainer.state = ContainerState.COMPLETE;
                    this.startedContainers.remove(startingContainer.containerId);
                    throw e;
                    catch (Throwable t) {
                        startingContainer.state = ContainerState.COMPLETE;
                        this.startedContainers.remove(startingContainer.containerId);
                        throw RPCUtil.getRemoteException(t);
                    }
                }
                catch (Throwable throwable) {
                    if (proxy != null) {
                        this.cmProxy.mayBeCloseProxy(proxy);
                    }
                    throw throwable;
                }
            }
            return allServiceResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void increaseContainerResource(Container container) throws YarnException, IOException {
        ContainerManagementProtocolProxy.ContainerManagementProtocolProxyData proxy = null;
        try {
            proxy = this.cmProxy.getProxy(container.getNodeId().toString(), container.getId());
            ArrayList<Token> increaseTokens = new ArrayList<Token>();
            increaseTokens.add(container.getContainerToken());
            ContainerUpdateRequest request = ContainerUpdateRequest.newInstance(increaseTokens);
            ContainerUpdateResponse response = proxy.getContainerManagementProtocol().updateContainer(request);
            if (response.getFailedRequests() != null && response.getFailedRequests().containsKey(container.getId())) {
                Throwable t = response.getFailedRequests().get(container.getId()).deSerialize();
                this.parseAndThrowException(t);
            }
            if (proxy != null) {
                this.cmProxy.mayBeCloseProxy(proxy);
            }
        }
        catch (Throwable throwable) {
            if (proxy != null) {
                this.cmProxy.mayBeCloseProxy(proxy);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateContainerResource(Container container) throws YarnException, IOException {
        ContainerManagementProtocolProxy.ContainerManagementProtocolProxyData proxy = null;
        try {
            proxy = this.cmProxy.getProxy(container.getNodeId().toString(), container.getId());
            ArrayList<Token> updateTokens = new ArrayList<Token>();
            updateTokens.add(container.getContainerToken());
            ContainerUpdateRequest request = ContainerUpdateRequest.newInstance(updateTokens);
            ContainerUpdateResponse response = proxy.getContainerManagementProtocol().updateContainer(request);
            if (response.getFailedRequests() != null && response.getFailedRequests().containsKey(container.getId())) {
                Throwable t = response.getFailedRequests().get(container.getId()).deSerialize();
                this.parseAndThrowException(t);
            }
            if (proxy != null) {
                this.cmProxy.mayBeCloseProxy(proxy);
            }
        }
        catch (Throwable throwable) {
            if (proxy != null) {
                this.cmProxy.mayBeCloseProxy(proxy);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopContainer(ContainerId containerId, NodeId nodeId) throws YarnException, IOException {
        StartedContainer startedContainer = (StartedContainer)this.startedContainers.get(containerId);
        if (startedContainer != null) {
            StartedContainer startedContainer2 = startedContainer;
            synchronized (startedContainer2) {
                if (startedContainer.state != ContainerState.RUNNING) {
                    return;
                }
                this.stopContainerInternal(containerId, nodeId);
                startedContainer.state = ContainerState.COMPLETE;
                this.startedContainers.remove(startedContainer.containerId);
            }
        } else {
            this.stopContainerInternal(containerId, nodeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerStatus getContainerStatus(ContainerId containerId, NodeId nodeId) throws YarnException, IOException {
        ContainerManagementProtocolProxy.ContainerManagementProtocolProxyData proxy = null;
        ArrayList<ContainerId> containerIds = new ArrayList<ContainerId>();
        containerIds.add(containerId);
        try {
            ContainerStatus containerStatus;
            proxy = this.cmProxy.getProxy(nodeId.toString(), containerId);
            GetContainerStatusesResponse response = proxy.getContainerManagementProtocol().getContainerStatuses(GetContainerStatusesRequest.newInstance(containerIds));
            if (response.getFailedRequests() != null && response.getFailedRequests().containsKey(containerId)) {
                Throwable t = response.getFailedRequests().get(containerId).deSerialize();
                this.parseAndThrowException(t);
            }
            ContainerStatus containerStatus2 = containerStatus = response.getContainerStatuses().get(0);
            return containerStatus2;
        }
        finally {
            if (proxy != null) {
                this.cmProxy.mayBeCloseProxy(proxy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reInitializeContainer(ContainerId containerId, ContainerLaunchContext containerLaunchContex, boolean autoCommit) throws YarnException, IOException {
        ContainerManagementProtocolProxy.ContainerManagementProtocolProxyData proxy = null;
        StartedContainer container = (StartedContainer)this.startedContainers.get(containerId);
        if (container != null) {
            StartedContainer startedContainer = container;
            synchronized (startedContainer) {
                proxy = this.cmProxy.getProxy(container.getNodeId().toString(), containerId);
                try {
                    proxy.getContainerManagementProtocol().reInitializeContainer(ReInitializeContainerRequest.newInstance(containerId, containerLaunchContex, autoCommit));
                }
                finally {
                    if (proxy != null) {
                        this.cmProxy.mayBeCloseProxy(proxy);
                    }
                }
            }
        }
        throw new YarnException("Unknown container [" + containerId + "]");
    }

    @Override
    public void restartContainer(ContainerId containerId) throws YarnException, IOException {
        this.restartCommitOrRollbackContainer(containerId, NMClient.UpgradeOp.RESTART);
    }

    @Override
    public void rollbackLastReInitialization(ContainerId containerId) throws YarnException, IOException {
        this.restartCommitOrRollbackContainer(containerId, NMClient.UpgradeOp.ROLLBACK);
    }

    @Override
    public void commitLastReInitialization(ContainerId containerId) throws YarnException, IOException {
        this.restartCommitOrRollbackContainer(containerId, NMClient.UpgradeOp.COMMIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void restartCommitOrRollbackContainer(ContainerId containerId, NMClient.UpgradeOp upgradeOp) throws YarnException, IOException {
        block10: {
            ContainerManagementProtocolProxy.ContainerManagementProtocolProxyData proxy = null;
            StartedContainer container = (StartedContainer)this.startedContainers.get(containerId);
            if (container == null) throw new YarnException("Unknown container [" + containerId + "]");
            StartedContainer startedContainer = container;
            // MONITORENTER : startedContainer
            proxy = this.cmProxy.getProxy(container.getNodeId().toString(), containerId);
            ContainerManagementProtocol cmp = proxy.getContainerManagementProtocol();
            try {
                switch (upgradeOp) {
                    case RESTART: {
                        cmp.restartContainer(containerId);
                        return;
                    }
                    case COMMIT: {
                        cmp.commitLastReInitialization(containerId);
                        return;
                    }
                    case ROLLBACK: {
                        cmp.rollbackLastReInitialization(containerId);
                        return;
                    }
                }
                return;
            }
            finally {
                if (proxy == null) break block10;
                this.cmProxy.mayBeCloseProxy(proxy);
            }
        }
        // MONITOREXIT : startedContainer
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopContainerInternal(ContainerId containerId, NodeId nodeId) throws IOException, YarnException {
        ContainerManagementProtocolProxy.ContainerManagementProtocolProxyData proxy = null;
        ArrayList<ContainerId> containerIds = new ArrayList<ContainerId>();
        containerIds.add(containerId);
        try {
            proxy = this.cmProxy.getProxy(nodeId.toString(), containerId);
            StopContainersResponse response = proxy.getContainerManagementProtocol().stopContainers(StopContainersRequest.newInstance(containerIds));
            if (response.getFailedRequests() != null && response.getFailedRequests().containsKey(containerId)) {
                Throwable t = response.getFailedRequests().get(containerId).deSerialize();
                this.parseAndThrowException(t);
            }
        }
        finally {
            if (proxy != null) {
                this.cmProxy.mayBeCloseProxy(proxy);
            }
        }
    }

    public AtomicBoolean getCleanupRunningContainers() {
        return this.cleanupRunningContainers;
    }

    private void parseAndThrowException(Throwable t) throws YarnException, IOException {
        if (t instanceof YarnException) {
            throw (YarnException)t;
        }
        if (t instanceof SecretManager.InvalidToken) {
            throw (SecretManager.InvalidToken)t;
        }
        throw (IOException)t;
    }

    @Override
    public NodeId getNodeIdOfStartedContainer(ContainerId containerId) {
        StartedContainer container = (StartedContainer)this.startedContainers.get(containerId);
        if (container != null) {
            return container.getNodeId();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void localize(ContainerId containerId, NodeId nodeId, Map<String, LocalResource> localResources) throws YarnException, IOException {
        StartedContainer container = (StartedContainer)this.startedContainers.get(containerId);
        if (container != null) {
            StartedContainer startedContainer = container;
            synchronized (startedContainer) {
                ContainerManagementProtocolProxy.ContainerManagementProtocolProxyData proxy = this.cmProxy.getProxy(container.getNodeId().toString(), containerId);
                try {
                    proxy.getContainerManagementProtocol().localize(ResourceLocalizationRequest.newInstance(containerId, localResources));
                }
                finally {
                    if (proxy != null) {
                        this.cmProxy.mayBeCloseProxy(proxy);
                    }
                }
            }
        }
        throw new YarnException("Unknown container [" + containerId + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LocalizationStatus> getLocalizationStatuses(ContainerId containerId, NodeId nodeId) throws YarnException, IOException {
        ContainerManagementProtocolProxy.ContainerManagementProtocolProxyData proxy = null;
        ArrayList<ContainerId> containerIds = Lists.newArrayList(containerId);
        try {
            proxy = this.cmProxy.getProxy(nodeId.toString(), containerId);
            GetLocalizationStatusesResponse response = proxy.getContainerManagementProtocol().getLocalizationStatuses(GetLocalizationStatusesRequest.newInstance(containerIds));
            if (response.getFailedRequests() != null && response.getFailedRequests().containsKey(containerId)) {
                Throwable t = response.getFailedRequests().get(containerId).deSerialize();
                this.parseAndThrowException(t);
            }
            List<LocalizationStatus> list = response.getLocalizationStatuses().get(containerId);
            return list;
        }
        finally {
            if (proxy != null) {
                this.cmProxy.mayBeCloseProxy(proxy);
            }
        }
    }

    protected static class StartedContainer {
        private ContainerId containerId;
        private NodeId nodeId;
        private ContainerState state;

        public StartedContainer(ContainerId containerId, NodeId nodeId) {
            this.containerId = containerId;
            this.nodeId = nodeId;
            this.state = ContainerState.NEW;
        }

        public ContainerId getContainerId() {
            return this.containerId;
        }

        public NodeId getNodeId() {
            return this.nodeId;
        }
    }
}

