/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.contextmanagement;

import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.MatchAllQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.ml.action.contextmanagement.ContextManagementIndexUtils;
import org.opensearch.ml.common.contextmanager.ContextManagementTemplate;
import org.opensearch.ml.engine.indices.MLIndicesHandler;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.transport.client.Client;

public class ContextManagementTemplateService {
    @Generated
    private static final Logger log = LogManager.getLogger(ContextManagementTemplateService.class);
    private static final int DEFAULT_MAX_TEMPLATES = 1000;
    private static final String INVALID_CONTEXT_MANAGEMENT_NAME_ERROR = "Invalid context management name: must contain only lowercase letters, numbers, hyphens, and underscores, and must be between 1 and 49 characters";
    private static final String INVALID_CONTEXT_MANAGEMENT_CONFIG_ERROR = "Invalid context management configuration";
    private static final String CONTEXT_MANAGEMENT_NAME_NULL_ERROR = "Context management name cannot be null, empty, or whitespace";
    private static final String CONTEXT_MANAGEMENT_NOT_FOUND_ERROR = "Context management not found: ";
    private final MLIndicesHandler mlIndicesHandler;
    private final Client client;
    private final ClusterService clusterService;
    private final ContextManagementIndexUtils indexUtils;

    @Inject
    public ContextManagementTemplateService(MLIndicesHandler mlIndicesHandler, Client client, ClusterService clusterService) {
        this.mlIndicesHandler = mlIndicesHandler;
        this.client = client;
        this.clusterService = clusterService;
        this.indexUtils = new ContextManagementIndexUtils(client, clusterService);
    }

    public void saveTemplate(String templateName, ContextManagementTemplate template, ActionListener<Boolean> listener) {
        try {
            if (!template.isValidName()) {
                listener.onFailure((Exception)new IllegalArgumentException(INVALID_CONTEXT_MANAGEMENT_NAME_ERROR));
                return;
            }
            if (!template.isValid()) {
                listener.onFailure((Exception)new IllegalArgumentException(INVALID_CONTEXT_MANAGEMENT_CONFIG_ERROR));
                return;
            }
            User user = RestActionUtils.getUserContext(this.client);
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                ActionListener wrappedListener = ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
                Instant now = Instant.now();
                if (template.getCreatedTime() == null) {
                    template.setCreatedTime(now);
                }
                template.setLastModified(now);
                if (template.getCreatedBy() == null && user != null) {
                    template.setCreatedBy(user.getName());
                }
                this.indexUtils.createIndexIfNotExists((ActionListener<Boolean>)ActionListener.wrap(indexCreated -> this.validateUniqueTemplateName(template.getName(), (ActionListener<Boolean>)ActionListener.wrap(exists -> {
                    if (exists.booleanValue()) {
                        wrappedListener.onFailure((Exception)new IllegalArgumentException("A context management with name '" + template.getName() + "' already exists"));
                        return;
                    }
                    IndexRequest indexRequest = (IndexRequest)new IndexRequest(ContextManagementIndexUtils.getIndexName()).id(template.getName()).source(template.toXContent(JsonXContent.jsonXContent.contentBuilder(), ToXContentObject.EMPTY_PARAMS)).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                    this.client.index(indexRequest, ActionListener.wrap(indexResponse -> {
                        log.info("Context management saved successfully: {}", (Object)template.getName());
                        wrappedListener.onResponse((Object)true);
                    }, exception -> {
                        log.error("Failed to save context management: {}", (Object)template.getName(), exception);
                        wrappedListener.onFailure(exception);
                    }));
                }, arg_0 -> ((ActionListener)wrappedListener).onFailure(arg_0))), arg_0 -> ((ActionListener)wrappedListener).onFailure(arg_0)));
            }
        }
        catch (Exception e) {
            log.error("Error saving context management", (Throwable)e);
            listener.onFailure(e);
        }
    }

    public void getTemplate(String templateName, ActionListener<ContextManagementTemplate> listener) {
        try {
            if (templateName == null || templateName.trim().isEmpty()) {
                listener.onFailure((Exception)new IllegalArgumentException(CONTEXT_MANAGEMENT_NAME_NULL_ERROR));
                return;
            }
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                ActionListener wrappedListener = ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
                GetRequest getRequest = new GetRequest(ContextManagementIndexUtils.getIndexName(), templateName);
                this.client.get(getRequest, ActionListener.wrap(getResponse -> {
                    if (!getResponse.isExists()) {
                        wrappedListener.onFailure((Exception)new OpenSearchStatusException(CONTEXT_MANAGEMENT_NOT_FOUND_ERROR + templateName, RestStatus.NOT_FOUND, new Object[0]));
                        return;
                    }
                    try {
                        XContentParser parser = this.createXContentParserFromRegistry(NamedXContentRegistry.EMPTY, LoggingDeprecationHandler.INSTANCE, getResponse.getSourceAsBytesRef());
                        ContextManagementTemplate template = ContextManagementTemplate.parse((XContentParser)parser);
                        wrappedListener.onResponse((Object)template);
                    }
                    catch (Exception e) {
                        log.error("Failed to parse context management: {}", (Object)templateName, (Object)e);
                        wrappedListener.onFailure(e);
                    }
                }, exception -> {
                    if (exception instanceof IndexNotFoundException) {
                        wrappedListener.onFailure((Exception)new OpenSearchStatusException(CONTEXT_MANAGEMENT_NOT_FOUND_ERROR + templateName, RestStatus.NOT_FOUND, new Object[0]));
                    } else {
                        log.error("Failed to get context management: {}", (Object)templateName, exception);
                        wrappedListener.onFailure(exception);
                    }
                }));
            }
        }
        catch (Exception e) {
            log.error("Error getting context management", (Throwable)e);
            listener.onFailure(e);
        }
    }

    public void listTemplates(ActionListener<List<ContextManagementTemplate>> listener) {
        this.listTemplates(0, 1000, listener);
    }

    public void listTemplates(int from, int size, ActionListener<List<ContextManagementTemplate>> listener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
            SearchRequest searchRequest = new SearchRequest(new String[]{ContextManagementIndexUtils.getIndexName()});
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)new MatchAllQueryBuilder()).from(from).size(size);
            searchRequest.source(searchSourceBuilder);
            this.client.search(searchRequest, ActionListener.wrap(searchResponse -> {
                try {
                    ArrayList<ContextManagementTemplate> templates = new ArrayList<ContextManagementTemplate>();
                    for (SearchHit hit : searchResponse.getHits().getHits()) {
                        XContentParser parser = this.createXContentParserFromRegistry(NamedXContentRegistry.EMPTY, LoggingDeprecationHandler.INSTANCE, hit.getSourceRef());
                        ContextManagementTemplate template = ContextManagementTemplate.parse((XContentParser)parser);
                        templates.add(template);
                    }
                    wrappedListener.onResponse(templates);
                }
                catch (Exception e) {
                    log.error("Failed to parse context management", (Throwable)e);
                    wrappedListener.onFailure(e);
                }
            }, exception -> {
                if (exception instanceof IndexNotFoundException) {
                    wrappedListener.onResponse(new ArrayList());
                } else {
                    log.error("Failed to list context management", (Throwable)exception);
                    wrappedListener.onFailure(exception);
                }
            }));
        }
        catch (Exception e) {
            log.error("Error listing context management", (Throwable)e);
            listener.onFailure(e);
        }
    }

    public void deleteTemplate(String templateName, ActionListener<Boolean> listener) {
        try {
            if (templateName == null || templateName.trim().isEmpty()) {
                listener.onFailure((Exception)new IllegalArgumentException(CONTEXT_MANAGEMENT_NAME_NULL_ERROR));
                return;
            }
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                ActionListener wrappedListener = ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
                DeleteRequest deleteRequest = (DeleteRequest)new DeleteRequest(ContextManagementIndexUtils.getIndexName(), templateName).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                this.client.delete(deleteRequest, ActionListener.wrap(deleteResponse -> {
                    boolean deleted;
                    boolean bl = deleted = deleteResponse.getResult() == DocWriteResponse.Result.DELETED;
                    if (deleted) {
                        log.info("Context management deleted successfully: {}", (Object)templateName);
                    } else {
                        log.warn("Context management not found for deletion: {}", (Object)templateName);
                    }
                    wrappedListener.onResponse((Object)deleted);
                }, exception -> {
                    if (exception instanceof IndexNotFoundException) {
                        wrappedListener.onResponse((Object)false);
                    } else {
                        log.error("Failed to delete context management: {}", (Object)templateName, exception);
                        wrappedListener.onFailure(exception);
                    }
                }));
            }
        }
        catch (Exception e) {
            log.error("Error deleting context management", (Throwable)e);
            listener.onFailure(e);
        }
    }

    private void validateUniqueTemplateName(String templateName, ActionListener<Boolean> listener) {
        try {
            SearchRequest searchRequest = new SearchRequest(new String[]{ContextManagementIndexUtils.getIndexName()});
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)new TermQueryBuilder("_id", templateName)).size(1);
            searchRequest.source(searchSourceBuilder);
            this.client.search(searchRequest, ActionListener.wrap(searchResponse -> {
                boolean exists = searchResponse.getHits().getTotalHits() != null && searchResponse.getHits().getTotalHits().value() > 0L;
                listener.onResponse((Object)exists);
            }, exception -> {
                if (exception instanceof IndexNotFoundException) {
                    listener.onResponse((Object)false);
                } else {
                    listener.onFailure(exception);
                }
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void updateTemplate(String templateName, ContextManagementTemplate template, ActionListener<UpdateResponse> listener) {
        try {
            if (templateName == null || templateName.trim().isEmpty()) {
                listener.onFailure((Exception)new IllegalArgumentException(CONTEXT_MANAGEMENT_NAME_NULL_ERROR));
                return;
            }
            if (!template.isValidName()) {
                listener.onFailure((Exception)new IllegalArgumentException(INVALID_CONTEXT_MANAGEMENT_NAME_ERROR));
                return;
            }
            if (!template.isValid()) {
                listener.onFailure((Exception)new IllegalArgumentException(INVALID_CONTEXT_MANAGEMENT_CONFIG_ERROR));
                return;
            }
            User user = RestActionUtils.getUserContext(this.client);
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                ActionListener wrappedListener = ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
                template.setLastModified(Instant.now());
                UpdateRequest updateRequest = new UpdateRequest(ContextManagementIndexUtils.getIndexName(), templateName).doc(template.toXContent(JsonXContent.jsonXContent.contentBuilder(), ToXContentObject.EMPTY_PARAMS)).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                this.client.update(updateRequest, ActionListener.wrap(updateResponse -> {
                    log.info("Context management updated successfully: {}", (Object)templateName);
                    wrappedListener.onResponse(updateResponse);
                }, exception -> {
                    if (exception instanceof IndexNotFoundException) {
                        wrappedListener.onFailure((Exception)new OpenSearchStatusException(CONTEXT_MANAGEMENT_NOT_FOUND_ERROR + templateName, RestStatus.NOT_FOUND, new Object[0]));
                    } else {
                        log.error("Failed to update context management: {}", (Object)templateName, exception);
                        wrappedListener.onFailure(exception);
                    }
                }));
            }
        }
        catch (Exception e) {
            log.error("Error updating context management: {}", (Object)templateName, (Object)e);
            listener.onFailure(e);
        }
    }

    private XContentParser createXContentParserFromRegistry(NamedXContentRegistry xContentRegistry, LoggingDeprecationHandler deprecationHandler, BytesReference bytesReference) throws IOException {
        return MediaTypeRegistry.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)deprecationHandler, (InputStream)bytesReference.streamInput());
    }
}

