/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import oracle.jdbc.driver.json.binary.OsonContext;
import oracle.jdbc.driver.json.binary.OsonHeader;
import oracle.jdbc.driver.json.binary.OsonStructureImpl;
import oracle.jdbc.driver.json.tree.OracleJsonNumberImpl;
import oracle.sql.json.OracleJsonValue;

public abstract class OsonAbstractArray
extends OsonStructureImpl {
    public OsonAbstractArray(OsonContext ctx, int pos) {
        super(ctx);
        this.init(pos);
    }

    protected OsonAbstractArray(OsonContext ctx) {
        super(ctx);
    }

    public String getString(int i) {
        int childOffset = this.getOffsetWithError(i);
        String result = this.getStringInternal(childOffset);
        if (result == null) {
            throw new ClassCastException();
        }
        return result;
    }

    public boolean getBoolean(int i) {
        int childOffset = this.getOffsetWithError(i);
        Boolean result = this.getBooleanInternal(childOffset);
        if (result == null) {
            throw new ClassCastException();
        }
        return result;
    }

    public boolean getBoolean(int i, boolean d) {
        int childOffset = this.getChildOffset(i);
        if (childOffset == -1) {
            return d;
        }
        Boolean result = this.getBooleanInternal(childOffset);
        if (result == null) {
            return d;
        }
        return result;
    }

    public int getInt(int i) {
        int childOffset = this.getOffsetWithError(i);
        return ((OracleJsonNumberImpl)this.getValueInternal(childOffset)).intValue();
    }

    public int getInt(int i, int d) {
        int childOffset = this.getChildOffset(i);
        if (childOffset == -1) {
            return d;
        }
        Object o = this.getValueInternal(childOffset);
        if (!(o instanceof OracleJsonNumberImpl)) {
            return d;
        }
        OracleJsonNumberImpl n = (OracleJsonNumberImpl)o;
        return n.intValue();
    }

    public boolean isNull(int i) {
        int childOffset = this.getOffsetWithError(i);
        return this.isNullInternal(childOffset);
    }

    public boolean contains(Object value) {
        for (int i = 0; i < this.size; ++i) {
            Object c = this.getValueInternal(this.getChildOffset(i));
            if (!c.equals(value)) continue;
            return true;
        }
        return false;
    }

    public Object[] toArray() {
        Object[] result = new Object[this.size];
        this.copyToArray(result);
        return result;
    }

    public <T> T[] toArray(T[] a) {
        Object[] r = a.length >= this.size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        this.copyToArray(r);
        if (r.length >= this.size + 1) {
            r[this.size] = null;
        }
        return r;
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (!(o instanceof List)) {
            return false;
        }
        List otherList = (List)o;
        if (otherList.size() != this.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            Object value = this.getValueInternal(this.getChildOffset(i));
            if (value.equals(otherList.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        for (int i = 0; i < this.size; ++i) {
            Object value = this.getValueInternal(this.getChildOffset(i));
            hashCode = 31 * hashCode + value.hashCode();
        }
        return hashCode;
    }

    public Object getInternal(int i) {
        return this.getValueInternal(this.getOffsetWithError(i));
    }

    public int indexOf(Object o) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.getInternal(i).equals(o)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        int result = -1;
        for (int i = 0; i < this.size; ++i) {
            if (!this.getInternal(i).equals(o)) continue;
            result = i;
        }
        return result;
    }

    @Override
    public OracleJsonValue.OracleJsonType getOracleJsonType() {
        return OracleJsonValue.OracleJsonType.ARRAY;
    }

    @Override
    protected void init(int pos) {
        super.init(pos);
        int op = this.ctx.b.getUB1(pos);
        this.initChildOffseUb(op);
        int childSizeBits = op & 0x18;
        this.childArrayOffset = pos + 1;
        if (childSizeBits == 0) {
            ++this.childArrayOffset;
            this.size = this.ctx.b.getUB1(pos + 1);
        } else if (childSizeBits == 8) {
            this.childArrayOffset += 2;
            this.size = this.ctx.b.getUB2(pos + 1);
        } else if (childSizeBits == 16) {
            this.childArrayOffset += 4;
            this.size = this.ctx.b.getUB4int(pos + 1);
        }
    }

    @Override
    protected int getChildOffset(int i) {
        if (i < 0 || i >= this.size) {
            return -1;
        }
        OsonHeader header = this.ctx.getHeader();
        if (header.relativeOffsets()) {
            if (this.childOffsetUb == 2) {
                short relative = this.ctx.b.getShort(this.childArrayOffset + i * 2);
                relative = (short)(relative + (this.pos - header.getTreeSegmentOffset()));
                return (relative & 0xFFFF) + header.getTreeSegmentOffset();
            }
            int relative = this.ctx.b.getInt(this.childArrayOffset + i * 4);
            return ((relative += this.pos - header.getTreeSegmentOffset()) & 0xFFFFFFFF) + header.getTreeSegmentOffset();
        }
        if (this.childOffsetUb == 2) {
            return this.ctx.b.getUB2(this.childArrayOffset + i * 2) + header.getTreeSegmentOffset();
        }
        return this.ctx.b.getUB4int(this.childArrayOffset + i * 4) + header.getTreeSegmentOffset();
    }

    private void copyToArray(Object[] result) {
        for (int i = 0; i < this.size; ++i) {
            result[i] = this.getValueInternal(this.getChildOffset(i));
        }
    }

    protected int getOffsetWithError(int i) {
        int childOffset = this.getChildOffset(i);
        if (childOffset == -1) {
            throw new IndexOutOfBoundsException();
        }
        return childOffset;
    }

    protected <T> AbstractList<T> sublist(final int fromIndex, final int toIndex) {
        if (fromIndex < 0 || toIndex > this.size || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException();
        }
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return OsonAbstractArray.this.getValueInternal(OsonAbstractArray.this.getOffsetWithError(index + fromIndex));
            }

            @Override
            public int size() {
                return toIndex - fromIndex;
            }
        };
    }

    public class ListIter<T>
    extends ValueIter<T>
    implements ListIterator<T> {
        public ListIter(int i) {
            this.ipos = i;
        }

        @Override
        public boolean hasPrevious() {
            return this.ipos != 0;
        }

        @Override
        public T previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return (T)OsonAbstractArray.this.getInternal(--this.ipos);
        }

        @Override
        public int nextIndex() {
            return this.ipos;
        }

        @Override
        public int previousIndex() {
            return this.ipos - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(T e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(T e) {
            throw new UnsupportedOperationException();
        }
    }

    protected class ValueIter<V>
    extends OsonStructureImpl.PositionIter<V> {
        protected ValueIter() {
            super(OsonAbstractArray.this);
        }

        @Override
        public V getValue(int pos) {
            return (V)OsonAbstractArray.this.getValueInternal(OsonAbstractArray.this.getChildOffset(pos++));
        }
    }
}

