/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.osmand.Location;
import net.osmand.ResultMatcher;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.GeocodingUtilities;
import net.osmand.binary.RouteDataObject;
import net.osmand.plus.ApplicationMode;
import net.osmand.plus.resources.RegionAddressRepository;
import net.osmand.router.GeneralRouter;
import net.osmand.router.RoutePlannerFrontEnd;
import net.osmand.router.RoutingConfiguration;
import net.osmand.router.RoutingContext;
import net.osmand.util.MapUtils;
import net.sourceforge.offroad.OsmWindow;

public class CurrentPositionHelper {
    private RouteDataObject lastFound;
    private Location lastAskedLocation = null;
    private RoutingContext ctx;
    private RoutingContext defCtx;
    private OsmWindow app;
    private ApplicationMode am;

    public CurrentPositionHelper(OsmWindow app) {
        this.app = app;
    }

    private void initCtx(OsmWindow app) {
        this.am = app.getSettings().getApplicationMode();
        GeneralRouter.GeneralRouterProfile p = this.am.isDerivedRoutingFrom(ApplicationMode.BICYCLE) ? GeneralRouter.GeneralRouterProfile.BICYCLE : (this.am.isDerivedRoutingFrom(ApplicationMode.PEDESTRIAN) ? GeneralRouter.GeneralRouterProfile.PEDESTRIAN : (this.am.isDerivedRoutingFrom(ApplicationMode.CAR) ? GeneralRouter.GeneralRouterProfile.CAR : GeneralRouter.GeneralRouterProfile.PEDESTRIAN));
        RoutingConfiguration cfg = app.getDefaultRoutingConfig().build(p.name().toLowerCase(), 10, new HashMap<String, String>());
        this.ctx = new RoutePlannerFrontEnd(false).buildRoutingContext(cfg, app.getResourceManager().getRoutingMapFiles());
        RoutingConfiguration defCfg = app.getDefaultRoutingConfig().build(GeneralRouter.GeneralRouterProfile.CAR.name().toLowerCase(), 10, new HashMap<String, String>());
        this.defCtx = new RoutePlannerFrontEnd(false).buildRoutingContext(defCfg, app.getResourceManager().getRoutingMapFiles());
    }

    private boolean scheduleRouteSegmentFind(final Location loc, final boolean storeFound, final ResultMatcher<GeocodingUtilities.GeocodingResult> geoCoding, final ResultMatcher<RouteDataObject> result) {
        boolean res = false;
        if (loc != null) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        final List gr = CurrentPositionHelper.this.runUpdateInThread(loc.getLatitude(), loc.getLongitude(), geoCoding != null);
                        if (storeFound) {
                            CurrentPositionHelper.this.lastAskedLocation = loc;
                            CurrentPositionHelper.this.lastFound = gr == null || gr.isEmpty() ? null : ((GeocodingUtilities.GeocodingResult)gr.get((int)0)).point.getRoad();
                        } else if (geoCoding != null) {
                            CurrentPositionHelper.this.justifyResult(gr, geoCoding);
                        } else if (result != null) {
                            CurrentPositionHelper.this.app.runInUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    result.publish(gr == null || gr.isEmpty() ? null : ((GeocodingUtilities.GeocodingResult)gr.get((int)0)).point.getRoad());
                                }
                            });
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            res = this.app.getRoutingHelper().startTaskInRouteThreadIfPossible(run);
        }
        return res;
    }

    protected void justifyResult(List<GeocodingUtilities.GeocodingResult> res, final ResultMatcher<GeocodingUtilities.GeocodingResult> result) {
        ArrayList<GeocodingUtilities.GeocodingResult> complete = new ArrayList<GeocodingUtilities.GeocodingResult>();
        double minBuildingDistance = 0.0;
        for (GeocodingUtilities.GeocodingResult r : res) {
            Collection<RegionAddressRepository> rar = this.app.getResourceManager().getAddressRepositories();
            RegionAddressRepository foundRepo = null;
            for (RegionAddressRepository repo : rar) {
                BinaryMapIndexReader reader = repo.getFile();
                for (BinaryMapRouteReaderAdapter.RouteRegion rb : reader.getRoutingIndexes()) {
                    if (r.regionFP == rb.getFilePointer() && r.regionLen == rb.getLength()) {
                        foundRepo = repo;
                        break;
                    }
                    if (!result.isCancelled()) continue;
                    break;
                }
                if (foundRepo == null && !result.isCancelled()) continue;
                break;
            }
            if (result.isCancelled()) break;
            if (foundRepo != null) {
                List<GeocodingUtilities.GeocodingResult> justified = foundRepo.justifyReverseGeocodingSearch(r, minBuildingDistance, result);
                if (justified.isEmpty()) continue;
                double md = justified.get(0).getDistance();
                minBuildingDistance = minBuildingDistance == 0.0 ? md : Math.min(md, minBuildingDistance);
                complete.addAll(justified);
                continue;
            }
            complete.add(r);
        }
        if (result.isCancelled()) {
            this.app.runInUIThread(new Runnable(){

                @Override
                public void run() {
                    result.publish(null);
                }
            });
            return;
        }
        Collections.sort(complete, GeocodingUtilities.DISTANCE_COMPARATOR);
        final GeocodingUtilities.GeocodingResult rts = complete.size() > 0 ? (GeocodingUtilities.GeocodingResult)complete.get(0) : new GeocodingUtilities.GeocodingResult();
        this.app.runInUIThread(new Runnable(){

            @Override
            public void run() {
                result.publish(rts);
            }
        });
    }

    private static double getOrthogonalDistance(RouteDataObject r, Location loc) {
        double d = 1000.0;
        if (r.getPointsLength() > 0) {
            double pLt = MapUtils.get31LatitudeY(r.getPoint31YTile(0));
            double pLn = MapUtils.get31LongitudeX(r.getPoint31XTile(0));
            for (int i = 1; i < r.getPointsLength(); ++i) {
                double lt = MapUtils.get31LatitudeY(r.getPoint31YTile(i));
                double ln = MapUtils.get31LongitudeX(r.getPoint31XTile(i));
                double od = MapUtils.getOrthogonalDistance(loc.getLatitude(), loc.getLongitude(), pLt, pLn, lt, ln);
                if (od < d) {
                    d = od;
                }
                pLt = lt;
                pLn = ln;
            }
        }
        return d;
    }

    public boolean getRouteSegment(Location loc, ResultMatcher<RouteDataObject> result) {
        return this.scheduleRouteSegmentFind(loc, false, null, result);
    }

    public boolean getGeocodingResult(Location loc, ResultMatcher<GeocodingUtilities.GeocodingResult> result) {
        return this.scheduleRouteSegmentFind(loc, false, result, null);
    }

    public RouteDataObject getLastKnownRouteSegment(Location loc) {
        Location last = this.lastAskedLocation;
        RouteDataObject r = this.lastFound;
        if (loc == null || loc.getAccuracy() > 50.0f) {
            return null;
        }
        if (last != null && last.distanceTo(loc) < 20.0f) {
            return r;
        }
        if (r == null) {
            this.scheduleRouteSegmentFind(loc, true, null, null);
            return null;
        }
        double d = CurrentPositionHelper.getOrthogonalDistance(r, loc);
        if (d > 25.0) {
            this.scheduleRouteSegmentFind(loc, true, null, null);
        }
        if (d < 70.0) {
            return r;
        }
        return null;
    }

    private synchronized List<GeocodingUtilities.GeocodingResult> runUpdateInThread(double lat, double lon, boolean geocoding) throws IOException {
        if (this.ctx == null || this.am != this.app.getSettings().getApplicationMode()) {
            this.initCtx(this.app);
            if (this.ctx == null) {
                return null;
            }
        }
        return new GeocodingUtilities().reverseGeocodingSearch(geocoding ? this.defCtx : this.ctx, lat, lon);
    }
}

