## Vulnerable Application

This module uses a challenge solver exploit which impacts two possible states
of the device: pre-password set and post-password set. The pre-password set
vulnerability uses a default password and a weak anti-CSRF (CVE-2015-4624)
check to obtain shell by logging in and pre-computing the solution to
the anti-CSRF check.

The post-password set vulnerability uses the fact that there is a 1 in 27
chance of correctly guessing the challenge solution. This attack resets the
password to a password chosen by the attacker (we suggest the default
'pineapplesareyummy' to decrease collateral damage on victims) and then
performs the same anti-CSRF attack as the pre-password vulnerability.

This exploit uses a utility function in
/components/system/configuration/functions.php to execute commands once
authorization has been bypassed.

## Verification Steps

This exploit requires a "fresh" pineapple, flashed with version 2.0-2.3. The
default options are generally effective due to having a set state after being
flashed. You will need to be connected to the WiFi pineapple network (e.g. via
WiFi or ethernet).

Assuming the above 2.3 firmware is installed, this exploit should always work.
If it does not, try it again. It should always work as long as the pineapple is
in its default configuration.
