# -*- coding: binary -*-

module Msf::Exploit::Remote::HTTP::Webmin::Login
  # performs a webmin login
  #
  # @param user [String] Username
  # @param pass [String] Password
  # @return [String,nil] the session cookies as a single string on successful login, nil otherwise
  def webmin_login(user, pass)
    print_status('Attempting to authenticate with Webmin')
    res = send_request_cgi({
                             'method' => 'POST',
                             'uri' => normalize_uri(datastore['TARGETURI'], 'session_login.cgi'),
                             'cookie' => 'testing=1', # it must be used for "Error - No cookies"
                             'keep_cookies' => true,
                             'vars_post' => {
                               'page' => '',
                               'user' => user,
                               'pass' => pass
                             }
                           })

    if res && res.code == 302 && res.get_cookies =~ /sid=(\w+)/
      print_good("Authentication successful")
      return ::Regexp.last_match(1)
    end

    return nil unless res

    res
  end
end
