/* libmanette-version.h.in
 *
 * Copyright (C) 2017 Adrien Plazas <kekun.plazas@laposte.net>
 *
 * This file is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#if !defined(__MANETTE_INSIDE__) && !defined(MANETTE_COMPILATION)
# error "Only <libmanette.h> can be included directly."
#endif

#include <glib.h>

G_BEGIN_DECLS

/**
 * MANETTE_MAJOR_VERSION:
 *
 * libmanette major version component (e.g. 1 if the version is 1.2.3).
 *
 * Since: 0.2.10
 */
#define MANETTE_MAJOR_VERSION (0)

/**
 * MANETTE_MINOR_VERSION:
 *
 * libmanette minor version component (e.g. 2 if the version is 1.2.3).
 *
 * Since: 0.2.10
 */
#define MANETTE_MINOR_VERSION (2)

/**
 * MANETTE_MICRO_VERSION:
 *
 * libmanette micro version component (e.g. 3 if the version is 1.2.3).
 *
 * Since: 0.2.10
 */
#define MANETTE_MICRO_VERSION (13)

/**
 * MANETTE_VERSION:
 *
 * libmanette version.
 *
 * Since: 0.2.10
 */
#define MANETTE_VERSION (0.2.13)

/**
 * MANETTE_VERSION_S:
 *
 * libmanette version, encoded as a string, useful for printing and
 * concatenation.
 *
 * Since: 0.2.10
 */
#define MANETTE_VERSION_S "0.2.13"

#define MANETTE_ENCODE_VERSION(major,minor,micro) \
        ((major) << 24 | (minor) << 16 | (micro) << 8)

/**
 * MANETTE_VERSION_HEX:
 *
 * libmanette version, encoded as an hexadecimal number, useful for
 * integer comparisons.
 *
 * Since: 0.2.10
 */
#define MANETTE_VERSION_HEX \
        (MANETTE_ENCODE_VERSION (MANETTE_MAJOR_VERSION, MANETTE_MINOR_VERSION, MANETTE_MICRO_VERSION))

/**
 * MANETTE_CHECK_VERSION:
 * @major: required major version
 * @minor: required minor version
 * @micro: required micro version
 *
 * Compile-time version checking. Evaluates to `TRUE` if the version
 * of libmanette is greater than the required one.
 *
 * Since: 0.2.10
 */
#define MANETTE_CHECK_VERSION(major,minor,micro)   \
        (MANETTE_MAJOR_VERSION > (major) || \
         (MANETTE_MAJOR_VERSION == (major) && MANETTE_MINOR_VERSION > (minor)) || \
         (MANETTE_MAJOR_VERSION == (major) && MANETTE_MINOR_VERSION == (minor) && \
          MANETTE_MICRO_VERSION >= (micro)))


/**
 * LIBMANETTE_MAJOR_VERSION: (skip)
 *
 * libmanette major version component (e.g. 1 if the version is 1.2.3)
 *
 * Deprecated: Use `MANETTE_MAJOR_VERSION` instead
 */
#define LIBMANETTE_MAJOR_VERSION (0)

/**
 * LIBMANETTE_MINOR_VERSION: (skip)
 *
 * libmanette minor version component (e.g. 2 if the version is 1.2.3)
 *
 * Deprecated: Use `MANETTE_MINOR_VERSION` instead
 */
#define LIBMANETTE_MINOR_VERSION (2)

/**
 * LIBMANETTE_MICRO_VERSION: (skip)
 *
 * libmanette micro version component (e.g. 3 if the version is 1.2.3)
 *
 * Deprecated: Use `MANETTE_MICRO_VERSION` instead
 */
#define LIBMANETTE_MICRO_VERSION (13)

/**
 * LIBMANETTE_VERSION: (skip)
 *
 * libmanette version.
 *
 * Deprecated: Use `MANETTE_VERSION` instead
 */
#define LIBMANETTE_VERSION (0.2.13)

/**
 * LIBMANETTE_VERSION_S: (skip)
 *
 * libmanette version, encoded as a string, useful for printing and
 * concatenation.
 *
 * Deprecated: Use `MANETTE_VERSION_S` instead
 */
#define LIBMANETTE_VERSION_S "0.2.13"

/**
 * LIBMANETTE_VERSION_HEX: (skip)
 *
 * libmanette version, encoded as an hexadecimal number, useful for
 * integer comparisons.
 *
 * Deprecated: Use `MANETTE_VERSION_HEX` instead
 */
#define LIBMANETTE_VERSION_HEX \
        (MANETTE_ENCODE_VERSION (MANETTE_MAJOR_VERSION, MANETTE_MINOR_VERSION, MANETTE_MICRO_VERSION))

/**
 * LIBMANETTE_CHECK_VERSION: (skip)
 * @major: required major version
 * @minor: required minor version
 * @micro: required micro version
 *
 * Compile-time version checking. Evaluates to `TRUE` if the version
 * of libmanette is greater than the required one.
 *
 * Deprecated: Use `MANETTE_CHECK_VERSION` instead
 */
#define LIBMANETTE_CHECK_VERSION(major,minor,micro)   \
        (MANETTE_MAJOR_VERSION > (major) || \
         (MANETTE_MAJOR_VERSION == (major) && MANETTE_MINOR_VERSION > (minor)) || \
         (MANETTE_MAJOR_VERSION == (major) && MANETTE_MINOR_VERSION == (minor) && \
          MANETTE_MICRO_VERSION >= (micro)))

guint manette_get_major_version (void);
guint manette_get_minor_version (void);
guint manette_get_micro_version (void);

G_END_DECLS
