// This file is part of libigl, a simple c++ geometry processing library.
//
// Copyright (C) 2013 Alec Jacobson <alecjacobson@gmail.com>
//
// This Source Code Form is subject to the terms of the Mozilla Public License
// v. 2.0. If a copy of the MPL was not distributed with this file, You can
// obtain one at http://mozilla.org/MPL/2.0/.
#include "increment_ulp.h"
#include <cmath>
#include <limits>


// see "Robust BVH Ray Traversal" by Thiago Ize, section 3:
// for why we need this
template <typename Derived>
IGL_INLINE void igl::increment_ulp(
    Eigen::MatrixBase<Derived>& inout,
    int it
    )
{
    typedef typename Derived::Scalar Scalar;

    inout = inout.unaryExpr([&it](Scalar v){
              for (int k = 0; k < it; ++k) {
                v = std::nextafter(v, std::signbit(v) ? -std::numeric_limits<Scalar>::infinity(): std::numeric_limits<Scalar>::infinity());
              }
              return v;
            });
}

#ifdef IGL_STATIC_LIBRARY
// Explicit template instantiation
// generated by autoexplicit.sh
template void igl::increment_ulp<Eigen::Matrix<float, 1, -1, 1, 1, -1>>(Eigen::MatrixBase<Eigen::Matrix<float, 1, -1, 1, 1, -1>>&, int);
// generated by autoexplicit.sh
template void igl::increment_ulp<Eigen::Matrix<float, 1, 3, 1, 1, 3>>(Eigen::MatrixBase<Eigen::Matrix<float, 1, 3, 1, 1, 3>>&, int);
// generated by autoexplicit.sh
template void igl::increment_ulp<Eigen::Matrix<double, 1, 3, 1, 1, 3>>(Eigen::MatrixBase<Eigen::Matrix<double, 1, 3, 1, 1, 3>>&, int);
#endif
