/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated plain C Header file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

#include "lib3mf_types.h"
#include "lib3mf_dynamic.h"
#ifdef _WIN32
#include <windows.h>
#else // _WIN32
#include <dlfcn.h>
#include <stdlib.h>
#endif // _WIN32

Lib3MFResult InitLib3MFWrapperTable(sLib3MFDynamicWrapperTable * pWrapperTable)
{
	if (pWrapperTable == NULL)
		return LIB3MF_ERROR_INVALIDPARAM;
	
	pWrapperTable->m_LibraryHandle = NULL;
	pWrapperTable->m_Base_ClassTypeId = NULL;
	pWrapperTable->m_Writer_WriteToFile = NULL;
	pWrapperTable->m_Writer_GetStreamSize = NULL;
	pWrapperTable->m_Writer_WriteToBuffer = NULL;
	pWrapperTable->m_Writer_WriteToCallback = NULL;
	pWrapperTable->m_Writer_SetProgressCallback = NULL;
	pWrapperTable->m_Writer_GetDecimalPrecision = NULL;
	pWrapperTable->m_Writer_SetDecimalPrecision = NULL;
	pWrapperTable->m_Writer_SetStrictModeActive = NULL;
	pWrapperTable->m_Writer_GetStrictModeActive = NULL;
	pWrapperTable->m_Writer_GetWarning = NULL;
	pWrapperTable->m_Writer_GetWarningCount = NULL;
	pWrapperTable->m_Writer_AddKeyWrappingCallback = NULL;
	pWrapperTable->m_Writer_SetContentEncryptionCallback = NULL;
	pWrapperTable->m_Reader_ReadFromFile = NULL;
	pWrapperTable->m_Reader_ReadFromBuffer = NULL;
	pWrapperTable->m_Reader_ReadFromCallback = NULL;
	pWrapperTable->m_Reader_SetProgressCallback = NULL;
	pWrapperTable->m_Reader_AddRelationToRead = NULL;
	pWrapperTable->m_Reader_RemoveRelationToRead = NULL;
	pWrapperTable->m_Reader_SetStrictModeActive = NULL;
	pWrapperTable->m_Reader_GetStrictModeActive = NULL;
	pWrapperTable->m_Reader_GetWarning = NULL;
	pWrapperTable->m_Reader_GetWarningCount = NULL;
	pWrapperTable->m_Reader_AddKeyWrappingCallback = NULL;
	pWrapperTable->m_Reader_SetContentEncryptionCallback = NULL;
	pWrapperTable->m_PackagePart_GetPath = NULL;
	pWrapperTable->m_PackagePart_SetPath = NULL;
	pWrapperTable->m_Resource_GetResourceID = NULL;
	pWrapperTable->m_Resource_GetUniqueResourceID = NULL;
	pWrapperTable->m_Resource_PackagePart = NULL;
	pWrapperTable->m_Resource_SetPackagePart = NULL;
	pWrapperTable->m_Resource_GetModelResourceID = NULL;
	pWrapperTable->m_ResourceIterator_MoveNext = NULL;
	pWrapperTable->m_ResourceIterator_MovePrevious = NULL;
	pWrapperTable->m_ResourceIterator_GetCurrent = NULL;
	pWrapperTable->m_ResourceIterator_Clone = NULL;
	pWrapperTable->m_ResourceIterator_Count = NULL;
	pWrapperTable->m_SliceStackIterator_GetCurrentSliceStack = NULL;
	pWrapperTable->m_ObjectIterator_GetCurrentObject = NULL;
	pWrapperTable->m_MeshObjectIterator_GetCurrentMeshObject = NULL;
	pWrapperTable->m_ComponentsObjectIterator_GetCurrentComponentsObject = NULL;
	pWrapperTable->m_Texture2DIterator_GetCurrentTexture2D = NULL;
	pWrapperTable->m_BaseMaterialGroupIterator_GetCurrentBaseMaterialGroup = NULL;
	pWrapperTable->m_ColorGroupIterator_GetCurrentColorGroup = NULL;
	pWrapperTable->m_Texture2DGroupIterator_GetCurrentTexture2DGroup = NULL;
	pWrapperTable->m_CompositeMaterialsIterator_GetCurrentCompositeMaterials = NULL;
	pWrapperTable->m_MultiPropertyGroupIterator_GetCurrentMultiPropertyGroup = NULL;
	pWrapperTable->m_Image3DIterator_GetCurrentImage3D = NULL;
	pWrapperTable->m_FunctionIterator_GetCurrentFunction = NULL;
	pWrapperTable->m_LevelSetIterator_GetCurrentLevelSet = NULL;
	pWrapperTable->m_MetaData_GetNameSpace = NULL;
	pWrapperTable->m_MetaData_SetNameSpace = NULL;
	pWrapperTable->m_MetaData_GetName = NULL;
	pWrapperTable->m_MetaData_SetName = NULL;
	pWrapperTable->m_MetaData_GetKey = NULL;
	pWrapperTable->m_MetaData_GetMustPreserve = NULL;
	pWrapperTable->m_MetaData_SetMustPreserve = NULL;
	pWrapperTable->m_MetaData_GetType = NULL;
	pWrapperTable->m_MetaData_SetType = NULL;
	pWrapperTable->m_MetaData_GetValue = NULL;
	pWrapperTable->m_MetaData_SetValue = NULL;
	pWrapperTable->m_MetaDataGroup_GetMetaDataCount = NULL;
	pWrapperTable->m_MetaDataGroup_GetMetaData = NULL;
	pWrapperTable->m_MetaDataGroup_GetMetaDataByKey = NULL;
	pWrapperTable->m_MetaDataGroup_RemoveMetaDataByIndex = NULL;
	pWrapperTable->m_MetaDataGroup_RemoveMetaData = NULL;
	pWrapperTable->m_MetaDataGroup_AddMetaData = NULL;
	pWrapperTable->m_TriangleSet_SetName = NULL;
	pWrapperTable->m_TriangleSet_GetName = NULL;
	pWrapperTable->m_TriangleSet_SetIdentifier = NULL;
	pWrapperTable->m_TriangleSet_GetIdentifier = NULL;
	pWrapperTable->m_TriangleSet_AddTriangle = NULL;
	pWrapperTable->m_TriangleSet_RemoveTriangle = NULL;
	pWrapperTable->m_TriangleSet_Clear = NULL;
	pWrapperTable->m_TriangleSet_SetTriangleList = NULL;
	pWrapperTable->m_TriangleSet_GetTriangleList = NULL;
	pWrapperTable->m_TriangleSet_AddTriangleList = NULL;
	pWrapperTable->m_TriangleSet_Merge = NULL;
	pWrapperTable->m_TriangleSet_DeleteSet = NULL;
	pWrapperTable->m_TriangleSet_Duplicate = NULL;
	pWrapperTable->m_Object_GetType = NULL;
	pWrapperTable->m_Object_SetType = NULL;
	pWrapperTable->m_Object_GetName = NULL;
	pWrapperTable->m_Object_SetName = NULL;
	pWrapperTable->m_Object_GetPartNumber = NULL;
	pWrapperTable->m_Object_SetPartNumber = NULL;
	pWrapperTable->m_Object_IsMeshObject = NULL;
	pWrapperTable->m_Object_IsComponentsObject = NULL;
	pWrapperTable->m_Object_IsLevelSetObject = NULL;
	pWrapperTable->m_Object_IsValid = NULL;
	pWrapperTable->m_Object_SetAttachmentAsThumbnail = NULL;
	pWrapperTable->m_Object_GetThumbnailAttachment = NULL;
	pWrapperTable->m_Object_ClearThumbnailAttachment = NULL;
	pWrapperTable->m_Object_GetOutbox = NULL;
	pWrapperTable->m_Object_GetUUID = NULL;
	pWrapperTable->m_Object_SetUUID = NULL;
	pWrapperTable->m_Object_GetMetaDataGroup = NULL;
	pWrapperTable->m_Object_SetSlicesMeshResolution = NULL;
	pWrapperTable->m_Object_GetSlicesMeshResolution = NULL;
	pWrapperTable->m_Object_HasSlices = NULL;
	pWrapperTable->m_Object_ClearSliceStack = NULL;
	pWrapperTable->m_Object_GetSliceStack = NULL;
	pWrapperTable->m_Object_AssignSliceStack = NULL;
	pWrapperTable->m_MeshObject_GetVertexCount = NULL;
	pWrapperTable->m_MeshObject_GetTriangleCount = NULL;
	pWrapperTable->m_MeshObject_GetVertex = NULL;
	pWrapperTable->m_MeshObject_SetVertex = NULL;
	pWrapperTable->m_MeshObject_AddVertex = NULL;
	pWrapperTable->m_MeshObject_GetVertices = NULL;
	pWrapperTable->m_MeshObject_GetTriangle = NULL;
	pWrapperTable->m_MeshObject_SetTriangle = NULL;
	pWrapperTable->m_MeshObject_AddTriangle = NULL;
	pWrapperTable->m_MeshObject_GetTriangleIndices = NULL;
	pWrapperTable->m_MeshObject_SetObjectLevelProperty = NULL;
	pWrapperTable->m_MeshObject_GetObjectLevelProperty = NULL;
	pWrapperTable->m_MeshObject_SetTriangleProperties = NULL;
	pWrapperTable->m_MeshObject_GetTriangleProperties = NULL;
	pWrapperTable->m_MeshObject_SetAllTriangleProperties = NULL;
	pWrapperTable->m_MeshObject_GetAllTriangleProperties = NULL;
	pWrapperTable->m_MeshObject_ClearAllProperties = NULL;
	pWrapperTable->m_MeshObject_SetGeometry = NULL;
	pWrapperTable->m_MeshObject_IsManifoldAndOriented = NULL;
	pWrapperTable->m_MeshObject_BeamLattice = NULL;
	pWrapperTable->m_MeshObject_GetVolumeData = NULL;
	pWrapperTable->m_MeshObject_SetVolumeData = NULL;
	pWrapperTable->m_MeshObject_AddTriangleSet = NULL;
	pWrapperTable->m_MeshObject_HasTriangleSet = NULL;
	pWrapperTable->m_MeshObject_FindTriangleSet = NULL;
	pWrapperTable->m_MeshObject_GetTriangleSetCount = NULL;
	pWrapperTable->m_MeshObject_GetTriangleSet = NULL;
	pWrapperTable->m_LevelSet_GetFunction = NULL;
	pWrapperTable->m_LevelSet_SetFunction = NULL;
	pWrapperTable->m_LevelSet_GetTransform = NULL;
	pWrapperTable->m_LevelSet_SetTransform = NULL;
	pWrapperTable->m_LevelSet_GetChannelName = NULL;
	pWrapperTable->m_LevelSet_SetChannelName = NULL;
	pWrapperTable->m_LevelSet_SetMinFeatureSize = NULL;
	pWrapperTable->m_LevelSet_GetMinFeatureSize = NULL;
	pWrapperTable->m_LevelSet_SetFallBackValue = NULL;
	pWrapperTable->m_LevelSet_GetFallBackValue = NULL;
	pWrapperTable->m_LevelSet_SetMeshBBoxOnly = NULL;
	pWrapperTable->m_LevelSet_GetMeshBBoxOnly = NULL;
	pWrapperTable->m_LevelSet_SetMesh = NULL;
	pWrapperTable->m_LevelSet_GetMesh = NULL;
	pWrapperTable->m_LevelSet_GetVolumeData = NULL;
	pWrapperTable->m_LevelSet_SetVolumeData = NULL;
	pWrapperTable->m_BeamLattice_GetMinLength = NULL;
	pWrapperTable->m_BeamLattice_SetMinLength = NULL;
	pWrapperTable->m_BeamLattice_GetClipping = NULL;
	pWrapperTable->m_BeamLattice_SetClipping = NULL;
	pWrapperTable->m_BeamLattice_GetRepresentation = NULL;
	pWrapperTable->m_BeamLattice_SetRepresentation = NULL;
	pWrapperTable->m_BeamLattice_GetBallOptions = NULL;
	pWrapperTable->m_BeamLattice_SetBallOptions = NULL;
	pWrapperTable->m_BeamLattice_GetBeamCount = NULL;
	pWrapperTable->m_BeamLattice_GetBeam = NULL;
	pWrapperTable->m_BeamLattice_AddBeam = NULL;
	pWrapperTable->m_BeamLattice_SetBeam = NULL;
	pWrapperTable->m_BeamLattice_SetBeams = NULL;
	pWrapperTable->m_BeamLattice_GetBeams = NULL;
	pWrapperTable->m_BeamLattice_GetBallCount = NULL;
	pWrapperTable->m_BeamLattice_GetBall = NULL;
	pWrapperTable->m_BeamLattice_AddBall = NULL;
	pWrapperTable->m_BeamLattice_SetBall = NULL;
	pWrapperTable->m_BeamLattice_SetBalls = NULL;
	pWrapperTable->m_BeamLattice_GetBalls = NULL;
	pWrapperTable->m_BeamLattice_GetBeamSetCount = NULL;
	pWrapperTable->m_BeamLattice_AddBeamSet = NULL;
	pWrapperTable->m_BeamLattice_GetBeamSet = NULL;
	pWrapperTable->m_FunctionReference_GetFunctionResourceID = NULL;
	pWrapperTable->m_FunctionReference_SetFunctionResourceID = NULL;
	pWrapperTable->m_FunctionReference_GetTransform = NULL;
	pWrapperTable->m_FunctionReference_SetTransform = NULL;
	pWrapperTable->m_FunctionReference_GetChannelName = NULL;
	pWrapperTable->m_FunctionReference_SetChannelName = NULL;
	pWrapperTable->m_FunctionReference_SetMinFeatureSize = NULL;
	pWrapperTable->m_FunctionReference_GetMinFeatureSize = NULL;
	pWrapperTable->m_FunctionReference_SetFallBackValue = NULL;
	pWrapperTable->m_FunctionReference_GetFallBackValue = NULL;
	pWrapperTable->m_VolumeDataComposite_GetBaseMaterialGroup = NULL;
	pWrapperTable->m_VolumeDataComposite_SetBaseMaterialGroup = NULL;
	pWrapperTable->m_VolumeDataComposite_GetMaterialMappingCount = NULL;
	pWrapperTable->m_VolumeDataComposite_GetMaterialMapping = NULL;
	pWrapperTable->m_VolumeDataComposite_AddMaterialMapping = NULL;
	pWrapperTable->m_VolumeDataComposite_RemoveMaterialMapping = NULL;
	pWrapperTable->m_VolumeDataProperty_GetName = NULL;
	pWrapperTable->m_VolumeDataProperty_SetIsRequired = NULL;
	pWrapperTable->m_VolumeDataProperty_IsRequired = NULL;
	pWrapperTable->m_VolumeData_GetComposite = NULL;
	pWrapperTable->m_VolumeData_CreateNewComposite = NULL;
	pWrapperTable->m_VolumeData_RemoveComposite = NULL;
	pWrapperTable->m_VolumeData_GetColor = NULL;
	pWrapperTable->m_VolumeData_CreateNewColor = NULL;
	pWrapperTable->m_VolumeData_RemoveColor = NULL;
	pWrapperTable->m_VolumeData_GetPropertyCount = NULL;
	pWrapperTable->m_VolumeData_GetProperty = NULL;
	pWrapperTable->m_VolumeData_AddPropertyFromFunction = NULL;
	pWrapperTable->m_VolumeData_RemoveProperty = NULL;
	pWrapperTable->m_Component_GetObjectResource = NULL;
	pWrapperTable->m_Component_GetObjectResourceID = NULL;
	pWrapperTable->m_Component_GetUUID = NULL;
	pWrapperTable->m_Component_SetUUID = NULL;
	pWrapperTable->m_Component_HasTransform = NULL;
	pWrapperTable->m_Component_GetTransform = NULL;
	pWrapperTable->m_Component_SetTransform = NULL;
	pWrapperTable->m_ComponentsObject_AddComponent = NULL;
	pWrapperTable->m_ComponentsObject_GetComponent = NULL;
	pWrapperTable->m_ComponentsObject_GetComponentCount = NULL;
	pWrapperTable->m_BeamSet_SetName = NULL;
	pWrapperTable->m_BeamSet_GetName = NULL;
	pWrapperTable->m_BeamSet_SetIdentifier = NULL;
	pWrapperTable->m_BeamSet_GetIdentifier = NULL;
	pWrapperTable->m_BeamSet_GetReferenceCount = NULL;
	pWrapperTable->m_BeamSet_SetReferences = NULL;
	pWrapperTable->m_BeamSet_GetReferences = NULL;
	pWrapperTable->m_BeamSet_GetBallReferenceCount = NULL;
	pWrapperTable->m_BeamSet_SetBallReferences = NULL;
	pWrapperTable->m_BeamSet_GetBallReferences = NULL;
	pWrapperTable->m_BaseMaterialGroup_GetCount = NULL;
	pWrapperTable->m_BaseMaterialGroup_GetAllPropertyIDs = NULL;
	pWrapperTable->m_BaseMaterialGroup_AddMaterial = NULL;
	pWrapperTable->m_BaseMaterialGroup_RemoveMaterial = NULL;
	pWrapperTable->m_BaseMaterialGroup_GetName = NULL;
	pWrapperTable->m_BaseMaterialGroup_SetName = NULL;
	pWrapperTable->m_BaseMaterialGroup_SetDisplayColor = NULL;
	pWrapperTable->m_BaseMaterialGroup_GetDisplayColor = NULL;
	pWrapperTable->m_ColorGroup_GetCount = NULL;
	pWrapperTable->m_ColorGroup_GetAllPropertyIDs = NULL;
	pWrapperTable->m_ColorGroup_AddColor = NULL;
	pWrapperTable->m_ColorGroup_RemoveColor = NULL;
	pWrapperTable->m_ColorGroup_SetColor = NULL;
	pWrapperTable->m_ColorGroup_GetColor = NULL;
	pWrapperTable->m_Texture2DGroup_GetCount = NULL;
	pWrapperTable->m_Texture2DGroup_GetAllPropertyIDs = NULL;
	pWrapperTable->m_Texture2DGroup_AddTex2Coord = NULL;
	pWrapperTable->m_Texture2DGroup_GetTex2Coord = NULL;
	pWrapperTable->m_Texture2DGroup_RemoveTex2Coord = NULL;
	pWrapperTable->m_Texture2DGroup_GetTexture2D = NULL;
	pWrapperTable->m_CompositeMaterials_GetCount = NULL;
	pWrapperTable->m_CompositeMaterials_GetAllPropertyIDs = NULL;
	pWrapperTable->m_CompositeMaterials_GetBaseMaterialGroup = NULL;
	pWrapperTable->m_CompositeMaterials_AddComposite = NULL;
	pWrapperTable->m_CompositeMaterials_RemoveComposite = NULL;
	pWrapperTable->m_CompositeMaterials_GetComposite = NULL;
	pWrapperTable->m_MultiPropertyGroup_GetCount = NULL;
	pWrapperTable->m_MultiPropertyGroup_GetAllPropertyIDs = NULL;
	pWrapperTable->m_MultiPropertyGroup_AddMultiProperty = NULL;
	pWrapperTable->m_MultiPropertyGroup_SetMultiProperty = NULL;
	pWrapperTable->m_MultiPropertyGroup_GetMultiProperty = NULL;
	pWrapperTable->m_MultiPropertyGroup_RemoveMultiProperty = NULL;
	pWrapperTable->m_MultiPropertyGroup_GetLayerCount = NULL;
	pWrapperTable->m_MultiPropertyGroup_AddLayer = NULL;
	pWrapperTable->m_MultiPropertyGroup_GetLayer = NULL;
	pWrapperTable->m_MultiPropertyGroup_RemoveLayer = NULL;
	pWrapperTable->m_Image3D_GetName = NULL;
	pWrapperTable->m_Image3D_SetName = NULL;
	pWrapperTable->m_Image3D_IsImageStack = NULL;
	pWrapperTable->m_ImageStack_GetRowCount = NULL;
	pWrapperTable->m_ImageStack_SetRowCount = NULL;
	pWrapperTable->m_ImageStack_GetColumnCount = NULL;
	pWrapperTable->m_ImageStack_SetColumnCount = NULL;
	pWrapperTable->m_ImageStack_GetSheetCount = NULL;
	pWrapperTable->m_ImageStack_GetSheet = NULL;
	pWrapperTable->m_ImageStack_SetSheet = NULL;
	pWrapperTable->m_ImageStack_CreateEmptySheet = NULL;
	pWrapperTable->m_ImageStack_CreateSheetFromBuffer = NULL;
	pWrapperTable->m_ImageStack_CreateSheetFromFile = NULL;
	pWrapperTable->m_Attachment_GetPath = NULL;
	pWrapperTable->m_Attachment_SetPath = NULL;
	pWrapperTable->m_Attachment_PackagePart = NULL;
	pWrapperTable->m_Attachment_GetRelationShipType = NULL;
	pWrapperTable->m_Attachment_SetRelationShipType = NULL;
	pWrapperTable->m_Attachment_WriteToFile = NULL;
	pWrapperTable->m_Attachment_ReadFromFile = NULL;
	pWrapperTable->m_Attachment_ReadFromCallback = NULL;
	pWrapperTable->m_Attachment_GetStreamSize = NULL;
	pWrapperTable->m_Attachment_WriteToBuffer = NULL;
	pWrapperTable->m_Attachment_ReadFromBuffer = NULL;
	pWrapperTable->m_Texture2D_GetAttachment = NULL;
	pWrapperTable->m_Texture2D_SetAttachment = NULL;
	pWrapperTable->m_Texture2D_GetContentType = NULL;
	pWrapperTable->m_Texture2D_SetContentType = NULL;
	pWrapperTable->m_Texture2D_GetTileStyleUV = NULL;
	pWrapperTable->m_Texture2D_SetTileStyleUV = NULL;
	pWrapperTable->m_Texture2D_GetFilter = NULL;
	pWrapperTable->m_Texture2D_SetFilter = NULL;
	pWrapperTable->m_ImplicitPort_GetIdentifier = NULL;
	pWrapperTable->m_ImplicitPort_SetIdentifier = NULL;
	pWrapperTable->m_ImplicitPort_GetDisplayName = NULL;
	pWrapperTable->m_ImplicitPort_SetDisplayName = NULL;
	pWrapperTable->m_ImplicitPort_SetType = NULL;
	pWrapperTable->m_ImplicitPort_GetType = NULL;
	pWrapperTable->m_ImplicitPort_GetReference = NULL;
	pWrapperTable->m_ImplicitPort_SetReference = NULL;
	pWrapperTable->m_Iterator_MoveNext = NULL;
	pWrapperTable->m_Iterator_MovePrevious = NULL;
	pWrapperTable->m_Iterator_Count = NULL;
	pWrapperTable->m_ImplicitPortIterator_GetCurrent = NULL;
	pWrapperTable->m_ImplicitNode_GetIdentifier = NULL;
	pWrapperTable->m_ImplicitNode_SetIdentifier = NULL;
	pWrapperTable->m_ImplicitNode_GetDisplayName = NULL;
	pWrapperTable->m_ImplicitNode_SetDisplayName = NULL;
	pWrapperTable->m_ImplicitNode_GetTag = NULL;
	pWrapperTable->m_ImplicitNode_SetTag = NULL;
	pWrapperTable->m_ImplicitNode_GetNodeType = NULL;
	pWrapperTable->m_ImplicitNode_AddInput = NULL;
	pWrapperTable->m_ImplicitNode_GetInputs = NULL;
	pWrapperTable->m_ImplicitNode_AddOutput = NULL;
	pWrapperTable->m_ImplicitNode_GetOutputs = NULL;
	pWrapperTable->m_ImplicitNode_FindInput = NULL;
	pWrapperTable->m_ImplicitNode_FindOutput = NULL;
	pWrapperTable->m_ImplicitNode_AreTypesValid = NULL;
	pWrapperTable->m_OneInputNode_GetInputA = NULL;
	pWrapperTable->m_OneInputNode_GetOutputResult = NULL;
	pWrapperTable->m_ResourceIdNode_SetResource = NULL;
	pWrapperTable->m_ResourceIdNode_GetResource = NULL;
	pWrapperTable->m_ResourceIdNode_GetOutputValue = NULL;
	pWrapperTable->m_TwoInputNode_GetInputB = NULL;
	pWrapperTable->m_SelectNode_GetInputB = NULL;
	pWrapperTable->m_SelectNode_GetInputC = NULL;
	pWrapperTable->m_SelectNode_GetInputD = NULL;
	pWrapperTable->m_ClampNode_GetInputMin = NULL;
	pWrapperTable->m_ClampNode_GetInputMax = NULL;
	pWrapperTable->m_ComposeVectorNode_GetInputX = NULL;
	pWrapperTable->m_ComposeVectorNode_GetInputY = NULL;
	pWrapperTable->m_ComposeVectorNode_GetInputZ = NULL;
	pWrapperTable->m_ComposeVectorNode_GetOutputResult = NULL;
	pWrapperTable->m_DecomposeVectorNode_GetInputA = NULL;
	pWrapperTable->m_DecomposeVectorNode_GetOutputX = NULL;
	pWrapperTable->m_DecomposeVectorNode_GetOutputY = NULL;
	pWrapperTable->m_DecomposeVectorNode_GetOutputZ = NULL;
	pWrapperTable->m_ComposeMatrixNode_GetInputM00 = NULL;
	pWrapperTable->m_ComposeMatrixNode_GetInputM01 = NULL;
	pWrapperTable->m_ComposeMatrixNode_GetInputM02 = NULL;
	pWrapperTable->m_ComposeMatrixNode_GetInputM03 = NULL;
	pWrapperTable->m_ComposeMatrixNode_GetInputM10 = NULL;
	pWrapperTable->m_ComposeMatrixNode_GetInputM11 = NULL;
	pWrapperTable->m_ComposeMatrixNode_GetInputM12 = NULL;
	pWrapperTable->m_ComposeMatrixNode_GetInputM13 = NULL;
	pWrapperTable->m_ComposeMatrixNode_GetInputM20 = NULL;
	pWrapperTable->m_ComposeMatrixNode_GetInputM21 = NULL;
	pWrapperTable->m_ComposeMatrixNode_GetInputM22 = NULL;
	pWrapperTable->m_ComposeMatrixNode_GetInputM23 = NULL;
	pWrapperTable->m_ComposeMatrixNode_GetInputM30 = NULL;
	pWrapperTable->m_ComposeMatrixNode_GetInputM31 = NULL;
	pWrapperTable->m_ComposeMatrixNode_GetInputM32 = NULL;
	pWrapperTable->m_ComposeMatrixNode_GetInputM33 = NULL;
	pWrapperTable->m_ComposeMatrixNode_GetOutputResult = NULL;
	pWrapperTable->m_MatrixFromRowsNode_GetInputA = NULL;
	pWrapperTable->m_MatrixFromRowsNode_GetInputB = NULL;
	pWrapperTable->m_MatrixFromRowsNode_GetInputC = NULL;
	pWrapperTable->m_MatrixFromRowsNode_GetInputD = NULL;
	pWrapperTable->m_MatrixFromRowsNode_GetOutputResult = NULL;
	pWrapperTable->m_MatrixFromColumnsNode_GetInputA = NULL;
	pWrapperTable->m_MatrixFromColumnsNode_GetInputB = NULL;
	pWrapperTable->m_MatrixFromColumnsNode_GetInputC = NULL;
	pWrapperTable->m_MatrixFromColumnsNode_GetInputD = NULL;
	pWrapperTable->m_MatrixFromColumnsNode_GetOutputResult = NULL;
	pWrapperTable->m_ConstantNode_SetConstant = NULL;
	pWrapperTable->m_ConstantNode_GetConstant = NULL;
	pWrapperTable->m_ConstantNode_GetOutputValue = NULL;
	pWrapperTable->m_ConstVecNode_SetVector = NULL;
	pWrapperTable->m_ConstVecNode_GetVector = NULL;
	pWrapperTable->m_ConstVecNode_GetOutputVector = NULL;
	pWrapperTable->m_ConstMatNode_SetMatrix = NULL;
	pWrapperTable->m_ConstMatNode_GetMatrix = NULL;
	pWrapperTable->m_ConstMatNode_GetOutputMatrix = NULL;
	pWrapperTable->m_MeshNode_GetInputMesh = NULL;
	pWrapperTable->m_MeshNode_GetInputPos = NULL;
	pWrapperTable->m_MeshNode_GetOutputDistance = NULL;
	pWrapperTable->m_UnsignedMeshNode_GetInputMesh = NULL;
	pWrapperTable->m_UnsignedMeshNode_GetInputPos = NULL;
	pWrapperTable->m_UnsignedMeshNode_GetOutputDistance = NULL;
	pWrapperTable->m_BeamLatticeNode_GetInputBeamLattice = NULL;
	pWrapperTable->m_BeamLatticeNode_GetInputPos = NULL;
	pWrapperTable->m_BeamLatticeNode_GetOutputDistance = NULL;
	pWrapperTable->m_BeamLatticeNode_SetAccurateRange = NULL;
	pWrapperTable->m_BeamLatticeNode_GetAccurateRange = NULL;
	pWrapperTable->m_FunctionGradientNode_GetInputFunctionID = NULL;
	pWrapperTable->m_FunctionGradientNode_GetInputPos = NULL;
	pWrapperTable->m_FunctionGradientNode_GetInputStep = NULL;
	pWrapperTable->m_FunctionGradientNode_SetScalarOutputName = NULL;
	pWrapperTable->m_FunctionGradientNode_GetScalarOutputName = NULL;
	pWrapperTable->m_FunctionGradientNode_SetVectorInputName = NULL;
	pWrapperTable->m_FunctionGradientNode_GetVectorInputName = NULL;
	pWrapperTable->m_FunctionGradientNode_GetOutputNormalizedGradient = NULL;
	pWrapperTable->m_FunctionGradientNode_GetOutputGradient = NULL;
	pWrapperTable->m_FunctionGradientNode_GetOutputMagnitude = NULL;
	pWrapperTable->m_NormalizeDistanceNode_GetInputFunctionID = NULL;
	pWrapperTable->m_NormalizeDistanceNode_GetInputPos = NULL;
	pWrapperTable->m_NormalizeDistanceNode_GetInputStep = NULL;
	pWrapperTable->m_NormalizeDistanceNode_SetScalarOutputName = NULL;
	pWrapperTable->m_NormalizeDistanceNode_GetScalarOutputName = NULL;
	pWrapperTable->m_NormalizeDistanceNode_SetVectorInputName = NULL;
	pWrapperTable->m_NormalizeDistanceNode_GetVectorInputName = NULL;
	pWrapperTable->m_NormalizeDistanceNode_GetOutputResult = NULL;
	pWrapperTable->m_FunctionCallNode_GetInputFunctionID = NULL;
	pWrapperTable->m_NodeIterator_GetCurrent = NULL;
	pWrapperTable->m_Function_GetDisplayName = NULL;
	pWrapperTable->m_Function_SetDisplayName = NULL;
	pWrapperTable->m_Function_AddInput = NULL;
	pWrapperTable->m_Function_GetInputs = NULL;
	pWrapperTable->m_Function_RemoveInput = NULL;
	pWrapperTable->m_Function_AddOutput = NULL;
	pWrapperTable->m_Function_GetOutputs = NULL;
	pWrapperTable->m_Function_RemoveOutput = NULL;
	pWrapperTable->m_Function_FindInput = NULL;
	pWrapperTable->m_Function_FindOutput = NULL;
	pWrapperTable->m_ImplicitFunction_GetIdentifier = NULL;
	pWrapperTable->m_ImplicitFunction_SetIdentifier = NULL;
	pWrapperTable->m_ImplicitFunction_AddNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddSinNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddCosNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddTanNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddArcSinNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddArcCosNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddArcTan2Node = NULL;
	pWrapperTable->m_ImplicitFunction_AddSinhNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddCoshNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddTanhNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddRoundNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddCeilNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddFloorNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddSignNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddFractNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddAbsNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddExpNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddLogNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddLog2Node = NULL;
	pWrapperTable->m_ImplicitFunction_AddLog10Node = NULL;
	pWrapperTable->m_ImplicitFunction_AddLengthNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddTransposeNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddInverseNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddSqrtNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddResourceIdNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddAdditionNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddSubtractionNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddMultiplicationNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddDivisionNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddDotNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddCrossNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddMatVecMultiplicationNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddMinNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddMaxNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddFmodNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddPowNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddSelectNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddClampNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddComposeVectorNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddVectorFromScalarNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddDecomposeVectorNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddComposeMatrixNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddMatrixFromRowsNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddMatrixFromColumnsNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddConstantNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddConstVecNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddConstMatNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddMeshNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddUnsignedMeshNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddBeamLatticeNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddFunctionGradientNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddNormalizeDistanceNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddFunctionCallNode = NULL;
	pWrapperTable->m_ImplicitFunction_GetNodes = NULL;
	pWrapperTable->m_ImplicitFunction_RemoveNode = NULL;
	pWrapperTable->m_ImplicitFunction_AddLink = NULL;
	pWrapperTable->m_ImplicitFunction_AddLinkByNames = NULL;
	pWrapperTable->m_ImplicitFunction_Clear = NULL;
	pWrapperTable->m_ImplicitFunction_SortNodesTopologically = NULL;
	pWrapperTable->m_FunctionFromImage3D_GetImage3D = NULL;
	pWrapperTable->m_FunctionFromImage3D_SetImage3D = NULL;
	pWrapperTable->m_FunctionFromImage3D_SetFilter = NULL;
	pWrapperTable->m_FunctionFromImage3D_GetFilter = NULL;
	pWrapperTable->m_FunctionFromImage3D_SetTileStyles = NULL;
	pWrapperTable->m_FunctionFromImage3D_GetTileStyles = NULL;
	pWrapperTable->m_FunctionFromImage3D_GetOffset = NULL;
	pWrapperTable->m_FunctionFromImage3D_SetOffset = NULL;
	pWrapperTable->m_FunctionFromImage3D_GetScale = NULL;
	pWrapperTable->m_FunctionFromImage3D_SetScale = NULL;
	pWrapperTable->m_BuildItem_GetObjectResource = NULL;
	pWrapperTable->m_BuildItem_GetUUID = NULL;
	pWrapperTable->m_BuildItem_SetUUID = NULL;
	pWrapperTable->m_BuildItem_GetObjectResourceID = NULL;
	pWrapperTable->m_BuildItem_HasObjectTransform = NULL;
	pWrapperTable->m_BuildItem_GetObjectTransform = NULL;
	pWrapperTable->m_BuildItem_SetObjectTransform = NULL;
	pWrapperTable->m_BuildItem_GetPartNumber = NULL;
	pWrapperTable->m_BuildItem_SetPartNumber = NULL;
	pWrapperTable->m_BuildItem_GetMetaDataGroup = NULL;
	pWrapperTable->m_BuildItem_GetOutbox = NULL;
	pWrapperTable->m_BuildItemIterator_MoveNext = NULL;
	pWrapperTable->m_BuildItemIterator_MovePrevious = NULL;
	pWrapperTable->m_BuildItemIterator_GetCurrent = NULL;
	pWrapperTable->m_BuildItemIterator_Clone = NULL;
	pWrapperTable->m_BuildItemIterator_Count = NULL;
	pWrapperTable->m_Slice_SetVertices = NULL;
	pWrapperTable->m_Slice_GetVertices = NULL;
	pWrapperTable->m_Slice_GetVertexCount = NULL;
	pWrapperTable->m_Slice_AddPolygon = NULL;
	pWrapperTable->m_Slice_GetPolygonCount = NULL;
	pWrapperTable->m_Slice_SetPolygonIndices = NULL;
	pWrapperTable->m_Slice_GetPolygonIndices = NULL;
	pWrapperTable->m_Slice_GetPolygonIndexCount = NULL;
	pWrapperTable->m_Slice_GetZTop = NULL;
	pWrapperTable->m_SliceStack_GetBottomZ = NULL;
	pWrapperTable->m_SliceStack_GetSliceCount = NULL;
	pWrapperTable->m_SliceStack_GetSlice = NULL;
	pWrapperTable->m_SliceStack_AddSlice = NULL;
	pWrapperTable->m_SliceStack_GetSliceRefCount = NULL;
	pWrapperTable->m_SliceStack_AddSliceStackReference = NULL;
	pWrapperTable->m_SliceStack_GetSliceStackReference = NULL;
	pWrapperTable->m_SliceStack_CollapseSliceReferences = NULL;
	pWrapperTable->m_SliceStack_SetOwnPath = NULL;
	pWrapperTable->m_SliceStack_GetOwnPath = NULL;
	pWrapperTable->m_Consumer_GetConsumerID = NULL;
	pWrapperTable->m_Consumer_GetKeyID = NULL;
	pWrapperTable->m_Consumer_GetKeyValue = NULL;
	pWrapperTable->m_AccessRight_GetConsumer = NULL;
	pWrapperTable->m_AccessRight_GetWrappingAlgorithm = NULL;
	pWrapperTable->m_AccessRight_GetMgfAlgorithm = NULL;
	pWrapperTable->m_AccessRight_GetDigestMethod = NULL;
	pWrapperTable->m_ContentEncryptionParams_GetEncryptionAlgorithm = NULL;
	pWrapperTable->m_ContentEncryptionParams_GetKey = NULL;
	pWrapperTable->m_ContentEncryptionParams_GetInitializationVector = NULL;
	pWrapperTable->m_ContentEncryptionParams_GetAuthenticationTag = NULL;
	pWrapperTable->m_ContentEncryptionParams_SetAuthenticationTag = NULL;
	pWrapperTable->m_ContentEncryptionParams_GetAdditionalAuthenticationData = NULL;
	pWrapperTable->m_ContentEncryptionParams_GetDescriptor = NULL;
	pWrapperTable->m_ContentEncryptionParams_GetKeyUUID = NULL;
	pWrapperTable->m_ResourceData_GetPath = NULL;
	pWrapperTable->m_ResourceData_GetEncryptionAlgorithm = NULL;
	pWrapperTable->m_ResourceData_GetCompression = NULL;
	pWrapperTable->m_ResourceData_GetAdditionalAuthenticationData = NULL;
	pWrapperTable->m_ResourceDataGroup_GetKeyUUID = NULL;
	pWrapperTable->m_ResourceDataGroup_AddAccessRight = NULL;
	pWrapperTable->m_ResourceDataGroup_FindAccessRightByConsumer = NULL;
	pWrapperTable->m_ResourceDataGroup_RemoveAccessRight = NULL;
	pWrapperTable->m_KeyStore_AddConsumer = NULL;
	pWrapperTable->m_KeyStore_GetConsumerCount = NULL;
	pWrapperTable->m_KeyStore_GetConsumer = NULL;
	pWrapperTable->m_KeyStore_RemoveConsumer = NULL;
	pWrapperTable->m_KeyStore_FindConsumer = NULL;
	pWrapperTable->m_KeyStore_GetResourceDataGroupCount = NULL;
	pWrapperTable->m_KeyStore_AddResourceDataGroup = NULL;
	pWrapperTable->m_KeyStore_GetResourceDataGroup = NULL;
	pWrapperTable->m_KeyStore_RemoveResourceDataGroup = NULL;
	pWrapperTable->m_KeyStore_FindResourceDataGroup = NULL;
	pWrapperTable->m_KeyStore_AddResourceData = NULL;
	pWrapperTable->m_KeyStore_RemoveResourceData = NULL;
	pWrapperTable->m_KeyStore_FindResourceData = NULL;
	pWrapperTable->m_KeyStore_GetResourceDataCount = NULL;
	pWrapperTable->m_KeyStore_GetResourceData = NULL;
	pWrapperTable->m_KeyStore_GetUUID = NULL;
	pWrapperTable->m_KeyStore_SetUUID = NULL;
	pWrapperTable->m_Model_RootModelPart = NULL;
	pWrapperTable->m_Model_FindOrCreatePackagePart = NULL;
	pWrapperTable->m_Model_SetUnit = NULL;
	pWrapperTable->m_Model_GetUnit = NULL;
	pWrapperTable->m_Model_GetLanguage = NULL;
	pWrapperTable->m_Model_SetLanguage = NULL;
	pWrapperTable->m_Model_QueryWriter = NULL;
	pWrapperTable->m_Model_QueryReader = NULL;
	pWrapperTable->m_Model_GetResourceByID = NULL;
	pWrapperTable->m_Model_GetTexture2DByID = NULL;
	pWrapperTable->m_Model_GetPropertyTypeByID = NULL;
	pWrapperTable->m_Model_GetBaseMaterialGroupByID = NULL;
	pWrapperTable->m_Model_GetTexture2DGroupByID = NULL;
	pWrapperTable->m_Model_GetCompositeMaterialsByID = NULL;
	pWrapperTable->m_Model_GetMultiPropertyGroupByID = NULL;
	pWrapperTable->m_Model_GetMeshObjectByID = NULL;
	pWrapperTable->m_Model_GetComponentsObjectByID = NULL;
	pWrapperTable->m_Model_GetColorGroupByID = NULL;
	pWrapperTable->m_Model_GetSliceStackByID = NULL;
	pWrapperTable->m_Model_GetLevelSetByID = NULL;
	pWrapperTable->m_Model_GetBuildUUID = NULL;
	pWrapperTable->m_Model_SetBuildUUID = NULL;
	pWrapperTable->m_Model_GetBuildItems = NULL;
	pWrapperTable->m_Model_GetOutbox = NULL;
	pWrapperTable->m_Model_GetResources = NULL;
	pWrapperTable->m_Model_GetObjects = NULL;
	pWrapperTable->m_Model_GetMeshObjects = NULL;
	pWrapperTable->m_Model_GetComponentsObjects = NULL;
	pWrapperTable->m_Model_GetTexture2Ds = NULL;
	pWrapperTable->m_Model_GetBaseMaterialGroups = NULL;
	pWrapperTable->m_Model_GetColorGroups = NULL;
	pWrapperTable->m_Model_GetTexture2DGroups = NULL;
	pWrapperTable->m_Model_GetCompositeMaterials = NULL;
	pWrapperTable->m_Model_GetMultiPropertyGroups = NULL;
	pWrapperTable->m_Model_GetSliceStacks = NULL;
	pWrapperTable->m_Model_GetImage3Ds = NULL;
	pWrapperTable->m_Model_MergeToModel = NULL;
	pWrapperTable->m_Model_MergeFromModel = NULL;
	pWrapperTable->m_Model_AddMeshObject = NULL;
	pWrapperTable->m_Model_AddComponentsObject = NULL;
	pWrapperTable->m_Model_AddSliceStack = NULL;
	pWrapperTable->m_Model_AddTexture2DFromAttachment = NULL;
	pWrapperTable->m_Model_AddBaseMaterialGroup = NULL;
	pWrapperTable->m_Model_AddColorGroup = NULL;
	pWrapperTable->m_Model_AddTexture2DGroup = NULL;
	pWrapperTable->m_Model_AddCompositeMaterials = NULL;
	pWrapperTable->m_Model_AddMultiPropertyGroup = NULL;
	pWrapperTable->m_Model_AddImageStack = NULL;
	pWrapperTable->m_Model_GetImageStackByID = NULL;
	pWrapperTable->m_Model_AddBuildItem = NULL;
	pWrapperTable->m_Model_RemoveBuildItem = NULL;
	pWrapperTable->m_Model_GetMetaDataGroup = NULL;
	pWrapperTable->m_Model_AddAttachment = NULL;
	pWrapperTable->m_Model_RemoveAttachment = NULL;
	pWrapperTable->m_Model_GetAttachment = NULL;
	pWrapperTable->m_Model_FindAttachment = NULL;
	pWrapperTable->m_Model_GetAttachmentCount = NULL;
	pWrapperTable->m_Model_HasPackageThumbnailAttachment = NULL;
	pWrapperTable->m_Model_CreatePackageThumbnailAttachment = NULL;
	pWrapperTable->m_Model_GetPackageThumbnailAttachment = NULL;
	pWrapperTable->m_Model_RemovePackageThumbnailAttachment = NULL;
	pWrapperTable->m_Model_AddCustomContentType = NULL;
	pWrapperTable->m_Model_RemoveCustomContentType = NULL;
	pWrapperTable->m_Model_SetRandomNumberCallback = NULL;
	pWrapperTable->m_Model_GetKeyStore = NULL;
	pWrapperTable->m_Model_GetFunctions = NULL;
	pWrapperTable->m_Model_AddImplicitFunction = NULL;
	pWrapperTable->m_Model_AddFunctionFromImage3D = NULL;
	pWrapperTable->m_Model_AddVolumeData = NULL;
	pWrapperTable->m_Model_AddLevelSet = NULL;
	pWrapperTable->m_Model_GetLevelSets = NULL;
	pWrapperTable->m_Model_RemoveResource = NULL;
	pWrapperTable->m_GetLibraryVersion = NULL;
	pWrapperTable->m_GetPrereleaseInformation = NULL;
	pWrapperTable->m_GetBuildInformation = NULL;
	pWrapperTable->m_GetSpecificationVersion = NULL;
	pWrapperTable->m_CreateModel = NULL;
	pWrapperTable->m_Release = NULL;
	pWrapperTable->m_Acquire = NULL;
	pWrapperTable->m_SetJournal = NULL;
	pWrapperTable->m_GetLastError = NULL;
	pWrapperTable->m_GetSymbolLookupMethod = NULL;
	pWrapperTable->m_RetrieveProgressMessage = NULL;
	pWrapperTable->m_RGBAToColor = NULL;
	pWrapperTable->m_FloatRGBAToColor = NULL;
	pWrapperTable->m_ColorToRGBA = NULL;
	pWrapperTable->m_ColorToFloatRGBA = NULL;
	pWrapperTable->m_GetIdentityTransform = NULL;
	pWrapperTable->m_GetUniformScaleTransform = NULL;
	pWrapperTable->m_GetScaleTransform = NULL;
	pWrapperTable->m_GetTranslationTransform = NULL;
	
	return LIB3MF_SUCCESS;
}

Lib3MFResult ReleaseLib3MFWrapperTable(sLib3MFDynamicWrapperTable * pWrapperTable)
{
	if (pWrapperTable == NULL)
		return LIB3MF_ERROR_INVALIDPARAM;
	
	if (pWrapperTable->m_LibraryHandle != NULL) {
	#ifdef _WIN32
		HMODULE hModule = (HMODULE) pWrapperTable->m_LibraryHandle;
		FreeLibrary(hModule);
	#else // _WIN32
		dlclose(pWrapperTable->m_LibraryHandle);
	#endif // _WIN32
		return InitLib3MFWrapperTable(pWrapperTable);
	}
	
	return LIB3MF_SUCCESS;
}

Lib3MFResult LoadLib3MFWrapperTable(sLib3MFDynamicWrapperTable * pWrapperTable, const char * pLibraryFileName)
{
	if (pWrapperTable == NULL)
		return LIB3MF_ERROR_INVALIDPARAM;
	if (pLibraryFileName == NULL)
		return LIB3MF_ERROR_INVALIDPARAM;
	
	#ifdef _WIN32
	// Convert filename to UTF16-string
	int nLength = 0;
	while ((pLibraryFileName[nLength] != 0) && (nLength < MAX_PATH))
		nLength++;
	int nBufferSize = nLength * 2 + 2;
	wchar_t* wsLibraryFileName = (wchar_t*)malloc(nBufferSize*sizeof(wchar_t));
	memset(wsLibraryFileName, 0, nBufferSize*sizeof(wchar_t));
	int nResult = MultiByteToWideChar(CP_UTF8, 0, pLibraryFileName, nLength, wsLibraryFileName, nBufferSize);
	if (nResult == 0) {
		free(wsLibraryFileName);
		return LIB3MF_ERROR_COULDNOTLOADLIBRARY;
	}
	
	HMODULE hLibrary = LoadLibraryW(wsLibraryFileName);
	free(wsLibraryFileName);
	if (hLibrary == 0) 
		return LIB3MF_ERROR_COULDNOTLOADLIBRARY;
	#else // _WIN32
	void* hLibrary = dlopen(pLibraryFileName, RTLD_LAZY);
	if (hLibrary == 0) 
		return LIB3MF_ERROR_COULDNOTLOADLIBRARY;
	dlerror();
	#endif // _WIN32
	
	#ifdef _WIN32
	pWrapperTable->m_Base_ClassTypeId = (PLib3MFBase_ClassTypeIdPtr) GetProcAddress(hLibrary, "lib3mf_base_classtypeid");
	#else // _WIN32
	pWrapperTable->m_Base_ClassTypeId = (PLib3MFBase_ClassTypeIdPtr) dlsym(hLibrary, "lib3mf_base_classtypeid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Base_ClassTypeId == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Writer_WriteToFile = (PLib3MFWriter_WriteToFilePtr) GetProcAddress(hLibrary, "lib3mf_writer_writetofile");
	#else // _WIN32
	pWrapperTable->m_Writer_WriteToFile = (PLib3MFWriter_WriteToFilePtr) dlsym(hLibrary, "lib3mf_writer_writetofile");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Writer_WriteToFile == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Writer_GetStreamSize = (PLib3MFWriter_GetStreamSizePtr) GetProcAddress(hLibrary, "lib3mf_writer_getstreamsize");
	#else // _WIN32
	pWrapperTable->m_Writer_GetStreamSize = (PLib3MFWriter_GetStreamSizePtr) dlsym(hLibrary, "lib3mf_writer_getstreamsize");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Writer_GetStreamSize == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Writer_WriteToBuffer = (PLib3MFWriter_WriteToBufferPtr) GetProcAddress(hLibrary, "lib3mf_writer_writetobuffer");
	#else // _WIN32
	pWrapperTable->m_Writer_WriteToBuffer = (PLib3MFWriter_WriteToBufferPtr) dlsym(hLibrary, "lib3mf_writer_writetobuffer");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Writer_WriteToBuffer == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Writer_WriteToCallback = (PLib3MFWriter_WriteToCallbackPtr) GetProcAddress(hLibrary, "lib3mf_writer_writetocallback");
	#else // _WIN32
	pWrapperTable->m_Writer_WriteToCallback = (PLib3MFWriter_WriteToCallbackPtr) dlsym(hLibrary, "lib3mf_writer_writetocallback");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Writer_WriteToCallback == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Writer_SetProgressCallback = (PLib3MFWriter_SetProgressCallbackPtr) GetProcAddress(hLibrary, "lib3mf_writer_setprogresscallback");
	#else // _WIN32
	pWrapperTable->m_Writer_SetProgressCallback = (PLib3MFWriter_SetProgressCallbackPtr) dlsym(hLibrary, "lib3mf_writer_setprogresscallback");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Writer_SetProgressCallback == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Writer_GetDecimalPrecision = (PLib3MFWriter_GetDecimalPrecisionPtr) GetProcAddress(hLibrary, "lib3mf_writer_getdecimalprecision");
	#else // _WIN32
	pWrapperTable->m_Writer_GetDecimalPrecision = (PLib3MFWriter_GetDecimalPrecisionPtr) dlsym(hLibrary, "lib3mf_writer_getdecimalprecision");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Writer_GetDecimalPrecision == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Writer_SetDecimalPrecision = (PLib3MFWriter_SetDecimalPrecisionPtr) GetProcAddress(hLibrary, "lib3mf_writer_setdecimalprecision");
	#else // _WIN32
	pWrapperTable->m_Writer_SetDecimalPrecision = (PLib3MFWriter_SetDecimalPrecisionPtr) dlsym(hLibrary, "lib3mf_writer_setdecimalprecision");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Writer_SetDecimalPrecision == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Writer_SetStrictModeActive = (PLib3MFWriter_SetStrictModeActivePtr) GetProcAddress(hLibrary, "lib3mf_writer_setstrictmodeactive");
	#else // _WIN32
	pWrapperTable->m_Writer_SetStrictModeActive = (PLib3MFWriter_SetStrictModeActivePtr) dlsym(hLibrary, "lib3mf_writer_setstrictmodeactive");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Writer_SetStrictModeActive == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Writer_GetStrictModeActive = (PLib3MFWriter_GetStrictModeActivePtr) GetProcAddress(hLibrary, "lib3mf_writer_getstrictmodeactive");
	#else // _WIN32
	pWrapperTable->m_Writer_GetStrictModeActive = (PLib3MFWriter_GetStrictModeActivePtr) dlsym(hLibrary, "lib3mf_writer_getstrictmodeactive");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Writer_GetStrictModeActive == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Writer_GetWarning = (PLib3MFWriter_GetWarningPtr) GetProcAddress(hLibrary, "lib3mf_writer_getwarning");
	#else // _WIN32
	pWrapperTable->m_Writer_GetWarning = (PLib3MFWriter_GetWarningPtr) dlsym(hLibrary, "lib3mf_writer_getwarning");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Writer_GetWarning == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Writer_GetWarningCount = (PLib3MFWriter_GetWarningCountPtr) GetProcAddress(hLibrary, "lib3mf_writer_getwarningcount");
	#else // _WIN32
	pWrapperTable->m_Writer_GetWarningCount = (PLib3MFWriter_GetWarningCountPtr) dlsym(hLibrary, "lib3mf_writer_getwarningcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Writer_GetWarningCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Writer_AddKeyWrappingCallback = (PLib3MFWriter_AddKeyWrappingCallbackPtr) GetProcAddress(hLibrary, "lib3mf_writer_addkeywrappingcallback");
	#else // _WIN32
	pWrapperTable->m_Writer_AddKeyWrappingCallback = (PLib3MFWriter_AddKeyWrappingCallbackPtr) dlsym(hLibrary, "lib3mf_writer_addkeywrappingcallback");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Writer_AddKeyWrappingCallback == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Writer_SetContentEncryptionCallback = (PLib3MFWriter_SetContentEncryptionCallbackPtr) GetProcAddress(hLibrary, "lib3mf_writer_setcontentencryptioncallback");
	#else // _WIN32
	pWrapperTable->m_Writer_SetContentEncryptionCallback = (PLib3MFWriter_SetContentEncryptionCallbackPtr) dlsym(hLibrary, "lib3mf_writer_setcontentencryptioncallback");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Writer_SetContentEncryptionCallback == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Reader_ReadFromFile = (PLib3MFReader_ReadFromFilePtr) GetProcAddress(hLibrary, "lib3mf_reader_readfromfile");
	#else // _WIN32
	pWrapperTable->m_Reader_ReadFromFile = (PLib3MFReader_ReadFromFilePtr) dlsym(hLibrary, "lib3mf_reader_readfromfile");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Reader_ReadFromFile == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Reader_ReadFromBuffer = (PLib3MFReader_ReadFromBufferPtr) GetProcAddress(hLibrary, "lib3mf_reader_readfrombuffer");
	#else // _WIN32
	pWrapperTable->m_Reader_ReadFromBuffer = (PLib3MFReader_ReadFromBufferPtr) dlsym(hLibrary, "lib3mf_reader_readfrombuffer");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Reader_ReadFromBuffer == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Reader_ReadFromCallback = (PLib3MFReader_ReadFromCallbackPtr) GetProcAddress(hLibrary, "lib3mf_reader_readfromcallback");
	#else // _WIN32
	pWrapperTable->m_Reader_ReadFromCallback = (PLib3MFReader_ReadFromCallbackPtr) dlsym(hLibrary, "lib3mf_reader_readfromcallback");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Reader_ReadFromCallback == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Reader_SetProgressCallback = (PLib3MFReader_SetProgressCallbackPtr) GetProcAddress(hLibrary, "lib3mf_reader_setprogresscallback");
	#else // _WIN32
	pWrapperTable->m_Reader_SetProgressCallback = (PLib3MFReader_SetProgressCallbackPtr) dlsym(hLibrary, "lib3mf_reader_setprogresscallback");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Reader_SetProgressCallback == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Reader_AddRelationToRead = (PLib3MFReader_AddRelationToReadPtr) GetProcAddress(hLibrary, "lib3mf_reader_addrelationtoread");
	#else // _WIN32
	pWrapperTable->m_Reader_AddRelationToRead = (PLib3MFReader_AddRelationToReadPtr) dlsym(hLibrary, "lib3mf_reader_addrelationtoread");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Reader_AddRelationToRead == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Reader_RemoveRelationToRead = (PLib3MFReader_RemoveRelationToReadPtr) GetProcAddress(hLibrary, "lib3mf_reader_removerelationtoread");
	#else // _WIN32
	pWrapperTable->m_Reader_RemoveRelationToRead = (PLib3MFReader_RemoveRelationToReadPtr) dlsym(hLibrary, "lib3mf_reader_removerelationtoread");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Reader_RemoveRelationToRead == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Reader_SetStrictModeActive = (PLib3MFReader_SetStrictModeActivePtr) GetProcAddress(hLibrary, "lib3mf_reader_setstrictmodeactive");
	#else // _WIN32
	pWrapperTable->m_Reader_SetStrictModeActive = (PLib3MFReader_SetStrictModeActivePtr) dlsym(hLibrary, "lib3mf_reader_setstrictmodeactive");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Reader_SetStrictModeActive == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Reader_GetStrictModeActive = (PLib3MFReader_GetStrictModeActivePtr) GetProcAddress(hLibrary, "lib3mf_reader_getstrictmodeactive");
	#else // _WIN32
	pWrapperTable->m_Reader_GetStrictModeActive = (PLib3MFReader_GetStrictModeActivePtr) dlsym(hLibrary, "lib3mf_reader_getstrictmodeactive");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Reader_GetStrictModeActive == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Reader_GetWarning = (PLib3MFReader_GetWarningPtr) GetProcAddress(hLibrary, "lib3mf_reader_getwarning");
	#else // _WIN32
	pWrapperTable->m_Reader_GetWarning = (PLib3MFReader_GetWarningPtr) dlsym(hLibrary, "lib3mf_reader_getwarning");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Reader_GetWarning == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Reader_GetWarningCount = (PLib3MFReader_GetWarningCountPtr) GetProcAddress(hLibrary, "lib3mf_reader_getwarningcount");
	#else // _WIN32
	pWrapperTable->m_Reader_GetWarningCount = (PLib3MFReader_GetWarningCountPtr) dlsym(hLibrary, "lib3mf_reader_getwarningcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Reader_GetWarningCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Reader_AddKeyWrappingCallback = (PLib3MFReader_AddKeyWrappingCallbackPtr) GetProcAddress(hLibrary, "lib3mf_reader_addkeywrappingcallback");
	#else // _WIN32
	pWrapperTable->m_Reader_AddKeyWrappingCallback = (PLib3MFReader_AddKeyWrappingCallbackPtr) dlsym(hLibrary, "lib3mf_reader_addkeywrappingcallback");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Reader_AddKeyWrappingCallback == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Reader_SetContentEncryptionCallback = (PLib3MFReader_SetContentEncryptionCallbackPtr) GetProcAddress(hLibrary, "lib3mf_reader_setcontentencryptioncallback");
	#else // _WIN32
	pWrapperTable->m_Reader_SetContentEncryptionCallback = (PLib3MFReader_SetContentEncryptionCallbackPtr) dlsym(hLibrary, "lib3mf_reader_setcontentencryptioncallback");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Reader_SetContentEncryptionCallback == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_PackagePart_GetPath = (PLib3MFPackagePart_GetPathPtr) GetProcAddress(hLibrary, "lib3mf_packagepart_getpath");
	#else // _WIN32
	pWrapperTable->m_PackagePart_GetPath = (PLib3MFPackagePart_GetPathPtr) dlsym(hLibrary, "lib3mf_packagepart_getpath");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_PackagePart_GetPath == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_PackagePart_SetPath = (PLib3MFPackagePart_SetPathPtr) GetProcAddress(hLibrary, "lib3mf_packagepart_setpath");
	#else // _WIN32
	pWrapperTable->m_PackagePart_SetPath = (PLib3MFPackagePart_SetPathPtr) dlsym(hLibrary, "lib3mf_packagepart_setpath");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_PackagePart_SetPath == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Resource_GetResourceID = (PLib3MFResource_GetResourceIDPtr) GetProcAddress(hLibrary, "lib3mf_resource_getresourceid");
	#else // _WIN32
	pWrapperTable->m_Resource_GetResourceID = (PLib3MFResource_GetResourceIDPtr) dlsym(hLibrary, "lib3mf_resource_getresourceid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Resource_GetResourceID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Resource_GetUniqueResourceID = (PLib3MFResource_GetUniqueResourceIDPtr) GetProcAddress(hLibrary, "lib3mf_resource_getuniqueresourceid");
	#else // _WIN32
	pWrapperTable->m_Resource_GetUniqueResourceID = (PLib3MFResource_GetUniqueResourceIDPtr) dlsym(hLibrary, "lib3mf_resource_getuniqueresourceid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Resource_GetUniqueResourceID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Resource_PackagePart = (PLib3MFResource_PackagePartPtr) GetProcAddress(hLibrary, "lib3mf_resource_packagepart");
	#else // _WIN32
	pWrapperTable->m_Resource_PackagePart = (PLib3MFResource_PackagePartPtr) dlsym(hLibrary, "lib3mf_resource_packagepart");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Resource_PackagePart == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Resource_SetPackagePart = (PLib3MFResource_SetPackagePartPtr) GetProcAddress(hLibrary, "lib3mf_resource_setpackagepart");
	#else // _WIN32
	pWrapperTable->m_Resource_SetPackagePart = (PLib3MFResource_SetPackagePartPtr) dlsym(hLibrary, "lib3mf_resource_setpackagepart");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Resource_SetPackagePart == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Resource_GetModelResourceID = (PLib3MFResource_GetModelResourceIDPtr) GetProcAddress(hLibrary, "lib3mf_resource_getmodelresourceid");
	#else // _WIN32
	pWrapperTable->m_Resource_GetModelResourceID = (PLib3MFResource_GetModelResourceIDPtr) dlsym(hLibrary, "lib3mf_resource_getmodelresourceid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Resource_GetModelResourceID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ResourceIterator_MoveNext = (PLib3MFResourceIterator_MoveNextPtr) GetProcAddress(hLibrary, "lib3mf_resourceiterator_movenext");
	#else // _WIN32
	pWrapperTable->m_ResourceIterator_MoveNext = (PLib3MFResourceIterator_MoveNextPtr) dlsym(hLibrary, "lib3mf_resourceiterator_movenext");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ResourceIterator_MoveNext == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ResourceIterator_MovePrevious = (PLib3MFResourceIterator_MovePreviousPtr) GetProcAddress(hLibrary, "lib3mf_resourceiterator_moveprevious");
	#else // _WIN32
	pWrapperTable->m_ResourceIterator_MovePrevious = (PLib3MFResourceIterator_MovePreviousPtr) dlsym(hLibrary, "lib3mf_resourceiterator_moveprevious");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ResourceIterator_MovePrevious == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ResourceIterator_GetCurrent = (PLib3MFResourceIterator_GetCurrentPtr) GetProcAddress(hLibrary, "lib3mf_resourceiterator_getcurrent");
	#else // _WIN32
	pWrapperTable->m_ResourceIterator_GetCurrent = (PLib3MFResourceIterator_GetCurrentPtr) dlsym(hLibrary, "lib3mf_resourceiterator_getcurrent");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ResourceIterator_GetCurrent == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ResourceIterator_Clone = (PLib3MFResourceIterator_ClonePtr) GetProcAddress(hLibrary, "lib3mf_resourceiterator_clone");
	#else // _WIN32
	pWrapperTable->m_ResourceIterator_Clone = (PLib3MFResourceIterator_ClonePtr) dlsym(hLibrary, "lib3mf_resourceiterator_clone");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ResourceIterator_Clone == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ResourceIterator_Count = (PLib3MFResourceIterator_CountPtr) GetProcAddress(hLibrary, "lib3mf_resourceiterator_count");
	#else // _WIN32
	pWrapperTable->m_ResourceIterator_Count = (PLib3MFResourceIterator_CountPtr) dlsym(hLibrary, "lib3mf_resourceiterator_count");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ResourceIterator_Count == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_SliceStackIterator_GetCurrentSliceStack = (PLib3MFSliceStackIterator_GetCurrentSliceStackPtr) GetProcAddress(hLibrary, "lib3mf_slicestackiterator_getcurrentslicestack");
	#else // _WIN32
	pWrapperTable->m_SliceStackIterator_GetCurrentSliceStack = (PLib3MFSliceStackIterator_GetCurrentSliceStackPtr) dlsym(hLibrary, "lib3mf_slicestackiterator_getcurrentslicestack");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_SliceStackIterator_GetCurrentSliceStack == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ObjectIterator_GetCurrentObject = (PLib3MFObjectIterator_GetCurrentObjectPtr) GetProcAddress(hLibrary, "lib3mf_objectiterator_getcurrentobject");
	#else // _WIN32
	pWrapperTable->m_ObjectIterator_GetCurrentObject = (PLib3MFObjectIterator_GetCurrentObjectPtr) dlsym(hLibrary, "lib3mf_objectiterator_getcurrentobject");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ObjectIterator_GetCurrentObject == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObjectIterator_GetCurrentMeshObject = (PLib3MFMeshObjectIterator_GetCurrentMeshObjectPtr) GetProcAddress(hLibrary, "lib3mf_meshobjectiterator_getcurrentmeshobject");
	#else // _WIN32
	pWrapperTable->m_MeshObjectIterator_GetCurrentMeshObject = (PLib3MFMeshObjectIterator_GetCurrentMeshObjectPtr) dlsym(hLibrary, "lib3mf_meshobjectiterator_getcurrentmeshobject");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObjectIterator_GetCurrentMeshObject == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ComponentsObjectIterator_GetCurrentComponentsObject = (PLib3MFComponentsObjectIterator_GetCurrentComponentsObjectPtr) GetProcAddress(hLibrary, "lib3mf_componentsobjectiterator_getcurrentcomponentsobject");
	#else // _WIN32
	pWrapperTable->m_ComponentsObjectIterator_GetCurrentComponentsObject = (PLib3MFComponentsObjectIterator_GetCurrentComponentsObjectPtr) dlsym(hLibrary, "lib3mf_componentsobjectiterator_getcurrentcomponentsobject");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ComponentsObjectIterator_GetCurrentComponentsObject == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Texture2DIterator_GetCurrentTexture2D = (PLib3MFTexture2DIterator_GetCurrentTexture2DPtr) GetProcAddress(hLibrary, "lib3mf_texture2diterator_getcurrenttexture2d");
	#else // _WIN32
	pWrapperTable->m_Texture2DIterator_GetCurrentTexture2D = (PLib3MFTexture2DIterator_GetCurrentTexture2DPtr) dlsym(hLibrary, "lib3mf_texture2diterator_getcurrenttexture2d");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Texture2DIterator_GetCurrentTexture2D == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BaseMaterialGroupIterator_GetCurrentBaseMaterialGroup = (PLib3MFBaseMaterialGroupIterator_GetCurrentBaseMaterialGroupPtr) GetProcAddress(hLibrary, "lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup");
	#else // _WIN32
	pWrapperTable->m_BaseMaterialGroupIterator_GetCurrentBaseMaterialGroup = (PLib3MFBaseMaterialGroupIterator_GetCurrentBaseMaterialGroupPtr) dlsym(hLibrary, "lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BaseMaterialGroupIterator_GetCurrentBaseMaterialGroup == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ColorGroupIterator_GetCurrentColorGroup = (PLib3MFColorGroupIterator_GetCurrentColorGroupPtr) GetProcAddress(hLibrary, "lib3mf_colorgroupiterator_getcurrentcolorgroup");
	#else // _WIN32
	pWrapperTable->m_ColorGroupIterator_GetCurrentColorGroup = (PLib3MFColorGroupIterator_GetCurrentColorGroupPtr) dlsym(hLibrary, "lib3mf_colorgroupiterator_getcurrentcolorgroup");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ColorGroupIterator_GetCurrentColorGroup == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Texture2DGroupIterator_GetCurrentTexture2DGroup = (PLib3MFTexture2DGroupIterator_GetCurrentTexture2DGroupPtr) GetProcAddress(hLibrary, "lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup");
	#else // _WIN32
	pWrapperTable->m_Texture2DGroupIterator_GetCurrentTexture2DGroup = (PLib3MFTexture2DGroupIterator_GetCurrentTexture2DGroupPtr) dlsym(hLibrary, "lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Texture2DGroupIterator_GetCurrentTexture2DGroup == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_CompositeMaterialsIterator_GetCurrentCompositeMaterials = (PLib3MFCompositeMaterialsIterator_GetCurrentCompositeMaterialsPtr) GetProcAddress(hLibrary, "lib3mf_compositematerialsiterator_getcurrentcompositematerials");
	#else // _WIN32
	pWrapperTable->m_CompositeMaterialsIterator_GetCurrentCompositeMaterials = (PLib3MFCompositeMaterialsIterator_GetCurrentCompositeMaterialsPtr) dlsym(hLibrary, "lib3mf_compositematerialsiterator_getcurrentcompositematerials");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_CompositeMaterialsIterator_GetCurrentCompositeMaterials == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MultiPropertyGroupIterator_GetCurrentMultiPropertyGroup = (PLib3MFMultiPropertyGroupIterator_GetCurrentMultiPropertyGroupPtr) GetProcAddress(hLibrary, "lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup");
	#else // _WIN32
	pWrapperTable->m_MultiPropertyGroupIterator_GetCurrentMultiPropertyGroup = (PLib3MFMultiPropertyGroupIterator_GetCurrentMultiPropertyGroupPtr) dlsym(hLibrary, "lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MultiPropertyGroupIterator_GetCurrentMultiPropertyGroup == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Image3DIterator_GetCurrentImage3D = (PLib3MFImage3DIterator_GetCurrentImage3DPtr) GetProcAddress(hLibrary, "lib3mf_image3diterator_getcurrentimage3d");
	#else // _WIN32
	pWrapperTable->m_Image3DIterator_GetCurrentImage3D = (PLib3MFImage3DIterator_GetCurrentImage3DPtr) dlsym(hLibrary, "lib3mf_image3diterator_getcurrentimage3d");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Image3DIterator_GetCurrentImage3D == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FunctionIterator_GetCurrentFunction = (PLib3MFFunctionIterator_GetCurrentFunctionPtr) GetProcAddress(hLibrary, "lib3mf_functioniterator_getcurrentfunction");
	#else // _WIN32
	pWrapperTable->m_FunctionIterator_GetCurrentFunction = (PLib3MFFunctionIterator_GetCurrentFunctionPtr) dlsym(hLibrary, "lib3mf_functioniterator_getcurrentfunction");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FunctionIterator_GetCurrentFunction == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_LevelSetIterator_GetCurrentLevelSet = (PLib3MFLevelSetIterator_GetCurrentLevelSetPtr) GetProcAddress(hLibrary, "lib3mf_levelsetiterator_getcurrentlevelset");
	#else // _WIN32
	pWrapperTable->m_LevelSetIterator_GetCurrentLevelSet = (PLib3MFLevelSetIterator_GetCurrentLevelSetPtr) dlsym(hLibrary, "lib3mf_levelsetiterator_getcurrentlevelset");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_LevelSetIterator_GetCurrentLevelSet == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MetaData_GetNameSpace = (PLib3MFMetaData_GetNameSpacePtr) GetProcAddress(hLibrary, "lib3mf_metadata_getnamespace");
	#else // _WIN32
	pWrapperTable->m_MetaData_GetNameSpace = (PLib3MFMetaData_GetNameSpacePtr) dlsym(hLibrary, "lib3mf_metadata_getnamespace");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MetaData_GetNameSpace == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MetaData_SetNameSpace = (PLib3MFMetaData_SetNameSpacePtr) GetProcAddress(hLibrary, "lib3mf_metadata_setnamespace");
	#else // _WIN32
	pWrapperTable->m_MetaData_SetNameSpace = (PLib3MFMetaData_SetNameSpacePtr) dlsym(hLibrary, "lib3mf_metadata_setnamespace");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MetaData_SetNameSpace == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MetaData_GetName = (PLib3MFMetaData_GetNamePtr) GetProcAddress(hLibrary, "lib3mf_metadata_getname");
	#else // _WIN32
	pWrapperTable->m_MetaData_GetName = (PLib3MFMetaData_GetNamePtr) dlsym(hLibrary, "lib3mf_metadata_getname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MetaData_GetName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MetaData_SetName = (PLib3MFMetaData_SetNamePtr) GetProcAddress(hLibrary, "lib3mf_metadata_setname");
	#else // _WIN32
	pWrapperTable->m_MetaData_SetName = (PLib3MFMetaData_SetNamePtr) dlsym(hLibrary, "lib3mf_metadata_setname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MetaData_SetName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MetaData_GetKey = (PLib3MFMetaData_GetKeyPtr) GetProcAddress(hLibrary, "lib3mf_metadata_getkey");
	#else // _WIN32
	pWrapperTable->m_MetaData_GetKey = (PLib3MFMetaData_GetKeyPtr) dlsym(hLibrary, "lib3mf_metadata_getkey");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MetaData_GetKey == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MetaData_GetMustPreserve = (PLib3MFMetaData_GetMustPreservePtr) GetProcAddress(hLibrary, "lib3mf_metadata_getmustpreserve");
	#else // _WIN32
	pWrapperTable->m_MetaData_GetMustPreserve = (PLib3MFMetaData_GetMustPreservePtr) dlsym(hLibrary, "lib3mf_metadata_getmustpreserve");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MetaData_GetMustPreserve == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MetaData_SetMustPreserve = (PLib3MFMetaData_SetMustPreservePtr) GetProcAddress(hLibrary, "lib3mf_metadata_setmustpreserve");
	#else // _WIN32
	pWrapperTable->m_MetaData_SetMustPreserve = (PLib3MFMetaData_SetMustPreservePtr) dlsym(hLibrary, "lib3mf_metadata_setmustpreserve");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MetaData_SetMustPreserve == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MetaData_GetType = (PLib3MFMetaData_GetTypePtr) GetProcAddress(hLibrary, "lib3mf_metadata_gettype");
	#else // _WIN32
	pWrapperTable->m_MetaData_GetType = (PLib3MFMetaData_GetTypePtr) dlsym(hLibrary, "lib3mf_metadata_gettype");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MetaData_GetType == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MetaData_SetType = (PLib3MFMetaData_SetTypePtr) GetProcAddress(hLibrary, "lib3mf_metadata_settype");
	#else // _WIN32
	pWrapperTable->m_MetaData_SetType = (PLib3MFMetaData_SetTypePtr) dlsym(hLibrary, "lib3mf_metadata_settype");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MetaData_SetType == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MetaData_GetValue = (PLib3MFMetaData_GetValuePtr) GetProcAddress(hLibrary, "lib3mf_metadata_getvalue");
	#else // _WIN32
	pWrapperTable->m_MetaData_GetValue = (PLib3MFMetaData_GetValuePtr) dlsym(hLibrary, "lib3mf_metadata_getvalue");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MetaData_GetValue == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MetaData_SetValue = (PLib3MFMetaData_SetValuePtr) GetProcAddress(hLibrary, "lib3mf_metadata_setvalue");
	#else // _WIN32
	pWrapperTable->m_MetaData_SetValue = (PLib3MFMetaData_SetValuePtr) dlsym(hLibrary, "lib3mf_metadata_setvalue");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MetaData_SetValue == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MetaDataGroup_GetMetaDataCount = (PLib3MFMetaDataGroup_GetMetaDataCountPtr) GetProcAddress(hLibrary, "lib3mf_metadatagroup_getmetadatacount");
	#else // _WIN32
	pWrapperTable->m_MetaDataGroup_GetMetaDataCount = (PLib3MFMetaDataGroup_GetMetaDataCountPtr) dlsym(hLibrary, "lib3mf_metadatagroup_getmetadatacount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MetaDataGroup_GetMetaDataCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MetaDataGroup_GetMetaData = (PLib3MFMetaDataGroup_GetMetaDataPtr) GetProcAddress(hLibrary, "lib3mf_metadatagroup_getmetadata");
	#else // _WIN32
	pWrapperTable->m_MetaDataGroup_GetMetaData = (PLib3MFMetaDataGroup_GetMetaDataPtr) dlsym(hLibrary, "lib3mf_metadatagroup_getmetadata");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MetaDataGroup_GetMetaData == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MetaDataGroup_GetMetaDataByKey = (PLib3MFMetaDataGroup_GetMetaDataByKeyPtr) GetProcAddress(hLibrary, "lib3mf_metadatagroup_getmetadatabykey");
	#else // _WIN32
	pWrapperTable->m_MetaDataGroup_GetMetaDataByKey = (PLib3MFMetaDataGroup_GetMetaDataByKeyPtr) dlsym(hLibrary, "lib3mf_metadatagroup_getmetadatabykey");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MetaDataGroup_GetMetaDataByKey == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MetaDataGroup_RemoveMetaDataByIndex = (PLib3MFMetaDataGroup_RemoveMetaDataByIndexPtr) GetProcAddress(hLibrary, "lib3mf_metadatagroup_removemetadatabyindex");
	#else // _WIN32
	pWrapperTable->m_MetaDataGroup_RemoveMetaDataByIndex = (PLib3MFMetaDataGroup_RemoveMetaDataByIndexPtr) dlsym(hLibrary, "lib3mf_metadatagroup_removemetadatabyindex");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MetaDataGroup_RemoveMetaDataByIndex == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MetaDataGroup_RemoveMetaData = (PLib3MFMetaDataGroup_RemoveMetaDataPtr) GetProcAddress(hLibrary, "lib3mf_metadatagroup_removemetadata");
	#else // _WIN32
	pWrapperTable->m_MetaDataGroup_RemoveMetaData = (PLib3MFMetaDataGroup_RemoveMetaDataPtr) dlsym(hLibrary, "lib3mf_metadatagroup_removemetadata");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MetaDataGroup_RemoveMetaData == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MetaDataGroup_AddMetaData = (PLib3MFMetaDataGroup_AddMetaDataPtr) GetProcAddress(hLibrary, "lib3mf_metadatagroup_addmetadata");
	#else // _WIN32
	pWrapperTable->m_MetaDataGroup_AddMetaData = (PLib3MFMetaDataGroup_AddMetaDataPtr) dlsym(hLibrary, "lib3mf_metadatagroup_addmetadata");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MetaDataGroup_AddMetaData == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_TriangleSet_SetName = (PLib3MFTriangleSet_SetNamePtr) GetProcAddress(hLibrary, "lib3mf_triangleset_setname");
	#else // _WIN32
	pWrapperTable->m_TriangleSet_SetName = (PLib3MFTriangleSet_SetNamePtr) dlsym(hLibrary, "lib3mf_triangleset_setname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_TriangleSet_SetName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_TriangleSet_GetName = (PLib3MFTriangleSet_GetNamePtr) GetProcAddress(hLibrary, "lib3mf_triangleset_getname");
	#else // _WIN32
	pWrapperTable->m_TriangleSet_GetName = (PLib3MFTriangleSet_GetNamePtr) dlsym(hLibrary, "lib3mf_triangleset_getname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_TriangleSet_GetName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_TriangleSet_SetIdentifier = (PLib3MFTriangleSet_SetIdentifierPtr) GetProcAddress(hLibrary, "lib3mf_triangleset_setidentifier");
	#else // _WIN32
	pWrapperTable->m_TriangleSet_SetIdentifier = (PLib3MFTriangleSet_SetIdentifierPtr) dlsym(hLibrary, "lib3mf_triangleset_setidentifier");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_TriangleSet_SetIdentifier == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_TriangleSet_GetIdentifier = (PLib3MFTriangleSet_GetIdentifierPtr) GetProcAddress(hLibrary, "lib3mf_triangleset_getidentifier");
	#else // _WIN32
	pWrapperTable->m_TriangleSet_GetIdentifier = (PLib3MFTriangleSet_GetIdentifierPtr) dlsym(hLibrary, "lib3mf_triangleset_getidentifier");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_TriangleSet_GetIdentifier == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_TriangleSet_AddTriangle = (PLib3MFTriangleSet_AddTrianglePtr) GetProcAddress(hLibrary, "lib3mf_triangleset_addtriangle");
	#else // _WIN32
	pWrapperTable->m_TriangleSet_AddTriangle = (PLib3MFTriangleSet_AddTrianglePtr) dlsym(hLibrary, "lib3mf_triangleset_addtriangle");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_TriangleSet_AddTriangle == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_TriangleSet_RemoveTriangle = (PLib3MFTriangleSet_RemoveTrianglePtr) GetProcAddress(hLibrary, "lib3mf_triangleset_removetriangle");
	#else // _WIN32
	pWrapperTable->m_TriangleSet_RemoveTriangle = (PLib3MFTriangleSet_RemoveTrianglePtr) dlsym(hLibrary, "lib3mf_triangleset_removetriangle");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_TriangleSet_RemoveTriangle == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_TriangleSet_Clear = (PLib3MFTriangleSet_ClearPtr) GetProcAddress(hLibrary, "lib3mf_triangleset_clear");
	#else // _WIN32
	pWrapperTable->m_TriangleSet_Clear = (PLib3MFTriangleSet_ClearPtr) dlsym(hLibrary, "lib3mf_triangleset_clear");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_TriangleSet_Clear == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_TriangleSet_SetTriangleList = (PLib3MFTriangleSet_SetTriangleListPtr) GetProcAddress(hLibrary, "lib3mf_triangleset_settrianglelist");
	#else // _WIN32
	pWrapperTable->m_TriangleSet_SetTriangleList = (PLib3MFTriangleSet_SetTriangleListPtr) dlsym(hLibrary, "lib3mf_triangleset_settrianglelist");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_TriangleSet_SetTriangleList == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_TriangleSet_GetTriangleList = (PLib3MFTriangleSet_GetTriangleListPtr) GetProcAddress(hLibrary, "lib3mf_triangleset_gettrianglelist");
	#else // _WIN32
	pWrapperTable->m_TriangleSet_GetTriangleList = (PLib3MFTriangleSet_GetTriangleListPtr) dlsym(hLibrary, "lib3mf_triangleset_gettrianglelist");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_TriangleSet_GetTriangleList == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_TriangleSet_AddTriangleList = (PLib3MFTriangleSet_AddTriangleListPtr) GetProcAddress(hLibrary, "lib3mf_triangleset_addtrianglelist");
	#else // _WIN32
	pWrapperTable->m_TriangleSet_AddTriangleList = (PLib3MFTriangleSet_AddTriangleListPtr) dlsym(hLibrary, "lib3mf_triangleset_addtrianglelist");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_TriangleSet_AddTriangleList == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_TriangleSet_Merge = (PLib3MFTriangleSet_MergePtr) GetProcAddress(hLibrary, "lib3mf_triangleset_merge");
	#else // _WIN32
	pWrapperTable->m_TriangleSet_Merge = (PLib3MFTriangleSet_MergePtr) dlsym(hLibrary, "lib3mf_triangleset_merge");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_TriangleSet_Merge == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_TriangleSet_DeleteSet = (PLib3MFTriangleSet_DeleteSetPtr) GetProcAddress(hLibrary, "lib3mf_triangleset_deleteset");
	#else // _WIN32
	pWrapperTable->m_TriangleSet_DeleteSet = (PLib3MFTriangleSet_DeleteSetPtr) dlsym(hLibrary, "lib3mf_triangleset_deleteset");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_TriangleSet_DeleteSet == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_TriangleSet_Duplicate = (PLib3MFTriangleSet_DuplicatePtr) GetProcAddress(hLibrary, "lib3mf_triangleset_duplicate");
	#else // _WIN32
	pWrapperTable->m_TriangleSet_Duplicate = (PLib3MFTriangleSet_DuplicatePtr) dlsym(hLibrary, "lib3mf_triangleset_duplicate");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_TriangleSet_Duplicate == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_GetType = (PLib3MFObject_GetTypePtr) GetProcAddress(hLibrary, "lib3mf_object_gettype");
	#else // _WIN32
	pWrapperTable->m_Object_GetType = (PLib3MFObject_GetTypePtr) dlsym(hLibrary, "lib3mf_object_gettype");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_GetType == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_SetType = (PLib3MFObject_SetTypePtr) GetProcAddress(hLibrary, "lib3mf_object_settype");
	#else // _WIN32
	pWrapperTable->m_Object_SetType = (PLib3MFObject_SetTypePtr) dlsym(hLibrary, "lib3mf_object_settype");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_SetType == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_GetName = (PLib3MFObject_GetNamePtr) GetProcAddress(hLibrary, "lib3mf_object_getname");
	#else // _WIN32
	pWrapperTable->m_Object_GetName = (PLib3MFObject_GetNamePtr) dlsym(hLibrary, "lib3mf_object_getname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_GetName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_SetName = (PLib3MFObject_SetNamePtr) GetProcAddress(hLibrary, "lib3mf_object_setname");
	#else // _WIN32
	pWrapperTable->m_Object_SetName = (PLib3MFObject_SetNamePtr) dlsym(hLibrary, "lib3mf_object_setname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_SetName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_GetPartNumber = (PLib3MFObject_GetPartNumberPtr) GetProcAddress(hLibrary, "lib3mf_object_getpartnumber");
	#else // _WIN32
	pWrapperTable->m_Object_GetPartNumber = (PLib3MFObject_GetPartNumberPtr) dlsym(hLibrary, "lib3mf_object_getpartnumber");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_GetPartNumber == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_SetPartNumber = (PLib3MFObject_SetPartNumberPtr) GetProcAddress(hLibrary, "lib3mf_object_setpartnumber");
	#else // _WIN32
	pWrapperTable->m_Object_SetPartNumber = (PLib3MFObject_SetPartNumberPtr) dlsym(hLibrary, "lib3mf_object_setpartnumber");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_SetPartNumber == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_IsMeshObject = (PLib3MFObject_IsMeshObjectPtr) GetProcAddress(hLibrary, "lib3mf_object_ismeshobject");
	#else // _WIN32
	pWrapperTable->m_Object_IsMeshObject = (PLib3MFObject_IsMeshObjectPtr) dlsym(hLibrary, "lib3mf_object_ismeshobject");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_IsMeshObject == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_IsComponentsObject = (PLib3MFObject_IsComponentsObjectPtr) GetProcAddress(hLibrary, "lib3mf_object_iscomponentsobject");
	#else // _WIN32
	pWrapperTable->m_Object_IsComponentsObject = (PLib3MFObject_IsComponentsObjectPtr) dlsym(hLibrary, "lib3mf_object_iscomponentsobject");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_IsComponentsObject == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_IsLevelSetObject = (PLib3MFObject_IsLevelSetObjectPtr) GetProcAddress(hLibrary, "lib3mf_object_islevelsetobject");
	#else // _WIN32
	pWrapperTable->m_Object_IsLevelSetObject = (PLib3MFObject_IsLevelSetObjectPtr) dlsym(hLibrary, "lib3mf_object_islevelsetobject");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_IsLevelSetObject == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_IsValid = (PLib3MFObject_IsValidPtr) GetProcAddress(hLibrary, "lib3mf_object_isvalid");
	#else // _WIN32
	pWrapperTable->m_Object_IsValid = (PLib3MFObject_IsValidPtr) dlsym(hLibrary, "lib3mf_object_isvalid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_IsValid == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_SetAttachmentAsThumbnail = (PLib3MFObject_SetAttachmentAsThumbnailPtr) GetProcAddress(hLibrary, "lib3mf_object_setattachmentasthumbnail");
	#else // _WIN32
	pWrapperTable->m_Object_SetAttachmentAsThumbnail = (PLib3MFObject_SetAttachmentAsThumbnailPtr) dlsym(hLibrary, "lib3mf_object_setattachmentasthumbnail");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_SetAttachmentAsThumbnail == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_GetThumbnailAttachment = (PLib3MFObject_GetThumbnailAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_object_getthumbnailattachment");
	#else // _WIN32
	pWrapperTable->m_Object_GetThumbnailAttachment = (PLib3MFObject_GetThumbnailAttachmentPtr) dlsym(hLibrary, "lib3mf_object_getthumbnailattachment");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_GetThumbnailAttachment == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_ClearThumbnailAttachment = (PLib3MFObject_ClearThumbnailAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_object_clearthumbnailattachment");
	#else // _WIN32
	pWrapperTable->m_Object_ClearThumbnailAttachment = (PLib3MFObject_ClearThumbnailAttachmentPtr) dlsym(hLibrary, "lib3mf_object_clearthumbnailattachment");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_ClearThumbnailAttachment == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_GetOutbox = (PLib3MFObject_GetOutboxPtr) GetProcAddress(hLibrary, "lib3mf_object_getoutbox");
	#else // _WIN32
	pWrapperTable->m_Object_GetOutbox = (PLib3MFObject_GetOutboxPtr) dlsym(hLibrary, "lib3mf_object_getoutbox");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_GetOutbox == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_GetUUID = (PLib3MFObject_GetUUIDPtr) GetProcAddress(hLibrary, "lib3mf_object_getuuid");
	#else // _WIN32
	pWrapperTable->m_Object_GetUUID = (PLib3MFObject_GetUUIDPtr) dlsym(hLibrary, "lib3mf_object_getuuid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_GetUUID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_SetUUID = (PLib3MFObject_SetUUIDPtr) GetProcAddress(hLibrary, "lib3mf_object_setuuid");
	#else // _WIN32
	pWrapperTable->m_Object_SetUUID = (PLib3MFObject_SetUUIDPtr) dlsym(hLibrary, "lib3mf_object_setuuid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_SetUUID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_GetMetaDataGroup = (PLib3MFObject_GetMetaDataGroupPtr) GetProcAddress(hLibrary, "lib3mf_object_getmetadatagroup");
	#else // _WIN32
	pWrapperTable->m_Object_GetMetaDataGroup = (PLib3MFObject_GetMetaDataGroupPtr) dlsym(hLibrary, "lib3mf_object_getmetadatagroup");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_GetMetaDataGroup == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_SetSlicesMeshResolution = (PLib3MFObject_SetSlicesMeshResolutionPtr) GetProcAddress(hLibrary, "lib3mf_object_setslicesmeshresolution");
	#else // _WIN32
	pWrapperTable->m_Object_SetSlicesMeshResolution = (PLib3MFObject_SetSlicesMeshResolutionPtr) dlsym(hLibrary, "lib3mf_object_setslicesmeshresolution");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_SetSlicesMeshResolution == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_GetSlicesMeshResolution = (PLib3MFObject_GetSlicesMeshResolutionPtr) GetProcAddress(hLibrary, "lib3mf_object_getslicesmeshresolution");
	#else // _WIN32
	pWrapperTable->m_Object_GetSlicesMeshResolution = (PLib3MFObject_GetSlicesMeshResolutionPtr) dlsym(hLibrary, "lib3mf_object_getslicesmeshresolution");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_GetSlicesMeshResolution == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_HasSlices = (PLib3MFObject_HasSlicesPtr) GetProcAddress(hLibrary, "lib3mf_object_hasslices");
	#else // _WIN32
	pWrapperTable->m_Object_HasSlices = (PLib3MFObject_HasSlicesPtr) dlsym(hLibrary, "lib3mf_object_hasslices");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_HasSlices == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_ClearSliceStack = (PLib3MFObject_ClearSliceStackPtr) GetProcAddress(hLibrary, "lib3mf_object_clearslicestack");
	#else // _WIN32
	pWrapperTable->m_Object_ClearSliceStack = (PLib3MFObject_ClearSliceStackPtr) dlsym(hLibrary, "lib3mf_object_clearslicestack");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_ClearSliceStack == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_GetSliceStack = (PLib3MFObject_GetSliceStackPtr) GetProcAddress(hLibrary, "lib3mf_object_getslicestack");
	#else // _WIN32
	pWrapperTable->m_Object_GetSliceStack = (PLib3MFObject_GetSliceStackPtr) dlsym(hLibrary, "lib3mf_object_getslicestack");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_GetSliceStack == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_AssignSliceStack = (PLib3MFObject_AssignSliceStackPtr) GetProcAddress(hLibrary, "lib3mf_object_assignslicestack");
	#else // _WIN32
	pWrapperTable->m_Object_AssignSliceStack = (PLib3MFObject_AssignSliceStackPtr) dlsym(hLibrary, "lib3mf_object_assignslicestack");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_AssignSliceStack == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_GetVertexCount = (PLib3MFMeshObject_GetVertexCountPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_getvertexcount");
	#else // _WIN32
	pWrapperTable->m_MeshObject_GetVertexCount = (PLib3MFMeshObject_GetVertexCountPtr) dlsym(hLibrary, "lib3mf_meshobject_getvertexcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_GetVertexCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_GetTriangleCount = (PLib3MFMeshObject_GetTriangleCountPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_gettrianglecount");
	#else // _WIN32
	pWrapperTable->m_MeshObject_GetTriangleCount = (PLib3MFMeshObject_GetTriangleCountPtr) dlsym(hLibrary, "lib3mf_meshobject_gettrianglecount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_GetTriangleCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_GetVertex = (PLib3MFMeshObject_GetVertexPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_getvertex");
	#else // _WIN32
	pWrapperTable->m_MeshObject_GetVertex = (PLib3MFMeshObject_GetVertexPtr) dlsym(hLibrary, "lib3mf_meshobject_getvertex");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_GetVertex == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_SetVertex = (PLib3MFMeshObject_SetVertexPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_setvertex");
	#else // _WIN32
	pWrapperTable->m_MeshObject_SetVertex = (PLib3MFMeshObject_SetVertexPtr) dlsym(hLibrary, "lib3mf_meshobject_setvertex");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_SetVertex == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_AddVertex = (PLib3MFMeshObject_AddVertexPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_addvertex");
	#else // _WIN32
	pWrapperTable->m_MeshObject_AddVertex = (PLib3MFMeshObject_AddVertexPtr) dlsym(hLibrary, "lib3mf_meshobject_addvertex");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_AddVertex == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_GetVertices = (PLib3MFMeshObject_GetVerticesPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_getvertices");
	#else // _WIN32
	pWrapperTable->m_MeshObject_GetVertices = (PLib3MFMeshObject_GetVerticesPtr) dlsym(hLibrary, "lib3mf_meshobject_getvertices");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_GetVertices == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_GetTriangle = (PLib3MFMeshObject_GetTrianglePtr) GetProcAddress(hLibrary, "lib3mf_meshobject_gettriangle");
	#else // _WIN32
	pWrapperTable->m_MeshObject_GetTriangle = (PLib3MFMeshObject_GetTrianglePtr) dlsym(hLibrary, "lib3mf_meshobject_gettriangle");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_GetTriangle == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_SetTriangle = (PLib3MFMeshObject_SetTrianglePtr) GetProcAddress(hLibrary, "lib3mf_meshobject_settriangle");
	#else // _WIN32
	pWrapperTable->m_MeshObject_SetTriangle = (PLib3MFMeshObject_SetTrianglePtr) dlsym(hLibrary, "lib3mf_meshobject_settriangle");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_SetTriangle == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_AddTriangle = (PLib3MFMeshObject_AddTrianglePtr) GetProcAddress(hLibrary, "lib3mf_meshobject_addtriangle");
	#else // _WIN32
	pWrapperTable->m_MeshObject_AddTriangle = (PLib3MFMeshObject_AddTrianglePtr) dlsym(hLibrary, "lib3mf_meshobject_addtriangle");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_AddTriangle == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_GetTriangleIndices = (PLib3MFMeshObject_GetTriangleIndicesPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_gettriangleindices");
	#else // _WIN32
	pWrapperTable->m_MeshObject_GetTriangleIndices = (PLib3MFMeshObject_GetTriangleIndicesPtr) dlsym(hLibrary, "lib3mf_meshobject_gettriangleindices");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_GetTriangleIndices == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_SetObjectLevelProperty = (PLib3MFMeshObject_SetObjectLevelPropertyPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_setobjectlevelproperty");
	#else // _WIN32
	pWrapperTable->m_MeshObject_SetObjectLevelProperty = (PLib3MFMeshObject_SetObjectLevelPropertyPtr) dlsym(hLibrary, "lib3mf_meshobject_setobjectlevelproperty");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_SetObjectLevelProperty == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_GetObjectLevelProperty = (PLib3MFMeshObject_GetObjectLevelPropertyPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_getobjectlevelproperty");
	#else // _WIN32
	pWrapperTable->m_MeshObject_GetObjectLevelProperty = (PLib3MFMeshObject_GetObjectLevelPropertyPtr) dlsym(hLibrary, "lib3mf_meshobject_getobjectlevelproperty");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_GetObjectLevelProperty == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_SetTriangleProperties = (PLib3MFMeshObject_SetTrianglePropertiesPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_settriangleproperties");
	#else // _WIN32
	pWrapperTable->m_MeshObject_SetTriangleProperties = (PLib3MFMeshObject_SetTrianglePropertiesPtr) dlsym(hLibrary, "lib3mf_meshobject_settriangleproperties");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_SetTriangleProperties == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_GetTriangleProperties = (PLib3MFMeshObject_GetTrianglePropertiesPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_gettriangleproperties");
	#else // _WIN32
	pWrapperTable->m_MeshObject_GetTriangleProperties = (PLib3MFMeshObject_GetTrianglePropertiesPtr) dlsym(hLibrary, "lib3mf_meshobject_gettriangleproperties");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_GetTriangleProperties == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_SetAllTriangleProperties = (PLib3MFMeshObject_SetAllTrianglePropertiesPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_setalltriangleproperties");
	#else // _WIN32
	pWrapperTable->m_MeshObject_SetAllTriangleProperties = (PLib3MFMeshObject_SetAllTrianglePropertiesPtr) dlsym(hLibrary, "lib3mf_meshobject_setalltriangleproperties");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_SetAllTriangleProperties == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_GetAllTriangleProperties = (PLib3MFMeshObject_GetAllTrianglePropertiesPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_getalltriangleproperties");
	#else // _WIN32
	pWrapperTable->m_MeshObject_GetAllTriangleProperties = (PLib3MFMeshObject_GetAllTrianglePropertiesPtr) dlsym(hLibrary, "lib3mf_meshobject_getalltriangleproperties");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_GetAllTriangleProperties == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_ClearAllProperties = (PLib3MFMeshObject_ClearAllPropertiesPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_clearallproperties");
	#else // _WIN32
	pWrapperTable->m_MeshObject_ClearAllProperties = (PLib3MFMeshObject_ClearAllPropertiesPtr) dlsym(hLibrary, "lib3mf_meshobject_clearallproperties");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_ClearAllProperties == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_SetGeometry = (PLib3MFMeshObject_SetGeometryPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_setgeometry");
	#else // _WIN32
	pWrapperTable->m_MeshObject_SetGeometry = (PLib3MFMeshObject_SetGeometryPtr) dlsym(hLibrary, "lib3mf_meshobject_setgeometry");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_SetGeometry == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_IsManifoldAndOriented = (PLib3MFMeshObject_IsManifoldAndOrientedPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_ismanifoldandoriented");
	#else // _WIN32
	pWrapperTable->m_MeshObject_IsManifoldAndOriented = (PLib3MFMeshObject_IsManifoldAndOrientedPtr) dlsym(hLibrary, "lib3mf_meshobject_ismanifoldandoriented");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_IsManifoldAndOriented == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_BeamLattice = (PLib3MFMeshObject_BeamLatticePtr) GetProcAddress(hLibrary, "lib3mf_meshobject_beamlattice");
	#else // _WIN32
	pWrapperTable->m_MeshObject_BeamLattice = (PLib3MFMeshObject_BeamLatticePtr) dlsym(hLibrary, "lib3mf_meshobject_beamlattice");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_BeamLattice == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_GetVolumeData = (PLib3MFMeshObject_GetVolumeDataPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_getvolumedata");
	#else // _WIN32
	pWrapperTable->m_MeshObject_GetVolumeData = (PLib3MFMeshObject_GetVolumeDataPtr) dlsym(hLibrary, "lib3mf_meshobject_getvolumedata");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_GetVolumeData == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_SetVolumeData = (PLib3MFMeshObject_SetVolumeDataPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_setvolumedata");
	#else // _WIN32
	pWrapperTable->m_MeshObject_SetVolumeData = (PLib3MFMeshObject_SetVolumeDataPtr) dlsym(hLibrary, "lib3mf_meshobject_setvolumedata");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_SetVolumeData == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_AddTriangleSet = (PLib3MFMeshObject_AddTriangleSetPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_addtriangleset");
	#else // _WIN32
	pWrapperTable->m_MeshObject_AddTriangleSet = (PLib3MFMeshObject_AddTriangleSetPtr) dlsym(hLibrary, "lib3mf_meshobject_addtriangleset");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_AddTriangleSet == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_HasTriangleSet = (PLib3MFMeshObject_HasTriangleSetPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_hastriangleset");
	#else // _WIN32
	pWrapperTable->m_MeshObject_HasTriangleSet = (PLib3MFMeshObject_HasTriangleSetPtr) dlsym(hLibrary, "lib3mf_meshobject_hastriangleset");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_HasTriangleSet == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_FindTriangleSet = (PLib3MFMeshObject_FindTriangleSetPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_findtriangleset");
	#else // _WIN32
	pWrapperTable->m_MeshObject_FindTriangleSet = (PLib3MFMeshObject_FindTriangleSetPtr) dlsym(hLibrary, "lib3mf_meshobject_findtriangleset");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_FindTriangleSet == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_GetTriangleSetCount = (PLib3MFMeshObject_GetTriangleSetCountPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_gettrianglesetcount");
	#else // _WIN32
	pWrapperTable->m_MeshObject_GetTriangleSetCount = (PLib3MFMeshObject_GetTriangleSetCountPtr) dlsym(hLibrary, "lib3mf_meshobject_gettrianglesetcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_GetTriangleSetCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_GetTriangleSet = (PLib3MFMeshObject_GetTriangleSetPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_gettriangleset");
	#else // _WIN32
	pWrapperTable->m_MeshObject_GetTriangleSet = (PLib3MFMeshObject_GetTriangleSetPtr) dlsym(hLibrary, "lib3mf_meshobject_gettriangleset");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_GetTriangleSet == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_LevelSet_GetFunction = (PLib3MFLevelSet_GetFunctionPtr) GetProcAddress(hLibrary, "lib3mf_levelset_getfunction");
	#else // _WIN32
	pWrapperTable->m_LevelSet_GetFunction = (PLib3MFLevelSet_GetFunctionPtr) dlsym(hLibrary, "lib3mf_levelset_getfunction");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_LevelSet_GetFunction == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_LevelSet_SetFunction = (PLib3MFLevelSet_SetFunctionPtr) GetProcAddress(hLibrary, "lib3mf_levelset_setfunction");
	#else // _WIN32
	pWrapperTable->m_LevelSet_SetFunction = (PLib3MFLevelSet_SetFunctionPtr) dlsym(hLibrary, "lib3mf_levelset_setfunction");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_LevelSet_SetFunction == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_LevelSet_GetTransform = (PLib3MFLevelSet_GetTransformPtr) GetProcAddress(hLibrary, "lib3mf_levelset_gettransform");
	#else // _WIN32
	pWrapperTable->m_LevelSet_GetTransform = (PLib3MFLevelSet_GetTransformPtr) dlsym(hLibrary, "lib3mf_levelset_gettransform");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_LevelSet_GetTransform == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_LevelSet_SetTransform = (PLib3MFLevelSet_SetTransformPtr) GetProcAddress(hLibrary, "lib3mf_levelset_settransform");
	#else // _WIN32
	pWrapperTable->m_LevelSet_SetTransform = (PLib3MFLevelSet_SetTransformPtr) dlsym(hLibrary, "lib3mf_levelset_settransform");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_LevelSet_SetTransform == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_LevelSet_GetChannelName = (PLib3MFLevelSet_GetChannelNamePtr) GetProcAddress(hLibrary, "lib3mf_levelset_getchannelname");
	#else // _WIN32
	pWrapperTable->m_LevelSet_GetChannelName = (PLib3MFLevelSet_GetChannelNamePtr) dlsym(hLibrary, "lib3mf_levelset_getchannelname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_LevelSet_GetChannelName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_LevelSet_SetChannelName = (PLib3MFLevelSet_SetChannelNamePtr) GetProcAddress(hLibrary, "lib3mf_levelset_setchannelname");
	#else // _WIN32
	pWrapperTable->m_LevelSet_SetChannelName = (PLib3MFLevelSet_SetChannelNamePtr) dlsym(hLibrary, "lib3mf_levelset_setchannelname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_LevelSet_SetChannelName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_LevelSet_SetMinFeatureSize = (PLib3MFLevelSet_SetMinFeatureSizePtr) GetProcAddress(hLibrary, "lib3mf_levelset_setminfeaturesize");
	#else // _WIN32
	pWrapperTable->m_LevelSet_SetMinFeatureSize = (PLib3MFLevelSet_SetMinFeatureSizePtr) dlsym(hLibrary, "lib3mf_levelset_setminfeaturesize");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_LevelSet_SetMinFeatureSize == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_LevelSet_GetMinFeatureSize = (PLib3MFLevelSet_GetMinFeatureSizePtr) GetProcAddress(hLibrary, "lib3mf_levelset_getminfeaturesize");
	#else // _WIN32
	pWrapperTable->m_LevelSet_GetMinFeatureSize = (PLib3MFLevelSet_GetMinFeatureSizePtr) dlsym(hLibrary, "lib3mf_levelset_getminfeaturesize");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_LevelSet_GetMinFeatureSize == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_LevelSet_SetFallBackValue = (PLib3MFLevelSet_SetFallBackValuePtr) GetProcAddress(hLibrary, "lib3mf_levelset_setfallbackvalue");
	#else // _WIN32
	pWrapperTable->m_LevelSet_SetFallBackValue = (PLib3MFLevelSet_SetFallBackValuePtr) dlsym(hLibrary, "lib3mf_levelset_setfallbackvalue");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_LevelSet_SetFallBackValue == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_LevelSet_GetFallBackValue = (PLib3MFLevelSet_GetFallBackValuePtr) GetProcAddress(hLibrary, "lib3mf_levelset_getfallbackvalue");
	#else // _WIN32
	pWrapperTable->m_LevelSet_GetFallBackValue = (PLib3MFLevelSet_GetFallBackValuePtr) dlsym(hLibrary, "lib3mf_levelset_getfallbackvalue");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_LevelSet_GetFallBackValue == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_LevelSet_SetMeshBBoxOnly = (PLib3MFLevelSet_SetMeshBBoxOnlyPtr) GetProcAddress(hLibrary, "lib3mf_levelset_setmeshbboxonly");
	#else // _WIN32
	pWrapperTable->m_LevelSet_SetMeshBBoxOnly = (PLib3MFLevelSet_SetMeshBBoxOnlyPtr) dlsym(hLibrary, "lib3mf_levelset_setmeshbboxonly");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_LevelSet_SetMeshBBoxOnly == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_LevelSet_GetMeshBBoxOnly = (PLib3MFLevelSet_GetMeshBBoxOnlyPtr) GetProcAddress(hLibrary, "lib3mf_levelset_getmeshbboxonly");
	#else // _WIN32
	pWrapperTable->m_LevelSet_GetMeshBBoxOnly = (PLib3MFLevelSet_GetMeshBBoxOnlyPtr) dlsym(hLibrary, "lib3mf_levelset_getmeshbboxonly");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_LevelSet_GetMeshBBoxOnly == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_LevelSet_SetMesh = (PLib3MFLevelSet_SetMeshPtr) GetProcAddress(hLibrary, "lib3mf_levelset_setmesh");
	#else // _WIN32
	pWrapperTable->m_LevelSet_SetMesh = (PLib3MFLevelSet_SetMeshPtr) dlsym(hLibrary, "lib3mf_levelset_setmesh");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_LevelSet_SetMesh == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_LevelSet_GetMesh = (PLib3MFLevelSet_GetMeshPtr) GetProcAddress(hLibrary, "lib3mf_levelset_getmesh");
	#else // _WIN32
	pWrapperTable->m_LevelSet_GetMesh = (PLib3MFLevelSet_GetMeshPtr) dlsym(hLibrary, "lib3mf_levelset_getmesh");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_LevelSet_GetMesh == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_LevelSet_GetVolumeData = (PLib3MFLevelSet_GetVolumeDataPtr) GetProcAddress(hLibrary, "lib3mf_levelset_getvolumedata");
	#else // _WIN32
	pWrapperTable->m_LevelSet_GetVolumeData = (PLib3MFLevelSet_GetVolumeDataPtr) dlsym(hLibrary, "lib3mf_levelset_getvolumedata");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_LevelSet_GetVolumeData == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_LevelSet_SetVolumeData = (PLib3MFLevelSet_SetVolumeDataPtr) GetProcAddress(hLibrary, "lib3mf_levelset_setvolumedata");
	#else // _WIN32
	pWrapperTable->m_LevelSet_SetVolumeData = (PLib3MFLevelSet_SetVolumeDataPtr) dlsym(hLibrary, "lib3mf_levelset_setvolumedata");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_LevelSet_SetVolumeData == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_GetMinLength = (PLib3MFBeamLattice_GetMinLengthPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getminlength");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_GetMinLength = (PLib3MFBeamLattice_GetMinLengthPtr) dlsym(hLibrary, "lib3mf_beamlattice_getminlength");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_GetMinLength == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_SetMinLength = (PLib3MFBeamLattice_SetMinLengthPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_setminlength");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_SetMinLength = (PLib3MFBeamLattice_SetMinLengthPtr) dlsym(hLibrary, "lib3mf_beamlattice_setminlength");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_SetMinLength == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_GetClipping = (PLib3MFBeamLattice_GetClippingPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getclipping");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_GetClipping = (PLib3MFBeamLattice_GetClippingPtr) dlsym(hLibrary, "lib3mf_beamlattice_getclipping");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_GetClipping == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_SetClipping = (PLib3MFBeamLattice_SetClippingPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_setclipping");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_SetClipping = (PLib3MFBeamLattice_SetClippingPtr) dlsym(hLibrary, "lib3mf_beamlattice_setclipping");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_SetClipping == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_GetRepresentation = (PLib3MFBeamLattice_GetRepresentationPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getrepresentation");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_GetRepresentation = (PLib3MFBeamLattice_GetRepresentationPtr) dlsym(hLibrary, "lib3mf_beamlattice_getrepresentation");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_GetRepresentation == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_SetRepresentation = (PLib3MFBeamLattice_SetRepresentationPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_setrepresentation");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_SetRepresentation = (PLib3MFBeamLattice_SetRepresentationPtr) dlsym(hLibrary, "lib3mf_beamlattice_setrepresentation");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_SetRepresentation == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_GetBallOptions = (PLib3MFBeamLattice_GetBallOptionsPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getballoptions");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_GetBallOptions = (PLib3MFBeamLattice_GetBallOptionsPtr) dlsym(hLibrary, "lib3mf_beamlattice_getballoptions");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_GetBallOptions == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_SetBallOptions = (PLib3MFBeamLattice_SetBallOptionsPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_setballoptions");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_SetBallOptions = (PLib3MFBeamLattice_SetBallOptionsPtr) dlsym(hLibrary, "lib3mf_beamlattice_setballoptions");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_SetBallOptions == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_GetBeamCount = (PLib3MFBeamLattice_GetBeamCountPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getbeamcount");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_GetBeamCount = (PLib3MFBeamLattice_GetBeamCountPtr) dlsym(hLibrary, "lib3mf_beamlattice_getbeamcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_GetBeamCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_GetBeam = (PLib3MFBeamLattice_GetBeamPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getbeam");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_GetBeam = (PLib3MFBeamLattice_GetBeamPtr) dlsym(hLibrary, "lib3mf_beamlattice_getbeam");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_GetBeam == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_AddBeam = (PLib3MFBeamLattice_AddBeamPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_addbeam");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_AddBeam = (PLib3MFBeamLattice_AddBeamPtr) dlsym(hLibrary, "lib3mf_beamlattice_addbeam");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_AddBeam == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_SetBeam = (PLib3MFBeamLattice_SetBeamPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_setbeam");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_SetBeam = (PLib3MFBeamLattice_SetBeamPtr) dlsym(hLibrary, "lib3mf_beamlattice_setbeam");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_SetBeam == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_SetBeams = (PLib3MFBeamLattice_SetBeamsPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_setbeams");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_SetBeams = (PLib3MFBeamLattice_SetBeamsPtr) dlsym(hLibrary, "lib3mf_beamlattice_setbeams");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_SetBeams == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_GetBeams = (PLib3MFBeamLattice_GetBeamsPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getbeams");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_GetBeams = (PLib3MFBeamLattice_GetBeamsPtr) dlsym(hLibrary, "lib3mf_beamlattice_getbeams");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_GetBeams == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_GetBallCount = (PLib3MFBeamLattice_GetBallCountPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getballcount");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_GetBallCount = (PLib3MFBeamLattice_GetBallCountPtr) dlsym(hLibrary, "lib3mf_beamlattice_getballcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_GetBallCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_GetBall = (PLib3MFBeamLattice_GetBallPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getball");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_GetBall = (PLib3MFBeamLattice_GetBallPtr) dlsym(hLibrary, "lib3mf_beamlattice_getball");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_GetBall == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_AddBall = (PLib3MFBeamLattice_AddBallPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_addball");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_AddBall = (PLib3MFBeamLattice_AddBallPtr) dlsym(hLibrary, "lib3mf_beamlattice_addball");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_AddBall == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_SetBall = (PLib3MFBeamLattice_SetBallPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_setball");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_SetBall = (PLib3MFBeamLattice_SetBallPtr) dlsym(hLibrary, "lib3mf_beamlattice_setball");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_SetBall == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_SetBalls = (PLib3MFBeamLattice_SetBallsPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_setballs");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_SetBalls = (PLib3MFBeamLattice_SetBallsPtr) dlsym(hLibrary, "lib3mf_beamlattice_setballs");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_SetBalls == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_GetBalls = (PLib3MFBeamLattice_GetBallsPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getballs");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_GetBalls = (PLib3MFBeamLattice_GetBallsPtr) dlsym(hLibrary, "lib3mf_beamlattice_getballs");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_GetBalls == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_GetBeamSetCount = (PLib3MFBeamLattice_GetBeamSetCountPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getbeamsetcount");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_GetBeamSetCount = (PLib3MFBeamLattice_GetBeamSetCountPtr) dlsym(hLibrary, "lib3mf_beamlattice_getbeamsetcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_GetBeamSetCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_AddBeamSet = (PLib3MFBeamLattice_AddBeamSetPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_addbeamset");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_AddBeamSet = (PLib3MFBeamLattice_AddBeamSetPtr) dlsym(hLibrary, "lib3mf_beamlattice_addbeamset");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_AddBeamSet == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_GetBeamSet = (PLib3MFBeamLattice_GetBeamSetPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getbeamset");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_GetBeamSet = (PLib3MFBeamLattice_GetBeamSetPtr) dlsym(hLibrary, "lib3mf_beamlattice_getbeamset");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_GetBeamSet == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FunctionReference_GetFunctionResourceID = (PLib3MFFunctionReference_GetFunctionResourceIDPtr) GetProcAddress(hLibrary, "lib3mf_functionreference_getfunctionresourceid");
	#else // _WIN32
	pWrapperTable->m_FunctionReference_GetFunctionResourceID = (PLib3MFFunctionReference_GetFunctionResourceIDPtr) dlsym(hLibrary, "lib3mf_functionreference_getfunctionresourceid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FunctionReference_GetFunctionResourceID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FunctionReference_SetFunctionResourceID = (PLib3MFFunctionReference_SetFunctionResourceIDPtr) GetProcAddress(hLibrary, "lib3mf_functionreference_setfunctionresourceid");
	#else // _WIN32
	pWrapperTable->m_FunctionReference_SetFunctionResourceID = (PLib3MFFunctionReference_SetFunctionResourceIDPtr) dlsym(hLibrary, "lib3mf_functionreference_setfunctionresourceid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FunctionReference_SetFunctionResourceID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FunctionReference_GetTransform = (PLib3MFFunctionReference_GetTransformPtr) GetProcAddress(hLibrary, "lib3mf_functionreference_gettransform");
	#else // _WIN32
	pWrapperTable->m_FunctionReference_GetTransform = (PLib3MFFunctionReference_GetTransformPtr) dlsym(hLibrary, "lib3mf_functionreference_gettransform");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FunctionReference_GetTransform == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FunctionReference_SetTransform = (PLib3MFFunctionReference_SetTransformPtr) GetProcAddress(hLibrary, "lib3mf_functionreference_settransform");
	#else // _WIN32
	pWrapperTable->m_FunctionReference_SetTransform = (PLib3MFFunctionReference_SetTransformPtr) dlsym(hLibrary, "lib3mf_functionreference_settransform");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FunctionReference_SetTransform == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FunctionReference_GetChannelName = (PLib3MFFunctionReference_GetChannelNamePtr) GetProcAddress(hLibrary, "lib3mf_functionreference_getchannelname");
	#else // _WIN32
	pWrapperTable->m_FunctionReference_GetChannelName = (PLib3MFFunctionReference_GetChannelNamePtr) dlsym(hLibrary, "lib3mf_functionreference_getchannelname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FunctionReference_GetChannelName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FunctionReference_SetChannelName = (PLib3MFFunctionReference_SetChannelNamePtr) GetProcAddress(hLibrary, "lib3mf_functionreference_setchannelname");
	#else // _WIN32
	pWrapperTable->m_FunctionReference_SetChannelName = (PLib3MFFunctionReference_SetChannelNamePtr) dlsym(hLibrary, "lib3mf_functionreference_setchannelname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FunctionReference_SetChannelName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FunctionReference_SetMinFeatureSize = (PLib3MFFunctionReference_SetMinFeatureSizePtr) GetProcAddress(hLibrary, "lib3mf_functionreference_setminfeaturesize");
	#else // _WIN32
	pWrapperTable->m_FunctionReference_SetMinFeatureSize = (PLib3MFFunctionReference_SetMinFeatureSizePtr) dlsym(hLibrary, "lib3mf_functionreference_setminfeaturesize");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FunctionReference_SetMinFeatureSize == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FunctionReference_GetMinFeatureSize = (PLib3MFFunctionReference_GetMinFeatureSizePtr) GetProcAddress(hLibrary, "lib3mf_functionreference_getminfeaturesize");
	#else // _WIN32
	pWrapperTable->m_FunctionReference_GetMinFeatureSize = (PLib3MFFunctionReference_GetMinFeatureSizePtr) dlsym(hLibrary, "lib3mf_functionreference_getminfeaturesize");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FunctionReference_GetMinFeatureSize == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FunctionReference_SetFallBackValue = (PLib3MFFunctionReference_SetFallBackValuePtr) GetProcAddress(hLibrary, "lib3mf_functionreference_setfallbackvalue");
	#else // _WIN32
	pWrapperTable->m_FunctionReference_SetFallBackValue = (PLib3MFFunctionReference_SetFallBackValuePtr) dlsym(hLibrary, "lib3mf_functionreference_setfallbackvalue");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FunctionReference_SetFallBackValue == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FunctionReference_GetFallBackValue = (PLib3MFFunctionReference_GetFallBackValuePtr) GetProcAddress(hLibrary, "lib3mf_functionreference_getfallbackvalue");
	#else // _WIN32
	pWrapperTable->m_FunctionReference_GetFallBackValue = (PLib3MFFunctionReference_GetFallBackValuePtr) dlsym(hLibrary, "lib3mf_functionreference_getfallbackvalue");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FunctionReference_GetFallBackValue == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_VolumeDataComposite_GetBaseMaterialGroup = (PLib3MFVolumeDataComposite_GetBaseMaterialGroupPtr) GetProcAddress(hLibrary, "lib3mf_volumedatacomposite_getbasematerialgroup");
	#else // _WIN32
	pWrapperTable->m_VolumeDataComposite_GetBaseMaterialGroup = (PLib3MFVolumeDataComposite_GetBaseMaterialGroupPtr) dlsym(hLibrary, "lib3mf_volumedatacomposite_getbasematerialgroup");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_VolumeDataComposite_GetBaseMaterialGroup == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_VolumeDataComposite_SetBaseMaterialGroup = (PLib3MFVolumeDataComposite_SetBaseMaterialGroupPtr) GetProcAddress(hLibrary, "lib3mf_volumedatacomposite_setbasematerialgroup");
	#else // _WIN32
	pWrapperTable->m_VolumeDataComposite_SetBaseMaterialGroup = (PLib3MFVolumeDataComposite_SetBaseMaterialGroupPtr) dlsym(hLibrary, "lib3mf_volumedatacomposite_setbasematerialgroup");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_VolumeDataComposite_SetBaseMaterialGroup == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_VolumeDataComposite_GetMaterialMappingCount = (PLib3MFVolumeDataComposite_GetMaterialMappingCountPtr) GetProcAddress(hLibrary, "lib3mf_volumedatacomposite_getmaterialmappingcount");
	#else // _WIN32
	pWrapperTable->m_VolumeDataComposite_GetMaterialMappingCount = (PLib3MFVolumeDataComposite_GetMaterialMappingCountPtr) dlsym(hLibrary, "lib3mf_volumedatacomposite_getmaterialmappingcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_VolumeDataComposite_GetMaterialMappingCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_VolumeDataComposite_GetMaterialMapping = (PLib3MFVolumeDataComposite_GetMaterialMappingPtr) GetProcAddress(hLibrary, "lib3mf_volumedatacomposite_getmaterialmapping");
	#else // _WIN32
	pWrapperTable->m_VolumeDataComposite_GetMaterialMapping = (PLib3MFVolumeDataComposite_GetMaterialMappingPtr) dlsym(hLibrary, "lib3mf_volumedatacomposite_getmaterialmapping");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_VolumeDataComposite_GetMaterialMapping == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_VolumeDataComposite_AddMaterialMapping = (PLib3MFVolumeDataComposite_AddMaterialMappingPtr) GetProcAddress(hLibrary, "lib3mf_volumedatacomposite_addmaterialmapping");
	#else // _WIN32
	pWrapperTable->m_VolumeDataComposite_AddMaterialMapping = (PLib3MFVolumeDataComposite_AddMaterialMappingPtr) dlsym(hLibrary, "lib3mf_volumedatacomposite_addmaterialmapping");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_VolumeDataComposite_AddMaterialMapping == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_VolumeDataComposite_RemoveMaterialMapping = (PLib3MFVolumeDataComposite_RemoveMaterialMappingPtr) GetProcAddress(hLibrary, "lib3mf_volumedatacomposite_removematerialmapping");
	#else // _WIN32
	pWrapperTable->m_VolumeDataComposite_RemoveMaterialMapping = (PLib3MFVolumeDataComposite_RemoveMaterialMappingPtr) dlsym(hLibrary, "lib3mf_volumedatacomposite_removematerialmapping");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_VolumeDataComposite_RemoveMaterialMapping == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_VolumeDataProperty_GetName = (PLib3MFVolumeDataProperty_GetNamePtr) GetProcAddress(hLibrary, "lib3mf_volumedataproperty_getname");
	#else // _WIN32
	pWrapperTable->m_VolumeDataProperty_GetName = (PLib3MFVolumeDataProperty_GetNamePtr) dlsym(hLibrary, "lib3mf_volumedataproperty_getname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_VolumeDataProperty_GetName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_VolumeDataProperty_SetIsRequired = (PLib3MFVolumeDataProperty_SetIsRequiredPtr) GetProcAddress(hLibrary, "lib3mf_volumedataproperty_setisrequired");
	#else // _WIN32
	pWrapperTable->m_VolumeDataProperty_SetIsRequired = (PLib3MFVolumeDataProperty_SetIsRequiredPtr) dlsym(hLibrary, "lib3mf_volumedataproperty_setisrequired");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_VolumeDataProperty_SetIsRequired == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_VolumeDataProperty_IsRequired = (PLib3MFVolumeDataProperty_IsRequiredPtr) GetProcAddress(hLibrary, "lib3mf_volumedataproperty_isrequired");
	#else // _WIN32
	pWrapperTable->m_VolumeDataProperty_IsRequired = (PLib3MFVolumeDataProperty_IsRequiredPtr) dlsym(hLibrary, "lib3mf_volumedataproperty_isrequired");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_VolumeDataProperty_IsRequired == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_VolumeData_GetComposite = (PLib3MFVolumeData_GetCompositePtr) GetProcAddress(hLibrary, "lib3mf_volumedata_getcomposite");
	#else // _WIN32
	pWrapperTable->m_VolumeData_GetComposite = (PLib3MFVolumeData_GetCompositePtr) dlsym(hLibrary, "lib3mf_volumedata_getcomposite");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_VolumeData_GetComposite == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_VolumeData_CreateNewComposite = (PLib3MFVolumeData_CreateNewCompositePtr) GetProcAddress(hLibrary, "lib3mf_volumedata_createnewcomposite");
	#else // _WIN32
	pWrapperTable->m_VolumeData_CreateNewComposite = (PLib3MFVolumeData_CreateNewCompositePtr) dlsym(hLibrary, "lib3mf_volumedata_createnewcomposite");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_VolumeData_CreateNewComposite == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_VolumeData_RemoveComposite = (PLib3MFVolumeData_RemoveCompositePtr) GetProcAddress(hLibrary, "lib3mf_volumedata_removecomposite");
	#else // _WIN32
	pWrapperTable->m_VolumeData_RemoveComposite = (PLib3MFVolumeData_RemoveCompositePtr) dlsym(hLibrary, "lib3mf_volumedata_removecomposite");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_VolumeData_RemoveComposite == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_VolumeData_GetColor = (PLib3MFVolumeData_GetColorPtr) GetProcAddress(hLibrary, "lib3mf_volumedata_getcolor");
	#else // _WIN32
	pWrapperTable->m_VolumeData_GetColor = (PLib3MFVolumeData_GetColorPtr) dlsym(hLibrary, "lib3mf_volumedata_getcolor");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_VolumeData_GetColor == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_VolumeData_CreateNewColor = (PLib3MFVolumeData_CreateNewColorPtr) GetProcAddress(hLibrary, "lib3mf_volumedata_createnewcolor");
	#else // _WIN32
	pWrapperTable->m_VolumeData_CreateNewColor = (PLib3MFVolumeData_CreateNewColorPtr) dlsym(hLibrary, "lib3mf_volumedata_createnewcolor");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_VolumeData_CreateNewColor == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_VolumeData_RemoveColor = (PLib3MFVolumeData_RemoveColorPtr) GetProcAddress(hLibrary, "lib3mf_volumedata_removecolor");
	#else // _WIN32
	pWrapperTable->m_VolumeData_RemoveColor = (PLib3MFVolumeData_RemoveColorPtr) dlsym(hLibrary, "lib3mf_volumedata_removecolor");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_VolumeData_RemoveColor == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_VolumeData_GetPropertyCount = (PLib3MFVolumeData_GetPropertyCountPtr) GetProcAddress(hLibrary, "lib3mf_volumedata_getpropertycount");
	#else // _WIN32
	pWrapperTable->m_VolumeData_GetPropertyCount = (PLib3MFVolumeData_GetPropertyCountPtr) dlsym(hLibrary, "lib3mf_volumedata_getpropertycount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_VolumeData_GetPropertyCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_VolumeData_GetProperty = (PLib3MFVolumeData_GetPropertyPtr) GetProcAddress(hLibrary, "lib3mf_volumedata_getproperty");
	#else // _WIN32
	pWrapperTable->m_VolumeData_GetProperty = (PLib3MFVolumeData_GetPropertyPtr) dlsym(hLibrary, "lib3mf_volumedata_getproperty");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_VolumeData_GetProperty == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_VolumeData_AddPropertyFromFunction = (PLib3MFVolumeData_AddPropertyFromFunctionPtr) GetProcAddress(hLibrary, "lib3mf_volumedata_addpropertyfromfunction");
	#else // _WIN32
	pWrapperTable->m_VolumeData_AddPropertyFromFunction = (PLib3MFVolumeData_AddPropertyFromFunctionPtr) dlsym(hLibrary, "lib3mf_volumedata_addpropertyfromfunction");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_VolumeData_AddPropertyFromFunction == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_VolumeData_RemoveProperty = (PLib3MFVolumeData_RemovePropertyPtr) GetProcAddress(hLibrary, "lib3mf_volumedata_removeproperty");
	#else // _WIN32
	pWrapperTable->m_VolumeData_RemoveProperty = (PLib3MFVolumeData_RemovePropertyPtr) dlsym(hLibrary, "lib3mf_volumedata_removeproperty");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_VolumeData_RemoveProperty == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Component_GetObjectResource = (PLib3MFComponent_GetObjectResourcePtr) GetProcAddress(hLibrary, "lib3mf_component_getobjectresource");
	#else // _WIN32
	pWrapperTable->m_Component_GetObjectResource = (PLib3MFComponent_GetObjectResourcePtr) dlsym(hLibrary, "lib3mf_component_getobjectresource");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Component_GetObjectResource == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Component_GetObjectResourceID = (PLib3MFComponent_GetObjectResourceIDPtr) GetProcAddress(hLibrary, "lib3mf_component_getobjectresourceid");
	#else // _WIN32
	pWrapperTable->m_Component_GetObjectResourceID = (PLib3MFComponent_GetObjectResourceIDPtr) dlsym(hLibrary, "lib3mf_component_getobjectresourceid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Component_GetObjectResourceID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Component_GetUUID = (PLib3MFComponent_GetUUIDPtr) GetProcAddress(hLibrary, "lib3mf_component_getuuid");
	#else // _WIN32
	pWrapperTable->m_Component_GetUUID = (PLib3MFComponent_GetUUIDPtr) dlsym(hLibrary, "lib3mf_component_getuuid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Component_GetUUID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Component_SetUUID = (PLib3MFComponent_SetUUIDPtr) GetProcAddress(hLibrary, "lib3mf_component_setuuid");
	#else // _WIN32
	pWrapperTable->m_Component_SetUUID = (PLib3MFComponent_SetUUIDPtr) dlsym(hLibrary, "lib3mf_component_setuuid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Component_SetUUID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Component_HasTransform = (PLib3MFComponent_HasTransformPtr) GetProcAddress(hLibrary, "lib3mf_component_hastransform");
	#else // _WIN32
	pWrapperTable->m_Component_HasTransform = (PLib3MFComponent_HasTransformPtr) dlsym(hLibrary, "lib3mf_component_hastransform");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Component_HasTransform == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Component_GetTransform = (PLib3MFComponent_GetTransformPtr) GetProcAddress(hLibrary, "lib3mf_component_gettransform");
	#else // _WIN32
	pWrapperTable->m_Component_GetTransform = (PLib3MFComponent_GetTransformPtr) dlsym(hLibrary, "lib3mf_component_gettransform");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Component_GetTransform == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Component_SetTransform = (PLib3MFComponent_SetTransformPtr) GetProcAddress(hLibrary, "lib3mf_component_settransform");
	#else // _WIN32
	pWrapperTable->m_Component_SetTransform = (PLib3MFComponent_SetTransformPtr) dlsym(hLibrary, "lib3mf_component_settransform");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Component_SetTransform == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ComponentsObject_AddComponent = (PLib3MFComponentsObject_AddComponentPtr) GetProcAddress(hLibrary, "lib3mf_componentsobject_addcomponent");
	#else // _WIN32
	pWrapperTable->m_ComponentsObject_AddComponent = (PLib3MFComponentsObject_AddComponentPtr) dlsym(hLibrary, "lib3mf_componentsobject_addcomponent");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ComponentsObject_AddComponent == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ComponentsObject_GetComponent = (PLib3MFComponentsObject_GetComponentPtr) GetProcAddress(hLibrary, "lib3mf_componentsobject_getcomponent");
	#else // _WIN32
	pWrapperTable->m_ComponentsObject_GetComponent = (PLib3MFComponentsObject_GetComponentPtr) dlsym(hLibrary, "lib3mf_componentsobject_getcomponent");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ComponentsObject_GetComponent == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ComponentsObject_GetComponentCount = (PLib3MFComponentsObject_GetComponentCountPtr) GetProcAddress(hLibrary, "lib3mf_componentsobject_getcomponentcount");
	#else // _WIN32
	pWrapperTable->m_ComponentsObject_GetComponentCount = (PLib3MFComponentsObject_GetComponentCountPtr) dlsym(hLibrary, "lib3mf_componentsobject_getcomponentcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ComponentsObject_GetComponentCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamSet_SetName = (PLib3MFBeamSet_SetNamePtr) GetProcAddress(hLibrary, "lib3mf_beamset_setname");
	#else // _WIN32
	pWrapperTable->m_BeamSet_SetName = (PLib3MFBeamSet_SetNamePtr) dlsym(hLibrary, "lib3mf_beamset_setname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamSet_SetName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamSet_GetName = (PLib3MFBeamSet_GetNamePtr) GetProcAddress(hLibrary, "lib3mf_beamset_getname");
	#else // _WIN32
	pWrapperTable->m_BeamSet_GetName = (PLib3MFBeamSet_GetNamePtr) dlsym(hLibrary, "lib3mf_beamset_getname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamSet_GetName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamSet_SetIdentifier = (PLib3MFBeamSet_SetIdentifierPtr) GetProcAddress(hLibrary, "lib3mf_beamset_setidentifier");
	#else // _WIN32
	pWrapperTable->m_BeamSet_SetIdentifier = (PLib3MFBeamSet_SetIdentifierPtr) dlsym(hLibrary, "lib3mf_beamset_setidentifier");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamSet_SetIdentifier == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamSet_GetIdentifier = (PLib3MFBeamSet_GetIdentifierPtr) GetProcAddress(hLibrary, "lib3mf_beamset_getidentifier");
	#else // _WIN32
	pWrapperTable->m_BeamSet_GetIdentifier = (PLib3MFBeamSet_GetIdentifierPtr) dlsym(hLibrary, "lib3mf_beamset_getidentifier");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamSet_GetIdentifier == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamSet_GetReferenceCount = (PLib3MFBeamSet_GetReferenceCountPtr) GetProcAddress(hLibrary, "lib3mf_beamset_getreferencecount");
	#else // _WIN32
	pWrapperTable->m_BeamSet_GetReferenceCount = (PLib3MFBeamSet_GetReferenceCountPtr) dlsym(hLibrary, "lib3mf_beamset_getreferencecount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamSet_GetReferenceCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamSet_SetReferences = (PLib3MFBeamSet_SetReferencesPtr) GetProcAddress(hLibrary, "lib3mf_beamset_setreferences");
	#else // _WIN32
	pWrapperTable->m_BeamSet_SetReferences = (PLib3MFBeamSet_SetReferencesPtr) dlsym(hLibrary, "lib3mf_beamset_setreferences");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamSet_SetReferences == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamSet_GetReferences = (PLib3MFBeamSet_GetReferencesPtr) GetProcAddress(hLibrary, "lib3mf_beamset_getreferences");
	#else // _WIN32
	pWrapperTable->m_BeamSet_GetReferences = (PLib3MFBeamSet_GetReferencesPtr) dlsym(hLibrary, "lib3mf_beamset_getreferences");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamSet_GetReferences == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamSet_GetBallReferenceCount = (PLib3MFBeamSet_GetBallReferenceCountPtr) GetProcAddress(hLibrary, "lib3mf_beamset_getballreferencecount");
	#else // _WIN32
	pWrapperTable->m_BeamSet_GetBallReferenceCount = (PLib3MFBeamSet_GetBallReferenceCountPtr) dlsym(hLibrary, "lib3mf_beamset_getballreferencecount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamSet_GetBallReferenceCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamSet_SetBallReferences = (PLib3MFBeamSet_SetBallReferencesPtr) GetProcAddress(hLibrary, "lib3mf_beamset_setballreferences");
	#else // _WIN32
	pWrapperTable->m_BeamSet_SetBallReferences = (PLib3MFBeamSet_SetBallReferencesPtr) dlsym(hLibrary, "lib3mf_beamset_setballreferences");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamSet_SetBallReferences == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamSet_GetBallReferences = (PLib3MFBeamSet_GetBallReferencesPtr) GetProcAddress(hLibrary, "lib3mf_beamset_getballreferences");
	#else // _WIN32
	pWrapperTable->m_BeamSet_GetBallReferences = (PLib3MFBeamSet_GetBallReferencesPtr) dlsym(hLibrary, "lib3mf_beamset_getballreferences");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamSet_GetBallReferences == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BaseMaterialGroup_GetCount = (PLib3MFBaseMaterialGroup_GetCountPtr) GetProcAddress(hLibrary, "lib3mf_basematerialgroup_getcount");
	#else // _WIN32
	pWrapperTable->m_BaseMaterialGroup_GetCount = (PLib3MFBaseMaterialGroup_GetCountPtr) dlsym(hLibrary, "lib3mf_basematerialgroup_getcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BaseMaterialGroup_GetCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BaseMaterialGroup_GetAllPropertyIDs = (PLib3MFBaseMaterialGroup_GetAllPropertyIDsPtr) GetProcAddress(hLibrary, "lib3mf_basematerialgroup_getallpropertyids");
	#else // _WIN32
	pWrapperTable->m_BaseMaterialGroup_GetAllPropertyIDs = (PLib3MFBaseMaterialGroup_GetAllPropertyIDsPtr) dlsym(hLibrary, "lib3mf_basematerialgroup_getallpropertyids");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BaseMaterialGroup_GetAllPropertyIDs == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BaseMaterialGroup_AddMaterial = (PLib3MFBaseMaterialGroup_AddMaterialPtr) GetProcAddress(hLibrary, "lib3mf_basematerialgroup_addmaterial");
	#else // _WIN32
	pWrapperTable->m_BaseMaterialGroup_AddMaterial = (PLib3MFBaseMaterialGroup_AddMaterialPtr) dlsym(hLibrary, "lib3mf_basematerialgroup_addmaterial");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BaseMaterialGroup_AddMaterial == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BaseMaterialGroup_RemoveMaterial = (PLib3MFBaseMaterialGroup_RemoveMaterialPtr) GetProcAddress(hLibrary, "lib3mf_basematerialgroup_removematerial");
	#else // _WIN32
	pWrapperTable->m_BaseMaterialGroup_RemoveMaterial = (PLib3MFBaseMaterialGroup_RemoveMaterialPtr) dlsym(hLibrary, "lib3mf_basematerialgroup_removematerial");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BaseMaterialGroup_RemoveMaterial == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BaseMaterialGroup_GetName = (PLib3MFBaseMaterialGroup_GetNamePtr) GetProcAddress(hLibrary, "lib3mf_basematerialgroup_getname");
	#else // _WIN32
	pWrapperTable->m_BaseMaterialGroup_GetName = (PLib3MFBaseMaterialGroup_GetNamePtr) dlsym(hLibrary, "lib3mf_basematerialgroup_getname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BaseMaterialGroup_GetName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BaseMaterialGroup_SetName = (PLib3MFBaseMaterialGroup_SetNamePtr) GetProcAddress(hLibrary, "lib3mf_basematerialgroup_setname");
	#else // _WIN32
	pWrapperTable->m_BaseMaterialGroup_SetName = (PLib3MFBaseMaterialGroup_SetNamePtr) dlsym(hLibrary, "lib3mf_basematerialgroup_setname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BaseMaterialGroup_SetName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BaseMaterialGroup_SetDisplayColor = (PLib3MFBaseMaterialGroup_SetDisplayColorPtr) GetProcAddress(hLibrary, "lib3mf_basematerialgroup_setdisplaycolor");
	#else // _WIN32
	pWrapperTable->m_BaseMaterialGroup_SetDisplayColor = (PLib3MFBaseMaterialGroup_SetDisplayColorPtr) dlsym(hLibrary, "lib3mf_basematerialgroup_setdisplaycolor");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BaseMaterialGroup_SetDisplayColor == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BaseMaterialGroup_GetDisplayColor = (PLib3MFBaseMaterialGroup_GetDisplayColorPtr) GetProcAddress(hLibrary, "lib3mf_basematerialgroup_getdisplaycolor");
	#else // _WIN32
	pWrapperTable->m_BaseMaterialGroup_GetDisplayColor = (PLib3MFBaseMaterialGroup_GetDisplayColorPtr) dlsym(hLibrary, "lib3mf_basematerialgroup_getdisplaycolor");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BaseMaterialGroup_GetDisplayColor == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ColorGroup_GetCount = (PLib3MFColorGroup_GetCountPtr) GetProcAddress(hLibrary, "lib3mf_colorgroup_getcount");
	#else // _WIN32
	pWrapperTable->m_ColorGroup_GetCount = (PLib3MFColorGroup_GetCountPtr) dlsym(hLibrary, "lib3mf_colorgroup_getcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ColorGroup_GetCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ColorGroup_GetAllPropertyIDs = (PLib3MFColorGroup_GetAllPropertyIDsPtr) GetProcAddress(hLibrary, "lib3mf_colorgroup_getallpropertyids");
	#else // _WIN32
	pWrapperTable->m_ColorGroup_GetAllPropertyIDs = (PLib3MFColorGroup_GetAllPropertyIDsPtr) dlsym(hLibrary, "lib3mf_colorgroup_getallpropertyids");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ColorGroup_GetAllPropertyIDs == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ColorGroup_AddColor = (PLib3MFColorGroup_AddColorPtr) GetProcAddress(hLibrary, "lib3mf_colorgroup_addcolor");
	#else // _WIN32
	pWrapperTable->m_ColorGroup_AddColor = (PLib3MFColorGroup_AddColorPtr) dlsym(hLibrary, "lib3mf_colorgroup_addcolor");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ColorGroup_AddColor == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ColorGroup_RemoveColor = (PLib3MFColorGroup_RemoveColorPtr) GetProcAddress(hLibrary, "lib3mf_colorgroup_removecolor");
	#else // _WIN32
	pWrapperTable->m_ColorGroup_RemoveColor = (PLib3MFColorGroup_RemoveColorPtr) dlsym(hLibrary, "lib3mf_colorgroup_removecolor");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ColorGroup_RemoveColor == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ColorGroup_SetColor = (PLib3MFColorGroup_SetColorPtr) GetProcAddress(hLibrary, "lib3mf_colorgroup_setcolor");
	#else // _WIN32
	pWrapperTable->m_ColorGroup_SetColor = (PLib3MFColorGroup_SetColorPtr) dlsym(hLibrary, "lib3mf_colorgroup_setcolor");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ColorGroup_SetColor == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ColorGroup_GetColor = (PLib3MFColorGroup_GetColorPtr) GetProcAddress(hLibrary, "lib3mf_colorgroup_getcolor");
	#else // _WIN32
	pWrapperTable->m_ColorGroup_GetColor = (PLib3MFColorGroup_GetColorPtr) dlsym(hLibrary, "lib3mf_colorgroup_getcolor");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ColorGroup_GetColor == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Texture2DGroup_GetCount = (PLib3MFTexture2DGroup_GetCountPtr) GetProcAddress(hLibrary, "lib3mf_texture2dgroup_getcount");
	#else // _WIN32
	pWrapperTable->m_Texture2DGroup_GetCount = (PLib3MFTexture2DGroup_GetCountPtr) dlsym(hLibrary, "lib3mf_texture2dgroup_getcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Texture2DGroup_GetCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Texture2DGroup_GetAllPropertyIDs = (PLib3MFTexture2DGroup_GetAllPropertyIDsPtr) GetProcAddress(hLibrary, "lib3mf_texture2dgroup_getallpropertyids");
	#else // _WIN32
	pWrapperTable->m_Texture2DGroup_GetAllPropertyIDs = (PLib3MFTexture2DGroup_GetAllPropertyIDsPtr) dlsym(hLibrary, "lib3mf_texture2dgroup_getallpropertyids");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Texture2DGroup_GetAllPropertyIDs == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Texture2DGroup_AddTex2Coord = (PLib3MFTexture2DGroup_AddTex2CoordPtr) GetProcAddress(hLibrary, "lib3mf_texture2dgroup_addtex2coord");
	#else // _WIN32
	pWrapperTable->m_Texture2DGroup_AddTex2Coord = (PLib3MFTexture2DGroup_AddTex2CoordPtr) dlsym(hLibrary, "lib3mf_texture2dgroup_addtex2coord");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Texture2DGroup_AddTex2Coord == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Texture2DGroup_GetTex2Coord = (PLib3MFTexture2DGroup_GetTex2CoordPtr) GetProcAddress(hLibrary, "lib3mf_texture2dgroup_gettex2coord");
	#else // _WIN32
	pWrapperTable->m_Texture2DGroup_GetTex2Coord = (PLib3MFTexture2DGroup_GetTex2CoordPtr) dlsym(hLibrary, "lib3mf_texture2dgroup_gettex2coord");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Texture2DGroup_GetTex2Coord == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Texture2DGroup_RemoveTex2Coord = (PLib3MFTexture2DGroup_RemoveTex2CoordPtr) GetProcAddress(hLibrary, "lib3mf_texture2dgroup_removetex2coord");
	#else // _WIN32
	pWrapperTable->m_Texture2DGroup_RemoveTex2Coord = (PLib3MFTexture2DGroup_RemoveTex2CoordPtr) dlsym(hLibrary, "lib3mf_texture2dgroup_removetex2coord");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Texture2DGroup_RemoveTex2Coord == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Texture2DGroup_GetTexture2D = (PLib3MFTexture2DGroup_GetTexture2DPtr) GetProcAddress(hLibrary, "lib3mf_texture2dgroup_gettexture2d");
	#else // _WIN32
	pWrapperTable->m_Texture2DGroup_GetTexture2D = (PLib3MFTexture2DGroup_GetTexture2DPtr) dlsym(hLibrary, "lib3mf_texture2dgroup_gettexture2d");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Texture2DGroup_GetTexture2D == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_CompositeMaterials_GetCount = (PLib3MFCompositeMaterials_GetCountPtr) GetProcAddress(hLibrary, "lib3mf_compositematerials_getcount");
	#else // _WIN32
	pWrapperTable->m_CompositeMaterials_GetCount = (PLib3MFCompositeMaterials_GetCountPtr) dlsym(hLibrary, "lib3mf_compositematerials_getcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_CompositeMaterials_GetCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_CompositeMaterials_GetAllPropertyIDs = (PLib3MFCompositeMaterials_GetAllPropertyIDsPtr) GetProcAddress(hLibrary, "lib3mf_compositematerials_getallpropertyids");
	#else // _WIN32
	pWrapperTable->m_CompositeMaterials_GetAllPropertyIDs = (PLib3MFCompositeMaterials_GetAllPropertyIDsPtr) dlsym(hLibrary, "lib3mf_compositematerials_getallpropertyids");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_CompositeMaterials_GetAllPropertyIDs == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_CompositeMaterials_GetBaseMaterialGroup = (PLib3MFCompositeMaterials_GetBaseMaterialGroupPtr) GetProcAddress(hLibrary, "lib3mf_compositematerials_getbasematerialgroup");
	#else // _WIN32
	pWrapperTable->m_CompositeMaterials_GetBaseMaterialGroup = (PLib3MFCompositeMaterials_GetBaseMaterialGroupPtr) dlsym(hLibrary, "lib3mf_compositematerials_getbasematerialgroup");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_CompositeMaterials_GetBaseMaterialGroup == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_CompositeMaterials_AddComposite = (PLib3MFCompositeMaterials_AddCompositePtr) GetProcAddress(hLibrary, "lib3mf_compositematerials_addcomposite");
	#else // _WIN32
	pWrapperTable->m_CompositeMaterials_AddComposite = (PLib3MFCompositeMaterials_AddCompositePtr) dlsym(hLibrary, "lib3mf_compositematerials_addcomposite");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_CompositeMaterials_AddComposite == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_CompositeMaterials_RemoveComposite = (PLib3MFCompositeMaterials_RemoveCompositePtr) GetProcAddress(hLibrary, "lib3mf_compositematerials_removecomposite");
	#else // _WIN32
	pWrapperTable->m_CompositeMaterials_RemoveComposite = (PLib3MFCompositeMaterials_RemoveCompositePtr) dlsym(hLibrary, "lib3mf_compositematerials_removecomposite");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_CompositeMaterials_RemoveComposite == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_CompositeMaterials_GetComposite = (PLib3MFCompositeMaterials_GetCompositePtr) GetProcAddress(hLibrary, "lib3mf_compositematerials_getcomposite");
	#else // _WIN32
	pWrapperTable->m_CompositeMaterials_GetComposite = (PLib3MFCompositeMaterials_GetCompositePtr) dlsym(hLibrary, "lib3mf_compositematerials_getcomposite");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_CompositeMaterials_GetComposite == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MultiPropertyGroup_GetCount = (PLib3MFMultiPropertyGroup_GetCountPtr) GetProcAddress(hLibrary, "lib3mf_multipropertygroup_getcount");
	#else // _WIN32
	pWrapperTable->m_MultiPropertyGroup_GetCount = (PLib3MFMultiPropertyGroup_GetCountPtr) dlsym(hLibrary, "lib3mf_multipropertygroup_getcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MultiPropertyGroup_GetCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MultiPropertyGroup_GetAllPropertyIDs = (PLib3MFMultiPropertyGroup_GetAllPropertyIDsPtr) GetProcAddress(hLibrary, "lib3mf_multipropertygroup_getallpropertyids");
	#else // _WIN32
	pWrapperTable->m_MultiPropertyGroup_GetAllPropertyIDs = (PLib3MFMultiPropertyGroup_GetAllPropertyIDsPtr) dlsym(hLibrary, "lib3mf_multipropertygroup_getallpropertyids");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MultiPropertyGroup_GetAllPropertyIDs == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MultiPropertyGroup_AddMultiProperty = (PLib3MFMultiPropertyGroup_AddMultiPropertyPtr) GetProcAddress(hLibrary, "lib3mf_multipropertygroup_addmultiproperty");
	#else // _WIN32
	pWrapperTable->m_MultiPropertyGroup_AddMultiProperty = (PLib3MFMultiPropertyGroup_AddMultiPropertyPtr) dlsym(hLibrary, "lib3mf_multipropertygroup_addmultiproperty");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MultiPropertyGroup_AddMultiProperty == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MultiPropertyGroup_SetMultiProperty = (PLib3MFMultiPropertyGroup_SetMultiPropertyPtr) GetProcAddress(hLibrary, "lib3mf_multipropertygroup_setmultiproperty");
	#else // _WIN32
	pWrapperTable->m_MultiPropertyGroup_SetMultiProperty = (PLib3MFMultiPropertyGroup_SetMultiPropertyPtr) dlsym(hLibrary, "lib3mf_multipropertygroup_setmultiproperty");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MultiPropertyGroup_SetMultiProperty == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MultiPropertyGroup_GetMultiProperty = (PLib3MFMultiPropertyGroup_GetMultiPropertyPtr) GetProcAddress(hLibrary, "lib3mf_multipropertygroup_getmultiproperty");
	#else // _WIN32
	pWrapperTable->m_MultiPropertyGroup_GetMultiProperty = (PLib3MFMultiPropertyGroup_GetMultiPropertyPtr) dlsym(hLibrary, "lib3mf_multipropertygroup_getmultiproperty");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MultiPropertyGroup_GetMultiProperty == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MultiPropertyGroup_RemoveMultiProperty = (PLib3MFMultiPropertyGroup_RemoveMultiPropertyPtr) GetProcAddress(hLibrary, "lib3mf_multipropertygroup_removemultiproperty");
	#else // _WIN32
	pWrapperTable->m_MultiPropertyGroup_RemoveMultiProperty = (PLib3MFMultiPropertyGroup_RemoveMultiPropertyPtr) dlsym(hLibrary, "lib3mf_multipropertygroup_removemultiproperty");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MultiPropertyGroup_RemoveMultiProperty == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MultiPropertyGroup_GetLayerCount = (PLib3MFMultiPropertyGroup_GetLayerCountPtr) GetProcAddress(hLibrary, "lib3mf_multipropertygroup_getlayercount");
	#else // _WIN32
	pWrapperTable->m_MultiPropertyGroup_GetLayerCount = (PLib3MFMultiPropertyGroup_GetLayerCountPtr) dlsym(hLibrary, "lib3mf_multipropertygroup_getlayercount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MultiPropertyGroup_GetLayerCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MultiPropertyGroup_AddLayer = (PLib3MFMultiPropertyGroup_AddLayerPtr) GetProcAddress(hLibrary, "lib3mf_multipropertygroup_addlayer");
	#else // _WIN32
	pWrapperTable->m_MultiPropertyGroup_AddLayer = (PLib3MFMultiPropertyGroup_AddLayerPtr) dlsym(hLibrary, "lib3mf_multipropertygroup_addlayer");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MultiPropertyGroup_AddLayer == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MultiPropertyGroup_GetLayer = (PLib3MFMultiPropertyGroup_GetLayerPtr) GetProcAddress(hLibrary, "lib3mf_multipropertygroup_getlayer");
	#else // _WIN32
	pWrapperTable->m_MultiPropertyGroup_GetLayer = (PLib3MFMultiPropertyGroup_GetLayerPtr) dlsym(hLibrary, "lib3mf_multipropertygroup_getlayer");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MultiPropertyGroup_GetLayer == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MultiPropertyGroup_RemoveLayer = (PLib3MFMultiPropertyGroup_RemoveLayerPtr) GetProcAddress(hLibrary, "lib3mf_multipropertygroup_removelayer");
	#else // _WIN32
	pWrapperTable->m_MultiPropertyGroup_RemoveLayer = (PLib3MFMultiPropertyGroup_RemoveLayerPtr) dlsym(hLibrary, "lib3mf_multipropertygroup_removelayer");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MultiPropertyGroup_RemoveLayer == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Image3D_GetName = (PLib3MFImage3D_GetNamePtr) GetProcAddress(hLibrary, "lib3mf_image3d_getname");
	#else // _WIN32
	pWrapperTable->m_Image3D_GetName = (PLib3MFImage3D_GetNamePtr) dlsym(hLibrary, "lib3mf_image3d_getname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Image3D_GetName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Image3D_SetName = (PLib3MFImage3D_SetNamePtr) GetProcAddress(hLibrary, "lib3mf_image3d_setname");
	#else // _WIN32
	pWrapperTable->m_Image3D_SetName = (PLib3MFImage3D_SetNamePtr) dlsym(hLibrary, "lib3mf_image3d_setname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Image3D_SetName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Image3D_IsImageStack = (PLib3MFImage3D_IsImageStackPtr) GetProcAddress(hLibrary, "lib3mf_image3d_isimagestack");
	#else // _WIN32
	pWrapperTable->m_Image3D_IsImageStack = (PLib3MFImage3D_IsImageStackPtr) dlsym(hLibrary, "lib3mf_image3d_isimagestack");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Image3D_IsImageStack == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImageStack_GetRowCount = (PLib3MFImageStack_GetRowCountPtr) GetProcAddress(hLibrary, "lib3mf_imagestack_getrowcount");
	#else // _WIN32
	pWrapperTable->m_ImageStack_GetRowCount = (PLib3MFImageStack_GetRowCountPtr) dlsym(hLibrary, "lib3mf_imagestack_getrowcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImageStack_GetRowCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImageStack_SetRowCount = (PLib3MFImageStack_SetRowCountPtr) GetProcAddress(hLibrary, "lib3mf_imagestack_setrowcount");
	#else // _WIN32
	pWrapperTable->m_ImageStack_SetRowCount = (PLib3MFImageStack_SetRowCountPtr) dlsym(hLibrary, "lib3mf_imagestack_setrowcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImageStack_SetRowCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImageStack_GetColumnCount = (PLib3MFImageStack_GetColumnCountPtr) GetProcAddress(hLibrary, "lib3mf_imagestack_getcolumncount");
	#else // _WIN32
	pWrapperTable->m_ImageStack_GetColumnCount = (PLib3MFImageStack_GetColumnCountPtr) dlsym(hLibrary, "lib3mf_imagestack_getcolumncount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImageStack_GetColumnCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImageStack_SetColumnCount = (PLib3MFImageStack_SetColumnCountPtr) GetProcAddress(hLibrary, "lib3mf_imagestack_setcolumncount");
	#else // _WIN32
	pWrapperTable->m_ImageStack_SetColumnCount = (PLib3MFImageStack_SetColumnCountPtr) dlsym(hLibrary, "lib3mf_imagestack_setcolumncount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImageStack_SetColumnCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImageStack_GetSheetCount = (PLib3MFImageStack_GetSheetCountPtr) GetProcAddress(hLibrary, "lib3mf_imagestack_getsheetcount");
	#else // _WIN32
	pWrapperTable->m_ImageStack_GetSheetCount = (PLib3MFImageStack_GetSheetCountPtr) dlsym(hLibrary, "lib3mf_imagestack_getsheetcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImageStack_GetSheetCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImageStack_GetSheet = (PLib3MFImageStack_GetSheetPtr) GetProcAddress(hLibrary, "lib3mf_imagestack_getsheet");
	#else // _WIN32
	pWrapperTable->m_ImageStack_GetSheet = (PLib3MFImageStack_GetSheetPtr) dlsym(hLibrary, "lib3mf_imagestack_getsheet");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImageStack_GetSheet == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImageStack_SetSheet = (PLib3MFImageStack_SetSheetPtr) GetProcAddress(hLibrary, "lib3mf_imagestack_setsheet");
	#else // _WIN32
	pWrapperTable->m_ImageStack_SetSheet = (PLib3MFImageStack_SetSheetPtr) dlsym(hLibrary, "lib3mf_imagestack_setsheet");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImageStack_SetSheet == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImageStack_CreateEmptySheet = (PLib3MFImageStack_CreateEmptySheetPtr) GetProcAddress(hLibrary, "lib3mf_imagestack_createemptysheet");
	#else // _WIN32
	pWrapperTable->m_ImageStack_CreateEmptySheet = (PLib3MFImageStack_CreateEmptySheetPtr) dlsym(hLibrary, "lib3mf_imagestack_createemptysheet");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImageStack_CreateEmptySheet == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImageStack_CreateSheetFromBuffer = (PLib3MFImageStack_CreateSheetFromBufferPtr) GetProcAddress(hLibrary, "lib3mf_imagestack_createsheetfrombuffer");
	#else // _WIN32
	pWrapperTable->m_ImageStack_CreateSheetFromBuffer = (PLib3MFImageStack_CreateSheetFromBufferPtr) dlsym(hLibrary, "lib3mf_imagestack_createsheetfrombuffer");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImageStack_CreateSheetFromBuffer == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImageStack_CreateSheetFromFile = (PLib3MFImageStack_CreateSheetFromFilePtr) GetProcAddress(hLibrary, "lib3mf_imagestack_createsheetfromfile");
	#else // _WIN32
	pWrapperTable->m_ImageStack_CreateSheetFromFile = (PLib3MFImageStack_CreateSheetFromFilePtr) dlsym(hLibrary, "lib3mf_imagestack_createsheetfromfile");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImageStack_CreateSheetFromFile == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Attachment_GetPath = (PLib3MFAttachment_GetPathPtr) GetProcAddress(hLibrary, "lib3mf_attachment_getpath");
	#else // _WIN32
	pWrapperTable->m_Attachment_GetPath = (PLib3MFAttachment_GetPathPtr) dlsym(hLibrary, "lib3mf_attachment_getpath");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Attachment_GetPath == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Attachment_SetPath = (PLib3MFAttachment_SetPathPtr) GetProcAddress(hLibrary, "lib3mf_attachment_setpath");
	#else // _WIN32
	pWrapperTable->m_Attachment_SetPath = (PLib3MFAttachment_SetPathPtr) dlsym(hLibrary, "lib3mf_attachment_setpath");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Attachment_SetPath == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Attachment_PackagePart = (PLib3MFAttachment_PackagePartPtr) GetProcAddress(hLibrary, "lib3mf_attachment_packagepart");
	#else // _WIN32
	pWrapperTable->m_Attachment_PackagePart = (PLib3MFAttachment_PackagePartPtr) dlsym(hLibrary, "lib3mf_attachment_packagepart");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Attachment_PackagePart == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Attachment_GetRelationShipType = (PLib3MFAttachment_GetRelationShipTypePtr) GetProcAddress(hLibrary, "lib3mf_attachment_getrelationshiptype");
	#else // _WIN32
	pWrapperTable->m_Attachment_GetRelationShipType = (PLib3MFAttachment_GetRelationShipTypePtr) dlsym(hLibrary, "lib3mf_attachment_getrelationshiptype");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Attachment_GetRelationShipType == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Attachment_SetRelationShipType = (PLib3MFAttachment_SetRelationShipTypePtr) GetProcAddress(hLibrary, "lib3mf_attachment_setrelationshiptype");
	#else // _WIN32
	pWrapperTable->m_Attachment_SetRelationShipType = (PLib3MFAttachment_SetRelationShipTypePtr) dlsym(hLibrary, "lib3mf_attachment_setrelationshiptype");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Attachment_SetRelationShipType == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Attachment_WriteToFile = (PLib3MFAttachment_WriteToFilePtr) GetProcAddress(hLibrary, "lib3mf_attachment_writetofile");
	#else // _WIN32
	pWrapperTable->m_Attachment_WriteToFile = (PLib3MFAttachment_WriteToFilePtr) dlsym(hLibrary, "lib3mf_attachment_writetofile");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Attachment_WriteToFile == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Attachment_ReadFromFile = (PLib3MFAttachment_ReadFromFilePtr) GetProcAddress(hLibrary, "lib3mf_attachment_readfromfile");
	#else // _WIN32
	pWrapperTable->m_Attachment_ReadFromFile = (PLib3MFAttachment_ReadFromFilePtr) dlsym(hLibrary, "lib3mf_attachment_readfromfile");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Attachment_ReadFromFile == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Attachment_ReadFromCallback = (PLib3MFAttachment_ReadFromCallbackPtr) GetProcAddress(hLibrary, "lib3mf_attachment_readfromcallback");
	#else // _WIN32
	pWrapperTable->m_Attachment_ReadFromCallback = (PLib3MFAttachment_ReadFromCallbackPtr) dlsym(hLibrary, "lib3mf_attachment_readfromcallback");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Attachment_ReadFromCallback == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Attachment_GetStreamSize = (PLib3MFAttachment_GetStreamSizePtr) GetProcAddress(hLibrary, "lib3mf_attachment_getstreamsize");
	#else // _WIN32
	pWrapperTable->m_Attachment_GetStreamSize = (PLib3MFAttachment_GetStreamSizePtr) dlsym(hLibrary, "lib3mf_attachment_getstreamsize");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Attachment_GetStreamSize == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Attachment_WriteToBuffer = (PLib3MFAttachment_WriteToBufferPtr) GetProcAddress(hLibrary, "lib3mf_attachment_writetobuffer");
	#else // _WIN32
	pWrapperTable->m_Attachment_WriteToBuffer = (PLib3MFAttachment_WriteToBufferPtr) dlsym(hLibrary, "lib3mf_attachment_writetobuffer");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Attachment_WriteToBuffer == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Attachment_ReadFromBuffer = (PLib3MFAttachment_ReadFromBufferPtr) GetProcAddress(hLibrary, "lib3mf_attachment_readfrombuffer");
	#else // _WIN32
	pWrapperTable->m_Attachment_ReadFromBuffer = (PLib3MFAttachment_ReadFromBufferPtr) dlsym(hLibrary, "lib3mf_attachment_readfrombuffer");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Attachment_ReadFromBuffer == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Texture2D_GetAttachment = (PLib3MFTexture2D_GetAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_texture2d_getattachment");
	#else // _WIN32
	pWrapperTable->m_Texture2D_GetAttachment = (PLib3MFTexture2D_GetAttachmentPtr) dlsym(hLibrary, "lib3mf_texture2d_getattachment");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Texture2D_GetAttachment == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Texture2D_SetAttachment = (PLib3MFTexture2D_SetAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_texture2d_setattachment");
	#else // _WIN32
	pWrapperTable->m_Texture2D_SetAttachment = (PLib3MFTexture2D_SetAttachmentPtr) dlsym(hLibrary, "lib3mf_texture2d_setattachment");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Texture2D_SetAttachment == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Texture2D_GetContentType = (PLib3MFTexture2D_GetContentTypePtr) GetProcAddress(hLibrary, "lib3mf_texture2d_getcontenttype");
	#else // _WIN32
	pWrapperTable->m_Texture2D_GetContentType = (PLib3MFTexture2D_GetContentTypePtr) dlsym(hLibrary, "lib3mf_texture2d_getcontenttype");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Texture2D_GetContentType == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Texture2D_SetContentType = (PLib3MFTexture2D_SetContentTypePtr) GetProcAddress(hLibrary, "lib3mf_texture2d_setcontenttype");
	#else // _WIN32
	pWrapperTable->m_Texture2D_SetContentType = (PLib3MFTexture2D_SetContentTypePtr) dlsym(hLibrary, "lib3mf_texture2d_setcontenttype");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Texture2D_SetContentType == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Texture2D_GetTileStyleUV = (PLib3MFTexture2D_GetTileStyleUVPtr) GetProcAddress(hLibrary, "lib3mf_texture2d_gettilestyleuv");
	#else // _WIN32
	pWrapperTable->m_Texture2D_GetTileStyleUV = (PLib3MFTexture2D_GetTileStyleUVPtr) dlsym(hLibrary, "lib3mf_texture2d_gettilestyleuv");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Texture2D_GetTileStyleUV == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Texture2D_SetTileStyleUV = (PLib3MFTexture2D_SetTileStyleUVPtr) GetProcAddress(hLibrary, "lib3mf_texture2d_settilestyleuv");
	#else // _WIN32
	pWrapperTable->m_Texture2D_SetTileStyleUV = (PLib3MFTexture2D_SetTileStyleUVPtr) dlsym(hLibrary, "lib3mf_texture2d_settilestyleuv");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Texture2D_SetTileStyleUV == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Texture2D_GetFilter = (PLib3MFTexture2D_GetFilterPtr) GetProcAddress(hLibrary, "lib3mf_texture2d_getfilter");
	#else // _WIN32
	pWrapperTable->m_Texture2D_GetFilter = (PLib3MFTexture2D_GetFilterPtr) dlsym(hLibrary, "lib3mf_texture2d_getfilter");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Texture2D_GetFilter == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Texture2D_SetFilter = (PLib3MFTexture2D_SetFilterPtr) GetProcAddress(hLibrary, "lib3mf_texture2d_setfilter");
	#else // _WIN32
	pWrapperTable->m_Texture2D_SetFilter = (PLib3MFTexture2D_SetFilterPtr) dlsym(hLibrary, "lib3mf_texture2d_setfilter");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Texture2D_SetFilter == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitPort_GetIdentifier = (PLib3MFImplicitPort_GetIdentifierPtr) GetProcAddress(hLibrary, "lib3mf_implicitport_getidentifier");
	#else // _WIN32
	pWrapperTable->m_ImplicitPort_GetIdentifier = (PLib3MFImplicitPort_GetIdentifierPtr) dlsym(hLibrary, "lib3mf_implicitport_getidentifier");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitPort_GetIdentifier == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitPort_SetIdentifier = (PLib3MFImplicitPort_SetIdentifierPtr) GetProcAddress(hLibrary, "lib3mf_implicitport_setidentifier");
	#else // _WIN32
	pWrapperTable->m_ImplicitPort_SetIdentifier = (PLib3MFImplicitPort_SetIdentifierPtr) dlsym(hLibrary, "lib3mf_implicitport_setidentifier");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitPort_SetIdentifier == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitPort_GetDisplayName = (PLib3MFImplicitPort_GetDisplayNamePtr) GetProcAddress(hLibrary, "lib3mf_implicitport_getdisplayname");
	#else // _WIN32
	pWrapperTable->m_ImplicitPort_GetDisplayName = (PLib3MFImplicitPort_GetDisplayNamePtr) dlsym(hLibrary, "lib3mf_implicitport_getdisplayname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitPort_GetDisplayName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitPort_SetDisplayName = (PLib3MFImplicitPort_SetDisplayNamePtr) GetProcAddress(hLibrary, "lib3mf_implicitport_setdisplayname");
	#else // _WIN32
	pWrapperTable->m_ImplicitPort_SetDisplayName = (PLib3MFImplicitPort_SetDisplayNamePtr) dlsym(hLibrary, "lib3mf_implicitport_setdisplayname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitPort_SetDisplayName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitPort_SetType = (PLib3MFImplicitPort_SetTypePtr) GetProcAddress(hLibrary, "lib3mf_implicitport_settype");
	#else // _WIN32
	pWrapperTable->m_ImplicitPort_SetType = (PLib3MFImplicitPort_SetTypePtr) dlsym(hLibrary, "lib3mf_implicitport_settype");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitPort_SetType == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitPort_GetType = (PLib3MFImplicitPort_GetTypePtr) GetProcAddress(hLibrary, "lib3mf_implicitport_gettype");
	#else // _WIN32
	pWrapperTable->m_ImplicitPort_GetType = (PLib3MFImplicitPort_GetTypePtr) dlsym(hLibrary, "lib3mf_implicitport_gettype");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitPort_GetType == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitPort_GetReference = (PLib3MFImplicitPort_GetReferencePtr) GetProcAddress(hLibrary, "lib3mf_implicitport_getreference");
	#else // _WIN32
	pWrapperTable->m_ImplicitPort_GetReference = (PLib3MFImplicitPort_GetReferencePtr) dlsym(hLibrary, "lib3mf_implicitport_getreference");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitPort_GetReference == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitPort_SetReference = (PLib3MFImplicitPort_SetReferencePtr) GetProcAddress(hLibrary, "lib3mf_implicitport_setreference");
	#else // _WIN32
	pWrapperTable->m_ImplicitPort_SetReference = (PLib3MFImplicitPort_SetReferencePtr) dlsym(hLibrary, "lib3mf_implicitport_setreference");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitPort_SetReference == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Iterator_MoveNext = (PLib3MFIterator_MoveNextPtr) GetProcAddress(hLibrary, "lib3mf_iterator_movenext");
	#else // _WIN32
	pWrapperTable->m_Iterator_MoveNext = (PLib3MFIterator_MoveNextPtr) dlsym(hLibrary, "lib3mf_iterator_movenext");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Iterator_MoveNext == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Iterator_MovePrevious = (PLib3MFIterator_MovePreviousPtr) GetProcAddress(hLibrary, "lib3mf_iterator_moveprevious");
	#else // _WIN32
	pWrapperTable->m_Iterator_MovePrevious = (PLib3MFIterator_MovePreviousPtr) dlsym(hLibrary, "lib3mf_iterator_moveprevious");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Iterator_MovePrevious == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Iterator_Count = (PLib3MFIterator_CountPtr) GetProcAddress(hLibrary, "lib3mf_iterator_count");
	#else // _WIN32
	pWrapperTable->m_Iterator_Count = (PLib3MFIterator_CountPtr) dlsym(hLibrary, "lib3mf_iterator_count");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Iterator_Count == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitPortIterator_GetCurrent = (PLib3MFImplicitPortIterator_GetCurrentPtr) GetProcAddress(hLibrary, "lib3mf_implicitportiterator_getcurrent");
	#else // _WIN32
	pWrapperTable->m_ImplicitPortIterator_GetCurrent = (PLib3MFImplicitPortIterator_GetCurrentPtr) dlsym(hLibrary, "lib3mf_implicitportiterator_getcurrent");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitPortIterator_GetCurrent == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitNode_GetIdentifier = (PLib3MFImplicitNode_GetIdentifierPtr) GetProcAddress(hLibrary, "lib3mf_implicitnode_getidentifier");
	#else // _WIN32
	pWrapperTable->m_ImplicitNode_GetIdentifier = (PLib3MFImplicitNode_GetIdentifierPtr) dlsym(hLibrary, "lib3mf_implicitnode_getidentifier");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitNode_GetIdentifier == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitNode_SetIdentifier = (PLib3MFImplicitNode_SetIdentifierPtr) GetProcAddress(hLibrary, "lib3mf_implicitnode_setidentifier");
	#else // _WIN32
	pWrapperTable->m_ImplicitNode_SetIdentifier = (PLib3MFImplicitNode_SetIdentifierPtr) dlsym(hLibrary, "lib3mf_implicitnode_setidentifier");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitNode_SetIdentifier == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitNode_GetDisplayName = (PLib3MFImplicitNode_GetDisplayNamePtr) GetProcAddress(hLibrary, "lib3mf_implicitnode_getdisplayname");
	#else // _WIN32
	pWrapperTable->m_ImplicitNode_GetDisplayName = (PLib3MFImplicitNode_GetDisplayNamePtr) dlsym(hLibrary, "lib3mf_implicitnode_getdisplayname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitNode_GetDisplayName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitNode_SetDisplayName = (PLib3MFImplicitNode_SetDisplayNamePtr) GetProcAddress(hLibrary, "lib3mf_implicitnode_setdisplayname");
	#else // _WIN32
	pWrapperTable->m_ImplicitNode_SetDisplayName = (PLib3MFImplicitNode_SetDisplayNamePtr) dlsym(hLibrary, "lib3mf_implicitnode_setdisplayname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitNode_SetDisplayName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitNode_GetTag = (PLib3MFImplicitNode_GetTagPtr) GetProcAddress(hLibrary, "lib3mf_implicitnode_gettag");
	#else // _WIN32
	pWrapperTable->m_ImplicitNode_GetTag = (PLib3MFImplicitNode_GetTagPtr) dlsym(hLibrary, "lib3mf_implicitnode_gettag");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitNode_GetTag == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitNode_SetTag = (PLib3MFImplicitNode_SetTagPtr) GetProcAddress(hLibrary, "lib3mf_implicitnode_settag");
	#else // _WIN32
	pWrapperTable->m_ImplicitNode_SetTag = (PLib3MFImplicitNode_SetTagPtr) dlsym(hLibrary, "lib3mf_implicitnode_settag");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitNode_SetTag == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitNode_GetNodeType = (PLib3MFImplicitNode_GetNodeTypePtr) GetProcAddress(hLibrary, "lib3mf_implicitnode_getnodetype");
	#else // _WIN32
	pWrapperTable->m_ImplicitNode_GetNodeType = (PLib3MFImplicitNode_GetNodeTypePtr) dlsym(hLibrary, "lib3mf_implicitnode_getnodetype");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitNode_GetNodeType == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitNode_AddInput = (PLib3MFImplicitNode_AddInputPtr) GetProcAddress(hLibrary, "lib3mf_implicitnode_addinput");
	#else // _WIN32
	pWrapperTable->m_ImplicitNode_AddInput = (PLib3MFImplicitNode_AddInputPtr) dlsym(hLibrary, "lib3mf_implicitnode_addinput");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitNode_AddInput == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitNode_GetInputs = (PLib3MFImplicitNode_GetInputsPtr) GetProcAddress(hLibrary, "lib3mf_implicitnode_getinputs");
	#else // _WIN32
	pWrapperTable->m_ImplicitNode_GetInputs = (PLib3MFImplicitNode_GetInputsPtr) dlsym(hLibrary, "lib3mf_implicitnode_getinputs");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitNode_GetInputs == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitNode_AddOutput = (PLib3MFImplicitNode_AddOutputPtr) GetProcAddress(hLibrary, "lib3mf_implicitnode_addoutput");
	#else // _WIN32
	pWrapperTable->m_ImplicitNode_AddOutput = (PLib3MFImplicitNode_AddOutputPtr) dlsym(hLibrary, "lib3mf_implicitnode_addoutput");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitNode_AddOutput == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitNode_GetOutputs = (PLib3MFImplicitNode_GetOutputsPtr) GetProcAddress(hLibrary, "lib3mf_implicitnode_getoutputs");
	#else // _WIN32
	pWrapperTable->m_ImplicitNode_GetOutputs = (PLib3MFImplicitNode_GetOutputsPtr) dlsym(hLibrary, "lib3mf_implicitnode_getoutputs");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitNode_GetOutputs == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitNode_FindInput = (PLib3MFImplicitNode_FindInputPtr) GetProcAddress(hLibrary, "lib3mf_implicitnode_findinput");
	#else // _WIN32
	pWrapperTable->m_ImplicitNode_FindInput = (PLib3MFImplicitNode_FindInputPtr) dlsym(hLibrary, "lib3mf_implicitnode_findinput");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitNode_FindInput == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitNode_FindOutput = (PLib3MFImplicitNode_FindOutputPtr) GetProcAddress(hLibrary, "lib3mf_implicitnode_findoutput");
	#else // _WIN32
	pWrapperTable->m_ImplicitNode_FindOutput = (PLib3MFImplicitNode_FindOutputPtr) dlsym(hLibrary, "lib3mf_implicitnode_findoutput");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitNode_FindOutput == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitNode_AreTypesValid = (PLib3MFImplicitNode_AreTypesValidPtr) GetProcAddress(hLibrary, "lib3mf_implicitnode_aretypesvalid");
	#else // _WIN32
	pWrapperTable->m_ImplicitNode_AreTypesValid = (PLib3MFImplicitNode_AreTypesValidPtr) dlsym(hLibrary, "lib3mf_implicitnode_aretypesvalid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitNode_AreTypesValid == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_OneInputNode_GetInputA = (PLib3MFOneInputNode_GetInputAPtr) GetProcAddress(hLibrary, "lib3mf_oneinputnode_getinputa");
	#else // _WIN32
	pWrapperTable->m_OneInputNode_GetInputA = (PLib3MFOneInputNode_GetInputAPtr) dlsym(hLibrary, "lib3mf_oneinputnode_getinputa");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_OneInputNode_GetInputA == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_OneInputNode_GetOutputResult = (PLib3MFOneInputNode_GetOutputResultPtr) GetProcAddress(hLibrary, "lib3mf_oneinputnode_getoutputresult");
	#else // _WIN32
	pWrapperTable->m_OneInputNode_GetOutputResult = (PLib3MFOneInputNode_GetOutputResultPtr) dlsym(hLibrary, "lib3mf_oneinputnode_getoutputresult");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_OneInputNode_GetOutputResult == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ResourceIdNode_SetResource = (PLib3MFResourceIdNode_SetResourcePtr) GetProcAddress(hLibrary, "lib3mf_resourceidnode_setresource");
	#else // _WIN32
	pWrapperTable->m_ResourceIdNode_SetResource = (PLib3MFResourceIdNode_SetResourcePtr) dlsym(hLibrary, "lib3mf_resourceidnode_setresource");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ResourceIdNode_SetResource == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ResourceIdNode_GetResource = (PLib3MFResourceIdNode_GetResourcePtr) GetProcAddress(hLibrary, "lib3mf_resourceidnode_getresource");
	#else // _WIN32
	pWrapperTable->m_ResourceIdNode_GetResource = (PLib3MFResourceIdNode_GetResourcePtr) dlsym(hLibrary, "lib3mf_resourceidnode_getresource");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ResourceIdNode_GetResource == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ResourceIdNode_GetOutputValue = (PLib3MFResourceIdNode_GetOutputValuePtr) GetProcAddress(hLibrary, "lib3mf_resourceidnode_getoutputvalue");
	#else // _WIN32
	pWrapperTable->m_ResourceIdNode_GetOutputValue = (PLib3MFResourceIdNode_GetOutputValuePtr) dlsym(hLibrary, "lib3mf_resourceidnode_getoutputvalue");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ResourceIdNode_GetOutputValue == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_TwoInputNode_GetInputB = (PLib3MFTwoInputNode_GetInputBPtr) GetProcAddress(hLibrary, "lib3mf_twoinputnode_getinputb");
	#else // _WIN32
	pWrapperTable->m_TwoInputNode_GetInputB = (PLib3MFTwoInputNode_GetInputBPtr) dlsym(hLibrary, "lib3mf_twoinputnode_getinputb");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_TwoInputNode_GetInputB == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_SelectNode_GetInputB = (PLib3MFSelectNode_GetInputBPtr) GetProcAddress(hLibrary, "lib3mf_selectnode_getinputb");
	#else // _WIN32
	pWrapperTable->m_SelectNode_GetInputB = (PLib3MFSelectNode_GetInputBPtr) dlsym(hLibrary, "lib3mf_selectnode_getinputb");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_SelectNode_GetInputB == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_SelectNode_GetInputC = (PLib3MFSelectNode_GetInputCPtr) GetProcAddress(hLibrary, "lib3mf_selectnode_getinputc");
	#else // _WIN32
	pWrapperTable->m_SelectNode_GetInputC = (PLib3MFSelectNode_GetInputCPtr) dlsym(hLibrary, "lib3mf_selectnode_getinputc");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_SelectNode_GetInputC == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_SelectNode_GetInputD = (PLib3MFSelectNode_GetInputDPtr) GetProcAddress(hLibrary, "lib3mf_selectnode_getinputd");
	#else // _WIN32
	pWrapperTable->m_SelectNode_GetInputD = (PLib3MFSelectNode_GetInputDPtr) dlsym(hLibrary, "lib3mf_selectnode_getinputd");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_SelectNode_GetInputD == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ClampNode_GetInputMin = (PLib3MFClampNode_GetInputMinPtr) GetProcAddress(hLibrary, "lib3mf_clampnode_getinputmin");
	#else // _WIN32
	pWrapperTable->m_ClampNode_GetInputMin = (PLib3MFClampNode_GetInputMinPtr) dlsym(hLibrary, "lib3mf_clampnode_getinputmin");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ClampNode_GetInputMin == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ClampNode_GetInputMax = (PLib3MFClampNode_GetInputMaxPtr) GetProcAddress(hLibrary, "lib3mf_clampnode_getinputmax");
	#else // _WIN32
	pWrapperTable->m_ClampNode_GetInputMax = (PLib3MFClampNode_GetInputMaxPtr) dlsym(hLibrary, "lib3mf_clampnode_getinputmax");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ClampNode_GetInputMax == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ComposeVectorNode_GetInputX = (PLib3MFComposeVectorNode_GetInputXPtr) GetProcAddress(hLibrary, "lib3mf_composevectornode_getinputx");
	#else // _WIN32
	pWrapperTable->m_ComposeVectorNode_GetInputX = (PLib3MFComposeVectorNode_GetInputXPtr) dlsym(hLibrary, "lib3mf_composevectornode_getinputx");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ComposeVectorNode_GetInputX == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ComposeVectorNode_GetInputY = (PLib3MFComposeVectorNode_GetInputYPtr) GetProcAddress(hLibrary, "lib3mf_composevectornode_getinputy");
	#else // _WIN32
	pWrapperTable->m_ComposeVectorNode_GetInputY = (PLib3MFComposeVectorNode_GetInputYPtr) dlsym(hLibrary, "lib3mf_composevectornode_getinputy");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ComposeVectorNode_GetInputY == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ComposeVectorNode_GetInputZ = (PLib3MFComposeVectorNode_GetInputZPtr) GetProcAddress(hLibrary, "lib3mf_composevectornode_getinputz");
	#else // _WIN32
	pWrapperTable->m_ComposeVectorNode_GetInputZ = (PLib3MFComposeVectorNode_GetInputZPtr) dlsym(hLibrary, "lib3mf_composevectornode_getinputz");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ComposeVectorNode_GetInputZ == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ComposeVectorNode_GetOutputResult = (PLib3MFComposeVectorNode_GetOutputResultPtr) GetProcAddress(hLibrary, "lib3mf_composevectornode_getoutputresult");
	#else // _WIN32
	pWrapperTable->m_ComposeVectorNode_GetOutputResult = (PLib3MFComposeVectorNode_GetOutputResultPtr) dlsym(hLibrary, "lib3mf_composevectornode_getoutputresult");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ComposeVectorNode_GetOutputResult == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_DecomposeVectorNode_GetInputA = (PLib3MFDecomposeVectorNode_GetInputAPtr) GetProcAddress(hLibrary, "lib3mf_decomposevectornode_getinputa");
	#else // _WIN32
	pWrapperTable->m_DecomposeVectorNode_GetInputA = (PLib3MFDecomposeVectorNode_GetInputAPtr) dlsym(hLibrary, "lib3mf_decomposevectornode_getinputa");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_DecomposeVectorNode_GetInputA == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_DecomposeVectorNode_GetOutputX = (PLib3MFDecomposeVectorNode_GetOutputXPtr) GetProcAddress(hLibrary, "lib3mf_decomposevectornode_getoutputx");
	#else // _WIN32
	pWrapperTable->m_DecomposeVectorNode_GetOutputX = (PLib3MFDecomposeVectorNode_GetOutputXPtr) dlsym(hLibrary, "lib3mf_decomposevectornode_getoutputx");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_DecomposeVectorNode_GetOutputX == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_DecomposeVectorNode_GetOutputY = (PLib3MFDecomposeVectorNode_GetOutputYPtr) GetProcAddress(hLibrary, "lib3mf_decomposevectornode_getoutputy");
	#else // _WIN32
	pWrapperTable->m_DecomposeVectorNode_GetOutputY = (PLib3MFDecomposeVectorNode_GetOutputYPtr) dlsym(hLibrary, "lib3mf_decomposevectornode_getoutputy");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_DecomposeVectorNode_GetOutputY == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_DecomposeVectorNode_GetOutputZ = (PLib3MFDecomposeVectorNode_GetOutputZPtr) GetProcAddress(hLibrary, "lib3mf_decomposevectornode_getoutputz");
	#else // _WIN32
	pWrapperTable->m_DecomposeVectorNode_GetOutputZ = (PLib3MFDecomposeVectorNode_GetOutputZPtr) dlsym(hLibrary, "lib3mf_decomposevectornode_getoutputz");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_DecomposeVectorNode_GetOutputZ == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ComposeMatrixNode_GetInputM00 = (PLib3MFComposeMatrixNode_GetInputM00Ptr) GetProcAddress(hLibrary, "lib3mf_composematrixnode_getinputm00");
	#else // _WIN32
	pWrapperTable->m_ComposeMatrixNode_GetInputM00 = (PLib3MFComposeMatrixNode_GetInputM00Ptr) dlsym(hLibrary, "lib3mf_composematrixnode_getinputm00");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ComposeMatrixNode_GetInputM00 == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ComposeMatrixNode_GetInputM01 = (PLib3MFComposeMatrixNode_GetInputM01Ptr) GetProcAddress(hLibrary, "lib3mf_composematrixnode_getinputm01");
	#else // _WIN32
	pWrapperTable->m_ComposeMatrixNode_GetInputM01 = (PLib3MFComposeMatrixNode_GetInputM01Ptr) dlsym(hLibrary, "lib3mf_composematrixnode_getinputm01");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ComposeMatrixNode_GetInputM01 == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ComposeMatrixNode_GetInputM02 = (PLib3MFComposeMatrixNode_GetInputM02Ptr) GetProcAddress(hLibrary, "lib3mf_composematrixnode_getinputm02");
	#else // _WIN32
	pWrapperTable->m_ComposeMatrixNode_GetInputM02 = (PLib3MFComposeMatrixNode_GetInputM02Ptr) dlsym(hLibrary, "lib3mf_composematrixnode_getinputm02");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ComposeMatrixNode_GetInputM02 == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ComposeMatrixNode_GetInputM03 = (PLib3MFComposeMatrixNode_GetInputM03Ptr) GetProcAddress(hLibrary, "lib3mf_composematrixnode_getinputm03");
	#else // _WIN32
	pWrapperTable->m_ComposeMatrixNode_GetInputM03 = (PLib3MFComposeMatrixNode_GetInputM03Ptr) dlsym(hLibrary, "lib3mf_composematrixnode_getinputm03");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ComposeMatrixNode_GetInputM03 == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ComposeMatrixNode_GetInputM10 = (PLib3MFComposeMatrixNode_GetInputM10Ptr) GetProcAddress(hLibrary, "lib3mf_composematrixnode_getinputm10");
	#else // _WIN32
	pWrapperTable->m_ComposeMatrixNode_GetInputM10 = (PLib3MFComposeMatrixNode_GetInputM10Ptr) dlsym(hLibrary, "lib3mf_composematrixnode_getinputm10");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ComposeMatrixNode_GetInputM10 == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ComposeMatrixNode_GetInputM11 = (PLib3MFComposeMatrixNode_GetInputM11Ptr) GetProcAddress(hLibrary, "lib3mf_composematrixnode_getinputm11");
	#else // _WIN32
	pWrapperTable->m_ComposeMatrixNode_GetInputM11 = (PLib3MFComposeMatrixNode_GetInputM11Ptr) dlsym(hLibrary, "lib3mf_composematrixnode_getinputm11");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ComposeMatrixNode_GetInputM11 == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ComposeMatrixNode_GetInputM12 = (PLib3MFComposeMatrixNode_GetInputM12Ptr) GetProcAddress(hLibrary, "lib3mf_composematrixnode_getinputm12");
	#else // _WIN32
	pWrapperTable->m_ComposeMatrixNode_GetInputM12 = (PLib3MFComposeMatrixNode_GetInputM12Ptr) dlsym(hLibrary, "lib3mf_composematrixnode_getinputm12");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ComposeMatrixNode_GetInputM12 == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ComposeMatrixNode_GetInputM13 = (PLib3MFComposeMatrixNode_GetInputM13Ptr) GetProcAddress(hLibrary, "lib3mf_composematrixnode_getinputm13");
	#else // _WIN32
	pWrapperTable->m_ComposeMatrixNode_GetInputM13 = (PLib3MFComposeMatrixNode_GetInputM13Ptr) dlsym(hLibrary, "lib3mf_composematrixnode_getinputm13");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ComposeMatrixNode_GetInputM13 == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ComposeMatrixNode_GetInputM20 = (PLib3MFComposeMatrixNode_GetInputM20Ptr) GetProcAddress(hLibrary, "lib3mf_composematrixnode_getinputm20");
	#else // _WIN32
	pWrapperTable->m_ComposeMatrixNode_GetInputM20 = (PLib3MFComposeMatrixNode_GetInputM20Ptr) dlsym(hLibrary, "lib3mf_composematrixnode_getinputm20");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ComposeMatrixNode_GetInputM20 == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ComposeMatrixNode_GetInputM21 = (PLib3MFComposeMatrixNode_GetInputM21Ptr) GetProcAddress(hLibrary, "lib3mf_composematrixnode_getinputm21");
	#else // _WIN32
	pWrapperTable->m_ComposeMatrixNode_GetInputM21 = (PLib3MFComposeMatrixNode_GetInputM21Ptr) dlsym(hLibrary, "lib3mf_composematrixnode_getinputm21");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ComposeMatrixNode_GetInputM21 == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ComposeMatrixNode_GetInputM22 = (PLib3MFComposeMatrixNode_GetInputM22Ptr) GetProcAddress(hLibrary, "lib3mf_composematrixnode_getinputm22");
	#else // _WIN32
	pWrapperTable->m_ComposeMatrixNode_GetInputM22 = (PLib3MFComposeMatrixNode_GetInputM22Ptr) dlsym(hLibrary, "lib3mf_composematrixnode_getinputm22");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ComposeMatrixNode_GetInputM22 == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ComposeMatrixNode_GetInputM23 = (PLib3MFComposeMatrixNode_GetInputM23Ptr) GetProcAddress(hLibrary, "lib3mf_composematrixnode_getinputm23");
	#else // _WIN32
	pWrapperTable->m_ComposeMatrixNode_GetInputM23 = (PLib3MFComposeMatrixNode_GetInputM23Ptr) dlsym(hLibrary, "lib3mf_composematrixnode_getinputm23");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ComposeMatrixNode_GetInputM23 == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ComposeMatrixNode_GetInputM30 = (PLib3MFComposeMatrixNode_GetInputM30Ptr) GetProcAddress(hLibrary, "lib3mf_composematrixnode_getinputm30");
	#else // _WIN32
	pWrapperTable->m_ComposeMatrixNode_GetInputM30 = (PLib3MFComposeMatrixNode_GetInputM30Ptr) dlsym(hLibrary, "lib3mf_composematrixnode_getinputm30");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ComposeMatrixNode_GetInputM30 == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ComposeMatrixNode_GetInputM31 = (PLib3MFComposeMatrixNode_GetInputM31Ptr) GetProcAddress(hLibrary, "lib3mf_composematrixnode_getinputm31");
	#else // _WIN32
	pWrapperTable->m_ComposeMatrixNode_GetInputM31 = (PLib3MFComposeMatrixNode_GetInputM31Ptr) dlsym(hLibrary, "lib3mf_composematrixnode_getinputm31");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ComposeMatrixNode_GetInputM31 == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ComposeMatrixNode_GetInputM32 = (PLib3MFComposeMatrixNode_GetInputM32Ptr) GetProcAddress(hLibrary, "lib3mf_composematrixnode_getinputm32");
	#else // _WIN32
	pWrapperTable->m_ComposeMatrixNode_GetInputM32 = (PLib3MFComposeMatrixNode_GetInputM32Ptr) dlsym(hLibrary, "lib3mf_composematrixnode_getinputm32");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ComposeMatrixNode_GetInputM32 == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ComposeMatrixNode_GetInputM33 = (PLib3MFComposeMatrixNode_GetInputM33Ptr) GetProcAddress(hLibrary, "lib3mf_composematrixnode_getinputm33");
	#else // _WIN32
	pWrapperTable->m_ComposeMatrixNode_GetInputM33 = (PLib3MFComposeMatrixNode_GetInputM33Ptr) dlsym(hLibrary, "lib3mf_composematrixnode_getinputm33");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ComposeMatrixNode_GetInputM33 == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ComposeMatrixNode_GetOutputResult = (PLib3MFComposeMatrixNode_GetOutputResultPtr) GetProcAddress(hLibrary, "lib3mf_composematrixnode_getoutputresult");
	#else // _WIN32
	pWrapperTable->m_ComposeMatrixNode_GetOutputResult = (PLib3MFComposeMatrixNode_GetOutputResultPtr) dlsym(hLibrary, "lib3mf_composematrixnode_getoutputresult");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ComposeMatrixNode_GetOutputResult == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MatrixFromRowsNode_GetInputA = (PLib3MFMatrixFromRowsNode_GetInputAPtr) GetProcAddress(hLibrary, "lib3mf_matrixfromrowsnode_getinputa");
	#else // _WIN32
	pWrapperTable->m_MatrixFromRowsNode_GetInputA = (PLib3MFMatrixFromRowsNode_GetInputAPtr) dlsym(hLibrary, "lib3mf_matrixfromrowsnode_getinputa");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MatrixFromRowsNode_GetInputA == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MatrixFromRowsNode_GetInputB = (PLib3MFMatrixFromRowsNode_GetInputBPtr) GetProcAddress(hLibrary, "lib3mf_matrixfromrowsnode_getinputb");
	#else // _WIN32
	pWrapperTable->m_MatrixFromRowsNode_GetInputB = (PLib3MFMatrixFromRowsNode_GetInputBPtr) dlsym(hLibrary, "lib3mf_matrixfromrowsnode_getinputb");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MatrixFromRowsNode_GetInputB == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MatrixFromRowsNode_GetInputC = (PLib3MFMatrixFromRowsNode_GetInputCPtr) GetProcAddress(hLibrary, "lib3mf_matrixfromrowsnode_getinputc");
	#else // _WIN32
	pWrapperTable->m_MatrixFromRowsNode_GetInputC = (PLib3MFMatrixFromRowsNode_GetInputCPtr) dlsym(hLibrary, "lib3mf_matrixfromrowsnode_getinputc");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MatrixFromRowsNode_GetInputC == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MatrixFromRowsNode_GetInputD = (PLib3MFMatrixFromRowsNode_GetInputDPtr) GetProcAddress(hLibrary, "lib3mf_matrixfromrowsnode_getinputd");
	#else // _WIN32
	pWrapperTable->m_MatrixFromRowsNode_GetInputD = (PLib3MFMatrixFromRowsNode_GetInputDPtr) dlsym(hLibrary, "lib3mf_matrixfromrowsnode_getinputd");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MatrixFromRowsNode_GetInputD == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MatrixFromRowsNode_GetOutputResult = (PLib3MFMatrixFromRowsNode_GetOutputResultPtr) GetProcAddress(hLibrary, "lib3mf_matrixfromrowsnode_getoutputresult");
	#else // _WIN32
	pWrapperTable->m_MatrixFromRowsNode_GetOutputResult = (PLib3MFMatrixFromRowsNode_GetOutputResultPtr) dlsym(hLibrary, "lib3mf_matrixfromrowsnode_getoutputresult");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MatrixFromRowsNode_GetOutputResult == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MatrixFromColumnsNode_GetInputA = (PLib3MFMatrixFromColumnsNode_GetInputAPtr) GetProcAddress(hLibrary, "lib3mf_matrixfromcolumnsnode_getinputa");
	#else // _WIN32
	pWrapperTable->m_MatrixFromColumnsNode_GetInputA = (PLib3MFMatrixFromColumnsNode_GetInputAPtr) dlsym(hLibrary, "lib3mf_matrixfromcolumnsnode_getinputa");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MatrixFromColumnsNode_GetInputA == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MatrixFromColumnsNode_GetInputB = (PLib3MFMatrixFromColumnsNode_GetInputBPtr) GetProcAddress(hLibrary, "lib3mf_matrixfromcolumnsnode_getinputb");
	#else // _WIN32
	pWrapperTable->m_MatrixFromColumnsNode_GetInputB = (PLib3MFMatrixFromColumnsNode_GetInputBPtr) dlsym(hLibrary, "lib3mf_matrixfromcolumnsnode_getinputb");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MatrixFromColumnsNode_GetInputB == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MatrixFromColumnsNode_GetInputC = (PLib3MFMatrixFromColumnsNode_GetInputCPtr) GetProcAddress(hLibrary, "lib3mf_matrixfromcolumnsnode_getinputc");
	#else // _WIN32
	pWrapperTable->m_MatrixFromColumnsNode_GetInputC = (PLib3MFMatrixFromColumnsNode_GetInputCPtr) dlsym(hLibrary, "lib3mf_matrixfromcolumnsnode_getinputc");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MatrixFromColumnsNode_GetInputC == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MatrixFromColumnsNode_GetInputD = (PLib3MFMatrixFromColumnsNode_GetInputDPtr) GetProcAddress(hLibrary, "lib3mf_matrixfromcolumnsnode_getinputd");
	#else // _WIN32
	pWrapperTable->m_MatrixFromColumnsNode_GetInputD = (PLib3MFMatrixFromColumnsNode_GetInputDPtr) dlsym(hLibrary, "lib3mf_matrixfromcolumnsnode_getinputd");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MatrixFromColumnsNode_GetInputD == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MatrixFromColumnsNode_GetOutputResult = (PLib3MFMatrixFromColumnsNode_GetOutputResultPtr) GetProcAddress(hLibrary, "lib3mf_matrixfromcolumnsnode_getoutputresult");
	#else // _WIN32
	pWrapperTable->m_MatrixFromColumnsNode_GetOutputResult = (PLib3MFMatrixFromColumnsNode_GetOutputResultPtr) dlsym(hLibrary, "lib3mf_matrixfromcolumnsnode_getoutputresult");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MatrixFromColumnsNode_GetOutputResult == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ConstantNode_SetConstant = (PLib3MFConstantNode_SetConstantPtr) GetProcAddress(hLibrary, "lib3mf_constantnode_setconstant");
	#else // _WIN32
	pWrapperTable->m_ConstantNode_SetConstant = (PLib3MFConstantNode_SetConstantPtr) dlsym(hLibrary, "lib3mf_constantnode_setconstant");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ConstantNode_SetConstant == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ConstantNode_GetConstant = (PLib3MFConstantNode_GetConstantPtr) GetProcAddress(hLibrary, "lib3mf_constantnode_getconstant");
	#else // _WIN32
	pWrapperTable->m_ConstantNode_GetConstant = (PLib3MFConstantNode_GetConstantPtr) dlsym(hLibrary, "lib3mf_constantnode_getconstant");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ConstantNode_GetConstant == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ConstantNode_GetOutputValue = (PLib3MFConstantNode_GetOutputValuePtr) GetProcAddress(hLibrary, "lib3mf_constantnode_getoutputvalue");
	#else // _WIN32
	pWrapperTable->m_ConstantNode_GetOutputValue = (PLib3MFConstantNode_GetOutputValuePtr) dlsym(hLibrary, "lib3mf_constantnode_getoutputvalue");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ConstantNode_GetOutputValue == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ConstVecNode_SetVector = (PLib3MFConstVecNode_SetVectorPtr) GetProcAddress(hLibrary, "lib3mf_constvecnode_setvector");
	#else // _WIN32
	pWrapperTable->m_ConstVecNode_SetVector = (PLib3MFConstVecNode_SetVectorPtr) dlsym(hLibrary, "lib3mf_constvecnode_setvector");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ConstVecNode_SetVector == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ConstVecNode_GetVector = (PLib3MFConstVecNode_GetVectorPtr) GetProcAddress(hLibrary, "lib3mf_constvecnode_getvector");
	#else // _WIN32
	pWrapperTable->m_ConstVecNode_GetVector = (PLib3MFConstVecNode_GetVectorPtr) dlsym(hLibrary, "lib3mf_constvecnode_getvector");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ConstVecNode_GetVector == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ConstVecNode_GetOutputVector = (PLib3MFConstVecNode_GetOutputVectorPtr) GetProcAddress(hLibrary, "lib3mf_constvecnode_getoutputvector");
	#else // _WIN32
	pWrapperTable->m_ConstVecNode_GetOutputVector = (PLib3MFConstVecNode_GetOutputVectorPtr) dlsym(hLibrary, "lib3mf_constvecnode_getoutputvector");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ConstVecNode_GetOutputVector == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ConstMatNode_SetMatrix = (PLib3MFConstMatNode_SetMatrixPtr) GetProcAddress(hLibrary, "lib3mf_constmatnode_setmatrix");
	#else // _WIN32
	pWrapperTable->m_ConstMatNode_SetMatrix = (PLib3MFConstMatNode_SetMatrixPtr) dlsym(hLibrary, "lib3mf_constmatnode_setmatrix");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ConstMatNode_SetMatrix == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ConstMatNode_GetMatrix = (PLib3MFConstMatNode_GetMatrixPtr) GetProcAddress(hLibrary, "lib3mf_constmatnode_getmatrix");
	#else // _WIN32
	pWrapperTable->m_ConstMatNode_GetMatrix = (PLib3MFConstMatNode_GetMatrixPtr) dlsym(hLibrary, "lib3mf_constmatnode_getmatrix");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ConstMatNode_GetMatrix == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ConstMatNode_GetOutputMatrix = (PLib3MFConstMatNode_GetOutputMatrixPtr) GetProcAddress(hLibrary, "lib3mf_constmatnode_getoutputmatrix");
	#else // _WIN32
	pWrapperTable->m_ConstMatNode_GetOutputMatrix = (PLib3MFConstMatNode_GetOutputMatrixPtr) dlsym(hLibrary, "lib3mf_constmatnode_getoutputmatrix");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ConstMatNode_GetOutputMatrix == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshNode_GetInputMesh = (PLib3MFMeshNode_GetInputMeshPtr) GetProcAddress(hLibrary, "lib3mf_meshnode_getinputmesh");
	#else // _WIN32
	pWrapperTable->m_MeshNode_GetInputMesh = (PLib3MFMeshNode_GetInputMeshPtr) dlsym(hLibrary, "lib3mf_meshnode_getinputmesh");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshNode_GetInputMesh == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshNode_GetInputPos = (PLib3MFMeshNode_GetInputPosPtr) GetProcAddress(hLibrary, "lib3mf_meshnode_getinputpos");
	#else // _WIN32
	pWrapperTable->m_MeshNode_GetInputPos = (PLib3MFMeshNode_GetInputPosPtr) dlsym(hLibrary, "lib3mf_meshnode_getinputpos");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshNode_GetInputPos == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshNode_GetOutputDistance = (PLib3MFMeshNode_GetOutputDistancePtr) GetProcAddress(hLibrary, "lib3mf_meshnode_getoutputdistance");
	#else // _WIN32
	pWrapperTable->m_MeshNode_GetOutputDistance = (PLib3MFMeshNode_GetOutputDistancePtr) dlsym(hLibrary, "lib3mf_meshnode_getoutputdistance");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshNode_GetOutputDistance == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_UnsignedMeshNode_GetInputMesh = (PLib3MFUnsignedMeshNode_GetInputMeshPtr) GetProcAddress(hLibrary, "lib3mf_unsignedmeshnode_getinputmesh");
	#else // _WIN32
	pWrapperTable->m_UnsignedMeshNode_GetInputMesh = (PLib3MFUnsignedMeshNode_GetInputMeshPtr) dlsym(hLibrary, "lib3mf_unsignedmeshnode_getinputmesh");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_UnsignedMeshNode_GetInputMesh == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_UnsignedMeshNode_GetInputPos = (PLib3MFUnsignedMeshNode_GetInputPosPtr) GetProcAddress(hLibrary, "lib3mf_unsignedmeshnode_getinputpos");
	#else // _WIN32
	pWrapperTable->m_UnsignedMeshNode_GetInputPos = (PLib3MFUnsignedMeshNode_GetInputPosPtr) dlsym(hLibrary, "lib3mf_unsignedmeshnode_getinputpos");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_UnsignedMeshNode_GetInputPos == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_UnsignedMeshNode_GetOutputDistance = (PLib3MFUnsignedMeshNode_GetOutputDistancePtr) GetProcAddress(hLibrary, "lib3mf_unsignedmeshnode_getoutputdistance");
	#else // _WIN32
	pWrapperTable->m_UnsignedMeshNode_GetOutputDistance = (PLib3MFUnsignedMeshNode_GetOutputDistancePtr) dlsym(hLibrary, "lib3mf_unsignedmeshnode_getoutputdistance");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_UnsignedMeshNode_GetOutputDistance == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLatticeNode_GetInputBeamLattice = (PLib3MFBeamLatticeNode_GetInputBeamLatticePtr) GetProcAddress(hLibrary, "lib3mf_beamlatticenode_getinputbeamlattice");
	#else // _WIN32
	pWrapperTable->m_BeamLatticeNode_GetInputBeamLattice = (PLib3MFBeamLatticeNode_GetInputBeamLatticePtr) dlsym(hLibrary, "lib3mf_beamlatticenode_getinputbeamlattice");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLatticeNode_GetInputBeamLattice == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLatticeNode_GetInputPos = (PLib3MFBeamLatticeNode_GetInputPosPtr) GetProcAddress(hLibrary, "lib3mf_beamlatticenode_getinputpos");
	#else // _WIN32
	pWrapperTable->m_BeamLatticeNode_GetInputPos = (PLib3MFBeamLatticeNode_GetInputPosPtr) dlsym(hLibrary, "lib3mf_beamlatticenode_getinputpos");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLatticeNode_GetInputPos == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLatticeNode_GetOutputDistance = (PLib3MFBeamLatticeNode_GetOutputDistancePtr) GetProcAddress(hLibrary, "lib3mf_beamlatticenode_getoutputdistance");
	#else // _WIN32
	pWrapperTable->m_BeamLatticeNode_GetOutputDistance = (PLib3MFBeamLatticeNode_GetOutputDistancePtr) dlsym(hLibrary, "lib3mf_beamlatticenode_getoutputdistance");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLatticeNode_GetOutputDistance == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLatticeNode_SetAccurateRange = (PLib3MFBeamLatticeNode_SetAccurateRangePtr) GetProcAddress(hLibrary, "lib3mf_beamlatticenode_setaccuraterange");
	#else // _WIN32
	pWrapperTable->m_BeamLatticeNode_SetAccurateRange = (PLib3MFBeamLatticeNode_SetAccurateRangePtr) dlsym(hLibrary, "lib3mf_beamlatticenode_setaccuraterange");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLatticeNode_SetAccurateRange == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLatticeNode_GetAccurateRange = (PLib3MFBeamLatticeNode_GetAccurateRangePtr) GetProcAddress(hLibrary, "lib3mf_beamlatticenode_getaccuraterange");
	#else // _WIN32
	pWrapperTable->m_BeamLatticeNode_GetAccurateRange = (PLib3MFBeamLatticeNode_GetAccurateRangePtr) dlsym(hLibrary, "lib3mf_beamlatticenode_getaccuraterange");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLatticeNode_GetAccurateRange == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FunctionGradientNode_GetInputFunctionID = (PLib3MFFunctionGradientNode_GetInputFunctionIDPtr) GetProcAddress(hLibrary, "lib3mf_functiongradientnode_getinputfunctionid");
	#else // _WIN32
	pWrapperTable->m_FunctionGradientNode_GetInputFunctionID = (PLib3MFFunctionGradientNode_GetInputFunctionIDPtr) dlsym(hLibrary, "lib3mf_functiongradientnode_getinputfunctionid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FunctionGradientNode_GetInputFunctionID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FunctionGradientNode_GetInputPos = (PLib3MFFunctionGradientNode_GetInputPosPtr) GetProcAddress(hLibrary, "lib3mf_functiongradientnode_getinputpos");
	#else // _WIN32
	pWrapperTable->m_FunctionGradientNode_GetInputPos = (PLib3MFFunctionGradientNode_GetInputPosPtr) dlsym(hLibrary, "lib3mf_functiongradientnode_getinputpos");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FunctionGradientNode_GetInputPos == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FunctionGradientNode_GetInputStep = (PLib3MFFunctionGradientNode_GetInputStepPtr) GetProcAddress(hLibrary, "lib3mf_functiongradientnode_getinputstep");
	#else // _WIN32
	pWrapperTable->m_FunctionGradientNode_GetInputStep = (PLib3MFFunctionGradientNode_GetInputStepPtr) dlsym(hLibrary, "lib3mf_functiongradientnode_getinputstep");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FunctionGradientNode_GetInputStep == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FunctionGradientNode_SetScalarOutputName = (PLib3MFFunctionGradientNode_SetScalarOutputNamePtr) GetProcAddress(hLibrary, "lib3mf_functiongradientnode_setscalaroutputname");
	#else // _WIN32
	pWrapperTable->m_FunctionGradientNode_SetScalarOutputName = (PLib3MFFunctionGradientNode_SetScalarOutputNamePtr) dlsym(hLibrary, "lib3mf_functiongradientnode_setscalaroutputname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FunctionGradientNode_SetScalarOutputName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FunctionGradientNode_GetScalarOutputName = (PLib3MFFunctionGradientNode_GetScalarOutputNamePtr) GetProcAddress(hLibrary, "lib3mf_functiongradientnode_getscalaroutputname");
	#else // _WIN32
	pWrapperTable->m_FunctionGradientNode_GetScalarOutputName = (PLib3MFFunctionGradientNode_GetScalarOutputNamePtr) dlsym(hLibrary, "lib3mf_functiongradientnode_getscalaroutputname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FunctionGradientNode_GetScalarOutputName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FunctionGradientNode_SetVectorInputName = (PLib3MFFunctionGradientNode_SetVectorInputNamePtr) GetProcAddress(hLibrary, "lib3mf_functiongradientnode_setvectorinputname");
	#else // _WIN32
	pWrapperTable->m_FunctionGradientNode_SetVectorInputName = (PLib3MFFunctionGradientNode_SetVectorInputNamePtr) dlsym(hLibrary, "lib3mf_functiongradientnode_setvectorinputname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FunctionGradientNode_SetVectorInputName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FunctionGradientNode_GetVectorInputName = (PLib3MFFunctionGradientNode_GetVectorInputNamePtr) GetProcAddress(hLibrary, "lib3mf_functiongradientnode_getvectorinputname");
	#else // _WIN32
	pWrapperTable->m_FunctionGradientNode_GetVectorInputName = (PLib3MFFunctionGradientNode_GetVectorInputNamePtr) dlsym(hLibrary, "lib3mf_functiongradientnode_getvectorinputname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FunctionGradientNode_GetVectorInputName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FunctionGradientNode_GetOutputNormalizedGradient = (PLib3MFFunctionGradientNode_GetOutputNormalizedGradientPtr) GetProcAddress(hLibrary, "lib3mf_functiongradientnode_getoutputnormalizedgradient");
	#else // _WIN32
	pWrapperTable->m_FunctionGradientNode_GetOutputNormalizedGradient = (PLib3MFFunctionGradientNode_GetOutputNormalizedGradientPtr) dlsym(hLibrary, "lib3mf_functiongradientnode_getoutputnormalizedgradient");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FunctionGradientNode_GetOutputNormalizedGradient == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FunctionGradientNode_GetOutputGradient = (PLib3MFFunctionGradientNode_GetOutputGradientPtr) GetProcAddress(hLibrary, "lib3mf_functiongradientnode_getoutputgradient");
	#else // _WIN32
	pWrapperTable->m_FunctionGradientNode_GetOutputGradient = (PLib3MFFunctionGradientNode_GetOutputGradientPtr) dlsym(hLibrary, "lib3mf_functiongradientnode_getoutputgradient");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FunctionGradientNode_GetOutputGradient == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FunctionGradientNode_GetOutputMagnitude = (PLib3MFFunctionGradientNode_GetOutputMagnitudePtr) GetProcAddress(hLibrary, "lib3mf_functiongradientnode_getoutputmagnitude");
	#else // _WIN32
	pWrapperTable->m_FunctionGradientNode_GetOutputMagnitude = (PLib3MFFunctionGradientNode_GetOutputMagnitudePtr) dlsym(hLibrary, "lib3mf_functiongradientnode_getoutputmagnitude");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FunctionGradientNode_GetOutputMagnitude == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_NormalizeDistanceNode_GetInputFunctionID = (PLib3MFNormalizeDistanceNode_GetInputFunctionIDPtr) GetProcAddress(hLibrary, "lib3mf_normalizedistancenode_getinputfunctionid");
	#else // _WIN32
	pWrapperTable->m_NormalizeDistanceNode_GetInputFunctionID = (PLib3MFNormalizeDistanceNode_GetInputFunctionIDPtr) dlsym(hLibrary, "lib3mf_normalizedistancenode_getinputfunctionid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_NormalizeDistanceNode_GetInputFunctionID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_NormalizeDistanceNode_GetInputPos = (PLib3MFNormalizeDistanceNode_GetInputPosPtr) GetProcAddress(hLibrary, "lib3mf_normalizedistancenode_getinputpos");
	#else // _WIN32
	pWrapperTable->m_NormalizeDistanceNode_GetInputPos = (PLib3MFNormalizeDistanceNode_GetInputPosPtr) dlsym(hLibrary, "lib3mf_normalizedistancenode_getinputpos");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_NormalizeDistanceNode_GetInputPos == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_NormalizeDistanceNode_GetInputStep = (PLib3MFNormalizeDistanceNode_GetInputStepPtr) GetProcAddress(hLibrary, "lib3mf_normalizedistancenode_getinputstep");
	#else // _WIN32
	pWrapperTable->m_NormalizeDistanceNode_GetInputStep = (PLib3MFNormalizeDistanceNode_GetInputStepPtr) dlsym(hLibrary, "lib3mf_normalizedistancenode_getinputstep");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_NormalizeDistanceNode_GetInputStep == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_NormalizeDistanceNode_SetScalarOutputName = (PLib3MFNormalizeDistanceNode_SetScalarOutputNamePtr) GetProcAddress(hLibrary, "lib3mf_normalizedistancenode_setscalaroutputname");
	#else // _WIN32
	pWrapperTable->m_NormalizeDistanceNode_SetScalarOutputName = (PLib3MFNormalizeDistanceNode_SetScalarOutputNamePtr) dlsym(hLibrary, "lib3mf_normalizedistancenode_setscalaroutputname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_NormalizeDistanceNode_SetScalarOutputName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_NormalizeDistanceNode_GetScalarOutputName = (PLib3MFNormalizeDistanceNode_GetScalarOutputNamePtr) GetProcAddress(hLibrary, "lib3mf_normalizedistancenode_getscalaroutputname");
	#else // _WIN32
	pWrapperTable->m_NormalizeDistanceNode_GetScalarOutputName = (PLib3MFNormalizeDistanceNode_GetScalarOutputNamePtr) dlsym(hLibrary, "lib3mf_normalizedistancenode_getscalaroutputname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_NormalizeDistanceNode_GetScalarOutputName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_NormalizeDistanceNode_SetVectorInputName = (PLib3MFNormalizeDistanceNode_SetVectorInputNamePtr) GetProcAddress(hLibrary, "lib3mf_normalizedistancenode_setvectorinputname");
	#else // _WIN32
	pWrapperTable->m_NormalizeDistanceNode_SetVectorInputName = (PLib3MFNormalizeDistanceNode_SetVectorInputNamePtr) dlsym(hLibrary, "lib3mf_normalizedistancenode_setvectorinputname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_NormalizeDistanceNode_SetVectorInputName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_NormalizeDistanceNode_GetVectorInputName = (PLib3MFNormalizeDistanceNode_GetVectorInputNamePtr) GetProcAddress(hLibrary, "lib3mf_normalizedistancenode_getvectorinputname");
	#else // _WIN32
	pWrapperTable->m_NormalizeDistanceNode_GetVectorInputName = (PLib3MFNormalizeDistanceNode_GetVectorInputNamePtr) dlsym(hLibrary, "lib3mf_normalizedistancenode_getvectorinputname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_NormalizeDistanceNode_GetVectorInputName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_NormalizeDistanceNode_GetOutputResult = (PLib3MFNormalizeDistanceNode_GetOutputResultPtr) GetProcAddress(hLibrary, "lib3mf_normalizedistancenode_getoutputresult");
	#else // _WIN32
	pWrapperTable->m_NormalizeDistanceNode_GetOutputResult = (PLib3MFNormalizeDistanceNode_GetOutputResultPtr) dlsym(hLibrary, "lib3mf_normalizedistancenode_getoutputresult");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_NormalizeDistanceNode_GetOutputResult == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FunctionCallNode_GetInputFunctionID = (PLib3MFFunctionCallNode_GetInputFunctionIDPtr) GetProcAddress(hLibrary, "lib3mf_functioncallnode_getinputfunctionid");
	#else // _WIN32
	pWrapperTable->m_FunctionCallNode_GetInputFunctionID = (PLib3MFFunctionCallNode_GetInputFunctionIDPtr) dlsym(hLibrary, "lib3mf_functioncallnode_getinputfunctionid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FunctionCallNode_GetInputFunctionID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_NodeIterator_GetCurrent = (PLib3MFNodeIterator_GetCurrentPtr) GetProcAddress(hLibrary, "lib3mf_nodeiterator_getcurrent");
	#else // _WIN32
	pWrapperTable->m_NodeIterator_GetCurrent = (PLib3MFNodeIterator_GetCurrentPtr) dlsym(hLibrary, "lib3mf_nodeiterator_getcurrent");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_NodeIterator_GetCurrent == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Function_GetDisplayName = (PLib3MFFunction_GetDisplayNamePtr) GetProcAddress(hLibrary, "lib3mf_function_getdisplayname");
	#else // _WIN32
	pWrapperTable->m_Function_GetDisplayName = (PLib3MFFunction_GetDisplayNamePtr) dlsym(hLibrary, "lib3mf_function_getdisplayname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Function_GetDisplayName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Function_SetDisplayName = (PLib3MFFunction_SetDisplayNamePtr) GetProcAddress(hLibrary, "lib3mf_function_setdisplayname");
	#else // _WIN32
	pWrapperTable->m_Function_SetDisplayName = (PLib3MFFunction_SetDisplayNamePtr) dlsym(hLibrary, "lib3mf_function_setdisplayname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Function_SetDisplayName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Function_AddInput = (PLib3MFFunction_AddInputPtr) GetProcAddress(hLibrary, "lib3mf_function_addinput");
	#else // _WIN32
	pWrapperTable->m_Function_AddInput = (PLib3MFFunction_AddInputPtr) dlsym(hLibrary, "lib3mf_function_addinput");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Function_AddInput == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Function_GetInputs = (PLib3MFFunction_GetInputsPtr) GetProcAddress(hLibrary, "lib3mf_function_getinputs");
	#else // _WIN32
	pWrapperTable->m_Function_GetInputs = (PLib3MFFunction_GetInputsPtr) dlsym(hLibrary, "lib3mf_function_getinputs");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Function_GetInputs == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Function_RemoveInput = (PLib3MFFunction_RemoveInputPtr) GetProcAddress(hLibrary, "lib3mf_function_removeinput");
	#else // _WIN32
	pWrapperTable->m_Function_RemoveInput = (PLib3MFFunction_RemoveInputPtr) dlsym(hLibrary, "lib3mf_function_removeinput");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Function_RemoveInput == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Function_AddOutput = (PLib3MFFunction_AddOutputPtr) GetProcAddress(hLibrary, "lib3mf_function_addoutput");
	#else // _WIN32
	pWrapperTable->m_Function_AddOutput = (PLib3MFFunction_AddOutputPtr) dlsym(hLibrary, "lib3mf_function_addoutput");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Function_AddOutput == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Function_GetOutputs = (PLib3MFFunction_GetOutputsPtr) GetProcAddress(hLibrary, "lib3mf_function_getoutputs");
	#else // _WIN32
	pWrapperTable->m_Function_GetOutputs = (PLib3MFFunction_GetOutputsPtr) dlsym(hLibrary, "lib3mf_function_getoutputs");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Function_GetOutputs == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Function_RemoveOutput = (PLib3MFFunction_RemoveOutputPtr) GetProcAddress(hLibrary, "lib3mf_function_removeoutput");
	#else // _WIN32
	pWrapperTable->m_Function_RemoveOutput = (PLib3MFFunction_RemoveOutputPtr) dlsym(hLibrary, "lib3mf_function_removeoutput");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Function_RemoveOutput == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Function_FindInput = (PLib3MFFunction_FindInputPtr) GetProcAddress(hLibrary, "lib3mf_function_findinput");
	#else // _WIN32
	pWrapperTable->m_Function_FindInput = (PLib3MFFunction_FindInputPtr) dlsym(hLibrary, "lib3mf_function_findinput");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Function_FindInput == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Function_FindOutput = (PLib3MFFunction_FindOutputPtr) GetProcAddress(hLibrary, "lib3mf_function_findoutput");
	#else // _WIN32
	pWrapperTable->m_Function_FindOutput = (PLib3MFFunction_FindOutputPtr) dlsym(hLibrary, "lib3mf_function_findoutput");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Function_FindOutput == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_GetIdentifier = (PLib3MFImplicitFunction_GetIdentifierPtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_getidentifier");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_GetIdentifier = (PLib3MFImplicitFunction_GetIdentifierPtr) dlsym(hLibrary, "lib3mf_implicitfunction_getidentifier");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_GetIdentifier == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_SetIdentifier = (PLib3MFImplicitFunction_SetIdentifierPtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_setidentifier");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_SetIdentifier = (PLib3MFImplicitFunction_SetIdentifierPtr) dlsym(hLibrary, "lib3mf_implicitfunction_setidentifier");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_SetIdentifier == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddNode = (PLib3MFImplicitFunction_AddNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddNode = (PLib3MFImplicitFunction_AddNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddSinNode = (PLib3MFImplicitFunction_AddSinNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addsinnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddSinNode = (PLib3MFImplicitFunction_AddSinNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addsinnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddSinNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddCosNode = (PLib3MFImplicitFunction_AddCosNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addcosnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddCosNode = (PLib3MFImplicitFunction_AddCosNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addcosnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddCosNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddTanNode = (PLib3MFImplicitFunction_AddTanNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addtannode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddTanNode = (PLib3MFImplicitFunction_AddTanNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addtannode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddTanNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddArcSinNode = (PLib3MFImplicitFunction_AddArcSinNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addarcsinnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddArcSinNode = (PLib3MFImplicitFunction_AddArcSinNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addarcsinnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddArcSinNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddArcCosNode = (PLib3MFImplicitFunction_AddArcCosNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addarccosnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddArcCosNode = (PLib3MFImplicitFunction_AddArcCosNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addarccosnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddArcCosNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddArcTan2Node = (PLib3MFImplicitFunction_AddArcTan2NodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addarctan2node");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddArcTan2Node = (PLib3MFImplicitFunction_AddArcTan2NodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addarctan2node");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddArcTan2Node == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddSinhNode = (PLib3MFImplicitFunction_AddSinhNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addsinhnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddSinhNode = (PLib3MFImplicitFunction_AddSinhNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addsinhnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddSinhNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddCoshNode = (PLib3MFImplicitFunction_AddCoshNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addcoshnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddCoshNode = (PLib3MFImplicitFunction_AddCoshNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addcoshnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddCoshNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddTanhNode = (PLib3MFImplicitFunction_AddTanhNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addtanhnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddTanhNode = (PLib3MFImplicitFunction_AddTanhNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addtanhnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddTanhNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddRoundNode = (PLib3MFImplicitFunction_AddRoundNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addroundnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddRoundNode = (PLib3MFImplicitFunction_AddRoundNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addroundnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddRoundNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddCeilNode = (PLib3MFImplicitFunction_AddCeilNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addceilnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddCeilNode = (PLib3MFImplicitFunction_AddCeilNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addceilnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddCeilNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddFloorNode = (PLib3MFImplicitFunction_AddFloorNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addfloornode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddFloorNode = (PLib3MFImplicitFunction_AddFloorNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addfloornode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddFloorNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddSignNode = (PLib3MFImplicitFunction_AddSignNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addsignnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddSignNode = (PLib3MFImplicitFunction_AddSignNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addsignnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddSignNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddFractNode = (PLib3MFImplicitFunction_AddFractNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addfractnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddFractNode = (PLib3MFImplicitFunction_AddFractNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addfractnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddFractNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddAbsNode = (PLib3MFImplicitFunction_AddAbsNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addabsnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddAbsNode = (PLib3MFImplicitFunction_AddAbsNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addabsnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddAbsNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddExpNode = (PLib3MFImplicitFunction_AddExpNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addexpnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddExpNode = (PLib3MFImplicitFunction_AddExpNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addexpnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddExpNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddLogNode = (PLib3MFImplicitFunction_AddLogNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addlognode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddLogNode = (PLib3MFImplicitFunction_AddLogNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addlognode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddLogNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddLog2Node = (PLib3MFImplicitFunction_AddLog2NodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addlog2node");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddLog2Node = (PLib3MFImplicitFunction_AddLog2NodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addlog2node");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddLog2Node == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddLog10Node = (PLib3MFImplicitFunction_AddLog10NodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addlog10node");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddLog10Node = (PLib3MFImplicitFunction_AddLog10NodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addlog10node");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddLog10Node == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddLengthNode = (PLib3MFImplicitFunction_AddLengthNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addlengthnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddLengthNode = (PLib3MFImplicitFunction_AddLengthNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addlengthnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddLengthNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddTransposeNode = (PLib3MFImplicitFunction_AddTransposeNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addtransposenode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddTransposeNode = (PLib3MFImplicitFunction_AddTransposeNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addtransposenode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddTransposeNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddInverseNode = (PLib3MFImplicitFunction_AddInverseNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addinversenode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddInverseNode = (PLib3MFImplicitFunction_AddInverseNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addinversenode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddInverseNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddSqrtNode = (PLib3MFImplicitFunction_AddSqrtNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addsqrtnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddSqrtNode = (PLib3MFImplicitFunction_AddSqrtNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addsqrtnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddSqrtNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddResourceIdNode = (PLib3MFImplicitFunction_AddResourceIdNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addresourceidnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddResourceIdNode = (PLib3MFImplicitFunction_AddResourceIdNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addresourceidnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddResourceIdNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddAdditionNode = (PLib3MFImplicitFunction_AddAdditionNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addadditionnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddAdditionNode = (PLib3MFImplicitFunction_AddAdditionNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addadditionnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddAdditionNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddSubtractionNode = (PLib3MFImplicitFunction_AddSubtractionNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addsubtractionnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddSubtractionNode = (PLib3MFImplicitFunction_AddSubtractionNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addsubtractionnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddSubtractionNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddMultiplicationNode = (PLib3MFImplicitFunction_AddMultiplicationNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addmultiplicationnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddMultiplicationNode = (PLib3MFImplicitFunction_AddMultiplicationNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addmultiplicationnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddMultiplicationNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddDivisionNode = (PLib3MFImplicitFunction_AddDivisionNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_adddivisionnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddDivisionNode = (PLib3MFImplicitFunction_AddDivisionNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_adddivisionnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddDivisionNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddDotNode = (PLib3MFImplicitFunction_AddDotNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_adddotnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddDotNode = (PLib3MFImplicitFunction_AddDotNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_adddotnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddDotNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddCrossNode = (PLib3MFImplicitFunction_AddCrossNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addcrossnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddCrossNode = (PLib3MFImplicitFunction_AddCrossNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addcrossnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddCrossNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddMatVecMultiplicationNode = (PLib3MFImplicitFunction_AddMatVecMultiplicationNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addmatvecmultiplicationnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddMatVecMultiplicationNode = (PLib3MFImplicitFunction_AddMatVecMultiplicationNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addmatvecmultiplicationnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddMatVecMultiplicationNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddMinNode = (PLib3MFImplicitFunction_AddMinNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addminnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddMinNode = (PLib3MFImplicitFunction_AddMinNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addminnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddMinNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddMaxNode = (PLib3MFImplicitFunction_AddMaxNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addmaxnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddMaxNode = (PLib3MFImplicitFunction_AddMaxNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addmaxnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddMaxNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddFmodNode = (PLib3MFImplicitFunction_AddFmodNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addfmodnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddFmodNode = (PLib3MFImplicitFunction_AddFmodNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addfmodnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddFmodNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddPowNode = (PLib3MFImplicitFunction_AddPowNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addpownode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddPowNode = (PLib3MFImplicitFunction_AddPowNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addpownode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddPowNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddSelectNode = (PLib3MFImplicitFunction_AddSelectNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addselectnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddSelectNode = (PLib3MFImplicitFunction_AddSelectNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addselectnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddSelectNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddClampNode = (PLib3MFImplicitFunction_AddClampNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addclampnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddClampNode = (PLib3MFImplicitFunction_AddClampNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addclampnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddClampNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddComposeVectorNode = (PLib3MFImplicitFunction_AddComposeVectorNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addcomposevectornode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddComposeVectorNode = (PLib3MFImplicitFunction_AddComposeVectorNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addcomposevectornode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddComposeVectorNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddVectorFromScalarNode = (PLib3MFImplicitFunction_AddVectorFromScalarNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addvectorfromscalarnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddVectorFromScalarNode = (PLib3MFImplicitFunction_AddVectorFromScalarNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addvectorfromscalarnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddVectorFromScalarNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddDecomposeVectorNode = (PLib3MFImplicitFunction_AddDecomposeVectorNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_adddecomposevectornode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddDecomposeVectorNode = (PLib3MFImplicitFunction_AddDecomposeVectorNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_adddecomposevectornode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddDecomposeVectorNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddComposeMatrixNode = (PLib3MFImplicitFunction_AddComposeMatrixNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addcomposematrixnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddComposeMatrixNode = (PLib3MFImplicitFunction_AddComposeMatrixNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addcomposematrixnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddComposeMatrixNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddMatrixFromRowsNode = (PLib3MFImplicitFunction_AddMatrixFromRowsNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addmatrixfromrowsnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddMatrixFromRowsNode = (PLib3MFImplicitFunction_AddMatrixFromRowsNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addmatrixfromrowsnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddMatrixFromRowsNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddMatrixFromColumnsNode = (PLib3MFImplicitFunction_AddMatrixFromColumnsNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addmatrixfromcolumnsnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddMatrixFromColumnsNode = (PLib3MFImplicitFunction_AddMatrixFromColumnsNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addmatrixfromcolumnsnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddMatrixFromColumnsNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddConstantNode = (PLib3MFImplicitFunction_AddConstantNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addconstantnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddConstantNode = (PLib3MFImplicitFunction_AddConstantNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addconstantnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddConstantNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddConstVecNode = (PLib3MFImplicitFunction_AddConstVecNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addconstvecnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddConstVecNode = (PLib3MFImplicitFunction_AddConstVecNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addconstvecnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddConstVecNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddConstMatNode = (PLib3MFImplicitFunction_AddConstMatNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addconstmatnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddConstMatNode = (PLib3MFImplicitFunction_AddConstMatNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addconstmatnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddConstMatNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddMeshNode = (PLib3MFImplicitFunction_AddMeshNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addmeshnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddMeshNode = (PLib3MFImplicitFunction_AddMeshNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addmeshnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddMeshNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddUnsignedMeshNode = (PLib3MFImplicitFunction_AddUnsignedMeshNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addunsignedmeshnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddUnsignedMeshNode = (PLib3MFImplicitFunction_AddUnsignedMeshNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addunsignedmeshnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddUnsignedMeshNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddBeamLatticeNode = (PLib3MFImplicitFunction_AddBeamLatticeNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addbeamlatticenode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddBeamLatticeNode = (PLib3MFImplicitFunction_AddBeamLatticeNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addbeamlatticenode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddBeamLatticeNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddFunctionGradientNode = (PLib3MFImplicitFunction_AddFunctionGradientNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addfunctiongradientnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddFunctionGradientNode = (PLib3MFImplicitFunction_AddFunctionGradientNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addfunctiongradientnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddFunctionGradientNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddNormalizeDistanceNode = (PLib3MFImplicitFunction_AddNormalizeDistanceNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addnormalizedistancenode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddNormalizeDistanceNode = (PLib3MFImplicitFunction_AddNormalizeDistanceNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addnormalizedistancenode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddNormalizeDistanceNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddFunctionCallNode = (PLib3MFImplicitFunction_AddFunctionCallNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addfunctioncallnode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddFunctionCallNode = (PLib3MFImplicitFunction_AddFunctionCallNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_addfunctioncallnode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddFunctionCallNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_GetNodes = (PLib3MFImplicitFunction_GetNodesPtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_getnodes");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_GetNodes = (PLib3MFImplicitFunction_GetNodesPtr) dlsym(hLibrary, "lib3mf_implicitfunction_getnodes");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_GetNodes == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_RemoveNode = (PLib3MFImplicitFunction_RemoveNodePtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_removenode");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_RemoveNode = (PLib3MFImplicitFunction_RemoveNodePtr) dlsym(hLibrary, "lib3mf_implicitfunction_removenode");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_RemoveNode == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddLink = (PLib3MFImplicitFunction_AddLinkPtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addlink");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddLink = (PLib3MFImplicitFunction_AddLinkPtr) dlsym(hLibrary, "lib3mf_implicitfunction_addlink");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddLink == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_AddLinkByNames = (PLib3MFImplicitFunction_AddLinkByNamesPtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_addlinkbynames");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_AddLinkByNames = (PLib3MFImplicitFunction_AddLinkByNamesPtr) dlsym(hLibrary, "lib3mf_implicitfunction_addlinkbynames");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_AddLinkByNames == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_Clear = (PLib3MFImplicitFunction_ClearPtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_clear");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_Clear = (PLib3MFImplicitFunction_ClearPtr) dlsym(hLibrary, "lib3mf_implicitfunction_clear");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_Clear == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ImplicitFunction_SortNodesTopologically = (PLib3MFImplicitFunction_SortNodesTopologicallyPtr) GetProcAddress(hLibrary, "lib3mf_implicitfunction_sortnodestopologically");
	#else // _WIN32
	pWrapperTable->m_ImplicitFunction_SortNodesTopologically = (PLib3MFImplicitFunction_SortNodesTopologicallyPtr) dlsym(hLibrary, "lib3mf_implicitfunction_sortnodestopologically");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ImplicitFunction_SortNodesTopologically == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FunctionFromImage3D_GetImage3D = (PLib3MFFunctionFromImage3D_GetImage3DPtr) GetProcAddress(hLibrary, "lib3mf_functionfromimage3d_getimage3d");
	#else // _WIN32
	pWrapperTable->m_FunctionFromImage3D_GetImage3D = (PLib3MFFunctionFromImage3D_GetImage3DPtr) dlsym(hLibrary, "lib3mf_functionfromimage3d_getimage3d");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FunctionFromImage3D_GetImage3D == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FunctionFromImage3D_SetImage3D = (PLib3MFFunctionFromImage3D_SetImage3DPtr) GetProcAddress(hLibrary, "lib3mf_functionfromimage3d_setimage3d");
	#else // _WIN32
	pWrapperTable->m_FunctionFromImage3D_SetImage3D = (PLib3MFFunctionFromImage3D_SetImage3DPtr) dlsym(hLibrary, "lib3mf_functionfromimage3d_setimage3d");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FunctionFromImage3D_SetImage3D == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FunctionFromImage3D_SetFilter = (PLib3MFFunctionFromImage3D_SetFilterPtr) GetProcAddress(hLibrary, "lib3mf_functionfromimage3d_setfilter");
	#else // _WIN32
	pWrapperTable->m_FunctionFromImage3D_SetFilter = (PLib3MFFunctionFromImage3D_SetFilterPtr) dlsym(hLibrary, "lib3mf_functionfromimage3d_setfilter");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FunctionFromImage3D_SetFilter == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FunctionFromImage3D_GetFilter = (PLib3MFFunctionFromImage3D_GetFilterPtr) GetProcAddress(hLibrary, "lib3mf_functionfromimage3d_getfilter");
	#else // _WIN32
	pWrapperTable->m_FunctionFromImage3D_GetFilter = (PLib3MFFunctionFromImage3D_GetFilterPtr) dlsym(hLibrary, "lib3mf_functionfromimage3d_getfilter");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FunctionFromImage3D_GetFilter == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FunctionFromImage3D_SetTileStyles = (PLib3MFFunctionFromImage3D_SetTileStylesPtr) GetProcAddress(hLibrary, "lib3mf_functionfromimage3d_settilestyles");
	#else // _WIN32
	pWrapperTable->m_FunctionFromImage3D_SetTileStyles = (PLib3MFFunctionFromImage3D_SetTileStylesPtr) dlsym(hLibrary, "lib3mf_functionfromimage3d_settilestyles");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FunctionFromImage3D_SetTileStyles == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FunctionFromImage3D_GetTileStyles = (PLib3MFFunctionFromImage3D_GetTileStylesPtr) GetProcAddress(hLibrary, "lib3mf_functionfromimage3d_gettilestyles");
	#else // _WIN32
	pWrapperTable->m_FunctionFromImage3D_GetTileStyles = (PLib3MFFunctionFromImage3D_GetTileStylesPtr) dlsym(hLibrary, "lib3mf_functionfromimage3d_gettilestyles");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FunctionFromImage3D_GetTileStyles == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FunctionFromImage3D_GetOffset = (PLib3MFFunctionFromImage3D_GetOffsetPtr) GetProcAddress(hLibrary, "lib3mf_functionfromimage3d_getoffset");
	#else // _WIN32
	pWrapperTable->m_FunctionFromImage3D_GetOffset = (PLib3MFFunctionFromImage3D_GetOffsetPtr) dlsym(hLibrary, "lib3mf_functionfromimage3d_getoffset");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FunctionFromImage3D_GetOffset == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FunctionFromImage3D_SetOffset = (PLib3MFFunctionFromImage3D_SetOffsetPtr) GetProcAddress(hLibrary, "lib3mf_functionfromimage3d_setoffset");
	#else // _WIN32
	pWrapperTable->m_FunctionFromImage3D_SetOffset = (PLib3MFFunctionFromImage3D_SetOffsetPtr) dlsym(hLibrary, "lib3mf_functionfromimage3d_setoffset");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FunctionFromImage3D_SetOffset == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FunctionFromImage3D_GetScale = (PLib3MFFunctionFromImage3D_GetScalePtr) GetProcAddress(hLibrary, "lib3mf_functionfromimage3d_getscale");
	#else // _WIN32
	pWrapperTable->m_FunctionFromImage3D_GetScale = (PLib3MFFunctionFromImage3D_GetScalePtr) dlsym(hLibrary, "lib3mf_functionfromimage3d_getscale");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FunctionFromImage3D_GetScale == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FunctionFromImage3D_SetScale = (PLib3MFFunctionFromImage3D_SetScalePtr) GetProcAddress(hLibrary, "lib3mf_functionfromimage3d_setscale");
	#else // _WIN32
	pWrapperTable->m_FunctionFromImage3D_SetScale = (PLib3MFFunctionFromImage3D_SetScalePtr) dlsym(hLibrary, "lib3mf_functionfromimage3d_setscale");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FunctionFromImage3D_SetScale == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BuildItem_GetObjectResource = (PLib3MFBuildItem_GetObjectResourcePtr) GetProcAddress(hLibrary, "lib3mf_builditem_getobjectresource");
	#else // _WIN32
	pWrapperTable->m_BuildItem_GetObjectResource = (PLib3MFBuildItem_GetObjectResourcePtr) dlsym(hLibrary, "lib3mf_builditem_getobjectresource");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BuildItem_GetObjectResource == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BuildItem_GetUUID = (PLib3MFBuildItem_GetUUIDPtr) GetProcAddress(hLibrary, "lib3mf_builditem_getuuid");
	#else // _WIN32
	pWrapperTable->m_BuildItem_GetUUID = (PLib3MFBuildItem_GetUUIDPtr) dlsym(hLibrary, "lib3mf_builditem_getuuid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BuildItem_GetUUID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BuildItem_SetUUID = (PLib3MFBuildItem_SetUUIDPtr) GetProcAddress(hLibrary, "lib3mf_builditem_setuuid");
	#else // _WIN32
	pWrapperTable->m_BuildItem_SetUUID = (PLib3MFBuildItem_SetUUIDPtr) dlsym(hLibrary, "lib3mf_builditem_setuuid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BuildItem_SetUUID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BuildItem_GetObjectResourceID = (PLib3MFBuildItem_GetObjectResourceIDPtr) GetProcAddress(hLibrary, "lib3mf_builditem_getobjectresourceid");
	#else // _WIN32
	pWrapperTable->m_BuildItem_GetObjectResourceID = (PLib3MFBuildItem_GetObjectResourceIDPtr) dlsym(hLibrary, "lib3mf_builditem_getobjectresourceid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BuildItem_GetObjectResourceID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BuildItem_HasObjectTransform = (PLib3MFBuildItem_HasObjectTransformPtr) GetProcAddress(hLibrary, "lib3mf_builditem_hasobjecttransform");
	#else // _WIN32
	pWrapperTable->m_BuildItem_HasObjectTransform = (PLib3MFBuildItem_HasObjectTransformPtr) dlsym(hLibrary, "lib3mf_builditem_hasobjecttransform");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BuildItem_HasObjectTransform == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BuildItem_GetObjectTransform = (PLib3MFBuildItem_GetObjectTransformPtr) GetProcAddress(hLibrary, "lib3mf_builditem_getobjecttransform");
	#else // _WIN32
	pWrapperTable->m_BuildItem_GetObjectTransform = (PLib3MFBuildItem_GetObjectTransformPtr) dlsym(hLibrary, "lib3mf_builditem_getobjecttransform");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BuildItem_GetObjectTransform == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BuildItem_SetObjectTransform = (PLib3MFBuildItem_SetObjectTransformPtr) GetProcAddress(hLibrary, "lib3mf_builditem_setobjecttransform");
	#else // _WIN32
	pWrapperTable->m_BuildItem_SetObjectTransform = (PLib3MFBuildItem_SetObjectTransformPtr) dlsym(hLibrary, "lib3mf_builditem_setobjecttransform");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BuildItem_SetObjectTransform == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BuildItem_GetPartNumber = (PLib3MFBuildItem_GetPartNumberPtr) GetProcAddress(hLibrary, "lib3mf_builditem_getpartnumber");
	#else // _WIN32
	pWrapperTable->m_BuildItem_GetPartNumber = (PLib3MFBuildItem_GetPartNumberPtr) dlsym(hLibrary, "lib3mf_builditem_getpartnumber");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BuildItem_GetPartNumber == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BuildItem_SetPartNumber = (PLib3MFBuildItem_SetPartNumberPtr) GetProcAddress(hLibrary, "lib3mf_builditem_setpartnumber");
	#else // _WIN32
	pWrapperTable->m_BuildItem_SetPartNumber = (PLib3MFBuildItem_SetPartNumberPtr) dlsym(hLibrary, "lib3mf_builditem_setpartnumber");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BuildItem_SetPartNumber == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BuildItem_GetMetaDataGroup = (PLib3MFBuildItem_GetMetaDataGroupPtr) GetProcAddress(hLibrary, "lib3mf_builditem_getmetadatagroup");
	#else // _WIN32
	pWrapperTable->m_BuildItem_GetMetaDataGroup = (PLib3MFBuildItem_GetMetaDataGroupPtr) dlsym(hLibrary, "lib3mf_builditem_getmetadatagroup");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BuildItem_GetMetaDataGroup == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BuildItem_GetOutbox = (PLib3MFBuildItem_GetOutboxPtr) GetProcAddress(hLibrary, "lib3mf_builditem_getoutbox");
	#else // _WIN32
	pWrapperTable->m_BuildItem_GetOutbox = (PLib3MFBuildItem_GetOutboxPtr) dlsym(hLibrary, "lib3mf_builditem_getoutbox");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BuildItem_GetOutbox == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BuildItemIterator_MoveNext = (PLib3MFBuildItemIterator_MoveNextPtr) GetProcAddress(hLibrary, "lib3mf_builditemiterator_movenext");
	#else // _WIN32
	pWrapperTable->m_BuildItemIterator_MoveNext = (PLib3MFBuildItemIterator_MoveNextPtr) dlsym(hLibrary, "lib3mf_builditemiterator_movenext");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BuildItemIterator_MoveNext == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BuildItemIterator_MovePrevious = (PLib3MFBuildItemIterator_MovePreviousPtr) GetProcAddress(hLibrary, "lib3mf_builditemiterator_moveprevious");
	#else // _WIN32
	pWrapperTable->m_BuildItemIterator_MovePrevious = (PLib3MFBuildItemIterator_MovePreviousPtr) dlsym(hLibrary, "lib3mf_builditemiterator_moveprevious");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BuildItemIterator_MovePrevious == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BuildItemIterator_GetCurrent = (PLib3MFBuildItemIterator_GetCurrentPtr) GetProcAddress(hLibrary, "lib3mf_builditemiterator_getcurrent");
	#else // _WIN32
	pWrapperTable->m_BuildItemIterator_GetCurrent = (PLib3MFBuildItemIterator_GetCurrentPtr) dlsym(hLibrary, "lib3mf_builditemiterator_getcurrent");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BuildItemIterator_GetCurrent == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BuildItemIterator_Clone = (PLib3MFBuildItemIterator_ClonePtr) GetProcAddress(hLibrary, "lib3mf_builditemiterator_clone");
	#else // _WIN32
	pWrapperTable->m_BuildItemIterator_Clone = (PLib3MFBuildItemIterator_ClonePtr) dlsym(hLibrary, "lib3mf_builditemiterator_clone");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BuildItemIterator_Clone == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BuildItemIterator_Count = (PLib3MFBuildItemIterator_CountPtr) GetProcAddress(hLibrary, "lib3mf_builditemiterator_count");
	#else // _WIN32
	pWrapperTable->m_BuildItemIterator_Count = (PLib3MFBuildItemIterator_CountPtr) dlsym(hLibrary, "lib3mf_builditemiterator_count");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BuildItemIterator_Count == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Slice_SetVertices = (PLib3MFSlice_SetVerticesPtr) GetProcAddress(hLibrary, "lib3mf_slice_setvertices");
	#else // _WIN32
	pWrapperTable->m_Slice_SetVertices = (PLib3MFSlice_SetVerticesPtr) dlsym(hLibrary, "lib3mf_slice_setvertices");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Slice_SetVertices == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Slice_GetVertices = (PLib3MFSlice_GetVerticesPtr) GetProcAddress(hLibrary, "lib3mf_slice_getvertices");
	#else // _WIN32
	pWrapperTable->m_Slice_GetVertices = (PLib3MFSlice_GetVerticesPtr) dlsym(hLibrary, "lib3mf_slice_getvertices");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Slice_GetVertices == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Slice_GetVertexCount = (PLib3MFSlice_GetVertexCountPtr) GetProcAddress(hLibrary, "lib3mf_slice_getvertexcount");
	#else // _WIN32
	pWrapperTable->m_Slice_GetVertexCount = (PLib3MFSlice_GetVertexCountPtr) dlsym(hLibrary, "lib3mf_slice_getvertexcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Slice_GetVertexCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Slice_AddPolygon = (PLib3MFSlice_AddPolygonPtr) GetProcAddress(hLibrary, "lib3mf_slice_addpolygon");
	#else // _WIN32
	pWrapperTable->m_Slice_AddPolygon = (PLib3MFSlice_AddPolygonPtr) dlsym(hLibrary, "lib3mf_slice_addpolygon");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Slice_AddPolygon == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Slice_GetPolygonCount = (PLib3MFSlice_GetPolygonCountPtr) GetProcAddress(hLibrary, "lib3mf_slice_getpolygoncount");
	#else // _WIN32
	pWrapperTable->m_Slice_GetPolygonCount = (PLib3MFSlice_GetPolygonCountPtr) dlsym(hLibrary, "lib3mf_slice_getpolygoncount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Slice_GetPolygonCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Slice_SetPolygonIndices = (PLib3MFSlice_SetPolygonIndicesPtr) GetProcAddress(hLibrary, "lib3mf_slice_setpolygonindices");
	#else // _WIN32
	pWrapperTable->m_Slice_SetPolygonIndices = (PLib3MFSlice_SetPolygonIndicesPtr) dlsym(hLibrary, "lib3mf_slice_setpolygonindices");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Slice_SetPolygonIndices == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Slice_GetPolygonIndices = (PLib3MFSlice_GetPolygonIndicesPtr) GetProcAddress(hLibrary, "lib3mf_slice_getpolygonindices");
	#else // _WIN32
	pWrapperTable->m_Slice_GetPolygonIndices = (PLib3MFSlice_GetPolygonIndicesPtr) dlsym(hLibrary, "lib3mf_slice_getpolygonindices");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Slice_GetPolygonIndices == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Slice_GetPolygonIndexCount = (PLib3MFSlice_GetPolygonIndexCountPtr) GetProcAddress(hLibrary, "lib3mf_slice_getpolygonindexcount");
	#else // _WIN32
	pWrapperTable->m_Slice_GetPolygonIndexCount = (PLib3MFSlice_GetPolygonIndexCountPtr) dlsym(hLibrary, "lib3mf_slice_getpolygonindexcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Slice_GetPolygonIndexCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Slice_GetZTop = (PLib3MFSlice_GetZTopPtr) GetProcAddress(hLibrary, "lib3mf_slice_getztop");
	#else // _WIN32
	pWrapperTable->m_Slice_GetZTop = (PLib3MFSlice_GetZTopPtr) dlsym(hLibrary, "lib3mf_slice_getztop");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Slice_GetZTop == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_SliceStack_GetBottomZ = (PLib3MFSliceStack_GetBottomZPtr) GetProcAddress(hLibrary, "lib3mf_slicestack_getbottomz");
	#else // _WIN32
	pWrapperTable->m_SliceStack_GetBottomZ = (PLib3MFSliceStack_GetBottomZPtr) dlsym(hLibrary, "lib3mf_slicestack_getbottomz");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_SliceStack_GetBottomZ == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_SliceStack_GetSliceCount = (PLib3MFSliceStack_GetSliceCountPtr) GetProcAddress(hLibrary, "lib3mf_slicestack_getslicecount");
	#else // _WIN32
	pWrapperTable->m_SliceStack_GetSliceCount = (PLib3MFSliceStack_GetSliceCountPtr) dlsym(hLibrary, "lib3mf_slicestack_getslicecount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_SliceStack_GetSliceCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_SliceStack_GetSlice = (PLib3MFSliceStack_GetSlicePtr) GetProcAddress(hLibrary, "lib3mf_slicestack_getslice");
	#else // _WIN32
	pWrapperTable->m_SliceStack_GetSlice = (PLib3MFSliceStack_GetSlicePtr) dlsym(hLibrary, "lib3mf_slicestack_getslice");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_SliceStack_GetSlice == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_SliceStack_AddSlice = (PLib3MFSliceStack_AddSlicePtr) GetProcAddress(hLibrary, "lib3mf_slicestack_addslice");
	#else // _WIN32
	pWrapperTable->m_SliceStack_AddSlice = (PLib3MFSliceStack_AddSlicePtr) dlsym(hLibrary, "lib3mf_slicestack_addslice");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_SliceStack_AddSlice == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_SliceStack_GetSliceRefCount = (PLib3MFSliceStack_GetSliceRefCountPtr) GetProcAddress(hLibrary, "lib3mf_slicestack_getslicerefcount");
	#else // _WIN32
	pWrapperTable->m_SliceStack_GetSliceRefCount = (PLib3MFSliceStack_GetSliceRefCountPtr) dlsym(hLibrary, "lib3mf_slicestack_getslicerefcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_SliceStack_GetSliceRefCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_SliceStack_AddSliceStackReference = (PLib3MFSliceStack_AddSliceStackReferencePtr) GetProcAddress(hLibrary, "lib3mf_slicestack_addslicestackreference");
	#else // _WIN32
	pWrapperTable->m_SliceStack_AddSliceStackReference = (PLib3MFSliceStack_AddSliceStackReferencePtr) dlsym(hLibrary, "lib3mf_slicestack_addslicestackreference");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_SliceStack_AddSliceStackReference == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_SliceStack_GetSliceStackReference = (PLib3MFSliceStack_GetSliceStackReferencePtr) GetProcAddress(hLibrary, "lib3mf_slicestack_getslicestackreference");
	#else // _WIN32
	pWrapperTable->m_SliceStack_GetSliceStackReference = (PLib3MFSliceStack_GetSliceStackReferencePtr) dlsym(hLibrary, "lib3mf_slicestack_getslicestackreference");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_SliceStack_GetSliceStackReference == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_SliceStack_CollapseSliceReferences = (PLib3MFSliceStack_CollapseSliceReferencesPtr) GetProcAddress(hLibrary, "lib3mf_slicestack_collapseslicereferences");
	#else // _WIN32
	pWrapperTable->m_SliceStack_CollapseSliceReferences = (PLib3MFSliceStack_CollapseSliceReferencesPtr) dlsym(hLibrary, "lib3mf_slicestack_collapseslicereferences");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_SliceStack_CollapseSliceReferences == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_SliceStack_SetOwnPath = (PLib3MFSliceStack_SetOwnPathPtr) GetProcAddress(hLibrary, "lib3mf_slicestack_setownpath");
	#else // _WIN32
	pWrapperTable->m_SliceStack_SetOwnPath = (PLib3MFSliceStack_SetOwnPathPtr) dlsym(hLibrary, "lib3mf_slicestack_setownpath");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_SliceStack_SetOwnPath == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_SliceStack_GetOwnPath = (PLib3MFSliceStack_GetOwnPathPtr) GetProcAddress(hLibrary, "lib3mf_slicestack_getownpath");
	#else // _WIN32
	pWrapperTable->m_SliceStack_GetOwnPath = (PLib3MFSliceStack_GetOwnPathPtr) dlsym(hLibrary, "lib3mf_slicestack_getownpath");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_SliceStack_GetOwnPath == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Consumer_GetConsumerID = (PLib3MFConsumer_GetConsumerIDPtr) GetProcAddress(hLibrary, "lib3mf_consumer_getconsumerid");
	#else // _WIN32
	pWrapperTable->m_Consumer_GetConsumerID = (PLib3MFConsumer_GetConsumerIDPtr) dlsym(hLibrary, "lib3mf_consumer_getconsumerid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Consumer_GetConsumerID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Consumer_GetKeyID = (PLib3MFConsumer_GetKeyIDPtr) GetProcAddress(hLibrary, "lib3mf_consumer_getkeyid");
	#else // _WIN32
	pWrapperTable->m_Consumer_GetKeyID = (PLib3MFConsumer_GetKeyIDPtr) dlsym(hLibrary, "lib3mf_consumer_getkeyid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Consumer_GetKeyID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Consumer_GetKeyValue = (PLib3MFConsumer_GetKeyValuePtr) GetProcAddress(hLibrary, "lib3mf_consumer_getkeyvalue");
	#else // _WIN32
	pWrapperTable->m_Consumer_GetKeyValue = (PLib3MFConsumer_GetKeyValuePtr) dlsym(hLibrary, "lib3mf_consumer_getkeyvalue");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Consumer_GetKeyValue == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_AccessRight_GetConsumer = (PLib3MFAccessRight_GetConsumerPtr) GetProcAddress(hLibrary, "lib3mf_accessright_getconsumer");
	#else // _WIN32
	pWrapperTable->m_AccessRight_GetConsumer = (PLib3MFAccessRight_GetConsumerPtr) dlsym(hLibrary, "lib3mf_accessright_getconsumer");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_AccessRight_GetConsumer == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_AccessRight_GetWrappingAlgorithm = (PLib3MFAccessRight_GetWrappingAlgorithmPtr) GetProcAddress(hLibrary, "lib3mf_accessright_getwrappingalgorithm");
	#else // _WIN32
	pWrapperTable->m_AccessRight_GetWrappingAlgorithm = (PLib3MFAccessRight_GetWrappingAlgorithmPtr) dlsym(hLibrary, "lib3mf_accessright_getwrappingalgorithm");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_AccessRight_GetWrappingAlgorithm == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_AccessRight_GetMgfAlgorithm = (PLib3MFAccessRight_GetMgfAlgorithmPtr) GetProcAddress(hLibrary, "lib3mf_accessright_getmgfalgorithm");
	#else // _WIN32
	pWrapperTable->m_AccessRight_GetMgfAlgorithm = (PLib3MFAccessRight_GetMgfAlgorithmPtr) dlsym(hLibrary, "lib3mf_accessright_getmgfalgorithm");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_AccessRight_GetMgfAlgorithm == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_AccessRight_GetDigestMethod = (PLib3MFAccessRight_GetDigestMethodPtr) GetProcAddress(hLibrary, "lib3mf_accessright_getdigestmethod");
	#else // _WIN32
	pWrapperTable->m_AccessRight_GetDigestMethod = (PLib3MFAccessRight_GetDigestMethodPtr) dlsym(hLibrary, "lib3mf_accessright_getdigestmethod");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_AccessRight_GetDigestMethod == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ContentEncryptionParams_GetEncryptionAlgorithm = (PLib3MFContentEncryptionParams_GetEncryptionAlgorithmPtr) GetProcAddress(hLibrary, "lib3mf_contentencryptionparams_getencryptionalgorithm");
	#else // _WIN32
	pWrapperTable->m_ContentEncryptionParams_GetEncryptionAlgorithm = (PLib3MFContentEncryptionParams_GetEncryptionAlgorithmPtr) dlsym(hLibrary, "lib3mf_contentencryptionparams_getencryptionalgorithm");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ContentEncryptionParams_GetEncryptionAlgorithm == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ContentEncryptionParams_GetKey = (PLib3MFContentEncryptionParams_GetKeyPtr) GetProcAddress(hLibrary, "lib3mf_contentencryptionparams_getkey");
	#else // _WIN32
	pWrapperTable->m_ContentEncryptionParams_GetKey = (PLib3MFContentEncryptionParams_GetKeyPtr) dlsym(hLibrary, "lib3mf_contentencryptionparams_getkey");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ContentEncryptionParams_GetKey == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ContentEncryptionParams_GetInitializationVector = (PLib3MFContentEncryptionParams_GetInitializationVectorPtr) GetProcAddress(hLibrary, "lib3mf_contentencryptionparams_getinitializationvector");
	#else // _WIN32
	pWrapperTable->m_ContentEncryptionParams_GetInitializationVector = (PLib3MFContentEncryptionParams_GetInitializationVectorPtr) dlsym(hLibrary, "lib3mf_contentencryptionparams_getinitializationvector");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ContentEncryptionParams_GetInitializationVector == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ContentEncryptionParams_GetAuthenticationTag = (PLib3MFContentEncryptionParams_GetAuthenticationTagPtr) GetProcAddress(hLibrary, "lib3mf_contentencryptionparams_getauthenticationtag");
	#else // _WIN32
	pWrapperTable->m_ContentEncryptionParams_GetAuthenticationTag = (PLib3MFContentEncryptionParams_GetAuthenticationTagPtr) dlsym(hLibrary, "lib3mf_contentencryptionparams_getauthenticationtag");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ContentEncryptionParams_GetAuthenticationTag == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ContentEncryptionParams_SetAuthenticationTag = (PLib3MFContentEncryptionParams_SetAuthenticationTagPtr) GetProcAddress(hLibrary, "lib3mf_contentencryptionparams_setauthenticationtag");
	#else // _WIN32
	pWrapperTable->m_ContentEncryptionParams_SetAuthenticationTag = (PLib3MFContentEncryptionParams_SetAuthenticationTagPtr) dlsym(hLibrary, "lib3mf_contentencryptionparams_setauthenticationtag");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ContentEncryptionParams_SetAuthenticationTag == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ContentEncryptionParams_GetAdditionalAuthenticationData = (PLib3MFContentEncryptionParams_GetAdditionalAuthenticationDataPtr) GetProcAddress(hLibrary, "lib3mf_contentencryptionparams_getadditionalauthenticationdata");
	#else // _WIN32
	pWrapperTable->m_ContentEncryptionParams_GetAdditionalAuthenticationData = (PLib3MFContentEncryptionParams_GetAdditionalAuthenticationDataPtr) dlsym(hLibrary, "lib3mf_contentencryptionparams_getadditionalauthenticationdata");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ContentEncryptionParams_GetAdditionalAuthenticationData == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ContentEncryptionParams_GetDescriptor = (PLib3MFContentEncryptionParams_GetDescriptorPtr) GetProcAddress(hLibrary, "lib3mf_contentencryptionparams_getdescriptor");
	#else // _WIN32
	pWrapperTable->m_ContentEncryptionParams_GetDescriptor = (PLib3MFContentEncryptionParams_GetDescriptorPtr) dlsym(hLibrary, "lib3mf_contentencryptionparams_getdescriptor");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ContentEncryptionParams_GetDescriptor == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ContentEncryptionParams_GetKeyUUID = (PLib3MFContentEncryptionParams_GetKeyUUIDPtr) GetProcAddress(hLibrary, "lib3mf_contentencryptionparams_getkeyuuid");
	#else // _WIN32
	pWrapperTable->m_ContentEncryptionParams_GetKeyUUID = (PLib3MFContentEncryptionParams_GetKeyUUIDPtr) dlsym(hLibrary, "lib3mf_contentencryptionparams_getkeyuuid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ContentEncryptionParams_GetKeyUUID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ResourceData_GetPath = (PLib3MFResourceData_GetPathPtr) GetProcAddress(hLibrary, "lib3mf_resourcedata_getpath");
	#else // _WIN32
	pWrapperTable->m_ResourceData_GetPath = (PLib3MFResourceData_GetPathPtr) dlsym(hLibrary, "lib3mf_resourcedata_getpath");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ResourceData_GetPath == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ResourceData_GetEncryptionAlgorithm = (PLib3MFResourceData_GetEncryptionAlgorithmPtr) GetProcAddress(hLibrary, "lib3mf_resourcedata_getencryptionalgorithm");
	#else // _WIN32
	pWrapperTable->m_ResourceData_GetEncryptionAlgorithm = (PLib3MFResourceData_GetEncryptionAlgorithmPtr) dlsym(hLibrary, "lib3mf_resourcedata_getencryptionalgorithm");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ResourceData_GetEncryptionAlgorithm == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ResourceData_GetCompression = (PLib3MFResourceData_GetCompressionPtr) GetProcAddress(hLibrary, "lib3mf_resourcedata_getcompression");
	#else // _WIN32
	pWrapperTable->m_ResourceData_GetCompression = (PLib3MFResourceData_GetCompressionPtr) dlsym(hLibrary, "lib3mf_resourcedata_getcompression");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ResourceData_GetCompression == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ResourceData_GetAdditionalAuthenticationData = (PLib3MFResourceData_GetAdditionalAuthenticationDataPtr) GetProcAddress(hLibrary, "lib3mf_resourcedata_getadditionalauthenticationdata");
	#else // _WIN32
	pWrapperTable->m_ResourceData_GetAdditionalAuthenticationData = (PLib3MFResourceData_GetAdditionalAuthenticationDataPtr) dlsym(hLibrary, "lib3mf_resourcedata_getadditionalauthenticationdata");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ResourceData_GetAdditionalAuthenticationData == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ResourceDataGroup_GetKeyUUID = (PLib3MFResourceDataGroup_GetKeyUUIDPtr) GetProcAddress(hLibrary, "lib3mf_resourcedatagroup_getkeyuuid");
	#else // _WIN32
	pWrapperTable->m_ResourceDataGroup_GetKeyUUID = (PLib3MFResourceDataGroup_GetKeyUUIDPtr) dlsym(hLibrary, "lib3mf_resourcedatagroup_getkeyuuid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ResourceDataGroup_GetKeyUUID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ResourceDataGroup_AddAccessRight = (PLib3MFResourceDataGroup_AddAccessRightPtr) GetProcAddress(hLibrary, "lib3mf_resourcedatagroup_addaccessright");
	#else // _WIN32
	pWrapperTable->m_ResourceDataGroup_AddAccessRight = (PLib3MFResourceDataGroup_AddAccessRightPtr) dlsym(hLibrary, "lib3mf_resourcedatagroup_addaccessright");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ResourceDataGroup_AddAccessRight == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ResourceDataGroup_FindAccessRightByConsumer = (PLib3MFResourceDataGroup_FindAccessRightByConsumerPtr) GetProcAddress(hLibrary, "lib3mf_resourcedatagroup_findaccessrightbyconsumer");
	#else // _WIN32
	pWrapperTable->m_ResourceDataGroup_FindAccessRightByConsumer = (PLib3MFResourceDataGroup_FindAccessRightByConsumerPtr) dlsym(hLibrary, "lib3mf_resourcedatagroup_findaccessrightbyconsumer");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ResourceDataGroup_FindAccessRightByConsumer == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ResourceDataGroup_RemoveAccessRight = (PLib3MFResourceDataGroup_RemoveAccessRightPtr) GetProcAddress(hLibrary, "lib3mf_resourcedatagroup_removeaccessright");
	#else // _WIN32
	pWrapperTable->m_ResourceDataGroup_RemoveAccessRight = (PLib3MFResourceDataGroup_RemoveAccessRightPtr) dlsym(hLibrary, "lib3mf_resourcedatagroup_removeaccessright");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ResourceDataGroup_RemoveAccessRight == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_KeyStore_AddConsumer = (PLib3MFKeyStore_AddConsumerPtr) GetProcAddress(hLibrary, "lib3mf_keystore_addconsumer");
	#else // _WIN32
	pWrapperTable->m_KeyStore_AddConsumer = (PLib3MFKeyStore_AddConsumerPtr) dlsym(hLibrary, "lib3mf_keystore_addconsumer");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_KeyStore_AddConsumer == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_KeyStore_GetConsumerCount = (PLib3MFKeyStore_GetConsumerCountPtr) GetProcAddress(hLibrary, "lib3mf_keystore_getconsumercount");
	#else // _WIN32
	pWrapperTable->m_KeyStore_GetConsumerCount = (PLib3MFKeyStore_GetConsumerCountPtr) dlsym(hLibrary, "lib3mf_keystore_getconsumercount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_KeyStore_GetConsumerCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_KeyStore_GetConsumer = (PLib3MFKeyStore_GetConsumerPtr) GetProcAddress(hLibrary, "lib3mf_keystore_getconsumer");
	#else // _WIN32
	pWrapperTable->m_KeyStore_GetConsumer = (PLib3MFKeyStore_GetConsumerPtr) dlsym(hLibrary, "lib3mf_keystore_getconsumer");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_KeyStore_GetConsumer == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_KeyStore_RemoveConsumer = (PLib3MFKeyStore_RemoveConsumerPtr) GetProcAddress(hLibrary, "lib3mf_keystore_removeconsumer");
	#else // _WIN32
	pWrapperTable->m_KeyStore_RemoveConsumer = (PLib3MFKeyStore_RemoveConsumerPtr) dlsym(hLibrary, "lib3mf_keystore_removeconsumer");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_KeyStore_RemoveConsumer == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_KeyStore_FindConsumer = (PLib3MFKeyStore_FindConsumerPtr) GetProcAddress(hLibrary, "lib3mf_keystore_findconsumer");
	#else // _WIN32
	pWrapperTable->m_KeyStore_FindConsumer = (PLib3MFKeyStore_FindConsumerPtr) dlsym(hLibrary, "lib3mf_keystore_findconsumer");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_KeyStore_FindConsumer == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_KeyStore_GetResourceDataGroupCount = (PLib3MFKeyStore_GetResourceDataGroupCountPtr) GetProcAddress(hLibrary, "lib3mf_keystore_getresourcedatagroupcount");
	#else // _WIN32
	pWrapperTable->m_KeyStore_GetResourceDataGroupCount = (PLib3MFKeyStore_GetResourceDataGroupCountPtr) dlsym(hLibrary, "lib3mf_keystore_getresourcedatagroupcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_KeyStore_GetResourceDataGroupCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_KeyStore_AddResourceDataGroup = (PLib3MFKeyStore_AddResourceDataGroupPtr) GetProcAddress(hLibrary, "lib3mf_keystore_addresourcedatagroup");
	#else // _WIN32
	pWrapperTable->m_KeyStore_AddResourceDataGroup = (PLib3MFKeyStore_AddResourceDataGroupPtr) dlsym(hLibrary, "lib3mf_keystore_addresourcedatagroup");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_KeyStore_AddResourceDataGroup == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_KeyStore_GetResourceDataGroup = (PLib3MFKeyStore_GetResourceDataGroupPtr) GetProcAddress(hLibrary, "lib3mf_keystore_getresourcedatagroup");
	#else // _WIN32
	pWrapperTable->m_KeyStore_GetResourceDataGroup = (PLib3MFKeyStore_GetResourceDataGroupPtr) dlsym(hLibrary, "lib3mf_keystore_getresourcedatagroup");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_KeyStore_GetResourceDataGroup == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_KeyStore_RemoveResourceDataGroup = (PLib3MFKeyStore_RemoveResourceDataGroupPtr) GetProcAddress(hLibrary, "lib3mf_keystore_removeresourcedatagroup");
	#else // _WIN32
	pWrapperTable->m_KeyStore_RemoveResourceDataGroup = (PLib3MFKeyStore_RemoveResourceDataGroupPtr) dlsym(hLibrary, "lib3mf_keystore_removeresourcedatagroup");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_KeyStore_RemoveResourceDataGroup == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_KeyStore_FindResourceDataGroup = (PLib3MFKeyStore_FindResourceDataGroupPtr) GetProcAddress(hLibrary, "lib3mf_keystore_findresourcedatagroup");
	#else // _WIN32
	pWrapperTable->m_KeyStore_FindResourceDataGroup = (PLib3MFKeyStore_FindResourceDataGroupPtr) dlsym(hLibrary, "lib3mf_keystore_findresourcedatagroup");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_KeyStore_FindResourceDataGroup == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_KeyStore_AddResourceData = (PLib3MFKeyStore_AddResourceDataPtr) GetProcAddress(hLibrary, "lib3mf_keystore_addresourcedata");
	#else // _WIN32
	pWrapperTable->m_KeyStore_AddResourceData = (PLib3MFKeyStore_AddResourceDataPtr) dlsym(hLibrary, "lib3mf_keystore_addresourcedata");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_KeyStore_AddResourceData == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_KeyStore_RemoveResourceData = (PLib3MFKeyStore_RemoveResourceDataPtr) GetProcAddress(hLibrary, "lib3mf_keystore_removeresourcedata");
	#else // _WIN32
	pWrapperTable->m_KeyStore_RemoveResourceData = (PLib3MFKeyStore_RemoveResourceDataPtr) dlsym(hLibrary, "lib3mf_keystore_removeresourcedata");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_KeyStore_RemoveResourceData == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_KeyStore_FindResourceData = (PLib3MFKeyStore_FindResourceDataPtr) GetProcAddress(hLibrary, "lib3mf_keystore_findresourcedata");
	#else // _WIN32
	pWrapperTable->m_KeyStore_FindResourceData = (PLib3MFKeyStore_FindResourceDataPtr) dlsym(hLibrary, "lib3mf_keystore_findresourcedata");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_KeyStore_FindResourceData == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_KeyStore_GetResourceDataCount = (PLib3MFKeyStore_GetResourceDataCountPtr) GetProcAddress(hLibrary, "lib3mf_keystore_getresourcedatacount");
	#else // _WIN32
	pWrapperTable->m_KeyStore_GetResourceDataCount = (PLib3MFKeyStore_GetResourceDataCountPtr) dlsym(hLibrary, "lib3mf_keystore_getresourcedatacount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_KeyStore_GetResourceDataCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_KeyStore_GetResourceData = (PLib3MFKeyStore_GetResourceDataPtr) GetProcAddress(hLibrary, "lib3mf_keystore_getresourcedata");
	#else // _WIN32
	pWrapperTable->m_KeyStore_GetResourceData = (PLib3MFKeyStore_GetResourceDataPtr) dlsym(hLibrary, "lib3mf_keystore_getresourcedata");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_KeyStore_GetResourceData == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_KeyStore_GetUUID = (PLib3MFKeyStore_GetUUIDPtr) GetProcAddress(hLibrary, "lib3mf_keystore_getuuid");
	#else // _WIN32
	pWrapperTable->m_KeyStore_GetUUID = (PLib3MFKeyStore_GetUUIDPtr) dlsym(hLibrary, "lib3mf_keystore_getuuid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_KeyStore_GetUUID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_KeyStore_SetUUID = (PLib3MFKeyStore_SetUUIDPtr) GetProcAddress(hLibrary, "lib3mf_keystore_setuuid");
	#else // _WIN32
	pWrapperTable->m_KeyStore_SetUUID = (PLib3MFKeyStore_SetUUIDPtr) dlsym(hLibrary, "lib3mf_keystore_setuuid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_KeyStore_SetUUID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_RootModelPart = (PLib3MFModel_RootModelPartPtr) GetProcAddress(hLibrary, "lib3mf_model_rootmodelpart");
	#else // _WIN32
	pWrapperTable->m_Model_RootModelPart = (PLib3MFModel_RootModelPartPtr) dlsym(hLibrary, "lib3mf_model_rootmodelpart");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_RootModelPart == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_FindOrCreatePackagePart = (PLib3MFModel_FindOrCreatePackagePartPtr) GetProcAddress(hLibrary, "lib3mf_model_findorcreatepackagepart");
	#else // _WIN32
	pWrapperTable->m_Model_FindOrCreatePackagePart = (PLib3MFModel_FindOrCreatePackagePartPtr) dlsym(hLibrary, "lib3mf_model_findorcreatepackagepart");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_FindOrCreatePackagePart == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_SetUnit = (PLib3MFModel_SetUnitPtr) GetProcAddress(hLibrary, "lib3mf_model_setunit");
	#else // _WIN32
	pWrapperTable->m_Model_SetUnit = (PLib3MFModel_SetUnitPtr) dlsym(hLibrary, "lib3mf_model_setunit");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_SetUnit == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetUnit = (PLib3MFModel_GetUnitPtr) GetProcAddress(hLibrary, "lib3mf_model_getunit");
	#else // _WIN32
	pWrapperTable->m_Model_GetUnit = (PLib3MFModel_GetUnitPtr) dlsym(hLibrary, "lib3mf_model_getunit");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetUnit == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetLanguage = (PLib3MFModel_GetLanguagePtr) GetProcAddress(hLibrary, "lib3mf_model_getlanguage");
	#else // _WIN32
	pWrapperTable->m_Model_GetLanguage = (PLib3MFModel_GetLanguagePtr) dlsym(hLibrary, "lib3mf_model_getlanguage");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetLanguage == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_SetLanguage = (PLib3MFModel_SetLanguagePtr) GetProcAddress(hLibrary, "lib3mf_model_setlanguage");
	#else // _WIN32
	pWrapperTable->m_Model_SetLanguage = (PLib3MFModel_SetLanguagePtr) dlsym(hLibrary, "lib3mf_model_setlanguage");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_SetLanguage == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_QueryWriter = (PLib3MFModel_QueryWriterPtr) GetProcAddress(hLibrary, "lib3mf_model_querywriter");
	#else // _WIN32
	pWrapperTable->m_Model_QueryWriter = (PLib3MFModel_QueryWriterPtr) dlsym(hLibrary, "lib3mf_model_querywriter");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_QueryWriter == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_QueryReader = (PLib3MFModel_QueryReaderPtr) GetProcAddress(hLibrary, "lib3mf_model_queryreader");
	#else // _WIN32
	pWrapperTable->m_Model_QueryReader = (PLib3MFModel_QueryReaderPtr) dlsym(hLibrary, "lib3mf_model_queryreader");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_QueryReader == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetResourceByID = (PLib3MFModel_GetResourceByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_getresourcebyid");
	#else // _WIN32
	pWrapperTable->m_Model_GetResourceByID = (PLib3MFModel_GetResourceByIDPtr) dlsym(hLibrary, "lib3mf_model_getresourcebyid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetResourceByID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetTexture2DByID = (PLib3MFModel_GetTexture2DByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_gettexture2dbyid");
	#else // _WIN32
	pWrapperTable->m_Model_GetTexture2DByID = (PLib3MFModel_GetTexture2DByIDPtr) dlsym(hLibrary, "lib3mf_model_gettexture2dbyid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetTexture2DByID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetPropertyTypeByID = (PLib3MFModel_GetPropertyTypeByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_getpropertytypebyid");
	#else // _WIN32
	pWrapperTable->m_Model_GetPropertyTypeByID = (PLib3MFModel_GetPropertyTypeByIDPtr) dlsym(hLibrary, "lib3mf_model_getpropertytypebyid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetPropertyTypeByID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetBaseMaterialGroupByID = (PLib3MFModel_GetBaseMaterialGroupByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_getbasematerialgroupbyid");
	#else // _WIN32
	pWrapperTable->m_Model_GetBaseMaterialGroupByID = (PLib3MFModel_GetBaseMaterialGroupByIDPtr) dlsym(hLibrary, "lib3mf_model_getbasematerialgroupbyid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetBaseMaterialGroupByID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetTexture2DGroupByID = (PLib3MFModel_GetTexture2DGroupByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_gettexture2dgroupbyid");
	#else // _WIN32
	pWrapperTable->m_Model_GetTexture2DGroupByID = (PLib3MFModel_GetTexture2DGroupByIDPtr) dlsym(hLibrary, "lib3mf_model_gettexture2dgroupbyid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetTexture2DGroupByID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetCompositeMaterialsByID = (PLib3MFModel_GetCompositeMaterialsByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_getcompositematerialsbyid");
	#else // _WIN32
	pWrapperTable->m_Model_GetCompositeMaterialsByID = (PLib3MFModel_GetCompositeMaterialsByIDPtr) dlsym(hLibrary, "lib3mf_model_getcompositematerialsbyid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetCompositeMaterialsByID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetMultiPropertyGroupByID = (PLib3MFModel_GetMultiPropertyGroupByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_getmultipropertygroupbyid");
	#else // _WIN32
	pWrapperTable->m_Model_GetMultiPropertyGroupByID = (PLib3MFModel_GetMultiPropertyGroupByIDPtr) dlsym(hLibrary, "lib3mf_model_getmultipropertygroupbyid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetMultiPropertyGroupByID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetMeshObjectByID = (PLib3MFModel_GetMeshObjectByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_getmeshobjectbyid");
	#else // _WIN32
	pWrapperTable->m_Model_GetMeshObjectByID = (PLib3MFModel_GetMeshObjectByIDPtr) dlsym(hLibrary, "lib3mf_model_getmeshobjectbyid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetMeshObjectByID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetComponentsObjectByID = (PLib3MFModel_GetComponentsObjectByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_getcomponentsobjectbyid");
	#else // _WIN32
	pWrapperTable->m_Model_GetComponentsObjectByID = (PLib3MFModel_GetComponentsObjectByIDPtr) dlsym(hLibrary, "lib3mf_model_getcomponentsobjectbyid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetComponentsObjectByID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetColorGroupByID = (PLib3MFModel_GetColorGroupByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_getcolorgroupbyid");
	#else // _WIN32
	pWrapperTable->m_Model_GetColorGroupByID = (PLib3MFModel_GetColorGroupByIDPtr) dlsym(hLibrary, "lib3mf_model_getcolorgroupbyid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetColorGroupByID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetSliceStackByID = (PLib3MFModel_GetSliceStackByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_getslicestackbyid");
	#else // _WIN32
	pWrapperTable->m_Model_GetSliceStackByID = (PLib3MFModel_GetSliceStackByIDPtr) dlsym(hLibrary, "lib3mf_model_getslicestackbyid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetSliceStackByID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetLevelSetByID = (PLib3MFModel_GetLevelSetByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_getlevelsetbyid");
	#else // _WIN32
	pWrapperTable->m_Model_GetLevelSetByID = (PLib3MFModel_GetLevelSetByIDPtr) dlsym(hLibrary, "lib3mf_model_getlevelsetbyid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetLevelSetByID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetBuildUUID = (PLib3MFModel_GetBuildUUIDPtr) GetProcAddress(hLibrary, "lib3mf_model_getbuilduuid");
	#else // _WIN32
	pWrapperTable->m_Model_GetBuildUUID = (PLib3MFModel_GetBuildUUIDPtr) dlsym(hLibrary, "lib3mf_model_getbuilduuid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetBuildUUID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_SetBuildUUID = (PLib3MFModel_SetBuildUUIDPtr) GetProcAddress(hLibrary, "lib3mf_model_setbuilduuid");
	#else // _WIN32
	pWrapperTable->m_Model_SetBuildUUID = (PLib3MFModel_SetBuildUUIDPtr) dlsym(hLibrary, "lib3mf_model_setbuilduuid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_SetBuildUUID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetBuildItems = (PLib3MFModel_GetBuildItemsPtr) GetProcAddress(hLibrary, "lib3mf_model_getbuilditems");
	#else // _WIN32
	pWrapperTable->m_Model_GetBuildItems = (PLib3MFModel_GetBuildItemsPtr) dlsym(hLibrary, "lib3mf_model_getbuilditems");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetBuildItems == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetOutbox = (PLib3MFModel_GetOutboxPtr) GetProcAddress(hLibrary, "lib3mf_model_getoutbox");
	#else // _WIN32
	pWrapperTable->m_Model_GetOutbox = (PLib3MFModel_GetOutboxPtr) dlsym(hLibrary, "lib3mf_model_getoutbox");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetOutbox == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetResources = (PLib3MFModel_GetResourcesPtr) GetProcAddress(hLibrary, "lib3mf_model_getresources");
	#else // _WIN32
	pWrapperTable->m_Model_GetResources = (PLib3MFModel_GetResourcesPtr) dlsym(hLibrary, "lib3mf_model_getresources");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetResources == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetObjects = (PLib3MFModel_GetObjectsPtr) GetProcAddress(hLibrary, "lib3mf_model_getobjects");
	#else // _WIN32
	pWrapperTable->m_Model_GetObjects = (PLib3MFModel_GetObjectsPtr) dlsym(hLibrary, "lib3mf_model_getobjects");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetObjects == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetMeshObjects = (PLib3MFModel_GetMeshObjectsPtr) GetProcAddress(hLibrary, "lib3mf_model_getmeshobjects");
	#else // _WIN32
	pWrapperTable->m_Model_GetMeshObjects = (PLib3MFModel_GetMeshObjectsPtr) dlsym(hLibrary, "lib3mf_model_getmeshobjects");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetMeshObjects == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetComponentsObjects = (PLib3MFModel_GetComponentsObjectsPtr) GetProcAddress(hLibrary, "lib3mf_model_getcomponentsobjects");
	#else // _WIN32
	pWrapperTable->m_Model_GetComponentsObjects = (PLib3MFModel_GetComponentsObjectsPtr) dlsym(hLibrary, "lib3mf_model_getcomponentsobjects");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetComponentsObjects == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetTexture2Ds = (PLib3MFModel_GetTexture2DsPtr) GetProcAddress(hLibrary, "lib3mf_model_gettexture2ds");
	#else // _WIN32
	pWrapperTable->m_Model_GetTexture2Ds = (PLib3MFModel_GetTexture2DsPtr) dlsym(hLibrary, "lib3mf_model_gettexture2ds");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetTexture2Ds == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetBaseMaterialGroups = (PLib3MFModel_GetBaseMaterialGroupsPtr) GetProcAddress(hLibrary, "lib3mf_model_getbasematerialgroups");
	#else // _WIN32
	pWrapperTable->m_Model_GetBaseMaterialGroups = (PLib3MFModel_GetBaseMaterialGroupsPtr) dlsym(hLibrary, "lib3mf_model_getbasematerialgroups");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetBaseMaterialGroups == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetColorGroups = (PLib3MFModel_GetColorGroupsPtr) GetProcAddress(hLibrary, "lib3mf_model_getcolorgroups");
	#else // _WIN32
	pWrapperTable->m_Model_GetColorGroups = (PLib3MFModel_GetColorGroupsPtr) dlsym(hLibrary, "lib3mf_model_getcolorgroups");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetColorGroups == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetTexture2DGroups = (PLib3MFModel_GetTexture2DGroupsPtr) GetProcAddress(hLibrary, "lib3mf_model_gettexture2dgroups");
	#else // _WIN32
	pWrapperTable->m_Model_GetTexture2DGroups = (PLib3MFModel_GetTexture2DGroupsPtr) dlsym(hLibrary, "lib3mf_model_gettexture2dgroups");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetTexture2DGroups == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetCompositeMaterials = (PLib3MFModel_GetCompositeMaterialsPtr) GetProcAddress(hLibrary, "lib3mf_model_getcompositematerials");
	#else // _WIN32
	pWrapperTable->m_Model_GetCompositeMaterials = (PLib3MFModel_GetCompositeMaterialsPtr) dlsym(hLibrary, "lib3mf_model_getcompositematerials");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetCompositeMaterials == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetMultiPropertyGroups = (PLib3MFModel_GetMultiPropertyGroupsPtr) GetProcAddress(hLibrary, "lib3mf_model_getmultipropertygroups");
	#else // _WIN32
	pWrapperTable->m_Model_GetMultiPropertyGroups = (PLib3MFModel_GetMultiPropertyGroupsPtr) dlsym(hLibrary, "lib3mf_model_getmultipropertygroups");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetMultiPropertyGroups == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetSliceStacks = (PLib3MFModel_GetSliceStacksPtr) GetProcAddress(hLibrary, "lib3mf_model_getslicestacks");
	#else // _WIN32
	pWrapperTable->m_Model_GetSliceStacks = (PLib3MFModel_GetSliceStacksPtr) dlsym(hLibrary, "lib3mf_model_getslicestacks");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetSliceStacks == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetImage3Ds = (PLib3MFModel_GetImage3DsPtr) GetProcAddress(hLibrary, "lib3mf_model_getimage3ds");
	#else // _WIN32
	pWrapperTable->m_Model_GetImage3Ds = (PLib3MFModel_GetImage3DsPtr) dlsym(hLibrary, "lib3mf_model_getimage3ds");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetImage3Ds == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_MergeToModel = (PLib3MFModel_MergeToModelPtr) GetProcAddress(hLibrary, "lib3mf_model_mergetomodel");
	#else // _WIN32
	pWrapperTable->m_Model_MergeToModel = (PLib3MFModel_MergeToModelPtr) dlsym(hLibrary, "lib3mf_model_mergetomodel");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_MergeToModel == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_MergeFromModel = (PLib3MFModel_MergeFromModelPtr) GetProcAddress(hLibrary, "lib3mf_model_mergefrommodel");
	#else // _WIN32
	pWrapperTable->m_Model_MergeFromModel = (PLib3MFModel_MergeFromModelPtr) dlsym(hLibrary, "lib3mf_model_mergefrommodel");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_MergeFromModel == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_AddMeshObject = (PLib3MFModel_AddMeshObjectPtr) GetProcAddress(hLibrary, "lib3mf_model_addmeshobject");
	#else // _WIN32
	pWrapperTable->m_Model_AddMeshObject = (PLib3MFModel_AddMeshObjectPtr) dlsym(hLibrary, "lib3mf_model_addmeshobject");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_AddMeshObject == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_AddComponentsObject = (PLib3MFModel_AddComponentsObjectPtr) GetProcAddress(hLibrary, "lib3mf_model_addcomponentsobject");
	#else // _WIN32
	pWrapperTable->m_Model_AddComponentsObject = (PLib3MFModel_AddComponentsObjectPtr) dlsym(hLibrary, "lib3mf_model_addcomponentsobject");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_AddComponentsObject == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_AddSliceStack = (PLib3MFModel_AddSliceStackPtr) GetProcAddress(hLibrary, "lib3mf_model_addslicestack");
	#else // _WIN32
	pWrapperTable->m_Model_AddSliceStack = (PLib3MFModel_AddSliceStackPtr) dlsym(hLibrary, "lib3mf_model_addslicestack");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_AddSliceStack == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_AddTexture2DFromAttachment = (PLib3MFModel_AddTexture2DFromAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_model_addtexture2dfromattachment");
	#else // _WIN32
	pWrapperTable->m_Model_AddTexture2DFromAttachment = (PLib3MFModel_AddTexture2DFromAttachmentPtr) dlsym(hLibrary, "lib3mf_model_addtexture2dfromattachment");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_AddTexture2DFromAttachment == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_AddBaseMaterialGroup = (PLib3MFModel_AddBaseMaterialGroupPtr) GetProcAddress(hLibrary, "lib3mf_model_addbasematerialgroup");
	#else // _WIN32
	pWrapperTable->m_Model_AddBaseMaterialGroup = (PLib3MFModel_AddBaseMaterialGroupPtr) dlsym(hLibrary, "lib3mf_model_addbasematerialgroup");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_AddBaseMaterialGroup == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_AddColorGroup = (PLib3MFModel_AddColorGroupPtr) GetProcAddress(hLibrary, "lib3mf_model_addcolorgroup");
	#else // _WIN32
	pWrapperTable->m_Model_AddColorGroup = (PLib3MFModel_AddColorGroupPtr) dlsym(hLibrary, "lib3mf_model_addcolorgroup");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_AddColorGroup == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_AddTexture2DGroup = (PLib3MFModel_AddTexture2DGroupPtr) GetProcAddress(hLibrary, "lib3mf_model_addtexture2dgroup");
	#else // _WIN32
	pWrapperTable->m_Model_AddTexture2DGroup = (PLib3MFModel_AddTexture2DGroupPtr) dlsym(hLibrary, "lib3mf_model_addtexture2dgroup");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_AddTexture2DGroup == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_AddCompositeMaterials = (PLib3MFModel_AddCompositeMaterialsPtr) GetProcAddress(hLibrary, "lib3mf_model_addcompositematerials");
	#else // _WIN32
	pWrapperTable->m_Model_AddCompositeMaterials = (PLib3MFModel_AddCompositeMaterialsPtr) dlsym(hLibrary, "lib3mf_model_addcompositematerials");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_AddCompositeMaterials == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_AddMultiPropertyGroup = (PLib3MFModel_AddMultiPropertyGroupPtr) GetProcAddress(hLibrary, "lib3mf_model_addmultipropertygroup");
	#else // _WIN32
	pWrapperTable->m_Model_AddMultiPropertyGroup = (PLib3MFModel_AddMultiPropertyGroupPtr) dlsym(hLibrary, "lib3mf_model_addmultipropertygroup");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_AddMultiPropertyGroup == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_AddImageStack = (PLib3MFModel_AddImageStackPtr) GetProcAddress(hLibrary, "lib3mf_model_addimagestack");
	#else // _WIN32
	pWrapperTable->m_Model_AddImageStack = (PLib3MFModel_AddImageStackPtr) dlsym(hLibrary, "lib3mf_model_addimagestack");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_AddImageStack == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetImageStackByID = (PLib3MFModel_GetImageStackByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_getimagestackbyid");
	#else // _WIN32
	pWrapperTable->m_Model_GetImageStackByID = (PLib3MFModel_GetImageStackByIDPtr) dlsym(hLibrary, "lib3mf_model_getimagestackbyid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetImageStackByID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_AddBuildItem = (PLib3MFModel_AddBuildItemPtr) GetProcAddress(hLibrary, "lib3mf_model_addbuilditem");
	#else // _WIN32
	pWrapperTable->m_Model_AddBuildItem = (PLib3MFModel_AddBuildItemPtr) dlsym(hLibrary, "lib3mf_model_addbuilditem");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_AddBuildItem == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_RemoveBuildItem = (PLib3MFModel_RemoveBuildItemPtr) GetProcAddress(hLibrary, "lib3mf_model_removebuilditem");
	#else // _WIN32
	pWrapperTable->m_Model_RemoveBuildItem = (PLib3MFModel_RemoveBuildItemPtr) dlsym(hLibrary, "lib3mf_model_removebuilditem");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_RemoveBuildItem == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetMetaDataGroup = (PLib3MFModel_GetMetaDataGroupPtr) GetProcAddress(hLibrary, "lib3mf_model_getmetadatagroup");
	#else // _WIN32
	pWrapperTable->m_Model_GetMetaDataGroup = (PLib3MFModel_GetMetaDataGroupPtr) dlsym(hLibrary, "lib3mf_model_getmetadatagroup");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetMetaDataGroup == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_AddAttachment = (PLib3MFModel_AddAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_model_addattachment");
	#else // _WIN32
	pWrapperTable->m_Model_AddAttachment = (PLib3MFModel_AddAttachmentPtr) dlsym(hLibrary, "lib3mf_model_addattachment");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_AddAttachment == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_RemoveAttachment = (PLib3MFModel_RemoveAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_model_removeattachment");
	#else // _WIN32
	pWrapperTable->m_Model_RemoveAttachment = (PLib3MFModel_RemoveAttachmentPtr) dlsym(hLibrary, "lib3mf_model_removeattachment");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_RemoveAttachment == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetAttachment = (PLib3MFModel_GetAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_model_getattachment");
	#else // _WIN32
	pWrapperTable->m_Model_GetAttachment = (PLib3MFModel_GetAttachmentPtr) dlsym(hLibrary, "lib3mf_model_getattachment");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetAttachment == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_FindAttachment = (PLib3MFModel_FindAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_model_findattachment");
	#else // _WIN32
	pWrapperTable->m_Model_FindAttachment = (PLib3MFModel_FindAttachmentPtr) dlsym(hLibrary, "lib3mf_model_findattachment");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_FindAttachment == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetAttachmentCount = (PLib3MFModel_GetAttachmentCountPtr) GetProcAddress(hLibrary, "lib3mf_model_getattachmentcount");
	#else // _WIN32
	pWrapperTable->m_Model_GetAttachmentCount = (PLib3MFModel_GetAttachmentCountPtr) dlsym(hLibrary, "lib3mf_model_getattachmentcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetAttachmentCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_HasPackageThumbnailAttachment = (PLib3MFModel_HasPackageThumbnailAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_model_haspackagethumbnailattachment");
	#else // _WIN32
	pWrapperTable->m_Model_HasPackageThumbnailAttachment = (PLib3MFModel_HasPackageThumbnailAttachmentPtr) dlsym(hLibrary, "lib3mf_model_haspackagethumbnailattachment");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_HasPackageThumbnailAttachment == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_CreatePackageThumbnailAttachment = (PLib3MFModel_CreatePackageThumbnailAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_model_createpackagethumbnailattachment");
	#else // _WIN32
	pWrapperTable->m_Model_CreatePackageThumbnailAttachment = (PLib3MFModel_CreatePackageThumbnailAttachmentPtr) dlsym(hLibrary, "lib3mf_model_createpackagethumbnailattachment");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_CreatePackageThumbnailAttachment == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetPackageThumbnailAttachment = (PLib3MFModel_GetPackageThumbnailAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_model_getpackagethumbnailattachment");
	#else // _WIN32
	pWrapperTable->m_Model_GetPackageThumbnailAttachment = (PLib3MFModel_GetPackageThumbnailAttachmentPtr) dlsym(hLibrary, "lib3mf_model_getpackagethumbnailattachment");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetPackageThumbnailAttachment == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_RemovePackageThumbnailAttachment = (PLib3MFModel_RemovePackageThumbnailAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_model_removepackagethumbnailattachment");
	#else // _WIN32
	pWrapperTable->m_Model_RemovePackageThumbnailAttachment = (PLib3MFModel_RemovePackageThumbnailAttachmentPtr) dlsym(hLibrary, "lib3mf_model_removepackagethumbnailattachment");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_RemovePackageThumbnailAttachment == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_AddCustomContentType = (PLib3MFModel_AddCustomContentTypePtr) GetProcAddress(hLibrary, "lib3mf_model_addcustomcontenttype");
	#else // _WIN32
	pWrapperTable->m_Model_AddCustomContentType = (PLib3MFModel_AddCustomContentTypePtr) dlsym(hLibrary, "lib3mf_model_addcustomcontenttype");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_AddCustomContentType == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_RemoveCustomContentType = (PLib3MFModel_RemoveCustomContentTypePtr) GetProcAddress(hLibrary, "lib3mf_model_removecustomcontenttype");
	#else // _WIN32
	pWrapperTable->m_Model_RemoveCustomContentType = (PLib3MFModel_RemoveCustomContentTypePtr) dlsym(hLibrary, "lib3mf_model_removecustomcontenttype");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_RemoveCustomContentType == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_SetRandomNumberCallback = (PLib3MFModel_SetRandomNumberCallbackPtr) GetProcAddress(hLibrary, "lib3mf_model_setrandomnumbercallback");
	#else // _WIN32
	pWrapperTable->m_Model_SetRandomNumberCallback = (PLib3MFModel_SetRandomNumberCallbackPtr) dlsym(hLibrary, "lib3mf_model_setrandomnumbercallback");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_SetRandomNumberCallback == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetKeyStore = (PLib3MFModel_GetKeyStorePtr) GetProcAddress(hLibrary, "lib3mf_model_getkeystore");
	#else // _WIN32
	pWrapperTable->m_Model_GetKeyStore = (PLib3MFModel_GetKeyStorePtr) dlsym(hLibrary, "lib3mf_model_getkeystore");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetKeyStore == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetFunctions = (PLib3MFModel_GetFunctionsPtr) GetProcAddress(hLibrary, "lib3mf_model_getfunctions");
	#else // _WIN32
	pWrapperTable->m_Model_GetFunctions = (PLib3MFModel_GetFunctionsPtr) dlsym(hLibrary, "lib3mf_model_getfunctions");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetFunctions == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_AddImplicitFunction = (PLib3MFModel_AddImplicitFunctionPtr) GetProcAddress(hLibrary, "lib3mf_model_addimplicitfunction");
	#else // _WIN32
	pWrapperTable->m_Model_AddImplicitFunction = (PLib3MFModel_AddImplicitFunctionPtr) dlsym(hLibrary, "lib3mf_model_addimplicitfunction");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_AddImplicitFunction == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_AddFunctionFromImage3D = (PLib3MFModel_AddFunctionFromImage3DPtr) GetProcAddress(hLibrary, "lib3mf_model_addfunctionfromimage3d");
	#else // _WIN32
	pWrapperTable->m_Model_AddFunctionFromImage3D = (PLib3MFModel_AddFunctionFromImage3DPtr) dlsym(hLibrary, "lib3mf_model_addfunctionfromimage3d");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_AddFunctionFromImage3D == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_AddVolumeData = (PLib3MFModel_AddVolumeDataPtr) GetProcAddress(hLibrary, "lib3mf_model_addvolumedata");
	#else // _WIN32
	pWrapperTable->m_Model_AddVolumeData = (PLib3MFModel_AddVolumeDataPtr) dlsym(hLibrary, "lib3mf_model_addvolumedata");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_AddVolumeData == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_AddLevelSet = (PLib3MFModel_AddLevelSetPtr) GetProcAddress(hLibrary, "lib3mf_model_addlevelset");
	#else // _WIN32
	pWrapperTable->m_Model_AddLevelSet = (PLib3MFModel_AddLevelSetPtr) dlsym(hLibrary, "lib3mf_model_addlevelset");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_AddLevelSet == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetLevelSets = (PLib3MFModel_GetLevelSetsPtr) GetProcAddress(hLibrary, "lib3mf_model_getlevelsets");
	#else // _WIN32
	pWrapperTable->m_Model_GetLevelSets = (PLib3MFModel_GetLevelSetsPtr) dlsym(hLibrary, "lib3mf_model_getlevelsets");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetLevelSets == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_RemoveResource = (PLib3MFModel_RemoveResourcePtr) GetProcAddress(hLibrary, "lib3mf_model_removeresource");
	#else // _WIN32
	pWrapperTable->m_Model_RemoveResource = (PLib3MFModel_RemoveResourcePtr) dlsym(hLibrary, "lib3mf_model_removeresource");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_RemoveResource == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_GetLibraryVersion = (PLib3MFGetLibraryVersionPtr) GetProcAddress(hLibrary, "lib3mf_getlibraryversion");
	#else // _WIN32
	pWrapperTable->m_GetLibraryVersion = (PLib3MFGetLibraryVersionPtr) dlsym(hLibrary, "lib3mf_getlibraryversion");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_GetLibraryVersion == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_GetPrereleaseInformation = (PLib3MFGetPrereleaseInformationPtr) GetProcAddress(hLibrary, "lib3mf_getprereleaseinformation");
	#else // _WIN32
	pWrapperTable->m_GetPrereleaseInformation = (PLib3MFGetPrereleaseInformationPtr) dlsym(hLibrary, "lib3mf_getprereleaseinformation");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_GetPrereleaseInformation == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_GetBuildInformation = (PLib3MFGetBuildInformationPtr) GetProcAddress(hLibrary, "lib3mf_getbuildinformation");
	#else // _WIN32
	pWrapperTable->m_GetBuildInformation = (PLib3MFGetBuildInformationPtr) dlsym(hLibrary, "lib3mf_getbuildinformation");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_GetBuildInformation == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_GetSpecificationVersion = (PLib3MFGetSpecificationVersionPtr) GetProcAddress(hLibrary, "lib3mf_getspecificationversion");
	#else // _WIN32
	pWrapperTable->m_GetSpecificationVersion = (PLib3MFGetSpecificationVersionPtr) dlsym(hLibrary, "lib3mf_getspecificationversion");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_GetSpecificationVersion == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_CreateModel = (PLib3MFCreateModelPtr) GetProcAddress(hLibrary, "lib3mf_createmodel");
	#else // _WIN32
	pWrapperTable->m_CreateModel = (PLib3MFCreateModelPtr) dlsym(hLibrary, "lib3mf_createmodel");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_CreateModel == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Release = (PLib3MFReleasePtr) GetProcAddress(hLibrary, "lib3mf_release");
	#else // _WIN32
	pWrapperTable->m_Release = (PLib3MFReleasePtr) dlsym(hLibrary, "lib3mf_release");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Release == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Acquire = (PLib3MFAcquirePtr) GetProcAddress(hLibrary, "lib3mf_acquire");
	#else // _WIN32
	pWrapperTable->m_Acquire = (PLib3MFAcquirePtr) dlsym(hLibrary, "lib3mf_acquire");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Acquire == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_SetJournal = (PLib3MFSetJournalPtr) GetProcAddress(hLibrary, "lib3mf_setjournal");
	#else // _WIN32
	pWrapperTable->m_SetJournal = (PLib3MFSetJournalPtr) dlsym(hLibrary, "lib3mf_setjournal");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_SetJournal == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_GetLastError = (PLib3MFGetLastErrorPtr) GetProcAddress(hLibrary, "lib3mf_getlasterror");
	#else // _WIN32
	pWrapperTable->m_GetLastError = (PLib3MFGetLastErrorPtr) dlsym(hLibrary, "lib3mf_getlasterror");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_GetLastError == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_GetSymbolLookupMethod = (PLib3MFGetSymbolLookupMethodPtr) GetProcAddress(hLibrary, "lib3mf_getsymbollookupmethod");
	#else // _WIN32
	pWrapperTable->m_GetSymbolLookupMethod = (PLib3MFGetSymbolLookupMethodPtr) dlsym(hLibrary, "lib3mf_getsymbollookupmethod");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_GetSymbolLookupMethod == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_RetrieveProgressMessage = (PLib3MFRetrieveProgressMessagePtr) GetProcAddress(hLibrary, "lib3mf_retrieveprogressmessage");
	#else // _WIN32
	pWrapperTable->m_RetrieveProgressMessage = (PLib3MFRetrieveProgressMessagePtr) dlsym(hLibrary, "lib3mf_retrieveprogressmessage");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_RetrieveProgressMessage == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_RGBAToColor = (PLib3MFRGBAToColorPtr) GetProcAddress(hLibrary, "lib3mf_rgbatocolor");
	#else // _WIN32
	pWrapperTable->m_RGBAToColor = (PLib3MFRGBAToColorPtr) dlsym(hLibrary, "lib3mf_rgbatocolor");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_RGBAToColor == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FloatRGBAToColor = (PLib3MFFloatRGBAToColorPtr) GetProcAddress(hLibrary, "lib3mf_floatrgbatocolor");
	#else // _WIN32
	pWrapperTable->m_FloatRGBAToColor = (PLib3MFFloatRGBAToColorPtr) dlsym(hLibrary, "lib3mf_floatrgbatocolor");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FloatRGBAToColor == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ColorToRGBA = (PLib3MFColorToRGBAPtr) GetProcAddress(hLibrary, "lib3mf_colortorgba");
	#else // _WIN32
	pWrapperTable->m_ColorToRGBA = (PLib3MFColorToRGBAPtr) dlsym(hLibrary, "lib3mf_colortorgba");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ColorToRGBA == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ColorToFloatRGBA = (PLib3MFColorToFloatRGBAPtr) GetProcAddress(hLibrary, "lib3mf_colortofloatrgba");
	#else // _WIN32
	pWrapperTable->m_ColorToFloatRGBA = (PLib3MFColorToFloatRGBAPtr) dlsym(hLibrary, "lib3mf_colortofloatrgba");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ColorToFloatRGBA == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_GetIdentityTransform = (PLib3MFGetIdentityTransformPtr) GetProcAddress(hLibrary, "lib3mf_getidentitytransform");
	#else // _WIN32
	pWrapperTable->m_GetIdentityTransform = (PLib3MFGetIdentityTransformPtr) dlsym(hLibrary, "lib3mf_getidentitytransform");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_GetIdentityTransform == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_GetUniformScaleTransform = (PLib3MFGetUniformScaleTransformPtr) GetProcAddress(hLibrary, "lib3mf_getuniformscaletransform");
	#else // _WIN32
	pWrapperTable->m_GetUniformScaleTransform = (PLib3MFGetUniformScaleTransformPtr) dlsym(hLibrary, "lib3mf_getuniformscaletransform");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_GetUniformScaleTransform == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_GetScaleTransform = (PLib3MFGetScaleTransformPtr) GetProcAddress(hLibrary, "lib3mf_getscaletransform");
	#else // _WIN32
	pWrapperTable->m_GetScaleTransform = (PLib3MFGetScaleTransformPtr) dlsym(hLibrary, "lib3mf_getscaletransform");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_GetScaleTransform == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_GetTranslationTransform = (PLib3MFGetTranslationTransformPtr) GetProcAddress(hLibrary, "lib3mf_gettranslationtransform");
	#else // _WIN32
	pWrapperTable->m_GetTranslationTransform = (PLib3MFGetTranslationTransformPtr) dlsym(hLibrary, "lib3mf_gettranslationtransform");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_GetTranslationTransform == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	pWrapperTable->m_LibraryHandle = hLibrary;
	return LIB3MF_SUCCESS;
}

Lib3MFHandle loadLib3MFLibrary (const char * pFileName)
{
	Lib3MFResult nResult;
	sLib3MFDynamicWrapperTable * pWrapperTable = (sLib3MFDynamicWrapperTable *) malloc (sizeof (sLib3MFDynamicWrapperTable));
	if (pWrapperTable != NULL) {
		nResult = InitLib3MFWrapperTable (pWrapperTable);
		if (nResult != LIB3MF_SUCCESS) {
			free (pWrapperTable);
			return 0;
		}

		nResult = LoadLib3MFWrapperTable (pWrapperTable, pFileName);
		if (nResult != LIB3MF_SUCCESS) {
			free (pWrapperTable);
			return 0;
		}

		return (Lib3MFHandle) pWrapperTable;
	}
}

void unloadLib3MFLibrary (Lib3MFHandle nLibraryHandle)
{
	sLib3MFDynamicWrapperTable * pWrapperTable = (sLib3MFDynamicWrapperTable *) malloc (sizeof (sLib3MFDynamicWrapperTable));
	if (pWrapperTable != NULL) {
		ReleaseLib3MFWrapperTable (pWrapperTable);
		free (pWrapperTable);
	}
}


Lib3MFResult CCall_lib3mf_base_classtypeid(Lib3MFHandle libraryHandle, Lib3MF_Base pBase, Lib3MF_uint64 * pClassTypeId)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Base_ClassTypeId (pBase, pClassTypeId);
}


Lib3MFResult CCall_lib3mf_writer_writetofile(Lib3MFHandle libraryHandle, Lib3MF_Writer pWriter, const char * pFilename)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Writer_WriteToFile (pWriter, pFilename);
}


Lib3MFResult CCall_lib3mf_writer_getstreamsize(Lib3MFHandle libraryHandle, Lib3MF_Writer pWriter, Lib3MF_uint64 * pStreamSize)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Writer_GetStreamSize (pWriter, pStreamSize);
}


Lib3MFResult CCall_lib3mf_writer_writetobuffer(Lib3MFHandle libraryHandle, Lib3MF_Writer pWriter, const Lib3MF_uint64 nBufferBufferSize, Lib3MF_uint64* pBufferNeededCount, Lib3MF_uint8 * pBufferBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Writer_WriteToBuffer (pWriter, nBufferBufferSize, pBufferNeededCount, pBufferBuffer);
}


Lib3MFResult CCall_lib3mf_writer_writetocallback(Lib3MFHandle libraryHandle, Lib3MF_Writer pWriter, Lib3MFWriteCallback pTheWriteCallback, Lib3MFSeekCallback pTheSeekCallback, Lib3MF_pvoid pUserData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Writer_WriteToCallback (pWriter, pTheWriteCallback, pTheSeekCallback, pUserData);
}


Lib3MFResult CCall_lib3mf_writer_setprogresscallback(Lib3MFHandle libraryHandle, Lib3MF_Writer pWriter, Lib3MFProgressCallback pProgressCallback, Lib3MF_pvoid pUserData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Writer_SetProgressCallback (pWriter, pProgressCallback, pUserData);
}


Lib3MFResult CCall_lib3mf_writer_getdecimalprecision(Lib3MFHandle libraryHandle, Lib3MF_Writer pWriter, Lib3MF_uint32 * pDecimalPrecision)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Writer_GetDecimalPrecision (pWriter, pDecimalPrecision);
}


Lib3MFResult CCall_lib3mf_writer_setdecimalprecision(Lib3MFHandle libraryHandle, Lib3MF_Writer pWriter, Lib3MF_uint32 nDecimalPrecision)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Writer_SetDecimalPrecision (pWriter, nDecimalPrecision);
}


Lib3MFResult CCall_lib3mf_writer_setstrictmodeactive(Lib3MFHandle libraryHandle, Lib3MF_Writer pWriter, bool bStrictModeActive)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Writer_SetStrictModeActive (pWriter, bStrictModeActive);
}


Lib3MFResult CCall_lib3mf_writer_getstrictmodeactive(Lib3MFHandle libraryHandle, Lib3MF_Writer pWriter, bool * pStrictModeActive)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Writer_GetStrictModeActive (pWriter, pStrictModeActive);
}


Lib3MFResult CCall_lib3mf_writer_getwarning(Lib3MFHandle libraryHandle, Lib3MF_Writer pWriter, Lib3MF_uint32 nIndex, Lib3MF_uint32 * pErrorCode, const Lib3MF_uint32 nWarningBufferSize, Lib3MF_uint32* pWarningNeededChars, char * pWarningBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Writer_GetWarning (pWriter, nIndex, pErrorCode, nWarningBufferSize, pWarningNeededChars, pWarningBuffer);
}


Lib3MFResult CCall_lib3mf_writer_getwarningcount(Lib3MFHandle libraryHandle, Lib3MF_Writer pWriter, Lib3MF_uint32 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Writer_GetWarningCount (pWriter, pCount);
}


Lib3MFResult CCall_lib3mf_writer_addkeywrappingcallback(Lib3MFHandle libraryHandle, Lib3MF_Writer pWriter, const char * pConsumerID, Lib3MFKeyWrappingCallback pTheCallback, Lib3MF_pvoid pUserData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Writer_AddKeyWrappingCallback (pWriter, pConsumerID, pTheCallback, pUserData);
}


Lib3MFResult CCall_lib3mf_writer_setcontentencryptioncallback(Lib3MFHandle libraryHandle, Lib3MF_Writer pWriter, Lib3MFContentEncryptionCallback pTheCallback, Lib3MF_pvoid pUserData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Writer_SetContentEncryptionCallback (pWriter, pTheCallback, pUserData);
}


Lib3MFResult CCall_lib3mf_reader_readfromfile(Lib3MFHandle libraryHandle, Lib3MF_Reader pReader, const char * pFilename)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Reader_ReadFromFile (pReader, pFilename);
}


Lib3MFResult CCall_lib3mf_reader_readfrombuffer(Lib3MFHandle libraryHandle, Lib3MF_Reader pReader, Lib3MF_uint64 nBufferBufferSize, const Lib3MF_uint8 * pBufferBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Reader_ReadFromBuffer (pReader, nBufferBufferSize, pBufferBuffer);
}


Lib3MFResult CCall_lib3mf_reader_readfromcallback(Lib3MFHandle libraryHandle, Lib3MF_Reader pReader, Lib3MFReadCallback pTheReadCallback, Lib3MF_uint64 nStreamSize, Lib3MFSeekCallback pTheSeekCallback, Lib3MF_pvoid pUserData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Reader_ReadFromCallback (pReader, pTheReadCallback, nStreamSize, pTheSeekCallback, pUserData);
}


Lib3MFResult CCall_lib3mf_reader_setprogresscallback(Lib3MFHandle libraryHandle, Lib3MF_Reader pReader, Lib3MFProgressCallback pProgressCallback, Lib3MF_pvoid pUserData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Reader_SetProgressCallback (pReader, pProgressCallback, pUserData);
}


Lib3MFResult CCall_lib3mf_reader_addrelationtoread(Lib3MFHandle libraryHandle, Lib3MF_Reader pReader, const char * pRelationShipType)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Reader_AddRelationToRead (pReader, pRelationShipType);
}


Lib3MFResult CCall_lib3mf_reader_removerelationtoread(Lib3MFHandle libraryHandle, Lib3MF_Reader pReader, const char * pRelationShipType)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Reader_RemoveRelationToRead (pReader, pRelationShipType);
}


Lib3MFResult CCall_lib3mf_reader_setstrictmodeactive(Lib3MFHandle libraryHandle, Lib3MF_Reader pReader, bool bStrictModeActive)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Reader_SetStrictModeActive (pReader, bStrictModeActive);
}


Lib3MFResult CCall_lib3mf_reader_getstrictmodeactive(Lib3MFHandle libraryHandle, Lib3MF_Reader pReader, bool * pStrictModeActive)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Reader_GetStrictModeActive (pReader, pStrictModeActive);
}


Lib3MFResult CCall_lib3mf_reader_getwarning(Lib3MFHandle libraryHandle, Lib3MF_Reader pReader, Lib3MF_uint32 nIndex, Lib3MF_uint32 * pErrorCode, const Lib3MF_uint32 nWarningBufferSize, Lib3MF_uint32* pWarningNeededChars, char * pWarningBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Reader_GetWarning (pReader, nIndex, pErrorCode, nWarningBufferSize, pWarningNeededChars, pWarningBuffer);
}


Lib3MFResult CCall_lib3mf_reader_getwarningcount(Lib3MFHandle libraryHandle, Lib3MF_Reader pReader, Lib3MF_uint32 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Reader_GetWarningCount (pReader, pCount);
}


Lib3MFResult CCall_lib3mf_reader_addkeywrappingcallback(Lib3MFHandle libraryHandle, Lib3MF_Reader pReader, const char * pConsumerID, Lib3MFKeyWrappingCallback pTheCallback, Lib3MF_pvoid pUserData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Reader_AddKeyWrappingCallback (pReader, pConsumerID, pTheCallback, pUserData);
}


Lib3MFResult CCall_lib3mf_reader_setcontentencryptioncallback(Lib3MFHandle libraryHandle, Lib3MF_Reader pReader, Lib3MFContentEncryptionCallback pTheCallback, Lib3MF_pvoid pUserData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Reader_SetContentEncryptionCallback (pReader, pTheCallback, pUserData);
}


Lib3MFResult CCall_lib3mf_packagepart_getpath(Lib3MFHandle libraryHandle, Lib3MF_PackagePart pPackagePart, const Lib3MF_uint32 nPathBufferSize, Lib3MF_uint32* pPathNeededChars, char * pPathBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_PackagePart_GetPath (pPackagePart, nPathBufferSize, pPathNeededChars, pPathBuffer);
}


Lib3MFResult CCall_lib3mf_packagepart_setpath(Lib3MFHandle libraryHandle, Lib3MF_PackagePart pPackagePart, const char * pPath)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_PackagePart_SetPath (pPackagePart, pPath);
}


Lib3MFResult CCall_lib3mf_resource_getresourceid(Lib3MFHandle libraryHandle, Lib3MF_Resource pResource, Lib3MF_uint32 * pUniqueResourceID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Resource_GetResourceID (pResource, pUniqueResourceID);
}


Lib3MFResult CCall_lib3mf_resource_getuniqueresourceid(Lib3MFHandle libraryHandle, Lib3MF_Resource pResource, Lib3MF_uint32 * pUniqueResourceID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Resource_GetUniqueResourceID (pResource, pUniqueResourceID);
}


Lib3MFResult CCall_lib3mf_resource_packagepart(Lib3MFHandle libraryHandle, Lib3MF_Resource pResource, Lib3MF_PackagePart * pPackagePart)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Resource_PackagePart (pResource, pPackagePart);
}


Lib3MFResult CCall_lib3mf_resource_setpackagepart(Lib3MFHandle libraryHandle, Lib3MF_Resource pResource, Lib3MF_PackagePart pPackagePart)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Resource_SetPackagePart (pResource, pPackagePart);
}


Lib3MFResult CCall_lib3mf_resource_getmodelresourceid(Lib3MFHandle libraryHandle, Lib3MF_Resource pResource, Lib3MF_uint32 * pModelResourceId)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Resource_GetModelResourceID (pResource, pModelResourceId);
}


Lib3MFResult CCall_lib3mf_resourceiterator_movenext(Lib3MFHandle libraryHandle, Lib3MF_ResourceIterator pResourceIterator, bool * pHasNext)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ResourceIterator_MoveNext (pResourceIterator, pHasNext);
}


Lib3MFResult CCall_lib3mf_resourceiterator_moveprevious(Lib3MFHandle libraryHandle, Lib3MF_ResourceIterator pResourceIterator, bool * pHasPrevious)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ResourceIterator_MovePrevious (pResourceIterator, pHasPrevious);
}


Lib3MFResult CCall_lib3mf_resourceiterator_getcurrent(Lib3MFHandle libraryHandle, Lib3MF_ResourceIterator pResourceIterator, Lib3MF_Resource * pResource)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ResourceIterator_GetCurrent (pResourceIterator, pResource);
}


Lib3MFResult CCall_lib3mf_resourceiterator_clone(Lib3MFHandle libraryHandle, Lib3MF_ResourceIterator pResourceIterator, Lib3MF_ResourceIterator * pOutResourceIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ResourceIterator_Clone (pResourceIterator, pOutResourceIterator);
}


Lib3MFResult CCall_lib3mf_resourceiterator_count(Lib3MFHandle libraryHandle, Lib3MF_ResourceIterator pResourceIterator, Lib3MF_uint64 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ResourceIterator_Count (pResourceIterator, pCount);
}


Lib3MFResult CCall_lib3mf_slicestackiterator_getcurrentslicestack(Lib3MFHandle libraryHandle, Lib3MF_SliceStackIterator pSliceStackIterator, Lib3MF_SliceStack * pResource)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_SliceStackIterator_GetCurrentSliceStack (pSliceStackIterator, pResource);
}


Lib3MFResult CCall_lib3mf_objectiterator_getcurrentobject(Lib3MFHandle libraryHandle, Lib3MF_ObjectIterator pObjectIterator, Lib3MF_Object * pResource)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ObjectIterator_GetCurrentObject (pObjectIterator, pResource);
}


Lib3MFResult CCall_lib3mf_meshobjectiterator_getcurrentmeshobject(Lib3MFHandle libraryHandle, Lib3MF_MeshObjectIterator pMeshObjectIterator, Lib3MF_MeshObject * pResource)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObjectIterator_GetCurrentMeshObject (pMeshObjectIterator, pResource);
}


Lib3MFResult CCall_lib3mf_componentsobjectiterator_getcurrentcomponentsobject(Lib3MFHandle libraryHandle, Lib3MF_ComponentsObjectIterator pComponentsObjectIterator, Lib3MF_ComponentsObject * pResource)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ComponentsObjectIterator_GetCurrentComponentsObject (pComponentsObjectIterator, pResource);
}


Lib3MFResult CCall_lib3mf_texture2diterator_getcurrenttexture2d(Lib3MFHandle libraryHandle, Lib3MF_Texture2DIterator pTexture2DIterator, Lib3MF_Texture2D * pResource)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Texture2DIterator_GetCurrentTexture2D (pTexture2DIterator, pResource);
}


Lib3MFResult CCall_lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup(Lib3MFHandle libraryHandle, Lib3MF_BaseMaterialGroupIterator pBaseMaterialGroupIterator, Lib3MF_BaseMaterialGroup * pResource)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BaseMaterialGroupIterator_GetCurrentBaseMaterialGroup (pBaseMaterialGroupIterator, pResource);
}


Lib3MFResult CCall_lib3mf_colorgroupiterator_getcurrentcolorgroup(Lib3MFHandle libraryHandle, Lib3MF_ColorGroupIterator pColorGroupIterator, Lib3MF_ColorGroup * pResource)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ColorGroupIterator_GetCurrentColorGroup (pColorGroupIterator, pResource);
}


Lib3MFResult CCall_lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup(Lib3MFHandle libraryHandle, Lib3MF_Texture2DGroupIterator pTexture2DGroupIterator, Lib3MF_Texture2DGroup * pResource)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Texture2DGroupIterator_GetCurrentTexture2DGroup (pTexture2DGroupIterator, pResource);
}


Lib3MFResult CCall_lib3mf_compositematerialsiterator_getcurrentcompositematerials(Lib3MFHandle libraryHandle, Lib3MF_CompositeMaterialsIterator pCompositeMaterialsIterator, Lib3MF_CompositeMaterials * pResource)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_CompositeMaterialsIterator_GetCurrentCompositeMaterials (pCompositeMaterialsIterator, pResource);
}


Lib3MFResult CCall_lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup(Lib3MFHandle libraryHandle, Lib3MF_MultiPropertyGroupIterator pMultiPropertyGroupIterator, Lib3MF_MultiPropertyGroup * pResource)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MultiPropertyGroupIterator_GetCurrentMultiPropertyGroup (pMultiPropertyGroupIterator, pResource);
}


Lib3MFResult CCall_lib3mf_image3diterator_getcurrentimage3d(Lib3MFHandle libraryHandle, Lib3MF_Image3DIterator pImage3DIterator, Lib3MF_Image3D * pResource)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Image3DIterator_GetCurrentImage3D (pImage3DIterator, pResource);
}


Lib3MFResult CCall_lib3mf_functioniterator_getcurrentfunction(Lib3MFHandle libraryHandle, Lib3MF_FunctionIterator pFunctionIterator, Lib3MF_Function * pResource)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_FunctionIterator_GetCurrentFunction (pFunctionIterator, pResource);
}


Lib3MFResult CCall_lib3mf_levelsetiterator_getcurrentlevelset(Lib3MFHandle libraryHandle, Lib3MF_LevelSetIterator pLevelSetIterator, Lib3MF_LevelSet * pResource)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_LevelSetIterator_GetCurrentLevelSet (pLevelSetIterator, pResource);
}


Lib3MFResult CCall_lib3mf_metadata_getnamespace(Lib3MFHandle libraryHandle, Lib3MF_MetaData pMetaData, const Lib3MF_uint32 nNameSpaceBufferSize, Lib3MF_uint32* pNameSpaceNeededChars, char * pNameSpaceBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MetaData_GetNameSpace (pMetaData, nNameSpaceBufferSize, pNameSpaceNeededChars, pNameSpaceBuffer);
}


Lib3MFResult CCall_lib3mf_metadata_setnamespace(Lib3MFHandle libraryHandle, Lib3MF_MetaData pMetaData, const char * pNameSpace)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MetaData_SetNameSpace (pMetaData, pNameSpace);
}


Lib3MFResult CCall_lib3mf_metadata_getname(Lib3MFHandle libraryHandle, Lib3MF_MetaData pMetaData, const Lib3MF_uint32 nNameBufferSize, Lib3MF_uint32* pNameNeededChars, char * pNameBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MetaData_GetName (pMetaData, nNameBufferSize, pNameNeededChars, pNameBuffer);
}


Lib3MFResult CCall_lib3mf_metadata_setname(Lib3MFHandle libraryHandle, Lib3MF_MetaData pMetaData, const char * pName)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MetaData_SetName (pMetaData, pName);
}


Lib3MFResult CCall_lib3mf_metadata_getkey(Lib3MFHandle libraryHandle, Lib3MF_MetaData pMetaData, const Lib3MF_uint32 nKeyBufferSize, Lib3MF_uint32* pKeyNeededChars, char * pKeyBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MetaData_GetKey (pMetaData, nKeyBufferSize, pKeyNeededChars, pKeyBuffer);
}


Lib3MFResult CCall_lib3mf_metadata_getmustpreserve(Lib3MFHandle libraryHandle, Lib3MF_MetaData pMetaData, bool * pMustPreserve)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MetaData_GetMustPreserve (pMetaData, pMustPreserve);
}


Lib3MFResult CCall_lib3mf_metadata_setmustpreserve(Lib3MFHandle libraryHandle, Lib3MF_MetaData pMetaData, bool bMustPreserve)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MetaData_SetMustPreserve (pMetaData, bMustPreserve);
}


Lib3MFResult CCall_lib3mf_metadata_gettype(Lib3MFHandle libraryHandle, Lib3MF_MetaData pMetaData, const Lib3MF_uint32 nTypeBufferSize, Lib3MF_uint32* pTypeNeededChars, char * pTypeBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MetaData_GetType (pMetaData, nTypeBufferSize, pTypeNeededChars, pTypeBuffer);
}


Lib3MFResult CCall_lib3mf_metadata_settype(Lib3MFHandle libraryHandle, Lib3MF_MetaData pMetaData, const char * pType)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MetaData_SetType (pMetaData, pType);
}


Lib3MFResult CCall_lib3mf_metadata_getvalue(Lib3MFHandle libraryHandle, Lib3MF_MetaData pMetaData, const Lib3MF_uint32 nValueBufferSize, Lib3MF_uint32* pValueNeededChars, char * pValueBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MetaData_GetValue (pMetaData, nValueBufferSize, pValueNeededChars, pValueBuffer);
}


Lib3MFResult CCall_lib3mf_metadata_setvalue(Lib3MFHandle libraryHandle, Lib3MF_MetaData pMetaData, const char * pValue)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MetaData_SetValue (pMetaData, pValue);
}


Lib3MFResult CCall_lib3mf_metadatagroup_getmetadatacount(Lib3MFHandle libraryHandle, Lib3MF_MetaDataGroup pMetaDataGroup, Lib3MF_uint32 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MetaDataGroup_GetMetaDataCount (pMetaDataGroup, pCount);
}


Lib3MFResult CCall_lib3mf_metadatagroup_getmetadata(Lib3MFHandle libraryHandle, Lib3MF_MetaDataGroup pMetaDataGroup, Lib3MF_uint32 nIndex, Lib3MF_MetaData * pMetaData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MetaDataGroup_GetMetaData (pMetaDataGroup, nIndex, pMetaData);
}


Lib3MFResult CCall_lib3mf_metadatagroup_getmetadatabykey(Lib3MFHandle libraryHandle, Lib3MF_MetaDataGroup pMetaDataGroup, const char * pNameSpace, const char * pName, Lib3MF_MetaData * pMetaData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MetaDataGroup_GetMetaDataByKey (pMetaDataGroup, pNameSpace, pName, pMetaData);
}


Lib3MFResult CCall_lib3mf_metadatagroup_removemetadatabyindex(Lib3MFHandle libraryHandle, Lib3MF_MetaDataGroup pMetaDataGroup, Lib3MF_uint32 nIndex)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MetaDataGroup_RemoveMetaDataByIndex (pMetaDataGroup, nIndex);
}


Lib3MFResult CCall_lib3mf_metadatagroup_removemetadata(Lib3MFHandle libraryHandle, Lib3MF_MetaDataGroup pMetaDataGroup, Lib3MF_MetaData pTheMetaData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MetaDataGroup_RemoveMetaData (pMetaDataGroup, pTheMetaData);
}


Lib3MFResult CCall_lib3mf_metadatagroup_addmetadata(Lib3MFHandle libraryHandle, Lib3MF_MetaDataGroup pMetaDataGroup, const char * pNameSpace, const char * pName, const char * pValue, const char * pType, bool bMustPreserve, Lib3MF_MetaData * pMetaData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MetaDataGroup_AddMetaData (pMetaDataGroup, pNameSpace, pName, pValue, pType, bMustPreserve, pMetaData);
}


Lib3MFResult CCall_lib3mf_triangleset_setname(Lib3MFHandle libraryHandle, Lib3MF_TriangleSet pTriangleSet, const char * pName)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_TriangleSet_SetName (pTriangleSet, pName);
}


Lib3MFResult CCall_lib3mf_triangleset_getname(Lib3MFHandle libraryHandle, Lib3MF_TriangleSet pTriangleSet, const Lib3MF_uint32 nNameBufferSize, Lib3MF_uint32* pNameNeededChars, char * pNameBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_TriangleSet_GetName (pTriangleSet, nNameBufferSize, pNameNeededChars, pNameBuffer);
}


Lib3MFResult CCall_lib3mf_triangleset_setidentifier(Lib3MFHandle libraryHandle, Lib3MF_TriangleSet pTriangleSet, const char * pIdentifier)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_TriangleSet_SetIdentifier (pTriangleSet, pIdentifier);
}


Lib3MFResult CCall_lib3mf_triangleset_getidentifier(Lib3MFHandle libraryHandle, Lib3MF_TriangleSet pTriangleSet, const Lib3MF_uint32 nIdentifierBufferSize, Lib3MF_uint32* pIdentifierNeededChars, char * pIdentifierBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_TriangleSet_GetIdentifier (pTriangleSet, nIdentifierBufferSize, pIdentifierNeededChars, pIdentifierBuffer);
}


Lib3MFResult CCall_lib3mf_triangleset_addtriangle(Lib3MFHandle libraryHandle, Lib3MF_TriangleSet pTriangleSet, Lib3MF_uint32 nTriangleIndex)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_TriangleSet_AddTriangle (pTriangleSet, nTriangleIndex);
}


Lib3MFResult CCall_lib3mf_triangleset_removetriangle(Lib3MFHandle libraryHandle, Lib3MF_TriangleSet pTriangleSet, Lib3MF_uint32 nTriangleIndex)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_TriangleSet_RemoveTriangle (pTriangleSet, nTriangleIndex);
}


Lib3MFResult CCall_lib3mf_triangleset_clear(Lib3MFHandle libraryHandle, Lib3MF_TriangleSet pTriangleSet)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_TriangleSet_Clear (pTriangleSet);
}


Lib3MFResult CCall_lib3mf_triangleset_settrianglelist(Lib3MFHandle libraryHandle, Lib3MF_TriangleSet pTriangleSet, Lib3MF_uint64 nTriangleIndicesBufferSize, const Lib3MF_uint32 * pTriangleIndicesBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_TriangleSet_SetTriangleList (pTriangleSet, nTriangleIndicesBufferSize, pTriangleIndicesBuffer);
}


Lib3MFResult CCall_lib3mf_triangleset_gettrianglelist(Lib3MFHandle libraryHandle, Lib3MF_TriangleSet pTriangleSet, const Lib3MF_uint64 nTriangleIndicesBufferSize, Lib3MF_uint64* pTriangleIndicesNeededCount, Lib3MF_uint32 * pTriangleIndicesBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_TriangleSet_GetTriangleList (pTriangleSet, nTriangleIndicesBufferSize, pTriangleIndicesNeededCount, pTriangleIndicesBuffer);
}


Lib3MFResult CCall_lib3mf_triangleset_addtrianglelist(Lib3MFHandle libraryHandle, Lib3MF_TriangleSet pTriangleSet, Lib3MF_uint64 nTriangleIndicesBufferSize, const Lib3MF_uint32 * pTriangleIndicesBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_TriangleSet_AddTriangleList (pTriangleSet, nTriangleIndicesBufferSize, pTriangleIndicesBuffer);
}


Lib3MFResult CCall_lib3mf_triangleset_merge(Lib3MFHandle libraryHandle, Lib3MF_TriangleSet pTriangleSet, Lib3MF_TriangleSet pOtherTriangleSet, bool bDeleteOther)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_TriangleSet_Merge (pTriangleSet, pOtherTriangleSet, bDeleteOther);
}


Lib3MFResult CCall_lib3mf_triangleset_deleteset(Lib3MFHandle libraryHandle, Lib3MF_TriangleSet pTriangleSet)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_TriangleSet_DeleteSet (pTriangleSet);
}


Lib3MFResult CCall_lib3mf_triangleset_duplicate(Lib3MFHandle libraryHandle, Lib3MF_TriangleSet pTriangleSet, const char * pIdentifier, Lib3MF_TriangleSet * pNewSet)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_TriangleSet_Duplicate (pTriangleSet, pIdentifier, pNewSet);
}


Lib3MFResult CCall_lib3mf_object_gettype(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, eLib3MFObjectType * pObjectType)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_GetType (pObject, pObjectType);
}


Lib3MFResult CCall_lib3mf_object_settype(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, eLib3MFObjectType eObjectType)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_SetType (pObject, eObjectType);
}


Lib3MFResult CCall_lib3mf_object_getname(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, const Lib3MF_uint32 nNameBufferSize, Lib3MF_uint32* pNameNeededChars, char * pNameBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_GetName (pObject, nNameBufferSize, pNameNeededChars, pNameBuffer);
}


Lib3MFResult CCall_lib3mf_object_setname(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, const char * pName)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_SetName (pObject, pName);
}


Lib3MFResult CCall_lib3mf_object_getpartnumber(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, const Lib3MF_uint32 nPartNumberBufferSize, Lib3MF_uint32* pPartNumberNeededChars, char * pPartNumberBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_GetPartNumber (pObject, nPartNumberBufferSize, pPartNumberNeededChars, pPartNumberBuffer);
}


Lib3MFResult CCall_lib3mf_object_setpartnumber(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, const char * pPartNumber)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_SetPartNumber (pObject, pPartNumber);
}


Lib3MFResult CCall_lib3mf_object_ismeshobject(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, bool * pIsMeshObject)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_IsMeshObject (pObject, pIsMeshObject);
}


Lib3MFResult CCall_lib3mf_object_iscomponentsobject(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, bool * pIsComponentsObject)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_IsComponentsObject (pObject, pIsComponentsObject);
}


Lib3MFResult CCall_lib3mf_object_islevelsetobject(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, bool * pIsLevelSetObject)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_IsLevelSetObject (pObject, pIsLevelSetObject);
}


Lib3MFResult CCall_lib3mf_object_isvalid(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, bool * pIsValid)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_IsValid (pObject, pIsValid);
}


Lib3MFResult CCall_lib3mf_object_setattachmentasthumbnail(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, Lib3MF_Attachment pAttachment)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_SetAttachmentAsThumbnail (pObject, pAttachment);
}


Lib3MFResult CCall_lib3mf_object_getthumbnailattachment(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, Lib3MF_Attachment * pAttachment)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_GetThumbnailAttachment (pObject, pAttachment);
}


Lib3MFResult CCall_lib3mf_object_clearthumbnailattachment(Lib3MFHandle libraryHandle, Lib3MF_Object pObject)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_ClearThumbnailAttachment (pObject);
}


Lib3MFResult CCall_lib3mf_object_getoutbox(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, sLib3MFBox * pOutbox)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_GetOutbox (pObject, pOutbox);
}


Lib3MFResult CCall_lib3mf_object_getuuid(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, bool * pHasUUID, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_GetUUID (pObject, pHasUUID, nUUIDBufferSize, pUUIDNeededChars, pUUIDBuffer);
}


Lib3MFResult CCall_lib3mf_object_setuuid(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, const char * pUUID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_SetUUID (pObject, pUUID);
}


Lib3MFResult CCall_lib3mf_object_getmetadatagroup(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, Lib3MF_MetaDataGroup * pMetaDataGroup)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_GetMetaDataGroup (pObject, pMetaDataGroup);
}


Lib3MFResult CCall_lib3mf_object_setslicesmeshresolution(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, eLib3MFSlicesMeshResolution eMeshResolution)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_SetSlicesMeshResolution (pObject, eMeshResolution);
}


Lib3MFResult CCall_lib3mf_object_getslicesmeshresolution(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, eLib3MFSlicesMeshResolution * pMeshResolution)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_GetSlicesMeshResolution (pObject, pMeshResolution);
}


Lib3MFResult CCall_lib3mf_object_hasslices(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, bool bRecursive, bool * pHasSlices)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_HasSlices (pObject, bRecursive, pHasSlices);
}


Lib3MFResult CCall_lib3mf_object_clearslicestack(Lib3MFHandle libraryHandle, Lib3MF_Object pObject)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_ClearSliceStack (pObject);
}


Lib3MFResult CCall_lib3mf_object_getslicestack(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, Lib3MF_SliceStack * pSliceStackInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_GetSliceStack (pObject, pSliceStackInstance);
}


Lib3MFResult CCall_lib3mf_object_assignslicestack(Lib3MFHandle libraryHandle, Lib3MF_Object pObject, Lib3MF_SliceStack pSliceStackInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Object_AssignSliceStack (pObject, pSliceStackInstance);
}


Lib3MFResult CCall_lib3mf_meshobject_getvertexcount(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 * pVertexCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_GetVertexCount (pMeshObject, pVertexCount);
}


Lib3MFResult CCall_lib3mf_meshobject_gettrianglecount(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 * pVertexCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_GetTriangleCount (pMeshObject, pVertexCount);
}


Lib3MFResult CCall_lib3mf_meshobject_getvertex(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, sLib3MFPosition * pCoordinates)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_GetVertex (pMeshObject, nIndex, pCoordinates);
}


Lib3MFResult CCall_lib3mf_meshobject_setvertex(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, const sLib3MFPosition * pCoordinates)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_SetVertex (pMeshObject, nIndex, pCoordinates);
}


Lib3MFResult CCall_lib3mf_meshobject_addvertex(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, const sLib3MFPosition * pCoordinates, Lib3MF_uint32 * pNewIndex)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_AddVertex (pMeshObject, pCoordinates, pNewIndex);
}


Lib3MFResult CCall_lib3mf_meshobject_getvertices(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, const Lib3MF_uint64 nVerticesBufferSize, Lib3MF_uint64* pVerticesNeededCount, sLib3MFPosition * pVerticesBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_GetVertices (pMeshObject, nVerticesBufferSize, pVerticesNeededCount, pVerticesBuffer);
}


Lib3MFResult CCall_lib3mf_meshobject_gettriangle(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, sLib3MFTriangle * pIndices)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_GetTriangle (pMeshObject, nIndex, pIndices);
}


Lib3MFResult CCall_lib3mf_meshobject_settriangle(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, const sLib3MFTriangle * pIndices)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_SetTriangle (pMeshObject, nIndex, pIndices);
}


Lib3MFResult CCall_lib3mf_meshobject_addtriangle(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, const sLib3MFTriangle * pIndices, Lib3MF_uint32 * pNewIndex)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_AddTriangle (pMeshObject, pIndices, pNewIndex);
}


Lib3MFResult CCall_lib3mf_meshobject_gettriangleindices(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, const Lib3MF_uint64 nIndicesBufferSize, Lib3MF_uint64* pIndicesNeededCount, sLib3MFTriangle * pIndicesBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_GetTriangleIndices (pMeshObject, nIndicesBufferSize, pIndicesNeededCount, pIndicesBuffer);
}


Lib3MFResult CCall_lib3mf_meshobject_setobjectlevelproperty(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nUniqueResourceID, Lib3MF_uint32 nPropertyID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_SetObjectLevelProperty (pMeshObject, nUniqueResourceID, nPropertyID);
}


Lib3MFResult CCall_lib3mf_meshobject_getobjectlevelproperty(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 * pUniqueResourceID, Lib3MF_uint32 * pPropertyID, bool * pHasObjectLevelProperty)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_GetObjectLevelProperty (pMeshObject, pUniqueResourceID, pPropertyID, pHasObjectLevelProperty);
}


Lib3MFResult CCall_lib3mf_meshobject_settriangleproperties(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, const sLib3MFTriangleProperties * pProperties)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_SetTriangleProperties (pMeshObject, nIndex, pProperties);
}


Lib3MFResult CCall_lib3mf_meshobject_gettriangleproperties(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, sLib3MFTriangleProperties * pProperty)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_GetTriangleProperties (pMeshObject, nIndex, pProperty);
}


Lib3MFResult CCall_lib3mf_meshobject_setalltriangleproperties(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, Lib3MF_uint64 nPropertiesArrayBufferSize, const sLib3MFTriangleProperties * pPropertiesArrayBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_SetAllTriangleProperties (pMeshObject, nPropertiesArrayBufferSize, pPropertiesArrayBuffer);
}


Lib3MFResult CCall_lib3mf_meshobject_getalltriangleproperties(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, const Lib3MF_uint64 nPropertiesArrayBufferSize, Lib3MF_uint64* pPropertiesArrayNeededCount, sLib3MFTriangleProperties * pPropertiesArrayBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_GetAllTriangleProperties (pMeshObject, nPropertiesArrayBufferSize, pPropertiesArrayNeededCount, pPropertiesArrayBuffer);
}


Lib3MFResult CCall_lib3mf_meshobject_clearallproperties(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_ClearAllProperties (pMeshObject);
}


Lib3MFResult CCall_lib3mf_meshobject_setgeometry(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, Lib3MF_uint64 nVerticesBufferSize, const sLib3MFPosition * pVerticesBuffer, Lib3MF_uint64 nIndicesBufferSize, const sLib3MFTriangle * pIndicesBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_SetGeometry (pMeshObject, nVerticesBufferSize, pVerticesBuffer, nIndicesBufferSize, pIndicesBuffer);
}


Lib3MFResult CCall_lib3mf_meshobject_ismanifoldandoriented(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, bool * pIsManifoldAndOriented)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_IsManifoldAndOriented (pMeshObject, pIsManifoldAndOriented);
}


Lib3MFResult CCall_lib3mf_meshobject_beamlattice(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, Lib3MF_BeamLattice * pTheBeamLattice)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_BeamLattice (pMeshObject, pTheBeamLattice);
}


Lib3MFResult CCall_lib3mf_meshobject_getvolumedata(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, Lib3MF_VolumeData * pTheVolumeData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_GetVolumeData (pMeshObject, pTheVolumeData);
}


Lib3MFResult CCall_lib3mf_meshobject_setvolumedata(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, Lib3MF_VolumeData pTheVolumeData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_SetVolumeData (pMeshObject, pTheVolumeData);
}


Lib3MFResult CCall_lib3mf_meshobject_addtriangleset(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, const char * pIdentifier, const char * pName, Lib3MF_TriangleSet * pTheTriangleSet)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_AddTriangleSet (pMeshObject, pIdentifier, pName, pTheTriangleSet);
}


Lib3MFResult CCall_lib3mf_meshobject_hastriangleset(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, const char * pIdentifier, bool * pTriangleSetExists)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_HasTriangleSet (pMeshObject, pIdentifier, pTriangleSetExists);
}


Lib3MFResult CCall_lib3mf_meshobject_findtriangleset(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, const char * pIdentifier, Lib3MF_TriangleSet * pTheTriangleSet)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_FindTriangleSet (pMeshObject, pIdentifier, pTheTriangleSet);
}


Lib3MFResult CCall_lib3mf_meshobject_gettrianglesetcount(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_GetTriangleSetCount (pMeshObject, pCount);
}


Lib3MFResult CCall_lib3mf_meshobject_gettriangleset(Lib3MFHandle libraryHandle, Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, Lib3MF_TriangleSet * pTheTriangleSet)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshObject_GetTriangleSet (pMeshObject, nIndex, pTheTriangleSet);
}


Lib3MFResult CCall_lib3mf_levelset_getfunction(Lib3MFHandle libraryHandle, Lib3MF_LevelSet pLevelSet, Lib3MF_Function * pTheFunction)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_LevelSet_GetFunction (pLevelSet, pTheFunction);
}


Lib3MFResult CCall_lib3mf_levelset_setfunction(Lib3MFHandle libraryHandle, Lib3MF_LevelSet pLevelSet, Lib3MF_Function pTheFunction)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_LevelSet_SetFunction (pLevelSet, pTheFunction);
}


Lib3MFResult CCall_lib3mf_levelset_gettransform(Lib3MFHandle libraryHandle, Lib3MF_LevelSet pLevelSet, sLib3MFTransform * pTransform)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_LevelSet_GetTransform (pLevelSet, pTransform);
}


Lib3MFResult CCall_lib3mf_levelset_settransform(Lib3MFHandle libraryHandle, Lib3MF_LevelSet pLevelSet, const sLib3MFTransform * pTransform)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_LevelSet_SetTransform (pLevelSet, pTransform);
}


Lib3MFResult CCall_lib3mf_levelset_getchannelname(Lib3MFHandle libraryHandle, Lib3MF_LevelSet pLevelSet, const Lib3MF_uint32 nChannelNameBufferSize, Lib3MF_uint32* pChannelNameNeededChars, char * pChannelNameBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_LevelSet_GetChannelName (pLevelSet, nChannelNameBufferSize, pChannelNameNeededChars, pChannelNameBuffer);
}


Lib3MFResult CCall_lib3mf_levelset_setchannelname(Lib3MFHandle libraryHandle, Lib3MF_LevelSet pLevelSet, const char * pChannelName)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_LevelSet_SetChannelName (pLevelSet, pChannelName);
}


Lib3MFResult CCall_lib3mf_levelset_setminfeaturesize(Lib3MFHandle libraryHandle, Lib3MF_LevelSet pLevelSet, Lib3MF_double dMinFeatureSize)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_LevelSet_SetMinFeatureSize (pLevelSet, dMinFeatureSize);
}


Lib3MFResult CCall_lib3mf_levelset_getminfeaturesize(Lib3MFHandle libraryHandle, Lib3MF_LevelSet pLevelSet, Lib3MF_double * pMinFeatureSize)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_LevelSet_GetMinFeatureSize (pLevelSet, pMinFeatureSize);
}


Lib3MFResult CCall_lib3mf_levelset_setfallbackvalue(Lib3MFHandle libraryHandle, Lib3MF_LevelSet pLevelSet, Lib3MF_double dFallBackValue)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_LevelSet_SetFallBackValue (pLevelSet, dFallBackValue);
}


Lib3MFResult CCall_lib3mf_levelset_getfallbackvalue(Lib3MFHandle libraryHandle, Lib3MF_LevelSet pLevelSet, Lib3MF_double * pFallBackValue)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_LevelSet_GetFallBackValue (pLevelSet, pFallBackValue);
}


Lib3MFResult CCall_lib3mf_levelset_setmeshbboxonly(Lib3MFHandle libraryHandle, Lib3MF_LevelSet pLevelSet, bool bMeshBBoxOnly)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_LevelSet_SetMeshBBoxOnly (pLevelSet, bMeshBBoxOnly);
}


Lib3MFResult CCall_lib3mf_levelset_getmeshbboxonly(Lib3MFHandle libraryHandle, Lib3MF_LevelSet pLevelSet, bool * pMeshBBoxOnly)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_LevelSet_GetMeshBBoxOnly (pLevelSet, pMeshBBoxOnly);
}


Lib3MFResult CCall_lib3mf_levelset_setmesh(Lib3MFHandle libraryHandle, Lib3MF_LevelSet pLevelSet, Lib3MF_MeshObject pTheMesh)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_LevelSet_SetMesh (pLevelSet, pTheMesh);
}


Lib3MFResult CCall_lib3mf_levelset_getmesh(Lib3MFHandle libraryHandle, Lib3MF_LevelSet pLevelSet, Lib3MF_MeshObject * pTheMesh)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_LevelSet_GetMesh (pLevelSet, pTheMesh);
}


Lib3MFResult CCall_lib3mf_levelset_getvolumedata(Lib3MFHandle libraryHandle, Lib3MF_LevelSet pLevelSet, Lib3MF_VolumeData * pTheVolumeData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_LevelSet_GetVolumeData (pLevelSet, pTheVolumeData);
}


Lib3MFResult CCall_lib3mf_levelset_setvolumedata(Lib3MFHandle libraryHandle, Lib3MF_LevelSet pLevelSet, Lib3MF_VolumeData pTheVolumeData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_LevelSet_SetVolumeData (pLevelSet, pTheVolumeData);
}


Lib3MFResult CCall_lib3mf_beamlattice_getminlength(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, Lib3MF_double * pMinLength)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_GetMinLength (pBeamLattice, pMinLength);
}


Lib3MFResult CCall_lib3mf_beamlattice_setminlength(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, Lib3MF_double dMinLength)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_SetMinLength (pBeamLattice, dMinLength);
}


Lib3MFResult CCall_lib3mf_beamlattice_getclipping(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, eLib3MFBeamLatticeClipMode * pClipMode, Lib3MF_uint32 * pUniqueResourceID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_GetClipping (pBeamLattice, pClipMode, pUniqueResourceID);
}


Lib3MFResult CCall_lib3mf_beamlattice_setclipping(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, eLib3MFBeamLatticeClipMode eClipMode, Lib3MF_uint32 nUniqueResourceID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_SetClipping (pBeamLattice, eClipMode, nUniqueResourceID);
}


Lib3MFResult CCall_lib3mf_beamlattice_getrepresentation(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, bool * pHasRepresentation, Lib3MF_uint32 * pUniqueResourceID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_GetRepresentation (pBeamLattice, pHasRepresentation, pUniqueResourceID);
}


Lib3MFResult CCall_lib3mf_beamlattice_setrepresentation(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nUniqueResourceID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_SetRepresentation (pBeamLattice, nUniqueResourceID);
}


Lib3MFResult CCall_lib3mf_beamlattice_getballoptions(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, eLib3MFBeamLatticeBallMode * pBallMode, Lib3MF_double * pBallRadius)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_GetBallOptions (pBeamLattice, pBallMode, pBallRadius);
}


Lib3MFResult CCall_lib3mf_beamlattice_setballoptions(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, eLib3MFBeamLatticeBallMode eBallMode, Lib3MF_double dBallRadius)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_SetBallOptions (pBeamLattice, eBallMode, dBallRadius);
}


Lib3MFResult CCall_lib3mf_beamlattice_getbeamcount(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_GetBeamCount (pBeamLattice, pCount);
}


Lib3MFResult CCall_lib3mf_beamlattice_getbeam(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nIndex, sLib3MFBeam * pBeamInfo)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_GetBeam (pBeamLattice, nIndex, pBeamInfo);
}


Lib3MFResult CCall_lib3mf_beamlattice_addbeam(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, const sLib3MFBeam * pBeamInfo, Lib3MF_uint32 * pIndex)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_AddBeam (pBeamLattice, pBeamInfo, pIndex);
}


Lib3MFResult CCall_lib3mf_beamlattice_setbeam(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nIndex, const sLib3MFBeam * pBeamInfo)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_SetBeam (pBeamLattice, nIndex, pBeamInfo);
}


Lib3MFResult CCall_lib3mf_beamlattice_setbeams(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint64 nBeamInfoBufferSize, const sLib3MFBeam * pBeamInfoBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_SetBeams (pBeamLattice, nBeamInfoBufferSize, pBeamInfoBuffer);
}


Lib3MFResult CCall_lib3mf_beamlattice_getbeams(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, const Lib3MF_uint64 nBeamInfoBufferSize, Lib3MF_uint64* pBeamInfoNeededCount, sLib3MFBeam * pBeamInfoBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_GetBeams (pBeamLattice, nBeamInfoBufferSize, pBeamInfoNeededCount, pBeamInfoBuffer);
}


Lib3MFResult CCall_lib3mf_beamlattice_getballcount(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_GetBallCount (pBeamLattice, pCount);
}


Lib3MFResult CCall_lib3mf_beamlattice_getball(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nIndex, sLib3MFBall * pBallInfo)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_GetBall (pBeamLattice, nIndex, pBallInfo);
}


Lib3MFResult CCall_lib3mf_beamlattice_addball(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, const sLib3MFBall * pBallInfo, Lib3MF_uint32 * pIndex)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_AddBall (pBeamLattice, pBallInfo, pIndex);
}


Lib3MFResult CCall_lib3mf_beamlattice_setball(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nIndex, const sLib3MFBall * pBallInfo)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_SetBall (pBeamLattice, nIndex, pBallInfo);
}


Lib3MFResult CCall_lib3mf_beamlattice_setballs(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint64 nBallInfoBufferSize, const sLib3MFBall * pBallInfoBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_SetBalls (pBeamLattice, nBallInfoBufferSize, pBallInfoBuffer);
}


Lib3MFResult CCall_lib3mf_beamlattice_getballs(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, const Lib3MF_uint64 nBallInfoBufferSize, Lib3MF_uint64* pBallInfoNeededCount, sLib3MFBall * pBallInfoBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_GetBalls (pBeamLattice, nBallInfoBufferSize, pBallInfoNeededCount, pBallInfoBuffer);
}


Lib3MFResult CCall_lib3mf_beamlattice_getbeamsetcount(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_GetBeamSetCount (pBeamLattice, pCount);
}


Lib3MFResult CCall_lib3mf_beamlattice_addbeamset(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, Lib3MF_BeamSet * pBeamSet)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_AddBeamSet (pBeamLattice, pBeamSet);
}


Lib3MFResult CCall_lib3mf_beamlattice_getbeamset(Lib3MFHandle libraryHandle, Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nIndex, Lib3MF_BeamSet * pBeamSet)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLattice_GetBeamSet (pBeamLattice, nIndex, pBeamSet);
}


Lib3MFResult CCall_lib3mf_functionreference_getfunctionresourceid(Lib3MFHandle libraryHandle, Lib3MF_FunctionReference pFunctionReference, Lib3MF_uint32 * pUniqueResourceID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_FunctionReference_GetFunctionResourceID (pFunctionReference, pUniqueResourceID);
}


Lib3MFResult CCall_lib3mf_functionreference_setfunctionresourceid(Lib3MFHandle libraryHandle, Lib3MF_FunctionReference pFunctionReference, Lib3MF_uint32 nUniqueResourceID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_FunctionReference_SetFunctionResourceID (pFunctionReference, nUniqueResourceID);
}


Lib3MFResult CCall_lib3mf_functionreference_gettransform(Lib3MFHandle libraryHandle, Lib3MF_FunctionReference pFunctionReference, sLib3MFTransform * pTransform)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_FunctionReference_GetTransform (pFunctionReference, pTransform);
}


Lib3MFResult CCall_lib3mf_functionreference_settransform(Lib3MFHandle libraryHandle, Lib3MF_FunctionReference pFunctionReference, const sLib3MFTransform * pTransform)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_FunctionReference_SetTransform (pFunctionReference, pTransform);
}


Lib3MFResult CCall_lib3mf_functionreference_getchannelname(Lib3MFHandle libraryHandle, Lib3MF_FunctionReference pFunctionReference, const Lib3MF_uint32 nChannelNameBufferSize, Lib3MF_uint32* pChannelNameNeededChars, char * pChannelNameBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_FunctionReference_GetChannelName (pFunctionReference, nChannelNameBufferSize, pChannelNameNeededChars, pChannelNameBuffer);
}


Lib3MFResult CCall_lib3mf_functionreference_setchannelname(Lib3MFHandle libraryHandle, Lib3MF_FunctionReference pFunctionReference, const char * pChannelName)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_FunctionReference_SetChannelName (pFunctionReference, pChannelName);
}


Lib3MFResult CCall_lib3mf_functionreference_setminfeaturesize(Lib3MFHandle libraryHandle, Lib3MF_FunctionReference pFunctionReference, Lib3MF_double dMinFeatureSize)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_FunctionReference_SetMinFeatureSize (pFunctionReference, dMinFeatureSize);
}


Lib3MFResult CCall_lib3mf_functionreference_getminfeaturesize(Lib3MFHandle libraryHandle, Lib3MF_FunctionReference pFunctionReference, Lib3MF_double * pMinFeatureSize)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_FunctionReference_GetMinFeatureSize (pFunctionReference, pMinFeatureSize);
}


Lib3MFResult CCall_lib3mf_functionreference_setfallbackvalue(Lib3MFHandle libraryHandle, Lib3MF_FunctionReference pFunctionReference, Lib3MF_double dFallBackValue)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_FunctionReference_SetFallBackValue (pFunctionReference, dFallBackValue);
}


Lib3MFResult CCall_lib3mf_functionreference_getfallbackvalue(Lib3MFHandle libraryHandle, Lib3MF_FunctionReference pFunctionReference, Lib3MF_double * pFallBackValue)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_FunctionReference_GetFallBackValue (pFunctionReference, pFallBackValue);
}


Lib3MFResult CCall_lib3mf_volumedatacomposite_getbasematerialgroup(Lib3MFHandle libraryHandle, Lib3MF_VolumeDataComposite pVolumeDataComposite, Lib3MF_BaseMaterialGroup * pBaseMaterialGroupInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_VolumeDataComposite_GetBaseMaterialGroup (pVolumeDataComposite, pBaseMaterialGroupInstance);
}


Lib3MFResult CCall_lib3mf_volumedatacomposite_setbasematerialgroup(Lib3MFHandle libraryHandle, Lib3MF_VolumeDataComposite pVolumeDataComposite, Lib3MF_BaseMaterialGroup pBaseMaterialGroupInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_VolumeDataComposite_SetBaseMaterialGroup (pVolumeDataComposite, pBaseMaterialGroupInstance);
}


Lib3MFResult CCall_lib3mf_volumedatacomposite_getmaterialmappingcount(Lib3MFHandle libraryHandle, Lib3MF_VolumeDataComposite pVolumeDataComposite, Lib3MF_uint32 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_VolumeDataComposite_GetMaterialMappingCount (pVolumeDataComposite, pCount);
}


Lib3MFResult CCall_lib3mf_volumedatacomposite_getmaterialmapping(Lib3MFHandle libraryHandle, Lib3MF_VolumeDataComposite pVolumeDataComposite, Lib3MF_uint32 nIndex, Lib3MF_MaterialMapping * pTheMaterialMapping)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_VolumeDataComposite_GetMaterialMapping (pVolumeDataComposite, nIndex, pTheMaterialMapping);
}


Lib3MFResult CCall_lib3mf_volumedatacomposite_addmaterialmapping(Lib3MFHandle libraryHandle, Lib3MF_VolumeDataComposite pVolumeDataComposite, const sLib3MFTransform * pTransform, Lib3MF_MaterialMapping * pTheMaterialMapping)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_VolumeDataComposite_AddMaterialMapping (pVolumeDataComposite, pTransform, pTheMaterialMapping);
}


Lib3MFResult CCall_lib3mf_volumedatacomposite_removematerialmapping(Lib3MFHandle libraryHandle, Lib3MF_VolumeDataComposite pVolumeDataComposite, Lib3MF_uint32 nIndex)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_VolumeDataComposite_RemoveMaterialMapping (pVolumeDataComposite, nIndex);
}


Lib3MFResult CCall_lib3mf_volumedataproperty_getname(Lib3MFHandle libraryHandle, Lib3MF_VolumeDataProperty pVolumeDataProperty, const Lib3MF_uint32 nPropertyNameBufferSize, Lib3MF_uint32* pPropertyNameNeededChars, char * pPropertyNameBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_VolumeDataProperty_GetName (pVolumeDataProperty, nPropertyNameBufferSize, pPropertyNameNeededChars, pPropertyNameBuffer);
}


Lib3MFResult CCall_lib3mf_volumedataproperty_setisrequired(Lib3MFHandle libraryHandle, Lib3MF_VolumeDataProperty pVolumeDataProperty, bool bIsRequired)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_VolumeDataProperty_SetIsRequired (pVolumeDataProperty, bIsRequired);
}


Lib3MFResult CCall_lib3mf_volumedataproperty_isrequired(Lib3MFHandle libraryHandle, Lib3MF_VolumeDataProperty pVolumeDataProperty, bool * pIsRequired)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_VolumeDataProperty_IsRequired (pVolumeDataProperty, pIsRequired);
}


Lib3MFResult CCall_lib3mf_volumedata_getcomposite(Lib3MFHandle libraryHandle, Lib3MF_VolumeData pVolumeData, Lib3MF_VolumeDataComposite * pTheCompositeData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_VolumeData_GetComposite (pVolumeData, pTheCompositeData);
}


Lib3MFResult CCall_lib3mf_volumedata_createnewcomposite(Lib3MFHandle libraryHandle, Lib3MF_VolumeData pVolumeData, Lib3MF_VolumeDataComposite * pTheCompositeData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_VolumeData_CreateNewComposite (pVolumeData, pTheCompositeData);
}


Lib3MFResult CCall_lib3mf_volumedata_removecomposite(Lib3MFHandle libraryHandle, Lib3MF_VolumeData pVolumeData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_VolumeData_RemoveComposite (pVolumeData);
}


Lib3MFResult CCall_lib3mf_volumedata_getcolor(Lib3MFHandle libraryHandle, Lib3MF_VolumeData pVolumeData, Lib3MF_VolumeDataColor * pTheColorData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_VolumeData_GetColor (pVolumeData, pTheColorData);
}


Lib3MFResult CCall_lib3mf_volumedata_createnewcolor(Lib3MFHandle libraryHandle, Lib3MF_VolumeData pVolumeData, Lib3MF_Function pTheFunction, Lib3MF_VolumeDataColor * pTheColorData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_VolumeData_CreateNewColor (pVolumeData, pTheFunction, pTheColorData);
}


Lib3MFResult CCall_lib3mf_volumedata_removecolor(Lib3MFHandle libraryHandle, Lib3MF_VolumeData pVolumeData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_VolumeData_RemoveColor (pVolumeData);
}


Lib3MFResult CCall_lib3mf_volumedata_getpropertycount(Lib3MFHandle libraryHandle, Lib3MF_VolumeData pVolumeData, Lib3MF_uint32 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_VolumeData_GetPropertyCount (pVolumeData, pCount);
}


Lib3MFResult CCall_lib3mf_volumedata_getproperty(Lib3MFHandle libraryHandle, Lib3MF_VolumeData pVolumeData, Lib3MF_uint32 nIndex, Lib3MF_VolumeDataProperty * pTheVolumeDataProperty)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_VolumeData_GetProperty (pVolumeData, nIndex, pTheVolumeDataProperty);
}


Lib3MFResult CCall_lib3mf_volumedata_addpropertyfromfunction(Lib3MFHandle libraryHandle, Lib3MF_VolumeData pVolumeData, const char * pName, Lib3MF_Function pTheFunction, Lib3MF_VolumeDataProperty * pTheVolumeDataProperty)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_VolumeData_AddPropertyFromFunction (pVolumeData, pName, pTheFunction, pTheVolumeDataProperty);
}


Lib3MFResult CCall_lib3mf_volumedata_removeproperty(Lib3MFHandle libraryHandle, Lib3MF_VolumeData pVolumeData, Lib3MF_uint32 nIndex)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_VolumeData_RemoveProperty (pVolumeData, nIndex);
}


Lib3MFResult CCall_lib3mf_component_getobjectresource(Lib3MFHandle libraryHandle, Lib3MF_Component pComponent, Lib3MF_Object * pObjectResource)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Component_GetObjectResource (pComponent, pObjectResource);
}


Lib3MFResult CCall_lib3mf_component_getobjectresourceid(Lib3MFHandle libraryHandle, Lib3MF_Component pComponent, Lib3MF_uint32 * pUniqueResourceID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Component_GetObjectResourceID (pComponent, pUniqueResourceID);
}


Lib3MFResult CCall_lib3mf_component_getuuid(Lib3MFHandle libraryHandle, Lib3MF_Component pComponent, bool * pHasUUID, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Component_GetUUID (pComponent, pHasUUID, nUUIDBufferSize, pUUIDNeededChars, pUUIDBuffer);
}


Lib3MFResult CCall_lib3mf_component_setuuid(Lib3MFHandle libraryHandle, Lib3MF_Component pComponent, const char * pUUID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Component_SetUUID (pComponent, pUUID);
}


Lib3MFResult CCall_lib3mf_component_hastransform(Lib3MFHandle libraryHandle, Lib3MF_Component pComponent, bool * pHasTransform)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Component_HasTransform (pComponent, pHasTransform);
}


Lib3MFResult CCall_lib3mf_component_gettransform(Lib3MFHandle libraryHandle, Lib3MF_Component pComponent, sLib3MFTransform * pTransform)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Component_GetTransform (pComponent, pTransform);
}


Lib3MFResult CCall_lib3mf_component_settransform(Lib3MFHandle libraryHandle, Lib3MF_Component pComponent, const sLib3MFTransform * pTransform)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Component_SetTransform (pComponent, pTransform);
}


Lib3MFResult CCall_lib3mf_componentsobject_addcomponent(Lib3MFHandle libraryHandle, Lib3MF_ComponentsObject pComponentsObject, Lib3MF_Object pObjectResource, const sLib3MFTransform * pTransform, Lib3MF_Component * pComponentInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ComponentsObject_AddComponent (pComponentsObject, pObjectResource, pTransform, pComponentInstance);
}


Lib3MFResult CCall_lib3mf_componentsobject_getcomponent(Lib3MFHandle libraryHandle, Lib3MF_ComponentsObject pComponentsObject, Lib3MF_uint32 nIndex, Lib3MF_Component * pComponentInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ComponentsObject_GetComponent (pComponentsObject, nIndex, pComponentInstance);
}


Lib3MFResult CCall_lib3mf_componentsobject_getcomponentcount(Lib3MFHandle libraryHandle, Lib3MF_ComponentsObject pComponentsObject, Lib3MF_uint32 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ComponentsObject_GetComponentCount (pComponentsObject, pCount);
}


Lib3MFResult CCall_lib3mf_beamset_setname(Lib3MFHandle libraryHandle, Lib3MF_BeamSet pBeamSet, const char * pName)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamSet_SetName (pBeamSet, pName);
}


Lib3MFResult CCall_lib3mf_beamset_getname(Lib3MFHandle libraryHandle, Lib3MF_BeamSet pBeamSet, const Lib3MF_uint32 nNameBufferSize, Lib3MF_uint32* pNameNeededChars, char * pNameBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamSet_GetName (pBeamSet, nNameBufferSize, pNameNeededChars, pNameBuffer);
}


Lib3MFResult CCall_lib3mf_beamset_setidentifier(Lib3MFHandle libraryHandle, Lib3MF_BeamSet pBeamSet, const char * pIdentifier)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamSet_SetIdentifier (pBeamSet, pIdentifier);
}


Lib3MFResult CCall_lib3mf_beamset_getidentifier(Lib3MFHandle libraryHandle, Lib3MF_BeamSet pBeamSet, const Lib3MF_uint32 nIdentifierBufferSize, Lib3MF_uint32* pIdentifierNeededChars, char * pIdentifierBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamSet_GetIdentifier (pBeamSet, nIdentifierBufferSize, pIdentifierNeededChars, pIdentifierBuffer);
}


Lib3MFResult CCall_lib3mf_beamset_getreferencecount(Lib3MFHandle libraryHandle, Lib3MF_BeamSet pBeamSet, Lib3MF_uint32 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamSet_GetReferenceCount (pBeamSet, pCount);
}


Lib3MFResult CCall_lib3mf_beamset_setreferences(Lib3MFHandle libraryHandle, Lib3MF_BeamSet pBeamSet, Lib3MF_uint64 nReferencesBufferSize, const Lib3MF_uint32 * pReferencesBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamSet_SetReferences (pBeamSet, nReferencesBufferSize, pReferencesBuffer);
}


Lib3MFResult CCall_lib3mf_beamset_getreferences(Lib3MFHandle libraryHandle, Lib3MF_BeamSet pBeamSet, const Lib3MF_uint64 nReferencesBufferSize, Lib3MF_uint64* pReferencesNeededCount, Lib3MF_uint32 * pReferencesBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamSet_GetReferences (pBeamSet, nReferencesBufferSize, pReferencesNeededCount, pReferencesBuffer);
}


Lib3MFResult CCall_lib3mf_beamset_getballreferencecount(Lib3MFHandle libraryHandle, Lib3MF_BeamSet pBeamSet, Lib3MF_uint32 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamSet_GetBallReferenceCount (pBeamSet, pCount);
}


Lib3MFResult CCall_lib3mf_beamset_setballreferences(Lib3MFHandle libraryHandle, Lib3MF_BeamSet pBeamSet, Lib3MF_uint64 nBallReferencesBufferSize, const Lib3MF_uint32 * pBallReferencesBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamSet_SetBallReferences (pBeamSet, nBallReferencesBufferSize, pBallReferencesBuffer);
}


Lib3MFResult CCall_lib3mf_beamset_getballreferences(Lib3MFHandle libraryHandle, Lib3MF_BeamSet pBeamSet, const Lib3MF_uint64 nBallReferencesBufferSize, Lib3MF_uint64* pBallReferencesNeededCount, Lib3MF_uint32 * pBallReferencesBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamSet_GetBallReferences (pBeamSet, nBallReferencesBufferSize, pBallReferencesNeededCount, pBallReferencesBuffer);
}


Lib3MFResult CCall_lib3mf_basematerialgroup_getcount(Lib3MFHandle libraryHandle, Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BaseMaterialGroup_GetCount (pBaseMaterialGroup, pCount);
}


Lib3MFResult CCall_lib3mf_basematerialgroup_getallpropertyids(Lib3MFHandle libraryHandle, Lib3MF_BaseMaterialGroup pBaseMaterialGroup, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BaseMaterialGroup_GetAllPropertyIDs (pBaseMaterialGroup, nPropertyIDsBufferSize, pPropertyIDsNeededCount, pPropertyIDsBuffer);
}


Lib3MFResult CCall_lib3mf_basematerialgroup_addmaterial(Lib3MFHandle libraryHandle, Lib3MF_BaseMaterialGroup pBaseMaterialGroup, const char * pName, const sLib3MFColor * pDisplayColor, Lib3MF_uint32 * pPropertyID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BaseMaterialGroup_AddMaterial (pBaseMaterialGroup, pName, pDisplayColor, pPropertyID);
}


Lib3MFResult CCall_lib3mf_basematerialgroup_removematerial(Lib3MFHandle libraryHandle, Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 nPropertyID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BaseMaterialGroup_RemoveMaterial (pBaseMaterialGroup, nPropertyID);
}


Lib3MFResult CCall_lib3mf_basematerialgroup_getname(Lib3MFHandle libraryHandle, Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 nPropertyID, const Lib3MF_uint32 nNameBufferSize, Lib3MF_uint32* pNameNeededChars, char * pNameBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BaseMaterialGroup_GetName (pBaseMaterialGroup, nPropertyID, nNameBufferSize, pNameNeededChars, pNameBuffer);
}


Lib3MFResult CCall_lib3mf_basematerialgroup_setname(Lib3MFHandle libraryHandle, Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 nPropertyID, const char * pName)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BaseMaterialGroup_SetName (pBaseMaterialGroup, nPropertyID, pName);
}


Lib3MFResult CCall_lib3mf_basematerialgroup_setdisplaycolor(Lib3MFHandle libraryHandle, Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 nPropertyID, const sLib3MFColor * pTheColor)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BaseMaterialGroup_SetDisplayColor (pBaseMaterialGroup, nPropertyID, pTheColor);
}


Lib3MFResult CCall_lib3mf_basematerialgroup_getdisplaycolor(Lib3MFHandle libraryHandle, Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 nPropertyID, sLib3MFColor * pTheColor)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BaseMaterialGroup_GetDisplayColor (pBaseMaterialGroup, nPropertyID, pTheColor);
}


Lib3MFResult CCall_lib3mf_colorgroup_getcount(Lib3MFHandle libraryHandle, Lib3MF_ColorGroup pColorGroup, Lib3MF_uint32 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ColorGroup_GetCount (pColorGroup, pCount);
}


Lib3MFResult CCall_lib3mf_colorgroup_getallpropertyids(Lib3MFHandle libraryHandle, Lib3MF_ColorGroup pColorGroup, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ColorGroup_GetAllPropertyIDs (pColorGroup, nPropertyIDsBufferSize, pPropertyIDsNeededCount, pPropertyIDsBuffer);
}


Lib3MFResult CCall_lib3mf_colorgroup_addcolor(Lib3MFHandle libraryHandle, Lib3MF_ColorGroup pColorGroup, const sLib3MFColor * pTheColor, Lib3MF_uint32 * pPropertyID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ColorGroup_AddColor (pColorGroup, pTheColor, pPropertyID);
}


Lib3MFResult CCall_lib3mf_colorgroup_removecolor(Lib3MFHandle libraryHandle, Lib3MF_ColorGroup pColorGroup, Lib3MF_uint32 nPropertyID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ColorGroup_RemoveColor (pColorGroup, nPropertyID);
}


Lib3MFResult CCall_lib3mf_colorgroup_setcolor(Lib3MFHandle libraryHandle, Lib3MF_ColorGroup pColorGroup, Lib3MF_uint32 nPropertyID, const sLib3MFColor * pTheColor)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ColorGroup_SetColor (pColorGroup, nPropertyID, pTheColor);
}


Lib3MFResult CCall_lib3mf_colorgroup_getcolor(Lib3MFHandle libraryHandle, Lib3MF_ColorGroup pColorGroup, Lib3MF_uint32 nPropertyID, sLib3MFColor * pTheColor)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ColorGroup_GetColor (pColorGroup, nPropertyID, pTheColor);
}


Lib3MFResult CCall_lib3mf_texture2dgroup_getcount(Lib3MFHandle libraryHandle, Lib3MF_Texture2DGroup pTexture2DGroup, Lib3MF_uint32 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Texture2DGroup_GetCount (pTexture2DGroup, pCount);
}


Lib3MFResult CCall_lib3mf_texture2dgroup_getallpropertyids(Lib3MFHandle libraryHandle, Lib3MF_Texture2DGroup pTexture2DGroup, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Texture2DGroup_GetAllPropertyIDs (pTexture2DGroup, nPropertyIDsBufferSize, pPropertyIDsNeededCount, pPropertyIDsBuffer);
}


Lib3MFResult CCall_lib3mf_texture2dgroup_addtex2coord(Lib3MFHandle libraryHandle, Lib3MF_Texture2DGroup pTexture2DGroup, const sLib3MFTex2Coord * pUVCoordinate, Lib3MF_uint32 * pPropertyID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Texture2DGroup_AddTex2Coord (pTexture2DGroup, pUVCoordinate, pPropertyID);
}


Lib3MFResult CCall_lib3mf_texture2dgroup_gettex2coord(Lib3MFHandle libraryHandle, Lib3MF_Texture2DGroup pTexture2DGroup, Lib3MF_uint32 nPropertyID, sLib3MFTex2Coord * pUVCoordinate)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Texture2DGroup_GetTex2Coord (pTexture2DGroup, nPropertyID, pUVCoordinate);
}


Lib3MFResult CCall_lib3mf_texture2dgroup_removetex2coord(Lib3MFHandle libraryHandle, Lib3MF_Texture2DGroup pTexture2DGroup, Lib3MF_uint32 nPropertyID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Texture2DGroup_RemoveTex2Coord (pTexture2DGroup, nPropertyID);
}


Lib3MFResult CCall_lib3mf_texture2dgroup_gettexture2d(Lib3MFHandle libraryHandle, Lib3MF_Texture2DGroup pTexture2DGroup, Lib3MF_Texture2D * pTexture2DInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Texture2DGroup_GetTexture2D (pTexture2DGroup, pTexture2DInstance);
}


Lib3MFResult CCall_lib3mf_compositematerials_getcount(Lib3MFHandle libraryHandle, Lib3MF_CompositeMaterials pCompositeMaterials, Lib3MF_uint32 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_CompositeMaterials_GetCount (pCompositeMaterials, pCount);
}


Lib3MFResult CCall_lib3mf_compositematerials_getallpropertyids(Lib3MFHandle libraryHandle, Lib3MF_CompositeMaterials pCompositeMaterials, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_CompositeMaterials_GetAllPropertyIDs (pCompositeMaterials, nPropertyIDsBufferSize, pPropertyIDsNeededCount, pPropertyIDsBuffer);
}


Lib3MFResult CCall_lib3mf_compositematerials_getbasematerialgroup(Lib3MFHandle libraryHandle, Lib3MF_CompositeMaterials pCompositeMaterials, Lib3MF_BaseMaterialGroup * pBaseMaterialGroupInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_CompositeMaterials_GetBaseMaterialGroup (pCompositeMaterials, pBaseMaterialGroupInstance);
}


Lib3MFResult CCall_lib3mf_compositematerials_addcomposite(Lib3MFHandle libraryHandle, Lib3MF_CompositeMaterials pCompositeMaterials, Lib3MF_uint64 nCompositeBufferSize, const sLib3MFCompositeConstituent * pCompositeBuffer, Lib3MF_uint32 * pPropertyID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_CompositeMaterials_AddComposite (pCompositeMaterials, nCompositeBufferSize, pCompositeBuffer, pPropertyID);
}


Lib3MFResult CCall_lib3mf_compositematerials_removecomposite(Lib3MFHandle libraryHandle, Lib3MF_CompositeMaterials pCompositeMaterials, Lib3MF_uint32 nPropertyID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_CompositeMaterials_RemoveComposite (pCompositeMaterials, nPropertyID);
}


Lib3MFResult CCall_lib3mf_compositematerials_getcomposite(Lib3MFHandle libraryHandle, Lib3MF_CompositeMaterials pCompositeMaterials, Lib3MF_uint32 nPropertyID, const Lib3MF_uint64 nCompositeBufferSize, Lib3MF_uint64* pCompositeNeededCount, sLib3MFCompositeConstituent * pCompositeBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_CompositeMaterials_GetComposite (pCompositeMaterials, nPropertyID, nCompositeBufferSize, pCompositeNeededCount, pCompositeBuffer);
}


Lib3MFResult CCall_lib3mf_multipropertygroup_getcount(Lib3MFHandle libraryHandle, Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MultiPropertyGroup_GetCount (pMultiPropertyGroup, pCount);
}


Lib3MFResult CCall_lib3mf_multipropertygroup_getallpropertyids(Lib3MFHandle libraryHandle, Lib3MF_MultiPropertyGroup pMultiPropertyGroup, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MultiPropertyGroup_GetAllPropertyIDs (pMultiPropertyGroup, nPropertyIDsBufferSize, pPropertyIDsNeededCount, pPropertyIDsBuffer);
}


Lib3MFResult CCall_lib3mf_multipropertygroup_addmultiproperty(Lib3MFHandle libraryHandle, Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint64 nPropertyIDsBufferSize, const Lib3MF_uint32 * pPropertyIDsBuffer, Lib3MF_uint32 * pPropertyID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MultiPropertyGroup_AddMultiProperty (pMultiPropertyGroup, nPropertyIDsBufferSize, pPropertyIDsBuffer, pPropertyID);
}


Lib3MFResult CCall_lib3mf_multipropertygroup_setmultiproperty(Lib3MFHandle libraryHandle, Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 nPropertyID, Lib3MF_uint64 nPropertyIDsBufferSize, const Lib3MF_uint32 * pPropertyIDsBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MultiPropertyGroup_SetMultiProperty (pMultiPropertyGroup, nPropertyID, nPropertyIDsBufferSize, pPropertyIDsBuffer);
}


Lib3MFResult CCall_lib3mf_multipropertygroup_getmultiproperty(Lib3MFHandle libraryHandle, Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 nPropertyID, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MultiPropertyGroup_GetMultiProperty (pMultiPropertyGroup, nPropertyID, nPropertyIDsBufferSize, pPropertyIDsNeededCount, pPropertyIDsBuffer);
}


Lib3MFResult CCall_lib3mf_multipropertygroup_removemultiproperty(Lib3MFHandle libraryHandle, Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 nPropertyID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MultiPropertyGroup_RemoveMultiProperty (pMultiPropertyGroup, nPropertyID);
}


Lib3MFResult CCall_lib3mf_multipropertygroup_getlayercount(Lib3MFHandle libraryHandle, Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MultiPropertyGroup_GetLayerCount (pMultiPropertyGroup, pCount);
}


Lib3MFResult CCall_lib3mf_multipropertygroup_addlayer(Lib3MFHandle libraryHandle, Lib3MF_MultiPropertyGroup pMultiPropertyGroup, const sLib3MFMultiPropertyLayer * pTheLayer, Lib3MF_uint32 * pLayerIndex)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MultiPropertyGroup_AddLayer (pMultiPropertyGroup, pTheLayer, pLayerIndex);
}


Lib3MFResult CCall_lib3mf_multipropertygroup_getlayer(Lib3MFHandle libraryHandle, Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 nLayerIndex, sLib3MFMultiPropertyLayer * pTheLayer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MultiPropertyGroup_GetLayer (pMultiPropertyGroup, nLayerIndex, pTheLayer);
}


Lib3MFResult CCall_lib3mf_multipropertygroup_removelayer(Lib3MFHandle libraryHandle, Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 nLayerIndex)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MultiPropertyGroup_RemoveLayer (pMultiPropertyGroup, nLayerIndex);
}


Lib3MFResult CCall_lib3mf_image3d_getname(Lib3MFHandle libraryHandle, Lib3MF_Image3D pImage3D, const Lib3MF_uint32 nNameBufferSize, Lib3MF_uint32* pNameNeededChars, char * pNameBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Image3D_GetName (pImage3D, nNameBufferSize, pNameNeededChars, pNameBuffer);
}


Lib3MFResult CCall_lib3mf_image3d_setname(Lib3MFHandle libraryHandle, Lib3MF_Image3D pImage3D, const char * pName)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Image3D_SetName (pImage3D, pName);
}


Lib3MFResult CCall_lib3mf_image3d_isimagestack(Lib3MFHandle libraryHandle, Lib3MF_Image3D pImage3D, bool * pIsImageStack)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Image3D_IsImageStack (pImage3D, pIsImageStack);
}


Lib3MFResult CCall_lib3mf_imagestack_getrowcount(Lib3MFHandle libraryHandle, Lib3MF_ImageStack pImageStack, Lib3MF_uint32 * pRowCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImageStack_GetRowCount (pImageStack, pRowCount);
}


Lib3MFResult CCall_lib3mf_imagestack_setrowcount(Lib3MFHandle libraryHandle, Lib3MF_ImageStack pImageStack, Lib3MF_uint32 nRowCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImageStack_SetRowCount (pImageStack, nRowCount);
}


Lib3MFResult CCall_lib3mf_imagestack_getcolumncount(Lib3MFHandle libraryHandle, Lib3MF_ImageStack pImageStack, Lib3MF_uint32 * pColumnCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImageStack_GetColumnCount (pImageStack, pColumnCount);
}


Lib3MFResult CCall_lib3mf_imagestack_setcolumncount(Lib3MFHandle libraryHandle, Lib3MF_ImageStack pImageStack, Lib3MF_uint32 nColumnCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImageStack_SetColumnCount (pImageStack, nColumnCount);
}


Lib3MFResult CCall_lib3mf_imagestack_getsheetcount(Lib3MFHandle libraryHandle, Lib3MF_ImageStack pImageStack, Lib3MF_uint32 * pSheetCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImageStack_GetSheetCount (pImageStack, pSheetCount);
}


Lib3MFResult CCall_lib3mf_imagestack_getsheet(Lib3MFHandle libraryHandle, Lib3MF_ImageStack pImageStack, Lib3MF_uint32 nIndex, Lib3MF_Attachment * pSheet)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImageStack_GetSheet (pImageStack, nIndex, pSheet);
}


Lib3MFResult CCall_lib3mf_imagestack_setsheet(Lib3MFHandle libraryHandle, Lib3MF_ImageStack pImageStack, Lib3MF_uint32 nIndex, Lib3MF_Attachment pSheet)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImageStack_SetSheet (pImageStack, nIndex, pSheet);
}


Lib3MFResult CCall_lib3mf_imagestack_createemptysheet(Lib3MFHandle libraryHandle, Lib3MF_ImageStack pImageStack, Lib3MF_uint32 nIndex, const char * pPath, Lib3MF_Attachment * pSheet)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImageStack_CreateEmptySheet (pImageStack, nIndex, pPath, pSheet);
}


Lib3MFResult CCall_lib3mf_imagestack_createsheetfrombuffer(Lib3MFHandle libraryHandle, Lib3MF_ImageStack pImageStack, Lib3MF_uint32 nIndex, const char * pPath, Lib3MF_uint64 nDataBufferSize, const Lib3MF_uint8 * pDataBuffer, Lib3MF_Attachment * pSheet)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImageStack_CreateSheetFromBuffer (pImageStack, nIndex, pPath, nDataBufferSize, pDataBuffer, pSheet);
}


Lib3MFResult CCall_lib3mf_imagestack_createsheetfromfile(Lib3MFHandle libraryHandle, Lib3MF_ImageStack pImageStack, Lib3MF_uint32 nIndex, const char * pPath, const char * pFileName, Lib3MF_Attachment * pSheet)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImageStack_CreateSheetFromFile (pImageStack, nIndex, pPath, pFileName, pSheet);
}


Lib3MFResult CCall_lib3mf_attachment_getpath(Lib3MFHandle libraryHandle, Lib3MF_Attachment pAttachment, const Lib3MF_uint32 nPathBufferSize, Lib3MF_uint32* pPathNeededChars, char * pPathBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Attachment_GetPath (pAttachment, nPathBufferSize, pPathNeededChars, pPathBuffer);
}


Lib3MFResult CCall_lib3mf_attachment_setpath(Lib3MFHandle libraryHandle, Lib3MF_Attachment pAttachment, const char * pPath)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Attachment_SetPath (pAttachment, pPath);
}


Lib3MFResult CCall_lib3mf_attachment_packagepart(Lib3MFHandle libraryHandle, Lib3MF_Attachment pAttachment, Lib3MF_PackagePart * pPackagePart)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Attachment_PackagePart (pAttachment, pPackagePart);
}


Lib3MFResult CCall_lib3mf_attachment_getrelationshiptype(Lib3MFHandle libraryHandle, Lib3MF_Attachment pAttachment, const Lib3MF_uint32 nPathBufferSize, Lib3MF_uint32* pPathNeededChars, char * pPathBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Attachment_GetRelationShipType (pAttachment, nPathBufferSize, pPathNeededChars, pPathBuffer);
}


Lib3MFResult CCall_lib3mf_attachment_setrelationshiptype(Lib3MFHandle libraryHandle, Lib3MF_Attachment pAttachment, const char * pPath)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Attachment_SetRelationShipType (pAttachment, pPath);
}


Lib3MFResult CCall_lib3mf_attachment_writetofile(Lib3MFHandle libraryHandle, Lib3MF_Attachment pAttachment, const char * pFileName)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Attachment_WriteToFile (pAttachment, pFileName);
}


Lib3MFResult CCall_lib3mf_attachment_readfromfile(Lib3MFHandle libraryHandle, Lib3MF_Attachment pAttachment, const char * pFileName)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Attachment_ReadFromFile (pAttachment, pFileName);
}


Lib3MFResult CCall_lib3mf_attachment_readfromcallback(Lib3MFHandle libraryHandle, Lib3MF_Attachment pAttachment, Lib3MFReadCallback pTheReadCallback, Lib3MF_uint64 nStreamSize, Lib3MFSeekCallback pTheSeekCallback, Lib3MF_pvoid pUserData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Attachment_ReadFromCallback (pAttachment, pTheReadCallback, nStreamSize, pTheSeekCallback, pUserData);
}


Lib3MFResult CCall_lib3mf_attachment_getstreamsize(Lib3MFHandle libraryHandle, Lib3MF_Attachment pAttachment, Lib3MF_uint64 * pStreamSize)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Attachment_GetStreamSize (pAttachment, pStreamSize);
}


Lib3MFResult CCall_lib3mf_attachment_writetobuffer(Lib3MFHandle libraryHandle, Lib3MF_Attachment pAttachment, const Lib3MF_uint64 nBufferBufferSize, Lib3MF_uint64* pBufferNeededCount, Lib3MF_uint8 * pBufferBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Attachment_WriteToBuffer (pAttachment, nBufferBufferSize, pBufferNeededCount, pBufferBuffer);
}


Lib3MFResult CCall_lib3mf_attachment_readfrombuffer(Lib3MFHandle libraryHandle, Lib3MF_Attachment pAttachment, Lib3MF_uint64 nBufferBufferSize, const Lib3MF_uint8 * pBufferBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Attachment_ReadFromBuffer (pAttachment, nBufferBufferSize, pBufferBuffer);
}


Lib3MFResult CCall_lib3mf_texture2d_getattachment(Lib3MFHandle libraryHandle, Lib3MF_Texture2D pTexture2D, Lib3MF_Attachment * pAttachment)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Texture2D_GetAttachment (pTexture2D, pAttachment);
}


Lib3MFResult CCall_lib3mf_texture2d_setattachment(Lib3MFHandle libraryHandle, Lib3MF_Texture2D pTexture2D, Lib3MF_Attachment pAttachment)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Texture2D_SetAttachment (pTexture2D, pAttachment);
}


Lib3MFResult CCall_lib3mf_texture2d_getcontenttype(Lib3MFHandle libraryHandle, Lib3MF_Texture2D pTexture2D, eLib3MFTextureType * pContentType)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Texture2D_GetContentType (pTexture2D, pContentType);
}


Lib3MFResult CCall_lib3mf_texture2d_setcontenttype(Lib3MFHandle libraryHandle, Lib3MF_Texture2D pTexture2D, eLib3MFTextureType eContentType)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Texture2D_SetContentType (pTexture2D, eContentType);
}


Lib3MFResult CCall_lib3mf_texture2d_gettilestyleuv(Lib3MFHandle libraryHandle, Lib3MF_Texture2D pTexture2D, eLib3MFTextureTileStyle * pTileStyleU, eLib3MFTextureTileStyle * pTileStyleV)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Texture2D_GetTileStyleUV (pTexture2D, pTileStyleU, pTileStyleV);
}


Lib3MFResult CCall_lib3mf_texture2d_settilestyleuv(Lib3MFHandle libraryHandle, Lib3MF_Texture2D pTexture2D, eLib3MFTextureTileStyle eTileStyleU, eLib3MFTextureTileStyle eTileStyleV)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Texture2D_SetTileStyleUV (pTexture2D, eTileStyleU, eTileStyleV);
}


Lib3MFResult CCall_lib3mf_texture2d_getfilter(Lib3MFHandle libraryHandle, Lib3MF_Texture2D pTexture2D, eLib3MFTextureFilter * pFilter)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Texture2D_GetFilter (pTexture2D, pFilter);
}


Lib3MFResult CCall_lib3mf_texture2d_setfilter(Lib3MFHandle libraryHandle, Lib3MF_Texture2D pTexture2D, eLib3MFTextureFilter eFilter)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Texture2D_SetFilter (pTexture2D, eFilter);
}


Lib3MFResult CCall_lib3mf_implicitport_getidentifier(Lib3MFHandle libraryHandle, Lib3MF_ImplicitPort pImplicitPort, const Lib3MF_uint32 nIdentifierBufferSize, Lib3MF_uint32* pIdentifierNeededChars, char * pIdentifierBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitPort_GetIdentifier (pImplicitPort, nIdentifierBufferSize, pIdentifierNeededChars, pIdentifierBuffer);
}


Lib3MFResult CCall_lib3mf_implicitport_setidentifier(Lib3MFHandle libraryHandle, Lib3MF_ImplicitPort pImplicitPort, const char * pIdentifier)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitPort_SetIdentifier (pImplicitPort, pIdentifier);
}


Lib3MFResult CCall_lib3mf_implicitport_getdisplayname(Lib3MFHandle libraryHandle, Lib3MF_ImplicitPort pImplicitPort, const Lib3MF_uint32 nDisplayNameBufferSize, Lib3MF_uint32* pDisplayNameNeededChars, char * pDisplayNameBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitPort_GetDisplayName (pImplicitPort, nDisplayNameBufferSize, pDisplayNameNeededChars, pDisplayNameBuffer);
}


Lib3MFResult CCall_lib3mf_implicitport_setdisplayname(Lib3MFHandle libraryHandle, Lib3MF_ImplicitPort pImplicitPort, const char * pDisplayName)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitPort_SetDisplayName (pImplicitPort, pDisplayName);
}


Lib3MFResult CCall_lib3mf_implicitport_settype(Lib3MFHandle libraryHandle, Lib3MF_ImplicitPort pImplicitPort, eLib3MFImplicitPortType eImplicitPortType)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitPort_SetType (pImplicitPort, eImplicitPortType);
}


Lib3MFResult CCall_lib3mf_implicitport_gettype(Lib3MFHandle libraryHandle, Lib3MF_ImplicitPort pImplicitPort, eLib3MFImplicitPortType * pImplicitPortType)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitPort_GetType (pImplicitPort, pImplicitPortType);
}


Lib3MFResult CCall_lib3mf_implicitport_getreference(Lib3MFHandle libraryHandle, Lib3MF_ImplicitPort pImplicitPort, const Lib3MF_uint32 nReferenceBufferSize, Lib3MF_uint32* pReferenceNeededChars, char * pReferenceBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitPort_GetReference (pImplicitPort, nReferenceBufferSize, pReferenceNeededChars, pReferenceBuffer);
}


Lib3MFResult CCall_lib3mf_implicitport_setreference(Lib3MFHandle libraryHandle, Lib3MF_ImplicitPort pImplicitPort, const char * pReference)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitPort_SetReference (pImplicitPort, pReference);
}


Lib3MFResult CCall_lib3mf_iterator_movenext(Lib3MFHandle libraryHandle, Lib3MF_Iterator pIterator, bool * pHasNext)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Iterator_MoveNext (pIterator, pHasNext);
}


Lib3MFResult CCall_lib3mf_iterator_moveprevious(Lib3MFHandle libraryHandle, Lib3MF_Iterator pIterator, bool * pHasPrevious)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Iterator_MovePrevious (pIterator, pHasPrevious);
}


Lib3MFResult CCall_lib3mf_iterator_count(Lib3MFHandle libraryHandle, Lib3MF_Iterator pIterator, Lib3MF_uint64 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Iterator_Count (pIterator, pCount);
}


Lib3MFResult CCall_lib3mf_implicitportiterator_getcurrent(Lib3MFHandle libraryHandle, Lib3MF_ImplicitPortIterator pImplicitPortIterator, Lib3MF_ImplicitPort * pPort)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitPortIterator_GetCurrent (pImplicitPortIterator, pPort);
}


Lib3MFResult CCall_lib3mf_implicitnode_getidentifier(Lib3MFHandle libraryHandle, Lib3MF_ImplicitNode pImplicitNode, const Lib3MF_uint32 nIdentifierBufferSize, Lib3MF_uint32* pIdentifierNeededChars, char * pIdentifierBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitNode_GetIdentifier (pImplicitNode, nIdentifierBufferSize, pIdentifierNeededChars, pIdentifierBuffer);
}


Lib3MFResult CCall_lib3mf_implicitnode_setidentifier(Lib3MFHandle libraryHandle, Lib3MF_ImplicitNode pImplicitNode, const char * pIdentifier)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitNode_SetIdentifier (pImplicitNode, pIdentifier);
}


Lib3MFResult CCall_lib3mf_implicitnode_getdisplayname(Lib3MFHandle libraryHandle, Lib3MF_ImplicitNode pImplicitNode, const Lib3MF_uint32 nDisplayNameBufferSize, Lib3MF_uint32* pDisplayNameNeededChars, char * pDisplayNameBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitNode_GetDisplayName (pImplicitNode, nDisplayNameBufferSize, pDisplayNameNeededChars, pDisplayNameBuffer);
}


Lib3MFResult CCall_lib3mf_implicitnode_setdisplayname(Lib3MFHandle libraryHandle, Lib3MF_ImplicitNode pImplicitNode, const char * pDisplayName)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitNode_SetDisplayName (pImplicitNode, pDisplayName);
}


Lib3MFResult CCall_lib3mf_implicitnode_gettag(Lib3MFHandle libraryHandle, Lib3MF_ImplicitNode pImplicitNode, const Lib3MF_uint32 nTagBufferSize, Lib3MF_uint32* pTagNeededChars, char * pTagBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitNode_GetTag (pImplicitNode, nTagBufferSize, pTagNeededChars, pTagBuffer);
}


Lib3MFResult CCall_lib3mf_implicitnode_settag(Lib3MFHandle libraryHandle, Lib3MF_ImplicitNode pImplicitNode, const char * pTag)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitNode_SetTag (pImplicitNode, pTag);
}


Lib3MFResult CCall_lib3mf_implicitnode_getnodetype(Lib3MFHandle libraryHandle, Lib3MF_ImplicitNode pImplicitNode, eLib3MFImplicitNodeType * pType)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitNode_GetNodeType (pImplicitNode, pType);
}


Lib3MFResult CCall_lib3mf_implicitnode_addinput(Lib3MFHandle libraryHandle, Lib3MF_ImplicitNode pImplicitNode, const char * pIdentifier, const char * pDisplayName, Lib3MF_ImplicitPort * pPort)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitNode_AddInput (pImplicitNode, pIdentifier, pDisplayName, pPort);
}


Lib3MFResult CCall_lib3mf_implicitnode_getinputs(Lib3MFHandle libraryHandle, Lib3MF_ImplicitNode pImplicitNode, Lib3MF_ImplicitPortIterator * pIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitNode_GetInputs (pImplicitNode, pIterator);
}


Lib3MFResult CCall_lib3mf_implicitnode_addoutput(Lib3MFHandle libraryHandle, Lib3MF_ImplicitNode pImplicitNode, const char * pIdentifier, const char * pDisplayName, Lib3MF_ImplicitPort * pPort)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitNode_AddOutput (pImplicitNode, pIdentifier, pDisplayName, pPort);
}


Lib3MFResult CCall_lib3mf_implicitnode_getoutputs(Lib3MFHandle libraryHandle, Lib3MF_ImplicitNode pImplicitNode, Lib3MF_ImplicitPortIterator * pIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitNode_GetOutputs (pImplicitNode, pIterator);
}


Lib3MFResult CCall_lib3mf_implicitnode_findinput(Lib3MFHandle libraryHandle, Lib3MF_ImplicitNode pImplicitNode, const char * pIdentifier, Lib3MF_ImplicitPort * pInput)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitNode_FindInput (pImplicitNode, pIdentifier, pInput);
}


Lib3MFResult CCall_lib3mf_implicitnode_findoutput(Lib3MFHandle libraryHandle, Lib3MF_ImplicitNode pImplicitNode, const char * pIdentifier, Lib3MF_ImplicitPort * pOutput)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitNode_FindOutput (pImplicitNode, pIdentifier, pOutput);
}


Lib3MFResult CCall_lib3mf_implicitnode_aretypesvalid(Lib3MFHandle libraryHandle, Lib3MF_ImplicitNode pImplicitNode, bool * pValid)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitNode_AreTypesValid (pImplicitNode, pValid);
}


Lib3MFResult CCall_lib3mf_oneinputnode_getinputa(Lib3MFHandle libraryHandle, Lib3MF_OneInputNode pOneInputNode, Lib3MF_ImplicitPort * pInput)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_OneInputNode_GetInputA (pOneInputNode, pInput);
}


Lib3MFResult CCall_lib3mf_oneinputnode_getoutputresult(Lib3MFHandle libraryHandle, Lib3MF_OneInputNode pOneInputNode, Lib3MF_ImplicitPort * pResult)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_OneInputNode_GetOutputResult (pOneInputNode, pResult);
}


Lib3MFResult CCall_lib3mf_resourceidnode_setresource(Lib3MFHandle libraryHandle, Lib3MF_ResourceIdNode pResourceIdNode, Lib3MF_Resource pResource)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ResourceIdNode_SetResource (pResourceIdNode, pResource);
}


Lib3MFResult CCall_lib3mf_resourceidnode_getresource(Lib3MFHandle libraryHandle, Lib3MF_ResourceIdNode pResourceIdNode, Lib3MF_Resource * pResource)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ResourceIdNode_GetResource (pResourceIdNode, pResource);
}


Lib3MFResult CCall_lib3mf_resourceidnode_getoutputvalue(Lib3MFHandle libraryHandle, Lib3MF_ResourceIdNode pResourceIdNode, Lib3MF_ImplicitPort * pValue)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ResourceIdNode_GetOutputValue (pResourceIdNode, pValue);
}


Lib3MFResult CCall_lib3mf_twoinputnode_getinputb(Lib3MFHandle libraryHandle, Lib3MF_TwoInputNode pTwoInputNode, Lib3MF_ImplicitPort * pB)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_TwoInputNode_GetInputB (pTwoInputNode, pB);
}


Lib3MFResult CCall_lib3mf_selectnode_getinputb(Lib3MFHandle libraryHandle, Lib3MF_SelectNode pSelectNode, Lib3MF_ImplicitPort * pB)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_SelectNode_GetInputB (pSelectNode, pB);
}


Lib3MFResult CCall_lib3mf_selectnode_getinputc(Lib3MFHandle libraryHandle, Lib3MF_SelectNode pSelectNode, Lib3MF_ImplicitPort * pC)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_SelectNode_GetInputC (pSelectNode, pC);
}


Lib3MFResult CCall_lib3mf_selectnode_getinputd(Lib3MFHandle libraryHandle, Lib3MF_SelectNode pSelectNode, Lib3MF_ImplicitPort * pD)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_SelectNode_GetInputD (pSelectNode, pD);
}


Lib3MFResult CCall_lib3mf_clampnode_getinputmin(Lib3MFHandle libraryHandle, Lib3MF_ClampNode pClampNode, Lib3MF_ImplicitPort * pMin)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ClampNode_GetInputMin (pClampNode, pMin);
}


Lib3MFResult CCall_lib3mf_clampnode_getinputmax(Lib3MFHandle libraryHandle, Lib3MF_ClampNode pClampNode, Lib3MF_ImplicitPort * pMax)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ClampNode_GetInputMax (pClampNode, pMax);
}


Lib3MFResult CCall_lib3mf_composevectornode_getinputx(Lib3MFHandle libraryHandle, Lib3MF_ComposeVectorNode pComposeVectorNode, Lib3MF_ImplicitPort * pX)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ComposeVectorNode_GetInputX (pComposeVectorNode, pX);
}


Lib3MFResult CCall_lib3mf_composevectornode_getinputy(Lib3MFHandle libraryHandle, Lib3MF_ComposeVectorNode pComposeVectorNode, Lib3MF_ImplicitPort * pY)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ComposeVectorNode_GetInputY (pComposeVectorNode, pY);
}


Lib3MFResult CCall_lib3mf_composevectornode_getinputz(Lib3MFHandle libraryHandle, Lib3MF_ComposeVectorNode pComposeVectorNode, Lib3MF_ImplicitPort * pZ)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ComposeVectorNode_GetInputZ (pComposeVectorNode, pZ);
}


Lib3MFResult CCall_lib3mf_composevectornode_getoutputresult(Lib3MFHandle libraryHandle, Lib3MF_ComposeVectorNode pComposeVectorNode, Lib3MF_ImplicitPort * pResult)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ComposeVectorNode_GetOutputResult (pComposeVectorNode, pResult);
}


Lib3MFResult CCall_lib3mf_decomposevectornode_getinputa(Lib3MFHandle libraryHandle, Lib3MF_DecomposeVectorNode pDecomposeVectorNode, Lib3MF_ImplicitPort * pA)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_DecomposeVectorNode_GetInputA (pDecomposeVectorNode, pA);
}


Lib3MFResult CCall_lib3mf_decomposevectornode_getoutputx(Lib3MFHandle libraryHandle, Lib3MF_DecomposeVectorNode pDecomposeVectorNode, Lib3MF_ImplicitPort * pX)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_DecomposeVectorNode_GetOutputX (pDecomposeVectorNode, pX);
}


Lib3MFResult CCall_lib3mf_decomposevectornode_getoutputy(Lib3MFHandle libraryHandle, Lib3MF_DecomposeVectorNode pDecomposeVectorNode, Lib3MF_ImplicitPort * pY)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_DecomposeVectorNode_GetOutputY (pDecomposeVectorNode, pY);
}


Lib3MFResult CCall_lib3mf_decomposevectornode_getoutputz(Lib3MFHandle libraryHandle, Lib3MF_DecomposeVectorNode pDecomposeVectorNode, Lib3MF_ImplicitPort * pZ)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_DecomposeVectorNode_GetOutputZ (pDecomposeVectorNode, pZ);
}


Lib3MFResult CCall_lib3mf_composematrixnode_getinputm00(Lib3MFHandle libraryHandle, Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM00)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ComposeMatrixNode_GetInputM00 (pComposeMatrixNode, pM00);
}


Lib3MFResult CCall_lib3mf_composematrixnode_getinputm01(Lib3MFHandle libraryHandle, Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM01)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ComposeMatrixNode_GetInputM01 (pComposeMatrixNode, pM01);
}


Lib3MFResult CCall_lib3mf_composematrixnode_getinputm02(Lib3MFHandle libraryHandle, Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM02)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ComposeMatrixNode_GetInputM02 (pComposeMatrixNode, pM02);
}


Lib3MFResult CCall_lib3mf_composematrixnode_getinputm03(Lib3MFHandle libraryHandle, Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM03)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ComposeMatrixNode_GetInputM03 (pComposeMatrixNode, pM03);
}


Lib3MFResult CCall_lib3mf_composematrixnode_getinputm10(Lib3MFHandle libraryHandle, Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM10)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ComposeMatrixNode_GetInputM10 (pComposeMatrixNode, pM10);
}


Lib3MFResult CCall_lib3mf_composematrixnode_getinputm11(Lib3MFHandle libraryHandle, Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM11)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ComposeMatrixNode_GetInputM11 (pComposeMatrixNode, pM11);
}


Lib3MFResult CCall_lib3mf_composematrixnode_getinputm12(Lib3MFHandle libraryHandle, Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM12)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ComposeMatrixNode_GetInputM12 (pComposeMatrixNode, pM12);
}


Lib3MFResult CCall_lib3mf_composematrixnode_getinputm13(Lib3MFHandle libraryHandle, Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM13)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ComposeMatrixNode_GetInputM13 (pComposeMatrixNode, pM13);
}


Lib3MFResult CCall_lib3mf_composematrixnode_getinputm20(Lib3MFHandle libraryHandle, Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM20)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ComposeMatrixNode_GetInputM20 (pComposeMatrixNode, pM20);
}


Lib3MFResult CCall_lib3mf_composematrixnode_getinputm21(Lib3MFHandle libraryHandle, Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM21)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ComposeMatrixNode_GetInputM21 (pComposeMatrixNode, pM21);
}


Lib3MFResult CCall_lib3mf_composematrixnode_getinputm22(Lib3MFHandle libraryHandle, Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM22)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ComposeMatrixNode_GetInputM22 (pComposeMatrixNode, pM22);
}


Lib3MFResult CCall_lib3mf_composematrixnode_getinputm23(Lib3MFHandle libraryHandle, Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM23)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ComposeMatrixNode_GetInputM23 (pComposeMatrixNode, pM23);
}


Lib3MFResult CCall_lib3mf_composematrixnode_getinputm30(Lib3MFHandle libraryHandle, Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM30)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ComposeMatrixNode_GetInputM30 (pComposeMatrixNode, pM30);
}


Lib3MFResult CCall_lib3mf_composematrixnode_getinputm31(Lib3MFHandle libraryHandle, Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM31)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ComposeMatrixNode_GetInputM31 (pComposeMatrixNode, pM31);
}


Lib3MFResult CCall_lib3mf_composematrixnode_getinputm32(Lib3MFHandle libraryHandle, Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM32)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ComposeMatrixNode_GetInputM32 (pComposeMatrixNode, pM32);
}


Lib3MFResult CCall_lib3mf_composematrixnode_getinputm33(Lib3MFHandle libraryHandle, Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pM33)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ComposeMatrixNode_GetInputM33 (pComposeMatrixNode, pM33);
}


Lib3MFResult CCall_lib3mf_composematrixnode_getoutputresult(Lib3MFHandle libraryHandle, Lib3MF_ComposeMatrixNode pComposeMatrixNode, Lib3MF_ImplicitPort * pResult)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ComposeMatrixNode_GetOutputResult (pComposeMatrixNode, pResult);
}


Lib3MFResult CCall_lib3mf_matrixfromrowsnode_getinputa(Lib3MFHandle libraryHandle, Lib3MF_MatrixFromRowsNode pMatrixFromRowsNode, Lib3MF_ImplicitPort * pRow0)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MatrixFromRowsNode_GetInputA (pMatrixFromRowsNode, pRow0);
}


Lib3MFResult CCall_lib3mf_matrixfromrowsnode_getinputb(Lib3MFHandle libraryHandle, Lib3MF_MatrixFromRowsNode pMatrixFromRowsNode, Lib3MF_ImplicitPort * pRow1)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MatrixFromRowsNode_GetInputB (pMatrixFromRowsNode, pRow1);
}


Lib3MFResult CCall_lib3mf_matrixfromrowsnode_getinputc(Lib3MFHandle libraryHandle, Lib3MF_MatrixFromRowsNode pMatrixFromRowsNode, Lib3MF_ImplicitPort * pRow2)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MatrixFromRowsNode_GetInputC (pMatrixFromRowsNode, pRow2);
}


Lib3MFResult CCall_lib3mf_matrixfromrowsnode_getinputd(Lib3MFHandle libraryHandle, Lib3MF_MatrixFromRowsNode pMatrixFromRowsNode, Lib3MF_ImplicitPort * pRow3)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MatrixFromRowsNode_GetInputD (pMatrixFromRowsNode, pRow3);
}


Lib3MFResult CCall_lib3mf_matrixfromrowsnode_getoutputresult(Lib3MFHandle libraryHandle, Lib3MF_MatrixFromRowsNode pMatrixFromRowsNode, Lib3MF_ImplicitPort * pResult)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MatrixFromRowsNode_GetOutputResult (pMatrixFromRowsNode, pResult);
}


Lib3MFResult CCall_lib3mf_matrixfromcolumnsnode_getinputa(Lib3MFHandle libraryHandle, Lib3MF_MatrixFromColumnsNode pMatrixFromColumnsNode, Lib3MF_ImplicitPort * pColumn0)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MatrixFromColumnsNode_GetInputA (pMatrixFromColumnsNode, pColumn0);
}


Lib3MFResult CCall_lib3mf_matrixfromcolumnsnode_getinputb(Lib3MFHandle libraryHandle, Lib3MF_MatrixFromColumnsNode pMatrixFromColumnsNode, Lib3MF_ImplicitPort * pColumn1)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MatrixFromColumnsNode_GetInputB (pMatrixFromColumnsNode, pColumn1);
}


Lib3MFResult CCall_lib3mf_matrixfromcolumnsnode_getinputc(Lib3MFHandle libraryHandle, Lib3MF_MatrixFromColumnsNode pMatrixFromColumnsNode, Lib3MF_ImplicitPort * pColumn2)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MatrixFromColumnsNode_GetInputC (pMatrixFromColumnsNode, pColumn2);
}


Lib3MFResult CCall_lib3mf_matrixfromcolumnsnode_getinputd(Lib3MFHandle libraryHandle, Lib3MF_MatrixFromColumnsNode pMatrixFromColumnsNode, Lib3MF_ImplicitPort * pColumn3)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MatrixFromColumnsNode_GetInputD (pMatrixFromColumnsNode, pColumn3);
}


Lib3MFResult CCall_lib3mf_matrixfromcolumnsnode_getoutputresult(Lib3MFHandle libraryHandle, Lib3MF_MatrixFromColumnsNode pMatrixFromColumnsNode, Lib3MF_ImplicitPort * pResult)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MatrixFromColumnsNode_GetOutputResult (pMatrixFromColumnsNode, pResult);
}


Lib3MFResult CCall_lib3mf_constantnode_setconstant(Lib3MFHandle libraryHandle, Lib3MF_ConstantNode pConstantNode, Lib3MF_double dValue)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ConstantNode_SetConstant (pConstantNode, dValue);
}


Lib3MFResult CCall_lib3mf_constantnode_getconstant(Lib3MFHandle libraryHandle, Lib3MF_ConstantNode pConstantNode, Lib3MF_double * pValue)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ConstantNode_GetConstant (pConstantNode, pValue);
}


Lib3MFResult CCall_lib3mf_constantnode_getoutputvalue(Lib3MFHandle libraryHandle, Lib3MF_ConstantNode pConstantNode, Lib3MF_ImplicitPort * pValue)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ConstantNode_GetOutputValue (pConstantNode, pValue);
}


Lib3MFResult CCall_lib3mf_constvecnode_setvector(Lib3MFHandle libraryHandle, Lib3MF_ConstVecNode pConstVecNode, const sLib3MFVector * pValue)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ConstVecNode_SetVector (pConstVecNode, pValue);
}


Lib3MFResult CCall_lib3mf_constvecnode_getvector(Lib3MFHandle libraryHandle, Lib3MF_ConstVecNode pConstVecNode, sLib3MFVector * pValue)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ConstVecNode_GetVector (pConstVecNode, pValue);
}


Lib3MFResult CCall_lib3mf_constvecnode_getoutputvector(Lib3MFHandle libraryHandle, Lib3MF_ConstVecNode pConstVecNode, Lib3MF_ImplicitPort * pVector)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ConstVecNode_GetOutputVector (pConstVecNode, pVector);
}


Lib3MFResult CCall_lib3mf_constmatnode_setmatrix(Lib3MFHandle libraryHandle, Lib3MF_ConstMatNode pConstMatNode, const sLib3MFMatrix4x4 * pValue)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ConstMatNode_SetMatrix (pConstMatNode, pValue);
}


Lib3MFResult CCall_lib3mf_constmatnode_getmatrix(Lib3MFHandle libraryHandle, Lib3MF_ConstMatNode pConstMatNode, sLib3MFMatrix4x4 * pValue)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ConstMatNode_GetMatrix (pConstMatNode, pValue);
}


Lib3MFResult CCall_lib3mf_constmatnode_getoutputmatrix(Lib3MFHandle libraryHandle, Lib3MF_ConstMatNode pConstMatNode, Lib3MF_ImplicitPort * pMatrix)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ConstMatNode_GetOutputMatrix (pConstMatNode, pMatrix);
}


Lib3MFResult CCall_lib3mf_meshnode_getinputmesh(Lib3MFHandle libraryHandle, Lib3MF_MeshNode pMeshNode, Lib3MF_ImplicitPort * pMesh)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshNode_GetInputMesh (pMeshNode, pMesh);
}


Lib3MFResult CCall_lib3mf_meshnode_getinputpos(Lib3MFHandle libraryHandle, Lib3MF_MeshNode pMeshNode, Lib3MF_ImplicitPort * pPos)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshNode_GetInputPos (pMeshNode, pPos);
}


Lib3MFResult CCall_lib3mf_meshnode_getoutputdistance(Lib3MFHandle libraryHandle, Lib3MF_MeshNode pMeshNode, Lib3MF_ImplicitPort * pDistance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_MeshNode_GetOutputDistance (pMeshNode, pDistance);
}


Lib3MFResult CCall_lib3mf_unsignedmeshnode_getinputmesh(Lib3MFHandle libraryHandle, Lib3MF_UnsignedMeshNode pUnsignedMeshNode, Lib3MF_ImplicitPort * pMesh)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_UnsignedMeshNode_GetInputMesh (pUnsignedMeshNode, pMesh);
}


Lib3MFResult CCall_lib3mf_unsignedmeshnode_getinputpos(Lib3MFHandle libraryHandle, Lib3MF_UnsignedMeshNode pUnsignedMeshNode, Lib3MF_ImplicitPort * pPos)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_UnsignedMeshNode_GetInputPos (pUnsignedMeshNode, pPos);
}


Lib3MFResult CCall_lib3mf_unsignedmeshnode_getoutputdistance(Lib3MFHandle libraryHandle, Lib3MF_UnsignedMeshNode pUnsignedMeshNode, Lib3MF_ImplicitPort * pDistance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_UnsignedMeshNode_GetOutputDistance (pUnsignedMeshNode, pDistance);
}


Lib3MFResult CCall_lib3mf_beamlatticenode_getinputbeamlattice(Lib3MFHandle libraryHandle, Lib3MF_BeamLatticeNode pBeamLatticeNode, Lib3MF_ImplicitPort * pBeamLattice)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLatticeNode_GetInputBeamLattice (pBeamLatticeNode, pBeamLattice);
}


Lib3MFResult CCall_lib3mf_beamlatticenode_getinputpos(Lib3MFHandle libraryHandle, Lib3MF_BeamLatticeNode pBeamLatticeNode, Lib3MF_ImplicitPort * pPos)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLatticeNode_GetInputPos (pBeamLatticeNode, pPos);
}


Lib3MFResult CCall_lib3mf_beamlatticenode_getoutputdistance(Lib3MFHandle libraryHandle, Lib3MF_BeamLatticeNode pBeamLatticeNode, Lib3MF_ImplicitPort * pDistance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLatticeNode_GetOutputDistance (pBeamLatticeNode, pDistance);
}


Lib3MFResult CCall_lib3mf_beamlatticenode_setaccuraterange(Lib3MFHandle libraryHandle, Lib3MF_BeamLatticeNode pBeamLatticeNode, Lib3MF_double dAccurateRange)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLatticeNode_SetAccurateRange (pBeamLatticeNode, dAccurateRange);
}


Lib3MFResult CCall_lib3mf_beamlatticenode_getaccuraterange(Lib3MFHandle libraryHandle, Lib3MF_BeamLatticeNode pBeamLatticeNode, Lib3MF_double * pAccurateRange)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BeamLatticeNode_GetAccurateRange (pBeamLatticeNode, pAccurateRange);
}


Lib3MFResult CCall_lib3mf_functiongradientnode_getinputfunctionid(Lib3MFHandle libraryHandle, Lib3MF_FunctionGradientNode pFunctionGradientNode, Lib3MF_ImplicitPort * pFunction)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_FunctionGradientNode_GetInputFunctionID (pFunctionGradientNode, pFunction);
}


Lib3MFResult CCall_lib3mf_functiongradientnode_getinputpos(Lib3MFHandle libraryHandle, Lib3MF_FunctionGradientNode pFunctionGradientNode, Lib3MF_ImplicitPort * pPos)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_FunctionGradientNode_GetInputPos (pFunctionGradientNode, pPos);
}


Lib3MFResult CCall_lib3mf_functiongradientnode_getinputstep(Lib3MFHandle libraryHandle, Lib3MF_FunctionGradientNode pFunctionGradientNode, Lib3MF_ImplicitPort * pStep)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_FunctionGradientNode_GetInputStep (pFunctionGradientNode, pStep);
}


Lib3MFResult CCall_lib3mf_functiongradientnode_setscalaroutputname(Lib3MFHandle libraryHandle, Lib3MF_FunctionGradientNode pFunctionGradientNode, const char * pScalarOutputName)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_FunctionGradientNode_SetScalarOutputName (pFunctionGradientNode, pScalarOutputName);
}


Lib3MFResult CCall_lib3mf_functiongradientnode_getscalaroutputname(Lib3MFHandle libraryHandle, Lib3MF_FunctionGradientNode pFunctionGradientNode, const Lib3MF_uint32 nScalarOutputNameBufferSize, Lib3MF_uint32* pScalarOutputNameNeededChars, char * pScalarOutputNameBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_FunctionGradientNode_GetScalarOutputName (pFunctionGradientNode, nScalarOutputNameBufferSize, pScalarOutputNameNeededChars, pScalarOutputNameBuffer);
}


Lib3MFResult CCall_lib3mf_functiongradientnode_setvectorinputname(Lib3MFHandle libraryHandle, Lib3MF_FunctionGradientNode pFunctionGradientNode, const char * pVectorInputName)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_FunctionGradientNode_SetVectorInputName (pFunctionGradientNode, pVectorInputName);
}


Lib3MFResult CCall_lib3mf_functiongradientnode_getvectorinputname(Lib3MFHandle libraryHandle, Lib3MF_FunctionGradientNode pFunctionGradientNode, const Lib3MF_uint32 nVectorInputNameBufferSize, Lib3MF_uint32* pVectorInputNameNeededChars, char * pVectorInputNameBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_FunctionGradientNode_GetVectorInputName (pFunctionGradientNode, nVectorInputNameBufferSize, pVectorInputNameNeededChars, pVectorInputNameBuffer);
}


Lib3MFResult CCall_lib3mf_functiongradientnode_getoutputnormalizedgradient(Lib3MFHandle libraryHandle, Lib3MF_FunctionGradientNode pFunctionGradientNode, Lib3MF_ImplicitPort * pNormalizedGradient)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_FunctionGradientNode_GetOutputNormalizedGradient (pFunctionGradientNode, pNormalizedGradient);
}


Lib3MFResult CCall_lib3mf_functiongradientnode_getoutputgradient(Lib3MFHandle libraryHandle, Lib3MF_FunctionGradientNode pFunctionGradientNode, Lib3MF_ImplicitPort * pGradient)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_FunctionGradientNode_GetOutputGradient (pFunctionGradientNode, pGradient);
}


Lib3MFResult CCall_lib3mf_functiongradientnode_getoutputmagnitude(Lib3MFHandle libraryHandle, Lib3MF_FunctionGradientNode pFunctionGradientNode, Lib3MF_ImplicitPort * pMagnitude)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_FunctionGradientNode_GetOutputMagnitude (pFunctionGradientNode, pMagnitude);
}


Lib3MFResult CCall_lib3mf_normalizedistancenode_getinputfunctionid(Lib3MFHandle libraryHandle, Lib3MF_NormalizeDistanceNode pNormalizeDistanceNode, Lib3MF_ImplicitPort * pFunction)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_NormalizeDistanceNode_GetInputFunctionID (pNormalizeDistanceNode, pFunction);
}


Lib3MFResult CCall_lib3mf_normalizedistancenode_getinputpos(Lib3MFHandle libraryHandle, Lib3MF_NormalizeDistanceNode pNormalizeDistanceNode, Lib3MF_ImplicitPort * pPos)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_NormalizeDistanceNode_GetInputPos (pNormalizeDistanceNode, pPos);
}


Lib3MFResult CCall_lib3mf_normalizedistancenode_getinputstep(Lib3MFHandle libraryHandle, Lib3MF_NormalizeDistanceNode pNormalizeDistanceNode, Lib3MF_ImplicitPort * pStep)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_NormalizeDistanceNode_GetInputStep (pNormalizeDistanceNode, pStep);
}


Lib3MFResult CCall_lib3mf_normalizedistancenode_setscalaroutputname(Lib3MFHandle libraryHandle, Lib3MF_NormalizeDistanceNode pNormalizeDistanceNode, const char * pScalarOutputName)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_NormalizeDistanceNode_SetScalarOutputName (pNormalizeDistanceNode, pScalarOutputName);
}


Lib3MFResult CCall_lib3mf_normalizedistancenode_getscalaroutputname(Lib3MFHandle libraryHandle, Lib3MF_NormalizeDistanceNode pNormalizeDistanceNode, const Lib3MF_uint32 nScalarOutputNameBufferSize, Lib3MF_uint32* pScalarOutputNameNeededChars, char * pScalarOutputNameBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_NormalizeDistanceNode_GetScalarOutputName (pNormalizeDistanceNode, nScalarOutputNameBufferSize, pScalarOutputNameNeededChars, pScalarOutputNameBuffer);
}


Lib3MFResult CCall_lib3mf_normalizedistancenode_setvectorinputname(Lib3MFHandle libraryHandle, Lib3MF_NormalizeDistanceNode pNormalizeDistanceNode, const char * pVectorInputName)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_NormalizeDistanceNode_SetVectorInputName (pNormalizeDistanceNode, pVectorInputName);
}


Lib3MFResult CCall_lib3mf_normalizedistancenode_getvectorinputname(Lib3MFHandle libraryHandle, Lib3MF_NormalizeDistanceNode pNormalizeDistanceNode, const Lib3MF_uint32 nVectorInputNameBufferSize, Lib3MF_uint32* pVectorInputNameNeededChars, char * pVectorInputNameBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_NormalizeDistanceNode_GetVectorInputName (pNormalizeDistanceNode, nVectorInputNameBufferSize, pVectorInputNameNeededChars, pVectorInputNameBuffer);
}


Lib3MFResult CCall_lib3mf_normalizedistancenode_getoutputresult(Lib3MFHandle libraryHandle, Lib3MF_NormalizeDistanceNode pNormalizeDistanceNode, Lib3MF_ImplicitPort * pResult)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_NormalizeDistanceNode_GetOutputResult (pNormalizeDistanceNode, pResult);
}


Lib3MFResult CCall_lib3mf_functioncallnode_getinputfunctionid(Lib3MFHandle libraryHandle, Lib3MF_FunctionCallNode pFunctionCallNode, Lib3MF_ImplicitPort * pFunction)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_FunctionCallNode_GetInputFunctionID (pFunctionCallNode, pFunction);
}


Lib3MFResult CCall_lib3mf_nodeiterator_getcurrent(Lib3MFHandle libraryHandle, Lib3MF_NodeIterator pNodeIterator, Lib3MF_ImplicitNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_NodeIterator_GetCurrent (pNodeIterator, pNode);
}


Lib3MFResult CCall_lib3mf_function_getdisplayname(Lib3MFHandle libraryHandle, Lib3MF_Function pFunction, const Lib3MF_uint32 nDisplayNameBufferSize, Lib3MF_uint32* pDisplayNameNeededChars, char * pDisplayNameBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Function_GetDisplayName (pFunction, nDisplayNameBufferSize, pDisplayNameNeededChars, pDisplayNameBuffer);
}


Lib3MFResult CCall_lib3mf_function_setdisplayname(Lib3MFHandle libraryHandle, Lib3MF_Function pFunction, const char * pDisplayName)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Function_SetDisplayName (pFunction, pDisplayName);
}


Lib3MFResult CCall_lib3mf_function_addinput(Lib3MFHandle libraryHandle, Lib3MF_Function pFunction, const char * pIdentifier, const char * pDisplayName, eLib3MFImplicitPortType eType, Lib3MF_ImplicitPort * pPort)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Function_AddInput (pFunction, pIdentifier, pDisplayName, eType, pPort);
}


Lib3MFResult CCall_lib3mf_function_getinputs(Lib3MFHandle libraryHandle, Lib3MF_Function pFunction, Lib3MF_ImplicitPortIterator * pIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Function_GetInputs (pFunction, pIterator);
}


Lib3MFResult CCall_lib3mf_function_removeinput(Lib3MFHandle libraryHandle, Lib3MF_Function pFunction, Lib3MF_ImplicitPort pInput)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Function_RemoveInput (pFunction, pInput);
}


Lib3MFResult CCall_lib3mf_function_addoutput(Lib3MFHandle libraryHandle, Lib3MF_Function pFunction, const char * pIdentifier, const char * pDisplayName, eLib3MFImplicitPortType eType, Lib3MF_ImplicitPort * pPort)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Function_AddOutput (pFunction, pIdentifier, pDisplayName, eType, pPort);
}


Lib3MFResult CCall_lib3mf_function_getoutputs(Lib3MFHandle libraryHandle, Lib3MF_Function pFunction, Lib3MF_ImplicitPortIterator * pIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Function_GetOutputs (pFunction, pIterator);
}


Lib3MFResult CCall_lib3mf_function_removeoutput(Lib3MFHandle libraryHandle, Lib3MF_Function pFunction, Lib3MF_ImplicitPort pOutput)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Function_RemoveOutput (pFunction, pOutput);
}


Lib3MFResult CCall_lib3mf_function_findinput(Lib3MFHandle libraryHandle, Lib3MF_Function pFunction, const char * pIdentifier, Lib3MF_ImplicitPort * pInput)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Function_FindInput (pFunction, pIdentifier, pInput);
}


Lib3MFResult CCall_lib3mf_function_findoutput(Lib3MFHandle libraryHandle, Lib3MF_Function pFunction, const char * pIdentifier, Lib3MF_ImplicitPort * pOutput)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Function_FindOutput (pFunction, pIdentifier, pOutput);
}


Lib3MFResult CCall_lib3mf_implicitfunction_getidentifier(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const Lib3MF_uint32 nIdentifierBufferSize, Lib3MF_uint32* pIdentifierNeededChars, char * pIdentifierBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_GetIdentifier (pImplicitFunction, nIdentifierBufferSize, pIdentifierNeededChars, pIdentifierBuffer);
}


Lib3MFResult CCall_lib3mf_implicitfunction_setidentifier(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_SetIdentifier (pImplicitFunction, pIdentifier);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, eLib3MFImplicitNodeType eNodeType, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_ImplicitNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddNode (pImplicitFunction, eNodeType, pIdentifier, eConfiguration, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addsinnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_SinNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddSinNode (pImplicitFunction, pIdentifier, eConfiguration, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addcosnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_CosNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddCosNode (pImplicitFunction, pIdentifier, eConfiguration, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addtannode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_TanNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddTanNode (pImplicitFunction, pIdentifier, eConfiguration, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addarcsinnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_ArcSinNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddArcSinNode (pImplicitFunction, pIdentifier, eConfiguration, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addarccosnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_ArcCosNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddArcCosNode (pImplicitFunction, pIdentifier, eConfiguration, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addarctan2node(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_ArcTan2Node * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddArcTan2Node (pImplicitFunction, pIdentifier, eConfiguration, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addsinhnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_SinhNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddSinhNode (pImplicitFunction, pIdentifier, eConfiguration, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addcoshnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_CoshNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddCoshNode (pImplicitFunction, pIdentifier, eConfiguration, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addtanhnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_TanhNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddTanhNode (pImplicitFunction, pIdentifier, eConfiguration, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addroundnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_RoundNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddRoundNode (pImplicitFunction, pIdentifier, eConfiguration, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addceilnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_CeilNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddCeilNode (pImplicitFunction, pIdentifier, eConfiguration, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addfloornode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_FloorNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddFloorNode (pImplicitFunction, pIdentifier, eConfiguration, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addsignnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_SignNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddSignNode (pImplicitFunction, pIdentifier, eConfiguration, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addfractnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_FractNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddFractNode (pImplicitFunction, pIdentifier, eConfiguration, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addabsnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_AbsNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddAbsNode (pImplicitFunction, pIdentifier, eConfiguration, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addexpnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_ExpNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddExpNode (pImplicitFunction, pIdentifier, eConfiguration, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addlognode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_LogNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddLogNode (pImplicitFunction, pIdentifier, eConfiguration, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addlog2node(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_Log2Node * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddLog2Node (pImplicitFunction, pIdentifier, eConfiguration, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addlog10node(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_Log10Node * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddLog10Node (pImplicitFunction, pIdentifier, eConfiguration, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addlengthnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_LengthNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddLengthNode (pImplicitFunction, pIdentifier, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addtransposenode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_TransposeNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddTransposeNode (pImplicitFunction, pIdentifier, eConfiguration, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addinversenode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_InverseNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddInverseNode (pImplicitFunction, pIdentifier, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addsqrtnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_SqrtNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddSqrtNode (pImplicitFunction, pIdentifier, eConfiguration, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addresourceidnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_ResourceIdNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddResourceIdNode (pImplicitFunction, pIdentifier, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addadditionnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_AdditionNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddAdditionNode (pImplicitFunction, pIdentifier, eConfiguration, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addsubtractionnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_SubtractionNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddSubtractionNode (pImplicitFunction, pIdentifier, eConfiguration, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addmultiplicationnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_MultiplicationNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddMultiplicationNode (pImplicitFunction, pIdentifier, eConfiguration, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_adddivisionnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_DivisionNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddDivisionNode (pImplicitFunction, pIdentifier, eConfiguration, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_adddotnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_DotNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddDotNode (pImplicitFunction, pIdentifier, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addcrossnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_CrossNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddCrossNode (pImplicitFunction, pIdentifier, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addmatvecmultiplicationnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_MatVecMultiplicationNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddMatVecMultiplicationNode (pImplicitFunction, pIdentifier, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addminnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_MinNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddMinNode (pImplicitFunction, pIdentifier, eConfiguration, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addmaxnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_MaxNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddMaxNode (pImplicitFunction, pIdentifier, eConfiguration, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addfmodnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_FmodNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddFmodNode (pImplicitFunction, pIdentifier, eConfiguration, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addpownode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_PowNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddPowNode (pImplicitFunction, pIdentifier, eConfiguration, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addselectnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_SelectNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddSelectNode (pImplicitFunction, pIdentifier, eConfiguration, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addclampnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, eLib3MFImplicitNodeConfiguration eConfiguration, const char * pDisplayName, const char * pTag, Lib3MF_ClampNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddClampNode (pImplicitFunction, pIdentifier, eConfiguration, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addcomposevectornode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_ComposeVectorNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddComposeVectorNode (pImplicitFunction, pIdentifier, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addvectorfromscalarnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_VectorFromScalarNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddVectorFromScalarNode (pImplicitFunction, pIdentifier, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_adddecomposevectornode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_DecomposeVectorNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddDecomposeVectorNode (pImplicitFunction, pIdentifier, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addcomposematrixnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_ComposeMatrixNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddComposeMatrixNode (pImplicitFunction, pIdentifier, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addmatrixfromrowsnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_MatrixFromRowsNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddMatrixFromRowsNode (pImplicitFunction, pIdentifier, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addmatrixfromcolumnsnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_MatrixFromColumnsNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddMatrixFromColumnsNode (pImplicitFunction, pIdentifier, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addconstantnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_ConstantNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddConstantNode (pImplicitFunction, pIdentifier, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addconstvecnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_ConstVecNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddConstVecNode (pImplicitFunction, pIdentifier, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addconstmatnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_ConstMatNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddConstMatNode (pImplicitFunction, pIdentifier, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addmeshnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_MeshNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddMeshNode (pImplicitFunction, pIdentifier, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addunsignedmeshnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_UnsignedMeshNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddUnsignedMeshNode (pImplicitFunction, pIdentifier, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addbeamlatticenode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_BeamLatticeNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddBeamLatticeNode (pImplicitFunction, pIdentifier, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addfunctiongradientnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_FunctionGradientNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddFunctionGradientNode (pImplicitFunction, pIdentifier, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addnormalizedistancenode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_NormalizeDistanceNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddNormalizeDistanceNode (pImplicitFunction, pIdentifier, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addfunctioncallnode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pIdentifier, const char * pDisplayName, const char * pTag, Lib3MF_FunctionCallNode * pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddFunctionCallNode (pImplicitFunction, pIdentifier, pDisplayName, pTag, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_getnodes(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, Lib3MF_NodeIterator * pIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_GetNodes (pImplicitFunction, pIterator);
}


Lib3MFResult CCall_lib3mf_implicitfunction_removenode(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, Lib3MF_ImplicitNode pNode)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_RemoveNode (pImplicitFunction, pNode);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addlink(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, Lib3MF_ImplicitPort pSource, Lib3MF_ImplicitPort pTarget)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddLink (pImplicitFunction, pSource, pTarget);
}


Lib3MFResult CCall_lib3mf_implicitfunction_addlinkbynames(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction, const char * pSource, const char * pTarget)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_AddLinkByNames (pImplicitFunction, pSource, pTarget);
}


Lib3MFResult CCall_lib3mf_implicitfunction_clear(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_Clear (pImplicitFunction);
}


Lib3MFResult CCall_lib3mf_implicitfunction_sortnodestopologically(Lib3MFHandle libraryHandle, Lib3MF_ImplicitFunction pImplicitFunction)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ImplicitFunction_SortNodesTopologically (pImplicitFunction);
}


Lib3MFResult CCall_lib3mf_functionfromimage3d_getimage3d(Lib3MFHandle libraryHandle, Lib3MF_FunctionFromImage3D pFunctionFromImage3D, Lib3MF_Image3D * pImage3D)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_FunctionFromImage3D_GetImage3D (pFunctionFromImage3D, pImage3D);
}


Lib3MFResult CCall_lib3mf_functionfromimage3d_setimage3d(Lib3MFHandle libraryHandle, Lib3MF_FunctionFromImage3D pFunctionFromImage3D, Lib3MF_Image3D pImage3D)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_FunctionFromImage3D_SetImage3D (pFunctionFromImage3D, pImage3D);
}


Lib3MFResult CCall_lib3mf_functionfromimage3d_setfilter(Lib3MFHandle libraryHandle, Lib3MF_FunctionFromImage3D pFunctionFromImage3D, eLib3MFTextureFilter eFilter)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_FunctionFromImage3D_SetFilter (pFunctionFromImage3D, eFilter);
}


Lib3MFResult CCall_lib3mf_functionfromimage3d_getfilter(Lib3MFHandle libraryHandle, Lib3MF_FunctionFromImage3D pFunctionFromImage3D, eLib3MFTextureFilter * pFilter)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_FunctionFromImage3D_GetFilter (pFunctionFromImage3D, pFilter);
}


Lib3MFResult CCall_lib3mf_functionfromimage3d_settilestyles(Lib3MFHandle libraryHandle, Lib3MF_FunctionFromImage3D pFunctionFromImage3D, eLib3MFTextureTileStyle eTileStyleU, eLib3MFTextureTileStyle eTileStyleV, eLib3MFTextureTileStyle eTileStyleW)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_FunctionFromImage3D_SetTileStyles (pFunctionFromImage3D, eTileStyleU, eTileStyleV, eTileStyleW);
}


Lib3MFResult CCall_lib3mf_functionfromimage3d_gettilestyles(Lib3MFHandle libraryHandle, Lib3MF_FunctionFromImage3D pFunctionFromImage3D, eLib3MFTextureTileStyle * pTileStyleU, eLib3MFTextureTileStyle * pTileStyleV, eLib3MFTextureTileStyle * pTileStyleW)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_FunctionFromImage3D_GetTileStyles (pFunctionFromImage3D, pTileStyleU, pTileStyleV, pTileStyleW);
}


Lib3MFResult CCall_lib3mf_functionfromimage3d_getoffset(Lib3MFHandle libraryHandle, Lib3MF_FunctionFromImage3D pFunctionFromImage3D, Lib3MF_double * pOffset)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_FunctionFromImage3D_GetOffset (pFunctionFromImage3D, pOffset);
}


Lib3MFResult CCall_lib3mf_functionfromimage3d_setoffset(Lib3MFHandle libraryHandle, Lib3MF_FunctionFromImage3D pFunctionFromImage3D, Lib3MF_double dOffset)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_FunctionFromImage3D_SetOffset (pFunctionFromImage3D, dOffset);
}


Lib3MFResult CCall_lib3mf_functionfromimage3d_getscale(Lib3MFHandle libraryHandle, Lib3MF_FunctionFromImage3D pFunctionFromImage3D, Lib3MF_double * pScale)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_FunctionFromImage3D_GetScale (pFunctionFromImage3D, pScale);
}


Lib3MFResult CCall_lib3mf_functionfromimage3d_setscale(Lib3MFHandle libraryHandle, Lib3MF_FunctionFromImage3D pFunctionFromImage3D, Lib3MF_double dScale)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_FunctionFromImage3D_SetScale (pFunctionFromImage3D, dScale);
}


Lib3MFResult CCall_lib3mf_builditem_getobjectresource(Lib3MFHandle libraryHandle, Lib3MF_BuildItem pBuildItem, Lib3MF_Object * pObjectResource)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BuildItem_GetObjectResource (pBuildItem, pObjectResource);
}


Lib3MFResult CCall_lib3mf_builditem_getuuid(Lib3MFHandle libraryHandle, Lib3MF_BuildItem pBuildItem, bool * pHasUUID, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BuildItem_GetUUID (pBuildItem, pHasUUID, nUUIDBufferSize, pUUIDNeededChars, pUUIDBuffer);
}


Lib3MFResult CCall_lib3mf_builditem_setuuid(Lib3MFHandle libraryHandle, Lib3MF_BuildItem pBuildItem, const char * pUUID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BuildItem_SetUUID (pBuildItem, pUUID);
}


Lib3MFResult CCall_lib3mf_builditem_getobjectresourceid(Lib3MFHandle libraryHandle, Lib3MF_BuildItem pBuildItem, Lib3MF_uint32 * pUniqueResourceID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BuildItem_GetObjectResourceID (pBuildItem, pUniqueResourceID);
}


Lib3MFResult CCall_lib3mf_builditem_hasobjecttransform(Lib3MFHandle libraryHandle, Lib3MF_BuildItem pBuildItem, bool * pHasTransform)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BuildItem_HasObjectTransform (pBuildItem, pHasTransform);
}


Lib3MFResult CCall_lib3mf_builditem_getobjecttransform(Lib3MFHandle libraryHandle, Lib3MF_BuildItem pBuildItem, sLib3MFTransform * pTransform)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BuildItem_GetObjectTransform (pBuildItem, pTransform);
}


Lib3MFResult CCall_lib3mf_builditem_setobjecttransform(Lib3MFHandle libraryHandle, Lib3MF_BuildItem pBuildItem, const sLib3MFTransform * pTransform)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BuildItem_SetObjectTransform (pBuildItem, pTransform);
}


Lib3MFResult CCall_lib3mf_builditem_getpartnumber(Lib3MFHandle libraryHandle, Lib3MF_BuildItem pBuildItem, const Lib3MF_uint32 nPartNumberBufferSize, Lib3MF_uint32* pPartNumberNeededChars, char * pPartNumberBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BuildItem_GetPartNumber (pBuildItem, nPartNumberBufferSize, pPartNumberNeededChars, pPartNumberBuffer);
}


Lib3MFResult CCall_lib3mf_builditem_setpartnumber(Lib3MFHandle libraryHandle, Lib3MF_BuildItem pBuildItem, const char * pSetPartnumber)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BuildItem_SetPartNumber (pBuildItem, pSetPartnumber);
}


Lib3MFResult CCall_lib3mf_builditem_getmetadatagroup(Lib3MFHandle libraryHandle, Lib3MF_BuildItem pBuildItem, Lib3MF_MetaDataGroup * pMetaDataGroup)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BuildItem_GetMetaDataGroup (pBuildItem, pMetaDataGroup);
}


Lib3MFResult CCall_lib3mf_builditem_getoutbox(Lib3MFHandle libraryHandle, Lib3MF_BuildItem pBuildItem, sLib3MFBox * pOutbox)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BuildItem_GetOutbox (pBuildItem, pOutbox);
}


Lib3MFResult CCall_lib3mf_builditemiterator_movenext(Lib3MFHandle libraryHandle, Lib3MF_BuildItemIterator pBuildItemIterator, bool * pHasNext)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BuildItemIterator_MoveNext (pBuildItemIterator, pHasNext);
}


Lib3MFResult CCall_lib3mf_builditemiterator_moveprevious(Lib3MFHandle libraryHandle, Lib3MF_BuildItemIterator pBuildItemIterator, bool * pHasPrevious)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BuildItemIterator_MovePrevious (pBuildItemIterator, pHasPrevious);
}


Lib3MFResult CCall_lib3mf_builditemiterator_getcurrent(Lib3MFHandle libraryHandle, Lib3MF_BuildItemIterator pBuildItemIterator, Lib3MF_BuildItem * pBuildItem)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BuildItemIterator_GetCurrent (pBuildItemIterator, pBuildItem);
}


Lib3MFResult CCall_lib3mf_builditemiterator_clone(Lib3MFHandle libraryHandle, Lib3MF_BuildItemIterator pBuildItemIterator, Lib3MF_BuildItemIterator * pOutBuildItemIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BuildItemIterator_Clone (pBuildItemIterator, pOutBuildItemIterator);
}


Lib3MFResult CCall_lib3mf_builditemiterator_count(Lib3MFHandle libraryHandle, Lib3MF_BuildItemIterator pBuildItemIterator, Lib3MF_uint64 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_BuildItemIterator_Count (pBuildItemIterator, pCount);
}


Lib3MFResult CCall_lib3mf_slice_setvertices(Lib3MFHandle libraryHandle, Lib3MF_Slice pSlice, Lib3MF_uint64 nVerticesBufferSize, const sLib3MFPosition2D * pVerticesBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Slice_SetVertices (pSlice, nVerticesBufferSize, pVerticesBuffer);
}


Lib3MFResult CCall_lib3mf_slice_getvertices(Lib3MFHandle libraryHandle, Lib3MF_Slice pSlice, const Lib3MF_uint64 nVerticesBufferSize, Lib3MF_uint64* pVerticesNeededCount, sLib3MFPosition2D * pVerticesBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Slice_GetVertices (pSlice, nVerticesBufferSize, pVerticesNeededCount, pVerticesBuffer);
}


Lib3MFResult CCall_lib3mf_slice_getvertexcount(Lib3MFHandle libraryHandle, Lib3MF_Slice pSlice, Lib3MF_uint64 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Slice_GetVertexCount (pSlice, pCount);
}


Lib3MFResult CCall_lib3mf_slice_addpolygon(Lib3MFHandle libraryHandle, Lib3MF_Slice pSlice, Lib3MF_uint64 nIndicesBufferSize, const Lib3MF_uint32 * pIndicesBuffer, Lib3MF_uint64 * pIndex)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Slice_AddPolygon (pSlice, nIndicesBufferSize, pIndicesBuffer, pIndex);
}


Lib3MFResult CCall_lib3mf_slice_getpolygoncount(Lib3MFHandle libraryHandle, Lib3MF_Slice pSlice, Lib3MF_uint64 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Slice_GetPolygonCount (pSlice, pCount);
}


Lib3MFResult CCall_lib3mf_slice_setpolygonindices(Lib3MFHandle libraryHandle, Lib3MF_Slice pSlice, Lib3MF_uint64 nIndex, Lib3MF_uint64 nIndicesBufferSize, const Lib3MF_uint32 * pIndicesBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Slice_SetPolygonIndices (pSlice, nIndex, nIndicesBufferSize, pIndicesBuffer);
}


Lib3MFResult CCall_lib3mf_slice_getpolygonindices(Lib3MFHandle libraryHandle, Lib3MF_Slice pSlice, Lib3MF_uint64 nIndex, const Lib3MF_uint64 nIndicesBufferSize, Lib3MF_uint64* pIndicesNeededCount, Lib3MF_uint32 * pIndicesBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Slice_GetPolygonIndices (pSlice, nIndex, nIndicesBufferSize, pIndicesNeededCount, pIndicesBuffer);
}


Lib3MFResult CCall_lib3mf_slice_getpolygonindexcount(Lib3MFHandle libraryHandle, Lib3MF_Slice pSlice, Lib3MF_uint64 nIndex, Lib3MF_uint64 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Slice_GetPolygonIndexCount (pSlice, nIndex, pCount);
}


Lib3MFResult CCall_lib3mf_slice_getztop(Lib3MFHandle libraryHandle, Lib3MF_Slice pSlice, Lib3MF_double * pZTop)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Slice_GetZTop (pSlice, pZTop);
}


Lib3MFResult CCall_lib3mf_slicestack_getbottomz(Lib3MFHandle libraryHandle, Lib3MF_SliceStack pSliceStack, Lib3MF_double * pZBottom)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_SliceStack_GetBottomZ (pSliceStack, pZBottom);
}


Lib3MFResult CCall_lib3mf_slicestack_getslicecount(Lib3MFHandle libraryHandle, Lib3MF_SliceStack pSliceStack, Lib3MF_uint64 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_SliceStack_GetSliceCount (pSliceStack, pCount);
}


Lib3MFResult CCall_lib3mf_slicestack_getslice(Lib3MFHandle libraryHandle, Lib3MF_SliceStack pSliceStack, Lib3MF_uint64 nSliceIndex, Lib3MF_Slice * pTheSlice)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_SliceStack_GetSlice (pSliceStack, nSliceIndex, pTheSlice);
}


Lib3MFResult CCall_lib3mf_slicestack_addslice(Lib3MFHandle libraryHandle, Lib3MF_SliceStack pSliceStack, Lib3MF_double dZTop, Lib3MF_Slice * pTheSlice)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_SliceStack_AddSlice (pSliceStack, dZTop, pTheSlice);
}


Lib3MFResult CCall_lib3mf_slicestack_getslicerefcount(Lib3MFHandle libraryHandle, Lib3MF_SliceStack pSliceStack, Lib3MF_uint64 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_SliceStack_GetSliceRefCount (pSliceStack, pCount);
}


Lib3MFResult CCall_lib3mf_slicestack_addslicestackreference(Lib3MFHandle libraryHandle, Lib3MF_SliceStack pSliceStack, Lib3MF_SliceStack pTheSliceStack)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_SliceStack_AddSliceStackReference (pSliceStack, pTheSliceStack);
}


Lib3MFResult CCall_lib3mf_slicestack_getslicestackreference(Lib3MFHandle libraryHandle, Lib3MF_SliceStack pSliceStack, Lib3MF_uint64 nSliceRefIndex, Lib3MF_SliceStack * pTheSliceStack)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_SliceStack_GetSliceStackReference (pSliceStack, nSliceRefIndex, pTheSliceStack);
}


Lib3MFResult CCall_lib3mf_slicestack_collapseslicereferences(Lib3MFHandle libraryHandle, Lib3MF_SliceStack pSliceStack)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_SliceStack_CollapseSliceReferences (pSliceStack);
}


Lib3MFResult CCall_lib3mf_slicestack_setownpath(Lib3MFHandle libraryHandle, Lib3MF_SliceStack pSliceStack, const char * pPath)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_SliceStack_SetOwnPath (pSliceStack, pPath);
}


Lib3MFResult CCall_lib3mf_slicestack_getownpath(Lib3MFHandle libraryHandle, Lib3MF_SliceStack pSliceStack, const Lib3MF_uint32 nPathBufferSize, Lib3MF_uint32* pPathNeededChars, char * pPathBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_SliceStack_GetOwnPath (pSliceStack, nPathBufferSize, pPathNeededChars, pPathBuffer);
}


Lib3MFResult CCall_lib3mf_consumer_getconsumerid(Lib3MFHandle libraryHandle, Lib3MF_Consumer pConsumer, const Lib3MF_uint32 nConsumerIDBufferSize, Lib3MF_uint32* pConsumerIDNeededChars, char * pConsumerIDBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Consumer_GetConsumerID (pConsumer, nConsumerIDBufferSize, pConsumerIDNeededChars, pConsumerIDBuffer);
}


Lib3MFResult CCall_lib3mf_consumer_getkeyid(Lib3MFHandle libraryHandle, Lib3MF_Consumer pConsumer, const Lib3MF_uint32 nKeyIDBufferSize, Lib3MF_uint32* pKeyIDNeededChars, char * pKeyIDBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Consumer_GetKeyID (pConsumer, nKeyIDBufferSize, pKeyIDNeededChars, pKeyIDBuffer);
}


Lib3MFResult CCall_lib3mf_consumer_getkeyvalue(Lib3MFHandle libraryHandle, Lib3MF_Consumer pConsumer, const Lib3MF_uint32 nKeyValueBufferSize, Lib3MF_uint32* pKeyValueNeededChars, char * pKeyValueBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Consumer_GetKeyValue (pConsumer, nKeyValueBufferSize, pKeyValueNeededChars, pKeyValueBuffer);
}


Lib3MFResult CCall_lib3mf_accessright_getconsumer(Lib3MFHandle libraryHandle, Lib3MF_AccessRight pAccessRight, Lib3MF_Consumer * pConsumer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_AccessRight_GetConsumer (pAccessRight, pConsumer);
}


Lib3MFResult CCall_lib3mf_accessright_getwrappingalgorithm(Lib3MFHandle libraryHandle, Lib3MF_AccessRight pAccessRight, eLib3MFWrappingAlgorithm * pAlgorithm)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_AccessRight_GetWrappingAlgorithm (pAccessRight, pAlgorithm);
}


Lib3MFResult CCall_lib3mf_accessright_getmgfalgorithm(Lib3MFHandle libraryHandle, Lib3MF_AccessRight pAccessRight, eLib3MFMgfAlgorithm * pAlgorithm)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_AccessRight_GetMgfAlgorithm (pAccessRight, pAlgorithm);
}


Lib3MFResult CCall_lib3mf_accessright_getdigestmethod(Lib3MFHandle libraryHandle, Lib3MF_AccessRight pAccessRight, eLib3MFDigestMethod * pAlgorithm)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_AccessRight_GetDigestMethod (pAccessRight, pAlgorithm);
}


Lib3MFResult CCall_lib3mf_contentencryptionparams_getencryptionalgorithm(Lib3MFHandle libraryHandle, Lib3MF_ContentEncryptionParams pContentEncryptionParams, eLib3MFEncryptionAlgorithm * pAlgorithm)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ContentEncryptionParams_GetEncryptionAlgorithm (pContentEncryptionParams, pAlgorithm);
}


Lib3MFResult CCall_lib3mf_contentencryptionparams_getkey(Lib3MFHandle libraryHandle, Lib3MF_ContentEncryptionParams pContentEncryptionParams, const Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ContentEncryptionParams_GetKey (pContentEncryptionParams, nByteDataBufferSize, pByteDataNeededCount, pByteDataBuffer);
}


Lib3MFResult CCall_lib3mf_contentencryptionparams_getinitializationvector(Lib3MFHandle libraryHandle, Lib3MF_ContentEncryptionParams pContentEncryptionParams, const Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ContentEncryptionParams_GetInitializationVector (pContentEncryptionParams, nByteDataBufferSize, pByteDataNeededCount, pByteDataBuffer);
}


Lib3MFResult CCall_lib3mf_contentencryptionparams_getauthenticationtag(Lib3MFHandle libraryHandle, Lib3MF_ContentEncryptionParams pContentEncryptionParams, const Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ContentEncryptionParams_GetAuthenticationTag (pContentEncryptionParams, nByteDataBufferSize, pByteDataNeededCount, pByteDataBuffer);
}


Lib3MFResult CCall_lib3mf_contentencryptionparams_setauthenticationtag(Lib3MFHandle libraryHandle, Lib3MF_ContentEncryptionParams pContentEncryptionParams, Lib3MF_uint64 nByteDataBufferSize, const Lib3MF_uint8 * pByteDataBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ContentEncryptionParams_SetAuthenticationTag (pContentEncryptionParams, nByteDataBufferSize, pByteDataBuffer);
}


Lib3MFResult CCall_lib3mf_contentencryptionparams_getadditionalauthenticationdata(Lib3MFHandle libraryHandle, Lib3MF_ContentEncryptionParams pContentEncryptionParams, const Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ContentEncryptionParams_GetAdditionalAuthenticationData (pContentEncryptionParams, nByteDataBufferSize, pByteDataNeededCount, pByteDataBuffer);
}


Lib3MFResult CCall_lib3mf_contentencryptionparams_getdescriptor(Lib3MFHandle libraryHandle, Lib3MF_ContentEncryptionParams pContentEncryptionParams, Lib3MF_uint64 * pDescriptor)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ContentEncryptionParams_GetDescriptor (pContentEncryptionParams, pDescriptor);
}


Lib3MFResult CCall_lib3mf_contentencryptionparams_getkeyuuid(Lib3MFHandle libraryHandle, Lib3MF_ContentEncryptionParams pContentEncryptionParams, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ContentEncryptionParams_GetKeyUUID (pContentEncryptionParams, nUUIDBufferSize, pUUIDNeededChars, pUUIDBuffer);
}


Lib3MFResult CCall_lib3mf_resourcedata_getpath(Lib3MFHandle libraryHandle, Lib3MF_ResourceData pResourceData, Lib3MF_PackagePart * pPath)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ResourceData_GetPath (pResourceData, pPath);
}


Lib3MFResult CCall_lib3mf_resourcedata_getencryptionalgorithm(Lib3MFHandle libraryHandle, Lib3MF_ResourceData pResourceData, eLib3MFEncryptionAlgorithm * pEncryptionAlgorithm)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ResourceData_GetEncryptionAlgorithm (pResourceData, pEncryptionAlgorithm);
}


Lib3MFResult CCall_lib3mf_resourcedata_getcompression(Lib3MFHandle libraryHandle, Lib3MF_ResourceData pResourceData, eLib3MFCompression * pCompression)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ResourceData_GetCompression (pResourceData, pCompression);
}


Lib3MFResult CCall_lib3mf_resourcedata_getadditionalauthenticationdata(Lib3MFHandle libraryHandle, Lib3MF_ResourceData pResourceData, const Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ResourceData_GetAdditionalAuthenticationData (pResourceData, nByteDataBufferSize, pByteDataNeededCount, pByteDataBuffer);
}


Lib3MFResult CCall_lib3mf_resourcedatagroup_getkeyuuid(Lib3MFHandle libraryHandle, Lib3MF_ResourceDataGroup pResourceDataGroup, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ResourceDataGroup_GetKeyUUID (pResourceDataGroup, nUUIDBufferSize, pUUIDNeededChars, pUUIDBuffer);
}


Lib3MFResult CCall_lib3mf_resourcedatagroup_addaccessright(Lib3MFHandle libraryHandle, Lib3MF_ResourceDataGroup pResourceDataGroup, Lib3MF_Consumer pConsumer, eLib3MFWrappingAlgorithm eWrappingAlgorithm, eLib3MFMgfAlgorithm eMgfAlgorithm, eLib3MFDigestMethod eDigestMethod, Lib3MF_AccessRight * pTheAccessRight)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ResourceDataGroup_AddAccessRight (pResourceDataGroup, pConsumer, eWrappingAlgorithm, eMgfAlgorithm, eDigestMethod, pTheAccessRight);
}


Lib3MFResult CCall_lib3mf_resourcedatagroup_findaccessrightbyconsumer(Lib3MFHandle libraryHandle, Lib3MF_ResourceDataGroup pResourceDataGroup, Lib3MF_Consumer pConsumer, Lib3MF_AccessRight * pTheAccessRight)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ResourceDataGroup_FindAccessRightByConsumer (pResourceDataGroup, pConsumer, pTheAccessRight);
}


Lib3MFResult CCall_lib3mf_resourcedatagroup_removeaccessright(Lib3MFHandle libraryHandle, Lib3MF_ResourceDataGroup pResourceDataGroup, Lib3MF_Consumer pConsumer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ResourceDataGroup_RemoveAccessRight (pResourceDataGroup, pConsumer);
}


Lib3MFResult CCall_lib3mf_keystore_addconsumer(Lib3MFHandle libraryHandle, Lib3MF_KeyStore pKeyStore, const char * pConsumerID, const char * pKeyID, const char * pKeyValue, Lib3MF_Consumer * pConsumer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_KeyStore_AddConsumer (pKeyStore, pConsumerID, pKeyID, pKeyValue, pConsumer);
}


Lib3MFResult CCall_lib3mf_keystore_getconsumercount(Lib3MFHandle libraryHandle, Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_KeyStore_GetConsumerCount (pKeyStore, pCount);
}


Lib3MFResult CCall_lib3mf_keystore_getconsumer(Lib3MFHandle libraryHandle, Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 nConsumerIndex, Lib3MF_Consumer * pConsumer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_KeyStore_GetConsumer (pKeyStore, nConsumerIndex, pConsumer);
}


Lib3MFResult CCall_lib3mf_keystore_removeconsumer(Lib3MFHandle libraryHandle, Lib3MF_KeyStore pKeyStore, Lib3MF_Consumer pConsumer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_KeyStore_RemoveConsumer (pKeyStore, pConsumer);
}


Lib3MFResult CCall_lib3mf_keystore_findconsumer(Lib3MFHandle libraryHandle, Lib3MF_KeyStore pKeyStore, const char * pConsumerID, Lib3MF_Consumer * pConsumer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_KeyStore_FindConsumer (pKeyStore, pConsumerID, pConsumer);
}


Lib3MFResult CCall_lib3mf_keystore_getresourcedatagroupcount(Lib3MFHandle libraryHandle, Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_KeyStore_GetResourceDataGroupCount (pKeyStore, pCount);
}


Lib3MFResult CCall_lib3mf_keystore_addresourcedatagroup(Lib3MFHandle libraryHandle, Lib3MF_KeyStore pKeyStore, Lib3MF_ResourceDataGroup * pResourceDataGroup)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_KeyStore_AddResourceDataGroup (pKeyStore, pResourceDataGroup);
}


Lib3MFResult CCall_lib3mf_keystore_getresourcedatagroup(Lib3MFHandle libraryHandle, Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 nResourceDataIndex, Lib3MF_ResourceDataGroup * pResourceDataGroup)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_KeyStore_GetResourceDataGroup (pKeyStore, nResourceDataIndex, pResourceDataGroup);
}


Lib3MFResult CCall_lib3mf_keystore_removeresourcedatagroup(Lib3MFHandle libraryHandle, Lib3MF_KeyStore pKeyStore, Lib3MF_ResourceDataGroup pResourceDataGroup)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_KeyStore_RemoveResourceDataGroup (pKeyStore, pResourceDataGroup);
}


Lib3MFResult CCall_lib3mf_keystore_findresourcedatagroup(Lib3MFHandle libraryHandle, Lib3MF_KeyStore pKeyStore, Lib3MF_PackagePart pPartPath, Lib3MF_ResourceDataGroup * pResourceDataGroup)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_KeyStore_FindResourceDataGroup (pKeyStore, pPartPath, pResourceDataGroup);
}


Lib3MFResult CCall_lib3mf_keystore_addresourcedata(Lib3MFHandle libraryHandle, Lib3MF_KeyStore pKeyStore, Lib3MF_ResourceDataGroup pResourceDataGroup, Lib3MF_PackagePart pPartPath, eLib3MFEncryptionAlgorithm eAlgorithm, eLib3MFCompression eCompression, Lib3MF_uint64 nAdditionalAuthenticationDataBufferSize, const Lib3MF_uint8 * pAdditionalAuthenticationDataBuffer, Lib3MF_ResourceData * pResourceData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_KeyStore_AddResourceData (pKeyStore, pResourceDataGroup, pPartPath, eAlgorithm, eCompression, nAdditionalAuthenticationDataBufferSize, pAdditionalAuthenticationDataBuffer, pResourceData);
}


Lib3MFResult CCall_lib3mf_keystore_removeresourcedata(Lib3MFHandle libraryHandle, Lib3MF_KeyStore pKeyStore, Lib3MF_ResourceData pResourceData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_KeyStore_RemoveResourceData (pKeyStore, pResourceData);
}


Lib3MFResult CCall_lib3mf_keystore_findresourcedata(Lib3MFHandle libraryHandle, Lib3MF_KeyStore pKeyStore, Lib3MF_PackagePart pResourcePath, Lib3MF_ResourceData * pResourceData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_KeyStore_FindResourceData (pKeyStore, pResourcePath, pResourceData);
}


Lib3MFResult CCall_lib3mf_keystore_getresourcedatacount(Lib3MFHandle libraryHandle, Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 * pCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_KeyStore_GetResourceDataCount (pKeyStore, pCount);
}


Lib3MFResult CCall_lib3mf_keystore_getresourcedata(Lib3MFHandle libraryHandle, Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 nResourceDataIndex, Lib3MF_ResourceData * pResourceData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_KeyStore_GetResourceData (pKeyStore, nResourceDataIndex, pResourceData);
}


Lib3MFResult CCall_lib3mf_keystore_getuuid(Lib3MFHandle libraryHandle, Lib3MF_KeyStore pKeyStore, bool * pHasUUID, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_KeyStore_GetUUID (pKeyStore, pHasUUID, nUUIDBufferSize, pUUIDNeededChars, pUUIDBuffer);
}


Lib3MFResult CCall_lib3mf_keystore_setuuid(Lib3MFHandle libraryHandle, Lib3MF_KeyStore pKeyStore, const char * pUUID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_KeyStore_SetUUID (pKeyStore, pUUID);
}


Lib3MFResult CCall_lib3mf_model_rootmodelpart(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_PackagePart * pRootModelPart)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_RootModelPart (pModel, pRootModelPart);
}


Lib3MFResult CCall_lib3mf_model_findorcreatepackagepart(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, const char * pAbsolutePath, Lib3MF_PackagePart * pModelPart)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_FindOrCreatePackagePart (pModel, pAbsolutePath, pModelPart);
}


Lib3MFResult CCall_lib3mf_model_setunit(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, eLib3MFModelUnit eUnit)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_SetUnit (pModel, eUnit);
}


Lib3MFResult CCall_lib3mf_model_getunit(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, eLib3MFModelUnit * pUnit)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetUnit (pModel, pUnit);
}


Lib3MFResult CCall_lib3mf_model_getlanguage(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, const Lib3MF_uint32 nLanguageBufferSize, Lib3MF_uint32* pLanguageNeededChars, char * pLanguageBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetLanguage (pModel, nLanguageBufferSize, pLanguageNeededChars, pLanguageBuffer);
}


Lib3MFResult CCall_lib3mf_model_setlanguage(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, const char * pLanguage)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_SetLanguage (pModel, pLanguage);
}


Lib3MFResult CCall_lib3mf_model_querywriter(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, const char * pWriterClass, Lib3MF_Writer * pWriterInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_QueryWriter (pModel, pWriterClass, pWriterInstance);
}


Lib3MFResult CCall_lib3mf_model_queryreader(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, const char * pReaderClass, Lib3MF_Reader * pReaderInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_QueryReader (pModel, pReaderClass, pReaderInstance);
}


Lib3MFResult CCall_lib3mf_model_getresourcebyid(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_Resource * pResource)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetResourceByID (pModel, nUniqueResourceID, pResource);
}


Lib3MFResult CCall_lib3mf_model_gettexture2dbyid(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_Texture2D * pTextureInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetTexture2DByID (pModel, nUniqueResourceID, pTextureInstance);
}


Lib3MFResult CCall_lib3mf_model_getpropertytypebyid(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, eLib3MFPropertyType * pThePropertyType)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetPropertyTypeByID (pModel, nUniqueResourceID, pThePropertyType);
}


Lib3MFResult CCall_lib3mf_model_getbasematerialgroupbyid(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_BaseMaterialGroup * pBaseMaterialGroupInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetBaseMaterialGroupByID (pModel, nUniqueResourceID, pBaseMaterialGroupInstance);
}


Lib3MFResult CCall_lib3mf_model_gettexture2dgroupbyid(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_Texture2DGroup * pTexture2DGroupInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetTexture2DGroupByID (pModel, nUniqueResourceID, pTexture2DGroupInstance);
}


Lib3MFResult CCall_lib3mf_model_getcompositematerialsbyid(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_CompositeMaterials * pCompositeMaterialsInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetCompositeMaterialsByID (pModel, nUniqueResourceID, pCompositeMaterialsInstance);
}


Lib3MFResult CCall_lib3mf_model_getmultipropertygroupbyid(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_MultiPropertyGroup * pMultiPropertyGroupInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetMultiPropertyGroupByID (pModel, nUniqueResourceID, pMultiPropertyGroupInstance);
}


Lib3MFResult CCall_lib3mf_model_getmeshobjectbyid(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_MeshObject * pMeshObjectInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetMeshObjectByID (pModel, nUniqueResourceID, pMeshObjectInstance);
}


Lib3MFResult CCall_lib3mf_model_getcomponentsobjectbyid(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_ComponentsObject * pComponentsObjectInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetComponentsObjectByID (pModel, nUniqueResourceID, pComponentsObjectInstance);
}


Lib3MFResult CCall_lib3mf_model_getcolorgroupbyid(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_ColorGroup * pColorGroupInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetColorGroupByID (pModel, nUniqueResourceID, pColorGroupInstance);
}


Lib3MFResult CCall_lib3mf_model_getslicestackbyid(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_SliceStack * pSliceStacInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetSliceStackByID (pModel, nUniqueResourceID, pSliceStacInstance);
}


Lib3MFResult CCall_lib3mf_model_getlevelsetbyid(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_LevelSet * pLevelSetObjectInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetLevelSetByID (pModel, nUniqueResourceID, pLevelSetObjectInstance);
}


Lib3MFResult CCall_lib3mf_model_getbuilduuid(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, bool * pHasUUID, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetBuildUUID (pModel, pHasUUID, nUUIDBufferSize, pUUIDNeededChars, pUUIDBuffer);
}


Lib3MFResult CCall_lib3mf_model_setbuilduuid(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, const char * pUUID)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_SetBuildUUID (pModel, pUUID);
}


Lib3MFResult CCall_lib3mf_model_getbuilditems(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_BuildItemIterator * pBuildItemIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetBuildItems (pModel, pBuildItemIterator);
}


Lib3MFResult CCall_lib3mf_model_getoutbox(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, sLib3MFBox * pOutbox)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetOutbox (pModel, pOutbox);
}


Lib3MFResult CCall_lib3mf_model_getresources(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_ResourceIterator * pResourceIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetResources (pModel, pResourceIterator);
}


Lib3MFResult CCall_lib3mf_model_getobjects(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_ObjectIterator * pResourceIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetObjects (pModel, pResourceIterator);
}


Lib3MFResult CCall_lib3mf_model_getmeshobjects(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_MeshObjectIterator * pResourceIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetMeshObjects (pModel, pResourceIterator);
}


Lib3MFResult CCall_lib3mf_model_getcomponentsobjects(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_ComponentsObjectIterator * pResourceIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetComponentsObjects (pModel, pResourceIterator);
}


Lib3MFResult CCall_lib3mf_model_gettexture2ds(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_Texture2DIterator * pResourceIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetTexture2Ds (pModel, pResourceIterator);
}


Lib3MFResult CCall_lib3mf_model_getbasematerialgroups(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_BaseMaterialGroupIterator * pResourceIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetBaseMaterialGroups (pModel, pResourceIterator);
}


Lib3MFResult CCall_lib3mf_model_getcolorgroups(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_ColorGroupIterator * pResourceIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetColorGroups (pModel, pResourceIterator);
}


Lib3MFResult CCall_lib3mf_model_gettexture2dgroups(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_Texture2DGroupIterator * pResourceIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetTexture2DGroups (pModel, pResourceIterator);
}


Lib3MFResult CCall_lib3mf_model_getcompositematerials(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_CompositeMaterialsIterator * pResourceIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetCompositeMaterials (pModel, pResourceIterator);
}


Lib3MFResult CCall_lib3mf_model_getmultipropertygroups(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_MultiPropertyGroupIterator * pResourceIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetMultiPropertyGroups (pModel, pResourceIterator);
}


Lib3MFResult CCall_lib3mf_model_getslicestacks(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_SliceStackIterator * pResourceIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetSliceStacks (pModel, pResourceIterator);
}


Lib3MFResult CCall_lib3mf_model_getimage3ds(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_Image3DIterator * pResourceIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetImage3Ds (pModel, pResourceIterator);
}


Lib3MFResult CCall_lib3mf_model_mergetomodel(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_Model * pMergedModelInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_MergeToModel (pModel, pMergedModelInstance);
}


Lib3MFResult CCall_lib3mf_model_mergefrommodel(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_Model pModelInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_MergeFromModel (pModel, pModelInstance);
}


Lib3MFResult CCall_lib3mf_model_addmeshobject(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_MeshObject * pMeshObjectInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_AddMeshObject (pModel, pMeshObjectInstance);
}


Lib3MFResult CCall_lib3mf_model_addcomponentsobject(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_ComponentsObject * pComponentsObjectInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_AddComponentsObject (pModel, pComponentsObjectInstance);
}


Lib3MFResult CCall_lib3mf_model_addslicestack(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_double dZBottom, Lib3MF_SliceStack * pSliceStackInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_AddSliceStack (pModel, dZBottom, pSliceStackInstance);
}


Lib3MFResult CCall_lib3mf_model_addtexture2dfromattachment(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_Attachment pTextureAttachment, Lib3MF_Texture2D * pTexture2DInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_AddTexture2DFromAttachment (pModel, pTextureAttachment, pTexture2DInstance);
}


Lib3MFResult CCall_lib3mf_model_addbasematerialgroup(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_BaseMaterialGroup * pBaseMaterialGroupInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_AddBaseMaterialGroup (pModel, pBaseMaterialGroupInstance);
}


Lib3MFResult CCall_lib3mf_model_addcolorgroup(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_ColorGroup * pColorGroupInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_AddColorGroup (pModel, pColorGroupInstance);
}


Lib3MFResult CCall_lib3mf_model_addtexture2dgroup(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_Texture2D pTexture2DInstance, Lib3MF_Texture2DGroup * pTexture2DGroupInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_AddTexture2DGroup (pModel, pTexture2DInstance, pTexture2DGroupInstance);
}


Lib3MFResult CCall_lib3mf_model_addcompositematerials(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_BaseMaterialGroup pBaseMaterialGroupInstance, Lib3MF_CompositeMaterials * pCompositeMaterialsInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_AddCompositeMaterials (pModel, pBaseMaterialGroupInstance, pCompositeMaterialsInstance);
}


Lib3MFResult CCall_lib3mf_model_addmultipropertygroup(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_MultiPropertyGroup * pMultiPropertyGroupInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_AddMultiPropertyGroup (pModel, pMultiPropertyGroupInstance);
}


Lib3MFResult CCall_lib3mf_model_addimagestack(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_uint32 nColumnCount, Lib3MF_uint32 nRowCount, Lib3MF_uint32 nSheetCount, Lib3MF_ImageStack * pInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_AddImageStack (pModel, nColumnCount, nRowCount, nSheetCount, pInstance);
}


Lib3MFResult CCall_lib3mf_model_getimagestackbyid(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_ImageStack * pImageStackInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetImageStackByID (pModel, nUniqueResourceID, pImageStackInstance);
}


Lib3MFResult CCall_lib3mf_model_addbuilditem(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_Object pObject, const sLib3MFTransform * pTransform, Lib3MF_BuildItem * pBuildItemInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_AddBuildItem (pModel, pObject, pTransform, pBuildItemInstance);
}


Lib3MFResult CCall_lib3mf_model_removebuilditem(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_BuildItem pBuildItemInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_RemoveBuildItem (pModel, pBuildItemInstance);
}


Lib3MFResult CCall_lib3mf_model_getmetadatagroup(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_MetaDataGroup * pTheMetaDataGroup)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetMetaDataGroup (pModel, pTheMetaDataGroup);
}


Lib3MFResult CCall_lib3mf_model_addattachment(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, const char * pURI, const char * pRelationShipType, Lib3MF_Attachment * pAttachmentInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_AddAttachment (pModel, pURI, pRelationShipType, pAttachmentInstance);
}


Lib3MFResult CCall_lib3mf_model_removeattachment(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_Attachment pAttachmentInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_RemoveAttachment (pModel, pAttachmentInstance);
}


Lib3MFResult CCall_lib3mf_model_getattachment(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_uint32 nIndex, Lib3MF_Attachment * pAttachmentInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetAttachment (pModel, nIndex, pAttachmentInstance);
}


Lib3MFResult CCall_lib3mf_model_findattachment(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, const char * pURI, Lib3MF_Attachment * pAttachmentInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_FindAttachment (pModel, pURI, pAttachmentInstance);
}


Lib3MFResult CCall_lib3mf_model_getattachmentcount(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_uint32 * pAttachmentCount)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetAttachmentCount (pModel, pAttachmentCount);
}


Lib3MFResult CCall_lib3mf_model_haspackagethumbnailattachment(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, bool * pHasThumbnail)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_HasPackageThumbnailAttachment (pModel, pHasThumbnail);
}


Lib3MFResult CCall_lib3mf_model_createpackagethumbnailattachment(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_Attachment * pAttachment)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_CreatePackageThumbnailAttachment (pModel, pAttachment);
}


Lib3MFResult CCall_lib3mf_model_getpackagethumbnailattachment(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_Attachment * pAttachment)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetPackageThumbnailAttachment (pModel, pAttachment);
}


Lib3MFResult CCall_lib3mf_model_removepackagethumbnailattachment(Lib3MFHandle libraryHandle, Lib3MF_Model pModel)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_RemovePackageThumbnailAttachment (pModel);
}


Lib3MFResult CCall_lib3mf_model_addcustomcontenttype(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, const char * pExtension, const char * pContentType)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_AddCustomContentType (pModel, pExtension, pContentType);
}


Lib3MFResult CCall_lib3mf_model_removecustomcontenttype(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, const char * pExtension)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_RemoveCustomContentType (pModel, pExtension);
}


Lib3MFResult CCall_lib3mf_model_setrandomnumbercallback(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MFRandomNumberCallback pTheCallback, Lib3MF_pvoid pUserData)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_SetRandomNumberCallback (pModel, pTheCallback, pUserData);
}


Lib3MFResult CCall_lib3mf_model_getkeystore(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_KeyStore * pKeyStore)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetKeyStore (pModel, pKeyStore);
}


Lib3MFResult CCall_lib3mf_model_getfunctions(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_FunctionIterator * pTheResourceIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetFunctions (pModel, pTheResourceIterator);
}


Lib3MFResult CCall_lib3mf_model_addimplicitfunction(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_ImplicitFunction * pFunctionInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_AddImplicitFunction (pModel, pFunctionInstance);
}


Lib3MFResult CCall_lib3mf_model_addfunctionfromimage3d(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_Image3D pImage3DInstance, Lib3MF_FunctionFromImage3D * pFunctionInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_AddFunctionFromImage3D (pModel, pImage3DInstance, pFunctionInstance);
}


Lib3MFResult CCall_lib3mf_model_addvolumedata(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_VolumeData * pVolumeDataInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_AddVolumeData (pModel, pVolumeDataInstance);
}


Lib3MFResult CCall_lib3mf_model_addlevelset(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_LevelSet * pLevelSetInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_AddLevelSet (pModel, pLevelSetInstance);
}


Lib3MFResult CCall_lib3mf_model_getlevelsets(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_LevelSetIterator * pResourceIterator)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_GetLevelSets (pModel, pResourceIterator);
}


Lib3MFResult CCall_lib3mf_model_removeresource(Lib3MFHandle libraryHandle, Lib3MF_Model pModel, Lib3MF_Resource pResource)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Model_RemoveResource (pModel, pResource);
}


Lib3MFResult CCall_lib3mf_getlibraryversion(Lib3MFHandle libraryHandle, Lib3MF_uint32 * pMajor, Lib3MF_uint32 * pMinor, Lib3MF_uint32 * pMicro)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_GetLibraryVersion (pMajor, pMinor, pMicro);
}


Lib3MFResult CCall_lib3mf_getprereleaseinformation(Lib3MFHandle libraryHandle, bool * pHasPrereleaseInfo, const Lib3MF_uint32 nPrereleaseInfoBufferSize, Lib3MF_uint32* pPrereleaseInfoNeededChars, char * pPrereleaseInfoBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_GetPrereleaseInformation (pHasPrereleaseInfo, nPrereleaseInfoBufferSize, pPrereleaseInfoNeededChars, pPrereleaseInfoBuffer);
}


Lib3MFResult CCall_lib3mf_getbuildinformation(Lib3MFHandle libraryHandle, bool * pHasBuildInfo, const Lib3MF_uint32 nBuildInformationBufferSize, Lib3MF_uint32* pBuildInformationNeededChars, char * pBuildInformationBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_GetBuildInformation (pHasBuildInfo, nBuildInformationBufferSize, pBuildInformationNeededChars, pBuildInformationBuffer);
}


Lib3MFResult CCall_lib3mf_getspecificationversion(Lib3MFHandle libraryHandle, const char * pSpecificationURL, bool * pIsSupported, Lib3MF_uint32 * pMajor, Lib3MF_uint32 * pMinor, Lib3MF_uint32 * pMicro)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_GetSpecificationVersion (pSpecificationURL, pIsSupported, pMajor, pMinor, pMicro);
}


Lib3MFResult CCall_lib3mf_createmodel(Lib3MFHandle libraryHandle, Lib3MF_Model * pModel)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_CreateModel (pModel);
}


Lib3MFResult CCall_lib3mf_release(Lib3MFHandle libraryHandle, Lib3MF_Base pInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Release (pInstance);
}


Lib3MFResult CCall_lib3mf_acquire(Lib3MFHandle libraryHandle, Lib3MF_Base pInstance)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_Acquire (pInstance);
}


Lib3MFResult CCall_lib3mf_setjournal(Lib3MFHandle libraryHandle, const char * pJournalPath)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_SetJournal (pJournalPath);
}


Lib3MFResult CCall_lib3mf_getlasterror(Lib3MFHandle libraryHandle, Lib3MF_Base pInstance, const Lib3MF_uint32 nLastErrorStringBufferSize, Lib3MF_uint32* pLastErrorStringNeededChars, char * pLastErrorStringBuffer, bool * pHasLastError)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_GetLastError (pInstance, nLastErrorStringBufferSize, pLastErrorStringNeededChars, pLastErrorStringBuffer, pHasLastError);
}


Lib3MFResult CCall_lib3mf_getsymbollookupmethod(Lib3MFHandle libraryHandle, Lib3MF_pvoid * pSymbolLookupMethod)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_GetSymbolLookupMethod (pSymbolLookupMethod);
}


Lib3MFResult CCall_lib3mf_retrieveprogressmessage(Lib3MFHandle libraryHandle, eLib3MFProgressIdentifier eTheProgressIdentifier, const Lib3MF_uint32 nProgressMessageBufferSize, Lib3MF_uint32* pProgressMessageNeededChars, char * pProgressMessageBuffer)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_RetrieveProgressMessage (eTheProgressIdentifier, nProgressMessageBufferSize, pProgressMessageNeededChars, pProgressMessageBuffer);
}


Lib3MFResult CCall_lib3mf_rgbatocolor(Lib3MFHandle libraryHandle, Lib3MF_uint8 nRed, Lib3MF_uint8 nGreen, Lib3MF_uint8 nBlue, Lib3MF_uint8 nAlpha, sLib3MFColor * pTheColor)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_RGBAToColor (nRed, nGreen, nBlue, nAlpha, pTheColor);
}


Lib3MFResult CCall_lib3mf_floatrgbatocolor(Lib3MFHandle libraryHandle, Lib3MF_single fRed, Lib3MF_single fGreen, Lib3MF_single fBlue, Lib3MF_single fAlpha, sLib3MFColor * pTheColor)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_FloatRGBAToColor (fRed, fGreen, fBlue, fAlpha, pTheColor);
}


Lib3MFResult CCall_lib3mf_colortorgba(Lib3MFHandle libraryHandle, const sLib3MFColor * pTheColor, Lib3MF_uint8 * pRed, Lib3MF_uint8 * pGreen, Lib3MF_uint8 * pBlue, Lib3MF_uint8 * pAlpha)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ColorToRGBA (pTheColor, pRed, pGreen, pBlue, pAlpha);
}


Lib3MFResult CCall_lib3mf_colortofloatrgba(Lib3MFHandle libraryHandle, const sLib3MFColor * pTheColor, Lib3MF_single * pRed, Lib3MF_single * pGreen, Lib3MF_single * pBlue, Lib3MF_single * pAlpha)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_ColorToFloatRGBA (pTheColor, pRed, pGreen, pBlue, pAlpha);
}


Lib3MFResult CCall_lib3mf_getidentitytransform(Lib3MFHandle libraryHandle, sLib3MFTransform * pTransform)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_GetIdentityTransform (pTransform);
}


Lib3MFResult CCall_lib3mf_getuniformscaletransform(Lib3MFHandle libraryHandle, Lib3MF_single fFactor, sLib3MFTransform * pTransform)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_GetUniformScaleTransform (fFactor, pTransform);
}


Lib3MFResult CCall_lib3mf_getscaletransform(Lib3MFHandle libraryHandle, Lib3MF_single fFactorX, Lib3MF_single fFactorY, Lib3MF_single fFactorZ, sLib3MFTransform * pTransform)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_GetScaleTransform (fFactorX, fFactorY, fFactorZ, pTransform);
}


Lib3MFResult CCall_lib3mf_gettranslationtransform(Lib3MFHandle libraryHandle, Lib3MF_single fVectorX, Lib3MF_single fVectorY, Lib3MF_single fVectorZ, sLib3MFTransform * pTransform)
{
	if (libraryHandle == 0) 
		return LIB3MF_ERROR_INVALIDCAST;
	sLib3MFDynamicWrapperTable * wrapperTable = (sLib3MFDynamicWrapperTable *) libraryHandle;
	return wrapperTable->m_GetTranslationTransform (fVectorX, fVectorY, fVectorZ, pTransform);
}

